; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64 -mattr=+neon,+sve2 -verify-machineinstrs %s -o - | FileCheck %s

define <vscale x 4 x i32> @add_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: add_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    add z1.s, z1.s, z2.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a = add <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @add_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: add_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    add z1.h, z1.h, z2.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a = add <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @add_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: add_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    add z1.b, z1.b, z2.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a = add <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @sub_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: sub_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sub z1.s, z1.s, z2.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a = sub <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @sub_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: sub_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    sub z1.h, z1.h, z2.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a = sub <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @sub_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: sub_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    sub z1.b, z1.b, z2.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a = sub <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @mul_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: mul_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mul z1.s, z1.s, z2.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a = mul <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mul_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: mul_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mul z1.h, z1.h, z2.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a = mul <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mul_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: mul_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    mul z1.b, z1.b, z2.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a = mul <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @and_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: and_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    and z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a = and <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @and_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: and_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    and z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a = and <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @and_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: and_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    and z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a = and <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @or_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: or_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    orr z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a = or <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @or_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: or_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    orr z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a = or <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @or_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: or_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    orr z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a = or <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @xor_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: xor_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    eor z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a = xor <vscale x 4 x i32> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @xor_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: xor_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    eor z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a = xor <vscale x 8 x i16> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @xor_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: xor_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    eor z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a = xor <vscale x 16 x i8> %x, %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @andnot_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: andnot_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    bic z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %y1 = xor <vscale x 4 x i32> %y, splat (i32 -1)
  %a = and <vscale x 4 x i32> %x, %y1
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @andnot_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: andnot_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    bic z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %y1 = xor <vscale x 8 x i16> %y, splat (i16 -1)
  %a = and <vscale x 8 x i16> %x, %y1
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @andnot_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: andnot_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    bic z1.d, z1.d, z2.d
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %y1 = xor <vscale x 16 x i8> %y, splat (i8 -1)
  %a = and <vscale x 16 x i8> %x, %y1
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @ornot_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: ornot_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    bsl2n z1.d, z1.d, z2.d, z1.d
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %y1 = xor <vscale x 4 x i32> %y, splat (i32 -1)
  %a = or <vscale x 4 x i32> %x, %y1
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @ornot_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: ornot_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    bsl2n z1.d, z1.d, z2.d, z1.d
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %y1 = xor <vscale x 8 x i16> %y, splat (i16 -1)
  %a = or <vscale x 8 x i16> %x, %y1
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @ornot_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: ornot_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    bsl2n z1.d, z1.d, z2.d, z1.d
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %y1 = xor <vscale x 16 x i8> %y, splat (i8 -1)
  %a = or <vscale x 16 x i8> %x, %y1
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x float> @fadd_v4f32(<vscale x 4 x float> %z, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: fadd_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fadd z1.s, z1.s, z2.s
; CHECK-NEXT:    fcmeq p0.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 4 x float> %z, zeroinitializer
  %a = fadd <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %z
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fadd_v8f16(<vscale x 8 x half> %z, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: fadd_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fadd z1.h, z1.h, z2.h
; CHECK-NEXT:    fcmeq p0.h, p0/z, z0.h, #0.0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 8 x half> %z, zeroinitializer
  %a = fadd <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %z
  ret <vscale x 8 x half> %b
}

define <vscale x 4 x float> @fsub_v4f32(<vscale x 4 x float> %z, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: fsub_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fsub z1.s, z1.s, z2.s
; CHECK-NEXT:    fcmeq p0.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 4 x float> %z, zeroinitializer
  %a = fsub <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %z
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fsub_v8f16(<vscale x 8 x half> %z, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: fsub_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fsub z1.h, z1.h, z2.h
; CHECK-NEXT:    fcmeq p0.h, p0/z, z0.h, #0.0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 8 x half> %z, zeroinitializer
  %a = fsub <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %z
  ret <vscale x 8 x half> %b
}

define <vscale x 4 x float> @fmul_v4f32(<vscale x 4 x float> %z, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: fmul_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fmul z1.s, z1.s, z2.s
; CHECK-NEXT:    fcmeq p0.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 4 x float> %z, zeroinitializer
  %a = fmul <vscale x 4 x float> %x, %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %z
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fmul_v8f16(<vscale x 8 x half> %z, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: fmul_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fmul z1.h, z1.h, z2.h
; CHECK-NEXT:    fcmeq p0.h, p0/z, z0.h, #0.0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 8 x half> %z, zeroinitializer
  %a = fmul <vscale x 8 x half> %x, %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %z
  ret <vscale x 8 x half> %b
}

define <vscale x 4 x i32> @icmp_slt_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: icmp_slt_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; CHECK-NEXT:    smin z1.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a1 = icmp slt <vscale x 4 x i32> %x, %y
  %a = select <vscale x 4 x i1> %a1, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @icmp_slt_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: icmp_slt_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; CHECK-NEXT:    smin z1.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a1 = icmp slt <vscale x 8 x i16> %x, %y
  %a = select <vscale x 8 x i1> %a1, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @icmp_slt_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: icmp_slt_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpeq p1.b, p0/z, z0.b, #0
; CHECK-NEXT:    smin z1.b, p0/m, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p1/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a1 = icmp slt <vscale x 16 x i8> %x, %y
  %a = select <vscale x 16 x i1> %a1, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @icmp_sgt_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: icmp_sgt_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; CHECK-NEXT:    smax z1.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a1 = icmp sgt <vscale x 4 x i32> %x, %y
  %a = select <vscale x 4 x i1> %a1, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @icmp_sgt_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: icmp_sgt_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; CHECK-NEXT:    smax z1.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a1 = icmp sgt <vscale x 8 x i16> %x, %y
  %a = select <vscale x 8 x i1> %a1, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @icmp_sgt_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: icmp_sgt_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpeq p1.b, p0/z, z0.b, #0
; CHECK-NEXT:    smax z1.b, p0/m, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p1/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a1 = icmp sgt <vscale x 16 x i8> %x, %y
  %a = select <vscale x 16 x i1> %a1, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @icmp_ult_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: icmp_ult_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; CHECK-NEXT:    umin z1.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a1 = icmp ult <vscale x 4 x i32> %x, %y
  %a = select <vscale x 4 x i1> %a1, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @icmp_ult_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: icmp_ult_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; CHECK-NEXT:    umin z1.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a1 = icmp ult <vscale x 8 x i16> %x, %y
  %a = select <vscale x 8 x i1> %a1, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @icmp_ult_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: icmp_ult_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpeq p1.b, p0/z, z0.b, #0
; CHECK-NEXT:    umin z1.b, p0/m, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p1/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a1 = icmp ult <vscale x 16 x i8> %x, %y
  %a = select <vscale x 16 x i1> %a1, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @icmp_ugt_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: icmp_ugt_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpeq p1.s, p0/z, z0.s, #0
; CHECK-NEXT:    umax z1.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a1 = icmp ugt <vscale x 4 x i32> %x, %y
  %a = select <vscale x 4 x i1> %a1, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @icmp_ugt_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: icmp_ugt_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpeq p1.h, p0/z, z0.h, #0
; CHECK-NEXT:    umax z1.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a1 = icmp ugt <vscale x 8 x i16> %x, %y
  %a = select <vscale x 8 x i1> %a1, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @icmp_ugt_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: icmp_ugt_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpeq p1.b, p0/z, z0.b, #0
; CHECK-NEXT:    umax z1.b, p0/m, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p1/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a1 = icmp ugt <vscale x 16 x i8> %x, %y
  %a = select <vscale x 16 x i1> %a1, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x float> @fcmp_fast_olt_v4f32(<vscale x 4 x float> %z, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: fcmp_fast_olt_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmeq p1.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    fminnm z1.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 4 x float> %z, zeroinitializer
  %a1 = fcmp fast olt <vscale x 4 x float> %x, %y
  %a = select <vscale x 4 x i1> %a1, <vscale x 4 x float> %x, <vscale x 4 x float> %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %z
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fcmp_fast_olt_v8f16(<vscale x 8 x half> %z, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: fcmp_fast_olt_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmeq p1.h, p0/z, z0.h, #0.0
; CHECK-NEXT:    fminnm z1.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 8 x half> %z, zeroinitializer
  %a1 = fcmp fast olt <vscale x 8 x half> %x, %y
  %a = select <vscale x 8 x i1> %a1, <vscale x 8 x half> %x, <vscale x 8 x half> %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %z
  ret <vscale x 8 x half> %b
}

define <vscale x 4 x float> @fcmp_fast_ogt_v4f32(<vscale x 4 x float> %z, <vscale x 4 x float> %x, <vscale x 4 x float> %y) {
; CHECK-LABEL: fcmp_fast_ogt_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcmeq p1.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    fmaxnm z1.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p1/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 4 x float> %z, zeroinitializer
  %a1 = fcmp fast ogt <vscale x 4 x float> %x, %y
  %a = select <vscale x 4 x i1> %a1, <vscale x 4 x float> %x, <vscale x 4 x float> %y
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %z
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fcmp_fast_ogt_v8f16(<vscale x 8 x half> %z, <vscale x 8 x half> %x, <vscale x 8 x half> %y) {
; CHECK-LABEL: fcmp_fast_ogt_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fcmeq p1.h, p0/z, z0.h, #0.0
; CHECK-NEXT:    fmaxnm z1.h, p0/m, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p1/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 8 x half> %z, zeroinitializer
  %a1 = fcmp fast ogt <vscale x 8 x half> %x, %y
  %a = select <vscale x 8 x i1> %a1, <vscale x 8 x half> %x, <vscale x 8 x half> %y
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %z
  ret <vscale x 8 x half> %b
}

define <vscale x 4 x i32> @sadd_sat_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: sadd_sat_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sqadd z1.s, z1.s, z2.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a = call <vscale x 4 x i32> @llvm.sadd.sat.v4i32(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @sadd_sat_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: sadd_sat_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    sqadd z1.h, z1.h, z2.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a = call <vscale x 8 x i16> @llvm.sadd.sat.v8i16(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @sadd_sat_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: sadd_sat_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    sqadd z1.b, z1.b, z2.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a = call <vscale x 16 x i8> @llvm.sadd.sat.v16i8(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y)
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @uadd_sat_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: uadd_sat_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uqadd z1.s, z1.s, z2.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a = call <vscale x 4 x i32> @llvm.uadd.sat.v4i32(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @uadd_sat_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: uadd_sat_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    uqadd z1.h, z1.h, z2.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a = call <vscale x 8 x i16> @llvm.uadd.sat.v8i16(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @uadd_sat_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: uadd_sat_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    uqadd z1.b, z1.b, z2.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a = call <vscale x 16 x i8> @llvm.uadd.sat.v16i8(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y)
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @ssub_sat_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: ssub_sat_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sqsub z1.s, z1.s, z2.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a = call <vscale x 4 x i32> @llvm.ssub.sat.v4i32(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @ssub_sat_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: ssub_sat_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    sqsub z1.h, z1.h, z2.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a = call <vscale x 8 x i16> @llvm.ssub.sat.v8i16(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @ssub_sat_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: ssub_sat_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    sqsub z1.b, z1.b, z2.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a = call <vscale x 16 x i8> @llvm.ssub.sat.v16i8(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y)
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @usub_sat_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: usub_sat_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uqsub z1.s, z1.s, z2.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %a = call <vscale x 4 x i32> @llvm.usub.sat.v4i32(<vscale x 4 x i32> %x, <vscale x 4 x i32> %y)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @usub_sat_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: usub_sat_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    uqsub z1.h, z1.h, z2.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %a = call <vscale x 8 x i16> @llvm.usub.sat.v8i16(<vscale x 8 x i16> %x, <vscale x 8 x i16> %y)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @usub_sat_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: usub_sat_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    uqsub z1.b, z1.b, z2.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %a = call <vscale x 16 x i8> @llvm.usub.sat.v16i8(<vscale x 16 x i8> %x, <vscale x 16 x i8> %y)
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @addqr_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, i32 %y) {
; CHECK-LABEL: addqr_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, w0
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    add z1.s, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %i = insertelement <vscale x 4 x i32> poison, i32 %y, i32 0
  %ys = shufflevector <vscale x 4 x i32> %i, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %a = add <vscale x 4 x i32> %x, %ys
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @addqr_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, i16 %y) {
; CHECK-LABEL: addqr_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, w0
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    add z1.h, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %i = insertelement <vscale x 8 x i16> poison, i16 %y, i32 0
  %ys = shufflevector <vscale x 8 x i16> %i, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %a = add <vscale x 8 x i16> %x, %ys
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @addqr_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, i8 %y) {
; CHECK-LABEL: addqr_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    mov z2.b, w0
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    add z1.b, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %i = insertelement <vscale x 16 x i8> poison, i8 %y, i32 0
  %ys = shufflevector <vscale x 16 x i8> %i, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %a = add <vscale x 16 x i8> %x, %ys
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @subqr_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, i32 %y) {
; CHECK-LABEL: subqr_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, w0
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    sub z1.s, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %i = insertelement <vscale x 4 x i32> poison, i32 %y, i32 0
  %ys = shufflevector <vscale x 4 x i32> %i, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %a = sub <vscale x 4 x i32> %x, %ys
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @subqr_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, i16 %y) {
; CHECK-LABEL: subqr_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, w0
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    sub z1.h, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %i = insertelement <vscale x 8 x i16> poison, i16 %y, i32 0
  %ys = shufflevector <vscale x 8 x i16> %i, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %a = sub <vscale x 8 x i16> %x, %ys
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @subqr_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, i8 %y) {
; CHECK-LABEL: subqr_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    mov z2.b, w0
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    sub z1.b, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %i = insertelement <vscale x 16 x i8> poison, i8 %y, i32 0
  %ys = shufflevector <vscale x 16 x i8> %i, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %a = sub <vscale x 16 x i8> %x, %ys
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @mulqr_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, i32 %y) {
; CHECK-LABEL: mulqr_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.s, w0
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    mul z1.s, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %i = insertelement <vscale x 4 x i32> poison, i32 %y, i32 0
  %ys = shufflevector <vscale x 4 x i32> %i, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %a = mul <vscale x 4 x i32> %x, %ys
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @mulqr_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, i16 %y) {
; CHECK-LABEL: mulqr_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.h, w0
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    mul z1.h, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %i = insertelement <vscale x 8 x i16> poison, i16 %y, i32 0
  %ys = shufflevector <vscale x 8 x i16> %i, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %a = mul <vscale x 8 x i16> %x, %ys
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @mulqr_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, i8 %y) {
; CHECK-LABEL: mulqr_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.b, w0
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    mul z1.b, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %i = insertelement <vscale x 16 x i8> poison, i8 %y, i32 0
  %ys = shufflevector <vscale x 16 x i8> %i, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %a = mul <vscale x 16 x i8> %x, %ys
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x float> @faddqr_v4f32(<vscale x 4 x float> %z, <vscale x 4 x float> %x, float %y) {
; CHECK-LABEL: faddqr_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $s2 killed $s2 def $z2
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, s2
; CHECK-NEXT:    fcmeq p0.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    fadd z1.s, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 4 x float> %z, zeroinitializer
  %i = insertelement <vscale x 4 x float> poison, float %y, i32 0
  %ys = shufflevector <vscale x 4 x float> %i, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %a = fadd <vscale x 4 x float> %x, %ys
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %z
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @faddqr_v8f16(<vscale x 8 x half> %z, <vscale x 8 x half> %x, half %y) {
; CHECK-LABEL: faddqr_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h2 killed $h2 def $z2
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, h2
; CHECK-NEXT:    fcmeq p0.h, p0/z, z0.h, #0.0
; CHECK-NEXT:    fadd z1.h, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 8 x half> %z, zeroinitializer
  %i = insertelement <vscale x 8 x half> poison, half %y, i32 0
  %ys = shufflevector <vscale x 8 x half> %i, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %a = fadd <vscale x 8 x half> %x, %ys
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %z
  ret <vscale x 8 x half> %b
}

define <vscale x 4 x float> @fsubqr_v4f32(<vscale x 4 x float> %z, <vscale x 4 x float> %x, float %y) {
; CHECK-LABEL: fsubqr_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $s2 killed $s2 def $z2
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, s2
; CHECK-NEXT:    fcmeq p0.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    fsub z1.s, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 4 x float> %z, zeroinitializer
  %i = insertelement <vscale x 4 x float> poison, float %y, i32 0
  %ys = shufflevector <vscale x 4 x float> %i, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %a = fsub <vscale x 4 x float> %x, %ys
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %z
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fsubqr_v8f16(<vscale x 8 x half> %z, <vscale x 8 x half> %x, half %y) {
; CHECK-LABEL: fsubqr_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h2 killed $h2 def $z2
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, h2
; CHECK-NEXT:    fcmeq p0.h, p0/z, z0.h, #0.0
; CHECK-NEXT:    fsub z1.h, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 8 x half> %z, zeroinitializer
  %i = insertelement <vscale x 8 x half> poison, half %y, i32 0
  %ys = shufflevector <vscale x 8 x half> %i, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %a = fsub <vscale x 8 x half> %x, %ys
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %z
  ret <vscale x 8 x half> %b
}

define <vscale x 4 x float> @fmulqr_v4f32(<vscale x 4 x float> %z, <vscale x 4 x float> %x, float %y) {
; CHECK-LABEL: fmulqr_v4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $s2 killed $s2 def $z2
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    mov z2.s, s2
; CHECK-NEXT:    fcmeq p0.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    fmul z1.s, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 4 x float> %z, zeroinitializer
  %i = insertelement <vscale x 4 x float> poison, float %y, i32 0
  %ys = shufflevector <vscale x 4 x float> %i, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %a = fmul <vscale x 4 x float> %x, %ys
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x float> %a, <vscale x 4 x float> %z
  ret <vscale x 4 x float> %b
}

define <vscale x 8 x half> @fmulqr_v8f16(<vscale x 8 x half> %z, <vscale x 8 x half> %x, half %y) {
; CHECK-LABEL: fmulqr_v8f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $h2 killed $h2 def $z2
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    mov z2.h, h2
; CHECK-NEXT:    fcmeq p0.h, p0/z, z0.h, #0.0
; CHECK-NEXT:    fmul z1.h, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = fcmp oeq <vscale x 8 x half> %z, zeroinitializer
  %i = insertelement <vscale x 8 x half> poison, half %y, i32 0
  %ys = shufflevector <vscale x 8 x half> %i, <vscale x 8 x half> poison, <vscale x 8 x i32> zeroinitializer
  %a = fmul <vscale x 8 x half> %x, %ys
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x half> %a, <vscale x 8 x half> %z
  ret <vscale x 8 x half> %b
}

define <vscale x 4 x i32> @sadd_satqr_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, i32 %y) {
; CHECK-LABEL: sadd_satqr_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.s, w0
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    sqadd z1.s, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %i = insertelement <vscale x 4 x i32> poison, i32 %y, i32 0
  %ys = shufflevector <vscale x 4 x i32> %i, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %a = call <vscale x 4 x i32> @llvm.sadd.sat.v4i32(<vscale x 4 x i32> %x, <vscale x 4 x i32> %ys)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @sadd_satqr_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, i16 %y) {
; CHECK-LABEL: sadd_satqr_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.h, w0
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    sqadd z1.h, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %i = insertelement <vscale x 8 x i16> poison, i16 %y, i32 0
  %ys = shufflevector <vscale x 8 x i16> %i, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %a = call <vscale x 8 x i16> @llvm.sadd.sat.v8i16(<vscale x 8 x i16> %x, <vscale x 8 x i16> %ys)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @sadd_satqr_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, i8 %y) {
; CHECK-LABEL: sadd_satqr_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.b, w0
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    sqadd z1.b, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %i = insertelement <vscale x 16 x i8> poison, i8 %y, i32 0
  %ys = shufflevector <vscale x 16 x i8> %i, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %a = call <vscale x 16 x i8> @llvm.sadd.sat.v16i8(<vscale x 16 x i8> %x, <vscale x 16 x i8> %ys)
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @uadd_satqr_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, i32 %y) {
; CHECK-LABEL: uadd_satqr_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.s, w0
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    uqadd z1.s, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %i = insertelement <vscale x 4 x i32> poison, i32 %y, i32 0
  %ys = shufflevector <vscale x 4 x i32> %i, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %a = call <vscale x 4 x i32> @llvm.uadd.sat.v4i32(<vscale x 4 x i32> %x, <vscale x 4 x i32> %ys)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @uadd_satqr_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, i16 %y) {
; CHECK-LABEL: uadd_satqr_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.h, w0
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    uqadd z1.h, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %i = insertelement <vscale x 8 x i16> poison, i16 %y, i32 0
  %ys = shufflevector <vscale x 8 x i16> %i, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %a = call <vscale x 8 x i16> @llvm.uadd.sat.v8i16(<vscale x 8 x i16> %x, <vscale x 8 x i16> %ys)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @uadd_satqr_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, i8 %y) {
; CHECK-LABEL: uadd_satqr_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.b, w0
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    uqadd z1.b, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %i = insertelement <vscale x 16 x i8> poison, i8 %y, i32 0
  %ys = shufflevector <vscale x 16 x i8> %i, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %a = call <vscale x 16 x i8> @llvm.uadd.sat.v16i8(<vscale x 16 x i8> %x, <vscale x 16 x i8> %ys)
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @ssub_satqr_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, i32 %y) {
; CHECK-LABEL: ssub_satqr_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.s, w0
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    sqsub z1.s, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %i = insertelement <vscale x 4 x i32> poison, i32 %y, i32 0
  %ys = shufflevector <vscale x 4 x i32> %i, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %a = call <vscale x 4 x i32> @llvm.ssub.sat.v4i32(<vscale x 4 x i32> %x, <vscale x 4 x i32> %ys)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @ssub_satqr_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, i16 %y) {
; CHECK-LABEL: ssub_satqr_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.h, w0
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    sqsub z1.h, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %i = insertelement <vscale x 8 x i16> poison, i16 %y, i32 0
  %ys = shufflevector <vscale x 8 x i16> %i, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %a = call <vscale x 8 x i16> @llvm.ssub.sat.v8i16(<vscale x 8 x i16> %x, <vscale x 8 x i16> %ys)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @ssub_satqr_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, i8 %y) {
; CHECK-LABEL: ssub_satqr_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.b, w0
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    sqsub z1.b, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %i = insertelement <vscale x 16 x i8> poison, i8 %y, i32 0
  %ys = shufflevector <vscale x 16 x i8> %i, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %a = call <vscale x 16 x i8> @llvm.ssub.sat.v16i8(<vscale x 16 x i8> %x, <vscale x 16 x i8> %ys)
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

define <vscale x 4 x i32> @usub_satqr_v4i32(<vscale x 4 x i32> %z, <vscale x 4 x i32> %x, i32 %y) {
; CHECK-LABEL: usub_satqr_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.s, w0
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    cmpeq p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    uqsub z1.s, z1.s, z2.s
; CHECK-NEXT:    mov z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 4 x i32> %z, zeroinitializer
  %i = insertelement <vscale x 4 x i32> poison, i32 %y, i32 0
  %ys = shufflevector <vscale x 4 x i32> %i, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %a = call <vscale x 4 x i32> @llvm.usub.sat.v4i32(<vscale x 4 x i32> %x, <vscale x 4 x i32> %ys)
  %b = select <vscale x 4 x i1> %c, <vscale x 4 x i32> %a, <vscale x 4 x i32> %z
  ret <vscale x 4 x i32> %b
}

define <vscale x 8 x i16> @usub_satqr_v8i16(<vscale x 8 x i16> %z, <vscale x 8 x i16> %x, i16 %y) {
; CHECK-LABEL: usub_satqr_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.h, w0
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    cmpeq p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    uqsub z1.h, z1.h, z2.h
; CHECK-NEXT:    mov z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 8 x i16> %z, zeroinitializer
  %i = insertelement <vscale x 8 x i16> poison, i16 %y, i32 0
  %ys = shufflevector <vscale x 8 x i16> %i, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %a = call <vscale x 8 x i16> @llvm.usub.sat.v8i16(<vscale x 8 x i16> %x, <vscale x 8 x i16> %ys)
  %b = select <vscale x 8 x i1> %c, <vscale x 8 x i16> %a, <vscale x 8 x i16> %z
  ret <vscale x 8 x i16> %b
}

define <vscale x 16 x i8> @usub_satqr_v16i8(<vscale x 16 x i8> %z, <vscale x 16 x i8> %x, i8 %y) {
; CHECK-LABEL: usub_satqr_v16i8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z2.b, w0
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    cmpeq p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    uqsub z1.b, z1.b, z2.b
; CHECK-NEXT:    mov z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
entry:
  %c = icmp eq <vscale x 16 x i8> %z, zeroinitializer
  %i = insertelement <vscale x 16 x i8> poison, i8 %y, i32 0
  %ys = shufflevector <vscale x 16 x i8> %i, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %a = call <vscale x 16 x i8> @llvm.usub.sat.v16i8(<vscale x 16 x i8> %x, <vscale x 16 x i8> %ys)
  %b = select <vscale x 16 x i1> %c, <vscale x 16 x i8> %a, <vscale x 16 x i8> %z
  ret <vscale x 16 x i8> %b
}

declare <vscale x 16 x i8> @llvm.sadd.sat.v16i8(<vscale x 16 x i8> %src1, <vscale x 16 x i8> %src2)
declare <vscale x 8 x i16> @llvm.sadd.sat.v8i16(<vscale x 8 x i16> %src1, <vscale x 8 x i16> %src2)
declare <vscale x 4 x i32> @llvm.sadd.sat.v4i32(<vscale x 4 x i32> %src1, <vscale x 4 x i32> %src2)
declare <vscale x 16 x i8> @llvm.uadd.sat.v16i8(<vscale x 16 x i8> %src1, <vscale x 16 x i8> %src2)
declare <vscale x 8 x i16> @llvm.uadd.sat.v8i16(<vscale x 8 x i16> %src1, <vscale x 8 x i16> %src2)
declare <vscale x 4 x i32> @llvm.uadd.sat.v4i32(<vscale x 4 x i32> %src1, <vscale x 4 x i32> %src2)
declare <vscale x 16 x i8> @llvm.ssub.sat.v16i8(<vscale x 16 x i8> %src1, <vscale x 16 x i8> %src2)
declare <vscale x 8 x i16> @llvm.ssub.sat.v8i16(<vscale x 8 x i16> %src1, <vscale x 8 x i16> %src2)
declare <vscale x 4 x i32> @llvm.ssub.sat.v4i32(<vscale x 4 x i32> %src1, <vscale x 4 x i32> %src2)
declare <vscale x 16 x i8> @llvm.usub.sat.v16i8(<vscale x 16 x i8> %src1, <vscale x 16 x i8> %src2)
declare <vscale x 8 x i16> @llvm.usub.sat.v8i16(<vscale x 8 x i16> %src1, <vscale x 8 x i16> %src2)
declare <vscale x 4 x i32> @llvm.usub.sat.v4i32(<vscale x 4 x i32> %src1, <vscale x 4 x i32> %src2)
