; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

define void @shuffle_any_ext_2i8_to_2i64(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_2i8_to_2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.h $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.h $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %x = load <2 x i8>, ptr %ptr
  %y = shufflevector <2 x i8> %x, <2 x i8> poison, <16 x i32> <i32 0, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 3, i32 1, i32 2, i32 2, i32 2,i32 2, i32 2, i32 2, i32 2>
  %r = bitcast <16 x i8> %y to <2 x i64>
  store <2 x i64> %r, ptr %dst
  ret void
}

define void @shuffle_any_ext_2i16_to_2i64(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_2i16_to_2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.w $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a0, 0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %x = load <2 x i16>, ptr %ptr
  %y = shufflevector <2 x i16> %x, <2 x i16> poison, <8 x i32> <i32 0, i32 3, i32 3, i32 3, i32 1, i32 2, i32 2, i32 2>
  %r = bitcast <8 x i16> %y to <2 x i64>
  store <2 x i64> %r, ptr %dst
  ret void
}

define void @shuffle_any_ext_2i32_to_2i64(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_2i32_to_2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; CHECK-NEXT:    vshuf4i.w $vr0, $vr0, 16
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %x = load <2 x i32>, ptr %ptr
  %y = shufflevector <2 x i32> %x, <2 x i32> poison, <4 x i32> <i32 0, i32 3, i32 1, i32 2>
  %r = bitcast <4 x i32> %y to <2 x i64>
  store <2 x i64> %r, ptr %dst
  ret void
}

define void @shuffle_any_ext_4i8_to_4i32(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_4i8_to_4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.w $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %x = load <4 x i8>, ptr %ptr
  %y = shufflevector <4 x i8> %x, <4 x i8> poison, <16 x i32> <i32 0, i32 7, i32 7, i32 7, i32 1, i32 6, i32 6, i32 6, i32 2, i32 5, i32 5, i32 5, i32 3, i32 4, i32 4, i32 4>
  %r = bitcast <16 x i8> %y to <4 x i32>
  store <4 x i32> %r, ptr %dst
  ret void
}

define void @shuffle_any_ext_4i16_to_4i32(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_4i16_to_4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; CHECK-NEXT:    vilvl.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %x = load <4 x i16>, ptr %ptr
  %y = shufflevector <4 x i16> %x, <4 x i16> poison, <8 x i32> <i32 0, i32 7, i32 1, i32 6, i32 2, i32 5, i32 3, i32 4>
  %r = bitcast <8 x i16> %y to <4 x i32>
  store <4 x i32> %r, ptr %dst
  ret void
}

define void @shuffle_any_ext_8i8_to_8i16(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_8i8_to_8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %x = load <8 x i8>, ptr %ptr
  %y = shufflevector <8 x i8> %x, <8 x i8> poison, <16 x i32> <i32 0, i32 15, i32 1, i32 14, i32 2, i32 13, i32 3, i32 12, i32 4, i32 11, i32 5, i32 10, i32 6, i32 9, i32 7, i32 8>
  %r = bitcast <16 x i8> %y to <8 x i16>
  store <8 x i16> %r, ptr %dst
  ret void
}

define void @shuffle_any_ext_4i32_to_4i64(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_4i32_to_4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vshuf4i.w $vr1, $vr0, 16
; CHECK-NEXT:    vshuf4i.w $vr0, $vr0, 50
; CHECK-NEXT:    vst $vr0, $a1, 16
; CHECK-NEXT:    vst $vr1, $a1, 0
; CHECK-NEXT:    ret
  %x = load <4 x i32>, ptr %ptr
  %y = shufflevector <4 x i32> %x, <4 x i32> poison, <8 x i32> <i32 0, i32 7, i32 1, i32 6, i32 2, i32 5, i32 3, i32 4>
  %r = bitcast <8 x i32> %y to <4 x i64>
  store <4 x i64> %r, ptr %dst
  ret void
}

define void @shuffle_any_ext_8i16_to_8i32(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_8i16_to_8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vilvl.h $vr1, $vr0, $vr0
; CHECK-NEXT:    vilvh.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 16
; CHECK-NEXT:    vst $vr1, $a1, 0
; CHECK-NEXT:    ret
  %x = load <8 x i16>, ptr %ptr
  %y = shufflevector <8 x i16> %x, <8 x i16> poison, <16 x i32> <i32 0, i32 15, i32 1, i32 15, i32 2, i32 13, i32 3, i32 12, i32 4, i32 11, i32 5, i32 10, i32 6, i32 9, i32 7, i32 8>
  %r = bitcast <16 x i16> %y to <8 x i32>
  store <8 x i32> %r, ptr %dst
  ret void
}

define void @shuffle_any_ext_8i16_to_8i64(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_8i16_to_8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vilvl.h $vr1, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr2, $vr1, $vr1
; CHECK-NEXT:    vilvh.w $vr1, $vr1, $vr1
; CHECK-NEXT:    vilvh.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr3, $vr0, $vr0
; CHECK-NEXT:    vilvh.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 48
; CHECK-NEXT:    vst $vr3, $a1, 32
; CHECK-NEXT:    vst $vr1, $a1, 16
; CHECK-NEXT:    vst $vr2, $a1, 0
; CHECK-NEXT:    ret
  %x = load <8 x i16>, ptr %ptr
  %y = shufflevector <8 x i16> %x, <8 x i16> poison, <32 x i32> <i32 0, i32 15, i32 15, i32 15, i32 1, i32 14, i32 14, i32 14, i32 2, i32 13, i32 13, i32 13, i32 3, i32 12, i32 12, i32 12, i32 4, i32 11, i32 11, i32 11, i32 5, i32 10, i32 10, i32 10, i32 6, i32 9, i32 9, i32 9, i32 7, i32 8, i32 8, i32 8>
  %r = bitcast <32 x i16> %y to <8 x i64>
  store <8 x i64> %r, ptr %dst
  ret void
}

define void @shuffle_any_ext_16i8_to_16i16(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_16i8_to_16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr1, $vr0, $vr0
; CHECK-NEXT:    vilvh.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 16
; CHECK-NEXT:    vst $vr1, $a1, 0
; CHECK-NEXT:    ret
  %x = load <16 x i8>, ptr %ptr
  %y = shufflevector <16 x i8> %x, <16 x i8> poison, <32 x i32> <i32 0, i32 31, i32 1, i32 31, i32 2, i32 29, i32 3, i32 28, i32 4, i32 27, i32 5, i32 26, i32 6, i32 25, i32 7, i32 24, i32 8, i32 23, i32 9, i32 22, i32 10, i32 21, i32 11, i32 20, i32 12, i32 19, i32 13, i32 18, i32 14, i32 17, i32 15, i32 16 >
  %r = bitcast <32 x i8> %y to <16 x i16>
  store <16 x i16> %r, ptr %dst
  ret void
}

define void @shuffle_any_ext_16i8_to_16i32(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_16i8_to_16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr1, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr2, $vr1, $vr1
; CHECK-NEXT:    vilvh.h $vr1, $vr1, $vr1
; CHECK-NEXT:    vilvh.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr3, $vr0, $vr0
; CHECK-NEXT:    vilvh.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 48
; CHECK-NEXT:    vst $vr3, $a1, 32
; CHECK-NEXT:    vst $vr1, $a1, 16
; CHECK-NEXT:    vst $vr2, $a1, 0
; CHECK-NEXT:    ret
  %x = load <16 x i8>, ptr %ptr
  %y = shufflevector <16 x i8> %x, <16 x i8> poison, <64 x i32> <i32 0, i32 31, i32 31, i32 31, i32 1, i32 30, i32 30, i32 30, i32 2, i32 29, i32 29, i32 29, i32 3, i32 28, i32 28, i32 28, i32 4, i32 27, i32 27, i32 27, i32 5, i32 26, i32 26, i32 26, i32 6, i32 25, i32 25, i32 25, i32 7, i32 24, i32 24, i32 24, i32 8, i32 23, i32 23, i32 23, i32 9, i32 22, i32 22, i32 22, i32 10, i32 21, i32 21, i32 21, i32 11, i32 20, i32 20, i32 20, i32 12, i32 19, i32 19, i32 19, i32 13, i32 18, i32 18, i32 18, i32 14, i32 17, i32 17, i32 17, i32 15, i32 16, i32 16, i32 16>
  %r = bitcast <64 x i8> %y to <16 x i32>
  store <16 x i32> %r, ptr %dst
  ret void
}

define void @shuffle_any_ext_16i8_to_16i64(ptr %ptr, ptr %dst) nounwind {
; CHECK-LABEL: shuffle_any_ext_16i8_to_16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vilvl.b $vr1, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr2, $vr1, $vr1
; CHECK-NEXT:    vilvl.w $vr3, $vr2, $vr2
; CHECK-NEXT:    vilvh.w $vr2, $vr2, $vr2
; CHECK-NEXT:    vilvh.h $vr1, $vr1, $vr1
; CHECK-NEXT:    vilvl.w $vr4, $vr1, $vr1
; CHECK-NEXT:    vilvh.w $vr1, $vr1, $vr1
; CHECK-NEXT:    vilvh.b $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.h $vr5, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr6, $vr5, $vr5
; CHECK-NEXT:    vilvh.w $vr5, $vr5, $vr5
; CHECK-NEXT:    vilvh.h $vr0, $vr0, $vr0
; CHECK-NEXT:    vilvl.w $vr7, $vr0, $vr0
; CHECK-NEXT:    vilvh.w $vr0, $vr0, $vr0
; CHECK-NEXT:    vst $vr0, $a1, 112
; CHECK-NEXT:    vst $vr7, $a1, 96
; CHECK-NEXT:    vst $vr5, $a1, 80
; CHECK-NEXT:    vst $vr6, $a1, 64
; CHECK-NEXT:    vst $vr1, $a1, 48
; CHECK-NEXT:    vst $vr4, $a1, 32
; CHECK-NEXT:    vst $vr2, $a1, 16
; CHECK-NEXT:    vst $vr3, $a1, 0
; CHECK-NEXT:    ret
  %x = load <16 x i8>, ptr %ptr
  %y = shufflevector <16 x i8> %x, <16 x i8> poison, <128 x i32> <i32 0, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 31, i32 1, i32 30, i32 30, i32 30, i32 30, i32 30, i32 30, i32 30, i32 2, i32 29, i32 29, i32 29, i32 29, i32 29, i32 29, i32 29, i32 3, i32 28, i32 28, i32 28, i32 28, i32 28, i32 28, i32 28, i32 4, i32 27, i32 27, i32 27, i32 27, i32 27, i32 27, i32 27, i32 5, i32 26, i32 26, i32 26, i32 26, i32 26, i32 26, i32 26, i32 6, i32 25, i32 25, i32 25, i32 25, i32 25, i32 25, i32 25, i32 7, i32 24, i32 24, i32 24, i32 24, i32 24, i32 24, i32 24, i32 8, i32 23, i32 23, i32 23, i32 23, i32 23, i32 23, i32 23, i32 9, i32 22, i32 22, i32 22, i32 22, i32 22, i32 22, i32 22, i32 10, i32 21, i32 21, i32 21, i32 21, i32 21, i32 21, i32 21, i32 11, i32 20, i32 20, i32 20, i32 20, i32 20, i32 20, i32 20, i32 12, i32 19, i32 19, i32 19, i32 19, i32 19, i32 19, i32 19, i32 13, i32 18, i32 18, i32 18, i32 18, i32 18, i32 18, i32 18, i32 14, i32 17, i32 17, i32 17, i32 17, i32 17, i32 17, i32 17, i32 15, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16, i32 16>
  %r = bitcast <128 x i8> %y to <16 x i64>
  store <16 x i64> %r, ptr %dst
  ret void
}
