; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown             | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=i686-unknown -mattr=sse2 | FileCheck %s --check-prefix=SSE2
; RUN: llc < %s -mtriple=i686-linux-gnu -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=GISEL-X86
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=x86_64-linux-gnu -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=GISEL-X64

define i64 @testmsxs(float %x) {
; X86-LABEL: testmsxs:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fstps (%esp)
; X86-NEXT:    calll llroundf
; X86-NEXT:    popl %ecx
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    retl
;
; SSE2-LABEL: testmsxs:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    pushl %eax
; SSE2-NEXT:    .cfi_def_cfa_offset 8
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss %xmm0, (%esp)
; SSE2-NEXT:    calll llroundf
; SSE2-NEXT:    popl %ecx
; SSE2-NEXT:    .cfi_def_cfa_offset 4
; SSE2-NEXT:    retl
;
; GISEL-X86-LABEL: testmsxs:
; GISEL-X86:       # %bb.0: # %entry
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 16
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl %eax, (%esp)
; GISEL-X86-NEXT:    calll llroundf
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 4
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: testmsxs:
; X64:       # %bb.0: # %entry
; X64-NEXT:    jmp llroundf@PLT # TAILCALL
;
; GISEL-X64-LABEL: testmsxs:
; GISEL-X64:       # %bb.0: # %entry
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 16
; GISEL-X64-NEXT:    callq llroundf
; GISEL-X64-NEXT:    popq %rcx
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 8
; GISEL-X64-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.llround.f32(float %x)
  ret i64 %0
}

define i64 @testmsxd(double %x) {
; X86-LABEL: testmsxd:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    .cfi_def_cfa_offset 12
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fstpl (%esp)
; X86-NEXT:    calll llround
; X86-NEXT:    addl $8, %esp
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    retl
;
; SSE2-LABEL: testmsxd:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    subl $8, %esp
; SSE2-NEXT:    .cfi_def_cfa_offset 12
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    movsd %xmm0, (%esp)
; SSE2-NEXT:    calll llround
; SSE2-NEXT:    addl $8, %esp
; SSE2-NEXT:    .cfi_def_cfa_offset 4
; SSE2-NEXT:    retl
;
; GISEL-X86-LABEL: testmsxd:
; GISEL-X86:       # %bb.0: # %entry
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 16
; GISEL-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl 4(%eax), %eax
; GISEL-X86-NEXT:    xorl %edx, %edx
; GISEL-X86-NEXT:    addl %esp, %edx
; GISEL-X86-NEXT:    movl %ecx, (%esp)
; GISEL-X86-NEXT:    movl %eax, 4(%edx)
; GISEL-X86-NEXT:    calll llround
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 4
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: testmsxd:
; X64:       # %bb.0: # %entry
; X64-NEXT:    jmp llround@PLT # TAILCALL
;
; GISEL-X64-LABEL: testmsxd:
; GISEL-X64:       # %bb.0: # %entry
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 16
; GISEL-X64-NEXT:    callq llround
; GISEL-X64-NEXT:    popq %rcx
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 8
; GISEL-X64-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.llround.f64(double %x)
  ret i64 %0
}

define i64 @testmsll(x86_fp80 %x) {
; X86-LABEL: testmsll:
; X86:       # %bb.0: # %entry
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    .cfi_def_cfa_offset 16
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fstpt (%esp)
; X86-NEXT:    calll llroundl
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    retl
;
; SSE2-LABEL: testmsll:
; SSE2:       # %bb.0: # %entry
; SSE2-NEXT:    subl $12, %esp
; SSE2-NEXT:    .cfi_def_cfa_offset 16
; SSE2-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE2-NEXT:    fstpt (%esp)
; SSE2-NEXT:    calll llroundl
; SSE2-NEXT:    addl $12, %esp
; SSE2-NEXT:    .cfi_def_cfa_offset 4
; SSE2-NEXT:    retl
;
; GISEL-X86-LABEL: testmsll:
; GISEL-X86:       # %bb.0: # %entry
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 16
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fstpt (%esp)
; GISEL-X86-NEXT:    calll llroundl
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    .cfi_def_cfa_offset 4
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: testmsll:
; X64:       # %bb.0: # %entry
; X64-NEXT:    jmp llroundl@PLT # TAILCALL
;
; GISEL-X64-LABEL: testmsll:
; GISEL-X64:       # %bb.0: # %entry
; GISEL-X64-NEXT:    subq $24, %rsp
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 32
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fstpt (%rsp)
; GISEL-X64-NEXT:    callq llroundl
; GISEL-X64-NEXT:    addq $24, %rsp
; GISEL-X64-NEXT:    .cfi_def_cfa_offset 8
; GISEL-X64-NEXT:    retq
entry:
  %0 = tail call i64 @llvm.llround.f80(x86_fp80 %x)
  ret i64 %0
}

define i64 @test_llround_i64_f32(float %x) nounwind {
; X86-LABEL: test_llround_i64_f32:
; X86:       # %bb.0:
; X86-NEXT:    pushl %eax
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fstps (%esp)
; X86-NEXT:    calll llroundf
; X86-NEXT:    popl %ecx
; X86-NEXT:    retl
;
; SSE2-LABEL: test_llround_i64_f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pushl %eax
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss %xmm0, (%esp)
; SSE2-NEXT:    calll llroundf
; SSE2-NEXT:    popl %ecx
; SSE2-NEXT:    retl
;
; GISEL-X86-LABEL: test_llround_i64_f32:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl %eax, (%esp)
; GISEL-X86-NEXT:    calll llroundf
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: test_llround_i64_f32:
; X64:       # %bb.0:
; X64-NEXT:    jmp llroundf@PLT # TAILCALL
;
; GISEL-X64-LABEL: test_llround_i64_f32:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    callq llroundf
; GISEL-X64-NEXT:    popq %rcx
; GISEL-X64-NEXT:    retq
  %conv = call i64 @llvm.llround.i64.f32(float %x)
  ret i64 %conv
}

define i64 @test_llround_i64_f64(double %x) nounwind {
; X86-LABEL: test_llround_i64_f64:
; X86:       # %bb.0:
; X86-NEXT:    subl $8, %esp
; X86-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NEXT:    fstpl (%esp)
; X86-NEXT:    calll llround
; X86-NEXT:    addl $8, %esp
; X86-NEXT:    retl
;
; SSE2-LABEL: test_llround_i64_f64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    subl $8, %esp
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    movsd %xmm0, (%esp)
; SSE2-NEXT:    calll llround
; SSE2-NEXT:    addl $8, %esp
; SSE2-NEXT:    retl
;
; GISEL-X86-LABEL: test_llround_i64_f64:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    leal {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl 4(%eax), %eax
; GISEL-X86-NEXT:    xorl %edx, %edx
; GISEL-X86-NEXT:    addl %esp, %edx
; GISEL-X86-NEXT:    movl %ecx, (%esp)
; GISEL-X86-NEXT:    movl %eax, 4(%edx)
; GISEL-X86-NEXT:    calll llround
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: test_llround_i64_f64:
; X64:       # %bb.0:
; X64-NEXT:    jmp llround@PLT # TAILCALL
;
; GISEL-X64-LABEL: test_llround_i64_f64:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    pushq %rax
; GISEL-X64-NEXT:    callq llround
; GISEL-X64-NEXT:    popq %rcx
; GISEL-X64-NEXT:    retq
  %conv = call i64 @llvm.llround.i64.f64(double %x)
  ret i64 %conv
}

define i64 @test_llround_i64_f80(x86_fp80 %x) nounwind {
; X86-LABEL: test_llround_i64_f80:
; X86:       # %bb.0:
; X86-NEXT:    subl $12, %esp
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fstpt (%esp)
; X86-NEXT:    calll llroundl
; X86-NEXT:    addl $12, %esp
; X86-NEXT:    retl
;
; SSE2-LABEL: test_llround_i64_f80:
; SSE2:       # %bb.0:
; SSE2-NEXT:    subl $12, %esp
; SSE2-NEXT:    fldt {{[0-9]+}}(%esp)
; SSE2-NEXT:    fstpt (%esp)
; SSE2-NEXT:    calll llroundl
; SSE2-NEXT:    addl $12, %esp
; SSE2-NEXT:    retl
;
; GISEL-X86-LABEL: test_llround_i64_f80:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    subl $12, %esp
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fstpt (%esp)
; GISEL-X86-NEXT:    calll llroundl
; GISEL-X86-NEXT:    addl $12, %esp
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: test_llround_i64_f80:
; X64:       # %bb.0:
; X64-NEXT:    jmp llroundl@PLT # TAILCALL
;
; GISEL-X64-LABEL: test_llround_i64_f80:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    subq $24, %rsp
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fstpt (%rsp)
; GISEL-X64-NEXT:    callq llroundl
; GISEL-X64-NEXT:    addq $24, %rsp
; GISEL-X64-NEXT:    retq
  %conv = call i64 @llvm.llround.i64.f80(x86_fp80 %x)
  ret i64 %conv
}
