; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s | FileCheck %s
; RUN: llc --fast-isel < %s | FileCheck %s
; RUN: llc --global-isel --global-isel-abort=2 < %s | FileCheck %s

; Source to regenerate:
; struct Foo {
;   int * __ptr32 p32;
;   int * __ptr64 p64;
;   __attribute__((address_space(9))) int *p_other;
; };
; extern "C" void use_foo(Foo *f);
; extern "C" int use_int(int i);
; extern "C" void test_sign_ext(Foo *f, int * __ptr32 __sptr i) {
;   f->p64 = i;
;   use_foo(f);
; }
; extern "C" void test_sign_ext_store_load(int * __ptr32 __sptr i) {
;   *i = use_int(*i);
; }
; extern "C" void test_zero_ext(Foo *f, int * __ptr32 __uptr i) {
;   f->p64 = i;
;   use_foo(f);
; }
; extern "C" void test_zero_ext_store_load(int * __ptr32 __uptr i) {
;   *i = use_int(*i);
; }
; extern "C" void test_trunc(Foo *f, int * __ptr64 i) {
;   f->p32 = i;
;   use_foo(f);
; }
; extern "C" void test_noop1(Foo *f, int * __ptr32 i) {
;   f->p32 = i;
;   use_foo(f);
; }
; extern "C" void test_noop2(Foo *f, int * __ptr64 i) {
;   f->p64 = i;
;   use_foo(f);
; }
; extern "C" void test_null_arg(Foo *f, int * __ptr32 i) {
;   test_noop1(f, 0);
; }
; extern "C" void test_unrecognized(Foo *f, __attribute__((address_space(14))) int *i) {
;   f->p32 = (int * __ptr32)i;
;   use_foo(f);
; }
;
; $ clang --target=aarch64-windows-msvc -fms-extensions -O2 -S -emit-llvm t.cpp

target datalayout = "e-m:w-p:64:64-i32:32-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-n32:64-S128-Fn32"
target triple = "aarch64-unknown-windows-msvc"

; Function Attrs: mustprogress uwtable
define dso_local void @test_sign_ext(ptr noundef %f, ptr addrspace(270) noundef %i) local_unnamed_addr #0 {
; CHECK-LABEL: test_sign_ext:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-NEXT:    sxtw x8, w1
; CHECK-NEXT:    str  x8, [x0, #8]
; CHECK-NEXT:    b    use_foo
entry:
  %0 = addrspacecast ptr addrspace(270) %i to ptr
  %p64 = getelementptr inbounds nuw i8, ptr %f, i64 8
  store ptr %0, ptr %p64, align 8
  tail call void @use_foo(ptr noundef %f)
  ret void
}

declare dso_local void @use_foo(ptr noundef) local_unnamed_addr #1

; Function Attrs: mustprogress uwtable
define dso_local void @test_sign_ext_store_load(ptr addrspace(270) nocapture noundef %i) local_unnamed_addr #0 {
; CHECK-LABEL: test_sign_ext_store_load:
; CHECK:       // %bb.0: // %entry
; CHECK:       sxtw    x19, w0
; CHECK-NEXT:  ldr     w0, [x19]
; CHECK-NEXT:  bl      use_int
; CHECK-NEXT:  str     w0, [x19]
entry:
  %0 = load i32, ptr addrspace(270) %i, align 4
  %call = tail call i32 @use_int(i32 noundef %0)
  store i32 %call, ptr addrspace(270) %i, align 4
  ret void
}

declare dso_local i32 @use_int(i32 noundef) local_unnamed_addr #1

; Function Attrs: mustprogress uwtable
define dso_local void @test_zero_ext(ptr noundef %f, ptr addrspace(271) noundef %i) local_unnamed_addr #0 {
; CHECK-LABEL: test_zero_ext:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:  mov     w8, w1
; CHECK-NEXT:  str     x8, [x0, #8]
; CHECK-NEXT:  b       use_foo
entry:
  %0 = addrspacecast ptr addrspace(271) %i to ptr
  %p64 = getelementptr inbounds nuw i8, ptr %f, i64 8
  store ptr %0, ptr %p64, align 8
  tail call void @use_foo(ptr noundef %f)
  ret void
}

; Function Attrs: mustprogress uwtable
define dso_local void @test_zero_ext_store_load(ptr addrspace(271) nocapture noundef %i) local_unnamed_addr #0 {
; CHECK-LABEL: test_zero_ext_store_load:
; CHECK:       // %bb.0: // %entry
; CHECK:       mov     w19, w0
; CHECK-NEXT:  ldr     w0, [x19]
; CHECK-NEXT:  bl      use_int
; CHECK-NEXT:  str     w0, [x19]
entry:
  %0 = load i32, ptr addrspace(271) %i, align 4
  %call = tail call i32 @use_int(i32 noundef %0)
  store i32 %call, ptr addrspace(271) %i, align 4
  ret void
}

; Function Attrs: mustprogress uwtable
define dso_local void @test_trunc(ptr noundef %f, ptr noundef %i) local_unnamed_addr #0 {
; CHECK-LABEL: test_trunc:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str     w1, [x0]
; CHECK-NEXT:    b      use_foo
entry:
  %0 = addrspacecast ptr %i to ptr addrspace(270)
  store ptr addrspace(270) %0, ptr %f, align 8
  tail call void @use_foo(ptr noundef nonnull %f)
  ret void
}

; Function Attrs: mustprogress uwtable
define dso_local void @test_noop1(ptr noundef %f, ptr addrspace(270) noundef %i) local_unnamed_addr #0 {
; CHECK-LABEL: test_noop1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str  w1, [x0]
; CHECK-NEXT:    b    use_foo
entry:
  store ptr addrspace(270) %i, ptr %f, align 8
  tail call void @use_foo(ptr noundef nonnull %f)
  ret void
}

; Function Attrs: mustprogress uwtable
define dso_local void @test_noop2(ptr noundef %f, ptr noundef %i) local_unnamed_addr #0 {
; CHECK-LABEL: test_noop2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str  x1, [x0, #8]
; CHECK-NEXT:    b    use_foo
entry:
  %p64 = getelementptr inbounds nuw i8, ptr %f, i64 8
  store ptr %i, ptr %p64, align 8
  tail call void @use_foo(ptr noundef %f)
  ret void
}

; Function Attrs: mustprogress uwtable
define dso_local void @test_null_arg(ptr noundef %f, ptr addrspace(270) nocapture noundef readnone %i) local_unnamed_addr #0 {
; CHECK-LABEL: test_null_arg:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str  wzr, [x0]
; CHECK-NEXT:    b    use_foo
entry:
  store ptr addrspace(270) null, ptr %f, align 8
  tail call void @use_foo(ptr noundef nonnull %f)
  ret void
}

; Function Attrs: mustprogress uwtable
define dso_local void @test_unrecognized(ptr noundef %f, ptr addrspace(14) noundef %i) local_unnamed_addr #0 {
; CHECK-LABEL: test_unrecognized:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str   w1, [x0]
; CHECK-NEXT:    b    use_foo
entry:
  %0 = addrspacecast ptr addrspace(14) %i to ptr addrspace(270)
  store ptr addrspace(270) %0, ptr %f, align 8
  tail call void @use_foo(ptr noundef nonnull %f)
  ret void
}

attributes #0 = { mustprogress uwtable "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-cpu"="generic" "target-features"="+fp-armv8,+neon,+v8a,-fmv" }
attributes #1 = { "no-trapping-math"="true" "stack-protector-buffer-size"="8" "target-cpu"="generic" "target-features"="+fp-armv8,+neon,+v8a,-fmv" }
