; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -verify-machineinstrs -mtriple=aarch64-none-linux-gnu | FileCheck %s

define i128 @ldp_single_csdb(ptr %p) speculative_load_hardening {
; CHECK-LABEL: ldp_single_csdb:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldp x8, x1, [x0]
; CHECK-NEXT:    cmp sp, #0
; CHECK-NEXT:    csetm x16, ne
; CHECK-NEXT:    and x8, x8, x16
; CHECK-NEXT:    and x1, x1, x16
; CHECK-NEXT:    csdb
; CHECK-NEXT:    mov x2, sp
; CHECK-NEXT:    mov x0, x8
; CHECK-NEXT:    and x2, x2, x16
; CHECK-NEXT:    mov sp, x2
; CHECK-NEXT:    ret
entry:
  %0 = load i128, ptr %p, align 16
  ret i128 %0
}

; Checking that the address loaded from is masked for a floating point load.
define double @ld_double(ptr %p) speculative_load_hardening {
; CHECK-LABEL: ld_double:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp sp, #0
; CHECK-NEXT:    csetm x16, ne
; CHECK-NEXT:    and x0, x0, x16
; CHECK-NEXT:    csdb
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    and x0, x0, x16
; CHECK-NEXT:    mov sp, x0
; CHECK-NEXT:    ret
entry:
  %0 = load double, ptr %p, align 8
  ret double %0
}

; Checking that the address loaded from is masked for a floating point load.
; csdb instruction must occur before the add instruction with w8 as operand.
define i32 @csdb_emitted_for_subreg_use(ptr %p, i32 %b) speculative_load_hardening {
; CHECK-LABEL: csdb_emitted_for_subreg_use:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp sp, #0
; CHECK-NEXT:    ldr x8, [x0]
; CHECK-NEXT:    csetm x16, ne
; CHECK-NEXT:    and x8, x8, x16
; CHECK-NEXT:    csdb
; CHECK-NEXT:    add w9, w1, w8
; CHECK-NEXT:    cmp x8, #0
; CHECK-NEXT:    csel w0, w1, w9, eq
; CHECK-NEXT:    mov x1, sp
; CHECK-NEXT:    and x1, x1, x16
; CHECK-NEXT:    mov sp, x1
; CHECK-NEXT:    ret
entry:
  %X = load i64, ptr %p, align 8
  %X_trunc = trunc i64 %X to i32
  %add = add i32 %b, %X_trunc
  %iszero = icmp eq i64 %X, 0
  %ret = select i1 %iszero, i32 %b, i32 %add
  ret i32 %ret
}

; Checking that the address loaded from is masked for a floating point load.
; csdb instruction must occur before the add instruction with x8 as operand.
define i64 @csdb_emitted_for_superreg_use(ptr %p, i64 %b) speculative_load_hardening {
; CHECK-LABEL: csdb_emitted_for_superreg_use:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp sp, #0
; CHECK-NEXT:    ldr w8, [x0]
; CHECK-NEXT:    csetm x16, ne
; CHECK-NEXT:    and w8, w8, w16
; CHECK-NEXT:    csdb
; CHECK-NEXT:    add x9, x1, x8
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    csel x0, x1, x9, eq
; CHECK-NEXT:    mov x1, sp
; CHECK-NEXT:    and x1, x1, x16
; CHECK-NEXT:    mov sp, x1
; CHECK-NEXT:    ret
entry:
  %X = load i32, ptr %p, align 4
  %X_ext = zext i32 %X to i64
  %add = add i64 %b, %X_ext
  %iszero = icmp eq i32 %X, 0
  %ret = select i1 %iszero, i64 %b, i64 %add
  ret i64 %ret
}

define i64 @no_masking_with_full_control_flow_barriers(i64 %a, i64 %b, ptr %p) speculative_load_hardening {
; CHECK-LABEL: no_masking_with_full_control_flow_barriers:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    dsb sy
; CHECK-NEXT:    isb
; CHECK-NEXT:    ldr x8, [x2]
; CHECK-NEXT:    mov x17, x0
; CHECK-NEXT:    mov x16, x1
; CHECK-NEXT:    //APP
; CHECK-NEXT:    hint #12
; CHECK-NEXT:    //NO_APP
; CHECK-NEXT:    add x0, x8, x17
; CHECK-NEXT:    ret
entry:
  %0 = tail call i64 asm "hint #12", "={x17},{x16},0"(i64 %b, i64 %a)
  %X = load i64, ptr %p, align 8
  %ret = add i64 %X, %0
  ret i64 %ret
}

define void @f_implicitdef_vector_load(ptr %dst, ptr %src) speculative_load_hardening {
; CHECK-LABEL: f_implicitdef_vector_load:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp sp, #0
; CHECK-NEXT:    csetm x16, ne
; CHECK-NEXT:    and x1, x1, x16
; CHECK-NEXT:    csdb
; CHECK-NEXT:    ldr d0, [x1]
; CHECK-NEXT:    mov v0.d[1], v0.d[0]
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    and x0, x0, x16
; CHECK-NEXT:    mov sp, x0
; CHECK-NEXT:    ret
entry:
  %0 = load <2 x i32>, ptr %src, align 8
  %shuffle = shufflevector <2 x i32> %0, <2 x i32> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  store <4 x i32> %shuffle, ptr %dst, align 4
  ret void
}

define <2 x double> @f_usedefvectorload(ptr %a, ptr %b) speculative_load_hardening {
; CHECK-LABEL: f_usedefvectorload:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp sp, #0
; CHECK-NEXT:    csetm x16, ne
; CHECK-NEXT:    and x1, x1, x16
; CHECK-NEXT:    csdb
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    ldr d0, [x1]
; CHECK-NEXT:    and x0, x0, x16
; CHECK-NEXT:    mov sp, x0
; CHECK-NEXT:    ret
entry:
  %0 = load double, ptr %b, align 16
  %vld1_lane = insertelement <2 x double> <double undef, double 0.000000e+00>, double %0, i32 0
  ret <2 x double> %vld1_lane
}

define i32 @deadload() speculative_load_hardening uwtable {
; CHECK-LABEL: deadload:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp sp, #0
; CHECK-NEXT:    csetm x16, ne
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldr w8, [sp, #12]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    and x0, x0, x16
; CHECK-NEXT:    mov sp, x0
; CHECK-NEXT:    ret
entry:
  %a = alloca i32, align 4
  %val = load volatile i32, ptr %a, align 4
  ret i32 undef
}
