; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=aarch64-none-linux-gnu | FileCheck %s

define i64 @and_bic(i64 %0, i64 %1) {
; CHECK-LABEL: and_bic:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mvn w8, w0
; CHECK-NEXT:    orr x8, x8, #0xffffffffffff00ff
; CHECK-NEXT:    and x0, x8, x1
; CHECK-NEXT:    ret
  %3 = and i64 %0, 65280
  %4 = xor i64 %3, -1
  %5 = and i64 %4, %1
  ret i64 %5
}

define i64 @and_bic2(i32 %0, i64 %1) {
; CHECK-LABEL: and_bic2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mvn w8, w0
; CHECK-NEXT:    orr w8, w8, #0xffff00ff
; CHECK-NEXT:    and x0, x8, x1
; CHECK-NEXT:    ret
  %3 = and i32 %0, 65280
  %4 = xor i32 %3, -1
  %5 = zext i32 %4 to i64
  %6 = and i64 %5, %1
  ret i64 %6
}

define i32 @and_bic3(i32 %0, i32 %1) {
; CHECK-LABEL: and_bic3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mvn w8, w0
; CHECK-NEXT:    orr w8, w8, #0xffff00ff
; CHECK-NEXT:    and w0, w8, w1
; CHECK-NEXT:    ret
  %3 = and i32 %0, 65280
  %4 = xor i32 %3, -1
  %5 = and i32 %4, %1
  ret i32 %5
}

define i64 @and_eon(i64 %0, i64 %1) {
; CHECK-LABEL: and_eon:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0xff00
; CHECK-NEXT:    eon x0, x8, x1
; CHECK-NEXT:    ret
  %3 = and i64 %0, 65280
  %4 = xor i64 %3, %1
  %5 = xor i64 %4, -1
  ret i64 %5
}

define i64 @and_eon2(i32 %0, i64 %1) {
; CHECK-LABEL: and_eon2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mvn w8, w0
; CHECK-NEXT:    orr w8, w8, #0xffff00ff
; CHECK-NEXT:    eor x0, x8, x1
; CHECK-NEXT:    ret
  %3 = and i32 %0, 65280
  %4 = xor i32 %3, -1
  %5 = zext i32 %4 to i64
  %6 = xor i64 %5, %1
  ret i64 %6
}

define i32 @and_eon3(i32 %0, i32 %1) {
; CHECK-LABEL: and_eon3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xff00
; CHECK-NEXT:    eon w0, w8, w1
; CHECK-NEXT:    ret
  %3 = and i32 %0, 65280
  %4 = xor i32 %3, %1
  %5 = xor i32 %4, -1
  ret i32 %5
}

define i64 @and_orn(i64 %0, i64 %1) {
; CHECK-LABEL: and_orn:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orn w8, w1, w0
; CHECK-NEXT:    orr x0, x8, #0xffffffffffff00ff
; CHECK-NEXT:    ret
  %3 = and i64 %0, 65280
  %4 = xor i64 %3, -1
  %5 = or i64 %4, %1
  ret i64 %5
}

define i64 @and_orn2(i32 %0, i64 %1) {
; CHECK-LABEL: and_orn2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mvn w8, w0
; CHECK-NEXT:    orr w8, w8, #0xffff00ff
; CHECK-NEXT:    orr x0, x8, x1
; CHECK-NEXT:    ret
  %3 = and i32 %0, 65280
  %4 = xor i32 %3, -1
  %5 = zext i32 %4 to i64
  %6 = or i64 %5, %1
  ret i64 %6
}

define i32 @and_orn3(i32 %0, i32 %1) {
; CHECK-LABEL: and_orn3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orn w8, w1, w0
; CHECK-NEXT:    orr w0, w8, #0xffff00ff
; CHECK-NEXT:    ret
  %3 = and i32 %0, 65280
  %4 = xor i32 %3, -1
  %5 = or i32 %4, %1
  ret i32 %5
}

define i64 @_Z6or_bic(i64 %0, i64 %1) {
; CHECK-LABEL: _Z6or_bic:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic x8, x1, x0
; CHECK-NEXT:    and x0, x8, #0xffffffffffff00ff
; CHECK-NEXT:    ret
  %3 = and i64 %0, -65281
  %4 = xor i64 %3, -65281
  %5 = and i64 %4, %1
  ret i64 %5
}

define i64 @or_bic2(i32 %0, i64 %1) {
; CHECK-LABEL: or_bic2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-65281
; CHECK-NEXT:    bic w8, w8, w0
; CHECK-NEXT:    and x0, x8, x1
; CHECK-NEXT:    ret
  %3 = and i32 %0, -65281
  %4 = xor i32 %3, -65281
  %5 = zext i32 %4 to i64
  %6 = and i64 %5, %1
  ret i64 %6
}

define i32 @or_bic3(i32 %0, i32 %1) {
; CHECK-LABEL: or_bic3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic w8, w1, w0
; CHECK-NEXT:    and w0, w8, #0xfffff000
; CHECK-NEXT:    ret
  %3 = and i32 %0, -4096
  %4 = xor i32 %3, -4096
  %5 = and i32 %4, %1
  ret i32 %5
}

define i64 @_Z6or_orn(i64 %0, i64 %1) {
; CHECK-LABEL: _Z6or_orn:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4096
; CHECK-NEXT:    bic x8, x8, x0
; CHECK-NEXT:    orr x0, x8, x1
; CHECK-NEXT:    ret
  %3 = and i64 %0, -4096
  %4 = xor i64 %3, -4096
  %5 = or i64 %4, %1
  ret i64 %5
}

define i64 @or_orn2(i32 %0, i64 %1) {
; CHECK-LABEL: or_orn2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-4096
; CHECK-NEXT:    bic w8, w8, w0
; CHECK-NEXT:    orr x0, x8, x1
; CHECK-NEXT:    ret
  %3 = and i32 %0, -4096
  %4 = xor i32 %3, -4096
  %5 = zext i32 %4 to i64
  %6 = or i64 %5, %1
  ret i64 %6
}

define i64 @or_orn3(i32 %0, i64 %1) {
; CHECK-LABEL: or_orn3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-4096
; CHECK-NEXT:    bic w8, w8, w0
; CHECK-NEXT:    orr x0, x8, x1
; CHECK-NEXT:    ret
  %3 = and i32 %0, -4096
  %4 = xor i32 %3, -4096
  %5 = zext i32 %4 to i64
  %6 = or i64 %5, %1
  ret i64 %6
}

define i64 @_Z6or_eon(i64 %0, i64 %1) {
; CHECK-LABEL: _Z6or_eon:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x0, #0xfffffffffffff000
; CHECK-NEXT:    eor x8, x8, x1
; CHECK-NEXT:    eor x0, x8, #0xfffffffffffff000
; CHECK-NEXT:    ret
  %3 = and i64 %0, -4096
  %4 = xor i64 %3, %1
  %5 = xor i64 %4, -4096
  ret i64 %5
}

define i64 @or_eon2(i32 %0, i64 %1) {
; CHECK-LABEL: or_eon2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-4096
; CHECK-NEXT:    bic w8, w8, w0
; CHECK-NEXT:    eor x0, x8, x1
; CHECK-NEXT:    ret
  %3 = and i32 %0, -4096
  %4 = xor i32 %3, -4096
  %5 = zext i32 %4 to i64
  %6 = xor i64 %5, %1
  ret i64 %6
}

define i64 @or_eon3(i32 %0, i64 %1) {
; CHECK-LABEL: or_eon3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-4096
; CHECK-NEXT:    bic w8, w8, w0
; CHECK-NEXT:    eor x0, x8, x1
; CHECK-NEXT:    ret
  %3 = and i32 %0, -4096
  %4 = xor i32 %3, -4096
  %5 = zext i32 %4 to i64
  %6 = xor i64 %5, %1
  ret i64 %6
}
