; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S < %s | FileCheck %s
declare void @use_i8(i8)
define i8 @mul_selectp2_x(i8 %x, i1 %c) {
; CHECK-LABEL: @mul_selectp2_x(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[C:%.*]], i8 1, i8 2
; CHECK-NEXT:    [[R:%.*]] = shl i8 [[X:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %s = select i1 %c, i8 2, i8 4
  %r = mul i8 %s, %x
  ret i8 %r
}


define i8 @mul_selectp2_x_propegate_nuw(i8 %x, i1 %c) {
; CHECK-LABEL: @mul_selectp2_x_propegate_nuw(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[C:%.*]], i8 1, i8 2
; CHECK-NEXT:    [[R:%.*]] = shl nuw i8 [[X:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %s = select i1 %c, i8 2, i8 4
  %r = mul nuw nsw i8 %s, %x
  ret i8 %r
}


define i8 @mul_selectp2_x_multiuse_fixme(i8 %x, i1 %c) {
; CHECK-LABEL: @mul_selectp2_x_multiuse_fixme(
; CHECK-NEXT:    [[S:%.*]] = select i1 [[C:%.*]], i8 2, i8 4
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[C]], i8 1, i8 2
; CHECK-NEXT:    [[R:%.*]] = shl i8 [[X:%.*]], [[TMP1]]
; CHECK-NEXT:    call void @use_i8(i8 [[S]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %s = select i1 %c, i8 2, i8 4
  %r = mul i8 %s, %x
  call void @use_i8(i8 %s)
  ret i8 %r
}

define i8 @mul_selectp2_x_non_const(i8 %x, i1 %c, i8 %yy) {
; CHECK-LABEL: @mul_selectp2_x_non_const(
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[C:%.*]], i8 1, i8 [[YY:%.*]]
; CHECK-NEXT:    [[R:%.*]] = shl i8 [[X:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %y = shl i8 1, %yy
  %s = select i1 %c, i8 2, i8 %y
  %r = mul i8 %s, %x
  ret i8 %r
}

define i8 @mul_selectp2_x_non_const_multiuse(i8 %x, i1 %c, i8 %yy) {
; CHECK-LABEL: @mul_selectp2_x_non_const_multiuse(
; CHECK-NEXT:    [[Y:%.*]] = shl nuw i8 1, [[YY:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[C:%.*]], i8 1, i8 [[YY]]
; CHECK-NEXT:    [[R:%.*]] = shl i8 [[X:%.*]], [[TMP1]]
; CHECK-NEXT:    call void @use_i8(i8 [[Y]])
; CHECK-NEXT:    ret i8 [[R]]
;
  %y = shl i8 1, %yy
  %s = select i1 %c, i8 2, i8 %y
  %r = mul i8 %s, %x
  call void @use_i8(i8 %y)
  ret i8 %r
}

define i8 @mul_x_selectp2(i8 %xx, i1 %c) {
; CHECK-LABEL: @mul_x_selectp2(
; CHECK-NEXT:    [[X:%.*]] = mul i8 [[XX:%.*]], [[XX]]
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[C:%.*]], i8 3, i8 0
; CHECK-NEXT:    [[R:%.*]] = shl i8 [[X]], [[TMP1]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %x = mul i8 %xx, %xx
  %s = select i1 %c, i8 8, i8 1
  %r = mul i8 %x, %s
  ret i8 %r
}

define i8 @mul_select_nonp2_x_fail(i8 %x, i1 %c) {
; CHECK-LABEL: @mul_select_nonp2_x_fail(
; CHECK-NEXT:    [[S:%.*]] = select i1 [[C:%.*]], i8 2, i8 5
; CHECK-NEXT:    [[R:%.*]] = mul i8 [[S]], [[X:%.*]]
; CHECK-NEXT:    ret i8 [[R]]
;
  %s = select i1 %c, i8 2, i8 5
  %r = mul i8 %s, %x
  ret i8 %r
}

define <2 x i8> @mul_x_selectp2_vec(<2 x i8> %xx, i1 %c) {
; CHECK-LABEL: @mul_x_selectp2_vec(
; CHECK-NEXT:    [[X:%.*]] = mul <2 x i8> [[XX:%.*]], [[XX]]
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[C:%.*]], <2 x i8> <i8 3, i8 4>, <2 x i8> <i8 2, i8 0>
; CHECK-NEXT:    [[R:%.*]] = shl <2 x i8> [[X]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i8> [[R]]
;
  %x = mul <2 x i8> %xx, %xx
  %s = select i1 %c, <2 x i8> <i8 8, i8 16>, <2 x i8> <i8 4, i8 1>
  %r = mul <2 x i8> %x, %s
  ret <2 x i8> %r
}


define i8 @shl_add_log_may_cause_poison_pr62175_fail(i8 %x, i8 %y) {
; CHECK-LABEL: @shl_add_log_may_cause_poison_pr62175_fail(
; CHECK-NEXT:    [[SHL:%.*]] = shl i8 4, [[X:%.*]]
; CHECK-NEXT:    [[MUL:%.*]] = mul i8 [[Y:%.*]], [[SHL]]
; CHECK-NEXT:    ret i8 [[MUL]]
;
  %shl = shl i8 4, %x
  %mul = mul i8 %y, %shl
  ret i8 %mul
}

define i8 @shl_add_log_may_cause_poison_pr62175_with_nuw(i8 %x, i8 %y) {
; CHECK-LABEL: @shl_add_log_may_cause_poison_pr62175_with_nuw(
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[X:%.*]], 2
; CHECK-NEXT:    [[MUL:%.*]] = shl i8 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i8 [[MUL]]
;
  %shl = shl nuw i8 4, %x
  %mul = mul i8 %y, %shl
  ret i8 %mul
}

define i8 @shl_add_log_may_cause_poison_pr62175_with_nsw(i8 %x, i8 %y) {
; CHECK-LABEL: @shl_add_log_may_cause_poison_pr62175_with_nsw(
; CHECK-NEXT:    [[TMP1:%.*]] = add i8 [[X:%.*]], 2
; CHECK-NEXT:    [[MUL:%.*]] = shl i8 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i8 [[MUL]]
;
  %shl = shl nsw i8 4, %x
  %mul = mul i8 %y, %shl
  ret i8 %mul
}
