; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test that we are able to generate the Xqcibi instructions
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32I
; RUN: llc -mtriple=riscv32 -mattr=+experimental-xqcibi -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32IXQCIBI

define i32 @beqimm(i32 %a) {
; RV32I-LABEL: beqimm:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, -16
; RV32I-NEXT:    beq a0, a1, .LBB0_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB0_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: beqimm:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.beqi a0, -16, .LBB0_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB0_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp eq i32 %a, -16
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @bneimm(i32 %a) {
; RV32I-LABEL: bneimm:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 15
; RV32I-NEXT:    bne a0, a1, .LBB1_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB1_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: bneimm:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.bnei a0, 15, .LBB1_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB1_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp ne i32 %a, 15
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @bltimm(i32 %a) {
; RV32I-LABEL: bltimm:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 5
; RV32I-NEXT:    blt a0, a1, .LBB2_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB2_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: bltimm:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.blti a0, 5, .LBB2_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB2_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp slt i32 %a, 5
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @bgeimm(i32 %a) {
; RV32I-LABEL: bgeimm:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, -6
; RV32I-NEXT:    blt a1, a0, .LBB3_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB3_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: bgeimm:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.bgei a0, -5, .LBB3_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB3_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp sge i32 %a, -5
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @bltuimm(i32 %a) {
; RV32I-LABEL: bltuimm:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 31
; RV32I-NEXT:    bltu a0, a1, .LBB4_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB4_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: bltuimm:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.bltui a0, 31, .LBB4_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB4_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp ult i32 %a, 31
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @bgeuimm(i32 %a) {
; RV32I-LABEL: bgeuimm:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 9
; RV32I-NEXT:    bltu a1, a0, .LBB5_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB5_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: bgeuimm:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.bgeui a0, 10, .LBB5_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB5_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp uge i32 %a, 10
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @beqimm16(i32 %a) {
; RV32I-LABEL: beqimm16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 1048568
; RV32I-NEXT:    beq a0, a1, .LBB6_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB6_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: beqimm16:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.e.beqi a0, -32768, .LBB6_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB6_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp eq i32 %a, -32768
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @bneimm16(i32 %a) {
; RV32I-LABEL: bneimm16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 8
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    bne a0, a1, .LBB7_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB7_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: bneimm16:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.e.bnei a0, 32767, .LBB7_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB7_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp ne i32 %a, 32767
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @bltimm16(i32 %a) {
; RV32I-LABEL: bltimm16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, -35
; RV32I-NEXT:    blt a0, a1, .LBB8_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB8_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: bltimm16:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.e.blti a0, -35, .LBB8_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB8_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp slt i32 %a, -35
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @bgeimm16(i32 %a) {
; RV32I-LABEL: bgeimm16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 254
; RV32I-NEXT:    blt a1, a0, .LBB9_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB9_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: bgeimm16:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.e.bgei a0, 255, .LBB9_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB9_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp sge i32 %a, 255
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @bltuimm16(i32 %a) {
; RV32I-LABEL: bltuimm16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    bltu a0, a1, .LBB10_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB10_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: bltuimm16:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.e.bltui a0, 65535, .LBB10_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB10_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp ult i32 %a, 65535
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i32 @bgeuimm16(i32 %a) {
; RV32I-LABEL: bgeuimm16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 99
; RV32I-NEXT:    bltu a1, a0, .LBB11_2
; RV32I-NEXT:  # %bb.1: # %f
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB11_2: # %t
; RV32I-NEXT:    li a0, 1
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: bgeuimm16:
; RV32IXQCIBI:       # %bb.0:
; RV32IXQCIBI-NEXT:    qc.e.bgeui a0, 100, .LBB11_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %f
; RV32IXQCIBI-NEXT:    li a0, 0
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB11_2: # %t
; RV32IXQCIBI-NEXT:    li a0, 1
; RV32IXQCIBI-NEXT:    ret
  %1 = icmp uge i32 %a, 100
  br i1 %1, label %t, label %f, !prof !0
f:
  ret i32 0
t:
  ret i32 1
}

define i1 @selectcc(i64 %0) {
; RV32I-LABEL: selectcc:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    li a2, 512
; RV32I-NEXT:    beq a1, a2, .LBB12_2
; RV32I-NEXT:  # %bb.1: # %entry
; RV32I-NEXT:    sltiu a0, a1, 513
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB12_2:
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV32IXQCIBI-LABEL: selectcc:
; RV32IXQCIBI:       # %bb.0: # %entry
; RV32IXQCIBI-NEXT:    qc.e.beqi a1, 512, .LBB12_2
; RV32IXQCIBI-NEXT:  # %bb.1: # %entry
; RV32IXQCIBI-NEXT:    sltiu a0, a1, 513
; RV32IXQCIBI-NEXT:    xori a0, a0, 1
; RV32IXQCIBI-NEXT:    ret
; RV32IXQCIBI-NEXT:  .LBB12_2:
; RV32IXQCIBI-NEXT:    snez a0, a0
; RV32IXQCIBI-NEXT:    ret
entry:
  %cmp10.i = icmp ugt i64 %0, 2199023255552
  ret i1 %cmp10.i
}

!0 = !{!"branch_weights", i32 1, i32 99}
