; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple=riscv32 -mattr=+zfa,+zfh -global-isel < %s \
; RUN: | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+zfa,+zfh -global-isel < %s \
; RUN: | FileCheck %s


define half @fceil(half %a) {
; CHECK-LABEL: fceil:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.h fa0, fa0, rup
; CHECK-NEXT:    ret
  %b = call half @llvm.ceil.f16(half %a)
  ret half %b
}

define half @ffloor(half %a) {
; CHECK-LABEL: ffloor:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.h fa0, fa0, rdn
; CHECK-NEXT:    ret
  %b = call half @llvm.floor.f16(half %a)
  ret half %b
}

define half @frint(half %a) {
; CHECK-LABEL: frint:
; CHECK:       # %bb.0:
; CHECK-NEXT:    froundnx.h fa0, fa0
; CHECK-NEXT:    ret
  %b = call half @llvm.rint.f16(half %a)
  ret half %b
}

define half @fnearbyint(half %a) {
; CHECK-LABEL: fnearbyint:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.h fa0, fa0
; CHECK-NEXT:    ret
  %b = call half @llvm.nearbyint.f16(half %a)
  ret half %b
}

define half @fround(half %a) {
; CHECK-LABEL: fround:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.h fa0, fa0, rmm
; CHECK-NEXT:    ret
  %b = call half @llvm.round.f16(half %a)
  ret half %b
}

define half @froundeven(half %a) {
; CHECK-LABEL: froundeven:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.h fa0, fa0, rne
; CHECK-NEXT:    ret
  %b = call half @llvm.roundeven.f16(half %a)
  ret half %b
}

define half @ftrunc(half %a) {
; CHECK-LABEL: ftrunc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fround.h fa0, fa0, rtz
; CHECK-NEXT:    ret
  %b = call half @llvm.trunc.f16(half %a)
  ret half %b
}

define half @fmaximum(half %a, half %b) {
; CHECK-LABEL: fmaximum:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmaxm.h fa0, fa0, fa1
; CHECK-NEXT:    ret
  %c = call half @llvm.maximum.f16(half %a, half %b)
  ret half %c
}

define half @fminimum(half %a, half %b) {
; CHECK-LABEL: fminimum:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fminm.h fa0, fa0, fa1
; CHECK-NEXT:    ret
  %c = call half @llvm.minimum.f16(half %a, half %b)
  ret half %c
}
