; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT

declare float @llvm.log.f32(float)
declare float @llvm.log2.f32(float)
declare float @llvm.log10.f32(float)

declare <2 x float> @llvm.log.v2f32(<2 x float>)
declare float @llvm.experimental.constrained.log.f32(float, metadata, metadata)
declare float @llvm.experimental.constrained.log2.f32(float, metadata, metadata)
declare float @llvm.experimental.constrained.log10.f32(float, metadata, metadata)

define float @ret_log(float %arg) #0 {
; CHECK-LABEL: define float @ret_log
; CHECK-SAME: (float [[ARG:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.log.f32(float [[ARG]]) #[[ATTR10:[0-9]+]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_noinf(float nofpclass(inf) %arg) #0 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_noinf
; CHECK-SAME: (float nofpclass(inf) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_noneg(float nofpclass(ninf nsub nnorm) %arg) #0 {
; CHECK-LABEL: define float @ret_log_noneg
; CHECK-SAME: (float nofpclass(ninf nsub nnorm) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.log.f32(float nofpclass(ninf nsub nnorm) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_noneg_nonan(float nofpclass(ninf nsub nnorm nan) %arg) #0 {
; CHECK-LABEL: define nofpclass(nan) float @ret_log_noneg_nonan
; CHECK-SAME: (float nofpclass(nan ninf nsub nnorm) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nan) float @llvm.log.f32(float nofpclass(nan ninf nsub nnorm) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_noinf_noneg(float nofpclass(inf nsub nnorm) %arg) #0 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_noinf_noneg
; CHECK-SAME: (float nofpclass(inf nsub nnorm) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf nsub nnorm) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_noinf_noneg_nonan(float nofpclass(inf nsub nnorm nan) %arg) #0 {
; CHECK-LABEL: define nofpclass(nan pinf) float @ret_log_noinf_noneg_nonan
; CHECK-SAME: (float nofpclass(nan inf nsub nnorm) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nan pinf) float @llvm.log.f32(float nofpclass(nan inf nsub nnorm) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_nopinf(float nofpclass(pinf) %arg) #0 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_nopinf
; CHECK-SAME: (float nofpclass(pinf) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(pinf) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_noninf(float nofpclass(ninf) %arg) #0 {
; CHECK-LABEL: define float @ret_log_noninf
; CHECK-SAME: (float nofpclass(ninf) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.log.f32(float nofpclass(ninf) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_nonan(float nofpclass(nan) %arg) #0 {
; CHECK-LABEL: define float @ret_log_nonan
; CHECK-SAME: (float nofpclass(nan) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.log.f32(float nofpclass(nan) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_nonan_noinf(float nofpclass(nan inf) %arg) #0 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_nonan_noinf
; CHECK-SAME: (float nofpclass(nan inf) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(nan inf) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_nonan_noinf_nozero(float nofpclass(nan inf zero) %arg) #0 {
; CHECK-LABEL: define nofpclass(inf) float @ret_log_nonan_noinf_nozero
; CHECK-SAME: (float nofpclass(nan inf zero) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(inf) float @llvm.log.f32(float nofpclass(nan inf zero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_noinf_nozero(float nofpclass(inf zero) %arg) #0 {
; CHECK-LABEL: define nofpclass(inf) float @ret_log_noinf_nozero
; CHECK-SAME: (float nofpclass(inf zero) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(inf) float @llvm.log.f32(float nofpclass(inf zero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_noinf_nonegzero(float nofpclass(inf nzero) %arg) #0 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_noinf_nonegzero
; CHECK-SAME: (float nofpclass(inf nzero) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf nzero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_positive_source(i32 %arg) #0 {
; CHECK-LABEL: define nofpclass(nan pinf) float @ret_log_positive_source
; CHECK-SAME: (i32 [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[UITOFP:%.*]] = uitofp i32 [[ARG]] to float
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nan pinf) float @llvm.log.f32(float [[UITOFP]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %uitofp = uitofp i32 %arg to float
  %call = call float @llvm.log.f32(float %uitofp)
  ret float %call
}

; Could produce a nan because we don't know if the multiply is negative.
define float @ret_log_unknown_sign(float nofpclass(nan) %arg, float nofpclass(nan) %arg1) #0 {
; CHECK-LABEL: define float @ret_log_unknown_sign
; CHECK-SAME: (float nofpclass(nan) [[ARG:%.*]], float nofpclass(nan) [[ARG1:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[UNKNOWN_SIGN_NOT_NAN:%.*]] = fmul nnan float [[ARG]], [[ARG1]]
; CHECK-NEXT:    [[CALL:%.*]] = call float @llvm.log.f32(float [[UNKNOWN_SIGN_NOT_NAN]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %unknown.sign.not.nan = fmul nnan float %arg, %arg1
  %call = call float @llvm.log.f32(float %unknown.sign.not.nan)
  ret float %call
}

define float @ret_log_daz_noinf_nozero(float nofpclass(inf zero) %arg) #1 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_daz_noinf_nozero
; CHECK-SAME: (float nofpclass(inf zero) [[ARG:%.*]]) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf zero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define <2 x float> @ret_log_daz_noinf_nozero_v2f32(<2 x float> nofpclass(inf zero) %arg) #1 {
; CHECK-LABEL: define nofpclass(pinf) <2 x float> @ret_log_daz_noinf_nozero_v2f32
; CHECK-SAME: (<2 x float> nofpclass(inf zero) [[ARG:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) <2 x float> @llvm.log.v2f32(<2 x float> nofpclass(inf zero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret <2 x float> [[CALL]]
;
  %call = call <2 x float> @llvm.log.v2f32(<2 x float> %arg)
  ret <2 x float> %call
}

define float @ret_log_daz_noinf_nonegzero(float nofpclass(inf nzero) %arg) #1 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_daz_noinf_nonegzero
; CHECK-SAME: (float nofpclass(inf nzero) [[ARG:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf nzero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_dapz_noinf_nozero(float nofpclass(inf zero) %arg) #2 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_dapz_noinf_nozero
; CHECK-SAME: (float nofpclass(inf zero) [[ARG:%.*]]) #[[ATTR4:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf zero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_dapz_noinf_nonegzero(float nofpclass(inf nzero) %arg) #2 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_dapz_noinf_nonegzero
; CHECK-SAME: (float nofpclass(inf nzero) [[ARG:%.*]]) #[[ATTR4]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf nzero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_dynamic_noinf_nozero(float nofpclass(inf zero) %arg) #3 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_dynamic_noinf_nozero
; CHECK-SAME: (float nofpclass(inf zero) [[ARG:%.*]]) #[[ATTR5:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf zero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_dynamic_noinf_nonegzero(float nofpclass(inf nzero) %arg) #3 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_dynamic_noinf_nonegzero
; CHECK-SAME: (float nofpclass(inf nzero) [[ARG:%.*]]) #[[ATTR5]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf nzero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_ftz_noinf_nonegzero(float nofpclass(inf nzero) %arg) #4 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_ftz_noinf_nonegzero
; CHECK-SAME: (float nofpclass(inf nzero) [[ARG:%.*]]) #[[ATTR6:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf nzero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_ftpz_noinf_nonegzero(float nofpclass(inf nzero) %arg) #5 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_ftpz_noinf_nonegzero
; CHECK-SAME: (float nofpclass(inf nzero) [[ARG:%.*]]) #[[ATTR7:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf nzero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @ret_log_ftz_dynamic_noinf_nonegzero(float nofpclass(inf nzero) %arg) #6 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log_ftz_dynamic_noinf_nonegzero
; CHECK-SAME: (float nofpclass(inf nzero) [[ARG:%.*]]) #[[ATTR8:[0-9]+]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log.f32(float nofpclass(inf nzero) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log.f32(float %arg)
  ret float %call
}

define float @constrained_log(float %arg) strictfp {
; CHECK-LABEL: define float @constrained_log
; CHECK-SAME: (float [[ARG:%.*]]) #[[ATTR9:[0-9]+]] {
; CHECK-NEXT:    [[VAL:%.*]] = call float @llvm.experimental.constrained.log.f32(float [[ARG]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR11:[0-9]+]]
; CHECK-NEXT:    ret float [[VAL]]
;
  %val = call float @llvm.experimental.constrained.log.f32(float %arg, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret float %val
}

define float @constrained_log_nonan(float nofpclass(nan) %arg) strictfp {
; CHECK-LABEL: define float @constrained_log_nonan
; CHECK-SAME: (float nofpclass(nan) [[ARG:%.*]]) #[[ATTR9]] {
; CHECK-NEXT:    [[VAL:%.*]] = call float @llvm.experimental.constrained.log.f32(float nofpclass(nan) [[ARG]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR11]]
; CHECK-NEXT:    ret float [[VAL]]
;
  %val = call float @llvm.experimental.constrained.log.f32(float %arg, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret float %val
}

define float @constrained_log_nopinf(float nofpclass(pinf) %arg) strictfp {
; CHECK-LABEL: define nofpclass(pinf) float @constrained_log_nopinf
; CHECK-SAME: (float nofpclass(pinf) [[ARG:%.*]]) #[[ATTR9]] {
; CHECK-NEXT:    [[VAL:%.*]] = call nofpclass(pinf) float @llvm.experimental.constrained.log.f32(float nofpclass(pinf) [[ARG]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR11]]
; CHECK-NEXT:    ret float [[VAL]]
;
  %val = call float @llvm.experimental.constrained.log.f32(float %arg, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret float %val
}

define float @constrained_log_nonegzero(float nofpclass(nzero) %arg) strictfp {
; CHECK-LABEL: define float @constrained_log_nonegzero
; CHECK-SAME: (float nofpclass(nzero) [[ARG:%.*]]) #[[ATTR9]] {
; CHECK-NEXT:    [[VAL:%.*]] = call float @llvm.experimental.constrained.log.f32(float nofpclass(nzero) [[ARG]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR11]]
; CHECK-NEXT:    ret float [[VAL]]
;
  %val = call float @llvm.experimental.constrained.log.f32(float %arg, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret float %val
}

define float @constrained_log_nozero(float nofpclass(zero) %arg) strictfp {
; CHECK-LABEL: define nofpclass(ninf) float @constrained_log_nozero
; CHECK-SAME: (float nofpclass(zero) [[ARG:%.*]]) #[[ATTR9]] {
; CHECK-NEXT:    [[VAL:%.*]] = call nofpclass(ninf) float @llvm.experimental.constrained.log.f32(float nofpclass(zero) [[ARG]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR11]]
; CHECK-NEXT:    ret float [[VAL]]
;
  %val = call float @llvm.experimental.constrained.log.f32(float %arg, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret float %val
}

define float @ret_log2_noinf_noneg(float nofpclass(inf nsub nnorm) %arg) #0 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log2_noinf_noneg
; CHECK-SAME: (float nofpclass(inf nsub nnorm) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log2.f32(float nofpclass(inf nsub nnorm) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log2.f32(float %arg)
  ret float %call
}

define float @ret_log2_noinf_noneg_nonan(float nofpclass(inf nsub nnorm nan) %arg) #0 {
; CHECK-LABEL: define nofpclass(nan pinf) float @ret_log2_noinf_noneg_nonan
; CHECK-SAME: (float nofpclass(nan inf nsub nnorm) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(nan pinf) float @llvm.log2.f32(float nofpclass(nan inf nsub nnorm) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log2.f32(float %arg)
  ret float %call
}

define float @ret_log2_noinf_noneg_noqnan(float nofpclass(inf nsub nnorm qnan) %arg) #0 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log2_noinf_noneg_noqnan
; CHECK-SAME: (float nofpclass(qnan inf nsub nnorm) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log2.f32(float nofpclass(qnan inf nsub nnorm) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log2.f32(float %arg)
  ret float %call
}

define float @ret_log2_noinf_noneg_nosnan(float nofpclass(inf nsub nnorm snan) %arg) #0 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log2_noinf_noneg_nosnan
; CHECK-SAME: (float nofpclass(snan inf nsub nnorm) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log2.f32(float nofpclass(snan inf nsub nnorm) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log2.f32(float %arg)
  ret float %call
}

define float @ret_log10_noinf_noneg(float nofpclass(inf nsub nnorm) %arg) #0 {
; CHECK-LABEL: define nofpclass(pinf) float @ret_log10_noinf_noneg
; CHECK-SAME: (float nofpclass(inf nsub nnorm) [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.log10.f32(float nofpclass(inf nsub nnorm) [[ARG]]) #[[ATTR10]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.log10.f32(float %arg)
  ret float %call
}

define float @ret_constrained_log2_noinf_noneg(float nofpclass(inf nsub nnorm) %arg) strictfp {
; CHECK-LABEL: define nofpclass(pinf) float @ret_constrained_log2_noinf_noneg
; CHECK-SAME: (float nofpclass(inf nsub nnorm) [[ARG:%.*]]) #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.experimental.constrained.log2.f32(float nofpclass(inf nsub nnorm) [[ARG]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR11]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.experimental.constrained.log2.f32(float %arg, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret float %call
}

define float @ret_constrained_log10_noinf_noneg(float nofpclass(inf nsub nnorm) %arg) strictfp {
; CHECK-LABEL: define nofpclass(pinf) float @ret_constrained_log10_noinf_noneg
; CHECK-SAME: (float nofpclass(inf nsub nnorm) [[ARG:%.*]]) #[[ATTR9]] {
; CHECK-NEXT:    [[CALL:%.*]] = call nofpclass(pinf) float @llvm.experimental.constrained.log10.f32(float nofpclass(inf nsub nnorm) [[ARG]], metadata !"round.dynamic", metadata !"fpexcept.strict") #[[ATTR11]]
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = call float @llvm.experimental.constrained.log10.f32(float %arg, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret float %call
}

attributes #0 = { "denormal-fp-math"="ieee,ieee" }
attributes #1 = { "denormal-fp-math"="ieee,preserve-sign" }
attributes #2 = { "denormal-fp-math"="ieee,positive-zero" }
attributes #3 = { "denormal-fp-math"="ieee,dynamic" }
attributes #4 = { "denormal-fp-math"="preserve-sign,ieee" }
attributes #5 = { "denormal-fp-math"="positive-zero,ieee" }
attributes #6 = { "denormal-fp-math"="dynamic,ieee" }

;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; TUNIT: {{.*}}
