"""British Color Standard

This module contains colors defined in one of the British Standards
for colors, BS381C. This standard specifies colors used in identification,
coding, and other special purposes. See https://www.britishstandardcolour.com/
for more information.

To use the colors from this list, access them directly from the module (which
is exposed to Manim's global name space):

.. code:: pycon

    >>> from manim import BS381
    >>> BS381.OXFORD_BLUE
    ManimColor('#1F3057')

List of Color Constants
-----------------------

These hex values (taken from https://www.w3schools.com/colors/colors_british.asp)
are non official approximate values intended to simulate the ones defined
in the standard:

.. automanimcolormodule:: manim.utils.color.BS381

"""

from __future__ import annotations

from .core import ManimColor

BS381_101 = ManimColor("#94BFAC")
SKY_BLUE = ManimColor("#94BFAC")
BS381_102 = ManimColor("#5B9291")
TURQUOISE_BLUE = ManimColor("#5B9291")
BS381_103 = ManimColor("#3B6879")
PEACOCK_BLUE = ManimColor("#3B6879")
BS381_104 = ManimColor("#264D7E")
AZURE_BLUE = ManimColor("#264D7E")
BS381_105 = ManimColor("#1F3057")
OXFORD_BLUE = ManimColor("#1F3057")
BS381_106 = ManimColor("#2A283D")
ROYAL_BLUE = ManimColor("#2A283D")
BS381_107 = ManimColor("#3A73A9")
STRONG_BLUE = ManimColor("#3A73A9")
BS381_108 = ManimColor("#173679")
AIRCRAFT_BLUE = ManimColor("#173679")
BS381_109 = ManimColor("#1C5680")
MIDDLE_BLUE = ManimColor("#1C5680")
BS381_110 = ManimColor("#2C3E75")
ROUNDEL_BLUE = ManimColor("#2C3E75")
BS381_111 = ManimColor("#8CC5BB")
PALE_BLUE = ManimColor("#8CC5BB")
BS381_112 = ManimColor("#78ADC2")
ARCTIC_BLUE = ManimColor("#78ADC2")
FIESTA_BLUE = ManimColor("#78ADC2")
BS381_113 = ManimColor("#3F687D")
DEEP_SAXE_BLUE = ManimColor("#3F687D")
BS381_114 = ManimColor("#1F4B61")
RAIL_BLUE = ManimColor("#1F4B61")
BS381_115 = ManimColor("#5F88C1")
COBALT_BLUE = ManimColor("#5F88C1")
BS381_166 = ManimColor("#2458AF")
FRENCH_BLUE = ManimColor("#2458AF")
BS381_169 = ManimColor("#135B75")
TRAFFIC_BLUE = ManimColor("#135B75")
BS381_172 = ManimColor("#A7C6EB")
PALE_ROUNDEL_BLUE = ManimColor("#A7C6EB")
BS381_174 = ManimColor("#64A0AA")
ORIENT_BLUE = ManimColor("#64A0AA")
BS381_175 = ManimColor("#4F81C5")
LIGHT_FRENCH_BLUE = ManimColor("#4F81C5")
BS381_210 = ManimColor("#BBC9A5")
SKY = ManimColor("#BBC9A5")
BS381_216 = ManimColor("#BCD890")
EAU_DE_NIL = ManimColor("#BCD890")
BS381_217 = ManimColor("#96BF65")
SEA_GREEN = ManimColor("#96BF65")
BS381_218 = ManimColor("#698B47")
GRASS_GREEN = ManimColor("#698B47")
BS381_219 = ManimColor("#757639")
SAGE_GREEN = ManimColor("#757639")
BS381_220 = ManimColor("#4B5729")
OLIVE_GREEN = ManimColor("#4B5729")
BS381_221 = ManimColor("#507D3A")
BRILLIANT_GREEN = ManimColor("#507D3A")
BS381_222 = ManimColor("#6A7031")
LIGHT_BRONZE_GREEN = ManimColor("#6A7031")
BS381_223 = ManimColor("#49523A")
MIDDLE_BRONZE_GREEN = ManimColor("#49523A")
BS381_224 = ManimColor("#3E4630")
DEEP_BRONZE_GREEN = ManimColor("#3E4630")
BS381_225 = ManimColor("#406A28")
LIGHT_BRUNSWICK_GREEN = ManimColor("#406A28")
BS381_226 = ManimColor("#33533B")
MID_BRUNSWICK_GREEN = ManimColor("#33533B")
BS381_227 = ManimColor("#254432")
DEEP_BRUNSWICK_GREEN = ManimColor("#254432")
BS381_228 = ManimColor("#428B64")
EMERALD_GREEN = ManimColor("#428B64")
BS381_241 = ManimColor("#4F5241")
DARK_GREEN = ManimColor("#4F5241")
BS381_262 = ManimColor("#44945E")
BOLD_GREEN = ManimColor("#44945E")
BS381_267 = ManimColor("#476A4C")
DEEP_CHROME_GREEN = ManimColor("#476A4C")
TRAFFIC_GREEN = ManimColor("#476A4C")
BS381_275 = ManimColor("#8FC693")
OPALINE_GREEN = ManimColor("#8FC693")
BS381_276 = ManimColor("#2E4C1E")
LINCON_GREEN = ManimColor("#2E4C1E")
BS381_277 = ManimColor("#364A20")
CYPRESS_GREEN = ManimColor("#364A20")
BS381_278 = ManimColor("#87965A")
LIGHT_OLIVE_GREEN = ManimColor("#87965A")
BS381_279 = ManimColor("#3B3629")
STEEL_FURNITURE_GREEN = ManimColor("#3B3629")
BS381_280 = ManimColor("#68AB77")
VERDIGRIS_GREEN = ManimColor("#68AB77")
BS381_282 = ManimColor("#506B52")
FOREST_GREEN = ManimColor("#506B52")
BS381_283 = ManimColor("#7E8F6E")
AIRCRAFT_GREY_GREEN = ManimColor("#7E8F6E")
BS381_284 = ManimColor("#6B6F5A")
SPRUCE_GREEN = ManimColor("#6B6F5A")
BS381_285 = ManimColor("#5F5C4B")
NATO_GREEN = ManimColor("#5F5C4B")
BS381_298 = ManimColor("#4F5138")
OLIVE_DRAB = ManimColor("#4F5138")
BS381_309 = ManimColor("#FEEC04")
CANARY_YELLOW = ManimColor("#FEEC04")
BS381_310 = ManimColor("#FEF963")
PRIMROSE = ManimColor("#FEF963")
BS381_315 = ManimColor("#FEF96A")
GRAPEFRUIT = ManimColor("#FEF96A")
BS381_320 = ManimColor("#9E7339")
LIGHT_BROWN = ManimColor("#9E7339")
BS381_337 = ManimColor("#4C4A3C")
VERY_DARK_DRAB = ManimColor("#4C4A3C")
BS381_350 = ManimColor("#7B6B4F")
DARK_EARTH = ManimColor("#7B6B4F")
BS381_352 = ManimColor("#FCED96")
PALE_CREAM = ManimColor("#FCED96")
BS381_353 = ManimColor("#FDF07A")
DEEP_CREAM = ManimColor("#FDF07A")
BS381_354 = ManimColor("#E9BB43")
PRIMROSE_2 = ManimColor("#E9BB43")
BS381_355 = ManimColor("#FDD906")
LEMON = ManimColor("#FDD906")
BS381_356 = ManimColor("#FCC808")
GOLDEN_YELLOW = ManimColor("#FCC808")
BS381_358 = ManimColor("#F6C870")
LIGHT_BUFF = ManimColor("#F6C870")
BS381_359 = ManimColor("#DBAC50")
MIDDLE_BUFF = ManimColor("#DBAC50")
BS381_361 = ManimColor("#D4B97D")
LIGHT_STONE = ManimColor("#D4B97D")
BS381_362 = ManimColor("#AC7C42")
MIDDLE_STONE = ManimColor("#AC7C42")
BS381_363 = ManimColor("#FDE706")
BOLD_YELLOW = ManimColor("#FDE706")
BS381_364 = ManimColor("#CEC093")
PORTLAND_STONE = ManimColor("#CEC093")
BS381_365 = ManimColor("#F4F0BD")
VELLUM = ManimColor("#F4F0BD")
BS381_366 = ManimColor("#F5E7A1")
LIGHT_BEIGE = ManimColor("#F5E7A1")
BS381_367 = ManimColor("#FEF6BF")
MANILLA = ManimColor("#fef6bf")
BS381_368 = ManimColor("#DD7B00")
TRAFFIC_YELLOW = ManimColor("#DD7B00")
BS381_369 = ManimColor("#FEEBA8")
BISCUIT = ManimColor("#feeba8")
BS381_380 = ManimColor("#BBA38A")
CAMOUFLAGE_DESERT_SAND = ManimColor("#BBA38A")
BS381_384 = ManimColor("#EEDFA5")
LIGHT_STRAW = ManimColor("#EEDFA5")
BS381_385 = ManimColor("#E8C88F")
LIGHT_BISCUIT = ManimColor("#E8C88F")
BS381_386 = ManimColor("#E6C18D")
CHAMPAGNE = ManimColor("#e6c18d")
BS381_387 = ManimColor("#CFB48A")
SUNRISE = ManimColor("#cfb48a")
SUNSHINE = ManimColor("#cfb48a")
BS381_388 = ManimColor("#E4CF93")
BEIGE = ManimColor("#e4cf93")
BS381_389 = ManimColor("#B2A788")
CAMOUFLAGE_BEIGE = ManimColor("#B2A788")
BS381_397 = ManimColor("#F3D163")
JASMINE_YELLOW = ManimColor("#F3D163")
BS381_411 = ManimColor("#74542F")
MIDDLE_BROWN = ManimColor("#74542F")
BS381_412 = ManimColor("#5C422E")
DARK_BROWN = ManimColor("#5C422E")
BS381_413 = ManimColor("#402D21")
NUT_BROWN = ManimColor("#402D21")
BS381_414 = ManimColor("#A86C29")
GOLDEN_BROWN = ManimColor("#A86C29")
BS381_415 = ManimColor("#61361E")
IMPERIAL_BROWN = ManimColor("#61361E")
BS381_420 = ManimColor("#A89177")
DARK_CAMOUFLAGE_DESERT_SAND = ManimColor("#A89177")
BS381_435 = ManimColor("#845B4D")
CAMOUFLAGE_RED = ManimColor("#845B4D")
BS381_436 = ManimColor("#564B47")
DARK_CAMOUFLAGE_BROWN = ManimColor("#564B47")
BS381_439 = ManimColor("#753B1E")
ORANGE_BROWN = ManimColor("#753B1E")
BS381_443 = ManimColor("#C98A71")
SALMON = ManimColor("#c98a71")
BS381_444 = ManimColor("#A65341")
TERRACOTTA = ManimColor("#a65341")
BS381_445 = ManimColor("#83422B")
VENETIAN_RED = ManimColor("#83422B")
BS381_446 = ManimColor("#774430")
RED_OXIDE = ManimColor("#774430")
BS381_447 = ManimColor("#F3B28B")
SALMON_PINK = ManimColor("#F3B28B")
BS381_448 = ManimColor("#67403A")
DEEP_INDIAN_RED = ManimColor("#67403A")
BS381_449 = ManimColor("#693B3F")
LIGHT_PURPLE_BROWN = ManimColor("#693B3F")
BS381_452 = ManimColor("#613339")
DARK_CRIMSON = ManimColor("#613339")
BS381_453 = ManimColor("#FBDED6")
SHELL_PINK = ManimColor("#FBDED6")
BS381_454 = ManimColor("#E8A1A2")
PALE_ROUNDEL_RED = ManimColor("#E8A1A2")
BS381_460 = ManimColor("#BD8F56")
DEEP_BUFF = ManimColor("#BD8F56")
BS381_473 = ManimColor("#793932")
GULF_RED = ManimColor("#793932")
BS381_489 = ManimColor("#8D5B41")
LEAF_BROWN = ManimColor("#8D5B41")
BS381_490 = ManimColor("#573320")
BEECH_BROWN = ManimColor("#573320")
BS381_499 = ManimColor("#59493E")
SERVICE_BROWN = ManimColor("#59493E")
BS381_536 = ManimColor("#BB3016")
POPPY = ManimColor("#bb3016")
BS381_537 = ManimColor("#DD3420")
SIGNAL_RED = ManimColor("#DD3420")
BS381_538 = ManimColor("#C41C22")
POST_OFFICE_RED = ManimColor("#C41C22")
CHERRY = ManimColor("#c41c22")
BS381_539 = ManimColor("#D21E2B")
CURRANT_RED = ManimColor("#D21E2B")
BS381_540 = ManimColor("#8B1A32")
CRIMSON = ManimColor("#8b1a32")
BS381_541 = ManimColor("#471B21")
MAROON = ManimColor("#471b21")
BS381_542 = ManimColor("#982D57")
RUBY = ManimColor("#982d57")
BS381_557 = ManimColor("#EF841E")
LIGHT_ORANGE = ManimColor("#EF841E")
BS381_564 = ManimColor("#DD3524")
BOLD_RED = ManimColor("#DD3524")
BS381_568 = ManimColor("#FB9C06")
APRICOT = ManimColor("#fb9c06")
BS381_570 = ManimColor("#A83C19")
TRAFFIC_RED = ManimColor("#A83C19")
BS381_591 = ManimColor("#D04E09")
DEEP_ORANGE = ManimColor("#D04E09")
BS381_592 = ManimColor("#E45523")
INTERNATIONAL_ORANGE = ManimColor("#E45523")
BS381_593 = ManimColor("#F24816")
RAIL_RED = ManimColor("#F24816")
AZO_ORANGE = ManimColor("#F24816")
BS381_626 = ManimColor("#A0A9AA")
CAMOUFLAGE_GREY = ManimColor("#A0A9AA")
BS381_627 = ManimColor("#BEC0B8")
LIGHT_AIRCRAFT_GREY = ManimColor("#BEC0B8")
BS381_628 = ManimColor("#9D9D7E")
SILVER_GREY = ManimColor("#9D9D7E")
BS381_629 = ManimColor("#7A838B")
DARK_CAMOUFLAGE_GREY = ManimColor("#7A838B")
BS381_630 = ManimColor("#A5AD98")
FRENCH_GREY = ManimColor("#A5AD98")
BS381_631 = ManimColor("#9AAA9F")
LIGHT_GREY = ManimColor("#9AAA9F")
BS381_632 = ManimColor("#6B7477")
DARK_ADMIRALTY_GREY = ManimColor("#6B7477")
BS381_633 = ManimColor("#424C53")
RAF_BLUE_GREY = ManimColor("#424C53")
BS381_634 = ManimColor("#6F7264")
SLATE = ManimColor("#6f7264")
BS381_635 = ManimColor("#525B55")
LEAD = ManimColor("#525b55")
BS381_636 = ManimColor("#5F7682")
PRU_BLUE = ManimColor("#5F7682")
BS381_637 = ManimColor("#8E9B9C")
MEDIUM_SEA_GREY = ManimColor("#8E9B9C")
BS381_638 = ManimColor("#6C7377")
DARK_SEA_GREY = ManimColor("#6C7377")
BS381_639 = ManimColor("#667563")
LIGHT_SLATE_GREY = ManimColor("#667563")
BS381_640 = ManimColor("#566164")
EXTRA_DARK_SEA_GREY = ManimColor("#566164")
BS381_642 = ManimColor("#282B2F")
NIGHT = ManimColor("#282b2f")
BS381_671 = ManimColor("#4E5355")
MIDDLE_GRAPHITE = ManimColor("#4E5355")
BS381_676 = ManimColor("#A9B7B9")
LIGHT_WEATHERWORK_GREY = ManimColor("#A9B7B9")
BS381_677 = ManimColor("#676F76")
DARK_WEATHERWORK_GREY = ManimColor("#676F76")
BS381_692 = ManimColor("#7B93A3")
SMOKE_GREY = ManimColor("#7B93A3")
BS381_693 = ManimColor("#88918D")
AIRCRAFT_GREY = ManimColor("#88918D")
BS381_694 = ManimColor("#909A92")
DOVE_GREY = ManimColor("#909A92")
BS381_697 = ManimColor("#B6D3CC")
LIGHT_ADMIRALTY_GREY = ManimColor("#B6D3CC")
BS381_796 = ManimColor("#6E4A75")
DARK_VIOLET = ManimColor("#6E4A75")
BS381_797 = ManimColor("#C9A8CE")
LIGHT_VIOLET = ManimColor("#C9A8CE")
