; APX testcases

%macro testcase 2
 %ifdef BIN
  db %1
 %endif
 %ifdef SRC
  %2
 %endif
%endmacro


bits 64

; aadd instruction
testcase	{0x0F, 0x38, 0xFC, 0x0A},		{aadd [rdx],ecx}		;m32 <- r32 regular
testcase	{0x48, 0x0F, 0x38, 0xFC, 0x0A},		{aadd [rdx],rcx}		;m64 <- r64 regular
testcase	{0x62, 0xF4, 0x7C, 0x08, 0xFC, 0x0A},	{aadd {evex} [rdx],ecx}		;m32 <- r32 explicit evex
testcase	{0x62, 0xF4, 0xFC, 0x08, 0xFC, 0x0A},	{aadd {evex} [rdx],rcx}		;m64 <- r64 explicit evex
testcase	{0x62, 0x64, 0xFC, 0x08, 0xFC, 0x0A},	{aadd [rdx],r25}		;m64 <- er64

; aand instruction
testcase	{0x66, 0x0F, 0x38, 0xFC, 0x0A},		{aand [rdx],ecx}		;m32 <- r32 regular
testcase	{0x66, 0x48, 0x0F, 0x38, 0xFC, 0x0A},	{aand [rdx],rcx}		;m64 <- r64 regular
testcase	{0x62, 0xF4, 0x7D, 0x08, 0xFC, 0x0A},	{aand {evex} [rdx],ecx}		;m32 <- r32 explicit evex
testcase	{0x62, 0xF4, 0xFD, 0x08, 0xFC, 0x0A},	{aand {evex} [rdx],rcx}		;m64 <- r64 explicit evex
testcase	{0x62, 0x64, 0xFD, 0x08, 0xFC, 0x0A},	{aand [rdx],r25}		;m64 <- er64

; aor instruction
testcase	{0xF2, 0x0F, 0x38, 0xFC, 0x0A},		{aor [rdx],ecx}			;m32 <- r32 regular
testcase	{0xF2, 0x48, 0x0F, 0x38, 0xFC, 0x0A},	{aor [rdx],rcx}			;m64 <- r64 regular
testcase	{0x62, 0xF4, 0x7F, 0x08, 0xFC, 0x0A},	{aor {evex} [rdx],ecx}		;m32 <- r32 explicit evex
testcase	{0x62, 0xF4, 0xFF, 0x08, 0xFC, 0x0A},	{aor {evex} [rdx],rcx}		;m64 <- r64 explicit evex
testcase	{0x62, 0x64, 0xFF, 0x08, 0xFC, 0x0A},	{aor [rdx],r25}			;m64 <- er64

; axor instruction
testcase	{0xF3, 0x0F, 0x38, 0xFC, 0x0A},		{axor [rdx],ecx}		;m32 <- r32 regular
testcase	{0xF3, 0x48, 0x0F, 0x38, 0xFC, 0x0A},	{axor [rdx],rcx}		;m64 <- r64 regular
testcase	{0x62, 0xF4, 0x7E, 0x08, 0xFC, 0x0A},	{axor {evex} [rdx],ecx}		;m32 <- r32 explicit evex
testcase	{0x62, 0xF4, 0xFE, 0x08, 0xFC, 0x0A},	{axor {evex} [rdx],rcx}		;m64 <- r64 explicit evex
testcase	{0x62, 0x64, 0xFE, 0x08, 0xFC, 0x0A},	{axor [rdx],r25}		;m64 <- er64

; adcx instruction: reg = reg + r/m
; adcx non-apx control group
testcase	{0x66, 0x0F, 0x38, 0xF6, 0x0A},		{adcx ecx, [rdx]}	;r32 + r/m32
testcase	{0x66 ,0x48, 0x0F, 0x38, 0xF6, 0x0A},	{adcx rcx, [rdx]}	;r64 + r/m64
testcase	{0x66 ,0x4C, 0x0F, 0x38, 0xF6, 0x0A},	{adcx r9, [rdx]}	;r64 + r/m64

; adcx implicit evex
; (legacy map 2 - no rex2 variant)
testcase	{0x62, 0x44, 0x7D, 0x08, 0x66, 0x09},	{adcx r25d, [r9]}	;r32 + r/m32
testcase	{0x62, 0x44, 0xFD, 0x08, 0x66, 0x09},	{adcx r25, [r9]}	;r64 + r/m64
testcase	{0x62, 0x5C, 0x7D, 0x08, 0x66, 0x09},	{adcx r9d, [r25]}	;r32 + r/m32
testcase	{0x62, 0x5C, 0xFD, 0x08, 0x66, 0x09},	{adcx r9, [r25]}	;r64 + r/m64
testcase	{0x62, 0x5C, 0x75, 0x18, 0x66, 0x09},	{adcx ecx, r9d, [r25]}	;r32 + r/m32 - ndd variant
testcase	{0x62, 0x5C, 0xF5, 0x18, 0x66, 0x09},	{adcx rcx, r9, [r25]}	;r64 + r/m64 - ndd variant

; adox instruction: reg = reg + r/m
; adox non-apx control group
testcase	{0xF3, 0x0F, 0x38, 0xF6, 0x0A},		{adox ecx, [rdx]}	;r32 + r/m32
testcase	{0xF3 ,0x48, 0x0F, 0x38, 0xF6, 0x0A},	{adox rcx, [rdx]}	;r64 + r/m64
testcase	{0xF3 ,0x4C, 0x0F, 0x38, 0xF6, 0x0A},	{adox r9, [rdx]}	;r64 + r/m64

; adox implicit evex
; (legacy map 2 - no rex2 variant)
testcase	{0x62, 0x44, 0x7E, 0x08, 0x66, 0x09},	{adox r25d, [r9]}	;r32 + r/m32
testcase	{0x62, 0x44, 0xFE, 0x08, 0x66, 0x09},	{adox r25, [r9]}	;r64 + r/m64
testcase	{0x62, 0x5C, 0x7E, 0x08, 0x66, 0x09},	{adox r9d, [r25]}	;r32 + r/m32
testcase	{0x62, 0x5C, 0xFE, 0x08, 0x66, 0x09},	{adox r9, [r25]}	;r64 + r/m64
testcase	{0x62, 0x5C, 0x76, 0x18, 0x66, 0x09},	{adox ecx, r9d, [r25]}	;r32 + r/m32 - ndd variant
testcase	{0x62, 0x5C, 0xF6, 0x18, 0x66, 0x09},	{adox rcx, r9, [r25]}	;r64 + r/m64 - ndd variant

; andn instruction
; andn non-apx control group (vex)
testcase	{0xC4, 0x62, 0x70, 0xF2, 0x0A},	{andn r9d, ecx, dword [rdx]}
testcase	{0xC4, 0x62, 0xF0, 0xF2, 0x0A},	{andn r9, rcx, qword [rdx]}

; andn explicit evex
testcase	{0x62, 0x72, 0x74, 0x08, 0xF2, 0x0A},	{andn{evex} r9d, ecx, dword [rdx]}
testcase	{0x62, 0x72, 0xF4, 0x08, 0xF2, 0x0A},	{andn{evex} r9, rcx, qword [rdx]}

; andn implicit evex through NF
testcase	{0x62, 0x72, 0x74, 0x0C, 0xF2, 0x0A},	{andn{nf} r9d, ecx, dword [rdx]}
testcase	{0x62, 0x72, 0xF4, 0x0C, 0xF2, 0x0A},	{andn{nf} r9, rcx, qword [rdx]}

; andn implicit evex through EGPR
testcase	{0x62, 0x62, 0x74, 0x08, 0xF2, 0x0A},	{andn r25d, ecx, dword [rdx]}
testcase	{0x62, 0x62, 0xF4, 0x08, 0xF2, 0x0A},	{andn r25, rcx, qword [rdx]}

; bextr instruction
; bextr non-apx control group (vex)
testcase	{0xC4, 0x62, 0x70, 0xF7, 0x0A},	{bextr r9d, dword [rdx], ecx}
testcase	{0xC4, 0x62, 0xF0, 0xF7, 0x0A},	{bextr r9, qword [rdx], rcx}

; bextr explicit evex
testcase	{0x62, 0x72, 0x74, 0x08, 0xF7, 0x0A},	{bextr{evex} r9d, dword [rdx], ecx}
testcase	{0x62, 0x72, 0xF4, 0x08, 0xF7, 0x0A},	{bextr{evex} r9, qword [rdx], rcx}

; bextr implicit evex through NF
testcase	{0x62, 0x72, 0x74, 0x0C, 0xF7, 0x0A},	{bextr{nf} r9d, dword [rdx], ecx}
testcase	{0x62, 0x72, 0xF4, 0x0C, 0xF7, 0x0A},	{bextr{nf} r9, qword [rdx], rcx}

; bextr implicit evex through EGPR
testcase	{0x62, 0x62, 0x74, 0x08, 0xF7, 0x0A},	{bextr r25d, dword [rdx], ecx}
testcase	{0x62, 0x62, 0xF4, 0x08, 0xF7, 0x0A},	{bextr r25, qword [rdx], rcx}

; blsi instruction
; blsi non-apx control group (vex)
testcase	{0xC4, 0xE2, 0x30, 0xF3, 0x1A},	{blsi r9d, dword [rdx]}
testcase	{0xC4, 0xE2, 0xB0, 0xF3, 0x1A},	{blsi r9, qword [rdx]}

; blsi explicit evex
testcase	{0x62, 0xF2, 0x34, 0x08, 0xF3, 0x1A},	{blsi{evex} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x08, 0xF3, 0x1A},	{blsi{evex} r9, qword [rdx]}

; blsi implicit evex through NF
testcase	{0x62, 0xF2, 0x34, 0x0C, 0xF3, 0x1A},	{blsi{nf} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x0C, 0xF3, 0x1A},	{blsi{nf} r9, qword [rdx]}

; blsi implicit evex through EGPR
testcase	{0x62, 0xF2, 0x34, 0x00, 0xF3, 0x1A},	{blsi r25d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x00, 0xF3, 0x1A},	{blsi r25, qword [rdx]}

; blsmsk instruction
; blsmsk non-apx control group (vex)
testcase	{0xC4, 0xE2, 0x30, 0xF3, 0x12},	{blsmsk r9d, dword [rdx]}
testcase	{0xC4, 0xE2, 0xB0, 0xF3, 0x12},	{blsmsk r9, qword [rdx]}

; blsmsk explicit evex
testcase	{0x62, 0xF2, 0x34, 0x08, 0xF3, 0x12},	{blsmsk{evex} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x08, 0xF3, 0x12},	{blsmsk{evex} r9, qword [rdx]}

; blsmsk implicit evex through NF
testcase	{0x62, 0xF2, 0x34, 0x0C, 0xF3, 0x12},	{blsmsk{nf} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x0C, 0xF3, 0x12},	{blsmsk{nf} r9, qword [rdx]}

; blsmsk implicit evex through EGPR
testcase	{0x62, 0xF2, 0x34, 0x00, 0xF3, 0x12},	{blsmsk r25d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x00, 0xF3, 0x12},	{blsmsk r25, qword [rdx]}

; blsr instruction
; blsr non-apx control group (vex)
testcase	{0xC4, 0xE2, 0x30, 0xF3, 0x0A},	{blsr r9d, dword [rdx]}
testcase	{0xC4, 0xE2, 0xB0, 0xF3, 0x0A},	{blsr r9, qword [rdx]}

; blsr explicit evex
testcase	{0x62, 0xF2, 0x34, 0x08, 0xF3, 0x0A},	{blsr{evex} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x08, 0xF3, 0x0A},	{blsr{evex} r9, qword [rdx]}

; blsr implicit evex through NF
testcase	{0x62, 0xF2, 0x34, 0x0C, 0xF3, 0x0A},	{blsr{nf} r9d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x0C, 0xF3, 0x0A},	{blsr{nf} r9, qword [rdx]}

; blsr implicit evex through EGPR
testcase	{0x62, 0xF2, 0x34, 0x00, 0xF3, 0x0A},	{blsr r25d, dword [rdx]}
testcase	{0x62, 0xF2, 0xB4, 0x00, 0xF3, 0x0A},	{blsr r25, qword [rdx]}

; bzhi instruction
; bzhi non-apx control group (vex)
testcase	{0xC4, 0x62, 0x70, 0xF5, 0x0A},	{bzhi r9d, dword [rdx], ecx}
testcase	{0xC4, 0x62, 0xF0, 0xF5, 0x0A},	{bzhi r9, qword [rdx], rcx}

; bzhi explicit evex
testcase	{0x62, 0x72, 0x74, 0x08, 0xF5, 0x0A},	{bzhi{evex} r9d, dword [rdx], ecx}
testcase	{0x62, 0x72, 0xF4, 0x08, 0xF5, 0x0A},	{bzhi{evex} r9, qword [rdx], rcx}

; bzhi implicit evex through NF
testcase	{0x62, 0x72, 0x74, 0x0C, 0xF5, 0x0A},	{bzhi{nf} r9d, dword [rdx], ecx}
testcase	{0x62, 0x72, 0xF4, 0x0C, 0xF5, 0x0A},	{bzhi{nf} r9, qword [rdx], rcx}

; bzhi implicit evex through EGPR
testcase	{0x62, 0x62, 0x74, 0x08, 0xF5, 0x0A},	{bzhi r25d, dword [rdx], ecx}
testcase	{0x62, 0x62, 0xF4, 0x08, 0xF5, 0x0A},	{bzhi r25, qword [rdx], rcx}

; --- crc32 instruction ---
; legacy crc32
testcase	{0xF2, 0x0F, 0x38, 0xF0, 0x0A},		{crc32 ecx, byte [rdx]}		; reg32 += crc32(r/m8)
testcase	{0x66, 0xF2, 0x0F, 0x38, 0xF1, 0x0A},	{crc32 ecx, word [rdx]}		; reg32 += crc32(r/m16)
testcase	{0xF2, 0x0F, 0x38, 0xF1, 0x0A},		{crc32 ecx, dword [rdx]}	; reg32 += crc32(r/m32)
testcase	{0xF2, 0x4C, 0x0F, 0x38, 0xF0, 0x0A},	{crc32 r9, byte [rdx]}		; reg64 += crc32(r/m8)
testcase	{0xF2, 0x4C, 0x0F, 0x38, 0xF1, 0x0A},	{crc32 r9, qword [rdx]}		; reg64 += crc32(r/m64)

; implicit evex through EGPRs
testcase	{0x62, 0x64, 0x7C, 0x08, 0xF0, 0x0A},	{crc32 r25d, byte [rdx]}	; ereg32 += crc32(r/m8)
testcase	{0x62, 0x64, 0x7D, 0x08, 0xF1, 0x0A},	{crc32 r25d, word [rdx]}	; ereg32 += crc32(r/m16)
testcase	{0x62, 0x64, 0x7C, 0x08, 0xF1, 0x0A},	{crc32 r25d, dword [rdx]}	; ereg32 += crc32(r/m32)
testcase	{0x62, 0x64, 0xFC, 0x08, 0xF0, 0x0A},	{crc32 r25, byte [rdx]}		; ereg64 += crc32(r/m8)
testcase	{0x62, 0x64, 0xFC, 0x08, 0xF1, 0x0A},	{crc32 r25, qword [rdx]}	; ereg64 += crc32(r/m64)

; --- dec instruction ---
; legacy dec
testcase	{0xFE, 0x0A},		{dec byte [rdx]}
testcase	{0x66, 0xFF, 0x0A},	{dec word [rdx]}
testcase	{0xFF, 0x0A},		{dec dword [rdx]}
testcase	{0x48, 0xFF, 0x0A},	{dec qword [rdx]}
; nolong only testcases
; testcase	{0x66, 0x4A},		{dec dx}
; testcase	{0x4A},			{dec edx}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xFE, 0x0A},	{dec{nf} byte [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xFF, 0x0A},	{dec{nf} word [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xFF, 0x0A},	{dec{nf} dword [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xFF, 0x0A},	{dec{nf} qword [rdx]}

; implicit evex through ND and EGPRs
testcase	{0x62, 0xF4, 0x34, 0x10, 0xFE, 0x0A},	{dec r25b, byte [rdx]}
testcase	{0x62, 0xF4, 0x35, 0x10, 0xFF, 0x0A},	{dec r25w, word [rdx]}
testcase	{0x62, 0xF4, 0x34, 0x10, 0xFF, 0x0A},	{dec r25d, dword [rdx]}
testcase	{0x62, 0xF4, 0xB4, 0x10, 0xFF, 0x0A},	{dec r25, qword [rdx]}

; --- div instruction ---
; legacy div
testcase	{0xF6, 0x31},				{div byte [rcx]}
testcase	{0x66, 0xF7, 0x31},			{div word [rcx]}
testcase	{0xF7, 0x31},				{div dword [rcx]}
testcase	{0x48, 0xF7, 0x31},			{div qword [rcx]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF6, 0x31},	{div{nf} byte [rcx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF7, 0x31},	{div{nf} word [rcx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF7, 0x31},	{div{nf} dword [rcx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF7, 0x31},	{div{nf} qword [rcx]}

; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x31},	{div byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x31},	{div word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x31},	{div dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x31},	{div qword [r25]}

; --- enqcmd instruction ---
testcase	{0x67, 0xF2, 0x0F, 0x38, 0xF8, 0x0A},	{enqcmd ecx, zword [edx]}
testcase	{0xF2, 0x0F, 0x38, 0xF8, 0x0A},		{enqcmd rcx, zword [rdx]}
testcase	{0x62, 0x64, 0xFF, 0x08, 0xF8, 0x0A},	{enqcmd r25, zword [rdx]}

; --- enqcmds instruction ---
testcase	{0x67, 0xF3, 0x0F, 0x38, 0xF8, 0x0A},	{enqcmds ecx, zword [edx]}
testcase	{0xF3, 0x0F, 0x38, 0xF8, 0x0A},		{enqcmds rcx, zword [rdx]}
testcase	{0x62, 0x64, 0xFE, 0x08, 0xF8, 0x0A},	{enqcmds r25, zword [rdx]}

; --- idiv instruction ---
; legacy idiv
testcase	{0xF6, 0x39},				{idiv byte [rcx]}
testcase	{0x66, 0xF7, 0x39},			{idiv word [rcx]}
testcase	{0xF7, 0x39},				{idiv dword [rcx]}
testcase	{0x48, 0xF7, 0x39},			{idiv qword [rcx]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF6, 0x39},	{idiv{nf} byte [rcx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF7, 0x39},	{idiv{nf} word [rcx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF7, 0x39},	{idiv{nf} dword [rcx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF7, 0x39},	{idiv{nf} qword [rcx]}

; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x39},	{idiv byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x39},	{idiv word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x39},	{idiv dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x39},	{idiv qword [r25]}

; --- imul instruction ---
; - imul : D:A = reg * A
; legacy
testcase	{0xF6, 0x29},		{imul byte [rcx]}
testcase	{0x66, 0xF7, 0x29},	{imul word [rcx]}
testcase	{0xF7, 0x29},		{imul dword [rcx]}
testcase	{0x48, 0xF7, 0x29},	{imul qword [rcx]}
; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF6, 0x29},		{imul{nf} byte [rcx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF7, 0x29},		{imul{nf} word [rcx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF7, 0x29},		{imul{nf} dword [rcx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF7, 0x29},		{imul{nf} qword [rcx]}
; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x29},		{imul byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x29},		{imul word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x29},		{imul dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x29},		{imul qword [r25]}

; - imul : reg1 *= r/m2 -
; legacy
testcase	{0x66, 0x0F, 0xAF, 0x0A},	{imul cx, [rdx]}
testcase	{0x0F, 0xAF, 0x0A},		{imul ecx, [rdx]}
testcase	{0x48, 0x0F, 0xAF, 0x0A},	{imul rcx, [rdx]}
; implicit evex through NF
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xAF, 0x0A},		{imul{nf} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xAF, 0x0A},		{imul{nf} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xAF, 0x0A},		{imul{nf} rcx, [rdx]}
; implicit evex through ND
testcase	{0x62, 0xF4, 0x7D, 0x18, 0xAF, 0x0A},		{imul ax, cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x18, 0xAF, 0x0A},		{imul eax, ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x18, 0xAF, 0x0A},		{imul rax, rcx, [rdx]}
; implicit rex2 through EGPRs
testcase	{0x66, 0xD5, 0xD5, 0xAF, 0x0A},		{imul r25w, [r26]}
testcase	{0xD5, 0xD5, 0xAF, 0x0A},		{imul r25d, [r26]}
testcase	{0xD5, 0xDD, 0xAF, 0x0A},		{imul r25, [r26]}

; - imul : reg1 = r/m2 * imm3
; legacy
testcase	{0x66, 0x6B, 0x0A, 0x02},			{imul cx, [rdx], byte 0x02}
testcase	{0x6B, 0x0A, 0x02},				{imul ecx, [rdx], byte 0x02}
testcase	{0x48, 0x6B, 0x0A, 0x02},			{imul rcx, [rdx], byte 0x02}
testcase	{0x66, 0x69, 0x0A, 0x02, 0x02},			{imul cx, [rdx], word 0x0202}
testcase	{0x69, 0x0A, 0x02, 0x02, 0x02, 0x02},		{imul ecx, [rdx], dword 0x02020202}
testcase	{0x48, 0x69, 0x0A, 0x02, 0x02, 0x02, 0x02},	{imul rcx, [rdx], dword 0x02020202}
; implicit evex through NF
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x6B, 0x0A, 0x02},\
			{imul{nf} cx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x6B, 0x0A, 0x02},\
			{imul{nf} ecx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x6B, 0x0A, 0x02},\
			{imul{nf} rcx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x69, 0x0A, 0x02, 0x02},\
			{imul{nf} cx, [rdx], word 0x0202}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x69, 0x0A, 0x02, 0x02, 0x02, 0x02},\
			{imul{nf} ecx, [rdx], dword 0x02020202}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x69, 0x0A, 0x02, 0x02, 0x02, 0x02},\
			{imul{nf} rcx, [rdx], dword 0x02020202}
; implicit evex through ZU
testcase	{0x62, 0xF4, 0x7D, 0x18, 0x6B, 0x0A, 0x02},\
			{imul{zu} cx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0x7C, 0x18, 0x6B, 0x0A, 0x02},\
			{imul{zu} ecx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0xFC, 0x18, 0x6B, 0x0A, 0x02},\
			{imul{zu} rcx, [rdx], byte 0x02}
testcase	{0x62, 0xF4, 0x7D, 0x18, 0x69, 0x0A, 0x02, 0x02},\
			{imul{zu} cx, [rdx], word 0x0202}

; --- inc instruction ---
; legacy inc
testcase	{0xFE, 0x02},		{inc byte [rdx]}
testcase	{0x66, 0xFF, 0x02},	{inc word [rdx]}
testcase	{0xFF, 0x02},		{inc dword [rdx]}
testcase	{0x48, 0xFF, 0x02},	{inc qword [rdx]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xFE, 0x02},	{inc{nf} byte [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xFF, 0x02},	{inc{nf} word [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xFF, 0x02},	{inc{nf} dword [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xFF, 0x02},	{inc{nf} qword [rdx]}

; implicit evex through ND and EGPRs
testcase	{0x62, 0xF4, 0x34, 0x10, 0xFE, 0x02},	{inc r25b, byte [rdx]}
testcase	{0x62, 0xF4, 0x35, 0x10, 0xFF, 0x02},	{inc r25w, word [rdx]}
testcase	{0x62, 0xF4, 0x34, 0x10, 0xFF, 0x02},	{inc r25d, dword [rdx]}
testcase	{0x62, 0xF4, 0xB4, 0x10, 0xFF, 0x02},	{inc r25, qword [rdx]}

; --- invept instruction ---
; legacy
testcase	{0x66, 0x0F, 0x38, 0x80, 0x0A},		{invept rcx, oword [rdx]}
; apx through EGPR
testcase	{0x62, 0x64, 0xFE, 0x08, 0xF0, 0x0A},	{invept r25, oword [rdx]}

; --- invpcid instruction ---
; legacy
testcase	{0x66, 0x0F, 0x38, 0x82, 0x0A},		{invpcid rcx, oword [rdx]}
; apx through EGPR
testcase	{0x62, 0x64, 0xFE, 0x08, 0xF2, 0x0A},	{invpcid r25, oword [rdx]}

; --- invvpid instruction ---
; legacy
testcase	{0x66, 0x0F, 0x38, 0x81, 0x0A},		{invvpid rcx, oword [rdx]}
; apx through EGPR
testcase	{0x62, 0x64, 0xFE, 0x08, 0xF1, 0x0A},	{invvpid r25, oword [rdx]}

; --- kmov instructions ---
; legacy - 0x90 variant
testcase	{0xC5, 0xF9, 0x90, 0xCA},	{kmovb k1, k2}
testcase	{0xC5, 0xF8, 0x90, 0xCA},	{kmovw k1, k2}
testcase	{0xC4, 0xE1, 0xF9, 0x90, 0xCA},	{kmovd k1, k2}
testcase	{0xC4, 0xE1, 0xF8, 0x90, 0xCA},	{kmovq k1, k2}
testcase	{0xC5, 0xF9, 0x90, 0x0A},	{kmovb k1, [rdx]}
testcase	{0xC5, 0xF8, 0x90, 0x0A},	{kmovw k1, [rdx]}
testcase	{0xC4, 0xE1, 0xF9, 0x90, 0x0A},	{kmovd k1, [rdx]}
testcase	{0xC4, 0xE1, 0xF8, 0x90, 0x0A},	{kmovq k1, [rdx]}
; legacy - 0x91 variant
testcase	{0xC5, 0xF9, 0x91, 0x0A},	{kmovb [rdx], k1}
testcase	{0xC5, 0xF8, 0x91, 0x0A},	{kmovw [rdx], k1}
testcase	{0xC4, 0xE1, 0xF9, 0x91, 0x0A},	{kmovd [rdx], k1}
testcase	{0xC4, 0xE1, 0xF8, 0x91, 0x0A},	{kmovq [rdx], k1}
; legacy - 0x92 variant
testcase	{0xC5, 0xF9, 0x92, 0xCA},	{kmovb k1, dl}
testcase	{0xC5, 0xF8, 0x92, 0xCA},	{kmovw k1, dx}
testcase	{0xC5, 0xF9, 0x92, 0xCA},	{kmovb k1, edx}
testcase	{0xC5, 0xF8, 0x92, 0xCA},	{kmovw k1, edx}
testcase	{0xC5, 0xFB, 0x92, 0xCA},	{kmovd k1, edx}
testcase	{0xC4, 0xE1, 0xFB, 0x92, 0xCA},	{kmovq k1, rdx}
; legacy - 0x93 variant
testcase	{0xC5, 0xF9, 0x93, 0xCA},	{kmovb ecx, k2}
testcase	{0xC5, 0xF8, 0x93, 0xCA},	{kmovw ecx, k2}
testcase	{0xC5, 0xFB, 0x93, 0xCA},	{kmovd ecx, k2}
testcase	{0xC4, 0xE1, 0xFB, 0x93, 0xCA},	{kmovq rcx, k2}

; implicit evex through EGPRs
testcase	{0x62, 0xD9, 0x7D, 0x08, 0x90, 0x0A},	{kmovb k1, [r26]}
testcase	{0x62, 0xD9, 0x7D, 0x08, 0x91, 0x0A},	{kmovb [r26], k1}
testcase	{0x62, 0xD9, 0x7D, 0x08, 0x92, 0xCA},	{kmovb k1, r26d}
testcase	{0x62, 0x61, 0x7D, 0x08, 0x93, 0xC9},	{kmovb r25d, k1}
testcase	{0x62, 0xD9, 0x7C, 0x08, 0x90, 0x0A},	{kmovw k1, [r26]}
testcase	{0x62, 0xD9, 0x7C, 0x08, 0x91, 0x0A},	{kmovw [r26], k1}
testcase	{0x62, 0xD9, 0x7C, 0x08, 0x92, 0xCA},	{kmovw k1, r26d}
testcase	{0x62, 0x61, 0x7C, 0x08, 0x93, 0xC9},	{kmovw r25d, k1}
testcase	{0x62, 0xD9, 0xFD, 0x08, 0x90, 0x0A},	{kmovd k1, [r26]}
testcase	{0x62, 0xD9, 0xFD, 0x08, 0x91, 0x0A},	{kmovd [r26], k1}
testcase	{0x62, 0xD9, 0x7F, 0x08, 0x92, 0xCA},	{kmovd k1, r26d}
testcase	{0x62, 0x61, 0x7F, 0x08, 0x93, 0xC9},	{kmovd r25d, k1}
testcase	{0x62, 0xD9, 0xFC, 0x08, 0x90, 0x0A},	{kmovq k1, [r26]}
testcase	{0x62, 0xD9, 0xFC, 0x08, 0x91, 0x0A},	{kmovq [r26], k1}
testcase	{0x62, 0xD9, 0xFF, 0x08, 0x92, 0xCA},	{kmovq k1, r26}
testcase	{0x62, 0x61, 0xFF, 0x08, 0x93, 0xC9},	{kmovq r25, k1}

; --- ldtilecfg instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x78, 0x49, 0x02},		{ldtilecfg [rdx]}
; apx
testcase	{0x62, 0xDA, 0x7C, 0x08, 0x49, 0x02},	{ldtilecfg [r26]}

; --- lzcnt instruction ---
; legacy
testcase	{0x66, 0xF3, 0x0F, 0xBD, 0x0A},	{lzcnt cx, [rdx]}
testcase	{0xF3, 0x0F, 0xBD, 0x0A},	{lzcnt ecx, [rdx]}
testcase	{0xF3, 0x48, 0x0F, 0xBD, 0x0A},	{lzcnt rcx, [rdx]}
; apx
testcase	{0x66, 0xF3, 0xD5, 0xD5, 0xBD, 0x0A},	{lzcnt r25w, [r26]}
testcase	{0xF3, 0xD5, 0xD5, 0xBD, 0x0A},	{lzcnt r25d, [r26]}
testcase	{0xF3, 0xD5, 0xDD, 0xBD, 0x0A},	{lzcnt r25, [r26]}

testcase	{0x62, 0x4C, 0x7D, 0x0C, 0xF5, 0x0A},	{lzcnt{nf} r25w, [r26]}
testcase	{0x62, 0x4C, 0x7C, 0x0C, 0xF5, 0x0A},	{lzcnt{nf} r25d, [r26]}
testcase	{0x62, 0x4C, 0xFC, 0x0C, 0xF5, 0x0A},	{lzcnt{nf} r25, [r26]}

; --- movbe instruction ---
; legacy
testcase	{0x66, 0x0F, 0x38, 0xF0, 0x0A},	{movbe cx, [rdx]}
testcase	{0x0F, 0x38, 0xF0, 0x0A},	{movbe ecx, [rdx]}
testcase	{0x48, 0x0F, 0x38, 0xF0, 0x0A},	{movbe rcx, [rdx]}
testcase	{0x66, 0x0F, 0x38, 0xF1, 0x0A},	{movbe [rdx], cx}
testcase	{0x0F, 0x38, 0xF1, 0x0A},	{movbe [rdx], ecx}
testcase	{0x48, 0x0F, 0x38, 0xF1, 0x0A},	{movbe [rdx], rcx}
; implicit evex through EGPRs
testcase	{0x62, 0x4C, 0x7D, 0x08, 0x60, 0x0A},	{movbe r25w, [r26]}
testcase	{0x62, 0x4C, 0x7C, 0x08, 0x60, 0x0A},	{movbe r25d, [r26]}
testcase	{0x62, 0x4C, 0xFC, 0x08, 0x60, 0x0A},	{movbe r25, [r26]}
testcase	{0x62, 0x4C, 0x7D, 0x08, 0x61, 0x0A},	{movbe [r26], r25w}
testcase	{0x62, 0x4C, 0x7C, 0x08, 0x61, 0x0A},	{movbe [r26], r25d}
testcase	{0x62, 0x4C, 0xFC, 0x08, 0x61, 0x0A},	{movbe [r26], r25}

; --- movdir64b instruction ---
; legacy
testcase	{0x67, 0x66, 0x0F, 0x38, 0xF8, 0x0A},	{movdir64b ecx, [edx]}
testcase	{0x66, 0x0F, 0x38, 0xF8, 0x0A},		{movdir64b rcx, [rdx]}
; apx
testcase	{0x62, 0x4C, 0xFD, 0x08, 0xF8, 0x0A},	{movdir64b r25, [r26]}

; --- movdiri instruction ---
; legacy
testcase	{0x0F, 0x38, 0xF9, 0x0A},		{movdiri [rdx], ecx}
testcase	{0x48, 0x0F, 0x38, 0xF9, 0x0A},		{movdiri [rdx], rcx}
; implicit evex through EGPRs
testcase	{0x62, 0x4C, 0x7C, 0x08, 0xF9, 0x0A},	{movdiri [r26], r25d}
testcase	{0x62, 0x4C, 0xFC, 0x08, 0xF9, 0x0A},	{movdiri [r26], r25}

; --- movrs instruction ---
; legacy
testcase	{0x0F, 0x38, 0x8A, 0x0A},	{movrs cl, [rdx]}
testcase	{0x66, 0x0F, 0x38, 0x8B, 0x0A},	{movrs cx, [rdx]}
testcase	{0x0F, 0x38, 0x8B, 0x0A},	{movrs ecx, [rdx]}
testcase	{0x48, 0x0F, 0x38, 0x8B, 0x0A},	{movrs rcx, [rdx]}
; implicit evex through EGPRs
testcase	{0x62, 0x4C, 0x7C, 0x08, 0x8A, 0x0A},	{movrs r25b, [r26]}
testcase	{0x62, 0x4C, 0x7D, 0x08, 0x8B, 0x0A},	{movrs r25w, [r26]}
testcase	{0x62, 0x4C, 0x7C, 0x08, 0x8B, 0x0A},	{movrs r25d, [r26]}
testcase	{0x62, 0x4C, 0xFC, 0x08, 0x8B, 0x0A},	{movrs r25, [r26]}

; --- mul instruction ---
; - mul : D:A = reg * A
; legacy
testcase	{0xF6, 0x21},		{mul byte [rcx]}
testcase	{0x66, 0xF7, 0x21},	{mul word [rcx]}
testcase	{0xF7, 0x21},		{mul dword [rcx]}
testcase	{0x48, 0xF7, 0x21},	{mul qword [rcx]}
; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF6, 0x21},		{mul{nf} byte [rcx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF7, 0x21},		{mul{nf} word [rcx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF7, 0x21},		{mul{nf} dword [rcx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF7, 0x21},		{mul{nf} qword [rcx]}
; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x21},		{mul byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x21},		{mul word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x21},		{mul dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x21},		{mul qword [r25]}

; --- mulx instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x2B, 0xF6, 0x0B},		{mulx ecx, r10d, [rbx]}
testcase	{0xC4, 0xE2, 0xAB, 0xF6, 0x0B},		{mulx rcx, r10, [rbx]}
; implicit evex through EGPRs
testcase	{0x62, 0xF2, 0x2F, 0x00, 0xF6, 0x0B},	{mulx ecx, r26d, [rbx]}
testcase	{0x62, 0xF2, 0xAF, 0x00, 0xF6, 0x0B},	{mulx rcx, r26, [rbx]}

; --- neg instruction ---
; legacy neg
testcase	{0xF6, 0x19},				{neg byte [rcx]}
testcase	{0x66, 0xF7, 0x19},			{neg word [rcx]}
testcase	{0xF7, 0x19},				{neg dword [rcx]}
testcase	{0x48, 0xF7, 0x19},			{neg qword [rcx]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF6, 0x19},	{neg{nf} byte [rcx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF7, 0x19},	{neg{nf} word [rcx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF7, 0x19},	{neg{nf} dword [rcx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF7, 0x19},	{neg{nf} qword [rcx]}

; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x19},	{neg byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x19},	{neg word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x19},	{neg dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x19},	{neg qword [r25]}

; implicit evex through ND
testcase	{0x62, 0xF4, 0x6C, 0x18, 0xF6, 0x19},	{neg dl, byte [rcx]}
testcase	{0x62, 0xF4, 0x6D, 0x18, 0xF7, 0x19},	{neg dx, word [rcx]}
testcase	{0x62, 0xF4, 0x6C, 0x18, 0xF7, 0x19},	{neg edx, dword [rcx]}
testcase	{0x62, 0xF4, 0xEC, 0x18, 0xF7, 0x19},	{neg rdx, qword [rcx]}

; --- not instruction ---
; legacy not
testcase	{0xF6, 0x11},				{not byte [rcx]}
testcase	{0x66, 0xF7, 0x11},			{not word [rcx]}
testcase	{0xF7, 0x11},				{not dword [rcx]}
testcase	{0x48, 0xF7, 0x11},			{not qword [rcx]}

; implicit rex2 through EGPRs
testcase	{0xD5, 0x11, 0xF6, 0x11},	{not byte [r25]}
testcase	{0x66, 0xD5, 0x11, 0xF7, 0x11},	{not word [r25]}
testcase	{0xD5, 0x11, 0xF7, 0x11},	{not dword [r25]}
testcase	{0xD5, 0x19, 0xF7, 0x11},	{not qword [r25]}

; implicit evex through ND
testcase	{0x62, 0xF4, 0x6C, 0x18, 0xF6, 0x11},	{not dl, byte [rcx]}
testcase	{0x62, 0xF4, 0x6D, 0x18, 0xF7, 0x11},	{not dx, word [rcx]}
testcase	{0x62, 0xF4, 0x6C, 0x18, 0xF7, 0x11},	{not edx, dword [rcx]}
testcase	{0x62, 0xF4, 0xEC, 0x18, 0xF7, 0x11},	{not rdx, qword [rcx]}

; --- pdep instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x33, 0xF5, 0x0A},	{pdep ecx, r9d, [rdx]}
testcase	{0xC4, 0xE2, 0xB3, 0xF5, 0x0A},	{pdep rcx, r9, [rdx]}

; implicit evex through EGPRs
testcase	{0x62, 0xF2, 0x37, 0x00, 0xF5, 0x0A},	{pdep ecx, r25d, [rdx]}
testcase	{0x62, 0xF2, 0xB7, 0x00, 0xF5, 0x0A},	{pdep rcx, r25, [rdx]}

; --- pext instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x32, 0xF5, 0x0A},	{pext ecx, r9d, [rdx]}
testcase	{0xC4, 0xE2, 0xB2, 0xF5, 0x0A},	{pext rcx, r9, [rdx]}

; implicit evex through EGPRs
testcase	{0x62, 0xF2, 0x36, 0x00, 0xF5, 0x0A},	{pext ecx, r25d, [rdx]}
testcase	{0x62, 0xF2, 0xB6, 0x00, 0xF5, 0x0A},	{pext rcx, r25, [rdx]}

; --- popcnt instruction ---
; legacy
testcase	{0x66, 0xF3, 0x0F, 0xB8, 0x0A},	{popcnt cx, [rdx]}
testcase	{0xF3, 0x0F, 0xB8, 0x0A},	{popcnt ecx, [rdx]}
testcase	{0xF3, 0x48, 0x0F, 0xB8, 0x0A},	{popcnt rcx, [rdx]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7D, 0x0C ,0x88, 0x0A},	{popcnt{nf} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x88, 0x0A},	{popcnt{nf} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x88, 0x0A},	{popcnt{nf} rcx, [rdx]}

; implicit evex through EGPRs
testcase	{0x66, 0xF3, 0xD5, 0xC4, 0xB8, 0x0A},	{popcnt r25w, [rdx]}
testcase	{0xF3, 0xD5, 0xC4, 0xB8, 0x0A},	{popcnt r25d, [rdx]}
testcase	{0xF3, 0xD5, 0xCC, 0xB8, 0x0A},	{popcnt r25, [rdx]}

; --- rdmsr instruction ---
; legacy
testcase	{0x0F, 0x32},					{rdmsr}
; apx
testcase	{0x62, 0xDF, 0x7F, 0x08, 0xF6, 0xC1,\
			0xFF, 0xFF, 0xFF, 0xFF},		{rdmsr r25, 0xFFFFFFFF}

; --- sttilecfg instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x79, 0x49, 0x02},			{sttilecfg [rdx]}
; apx
testcase	{0x62, 0xDA, 0x7D, 0x08, 0x49, 0x02},		{sttilecfg [r26]}

; --- tileloadd[t1] instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x7B, 0x4B, 0x0C, 0x22},		{tileloadd tmm1, [rdx]}
testcase	{0xC4, 0xE2, 0x79, 0x4B, 0x0C, 0x22},		{tileloaddt1 tmm1, [rdx]}
; apx
testcase	{0x62, 0xDA, 0x7F, 0x08, 0x4B, 0x0C, 0x22},		{tileloadd tmm1, [r26]}
testcase	{0x62, 0xDA, 0x7D, 0x08, 0x4B, 0x0C, 0x22},		{tileloaddt1 tmm1, [r26]}

; --- tileloaddrs[t1] instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x7B, 0x4A, 0x0C, 0x22},		{tileloaddrs tmm1, [rdx]}
testcase	{0xC4, 0xE2, 0x79, 0x4A, 0x0C, 0x22},		{tileloaddrst1 tmm1, [rdx]}
; apx
testcase	{0x62, 0xDA, 0x7F, 0x08, 0x4A, 0x0C, 0x22},		{tileloaddrs tmm1, [r26]}
testcase	{0x62, 0xDA, 0x7D, 0x08, 0x4A, 0x0C, 0x22},		{tileloaddrst1 tmm1, [r26]}

; --- tilestored instruction ---
; legacy
testcase	{0xC4, 0xE2, 0x7A, 0x4B, 0x0C, 0x22},		{tilestored [rdx], tmm1}
; apx
testcase	{0x62, 0xDA, 0x7E, 0x08, 0x4B, 0x0C, 0x22},		{tilestored [r26], tmm1}

; --- tzcnt instruction ---
; legacy
testcase	{0x66, 0xF3, 0x0F, 0xBC, 0x0A},			{tzcnt cx, [rdx]}
testcase	{0xF3, 0x0F, 0xBC, 0x0A},			{tzcnt ecx, [rdx]}
testcase	{0xF3, 0x48, 0x0F, 0xBC, 0x0A},			{tzcnt rcx, [rdx]}

; implicit rex2 through EGPRs
testcase	{0x66, 0xF3, 0xD5, 0x91, 0xBC, 0x0A},			{tzcnt cx, [r26]}
testcase	{0xF3, 0xD5, 0x91, 0xBC, 0x0A},				{tzcnt ecx, [r26]}
testcase	{0xF3, 0xD5, 0x99, 0xBC, 0x0A},				{tzcnt rcx, [r26]}

; implicit evex through NF
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0xF4, 0x0A},			{tzcnt{nf} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0xF4, 0x0A},			{tzcnt{nf} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0xF4, 0x0A},			{tzcnt{nf} rcx, [rdx]}

; --- urdmsr instruction ---
; legacy
testcase	{0xF2, 0x0F, 0x38, 0xF8, 0xCA},			{urdmsr rdx, rcx}
testcase	{0xC4, 0xE7, 0x7B, 0xF8, 0xC2, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{urdmsr rdx, 0xFFFFFFFF}
; apx
testcase	{0x62, 0xDC, 0x7F, 0x08, 0xF8, 0xCA},		{urdmsr r26, rcx}
testcase	{0x62, 0xDF, 0x7F, 0x08, 0xF8, 0xC2, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{urdmsr r26, 0xFFFFFFFF}

; --- uwrmsr instruction ---
; legacy
testcase	{0xF3, 0x0F, 0x38, 0xF8, 0xCA},			{uwrmsr rdx, rcx}
testcase	{0xC4, 0xE7, 0x7A, 0xF8, 0xC2, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{uwrmsr rdx, 0xFFFFFFFF}
; apx
testcase	{0x62, 0xDC, 0x7E, 0x08, 0xF8, 0xCA},		{uwrmsr r26, rcx}
testcase	{0x62, 0xDF, 0x7E, 0x08, 0xF8, 0xC2, 0xFF, 0xFF, 0xFF, 0xFF}, \
			{uwrmsr r26, 0xFFFFFFFF}

; --- wrmsrns instruction ---
; legacy
testcase	{0x0F, 0x01, 0xC6},			{wrmsrns}
; apx
testcase	{0x62, 0xDF, 0x7E, 0x08, 0xF6, 0xC2,\
			0x00, 0x01, 0x00, 0x00},	{wrmsrns 0x100, r26}

; --- wrssd/wrssq instructions ---
; legacy
testcase	{0x0F, 0x38, 0xF6, 0x0A},		{wrssd [rdx], ecx}
testcase	{0x48, 0x0F, 0x38, 0xF6, 0x0A},		{wrssq [rdx], rcx}
; apx
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x66, 0x0A},	{wrssd [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x66, 0x0A},	{wrssq [r26], rcx}

; --- wrussd/wrussq instructions ---
; legacy
testcase	{0x66, 0x0F, 0x38, 0xF5, 0x0A},		{wrussd [rdx], ecx}
testcase	{0x66, 0x48, 0x0F, 0x38, 0xF5, 0x0A},	{wrussq [rdx], rcx}
; apx
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x65, 0x0A},	{wrussd [r26], ecx}
testcase	{0x62, 0xDC, 0xFD, 0x08, 0x65, 0x0A},	{wrussq [r26], rcx}

; --- jmpabs instruction ---
testcase	{0xD5, 0x00, 0xA1, 0x00, 0x00, 0x00, 0x00, \
			0x00, 0x00, 0xFF, 0xFF},	{jmpabs 0xFFFF000000000000}

; --- setcc instruction ---
; implicit rex2 through EGPRs
testcase	{0xD5, 0x91, 0x92, 0xC1},	{setb r25b}
testcase	{0xD5, 0x91, 0x96, 0xC1},	{setbe r25b}
testcase	{0xD5, 0x91, 0x9C, 0xC1},	{setl r25b}
testcase	{0xD5, 0x91, 0x9E, 0xC1},	{setle r25b}
testcase	{0xD5, 0x91, 0x93, 0xC1},	{setnb r25b}
testcase	{0xD5, 0x91, 0x97, 0xC1},	{setnbe r25b}
testcase	{0xD5, 0x91, 0x9D, 0xC1},	{setnl r25b}
testcase	{0xD5, 0x91, 0x9F, 0xC1},	{setnle r25b}
testcase	{0xD5, 0x91, 0x91, 0xC1},	{setno r25b}
testcase	{0xD5, 0x91, 0x9B, 0xC1},	{setnp r25b}
testcase	{0xD5, 0x91, 0x99, 0xC1},	{setns r25b}
testcase	{0xD5, 0x91, 0x95, 0xC1},	{setnz r25b}
testcase	{0xD5, 0x91, 0x90, 0xC1},	{seto r25b}
testcase	{0xD5, 0x91, 0x9A, 0xC1},	{setp r25b}
testcase	{0xD5, 0x91, 0x98, 0xC1},	{sets r25b}
testcase	{0xD5, 0x91, 0x94, 0xC1},	{setz r25b}
; implicit evex through ND=ZU
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x42, 0xC1},	{setb{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x46, 0xC1},	{setbe{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x4C, 0xC1},	{setl{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x4E, 0xC1},	{setle{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x43, 0xC1},	{setnb{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x47, 0xC1},	{setnbe{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x4D, 0xC1},	{setnl{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x4F, 0xC1},	{setnle{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x41, 0xC1},	{setno{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x4B, 0xC1},	{setnp{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x49, 0xC1},	{setns{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x45, 0xC1},	{setnz{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x40, 0xC1},	{seto{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x4A, 0xC1},	{setp{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x48, 0xC1},	{sets{zu} r25b}
testcase	{0x62, 0xDC, 0x7F, 0x18, 0x44, 0xC1},	{setz{zu} r25b}

; --- pop[2][p] / push[2][p] --- instructions
testcase	{0x62, 0xDC, 0x34, 0x10, 0x8F, 0xC2},	{pop2 r25, r26}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0x8F, 0xC2},	{pop2p r25, r26}
testcase	{0xD5, 0x19, 0x59},			{popp r25}
testcase	{0x62, 0xDC, 0x34, 0x10, 0xFF, 0xF2},	{push2 r25, r26}
testcase	{0x62, 0xDC, 0xB4, 0x10, 0xFF, 0xF2},	{push2p r25, r26}
testcase	{0xD5, 0x19, 0x51},			{pushp r25}
