/*
Copyright 2018 Ioannis Makris

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// This file was generated by glatter.py script.



#ifdef GLATTER_GL
#if defined(__GL_H__)
#if !defined(GL_VERSION_ES_CM_1_0)
#if defined(__gl_h_)
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glAccum, (op, value), (GLenum op, GLfloat value))
GLATTER_INLINE_OR_NOT void glatter_glAccum_debug(GLenum op, GLfloat value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAccum, "(%s, %f)", enum_to_string_GL(op), (float)value)
    glatter_glAccum(op, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAccum_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glAlphaFunc, (func, ref), (GLenum func, GLclampf ref))
GLATTER_INLINE_OR_NOT void glatter_glAlphaFunc_debug(GLenum func, GLclampf ref, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAlphaFunc, "(%s, %f)", enum_to_string_GL(func), (float)ref)
    glatter_glAlphaFunc(func, ref);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAlphaFunc_defined
GLATTER_FBLOCK(return, GL, WINGDIAPI, GLboolean, APIENTRY, glAreTexturesResident, (n, textures, residences), (GLsizei n, const GLuint *textures, GLboolean *residences))
GLATTER_INLINE_OR_NOT GLboolean glatter_glAreTexturesResident_debug(GLsizei n, const GLuint *textures, GLboolean *residences, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAreTexturesResident, "(%d, %p, %p)", (int)n, (void*)textures, (void*)residences)
    GLboolean rval = glatter_glAreTexturesResident(n, textures, residences);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glAreTexturesResident_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glArrayElement, (i), (GLint i))
GLATTER_INLINE_OR_NOT void glatter_glArrayElement_debug(GLint i, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glArrayElement, "(%d)", (int)i)
    glatter_glArrayElement(i);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glArrayElement_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glBegin, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glBegin_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBegin, "(%s)", enum_to_string_GL(mode))
    glatter_glBegin(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBegin_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glBindTexture, (target, texture), (GLenum target, GLuint texture))
GLATTER_INLINE_OR_NOT void glatter_glBindTexture_debug(GLenum target, GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindTexture, "(%s, %u)", enum_to_string_GL(target), (unsigned int)texture)
    glatter_glBindTexture(target, texture);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindTexture_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glBitmap, (width, height, xorig, yorig, xmove, ymove, bitmap), (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap))
GLATTER_INLINE_OR_NOT void glatter_glBitmap_debug(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBitmap, "(%d, %d, %f, %f, %f, %f, %p)", (int)width, (int)height, (float)xorig, (float)yorig, (float)xmove, (float)ymove, (void*)bitmap)
    glatter_glBitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBitmap_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glBlendFunc, (sfactor, dfactor), (GLenum sfactor, GLenum dfactor))
GLATTER_INLINE_OR_NOT void glatter_glBlendFunc_debug(GLenum sfactor, GLenum dfactor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFunc, "(%s, %s)", enum_to_string_GL(sfactor), enum_to_string_GL(dfactor))
    glatter_glBlendFunc(sfactor, dfactor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFunc_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glCallList, (list), (GLuint list))
GLATTER_INLINE_OR_NOT void glatter_glCallList_debug(GLuint list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCallList, "(%u)", (unsigned int)list)
    glatter_glCallList(list);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCallList_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glCallLists, (n, type, lists), (GLsizei n, GLenum type, const GLvoid *lists))
GLATTER_INLINE_OR_NOT void glatter_glCallLists_debug(GLsizei n, GLenum type, const GLvoid *lists, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCallLists, "(%d, %s, %p)", (int)n, enum_to_string_GL(type), (void*)lists)
    glatter_glCallLists(n, type, lists);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCallLists_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glClear, (mask), (GLbitfield mask))
GLATTER_INLINE_OR_NOT void glatter_glClear_debug(GLbitfield mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClear, "(%u)", (unsigned int)mask)
    glatter_glClear(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClear_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glClearAccum, (red, green, blue, alpha), (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha))
GLATTER_INLINE_OR_NOT void glatter_glClearAccum_debug(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearAccum, "(%f, %f, %f, %f)", (float)red, (float)green, (float)blue, (float)alpha)
    glatter_glClearAccum(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearAccum_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glClearColor, (red, green, blue, alpha), (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha))
GLATTER_INLINE_OR_NOT void glatter_glClearColor_debug(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearColor, "(%f, %f, %f, %f)", (float)red, (float)green, (float)blue, (float)alpha)
    glatter_glClearColor(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearColor_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glClearDepth, (depth), (GLclampd depth))
GLATTER_INLINE_OR_NOT void glatter_glClearDepth_debug(GLclampd depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearDepth, "(%f)", (double)depth)
    glatter_glClearDepth(depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearDepth_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glClearIndex, (c), (GLfloat c))
GLATTER_INLINE_OR_NOT void glatter_glClearIndex_debug(GLfloat c, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearIndex, "(%f)", (float)c)
    glatter_glClearIndex(c);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearIndex_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glClearStencil, (s), (GLint s))
GLATTER_INLINE_OR_NOT void glatter_glClearStencil_debug(GLint s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearStencil, "(%d)", (int)s)
    glatter_glClearStencil(s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearStencil_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glClipPlane, (plane, equation), (GLenum plane, const GLdouble *equation))
GLATTER_INLINE_OR_NOT void glatter_glClipPlane_debug(GLenum plane, const GLdouble *equation, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClipPlane, "(%s, %p)", enum_to_string_GL(plane), (void*)equation)
    glatter_glClipPlane(plane, equation);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClipPlane_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3b, (red, green, blue), (GLbyte red, GLbyte green, GLbyte blue))
GLATTER_INLINE_OR_NOT void glatter_glColor3b_debug(GLbyte red, GLbyte green, GLbyte blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3b, "(%d, %d, %d)", (signed char)red, (signed char)green, (signed char)blue)
    glatter_glColor3b(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3b_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3bv, (v), (const GLbyte *v))
GLATTER_INLINE_OR_NOT void glatter_glColor3bv_debug(const GLbyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3bv, "(%p)", (void*)v)
    glatter_glColor3bv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3bv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3d, (red, green, blue), (GLdouble red, GLdouble green, GLdouble blue))
GLATTER_INLINE_OR_NOT void glatter_glColor3d_debug(GLdouble red, GLdouble green, GLdouble blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3d, "(%f, %f, %f)", (double)red, (double)green, (double)blue)
    glatter_glColor3d(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glColor3dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3dv, "(%p)", (void*)v)
    glatter_glColor3dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3f, (red, green, blue), (GLfloat red, GLfloat green, GLfloat blue))
GLATTER_INLINE_OR_NOT void glatter_glColor3f_debug(GLfloat red, GLfloat green, GLfloat blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3f, "(%f, %f, %f)", (float)red, (float)green, (float)blue)
    glatter_glColor3f(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glColor3fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3fv, "(%p)", (void*)v)
    glatter_glColor3fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3i, (red, green, blue), (GLint red, GLint green, GLint blue))
GLATTER_INLINE_OR_NOT void glatter_glColor3i_debug(GLint red, GLint green, GLint blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3i, "(%d, %d, %d)", (int)red, (int)green, (int)blue)
    glatter_glColor3i(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glColor3iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3iv, "(%p)", (void*)v)
    glatter_glColor3iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3s, (red, green, blue), (GLshort red, GLshort green, GLshort blue))
GLATTER_INLINE_OR_NOT void glatter_glColor3s_debug(GLshort red, GLshort green, GLshort blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3s, "(%hi, %hi, %hi)", (short)red, (short)green, (short)blue)
    glatter_glColor3s(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glColor3sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3sv, "(%p)", (void*)v)
    glatter_glColor3sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3ub, (red, green, blue), (GLubyte red, GLubyte green, GLubyte blue))
GLATTER_INLINE_OR_NOT void glatter_glColor3ub_debug(GLubyte red, GLubyte green, GLubyte blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3ub, "(%u, %u, %u)", (unsigned char)red, (unsigned char)green, (unsigned char)blue)
    glatter_glColor3ub(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3ub_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3ubv, (v), (const GLubyte *v))
GLATTER_INLINE_OR_NOT void glatter_glColor3ubv_debug(const GLubyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3ubv, "(%p)", (void*)v)
    glatter_glColor3ubv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3ubv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3ui, (red, green, blue), (GLuint red, GLuint green, GLuint blue))
GLATTER_INLINE_OR_NOT void glatter_glColor3ui_debug(GLuint red, GLuint green, GLuint blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3ui, "(%u, %u, %u)", (unsigned int)red, (unsigned int)green, (unsigned int)blue)
    glatter_glColor3ui(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3ui_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3uiv, (v), (const GLuint *v))
GLATTER_INLINE_OR_NOT void glatter_glColor3uiv_debug(const GLuint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3uiv, "(%p)", (void*)v)
    glatter_glColor3uiv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3uiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3us, (red, green, blue), (GLushort red, GLushort green, GLushort blue))
GLATTER_INLINE_OR_NOT void glatter_glColor3us_debug(GLushort red, GLushort green, GLushort blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3us, "(%hu, %hu, %hu)", (unsigned short)red, (unsigned short)green, (unsigned short)blue)
    glatter_glColor3us(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3us_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor3usv, (v), (const GLushort *v))
GLATTER_INLINE_OR_NOT void glatter_glColor3usv_debug(const GLushort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3usv, "(%p)", (void*)v)
    glatter_glColor3usv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3usv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4b, (red, green, blue, alpha), (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4b_debug(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4b, "(%d, %d, %d, %d)", (signed char)red, (signed char)green, (signed char)blue, (signed char)alpha)
    glatter_glColor4b(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4b_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4bv, (v), (const GLbyte *v))
GLATTER_INLINE_OR_NOT void glatter_glColor4bv_debug(const GLbyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4bv, "(%p)", (void*)v)
    glatter_glColor4bv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4bv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4d, (red, green, blue, alpha), (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4d_debug(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4d, "(%f, %f, %f, %f)", (double)red, (double)green, (double)blue, (double)alpha)
    glatter_glColor4d(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glColor4dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4dv, "(%p)", (void*)v)
    glatter_glColor4dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4f, (red, green, blue, alpha), (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4f_debug(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4f, "(%f, %f, %f, %f)", (float)red, (float)green, (float)blue, (float)alpha)
    glatter_glColor4f(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glColor4fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4fv, "(%p)", (void*)v)
    glatter_glColor4fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4i, (red, green, blue, alpha), (GLint red, GLint green, GLint blue, GLint alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4i_debug(GLint red, GLint green, GLint blue, GLint alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4i, "(%d, %d, %d, %d)", (int)red, (int)green, (int)blue, (int)alpha)
    glatter_glColor4i(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glColor4iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4iv, "(%p)", (void*)v)
    glatter_glColor4iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4s, (red, green, blue, alpha), (GLshort red, GLshort green, GLshort blue, GLshort alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4s_debug(GLshort red, GLshort green, GLshort blue, GLshort alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4s, "(%hi, %hi, %hi, %hi)", (short)red, (short)green, (short)blue, (short)alpha)
    glatter_glColor4s(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glColor4sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4sv, "(%p)", (void*)v)
    glatter_glColor4sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4ub, (red, green, blue, alpha), (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4ub_debug(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4ub, "(%u, %u, %u, %u)", (unsigned char)red, (unsigned char)green, (unsigned char)blue, (unsigned char)alpha)
    glatter_glColor4ub(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4ub_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4ubv, (v), (const GLubyte *v))
GLATTER_INLINE_OR_NOT void glatter_glColor4ubv_debug(const GLubyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4ubv, "(%p)", (void*)v)
    glatter_glColor4ubv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4ubv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4ui, (red, green, blue, alpha), (GLuint red, GLuint green, GLuint blue, GLuint alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4ui_debug(GLuint red, GLuint green, GLuint blue, GLuint alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4ui, "(%u, %u, %u, %u)", (unsigned int)red, (unsigned int)green, (unsigned int)blue, (unsigned int)alpha)
    glatter_glColor4ui(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4ui_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4uiv, (v), (const GLuint *v))
GLATTER_INLINE_OR_NOT void glatter_glColor4uiv_debug(const GLuint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4uiv, "(%p)", (void*)v)
    glatter_glColor4uiv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4uiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4us, (red, green, blue, alpha), (GLushort red, GLushort green, GLushort blue, GLushort alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4us_debug(GLushort red, GLushort green, GLushort blue, GLushort alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4us, "(%hu, %hu, %hu, %hu)", (unsigned short)red, (unsigned short)green, (unsigned short)blue, (unsigned short)alpha)
    glatter_glColor4us(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4us_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColor4usv, (v), (const GLushort *v))
GLATTER_INLINE_OR_NOT void glatter_glColor4usv_debug(const GLushort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4usv, "(%p)", (void*)v)
    glatter_glColor4usv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4usv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColorMask, (red, green, blue, alpha), (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha))
GLATTER_INLINE_OR_NOT void glatter_glColorMask_debug(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorMask, "(%u, %u, %u, %u)", (unsigned char)red, (unsigned char)green, (unsigned char)blue, (unsigned char)alpha)
    glatter_glColorMask(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorMask_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColorMaterial, (face, mode), (GLenum face, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glColorMaterial_debug(GLenum face, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorMaterial, "(%s, %s)", enum_to_string_GL(face), enum_to_string_GL(mode))
    glatter_glColorMaterial(face, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorMaterial_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glColorPointer, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GLATTER_INLINE_OR_NOT void glatter_glColorPointer_debug(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorPointer, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glColorPointer(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorPointer_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glCopyPixels, (x, y, width, height, type), (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type))
GLATTER_INLINE_OR_NOT void glatter_glCopyPixels_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyPixels, "(%d, %d, %d, %d, %s)", (int)x, (int)y, (int)width, (int)height, enum_to_string_GL(type))
    glatter_glCopyPixels(x, y, width, height, type);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyPixels_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glCopyTexImage1D, (target, level, internalFormat, x, y, width, border), (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexImage1D_debug(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexImage1D, "(%s, %d, %s, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalFormat), (int)x, (int)y, (int)width, (int)border)
    glatter_glCopyTexImage1D(target, level, internalFormat, x, y, width, border);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexImage1D_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glCopyTexImage2D, (target, level, internalFormat, x, y, width, height, border), (GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexImage2D_debug(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexImage2D, "(%s, %d, %s, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalFormat), (int)x, (int)y, (int)width, (int)height, (int)border)
    glatter_glCopyTexImage2D(target, level, internalFormat, x, y, width, height, border);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexImage2D_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glCopyTexSubImage1D, (target, level, xoffset, x, y, width), (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage1D_debug(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexSubImage1D, "(%s, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)x, (int)y, (int)width)
    glatter_glCopyTexSubImage1D(target, level, xoffset, x, y, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexSubImage1D_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glCopyTexSubImage2D, (target, level, xoffset, yoffset, x, y, width, height), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage2D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexSubImage2D, "(%s, %d, %d, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexSubImage2D_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glCullFace, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glCullFace_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCullFace, "(%s)", enum_to_string_GL(mode))
    glatter_glCullFace(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCullFace_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glDeleteLists, (list, range), (GLuint list, GLsizei range))
GLATTER_INLINE_OR_NOT void glatter_glDeleteLists_debug(GLuint list, GLsizei range, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteLists, "(%u, %d)", (unsigned int)list, (int)range)
    glatter_glDeleteLists(list, range);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteLists_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glDeleteTextures, (n, textures), (GLsizei n, const GLuint *textures))
GLATTER_INLINE_OR_NOT void glatter_glDeleteTextures_debug(GLsizei n, const GLuint *textures, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteTextures, "(%d, %p)", (int)n, (void*)textures)
    glatter_glDeleteTextures(n, textures);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteTextures_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glDepthFunc, (func), (GLenum func))
GLATTER_INLINE_OR_NOT void glatter_glDepthFunc_debug(GLenum func, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthFunc, "(%s)", enum_to_string_GL(func))
    glatter_glDepthFunc(func);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthFunc_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glDepthMask, (flag), (GLboolean flag))
GLATTER_INLINE_OR_NOT void glatter_glDepthMask_debug(GLboolean flag, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthMask, "(%u)", (unsigned char)flag)
    glatter_glDepthMask(flag);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthMask_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glDepthRange, (zNear, zFar), (GLclampd zNear, GLclampd zFar))
GLATTER_INLINE_OR_NOT void glatter_glDepthRange_debug(GLclampd zNear, GLclampd zFar, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthRange, "(%f, %f)", (double)zNear, (double)zFar)
    glatter_glDepthRange(zNear, zFar);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthRange_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glDisable, (cap), (GLenum cap))
GLATTER_INLINE_OR_NOT void glatter_glDisable_debug(GLenum cap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisable, "(%s)", enum_to_string_GL(cap))
    glatter_glDisable(cap);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisable_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glDisableClientState, (array), (GLenum array))
GLATTER_INLINE_OR_NOT void glatter_glDisableClientState_debug(GLenum array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableClientState, "(%s)", enum_to_string_GL(array))
    glatter_glDisableClientState(array);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableClientState_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glDrawArrays, (mode, first, count), (GLenum mode, GLint first, GLsizei count))
GLATTER_INLINE_OR_NOT void glatter_glDrawArrays_debug(GLenum mode, GLint first, GLsizei count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArrays, "(%s, %d, %d)", enum_to_string_GL(mode), (int)first, (int)count)
    glatter_glDrawArrays(mode, first, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArrays_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glDrawBuffer, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glDrawBuffer_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawBuffer, "(%s)", enum_to_string_GL(mode))
    glatter_glDrawBuffer(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawBuffer_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glDrawElements, (mode, count, type, indices), (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices))
GLATTER_INLINE_OR_NOT void glatter_glDrawElements_debug(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElements, "(%s, %d, %s, %p)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices)
    glatter_glDrawElements(mode, count, type, indices);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElements_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glDrawPixels, (width, height, format, type, pixels), (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels))
GLATTER_INLINE_OR_NOT void glatter_glDrawPixels_debug(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawPixels, "(%d, %d, %s, %s, %p)", (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glDrawPixels(width, height, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawPixels_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEdgeFlag, (flag), (GLboolean flag))
GLATTER_INLINE_OR_NOT void glatter_glEdgeFlag_debug(GLboolean flag, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEdgeFlag, "(%u)", (unsigned char)flag)
    glatter_glEdgeFlag(flag);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEdgeFlag_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEdgeFlagPointer, (stride, pointer), (GLsizei stride, const GLvoid *pointer))
GLATTER_INLINE_OR_NOT void glatter_glEdgeFlagPointer_debug(GLsizei stride, const GLvoid *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEdgeFlagPointer, "(%d, %p)", (int)stride, (void*)pointer)
    glatter_glEdgeFlagPointer(stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEdgeFlagPointer_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEdgeFlagv, (flag), (const GLboolean *flag))
GLATTER_INLINE_OR_NOT void glatter_glEdgeFlagv_debug(const GLboolean *flag, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEdgeFlagv, "(%p)", (void*)flag)
    glatter_glEdgeFlagv(flag);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEdgeFlagv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEnable, (cap), (GLenum cap))
GLATTER_INLINE_OR_NOT void glatter_glEnable_debug(GLenum cap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnable, "(%s)", enum_to_string_GL(cap))
    glatter_glEnable(cap);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnable_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEnableClientState, (array), (GLenum array))
GLATTER_INLINE_OR_NOT void glatter_glEnableClientState_debug(GLenum array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableClientState, "(%s)", enum_to_string_GL(array))
    glatter_glEnableClientState(array);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableClientState_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEnd, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glEnd_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnd, "()")
    glatter_glEnd();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnd_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEndList, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glEndList_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndList, "()")
    glatter_glEndList();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndList_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalCoord1d, (u), (GLdouble u))
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord1d_debug(GLdouble u, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalCoord1d, "(%f)", (double)u)
    glatter_glEvalCoord1d(u);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalCoord1d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalCoord1dv, (u), (const GLdouble *u))
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord1dv_debug(const GLdouble *u, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalCoord1dv, "(%p)", (void*)u)
    glatter_glEvalCoord1dv(u);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalCoord1dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalCoord1f, (u), (GLfloat u))
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord1f_debug(GLfloat u, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalCoord1f, "(%f)", (float)u)
    glatter_glEvalCoord1f(u);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalCoord1f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalCoord1fv, (u), (const GLfloat *u))
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord1fv_debug(const GLfloat *u, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalCoord1fv, "(%p)", (void*)u)
    glatter_glEvalCoord1fv(u);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalCoord1fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalCoord2d, (u, v), (GLdouble u, GLdouble v))
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord2d_debug(GLdouble u, GLdouble v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalCoord2d, "(%f, %f)", (double)u, (double)v)
    glatter_glEvalCoord2d(u, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalCoord2d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalCoord2dv, (u), (const GLdouble *u))
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord2dv_debug(const GLdouble *u, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalCoord2dv, "(%p)", (void*)u)
    glatter_glEvalCoord2dv(u);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalCoord2dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalCoord2f, (u, v), (GLfloat u, GLfloat v))
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord2f_debug(GLfloat u, GLfloat v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalCoord2f, "(%f, %f)", (float)u, (float)v)
    glatter_glEvalCoord2f(u, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalCoord2f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalCoord2fv, (u), (const GLfloat *u))
GLATTER_INLINE_OR_NOT void glatter_glEvalCoord2fv_debug(const GLfloat *u, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalCoord2fv, "(%p)", (void*)u)
    glatter_glEvalCoord2fv(u);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalCoord2fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalMesh1, (mode, i1, i2), (GLenum mode, GLint i1, GLint i2))
GLATTER_INLINE_OR_NOT void glatter_glEvalMesh1_debug(GLenum mode, GLint i1, GLint i2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalMesh1, "(%s, %d, %d)", enum_to_string_GL(mode), (int)i1, (int)i2)
    glatter_glEvalMesh1(mode, i1, i2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalMesh1_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalMesh2, (mode, i1, i2, j1, j2), (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2))
GLATTER_INLINE_OR_NOT void glatter_glEvalMesh2_debug(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalMesh2, "(%s, %d, %d, %d, %d)", enum_to_string_GL(mode), (int)i1, (int)i2, (int)j1, (int)j2)
    glatter_glEvalMesh2(mode, i1, i2, j1, j2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalMesh2_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalPoint1, (i), (GLint i))
GLATTER_INLINE_OR_NOT void glatter_glEvalPoint1_debug(GLint i, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalPoint1, "(%d)", (int)i)
    glatter_glEvalPoint1(i);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalPoint1_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glEvalPoint2, (i, j), (GLint i, GLint j))
GLATTER_INLINE_OR_NOT void glatter_glEvalPoint2_debug(GLint i, GLint j, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalPoint2, "(%d, %d)", (int)i, (int)j)
    glatter_glEvalPoint2(i, j);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalPoint2_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glFeedbackBuffer, (size, type, buffer), (GLsizei size, GLenum type, GLfloat *buffer))
GLATTER_INLINE_OR_NOT void glatter_glFeedbackBuffer_debug(GLsizei size, GLenum type, GLfloat *buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFeedbackBuffer, "(%d, %s, %p)", (int)size, enum_to_string_GL(type), (void*)buffer)
    glatter_glFeedbackBuffer(size, type, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFeedbackBuffer_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glFinish, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glFinish_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFinish, "()")
    glatter_glFinish();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFinish_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glFlush, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glFlush_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFlush, "()")
    glatter_glFlush();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFlush_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glFogf, (pname, param), (GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glFogf_debug(GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogf, "(%s, %f)", enum_to_string_GL(pname), (float)param)
    glatter_glFogf(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glFogfv, (pname, params), (GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glFogfv_debug(GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogfv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glFogfv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glFogi, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glFogi_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogi, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glFogi(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogi_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glFogiv, (pname, params), (GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glFogiv_debug(GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogiv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glFogiv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glFrontFace, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glFrontFace_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFrontFace, "(%s)", enum_to_string_GL(mode))
    glatter_glFrontFace(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFrontFace_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glFrustum, (left, right, bottom, top, zNear, zFar), (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GLATTER_INLINE_OR_NOT void glatter_glFrustum_debug(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFrustum, "(%f, %f, %f, %f, %f, %f)", (double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar)
    glatter_glFrustum(left, right, bottom, top, zNear, zFar);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFrustum_defined
GLATTER_FBLOCK(return, GL, WINGDIAPI, GLuint, APIENTRY, glGenLists, (range), (GLsizei range))
GLATTER_INLINE_OR_NOT GLuint glatter_glGenLists_debug(GLsizei range, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenLists, "(%d)", (int)range)
    GLuint rval = glatter_glGenLists(range);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGenLists_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGenTextures, (n, textures), (GLsizei n, GLuint *textures))
GLATTER_INLINE_OR_NOT void glatter_glGenTextures_debug(GLsizei n, GLuint *textures, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenTextures, "(%d, %p)", (int)n, (void*)textures)
    glatter_glGenTextures(n, textures);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenTextures_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetBooleanv, (pname, params), (GLenum pname, GLboolean *params))
GLATTER_INLINE_OR_NOT void glatter_glGetBooleanv_debug(GLenum pname, GLboolean *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBooleanv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetBooleanv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBooleanv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetClipPlane, (plane, equation), (GLenum plane, GLdouble *equation))
GLATTER_INLINE_OR_NOT void glatter_glGetClipPlane_debug(GLenum plane, GLdouble *equation, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetClipPlane, "(%s, %p)", enum_to_string_GL(plane), (void*)equation)
    glatter_glGetClipPlane(plane, equation);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetClipPlane_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetDoublev, (pname, params), (GLenum pname, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glGetDoublev_debug(GLenum pname, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetDoublev, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetDoublev(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetDoublev_defined
GLATTER_FBLOCK(return, GL, WINGDIAPI, GLenum, APIENTRY, glGetError, (), (void))
GLATTER_INLINE_OR_NOT GLenum glatter_glGetError_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetError, "()")
    GLenum rval = glatter_glGetError();
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetError_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetFloatv, (pname, params), (GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFloatv_debug(GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFloatv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetFloatv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFloatv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetIntegerv, (pname, params), (GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetIntegerv_debug(GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetIntegerv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetIntegerv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetIntegerv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetLightfv, (light, pname, params), (GLenum light, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetLightfv_debug(GLenum light, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetLightfv, "(%s, %s, %p)", enum_to_string_GL(light), enum_to_string_GL(pname), (void*)params)
    glatter_glGetLightfv(light, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetLightfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetLightiv, (light, pname, params), (GLenum light, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetLightiv_debug(GLenum light, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetLightiv, "(%s, %s, %p)", enum_to_string_GL(light), enum_to_string_GL(pname), (void*)params)
    glatter_glGetLightiv(light, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetLightiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetMapdv, (target, query, v), (GLenum target, GLenum query, GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glGetMapdv_debug(GLenum target, GLenum query, GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMapdv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(query), (void*)v)
    glatter_glGetMapdv(target, query, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMapdv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetMapfv, (target, query, v), (GLenum target, GLenum query, GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glGetMapfv_debug(GLenum target, GLenum query, GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMapfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(query), (void*)v)
    glatter_glGetMapfv(target, query, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMapfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetMapiv, (target, query, v), (GLenum target, GLenum query, GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glGetMapiv_debug(GLenum target, GLenum query, GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMapiv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(query), (void*)v)
    glatter_glGetMapiv(target, query, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMapiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetMaterialfv, (face, pname, params), (GLenum face, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMaterialfv_debug(GLenum face, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMaterialfv, "(%s, %s, %p)", enum_to_string_GL(face), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMaterialfv(face, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMaterialfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetMaterialiv, (face, pname, params), (GLenum face, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMaterialiv_debug(GLenum face, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMaterialiv, "(%s, %s, %p)", enum_to_string_GL(face), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMaterialiv(face, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMaterialiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetPixelMapfv, (map, values), (GLenum map, GLfloat *values))
GLATTER_INLINE_OR_NOT void glatter_glGetPixelMapfv_debug(GLenum map, GLfloat *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPixelMapfv, "(%s, %p)", enum_to_string_GL(map), (void*)values)
    glatter_glGetPixelMapfv(map, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPixelMapfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetPixelMapuiv, (map, values), (GLenum map, GLuint *values))
GLATTER_INLINE_OR_NOT void glatter_glGetPixelMapuiv_debug(GLenum map, GLuint *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPixelMapuiv, "(%s, %p)", enum_to_string_GL(map), (void*)values)
    glatter_glGetPixelMapuiv(map, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPixelMapuiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetPixelMapusv, (map, values), (GLenum map, GLushort *values))
GLATTER_INLINE_OR_NOT void glatter_glGetPixelMapusv_debug(GLenum map, GLushort *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPixelMapusv, "(%s, %p)", enum_to_string_GL(map), (void*)values)
    glatter_glGetPixelMapusv(map, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPixelMapusv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetPointerv, (pname, params), (GLenum pname, GLvoid* *params))
GLATTER_INLINE_OR_NOT void glatter_glGetPointerv_debug(GLenum pname, GLvoid* *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPointerv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetPointerv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPointerv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetPolygonStipple, (mask), (GLubyte *mask))
GLATTER_INLINE_OR_NOT void glatter_glGetPolygonStipple_debug(GLubyte *mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPolygonStipple, "(%p)", (void*)mask)
    glatter_glGetPolygonStipple(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPolygonStipple_defined
GLATTER_FBLOCK(return, GL, WINGDIAPI, const GLubyte *, APIENTRY, glGetString, (name), (GLenum name))
GLATTER_INLINE_OR_NOT const GLubyte * glatter_glGetString_debug(GLenum name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetString, "(%s)", enum_to_string_GL(name))
    const GLubyte * rval = glatter_glGetString(name);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetString_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetTexEnvfv, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexEnvfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexEnvfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexEnvfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexEnvfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetTexEnviv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexEnviv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexEnviv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexEnviv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexEnviv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetTexGendv, (coord, pname, params), (GLenum coord, GLenum pname, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexGendv_debug(GLenum coord, GLenum pname, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexGendv, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexGendv(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexGendv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetTexGenfv, (coord, pname, params), (GLenum coord, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexGenfv_debug(GLenum coord, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexGenfv, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexGenfv(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexGenfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetTexGeniv, (coord, pname, params), (GLenum coord, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexGeniv_debug(GLenum coord, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexGeniv, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexGeniv(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexGeniv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetTexImage, (target, level, format, type, pixels), (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels))
GLATTER_INLINE_OR_NOT void glatter_glGetTexImage_debug(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexImage, "(%s, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glGetTexImage(target, level, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexImage_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetTexLevelParameterfv, (target, level, pname, params), (GLenum target, GLint level, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexLevelParameterfv_debug(GLenum target, GLint level, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexLevelParameterfv, "(%s, %d, %s, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexLevelParameterfv(target, level, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexLevelParameterfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetTexLevelParameteriv, (target, level, pname, params), (GLenum target, GLint level, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexLevelParameteriv_debug(GLenum target, GLint level, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexLevelParameteriv, "(%s, %d, %s, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexLevelParameteriv(target, level, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexLevelParameteriv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetTexParameterfv, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glGetTexParameteriv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameteriv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glHint, (target, mode), (GLenum target, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glHint_debug(GLenum target, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glHint, "(%s, %s)", enum_to_string_GL(target), enum_to_string_GL(mode))
    glatter_glHint(target, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glHint_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexMask, (mask), (GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glIndexMask_debug(GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexMask, "(%u)", (unsigned int)mask)
    glatter_glIndexMask(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexMask_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexPointer, (type, stride, pointer), (GLenum type, GLsizei stride, const GLvoid *pointer))
GLATTER_INLINE_OR_NOT void glatter_glIndexPointer_debug(GLenum type, GLsizei stride, const GLvoid *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexPointer, "(%s, %d, %p)", enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glIndexPointer(type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexPointer_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexd, (c), (GLdouble c))
GLATTER_INLINE_OR_NOT void glatter_glIndexd_debug(GLdouble c, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexd, "(%f)", (double)c)
    glatter_glIndexd(c);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexd_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexdv, (c), (const GLdouble *c))
GLATTER_INLINE_OR_NOT void glatter_glIndexdv_debug(const GLdouble *c, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexdv, "(%p)", (void*)c)
    glatter_glIndexdv(c);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexdv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexf, (c), (GLfloat c))
GLATTER_INLINE_OR_NOT void glatter_glIndexf_debug(GLfloat c, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexf, "(%f)", (float)c)
    glatter_glIndexf(c);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexfv, (c), (const GLfloat *c))
GLATTER_INLINE_OR_NOT void glatter_glIndexfv_debug(const GLfloat *c, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexfv, "(%p)", (void*)c)
    glatter_glIndexfv(c);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexi, (c), (GLint c))
GLATTER_INLINE_OR_NOT void glatter_glIndexi_debug(GLint c, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexi, "(%d)", (int)c)
    glatter_glIndexi(c);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexi_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexiv, (c), (const GLint *c))
GLATTER_INLINE_OR_NOT void glatter_glIndexiv_debug(const GLint *c, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexiv, "(%p)", (void*)c)
    glatter_glIndexiv(c);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexs, (c), (GLshort c))
GLATTER_INLINE_OR_NOT void glatter_glIndexs_debug(GLshort c, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexs, "(%hi)", (short)c)
    glatter_glIndexs(c);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexs_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexsv, (c), (const GLshort *c))
GLATTER_INLINE_OR_NOT void glatter_glIndexsv_debug(const GLshort *c, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexsv, "(%p)", (void*)c)
    glatter_glIndexsv(c);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexsv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexub, (c), (GLubyte c))
GLATTER_INLINE_OR_NOT void glatter_glIndexub_debug(GLubyte c, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexub, "(%u)", (unsigned char)c)
    glatter_glIndexub(c);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexub_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glIndexubv, (c), (const GLubyte *c))
GLATTER_INLINE_OR_NOT void glatter_glIndexubv_debug(const GLubyte *c, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexubv, "(%p)", (void*)c)
    glatter_glIndexubv(c);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexubv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glInitNames, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glInitNames_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glInitNames, "()")
    glatter_glInitNames();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glInitNames_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glInterleavedArrays, (format, stride, pointer), (GLenum format, GLsizei stride, const GLvoid *pointer))
GLATTER_INLINE_OR_NOT void glatter_glInterleavedArrays_debug(GLenum format, GLsizei stride, const GLvoid *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glInterleavedArrays, "(%s, %d, %p)", enum_to_string_GL(format), (int)stride, (void*)pointer)
    glatter_glInterleavedArrays(format, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glInterleavedArrays_defined
GLATTER_FBLOCK(return, GL, WINGDIAPI, GLboolean, APIENTRY, glIsEnabled, (cap), (GLenum cap))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsEnabled_debug(GLenum cap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsEnabled, "(%s)", enum_to_string_GL(cap))
    GLboolean rval = glatter_glIsEnabled(cap);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsEnabled_defined
GLATTER_FBLOCK(return, GL, WINGDIAPI, GLboolean, APIENTRY, glIsList, (list), (GLuint list))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsList_debug(GLuint list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsList, "(%u)", (unsigned int)list)
    GLboolean rval = glatter_glIsList(list);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsList_defined
GLATTER_FBLOCK(return, GL, WINGDIAPI, GLboolean, APIENTRY, glIsTexture, (texture), (GLuint texture))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTexture_debug(GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsTexture, "(%u)", (unsigned int)texture)
    GLboolean rval = glatter_glIsTexture(texture);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsTexture_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLightModelf, (pname, param), (GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glLightModelf_debug(GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightModelf, "(%s, %f)", enum_to_string_GL(pname), (float)param)
    glatter_glLightModelf(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightModelf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLightModelfv, (pname, params), (GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glLightModelfv_debug(GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightModelfv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glLightModelfv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightModelfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLightModeli, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glLightModeli_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightModeli, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glLightModeli(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightModeli_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLightModeliv, (pname, params), (GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glLightModeliv_debug(GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightModeliv, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glLightModeliv(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightModeliv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLightf, (light, pname, param), (GLenum light, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glLightf_debug(GLenum light, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightf, "(%s, %s, %f)", enum_to_string_GL(light), enum_to_string_GL(pname), (float)param)
    glatter_glLightf(light, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLightfv, (light, pname, params), (GLenum light, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glLightfv_debug(GLenum light, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightfv, "(%s, %s, %p)", enum_to_string_GL(light), enum_to_string_GL(pname), (void*)params)
    glatter_glLightfv(light, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLighti, (light, pname, param), (GLenum light, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glLighti_debug(GLenum light, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLighti, "(%s, %s, %d)", enum_to_string_GL(light), enum_to_string_GL(pname), (int)param)
    glatter_glLighti(light, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLighti_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLightiv, (light, pname, params), (GLenum light, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glLightiv_debug(GLenum light, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLightiv, "(%s, %s, %p)", enum_to_string_GL(light), enum_to_string_GL(pname), (void*)params)
    glatter_glLightiv(light, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLightiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLineStipple, (factor, pattern), (GLint factor, GLushort pattern))
GLATTER_INLINE_OR_NOT void glatter_glLineStipple_debug(GLint factor, GLushort pattern, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLineStipple, "(%d, %hu)", (int)factor, (unsigned short)pattern)
    glatter_glLineStipple(factor, pattern);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLineStipple_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLineWidth, (width), (GLfloat width))
GLATTER_INLINE_OR_NOT void glatter_glLineWidth_debug(GLfloat width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLineWidth, "(%f)", (float)width)
    glatter_glLineWidth(width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLineWidth_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glListBase, (base), (GLuint base))
GLATTER_INLINE_OR_NOT void glatter_glListBase_debug(GLuint base, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glListBase, "(%u)", (unsigned int)base)
    glatter_glListBase(base);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glListBase_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLoadIdentity, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glLoadIdentity_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLoadIdentity, "()")
    glatter_glLoadIdentity();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLoadIdentity_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLoadMatrixd, (m), (const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glLoadMatrixd_debug(const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLoadMatrixd, "(%p)", (void*)m)
    glatter_glLoadMatrixd(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLoadMatrixd_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLoadMatrixf, (m), (const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glLoadMatrixf_debug(const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLoadMatrixf, "(%p)", (void*)m)
    glatter_glLoadMatrixf(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLoadMatrixf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLoadName, (name), (GLuint name))
GLATTER_INLINE_OR_NOT void glatter_glLoadName_debug(GLuint name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLoadName, "(%u)", (unsigned int)name)
    glatter_glLoadName(name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLoadName_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glLogicOp, (opcode), (GLenum opcode))
GLATTER_INLINE_OR_NOT void glatter_glLogicOp_debug(GLenum opcode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLogicOp, "(%s)", enum_to_string_GL(opcode))
    glatter_glLogicOp(opcode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLogicOp_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMap1d, (target, u1, u2, stride, order, points), (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points))
GLATTER_INLINE_OR_NOT void glatter_glMap1d_debug(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMap1d, "(%s, %f, %f, %d, %d, %p)", enum_to_string_GL(target), (double)u1, (double)u2, (int)stride, (int)order, (void*)points)
    glatter_glMap1d(target, u1, u2, stride, order, points);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMap1d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMap1f, (target, u1, u2, stride, order, points), (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points))
GLATTER_INLINE_OR_NOT void glatter_glMap1f_debug(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMap1f, "(%s, %f, %f, %d, %d, %p)", enum_to_string_GL(target), (float)u1, (float)u2, (int)stride, (int)order, (void*)points)
    glatter_glMap1f(target, u1, u2, stride, order, points);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMap1f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMap2d, (target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points), (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points))
GLATTER_INLINE_OR_NOT void glatter_glMap2d_debug(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMap2d, "(%s, %f, %f, %d, %d, %f, %f, %d, %d, %p)", enum_to_string_GL(target), (double)u1, (double)u2, (int)ustride, (int)uorder, (double)v1, (double)v2, (int)vstride, (int)vorder, (void*)points)
    glatter_glMap2d(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMap2d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMap2f, (target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points), (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points))
GLATTER_INLINE_OR_NOT void glatter_glMap2f_debug(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMap2f, "(%s, %f, %f, %d, %d, %f, %f, %d, %d, %p)", enum_to_string_GL(target), (float)u1, (float)u2, (int)ustride, (int)uorder, (float)v1, (float)v2, (int)vstride, (int)vorder, (void*)points)
    glatter_glMap2f(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMap2f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMapGrid1d, (un, u1, u2), (GLint un, GLdouble u1, GLdouble u2))
GLATTER_INLINE_OR_NOT void glatter_glMapGrid1d_debug(GLint un, GLdouble u1, GLdouble u2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapGrid1d, "(%d, %f, %f)", (int)un, (double)u1, (double)u2)
    glatter_glMapGrid1d(un, u1, u2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMapGrid1d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMapGrid1f, (un, u1, u2), (GLint un, GLfloat u1, GLfloat u2))
GLATTER_INLINE_OR_NOT void glatter_glMapGrid1f_debug(GLint un, GLfloat u1, GLfloat u2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapGrid1f, "(%d, %f, %f)", (int)un, (float)u1, (float)u2)
    glatter_glMapGrid1f(un, u1, u2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMapGrid1f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMapGrid2d, (un, u1, u2, vn, v1, v2), (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2))
GLATTER_INLINE_OR_NOT void glatter_glMapGrid2d_debug(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapGrid2d, "(%d, %f, %f, %d, %f, %f)", (int)un, (double)u1, (double)u2, (int)vn, (double)v1, (double)v2)
    glatter_glMapGrid2d(un, u1, u2, vn, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMapGrid2d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMapGrid2f, (un, u1, u2, vn, v1, v2), (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2))
GLATTER_INLINE_OR_NOT void glatter_glMapGrid2f_debug(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapGrid2f, "(%d, %f, %f, %d, %f, %f)", (int)un, (float)u1, (float)u2, (int)vn, (float)v1, (float)v2)
    glatter_glMapGrid2f(un, u1, u2, vn, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMapGrid2f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMaterialf, (face, pname, param), (GLenum face, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glMaterialf_debug(GLenum face, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaterialf, "(%s, %s, %f)", enum_to_string_GL(face), enum_to_string_GL(pname), (float)param)
    glatter_glMaterialf(face, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaterialf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMaterialfv, (face, pname, params), (GLenum face, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glMaterialfv_debug(GLenum face, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaterialfv, "(%s, %s, %p)", enum_to_string_GL(face), enum_to_string_GL(pname), (void*)params)
    glatter_glMaterialfv(face, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaterialfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMateriali, (face, pname, param), (GLenum face, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glMateriali_debug(GLenum face, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMateriali, "(%s, %s, %d)", enum_to_string_GL(face), enum_to_string_GL(pname), (int)param)
    glatter_glMateriali(face, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMateriali_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMaterialiv, (face, pname, params), (GLenum face, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glMaterialiv_debug(GLenum face, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaterialiv, "(%s, %s, %p)", enum_to_string_GL(face), enum_to_string_GL(pname), (void*)params)
    glatter_glMaterialiv(face, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaterialiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMatrixMode, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMode_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMode, "(%s)", enum_to_string_GL(mode))
    glatter_glMatrixMode(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMode_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMultMatrixd, (m), (const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glMultMatrixd_debug(const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultMatrixd, "(%p)", (void*)m)
    glatter_glMultMatrixd(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultMatrixd_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glMultMatrixf, (m), (const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMultMatrixf_debug(const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultMatrixf, "(%p)", (void*)m)
    glatter_glMultMatrixf(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultMatrixf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNewList, (list, mode), (GLuint list, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glNewList_debug(GLuint list, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNewList, "(%u, %s)", (unsigned int)list, enum_to_string_GL(mode))
    glatter_glNewList(list, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNewList_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNormal3b, (nx, ny, nz), (GLbyte nx, GLbyte ny, GLbyte nz))
GLATTER_INLINE_OR_NOT void glatter_glNormal3b_debug(GLbyte nx, GLbyte ny, GLbyte nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3b, "(%d, %d, %d)", (signed char)nx, (signed char)ny, (signed char)nz)
    glatter_glNormal3b(nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3b_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNormal3bv, (v), (const GLbyte *v))
GLATTER_INLINE_OR_NOT void glatter_glNormal3bv_debug(const GLbyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3bv, "(%p)", (void*)v)
    glatter_glNormal3bv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3bv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNormal3d, (nx, ny, nz), (GLdouble nx, GLdouble ny, GLdouble nz))
GLATTER_INLINE_OR_NOT void glatter_glNormal3d_debug(GLdouble nx, GLdouble ny, GLdouble nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3d, "(%f, %f, %f)", (double)nx, (double)ny, (double)nz)
    glatter_glNormal3d(nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNormal3dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glNormal3dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3dv, "(%p)", (void*)v)
    glatter_glNormal3dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNormal3f, (nx, ny, nz), (GLfloat nx, GLfloat ny, GLfloat nz))
GLATTER_INLINE_OR_NOT void glatter_glNormal3f_debug(GLfloat nx, GLfloat ny, GLfloat nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3f, "(%f, %f, %f)", (float)nx, (float)ny, (float)nz)
    glatter_glNormal3f(nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNormal3fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glNormal3fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3fv, "(%p)", (void*)v)
    glatter_glNormal3fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNormal3i, (nx, ny, nz), (GLint nx, GLint ny, GLint nz))
GLATTER_INLINE_OR_NOT void glatter_glNormal3i_debug(GLint nx, GLint ny, GLint nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3i, "(%d, %d, %d)", (int)nx, (int)ny, (int)nz)
    glatter_glNormal3i(nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNormal3iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glNormal3iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3iv, "(%p)", (void*)v)
    glatter_glNormal3iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNormal3s, (nx, ny, nz), (GLshort nx, GLshort ny, GLshort nz))
GLATTER_INLINE_OR_NOT void glatter_glNormal3s_debug(GLshort nx, GLshort ny, GLshort nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3s, "(%hi, %hi, %hi)", (short)nx, (short)ny, (short)nz)
    glatter_glNormal3s(nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNormal3sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glNormal3sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3sv, "(%p)", (void*)v)
    glatter_glNormal3sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glNormalPointer, (type, stride, pointer), (GLenum type, GLsizei stride, const GLvoid *pointer))
GLATTER_INLINE_OR_NOT void glatter_glNormalPointer_debug(GLenum type, GLsizei stride, const GLvoid *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalPointer, "(%s, %d, %p)", enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glNormalPointer(type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalPointer_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glOrtho, (left, right, bottom, top, zNear, zFar), (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GLATTER_INLINE_OR_NOT void glatter_glOrtho_debug(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glOrtho, "(%f, %f, %f, %f, %f, %f)", (double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar)
    glatter_glOrtho(left, right, bottom, top, zNear, zFar);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glOrtho_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPassThrough, (token), (GLfloat token))
GLATTER_INLINE_OR_NOT void glatter_glPassThrough_debug(GLfloat token, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPassThrough, "(%f)", (float)token)
    glatter_glPassThrough(token);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPassThrough_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPixelMapfv, (map, mapsize, values), (GLenum map, GLsizei mapsize, const GLfloat *values))
GLATTER_INLINE_OR_NOT void glatter_glPixelMapfv_debug(GLenum map, GLsizei mapsize, const GLfloat *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelMapfv, "(%s, %d, %p)", enum_to_string_GL(map), (int)mapsize, (void*)values)
    glatter_glPixelMapfv(map, mapsize, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelMapfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPixelMapuiv, (map, mapsize, values), (GLenum map, GLsizei mapsize, const GLuint *values))
GLATTER_INLINE_OR_NOT void glatter_glPixelMapuiv_debug(GLenum map, GLsizei mapsize, const GLuint *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelMapuiv, "(%s, %d, %p)", enum_to_string_GL(map), (int)mapsize, (void*)values)
    glatter_glPixelMapuiv(map, mapsize, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelMapuiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPixelMapusv, (map, mapsize, values), (GLenum map, GLsizei mapsize, const GLushort *values))
GLATTER_INLINE_OR_NOT void glatter_glPixelMapusv_debug(GLenum map, GLsizei mapsize, const GLushort *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelMapusv, "(%s, %d, %p)", enum_to_string_GL(map), (int)mapsize, (void*)values)
    glatter_glPixelMapusv(map, mapsize, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelMapusv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPixelStoref, (pname, param), (GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glPixelStoref_debug(GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelStoref, "(%s, %f)", enum_to_string_GL(pname), (float)param)
    glatter_glPixelStoref(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelStoref_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPixelStorei, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glPixelStorei_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelStorei, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glPixelStorei(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelStorei_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPixelTransferf, (pname, param), (GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glPixelTransferf_debug(GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelTransferf, "(%s, %f)", enum_to_string_GL(pname), (float)param)
    glatter_glPixelTransferf(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelTransferf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPixelTransferi, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glPixelTransferi_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelTransferi, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glPixelTransferi(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelTransferi_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPixelZoom, (xfactor, yfactor), (GLfloat xfactor, GLfloat yfactor))
GLATTER_INLINE_OR_NOT void glatter_glPixelZoom_debug(GLfloat xfactor, GLfloat yfactor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelZoom, "(%f, %f)", (float)xfactor, (float)yfactor)
    glatter_glPixelZoom(xfactor, yfactor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelZoom_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPointSize, (size), (GLfloat size))
GLATTER_INLINE_OR_NOT void glatter_glPointSize_debug(GLfloat size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointSize, "(%f)", (float)size)
    glatter_glPointSize(size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointSize_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPolygonMode, (face, mode), (GLenum face, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glPolygonMode_debug(GLenum face, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPolygonMode, "(%s, %s)", enum_to_string_GL(face), enum_to_string_GL(mode))
    glatter_glPolygonMode(face, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPolygonMode_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPolygonOffset, (factor, units), (GLfloat factor, GLfloat units))
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffset_debug(GLfloat factor, GLfloat units, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPolygonOffset, "(%f, %f)", (float)factor, (float)units)
    glatter_glPolygonOffset(factor, units);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPolygonOffset_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPolygonStipple, (mask), (const GLubyte *mask))
GLATTER_INLINE_OR_NOT void glatter_glPolygonStipple_debug(const GLubyte *mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPolygonStipple, "(%p)", (void*)mask)
    glatter_glPolygonStipple(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPolygonStipple_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPopAttrib, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPopAttrib_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPopAttrib, "()")
    glatter_glPopAttrib();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPopAttrib_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPopClientAttrib, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPopClientAttrib_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPopClientAttrib, "()")
    glatter_glPopClientAttrib();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPopClientAttrib_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPopMatrix, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPopMatrix_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPopMatrix, "()")
    glatter_glPopMatrix();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPopMatrix_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPopName, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPopName_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPopName, "()")
    glatter_glPopName();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPopName_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPrioritizeTextures, (n, textures, priorities), (GLsizei n, const GLuint *textures, const GLclampf *priorities))
GLATTER_INLINE_OR_NOT void glatter_glPrioritizeTextures_debug(GLsizei n, const GLuint *textures, const GLclampf *priorities, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPrioritizeTextures, "(%d, %p, %p)", (int)n, (void*)textures, (void*)priorities)
    glatter_glPrioritizeTextures(n, textures, priorities);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPrioritizeTextures_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPushAttrib, (mask), (GLbitfield mask))
GLATTER_INLINE_OR_NOT void glatter_glPushAttrib_debug(GLbitfield mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPushAttrib, "(%u)", (unsigned int)mask)
    glatter_glPushAttrib(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPushAttrib_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPushClientAttrib, (mask), (GLbitfield mask))
GLATTER_INLINE_OR_NOT void glatter_glPushClientAttrib_debug(GLbitfield mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPushClientAttrib, "(%u)", (unsigned int)mask)
    glatter_glPushClientAttrib(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPushClientAttrib_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPushMatrix, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPushMatrix_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPushMatrix, "()")
    glatter_glPushMatrix();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPushMatrix_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glPushName, (name), (GLuint name))
GLATTER_INLINE_OR_NOT void glatter_glPushName_debug(GLuint name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPushName, "(%u)", (unsigned int)name)
    glatter_glPushName(name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPushName_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos2d, (x, y), (GLdouble x, GLdouble y))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2d_debug(GLdouble x, GLdouble y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos2d, "(%f, %f)", (double)x, (double)y)
    glatter_glRasterPos2d(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos2d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos2dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos2dv, "(%p)", (void*)v)
    glatter_glRasterPos2dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos2dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos2f, (x, y), (GLfloat x, GLfloat y))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2f_debug(GLfloat x, GLfloat y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos2f, "(%f, %f)", (float)x, (float)y)
    glatter_glRasterPos2f(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos2f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos2fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos2fv, "(%p)", (void*)v)
    glatter_glRasterPos2fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos2fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos2i, (x, y), (GLint x, GLint y))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2i_debug(GLint x, GLint y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos2i, "(%d, %d)", (int)x, (int)y)
    glatter_glRasterPos2i(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos2i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos2iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos2iv, "(%p)", (void*)v)
    glatter_glRasterPos2iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos2iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos2s, (x, y), (GLshort x, GLshort y))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2s_debug(GLshort x, GLshort y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos2s, "(%hi, %hi)", (short)x, (short)y)
    glatter_glRasterPos2s(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos2s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos2sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos2sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos2sv, "(%p)", (void*)v)
    glatter_glRasterPos2sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos2sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos3d, (x, y, z), (GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3d_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos3d, "(%f, %f, %f)", (double)x, (double)y, (double)z)
    glatter_glRasterPos3d(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos3d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos3dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos3dv, "(%p)", (void*)v)
    glatter_glRasterPos3dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos3dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos3f, (x, y, z), (GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3f_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos3f, "(%f, %f, %f)", (float)x, (float)y, (float)z)
    glatter_glRasterPos3f(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos3f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos3fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos3fv, "(%p)", (void*)v)
    glatter_glRasterPos3fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos3fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos3i, (x, y, z), (GLint x, GLint y, GLint z))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3i_debug(GLint x, GLint y, GLint z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos3i, "(%d, %d, %d)", (int)x, (int)y, (int)z)
    glatter_glRasterPos3i(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos3i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos3iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos3iv, "(%p)", (void*)v)
    glatter_glRasterPos3iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos3iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos3s, (x, y, z), (GLshort x, GLshort y, GLshort z))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3s_debug(GLshort x, GLshort y, GLshort z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos3s, "(%hi, %hi, %hi)", (short)x, (short)y, (short)z)
    glatter_glRasterPos3s(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos3s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos3sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos3sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos3sv, "(%p)", (void*)v)
    glatter_glRasterPos3sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos3sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos4d, (x, y, z, w), (GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4d_debug(GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos4d, "(%f, %f, %f, %f)", (double)x, (double)y, (double)z, (double)w)
    glatter_glRasterPos4d(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos4d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos4dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos4dv, "(%p)", (void*)v)
    glatter_glRasterPos4dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos4dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos4f, (x, y, z, w), (GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4f_debug(GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos4f, "(%f, %f, %f, %f)", (float)x, (float)y, (float)z, (float)w)
    glatter_glRasterPos4f(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos4f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos4fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos4fv, "(%p)", (void*)v)
    glatter_glRasterPos4fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos4fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos4i, (x, y, z, w), (GLint x, GLint y, GLint z, GLint w))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4i_debug(GLint x, GLint y, GLint z, GLint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos4i, "(%d, %d, %d, %d)", (int)x, (int)y, (int)z, (int)w)
    glatter_glRasterPos4i(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos4i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos4iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos4iv, "(%p)", (void*)v)
    glatter_glRasterPos4iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos4iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos4s, (x, y, z, w), (GLshort x, GLshort y, GLshort z, GLshort w))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4s_debug(GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos4s, "(%hi, %hi, %hi, %hi)", (short)x, (short)y, (short)z, (short)w)
    glatter_glRasterPos4s(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos4s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRasterPos4sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glRasterPos4sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterPos4sv, "(%p)", (void*)v)
    glatter_glRasterPos4sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterPos4sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glReadBuffer, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glReadBuffer_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadBuffer, "(%s)", enum_to_string_GL(mode))
    glatter_glReadBuffer(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadBuffer_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glReadPixels, (x, y, width, height, format, type, pixels), (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels))
GLATTER_INLINE_OR_NOT void glatter_glReadPixels_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadPixels, "(%d, %d, %d, %d, %s, %s, %p)", (int)x, (int)y, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glReadPixels(x, y, width, height, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadPixels_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRectd, (x1, y1, x2, y2), (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2))
GLATTER_INLINE_OR_NOT void glatter_glRectd_debug(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRectd, "(%f, %f, %f, %f)", (double)x1, (double)y1, (double)x2, (double)y2)
    glatter_glRectd(x1, y1, x2, y2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRectd_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRectdv, (v1, v2), (const GLdouble *v1, const GLdouble *v2))
GLATTER_INLINE_OR_NOT void glatter_glRectdv_debug(const GLdouble *v1, const GLdouble *v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRectdv, "(%p, %p)", (void*)v1, (void*)v2)
    glatter_glRectdv(v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRectdv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRectf, (x1, y1, x2, y2), (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2))
GLATTER_INLINE_OR_NOT void glatter_glRectf_debug(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRectf, "(%f, %f, %f, %f)", (float)x1, (float)y1, (float)x2, (float)y2)
    glatter_glRectf(x1, y1, x2, y2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRectf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRectfv, (v1, v2), (const GLfloat *v1, const GLfloat *v2))
GLATTER_INLINE_OR_NOT void glatter_glRectfv_debug(const GLfloat *v1, const GLfloat *v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRectfv, "(%p, %p)", (void*)v1, (void*)v2)
    glatter_glRectfv(v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRectfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRecti, (x1, y1, x2, y2), (GLint x1, GLint y1, GLint x2, GLint y2))
GLATTER_INLINE_OR_NOT void glatter_glRecti_debug(GLint x1, GLint y1, GLint x2, GLint y2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRecti, "(%d, %d, %d, %d)", (int)x1, (int)y1, (int)x2, (int)y2)
    glatter_glRecti(x1, y1, x2, y2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRecti_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRectiv, (v1, v2), (const GLint *v1, const GLint *v2))
GLATTER_INLINE_OR_NOT void glatter_glRectiv_debug(const GLint *v1, const GLint *v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRectiv, "(%p, %p)", (void*)v1, (void*)v2)
    glatter_glRectiv(v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRectiv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRects, (x1, y1, x2, y2), (GLshort x1, GLshort y1, GLshort x2, GLshort y2))
GLATTER_INLINE_OR_NOT void glatter_glRects_debug(GLshort x1, GLshort y1, GLshort x2, GLshort y2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRects, "(%hi, %hi, %hi, %hi)", (short)x1, (short)y1, (short)x2, (short)y2)
    glatter_glRects(x1, y1, x2, y2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRects_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRectsv, (v1, v2), (const GLshort *v1, const GLshort *v2))
GLATTER_INLINE_OR_NOT void glatter_glRectsv_debug(const GLshort *v1, const GLshort *v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRectsv, "(%p, %p)", (void*)v1, (void*)v2)
    glatter_glRectsv(v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRectsv_defined
GLATTER_FBLOCK(return, GL, WINGDIAPI, GLint, APIENTRY, glRenderMode, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT GLint glatter_glRenderMode_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderMode, "(%s)", enum_to_string_GL(mode))
    GLint rval = glatter_glRenderMode(mode);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glRenderMode_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRotated, (angle, x, y, z), (GLdouble angle, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glRotated_debug(GLdouble angle, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRotated, "(%f, %f, %f, %f)", (double)angle, (double)x, (double)y, (double)z)
    glatter_glRotated(angle, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRotated_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glRotatef, (angle, x, y, z), (GLfloat angle, GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glRotatef_debug(GLfloat angle, GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRotatef, "(%f, %f, %f, %f)", (float)angle, (float)x, (float)y, (float)z)
    glatter_glRotatef(angle, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRotatef_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glScaled, (x, y, z), (GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glScaled_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScaled, "(%f, %f, %f)", (double)x, (double)y, (double)z)
    glatter_glScaled(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScaled_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glScalef, (x, y, z), (GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glScalef_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScalef, "(%f, %f, %f)", (float)x, (float)y, (float)z)
    glatter_glScalef(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScalef_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glScissor, (x, y, width, height), (GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glScissor_debug(GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glScissor, "(%d, %d, %d, %d)", (int)x, (int)y, (int)width, (int)height)
    glatter_glScissor(x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glScissor_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glSelectBuffer, (size, buffer), (GLsizei size, GLuint *buffer))
GLATTER_INLINE_OR_NOT void glatter_glSelectBuffer_debug(GLsizei size, GLuint *buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSelectBuffer, "(%d, %p)", (int)size, (void*)buffer)
    glatter_glSelectBuffer(size, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSelectBuffer_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glShadeModel, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glShadeModel_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glShadeModel, "(%s)", enum_to_string_GL(mode))
    glatter_glShadeModel(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glShadeModel_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glStencilFunc, (func, ref, mask), (GLenum func, GLint ref, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilFunc_debug(GLenum func, GLint ref, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilFunc, "(%s, %d, %u)", enum_to_string_GL(func), (int)ref, (unsigned int)mask)
    glatter_glStencilFunc(func, ref, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilFunc_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glStencilMask, (mask), (GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilMask_debug(GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilMask, "(%u)", (unsigned int)mask)
    glatter_glStencilMask(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilMask_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glStencilOp, (fail, zfail, zpass), (GLenum fail, GLenum zfail, GLenum zpass))
GLATTER_INLINE_OR_NOT void glatter_glStencilOp_debug(GLenum fail, GLenum zfail, GLenum zpass, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilOp, "(%s, %s, %s)", enum_to_string_GL(fail), enum_to_string_GL(zfail), enum_to_string_GL(zpass))
    glatter_glStencilOp(fail, zfail, zpass);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilOp_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord1d, (s), (GLdouble s))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1d_debug(GLdouble s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord1d, "(%f)", (double)s)
    glatter_glTexCoord1d(s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord1d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord1dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord1dv, "(%p)", (void*)v)
    glatter_glTexCoord1dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord1dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord1f, (s), (GLfloat s))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1f_debug(GLfloat s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord1f, "(%f)", (float)s)
    glatter_glTexCoord1f(s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord1f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord1fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord1fv, "(%p)", (void*)v)
    glatter_glTexCoord1fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord1fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord1i, (s), (GLint s))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1i_debug(GLint s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord1i, "(%d)", (int)s)
    glatter_glTexCoord1i(s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord1i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord1iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord1iv, "(%p)", (void*)v)
    glatter_glTexCoord1iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord1iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord1s, (s), (GLshort s))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1s_debug(GLshort s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord1s, "(%hi)", (short)s)
    glatter_glTexCoord1s(s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord1s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord1sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord1sv, "(%p)", (void*)v)
    glatter_glTexCoord1sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord1sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord2d, (s, t), (GLdouble s, GLdouble t))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2d_debug(GLdouble s, GLdouble t, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord2d, "(%f, %f)", (double)s, (double)t)
    glatter_glTexCoord2d(s, t);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord2d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord2dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord2dv, "(%p)", (void*)v)
    glatter_glTexCoord2dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord2dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord2f, (s, t), (GLfloat s, GLfloat t))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2f_debug(GLfloat s, GLfloat t, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord2f, "(%f, %f)", (float)s, (float)t)
    glatter_glTexCoord2f(s, t);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord2f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord2fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord2fv, "(%p)", (void*)v)
    glatter_glTexCoord2fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord2fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord2i, (s, t), (GLint s, GLint t))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2i_debug(GLint s, GLint t, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord2i, "(%d, %d)", (int)s, (int)t)
    glatter_glTexCoord2i(s, t);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord2i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord2iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord2iv, "(%p)", (void*)v)
    glatter_glTexCoord2iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord2iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord2s, (s, t), (GLshort s, GLshort t))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2s_debug(GLshort s, GLshort t, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord2s, "(%hi, %hi)", (short)s, (short)t)
    glatter_glTexCoord2s(s, t);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord2s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord2sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord2sv, "(%p)", (void*)v)
    glatter_glTexCoord2sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord2sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord3d, (s, t, r), (GLdouble s, GLdouble t, GLdouble r))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3d_debug(GLdouble s, GLdouble t, GLdouble r, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord3d, "(%f, %f, %f)", (double)s, (double)t, (double)r)
    glatter_glTexCoord3d(s, t, r);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord3d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord3dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord3dv, "(%p)", (void*)v)
    glatter_glTexCoord3dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord3dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord3f, (s, t, r), (GLfloat s, GLfloat t, GLfloat r))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3f_debug(GLfloat s, GLfloat t, GLfloat r, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord3f, "(%f, %f, %f)", (float)s, (float)t, (float)r)
    glatter_glTexCoord3f(s, t, r);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord3f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord3fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord3fv, "(%p)", (void*)v)
    glatter_glTexCoord3fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord3fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord3i, (s, t, r), (GLint s, GLint t, GLint r))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3i_debug(GLint s, GLint t, GLint r, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord3i, "(%d, %d, %d)", (int)s, (int)t, (int)r)
    glatter_glTexCoord3i(s, t, r);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord3i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord3iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord3iv, "(%p)", (void*)v)
    glatter_glTexCoord3iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord3iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord3s, (s, t, r), (GLshort s, GLshort t, GLshort r))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3s_debug(GLshort s, GLshort t, GLshort r, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord3s, "(%hi, %hi, %hi)", (short)s, (short)t, (short)r)
    glatter_glTexCoord3s(s, t, r);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord3s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord3sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord3sv, "(%p)", (void*)v)
    glatter_glTexCoord3sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord3sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord4d, (s, t, r, q), (GLdouble s, GLdouble t, GLdouble r, GLdouble q))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4d_debug(GLdouble s, GLdouble t, GLdouble r, GLdouble q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord4d, "(%f, %f, %f, %f)", (double)s, (double)t, (double)r, (double)q)
    glatter_glTexCoord4d(s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord4d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord4dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord4dv, "(%p)", (void*)v)
    glatter_glTexCoord4dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord4dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord4f, (s, t, r, q), (GLfloat s, GLfloat t, GLfloat r, GLfloat q))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4f_debug(GLfloat s, GLfloat t, GLfloat r, GLfloat q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord4f, "(%f, %f, %f, %f)", (float)s, (float)t, (float)r, (float)q)
    glatter_glTexCoord4f(s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord4f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord4fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord4fv, "(%p)", (void*)v)
    glatter_glTexCoord4fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord4fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord4i, (s, t, r, q), (GLint s, GLint t, GLint r, GLint q))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4i_debug(GLint s, GLint t, GLint r, GLint q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord4i, "(%d, %d, %d, %d)", (int)s, (int)t, (int)r, (int)q)
    glatter_glTexCoord4i(s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord4i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord4iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord4iv, "(%p)", (void*)v)
    glatter_glTexCoord4iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord4iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord4s, (s, t, r, q), (GLshort s, GLshort t, GLshort r, GLshort q))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4s_debug(GLshort s, GLshort t, GLshort r, GLshort q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord4s, "(%hi, %hi, %hi, %hi)", (short)s, (short)t, (short)r, (short)q)
    glatter_glTexCoord4s(s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord4s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoord4sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord4sv, "(%p)", (void*)v)
    glatter_glTexCoord4sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord4sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexCoordPointer, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GLATTER_INLINE_OR_NOT void glatter_glTexCoordPointer_debug(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoordPointer, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glTexCoordPointer(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoordPointer_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexEnvf, (target, pname, param), (GLenum target, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glTexEnvf_debug(GLenum target, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnvf, "(%s, %s, %f)", enum_to_string_GL(target), enum_to_string_GL(pname), (float)param)
    glatter_glTexEnvf(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnvf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexEnvfv, (target, pname, params), (GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glTexEnvfv_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnvfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexEnvfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnvfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexEnvi, (target, pname, param), (GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glTexEnvi_debug(GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnvi, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glTexEnvi(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnvi_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexEnviv, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexEnviv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexEnviv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexEnviv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexEnviv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexGend, (coord, pname, param), (GLenum coord, GLenum pname, GLdouble param))
GLATTER_INLINE_OR_NOT void glatter_glTexGend_debug(GLenum coord, GLenum pname, GLdouble param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGend, "(%s, %s, %f)", enum_to_string_GL(coord), enum_to_string_GL(pname), (double)param)
    glatter_glTexGend(coord, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGend_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexGendv, (coord, pname, params), (GLenum coord, GLenum pname, const GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glTexGendv_debug(GLenum coord, GLenum pname, const GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGendv, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glTexGendv(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGendv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexGenf, (coord, pname, param), (GLenum coord, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glTexGenf_debug(GLenum coord, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGenf, "(%s, %s, %f)", enum_to_string_GL(coord), enum_to_string_GL(pname), (float)param)
    glatter_glTexGenf(coord, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGenf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexGenfv, (coord, pname, params), (GLenum coord, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glTexGenfv_debug(GLenum coord, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGenfv, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glTexGenfv(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGenfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexGeni, (coord, pname, param), (GLenum coord, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glTexGeni_debug(GLenum coord, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGeni, "(%s, %s, %d)", enum_to_string_GL(coord), enum_to_string_GL(pname), (int)param)
    glatter_glTexGeni(coord, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGeni_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexGeniv, (coord, pname, params), (GLenum coord, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexGeniv_debug(GLenum coord, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexGeniv, "(%s, %s, %p)", enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glTexGeniv(coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexGeniv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexImage1D, (target, level, internalformat, width, border, format, type, pixels), (GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexImage1D_debug(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexImage1D, "(%s, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)internalformat, (int)width, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexImage1D(target, level, internalformat, width, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexImage1D_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexImage2D, (target, level, internalformat, width, height, border, format, type, pixels), (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexImage2D_debug(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexImage2D, "(%s, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)internalformat, (int)width, (int)height, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexImage2D_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexParameterf, (target, pname, param), (GLenum target, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterf_debug(GLenum target, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterf, "(%s, %s, %f)", enum_to_string_GL(target), enum_to_string_GL(pname), (float)param)
    glatter_glTexParameterf(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterf_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexParameterfv, (target, pname, params), (GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterfv_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterfv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexParameteri, (target, pname, param), (GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glTexParameteri_debug(GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameteri, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glTexParameteri(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameteri_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexParameteriv, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameteriv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameteriv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexSubImage1D, (target, level, xoffset, width, format, type, pixels), (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage1D_debug(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexSubImage1D, "(%s, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)width, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexSubImage1D(target, level, xoffset, width, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexSubImage1D_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTexSubImage2D, (target, level, xoffset, yoffset, width, height, format, type, pixels), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage2D_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexSubImage2D, "(%s, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexSubImage2D_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTranslated, (x, y, z), (GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glTranslated_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTranslated, "(%f, %f, %f)", (double)x, (double)y, (double)z)
    glatter_glTranslated(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTranslated_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glTranslatef, (x, y, z), (GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glTranslatef_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTranslatef, "(%f, %f, %f)", (float)x, (float)y, (float)z)
    glatter_glTranslatef(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTranslatef_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex2d, (x, y), (GLdouble x, GLdouble y))
GLATTER_INLINE_OR_NOT void glatter_glVertex2d_debug(GLdouble x, GLdouble y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex2d, "(%f, %f)", (double)x, (double)y)
    glatter_glVertex2d(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex2d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex2dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex2dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex2dv, "(%p)", (void*)v)
    glatter_glVertex2dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex2dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex2f, (x, y), (GLfloat x, GLfloat y))
GLATTER_INLINE_OR_NOT void glatter_glVertex2f_debug(GLfloat x, GLfloat y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex2f, "(%f, %f)", (float)x, (float)y)
    glatter_glVertex2f(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex2f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex2fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex2fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex2fv, "(%p)", (void*)v)
    glatter_glVertex2fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex2fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex2i, (x, y), (GLint x, GLint y))
GLATTER_INLINE_OR_NOT void glatter_glVertex2i_debug(GLint x, GLint y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex2i, "(%d, %d)", (int)x, (int)y)
    glatter_glVertex2i(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex2i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex2iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex2iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex2iv, "(%p)", (void*)v)
    glatter_glVertex2iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex2iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex2s, (x, y), (GLshort x, GLshort y))
GLATTER_INLINE_OR_NOT void glatter_glVertex2s_debug(GLshort x, GLshort y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex2s, "(%hi, %hi)", (short)x, (short)y)
    glatter_glVertex2s(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex2s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex2sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex2sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex2sv, "(%p)", (void*)v)
    glatter_glVertex2sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex2sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex3d, (x, y, z), (GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glVertex3d_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex3d, "(%f, %f, %f)", (double)x, (double)y, (double)z)
    glatter_glVertex3d(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex3d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex3dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex3dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex3dv, "(%p)", (void*)v)
    glatter_glVertex3dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex3dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex3f, (x, y, z), (GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glVertex3f_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex3f, "(%f, %f, %f)", (float)x, (float)y, (float)z)
    glatter_glVertex3f(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex3f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex3fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex3fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex3fv, "(%p)", (void*)v)
    glatter_glVertex3fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex3fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex3i, (x, y, z), (GLint x, GLint y, GLint z))
GLATTER_INLINE_OR_NOT void glatter_glVertex3i_debug(GLint x, GLint y, GLint z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex3i, "(%d, %d, %d)", (int)x, (int)y, (int)z)
    glatter_glVertex3i(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex3i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex3iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex3iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex3iv, "(%p)", (void*)v)
    glatter_glVertex3iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex3iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex3s, (x, y, z), (GLshort x, GLshort y, GLshort z))
GLATTER_INLINE_OR_NOT void glatter_glVertex3s_debug(GLshort x, GLshort y, GLshort z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex3s, "(%hi, %hi, %hi)", (short)x, (short)y, (short)z)
    glatter_glVertex3s(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex3s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex3sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex3sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex3sv, "(%p)", (void*)v)
    glatter_glVertex3sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex3sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex4d, (x, y, z, w), (GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GLATTER_INLINE_OR_NOT void glatter_glVertex4d_debug(GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex4d, "(%f, %f, %f, %f)", (double)x, (double)y, (double)z, (double)w)
    glatter_glVertex4d(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex4d_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex4dv, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex4dv_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex4dv, "(%p)", (void*)v)
    glatter_glVertex4dv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex4dv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex4f, (x, y, z, w), (GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GLATTER_INLINE_OR_NOT void glatter_glVertex4f_debug(GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex4f, "(%f, %f, %f, %f)", (float)x, (float)y, (float)z, (float)w)
    glatter_glVertex4f(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex4f_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex4fv, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex4fv_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex4fv, "(%p)", (void*)v)
    glatter_glVertex4fv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex4fv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex4i, (x, y, z, w), (GLint x, GLint y, GLint z, GLint w))
GLATTER_INLINE_OR_NOT void glatter_glVertex4i_debug(GLint x, GLint y, GLint z, GLint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex4i, "(%d, %d, %d, %d)", (int)x, (int)y, (int)z, (int)w)
    glatter_glVertex4i(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex4i_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex4iv, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex4iv_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex4iv, "(%p)", (void*)v)
    glatter_glVertex4iv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex4iv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex4s, (x, y, z, w), (GLshort x, GLshort y, GLshort z, GLshort w))
GLATTER_INLINE_OR_NOT void glatter_glVertex4s_debug(GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex4s, "(%hi, %hi, %hi, %hi)", (short)x, (short)y, (short)z, (short)w)
    glatter_glVertex4s(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex4s_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertex4sv, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex4sv_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex4sv, "(%p)", (void*)v)
    glatter_glVertex4sv(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex4sv_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glVertexPointer, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GLATTER_INLINE_OR_NOT void glatter_glVertexPointer_debug(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexPointer, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glVertexPointer(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexPointer_defined
GLATTER_FBLOCK(, GL, WINGDIAPI, void, APIENTRY, glViewport, (x, y, width, height), (GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glViewport_debug(GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewport, "(%d, %d, %d, %d)", (int)x, (int)y, (int)width, (int)height)
    glatter_glViewport(x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewport_defined
#endif // defined(__gl_h_)
#endif // !defined(GL_VERSION_ES_CM_1_0)
#endif // defined(__GL_H__)
#if defined(__gl_glext_h_)
#if defined(GL_3DFX_tbuffer)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTbufferMask3DFX, (mask), (GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glTbufferMask3DFX_debug(GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTbufferMask3DFX, "(%u)", (unsigned int)mask)
    glatter_glTbufferMask3DFX(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTbufferMask3DFX_defined
#endif // defined(GL_3DFX_tbuffer)
#if defined(GL_AMD_debug_output)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDebugMessageCallbackAMD, (callback, userParam), (GLDEBUGPROCAMD callback, void *userParam))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageCallbackAMD_debug(GLDEBUGPROCAMD callback, void *userParam, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageCallbackAMD, "(%s, %p)", GET_PRS(callback), (void*)userParam)
    glatter_glDebugMessageCallbackAMD(callback, userParam);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageCallbackAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDebugMessageEnableAMD, (category, severity, count, ids, enabled), (GLenum category, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageEnableAMD_debug(GLenum category, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageEnableAMD, "(%s, %s, %d, %p, %u)", enum_to_string_GL(category), enum_to_string_GL(severity), (int)count, (void*)ids, (unsigned char)enabled)
    glatter_glDebugMessageEnableAMD(category, severity, count, ids, enabled);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageEnableAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDebugMessageInsertAMD, (category, severity, id, length, buf), (GLenum category, GLenum severity, GLuint id, GLsizei length, const GLchar *buf))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageInsertAMD_debug(GLenum category, GLenum severity, GLuint id, GLsizei length, const GLchar *buf, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageInsertAMD, "(%s, %s, %u, %d, %p)", enum_to_string_GL(category), enum_to_string_GL(severity), (unsigned int)id, (int)length, (void*)buf)
    glatter_glDebugMessageInsertAMD(category, severity, id, length, buf);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageInsertAMD_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glGetDebugMessageLogAMD, (count, bufsize, categories, severities, ids, lengths, message), (GLuint count, GLsizei bufsize, GLenum *categories, GLuint *severities, GLuint *ids, GLsizei *lengths, GLchar *message))
GLATTER_INLINE_OR_NOT GLuint glatter_glGetDebugMessageLogAMD_debug(GLuint count, GLsizei bufsize, GLenum *categories, GLuint *severities, GLuint *ids, GLsizei *lengths, GLchar *message, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetDebugMessageLogAMD, "(%u, %d, %p, %p, %p, %p, %p)", (unsigned int)count, (int)bufsize, (void*)categories, (void*)severities, (void*)ids, (void*)lengths, (void*)message)
    GLuint rval = glatter_glGetDebugMessageLogAMD(count, bufsize, categories, severities, ids, lengths, message);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetDebugMessageLogAMD_defined
#endif // defined(GL_AMD_debug_output)
#if defined(GL_AMD_draw_buffers_blend)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendEquationIndexedAMD, (buf, mode), (GLuint buf, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationIndexedAMD_debug(GLuint buf, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationIndexedAMD, "(%u, %s)", (unsigned int)buf, enum_to_string_GL(mode))
    glatter_glBlendEquationIndexedAMD(buf, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationIndexedAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendEquationSeparateIndexedAMD, (buf, modeRGB, modeAlpha), (GLuint buf, GLenum modeRGB, GLenum modeAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparateIndexedAMD_debug(GLuint buf, GLenum modeRGB, GLenum modeAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationSeparateIndexedAMD, "(%u, %s, %s)", (unsigned int)buf, enum_to_string_GL(modeRGB), enum_to_string_GL(modeAlpha))
    glatter_glBlendEquationSeparateIndexedAMD(buf, modeRGB, modeAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationSeparateIndexedAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendFuncIndexedAMD, (buf, src, dst), (GLuint buf, GLenum src, GLenum dst))
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncIndexedAMD_debug(GLuint buf, GLenum src, GLenum dst, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFuncIndexedAMD, "(%u, %s, %s)", (unsigned int)buf, enum_to_string_GL(src), enum_to_string_GL(dst))
    glatter_glBlendFuncIndexedAMD(buf, src, dst);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFuncIndexedAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendFuncSeparateIndexedAMD, (buf, srcRGB, dstRGB, srcAlpha, dstAlpha), (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparateIndexedAMD_debug(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFuncSeparateIndexedAMD, "(%u, %s, %s, %s, %s)", (unsigned int)buf, enum_to_string_GL(srcRGB), enum_to_string_GL(dstRGB), enum_to_string_GL(srcAlpha), enum_to_string_GL(dstAlpha))
    glatter_glBlendFuncSeparateIndexedAMD(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFuncSeparateIndexedAMD_defined
#endif // defined(GL_AMD_draw_buffers_blend)
#if defined(GL_AMD_framebuffer_multisample_advanced)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedRenderbufferStorageMultisampleAdvancedAMD, (renderbuffer, samples, storageSamples, internalformat, width, height), (GLuint renderbuffer, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glNamedRenderbufferStorageMultisampleAdvancedAMD_debug(GLuint renderbuffer, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedRenderbufferStorageMultisampleAdvancedAMD, "(%u, %d, %d, %s, %d, %d)", (unsigned int)renderbuffer, (int)samples, (int)storageSamples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glNamedRenderbufferStorageMultisampleAdvancedAMD(renderbuffer, samples, storageSamples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedRenderbufferStorageMultisampleAdvancedAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glRenderbufferStorageMultisampleAdvancedAMD, (target, samples, storageSamples, internalformat, width, height), (GLenum target, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleAdvancedAMD_debug(GLenum target, GLsizei samples, GLsizei storageSamples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleAdvancedAMD, "(%s, %d, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, (int)storageSamples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleAdvancedAMD(target, samples, storageSamples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleAdvancedAMD_defined
#endif // defined(GL_AMD_framebuffer_multisample_advanced)
#if defined(GL_AMD_framebuffer_sample_positions)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferSamplePositionsfvAMD, (target, numsamples, pixelindex, values), (GLenum target, GLuint numsamples, GLuint pixelindex, const GLfloat *values))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferSamplePositionsfvAMD_debug(GLenum target, GLuint numsamples, GLuint pixelindex, const GLfloat *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferSamplePositionsfvAMD, "(%s, %u, %u, %p)", enum_to_string_GL(target), (unsigned int)numsamples, (unsigned int)pixelindex, (void*)values)
    glatter_glFramebufferSamplePositionsfvAMD(target, numsamples, pixelindex, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferSamplePositionsfvAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetFramebufferParameterfvAMD, (target, pname, numsamples, pixelindex, size, values), (GLenum target, GLenum pname, GLuint numsamples, GLuint pixelindex, GLsizei size, GLfloat *values))
GLATTER_INLINE_OR_NOT void glatter_glGetFramebufferParameterfvAMD_debug(GLenum target, GLenum pname, GLuint numsamples, GLuint pixelindex, GLsizei size, GLfloat *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFramebufferParameterfvAMD, "(%s, %s, %u, %u, %d, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (unsigned int)numsamples, (unsigned int)pixelindex, (int)size, (void*)values)
    glatter_glGetFramebufferParameterfvAMD(target, pname, numsamples, pixelindex, size, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFramebufferParameterfvAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedFramebufferParameterfvAMD, (framebuffer, pname, numsamples, pixelindex, size, values), (GLuint framebuffer, GLenum pname, GLuint numsamples, GLuint pixelindex, GLsizei size, GLfloat *values))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedFramebufferParameterfvAMD_debug(GLuint framebuffer, GLenum pname, GLuint numsamples, GLuint pixelindex, GLsizei size, GLfloat *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedFramebufferParameterfvAMD, "(%u, %s, %u, %u, %d, %p)", (unsigned int)framebuffer, enum_to_string_GL(pname), (unsigned int)numsamples, (unsigned int)pixelindex, (int)size, (void*)values)
    glatter_glGetNamedFramebufferParameterfvAMD(framebuffer, pname, numsamples, pixelindex, size, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedFramebufferParameterfvAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedFramebufferSamplePositionsfvAMD, (framebuffer, numsamples, pixelindex, values), (GLuint framebuffer, GLuint numsamples, GLuint pixelindex, const GLfloat *values))
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferSamplePositionsfvAMD_debug(GLuint framebuffer, GLuint numsamples, GLuint pixelindex, const GLfloat *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedFramebufferSamplePositionsfvAMD, "(%u, %u, %u, %p)", (unsigned int)framebuffer, (unsigned int)numsamples, (unsigned int)pixelindex, (void*)values)
    glatter_glNamedFramebufferSamplePositionsfvAMD(framebuffer, numsamples, pixelindex, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedFramebufferSamplePositionsfvAMD_defined
#endif // defined(GL_AMD_framebuffer_sample_positions)
#if defined(GL_AMD_gpu_shader_int64)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetUniformi64vNV, (program, location, params), (GLuint program, GLint location, GLint64EXT *params))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformi64vNV_debug(GLuint program, GLint location, GLint64EXT *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformi64vNV, "(%u, %d, %p)", (unsigned int)program, (int)location, (void*)params)
    glatter_glGetUniformi64vNV(program, location, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformi64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetUniformui64vNV, (program, location, params), (GLuint program, GLint location, GLuint64EXT *params))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformui64vNV_debug(GLuint program, GLint location, GLuint64EXT *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformui64vNV, "(%u, %d, %p)", (unsigned int)program, (int)location, (void*)params)
    glatter_glGetUniformui64vNV(program, location, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformui64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1i64NV, (program, location, x), (GLuint program, GLint location, GLint64EXT x))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i64NV_debug(GLuint program, GLint location, GLint64EXT x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1i64NV, "(%u, %d, %" PRId64 ")", (unsigned int)program, (int)location, (int64_t)x)
    glatter_glProgramUniform1i64NV(program, location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1i64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1i64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1i64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1i64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1i64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1ui64NV, (program, location, x), (GLuint program, GLint location, GLuint64EXT x))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1ui64NV, "(%u, %d, %" PRIu64 ")", (unsigned int)program, (int)location, (uint64_t)x)
    glatter_glProgramUniform1ui64NV(program, location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1ui64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1ui64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1ui64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1ui64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1ui64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2i64NV, (program, location, x, y), (GLuint program, GLint location, GLint64EXT x, GLint64EXT y))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i64NV_debug(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2i64NV, "(%u, %d, %" PRId64 ", %" PRId64 ")", (unsigned int)program, (int)location, (int64_t)x, (int64_t)y)
    glatter_glProgramUniform2i64NV(program, location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2i64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2i64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2i64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2i64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2i64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2ui64NV, (program, location, x, y), (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2ui64NV, "(%u, %d, %" PRIu64 ", %" PRIu64 ")", (unsigned int)program, (int)location, (uint64_t)x, (uint64_t)y)
    glatter_glProgramUniform2ui64NV(program, location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2ui64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2ui64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2ui64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2ui64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2ui64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3i64NV, (program, location, x, y, z), (GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i64NV_debug(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3i64NV, "(%u, %d, %" PRId64 ", %" PRId64 ", %" PRId64 ")", (unsigned int)program, (int)location, (int64_t)x, (int64_t)y, (int64_t)z)
    glatter_glProgramUniform3i64NV(program, location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3i64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3i64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3i64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3i64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3i64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3ui64NV, (program, location, x, y, z), (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3ui64NV, "(%u, %d, %" PRIu64 ", %" PRIu64 ", %" PRIu64 ")", (unsigned int)program, (int)location, (uint64_t)x, (uint64_t)y, (uint64_t)z)
    glatter_glProgramUniform3ui64NV(program, location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3ui64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3ui64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3ui64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3ui64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3ui64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4i64NV, (program, location, x, y, z, w), (GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i64NV_debug(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4i64NV, "(%u, %d, %" PRId64 ", %" PRId64 ", %" PRId64 ", %" PRId64 ")", (unsigned int)program, (int)location, (int64_t)x, (int64_t)y, (int64_t)z, (int64_t)w)
    glatter_glProgramUniform4i64NV(program, location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4i64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4i64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i64vNV_debug(GLuint program, GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4i64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4i64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4i64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4ui64NV, (program, location, x, y, z, w), (GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui64NV_debug(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4ui64NV, "(%u, %d, %" PRIu64 ", %" PRIu64 ", %" PRIu64 ", %" PRIu64 ")", (unsigned int)program, (int)location, (uint64_t)x, (uint64_t)y, (uint64_t)z, (uint64_t)w)
    glatter_glProgramUniform4ui64NV(program, location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4ui64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4ui64vNV, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4ui64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4ui64vNV(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4ui64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1i64NV, (location, x), (GLint location, GLint64EXT x))
GLATTER_INLINE_OR_NOT void glatter_glUniform1i64NV_debug(GLint location, GLint64EXT x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1i64NV, "(%d, %" PRId64 ")", (int)location, (int64_t)x)
    glatter_glUniform1i64NV(location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1i64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1i64vNV, (location, count, value), (GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1i64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1i64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1i64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1ui64NV, (location, x), (GLint location, GLuint64EXT x))
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui64NV_debug(GLint location, GLuint64EXT x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1ui64NV, "(%d, %" PRIu64 ")", (int)location, (uint64_t)x)
    glatter_glUniform1ui64NV(location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1ui64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1ui64vNV, (location, count, value), (GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1ui64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1ui64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1ui64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2i64NV, (location, x, y), (GLint location, GLint64EXT x, GLint64EXT y))
GLATTER_INLINE_OR_NOT void glatter_glUniform2i64NV_debug(GLint location, GLint64EXT x, GLint64EXT y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2i64NV, "(%d, %" PRId64 ", %" PRId64 ")", (int)location, (int64_t)x, (int64_t)y)
    glatter_glUniform2i64NV(location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2i64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2i64vNV, (location, count, value), (GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2i64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2i64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2i64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2ui64NV, (location, x, y), (GLint location, GLuint64EXT x, GLuint64EXT y))
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui64NV_debug(GLint location, GLuint64EXT x, GLuint64EXT y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2ui64NV, "(%d, %" PRIu64 ", %" PRIu64 ")", (int)location, (uint64_t)x, (uint64_t)y)
    glatter_glUniform2ui64NV(location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2ui64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2ui64vNV, (location, count, value), (GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2ui64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2ui64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2ui64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3i64NV, (location, x, y, z), (GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z))
GLATTER_INLINE_OR_NOT void glatter_glUniform3i64NV_debug(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3i64NV, "(%d, %" PRId64 ", %" PRId64 ", %" PRId64 ")", (int)location, (int64_t)x, (int64_t)y, (int64_t)z)
    glatter_glUniform3i64NV(location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3i64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3i64vNV, (location, count, value), (GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3i64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3i64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3i64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3ui64NV, (location, x, y, z), (GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z))
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui64NV_debug(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3ui64NV, "(%d, %" PRIu64 ", %" PRIu64 ", %" PRIu64 ")", (int)location, (uint64_t)x, (uint64_t)y, (uint64_t)z)
    glatter_glUniform3ui64NV(location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3ui64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3ui64vNV, (location, count, value), (GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3ui64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3ui64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3ui64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4i64NV, (location, x, y, z, w), (GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w))
GLATTER_INLINE_OR_NOT void glatter_glUniform4i64NV_debug(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4i64NV, "(%d, %" PRId64 ", %" PRId64 ", %" PRId64 ", %" PRId64 ")", (int)location, (int64_t)x, (int64_t)y, (int64_t)z, (int64_t)w)
    glatter_glUniform4i64NV(location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4i64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4i64vNV, (location, count, value), (GLint location, GLsizei count, const GLint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4i64vNV_debug(GLint location, GLsizei count, const GLint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4i64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4i64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4i64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4ui64NV, (location, x, y, z, w), (GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w))
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui64NV_debug(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4ui64NV, "(%d, %" PRIu64 ", %" PRIu64 ", %" PRIu64 ", %" PRIu64 ")", (int)location, (uint64_t)x, (uint64_t)y, (uint64_t)z, (uint64_t)w)
    glatter_glUniform4ui64NV(location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4ui64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4ui64vNV, (location, count, value), (GLint location, GLsizei count, const GLuint64EXT *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui64vNV_debug(GLint location, GLsizei count, const GLuint64EXT *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4ui64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4ui64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4ui64vNV_defined
#endif // defined(GL_AMD_gpu_shader_int64)
#if defined(GL_AMD_interleaved_elements)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribParameteriAMD, (index, pname, param), (GLuint index, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribParameteriAMD_debug(GLuint index, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribParameteriAMD, "(%u, %s, %d)", (unsigned int)index, enum_to_string_GL(pname), (int)param)
    glatter_glVertexAttribParameteriAMD(index, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribParameteriAMD_defined
#endif // defined(GL_AMD_interleaved_elements)
#if defined(GL_AMD_multi_draw_indirect)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawArraysIndirectAMD, (mode, indirect, primcount, stride), (GLenum mode, const void *indirect, GLsizei primcount, GLsizei stride))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysIndirectAMD_debug(GLenum mode, const void *indirect, GLsizei primcount, GLsizei stride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawArraysIndirectAMD, "(%s, %p, %d, %d)", enum_to_string_GL(mode), (void*)indirect, (int)primcount, (int)stride)
    glatter_glMultiDrawArraysIndirectAMD(mode, indirect, primcount, stride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawArraysIndirectAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawElementsIndirectAMD, (mode, type, indirect, primcount, stride), (GLenum mode, GLenum type, const void *indirect, GLsizei primcount, GLsizei stride))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsIndirectAMD_debug(GLenum mode, GLenum type, const void *indirect, GLsizei primcount, GLsizei stride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawElementsIndirectAMD, "(%s, %s, %p, %d, %d)", enum_to_string_GL(mode), enum_to_string_GL(type), (void*)indirect, (int)primcount, (int)stride)
    glatter_glMultiDrawElementsIndirectAMD(mode, type, indirect, primcount, stride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawElementsIndirectAMD_defined
#endif // defined(GL_AMD_multi_draw_indirect)
#if defined(GL_AMD_name_gen_delete)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteNamesAMD, (identifier, num, names), (GLenum identifier, GLuint num, const GLuint *names))
GLATTER_INLINE_OR_NOT void glatter_glDeleteNamesAMD_debug(GLenum identifier, GLuint num, const GLuint *names, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteNamesAMD, "(%s, %u, %p)", enum_to_string_GL(identifier), (unsigned int)num, (void*)names)
    glatter_glDeleteNamesAMD(identifier, num, names);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteNamesAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenNamesAMD, (identifier, num, names), (GLenum identifier, GLuint num, GLuint *names))
GLATTER_INLINE_OR_NOT void glatter_glGenNamesAMD_debug(GLenum identifier, GLuint num, GLuint *names, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenNamesAMD, "(%s, %u, %p)", enum_to_string_GL(identifier), (unsigned int)num, (void*)names)
    glatter_glGenNamesAMD(identifier, num, names);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenNamesAMD_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsNameAMD, (identifier, name), (GLenum identifier, GLuint name))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsNameAMD_debug(GLenum identifier, GLuint name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsNameAMD, "(%s, %u)", enum_to_string_GL(identifier), (unsigned int)name)
    GLboolean rval = glatter_glIsNameAMD(identifier, name);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsNameAMD_defined
#endif // defined(GL_AMD_name_gen_delete)
#if defined(GL_AMD_occlusion_query_event)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glQueryObjectParameteruiAMD, (target, id, pname, param), (GLenum target, GLuint id, GLenum pname, GLuint param))
GLATTER_INLINE_OR_NOT void glatter_glQueryObjectParameteruiAMD_debug(GLenum target, GLuint id, GLenum pname, GLuint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glQueryObjectParameteruiAMD, "(%s, %u, %s, %u)", enum_to_string_GL(target), (unsigned int)id, enum_to_string_GL(pname), (unsigned int)param)
    glatter_glQueryObjectParameteruiAMD(target, id, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glQueryObjectParameteruiAMD_defined
#endif // defined(GL_AMD_occlusion_query_event)
#if defined(GL_AMD_performance_monitor)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBeginPerfMonitorAMD, (monitor), (GLuint monitor))
GLATTER_INLINE_OR_NOT void glatter_glBeginPerfMonitorAMD_debug(GLuint monitor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginPerfMonitorAMD, "(%u)", (unsigned int)monitor)
    glatter_glBeginPerfMonitorAMD(monitor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginPerfMonitorAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeletePerfMonitorsAMD, (n, monitors), (GLsizei n, GLuint *monitors))
GLATTER_INLINE_OR_NOT void glatter_glDeletePerfMonitorsAMD_debug(GLsizei n, GLuint *monitors, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeletePerfMonitorsAMD, "(%d, %p)", (int)n, (void*)monitors)
    glatter_glDeletePerfMonitorsAMD(n, monitors);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeletePerfMonitorsAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEndPerfMonitorAMD, (monitor), (GLuint monitor))
GLATTER_INLINE_OR_NOT void glatter_glEndPerfMonitorAMD_debug(GLuint monitor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndPerfMonitorAMD, "(%u)", (unsigned int)monitor)
    glatter_glEndPerfMonitorAMD(monitor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndPerfMonitorAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenPerfMonitorsAMD, (n, monitors), (GLsizei n, GLuint *monitors))
GLATTER_INLINE_OR_NOT void glatter_glGenPerfMonitorsAMD_debug(GLsizei n, GLuint *monitors, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenPerfMonitorsAMD, "(%d, %p)", (int)n, (void*)monitors)
    glatter_glGenPerfMonitorsAMD(n, monitors);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenPerfMonitorsAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPerfMonitorCounterDataAMD, (monitor, pname, dataSize, data, bytesWritten), (GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCounterDataAMD_debug(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorCounterDataAMD, "(%u, %s, %d, %p, %p)", (unsigned int)monitor, enum_to_string_GL(pname), (int)dataSize, (void*)data, (void*)bytesWritten)
    glatter_glGetPerfMonitorCounterDataAMD(monitor, pname, dataSize, data, bytesWritten);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorCounterDataAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPerfMonitorCounterInfoAMD, (group, counter, pname, data), (GLuint group, GLuint counter, GLenum pname, void *data))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCounterInfoAMD_debug(GLuint group, GLuint counter, GLenum pname, void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorCounterInfoAMD, "(%u, %u, %s, %p)", (unsigned int)group, (unsigned int)counter, enum_to_string_GL(pname), (void*)data)
    glatter_glGetPerfMonitorCounterInfoAMD(group, counter, pname, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorCounterInfoAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPerfMonitorCounterStringAMD, (group, counter, bufSize, length, counterString), (GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCounterStringAMD_debug(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorCounterStringAMD, "(%u, %u, %d, %p, %p)", (unsigned int)group, (unsigned int)counter, (int)bufSize, (void*)length, (void*)counterString)
    glatter_glGetPerfMonitorCounterStringAMD(group, counter, bufSize, length, counterString);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorCounterStringAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPerfMonitorCountersAMD, (group, numCounters, maxActiveCounters, counterSize, counters), (GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorCountersAMD_debug(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorCountersAMD, "(%u, %p, %p, %d, %p)", (unsigned int)group, (void*)numCounters, (void*)maxActiveCounters, (int)counterSize, (void*)counters)
    glatter_glGetPerfMonitorCountersAMD(group, numCounters, maxActiveCounters, counterSize, counters);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorCountersAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPerfMonitorGroupStringAMD, (group, bufSize, length, groupString), (GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorGroupStringAMD_debug(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorGroupStringAMD, "(%u, %d, %p, %p)", (unsigned int)group, (int)bufSize, (void*)length, (void*)groupString)
    glatter_glGetPerfMonitorGroupStringAMD(group, bufSize, length, groupString);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorGroupStringAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPerfMonitorGroupsAMD, (numGroups, groupsSize, groups), (GLint *numGroups, GLsizei groupsSize, GLuint *groups))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfMonitorGroupsAMD_debug(GLint *numGroups, GLsizei groupsSize, GLuint *groups, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfMonitorGroupsAMD, "(%p, %d, %p)", (void*)numGroups, (int)groupsSize, (void*)groups)
    glatter_glGetPerfMonitorGroupsAMD(numGroups, groupsSize, groups);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfMonitorGroupsAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSelectPerfMonitorCountersAMD, (monitor, enable, group, numCounters, counterList), (GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *counterList))
GLATTER_INLINE_OR_NOT void glatter_glSelectPerfMonitorCountersAMD_debug(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *counterList, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSelectPerfMonitorCountersAMD, "(%u, %u, %u, %d, %p)", (unsigned int)monitor, (unsigned char)enable, (unsigned int)group, (int)numCounters, (void*)counterList)
    glatter_glSelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, counterList);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSelectPerfMonitorCountersAMD_defined
#endif // defined(GL_AMD_performance_monitor)
#if defined(GL_AMD_sample_positions)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSetMultisamplefvAMD, (pname, index, val), (GLenum pname, GLuint index, const GLfloat *val))
GLATTER_INLINE_OR_NOT void glatter_glSetMultisamplefvAMD_debug(GLenum pname, GLuint index, const GLfloat *val, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSetMultisamplefvAMD, "(%s, %u, %p)", enum_to_string_GL(pname), (unsigned int)index, (void*)val)
    glatter_glSetMultisamplefvAMD(pname, index, val);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSetMultisamplefvAMD_defined
#endif // defined(GL_AMD_sample_positions)
#if defined(GL_AMD_sparse_texture)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexStorageSparseAMD, (target, internalFormat, width, height, depth, layers, flags), (GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags))
GLATTER_INLINE_OR_NOT void glatter_glTexStorageSparseAMD_debug(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorageSparseAMD, "(%s, %s, %d, %d, %d, %d, %u)", enum_to_string_GL(target), enum_to_string_GL(internalFormat), (int)width, (int)height, (int)depth, (int)layers, (unsigned int)flags)
    glatter_glTexStorageSparseAMD(target, internalFormat, width, height, depth, layers, flags);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorageSparseAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureStorageSparseAMD, (texture, target, internalFormat, width, height, depth, layers, flags), (GLuint texture, GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageSparseAMD_debug(GLuint texture, GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorageSparseAMD, "(%u, %s, %s, %d, %d, %d, %d, %u)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(internalFormat), (int)width, (int)height, (int)depth, (int)layers, (unsigned int)flags)
    glatter_glTextureStorageSparseAMD(texture, target, internalFormat, width, height, depth, layers, flags);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorageSparseAMD_defined
#endif // defined(GL_AMD_sparse_texture)
#if defined(GL_AMD_stencil_operation_extended)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilOpValueAMD, (face, value), (GLenum face, GLuint value))
GLATTER_INLINE_OR_NOT void glatter_glStencilOpValueAMD_debug(GLenum face, GLuint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilOpValueAMD, "(%s, %u)", enum_to_string_GL(face), (unsigned int)value)
    glatter_glStencilOpValueAMD(face, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilOpValueAMD_defined
#endif // defined(GL_AMD_stencil_operation_extended)
#if defined(GL_AMD_vertex_shader_tessellator)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTessellationFactorAMD, (factor), (GLfloat factor))
GLATTER_INLINE_OR_NOT void glatter_glTessellationFactorAMD_debug(GLfloat factor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTessellationFactorAMD, "(%f)", (float)factor)
    glatter_glTessellationFactorAMD(factor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTessellationFactorAMD_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTessellationModeAMD, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glTessellationModeAMD_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTessellationModeAMD, "(%s)", enum_to_string_GL(mode))
    glatter_glTessellationModeAMD(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTessellationModeAMD_defined
#endif // defined(GL_AMD_vertex_shader_tessellator)
#if defined(GL_APPLE_element_array)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawElementArrayAPPLE, (mode, first, count), (GLenum mode, GLint first, GLsizei count))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementArrayAPPLE_debug(GLenum mode, GLint first, GLsizei count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementArrayAPPLE, "(%s, %d, %d)", enum_to_string_GL(mode), (int)first, (int)count)
    glatter_glDrawElementArrayAPPLE(mode, first, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementArrayAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawRangeElementArrayAPPLE, (mode, start, end, first, count), (GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count))
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElementArrayAPPLE_debug(GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawRangeElementArrayAPPLE, "(%s, %u, %u, %d, %d)", enum_to_string_GL(mode), (unsigned int)start, (unsigned int)end, (int)first, (int)count)
    glatter_glDrawRangeElementArrayAPPLE(mode, start, end, first, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawRangeElementArrayAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glElementPointerAPPLE, (type, pointer), (GLenum type, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glElementPointerAPPLE_debug(GLenum type, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glElementPointerAPPLE, "(%s, %p)", enum_to_string_GL(type), (void*)pointer)
    glatter_glElementPointerAPPLE(type, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glElementPointerAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawElementArrayAPPLE, (mode, first, count, primcount), (GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementArrayAPPLE_debug(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawElementArrayAPPLE, "(%s, %p, %p, %d)", enum_to_string_GL(mode), (void*)first, (void*)count, (int)primcount)
    glatter_glMultiDrawElementArrayAPPLE(mode, first, count, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawElementArrayAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawRangeElementArrayAPPLE, (mode, start, end, first, count, primcount), (GLenum mode, GLuint start, GLuint end, const GLint *first, const GLsizei *count, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawRangeElementArrayAPPLE_debug(GLenum mode, GLuint start, GLuint end, const GLint *first, const GLsizei *count, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawRangeElementArrayAPPLE, "(%s, %u, %u, %p, %p, %d)", enum_to_string_GL(mode), (unsigned int)start, (unsigned int)end, (void*)first, (void*)count, (int)primcount)
    glatter_glMultiDrawRangeElementArrayAPPLE(mode, start, end, first, count, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawRangeElementArrayAPPLE_defined
#endif // defined(GL_APPLE_element_array)
#if defined(GL_APPLE_fence)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteFencesAPPLE, (n, fences), (GLsizei n, const GLuint *fences))
GLATTER_INLINE_OR_NOT void glatter_glDeleteFencesAPPLE_debug(GLsizei n, const GLuint *fences, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteFencesAPPLE, "(%d, %p)", (int)n, (void*)fences)
    glatter_glDeleteFencesAPPLE(n, fences);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteFencesAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFinishFenceAPPLE, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT void glatter_glFinishFenceAPPLE_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFinishFenceAPPLE, "(%u)", (unsigned int)fence)
    glatter_glFinishFenceAPPLE(fence);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFinishFenceAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFinishObjectAPPLE, (object, name), (GLenum object, GLint name))
GLATTER_INLINE_OR_NOT void glatter_glFinishObjectAPPLE_debug(GLenum object, GLint name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFinishObjectAPPLE, "(%s, %d)", enum_to_string_GL(object), (int)name)
    glatter_glFinishObjectAPPLE(object, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFinishObjectAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenFencesAPPLE, (n, fences), (GLsizei n, GLuint *fences))
GLATTER_INLINE_OR_NOT void glatter_glGenFencesAPPLE_debug(GLsizei n, GLuint *fences, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenFencesAPPLE, "(%d, %p)", (int)n, (void*)fences)
    glatter_glGenFencesAPPLE(n, fences);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenFencesAPPLE_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsFenceAPPLE, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsFenceAPPLE_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsFenceAPPLE, "(%u)", (unsigned int)fence)
    GLboolean rval = glatter_glIsFenceAPPLE(fence);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsFenceAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSetFenceAPPLE, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT void glatter_glSetFenceAPPLE_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSetFenceAPPLE, "(%u)", (unsigned int)fence)
    glatter_glSetFenceAPPLE(fence);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSetFenceAPPLE_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glTestFenceAPPLE, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT GLboolean glatter_glTestFenceAPPLE_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTestFenceAPPLE, "(%u)", (unsigned int)fence)
    GLboolean rval = glatter_glTestFenceAPPLE(fence);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glTestFenceAPPLE_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glTestObjectAPPLE, (object, name), (GLenum object, GLuint name))
GLATTER_INLINE_OR_NOT GLboolean glatter_glTestObjectAPPLE_debug(GLenum object, GLuint name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTestObjectAPPLE, "(%s, %u)", enum_to_string_GL(object), (unsigned int)name)
    GLboolean rval = glatter_glTestObjectAPPLE(object, name);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glTestObjectAPPLE_defined
#endif // defined(GL_APPLE_fence)
#if defined(GL_APPLE_flush_buffer_range)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBufferParameteriAPPLE, (target, pname, param), (GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glBufferParameteriAPPLE_debug(GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferParameteriAPPLE, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glBufferParameteriAPPLE(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferParameteriAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFlushMappedBufferRangeAPPLE, (target, offset, size), (GLenum target, GLintptr offset, GLsizeiptr size))
GLATTER_INLINE_OR_NOT void glatter_glFlushMappedBufferRangeAPPLE_debug(GLenum target, GLintptr offset, GLsizeiptr size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFlushMappedBufferRangeAPPLE, "(%s, %s, %s)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(size))
    glatter_glFlushMappedBufferRangeAPPLE(target, offset, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFlushMappedBufferRangeAPPLE_defined
#endif // defined(GL_APPLE_flush_buffer_range)
#if defined(GL_APPLE_object_purgeable)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetObjectParameterivAPPLE, (objectType, name, pname, params), (GLenum objectType, GLuint name, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetObjectParameterivAPPLE_debug(GLenum objectType, GLuint name, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetObjectParameterivAPPLE, "(%s, %u, %s, %p)", enum_to_string_GL(objectType), (unsigned int)name, enum_to_string_GL(pname), (void*)params)
    glatter_glGetObjectParameterivAPPLE(objectType, name, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetObjectParameterivAPPLE_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLenum, APIENTRY, glObjectPurgeableAPPLE, (objectType, name, option), (GLenum objectType, GLuint name, GLenum option))
GLATTER_INLINE_OR_NOT GLenum glatter_glObjectPurgeableAPPLE_debug(GLenum objectType, GLuint name, GLenum option, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glObjectPurgeableAPPLE, "(%s, %u, %s)", enum_to_string_GL(objectType), (unsigned int)name, enum_to_string_GL(option))
    GLenum rval = glatter_glObjectPurgeableAPPLE(objectType, name, option);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glObjectPurgeableAPPLE_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLenum, APIENTRY, glObjectUnpurgeableAPPLE, (objectType, name, option), (GLenum objectType, GLuint name, GLenum option))
GLATTER_INLINE_OR_NOT GLenum glatter_glObjectUnpurgeableAPPLE_debug(GLenum objectType, GLuint name, GLenum option, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glObjectUnpurgeableAPPLE, "(%s, %u, %s)", enum_to_string_GL(objectType), (unsigned int)name, enum_to_string_GL(option))
    GLenum rval = glatter_glObjectUnpurgeableAPPLE(objectType, name, option);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glObjectUnpurgeableAPPLE_defined
#endif // defined(GL_APPLE_object_purgeable)
#if defined(GL_APPLE_texture_range)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTexParameterPointervAPPLE, (target, pname, params), (GLenum target, GLenum pname, void **params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterPointervAPPLE_debug(GLenum target, GLenum pname, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterPointervAPPLE, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterPointervAPPLE(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterPointervAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureRangeAPPLE, (target, length, pointer), (GLenum target, GLsizei length, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glTextureRangeAPPLE_debug(GLenum target, GLsizei length, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureRangeAPPLE, "(%s, %d, %p)", enum_to_string_GL(target), (int)length, (void*)pointer)
    glatter_glTextureRangeAPPLE(target, length, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureRangeAPPLE_defined
#endif // defined(GL_APPLE_texture_range)
#if defined(GL_APPLE_vertex_array_object)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindVertexArrayAPPLE, (array), (GLuint array))
GLATTER_INLINE_OR_NOT void glatter_glBindVertexArrayAPPLE_debug(GLuint array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindVertexArrayAPPLE, "(%u)", (unsigned int)array)
    glatter_glBindVertexArrayAPPLE(array);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindVertexArrayAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteVertexArraysAPPLE, (n, arrays), (GLsizei n, const GLuint *arrays))
GLATTER_INLINE_OR_NOT void glatter_glDeleteVertexArraysAPPLE_debug(GLsizei n, const GLuint *arrays, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteVertexArraysAPPLE, "(%d, %p)", (int)n, (void*)arrays)
    glatter_glDeleteVertexArraysAPPLE(n, arrays);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteVertexArraysAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenVertexArraysAPPLE, (n, arrays), (GLsizei n, GLuint *arrays))
GLATTER_INLINE_OR_NOT void glatter_glGenVertexArraysAPPLE_debug(GLsizei n, GLuint *arrays, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenVertexArraysAPPLE, "(%d, %p)", (int)n, (void*)arrays)
    glatter_glGenVertexArraysAPPLE(n, arrays);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenVertexArraysAPPLE_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsVertexArrayAPPLE, (array), (GLuint array))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsVertexArrayAPPLE_debug(GLuint array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsVertexArrayAPPLE, "(%u)", (unsigned int)array)
    GLboolean rval = glatter_glIsVertexArrayAPPLE(array);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsVertexArrayAPPLE_defined
#endif // defined(GL_APPLE_vertex_array_object)
#if defined(GL_APPLE_vertex_array_range)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFlushVertexArrayRangeAPPLE, (length, pointer), (GLsizei length, void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glFlushVertexArrayRangeAPPLE_debug(GLsizei length, void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFlushVertexArrayRangeAPPLE, "(%d, %p)", (int)length, (void*)pointer)
    glatter_glFlushVertexArrayRangeAPPLE(length, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFlushVertexArrayRangeAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayParameteriAPPLE, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayParameteriAPPLE_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayParameteriAPPLE, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glVertexArrayParameteriAPPLE(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayParameteriAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayRangeAPPLE, (length, pointer), (GLsizei length, void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayRangeAPPLE_debug(GLsizei length, void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayRangeAPPLE, "(%d, %p)", (int)length, (void*)pointer)
    glatter_glVertexArrayRangeAPPLE(length, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayRangeAPPLE_defined
#endif // defined(GL_APPLE_vertex_array_range)
#if defined(GL_APPLE_vertex_program_evaluators)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDisableVertexAttribAPPLE, (index, pname), (GLuint index, GLenum pname))
GLATTER_INLINE_OR_NOT void glatter_glDisableVertexAttribAPPLE_debug(GLuint index, GLenum pname, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableVertexAttribAPPLE, "(%u, %s)", (unsigned int)index, enum_to_string_GL(pname))
    glatter_glDisableVertexAttribAPPLE(index, pname);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableVertexAttribAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEnableVertexAttribAPPLE, (index, pname), (GLuint index, GLenum pname))
GLATTER_INLINE_OR_NOT void glatter_glEnableVertexAttribAPPLE_debug(GLuint index, GLenum pname, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableVertexAttribAPPLE, "(%u, %s)", (unsigned int)index, enum_to_string_GL(pname))
    glatter_glEnableVertexAttribAPPLE(index, pname);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableVertexAttribAPPLE_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsVertexAttribEnabledAPPLE, (index, pname), (GLuint index, GLenum pname))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsVertexAttribEnabledAPPLE_debug(GLuint index, GLenum pname, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsVertexAttribEnabledAPPLE, "(%u, %s)", (unsigned int)index, enum_to_string_GL(pname))
    GLboolean rval = glatter_glIsVertexAttribEnabledAPPLE(index, pname);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsVertexAttribEnabledAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMapVertexAttrib1dAPPLE, (index, size, u1, u2, stride, order, points), (GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points))
GLATTER_INLINE_OR_NOT void glatter_glMapVertexAttrib1dAPPLE_debug(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapVertexAttrib1dAPPLE, "(%u, %u, %f, %f, %d, %d, %p)", (unsigned int)index, (unsigned int)size, (double)u1, (double)u2, (int)stride, (int)order, (void*)points)
    glatter_glMapVertexAttrib1dAPPLE(index, size, u1, u2, stride, order, points);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMapVertexAttrib1dAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMapVertexAttrib1fAPPLE, (index, size, u1, u2, stride, order, points), (GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points))
GLATTER_INLINE_OR_NOT void glatter_glMapVertexAttrib1fAPPLE_debug(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapVertexAttrib1fAPPLE, "(%u, %u, %f, %f, %d, %d, %p)", (unsigned int)index, (unsigned int)size, (float)u1, (float)u2, (int)stride, (int)order, (void*)points)
    glatter_glMapVertexAttrib1fAPPLE(index, size, u1, u2, stride, order, points);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMapVertexAttrib1fAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMapVertexAttrib2dAPPLE, (index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points), (GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points))
GLATTER_INLINE_OR_NOT void glatter_glMapVertexAttrib2dAPPLE_debug(GLuint index, GLuint size, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapVertexAttrib2dAPPLE, "(%u, %u, %f, %f, %d, %d, %f, %f, %d, %d, %p)", (unsigned int)index, (unsigned int)size, (double)u1, (double)u2, (int)ustride, (int)uorder, (double)v1, (double)v2, (int)vstride, (int)vorder, (void*)points)
    glatter_glMapVertexAttrib2dAPPLE(index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMapVertexAttrib2dAPPLE_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMapVertexAttrib2fAPPLE, (index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points), (GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points))
GLATTER_INLINE_OR_NOT void glatter_glMapVertexAttrib2fAPPLE_debug(GLuint index, GLuint size, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapVertexAttrib2fAPPLE, "(%u, %u, %f, %f, %d, %d, %f, %f, %d, %d, %p)", (unsigned int)index, (unsigned int)size, (float)u1, (float)u2, (int)ustride, (int)uorder, (float)v1, (float)v2, (int)vstride, (int)vorder, (void*)points)
    glatter_glMapVertexAttrib2fAPPLE(index, size, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMapVertexAttrib2fAPPLE_defined
#endif // defined(GL_APPLE_vertex_program_evaluators)
#if defined(GL_ARB_ES3_2_compatibility)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPrimitiveBoundingBoxARB, (minX, minY, minZ, minW, maxX, maxY, maxZ, maxW), (GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW))
GLATTER_INLINE_OR_NOT void glatter_glPrimitiveBoundingBoxARB_debug(GLfloat minX, GLfloat minY, GLfloat minZ, GLfloat minW, GLfloat maxX, GLfloat maxY, GLfloat maxZ, GLfloat maxW, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPrimitiveBoundingBoxARB, "(%f, %f, %f, %f, %f, %f, %f, %f)", (float)minX, (float)minY, (float)minZ, (float)minW, (float)maxX, (float)maxY, (float)maxZ, (float)maxW)
    glatter_glPrimitiveBoundingBoxARB(minX, minY, minZ, minW, maxX, maxY, maxZ, maxW);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPrimitiveBoundingBoxARB_defined
#endif // defined(GL_ARB_ES3_2_compatibility)
#if defined(GL_ARB_bindless_texture)
GLATTER_FBLOCK(return, GL, GLAPI, GLuint64, APIENTRY, glGetImageHandleARB, (texture, level, layered, layer, format), (GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format))
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetImageHandleARB_debug(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetImageHandleARB, "(%u, %d, %u, %d, %s)", (unsigned int)texture, (int)level, (unsigned char)layered, (int)layer, enum_to_string_GL(format))
    GLuint64 rval = glatter_glGetImageHandleARB(texture, level, layered, layer, format);
    GLATTER_RBLOCK("%" PRIu64 "\n", (uint64_t)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetImageHandleARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint64, APIENTRY, glGetTextureHandleARB, (texture), (GLuint texture))
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureHandleARB_debug(GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureHandleARB, "(%u)", (unsigned int)texture)
    GLuint64 rval = glatter_glGetTextureHandleARB(texture);
    GLATTER_RBLOCK("%" PRIu64 "\n", (uint64_t)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetTextureHandleARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint64, APIENTRY, glGetTextureSamplerHandleARB, (texture, sampler), (GLuint texture, GLuint sampler))
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureSamplerHandleARB_debug(GLuint texture, GLuint sampler, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureSamplerHandleARB, "(%u, %u)", (unsigned int)texture, (unsigned int)sampler)
    GLuint64 rval = glatter_glGetTextureSamplerHandleARB(texture, sampler);
    GLATTER_RBLOCK("%" PRIu64 "\n", (uint64_t)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetTextureSamplerHandleARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexAttribLui64vARB, (index, pname, params), (GLuint index, GLenum pname, GLuint64EXT *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribLui64vARB_debug(GLuint index, GLenum pname, GLuint64EXT *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribLui64vARB, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVertexAttribLui64vARB(index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribLui64vARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsImageHandleResidentARB, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsImageHandleResidentARB_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsImageHandleResidentARB, "(%" PRIu64 ")", (uint64_t)handle)
    GLboolean rval = glatter_glIsImageHandleResidentARB(handle);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsImageHandleResidentARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsTextureHandleResidentARB, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTextureHandleResidentARB_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsTextureHandleResidentARB, "(%" PRIu64 ")", (uint64_t)handle)
    GLboolean rval = glatter_glIsTextureHandleResidentARB(handle);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsTextureHandleResidentARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMakeImageHandleNonResidentARB, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT void glatter_glMakeImageHandleNonResidentARB_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeImageHandleNonResidentARB, "(%" PRIu64 ")", (uint64_t)handle)
    glatter_glMakeImageHandleNonResidentARB(handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeImageHandleNonResidentARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMakeImageHandleResidentARB, (handle, access), (GLuint64 handle, GLenum access))
GLATTER_INLINE_OR_NOT void glatter_glMakeImageHandleResidentARB_debug(GLuint64 handle, GLenum access, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeImageHandleResidentARB, "(%" PRIu64 ", %s)", (uint64_t)handle, enum_to_string_GL(access))
    glatter_glMakeImageHandleResidentARB(handle, access);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeImageHandleResidentARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMakeTextureHandleNonResidentARB, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT void glatter_glMakeTextureHandleNonResidentARB_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeTextureHandleNonResidentARB, "(%" PRIu64 ")", (uint64_t)handle)
    glatter_glMakeTextureHandleNonResidentARB(handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeTextureHandleNonResidentARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMakeTextureHandleResidentARB, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT void glatter_glMakeTextureHandleResidentARB_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeTextureHandleResidentARB, "(%" PRIu64 ")", (uint64_t)handle)
    glatter_glMakeTextureHandleResidentARB(handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeTextureHandleResidentARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformHandleui64ARB, (program, location, value), (GLuint program, GLint location, GLuint64 value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64ARB_debug(GLuint program, GLint location, GLuint64 value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformHandleui64ARB, "(%u, %d, %" PRIu64 ")", (unsigned int)program, (int)location, (uint64_t)value)
    glatter_glProgramUniformHandleui64ARB(program, location, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformHandleui64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformHandleui64vARB, (program, location, count, values), (GLuint program, GLint location, GLsizei count, const GLuint64 *values))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64vARB_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformHandleui64vARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)values)
    glatter_glProgramUniformHandleui64vARB(program, location, count, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformHandleui64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniformHandleui64ARB, (location, value), (GLint location, GLuint64 value))
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64ARB_debug(GLint location, GLuint64 value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformHandleui64ARB, "(%d, %" PRIu64 ")", (int)location, (uint64_t)value)
    glatter_glUniformHandleui64ARB(location, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformHandleui64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniformHandleui64vARB, (location, count, value), (GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64vARB_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformHandleui64vARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniformHandleui64vARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformHandleui64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribL1ui64ARB, (index, x), (GLuint index, GLuint64EXT x))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1ui64ARB_debug(GLuint index, GLuint64EXT x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribL1ui64ARB, "(%u, %" PRIu64 ")", (unsigned int)index, (uint64_t)x)
    glatter_glVertexAttribL1ui64ARB(index, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribL1ui64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribL1ui64vARB, (index, v), (GLuint index, const GLuint64EXT *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1ui64vARB_debug(GLuint index, const GLuint64EXT *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribL1ui64vARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttribL1ui64vARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribL1ui64vARB_defined
#endif // defined(GL_ARB_bindless_texture)
#if defined(GL_ARB_cl_event)
GLATTER_FBLOCK(return, GL, GLAPI, GLsync, APIENTRY, glCreateSyncFromCLeventARB, (context, event, flags), (struct _cl_context *context, struct _cl_event *event, GLbitfield flags))
GLATTER_INLINE_OR_NOT GLsync glatter_glCreateSyncFromCLeventARB_debug(struct _cl_context *context, struct _cl_event *event, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateSyncFromCLeventARB, "(%p, %p, %u)", (void*)context, (void*)event, (unsigned int)flags)
    GLsync rval = glatter_glCreateSyncFromCLeventARB(context, event, flags);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCreateSyncFromCLeventARB_defined
#endif // defined(GL_ARB_cl_event)
#if defined(GL_ARB_color_buffer_float)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glClampColorARB, (target, clamp), (GLenum target, GLenum clamp))
GLATTER_INLINE_OR_NOT void glatter_glClampColorARB_debug(GLenum target, GLenum clamp, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClampColorARB, "(%s, %s)", enum_to_string_GL(target), enum_to_string_GL(clamp))
    glatter_glClampColorARB(target, clamp);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClampColorARB_defined
#endif // defined(GL_ARB_color_buffer_float)
#if defined(GL_ARB_compute_variable_group_size)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDispatchComputeGroupSizeARB, (num_groups_x, num_groups_y, num_groups_z, group_size_x, group_size_y, group_size_z), (GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z))
GLATTER_INLINE_OR_NOT void glatter_glDispatchComputeGroupSizeARB_debug(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDispatchComputeGroupSizeARB, "(%u, %u, %u, %u, %u, %u)", (unsigned int)num_groups_x, (unsigned int)num_groups_y, (unsigned int)num_groups_z, (unsigned int)group_size_x, (unsigned int)group_size_y, (unsigned int)group_size_z)
    glatter_glDispatchComputeGroupSizeARB(num_groups_x, num_groups_y, num_groups_z, group_size_x, group_size_y, group_size_z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDispatchComputeGroupSizeARB_defined
#endif // defined(GL_ARB_compute_variable_group_size)
#if defined(GL_ARB_debug_output)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDebugMessageCallbackARB, (callback, userParam), (GLDEBUGPROCARB callback, const void *userParam))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageCallbackARB_debug(GLDEBUGPROCARB callback, const void *userParam, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageCallbackARB, "(%s, %p)", GET_PRS(callback), (void*)userParam)
    glatter_glDebugMessageCallbackARB(callback, userParam);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageCallbackARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDebugMessageControlARB, (source, type, severity, count, ids, enabled), (GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageControlARB_debug(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint *ids, GLboolean enabled, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageControlARB, "(%s, %s, %s, %d, %p, %u)", enum_to_string_GL(source), enum_to_string_GL(type), enum_to_string_GL(severity), (int)count, (void*)ids, (unsigned char)enabled)
    glatter_glDebugMessageControlARB(source, type, severity, count, ids, enabled);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageControlARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDebugMessageInsertARB, (source, type, id, severity, length, buf), (GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf))
GLATTER_INLINE_OR_NOT void glatter_glDebugMessageInsertARB_debug(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar *buf, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDebugMessageInsertARB, "(%s, %s, %u, %s, %d, %p)", enum_to_string_GL(source), enum_to_string_GL(type), (unsigned int)id, enum_to_string_GL(severity), (int)length, (void*)buf)
    glatter_glDebugMessageInsertARB(source, type, id, severity, length, buf);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDebugMessageInsertARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glGetDebugMessageLogARB, (count, bufSize, sources, types, ids, severities, lengths, messageLog), (GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog))
GLATTER_INLINE_OR_NOT GLuint glatter_glGetDebugMessageLogARB_debug(GLuint count, GLsizei bufSize, GLenum *sources, GLenum *types, GLuint *ids, GLenum *severities, GLsizei *lengths, GLchar *messageLog, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetDebugMessageLogARB, "(%u, %d, %p, %p, %p, %p, %p, %p)", (unsigned int)count, (int)bufSize, (void*)sources, (void*)types, (void*)ids, (void*)severities, (void*)lengths, (void*)messageLog)
    GLuint rval = glatter_glGetDebugMessageLogARB(count, bufSize, sources, types, ids, severities, lengths, messageLog);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetDebugMessageLogARB_defined
#endif // defined(GL_ARB_debug_output)
#if defined(GL_ARB_draw_buffers)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawBuffersARB, (n, bufs), (GLsizei n, const GLenum *bufs))
GLATTER_INLINE_OR_NOT void glatter_glDrawBuffersARB_debug(GLsizei n, const GLenum *bufs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawBuffersARB, "(%d, %p)", (int)n, (void*)bufs)
    glatter_glDrawBuffersARB(n, bufs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawBuffersARB_defined
#endif // defined(GL_ARB_draw_buffers)
#if defined(GL_ARB_draw_buffers_blend)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendEquationSeparateiARB, (buf, modeRGB, modeAlpha), (GLuint buf, GLenum modeRGB, GLenum modeAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparateiARB_debug(GLuint buf, GLenum modeRGB, GLenum modeAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationSeparateiARB, "(%u, %s, %s)", (unsigned int)buf, enum_to_string_GL(modeRGB), enum_to_string_GL(modeAlpha))
    glatter_glBlendEquationSeparateiARB(buf, modeRGB, modeAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationSeparateiARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendEquationiARB, (buf, mode), (GLuint buf, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationiARB_debug(GLuint buf, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationiARB, "(%u, %s)", (unsigned int)buf, enum_to_string_GL(mode))
    glatter_glBlendEquationiARB(buf, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationiARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendFuncSeparateiARB, (buf, srcRGB, dstRGB, srcAlpha, dstAlpha), (GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparateiARB_debug(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFuncSeparateiARB, "(%u, %s, %s, %s, %s)", (unsigned int)buf, enum_to_string_GL(srcRGB), enum_to_string_GL(dstRGB), enum_to_string_GL(srcAlpha), enum_to_string_GL(dstAlpha))
    glatter_glBlendFuncSeparateiARB(buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFuncSeparateiARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendFunciARB, (buf, src, dst), (GLuint buf, GLenum src, GLenum dst))
GLATTER_INLINE_OR_NOT void glatter_glBlendFunciARB_debug(GLuint buf, GLenum src, GLenum dst, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFunciARB, "(%u, %s, %s)", (unsigned int)buf, enum_to_string_GL(src), enum_to_string_GL(dst))
    glatter_glBlendFunciARB(buf, src, dst);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFunciARB_defined
#endif // defined(GL_ARB_draw_buffers_blend)
#if defined(GL_ARB_draw_instanced)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawArraysInstancedARB, (mode, first, count, primcount), (GLenum mode, GLint first, GLsizei count, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysInstancedARB_debug(GLenum mode, GLint first, GLsizei count, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArraysInstancedARB, "(%s, %d, %d, %d)", enum_to_string_GL(mode), (int)first, (int)count, (int)primcount)
    glatter_glDrawArraysInstancedARB(mode, first, count, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArraysInstancedARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawElementsInstancedARB, (mode, count, type, indices, primcount), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedARB_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsInstancedARB, "(%s, %d, %s, %p, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)primcount)
    glatter_glDrawElementsInstancedARB(mode, count, type, indices, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsInstancedARB_defined
#endif // defined(GL_ARB_draw_instanced)
#if defined(GL_ARB_fragment_program)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindProgramARB, (target, program), (GLenum target, GLuint program))
GLATTER_INLINE_OR_NOT void glatter_glBindProgramARB_debug(GLenum target, GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindProgramARB, "(%s, %u)", enum_to_string_GL(target), (unsigned int)program)
    glatter_glBindProgramARB(target, program);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindProgramARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteProgramsARB, (n, programs), (GLsizei n, const GLuint *programs))
GLATTER_INLINE_OR_NOT void glatter_glDeleteProgramsARB_debug(GLsizei n, const GLuint *programs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteProgramsARB, "(%d, %p)", (int)n, (void*)programs)
    glatter_glDeleteProgramsARB(n, programs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteProgramsARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenProgramsARB, (n, programs), (GLsizei n, GLuint *programs))
GLATTER_INLINE_OR_NOT void glatter_glGenProgramsARB_debug(GLsizei n, GLuint *programs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenProgramsARB, "(%d, %p)", (int)n, (void*)programs)
    glatter_glGenProgramsARB(n, programs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenProgramsARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramEnvParameterdvARB, (target, index, params), (GLenum target, GLuint index, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramEnvParameterdvARB_debug(GLenum target, GLuint index, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramEnvParameterdvARB, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetProgramEnvParameterdvARB(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramEnvParameterdvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramEnvParameterfvARB, (target, index, params), (GLenum target, GLuint index, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramEnvParameterfvARB_debug(GLenum target, GLuint index, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramEnvParameterfvARB, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetProgramEnvParameterfvARB(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramEnvParameterfvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramLocalParameterdvARB, (target, index, params), (GLenum target, GLuint index, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramLocalParameterdvARB_debug(GLenum target, GLuint index, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramLocalParameterdvARB, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetProgramLocalParameterdvARB(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramLocalParameterdvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramLocalParameterfvARB, (target, index, params), (GLenum target, GLuint index, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramLocalParameterfvARB_debug(GLenum target, GLuint index, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramLocalParameterfvARB, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetProgramLocalParameterfvARB(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramLocalParameterfvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramStringARB, (target, pname, string), (GLenum target, GLenum pname, void *string))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramStringARB_debug(GLenum target, GLenum pname, void *string, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramStringARB, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)string)
    glatter_glGetProgramStringARB(target, pname, string);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramStringARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramivARB, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramivARB_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramivARB, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetProgramivARB(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramivARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsProgramARB, (program), (GLuint program))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsProgramARB_debug(GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsProgramARB, "(%u)", (unsigned int)program)
    GLboolean rval = glatter_glIsProgramARB(program);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsProgramARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramEnvParameter4dARB, (target, index, x, y, z, w), (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameter4dARB_debug(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramEnvParameter4dARB, "(%s, %u, %f, %f, %f, %f)", enum_to_string_GL(target), (unsigned int)index, (double)x, (double)y, (double)z, (double)w)
    glatter_glProgramEnvParameter4dARB(target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramEnvParameter4dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramEnvParameter4dvARB, (target, index, params), (GLenum target, GLuint index, const GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameter4dvARB_debug(GLenum target, GLuint index, const GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramEnvParameter4dvARB, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glProgramEnvParameter4dvARB(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramEnvParameter4dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramEnvParameter4fARB, (target, index, x, y, z, w), (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameter4fARB_debug(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramEnvParameter4fARB, "(%s, %u, %f, %f, %f, %f)", enum_to_string_GL(target), (unsigned int)index, (float)x, (float)y, (float)z, (float)w)
    glatter_glProgramEnvParameter4fARB(target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramEnvParameter4fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramEnvParameter4fvARB, (target, index, params), (GLenum target, GLuint index, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameter4fvARB_debug(GLenum target, GLuint index, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramEnvParameter4fvARB, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glProgramEnvParameter4fvARB(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramEnvParameter4fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramLocalParameter4dARB, (target, index, x, y, z, w), (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameter4dARB_debug(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramLocalParameter4dARB, "(%s, %u, %f, %f, %f, %f)", enum_to_string_GL(target), (unsigned int)index, (double)x, (double)y, (double)z, (double)w)
    glatter_glProgramLocalParameter4dARB(target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramLocalParameter4dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramLocalParameter4dvARB, (target, index, params), (GLenum target, GLuint index, const GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameter4dvARB_debug(GLenum target, GLuint index, const GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramLocalParameter4dvARB, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glProgramLocalParameter4dvARB(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramLocalParameter4dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramLocalParameter4fARB, (target, index, x, y, z, w), (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameter4fARB_debug(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramLocalParameter4fARB, "(%s, %u, %f, %f, %f, %f)", enum_to_string_GL(target), (unsigned int)index, (float)x, (float)y, (float)z, (float)w)
    glatter_glProgramLocalParameter4fARB(target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramLocalParameter4fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramLocalParameter4fvARB, (target, index, params), (GLenum target, GLuint index, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameter4fvARB_debug(GLenum target, GLuint index, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramLocalParameter4fvARB, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glProgramLocalParameter4fvARB(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramLocalParameter4fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramStringARB, (target, format, len, string), (GLenum target, GLenum format, GLsizei len, const void *string))
GLATTER_INLINE_OR_NOT void glatter_glProgramStringARB_debug(GLenum target, GLenum format, GLsizei len, const void *string, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramStringARB, "(%s, %s, %d, %p)", enum_to_string_GL(target), enum_to_string_GL(format), (int)len, (void*)string)
    glatter_glProgramStringARB(target, format, len, string);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramStringARB_defined
#endif // defined(GL_ARB_fragment_program)
#if defined(GL_ARB_geometry_shader4)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferTextureARB, (target, attachment, texture, level), (GLenum target, GLenum attachment, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureARB_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureARB, "(%s, %s, %u, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level)
    glatter_glFramebufferTextureARB(target, attachment, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferTextureFaceARB, (target, attachment, texture, level, face), (GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureFaceARB_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureFaceARB, "(%s, %s, %u, %d, %s)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level, enum_to_string_GL(face))
    glatter_glFramebufferTextureFaceARB(target, attachment, texture, level, face);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureFaceARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferTextureLayerARB, (target, attachment, texture, level, layer), (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureLayerARB_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureLayerARB, "(%s, %s, %u, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level, (int)layer)
    glatter_glFramebufferTextureLayerARB(target, attachment, texture, level, layer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureLayerARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramParameteriARB, (program, pname, value), (GLuint program, GLenum pname, GLint value))
GLATTER_INLINE_OR_NOT void glatter_glProgramParameteriARB_debug(GLuint program, GLenum pname, GLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramParameteriARB, "(%u, %s, %d)", (unsigned int)program, enum_to_string_GL(pname), (int)value)
    glatter_glProgramParameteriARB(program, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramParameteriARB_defined
#endif // defined(GL_ARB_geometry_shader4)
#if defined(GL_ARB_gl_spirv)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSpecializeShaderARB, (shader, pEntryPoint, numSpecializationConstants, pConstantIndex, pConstantValue), (GLuint shader, const GLchar *pEntryPoint, GLuint numSpecializationConstants, const GLuint *pConstantIndex, const GLuint *pConstantValue))
GLATTER_INLINE_OR_NOT void glatter_glSpecializeShaderARB_debug(GLuint shader, const GLchar *pEntryPoint, GLuint numSpecializationConstants, const GLuint *pConstantIndex, const GLuint *pConstantValue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSpecializeShaderARB, "(%u, %p, %u, %p, %p)", (unsigned int)shader, (void*)pEntryPoint, (unsigned int)numSpecializationConstants, (void*)pConstantIndex, (void*)pConstantValue)
    glatter_glSpecializeShaderARB(shader, pEntryPoint, numSpecializationConstants, pConstantIndex, pConstantValue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSpecializeShaderARB_defined
#endif // defined(GL_ARB_gl_spirv)
#if defined(GL_ARB_gpu_shader_int64)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetUniformi64vARB, (program, location, params), (GLuint program, GLint location, GLint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformi64vARB_debug(GLuint program, GLint location, GLint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformi64vARB, "(%u, %d, %p)", (unsigned int)program, (int)location, (void*)params)
    glatter_glGetUniformi64vARB(program, location, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformi64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetUniformui64vARB, (program, location, params), (GLuint program, GLint location, GLuint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformui64vARB_debug(GLuint program, GLint location, GLuint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformui64vARB, "(%u, %d, %p)", (unsigned int)program, (int)location, (void*)params)
    glatter_glGetUniformui64vARB(program, location, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformui64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnUniformi64vARB, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformi64vARB_debug(GLuint program, GLint location, GLsizei bufSize, GLint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformi64vARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformi64vARB(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformi64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnUniformui64vARB, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLuint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformui64vARB_debug(GLuint program, GLint location, GLsizei bufSize, GLuint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformui64vARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformui64vARB(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformui64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1i64ARB, (program, location, x), (GLuint program, GLint location, GLint64 x))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i64ARB_debug(GLuint program, GLint location, GLint64 x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1i64ARB, "(%u, %d, %" PRId64 ")", (unsigned int)program, (int)location, (int64_t)x)
    glatter_glProgramUniform1i64ARB(program, location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1i64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1i64vARB, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1i64vARB_debug(GLuint program, GLint location, GLsizei count, const GLint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1i64vARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1i64vARB(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1i64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1ui64ARB, (program, location, x), (GLuint program, GLint location, GLuint64 x))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui64ARB_debug(GLuint program, GLint location, GLuint64 x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1ui64ARB, "(%u, %d, %" PRIu64 ")", (unsigned int)program, (int)location, (uint64_t)x)
    glatter_glProgramUniform1ui64ARB(program, location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1ui64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1ui64vARB, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ui64vARB_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1ui64vARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1ui64vARB(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1ui64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2i64ARB, (program, location, x, y), (GLuint program, GLint location, GLint64 x, GLint64 y))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i64ARB_debug(GLuint program, GLint location, GLint64 x, GLint64 y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2i64ARB, "(%u, %d, %" PRId64 ", %" PRId64 ")", (unsigned int)program, (int)location, (int64_t)x, (int64_t)y)
    glatter_glProgramUniform2i64ARB(program, location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2i64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2i64vARB, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2i64vARB_debug(GLuint program, GLint location, GLsizei count, const GLint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2i64vARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2i64vARB(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2i64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2ui64ARB, (program, location, x, y), (GLuint program, GLint location, GLuint64 x, GLuint64 y))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui64ARB_debug(GLuint program, GLint location, GLuint64 x, GLuint64 y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2ui64ARB, "(%u, %d, %" PRIu64 ", %" PRIu64 ")", (unsigned int)program, (int)location, (uint64_t)x, (uint64_t)y)
    glatter_glProgramUniform2ui64ARB(program, location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2ui64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2ui64vARB, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ui64vARB_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2ui64vARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2ui64vARB(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2ui64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3i64ARB, (program, location, x, y, z), (GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i64ARB_debug(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3i64ARB, "(%u, %d, %" PRId64 ", %" PRId64 ", %" PRId64 ")", (unsigned int)program, (int)location, (int64_t)x, (int64_t)y, (int64_t)z)
    glatter_glProgramUniform3i64ARB(program, location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3i64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3i64vARB, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3i64vARB_debug(GLuint program, GLint location, GLsizei count, const GLint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3i64vARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3i64vARB(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3i64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3ui64ARB, (program, location, x, y, z), (GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui64ARB_debug(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3ui64ARB, "(%u, %d, %" PRIu64 ", %" PRIu64 ", %" PRIu64 ")", (unsigned int)program, (int)location, (uint64_t)x, (uint64_t)y, (uint64_t)z)
    glatter_glProgramUniform3ui64ARB(program, location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3ui64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3ui64vARB, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ui64vARB_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3ui64vARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3ui64vARB(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3ui64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4i64ARB, (program, location, x, y, z, w), (GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i64ARB_debug(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4i64ARB, "(%u, %d, %" PRId64 ", %" PRId64 ", %" PRId64 ", %" PRId64 ")", (unsigned int)program, (int)location, (int64_t)x, (int64_t)y, (int64_t)z, (int64_t)w)
    glatter_glProgramUniform4i64ARB(program, location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4i64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4i64vARB, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4i64vARB_debug(GLuint program, GLint location, GLsizei count, const GLint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4i64vARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4i64vARB(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4i64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4ui64ARB, (program, location, x, y, z, w), (GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui64ARB_debug(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4ui64ARB, "(%u, %d, %" PRIu64 ", %" PRIu64 ", %" PRIu64 ", %" PRIu64 ")", (unsigned int)program, (int)location, (uint64_t)x, (uint64_t)y, (uint64_t)z, (uint64_t)w)
    glatter_glProgramUniform4ui64ARB(program, location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4ui64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4ui64vARB, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ui64vARB_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4ui64vARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4ui64vARB(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4ui64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1i64ARB, (location, x), (GLint location, GLint64 x))
GLATTER_INLINE_OR_NOT void glatter_glUniform1i64ARB_debug(GLint location, GLint64 x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1i64ARB, "(%d, %" PRId64 ")", (int)location, (int64_t)x)
    glatter_glUniform1i64ARB(location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1i64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1i64vARB, (location, count, value), (GLint location, GLsizei count, const GLint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1i64vARB_debug(GLint location, GLsizei count, const GLint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1i64vARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1i64vARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1i64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1ui64ARB, (location, x), (GLint location, GLuint64 x))
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui64ARB_debug(GLint location, GLuint64 x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1ui64ARB, "(%d, %" PRIu64 ")", (int)location, (uint64_t)x)
    glatter_glUniform1ui64ARB(location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1ui64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1ui64vARB, (location, count, value), (GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1ui64vARB_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1ui64vARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1ui64vARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1ui64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2i64ARB, (location, x, y), (GLint location, GLint64 x, GLint64 y))
GLATTER_INLINE_OR_NOT void glatter_glUniform2i64ARB_debug(GLint location, GLint64 x, GLint64 y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2i64ARB, "(%d, %" PRId64 ", %" PRId64 ")", (int)location, (int64_t)x, (int64_t)y)
    glatter_glUniform2i64ARB(location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2i64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2i64vARB, (location, count, value), (GLint location, GLsizei count, const GLint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2i64vARB_debug(GLint location, GLsizei count, const GLint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2i64vARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2i64vARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2i64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2ui64ARB, (location, x, y), (GLint location, GLuint64 x, GLuint64 y))
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui64ARB_debug(GLint location, GLuint64 x, GLuint64 y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2ui64ARB, "(%d, %" PRIu64 ", %" PRIu64 ")", (int)location, (uint64_t)x, (uint64_t)y)
    glatter_glUniform2ui64ARB(location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2ui64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2ui64vARB, (location, count, value), (GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2ui64vARB_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2ui64vARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2ui64vARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2ui64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3i64ARB, (location, x, y, z), (GLint location, GLint64 x, GLint64 y, GLint64 z))
GLATTER_INLINE_OR_NOT void glatter_glUniform3i64ARB_debug(GLint location, GLint64 x, GLint64 y, GLint64 z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3i64ARB, "(%d, %" PRId64 ", %" PRId64 ", %" PRId64 ")", (int)location, (int64_t)x, (int64_t)y, (int64_t)z)
    glatter_glUniform3i64ARB(location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3i64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3i64vARB, (location, count, value), (GLint location, GLsizei count, const GLint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3i64vARB_debug(GLint location, GLsizei count, const GLint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3i64vARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3i64vARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3i64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3ui64ARB, (location, x, y, z), (GLint location, GLuint64 x, GLuint64 y, GLuint64 z))
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui64ARB_debug(GLint location, GLuint64 x, GLuint64 y, GLuint64 z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3ui64ARB, "(%d, %" PRIu64 ", %" PRIu64 ", %" PRIu64 ")", (int)location, (uint64_t)x, (uint64_t)y, (uint64_t)z)
    glatter_glUniform3ui64ARB(location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3ui64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3ui64vARB, (location, count, value), (GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3ui64vARB_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3ui64vARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3ui64vARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3ui64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4i64ARB, (location, x, y, z, w), (GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w))
GLATTER_INLINE_OR_NOT void glatter_glUniform4i64ARB_debug(GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4i64ARB, "(%d, %" PRId64 ", %" PRId64 ", %" PRId64 ", %" PRId64 ")", (int)location, (int64_t)x, (int64_t)y, (int64_t)z, (int64_t)w)
    glatter_glUniform4i64ARB(location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4i64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4i64vARB, (location, count, value), (GLint location, GLsizei count, const GLint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4i64vARB_debug(GLint location, GLsizei count, const GLint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4i64vARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4i64vARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4i64vARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4ui64ARB, (location, x, y, z, w), (GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w))
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui64ARB_debug(GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4ui64ARB, "(%d, %" PRIu64 ", %" PRIu64 ", %" PRIu64 ", %" PRIu64 ")", (int)location, (uint64_t)x, (uint64_t)y, (uint64_t)z, (uint64_t)w)
    glatter_glUniform4ui64ARB(location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4ui64ARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4ui64vARB, (location, count, value), (GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4ui64vARB_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4ui64vARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4ui64vARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4ui64vARB_defined
#endif // defined(GL_ARB_gpu_shader_int64)
#if defined(GL_ARB_imaging)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorSubTable, (target, start, count, format, type, data), (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glColorSubTable_debug(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorSubTable, "(%s, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)start, (int)count, enum_to_string_GL(format), enum_to_string_GL(type), (void*)data)
    glatter_glColorSubTable(target, start, count, format, type, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorSubTable_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorTable, (target, internalformat, width, format, type, table), (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *table))
GLATTER_INLINE_OR_NOT void glatter_glColorTable_debug(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *table, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorTable, "(%s, %s, %d, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)width, enum_to_string_GL(format), enum_to_string_GL(type), (void*)table)
    glatter_glColorTable(target, internalformat, width, format, type, table);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorTable_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorTableParameterfv, (target, pname, params), (GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glColorTableParameterfv_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorTableParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glColorTableParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorTableParameterfv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorTableParameteriv, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glColorTableParameteriv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorTableParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glColorTableParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorTableParameteriv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionFilter1D, (target, internalformat, width, format, type, image), (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionFilter1D_debug(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionFilter1D, "(%s, %s, %d, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)width, enum_to_string_GL(format), enum_to_string_GL(type), (void*)image)
    glatter_glConvolutionFilter1D(target, internalformat, width, format, type, image);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionFilter1D_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionFilter2D, (target, internalformat, width, height, format, type, image), (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionFilter2D_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionFilter2D, "(%s, %s, %d, %d, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)image)
    glatter_glConvolutionFilter2D(target, internalformat, width, height, format, type, image);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionFilter2D_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionParameterf, (target, pname, params), (GLenum target, GLenum pname, GLfloat params))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterf_debug(GLenum target, GLenum pname, GLfloat params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionParameterf, "(%s, %s, %f)", enum_to_string_GL(target), enum_to_string_GL(pname), (float)params)
    glatter_glConvolutionParameterf(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionParameterf_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionParameterfv, (target, pname, params), (GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterfv_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glConvolutionParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionParameterfv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionParameteri, (target, pname, params), (GLenum target, GLenum pname, GLint params))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameteri_debug(GLenum target, GLenum pname, GLint params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionParameteri, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)params)
    glatter_glConvolutionParameteri(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionParameteri_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionParameteriv, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameteriv_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glConvolutionParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionParameteriv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyColorSubTable, (target, start, x, y, width), (GLenum target, GLsizei start, GLint x, GLint y, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glCopyColorSubTable_debug(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyColorSubTable, "(%s, %d, %d, %d, %d)", enum_to_string_GL(target), (int)start, (int)x, (int)y, (int)width)
    glatter_glCopyColorSubTable(target, start, x, y, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyColorSubTable_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyColorTable, (target, internalformat, x, y, width), (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glCopyColorTable_debug(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyColorTable, "(%s, %s, %d, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)x, (int)y, (int)width)
    glatter_glCopyColorTable(target, internalformat, x, y, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyColorTable_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyConvolutionFilter1D, (target, internalformat, x, y, width), (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glCopyConvolutionFilter1D_debug(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyConvolutionFilter1D, "(%s, %s, %d, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)x, (int)y, (int)width)
    glatter_glCopyConvolutionFilter1D(target, internalformat, x, y, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyConvolutionFilter1D_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyConvolutionFilter2D, (target, internalformat, x, y, width, height), (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyConvolutionFilter2D_debug(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyConvolutionFilter2D, "(%s, %s, %d, %d, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyConvolutionFilter2D(target, internalformat, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyConvolutionFilter2D_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetColorTable, (target, format, type, table), (GLenum target, GLenum format, GLenum type, void *table))
GLATTER_INLINE_OR_NOT void glatter_glGetColorTable_debug(GLenum target, GLenum format, GLenum type, void *table, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetColorTable, "(%s, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(format), enum_to_string_GL(type), (void*)table)
    glatter_glGetColorTable(target, format, type, table);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetColorTable_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetColorTableParameterfv, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetColorTableParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetColorTableParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetColorTableParameterfv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetColorTableParameteriv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetColorTableParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetColorTableParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetColorTableParameteriv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetConvolutionFilter, (target, format, type, image), (GLenum target, GLenum format, GLenum type, void *image))
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionFilter_debug(GLenum target, GLenum format, GLenum type, void *image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetConvolutionFilter, "(%s, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(format), enum_to_string_GL(type), (void*)image)
    glatter_glGetConvolutionFilter(target, format, type, image);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetConvolutionFilter_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetConvolutionParameterfv, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetConvolutionParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetConvolutionParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetConvolutionParameterfv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetConvolutionParameteriv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetConvolutionParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetConvolutionParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetConvolutionParameteriv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetHistogram, (target, reset, format, type, values), (GLenum target, GLboolean reset, GLenum format, GLenum type, void *values))
GLATTER_INLINE_OR_NOT void glatter_glGetHistogram_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, void *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetHistogram, "(%s, %u, %s, %s, %p)", enum_to_string_GL(target), (unsigned char)reset, enum_to_string_GL(format), enum_to_string_GL(type), (void*)values)
    glatter_glGetHistogram(target, reset, format, type, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetHistogram_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetHistogramParameterfv, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetHistogramParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetHistogramParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetHistogramParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetHistogramParameterfv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetHistogramParameteriv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetHistogramParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetHistogramParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetHistogramParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetHistogramParameteriv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMinmax, (target, reset, format, type, values), (GLenum target, GLboolean reset, GLenum format, GLenum type, void *values))
GLATTER_INLINE_OR_NOT void glatter_glGetMinmax_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, void *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMinmax, "(%s, %u, %s, %s, %p)", enum_to_string_GL(target), (unsigned char)reset, enum_to_string_GL(format), enum_to_string_GL(type), (void*)values)
    glatter_glGetMinmax(target, reset, format, type, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMinmax_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMinmaxParameterfv, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMinmaxParameterfv_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMinmaxParameterfv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMinmaxParameterfv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMinmaxParameterfv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMinmaxParameteriv, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMinmaxParameteriv_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMinmaxParameteriv, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMinmaxParameteriv(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMinmaxParameteriv_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetSeparableFilter, (target, format, type, row, column, span), (GLenum target, GLenum format, GLenum type, void *row, void *column, void *span))
GLATTER_INLINE_OR_NOT void glatter_glGetSeparableFilter_debug(GLenum target, GLenum format, GLenum type, void *row, void *column, void *span, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSeparableFilter, "(%s, %s, %s, %p, %p, %p)", enum_to_string_GL(target), enum_to_string_GL(format), enum_to_string_GL(type), (void*)row, (void*)column, (void*)span)
    glatter_glGetSeparableFilter(target, format, type, row, column, span);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSeparableFilter_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glHistogram, (target, width, internalformat, sink), (GLenum target, GLsizei width, GLenum internalformat, GLboolean sink))
GLATTER_INLINE_OR_NOT void glatter_glHistogram_debug(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glHistogram, "(%s, %d, %s, %u)", enum_to_string_GL(target), (int)width, enum_to_string_GL(internalformat), (unsigned char)sink)
    glatter_glHistogram(target, width, internalformat, sink);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glHistogram_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMinmax, (target, internalformat, sink), (GLenum target, GLenum internalformat, GLboolean sink))
GLATTER_INLINE_OR_NOT void glatter_glMinmax_debug(GLenum target, GLenum internalformat, GLboolean sink, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMinmax, "(%s, %s, %u)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned char)sink)
    glatter_glMinmax(target, internalformat, sink);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMinmax_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glResetHistogram, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glResetHistogram_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glResetHistogram, "(%s)", enum_to_string_GL(target))
    glatter_glResetHistogram(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glResetHistogram_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glResetMinmax, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glResetMinmax_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glResetMinmax, "(%s)", enum_to_string_GL(target))
    glatter_glResetMinmax(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glResetMinmax_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSeparableFilter2D, (target, internalformat, width, height, format, type, row, column), (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column))
GLATTER_INLINE_OR_NOT void glatter_glSeparableFilter2D_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSeparableFilter2D, "(%s, %s, %d, %d, %s, %s, %p, %p)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)row, (void*)column)
    glatter_glSeparableFilter2D(target, internalformat, width, height, format, type, row, column);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSeparableFilter2D_defined
#endif // defined(GL_ARB_imaging)
#if defined(GL_ARB_indirect_parameters)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawArraysIndirectCountARB, (mode, indirect, drawcount, maxdrawcount, stride), (GLenum mode, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysIndirectCountARB_debug(GLenum mode, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawArraysIndirectCountARB, "(%s, %p, %s, %d, %d)", enum_to_string_GL(mode), (void*)indirect, GET_PRS(drawcount), (int)maxdrawcount, (int)stride)
    glatter_glMultiDrawArraysIndirectCountARB(mode, indirect, drawcount, maxdrawcount, stride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawArraysIndirectCountARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawElementsIndirectCountARB, (mode, type, indirect, drawcount, maxdrawcount, stride), (GLenum mode, GLenum type, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsIndirectCountARB_debug(GLenum mode, GLenum type, const void *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawElementsIndirectCountARB, "(%s, %s, %p, %s, %d, %d)", enum_to_string_GL(mode), enum_to_string_GL(type), (void*)indirect, GET_PRS(drawcount), (int)maxdrawcount, (int)stride)
    glatter_glMultiDrawElementsIndirectCountARB(mode, type, indirect, drawcount, maxdrawcount, stride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawElementsIndirectCountARB_defined
#endif // defined(GL_ARB_indirect_parameters)
#if defined(GL_ARB_instanced_arrays)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribDivisorARB, (index, divisor), (GLuint index, GLuint divisor))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribDivisorARB_debug(GLuint index, GLuint divisor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribDivisorARB, "(%u, %u)", (unsigned int)index, (unsigned int)divisor)
    glatter_glVertexAttribDivisorARB(index, divisor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribDivisorARB_defined
#endif // defined(GL_ARB_instanced_arrays)
#if defined(GL_ARB_matrix_palette)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCurrentPaletteMatrixARB, (index), (GLint index))
GLATTER_INLINE_OR_NOT void glatter_glCurrentPaletteMatrixARB_debug(GLint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCurrentPaletteMatrixARB, "(%d)", (int)index)
    glatter_glCurrentPaletteMatrixARB(index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCurrentPaletteMatrixARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixIndexPointerARB, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glMatrixIndexPointerARB_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixIndexPointerARB, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glMatrixIndexPointerARB(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixIndexPointerARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixIndexubvARB, (size, indices), (GLint size, const GLubyte *indices))
GLATTER_INLINE_OR_NOT void glatter_glMatrixIndexubvARB_debug(GLint size, const GLubyte *indices, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixIndexubvARB, "(%d, %p)", (int)size, (void*)indices)
    glatter_glMatrixIndexubvARB(size, indices);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixIndexubvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixIndexuivARB, (size, indices), (GLint size, const GLuint *indices))
GLATTER_INLINE_OR_NOT void glatter_glMatrixIndexuivARB_debug(GLint size, const GLuint *indices, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixIndexuivARB, "(%d, %p)", (int)size, (void*)indices)
    glatter_glMatrixIndexuivARB(size, indices);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixIndexuivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixIndexusvARB, (size, indices), (GLint size, const GLushort *indices))
GLATTER_INLINE_OR_NOT void glatter_glMatrixIndexusvARB_debug(GLint size, const GLushort *indices, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixIndexusvARB, "(%d, %p)", (int)size, (void*)indices)
    glatter_glMatrixIndexusvARB(size, indices);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixIndexusvARB_defined
#endif // defined(GL_ARB_matrix_palette)
#if defined(GL_ARB_multisample)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSampleCoverageARB, (value, invert), (GLfloat value, GLboolean invert))
GLATTER_INLINE_OR_NOT void glatter_glSampleCoverageARB_debug(GLfloat value, GLboolean invert, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSampleCoverageARB, "(%f, %u)", (float)value, (unsigned char)invert)
    glatter_glSampleCoverageARB(value, invert);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSampleCoverageARB_defined
#endif // defined(GL_ARB_multisample)
#if defined(GL_ARB_multitexture)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glActiveTextureARB, (texture), (GLenum texture))
GLATTER_INLINE_OR_NOT void glatter_glActiveTextureARB_debug(GLenum texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glActiveTextureARB, "(%s)", enum_to_string_GL(texture))
    glatter_glActiveTextureARB(texture);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glActiveTextureARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glClientActiveTextureARB, (texture), (GLenum texture))
GLATTER_INLINE_OR_NOT void glatter_glClientActiveTextureARB_debug(GLenum texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClientActiveTextureARB, "(%s)", enum_to_string_GL(texture))
    glatter_glClientActiveTextureARB(texture);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClientActiveTextureARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord1dARB, (target, s), (GLenum target, GLdouble s))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1dARB_debug(GLenum target, GLdouble s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord1dARB, "(%s, %f)", enum_to_string_GL(target), (double)s)
    glatter_glMultiTexCoord1dARB(target, s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord1dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord1dvARB, (target, v), (GLenum target, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1dvARB_debug(GLenum target, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord1dvARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord1dvARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord1dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord1fARB, (target, s), (GLenum target, GLfloat s))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1fARB_debug(GLenum target, GLfloat s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord1fARB, "(%s, %f)", enum_to_string_GL(target), (float)s)
    glatter_glMultiTexCoord1fARB(target, s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord1fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord1fvARB, (target, v), (GLenum target, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1fvARB_debug(GLenum target, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord1fvARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord1fvARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord1fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord1iARB, (target, s), (GLenum target, GLint s))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1iARB_debug(GLenum target, GLint s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord1iARB, "(%s, %d)", enum_to_string_GL(target), (int)s)
    glatter_glMultiTexCoord1iARB(target, s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord1iARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord1ivARB, (target, v), (GLenum target, const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1ivARB_debug(GLenum target, const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord1ivARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord1ivARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord1ivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord1sARB, (target, s), (GLenum target, GLshort s))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1sARB_debug(GLenum target, GLshort s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord1sARB, "(%s, %hi)", enum_to_string_GL(target), (short)s)
    glatter_glMultiTexCoord1sARB(target, s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord1sARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord1svARB, (target, v), (GLenum target, const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1svARB_debug(GLenum target, const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord1svARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord1svARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord1svARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord2dARB, (target, s, t), (GLenum target, GLdouble s, GLdouble t))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2dARB_debug(GLenum target, GLdouble s, GLdouble t, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord2dARB, "(%s, %f, %f)", enum_to_string_GL(target), (double)s, (double)t)
    glatter_glMultiTexCoord2dARB(target, s, t);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord2dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord2dvARB, (target, v), (GLenum target, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2dvARB_debug(GLenum target, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord2dvARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord2dvARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord2dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord2fARB, (target, s, t), (GLenum target, GLfloat s, GLfloat t))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2fARB_debug(GLenum target, GLfloat s, GLfloat t, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord2fARB, "(%s, %f, %f)", enum_to_string_GL(target), (float)s, (float)t)
    glatter_glMultiTexCoord2fARB(target, s, t);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord2fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord2fvARB, (target, v), (GLenum target, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2fvARB_debug(GLenum target, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord2fvARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord2fvARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord2fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord2iARB, (target, s, t), (GLenum target, GLint s, GLint t))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2iARB_debug(GLenum target, GLint s, GLint t, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord2iARB, "(%s, %d, %d)", enum_to_string_GL(target), (int)s, (int)t)
    glatter_glMultiTexCoord2iARB(target, s, t);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord2iARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord2ivARB, (target, v), (GLenum target, const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2ivARB_debug(GLenum target, const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord2ivARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord2ivARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord2ivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord2sARB, (target, s, t), (GLenum target, GLshort s, GLshort t))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2sARB_debug(GLenum target, GLshort s, GLshort t, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord2sARB, "(%s, %hi, %hi)", enum_to_string_GL(target), (short)s, (short)t)
    glatter_glMultiTexCoord2sARB(target, s, t);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord2sARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord2svARB, (target, v), (GLenum target, const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2svARB_debug(GLenum target, const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord2svARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord2svARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord2svARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord3dARB, (target, s, t, r), (GLenum target, GLdouble s, GLdouble t, GLdouble r))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3dARB_debug(GLenum target, GLdouble s, GLdouble t, GLdouble r, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord3dARB, "(%s, %f, %f, %f)", enum_to_string_GL(target), (double)s, (double)t, (double)r)
    glatter_glMultiTexCoord3dARB(target, s, t, r);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord3dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord3dvARB, (target, v), (GLenum target, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3dvARB_debug(GLenum target, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord3dvARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord3dvARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord3dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord3fARB, (target, s, t, r), (GLenum target, GLfloat s, GLfloat t, GLfloat r))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3fARB_debug(GLenum target, GLfloat s, GLfloat t, GLfloat r, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord3fARB, "(%s, %f, %f, %f)", enum_to_string_GL(target), (float)s, (float)t, (float)r)
    glatter_glMultiTexCoord3fARB(target, s, t, r);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord3fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord3fvARB, (target, v), (GLenum target, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3fvARB_debug(GLenum target, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord3fvARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord3fvARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord3fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord3iARB, (target, s, t, r), (GLenum target, GLint s, GLint t, GLint r))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3iARB_debug(GLenum target, GLint s, GLint t, GLint r, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord3iARB, "(%s, %d, %d, %d)", enum_to_string_GL(target), (int)s, (int)t, (int)r)
    glatter_glMultiTexCoord3iARB(target, s, t, r);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord3iARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord3ivARB, (target, v), (GLenum target, const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3ivARB_debug(GLenum target, const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord3ivARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord3ivARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord3ivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord3sARB, (target, s, t, r), (GLenum target, GLshort s, GLshort t, GLshort r))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3sARB_debug(GLenum target, GLshort s, GLshort t, GLshort r, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord3sARB, "(%s, %hi, %hi, %hi)", enum_to_string_GL(target), (short)s, (short)t, (short)r)
    glatter_glMultiTexCoord3sARB(target, s, t, r);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord3sARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord3svARB, (target, v), (GLenum target, const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3svARB_debug(GLenum target, const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord3svARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord3svARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord3svARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord4dARB, (target, s, t, r, q), (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4dARB_debug(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4dARB, "(%s, %f, %f, %f, %f)", enum_to_string_GL(target), (double)s, (double)t, (double)r, (double)q)
    glatter_glMultiTexCoord4dARB(target, s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord4dvARB, (target, v), (GLenum target, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4dvARB_debug(GLenum target, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4dvARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord4dvARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord4fARB, (target, s, t, r, q), (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4fARB_debug(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4fARB, "(%s, %f, %f, %f, %f)", enum_to_string_GL(target), (float)s, (float)t, (float)r, (float)q)
    glatter_glMultiTexCoord4fARB(target, s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord4fvARB, (target, v), (GLenum target, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4fvARB_debug(GLenum target, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4fvARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord4fvARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord4iARB, (target, s, t, r, q), (GLenum target, GLint s, GLint t, GLint r, GLint q))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4iARB_debug(GLenum target, GLint s, GLint t, GLint r, GLint q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4iARB, "(%s, %d, %d, %d, %d)", enum_to_string_GL(target), (int)s, (int)t, (int)r, (int)q)
    glatter_glMultiTexCoord4iARB(target, s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4iARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord4ivARB, (target, v), (GLenum target, const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4ivARB_debug(GLenum target, const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4ivARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord4ivARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4ivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord4sARB, (target, s, t, r, q), (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4sARB_debug(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4sARB, "(%s, %hi, %hi, %hi, %hi)", enum_to_string_GL(target), (short)s, (short)t, (short)r, (short)q)
    glatter_glMultiTexCoord4sARB(target, s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4sARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord4svARB, (target, v), (GLenum target, const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4svARB_debug(GLenum target, const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4svARB, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord4svARB(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4svARB_defined
#endif // defined(GL_ARB_multitexture)
#if defined(GL_ARB_occlusion_query)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBeginQueryARB, (target, id), (GLenum target, GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glBeginQueryARB_debug(GLenum target, GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginQueryARB, "(%s, %u)", enum_to_string_GL(target), (unsigned int)id)
    glatter_glBeginQueryARB(target, id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginQueryARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteQueriesARB, (n, ids), (GLsizei n, const GLuint *ids))
GLATTER_INLINE_OR_NOT void glatter_glDeleteQueriesARB_debug(GLsizei n, const GLuint *ids, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteQueriesARB, "(%d, %p)", (int)n, (void*)ids)
    glatter_glDeleteQueriesARB(n, ids);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteQueriesARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEndQueryARB, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glEndQueryARB_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndQueryARB, "(%s)", enum_to_string_GL(target))
    glatter_glEndQueryARB(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndQueryARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenQueriesARB, (n, ids), (GLsizei n, GLuint *ids))
GLATTER_INLINE_OR_NOT void glatter_glGenQueriesARB_debug(GLsizei n, GLuint *ids, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenQueriesARB, "(%d, %p)", (int)n, (void*)ids)
    glatter_glGenQueriesARB(n, ids);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenQueriesARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetQueryObjectivARB, (id, pname, params), (GLuint id, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectivARB_debug(GLuint id, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryObjectivARB, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryObjectivARB(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryObjectivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetQueryObjectuivARB, (id, pname, params), (GLuint id, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectuivARB_debug(GLuint id, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryObjectuivARB, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryObjectuivARB(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryObjectuivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetQueryivARB, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryivARB_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryivARB, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryivARB(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryivARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsQueryARB, (id), (GLuint id))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsQueryARB_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsQueryARB, "(%u)", (unsigned int)id)
    GLboolean rval = glatter_glIsQueryARB(id);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsQueryARB_defined
#endif // defined(GL_ARB_occlusion_query)
#if defined(GL_ARB_parallel_shader_compile)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMaxShaderCompilerThreadsARB, (count), (GLuint count))
GLATTER_INLINE_OR_NOT void glatter_glMaxShaderCompilerThreadsARB_debug(GLuint count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaxShaderCompilerThreadsARB, "(%u)", (unsigned int)count)
    glatter_glMaxShaderCompilerThreadsARB(count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaxShaderCompilerThreadsARB_defined
#endif // defined(GL_ARB_parallel_shader_compile)
#if defined(GL_ARB_point_parameters)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPointParameterfARB, (pname, param), (GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfARB_debug(GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameterfARB, "(%s, %f)", enum_to_string_GL(pname), (float)param)
    glatter_glPointParameterfARB(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameterfARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPointParameterfvARB, (pname, params), (GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfvARB_debug(GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameterfvARB, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glPointParameterfvARB(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameterfvARB_defined
#endif // defined(GL_ARB_point_parameters)
#if defined(GL_ARB_robustness)
GLATTER_FBLOCK(return, GL, GLAPI, GLenum, APIENTRY, glGetGraphicsResetStatusARB, (), (void))
GLATTER_INLINE_OR_NOT GLenum glatter_glGetGraphicsResetStatusARB_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetGraphicsResetStatusARB, "()")
    GLenum rval = glatter_glGetGraphicsResetStatusARB();
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetGraphicsResetStatusARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnColorTableARB, (target, format, type, bufSize, table), (GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table))
GLATTER_INLINE_OR_NOT void glatter_glGetnColorTableARB_debug(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *table, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnColorTableARB, "(%s, %s, %s, %d, %p)", enum_to_string_GL(target), enum_to_string_GL(format), enum_to_string_GL(type), (int)bufSize, (void*)table)
    glatter_glGetnColorTableARB(target, format, type, bufSize, table);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnColorTableARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnCompressedTexImageARB, (target, lod, bufSize, img), (GLenum target, GLint lod, GLsizei bufSize, void *img))
GLATTER_INLINE_OR_NOT void glatter_glGetnCompressedTexImageARB_debug(GLenum target, GLint lod, GLsizei bufSize, void *img, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnCompressedTexImageARB, "(%s, %d, %d, %p)", enum_to_string_GL(target), (int)lod, (int)bufSize, (void*)img)
    glatter_glGetnCompressedTexImageARB(target, lod, bufSize, img);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnCompressedTexImageARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnConvolutionFilterARB, (target, format, type, bufSize, image), (GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image))
GLATTER_INLINE_OR_NOT void glatter_glGetnConvolutionFilterARB_debug(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void *image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnConvolutionFilterARB, "(%s, %s, %s, %d, %p)", enum_to_string_GL(target), enum_to_string_GL(format), enum_to_string_GL(type), (int)bufSize, (void*)image)
    glatter_glGetnConvolutionFilterARB(target, format, type, bufSize, image);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnConvolutionFilterARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnHistogramARB, (target, reset, format, type, bufSize, values), (GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void *values))
GLATTER_INLINE_OR_NOT void glatter_glGetnHistogramARB_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnHistogramARB, "(%s, %u, %s, %s, %d, %p)", enum_to_string_GL(target), (unsigned char)reset, enum_to_string_GL(format), enum_to_string_GL(type), (int)bufSize, (void*)values)
    glatter_glGetnHistogramARB(target, reset, format, type, bufSize, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnHistogramARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnMapdvARB, (target, query, bufSize, v), (GLenum target, GLenum query, GLsizei bufSize, GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glGetnMapdvARB_debug(GLenum target, GLenum query, GLsizei bufSize, GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnMapdvARB, "(%s, %s, %d, %p)", enum_to_string_GL(target), enum_to_string_GL(query), (int)bufSize, (void*)v)
    glatter_glGetnMapdvARB(target, query, bufSize, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnMapdvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnMapfvARB, (target, query, bufSize, v), (GLenum target, GLenum query, GLsizei bufSize, GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glGetnMapfvARB_debug(GLenum target, GLenum query, GLsizei bufSize, GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnMapfvARB, "(%s, %s, %d, %p)", enum_to_string_GL(target), enum_to_string_GL(query), (int)bufSize, (void*)v)
    glatter_glGetnMapfvARB(target, query, bufSize, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnMapfvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnMapivARB, (target, query, bufSize, v), (GLenum target, GLenum query, GLsizei bufSize, GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glGetnMapivARB_debug(GLenum target, GLenum query, GLsizei bufSize, GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnMapivARB, "(%s, %s, %d, %p)", enum_to_string_GL(target), enum_to_string_GL(query), (int)bufSize, (void*)v)
    glatter_glGetnMapivARB(target, query, bufSize, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnMapivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnMinmaxARB, (target, reset, format, type, bufSize, values), (GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void *values))
GLATTER_INLINE_OR_NOT void glatter_glGetnMinmaxARB_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnMinmaxARB, "(%s, %u, %s, %s, %d, %p)", enum_to_string_GL(target), (unsigned char)reset, enum_to_string_GL(format), enum_to_string_GL(type), (int)bufSize, (void*)values)
    glatter_glGetnMinmaxARB(target, reset, format, type, bufSize, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnMinmaxARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnPixelMapfvARB, (map, bufSize, values), (GLenum map, GLsizei bufSize, GLfloat *values))
GLATTER_INLINE_OR_NOT void glatter_glGetnPixelMapfvARB_debug(GLenum map, GLsizei bufSize, GLfloat *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnPixelMapfvARB, "(%s, %d, %p)", enum_to_string_GL(map), (int)bufSize, (void*)values)
    glatter_glGetnPixelMapfvARB(map, bufSize, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnPixelMapfvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnPixelMapuivARB, (map, bufSize, values), (GLenum map, GLsizei bufSize, GLuint *values))
GLATTER_INLINE_OR_NOT void glatter_glGetnPixelMapuivARB_debug(GLenum map, GLsizei bufSize, GLuint *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnPixelMapuivARB, "(%s, %d, %p)", enum_to_string_GL(map), (int)bufSize, (void*)values)
    glatter_glGetnPixelMapuivARB(map, bufSize, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnPixelMapuivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnPixelMapusvARB, (map, bufSize, values), (GLenum map, GLsizei bufSize, GLushort *values))
GLATTER_INLINE_OR_NOT void glatter_glGetnPixelMapusvARB_debug(GLenum map, GLsizei bufSize, GLushort *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnPixelMapusvARB, "(%s, %d, %p)", enum_to_string_GL(map), (int)bufSize, (void*)values)
    glatter_glGetnPixelMapusvARB(map, bufSize, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnPixelMapusvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnPolygonStippleARB, (bufSize, pattern), (GLsizei bufSize, GLubyte *pattern))
GLATTER_INLINE_OR_NOT void glatter_glGetnPolygonStippleARB_debug(GLsizei bufSize, GLubyte *pattern, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnPolygonStippleARB, "(%d, %p)", (int)bufSize, (void*)pattern)
    glatter_glGetnPolygonStippleARB(bufSize, pattern);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnPolygonStippleARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnSeparableFilterARB, (target, format, type, rowBufSize, row, columnBufSize, column, span), (GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void *row, GLsizei columnBufSize, void *column, void *span))
GLATTER_INLINE_OR_NOT void glatter_glGetnSeparableFilterARB_debug(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void *row, GLsizei columnBufSize, void *column, void *span, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnSeparableFilterARB, "(%s, %s, %s, %d, %p, %d, %p, %p)", enum_to_string_GL(target), enum_to_string_GL(format), enum_to_string_GL(type), (int)rowBufSize, (void*)row, (int)columnBufSize, (void*)column, (void*)span)
    glatter_glGetnSeparableFilterARB(target, format, type, rowBufSize, row, columnBufSize, column, span);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnSeparableFilterARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnTexImageARB, (target, level, format, type, bufSize, img), (GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *img))
GLATTER_INLINE_OR_NOT void glatter_glGetnTexImageARB_debug(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void *img, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnTexImageARB, "(%s, %d, %s, %s, %d, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(format), enum_to_string_GL(type), (int)bufSize, (void*)img)
    glatter_glGetnTexImageARB(target, level, format, type, bufSize, img);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnTexImageARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnUniformdvARB, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformdvARB_debug(GLuint program, GLint location, GLsizei bufSize, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformdvARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformdvARB(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformdvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnUniformfvARB, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformfvARB_debug(GLuint program, GLint location, GLsizei bufSize, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformfvARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformfvARB(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformfvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnUniformivARB, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformivARB_debug(GLuint program, GLint location, GLsizei bufSize, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformivARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformivARB(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetnUniformuivARB, (program, location, bufSize, params), (GLuint program, GLint location, GLsizei bufSize, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetnUniformuivARB_debug(GLuint program, GLint location, GLsizei bufSize, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetnUniformuivARB, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)bufSize, (void*)params)
    glatter_glGetnUniformuivARB(program, location, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetnUniformuivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glReadnPixelsARB, (x, y, width, height, format, type, bufSize, data), (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data))
GLATTER_INLINE_OR_NOT void glatter_glReadnPixelsARB_debug(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReadnPixelsARB, "(%d, %d, %d, %d, %s, %s, %d, %p)", (int)x, (int)y, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (int)bufSize, (void*)data)
    glatter_glReadnPixelsARB(x, y, width, height, format, type, bufSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glReadnPixelsARB_defined
#endif // defined(GL_ARB_robustness)
#if defined(GL_ARB_sample_locations)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEvaluateDepthValuesARB, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glEvaluateDepthValuesARB_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvaluateDepthValuesARB, "()")
    glatter_glEvaluateDepthValuesARB();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvaluateDepthValuesARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferSampleLocationsfvARB, (target, start, count, v), (GLenum target, GLuint start, GLsizei count, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferSampleLocationsfvARB_debug(GLenum target, GLuint start, GLsizei count, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferSampleLocationsfvARB, "(%s, %u, %d, %p)", enum_to_string_GL(target), (unsigned int)start, (int)count, (void*)v)
    glatter_glFramebufferSampleLocationsfvARB(target, start, count, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferSampleLocationsfvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedFramebufferSampleLocationsfvARB, (framebuffer, start, count, v), (GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferSampleLocationsfvARB_debug(GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedFramebufferSampleLocationsfvARB, "(%u, %u, %d, %p)", (unsigned int)framebuffer, (unsigned int)start, (int)count, (void*)v)
    glatter_glNamedFramebufferSampleLocationsfvARB(framebuffer, start, count, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedFramebufferSampleLocationsfvARB_defined
#endif // defined(GL_ARB_sample_locations)
#if defined(GL_ARB_sample_shading)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMinSampleShadingARB, (value), (GLfloat value))
GLATTER_INLINE_OR_NOT void glatter_glMinSampleShadingARB_debug(GLfloat value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMinSampleShadingARB, "(%f)", (float)value)
    glatter_glMinSampleShadingARB(value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMinSampleShadingARB_defined
#endif // defined(GL_ARB_sample_shading)
#if defined(GL_ARB_shader_objects)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glAttachObjectARB, (containerObj, obj), (GLhandleARB containerObj, GLhandleARB obj))
GLATTER_INLINE_OR_NOT void glatter_glAttachObjectARB_debug(GLhandleARB containerObj, GLhandleARB obj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAttachObjectARB, "(%u, %u)", (unsigned int)containerObj, (unsigned int)obj)
    glatter_glAttachObjectARB(containerObj, obj);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAttachObjectARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompileShaderARB, (shaderObj), (GLhandleARB shaderObj))
GLATTER_INLINE_OR_NOT void glatter_glCompileShaderARB_debug(GLhandleARB shaderObj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompileShaderARB, "(%u)", (unsigned int)shaderObj)
    glatter_glCompileShaderARB(shaderObj);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompileShaderARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLhandleARB, APIENTRY, glCreateProgramObjectARB, (), (void))
GLATTER_INLINE_OR_NOT GLhandleARB glatter_glCreateProgramObjectARB_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateProgramObjectARB, "()")
    GLhandleARB rval = glatter_glCreateProgramObjectARB();
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCreateProgramObjectARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLhandleARB, APIENTRY, glCreateShaderObjectARB, (shaderType), (GLenum shaderType))
GLATTER_INLINE_OR_NOT GLhandleARB glatter_glCreateShaderObjectARB_debug(GLenum shaderType, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateShaderObjectARB, "(%s)", enum_to_string_GL(shaderType))
    GLhandleARB rval = glatter_glCreateShaderObjectARB(shaderType);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCreateShaderObjectARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteObjectARB, (obj), (GLhandleARB obj))
GLATTER_INLINE_OR_NOT void glatter_glDeleteObjectARB_debug(GLhandleARB obj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteObjectARB, "(%u)", (unsigned int)obj)
    glatter_glDeleteObjectARB(obj);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteObjectARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDetachObjectARB, (containerObj, attachedObj), (GLhandleARB containerObj, GLhandleARB attachedObj))
GLATTER_INLINE_OR_NOT void glatter_glDetachObjectARB_debug(GLhandleARB containerObj, GLhandleARB attachedObj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDetachObjectARB, "(%u, %u)", (unsigned int)containerObj, (unsigned int)attachedObj)
    glatter_glDetachObjectARB(containerObj, attachedObj);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDetachObjectARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetActiveUniformARB, (programObj, index, maxLength, length, size, type, name), (GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name))
GLATTER_INLINE_OR_NOT void glatter_glGetActiveUniformARB_debug(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetActiveUniformARB, "(%u, %u, %d, %p, %p, %p, %p)", (unsigned int)programObj, (unsigned int)index, (int)maxLength, (void*)length, (void*)size, (void*)type, (void*)name)
    glatter_glGetActiveUniformARB(programObj, index, maxLength, length, size, type, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetActiveUniformARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetAttachedObjectsARB, (containerObj, maxCount, count, obj), (GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj))
GLATTER_INLINE_OR_NOT void glatter_glGetAttachedObjectsARB_debug(GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetAttachedObjectsARB, "(%u, %d, %p, %p)", (unsigned int)containerObj, (int)maxCount, (void*)count, (void*)obj)
    glatter_glGetAttachedObjectsARB(containerObj, maxCount, count, obj);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetAttachedObjectsARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLhandleARB, APIENTRY, glGetHandleARB, (pname), (GLenum pname))
GLATTER_INLINE_OR_NOT GLhandleARB glatter_glGetHandleARB_debug(GLenum pname, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetHandleARB, "(%s)", enum_to_string_GL(pname))
    GLhandleARB rval = glatter_glGetHandleARB(pname);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetHandleARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetInfoLogARB, (obj, maxLength, length, infoLog), (GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog))
GLATTER_INLINE_OR_NOT void glatter_glGetInfoLogARB_debug(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetInfoLogARB, "(%u, %d, %p, %p)", (unsigned int)obj, (int)maxLength, (void*)length, (void*)infoLog)
    glatter_glGetInfoLogARB(obj, maxLength, length, infoLog);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetInfoLogARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetObjectParameterfvARB, (obj, pname, params), (GLhandleARB obj, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetObjectParameterfvARB_debug(GLhandleARB obj, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetObjectParameterfvARB, "(%u, %s, %p)", (unsigned int)obj, enum_to_string_GL(pname), (void*)params)
    glatter_glGetObjectParameterfvARB(obj, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetObjectParameterfvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetObjectParameterivARB, (obj, pname, params), (GLhandleARB obj, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetObjectParameterivARB_debug(GLhandleARB obj, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetObjectParameterivARB, "(%u, %s, %p)", (unsigned int)obj, enum_to_string_GL(pname), (void*)params)
    glatter_glGetObjectParameterivARB(obj, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetObjectParameterivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetShaderSourceARB, (obj, maxLength, length, source), (GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source))
GLATTER_INLINE_OR_NOT void glatter_glGetShaderSourceARB_debug(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetShaderSourceARB, "(%u, %d, %p, %p)", (unsigned int)obj, (int)maxLength, (void*)length, (void*)source)
    glatter_glGetShaderSourceARB(obj, maxLength, length, source);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetShaderSourceARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLint, APIENTRY, glGetUniformLocationARB, (programObj, name), (GLhandleARB programObj, const GLcharARB *name))
GLATTER_INLINE_OR_NOT GLint glatter_glGetUniformLocationARB_debug(GLhandleARB programObj, const GLcharARB *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformLocationARB, "(%u, %p)", (unsigned int)programObj, (void*)name)
    GLint rval = glatter_glGetUniformLocationARB(programObj, name);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetUniformLocationARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetUniformfvARB, (programObj, location, params), (GLhandleARB programObj, GLint location, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformfvARB_debug(GLhandleARB programObj, GLint location, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformfvARB, "(%u, %d, %p)", (unsigned int)programObj, (int)location, (void*)params)
    glatter_glGetUniformfvARB(programObj, location, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformfvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetUniformivARB, (programObj, location, params), (GLhandleARB programObj, GLint location, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformivARB_debug(GLhandleARB programObj, GLint location, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformivARB, "(%u, %d, %p)", (unsigned int)programObj, (int)location, (void*)params)
    glatter_glGetUniformivARB(programObj, location, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glLinkProgramARB, (programObj), (GLhandleARB programObj))
GLATTER_INLINE_OR_NOT void glatter_glLinkProgramARB_debug(GLhandleARB programObj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLinkProgramARB, "(%u)", (unsigned int)programObj)
    glatter_glLinkProgramARB(programObj);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLinkProgramARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glShaderSourceARB, (shaderObj, count, string, length), (GLhandleARB shaderObj, GLsizei count, const GLcharARB **string, const GLint *length))
GLATTER_INLINE_OR_NOT void glatter_glShaderSourceARB_debug(GLhandleARB shaderObj, GLsizei count, const GLcharARB **string, const GLint *length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glShaderSourceARB, "(%u, %d, %p, %p)", (unsigned int)shaderObj, (int)count, (void*)string, (void*)length)
    glatter_glShaderSourceARB(shaderObj, count, string, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glShaderSourceARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1fARB, (location, v0), (GLint location, GLfloat v0))
GLATTER_INLINE_OR_NOT void glatter_glUniform1fARB_debug(GLint location, GLfloat v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1fARB, "(%d, %f)", (int)location, (float)v0)
    glatter_glUniform1fARB(location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1fvARB, (location, count, value), (GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1fvARB_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1fvARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1fvARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1iARB, (location, v0), (GLint location, GLint v0))
GLATTER_INLINE_OR_NOT void glatter_glUniform1iARB_debug(GLint location, GLint v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1iARB, "(%d, %d)", (int)location, (int)v0)
    glatter_glUniform1iARB(location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1iARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1ivARB, (location, count, value), (GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1ivARB_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1ivARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1ivARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1ivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2fARB, (location, v0, v1), (GLint location, GLfloat v0, GLfloat v1))
GLATTER_INLINE_OR_NOT void glatter_glUniform2fARB_debug(GLint location, GLfloat v0, GLfloat v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2fARB, "(%d, %f, %f)", (int)location, (float)v0, (float)v1)
    glatter_glUniform2fARB(location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2fvARB, (location, count, value), (GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2fvARB_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2fvARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2fvARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2iARB, (location, v0, v1), (GLint location, GLint v0, GLint v1))
GLATTER_INLINE_OR_NOT void glatter_glUniform2iARB_debug(GLint location, GLint v0, GLint v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2iARB, "(%d, %d, %d)", (int)location, (int)v0, (int)v1)
    glatter_glUniform2iARB(location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2iARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2ivARB, (location, count, value), (GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2ivARB_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2ivARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2ivARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2ivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3fARB, (location, v0, v1, v2), (GLint location, GLfloat v0, GLfloat v1, GLfloat v2))
GLATTER_INLINE_OR_NOT void glatter_glUniform3fARB_debug(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3fARB, "(%d, %f, %f, %f)", (int)location, (float)v0, (float)v1, (float)v2)
    glatter_glUniform3fARB(location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3fvARB, (location, count, value), (GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3fvARB_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3fvARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3fvARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3iARB, (location, v0, v1, v2), (GLint location, GLint v0, GLint v1, GLint v2))
GLATTER_INLINE_OR_NOT void glatter_glUniform3iARB_debug(GLint location, GLint v0, GLint v1, GLint v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3iARB, "(%d, %d, %d, %d)", (int)location, (int)v0, (int)v1, (int)v2)
    glatter_glUniform3iARB(location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3iARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3ivARB, (location, count, value), (GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3ivARB_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3ivARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3ivARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3ivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4fARB, (location, v0, v1, v2, v3), (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3))
GLATTER_INLINE_OR_NOT void glatter_glUniform4fARB_debug(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4fARB, "(%d, %f, %f, %f, %f)", (int)location, (float)v0, (float)v1, (float)v2, (float)v3)
    glatter_glUniform4fARB(location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4fvARB, (location, count, value), (GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4fvARB_debug(GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4fvARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4fvARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4iARB, (location, v0, v1, v2, v3), (GLint location, GLint v0, GLint v1, GLint v2, GLint v3))
GLATTER_INLINE_OR_NOT void glatter_glUniform4iARB_debug(GLint location, GLint v0, GLint v1, GLint v2, GLint v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4iARB, "(%d, %d, %d, %d, %d)", (int)location, (int)v0, (int)v1, (int)v2, (int)v3)
    glatter_glUniform4iARB(location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4iARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4ivARB, (location, count, value), (GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4ivARB_debug(GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4ivARB, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4ivARB(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4ivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniformMatrix2fvARB, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix2fvARB_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix2fvARB, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix2fvARB(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix2fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniformMatrix3fvARB, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix3fvARB_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix3fvARB, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix3fvARB(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix3fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniformMatrix4fvARB, (location, count, transpose, value), (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformMatrix4fvARB_debug(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformMatrix4fvARB, "(%d, %d, %u, %p)", (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glUniformMatrix4fvARB(location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformMatrix4fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUseProgramObjectARB, (programObj), (GLhandleARB programObj))
GLATTER_INLINE_OR_NOT void glatter_glUseProgramObjectARB_debug(GLhandleARB programObj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUseProgramObjectARB, "(%u)", (unsigned int)programObj)
    glatter_glUseProgramObjectARB(programObj);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUseProgramObjectARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glValidateProgramARB, (programObj), (GLhandleARB programObj))
GLATTER_INLINE_OR_NOT void glatter_glValidateProgramARB_debug(GLhandleARB programObj, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glValidateProgramARB, "(%u)", (unsigned int)programObj)
    glatter_glValidateProgramARB(programObj);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glValidateProgramARB_defined
#endif // defined(GL_ARB_shader_objects)
#if defined(GL_ARB_shading_language_include)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompileShaderIncludeARB, (shader, count, path, length), (GLuint shader, GLsizei count, const GLchar *const*path, const GLint *length))
GLATTER_INLINE_OR_NOT void glatter_glCompileShaderIncludeARB_debug(GLuint shader, GLsizei count, const GLchar *const*path, const GLint *length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompileShaderIncludeARB, "(%u, %d, %p, %p)", (unsigned int)shader, (int)count, (void*)path, (void*)length)
    glatter_glCompileShaderIncludeARB(shader, count, path, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompileShaderIncludeARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteNamedStringARB, (namelen, name), (GLint namelen, const GLchar *name))
GLATTER_INLINE_OR_NOT void glatter_glDeleteNamedStringARB_debug(GLint namelen, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteNamedStringARB, "(%d, %p)", (int)namelen, (void*)name)
    glatter_glDeleteNamedStringARB(namelen, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteNamedStringARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedStringARB, (namelen, name, bufSize, stringlen, string), (GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedStringARB_debug(GLint namelen, const GLchar *name, GLsizei bufSize, GLint *stringlen, GLchar *string, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedStringARB, "(%d, %p, %d, %p, %p)", (int)namelen, (void*)name, (int)bufSize, (void*)stringlen, (void*)string)
    glatter_glGetNamedStringARB(namelen, name, bufSize, stringlen, string);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedStringARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedStringivARB, (namelen, name, pname, params), (GLint namelen, const GLchar *name, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedStringivARB_debug(GLint namelen, const GLchar *name, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedStringivARB, "(%d, %p, %s, %p)", (int)namelen, (void*)name, enum_to_string_GL(pname), (void*)params)
    glatter_glGetNamedStringivARB(namelen, name, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedStringivARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsNamedStringARB, (namelen, name), (GLint namelen, const GLchar *name))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsNamedStringARB_debug(GLint namelen, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsNamedStringARB, "(%d, %p)", (int)namelen, (void*)name)
    GLboolean rval = glatter_glIsNamedStringARB(namelen, name);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsNamedStringARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedStringARB, (type, namelen, name, stringlen, string), (GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string))
GLATTER_INLINE_OR_NOT void glatter_glNamedStringARB_debug(GLenum type, GLint namelen, const GLchar *name, GLint stringlen, const GLchar *string, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedStringARB, "(%s, %d, %p, %d, %p)", enum_to_string_GL(type), (int)namelen, (void*)name, (int)stringlen, (void*)string)
    glatter_glNamedStringARB(type, namelen, name, stringlen, string);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedStringARB_defined
#endif // defined(GL_ARB_shading_language_include)
#if defined(GL_ARB_sparse_buffer)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBufferPageCommitmentARB, (target, offset, size, commit), (GLenum target, GLintptr offset, GLsizeiptr size, GLboolean commit))
GLATTER_INLINE_OR_NOT void glatter_glBufferPageCommitmentARB_debug(GLenum target, GLintptr offset, GLsizeiptr size, GLboolean commit, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferPageCommitmentARB, "(%s, %s, %s, %u)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(size), (unsigned char)commit)
    glatter_glBufferPageCommitmentARB(target, offset, size, commit);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferPageCommitmentARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedBufferPageCommitmentARB, (buffer, offset, size, commit), (GLuint buffer, GLintptr offset, GLsizeiptr size, GLboolean commit))
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferPageCommitmentARB_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, GLboolean commit, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedBufferPageCommitmentARB, "(%u, %s, %s, %u)", (unsigned int)buffer, GET_PRS(offset), GET_PRS(size), (unsigned char)commit)
    glatter_glNamedBufferPageCommitmentARB(buffer, offset, size, commit);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedBufferPageCommitmentARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedBufferPageCommitmentEXT, (buffer, offset, size, commit), (GLuint buffer, GLintptr offset, GLsizeiptr size, GLboolean commit))
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferPageCommitmentEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, GLboolean commit, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedBufferPageCommitmentEXT, "(%u, %s, %s, %u)", (unsigned int)buffer, GET_PRS(offset), GET_PRS(size), (unsigned char)commit)
    glatter_glNamedBufferPageCommitmentEXT(buffer, offset, size, commit);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedBufferPageCommitmentEXT_defined
#endif // defined(GL_ARB_sparse_buffer)
#if defined(GL_ARB_sparse_texture)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexPageCommitmentARB, (target, level, xoffset, yoffset, zoffset, width, height, depth, commit), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit))
GLATTER_INLINE_OR_NOT void glatter_glTexPageCommitmentARB_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexPageCommitmentARB, "(%s, %d, %d, %d, %d, %d, %d, %d, %u)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (unsigned char)commit)
    glatter_glTexPageCommitmentARB(target, level, xoffset, yoffset, zoffset, width, height, depth, commit);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexPageCommitmentARB_defined
#endif // defined(GL_ARB_sparse_texture)
#if defined(GL_ARB_texture_buffer_object)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexBufferARB, (target, internalformat, buffer), (GLenum target, GLenum internalformat, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glTexBufferARB_debug(GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexBufferARB, "(%s, %s, %u)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned int)buffer)
    glatter_glTexBufferARB(target, internalformat, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexBufferARB_defined
#endif // defined(GL_ARB_texture_buffer_object)
#if defined(GL_ARB_texture_compression)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTexImage1DARB, (target, level, internalformat, width, border, imageSize, data), (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage1DARB_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexImage1DARB, "(%s, %d, %s, %d, %d, %d, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)border, (int)imageSize, (void*)data)
    glatter_glCompressedTexImage1DARB(target, level, internalformat, width, border, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexImage1DARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTexImage2DARB, (target, level, internalformat, width, height, border, imageSize, data), (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage2DARB_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexImage2DARB, "(%s, %d, %s, %d, %d, %d, %d, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)border, (int)imageSize, (void*)data)
    glatter_glCompressedTexImage2DARB(target, level, internalformat, width, height, border, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexImage2DARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTexImage3DARB, (target, level, internalformat, width, height, depth, border, imageSize, data), (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexImage3DARB_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexImage3DARB, "(%s, %d, %s, %d, %d, %d, %d, %d, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth, (int)border, (int)imageSize, (void*)data)
    glatter_glCompressedTexImage3DARB(target, level, internalformat, width, height, depth, border, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexImage3DARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTexSubImage1DARB, (target, level, xoffset, width, format, imageSize, data), (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage1DARB_debug(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexSubImage1DARB, "(%s, %d, %d, %d, %s, %d, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)width, enum_to_string_GL(format), (int)imageSize, (void*)data)
    glatter_glCompressedTexSubImage1DARB(target, level, xoffset, width, format, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexSubImage1DARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTexSubImage2DARB, (target, level, xoffset, yoffset, width, height, format, imageSize, data), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage2DARB_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexSubImage2DARB, "(%s, %d, %d, %d, %d, %d, %s, %d, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, enum_to_string_GL(format), (int)imageSize, (void*)data)
    glatter_glCompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexSubImage2DARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTexSubImage3DARB, (target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTexSubImage3DARB_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTexSubImage3DARB, "(%s, %d, %d, %d, %d, %d, %d, %d, %s, %d, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), (int)imageSize, (void*)data)
    glatter_glCompressedTexSubImage3DARB(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTexSubImage3DARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetCompressedTexImageARB, (target, level, img), (GLenum target, GLint level, void *img))
GLATTER_INLINE_OR_NOT void glatter_glGetCompressedTexImageARB_debug(GLenum target, GLint level, void *img, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetCompressedTexImageARB, "(%s, %d, %p)", enum_to_string_GL(target), (int)level, (void*)img)
    glatter_glGetCompressedTexImageARB(target, level, img);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetCompressedTexImageARB_defined
#endif // defined(GL_ARB_texture_compression)
#if defined(GL_ARB_transpose_matrix)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glLoadTransposeMatrixdARB, (m), (const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glLoadTransposeMatrixdARB_debug(const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLoadTransposeMatrixdARB, "(%p)", (void*)m)
    glatter_glLoadTransposeMatrixdARB(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLoadTransposeMatrixdARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glLoadTransposeMatrixfARB, (m), (const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glLoadTransposeMatrixfARB_debug(const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLoadTransposeMatrixfARB, "(%p)", (void*)m)
    glatter_glLoadTransposeMatrixfARB(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLoadTransposeMatrixfARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultTransposeMatrixdARB, (m), (const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glMultTransposeMatrixdARB_debug(const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultTransposeMatrixdARB, "(%p)", (void*)m)
    glatter_glMultTransposeMatrixdARB(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultTransposeMatrixdARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultTransposeMatrixfARB, (m), (const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMultTransposeMatrixfARB_debug(const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultTransposeMatrixfARB, "(%p)", (void*)m)
    glatter_glMultTransposeMatrixfARB(m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultTransposeMatrixfARB_defined
#endif // defined(GL_ARB_transpose_matrix)
#if defined(GL_ARB_vertex_blend)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexBlendARB, (count), (GLint count))
GLATTER_INLINE_OR_NOT void glatter_glVertexBlendARB_debug(GLint count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexBlendARB, "(%d)", (int)count)
    glatter_glVertexBlendARB(count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexBlendARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWeightPointerARB, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glWeightPointerARB_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightPointerARB, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glWeightPointerARB(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightPointerARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWeightbvARB, (size, weights), (GLint size, const GLbyte *weights))
GLATTER_INLINE_OR_NOT void glatter_glWeightbvARB_debug(GLint size, const GLbyte *weights, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightbvARB, "(%d, %p)", (int)size, (void*)weights)
    glatter_glWeightbvARB(size, weights);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightbvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWeightdvARB, (size, weights), (GLint size, const GLdouble *weights))
GLATTER_INLINE_OR_NOT void glatter_glWeightdvARB_debug(GLint size, const GLdouble *weights, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightdvARB, "(%d, %p)", (int)size, (void*)weights)
    glatter_glWeightdvARB(size, weights);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightdvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWeightfvARB, (size, weights), (GLint size, const GLfloat *weights))
GLATTER_INLINE_OR_NOT void glatter_glWeightfvARB_debug(GLint size, const GLfloat *weights, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightfvARB, "(%d, %p)", (int)size, (void*)weights)
    glatter_glWeightfvARB(size, weights);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightfvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWeightivARB, (size, weights), (GLint size, const GLint *weights))
GLATTER_INLINE_OR_NOT void glatter_glWeightivARB_debug(GLint size, const GLint *weights, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightivARB, "(%d, %p)", (int)size, (void*)weights)
    glatter_glWeightivARB(size, weights);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWeightsvARB, (size, weights), (GLint size, const GLshort *weights))
GLATTER_INLINE_OR_NOT void glatter_glWeightsvARB_debug(GLint size, const GLshort *weights, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightsvARB, "(%d, %p)", (int)size, (void*)weights)
    glatter_glWeightsvARB(size, weights);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightsvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWeightubvARB, (size, weights), (GLint size, const GLubyte *weights))
GLATTER_INLINE_OR_NOT void glatter_glWeightubvARB_debug(GLint size, const GLubyte *weights, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightubvARB, "(%d, %p)", (int)size, (void*)weights)
    glatter_glWeightubvARB(size, weights);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightubvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWeightuivARB, (size, weights), (GLint size, const GLuint *weights))
GLATTER_INLINE_OR_NOT void glatter_glWeightuivARB_debug(GLint size, const GLuint *weights, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightuivARB, "(%d, %p)", (int)size, (void*)weights)
    glatter_glWeightuivARB(size, weights);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightuivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWeightusvARB, (size, weights), (GLint size, const GLushort *weights))
GLATTER_INLINE_OR_NOT void glatter_glWeightusvARB_debug(GLint size, const GLushort *weights, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightusvARB, "(%d, %p)", (int)size, (void*)weights)
    glatter_glWeightusvARB(size, weights);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightusvARB_defined
#endif // defined(GL_ARB_vertex_blend)
#if defined(GL_ARB_vertex_buffer_object)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindBufferARB, (target, buffer), (GLenum target, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glBindBufferARB_debug(GLenum target, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindBufferARB, "(%s, %u)", enum_to_string_GL(target), (unsigned int)buffer)
    glatter_glBindBufferARB(target, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindBufferARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBufferDataARB, (target, size, data, usage), (GLenum target, GLsizeiptrARB size, const void *data, GLenum usage))
GLATTER_INLINE_OR_NOT void glatter_glBufferDataARB_debug(GLenum target, GLsizeiptrARB size, const void *data, GLenum usage, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferDataARB, "(%s, %td, %p, %s)", enum_to_string_GL(target), (ptrdiff_t)size, (void*)data, enum_to_string_GL(usage))
    glatter_glBufferDataARB(target, size, data, usage);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferDataARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBufferSubDataARB, (target, offset, size, data), (GLenum target, GLintptrARB offset, GLsizeiptrARB size, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glBufferSubDataARB_debug(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferSubDataARB, "(%s, %td, %td, %p)", enum_to_string_GL(target), (ptrdiff_t)offset, (ptrdiff_t)size, (void*)data)
    glatter_glBufferSubDataARB(target, offset, size, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferSubDataARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteBuffersARB, (n, buffers), (GLsizei n, const GLuint *buffers))
GLATTER_INLINE_OR_NOT void glatter_glDeleteBuffersARB_debug(GLsizei n, const GLuint *buffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteBuffersARB, "(%d, %p)", (int)n, (void*)buffers)
    glatter_glDeleteBuffersARB(n, buffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteBuffersARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenBuffersARB, (n, buffers), (GLsizei n, GLuint *buffers))
GLATTER_INLINE_OR_NOT void glatter_glGenBuffersARB_debug(GLsizei n, GLuint *buffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenBuffersARB, "(%d, %p)", (int)n, (void*)buffers)
    glatter_glGenBuffersARB(n, buffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenBuffersARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetBufferParameterivARB, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetBufferParameterivARB_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBufferParameterivARB, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetBufferParameterivARB(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBufferParameterivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetBufferPointervARB, (target, pname, params), (GLenum target, GLenum pname, void **params))
GLATTER_INLINE_OR_NOT void glatter_glGetBufferPointervARB_debug(GLenum target, GLenum pname, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBufferPointervARB, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetBufferPointervARB(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBufferPointervARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetBufferSubDataARB, (target, offset, size, data), (GLenum target, GLintptrARB offset, GLsizeiptrARB size, void *data))
GLATTER_INLINE_OR_NOT void glatter_glGetBufferSubDataARB_debug(GLenum target, GLintptrARB offset, GLsizeiptrARB size, void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBufferSubDataARB, "(%s, %td, %td, %p)", enum_to_string_GL(target), (ptrdiff_t)offset, (ptrdiff_t)size, (void*)data)
    glatter_glGetBufferSubDataARB(target, offset, size, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBufferSubDataARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsBufferARB, (buffer), (GLuint buffer))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsBufferARB_debug(GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsBufferARB, "(%u)", (unsigned int)buffer)
    GLboolean rval = glatter_glIsBufferARB(buffer);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsBufferARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, void *, APIENTRY, glMapBufferARB, (target, access), (GLenum target, GLenum access))
GLATTER_INLINE_OR_NOT void * glatter_glMapBufferARB_debug(GLenum target, GLenum access, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapBufferARB, "(%s, %s)", enum_to_string_GL(target), enum_to_string_GL(access))
    void * rval = glatter_glMapBufferARB(target, access);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glMapBufferARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glUnmapBufferARB, (target), (GLenum target))
GLATTER_INLINE_OR_NOT GLboolean glatter_glUnmapBufferARB_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUnmapBufferARB, "(%s)", enum_to_string_GL(target))
    GLboolean rval = glatter_glUnmapBufferARB(target);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glUnmapBufferARB_defined
#endif // defined(GL_ARB_vertex_buffer_object)
#if defined(GL_ARB_vertex_program)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDisableVertexAttribArrayARB, (index), (GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glDisableVertexAttribArrayARB_debug(GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableVertexAttribArrayARB, "(%u)", (unsigned int)index)
    glatter_glDisableVertexAttribArrayARB(index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableVertexAttribArrayARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEnableVertexAttribArrayARB, (index), (GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glEnableVertexAttribArrayARB_debug(GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableVertexAttribArrayARB, "(%u)", (unsigned int)index)
    glatter_glEnableVertexAttribArrayARB(index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableVertexAttribArrayARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexAttribPointervARB, (index, pname, pointer), (GLuint index, GLenum pname, void **pointer))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribPointervARB_debug(GLuint index, GLenum pname, void **pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribPointervARB, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)pointer)
    glatter_glGetVertexAttribPointervARB(index, pname, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribPointervARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexAttribdvARB, (index, pname, params), (GLuint index, GLenum pname, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribdvARB_debug(GLuint index, GLenum pname, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribdvARB, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVertexAttribdvARB(index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribdvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexAttribfvARB, (index, pname, params), (GLuint index, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribfvARB_debug(GLuint index, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribfvARB, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVertexAttribfvARB(index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribfvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexAttribivARB, (index, pname, params), (GLuint index, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribivARB_debug(GLuint index, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribivARB, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVertexAttribivARB(index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib1dARB, (index, x), (GLuint index, GLdouble x))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1dARB_debug(GLuint index, GLdouble x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib1dARB, "(%u, %f)", (unsigned int)index, (double)x)
    glatter_glVertexAttrib1dARB(index, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib1dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib1dvARB, (index, v), (GLuint index, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1dvARB_debug(GLuint index, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib1dvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib1dvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib1dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib1fARB, (index, x), (GLuint index, GLfloat x))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1fARB_debug(GLuint index, GLfloat x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib1fARB, "(%u, %f)", (unsigned int)index, (float)x)
    glatter_glVertexAttrib1fARB(index, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib1fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib1fvARB, (index, v), (GLuint index, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1fvARB_debug(GLuint index, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib1fvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib1fvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib1fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib1sARB, (index, x), (GLuint index, GLshort x))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1sARB_debug(GLuint index, GLshort x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib1sARB, "(%u, %hi)", (unsigned int)index, (short)x)
    glatter_glVertexAttrib1sARB(index, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib1sARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib1svARB, (index, v), (GLuint index, const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1svARB_debug(GLuint index, const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib1svARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib1svARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib1svARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib2dARB, (index, x, y), (GLuint index, GLdouble x, GLdouble y))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2dARB_debug(GLuint index, GLdouble x, GLdouble y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib2dARB, "(%u, %f, %f)", (unsigned int)index, (double)x, (double)y)
    glatter_glVertexAttrib2dARB(index, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib2dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib2dvARB, (index, v), (GLuint index, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2dvARB_debug(GLuint index, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib2dvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib2dvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib2dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib2fARB, (index, x, y), (GLuint index, GLfloat x, GLfloat y))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2fARB_debug(GLuint index, GLfloat x, GLfloat y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib2fARB, "(%u, %f, %f)", (unsigned int)index, (float)x, (float)y)
    glatter_glVertexAttrib2fARB(index, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib2fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib2fvARB, (index, v), (GLuint index, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2fvARB_debug(GLuint index, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib2fvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib2fvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib2fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib2sARB, (index, x, y), (GLuint index, GLshort x, GLshort y))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2sARB_debug(GLuint index, GLshort x, GLshort y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib2sARB, "(%u, %hi, %hi)", (unsigned int)index, (short)x, (short)y)
    glatter_glVertexAttrib2sARB(index, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib2sARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib2svARB, (index, v), (GLuint index, const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2svARB_debug(GLuint index, const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib2svARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib2svARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib2svARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib3dARB, (index, x, y, z), (GLuint index, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3dARB_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib3dARB, "(%u, %f, %f, %f)", (unsigned int)index, (double)x, (double)y, (double)z)
    glatter_glVertexAttrib3dARB(index, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib3dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib3dvARB, (index, v), (GLuint index, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3dvARB_debug(GLuint index, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib3dvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib3dvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib3dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib3fARB, (index, x, y, z), (GLuint index, GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3fARB_debug(GLuint index, GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib3fARB, "(%u, %f, %f, %f)", (unsigned int)index, (float)x, (float)y, (float)z)
    glatter_glVertexAttrib3fARB(index, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib3fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib3fvARB, (index, v), (GLuint index, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3fvARB_debug(GLuint index, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib3fvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib3fvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib3fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib3sARB, (index, x, y, z), (GLuint index, GLshort x, GLshort y, GLshort z))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3sARB_debug(GLuint index, GLshort x, GLshort y, GLshort z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib3sARB, "(%u, %hi, %hi, %hi)", (unsigned int)index, (short)x, (short)y, (short)z)
    glatter_glVertexAttrib3sARB(index, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib3sARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib3svARB, (index, v), (GLuint index, const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3svARB_debug(GLuint index, const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib3svARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib3svARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib3svARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4NbvARB, (index, v), (GLuint index, const GLbyte *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NbvARB_debug(GLuint index, const GLbyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4NbvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4NbvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4NbvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4NivARB, (index, v), (GLuint index, const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NivARB_debug(GLuint index, const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4NivARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4NivARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4NivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4NsvARB, (index, v), (GLuint index, const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NsvARB_debug(GLuint index, const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4NsvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4NsvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4NsvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4NubARB, (index, x, y, z, w), (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NubARB_debug(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4NubARB, "(%u, %u, %u, %u, %u)", (unsigned int)index, (unsigned char)x, (unsigned char)y, (unsigned char)z, (unsigned char)w)
    glatter_glVertexAttrib4NubARB(index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4NubARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4NubvARB, (index, v), (GLuint index, const GLubyte *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NubvARB_debug(GLuint index, const GLubyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4NubvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4NubvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4NubvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4NuivARB, (index, v), (GLuint index, const GLuint *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NuivARB_debug(GLuint index, const GLuint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4NuivARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4NuivARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4NuivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4NusvARB, (index, v), (GLuint index, const GLushort *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4NusvARB_debug(GLuint index, const GLushort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4NusvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4NusvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4NusvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4bvARB, (index, v), (GLuint index, const GLbyte *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4bvARB_debug(GLuint index, const GLbyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4bvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4bvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4bvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4dARB, (index, x, y, z, w), (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4dARB_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4dARB, "(%u, %f, %f, %f, %f)", (unsigned int)index, (double)x, (double)y, (double)z, (double)w)
    glatter_glVertexAttrib4dARB(index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4dvARB, (index, v), (GLuint index, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4dvARB_debug(GLuint index, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4dvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4dvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4fARB, (index, x, y, z, w), (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4fARB_debug(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4fARB, "(%u, %f, %f, %f, %f)", (unsigned int)index, (float)x, (float)y, (float)z, (float)w)
    glatter_glVertexAttrib4fARB(index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4fvARB, (index, v), (GLuint index, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4fvARB_debug(GLuint index, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4fvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4fvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4ivARB, (index, v), (GLuint index, const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4ivARB_debug(GLuint index, const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4ivARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4ivARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4ivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4sARB, (index, x, y, z, w), (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4sARB_debug(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4sARB, "(%u, %hi, %hi, %hi, %hi)", (unsigned int)index, (short)x, (short)y, (short)z, (short)w)
    glatter_glVertexAttrib4sARB(index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4sARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4svARB, (index, v), (GLuint index, const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4svARB_debug(GLuint index, const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4svARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4svARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4svARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4ubvARB, (index, v), (GLuint index, const GLubyte *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4ubvARB_debug(GLuint index, const GLubyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4ubvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4ubvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4ubvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4uivARB, (index, v), (GLuint index, const GLuint *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4uivARB_debug(GLuint index, const GLuint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4uivARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4uivARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4uivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4usvARB, (index, v), (GLuint index, const GLushort *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4usvARB_debug(GLuint index, const GLushort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4usvARB, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4usvARB(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4usvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribPointerARB, (index, size, type, normalized, stride, pointer), (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribPointerARB_debug(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribPointerARB, "(%u, %d, %s, %u, %d, %p)", (unsigned int)index, (int)size, enum_to_string_GL(type), (unsigned char)normalized, (int)stride, (void*)pointer)
    glatter_glVertexAttribPointerARB(index, size, type, normalized, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribPointerARB_defined
#endif // defined(GL_ARB_vertex_program)
#if defined(GL_ARB_vertex_shader)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindAttribLocationARB, (programObj, index, name), (GLhandleARB programObj, GLuint index, const GLcharARB *name))
GLATTER_INLINE_OR_NOT void glatter_glBindAttribLocationARB_debug(GLhandleARB programObj, GLuint index, const GLcharARB *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindAttribLocationARB, "(%u, %u, %p)", (unsigned int)programObj, (unsigned int)index, (void*)name)
    glatter_glBindAttribLocationARB(programObj, index, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindAttribLocationARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetActiveAttribARB, (programObj, index, maxLength, length, size, type, name), (GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name))
GLATTER_INLINE_OR_NOT void glatter_glGetActiveAttribARB_debug(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, GLint *size, GLenum *type, GLcharARB *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetActiveAttribARB, "(%u, %u, %d, %p, %p, %p, %p)", (unsigned int)programObj, (unsigned int)index, (int)maxLength, (void*)length, (void*)size, (void*)type, (void*)name)
    glatter_glGetActiveAttribARB(programObj, index, maxLength, length, size, type, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetActiveAttribARB_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLint, APIENTRY, glGetAttribLocationARB, (programObj, name), (GLhandleARB programObj, const GLcharARB *name))
GLATTER_INLINE_OR_NOT GLint glatter_glGetAttribLocationARB_debug(GLhandleARB programObj, const GLcharARB *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetAttribLocationARB, "(%u, %p)", (unsigned int)programObj, (void*)name)
    GLint rval = glatter_glGetAttribLocationARB(programObj, name);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetAttribLocationARB_defined
#endif // defined(GL_ARB_vertex_shader)
#if defined(GL_ARB_window_pos)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2dARB, (x, y), (GLdouble x, GLdouble y))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2dARB_debug(GLdouble x, GLdouble y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2dARB, "(%f, %f)", (double)x, (double)y)
    glatter_glWindowPos2dARB(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2dvARB, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2dvARB_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2dvARB, "(%p)", (void*)v)
    glatter_glWindowPos2dvARB(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2fARB, (x, y), (GLfloat x, GLfloat y))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2fARB_debug(GLfloat x, GLfloat y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2fARB, "(%f, %f)", (float)x, (float)y)
    glatter_glWindowPos2fARB(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2fvARB, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2fvARB_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2fvARB, "(%p)", (void*)v)
    glatter_glWindowPos2fvARB(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2iARB, (x, y), (GLint x, GLint y))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2iARB_debug(GLint x, GLint y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2iARB, "(%d, %d)", (int)x, (int)y)
    glatter_glWindowPos2iARB(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2iARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2ivARB, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2ivARB_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2ivARB, "(%p)", (void*)v)
    glatter_glWindowPos2ivARB(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2ivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2sARB, (x, y), (GLshort x, GLshort y))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2sARB_debug(GLshort x, GLshort y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2sARB, "(%hi, %hi)", (short)x, (short)y)
    glatter_glWindowPos2sARB(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2sARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2svARB, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2svARB_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2svARB, "(%p)", (void*)v)
    glatter_glWindowPos2svARB(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2svARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3dARB, (x, y, z), (GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3dARB_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3dARB, "(%f, %f, %f)", (double)x, (double)y, (double)z)
    glatter_glWindowPos3dARB(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3dARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3dvARB, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3dvARB_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3dvARB, "(%p)", (void*)v)
    glatter_glWindowPos3dvARB(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3dvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3fARB, (x, y, z), (GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3fARB_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3fARB, "(%f, %f, %f)", (float)x, (float)y, (float)z)
    glatter_glWindowPos3fARB(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3fARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3fvARB, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3fvARB_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3fvARB, "(%p)", (void*)v)
    glatter_glWindowPos3fvARB(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3fvARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3iARB, (x, y, z), (GLint x, GLint y, GLint z))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3iARB_debug(GLint x, GLint y, GLint z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3iARB, "(%d, %d, %d)", (int)x, (int)y, (int)z)
    glatter_glWindowPos3iARB(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3iARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3ivARB, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3ivARB_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3ivARB, "(%p)", (void*)v)
    glatter_glWindowPos3ivARB(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3ivARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3sARB, (x, y, z), (GLshort x, GLshort y, GLshort z))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3sARB_debug(GLshort x, GLshort y, GLshort z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3sARB, "(%hi, %hi, %hi)", (short)x, (short)y, (short)z)
    glatter_glWindowPos3sARB(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3sARB_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3svARB, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3svARB_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3svARB, "(%p)", (void*)v)
    glatter_glWindowPos3svARB(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3svARB_defined
#endif // defined(GL_ARB_window_pos)
#if defined(GL_ATI_draw_buffers)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawBuffersATI, (n, bufs), (GLsizei n, const GLenum *bufs))
GLATTER_INLINE_OR_NOT void glatter_glDrawBuffersATI_debug(GLsizei n, const GLenum *bufs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawBuffersATI, "(%d, %p)", (int)n, (void*)bufs)
    glatter_glDrawBuffersATI(n, bufs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawBuffersATI_defined
#endif // defined(GL_ATI_draw_buffers)
#if defined(GL_ATI_element_array)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawElementArrayATI, (mode, count), (GLenum mode, GLsizei count))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementArrayATI_debug(GLenum mode, GLsizei count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementArrayATI, "(%s, %d)", enum_to_string_GL(mode), (int)count)
    glatter_glDrawElementArrayATI(mode, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementArrayATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawRangeElementArrayATI, (mode, start, end, count), (GLenum mode, GLuint start, GLuint end, GLsizei count))
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElementArrayATI_debug(GLenum mode, GLuint start, GLuint end, GLsizei count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawRangeElementArrayATI, "(%s, %u, %u, %d)", enum_to_string_GL(mode), (unsigned int)start, (unsigned int)end, (int)count)
    glatter_glDrawRangeElementArrayATI(mode, start, end, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawRangeElementArrayATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glElementPointerATI, (type, pointer), (GLenum type, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glElementPointerATI_debug(GLenum type, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glElementPointerATI, "(%s, %p)", enum_to_string_GL(type), (void*)pointer)
    glatter_glElementPointerATI(type, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glElementPointerATI_defined
#endif // defined(GL_ATI_element_array)
#if defined(GL_ATI_envmap_bumpmap)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTexBumpParameterfvATI, (pname, param), (GLenum pname, GLfloat *param))
GLATTER_INLINE_OR_NOT void glatter_glGetTexBumpParameterfvATI_debug(GLenum pname, GLfloat *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexBumpParameterfvATI, "(%s, %p)", enum_to_string_GL(pname), (void*)param)
    glatter_glGetTexBumpParameterfvATI(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexBumpParameterfvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTexBumpParameterivATI, (pname, param), (GLenum pname, GLint *param))
GLATTER_INLINE_OR_NOT void glatter_glGetTexBumpParameterivATI_debug(GLenum pname, GLint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexBumpParameterivATI, "(%s, %p)", enum_to_string_GL(pname), (void*)param)
    glatter_glGetTexBumpParameterivATI(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexBumpParameterivATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexBumpParameterfvATI, (pname, param), (GLenum pname, const GLfloat *param))
GLATTER_INLINE_OR_NOT void glatter_glTexBumpParameterfvATI_debug(GLenum pname, const GLfloat *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexBumpParameterfvATI, "(%s, %p)", enum_to_string_GL(pname), (void*)param)
    glatter_glTexBumpParameterfvATI(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexBumpParameterfvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexBumpParameterivATI, (pname, param), (GLenum pname, const GLint *param))
GLATTER_INLINE_OR_NOT void glatter_glTexBumpParameterivATI_debug(GLenum pname, const GLint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexBumpParameterivATI, "(%s, %p)", enum_to_string_GL(pname), (void*)param)
    glatter_glTexBumpParameterivATI(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexBumpParameterivATI_defined
#endif // defined(GL_ATI_envmap_bumpmap)
#if defined(GL_ATI_fragment_shader)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glAlphaFragmentOp1ATI, (op, dst, dstMod, arg1, arg1Rep, arg1Mod), (GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod))
GLATTER_INLINE_OR_NOT void glatter_glAlphaFragmentOp1ATI_debug(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAlphaFragmentOp1ATI, "(%s, %u, %u, %u, %u, %u)", enum_to_string_GL(op), (unsigned int)dst, (unsigned int)dstMod, (unsigned int)arg1, (unsigned int)arg1Rep, (unsigned int)arg1Mod)
    glatter_glAlphaFragmentOp1ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAlphaFragmentOp1ATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glAlphaFragmentOp2ATI, (op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod), (GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod))
GLATTER_INLINE_OR_NOT void glatter_glAlphaFragmentOp2ATI_debug(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAlphaFragmentOp2ATI, "(%s, %u, %u, %u, %u, %u, %u, %u, %u)", enum_to_string_GL(op), (unsigned int)dst, (unsigned int)dstMod, (unsigned int)arg1, (unsigned int)arg1Rep, (unsigned int)arg1Mod, (unsigned int)arg2, (unsigned int)arg2Rep, (unsigned int)arg2Mod)
    glatter_glAlphaFragmentOp2ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAlphaFragmentOp2ATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glAlphaFragmentOp3ATI, (op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod), (GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod))
GLATTER_INLINE_OR_NOT void glatter_glAlphaFragmentOp3ATI_debug(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAlphaFragmentOp3ATI, "(%s, %u, %u, %u, %u, %u, %u, %u, %u, %u, %u, %u)", enum_to_string_GL(op), (unsigned int)dst, (unsigned int)dstMod, (unsigned int)arg1, (unsigned int)arg1Rep, (unsigned int)arg1Mod, (unsigned int)arg2, (unsigned int)arg2Rep, (unsigned int)arg2Mod, (unsigned int)arg3, (unsigned int)arg3Rep, (unsigned int)arg3Mod)
    glatter_glAlphaFragmentOp3ATI(op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAlphaFragmentOp3ATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBeginFragmentShaderATI, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glBeginFragmentShaderATI_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginFragmentShaderATI, "()")
    glatter_glBeginFragmentShaderATI();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginFragmentShaderATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindFragmentShaderATI, (id), (GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glBindFragmentShaderATI_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindFragmentShaderATI, "(%u)", (unsigned int)id)
    glatter_glBindFragmentShaderATI(id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindFragmentShaderATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorFragmentOp1ATI, (op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod), (GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod))
GLATTER_INLINE_OR_NOT void glatter_glColorFragmentOp1ATI_debug(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorFragmentOp1ATI, "(%s, %u, %u, %u, %u, %u, %u)", enum_to_string_GL(op), (unsigned int)dst, (unsigned int)dstMask, (unsigned int)dstMod, (unsigned int)arg1, (unsigned int)arg1Rep, (unsigned int)arg1Mod)
    glatter_glColorFragmentOp1ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorFragmentOp1ATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorFragmentOp2ATI, (op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod), (GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod))
GLATTER_INLINE_OR_NOT void glatter_glColorFragmentOp2ATI_debug(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorFragmentOp2ATI, "(%s, %u, %u, %u, %u, %u, %u, %u, %u, %u)", enum_to_string_GL(op), (unsigned int)dst, (unsigned int)dstMask, (unsigned int)dstMod, (unsigned int)arg1, (unsigned int)arg1Rep, (unsigned int)arg1Mod, (unsigned int)arg2, (unsigned int)arg2Rep, (unsigned int)arg2Mod)
    glatter_glColorFragmentOp2ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorFragmentOp2ATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorFragmentOp3ATI, (op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod), (GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod))
GLATTER_INLINE_OR_NOT void glatter_glColorFragmentOp3ATI_debug(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorFragmentOp3ATI, "(%s, %u, %u, %u, %u, %u, %u, %u, %u, %u, %u, %u, %u)", enum_to_string_GL(op), (unsigned int)dst, (unsigned int)dstMask, (unsigned int)dstMod, (unsigned int)arg1, (unsigned int)arg1Rep, (unsigned int)arg1Mod, (unsigned int)arg2, (unsigned int)arg2Rep, (unsigned int)arg2Mod, (unsigned int)arg3, (unsigned int)arg3Rep, (unsigned int)arg3Mod)
    glatter_glColorFragmentOp3ATI(op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorFragmentOp3ATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteFragmentShaderATI, (id), (GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glDeleteFragmentShaderATI_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteFragmentShaderATI, "(%u)", (unsigned int)id)
    glatter_glDeleteFragmentShaderATI(id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteFragmentShaderATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEndFragmentShaderATI, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glEndFragmentShaderATI_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndFragmentShaderATI, "()")
    glatter_glEndFragmentShaderATI();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndFragmentShaderATI_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glGenFragmentShadersATI, (range), (GLuint range))
GLATTER_INLINE_OR_NOT GLuint glatter_glGenFragmentShadersATI_debug(GLuint range, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenFragmentShadersATI, "(%u)", (unsigned int)range)
    GLuint rval = glatter_glGenFragmentShadersATI(range);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGenFragmentShadersATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPassTexCoordATI, (dst, coord, swizzle), (GLuint dst, GLuint coord, GLenum swizzle))
GLATTER_INLINE_OR_NOT void glatter_glPassTexCoordATI_debug(GLuint dst, GLuint coord, GLenum swizzle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPassTexCoordATI, "(%u, %u, %s)", (unsigned int)dst, (unsigned int)coord, enum_to_string_GL(swizzle))
    glatter_glPassTexCoordATI(dst, coord, swizzle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPassTexCoordATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSampleMapATI, (dst, interp, swizzle), (GLuint dst, GLuint interp, GLenum swizzle))
GLATTER_INLINE_OR_NOT void glatter_glSampleMapATI_debug(GLuint dst, GLuint interp, GLenum swizzle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSampleMapATI, "(%u, %u, %s)", (unsigned int)dst, (unsigned int)interp, enum_to_string_GL(swizzle))
    glatter_glSampleMapATI(dst, interp, swizzle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSampleMapATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSetFragmentShaderConstantATI, (dst, value), (GLuint dst, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glSetFragmentShaderConstantATI_debug(GLuint dst, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSetFragmentShaderConstantATI, "(%u, %p)", (unsigned int)dst, (void*)value)
    glatter_glSetFragmentShaderConstantATI(dst, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSetFragmentShaderConstantATI_defined
#endif // defined(GL_ATI_fragment_shader)
#if defined(GL_ATI_map_object_buffer)
GLATTER_FBLOCK(return, GL, GLAPI, void *, APIENTRY, glMapObjectBufferATI, (buffer), (GLuint buffer))
GLATTER_INLINE_OR_NOT void * glatter_glMapObjectBufferATI_debug(GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapObjectBufferATI, "(%u)", (unsigned int)buffer)
    void * rval = glatter_glMapObjectBufferATI(buffer);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glMapObjectBufferATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUnmapObjectBufferATI, (buffer), (GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glUnmapObjectBufferATI_debug(GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUnmapObjectBufferATI, "(%u)", (unsigned int)buffer)
    glatter_glUnmapObjectBufferATI(buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUnmapObjectBufferATI_defined
#endif // defined(GL_ATI_map_object_buffer)
#if defined(GL_ATI_pn_triangles)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPNTrianglesfATI, (pname, param), (GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glPNTrianglesfATI_debug(GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPNTrianglesfATI, "(%s, %f)", enum_to_string_GL(pname), (float)param)
    glatter_glPNTrianglesfATI(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPNTrianglesfATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPNTrianglesiATI, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glPNTrianglesiATI_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPNTrianglesiATI, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glPNTrianglesiATI(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPNTrianglesiATI_defined
#endif // defined(GL_ATI_pn_triangles)
#if defined(GL_ATI_separate_stencil)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilFuncSeparateATI, (frontfunc, backfunc, ref, mask), (GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilFuncSeparateATI_debug(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilFuncSeparateATI, "(%s, %s, %d, %u)", enum_to_string_GL(frontfunc), enum_to_string_GL(backfunc), (int)ref, (unsigned int)mask)
    glatter_glStencilFuncSeparateATI(frontfunc, backfunc, ref, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilFuncSeparateATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilOpSeparateATI, (face, sfail, dpfail, dppass), (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass))
GLATTER_INLINE_OR_NOT void glatter_glStencilOpSeparateATI_debug(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilOpSeparateATI, "(%s, %s, %s, %s)", enum_to_string_GL(face), enum_to_string_GL(sfail), enum_to_string_GL(dpfail), enum_to_string_GL(dppass))
    glatter_glStencilOpSeparateATI(face, sfail, dpfail, dppass);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilOpSeparateATI_defined
#endif // defined(GL_ATI_separate_stencil)
#if defined(GL_ATI_vertex_array_object)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glArrayObjectATI, (array, size, type, stride, buffer, offset), (GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset))
GLATTER_INLINE_OR_NOT void glatter_glArrayObjectATI_debug(GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glArrayObjectATI, "(%s, %d, %s, %d, %u, %u)", enum_to_string_GL(array), (int)size, enum_to_string_GL(type), (int)stride, (unsigned int)buffer, (unsigned int)offset)
    glatter_glArrayObjectATI(array, size, type, stride, buffer, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glArrayObjectATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFreeObjectBufferATI, (buffer), (GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glFreeObjectBufferATI_debug(GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFreeObjectBufferATI, "(%u)", (unsigned int)buffer)
    glatter_glFreeObjectBufferATI(buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFreeObjectBufferATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetArrayObjectfvATI, (array, pname, params), (GLenum array, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetArrayObjectfvATI_debug(GLenum array, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetArrayObjectfvATI, "(%s, %s, %p)", enum_to_string_GL(array), enum_to_string_GL(pname), (void*)params)
    glatter_glGetArrayObjectfvATI(array, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetArrayObjectfvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetArrayObjectivATI, (array, pname, params), (GLenum array, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetArrayObjectivATI_debug(GLenum array, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetArrayObjectivATI, "(%s, %s, %p)", enum_to_string_GL(array), enum_to_string_GL(pname), (void*)params)
    glatter_glGetArrayObjectivATI(array, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetArrayObjectivATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetObjectBufferfvATI, (buffer, pname, params), (GLuint buffer, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetObjectBufferfvATI_debug(GLuint buffer, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetObjectBufferfvATI, "(%u, %s, %p)", (unsigned int)buffer, enum_to_string_GL(pname), (void*)params)
    glatter_glGetObjectBufferfvATI(buffer, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetObjectBufferfvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetObjectBufferivATI, (buffer, pname, params), (GLuint buffer, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetObjectBufferivATI_debug(GLuint buffer, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetObjectBufferivATI, "(%u, %s, %p)", (unsigned int)buffer, enum_to_string_GL(pname), (void*)params)
    glatter_glGetObjectBufferivATI(buffer, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetObjectBufferivATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVariantArrayObjectfvATI, (id, pname, params), (GLuint id, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVariantArrayObjectfvATI_debug(GLuint id, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVariantArrayObjectfvATI, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVariantArrayObjectfvATI(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVariantArrayObjectfvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVariantArrayObjectivATI, (id, pname, params), (GLuint id, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVariantArrayObjectivATI_debug(GLuint id, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVariantArrayObjectivATI, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVariantArrayObjectivATI(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVariantArrayObjectivATI_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsObjectBufferATI, (buffer), (GLuint buffer))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsObjectBufferATI_debug(GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsObjectBufferATI, "(%u)", (unsigned int)buffer)
    GLboolean rval = glatter_glIsObjectBufferATI(buffer);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsObjectBufferATI_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glNewObjectBufferATI, (size, pointer, usage), (GLsizei size, const void *pointer, GLenum usage))
GLATTER_INLINE_OR_NOT GLuint glatter_glNewObjectBufferATI_debug(GLsizei size, const void *pointer, GLenum usage, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNewObjectBufferATI, "(%d, %p, %s)", (int)size, (void*)pointer, enum_to_string_GL(usage))
    GLuint rval = glatter_glNewObjectBufferATI(size, pointer, usage);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glNewObjectBufferATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUpdateObjectBufferATI, (buffer, offset, size, pointer, preserve), (GLuint buffer, GLuint offset, GLsizei size, const void *pointer, GLenum preserve))
GLATTER_INLINE_OR_NOT void glatter_glUpdateObjectBufferATI_debug(GLuint buffer, GLuint offset, GLsizei size, const void *pointer, GLenum preserve, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUpdateObjectBufferATI, "(%u, %u, %d, %p, %s)", (unsigned int)buffer, (unsigned int)offset, (int)size, (void*)pointer, enum_to_string_GL(preserve))
    glatter_glUpdateObjectBufferATI(buffer, offset, size, pointer, preserve);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUpdateObjectBufferATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVariantArrayObjectATI, (id, type, stride, buffer, offset), (GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset))
GLATTER_INLINE_OR_NOT void glatter_glVariantArrayObjectATI_debug(GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVariantArrayObjectATI, "(%u, %s, %d, %u, %u)", (unsigned int)id, enum_to_string_GL(type), (int)stride, (unsigned int)buffer, (unsigned int)offset)
    glatter_glVariantArrayObjectATI(id, type, stride, buffer, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVariantArrayObjectATI_defined
#endif // defined(GL_ATI_vertex_array_object)
#if defined(GL_ATI_vertex_attrib_array_object)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexAttribArrayObjectfvATI, (index, pname, params), (GLuint index, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribArrayObjectfvATI_debug(GLuint index, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribArrayObjectfvATI, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVertexAttribArrayObjectfvATI(index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribArrayObjectfvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexAttribArrayObjectivATI, (index, pname, params), (GLuint index, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribArrayObjectivATI_debug(GLuint index, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribArrayObjectivATI, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVertexAttribArrayObjectivATI(index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribArrayObjectivATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribArrayObjectATI, (index, size, type, normalized, stride, buffer, offset), (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLuint buffer, GLuint offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribArrayObjectATI_debug(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLuint buffer, GLuint offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribArrayObjectATI, "(%u, %d, %s, %u, %d, %u, %u)", (unsigned int)index, (int)size, enum_to_string_GL(type), (unsigned char)normalized, (int)stride, (unsigned int)buffer, (unsigned int)offset)
    glatter_glVertexAttribArrayObjectATI(index, size, type, normalized, stride, buffer, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribArrayObjectATI_defined
#endif // defined(GL_ATI_vertex_attrib_array_object)
#if defined(GL_ATI_vertex_streams)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glClientActiveVertexStreamATI, (stream), (GLenum stream))
GLATTER_INLINE_OR_NOT void glatter_glClientActiveVertexStreamATI_debug(GLenum stream, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClientActiveVertexStreamATI, "(%s)", enum_to_string_GL(stream))
    glatter_glClientActiveVertexStreamATI(stream);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClientActiveVertexStreamATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalStream3bATI, (stream, nx, ny, nz), (GLenum stream, GLbyte nx, GLbyte ny, GLbyte nz))
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3bATI_debug(GLenum stream, GLbyte nx, GLbyte ny, GLbyte nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalStream3bATI, "(%s, %d, %d, %d)", enum_to_string_GL(stream), (signed char)nx, (signed char)ny, (signed char)nz)
    glatter_glNormalStream3bATI(stream, nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalStream3bATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalStream3bvATI, (stream, coords), (GLenum stream, const GLbyte *coords))
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3bvATI_debug(GLenum stream, const GLbyte *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalStream3bvATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glNormalStream3bvATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalStream3bvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalStream3dATI, (stream, nx, ny, nz), (GLenum stream, GLdouble nx, GLdouble ny, GLdouble nz))
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3dATI_debug(GLenum stream, GLdouble nx, GLdouble ny, GLdouble nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalStream3dATI, "(%s, %f, %f, %f)", enum_to_string_GL(stream), (double)nx, (double)ny, (double)nz)
    glatter_glNormalStream3dATI(stream, nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalStream3dATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalStream3dvATI, (stream, coords), (GLenum stream, const GLdouble *coords))
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3dvATI_debug(GLenum stream, const GLdouble *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalStream3dvATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glNormalStream3dvATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalStream3dvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalStream3fATI, (stream, nx, ny, nz), (GLenum stream, GLfloat nx, GLfloat ny, GLfloat nz))
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3fATI_debug(GLenum stream, GLfloat nx, GLfloat ny, GLfloat nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalStream3fATI, "(%s, %f, %f, %f)", enum_to_string_GL(stream), (float)nx, (float)ny, (float)nz)
    glatter_glNormalStream3fATI(stream, nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalStream3fATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalStream3fvATI, (stream, coords), (GLenum stream, const GLfloat *coords))
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3fvATI_debug(GLenum stream, const GLfloat *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalStream3fvATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glNormalStream3fvATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalStream3fvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalStream3iATI, (stream, nx, ny, nz), (GLenum stream, GLint nx, GLint ny, GLint nz))
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3iATI_debug(GLenum stream, GLint nx, GLint ny, GLint nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalStream3iATI, "(%s, %d, %d, %d)", enum_to_string_GL(stream), (int)nx, (int)ny, (int)nz)
    glatter_glNormalStream3iATI(stream, nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalStream3iATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalStream3ivATI, (stream, coords), (GLenum stream, const GLint *coords))
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3ivATI_debug(GLenum stream, const GLint *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalStream3ivATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glNormalStream3ivATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalStream3ivATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalStream3sATI, (stream, nx, ny, nz), (GLenum stream, GLshort nx, GLshort ny, GLshort nz))
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3sATI_debug(GLenum stream, GLshort nx, GLshort ny, GLshort nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalStream3sATI, "(%s, %hi, %hi, %hi)", enum_to_string_GL(stream), (short)nx, (short)ny, (short)nz)
    glatter_glNormalStream3sATI(stream, nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalStream3sATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalStream3svATI, (stream, coords), (GLenum stream, const GLshort *coords))
GLATTER_INLINE_OR_NOT void glatter_glNormalStream3svATI_debug(GLenum stream, const GLshort *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalStream3svATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glNormalStream3svATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalStream3svATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexBlendEnvfATI, (pname, param), (GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glVertexBlendEnvfATI_debug(GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexBlendEnvfATI, "(%s, %f)", enum_to_string_GL(pname), (float)param)
    glatter_glVertexBlendEnvfATI(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexBlendEnvfATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexBlendEnviATI, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glVertexBlendEnviATI_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexBlendEnviATI, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glVertexBlendEnviATI(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexBlendEnviATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream1dATI, (stream, x), (GLenum stream, GLdouble x))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1dATI_debug(GLenum stream, GLdouble x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream1dATI, "(%s, %f)", enum_to_string_GL(stream), (double)x)
    glatter_glVertexStream1dATI(stream, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream1dATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream1dvATI, (stream, coords), (GLenum stream, const GLdouble *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1dvATI_debug(GLenum stream, const GLdouble *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream1dvATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream1dvATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream1dvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream1fATI, (stream, x), (GLenum stream, GLfloat x))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1fATI_debug(GLenum stream, GLfloat x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream1fATI, "(%s, %f)", enum_to_string_GL(stream), (float)x)
    glatter_glVertexStream1fATI(stream, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream1fATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream1fvATI, (stream, coords), (GLenum stream, const GLfloat *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1fvATI_debug(GLenum stream, const GLfloat *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream1fvATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream1fvATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream1fvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream1iATI, (stream, x), (GLenum stream, GLint x))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1iATI_debug(GLenum stream, GLint x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream1iATI, "(%s, %d)", enum_to_string_GL(stream), (int)x)
    glatter_glVertexStream1iATI(stream, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream1iATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream1ivATI, (stream, coords), (GLenum stream, const GLint *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1ivATI_debug(GLenum stream, const GLint *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream1ivATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream1ivATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream1ivATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream1sATI, (stream, x), (GLenum stream, GLshort x))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1sATI_debug(GLenum stream, GLshort x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream1sATI, "(%s, %hi)", enum_to_string_GL(stream), (short)x)
    glatter_glVertexStream1sATI(stream, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream1sATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream1svATI, (stream, coords), (GLenum stream, const GLshort *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream1svATI_debug(GLenum stream, const GLshort *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream1svATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream1svATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream1svATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream2dATI, (stream, x, y), (GLenum stream, GLdouble x, GLdouble y))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2dATI_debug(GLenum stream, GLdouble x, GLdouble y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream2dATI, "(%s, %f, %f)", enum_to_string_GL(stream), (double)x, (double)y)
    glatter_glVertexStream2dATI(stream, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream2dATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream2dvATI, (stream, coords), (GLenum stream, const GLdouble *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2dvATI_debug(GLenum stream, const GLdouble *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream2dvATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream2dvATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream2dvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream2fATI, (stream, x, y), (GLenum stream, GLfloat x, GLfloat y))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2fATI_debug(GLenum stream, GLfloat x, GLfloat y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream2fATI, "(%s, %f, %f)", enum_to_string_GL(stream), (float)x, (float)y)
    glatter_glVertexStream2fATI(stream, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream2fATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream2fvATI, (stream, coords), (GLenum stream, const GLfloat *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2fvATI_debug(GLenum stream, const GLfloat *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream2fvATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream2fvATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream2fvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream2iATI, (stream, x, y), (GLenum stream, GLint x, GLint y))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2iATI_debug(GLenum stream, GLint x, GLint y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream2iATI, "(%s, %d, %d)", enum_to_string_GL(stream), (int)x, (int)y)
    glatter_glVertexStream2iATI(stream, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream2iATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream2ivATI, (stream, coords), (GLenum stream, const GLint *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2ivATI_debug(GLenum stream, const GLint *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream2ivATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream2ivATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream2ivATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream2sATI, (stream, x, y), (GLenum stream, GLshort x, GLshort y))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2sATI_debug(GLenum stream, GLshort x, GLshort y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream2sATI, "(%s, %hi, %hi)", enum_to_string_GL(stream), (short)x, (short)y)
    glatter_glVertexStream2sATI(stream, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream2sATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream2svATI, (stream, coords), (GLenum stream, const GLshort *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream2svATI_debug(GLenum stream, const GLshort *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream2svATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream2svATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream2svATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream3dATI, (stream, x, y, z), (GLenum stream, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3dATI_debug(GLenum stream, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream3dATI, "(%s, %f, %f, %f)", enum_to_string_GL(stream), (double)x, (double)y, (double)z)
    glatter_glVertexStream3dATI(stream, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream3dATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream3dvATI, (stream, coords), (GLenum stream, const GLdouble *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3dvATI_debug(GLenum stream, const GLdouble *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream3dvATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream3dvATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream3dvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream3fATI, (stream, x, y, z), (GLenum stream, GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3fATI_debug(GLenum stream, GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream3fATI, "(%s, %f, %f, %f)", enum_to_string_GL(stream), (float)x, (float)y, (float)z)
    glatter_glVertexStream3fATI(stream, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream3fATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream3fvATI, (stream, coords), (GLenum stream, const GLfloat *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3fvATI_debug(GLenum stream, const GLfloat *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream3fvATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream3fvATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream3fvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream3iATI, (stream, x, y, z), (GLenum stream, GLint x, GLint y, GLint z))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3iATI_debug(GLenum stream, GLint x, GLint y, GLint z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream3iATI, "(%s, %d, %d, %d)", enum_to_string_GL(stream), (int)x, (int)y, (int)z)
    glatter_glVertexStream3iATI(stream, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream3iATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream3ivATI, (stream, coords), (GLenum stream, const GLint *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3ivATI_debug(GLenum stream, const GLint *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream3ivATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream3ivATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream3ivATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream3sATI, (stream, x, y, z), (GLenum stream, GLshort x, GLshort y, GLshort z))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3sATI_debug(GLenum stream, GLshort x, GLshort y, GLshort z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream3sATI, "(%s, %hi, %hi, %hi)", enum_to_string_GL(stream), (short)x, (short)y, (short)z)
    glatter_glVertexStream3sATI(stream, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream3sATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream3svATI, (stream, coords), (GLenum stream, const GLshort *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream3svATI_debug(GLenum stream, const GLshort *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream3svATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream3svATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream3svATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream4dATI, (stream, x, y, z, w), (GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4dATI_debug(GLenum stream, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream4dATI, "(%s, %f, %f, %f, %f)", enum_to_string_GL(stream), (double)x, (double)y, (double)z, (double)w)
    glatter_glVertexStream4dATI(stream, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream4dATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream4dvATI, (stream, coords), (GLenum stream, const GLdouble *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4dvATI_debug(GLenum stream, const GLdouble *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream4dvATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream4dvATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream4dvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream4fATI, (stream, x, y, z, w), (GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4fATI_debug(GLenum stream, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream4fATI, "(%s, %f, %f, %f, %f)", enum_to_string_GL(stream), (float)x, (float)y, (float)z, (float)w)
    glatter_glVertexStream4fATI(stream, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream4fATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream4fvATI, (stream, coords), (GLenum stream, const GLfloat *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4fvATI_debug(GLenum stream, const GLfloat *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream4fvATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream4fvATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream4fvATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream4iATI, (stream, x, y, z, w), (GLenum stream, GLint x, GLint y, GLint z, GLint w))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4iATI_debug(GLenum stream, GLint x, GLint y, GLint z, GLint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream4iATI, "(%s, %d, %d, %d, %d)", enum_to_string_GL(stream), (int)x, (int)y, (int)z, (int)w)
    glatter_glVertexStream4iATI(stream, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream4iATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream4ivATI, (stream, coords), (GLenum stream, const GLint *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4ivATI_debug(GLenum stream, const GLint *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream4ivATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream4ivATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream4ivATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream4sATI, (stream, x, y, z, w), (GLenum stream, GLshort x, GLshort y, GLshort z, GLshort w))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4sATI_debug(GLenum stream, GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream4sATI, "(%s, %hi, %hi, %hi, %hi)", enum_to_string_GL(stream), (short)x, (short)y, (short)z, (short)w)
    glatter_glVertexStream4sATI(stream, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream4sATI_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexStream4svATI, (stream, coords), (GLenum stream, const GLshort *coords))
GLATTER_INLINE_OR_NOT void glatter_glVertexStream4svATI_debug(GLenum stream, const GLshort *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexStream4svATI, "(%s, %p)", enum_to_string_GL(stream), (void*)coords)
    glatter_glVertexStream4svATI(stream, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexStream4svATI_defined
#endif // defined(GL_ATI_vertex_streams)
#if defined(GL_EXT_EGL_image_storage)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEGLImageTargetTexStorageEXT, (target, image, attrib_list), (GLenum target, GLeglImageOES image, const GLint* attrib_list))
GLATTER_INLINE_OR_NOT void glatter_glEGLImageTargetTexStorageEXT_debug(GLenum target, GLeglImageOES image, const GLint* attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEGLImageTargetTexStorageEXT, "(%s, %p, %p)", enum_to_string_GL(target), (void*)image, (void*)attrib_list)
    glatter_glEGLImageTargetTexStorageEXT(target, image, attrib_list);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEGLImageTargetTexStorageEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEGLImageTargetTextureStorageEXT, (texture, image, attrib_list), (GLuint texture, GLeglImageOES image, const GLint* attrib_list))
GLATTER_INLINE_OR_NOT void glatter_glEGLImageTargetTextureStorageEXT_debug(GLuint texture, GLeglImageOES image, const GLint* attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEGLImageTargetTextureStorageEXT, "(%u, %p, %p)", (unsigned int)texture, (void*)image, (void*)attrib_list)
    glatter_glEGLImageTargetTextureStorageEXT(texture, image, attrib_list);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEGLImageTargetTextureStorageEXT_defined
#endif // defined(GL_EXT_EGL_image_storage)
#if defined(GL_EXT_bindable_uniform)
GLATTER_FBLOCK(return, GL, GLAPI, GLint, APIENTRY, glGetUniformBufferSizeEXT, (program, location), (GLuint program, GLint location))
GLATTER_INLINE_OR_NOT GLint glatter_glGetUniformBufferSizeEXT_debug(GLuint program, GLint location, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformBufferSizeEXT, "(%u, %d)", (unsigned int)program, (int)location)
    GLint rval = glatter_glGetUniformBufferSizeEXT(program, location);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetUniformBufferSizeEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLintptr, APIENTRY, glGetUniformOffsetEXT, (program, location), (GLuint program, GLint location))
GLATTER_INLINE_OR_NOT GLintptr glatter_glGetUniformOffsetEXT_debug(GLuint program, GLint location, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformOffsetEXT, "(%u, %d)", (unsigned int)program, (int)location)
    GLintptr rval = glatter_glGetUniformOffsetEXT(program, location);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetUniformOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniformBufferEXT, (program, location, buffer), (GLuint program, GLint location, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glUniformBufferEXT_debug(GLuint program, GLint location, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformBufferEXT, "(%u, %d, %u)", (unsigned int)program, (int)location, (unsigned int)buffer)
    glatter_glUniformBufferEXT(program, location, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformBufferEXT_defined
#endif // defined(GL_EXT_bindable_uniform)
#if defined(GL_EXT_blend_color)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendColorEXT, (red, green, blue, alpha), (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendColorEXT_debug(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendColorEXT, "(%f, %f, %f, %f)", (float)red, (float)green, (float)blue, (float)alpha)
    glatter_glBlendColorEXT(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendColorEXT_defined
#endif // defined(GL_EXT_blend_color)
#if defined(GL_EXT_blend_equation_separate)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendEquationSeparateEXT, (modeRGB, modeAlpha), (GLenum modeRGB, GLenum modeAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationSeparateEXT_debug(GLenum modeRGB, GLenum modeAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationSeparateEXT, "(%s, %s)", enum_to_string_GL(modeRGB), enum_to_string_GL(modeAlpha))
    glatter_glBlendEquationSeparateEXT(modeRGB, modeAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationSeparateEXT_defined
#endif // defined(GL_EXT_blend_equation_separate)
#if defined(GL_EXT_blend_func_separate)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendFuncSeparateEXT, (sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha), (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparateEXT_debug(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFuncSeparateEXT, "(%s, %s, %s, %s)", enum_to_string_GL(sfactorRGB), enum_to_string_GL(dfactorRGB), enum_to_string_GL(sfactorAlpha), enum_to_string_GL(dfactorAlpha))
    glatter_glBlendFuncSeparateEXT(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFuncSeparateEXT_defined
#endif // defined(GL_EXT_blend_func_separate)
#if defined(GL_EXT_blend_minmax)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendEquationEXT, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glBlendEquationEXT_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendEquationEXT, "(%s)", enum_to_string_GL(mode))
    glatter_glBlendEquationEXT(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendEquationEXT_defined
#endif // defined(GL_EXT_blend_minmax)
#if defined(GL_EXT_color_subtable)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorSubTableEXT, (target, start, count, format, type, data), (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glColorSubTableEXT_debug(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorSubTableEXT, "(%s, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)start, (int)count, enum_to_string_GL(format), enum_to_string_GL(type), (void*)data)
    glatter_glColorSubTableEXT(target, start, count, format, type, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorSubTableEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyColorSubTableEXT, (target, start, x, y, width), (GLenum target, GLsizei start, GLint x, GLint y, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glCopyColorSubTableEXT_debug(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyColorSubTableEXT, "(%s, %d, %d, %d, %d)", enum_to_string_GL(target), (int)start, (int)x, (int)y, (int)width)
    glatter_glCopyColorSubTableEXT(target, start, x, y, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyColorSubTableEXT_defined
#endif // defined(GL_EXT_color_subtable)
#if defined(GL_EXT_compiled_vertex_array)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glLockArraysEXT, (first, count), (GLint first, GLsizei count))
GLATTER_INLINE_OR_NOT void glatter_glLockArraysEXT_debug(GLint first, GLsizei count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLockArraysEXT, "(%d, %d)", (int)first, (int)count)
    glatter_glLockArraysEXT(first, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLockArraysEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUnlockArraysEXT, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glUnlockArraysEXT_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUnlockArraysEXT, "()")
    glatter_glUnlockArraysEXT();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUnlockArraysEXT_defined
#endif // defined(GL_EXT_compiled_vertex_array)
#if defined(GL_EXT_convolution)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionFilter1DEXT, (target, internalformat, width, format, type, image), (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionFilter1DEXT_debug(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const void *image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionFilter1DEXT, "(%s, %s, %d, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)width, enum_to_string_GL(format), enum_to_string_GL(type), (void*)image)
    glatter_glConvolutionFilter1DEXT(target, internalformat, width, format, type, image);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionFilter1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionFilter2DEXT, (target, internalformat, width, height, format, type, image), (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionFilter2DEXT_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionFilter2DEXT, "(%s, %s, %d, %d, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)image)
    glatter_glConvolutionFilter2DEXT(target, internalformat, width, height, format, type, image);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionFilter2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionParameterfEXT, (target, pname, params), (GLenum target, GLenum pname, GLfloat params))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterfEXT_debug(GLenum target, GLenum pname, GLfloat params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionParameterfEXT, "(%s, %s, %f)", enum_to_string_GL(target), enum_to_string_GL(pname), (float)params)
    glatter_glConvolutionParameterfEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionParameterfEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionParameterfvEXT, (target, pname, params), (GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterfvEXT_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionParameterfvEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glConvolutionParameterfvEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionParameteriEXT, (target, pname, params), (GLenum target, GLenum pname, GLint params))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameteriEXT_debug(GLenum target, GLenum pname, GLint params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionParameteriEXT, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)params)
    glatter_glConvolutionParameteriEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionParameteriEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConvolutionParameterivEXT, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glConvolutionParameterivEXT_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConvolutionParameterivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glConvolutionParameterivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConvolutionParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyConvolutionFilter1DEXT, (target, internalformat, x, y, width), (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glCopyConvolutionFilter1DEXT_debug(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyConvolutionFilter1DEXT, "(%s, %s, %d, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)x, (int)y, (int)width)
    glatter_glCopyConvolutionFilter1DEXT(target, internalformat, x, y, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyConvolutionFilter1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyConvolutionFilter2DEXT, (target, internalformat, x, y, width, height), (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyConvolutionFilter2DEXT_debug(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyConvolutionFilter2DEXT, "(%s, %s, %d, %d, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyConvolutionFilter2DEXT(target, internalformat, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyConvolutionFilter2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetConvolutionFilterEXT, (target, format, type, image), (GLenum target, GLenum format, GLenum type, void *image))
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionFilterEXT_debug(GLenum target, GLenum format, GLenum type, void *image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetConvolutionFilterEXT, "(%s, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(format), enum_to_string_GL(type), (void*)image)
    glatter_glGetConvolutionFilterEXT(target, format, type, image);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetConvolutionFilterEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetConvolutionParameterfvEXT, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionParameterfvEXT_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetConvolutionParameterfvEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetConvolutionParameterfvEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetConvolutionParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetConvolutionParameterivEXT, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetConvolutionParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetConvolutionParameterivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetConvolutionParameterivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetConvolutionParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetSeparableFilterEXT, (target, format, type, row, column, span), (GLenum target, GLenum format, GLenum type, void *row, void *column, void *span))
GLATTER_INLINE_OR_NOT void glatter_glGetSeparableFilterEXT_debug(GLenum target, GLenum format, GLenum type, void *row, void *column, void *span, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSeparableFilterEXT, "(%s, %s, %s, %p, %p, %p)", enum_to_string_GL(target), enum_to_string_GL(format), enum_to_string_GL(type), (void*)row, (void*)column, (void*)span)
    glatter_glGetSeparableFilterEXT(target, format, type, row, column, span);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSeparableFilterEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSeparableFilter2DEXT, (target, internalformat, width, height, format, type, row, column), (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column))
GLATTER_INLINE_OR_NOT void glatter_glSeparableFilter2DEXT_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *row, const void *column, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSeparableFilter2DEXT, "(%s, %s, %d, %d, %s, %s, %p, %p)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)row, (void*)column)
    glatter_glSeparableFilter2DEXT(target, internalformat, width, height, format, type, row, column);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSeparableFilter2DEXT_defined
#endif // defined(GL_EXT_convolution)
#if defined(GL_EXT_coordinate_frame)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBinormal3bEXT, (bx, by, bz), (GLbyte bx, GLbyte by, GLbyte bz))
GLATTER_INLINE_OR_NOT void glatter_glBinormal3bEXT_debug(GLbyte bx, GLbyte by, GLbyte bz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBinormal3bEXT, "(%d, %d, %d)", (signed char)bx, (signed char)by, (signed char)bz)
    glatter_glBinormal3bEXT(bx, by, bz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBinormal3bEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBinormal3bvEXT, (v), (const GLbyte *v))
GLATTER_INLINE_OR_NOT void glatter_glBinormal3bvEXT_debug(const GLbyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBinormal3bvEXT, "(%p)", (void*)v)
    glatter_glBinormal3bvEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBinormal3bvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBinormal3dEXT, (bx, by, bz), (GLdouble bx, GLdouble by, GLdouble bz))
GLATTER_INLINE_OR_NOT void glatter_glBinormal3dEXT_debug(GLdouble bx, GLdouble by, GLdouble bz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBinormal3dEXT, "(%f, %f, %f)", (double)bx, (double)by, (double)bz)
    glatter_glBinormal3dEXT(bx, by, bz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBinormal3dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBinormal3dvEXT, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glBinormal3dvEXT_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBinormal3dvEXT, "(%p)", (void*)v)
    glatter_glBinormal3dvEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBinormal3dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBinormal3fEXT, (bx, by, bz), (GLfloat bx, GLfloat by, GLfloat bz))
GLATTER_INLINE_OR_NOT void glatter_glBinormal3fEXT_debug(GLfloat bx, GLfloat by, GLfloat bz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBinormal3fEXT, "(%f, %f, %f)", (float)bx, (float)by, (float)bz)
    glatter_glBinormal3fEXT(bx, by, bz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBinormal3fEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBinormal3fvEXT, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glBinormal3fvEXT_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBinormal3fvEXT, "(%p)", (void*)v)
    glatter_glBinormal3fvEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBinormal3fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBinormal3iEXT, (bx, by, bz), (GLint bx, GLint by, GLint bz))
GLATTER_INLINE_OR_NOT void glatter_glBinormal3iEXT_debug(GLint bx, GLint by, GLint bz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBinormal3iEXT, "(%d, %d, %d)", (int)bx, (int)by, (int)bz)
    glatter_glBinormal3iEXT(bx, by, bz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBinormal3iEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBinormal3ivEXT, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glBinormal3ivEXT_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBinormal3ivEXT, "(%p)", (void*)v)
    glatter_glBinormal3ivEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBinormal3ivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBinormal3sEXT, (bx, by, bz), (GLshort bx, GLshort by, GLshort bz))
GLATTER_INLINE_OR_NOT void glatter_glBinormal3sEXT_debug(GLshort bx, GLshort by, GLshort bz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBinormal3sEXT, "(%hi, %hi, %hi)", (short)bx, (short)by, (short)bz)
    glatter_glBinormal3sEXT(bx, by, bz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBinormal3sEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBinormal3svEXT, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glBinormal3svEXT_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBinormal3svEXT, "(%p)", (void*)v)
    glatter_glBinormal3svEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBinormal3svEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBinormalPointerEXT, (type, stride, pointer), (GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glBinormalPointerEXT_debug(GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBinormalPointerEXT, "(%s, %d, %p)", enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glBinormalPointerEXT(type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBinormalPointerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTangent3bEXT, (tx, ty, tz), (GLbyte tx, GLbyte ty, GLbyte tz))
GLATTER_INLINE_OR_NOT void glatter_glTangent3bEXT_debug(GLbyte tx, GLbyte ty, GLbyte tz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTangent3bEXT, "(%d, %d, %d)", (signed char)tx, (signed char)ty, (signed char)tz)
    glatter_glTangent3bEXT(tx, ty, tz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTangent3bEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTangent3bvEXT, (v), (const GLbyte *v))
GLATTER_INLINE_OR_NOT void glatter_glTangent3bvEXT_debug(const GLbyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTangent3bvEXT, "(%p)", (void*)v)
    glatter_glTangent3bvEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTangent3bvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTangent3dEXT, (tx, ty, tz), (GLdouble tx, GLdouble ty, GLdouble tz))
GLATTER_INLINE_OR_NOT void glatter_glTangent3dEXT_debug(GLdouble tx, GLdouble ty, GLdouble tz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTangent3dEXT, "(%f, %f, %f)", (double)tx, (double)ty, (double)tz)
    glatter_glTangent3dEXT(tx, ty, tz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTangent3dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTangent3dvEXT, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glTangent3dvEXT_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTangent3dvEXT, "(%p)", (void*)v)
    glatter_glTangent3dvEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTangent3dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTangent3fEXT, (tx, ty, tz), (GLfloat tx, GLfloat ty, GLfloat tz))
GLATTER_INLINE_OR_NOT void glatter_glTangent3fEXT_debug(GLfloat tx, GLfloat ty, GLfloat tz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTangent3fEXT, "(%f, %f, %f)", (float)tx, (float)ty, (float)tz)
    glatter_glTangent3fEXT(tx, ty, tz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTangent3fEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTangent3fvEXT, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glTangent3fvEXT_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTangent3fvEXT, "(%p)", (void*)v)
    glatter_glTangent3fvEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTangent3fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTangent3iEXT, (tx, ty, tz), (GLint tx, GLint ty, GLint tz))
GLATTER_INLINE_OR_NOT void glatter_glTangent3iEXT_debug(GLint tx, GLint ty, GLint tz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTangent3iEXT, "(%d, %d, %d)", (int)tx, (int)ty, (int)tz)
    glatter_glTangent3iEXT(tx, ty, tz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTangent3iEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTangent3ivEXT, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glTangent3ivEXT_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTangent3ivEXT, "(%p)", (void*)v)
    glatter_glTangent3ivEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTangent3ivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTangent3sEXT, (tx, ty, tz), (GLshort tx, GLshort ty, GLshort tz))
GLATTER_INLINE_OR_NOT void glatter_glTangent3sEXT_debug(GLshort tx, GLshort ty, GLshort tz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTangent3sEXT, "(%hi, %hi, %hi)", (short)tx, (short)ty, (short)tz)
    glatter_glTangent3sEXT(tx, ty, tz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTangent3sEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTangent3svEXT, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glTangent3svEXT_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTangent3svEXT, "(%p)", (void*)v)
    glatter_glTangent3svEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTangent3svEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTangentPointerEXT, (type, stride, pointer), (GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glTangentPointerEXT_debug(GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTangentPointerEXT, "(%s, %d, %p)", enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glTangentPointerEXT(type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTangentPointerEXT_defined
#endif // defined(GL_EXT_coordinate_frame)
#if defined(GL_EXT_copy_texture)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyTexImage1DEXT, (target, level, internalformat, x, y, width, border), (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexImage1DEXT_debug(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexImage1DEXT, "(%s, %d, %s, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)x, (int)y, (int)width, (int)border)
    glatter_glCopyTexImage1DEXT(target, level, internalformat, x, y, width, border);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyTexImage2DEXT, (target, level, internalformat, x, y, width, height, border), (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexImage2DEXT_debug(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexImage2DEXT, "(%s, %d, %s, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)x, (int)y, (int)width, (int)height, (int)border)
    glatter_glCopyTexImage2DEXT(target, level, internalformat, x, y, width, height, border);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyTexSubImage1DEXT, (target, level, xoffset, x, y, width), (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage1DEXT_debug(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexSubImage1DEXT, "(%s, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)x, (int)y, (int)width)
    glatter_glCopyTexSubImage1DEXT(target, level, xoffset, x, y, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexSubImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyTexSubImage2DEXT, (target, level, xoffset, yoffset, x, y, width, height), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage2DEXT_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexSubImage2DEXT, "(%s, %d, %d, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyTexSubImage2DEXT(target, level, xoffset, yoffset, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexSubImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyTexSubImage3DEXT, (target, level, xoffset, yoffset, zoffset, x, y, width, height), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyTexSubImage3DEXT_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTexSubImage3DEXT, "(%s, %d, %d, %d, %d, %d, %d, %d, %d)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyTexSubImage3DEXT(target, level, xoffset, yoffset, zoffset, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTexSubImage3DEXT_defined
#endif // defined(GL_EXT_copy_texture)
#if defined(GL_EXT_cull_vertex)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCullParameterdvEXT, (pname, params), (GLenum pname, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glCullParameterdvEXT_debug(GLenum pname, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCullParameterdvEXT, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glCullParameterdvEXT(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCullParameterdvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCullParameterfvEXT, (pname, params), (GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glCullParameterfvEXT_debug(GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCullParameterfvEXT, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glCullParameterfvEXT(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCullParameterfvEXT_defined
#endif // defined(GL_EXT_cull_vertex)
#if defined(GL_EXT_debug_label)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetObjectLabelEXT, (type, object, bufSize, length, label), (GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glGetObjectLabelEXT_debug(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetObjectLabelEXT, "(%s, %u, %d, %p, %p)", enum_to_string_GL(type), (unsigned int)object, (int)bufSize, (void*)length, (void*)label)
    glatter_glGetObjectLabelEXT(type, object, bufSize, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetObjectLabelEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glLabelObjectEXT, (type, object, length, label), (GLenum type, GLuint object, GLsizei length, const GLchar *label))
GLATTER_INLINE_OR_NOT void glatter_glLabelObjectEXT_debug(GLenum type, GLuint object, GLsizei length, const GLchar *label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLabelObjectEXT, "(%s, %u, %d, %p)", enum_to_string_GL(type), (unsigned int)object, (int)length, (void*)label)
    glatter_glLabelObjectEXT(type, object, length, label);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLabelObjectEXT_defined
#endif // defined(GL_EXT_debug_label)
#if defined(GL_EXT_debug_marker)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glInsertEventMarkerEXT, (length, marker), (GLsizei length, const GLchar *marker))
GLATTER_INLINE_OR_NOT void glatter_glInsertEventMarkerEXT_debug(GLsizei length, const GLchar *marker, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glInsertEventMarkerEXT, "(%d, %p)", (int)length, (void*)marker)
    glatter_glInsertEventMarkerEXT(length, marker);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glInsertEventMarkerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPopGroupMarkerEXT, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPopGroupMarkerEXT_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPopGroupMarkerEXT, "()")
    glatter_glPopGroupMarkerEXT();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPopGroupMarkerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPushGroupMarkerEXT, (length, marker), (GLsizei length, const GLchar *marker))
GLATTER_INLINE_OR_NOT void glatter_glPushGroupMarkerEXT_debug(GLsizei length, const GLchar *marker, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPushGroupMarkerEXT, "(%d, %p)", (int)length, (void*)marker)
    glatter_glPushGroupMarkerEXT(length, marker);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPushGroupMarkerEXT_defined
#endif // defined(GL_EXT_debug_marker)
#if defined(GL_EXT_depth_bounds_test)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDepthBoundsEXT, (zmin, zmax), (GLclampd zmin, GLclampd zmax))
GLATTER_INLINE_OR_NOT void glatter_glDepthBoundsEXT_debug(GLclampd zmin, GLclampd zmax, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthBoundsEXT, "(%f, %f)", (double)zmin, (double)zmax)
    glatter_glDepthBoundsEXT(zmin, zmax);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthBoundsEXT_defined
#endif // defined(GL_EXT_depth_bounds_test)
#if defined(GL_EXT_direct_state_access)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindMultiTextureEXT, (texunit, target, texture), (GLenum texunit, GLenum target, GLuint texture))
GLATTER_INLINE_OR_NOT void glatter_glBindMultiTextureEXT_debug(GLenum texunit, GLenum target, GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindMultiTextureEXT, "(%s, %s, %u)", enum_to_string_GL(texunit), enum_to_string_GL(target), (unsigned int)texture)
    glatter_glBindMultiTextureEXT(texunit, target, texture);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindMultiTextureEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLenum, APIENTRY, glCheckNamedFramebufferStatusEXT, (framebuffer, target), (GLuint framebuffer, GLenum target))
GLATTER_INLINE_OR_NOT GLenum glatter_glCheckNamedFramebufferStatusEXT_debug(GLuint framebuffer, GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCheckNamedFramebufferStatusEXT, "(%u, %s)", (unsigned int)framebuffer, enum_to_string_GL(target))
    GLenum rval = glatter_glCheckNamedFramebufferStatusEXT(framebuffer, target);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCheckNamedFramebufferStatusEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glClearNamedBufferDataEXT, (buffer, internalformat, format, type, data), (GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glClearNamedBufferDataEXT_debug(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearNamedBufferDataEXT, "(%u, %s, %s, %s, %p)", (unsigned int)buffer, enum_to_string_GL(internalformat), enum_to_string_GL(format), enum_to_string_GL(type), (void*)data)
    glatter_glClearNamedBufferDataEXT(buffer, internalformat, format, type, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearNamedBufferDataEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glClearNamedBufferSubDataEXT, (buffer, internalformat, offset, size, format, type, data), (GLuint buffer, GLenum internalformat, GLsizeiptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glClearNamedBufferSubDataEXT_debug(GLuint buffer, GLenum internalformat, GLsizeiptr offset, GLsizeiptr size, GLenum format, GLenum type, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearNamedBufferSubDataEXT, "(%u, %s, %s, %s, %s, %s, %p)", (unsigned int)buffer, enum_to_string_GL(internalformat), GET_PRS(offset), GET_PRS(size), enum_to_string_GL(format), enum_to_string_GL(type), (void*)data)
    glatter_glClearNamedBufferSubDataEXT(buffer, internalformat, offset, size, format, type, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearNamedBufferSubDataEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glClientAttribDefaultEXT, (mask), (GLbitfield mask))
GLATTER_INLINE_OR_NOT void glatter_glClientAttribDefaultEXT_debug(GLbitfield mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClientAttribDefaultEXT, "(%u)", (unsigned int)mask)
    glatter_glClientAttribDefaultEXT(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClientAttribDefaultEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedMultiTexImage1DEXT, (texunit, target, level, internalformat, width, border, imageSize, bits), (GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedMultiTexImage1DEXT, "(%s, %s, %d, %s, %d, %d, %d, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)border, (int)imageSize, (void*)bits)
    glatter_glCompressedMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedMultiTexImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedMultiTexImage2DEXT, (texunit, target, level, internalformat, width, height, border, imageSize, bits), (GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedMultiTexImage2DEXT, "(%s, %s, %d, %s, %d, %d, %d, %d, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)border, (int)imageSize, (void*)bits)
    glatter_glCompressedMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedMultiTexImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedMultiTexImage3DEXT, (texunit, target, level, internalformat, width, height, depth, border, imageSize, bits), (GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexImage3DEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedMultiTexImage3DEXT, "(%s, %s, %d, %s, %d, %d, %d, %d, %d, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth, (int)border, (int)imageSize, (void*)bits)
    glatter_glCompressedMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedMultiTexImage3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedMultiTexSubImage1DEXT, (texunit, target, level, xoffset, width, format, imageSize, bits), (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexSubImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedMultiTexSubImage1DEXT, "(%s, %s, %d, %d, %d, %s, %d, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)xoffset, (int)width, enum_to_string_GL(format), (int)imageSize, (void*)bits)
    glatter_glCompressedMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedMultiTexSubImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedMultiTexSubImage2DEXT, (texunit, target, level, xoffset, yoffset, width, height, format, imageSize, bits), (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexSubImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedMultiTexSubImage2DEXT, "(%s, %s, %d, %d, %d, %d, %d, %s, %d, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, enum_to_string_GL(format), (int)imageSize, (void*)bits)
    glatter_glCompressedMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedMultiTexSubImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedMultiTexSubImage3DEXT, (texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, bits), (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedMultiTexSubImage3DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedMultiTexSubImage3DEXT, "(%s, %s, %d, %d, %d, %d, %d, %d, %d, %s, %d, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), (int)imageSize, (void*)bits)
    glatter_glCompressedMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedMultiTexSubImage3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTextureImage1DEXT, (texture, target, level, internalformat, width, border, imageSize, bits), (GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTextureImage1DEXT, "(%u, %s, %d, %s, %d, %d, %d, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)border, (int)imageSize, (void*)bits)
    glatter_glCompressedTextureImage1DEXT(texture, target, level, internalformat, width, border, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTextureImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTextureImage2DEXT, (texture, target, level, internalformat, width, height, border, imageSize, bits), (GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTextureImage2DEXT, "(%u, %s, %d, %s, %d, %d, %d, %d, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)border, (int)imageSize, (void*)bits)
    glatter_glCompressedTextureImage2DEXT(texture, target, level, internalformat, width, height, border, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTextureImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTextureImage3DEXT, (texture, target, level, internalformat, width, height, depth, border, imageSize, bits), (GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureImage3DEXT_debug(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTextureImage3DEXT, "(%u, %s, %d, %s, %d, %d, %d, %d, %d, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth, (int)border, (int)imageSize, (void*)bits)
    glatter_glCompressedTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTextureImage3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTextureSubImage1DEXT, (texture, target, level, xoffset, width, format, imageSize, bits), (GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureSubImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTextureSubImage1DEXT, "(%u, %s, %d, %d, %d, %s, %d, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)xoffset, (int)width, enum_to_string_GL(format), (int)imageSize, (void*)bits)
    glatter_glCompressedTextureSubImage1DEXT(texture, target, level, xoffset, width, format, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTextureSubImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTextureSubImage2DEXT, (texture, target, level, xoffset, yoffset, width, height, format, imageSize, bits), (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureSubImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTextureSubImage2DEXT, "(%u, %s, %d, %d, %d, %d, %d, %s, %d, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, enum_to_string_GL(format), (int)imageSize, (void*)bits)
    glatter_glCompressedTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTextureSubImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompressedTextureSubImage3DEXT, (texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, bits), (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits))
GLATTER_INLINE_OR_NOT void glatter_glCompressedTextureSubImage3DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const void *bits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompressedTextureSubImage3DEXT, "(%u, %s, %d, %d, %d, %d, %d, %d, %d, %s, %d, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), (int)imageSize, (void*)bits)
    glatter_glCompressedTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, bits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompressedTextureSubImage3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyMultiTexImage1DEXT, (texunit, target, level, internalformat, x, y, width, border), (GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border))
GLATTER_INLINE_OR_NOT void glatter_glCopyMultiTexImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyMultiTexImage1DEXT, "(%s, %s, %d, %s, %d, %d, %d, %d)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)x, (int)y, (int)width, (int)border)
    glatter_glCopyMultiTexImage1DEXT(texunit, target, level, internalformat, x, y, width, border);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyMultiTexImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyMultiTexImage2DEXT, (texunit, target, level, internalformat, x, y, width, height, border), (GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
GLATTER_INLINE_OR_NOT void glatter_glCopyMultiTexImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyMultiTexImage2DEXT, "(%s, %s, %d, %s, %d, %d, %d, %d, %d)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)x, (int)y, (int)width, (int)height, (int)border)
    glatter_glCopyMultiTexImage2DEXT(texunit, target, level, internalformat, x, y, width, height, border);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyMultiTexImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyMultiTexSubImage1DEXT, (texunit, target, level, xoffset, x, y, width), (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glCopyMultiTexSubImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyMultiTexSubImage1DEXT, "(%s, %s, %d, %d, %d, %d, %d)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)xoffset, (int)x, (int)y, (int)width)
    glatter_glCopyMultiTexSubImage1DEXT(texunit, target, level, xoffset, x, y, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyMultiTexSubImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyMultiTexSubImage2DEXT, (texunit, target, level, xoffset, yoffset, x, y, width, height), (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyMultiTexSubImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyMultiTexSubImage2DEXT, "(%s, %s, %d, %d, %d, %d, %d, %d, %d)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyMultiTexSubImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyMultiTexSubImage3DEXT, (texunit, target, level, xoffset, yoffset, zoffset, x, y, width, height), (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyMultiTexSubImage3DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyMultiTexSubImage3DEXT, "(%s, %s, %d, %d, %d, %d, %d, %d, %d, %d)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyMultiTexSubImage3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyTextureImage1DEXT, (texture, target, level, internalformat, x, y, width, border), (GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border))
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTextureImage1DEXT, "(%u, %s, %d, %s, %d, %d, %d, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)x, (int)y, (int)width, (int)border)
    glatter_glCopyTextureImage1DEXT(texture, target, level, internalformat, x, y, width, border);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTextureImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyTextureImage2DEXT, (texture, target, level, internalformat, x, y, width, height, border), (GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTextureImage2DEXT, "(%u, %s, %d, %s, %d, %d, %d, %d, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)x, (int)y, (int)width, (int)height, (int)border)
    glatter_glCopyTextureImage2DEXT(texture, target, level, internalformat, x, y, width, height, border);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTextureImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyTextureSubImage1DEXT, (texture, target, level, xoffset, x, y, width), (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureSubImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTextureSubImage1DEXT, "(%u, %s, %d, %d, %d, %d, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)xoffset, (int)x, (int)y, (int)width)
    glatter_glCopyTextureSubImage1DEXT(texture, target, level, xoffset, x, y, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTextureSubImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyTextureSubImage2DEXT, (texture, target, level, xoffset, yoffset, x, y, width, height), (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureSubImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTextureSubImage2DEXT, "(%u, %s, %d, %d, %d, %d, %d, %d, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTextureSubImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyTextureSubImage3DEXT, (texture, target, level, xoffset, yoffset, zoffset, x, y, width, height), (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glCopyTextureSubImage3DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyTextureSubImage3DEXT, "(%u, %s, %d, %d, %d, %d, %d, %d, %d, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)x, (int)y, (int)width, (int)height)
    glatter_glCopyTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, x, y, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyTextureSubImage3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDisableClientStateIndexedEXT, (array, index), (GLenum array, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glDisableClientStateIndexedEXT_debug(GLenum array, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableClientStateIndexedEXT, "(%s, %u)", enum_to_string_GL(array), (unsigned int)index)
    glatter_glDisableClientStateIndexedEXT(array, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableClientStateIndexedEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDisableClientStateiEXT, (array, index), (GLenum array, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glDisableClientStateiEXT_debug(GLenum array, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableClientStateiEXT, "(%s, %u)", enum_to_string_GL(array), (unsigned int)index)
    glatter_glDisableClientStateiEXT(array, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableClientStateiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDisableIndexedEXT, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glDisableIndexedEXT_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableIndexedEXT, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    glatter_glDisableIndexedEXT(target, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableIndexedEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDisableVertexArrayAttribEXT, (vaobj, index), (GLuint vaobj, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glDisableVertexArrayAttribEXT_debug(GLuint vaobj, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableVertexArrayAttribEXT, "(%u, %u)", (unsigned int)vaobj, (unsigned int)index)
    glatter_glDisableVertexArrayAttribEXT(vaobj, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableVertexArrayAttribEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDisableVertexArrayEXT, (vaobj, array), (GLuint vaobj, GLenum array))
GLATTER_INLINE_OR_NOT void glatter_glDisableVertexArrayEXT_debug(GLuint vaobj, GLenum array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableVertexArrayEXT, "(%u, %s)", (unsigned int)vaobj, enum_to_string_GL(array))
    glatter_glDisableVertexArrayEXT(vaobj, array);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableVertexArrayEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEnableClientStateIndexedEXT, (array, index), (GLenum array, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glEnableClientStateIndexedEXT_debug(GLenum array, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableClientStateIndexedEXT, "(%s, %u)", enum_to_string_GL(array), (unsigned int)index)
    glatter_glEnableClientStateIndexedEXT(array, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableClientStateIndexedEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEnableClientStateiEXT, (array, index), (GLenum array, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glEnableClientStateiEXT_debug(GLenum array, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableClientStateiEXT, "(%s, %u)", enum_to_string_GL(array), (unsigned int)index)
    glatter_glEnableClientStateiEXT(array, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableClientStateiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEnableIndexedEXT, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glEnableIndexedEXT_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableIndexedEXT, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    glatter_glEnableIndexedEXT(target, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableIndexedEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEnableVertexArrayAttribEXT, (vaobj, index), (GLuint vaobj, GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glEnableVertexArrayAttribEXT_debug(GLuint vaobj, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableVertexArrayAttribEXT, "(%u, %u)", (unsigned int)vaobj, (unsigned int)index)
    glatter_glEnableVertexArrayAttribEXT(vaobj, index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableVertexArrayAttribEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEnableVertexArrayEXT, (vaobj, array), (GLuint vaobj, GLenum array))
GLATTER_INLINE_OR_NOT void glatter_glEnableVertexArrayEXT_debug(GLuint vaobj, GLenum array, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableVertexArrayEXT, "(%u, %s)", (unsigned int)vaobj, enum_to_string_GL(array))
    glatter_glEnableVertexArrayEXT(vaobj, array);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableVertexArrayEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFlushMappedNamedBufferRangeEXT, (buffer, offset, length), (GLuint buffer, GLintptr offset, GLsizeiptr length))
GLATTER_INLINE_OR_NOT void glatter_glFlushMappedNamedBufferRangeEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr length, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFlushMappedNamedBufferRangeEXT, "(%u, %s, %s)", (unsigned int)buffer, GET_PRS(offset), GET_PRS(length))
    glatter_glFlushMappedNamedBufferRangeEXT(buffer, offset, length);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFlushMappedNamedBufferRangeEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferDrawBufferEXT, (framebuffer, mode), (GLuint framebuffer, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferDrawBufferEXT_debug(GLuint framebuffer, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferDrawBufferEXT, "(%u, %s)", (unsigned int)framebuffer, enum_to_string_GL(mode))
    glatter_glFramebufferDrawBufferEXT(framebuffer, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferDrawBufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferDrawBuffersEXT, (framebuffer, n, bufs), (GLuint framebuffer, GLsizei n, const GLenum *bufs))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferDrawBuffersEXT_debug(GLuint framebuffer, GLsizei n, const GLenum *bufs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferDrawBuffersEXT, "(%u, %d, %p)", (unsigned int)framebuffer, (int)n, (void*)bufs)
    glatter_glFramebufferDrawBuffersEXT(framebuffer, n, bufs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferDrawBuffersEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferReadBufferEXT, (framebuffer, mode), (GLuint framebuffer, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferReadBufferEXT_debug(GLuint framebuffer, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferReadBufferEXT, "(%u, %s)", (unsigned int)framebuffer, enum_to_string_GL(mode))
    glatter_glFramebufferReadBufferEXT(framebuffer, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferReadBufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenerateMultiTexMipmapEXT, (texunit, target), (GLenum texunit, GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glGenerateMultiTexMipmapEXT_debug(GLenum texunit, GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenerateMultiTexMipmapEXT, "(%s, %s)", enum_to_string_GL(texunit), enum_to_string_GL(target))
    glatter_glGenerateMultiTexMipmapEXT(texunit, target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenerateMultiTexMipmapEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenerateTextureMipmapEXT, (texture, target), (GLuint texture, GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glGenerateTextureMipmapEXT_debug(GLuint texture, GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenerateTextureMipmapEXT, "(%u, %s)", (unsigned int)texture, enum_to_string_GL(target))
    glatter_glGenerateTextureMipmapEXT(texture, target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenerateTextureMipmapEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetBooleanIndexedvEXT, (target, index, data), (GLenum target, GLuint index, GLboolean *data))
GLATTER_INLINE_OR_NOT void glatter_glGetBooleanIndexedvEXT_debug(GLenum target, GLuint index, GLboolean *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetBooleanIndexedvEXT, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetBooleanIndexedvEXT(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetBooleanIndexedvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetCompressedMultiTexImageEXT, (texunit, target, lod, img), (GLenum texunit, GLenum target, GLint lod, void *img))
GLATTER_INLINE_OR_NOT void glatter_glGetCompressedMultiTexImageEXT_debug(GLenum texunit, GLenum target, GLint lod, void *img, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetCompressedMultiTexImageEXT, "(%s, %s, %d, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)lod, (void*)img)
    glatter_glGetCompressedMultiTexImageEXT(texunit, target, lod, img);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetCompressedMultiTexImageEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetCompressedTextureImageEXT, (texture, target, lod, img), (GLuint texture, GLenum target, GLint lod, void *img))
GLATTER_INLINE_OR_NOT void glatter_glGetCompressedTextureImageEXT_debug(GLuint texture, GLenum target, GLint lod, void *img, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetCompressedTextureImageEXT, "(%u, %s, %d, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)lod, (void*)img)
    glatter_glGetCompressedTextureImageEXT(texture, target, lod, img);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetCompressedTextureImageEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetDoubleIndexedvEXT, (target, index, data), (GLenum target, GLuint index, GLdouble *data))
GLATTER_INLINE_OR_NOT void glatter_glGetDoubleIndexedvEXT_debug(GLenum target, GLuint index, GLdouble *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetDoubleIndexedvEXT, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetDoubleIndexedvEXT(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetDoubleIndexedvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetDoublei_vEXT, (pname, index, params), (GLenum pname, GLuint index, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glGetDoublei_vEXT_debug(GLenum pname, GLuint index, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetDoublei_vEXT, "(%s, %u, %p)", enum_to_string_GL(pname), (unsigned int)index, (void*)params)
    glatter_glGetDoublei_vEXT(pname, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetDoublei_vEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetFloatIndexedvEXT, (target, index, data), (GLenum target, GLuint index, GLfloat *data))
GLATTER_INLINE_OR_NOT void glatter_glGetFloatIndexedvEXT_debug(GLenum target, GLuint index, GLfloat *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFloatIndexedvEXT, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetFloatIndexedvEXT(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFloatIndexedvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetFloati_vEXT, (pname, index, params), (GLenum pname, GLuint index, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFloati_vEXT_debug(GLenum pname, GLuint index, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFloati_vEXT, "(%s, %u, %p)", enum_to_string_GL(pname), (unsigned int)index, (void*)params)
    glatter_glGetFloati_vEXT(pname, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFloati_vEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetFramebufferParameterivEXT, (framebuffer, pname, params), (GLuint framebuffer, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFramebufferParameterivEXT_debug(GLuint framebuffer, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFramebufferParameterivEXT, "(%u, %s, %p)", (unsigned int)framebuffer, enum_to_string_GL(pname), (void*)params)
    glatter_glGetFramebufferParameterivEXT(framebuffer, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFramebufferParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetIntegerIndexedvEXT, (target, index, data), (GLenum target, GLuint index, GLint *data))
GLATTER_INLINE_OR_NOT void glatter_glGetIntegerIndexedvEXT_debug(GLenum target, GLuint index, GLint *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetIntegerIndexedvEXT, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetIntegerIndexedvEXT(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetIntegerIndexedvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexEnvfvEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexEnvfvEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexEnvfvEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMultiTexEnvfvEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexEnvfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexEnvivEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexEnvivEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexEnvivEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMultiTexEnvivEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexEnvivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexGendvEXT, (texunit, coord, pname, params), (GLenum texunit, GLenum coord, GLenum pname, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexGendvEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexGendvEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMultiTexGendvEXT(texunit, coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexGendvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexGenfvEXT, (texunit, coord, pname, params), (GLenum texunit, GLenum coord, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexGenfvEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexGenfvEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMultiTexGenfvEXT(texunit, coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexGenfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexGenivEXT, (texunit, coord, pname, params), (GLenum texunit, GLenum coord, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexGenivEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexGenivEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMultiTexGenivEXT(texunit, coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexGenivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexImageEXT, (texunit, target, level, format, type, pixels), (GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexImageEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexImageEXT, "(%s, %s, %d, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glGetMultiTexImageEXT(texunit, target, level, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexImageEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexLevelParameterfvEXT, (texunit, target, level, pname, params), (GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexLevelParameterfvEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexLevelParameterfvEXT, "(%s, %s, %d, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, enum_to_string_GL(pname), (void*)params)
    glatter_glGetMultiTexLevelParameterfvEXT(texunit, target, level, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexLevelParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexLevelParameterivEXT, (texunit, target, level, pname, params), (GLenum texunit, GLenum target, GLint level, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexLevelParameterivEXT_debug(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexLevelParameterivEXT, "(%s, %s, %d, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, enum_to_string_GL(pname), (void*)params)
    glatter_glGetMultiTexLevelParameterivEXT(texunit, target, level, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexLevelParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexParameterIivEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexParameterIivEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexParameterIivEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMultiTexParameterIivEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexParameterIivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexParameterIuivEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexParameterIuivEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexParameterIuivEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMultiTexParameterIuivEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexParameterIuivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexParameterfvEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexParameterfvEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexParameterfvEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMultiTexParameterfvEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultiTexParameterivEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMultiTexParameterivEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultiTexParameterivEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMultiTexParameterivEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultiTexParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedBufferParameterivEXT, (buffer, pname, params), (GLuint buffer, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedBufferParameterivEXT_debug(GLuint buffer, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedBufferParameterivEXT, "(%u, %s, %p)", (unsigned int)buffer, enum_to_string_GL(pname), (void*)params)
    glatter_glGetNamedBufferParameterivEXT(buffer, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedBufferParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedBufferPointervEXT, (buffer, pname, params), (GLuint buffer, GLenum pname, void **params))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedBufferPointervEXT_debug(GLuint buffer, GLenum pname, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedBufferPointervEXT, "(%u, %s, %p)", (unsigned int)buffer, enum_to_string_GL(pname), (void*)params)
    glatter_glGetNamedBufferPointervEXT(buffer, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedBufferPointervEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedBufferSubDataEXT, (buffer, offset, size, data), (GLuint buffer, GLintptr offset, GLsizeiptr size, void *data))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedBufferSubDataEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedBufferSubDataEXT, "(%u, %s, %s, %p)", (unsigned int)buffer, GET_PRS(offset), GET_PRS(size), (void*)data)
    glatter_glGetNamedBufferSubDataEXT(buffer, offset, size, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedBufferSubDataEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedFramebufferAttachmentParameterivEXT, (framebuffer, attachment, pname, params), (GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedFramebufferAttachmentParameterivEXT_debug(GLuint framebuffer, GLenum attachment, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedFramebufferAttachmentParameterivEXT, "(%u, %s, %s, %p)", (unsigned int)framebuffer, enum_to_string_GL(attachment), enum_to_string_GL(pname), (void*)params)
    glatter_glGetNamedFramebufferAttachmentParameterivEXT(framebuffer, attachment, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedFramebufferAttachmentParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedFramebufferParameterivEXT, (framebuffer, pname, params), (GLuint framebuffer, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedFramebufferParameterivEXT_debug(GLuint framebuffer, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedFramebufferParameterivEXT, "(%u, %s, %p)", (unsigned int)framebuffer, enum_to_string_GL(pname), (void*)params)
    glatter_glGetNamedFramebufferParameterivEXT(framebuffer, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedFramebufferParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedProgramLocalParameterIivEXT, (program, target, index, params), (GLuint program, GLenum target, GLuint index, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramLocalParameterIivEXT_debug(GLuint program, GLenum target, GLuint index, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedProgramLocalParameterIivEXT, "(%u, %s, %u, %p)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetNamedProgramLocalParameterIivEXT(program, target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedProgramLocalParameterIivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedProgramLocalParameterIuivEXT, (program, target, index, params), (GLuint program, GLenum target, GLuint index, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramLocalParameterIuivEXT_debug(GLuint program, GLenum target, GLuint index, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedProgramLocalParameterIuivEXT, "(%u, %s, %u, %p)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetNamedProgramLocalParameterIuivEXT(program, target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedProgramLocalParameterIuivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedProgramLocalParameterdvEXT, (program, target, index, params), (GLuint program, GLenum target, GLuint index, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramLocalParameterdvEXT_debug(GLuint program, GLenum target, GLuint index, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedProgramLocalParameterdvEXT, "(%u, %s, %u, %p)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetNamedProgramLocalParameterdvEXT(program, target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedProgramLocalParameterdvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedProgramLocalParameterfvEXT, (program, target, index, params), (GLuint program, GLenum target, GLuint index, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramLocalParameterfvEXT_debug(GLuint program, GLenum target, GLuint index, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedProgramLocalParameterfvEXT, "(%u, %s, %u, %p)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetNamedProgramLocalParameterfvEXT(program, target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedProgramLocalParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedProgramStringEXT, (program, target, pname, string), (GLuint program, GLenum target, GLenum pname, void *string))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramStringEXT_debug(GLuint program, GLenum target, GLenum pname, void *string, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedProgramStringEXT, "(%u, %s, %s, %p)", (unsigned int)program, enum_to_string_GL(target), enum_to_string_GL(pname), (void*)string)
    glatter_glGetNamedProgramStringEXT(program, target, pname, string);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedProgramStringEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedProgramivEXT, (program, target, pname, params), (GLuint program, GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedProgramivEXT_debug(GLuint program, GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedProgramivEXT, "(%u, %s, %s, %p)", (unsigned int)program, enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetNamedProgramivEXT(program, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedProgramivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNamedRenderbufferParameterivEXT, (renderbuffer, pname, params), (GLuint renderbuffer, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetNamedRenderbufferParameterivEXT_debug(GLuint renderbuffer, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNamedRenderbufferParameterivEXT, "(%u, %s, %p)", (unsigned int)renderbuffer, enum_to_string_GL(pname), (void*)params)
    glatter_glGetNamedRenderbufferParameterivEXT(renderbuffer, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNamedRenderbufferParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPointerIndexedvEXT, (target, index, data), (GLenum target, GLuint index, void **data))
GLATTER_INLINE_OR_NOT void glatter_glGetPointerIndexedvEXT_debug(GLenum target, GLuint index, void **data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPointerIndexedvEXT, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetPointerIndexedvEXT(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPointerIndexedvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPointeri_vEXT, (pname, index, params), (GLenum pname, GLuint index, void **params))
GLATTER_INLINE_OR_NOT void glatter_glGetPointeri_vEXT_debug(GLenum pname, GLuint index, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPointeri_vEXT, "(%s, %u, %p)", enum_to_string_GL(pname), (unsigned int)index, (void*)params)
    glatter_glGetPointeri_vEXT(pname, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPointeri_vEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTextureImageEXT, (texture, target, level, format, type, pixels), (GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glGetTextureImageEXT_debug(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureImageEXT, "(%u, %s, %d, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glGetTextureImageEXT(texture, target, level, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTextureImageEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTextureLevelParameterfvEXT, (texture, target, level, pname, params), (GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTextureLevelParameterfvEXT_debug(GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureLevelParameterfvEXT, "(%u, %s, %d, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, enum_to_string_GL(pname), (void*)params)
    glatter_glGetTextureLevelParameterfvEXT(texture, target, level, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTextureLevelParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTextureLevelParameterivEXT, (texture, target, level, pname, params), (GLuint texture, GLenum target, GLint level, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTextureLevelParameterivEXT_debug(GLuint texture, GLenum target, GLint level, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureLevelParameterivEXT, "(%u, %s, %d, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, enum_to_string_GL(pname), (void*)params)
    glatter_glGetTextureLevelParameterivEXT(texture, target, level, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTextureLevelParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTextureParameterIivEXT, (texture, target, pname, params), (GLuint texture, GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameterIivEXT_debug(GLuint texture, GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureParameterIivEXT, "(%u, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTextureParameterIivEXT(texture, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTextureParameterIivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTextureParameterIuivEXT, (texture, target, pname, params), (GLuint texture, GLenum target, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameterIuivEXT_debug(GLuint texture, GLenum target, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureParameterIuivEXT, "(%u, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTextureParameterIuivEXT(texture, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTextureParameterIuivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTextureParameterfvEXT, (texture, target, pname, params), (GLuint texture, GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameterfvEXT_debug(GLuint texture, GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureParameterfvEXT, "(%u, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTextureParameterfvEXT(texture, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTextureParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTextureParameterivEXT, (texture, target, pname, params), (GLuint texture, GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTextureParameterivEXT_debug(GLuint texture, GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureParameterivEXT, "(%u, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTextureParameterivEXT(texture, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTextureParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexArrayIntegeri_vEXT, (vaobj, index, pname, param), (GLuint vaobj, GLuint index, GLenum pname, GLint *param))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexArrayIntegeri_vEXT_debug(GLuint vaobj, GLuint index, GLenum pname, GLint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexArrayIntegeri_vEXT, "(%u, %u, %s, %p)", (unsigned int)vaobj, (unsigned int)index, enum_to_string_GL(pname), (void*)param)
    glatter_glGetVertexArrayIntegeri_vEXT(vaobj, index, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexArrayIntegeri_vEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexArrayIntegervEXT, (vaobj, pname, param), (GLuint vaobj, GLenum pname, GLint *param))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexArrayIntegervEXT_debug(GLuint vaobj, GLenum pname, GLint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexArrayIntegervEXT, "(%u, %s, %p)", (unsigned int)vaobj, enum_to_string_GL(pname), (void*)param)
    glatter_glGetVertexArrayIntegervEXT(vaobj, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexArrayIntegervEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexArrayPointeri_vEXT, (vaobj, index, pname, param), (GLuint vaobj, GLuint index, GLenum pname, void **param))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexArrayPointeri_vEXT_debug(GLuint vaobj, GLuint index, GLenum pname, void **param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexArrayPointeri_vEXT, "(%u, %u, %s, %p)", (unsigned int)vaobj, (unsigned int)index, enum_to_string_GL(pname), (void*)param)
    glatter_glGetVertexArrayPointeri_vEXT(vaobj, index, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexArrayPointeri_vEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexArrayPointervEXT, (vaobj, pname, param), (GLuint vaobj, GLenum pname, void **param))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexArrayPointervEXT_debug(GLuint vaobj, GLenum pname, void **param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexArrayPointervEXT, "(%u, %s, %p)", (unsigned int)vaobj, enum_to_string_GL(pname), (void*)param)
    glatter_glGetVertexArrayPointervEXT(vaobj, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexArrayPointervEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsEnabledIndexedEXT, (target, index), (GLenum target, GLuint index))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsEnabledIndexedEXT_debug(GLenum target, GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsEnabledIndexedEXT, "(%s, %u)", enum_to_string_GL(target), (unsigned int)index)
    GLboolean rval = glatter_glIsEnabledIndexedEXT(target, index);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsEnabledIndexedEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, void *, APIENTRY, glMapNamedBufferEXT, (buffer, access), (GLuint buffer, GLenum access))
GLATTER_INLINE_OR_NOT void * glatter_glMapNamedBufferEXT_debug(GLuint buffer, GLenum access, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapNamedBufferEXT, "(%u, %s)", (unsigned int)buffer, enum_to_string_GL(access))
    void * rval = glatter_glMapNamedBufferEXT(buffer, access);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glMapNamedBufferEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, void *, APIENTRY, glMapNamedBufferRangeEXT, (buffer, offset, length, access), (GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access))
GLATTER_INLINE_OR_NOT void * glatter_glMapNamedBufferRangeEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapNamedBufferRangeEXT, "(%u, %s, %s, %u)", (unsigned int)buffer, GET_PRS(offset), GET_PRS(length), (unsigned int)access)
    void * rval = glatter_glMapNamedBufferRangeEXT(buffer, offset, length, access);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glMapNamedBufferRangeEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixFrustumEXT, (mode, left, right, bottom, top, zNear, zFar), (GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GLATTER_INLINE_OR_NOT void glatter_glMatrixFrustumEXT_debug(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixFrustumEXT, "(%s, %f, %f, %f, %f, %f, %f)", enum_to_string_GL(mode), (double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar)
    glatter_glMatrixFrustumEXT(mode, left, right, bottom, top, zNear, zFar);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixFrustumEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixLoadIdentityEXT, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadIdentityEXT_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoadIdentityEXT, "(%s)", enum_to_string_GL(mode))
    glatter_glMatrixLoadIdentityEXT(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoadIdentityEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixLoadTransposedEXT, (mode, m), (GLenum mode, const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadTransposedEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoadTransposedEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixLoadTransposedEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoadTransposedEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixLoadTransposefEXT, (mode, m), (GLenum mode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadTransposefEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoadTransposefEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixLoadTransposefEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoadTransposefEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixLoaddEXT, (mode, m), (GLenum mode, const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoaddEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoaddEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixLoaddEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoaddEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixLoadfEXT, (mode, m), (GLenum mode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadfEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoadfEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixLoadfEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoadfEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixMultTransposedEXT, (mode, m), (GLenum mode, const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultTransposedEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMultTransposedEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixMultTransposedEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMultTransposedEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixMultTransposefEXT, (mode, m), (GLenum mode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultTransposefEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMultTransposefEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixMultTransposefEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMultTransposefEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixMultdEXT, (mode, m), (GLenum mode, const GLdouble *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultdEXT_debug(GLenum mode, const GLdouble *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMultdEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixMultdEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMultdEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixMultfEXT, (mode, m), (GLenum mode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultfEXT_debug(GLenum mode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMultfEXT, "(%s, %p)", enum_to_string_GL(mode), (void*)m)
    glatter_glMatrixMultfEXT(mode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMultfEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixOrthoEXT, (mode, left, right, bottom, top, zNear, zFar), (GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GLATTER_INLINE_OR_NOT void glatter_glMatrixOrthoEXT_debug(GLenum mode, GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixOrthoEXT, "(%s, %f, %f, %f, %f, %f, %f)", enum_to_string_GL(mode), (double)left, (double)right, (double)bottom, (double)top, (double)zNear, (double)zFar)
    glatter_glMatrixOrthoEXT(mode, left, right, bottom, top, zNear, zFar);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixOrthoEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixPopEXT, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glMatrixPopEXT_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixPopEXT, "(%s)", enum_to_string_GL(mode))
    glatter_glMatrixPopEXT(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixPopEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixPushEXT, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glMatrixPushEXT_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixPushEXT, "(%s)", enum_to_string_GL(mode))
    glatter_glMatrixPushEXT(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixPushEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixRotatedEXT, (mode, angle, x, y, z), (GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixRotatedEXT_debug(GLenum mode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixRotatedEXT, "(%s, %f, %f, %f, %f)", enum_to_string_GL(mode), (double)angle, (double)x, (double)y, (double)z)
    glatter_glMatrixRotatedEXT(mode, angle, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixRotatedEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixRotatefEXT, (mode, angle, x, y, z), (GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixRotatefEXT_debug(GLenum mode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixRotatefEXT, "(%s, %f, %f, %f, %f)", enum_to_string_GL(mode), (float)angle, (float)x, (float)y, (float)z)
    glatter_glMatrixRotatefEXT(mode, angle, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixRotatefEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixScaledEXT, (mode, x, y, z), (GLenum mode, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixScaledEXT_debug(GLenum mode, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixScaledEXT, "(%s, %f, %f, %f)", enum_to_string_GL(mode), (double)x, (double)y, (double)z)
    glatter_glMatrixScaledEXT(mode, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixScaledEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixScalefEXT, (mode, x, y, z), (GLenum mode, GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixScalefEXT_debug(GLenum mode, GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixScalefEXT, "(%s, %f, %f, %f)", enum_to_string_GL(mode), (float)x, (float)y, (float)z)
    glatter_glMatrixScalefEXT(mode, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixScalefEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixTranslatedEXT, (mode, x, y, z), (GLenum mode, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixTranslatedEXT_debug(GLenum mode, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixTranslatedEXT, "(%s, %f, %f, %f)", enum_to_string_GL(mode), (double)x, (double)y, (double)z)
    glatter_glMatrixTranslatedEXT(mode, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixTranslatedEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixTranslatefEXT, (mode, x, y, z), (GLenum mode, GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glMatrixTranslatefEXT_debug(GLenum mode, GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixTranslatefEXT, "(%s, %f, %f, %f)", enum_to_string_GL(mode), (float)x, (float)y, (float)z)
    glatter_glMatrixTranslatefEXT(mode, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixTranslatefEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexBufferEXT, (texunit, target, internalformat, buffer), (GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexBufferEXT_debug(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexBufferEXT, "(%s, %s, %s, %u)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned int)buffer)
    glatter_glMultiTexBufferEXT(texunit, target, internalformat, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexBufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoordPointerEXT, (texunit, size, type, stride, pointer), (GLenum texunit, GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoordPointerEXT_debug(GLenum texunit, GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoordPointerEXT, "(%s, %d, %s, %d, %p)", enum_to_string_GL(texunit), (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glMultiTexCoordPointerEXT(texunit, size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoordPointerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexEnvfEXT, (texunit, target, pname, param), (GLenum texunit, GLenum target, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexEnvfEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexEnvfEXT, "(%s, %s, %s, %f)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (float)param)
    glatter_glMultiTexEnvfEXT(texunit, target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexEnvfEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexEnvfvEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexEnvfvEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexEnvfvEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glMultiTexEnvfvEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexEnvfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexEnviEXT, (texunit, target, pname, param), (GLenum texunit, GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexEnviEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexEnviEXT, "(%s, %s, %s, %d)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glMultiTexEnviEXT(texunit, target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexEnviEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexEnvivEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexEnvivEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexEnvivEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glMultiTexEnvivEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexEnvivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexGendEXT, (texunit, coord, pname, param), (GLenum texunit, GLenum coord, GLenum pname, GLdouble param))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGendEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLdouble param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexGendEXT, "(%s, %s, %s, %f)", enum_to_string_GL(texunit), enum_to_string_GL(coord), enum_to_string_GL(pname), (double)param)
    glatter_glMultiTexGendEXT(texunit, coord, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexGendEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexGendvEXT, (texunit, coord, pname, params), (GLenum texunit, GLenum coord, GLenum pname, const GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGendvEXT_debug(GLenum texunit, GLenum coord, GLenum pname, const GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexGendvEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glMultiTexGendvEXT(texunit, coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexGendvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexGenfEXT, (texunit, coord, pname, param), (GLenum texunit, GLenum coord, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGenfEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexGenfEXT, "(%s, %s, %s, %f)", enum_to_string_GL(texunit), enum_to_string_GL(coord), enum_to_string_GL(pname), (float)param)
    glatter_glMultiTexGenfEXT(texunit, coord, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexGenfEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexGenfvEXT, (texunit, coord, pname, params), (GLenum texunit, GLenum coord, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGenfvEXT_debug(GLenum texunit, GLenum coord, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexGenfvEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glMultiTexGenfvEXT(texunit, coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexGenfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexGeniEXT, (texunit, coord, pname, param), (GLenum texunit, GLenum coord, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGeniEXT_debug(GLenum texunit, GLenum coord, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexGeniEXT, "(%s, %s, %s, %d)", enum_to_string_GL(texunit), enum_to_string_GL(coord), enum_to_string_GL(pname), (int)param)
    glatter_glMultiTexGeniEXT(texunit, coord, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexGeniEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexGenivEXT, (texunit, coord, pname, params), (GLenum texunit, GLenum coord, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexGenivEXT_debug(GLenum texunit, GLenum coord, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexGenivEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(coord), enum_to_string_GL(pname), (void*)params)
    glatter_glMultiTexGenivEXT(texunit, coord, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexGenivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexImage1DEXT, (texunit, target, level, internalformat, width, border, format, type, pixels), (GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexImage1DEXT, "(%s, %s, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)internalformat, (int)width, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glMultiTexImage1DEXT(texunit, target, level, internalformat, width, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexImage2DEXT, (texunit, target, level, internalformat, width, height, border, format, type, pixels), (GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexImage2DEXT, "(%s, %s, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)internalformat, (int)width, (int)height, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glMultiTexImage2DEXT(texunit, target, level, internalformat, width, height, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexImage3DEXT, (texunit, target, level, internalformat, width, height, depth, border, format, type, pixels), (GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexImage3DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexImage3DEXT, "(%s, %s, %d, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glMultiTexImage3DEXT(texunit, target, level, internalformat, width, height, depth, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexImage3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexParameterIivEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameterIivEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexParameterIivEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glMultiTexParameterIivEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexParameterIivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexParameterIuivEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameterIuivEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexParameterIuivEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glMultiTexParameterIuivEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexParameterIuivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexParameterfEXT, (texunit, target, pname, param), (GLenum texunit, GLenum target, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameterfEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexParameterfEXT, "(%s, %s, %s, %f)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (float)param)
    glatter_glMultiTexParameterfEXT(texunit, target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexParameterfEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexParameterfvEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameterfvEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexParameterfvEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glMultiTexParameterfvEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexParameteriEXT, (texunit, target, pname, param), (GLenum texunit, GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameteriEXT_debug(GLenum texunit, GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexParameteriEXT, "(%s, %s, %s, %d)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glMultiTexParameteriEXT(texunit, target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexParameteriEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexParameterivEXT, (texunit, target, pname, params), (GLenum texunit, GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexParameterivEXT_debug(GLenum texunit, GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexParameterivEXT, "(%s, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glMultiTexParameterivEXT(texunit, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexRenderbufferEXT, (texunit, target, renderbuffer), (GLenum texunit, GLenum target, GLuint renderbuffer))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexRenderbufferEXT_debug(GLenum texunit, GLenum target, GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexRenderbufferEXT, "(%s, %s, %u)", enum_to_string_GL(texunit), enum_to_string_GL(target), (unsigned int)renderbuffer)
    glatter_glMultiTexRenderbufferEXT(texunit, target, renderbuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexRenderbufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexSubImage1DEXT, (texunit, target, level, xoffset, width, format, type, pixels), (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexSubImage1DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexSubImage1DEXT, "(%s, %s, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)xoffset, (int)width, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glMultiTexSubImage1DEXT(texunit, target, level, xoffset, width, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexSubImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexSubImage2DEXT, (texunit, target, level, xoffset, yoffset, width, height, format, type, pixels), (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexSubImage2DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexSubImage2DEXT, "(%s, %s, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glMultiTexSubImage2DEXT(texunit, target, level, xoffset, yoffset, width, height, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexSubImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexSubImage3DEXT, (texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels), (GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexSubImage3DEXT_debug(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexSubImage3DEXT, "(%s, %s, %d, %d, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(texunit), enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glMultiTexSubImage3DEXT(texunit, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexSubImage3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedBufferDataEXT, (buffer, size, data, usage), (GLuint buffer, GLsizeiptr size, const void *data, GLenum usage))
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferDataEXT_debug(GLuint buffer, GLsizeiptr size, const void *data, GLenum usage, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedBufferDataEXT, "(%u, %s, %p, %s)", (unsigned int)buffer, GET_PRS(size), (void*)data, enum_to_string_GL(usage))
    glatter_glNamedBufferDataEXT(buffer, size, data, usage);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedBufferDataEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedBufferStorageEXT, (buffer, size, data, flags), (GLuint buffer, GLsizeiptr size, const void *data, GLbitfield flags))
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferStorageEXT_debug(GLuint buffer, GLsizeiptr size, const void *data, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedBufferStorageEXT, "(%u, %s, %p, %u)", (unsigned int)buffer, GET_PRS(size), (void*)data, (unsigned int)flags)
    glatter_glNamedBufferStorageEXT(buffer, size, data, flags);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedBufferStorageEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedBufferSubDataEXT, (buffer, offset, size, data), (GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferSubDataEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedBufferSubDataEXT, "(%u, %s, %s, %p)", (unsigned int)buffer, GET_PRS(offset), GET_PRS(size), (void*)data)
    glatter_glNamedBufferSubDataEXT(buffer, offset, size, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedBufferSubDataEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedCopyBufferSubDataEXT, (readBuffer, writeBuffer, readOffset, writeOffset, size), (GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size))
GLATTER_INLINE_OR_NOT void glatter_glNamedCopyBufferSubDataEXT_debug(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedCopyBufferSubDataEXT, "(%u, %u, %s, %s, %s)", (unsigned int)readBuffer, (unsigned int)writeBuffer, GET_PRS(readOffset), GET_PRS(writeOffset), GET_PRS(size))
    glatter_glNamedCopyBufferSubDataEXT(readBuffer, writeBuffer, readOffset, writeOffset, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedCopyBufferSubDataEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedFramebufferParameteriEXT, (framebuffer, pname, param), (GLuint framebuffer, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferParameteriEXT_debug(GLuint framebuffer, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedFramebufferParameteriEXT, "(%u, %s, %d)", (unsigned int)framebuffer, enum_to_string_GL(pname), (int)param)
    glatter_glNamedFramebufferParameteriEXT(framebuffer, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedFramebufferParameteriEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedFramebufferRenderbufferEXT, (framebuffer, attachment, renderbuffertarget, renderbuffer), (GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer))
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferRenderbufferEXT_debug(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedFramebufferRenderbufferEXT, "(%u, %s, %s, %u)", (unsigned int)framebuffer, enum_to_string_GL(attachment), enum_to_string_GL(renderbuffertarget), (unsigned int)renderbuffer)
    glatter_glNamedFramebufferRenderbufferEXT(framebuffer, attachment, renderbuffertarget, renderbuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedFramebufferRenderbufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedFramebufferTexture1DEXT, (framebuffer, attachment, textarget, texture, level), (GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTexture1DEXT_debug(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedFramebufferTexture1DEXT, "(%u, %s, %s, %u, %d)", (unsigned int)framebuffer, enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level)
    glatter_glNamedFramebufferTexture1DEXT(framebuffer, attachment, textarget, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedFramebufferTexture1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedFramebufferTexture2DEXT, (framebuffer, attachment, textarget, texture, level), (GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTexture2DEXT_debug(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedFramebufferTexture2DEXT, "(%u, %s, %s, %u, %d)", (unsigned int)framebuffer, enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level)
    glatter_glNamedFramebufferTexture2DEXT(framebuffer, attachment, textarget, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedFramebufferTexture2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedFramebufferTexture3DEXT, (framebuffer, attachment, textarget, texture, level, zoffset), (GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset))
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTexture3DEXT_debug(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedFramebufferTexture3DEXT, "(%u, %s, %s, %u, %d, %d)", (unsigned int)framebuffer, enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level, (int)zoffset)
    glatter_glNamedFramebufferTexture3DEXT(framebuffer, attachment, textarget, texture, level, zoffset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedFramebufferTexture3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedFramebufferTextureEXT, (framebuffer, attachment, texture, level), (GLuint framebuffer, GLenum attachment, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTextureEXT_debug(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedFramebufferTextureEXT, "(%u, %s, %u, %d)", (unsigned int)framebuffer, enum_to_string_GL(attachment), (unsigned int)texture, (int)level)
    glatter_glNamedFramebufferTextureEXT(framebuffer, attachment, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedFramebufferTextureEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedFramebufferTextureFaceEXT, (framebuffer, attachment, texture, level, face), (GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face))
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTextureFaceEXT_debug(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedFramebufferTextureFaceEXT, "(%u, %s, %u, %d, %s)", (unsigned int)framebuffer, enum_to_string_GL(attachment), (unsigned int)texture, (int)level, enum_to_string_GL(face))
    glatter_glNamedFramebufferTextureFaceEXT(framebuffer, attachment, texture, level, face);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedFramebufferTextureFaceEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedFramebufferTextureLayerEXT, (framebuffer, attachment, texture, level, layer), (GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer))
GLATTER_INLINE_OR_NOT void glatter_glNamedFramebufferTextureLayerEXT_debug(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedFramebufferTextureLayerEXT, "(%u, %s, %u, %d, %d)", (unsigned int)framebuffer, enum_to_string_GL(attachment), (unsigned int)texture, (int)level, (int)layer)
    glatter_glNamedFramebufferTextureLayerEXT(framebuffer, attachment, texture, level, layer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedFramebufferTextureLayerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramLocalParameter4dEXT, (program, target, index, x, y, z, w), (GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameter4dEXT_debug(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramLocalParameter4dEXT, "(%u, %s, %u, %f, %f, %f, %f)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (double)x, (double)y, (double)z, (double)w)
    glatter_glNamedProgramLocalParameter4dEXT(program, target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramLocalParameter4dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramLocalParameter4dvEXT, (program, target, index, params), (GLuint program, GLenum target, GLuint index, const GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameter4dvEXT_debug(GLuint program, GLenum target, GLuint index, const GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramLocalParameter4dvEXT, "(%u, %s, %u, %p)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glNamedProgramLocalParameter4dvEXT(program, target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramLocalParameter4dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramLocalParameter4fEXT, (program, target, index, x, y, z, w), (GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameter4fEXT_debug(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramLocalParameter4fEXT, "(%u, %s, %u, %f, %f, %f, %f)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (float)x, (float)y, (float)z, (float)w)
    glatter_glNamedProgramLocalParameter4fEXT(program, target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramLocalParameter4fEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramLocalParameter4fvEXT, (program, target, index, params), (GLuint program, GLenum target, GLuint index, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameter4fvEXT_debug(GLuint program, GLenum target, GLuint index, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramLocalParameter4fvEXT, "(%u, %s, %u, %p)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glNamedProgramLocalParameter4fvEXT(program, target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramLocalParameter4fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramLocalParameterI4iEXT, (program, target, index, x, y, z, w), (GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameterI4iEXT_debug(GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramLocalParameterI4iEXT, "(%u, %s, %u, %d, %d, %d, %d)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (int)x, (int)y, (int)z, (int)w)
    glatter_glNamedProgramLocalParameterI4iEXT(program, target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramLocalParameterI4iEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramLocalParameterI4ivEXT, (program, target, index, params), (GLuint program, GLenum target, GLuint index, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameterI4ivEXT_debug(GLuint program, GLenum target, GLuint index, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramLocalParameterI4ivEXT, "(%u, %s, %u, %p)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glNamedProgramLocalParameterI4ivEXT(program, target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramLocalParameterI4ivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramLocalParameterI4uiEXT, (program, target, index, x, y, z, w), (GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameterI4uiEXT_debug(GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramLocalParameterI4uiEXT, "(%u, %s, %u, %u, %u, %u, %u)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (unsigned int)x, (unsigned int)y, (unsigned int)z, (unsigned int)w)
    glatter_glNamedProgramLocalParameterI4uiEXT(program, target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramLocalParameterI4uiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramLocalParameterI4uivEXT, (program, target, index, params), (GLuint program, GLenum target, GLuint index, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameterI4uivEXT_debug(GLuint program, GLenum target, GLuint index, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramLocalParameterI4uivEXT, "(%u, %s, %u, %p)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glNamedProgramLocalParameterI4uivEXT(program, target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramLocalParameterI4uivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramLocalParameters4fvEXT, (program, target, index, count, params), (GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParameters4fvEXT_debug(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramLocalParameters4fvEXT, "(%u, %s, %u, %d, %p)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (int)count, (void*)params)
    glatter_glNamedProgramLocalParameters4fvEXT(program, target, index, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramLocalParameters4fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramLocalParametersI4ivEXT, (program, target, index, count, params), (GLuint program, GLenum target, GLuint index, GLsizei count, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParametersI4ivEXT_debug(GLuint program, GLenum target, GLuint index, GLsizei count, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramLocalParametersI4ivEXT, "(%u, %s, %u, %d, %p)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (int)count, (void*)params)
    glatter_glNamedProgramLocalParametersI4ivEXT(program, target, index, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramLocalParametersI4ivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramLocalParametersI4uivEXT, (program, target, index, count, params), (GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramLocalParametersI4uivEXT_debug(GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramLocalParametersI4uivEXT, "(%u, %s, %u, %d, %p)", (unsigned int)program, enum_to_string_GL(target), (unsigned int)index, (int)count, (void*)params)
    glatter_glNamedProgramLocalParametersI4uivEXT(program, target, index, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramLocalParametersI4uivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedProgramStringEXT, (program, target, format, len, string), (GLuint program, GLenum target, GLenum format, GLsizei len, const void *string))
GLATTER_INLINE_OR_NOT void glatter_glNamedProgramStringEXT_debug(GLuint program, GLenum target, GLenum format, GLsizei len, const void *string, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedProgramStringEXT, "(%u, %s, %s, %d, %p)", (unsigned int)program, enum_to_string_GL(target), enum_to_string_GL(format), (int)len, (void*)string)
    glatter_glNamedProgramStringEXT(program, target, format, len, string);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedProgramStringEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedRenderbufferStorageEXT, (renderbuffer, internalformat, width, height), (GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glNamedRenderbufferStorageEXT_debug(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedRenderbufferStorageEXT, "(%u, %s, %d, %d)", (unsigned int)renderbuffer, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glNamedRenderbufferStorageEXT(renderbuffer, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedRenderbufferStorageEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedRenderbufferStorageMultisampleCoverageEXT, (renderbuffer, coverageSamples, colorSamples, internalformat, width, height), (GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glNamedRenderbufferStorageMultisampleCoverageEXT_debug(GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedRenderbufferStorageMultisampleCoverageEXT, "(%u, %d, %d, %s, %d, %d)", (unsigned int)renderbuffer, (int)coverageSamples, (int)colorSamples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glNamedRenderbufferStorageMultisampleCoverageEXT(renderbuffer, coverageSamples, colorSamples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedRenderbufferStorageMultisampleCoverageEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedRenderbufferStorageMultisampleEXT, (renderbuffer, samples, internalformat, width, height), (GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glNamedRenderbufferStorageMultisampleEXT_debug(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedRenderbufferStorageMultisampleEXT, "(%u, %d, %s, %d, %d)", (unsigned int)renderbuffer, (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glNamedRenderbufferStorageMultisampleEXT(renderbuffer, samples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedRenderbufferStorageMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1dEXT, (program, location, x), (GLuint program, GLint location, GLdouble x))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1dEXT_debug(GLuint program, GLint location, GLdouble x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1dEXT, "(%u, %d, %f)", (unsigned int)program, (int)location, (double)x)
    glatter_glProgramUniform1dEXT(program, location, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1dvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1dvEXT_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1dvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1dvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1fEXT, (program, location, v0), (GLuint program, GLint location, GLfloat v0))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1fEXT_debug(GLuint program, GLint location, GLfloat v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1fEXT, "(%u, %d, %f)", (unsigned int)program, (int)location, (float)v0)
    glatter_glProgramUniform1fEXT(program, location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1fEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1fvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1fvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1fvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1iEXT, (program, location, v0), (GLuint program, GLint location, GLint v0))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1iEXT_debug(GLuint program, GLint location, GLint v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1iEXT, "(%u, %d, %d)", (unsigned int)program, (int)location, (int)v0)
    glatter_glProgramUniform1iEXT(program, location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1iEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1ivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1ivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1ivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1ivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1uiEXT, (program, location, v0), (GLuint program, GLint location, GLuint v0))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1uiEXT_debug(GLuint program, GLint location, GLuint v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1uiEXT, "(%u, %d, %u)", (unsigned int)program, (int)location, (unsigned int)v0)
    glatter_glProgramUniform1uiEXT(program, location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1uiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform1uivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform1uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform1uivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform1uivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform1uivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2dEXT, (program, location, x, y), (GLuint program, GLint location, GLdouble x, GLdouble y))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2dEXT_debug(GLuint program, GLint location, GLdouble x, GLdouble y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2dEXT, "(%u, %d, %f, %f)", (unsigned int)program, (int)location, (double)x, (double)y)
    glatter_glProgramUniform2dEXT(program, location, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2dvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2dvEXT_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2dvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2dvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2fEXT, (program, location, v0, v1), (GLuint program, GLint location, GLfloat v0, GLfloat v1))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2fEXT_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2fEXT, "(%u, %d, %f, %f)", (unsigned int)program, (int)location, (float)v0, (float)v1)
    glatter_glProgramUniform2fEXT(program, location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2fEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2fvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2fvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2fvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2iEXT, (program, location, v0, v1), (GLuint program, GLint location, GLint v0, GLint v1))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2iEXT_debug(GLuint program, GLint location, GLint v0, GLint v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2iEXT, "(%u, %d, %d, %d)", (unsigned int)program, (int)location, (int)v0, (int)v1)
    glatter_glProgramUniform2iEXT(program, location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2iEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2ivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2ivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2ivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2ivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2uiEXT, (program, location, v0, v1), (GLuint program, GLint location, GLuint v0, GLuint v1))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2uiEXT_debug(GLuint program, GLint location, GLuint v0, GLuint v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2uiEXT, "(%u, %d, %u, %u)", (unsigned int)program, (int)location, (unsigned int)v0, (unsigned int)v1)
    glatter_glProgramUniform2uiEXT(program, location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2uiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform2uivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform2uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform2uivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform2uivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform2uivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3dEXT, (program, location, x, y, z), (GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3dEXT_debug(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3dEXT, "(%u, %d, %f, %f, %f)", (unsigned int)program, (int)location, (double)x, (double)y, (double)z)
    glatter_glProgramUniform3dEXT(program, location, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3dvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3dvEXT_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3dvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3dvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3fEXT, (program, location, v0, v1, v2), (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3fEXT_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3fEXT, "(%u, %d, %f, %f, %f)", (unsigned int)program, (int)location, (float)v0, (float)v1, (float)v2)
    glatter_glProgramUniform3fEXT(program, location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3fEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3fvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3fvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3fvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3iEXT, (program, location, v0, v1, v2), (GLuint program, GLint location, GLint v0, GLint v1, GLint v2))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3iEXT_debug(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3iEXT, "(%u, %d, %d, %d, %d)", (unsigned int)program, (int)location, (int)v0, (int)v1, (int)v2)
    glatter_glProgramUniform3iEXT(program, location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3iEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3ivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3ivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3ivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3ivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3uiEXT, (program, location, v0, v1, v2), (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3uiEXT_debug(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3uiEXT, "(%u, %d, %u, %u, %u)", (unsigned int)program, (int)location, (unsigned int)v0, (unsigned int)v1, (unsigned int)v2)
    glatter_glProgramUniform3uiEXT(program, location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3uiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform3uivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform3uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform3uivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform3uivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform3uivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4dEXT, (program, location, x, y, z, w), (GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4dEXT_debug(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4dEXT, "(%u, %d, %f, %f, %f, %f)", (unsigned int)program, (int)location, (double)x, (double)y, (double)z, (double)w)
    glatter_glProgramUniform4dEXT(program, location, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4dvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4dvEXT_debug(GLuint program, GLint location, GLsizei count, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4dvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4dvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4fEXT, (program, location, v0, v1, v2, v3), (GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4fEXT_debug(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4fEXT, "(%u, %d, %f, %f, %f, %f)", (unsigned int)program, (int)location, (float)v0, (float)v1, (float)v2, (float)v3)
    glatter_glProgramUniform4fEXT(program, location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4fEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4fvEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4fvEXT_debug(GLuint program, GLint location, GLsizei count, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4fvEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4fvEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4iEXT, (program, location, v0, v1, v2, v3), (GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4iEXT_debug(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4iEXT, "(%u, %d, %d, %d, %d, %d)", (unsigned int)program, (int)location, (int)v0, (int)v1, (int)v2, (int)v3)
    glatter_glProgramUniform4iEXT(program, location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4iEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4ivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4ivEXT_debug(GLuint program, GLint location, GLsizei count, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4ivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4ivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4ivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4uiEXT, (program, location, v0, v1, v2, v3), (GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4uiEXT_debug(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4uiEXT, "(%u, %d, %u, %u, %u, %u)", (unsigned int)program, (int)location, (unsigned int)v0, (unsigned int)v1, (unsigned int)v2, (unsigned int)v3)
    glatter_glProgramUniform4uiEXT(program, location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4uiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniform4uivEXT, (program, location, count, value), (GLuint program, GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniform4uivEXT_debug(GLuint program, GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniform4uivEXT, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)value)
    glatter_glProgramUniform4uivEXT(program, location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniform4uivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix2dvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2dvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2dvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix2fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix2x3dvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x3dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2x3dvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2x3dvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2x3dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix2x3fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x3fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2x3fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2x3fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2x3fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix2x4dvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x4dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2x4dvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2x4dvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2x4dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix2x4fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix2x4fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix2x4fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix2x4fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix2x4fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix3dvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3dvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3dvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix3fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix3x2dvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x2dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3x2dvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3x2dvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3x2dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix3x2fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x2fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3x2fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3x2fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3x2fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix3x4dvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x4dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3x4dvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3x4dvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3x4dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix3x4fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix3x4fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix3x4fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix3x4fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix3x4fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix4dvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4dvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4dvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix4fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix4x2dvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x2dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4x2dvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4x2dvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4x2dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix4x2fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x2fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4x2fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4x2fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4x2fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix4x3dvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x3dvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4x3dvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4x3dvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4x3dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformMatrix4x3fvEXT, (program, location, count, transpose, value), (GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformMatrix4x3fvEXT_debug(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformMatrix4x3fvEXT, "(%u, %d, %d, %u, %p)", (unsigned int)program, (int)location, (int)count, (unsigned char)transpose, (void*)value)
    glatter_glProgramUniformMatrix4x3fvEXT(program, location, count, transpose, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformMatrix4x3fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPushClientAttribDefaultEXT, (mask), (GLbitfield mask))
GLATTER_INLINE_OR_NOT void glatter_glPushClientAttribDefaultEXT_debug(GLbitfield mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPushClientAttribDefaultEXT, "(%u)", (unsigned int)mask)
    glatter_glPushClientAttribDefaultEXT(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPushClientAttribDefaultEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureBufferEXT, (texture, target, internalformat, buffer), (GLuint texture, GLenum target, GLenum internalformat, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glTextureBufferEXT_debug(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureBufferEXT, "(%u, %s, %s, %u)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned int)buffer)
    glatter_glTextureBufferEXT(texture, target, internalformat, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureBufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureBufferRangeEXT, (texture, target, internalformat, buffer, offset, size), (GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size))
GLATTER_INLINE_OR_NOT void glatter_glTextureBufferRangeEXT_debug(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureBufferRangeEXT, "(%u, %s, %s, %u, %s, %s)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned int)buffer, GET_PRS(offset), GET_PRS(size))
    glatter_glTextureBufferRangeEXT(texture, target, internalformat, buffer, offset, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureBufferRangeEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureImage1DEXT, (texture, target, level, internalformat, width, border, format, type, pixels), (GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTextureImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureImage1DEXT, "(%u, %s, %d, %d, %d, %d, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)internalformat, (int)width, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTextureImage1DEXT(texture, target, level, internalformat, width, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureImage2DEXT, (texture, target, level, internalformat, width, height, border, format, type, pixels), (GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTextureImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureImage2DEXT, "(%u, %s, %d, %d, %d, %d, %d, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)internalformat, (int)width, (int)height, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTextureImage2DEXT(texture, target, level, internalformat, width, height, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureImage3DEXT, (texture, target, level, internalformat, width, height, depth, border, format, type, pixels), (GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTextureImage3DEXT_debug(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureImage3DEXT, "(%u, %s, %d, %d, %d, %d, %d, %d, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTextureImage3DEXT(texture, target, level, internalformat, width, height, depth, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureImage3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexturePageCommitmentEXT, (texture, level, xoffset, yoffset, zoffset, width, height, depth, commit), (GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit))
GLATTER_INLINE_OR_NOT void glatter_glTexturePageCommitmentEXT_debug(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexturePageCommitmentEXT, "(%u, %d, %d, %d, %d, %d, %d, %d, %u)", (unsigned int)texture, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (unsigned char)commit)
    glatter_glTexturePageCommitmentEXT(texture, level, xoffset, yoffset, zoffset, width, height, depth, commit);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexturePageCommitmentEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureParameterIivEXT, (texture, target, pname, params), (GLuint texture, GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterIivEXT_debug(GLuint texture, GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureParameterIivEXT, "(%u, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTextureParameterIivEXT(texture, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureParameterIivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureParameterIuivEXT, (texture, target, pname, params), (GLuint texture, GLenum target, GLenum pname, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterIuivEXT_debug(GLuint texture, GLenum target, GLenum pname, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureParameterIuivEXT, "(%u, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTextureParameterIuivEXT(texture, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureParameterIuivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureParameterfEXT, (texture, target, pname, param), (GLuint texture, GLenum target, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterfEXT_debug(GLuint texture, GLenum target, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureParameterfEXT, "(%u, %s, %s, %f)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(pname), (float)param)
    glatter_glTextureParameterfEXT(texture, target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureParameterfEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureParameterfvEXT, (texture, target, pname, params), (GLuint texture, GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterfvEXT_debug(GLuint texture, GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureParameterfvEXT, "(%u, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTextureParameterfvEXT(texture, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureParameteriEXT, (texture, target, pname, param), (GLuint texture, GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glTextureParameteriEXT_debug(GLuint texture, GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureParameteriEXT, "(%u, %s, %s, %d)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glTextureParameteriEXT(texture, target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureParameteriEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureParameterivEXT, (texture, target, pname, params), (GLuint texture, GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTextureParameterivEXT_debug(GLuint texture, GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureParameterivEXT, "(%u, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTextureParameterivEXT(texture, target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureRenderbufferEXT, (texture, target, renderbuffer), (GLuint texture, GLenum target, GLuint renderbuffer))
GLATTER_INLINE_OR_NOT void glatter_glTextureRenderbufferEXT_debug(GLuint texture, GLenum target, GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureRenderbufferEXT, "(%u, %s, %u)", (unsigned int)texture, enum_to_string_GL(target), (unsigned int)renderbuffer)
    glatter_glTextureRenderbufferEXT(texture, target, renderbuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureRenderbufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureStorage1DEXT, (texture, target, levels, internalformat, width), (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage1DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorage1DEXT, "(%u, %s, %d, %s, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width)
    glatter_glTextureStorage1DEXT(texture, target, levels, internalformat, width);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureStorage2DEXT, (texture, target, levels, internalformat, width, height), (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage2DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorage2DEXT, "(%u, %s, %d, %s, %d, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glTextureStorage2DEXT(texture, target, levels, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureStorage2DMultisampleEXT, (texture, target, samples, internalformat, width, height, fixedsamplelocations), (GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage2DMultisampleEXT_debug(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorage2DMultisampleEXT, "(%u, %s, %d, %s, %d, %d, %u)", (unsigned int)texture, enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height, (unsigned char)fixedsamplelocations)
    glatter_glTextureStorage2DMultisampleEXT(texture, target, samples, internalformat, width, height, fixedsamplelocations);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorage2DMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureStorage3DEXT, (texture, target, levels, internalformat, width, height, depth), (GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage3DEXT_debug(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorage3DEXT, "(%u, %s, %d, %s, %d, %d, %d)", (unsigned int)texture, enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth)
    glatter_glTextureStorage3DEXT(texture, target, levels, internalformat, width, height, depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorage3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureStorage3DMultisampleEXT, (texture, target, samples, internalformat, width, height, depth, fixedsamplelocations), (GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorage3DMultisampleEXT_debug(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorage3DMultisampleEXT, "(%u, %s, %d, %s, %d, %d, %d, %u)", (unsigned int)texture, enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth, (unsigned char)fixedsamplelocations)
    glatter_glTextureStorage3DMultisampleEXT(texture, target, samples, internalformat, width, height, depth, fixedsamplelocations);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorage3DMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureSubImage1DEXT, (texture, target, level, xoffset, width, format, type, pixels), (GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTextureSubImage1DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureSubImage1DEXT, "(%u, %s, %d, %d, %d, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)xoffset, (int)width, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTextureSubImage1DEXT(texture, target, level, xoffset, width, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureSubImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureSubImage2DEXT, (texture, target, level, xoffset, yoffset, width, height, format, type, pixels), (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTextureSubImage2DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureSubImage2DEXT, "(%u, %s, %d, %d, %d, %d, %d, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTextureSubImage2DEXT(texture, target, level, xoffset, yoffset, width, height, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureSubImage2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureSubImage3DEXT, (texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels), (GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTextureSubImage3DEXT_debug(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureSubImage3DEXT, "(%u, %s, %d, %d, %d, %d, %d, %d, %d, %s, %s, %p)", (unsigned int)texture, enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTextureSubImage3DEXT(texture, target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureSubImage3DEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glUnmapNamedBufferEXT, (buffer), (GLuint buffer))
GLATTER_INLINE_OR_NOT GLboolean glatter_glUnmapNamedBufferEXT_debug(GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUnmapNamedBufferEXT, "(%u)", (unsigned int)buffer)
    GLboolean rval = glatter_glUnmapNamedBufferEXT(buffer);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glUnmapNamedBufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayBindVertexBufferEXT, (vaobj, bindingindex, buffer, offset, stride), (GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayBindVertexBufferEXT_debug(GLuint vaobj, GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayBindVertexBufferEXT, "(%u, %u, %u, %s, %d)", (unsigned int)vaobj, (unsigned int)bindingindex, (unsigned int)buffer, GET_PRS(offset), (int)stride)
    glatter_glVertexArrayBindVertexBufferEXT(vaobj, bindingindex, buffer, offset, stride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayBindVertexBufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayColorOffsetEXT, (vaobj, buffer, size, type, stride, offset), (GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayColorOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayColorOffsetEXT, "(%u, %u, %d, %s, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, (int)size, enum_to_string_GL(type), (int)stride, GET_PRS(offset))
    glatter_glVertexArrayColorOffsetEXT(vaobj, buffer, size, type, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayColorOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayEdgeFlagOffsetEXT, (vaobj, buffer, stride, offset), (GLuint vaobj, GLuint buffer, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayEdgeFlagOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayEdgeFlagOffsetEXT, "(%u, %u, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, (int)stride, GET_PRS(offset))
    glatter_glVertexArrayEdgeFlagOffsetEXT(vaobj, buffer, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayEdgeFlagOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayFogCoordOffsetEXT, (vaobj, buffer, type, stride, offset), (GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayFogCoordOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayFogCoordOffsetEXT, "(%u, %u, %s, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, enum_to_string_GL(type), (int)stride, GET_PRS(offset))
    glatter_glVertexArrayFogCoordOffsetEXT(vaobj, buffer, type, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayFogCoordOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayIndexOffsetEXT, (vaobj, buffer, type, stride, offset), (GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayIndexOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayIndexOffsetEXT, "(%u, %u, %s, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, enum_to_string_GL(type), (int)stride, GET_PRS(offset))
    glatter_glVertexArrayIndexOffsetEXT(vaobj, buffer, type, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayIndexOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayMultiTexCoordOffsetEXT, (vaobj, buffer, texunit, size, type, stride, offset), (GLuint vaobj, GLuint buffer, GLenum texunit, GLint size, GLenum type, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayMultiTexCoordOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLenum texunit, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayMultiTexCoordOffsetEXT, "(%u, %u, %s, %d, %s, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, enum_to_string_GL(texunit), (int)size, enum_to_string_GL(type), (int)stride, GET_PRS(offset))
    glatter_glVertexArrayMultiTexCoordOffsetEXT(vaobj, buffer, texunit, size, type, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayMultiTexCoordOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayNormalOffsetEXT, (vaobj, buffer, type, stride, offset), (GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayNormalOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayNormalOffsetEXT, "(%u, %u, %s, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, enum_to_string_GL(type), (int)stride, GET_PRS(offset))
    glatter_glVertexArrayNormalOffsetEXT(vaobj, buffer, type, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayNormalOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArraySecondaryColorOffsetEXT, (vaobj, buffer, size, type, stride, offset), (GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArraySecondaryColorOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArraySecondaryColorOffsetEXT, "(%u, %u, %d, %s, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, (int)size, enum_to_string_GL(type), (int)stride, GET_PRS(offset))
    glatter_glVertexArraySecondaryColorOffsetEXT(vaobj, buffer, size, type, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArraySecondaryColorOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayTexCoordOffsetEXT, (vaobj, buffer, size, type, stride, offset), (GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayTexCoordOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayTexCoordOffsetEXT, "(%u, %u, %d, %s, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, (int)size, enum_to_string_GL(type), (int)stride, GET_PRS(offset))
    glatter_glVertexArrayTexCoordOffsetEXT(vaobj, buffer, size, type, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayTexCoordOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayVertexAttribBindingEXT, (vaobj, attribindex, bindingindex), (GLuint vaobj, GLuint attribindex, GLuint bindingindex))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribBindingEXT_debug(GLuint vaobj, GLuint attribindex, GLuint bindingindex, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayVertexAttribBindingEXT, "(%u, %u, %u)", (unsigned int)vaobj, (unsigned int)attribindex, (unsigned int)bindingindex)
    glatter_glVertexArrayVertexAttribBindingEXT(vaobj, attribindex, bindingindex);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayVertexAttribBindingEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayVertexAttribDivisorEXT, (vaobj, index, divisor), (GLuint vaobj, GLuint index, GLuint divisor))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribDivisorEXT_debug(GLuint vaobj, GLuint index, GLuint divisor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayVertexAttribDivisorEXT, "(%u, %u, %u)", (unsigned int)vaobj, (unsigned int)index, (unsigned int)divisor)
    glatter_glVertexArrayVertexAttribDivisorEXT(vaobj, index, divisor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayVertexAttribDivisorEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayVertexAttribFormatEXT, (vaobj, attribindex, size, type, normalized, relativeoffset), (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribFormatEXT_debug(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayVertexAttribFormatEXT, "(%u, %u, %d, %s, %u, %u)", (unsigned int)vaobj, (unsigned int)attribindex, (int)size, enum_to_string_GL(type), (unsigned char)normalized, (unsigned int)relativeoffset)
    glatter_glVertexArrayVertexAttribFormatEXT(vaobj, attribindex, size, type, normalized, relativeoffset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayVertexAttribFormatEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayVertexAttribIFormatEXT, (vaobj, attribindex, size, type, relativeoffset), (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribIFormatEXT_debug(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayVertexAttribIFormatEXT, "(%u, %u, %d, %s, %u)", (unsigned int)vaobj, (unsigned int)attribindex, (int)size, enum_to_string_GL(type), (unsigned int)relativeoffset)
    glatter_glVertexArrayVertexAttribIFormatEXT(vaobj, attribindex, size, type, relativeoffset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayVertexAttribIFormatEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayVertexAttribIOffsetEXT, (vaobj, buffer, index, size, type, stride, offset), (GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribIOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayVertexAttribIOffsetEXT, "(%u, %u, %u, %d, %s, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, (unsigned int)index, (int)size, enum_to_string_GL(type), (int)stride, GET_PRS(offset))
    glatter_glVertexArrayVertexAttribIOffsetEXT(vaobj, buffer, index, size, type, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayVertexAttribIOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayVertexAttribLFormatEXT, (vaobj, attribindex, size, type, relativeoffset), (GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribLFormatEXT_debug(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayVertexAttribLFormatEXT, "(%u, %u, %d, %s, %u)", (unsigned int)vaobj, (unsigned int)attribindex, (int)size, enum_to_string_GL(type), (unsigned int)relativeoffset)
    glatter_glVertexArrayVertexAttribLFormatEXT(vaobj, attribindex, size, type, relativeoffset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayVertexAttribLFormatEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayVertexAttribLOffsetEXT, (vaobj, buffer, index, size, type, stride, offset), (GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribLOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayVertexAttribLOffsetEXT, "(%u, %u, %u, %d, %s, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, (unsigned int)index, (int)size, enum_to_string_GL(type), (int)stride, GET_PRS(offset))
    glatter_glVertexArrayVertexAttribLOffsetEXT(vaobj, buffer, index, size, type, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayVertexAttribLOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayVertexAttribOffsetEXT, (vaobj, buffer, index, size, type, normalized, stride, offset), (GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexAttribOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayVertexAttribOffsetEXT, "(%u, %u, %u, %d, %s, %u, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, (unsigned int)index, (int)size, enum_to_string_GL(type), (unsigned char)normalized, (int)stride, GET_PRS(offset))
    glatter_glVertexArrayVertexAttribOffsetEXT(vaobj, buffer, index, size, type, normalized, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayVertexAttribOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayVertexBindingDivisorEXT, (vaobj, bindingindex, divisor), (GLuint vaobj, GLuint bindingindex, GLuint divisor))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexBindingDivisorEXT_debug(GLuint vaobj, GLuint bindingindex, GLuint divisor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayVertexBindingDivisorEXT, "(%u, %u, %u)", (unsigned int)vaobj, (unsigned int)bindingindex, (unsigned int)divisor)
    glatter_glVertexArrayVertexBindingDivisorEXT(vaobj, bindingindex, divisor);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayVertexBindingDivisorEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexArrayVertexOffsetEXT, (vaobj, buffer, size, type, stride, offset), (GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glVertexArrayVertexOffsetEXT_debug(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexArrayVertexOffsetEXT, "(%u, %u, %d, %s, %d, %s)", (unsigned int)vaobj, (unsigned int)buffer, (int)size, enum_to_string_GL(type), (int)stride, GET_PRS(offset))
    glatter_glVertexArrayVertexOffsetEXT(vaobj, buffer, size, type, stride, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexArrayVertexOffsetEXT_defined
#endif // defined(GL_EXT_direct_state_access)
#if defined(GL_EXT_draw_buffers2)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorMaskIndexedEXT, (index, r, g, b, a), (GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a))
GLATTER_INLINE_OR_NOT void glatter_glColorMaskIndexedEXT_debug(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorMaskIndexedEXT, "(%u, %u, %u, %u, %u)", (unsigned int)index, (unsigned char)r, (unsigned char)g, (unsigned char)b, (unsigned char)a)
    glatter_glColorMaskIndexedEXT(index, r, g, b, a);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorMaskIndexedEXT_defined
#endif // defined(GL_EXT_draw_buffers2)
#if defined(GL_EXT_draw_instanced)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawArraysInstancedEXT, (mode, start, count, primcount), (GLenum mode, GLint start, GLsizei count, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysInstancedEXT_debug(GLenum mode, GLint start, GLsizei count, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArraysInstancedEXT, "(%s, %d, %d, %d)", enum_to_string_GL(mode), (int)start, (int)count, (int)primcount)
    glatter_glDrawArraysInstancedEXT(mode, start, count, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArraysInstancedEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawElementsInstancedEXT, (mode, count, type, indices, primcount), (GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glDrawElementsInstancedEXT_debug(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawElementsInstancedEXT, "(%s, %d, %s, %p, %d)", enum_to_string_GL(mode), (int)count, enum_to_string_GL(type), (void*)indices, (int)primcount)
    glatter_glDrawElementsInstancedEXT(mode, count, type, indices, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawElementsInstancedEXT_defined
#endif // defined(GL_EXT_draw_instanced)
#if defined(GL_EXT_draw_range_elements)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawRangeElementsEXT, (mode, start, end, count, type, indices), (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices))
GLATTER_INLINE_OR_NOT void glatter_glDrawRangeElementsEXT_debug(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const void *indices, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawRangeElementsEXT, "(%s, %u, %u, %d, %s, %p)", enum_to_string_GL(mode), (unsigned int)start, (unsigned int)end, (int)count, enum_to_string_GL(type), (void*)indices)
    glatter_glDrawRangeElementsEXT(mode, start, end, count, type, indices);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawRangeElementsEXT_defined
#endif // defined(GL_EXT_draw_range_elements)
#if defined(GL_EXT_external_buffer)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBufferStorageExternalEXT, (target, offset, size, clientBuffer, flags), (GLenum target, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags))
GLATTER_INLINE_OR_NOT void glatter_glBufferStorageExternalEXT_debug(GLenum target, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferStorageExternalEXT, "(%s, %s, %s, %p, %u)", enum_to_string_GL(target), GET_PRS(offset), GET_PRS(size), (void*)clientBuffer, (unsigned int)flags)
    glatter_glBufferStorageExternalEXT(target, offset, size, clientBuffer, flags);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferStorageExternalEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedBufferStorageExternalEXT, (buffer, offset, size, clientBuffer, flags), (GLuint buffer, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags))
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferStorageExternalEXT_debug(GLuint buffer, GLintptr offset, GLsizeiptr size, GLeglClientBufferEXT clientBuffer, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedBufferStorageExternalEXT, "(%u, %s, %s, %p, %u)", (unsigned int)buffer, GET_PRS(offset), GET_PRS(size), (void*)clientBuffer, (unsigned int)flags)
    glatter_glNamedBufferStorageExternalEXT(buffer, offset, size, clientBuffer, flags);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedBufferStorageExternalEXT_defined
#endif // defined(GL_EXT_external_buffer)
#if defined(GL_EXT_fog_coord)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFogCoordPointerEXT, (type, stride, pointer), (GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glFogCoordPointerEXT_debug(GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogCoordPointerEXT, "(%s, %d, %p)", enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glFogCoordPointerEXT(type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogCoordPointerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFogCoorddEXT, (coord), (GLdouble coord))
GLATTER_INLINE_OR_NOT void glatter_glFogCoorddEXT_debug(GLdouble coord, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogCoorddEXT, "(%f)", (double)coord)
    glatter_glFogCoorddEXT(coord);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogCoorddEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFogCoorddvEXT, (coord), (const GLdouble *coord))
GLATTER_INLINE_OR_NOT void glatter_glFogCoorddvEXT_debug(const GLdouble *coord, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogCoorddvEXT, "(%p)", (void*)coord)
    glatter_glFogCoorddvEXT(coord);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogCoorddvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFogCoordfEXT, (coord), (GLfloat coord))
GLATTER_INLINE_OR_NOT void glatter_glFogCoordfEXT_debug(GLfloat coord, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogCoordfEXT, "(%f)", (float)coord)
    glatter_glFogCoordfEXT(coord);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogCoordfEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFogCoordfvEXT, (coord), (const GLfloat *coord))
GLATTER_INLINE_OR_NOT void glatter_glFogCoordfvEXT_debug(const GLfloat *coord, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogCoordfvEXT, "(%p)", (void*)coord)
    glatter_glFogCoordfvEXT(coord);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogCoordfvEXT_defined
#endif // defined(GL_EXT_fog_coord)
#if defined(GL_EXT_framebuffer_blit)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlitFramebufferEXT, (srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter), (GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter))
GLATTER_INLINE_OR_NOT void glatter_glBlitFramebufferEXT_debug(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlitFramebufferEXT, "(%d, %d, %d, %d, %d, %d, %d, %d, %u, %s)", (int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (unsigned int)mask, enum_to_string_GL(filter))
    glatter_glBlitFramebufferEXT(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlitFramebufferEXT_defined
#endif // defined(GL_EXT_framebuffer_blit)
#if defined(GL_EXT_framebuffer_multisample)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glRenderbufferStorageMultisampleEXT, (target, samples, internalformat, width, height), (GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleEXT_debug(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleEXT, "(%s, %d, %s, %d, %d)", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleEXT(target, samples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleEXT_defined
#endif // defined(GL_EXT_framebuffer_multisample)
#if defined(GL_EXT_framebuffer_object)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindFramebufferEXT, (target, framebuffer), (GLenum target, GLuint framebuffer))
GLATTER_INLINE_OR_NOT void glatter_glBindFramebufferEXT_debug(GLenum target, GLuint framebuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindFramebufferEXT, "(%s, %u)", enum_to_string_GL(target), (unsigned int)framebuffer)
    glatter_glBindFramebufferEXT(target, framebuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindFramebufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindRenderbufferEXT, (target, renderbuffer), (GLenum target, GLuint renderbuffer))
GLATTER_INLINE_OR_NOT void glatter_glBindRenderbufferEXT_debug(GLenum target, GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindRenderbufferEXT, "(%s, %u)", enum_to_string_GL(target), (unsigned int)renderbuffer)
    glatter_glBindRenderbufferEXT(target, renderbuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindRenderbufferEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLenum, APIENTRY, glCheckFramebufferStatusEXT, (target), (GLenum target))
GLATTER_INLINE_OR_NOT GLenum glatter_glCheckFramebufferStatusEXT_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCheckFramebufferStatusEXT, "(%s)", enum_to_string_GL(target))
    GLenum rval = glatter_glCheckFramebufferStatusEXT(target);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCheckFramebufferStatusEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteFramebuffersEXT, (n, framebuffers), (GLsizei n, const GLuint *framebuffers))
GLATTER_INLINE_OR_NOT void glatter_glDeleteFramebuffersEXT_debug(GLsizei n, const GLuint *framebuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteFramebuffersEXT, "(%d, %p)", (int)n, (void*)framebuffers)
    glatter_glDeleteFramebuffersEXT(n, framebuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteFramebuffersEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteRenderbuffersEXT, (n, renderbuffers), (GLsizei n, const GLuint *renderbuffers))
GLATTER_INLINE_OR_NOT void glatter_glDeleteRenderbuffersEXT_debug(GLsizei n, const GLuint *renderbuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteRenderbuffersEXT, "(%d, %p)", (int)n, (void*)renderbuffers)
    glatter_glDeleteRenderbuffersEXT(n, renderbuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteRenderbuffersEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferRenderbufferEXT, (target, attachment, renderbuffertarget, renderbuffer), (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferRenderbufferEXT_debug(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferRenderbufferEXT, "(%s, %s, %s, %u)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(renderbuffertarget), (unsigned int)renderbuffer)
    glatter_glFramebufferRenderbufferEXT(target, attachment, renderbuffertarget, renderbuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferRenderbufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferTexture1DEXT, (target, attachment, textarget, texture, level), (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture1DEXT_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture1DEXT, "(%s, %s, %s, %u, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level)
    glatter_glFramebufferTexture1DEXT(target, attachment, textarget, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferTexture2DEXT, (target, attachment, textarget, texture, level), (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture2DEXT_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture2DEXT, "(%s, %s, %s, %u, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level)
    glatter_glFramebufferTexture2DEXT(target, attachment, textarget, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferTexture3DEXT, (target, attachment, textarget, texture, level, zoffset), (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTexture3DEXT_debug(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTexture3DEXT, "(%s, %s, %s, %u, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(textarget), (unsigned int)texture, (int)level, (int)zoffset)
    glatter_glFramebufferTexture3DEXT(target, attachment, textarget, texture, level, zoffset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTexture3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenFramebuffersEXT, (n, framebuffers), (GLsizei n, GLuint *framebuffers))
GLATTER_INLINE_OR_NOT void glatter_glGenFramebuffersEXT_debug(GLsizei n, GLuint *framebuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenFramebuffersEXT, "(%d, %p)", (int)n, (void*)framebuffers)
    glatter_glGenFramebuffersEXT(n, framebuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenFramebuffersEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenRenderbuffersEXT, (n, renderbuffers), (GLsizei n, GLuint *renderbuffers))
GLATTER_INLINE_OR_NOT void glatter_glGenRenderbuffersEXT_debug(GLsizei n, GLuint *renderbuffers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenRenderbuffersEXT, "(%d, %p)", (int)n, (void*)renderbuffers)
    glatter_glGenRenderbuffersEXT(n, renderbuffers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenRenderbuffersEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenerateMipmapEXT, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glGenerateMipmapEXT_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenerateMipmapEXT, "(%s)", enum_to_string_GL(target))
    glatter_glGenerateMipmapEXT(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenerateMipmapEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetFramebufferAttachmentParameterivEXT, (target, attachment, pname, params), (GLenum target, GLenum attachment, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFramebufferAttachmentParameterivEXT_debug(GLenum target, GLenum attachment, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFramebufferAttachmentParameterivEXT, "(%s, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(attachment), enum_to_string_GL(pname), (void*)params)
    glatter_glGetFramebufferAttachmentParameterivEXT(target, attachment, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFramebufferAttachmentParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetRenderbufferParameterivEXT, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetRenderbufferParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetRenderbufferParameterivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetRenderbufferParameterivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetRenderbufferParameterivEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsFramebufferEXT, (framebuffer), (GLuint framebuffer))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsFramebufferEXT_debug(GLuint framebuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsFramebufferEXT, "(%u)", (unsigned int)framebuffer)
    GLboolean rval = glatter_glIsFramebufferEXT(framebuffer);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsFramebufferEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsRenderbufferEXT, (renderbuffer), (GLuint renderbuffer))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsRenderbufferEXT_debug(GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsRenderbufferEXT, "(%u)", (unsigned int)renderbuffer)
    GLboolean rval = glatter_glIsRenderbufferEXT(renderbuffer);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsRenderbufferEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glRenderbufferStorageEXT, (target, internalformat, width, height), (GLenum target, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageEXT_debug(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageEXT, "(%s, %s, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageEXT(target, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageEXT_defined
#endif // defined(GL_EXT_framebuffer_object)
#if defined(GL_EXT_geometry_shader4)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramParameteriEXT, (program, pname, value), (GLuint program, GLenum pname, GLint value))
GLATTER_INLINE_OR_NOT void glatter_glProgramParameteriEXT_debug(GLuint program, GLenum pname, GLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramParameteriEXT, "(%u, %s, %d)", (unsigned int)program, enum_to_string_GL(pname), (int)value)
    glatter_glProgramParameteriEXT(program, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramParameteriEXT_defined
#endif // defined(GL_EXT_geometry_shader4)
#if defined(GL_EXT_gpu_program_parameters)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramEnvParameters4fvEXT, (target, index, count, params), (GLenum target, GLuint index, GLsizei count, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameters4fvEXT_debug(GLenum target, GLuint index, GLsizei count, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramEnvParameters4fvEXT, "(%s, %u, %d, %p)", enum_to_string_GL(target), (unsigned int)index, (int)count, (void*)params)
    glatter_glProgramEnvParameters4fvEXT(target, index, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramEnvParameters4fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramLocalParameters4fvEXT, (target, index, count, params), (GLenum target, GLuint index, GLsizei count, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameters4fvEXT_debug(GLenum target, GLuint index, GLsizei count, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramLocalParameters4fvEXT, "(%s, %u, %d, %p)", enum_to_string_GL(target), (unsigned int)index, (int)count, (void*)params)
    glatter_glProgramLocalParameters4fvEXT(target, index, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramLocalParameters4fvEXT_defined
#endif // defined(GL_EXT_gpu_program_parameters)
#if defined(GL_EXT_gpu_shader4)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindFragDataLocationEXT, (program, color, name), (GLuint program, GLuint color, const GLchar *name))
GLATTER_INLINE_OR_NOT void glatter_glBindFragDataLocationEXT_debug(GLuint program, GLuint color, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindFragDataLocationEXT, "(%u, %u, %p)", (unsigned int)program, (unsigned int)color, (void*)name)
    glatter_glBindFragDataLocationEXT(program, color, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindFragDataLocationEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLint, APIENTRY, glGetFragDataLocationEXT, (program, name), (GLuint program, const GLchar *name))
GLATTER_INLINE_OR_NOT GLint glatter_glGetFragDataLocationEXT_debug(GLuint program, const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFragDataLocationEXT, "(%u, %p)", (unsigned int)program, (void*)name)
    GLint rval = glatter_glGetFragDataLocationEXT(program, name);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetFragDataLocationEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetUniformuivEXT, (program, location, params), (GLuint program, GLint location, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetUniformuivEXT_debug(GLuint program, GLint location, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUniformuivEXT, "(%u, %d, %p)", (unsigned int)program, (int)location, (void*)params)
    glatter_glGetUniformuivEXT(program, location, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUniformuivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1uiEXT, (location, v0), (GLint location, GLuint v0))
GLATTER_INLINE_OR_NOT void glatter_glUniform1uiEXT_debug(GLint location, GLuint v0, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1uiEXT, "(%d, %u)", (int)location, (unsigned int)v0)
    glatter_glUniform1uiEXT(location, v0);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1uiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform1uivEXT, (location, count, value), (GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform1uivEXT_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform1uivEXT, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform1uivEXT(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform1uivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2uiEXT, (location, v0, v1), (GLint location, GLuint v0, GLuint v1))
GLATTER_INLINE_OR_NOT void glatter_glUniform2uiEXT_debug(GLint location, GLuint v0, GLuint v1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2uiEXT, "(%d, %u, %u)", (int)location, (unsigned int)v0, (unsigned int)v1)
    glatter_glUniform2uiEXT(location, v0, v1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2uiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform2uivEXT, (location, count, value), (GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform2uivEXT_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform2uivEXT, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform2uivEXT(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform2uivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3uiEXT, (location, v0, v1, v2), (GLint location, GLuint v0, GLuint v1, GLuint v2))
GLATTER_INLINE_OR_NOT void glatter_glUniform3uiEXT_debug(GLint location, GLuint v0, GLuint v1, GLuint v2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3uiEXT, "(%d, %u, %u, %u)", (int)location, (unsigned int)v0, (unsigned int)v1, (unsigned int)v2)
    glatter_glUniform3uiEXT(location, v0, v1, v2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3uiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform3uivEXT, (location, count, value), (GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform3uivEXT_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform3uivEXT, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform3uivEXT(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform3uivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4uiEXT, (location, v0, v1, v2, v3), (GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3))
GLATTER_INLINE_OR_NOT void glatter_glUniform4uiEXT_debug(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4uiEXT, "(%d, %u, %u, %u, %u)", (int)location, (unsigned int)v0, (unsigned int)v1, (unsigned int)v2, (unsigned int)v3)
    glatter_glUniform4uiEXT(location, v0, v1, v2, v3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4uiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniform4uivEXT, (location, count, value), (GLint location, GLsizei count, const GLuint *value))
GLATTER_INLINE_OR_NOT void glatter_glUniform4uivEXT_debug(GLint location, GLsizei count, const GLuint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniform4uivEXT, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniform4uivEXT(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniform4uivEXT_defined
#endif // defined(GL_EXT_gpu_shader4)
#if defined(GL_EXT_histogram)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetHistogramEXT, (target, reset, format, type, values), (GLenum target, GLboolean reset, GLenum format, GLenum type, void *values))
GLATTER_INLINE_OR_NOT void glatter_glGetHistogramEXT_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, void *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetHistogramEXT, "(%s, %u, %s, %s, %p)", enum_to_string_GL(target), (unsigned char)reset, enum_to_string_GL(format), enum_to_string_GL(type), (void*)values)
    glatter_glGetHistogramEXT(target, reset, format, type, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetHistogramEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetHistogramParameterfvEXT, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetHistogramParameterfvEXT_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetHistogramParameterfvEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetHistogramParameterfvEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetHistogramParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetHistogramParameterivEXT, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetHistogramParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetHistogramParameterivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetHistogramParameterivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetHistogramParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMinmaxEXT, (target, reset, format, type, values), (GLenum target, GLboolean reset, GLenum format, GLenum type, void *values))
GLATTER_INLINE_OR_NOT void glatter_glGetMinmaxEXT_debug(GLenum target, GLboolean reset, GLenum format, GLenum type, void *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMinmaxEXT, "(%s, %u, %s, %s, %p)", enum_to_string_GL(target), (unsigned char)reset, enum_to_string_GL(format), enum_to_string_GL(type), (void*)values)
    glatter_glGetMinmaxEXT(target, reset, format, type, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMinmaxEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMinmaxParameterfvEXT, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMinmaxParameterfvEXT_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMinmaxParameterfvEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMinmaxParameterfvEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMinmaxParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMinmaxParameterivEXT, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMinmaxParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMinmaxParameterivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMinmaxParameterivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMinmaxParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glHistogramEXT, (target, width, internalformat, sink), (GLenum target, GLsizei width, GLenum internalformat, GLboolean sink))
GLATTER_INLINE_OR_NOT void glatter_glHistogramEXT_debug(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glHistogramEXT, "(%s, %d, %s, %u)", enum_to_string_GL(target), (int)width, enum_to_string_GL(internalformat), (unsigned char)sink)
    glatter_glHistogramEXT(target, width, internalformat, sink);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glHistogramEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMinmaxEXT, (target, internalformat, sink), (GLenum target, GLenum internalformat, GLboolean sink))
GLATTER_INLINE_OR_NOT void glatter_glMinmaxEXT_debug(GLenum target, GLenum internalformat, GLboolean sink, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMinmaxEXT, "(%s, %s, %u)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned char)sink)
    glatter_glMinmaxEXT(target, internalformat, sink);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMinmaxEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glResetHistogramEXT, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glResetHistogramEXT_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glResetHistogramEXT, "(%s)", enum_to_string_GL(target))
    glatter_glResetHistogramEXT(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glResetHistogramEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glResetMinmaxEXT, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glResetMinmaxEXT_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glResetMinmaxEXT, "(%s)", enum_to_string_GL(target))
    glatter_glResetMinmaxEXT(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glResetMinmaxEXT_defined
#endif // defined(GL_EXT_histogram)
#if defined(GL_EXT_index_func)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glIndexFuncEXT, (func, ref), (GLenum func, GLclampf ref))
GLATTER_INLINE_OR_NOT void glatter_glIndexFuncEXT_debug(GLenum func, GLclampf ref, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexFuncEXT, "(%s, %f)", enum_to_string_GL(func), (float)ref)
    glatter_glIndexFuncEXT(func, ref);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexFuncEXT_defined
#endif // defined(GL_EXT_index_func)
#if defined(GL_EXT_index_material)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glIndexMaterialEXT, (face, mode), (GLenum face, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glIndexMaterialEXT_debug(GLenum face, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexMaterialEXT, "(%s, %s)", enum_to_string_GL(face), enum_to_string_GL(mode))
    glatter_glIndexMaterialEXT(face, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexMaterialEXT_defined
#endif // defined(GL_EXT_index_material)
#if defined(GL_EXT_light_texture)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glApplyTextureEXT, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glApplyTextureEXT_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glApplyTextureEXT, "(%s)", enum_to_string_GL(mode))
    glatter_glApplyTextureEXT(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glApplyTextureEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureLightEXT, (pname), (GLenum pname))
GLATTER_INLINE_OR_NOT void glatter_glTextureLightEXT_debug(GLenum pname, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureLightEXT, "(%s)", enum_to_string_GL(pname))
    glatter_glTextureLightEXT(pname);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureLightEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureMaterialEXT, (face, mode), (GLenum face, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glTextureMaterialEXT_debug(GLenum face, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureMaterialEXT, "(%s, %s)", enum_to_string_GL(face), enum_to_string_GL(mode))
    glatter_glTextureMaterialEXT(face, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureMaterialEXT_defined
#endif // defined(GL_EXT_light_texture)
#if defined(GL_EXT_memory_object)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBufferStorageMemEXT, (target, size, memory, offset), (GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glBufferStorageMemEXT_debug(GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBufferStorageMemEXT, "(%s, %s, %u, %" PRIu64 ")", enum_to_string_GL(target), GET_PRS(size), (unsigned int)memory, (uint64_t)offset)
    glatter_glBufferStorageMemEXT(target, size, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBufferStorageMemEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCreateMemoryObjectsEXT, (n, memoryObjects), (GLsizei n, GLuint *memoryObjects))
GLATTER_INLINE_OR_NOT void glatter_glCreateMemoryObjectsEXT_debug(GLsizei n, GLuint *memoryObjects, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateMemoryObjectsEXT, "(%d, %p)", (int)n, (void*)memoryObjects)
    glatter_glCreateMemoryObjectsEXT(n, memoryObjects);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCreateMemoryObjectsEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteMemoryObjectsEXT, (n, memoryObjects), (GLsizei n, const GLuint *memoryObjects))
GLATTER_INLINE_OR_NOT void glatter_glDeleteMemoryObjectsEXT_debug(GLsizei n, const GLuint *memoryObjects, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteMemoryObjectsEXT, "(%d, %p)", (int)n, (void*)memoryObjects)
    glatter_glDeleteMemoryObjectsEXT(n, memoryObjects);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteMemoryObjectsEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMemoryObjectParameterivEXT, (memoryObject, pname, params), (GLuint memoryObject, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMemoryObjectParameterivEXT_debug(GLuint memoryObject, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMemoryObjectParameterivEXT, "(%u, %s, %p)", (unsigned int)memoryObject, enum_to_string_GL(pname), (void*)params)
    glatter_glGetMemoryObjectParameterivEXT(memoryObject, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMemoryObjectParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetUnsignedBytei_vEXT, (target, index, data), (GLenum target, GLuint index, GLubyte *data))
GLATTER_INLINE_OR_NOT void glatter_glGetUnsignedBytei_vEXT_debug(GLenum target, GLuint index, GLubyte *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUnsignedBytei_vEXT, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)data)
    glatter_glGetUnsignedBytei_vEXT(target, index, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUnsignedBytei_vEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetUnsignedBytevEXT, (pname, data), (GLenum pname, GLubyte *data))
GLATTER_INLINE_OR_NOT void glatter_glGetUnsignedBytevEXT_debug(GLenum pname, GLubyte *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetUnsignedBytevEXT, "(%s, %p)", enum_to_string_GL(pname), (void*)data)
    glatter_glGetUnsignedBytevEXT(pname, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetUnsignedBytevEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsMemoryObjectEXT, (memoryObject), (GLuint memoryObject))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsMemoryObjectEXT_debug(GLuint memoryObject, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsMemoryObjectEXT, "(%u)", (unsigned int)memoryObject)
    GLboolean rval = glatter_glIsMemoryObjectEXT(memoryObject);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsMemoryObjectEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMemoryObjectParameterivEXT, (memoryObject, pname, params), (GLuint memoryObject, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glMemoryObjectParameterivEXT_debug(GLuint memoryObject, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMemoryObjectParameterivEXT, "(%u, %s, %p)", (unsigned int)memoryObject, enum_to_string_GL(pname), (void*)params)
    glatter_glMemoryObjectParameterivEXT(memoryObject, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMemoryObjectParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNamedBufferStorageMemEXT, (buffer, size, memory, offset), (GLuint buffer, GLsizeiptr size, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glNamedBufferStorageMemEXT_debug(GLuint buffer, GLsizeiptr size, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNamedBufferStorageMemEXT, "(%u, %s, %u, %" PRIu64 ")", (unsigned int)buffer, GET_PRS(size), (unsigned int)memory, (uint64_t)offset)
    glatter_glNamedBufferStorageMemEXT(buffer, size, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNamedBufferStorageMemEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexStorageMem1DEXT, (target, levels, internalFormat, width, memory, offset), (GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem1DEXT_debug(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorageMem1DEXT, "(%s, %d, %s, %d, %u, %" PRIu64 ")", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalFormat), (int)width, (unsigned int)memory, (uint64_t)offset)
    glatter_glTexStorageMem1DEXT(target, levels, internalFormat, width, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorageMem1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexStorageMem2DEXT, (target, levels, internalFormat, width, height, memory, offset), (GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem2DEXT_debug(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorageMem2DEXT, "(%s, %d, %s, %d, %d, %u, %" PRIu64 ")", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalFormat), (int)width, (int)height, (unsigned int)memory, (uint64_t)offset)
    glatter_glTexStorageMem2DEXT(target, levels, internalFormat, width, height, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorageMem2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexStorageMem2DMultisampleEXT, (target, samples, internalFormat, width, height, fixedSampleLocations, memory, offset), (GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem2DMultisampleEXT_debug(GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorageMem2DMultisampleEXT, "(%s, %d, %s, %d, %d, %u, %u, %" PRIu64 ")", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalFormat), (int)width, (int)height, (unsigned char)fixedSampleLocations, (unsigned int)memory, (uint64_t)offset)
    glatter_glTexStorageMem2DMultisampleEXT(target, samples, internalFormat, width, height, fixedSampleLocations, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorageMem2DMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexStorageMem3DEXT, (target, levels, internalFormat, width, height, depth, memory, offset), (GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem3DEXT_debug(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorageMem3DEXT, "(%s, %d, %s, %d, %d, %d, %u, %" PRIu64 ")", enum_to_string_GL(target), (int)levels, enum_to_string_GL(internalFormat), (int)width, (int)height, (int)depth, (unsigned int)memory, (uint64_t)offset)
    glatter_glTexStorageMem3DEXT(target, levels, internalFormat, width, height, depth, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorageMem3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexStorageMem3DMultisampleEXT, (target, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset), (GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTexStorageMem3DMultisampleEXT_debug(GLenum target, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexStorageMem3DMultisampleEXT, "(%s, %d, %s, %d, %d, %d, %u, %u, %" PRIu64 ")", enum_to_string_GL(target), (int)samples, enum_to_string_GL(internalFormat), (int)width, (int)height, (int)depth, (unsigned char)fixedSampleLocations, (unsigned int)memory, (uint64_t)offset)
    glatter_glTexStorageMem3DMultisampleEXT(target, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexStorageMem3DMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureStorageMem1DEXT, (texture, levels, internalFormat, width, memory, offset), (GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem1DEXT_debug(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorageMem1DEXT, "(%u, %d, %s, %d, %u, %" PRIu64 ")", (unsigned int)texture, (int)levels, enum_to_string_GL(internalFormat), (int)width, (unsigned int)memory, (uint64_t)offset)
    glatter_glTextureStorageMem1DEXT(texture, levels, internalFormat, width, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorageMem1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureStorageMem2DEXT, (texture, levels, internalFormat, width, height, memory, offset), (GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem2DEXT_debug(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorageMem2DEXT, "(%u, %d, %s, %d, %d, %u, %" PRIu64 ")", (unsigned int)texture, (int)levels, enum_to_string_GL(internalFormat), (int)width, (int)height, (unsigned int)memory, (uint64_t)offset)
    glatter_glTextureStorageMem2DEXT(texture, levels, internalFormat, width, height, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorageMem2DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureStorageMem2DMultisampleEXT, (texture, samples, internalFormat, width, height, fixedSampleLocations, memory, offset), (GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem2DMultisampleEXT_debug(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorageMem2DMultisampleEXT, "(%u, %d, %s, %d, %d, %u, %u, %" PRIu64 ")", (unsigned int)texture, (int)samples, enum_to_string_GL(internalFormat), (int)width, (int)height, (unsigned char)fixedSampleLocations, (unsigned int)memory, (uint64_t)offset)
    glatter_glTextureStorageMem2DMultisampleEXT(texture, samples, internalFormat, width, height, fixedSampleLocations, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorageMem2DMultisampleEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureStorageMem3DEXT, (texture, levels, internalFormat, width, height, depth, memory, offset), (GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem3DEXT_debug(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorageMem3DEXT, "(%u, %d, %s, %d, %d, %d, %u, %" PRIu64 ")", (unsigned int)texture, (int)levels, enum_to_string_GL(internalFormat), (int)width, (int)height, (int)depth, (unsigned int)memory, (uint64_t)offset)
    glatter_glTextureStorageMem3DEXT(texture, levels, internalFormat, width, height, depth, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorageMem3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureStorageMem3DMultisampleEXT, (texture, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset), (GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset))
GLATTER_INLINE_OR_NOT void glatter_glTextureStorageMem3DMultisampleEXT_debug(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureStorageMem3DMultisampleEXT, "(%u, %d, %s, %d, %d, %d, %u, %u, %" PRIu64 ")", (unsigned int)texture, (int)samples, enum_to_string_GL(internalFormat), (int)width, (int)height, (int)depth, (unsigned char)fixedSampleLocations, (unsigned int)memory, (uint64_t)offset)
    glatter_glTextureStorageMem3DMultisampleEXT(texture, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureStorageMem3DMultisampleEXT_defined
#endif // defined(GL_EXT_memory_object)
#if defined(GL_EXT_memory_object_fd)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glImportMemoryFdEXT, (memory, size, handleType, fd), (GLuint memory, GLuint64 size, GLenum handleType, GLint fd))
GLATTER_INLINE_OR_NOT void glatter_glImportMemoryFdEXT_debug(GLuint memory, GLuint64 size, GLenum handleType, GLint fd, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportMemoryFdEXT, "(%u, %" PRIu64 ", %s, %d)", (unsigned int)memory, (uint64_t)size, enum_to_string_GL(handleType), (int)fd)
    glatter_glImportMemoryFdEXT(memory, size, handleType, fd);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportMemoryFdEXT_defined
#endif // defined(GL_EXT_memory_object_fd)
#if defined(GL_EXT_memory_object_win32)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glImportMemoryWin32HandleEXT, (memory, size, handleType, handle), (GLuint memory, GLuint64 size, GLenum handleType, void *handle))
GLATTER_INLINE_OR_NOT void glatter_glImportMemoryWin32HandleEXT_debug(GLuint memory, GLuint64 size, GLenum handleType, void *handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportMemoryWin32HandleEXT, "(%u, %" PRIu64 ", %s, %p)", (unsigned int)memory, (uint64_t)size, enum_to_string_GL(handleType), (void*)handle)
    glatter_glImportMemoryWin32HandleEXT(memory, size, handleType, handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportMemoryWin32HandleEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glImportMemoryWin32NameEXT, (memory, size, handleType, name), (GLuint memory, GLuint64 size, GLenum handleType, const void *name))
GLATTER_INLINE_OR_NOT void glatter_glImportMemoryWin32NameEXT_debug(GLuint memory, GLuint64 size, GLenum handleType, const void *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportMemoryWin32NameEXT, "(%u, %" PRIu64 ", %s, %p)", (unsigned int)memory, (uint64_t)size, enum_to_string_GL(handleType), (void*)name)
    glatter_glImportMemoryWin32NameEXT(memory, size, handleType, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportMemoryWin32NameEXT_defined
#endif // defined(GL_EXT_memory_object_win32)
#if defined(GL_EXT_multi_draw_arrays)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawArraysEXT, (mode, first, count, primcount), (GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysEXT_debug(GLenum mode, const GLint *first, const GLsizei *count, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawArraysEXT, "(%s, %p, %p, %d)", enum_to_string_GL(mode), (void*)first, (void*)count, (int)primcount)
    glatter_glMultiDrawArraysEXT(mode, first, count, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawArraysEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawElementsEXT, (mode, count, type, indices, primcount), (GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsEXT_debug(GLenum mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawElementsEXT, "(%s, %p, %s, %p, %d)", enum_to_string_GL(mode), (void*)count, enum_to_string_GL(type), (void*)indices, (int)primcount)
    glatter_glMultiDrawElementsEXT(mode, count, type, indices, primcount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawElementsEXT_defined
#endif // defined(GL_EXT_multi_draw_arrays)
#if defined(GL_EXT_multisample)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSampleMaskEXT, (value, invert), (GLclampf value, GLboolean invert))
GLATTER_INLINE_OR_NOT void glatter_glSampleMaskEXT_debug(GLclampf value, GLboolean invert, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSampleMaskEXT, "(%f, %u)", (float)value, (unsigned char)invert)
    glatter_glSampleMaskEXT(value, invert);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSampleMaskEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSamplePatternEXT, (pattern), (GLenum pattern))
GLATTER_INLINE_OR_NOT void glatter_glSamplePatternEXT_debug(GLenum pattern, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSamplePatternEXT, "(%s)", enum_to_string_GL(pattern))
    glatter_glSamplePatternEXT(pattern);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSamplePatternEXT_defined
#endif // defined(GL_EXT_multisample)
#if defined(GL_EXT_paletted_texture)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorTableEXT, (target, internalFormat, width, format, type, table), (GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const void *table))
GLATTER_INLINE_OR_NOT void glatter_glColorTableEXT_debug(GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const void *table, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorTableEXT, "(%s, %s, %d, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(internalFormat), (int)width, enum_to_string_GL(format), enum_to_string_GL(type), (void*)table)
    glatter_glColorTableEXT(target, internalFormat, width, format, type, table);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorTableEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetColorTableEXT, (target, format, type, data), (GLenum target, GLenum format, GLenum type, void *data))
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableEXT_debug(GLenum target, GLenum format, GLenum type, void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetColorTableEXT, "(%s, %s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(format), enum_to_string_GL(type), (void*)data)
    glatter_glGetColorTableEXT(target, format, type, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetColorTableEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetColorTableParameterfvEXT, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableParameterfvEXT_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetColorTableParameterfvEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetColorTableParameterfvEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetColorTableParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetColorTableParameterivEXT, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetColorTableParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetColorTableParameterivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetColorTableParameterivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetColorTableParameterivEXT_defined
#endif // defined(GL_EXT_paletted_texture)
#if defined(GL_EXT_pixel_transform)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPixelTransformParameterfvEXT, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetPixelTransformParameterfvEXT_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPixelTransformParameterfvEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetPixelTransformParameterfvEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPixelTransformParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPixelTransformParameterivEXT, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetPixelTransformParameterivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPixelTransformParameterivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetPixelTransformParameterivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPixelTransformParameterivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPixelTransformParameterfEXT, (target, pname, param), (GLenum target, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glPixelTransformParameterfEXT_debug(GLenum target, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelTransformParameterfEXT, "(%s, %s, %f)", enum_to_string_GL(target), enum_to_string_GL(pname), (float)param)
    glatter_glPixelTransformParameterfEXT(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelTransformParameterfEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPixelTransformParameterfvEXT, (target, pname, params), (GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glPixelTransformParameterfvEXT_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelTransformParameterfvEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glPixelTransformParameterfvEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelTransformParameterfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPixelTransformParameteriEXT, (target, pname, param), (GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glPixelTransformParameteriEXT_debug(GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelTransformParameteriEXT, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glPixelTransformParameteriEXT(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelTransformParameteriEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPixelTransformParameterivEXT, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glPixelTransformParameterivEXT_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelTransformParameterivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glPixelTransformParameterivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelTransformParameterivEXT_defined
#endif // defined(GL_EXT_pixel_transform)
#if defined(GL_EXT_point_parameters)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPointParameterfEXT, (pname, param), (GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfEXT_debug(GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameterfEXT, "(%s, %f)", enum_to_string_GL(pname), (float)param)
    glatter_glPointParameterfEXT(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameterfEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPointParameterfvEXT, (pname, params), (GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glPointParameterfvEXT_debug(GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameterfvEXT, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glPointParameterfvEXT(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameterfvEXT_defined
#endif // defined(GL_EXT_point_parameters)
#if defined(GL_EXT_polygon_offset)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPolygonOffsetEXT, (factor, bias), (GLfloat factor, GLfloat bias))
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffsetEXT_debug(GLfloat factor, GLfloat bias, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPolygonOffsetEXT, "(%f, %f)", (float)factor, (float)bias)
    glatter_glPolygonOffsetEXT(factor, bias);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPolygonOffsetEXT_defined
#endif // defined(GL_EXT_polygon_offset)
#if defined(GL_EXT_polygon_offset_clamp)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPolygonOffsetClampEXT, (factor, units, clamp), (GLfloat factor, GLfloat units, GLfloat clamp))
GLATTER_INLINE_OR_NOT void glatter_glPolygonOffsetClampEXT_debug(GLfloat factor, GLfloat units, GLfloat clamp, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPolygonOffsetClampEXT, "(%f, %f, %f)", (float)factor, (float)units, (float)clamp)
    glatter_glPolygonOffsetClampEXT(factor, units, clamp);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPolygonOffsetClampEXT_defined
#endif // defined(GL_EXT_polygon_offset_clamp)
#if defined(GL_EXT_provoking_vertex)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProvokingVertexEXT, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glProvokingVertexEXT_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProvokingVertexEXT, "(%s)", enum_to_string_GL(mode))
    glatter_glProvokingVertexEXT(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProvokingVertexEXT_defined
#endif // defined(GL_EXT_provoking_vertex)
#if defined(GL_EXT_raster_multisample)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glRasterSamplesEXT, (samples, fixedsamplelocations), (GLuint samples, GLboolean fixedsamplelocations))
GLATTER_INLINE_OR_NOT void glatter_glRasterSamplesEXT_debug(GLuint samples, GLboolean fixedsamplelocations, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRasterSamplesEXT, "(%u, %u)", (unsigned int)samples, (unsigned char)fixedsamplelocations)
    glatter_glRasterSamplesEXT(samples, fixedsamplelocations);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRasterSamplesEXT_defined
#endif // defined(GL_EXT_raster_multisample)
#if defined(GL_EXT_secondary_color)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3bEXT, (red, green, blue), (GLbyte red, GLbyte green, GLbyte blue))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3bEXT_debug(GLbyte red, GLbyte green, GLbyte blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3bEXT, "(%d, %d, %d)", (signed char)red, (signed char)green, (signed char)blue)
    glatter_glSecondaryColor3bEXT(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3bEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3bvEXT, (v), (const GLbyte *v))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3bvEXT_debug(const GLbyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3bvEXT, "(%p)", (void*)v)
    glatter_glSecondaryColor3bvEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3bvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3dEXT, (red, green, blue), (GLdouble red, GLdouble green, GLdouble blue))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3dEXT_debug(GLdouble red, GLdouble green, GLdouble blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3dEXT, "(%f, %f, %f)", (double)red, (double)green, (double)blue)
    glatter_glSecondaryColor3dEXT(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3dvEXT, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3dvEXT_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3dvEXT, "(%p)", (void*)v)
    glatter_glSecondaryColor3dvEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3fEXT, (red, green, blue), (GLfloat red, GLfloat green, GLfloat blue))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3fEXT_debug(GLfloat red, GLfloat green, GLfloat blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3fEXT, "(%f, %f, %f)", (float)red, (float)green, (float)blue)
    glatter_glSecondaryColor3fEXT(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3fEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3fvEXT, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3fvEXT_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3fvEXT, "(%p)", (void*)v)
    glatter_glSecondaryColor3fvEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3fvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3iEXT, (red, green, blue), (GLint red, GLint green, GLint blue))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3iEXT_debug(GLint red, GLint green, GLint blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3iEXT, "(%d, %d, %d)", (int)red, (int)green, (int)blue)
    glatter_glSecondaryColor3iEXT(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3iEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3ivEXT, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3ivEXT_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3ivEXT, "(%p)", (void*)v)
    glatter_glSecondaryColor3ivEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3ivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3sEXT, (red, green, blue), (GLshort red, GLshort green, GLshort blue))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3sEXT_debug(GLshort red, GLshort green, GLshort blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3sEXT, "(%hi, %hi, %hi)", (short)red, (short)green, (short)blue)
    glatter_glSecondaryColor3sEXT(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3sEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3svEXT, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3svEXT_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3svEXT, "(%p)", (void*)v)
    glatter_glSecondaryColor3svEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3svEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3ubEXT, (red, green, blue), (GLubyte red, GLubyte green, GLubyte blue))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3ubEXT_debug(GLubyte red, GLubyte green, GLubyte blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3ubEXT, "(%u, %u, %u)", (unsigned char)red, (unsigned char)green, (unsigned char)blue)
    glatter_glSecondaryColor3ubEXT(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3ubEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3ubvEXT, (v), (const GLubyte *v))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3ubvEXT_debug(const GLubyte *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3ubvEXT, "(%p)", (void*)v)
    glatter_glSecondaryColor3ubvEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3ubvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3uiEXT, (red, green, blue), (GLuint red, GLuint green, GLuint blue))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3uiEXT_debug(GLuint red, GLuint green, GLuint blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3uiEXT, "(%u, %u, %u)", (unsigned int)red, (unsigned int)green, (unsigned int)blue)
    glatter_glSecondaryColor3uiEXT(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3uiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3uivEXT, (v), (const GLuint *v))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3uivEXT_debug(const GLuint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3uivEXT, "(%p)", (void*)v)
    glatter_glSecondaryColor3uivEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3uivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3usEXT, (red, green, blue), (GLushort red, GLushort green, GLushort blue))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3usEXT_debug(GLushort red, GLushort green, GLushort blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3usEXT, "(%hu, %hu, %hu)", (unsigned short)red, (unsigned short)green, (unsigned short)blue)
    glatter_glSecondaryColor3usEXT(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3usEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3usvEXT, (v), (const GLushort *v))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3usvEXT_debug(const GLushort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3usvEXT, "(%p)", (void*)v)
    glatter_glSecondaryColor3usvEXT(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3usvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColorPointerEXT, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColorPointerEXT_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColorPointerEXT, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glSecondaryColorPointerEXT(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColorPointerEXT_defined
#endif // defined(GL_EXT_secondary_color)
#if defined(GL_EXT_semaphore)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteSemaphoresEXT, (n, semaphores), (GLsizei n, const GLuint *semaphores))
GLATTER_INLINE_OR_NOT void glatter_glDeleteSemaphoresEXT_debug(GLsizei n, const GLuint *semaphores, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteSemaphoresEXT, "(%d, %p)", (int)n, (void*)semaphores)
    glatter_glDeleteSemaphoresEXT(n, semaphores);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteSemaphoresEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenSemaphoresEXT, (n, semaphores), (GLsizei n, GLuint *semaphores))
GLATTER_INLINE_OR_NOT void glatter_glGenSemaphoresEXT_debug(GLsizei n, GLuint *semaphores, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenSemaphoresEXT, "(%d, %p)", (int)n, (void*)semaphores)
    glatter_glGenSemaphoresEXT(n, semaphores);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenSemaphoresEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetSemaphoreParameterui64vEXT, (semaphore, pname, params), (GLuint semaphore, GLenum pname, GLuint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetSemaphoreParameterui64vEXT_debug(GLuint semaphore, GLenum pname, GLuint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetSemaphoreParameterui64vEXT, "(%u, %s, %p)", (unsigned int)semaphore, enum_to_string_GL(pname), (void*)params)
    glatter_glGetSemaphoreParameterui64vEXT(semaphore, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetSemaphoreParameterui64vEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsSemaphoreEXT, (semaphore), (GLuint semaphore))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsSemaphoreEXT_debug(GLuint semaphore, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsSemaphoreEXT, "(%u)", (unsigned int)semaphore)
    GLboolean rval = glatter_glIsSemaphoreEXT(semaphore);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsSemaphoreEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSemaphoreParameterui64vEXT, (semaphore, pname, params), (GLuint semaphore, GLenum pname, const GLuint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glSemaphoreParameterui64vEXT_debug(GLuint semaphore, GLenum pname, const GLuint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSemaphoreParameterui64vEXT, "(%u, %s, %p)", (unsigned int)semaphore, enum_to_string_GL(pname), (void*)params)
    glatter_glSemaphoreParameterui64vEXT(semaphore, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSemaphoreParameterui64vEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSignalSemaphoreEXT, (semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, dstLayouts), (GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *dstLayouts))
GLATTER_INLINE_OR_NOT void glatter_glSignalSemaphoreEXT_debug(GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *dstLayouts, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSignalSemaphoreEXT, "(%u, %u, %p, %u, %p, %p)", (unsigned int)semaphore, (unsigned int)numBufferBarriers, (void*)buffers, (unsigned int)numTextureBarriers, (void*)textures, (void*)dstLayouts)
    glatter_glSignalSemaphoreEXT(semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, dstLayouts);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSignalSemaphoreEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWaitSemaphoreEXT, (semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, srcLayouts), (GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *srcLayouts))
GLATTER_INLINE_OR_NOT void glatter_glWaitSemaphoreEXT_debug(GLuint semaphore, GLuint numBufferBarriers, const GLuint *buffers, GLuint numTextureBarriers, const GLuint *textures, const GLenum *srcLayouts, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWaitSemaphoreEXT, "(%u, %u, %p, %u, %p, %p)", (unsigned int)semaphore, (unsigned int)numBufferBarriers, (void*)buffers, (unsigned int)numTextureBarriers, (void*)textures, (void*)srcLayouts)
    glatter_glWaitSemaphoreEXT(semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, srcLayouts);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWaitSemaphoreEXT_defined
#endif // defined(GL_EXT_semaphore)
#if defined(GL_EXT_semaphore_fd)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glImportSemaphoreFdEXT, (semaphore, handleType, fd), (GLuint semaphore, GLenum handleType, GLint fd))
GLATTER_INLINE_OR_NOT void glatter_glImportSemaphoreFdEXT_debug(GLuint semaphore, GLenum handleType, GLint fd, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportSemaphoreFdEXT, "(%u, %s, %d)", (unsigned int)semaphore, enum_to_string_GL(handleType), (int)fd)
    glatter_glImportSemaphoreFdEXT(semaphore, handleType, fd);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportSemaphoreFdEXT_defined
#endif // defined(GL_EXT_semaphore_fd)
#if defined(GL_EXT_semaphore_win32)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glImportSemaphoreWin32HandleEXT, (semaphore, handleType, handle), (GLuint semaphore, GLenum handleType, void *handle))
GLATTER_INLINE_OR_NOT void glatter_glImportSemaphoreWin32HandleEXT_debug(GLuint semaphore, GLenum handleType, void *handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportSemaphoreWin32HandleEXT, "(%u, %s, %p)", (unsigned int)semaphore, enum_to_string_GL(handleType), (void*)handle)
    glatter_glImportSemaphoreWin32HandleEXT(semaphore, handleType, handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportSemaphoreWin32HandleEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glImportSemaphoreWin32NameEXT, (semaphore, handleType, name), (GLuint semaphore, GLenum handleType, const void *name))
GLATTER_INLINE_OR_NOT void glatter_glImportSemaphoreWin32NameEXT_debug(GLuint semaphore, GLenum handleType, const void *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportSemaphoreWin32NameEXT, "(%u, %s, %p)", (unsigned int)semaphore, enum_to_string_GL(handleType), (void*)name)
    glatter_glImportSemaphoreWin32NameEXT(semaphore, handleType, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImportSemaphoreWin32NameEXT_defined
#endif // defined(GL_EXT_semaphore_win32)
#if defined(GL_EXT_separate_shader_objects)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glActiveProgramEXT, (program), (GLuint program))
GLATTER_INLINE_OR_NOT void glatter_glActiveProgramEXT_debug(GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glActiveProgramEXT, "(%u)", (unsigned int)program)
    glatter_glActiveProgramEXT(program);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glActiveProgramEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glCreateShaderProgramEXT, (type, string), (GLenum type, const GLchar *string))
GLATTER_INLINE_OR_NOT GLuint glatter_glCreateShaderProgramEXT_debug(GLenum type, const GLchar *string, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateShaderProgramEXT, "(%s, %p)", enum_to_string_GL(type), (void*)string)
    GLuint rval = glatter_glCreateShaderProgramEXT(type, string);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glCreateShaderProgramEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUseShaderProgramEXT, (type, program), (GLenum type, GLuint program))
GLATTER_INLINE_OR_NOT void glatter_glUseShaderProgramEXT_debug(GLenum type, GLuint program, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUseShaderProgramEXT, "(%s, %u)", enum_to_string_GL(type), (unsigned int)program)
    glatter_glUseShaderProgramEXT(type, program);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUseShaderProgramEXT_defined
#endif // defined(GL_EXT_separate_shader_objects)
#if defined(GL_EXT_shader_framebuffer_fetch_non_coherent)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferFetchBarrierEXT, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferFetchBarrierEXT_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferFetchBarrierEXT, "()")
    glatter_glFramebufferFetchBarrierEXT();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferFetchBarrierEXT_defined
#endif // defined(GL_EXT_shader_framebuffer_fetch_non_coherent)
#if defined(GL_EXT_shader_image_load_store)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindImageTextureEXT, (index, texture, level, layered, layer, access, format), (GLuint index, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLint format))
GLATTER_INLINE_OR_NOT void glatter_glBindImageTextureEXT_debug(GLuint index, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLint format, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindImageTextureEXT, "(%u, %u, %d, %u, %d, %s, %d)", (unsigned int)index, (unsigned int)texture, (int)level, (unsigned char)layered, (int)layer, enum_to_string_GL(access), (int)format)
    glatter_glBindImageTextureEXT(index, texture, level, layered, layer, access, format);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindImageTextureEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMemoryBarrierEXT, (barriers), (GLbitfield barriers))
GLATTER_INLINE_OR_NOT void glatter_glMemoryBarrierEXT_debug(GLbitfield barriers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMemoryBarrierEXT, "(%u)", (unsigned int)barriers)
    glatter_glMemoryBarrierEXT(barriers);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMemoryBarrierEXT_defined
#endif // defined(GL_EXT_shader_image_load_store)
#if defined(GL_EXT_stencil_clear_tag)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilClearTagEXT, (stencilTagBits, stencilClearTag), (GLsizei stencilTagBits, GLuint stencilClearTag))
GLATTER_INLINE_OR_NOT void glatter_glStencilClearTagEXT_debug(GLsizei stencilTagBits, GLuint stencilClearTag, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilClearTagEXT, "(%d, %u)", (int)stencilTagBits, (unsigned int)stencilClearTag)
    glatter_glStencilClearTagEXT(stencilTagBits, stencilClearTag);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilClearTagEXT_defined
#endif // defined(GL_EXT_stencil_clear_tag)
#if defined(GL_EXT_stencil_two_side)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glActiveStencilFaceEXT, (face), (GLenum face))
GLATTER_INLINE_OR_NOT void glatter_glActiveStencilFaceEXT_debug(GLenum face, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glActiveStencilFaceEXT, "(%s)", enum_to_string_GL(face))
    glatter_glActiveStencilFaceEXT(face);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glActiveStencilFaceEXT_defined
#endif // defined(GL_EXT_stencil_two_side)
#if defined(GL_EXT_subtexture)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexSubImage1DEXT, (target, level, xoffset, width, format, type, pixels), (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage1DEXT_debug(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexSubImage1DEXT, "(%s, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)width, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexSubImage1DEXT(target, level, xoffset, width, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexSubImage1DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexSubImage2DEXT, (target, level, xoffset, yoffset, width, height, format, type, pixels), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage2DEXT_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexSubImage2DEXT, "(%s, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexSubImage2DEXT(target, level, xoffset, yoffset, width, height, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexSubImage2DEXT_defined
#endif // defined(GL_EXT_subtexture)
#if defined(GL_EXT_texture3D)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexImage3DEXT, (target, level, internalformat, width, height, depth, border, format, type, pixels), (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexImage3DEXT_debug(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexImage3DEXT, "(%s, %d, %s, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, enum_to_string_GL(internalformat), (int)width, (int)height, (int)depth, (int)border, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexImage3DEXT(target, level, internalformat, width, height, depth, border, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexImage3DEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexSubImage3DEXT, (target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels), (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels))
GLATTER_INLINE_OR_NOT void glatter_glTexSubImage3DEXT_debug(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const void *pixels, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexSubImage3DEXT, "(%s, %d, %d, %d, %d, %d, %d, %d, %s, %s, %p)", enum_to_string_GL(target), (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, enum_to_string_GL(format), enum_to_string_GL(type), (void*)pixels)
    glatter_glTexSubImage3DEXT(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexSubImage3DEXT_defined
#endif // defined(GL_EXT_texture3D)
#if defined(GL_EXT_texture_array)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferTextureLayerEXT, (target, attachment, texture, level, layer), (GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureLayerEXT_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureLayerEXT, "(%s, %s, %u, %d, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level, (int)layer)
    glatter_glFramebufferTextureLayerEXT(target, attachment, texture, level, layer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureLayerEXT_defined
#endif // defined(GL_EXT_texture_array)
#if defined(GL_EXT_texture_buffer_object)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexBufferEXT, (target, internalformat, buffer), (GLenum target, GLenum internalformat, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glTexBufferEXT_debug(GLenum target, GLenum internalformat, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexBufferEXT, "(%s, %s, %u)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (unsigned int)buffer)
    glatter_glTexBufferEXT(target, internalformat, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexBufferEXT_defined
#endif // defined(GL_EXT_texture_buffer_object)
#if defined(GL_EXT_texture_integer)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glClearColorIiEXT, (red, green, blue, alpha), (GLint red, GLint green, GLint blue, GLint alpha))
GLATTER_INLINE_OR_NOT void glatter_glClearColorIiEXT_debug(GLint red, GLint green, GLint blue, GLint alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearColorIiEXT, "(%d, %d, %d, %d)", (int)red, (int)green, (int)blue, (int)alpha)
    glatter_glClearColorIiEXT(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearColorIiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glClearColorIuiEXT, (red, green, blue, alpha), (GLuint red, GLuint green, GLuint blue, GLuint alpha))
GLATTER_INLINE_OR_NOT void glatter_glClearColorIuiEXT_debug(GLuint red, GLuint green, GLuint blue, GLuint alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearColorIuiEXT, "(%u, %u, %u, %u)", (unsigned int)red, (unsigned int)green, (unsigned int)blue, (unsigned int)alpha)
    glatter_glClearColorIuiEXT(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearColorIuiEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTexParameterIivEXT, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIivEXT_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterIivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterIivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterIivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTexParameterIuivEXT, (target, pname, params), (GLenum target, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetTexParameterIuivEXT_debug(GLenum target, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTexParameterIuivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetTexParameterIuivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTexParameterIuivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexParameterIivEXT, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIivEXT_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterIivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterIivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterIivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexParameterIuivEXT, (target, pname, params), (GLenum target, GLenum pname, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glTexParameterIuivEXT_debug(GLenum target, GLenum pname, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexParameterIuivEXT, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glTexParameterIuivEXT(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexParameterIuivEXT_defined
#endif // defined(GL_EXT_texture_integer)
#if defined(GL_EXT_texture_object)
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glAreTexturesResidentEXT, (n, textures, residences), (GLsizei n, const GLuint *textures, GLboolean *residences))
GLATTER_INLINE_OR_NOT GLboolean glatter_glAreTexturesResidentEXT_debug(GLsizei n, const GLuint *textures, GLboolean *residences, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAreTexturesResidentEXT, "(%d, %p, %p)", (int)n, (void*)textures, (void*)residences)
    GLboolean rval = glatter_glAreTexturesResidentEXT(n, textures, residences);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glAreTexturesResidentEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindTextureEXT, (target, texture), (GLenum target, GLuint texture))
GLATTER_INLINE_OR_NOT void glatter_glBindTextureEXT_debug(GLenum target, GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindTextureEXT, "(%s, %u)", enum_to_string_GL(target), (unsigned int)texture)
    glatter_glBindTextureEXT(target, texture);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindTextureEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteTexturesEXT, (n, textures), (GLsizei n, const GLuint *textures))
GLATTER_INLINE_OR_NOT void glatter_glDeleteTexturesEXT_debug(GLsizei n, const GLuint *textures, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteTexturesEXT, "(%d, %p)", (int)n, (void*)textures)
    glatter_glDeleteTexturesEXT(n, textures);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteTexturesEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenTexturesEXT, (n, textures), (GLsizei n, GLuint *textures))
GLATTER_INLINE_OR_NOT void glatter_glGenTexturesEXT_debug(GLsizei n, GLuint *textures, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenTexturesEXT, "(%d, %p)", (int)n, (void*)textures)
    glatter_glGenTexturesEXT(n, textures);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenTexturesEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsTextureEXT, (texture), (GLuint texture))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTextureEXT_debug(GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsTextureEXT, "(%u)", (unsigned int)texture)
    GLboolean rval = glatter_glIsTextureEXT(texture);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsTextureEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPrioritizeTexturesEXT, (n, textures, priorities), (GLsizei n, const GLuint *textures, const GLclampf *priorities))
GLATTER_INLINE_OR_NOT void glatter_glPrioritizeTexturesEXT_debug(GLsizei n, const GLuint *textures, const GLclampf *priorities, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPrioritizeTexturesEXT, "(%d, %p, %p)", (int)n, (void*)textures, (void*)priorities)
    glatter_glPrioritizeTexturesEXT(n, textures, priorities);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPrioritizeTexturesEXT_defined
#endif // defined(GL_EXT_texture_object)
#if defined(GL_EXT_texture_perturb_normal)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTextureNormalEXT, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glTextureNormalEXT_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTextureNormalEXT, "(%s)", enum_to_string_GL(mode))
    glatter_glTextureNormalEXT(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTextureNormalEXT_defined
#endif // defined(GL_EXT_texture_perturb_normal)
#if defined(GL_EXT_timer_query)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetQueryObjecti64vEXT, (id, pname, params), (GLuint id, GLenum pname, GLint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjecti64vEXT_debug(GLuint id, GLenum pname, GLint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryObjecti64vEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryObjecti64vEXT(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryObjecti64vEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetQueryObjectui64vEXT, (id, pname, params), (GLuint id, GLenum pname, GLuint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glGetQueryObjectui64vEXT_debug(GLuint id, GLenum pname, GLuint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetQueryObjectui64vEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetQueryObjectui64vEXT(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetQueryObjectui64vEXT_defined
#endif // defined(GL_EXT_timer_query)
#if defined(GL_EXT_transform_feedback)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBeginTransformFeedbackEXT, (primitiveMode), (GLenum primitiveMode))
GLATTER_INLINE_OR_NOT void glatter_glBeginTransformFeedbackEXT_debug(GLenum primitiveMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginTransformFeedbackEXT, "(%s)", enum_to_string_GL(primitiveMode))
    glatter_glBeginTransformFeedbackEXT(primitiveMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginTransformFeedbackEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindBufferBaseEXT, (target, index, buffer), (GLenum target, GLuint index, GLuint buffer))
GLATTER_INLINE_OR_NOT void glatter_glBindBufferBaseEXT_debug(GLenum target, GLuint index, GLuint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindBufferBaseEXT, "(%s, %u, %u)", enum_to_string_GL(target), (unsigned int)index, (unsigned int)buffer)
    glatter_glBindBufferBaseEXT(target, index, buffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindBufferBaseEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindBufferOffsetEXT, (target, index, buffer, offset), (GLenum target, GLuint index, GLuint buffer, GLintptr offset))
GLATTER_INLINE_OR_NOT void glatter_glBindBufferOffsetEXT_debug(GLenum target, GLuint index, GLuint buffer, GLintptr offset, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindBufferOffsetEXT, "(%s, %u, %u, %s)", enum_to_string_GL(target), (unsigned int)index, (unsigned int)buffer, GET_PRS(offset))
    glatter_glBindBufferOffsetEXT(target, index, buffer, offset);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindBufferOffsetEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindBufferRangeEXT, (target, index, buffer, offset, size), (GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size))
GLATTER_INLINE_OR_NOT void glatter_glBindBufferRangeEXT_debug(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindBufferRangeEXT, "(%s, %u, %u, %s, %s)", enum_to_string_GL(target), (unsigned int)index, (unsigned int)buffer, GET_PRS(offset), GET_PRS(size))
    glatter_glBindBufferRangeEXT(target, index, buffer, offset, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindBufferRangeEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEndTransformFeedbackEXT, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glEndTransformFeedbackEXT_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndTransformFeedbackEXT, "()")
    glatter_glEndTransformFeedbackEXT();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndTransformFeedbackEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetTransformFeedbackVaryingEXT, (program, index, bufSize, length, size, type, name), (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name))
GLATTER_INLINE_OR_NOT void glatter_glGetTransformFeedbackVaryingEXT_debug(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTransformFeedbackVaryingEXT, "(%u, %u, %d, %p, %p, %p, %p)", (unsigned int)program, (unsigned int)index, (int)bufSize, (void*)length, (void*)size, (void*)type, (void*)name)
    glatter_glGetTransformFeedbackVaryingEXT(program, index, bufSize, length, size, type, name);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetTransformFeedbackVaryingEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTransformFeedbackVaryingsEXT, (program, count, varyings, bufferMode), (GLuint program, GLsizei count, const GLchar *const*varyings, GLenum bufferMode))
GLATTER_INLINE_OR_NOT void glatter_glTransformFeedbackVaryingsEXT_debug(GLuint program, GLsizei count, const GLchar *const*varyings, GLenum bufferMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTransformFeedbackVaryingsEXT, "(%u, %d, %p, %s)", (unsigned int)program, (int)count, (void*)varyings, enum_to_string_GL(bufferMode))
    glatter_glTransformFeedbackVaryingsEXT(program, count, varyings, bufferMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTransformFeedbackVaryingsEXT_defined
#endif // defined(GL_EXT_transform_feedback)
#if defined(GL_EXT_vertex_array)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glArrayElementEXT, (i), (GLint i))
GLATTER_INLINE_OR_NOT void glatter_glArrayElementEXT_debug(GLint i, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glArrayElementEXT, "(%d)", (int)i)
    glatter_glArrayElementEXT(i);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glArrayElementEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorPointerEXT, (size, type, stride, count, pointer), (GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glColorPointerEXT_debug(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorPointerEXT, "(%d, %s, %d, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (int)count, (void*)pointer)
    glatter_glColorPointerEXT(size, type, stride, count, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorPointerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawArraysEXT, (mode, first, count), (GLenum mode, GLint first, GLsizei count))
GLATTER_INLINE_OR_NOT void glatter_glDrawArraysEXT_debug(GLenum mode, GLint first, GLsizei count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawArraysEXT, "(%s, %d, %d)", enum_to_string_GL(mode), (int)first, (int)count)
    glatter_glDrawArraysEXT(mode, first, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawArraysEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEdgeFlagPointerEXT, (stride, count, pointer), (GLsizei stride, GLsizei count, const GLboolean *pointer))
GLATTER_INLINE_OR_NOT void glatter_glEdgeFlagPointerEXT_debug(GLsizei stride, GLsizei count, const GLboolean *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEdgeFlagPointerEXT, "(%d, %d, %p)", (int)stride, (int)count, (void*)pointer)
    glatter_glEdgeFlagPointerEXT(stride, count, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEdgeFlagPointerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPointervEXT, (pname, params), (GLenum pname, void **params))
GLATTER_INLINE_OR_NOT void glatter_glGetPointervEXT_debug(GLenum pname, void **params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPointervEXT, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glGetPointervEXT(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPointervEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glIndexPointerEXT, (type, stride, count, pointer), (GLenum type, GLsizei stride, GLsizei count, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glIndexPointerEXT_debug(GLenum type, GLsizei stride, GLsizei count, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexPointerEXT, "(%s, %d, %d, %p)", enum_to_string_GL(type), (int)stride, (int)count, (void*)pointer)
    glatter_glIndexPointerEXT(type, stride, count, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexPointerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalPointerEXT, (type, stride, count, pointer), (GLenum type, GLsizei stride, GLsizei count, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glNormalPointerEXT_debug(GLenum type, GLsizei stride, GLsizei count, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalPointerEXT, "(%s, %d, %d, %p)", enum_to_string_GL(type), (int)stride, (int)count, (void*)pointer)
    glatter_glNormalPointerEXT(type, stride, count, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalPointerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexCoordPointerEXT, (size, type, stride, count, pointer), (GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glTexCoordPointerEXT_debug(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoordPointerEXT, "(%d, %s, %d, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (int)count, (void*)pointer)
    glatter_glTexCoordPointerEXT(size, type, stride, count, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoordPointerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexPointerEXT, (size, type, stride, count, pointer), (GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glVertexPointerEXT_debug(GLint size, GLenum type, GLsizei stride, GLsizei count, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexPointerEXT, "(%d, %s, %d, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (int)count, (void*)pointer)
    glatter_glVertexPointerEXT(size, type, stride, count, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexPointerEXT_defined
#endif // defined(GL_EXT_vertex_array)
#if defined(GL_EXT_vertex_attrib_64bit)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVertexAttribLdvEXT, (index, pname, params), (GLuint index, GLenum pname, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVertexAttribLdvEXT_debug(GLuint index, GLenum pname, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVertexAttribLdvEXT, "(%u, %s, %p)", (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVertexAttribLdvEXT(index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVertexAttribLdvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribL1dEXT, (index, x), (GLuint index, GLdouble x))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1dEXT_debug(GLuint index, GLdouble x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribL1dEXT, "(%u, %f)", (unsigned int)index, (double)x)
    glatter_glVertexAttribL1dEXT(index, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribL1dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribL1dvEXT, (index, v), (GLuint index, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL1dvEXT_debug(GLuint index, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribL1dvEXT, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttribL1dvEXT(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribL1dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribL2dEXT, (index, x, y), (GLuint index, GLdouble x, GLdouble y))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL2dEXT_debug(GLuint index, GLdouble x, GLdouble y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribL2dEXT, "(%u, %f, %f)", (unsigned int)index, (double)x, (double)y)
    glatter_glVertexAttribL2dEXT(index, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribL2dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribL2dvEXT, (index, v), (GLuint index, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL2dvEXT_debug(GLuint index, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribL2dvEXT, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttribL2dvEXT(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribL2dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribL3dEXT, (index, x, y, z), (GLuint index, GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL3dEXT_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribL3dEXT, "(%u, %f, %f, %f)", (unsigned int)index, (double)x, (double)y, (double)z)
    glatter_glVertexAttribL3dEXT(index, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribL3dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribL3dvEXT, (index, v), (GLuint index, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL3dvEXT_debug(GLuint index, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribL3dvEXT, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttribL3dvEXT(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribL3dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribL4dEXT, (index, x, y, z, w), (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL4dEXT_debug(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribL4dEXT, "(%u, %f, %f, %f, %f)", (unsigned int)index, (double)x, (double)y, (double)z, (double)w)
    glatter_glVertexAttribL4dEXT(index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribL4dEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribL4dvEXT, (index, v), (GLuint index, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribL4dvEXT_debug(GLuint index, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribL4dvEXT, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttribL4dvEXT(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribL4dvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribLPointerEXT, (index, size, type, stride, pointer), (GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribLPointerEXT_debug(GLuint index, GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribLPointerEXT, "(%u, %d, %s, %d, %p)", (unsigned int)index, (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glVertexAttribLPointerEXT(index, size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribLPointerEXT_defined
#endif // defined(GL_EXT_vertex_attrib_64bit)
#if defined(GL_EXT_vertex_shader)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBeginVertexShaderEXT, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glBeginVertexShaderEXT_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginVertexShaderEXT, "()")
    glatter_glBeginVertexShaderEXT();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginVertexShaderEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glBindLightParameterEXT, (light, value), (GLenum light, GLenum value))
GLATTER_INLINE_OR_NOT GLuint glatter_glBindLightParameterEXT_debug(GLenum light, GLenum value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindLightParameterEXT, "(%s, %s)", enum_to_string_GL(light), enum_to_string_GL(value))
    GLuint rval = glatter_glBindLightParameterEXT(light, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glBindLightParameterEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glBindMaterialParameterEXT, (face, value), (GLenum face, GLenum value))
GLATTER_INLINE_OR_NOT GLuint glatter_glBindMaterialParameterEXT_debug(GLenum face, GLenum value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindMaterialParameterEXT, "(%s, %s)", enum_to_string_GL(face), enum_to_string_GL(value))
    GLuint rval = glatter_glBindMaterialParameterEXT(face, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glBindMaterialParameterEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glBindParameterEXT, (value), (GLenum value))
GLATTER_INLINE_OR_NOT GLuint glatter_glBindParameterEXT_debug(GLenum value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindParameterEXT, "(%s)", enum_to_string_GL(value))
    GLuint rval = glatter_glBindParameterEXT(value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glBindParameterEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glBindTexGenParameterEXT, (unit, coord, value), (GLenum unit, GLenum coord, GLenum value))
GLATTER_INLINE_OR_NOT GLuint glatter_glBindTexGenParameterEXT_debug(GLenum unit, GLenum coord, GLenum value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindTexGenParameterEXT, "(%s, %s, %s)", enum_to_string_GL(unit), enum_to_string_GL(coord), enum_to_string_GL(value))
    GLuint rval = glatter_glBindTexGenParameterEXT(unit, coord, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glBindTexGenParameterEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glBindTextureUnitParameterEXT, (unit, value), (GLenum unit, GLenum value))
GLATTER_INLINE_OR_NOT GLuint glatter_glBindTextureUnitParameterEXT_debug(GLenum unit, GLenum value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindTextureUnitParameterEXT, "(%s, %s)", enum_to_string_GL(unit), enum_to_string_GL(value))
    GLuint rval = glatter_glBindTextureUnitParameterEXT(unit, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glBindTextureUnitParameterEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBindVertexShaderEXT, (id), (GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glBindVertexShaderEXT_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBindVertexShaderEXT, "(%u)", (unsigned int)id)
    glatter_glBindVertexShaderEXT(id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBindVertexShaderEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteVertexShaderEXT, (id), (GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glDeleteVertexShaderEXT_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteVertexShaderEXT, "(%u)", (unsigned int)id)
    glatter_glDeleteVertexShaderEXT(id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteVertexShaderEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDisableVariantClientStateEXT, (id), (GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glDisableVariantClientStateEXT_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDisableVariantClientStateEXT, "(%u)", (unsigned int)id)
    glatter_glDisableVariantClientStateEXT(id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDisableVariantClientStateEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEnableVariantClientStateEXT, (id), (GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glEnableVariantClientStateEXT_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEnableVariantClientStateEXT, "(%u)", (unsigned int)id)
    glatter_glEnableVariantClientStateEXT(id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEnableVariantClientStateEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEndVertexShaderEXT, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glEndVertexShaderEXT_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndVertexShaderEXT, "()")
    glatter_glEndVertexShaderEXT();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndVertexShaderEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glExtractComponentEXT, (res, src, num), (GLuint res, GLuint src, GLuint num))
GLATTER_INLINE_OR_NOT void glatter_glExtractComponentEXT_debug(GLuint res, GLuint src, GLuint num, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glExtractComponentEXT, "(%u, %u, %u)", (unsigned int)res, (unsigned int)src, (unsigned int)num)
    glatter_glExtractComponentEXT(res, src, num);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glExtractComponentEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glGenSymbolsEXT, (datatype, storagetype, range, components), (GLenum datatype, GLenum storagetype, GLenum range, GLuint components))
GLATTER_INLINE_OR_NOT GLuint glatter_glGenSymbolsEXT_debug(GLenum datatype, GLenum storagetype, GLenum range, GLuint components, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenSymbolsEXT, "(%s, %s, %s, %u)", enum_to_string_GL(datatype), enum_to_string_GL(storagetype), enum_to_string_GL(range), (unsigned int)components)
    GLuint rval = glatter_glGenSymbolsEXT(datatype, storagetype, range, components);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGenSymbolsEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glGenVertexShadersEXT, (range), (GLuint range))
GLATTER_INLINE_OR_NOT GLuint glatter_glGenVertexShadersEXT_debug(GLuint range, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenVertexShadersEXT, "(%u)", (unsigned int)range)
    GLuint rval = glatter_glGenVertexShadersEXT(range);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGenVertexShadersEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetInvariantBooleanvEXT, (id, value, data), (GLuint id, GLenum value, GLboolean *data))
GLATTER_INLINE_OR_NOT void glatter_glGetInvariantBooleanvEXT_debug(GLuint id, GLenum value, GLboolean *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetInvariantBooleanvEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(value), (void*)data)
    glatter_glGetInvariantBooleanvEXT(id, value, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetInvariantBooleanvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetInvariantFloatvEXT, (id, value, data), (GLuint id, GLenum value, GLfloat *data))
GLATTER_INLINE_OR_NOT void glatter_glGetInvariantFloatvEXT_debug(GLuint id, GLenum value, GLfloat *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetInvariantFloatvEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(value), (void*)data)
    glatter_glGetInvariantFloatvEXT(id, value, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetInvariantFloatvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetInvariantIntegervEXT, (id, value, data), (GLuint id, GLenum value, GLint *data))
GLATTER_INLINE_OR_NOT void glatter_glGetInvariantIntegervEXT_debug(GLuint id, GLenum value, GLint *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetInvariantIntegervEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(value), (void*)data)
    glatter_glGetInvariantIntegervEXT(id, value, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetInvariantIntegervEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetLocalConstantBooleanvEXT, (id, value, data), (GLuint id, GLenum value, GLboolean *data))
GLATTER_INLINE_OR_NOT void glatter_glGetLocalConstantBooleanvEXT_debug(GLuint id, GLenum value, GLboolean *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetLocalConstantBooleanvEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(value), (void*)data)
    glatter_glGetLocalConstantBooleanvEXT(id, value, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetLocalConstantBooleanvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetLocalConstantFloatvEXT, (id, value, data), (GLuint id, GLenum value, GLfloat *data))
GLATTER_INLINE_OR_NOT void glatter_glGetLocalConstantFloatvEXT_debug(GLuint id, GLenum value, GLfloat *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetLocalConstantFloatvEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(value), (void*)data)
    glatter_glGetLocalConstantFloatvEXT(id, value, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetLocalConstantFloatvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetLocalConstantIntegervEXT, (id, value, data), (GLuint id, GLenum value, GLint *data))
GLATTER_INLINE_OR_NOT void glatter_glGetLocalConstantIntegervEXT_debug(GLuint id, GLenum value, GLint *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetLocalConstantIntegervEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(value), (void*)data)
    glatter_glGetLocalConstantIntegervEXT(id, value, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetLocalConstantIntegervEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVariantBooleanvEXT, (id, value, data), (GLuint id, GLenum value, GLboolean *data))
GLATTER_INLINE_OR_NOT void glatter_glGetVariantBooleanvEXT_debug(GLuint id, GLenum value, GLboolean *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVariantBooleanvEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(value), (void*)data)
    glatter_glGetVariantBooleanvEXT(id, value, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVariantBooleanvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVariantFloatvEXT, (id, value, data), (GLuint id, GLenum value, GLfloat *data))
GLATTER_INLINE_OR_NOT void glatter_glGetVariantFloatvEXT_debug(GLuint id, GLenum value, GLfloat *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVariantFloatvEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(value), (void*)data)
    glatter_glGetVariantFloatvEXT(id, value, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVariantFloatvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVariantIntegervEXT, (id, value, data), (GLuint id, GLenum value, GLint *data))
GLATTER_INLINE_OR_NOT void glatter_glGetVariantIntegervEXT_debug(GLuint id, GLenum value, GLint *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVariantIntegervEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(value), (void*)data)
    glatter_glGetVariantIntegervEXT(id, value, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVariantIntegervEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVariantPointervEXT, (id, value, data), (GLuint id, GLenum value, void **data))
GLATTER_INLINE_OR_NOT void glatter_glGetVariantPointervEXT_debug(GLuint id, GLenum value, void **data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVariantPointervEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(value), (void*)data)
    glatter_glGetVariantPointervEXT(id, value, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVariantPointervEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glInsertComponentEXT, (res, src, num), (GLuint res, GLuint src, GLuint num))
GLATTER_INLINE_OR_NOT void glatter_glInsertComponentEXT_debug(GLuint res, GLuint src, GLuint num, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glInsertComponentEXT, "(%u, %u, %u)", (unsigned int)res, (unsigned int)src, (unsigned int)num)
    glatter_glInsertComponentEXT(res, src, num);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glInsertComponentEXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsVariantEnabledEXT, (id, cap), (GLuint id, GLenum cap))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsVariantEnabledEXT_debug(GLuint id, GLenum cap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsVariantEnabledEXT, "(%u, %s)", (unsigned int)id, enum_to_string_GL(cap))
    GLboolean rval = glatter_glIsVariantEnabledEXT(id, cap);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsVariantEnabledEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSetInvariantEXT, (id, type, addr), (GLuint id, GLenum type, const void *addr))
GLATTER_INLINE_OR_NOT void glatter_glSetInvariantEXT_debug(GLuint id, GLenum type, const void *addr, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSetInvariantEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(type), (void*)addr)
    glatter_glSetInvariantEXT(id, type, addr);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSetInvariantEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSetLocalConstantEXT, (id, type, addr), (GLuint id, GLenum type, const void *addr))
GLATTER_INLINE_OR_NOT void glatter_glSetLocalConstantEXT_debug(GLuint id, GLenum type, const void *addr, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSetLocalConstantEXT, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(type), (void*)addr)
    glatter_glSetLocalConstantEXT(id, type, addr);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSetLocalConstantEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glShaderOp1EXT, (op, res, arg1), (GLenum op, GLuint res, GLuint arg1))
GLATTER_INLINE_OR_NOT void glatter_glShaderOp1EXT_debug(GLenum op, GLuint res, GLuint arg1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glShaderOp1EXT, "(%s, %u, %u)", enum_to_string_GL(op), (unsigned int)res, (unsigned int)arg1)
    glatter_glShaderOp1EXT(op, res, arg1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glShaderOp1EXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glShaderOp2EXT, (op, res, arg1, arg2), (GLenum op, GLuint res, GLuint arg1, GLuint arg2))
GLATTER_INLINE_OR_NOT void glatter_glShaderOp2EXT_debug(GLenum op, GLuint res, GLuint arg1, GLuint arg2, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glShaderOp2EXT, "(%s, %u, %u, %u)", enum_to_string_GL(op), (unsigned int)res, (unsigned int)arg1, (unsigned int)arg2)
    glatter_glShaderOp2EXT(op, res, arg1, arg2);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glShaderOp2EXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glShaderOp3EXT, (op, res, arg1, arg2, arg3), (GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3))
GLATTER_INLINE_OR_NOT void glatter_glShaderOp3EXT_debug(GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glShaderOp3EXT, "(%s, %u, %u, %u, %u)", enum_to_string_GL(op), (unsigned int)res, (unsigned int)arg1, (unsigned int)arg2, (unsigned int)arg3)
    glatter_glShaderOp3EXT(op, res, arg1, arg2, arg3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glShaderOp3EXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSwizzleEXT, (res, in, outX, outY, outZ, outW), (GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW))
GLATTER_INLINE_OR_NOT void glatter_glSwizzleEXT_debug(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSwizzleEXT, "(%u, %u, %s, %s, %s, %s)", (unsigned int)res, (unsigned int)in, enum_to_string_GL(outX), enum_to_string_GL(outY), enum_to_string_GL(outZ), enum_to_string_GL(outW))
    glatter_glSwizzleEXT(res, in, outX, outY, outZ, outW);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSwizzleEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVariantPointerEXT, (id, type, stride, addr), (GLuint id, GLenum type, GLuint stride, const void *addr))
GLATTER_INLINE_OR_NOT void glatter_glVariantPointerEXT_debug(GLuint id, GLenum type, GLuint stride, const void *addr, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVariantPointerEXT, "(%u, %s, %u, %p)", (unsigned int)id, enum_to_string_GL(type), (unsigned int)stride, (void*)addr)
    glatter_glVariantPointerEXT(id, type, stride, addr);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVariantPointerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVariantbvEXT, (id, addr), (GLuint id, const GLbyte *addr))
GLATTER_INLINE_OR_NOT void glatter_glVariantbvEXT_debug(GLuint id, const GLbyte *addr, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVariantbvEXT, "(%u, %p)", (unsigned int)id, (void*)addr)
    glatter_glVariantbvEXT(id, addr);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVariantbvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVariantdvEXT, (id, addr), (GLuint id, const GLdouble *addr))
GLATTER_INLINE_OR_NOT void glatter_glVariantdvEXT_debug(GLuint id, const GLdouble *addr, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVariantdvEXT, "(%u, %p)", (unsigned int)id, (void*)addr)
    glatter_glVariantdvEXT(id, addr);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVariantdvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVariantfvEXT, (id, addr), (GLuint id, const GLfloat *addr))
GLATTER_INLINE_OR_NOT void glatter_glVariantfvEXT_debug(GLuint id, const GLfloat *addr, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVariantfvEXT, "(%u, %p)", (unsigned int)id, (void*)addr)
    glatter_glVariantfvEXT(id, addr);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVariantfvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVariantivEXT, (id, addr), (GLuint id, const GLint *addr))
GLATTER_INLINE_OR_NOT void glatter_glVariantivEXT_debug(GLuint id, const GLint *addr, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVariantivEXT, "(%u, %p)", (unsigned int)id, (void*)addr)
    glatter_glVariantivEXT(id, addr);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVariantivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVariantsvEXT, (id, addr), (GLuint id, const GLshort *addr))
GLATTER_INLINE_OR_NOT void glatter_glVariantsvEXT_debug(GLuint id, const GLshort *addr, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVariantsvEXT, "(%u, %p)", (unsigned int)id, (void*)addr)
    glatter_glVariantsvEXT(id, addr);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVariantsvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVariantubvEXT, (id, addr), (GLuint id, const GLubyte *addr))
GLATTER_INLINE_OR_NOT void glatter_glVariantubvEXT_debug(GLuint id, const GLubyte *addr, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVariantubvEXT, "(%u, %p)", (unsigned int)id, (void*)addr)
    glatter_glVariantubvEXT(id, addr);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVariantubvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVariantuivEXT, (id, addr), (GLuint id, const GLuint *addr))
GLATTER_INLINE_OR_NOT void glatter_glVariantuivEXT_debug(GLuint id, const GLuint *addr, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVariantuivEXT, "(%u, %p)", (unsigned int)id, (void*)addr)
    glatter_glVariantuivEXT(id, addr);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVariantuivEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVariantusvEXT, (id, addr), (GLuint id, const GLushort *addr))
GLATTER_INLINE_OR_NOT void glatter_glVariantusvEXT_debug(GLuint id, const GLushort *addr, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVariantusvEXT, "(%u, %p)", (unsigned int)id, (void*)addr)
    glatter_glVariantusvEXT(id, addr);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVariantusvEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWriteMaskEXT, (res, in, outX, outY, outZ, outW), (GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW))
GLATTER_INLINE_OR_NOT void glatter_glWriteMaskEXT_debug(GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWriteMaskEXT, "(%u, %u, %s, %s, %s, %s)", (unsigned int)res, (unsigned int)in, enum_to_string_GL(outX), enum_to_string_GL(outY), enum_to_string_GL(outZ), enum_to_string_GL(outW))
    glatter_glWriteMaskEXT(res, in, outX, outY, outZ, outW);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWriteMaskEXT_defined
#endif // defined(GL_EXT_vertex_shader)
#if defined(GL_EXT_vertex_weighting)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexWeightPointerEXT, (size, type, stride, pointer), (GLint size, GLenum type, GLsizei stride, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glVertexWeightPointerEXT_debug(GLint size, GLenum type, GLsizei stride, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexWeightPointerEXT, "(%d, %s, %d, %p)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer)
    glatter_glVertexWeightPointerEXT(size, type, stride, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexWeightPointerEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexWeightfEXT, (weight), (GLfloat weight))
GLATTER_INLINE_OR_NOT void glatter_glVertexWeightfEXT_debug(GLfloat weight, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexWeightfEXT, "(%f)", (float)weight)
    glatter_glVertexWeightfEXT(weight);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexWeightfEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexWeightfvEXT, (weight), (const GLfloat *weight))
GLATTER_INLINE_OR_NOT void glatter_glVertexWeightfvEXT_debug(const GLfloat *weight, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexWeightfvEXT, "(%p)", (void*)weight)
    glatter_glVertexWeightfvEXT(weight);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexWeightfvEXT_defined
#endif // defined(GL_EXT_vertex_weighting)
#if defined(GL_EXT_win32_keyed_mutex)
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glAcquireKeyedMutexWin32EXT, (memory, key, timeout), (GLuint memory, GLuint64 key, GLuint timeout))
GLATTER_INLINE_OR_NOT GLboolean glatter_glAcquireKeyedMutexWin32EXT_debug(GLuint memory, GLuint64 key, GLuint timeout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAcquireKeyedMutexWin32EXT, "(%u, %" PRIu64 ", %u)", (unsigned int)memory, (uint64_t)key, (unsigned int)timeout)
    GLboolean rval = glatter_glAcquireKeyedMutexWin32EXT(memory, key, timeout);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glAcquireKeyedMutexWin32EXT_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glReleaseKeyedMutexWin32EXT, (memory, key), (GLuint memory, GLuint64 key))
GLATTER_INLINE_OR_NOT GLboolean glatter_glReleaseKeyedMutexWin32EXT_debug(GLuint memory, GLuint64 key, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glReleaseKeyedMutexWin32EXT, "(%u, %" PRIu64 ")", (unsigned int)memory, (uint64_t)key)
    GLboolean rval = glatter_glReleaseKeyedMutexWin32EXT(memory, key);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glReleaseKeyedMutexWin32EXT_defined
#endif // defined(GL_EXT_win32_keyed_mutex)
#if defined(GL_EXT_window_rectangles)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowRectanglesEXT, (mode, count, box), (GLenum mode, GLsizei count, const GLint *box))
GLATTER_INLINE_OR_NOT void glatter_glWindowRectanglesEXT_debug(GLenum mode, GLsizei count, const GLint *box, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowRectanglesEXT, "(%s, %d, %p)", enum_to_string_GL(mode), (int)count, (void*)box)
    glatter_glWindowRectanglesEXT(mode, count, box);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowRectanglesEXT_defined
#endif // defined(GL_EXT_window_rectangles)
#if defined(GL_EXT_x11_sync_object)
GLATTER_FBLOCK(return, GL, GLAPI, GLsync, APIENTRY, glImportSyncEXT, (external_sync_type, external_sync, flags), (GLenum external_sync_type, GLintptr external_sync, GLbitfield flags))
GLATTER_INLINE_OR_NOT GLsync glatter_glImportSyncEXT_debug(GLenum external_sync_type, GLintptr external_sync, GLbitfield flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImportSyncEXT, "(%s, %s, %u)", enum_to_string_GL(external_sync_type), GET_PRS(external_sync), (unsigned int)flags)
    GLsync rval = glatter_glImportSyncEXT(external_sync_type, external_sync, flags);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glImportSyncEXT_defined
#endif // defined(GL_EXT_x11_sync_object)
#if defined(GL_GREMEDY_frame_terminator)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFrameTerminatorGREMEDY, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glFrameTerminatorGREMEDY_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFrameTerminatorGREMEDY, "()")
    glatter_glFrameTerminatorGREMEDY();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFrameTerminatorGREMEDY_defined
#endif // defined(GL_GREMEDY_frame_terminator)
#if defined(GL_GREMEDY_string_marker)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStringMarkerGREMEDY, (len, string), (GLsizei len, const void *string))
GLATTER_INLINE_OR_NOT void glatter_glStringMarkerGREMEDY_debug(GLsizei len, const void *string, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStringMarkerGREMEDY, "(%d, %p)", (int)len, (void*)string)
    glatter_glStringMarkerGREMEDY(len, string);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStringMarkerGREMEDY_defined
#endif // defined(GL_GREMEDY_string_marker)
#if defined(GL_HP_image_transform)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetImageTransformParameterfvHP, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetImageTransformParameterfvHP_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetImageTransformParameterfvHP, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetImageTransformParameterfvHP(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetImageTransformParameterfvHP_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetImageTransformParameterivHP, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetImageTransformParameterivHP_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetImageTransformParameterivHP, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetImageTransformParameterivHP(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetImageTransformParameterivHP_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glImageTransformParameterfHP, (target, pname, param), (GLenum target, GLenum pname, GLfloat param))
GLATTER_INLINE_OR_NOT void glatter_glImageTransformParameterfHP_debug(GLenum target, GLenum pname, GLfloat param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImageTransformParameterfHP, "(%s, %s, %f)", enum_to_string_GL(target), enum_to_string_GL(pname), (float)param)
    glatter_glImageTransformParameterfHP(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImageTransformParameterfHP_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glImageTransformParameterfvHP, (target, pname, params), (GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glImageTransformParameterfvHP_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImageTransformParameterfvHP, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glImageTransformParameterfvHP(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImageTransformParameterfvHP_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glImageTransformParameteriHP, (target, pname, param), (GLenum target, GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glImageTransformParameteriHP_debug(GLenum target, GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImageTransformParameteriHP, "(%s, %s, %d)", enum_to_string_GL(target), enum_to_string_GL(pname), (int)param)
    glatter_glImageTransformParameteriHP(target, pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImageTransformParameteriHP_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glImageTransformParameterivHP, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glImageTransformParameterivHP_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glImageTransformParameterivHP, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glImageTransformParameterivHP(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glImageTransformParameterivHP_defined
#endif // defined(GL_HP_image_transform)
#if defined(GL_IBM_multimode_draw_arrays)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiModeDrawArraysIBM, (mode, first, count, primcount, modestride), (const GLenum *mode, const GLint *first, const GLsizei *count, GLsizei primcount, GLint modestride))
GLATTER_INLINE_OR_NOT void glatter_glMultiModeDrawArraysIBM_debug(const GLenum *mode, const GLint *first, const GLsizei *count, GLsizei primcount, GLint modestride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiModeDrawArraysIBM, "(%p, %p, %p, %d, %d)", (void*)mode, (void*)first, (void*)count, (int)primcount, (int)modestride)
    glatter_glMultiModeDrawArraysIBM(mode, first, count, primcount, modestride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiModeDrawArraysIBM_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiModeDrawElementsIBM, (mode, count, type, indices, primcount, modestride), (const GLenum *mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount, GLint modestride))
GLATTER_INLINE_OR_NOT void glatter_glMultiModeDrawElementsIBM_debug(const GLenum *mode, const GLsizei *count, GLenum type, const void *const*indices, GLsizei primcount, GLint modestride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiModeDrawElementsIBM, "(%p, %p, %s, %p, %d, %d)", (void*)mode, (void*)count, enum_to_string_GL(type), (void*)indices, (int)primcount, (int)modestride)
    glatter_glMultiModeDrawElementsIBM(mode, count, type, indices, primcount, modestride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiModeDrawElementsIBM_defined
#endif // defined(GL_IBM_multimode_draw_arrays)
#if defined(GL_IBM_static_data)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFlushStaticDataIBM, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glFlushStaticDataIBM_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFlushStaticDataIBM, "(%s)", enum_to_string_GL(target))
    glatter_glFlushStaticDataIBM(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFlushStaticDataIBM_defined
#endif // defined(GL_IBM_static_data)
#if defined(GL_IBM_vertex_array_lists)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorPointerListIBM, (size, type, stride, pointer, ptrstride), (GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride))
GLATTER_INLINE_OR_NOT void glatter_glColorPointerListIBM_debug(GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorPointerListIBM, "(%d, %s, %d, %p, %d)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer, (int)ptrstride)
    glatter_glColorPointerListIBM(size, type, stride, pointer, ptrstride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorPointerListIBM_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEdgeFlagPointerListIBM, (stride, pointer, ptrstride), (GLint stride, const GLboolean **pointer, GLint ptrstride))
GLATTER_INLINE_OR_NOT void glatter_glEdgeFlagPointerListIBM_debug(GLint stride, const GLboolean **pointer, GLint ptrstride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEdgeFlagPointerListIBM, "(%d, %p, %d)", (int)stride, (void*)pointer, (int)ptrstride)
    glatter_glEdgeFlagPointerListIBM(stride, pointer, ptrstride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEdgeFlagPointerListIBM_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFogCoordPointerListIBM, (type, stride, pointer, ptrstride), (GLenum type, GLint stride, const void **pointer, GLint ptrstride))
GLATTER_INLINE_OR_NOT void glatter_glFogCoordPointerListIBM_debug(GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogCoordPointerListIBM, "(%s, %d, %p, %d)", enum_to_string_GL(type), (int)stride, (void*)pointer, (int)ptrstride)
    glatter_glFogCoordPointerListIBM(type, stride, pointer, ptrstride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogCoordPointerListIBM_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glIndexPointerListIBM, (type, stride, pointer, ptrstride), (GLenum type, GLint stride, const void **pointer, GLint ptrstride))
GLATTER_INLINE_OR_NOT void glatter_glIndexPointerListIBM_debug(GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIndexPointerListIBM, "(%s, %d, %p, %d)", enum_to_string_GL(type), (int)stride, (void*)pointer, (int)ptrstride)
    glatter_glIndexPointerListIBM(type, stride, pointer, ptrstride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glIndexPointerListIBM_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalPointerListIBM, (type, stride, pointer, ptrstride), (GLenum type, GLint stride, const void **pointer, GLint ptrstride))
GLATTER_INLINE_OR_NOT void glatter_glNormalPointerListIBM_debug(GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalPointerListIBM, "(%s, %d, %p, %d)", enum_to_string_GL(type), (int)stride, (void*)pointer, (int)ptrstride)
    glatter_glNormalPointerListIBM(type, stride, pointer, ptrstride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalPointerListIBM_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColorPointerListIBM, (size, type, stride, pointer, ptrstride), (GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColorPointerListIBM_debug(GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColorPointerListIBM, "(%d, %s, %d, %p, %d)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer, (int)ptrstride)
    glatter_glSecondaryColorPointerListIBM(size, type, stride, pointer, ptrstride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColorPointerListIBM_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexCoordPointerListIBM, (size, type, stride, pointer, ptrstride), (GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride))
GLATTER_INLINE_OR_NOT void glatter_glTexCoordPointerListIBM_debug(GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoordPointerListIBM, "(%d, %s, %d, %p, %d)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer, (int)ptrstride)
    glatter_glTexCoordPointerListIBM(size, type, stride, pointer, ptrstride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoordPointerListIBM_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexPointerListIBM, (size, type, stride, pointer, ptrstride), (GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride))
GLATTER_INLINE_OR_NOT void glatter_glVertexPointerListIBM_debug(GLint size, GLenum type, GLint stride, const void **pointer, GLint ptrstride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexPointerListIBM, "(%d, %s, %d, %p, %d)", (int)size, enum_to_string_GL(type), (int)stride, (void*)pointer, (int)ptrstride)
    glatter_glVertexPointerListIBM(size, type, stride, pointer, ptrstride);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexPointerListIBM_defined
#endif // defined(GL_IBM_vertex_array_lists)
#if defined(GL_INGR_blend_func_separate)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendFuncSeparateINGR, (sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha), (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha))
GLATTER_INLINE_OR_NOT void glatter_glBlendFuncSeparateINGR_debug(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendFuncSeparateINGR, "(%s, %s, %s, %s)", enum_to_string_GL(sfactorRGB), enum_to_string_GL(dfactorRGB), enum_to_string_GL(sfactorAlpha), enum_to_string_GL(dfactorAlpha))
    glatter_glBlendFuncSeparateINGR(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendFuncSeparateINGR_defined
#endif // defined(GL_INGR_blend_func_separate)
#if defined(GL_INTEL_framebuffer_CMAA)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glApplyFramebufferAttachmentCMAAINTEL, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glApplyFramebufferAttachmentCMAAINTEL_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glApplyFramebufferAttachmentCMAAINTEL, "()")
    glatter_glApplyFramebufferAttachmentCMAAINTEL();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glApplyFramebufferAttachmentCMAAINTEL_defined
#endif // defined(GL_INTEL_framebuffer_CMAA)
#if defined(GL_INTEL_map_texture)
GLATTER_FBLOCK(return, GL, GLAPI, void *, APIENTRY, glMapTexture2DINTEL, (texture, level, access, stride, layout), (GLuint texture, GLint level, GLbitfield access, GLint *stride, GLenum *layout))
GLATTER_INLINE_OR_NOT void * glatter_glMapTexture2DINTEL_debug(GLuint texture, GLint level, GLbitfield access, GLint *stride, GLenum *layout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapTexture2DINTEL, "(%u, %d, %u, %p, %p)", (unsigned int)texture, (int)level, (unsigned int)access, (void*)stride, (void*)layout)
    void * rval = glatter_glMapTexture2DINTEL(texture, level, access, stride, layout);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glMapTexture2DINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSyncTextureINTEL, (texture), (GLuint texture))
GLATTER_INLINE_OR_NOT void glatter_glSyncTextureINTEL_debug(GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSyncTextureINTEL, "(%u)", (unsigned int)texture)
    glatter_glSyncTextureINTEL(texture);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSyncTextureINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUnmapTexture2DINTEL, (texture, level), (GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glUnmapTexture2DINTEL_debug(GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUnmapTexture2DINTEL, "(%u, %d)", (unsigned int)texture, (int)level)
    glatter_glUnmapTexture2DINTEL(texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUnmapTexture2DINTEL_defined
#endif // defined(GL_INTEL_map_texture)
#if defined(GL_INTEL_parallel_arrays)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColorPointervINTEL, (size, type, pointer), (GLint size, GLenum type, const void **pointer))
GLATTER_INLINE_OR_NOT void glatter_glColorPointervINTEL_debug(GLint size, GLenum type, const void **pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColorPointervINTEL, "(%d, %s, %p)", (int)size, enum_to_string_GL(type), (void*)pointer)
    glatter_glColorPointervINTEL(size, type, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColorPointervINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormalPointervINTEL, (type, pointer), (GLenum type, const void **pointer))
GLATTER_INLINE_OR_NOT void glatter_glNormalPointervINTEL_debug(GLenum type, const void **pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormalPointervINTEL, "(%s, %p)", enum_to_string_GL(type), (void*)pointer)
    glatter_glNormalPointervINTEL(type, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormalPointervINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexCoordPointervINTEL, (size, type, pointer), (GLint size, GLenum type, const void **pointer))
GLATTER_INLINE_OR_NOT void glatter_glTexCoordPointervINTEL_debug(GLint size, GLenum type, const void **pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoordPointervINTEL, "(%d, %s, %p)", (int)size, enum_to_string_GL(type), (void*)pointer)
    glatter_glTexCoordPointervINTEL(size, type, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoordPointervINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexPointervINTEL, (size, type, pointer), (GLint size, GLenum type, const void **pointer))
GLATTER_INLINE_OR_NOT void glatter_glVertexPointervINTEL_debug(GLint size, GLenum type, const void **pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexPointervINTEL, "(%d, %s, %p)", (int)size, enum_to_string_GL(type), (void*)pointer)
    glatter_glVertexPointervINTEL(size, type, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexPointervINTEL_defined
#endif // defined(GL_INTEL_parallel_arrays)
#if defined(GL_INTEL_performance_query)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBeginPerfQueryINTEL, (queryHandle), (GLuint queryHandle))
GLATTER_INLINE_OR_NOT void glatter_glBeginPerfQueryINTEL_debug(GLuint queryHandle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginPerfQueryINTEL, "(%u)", (unsigned int)queryHandle)
    glatter_glBeginPerfQueryINTEL(queryHandle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginPerfQueryINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCreatePerfQueryINTEL, (queryId, queryHandle), (GLuint queryId, GLuint *queryHandle))
GLATTER_INLINE_OR_NOT void glatter_glCreatePerfQueryINTEL_debug(GLuint queryId, GLuint *queryHandle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreatePerfQueryINTEL, "(%u, %p)", (unsigned int)queryId, (void*)queryHandle)
    glatter_glCreatePerfQueryINTEL(queryId, queryHandle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCreatePerfQueryINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeletePerfQueryINTEL, (queryHandle), (GLuint queryHandle))
GLATTER_INLINE_OR_NOT void glatter_glDeletePerfQueryINTEL_debug(GLuint queryHandle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeletePerfQueryINTEL, "(%u)", (unsigned int)queryHandle)
    glatter_glDeletePerfQueryINTEL(queryHandle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeletePerfQueryINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEndPerfQueryINTEL, (queryHandle), (GLuint queryHandle))
GLATTER_INLINE_OR_NOT void glatter_glEndPerfQueryINTEL_debug(GLuint queryHandle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndPerfQueryINTEL, "(%u)", (unsigned int)queryHandle)
    glatter_glEndPerfQueryINTEL(queryHandle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndPerfQueryINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetFirstPerfQueryIdINTEL, (queryId), (GLuint *queryId))
GLATTER_INLINE_OR_NOT void glatter_glGetFirstPerfQueryIdINTEL_debug(GLuint *queryId, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFirstPerfQueryIdINTEL, "(%p)", (void*)queryId)
    glatter_glGetFirstPerfQueryIdINTEL(queryId);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFirstPerfQueryIdINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetNextPerfQueryIdINTEL, (queryId, nextQueryId), (GLuint queryId, GLuint *nextQueryId))
GLATTER_INLINE_OR_NOT void glatter_glGetNextPerfQueryIdINTEL_debug(GLuint queryId, GLuint *nextQueryId, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetNextPerfQueryIdINTEL, "(%u, %p)", (unsigned int)queryId, (void*)nextQueryId)
    glatter_glGetNextPerfQueryIdINTEL(queryId, nextQueryId);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetNextPerfQueryIdINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPerfCounterInfoINTEL, (queryId, counterId, counterNameLength, counterName, counterDescLength, counterDesc, counterOffset, counterDataSize, counterTypeEnum, counterDataTypeEnum, rawCounterMaxValue), (GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar *counterName, GLuint counterDescLength, GLchar *counterDesc, GLuint *counterOffset, GLuint *counterDataSize, GLuint *counterTypeEnum, GLuint *counterDataTypeEnum, GLuint64 *rawCounterMaxValue))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfCounterInfoINTEL_debug(GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar *counterName, GLuint counterDescLength, GLchar *counterDesc, GLuint *counterOffset, GLuint *counterDataSize, GLuint *counterTypeEnum, GLuint *counterDataTypeEnum, GLuint64 *rawCounterMaxValue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfCounterInfoINTEL, "(%u, %u, %u, %p, %u, %p, %p, %p, %p, %p, %p)", (unsigned int)queryId, (unsigned int)counterId, (unsigned int)counterNameLength, (void*)counterName, (unsigned int)counterDescLength, (void*)counterDesc, (void*)counterOffset, (void*)counterDataSize, (void*)counterTypeEnum, (void*)counterDataTypeEnum, (void*)rawCounterMaxValue)
    glatter_glGetPerfCounterInfoINTEL(queryId, counterId, counterNameLength, counterName, counterDescLength, counterDesc, counterOffset, counterDataSize, counterTypeEnum, counterDataTypeEnum, rawCounterMaxValue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfCounterInfoINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPerfQueryDataINTEL, (queryHandle, flags, dataSize, data, bytesWritten), (GLuint queryHandle, GLuint flags, GLsizei dataSize, void *data, GLuint *bytesWritten))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfQueryDataINTEL_debug(GLuint queryHandle, GLuint flags, GLsizei dataSize, void *data, GLuint *bytesWritten, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfQueryDataINTEL, "(%u, %u, %d, %p, %p)", (unsigned int)queryHandle, (unsigned int)flags, (int)dataSize, (void*)data, (void*)bytesWritten)
    glatter_glGetPerfQueryDataINTEL(queryHandle, flags, dataSize, data, bytesWritten);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfQueryDataINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPerfQueryIdByNameINTEL, (queryName, queryId), (GLchar *queryName, GLuint *queryId))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfQueryIdByNameINTEL_debug(GLchar *queryName, GLuint *queryId, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfQueryIdByNameINTEL, "(%p, %p)", (void*)queryName, (void*)queryId)
    glatter_glGetPerfQueryIdByNameINTEL(queryName, queryId);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfQueryIdByNameINTEL_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPerfQueryInfoINTEL, (queryId, queryNameLength, queryName, dataSize, noCounters, noInstances, capsMask), (GLuint queryId, GLuint queryNameLength, GLchar *queryName, GLuint *dataSize, GLuint *noCounters, GLuint *noInstances, GLuint *capsMask))
GLATTER_INLINE_OR_NOT void glatter_glGetPerfQueryInfoINTEL_debug(GLuint queryId, GLuint queryNameLength, GLchar *queryName, GLuint *dataSize, GLuint *noCounters, GLuint *noInstances, GLuint *capsMask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPerfQueryInfoINTEL, "(%u, %u, %p, %p, %p, %p, %p)", (unsigned int)queryId, (unsigned int)queryNameLength, (void*)queryName, (void*)dataSize, (void*)noCounters, (void*)noInstances, (void*)capsMask)
    glatter_glGetPerfQueryInfoINTEL(queryId, queryNameLength, queryName, dataSize, noCounters, noInstances, capsMask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPerfQueryInfoINTEL_defined
#endif // defined(GL_INTEL_performance_query)
#if defined(GL_KHR_blend_equation_advanced)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendBarrierKHR, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glBlendBarrierKHR_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendBarrierKHR, "()")
    glatter_glBlendBarrierKHR();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendBarrierKHR_defined
#endif // defined(GL_KHR_blend_equation_advanced)
#if defined(GL_KHR_parallel_shader_compile)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMaxShaderCompilerThreadsKHR, (count), (GLuint count))
GLATTER_INLINE_OR_NOT void glatter_glMaxShaderCompilerThreadsKHR_debug(GLuint count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMaxShaderCompilerThreadsKHR, "(%u)", (unsigned int)count)
    glatter_glMaxShaderCompilerThreadsKHR(count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMaxShaderCompilerThreadsKHR_defined
#endif // defined(GL_KHR_parallel_shader_compile)
#if defined(GL_MESA_resize_buffers)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glResizeBuffersMESA, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glResizeBuffersMESA_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glResizeBuffersMESA, "()")
    glatter_glResizeBuffersMESA();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glResizeBuffersMESA_defined
#endif // defined(GL_MESA_resize_buffers)
#if defined(GL_MESA_window_pos)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2dMESA, (x, y), (GLdouble x, GLdouble y))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2dMESA_debug(GLdouble x, GLdouble y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2dMESA, "(%f, %f)", (double)x, (double)y)
    glatter_glWindowPos2dMESA(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2dMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2dvMESA, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2dvMESA_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2dvMESA, "(%p)", (void*)v)
    glatter_glWindowPos2dvMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2dvMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2fMESA, (x, y), (GLfloat x, GLfloat y))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2fMESA_debug(GLfloat x, GLfloat y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2fMESA, "(%f, %f)", (float)x, (float)y)
    glatter_glWindowPos2fMESA(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2fMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2fvMESA, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2fvMESA_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2fvMESA, "(%p)", (void*)v)
    glatter_glWindowPos2fvMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2fvMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2iMESA, (x, y), (GLint x, GLint y))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2iMESA_debug(GLint x, GLint y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2iMESA, "(%d, %d)", (int)x, (int)y)
    glatter_glWindowPos2iMESA(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2iMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2ivMESA, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2ivMESA_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2ivMESA, "(%p)", (void*)v)
    glatter_glWindowPos2ivMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2ivMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2sMESA, (x, y), (GLshort x, GLshort y))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2sMESA_debug(GLshort x, GLshort y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2sMESA, "(%hi, %hi)", (short)x, (short)y)
    glatter_glWindowPos2sMESA(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2sMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos2svMESA, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos2svMESA_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos2svMESA, "(%p)", (void*)v)
    glatter_glWindowPos2svMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos2svMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3dMESA, (x, y, z), (GLdouble x, GLdouble y, GLdouble z))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3dMESA_debug(GLdouble x, GLdouble y, GLdouble z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3dMESA, "(%f, %f, %f)", (double)x, (double)y, (double)z)
    glatter_glWindowPos3dMESA(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3dMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3dvMESA, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3dvMESA_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3dvMESA, "(%p)", (void*)v)
    glatter_glWindowPos3dvMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3dvMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3fMESA, (x, y, z), (GLfloat x, GLfloat y, GLfloat z))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3fMESA_debug(GLfloat x, GLfloat y, GLfloat z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3fMESA, "(%f, %f, %f)", (float)x, (float)y, (float)z)
    glatter_glWindowPos3fMESA(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3fMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3fvMESA, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3fvMESA_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3fvMESA, "(%p)", (void*)v)
    glatter_glWindowPos3fvMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3fvMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3iMESA, (x, y, z), (GLint x, GLint y, GLint z))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3iMESA_debug(GLint x, GLint y, GLint z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3iMESA, "(%d, %d, %d)", (int)x, (int)y, (int)z)
    glatter_glWindowPos3iMESA(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3iMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3ivMESA, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3ivMESA_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3ivMESA, "(%p)", (void*)v)
    glatter_glWindowPos3ivMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3ivMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3sMESA, (x, y, z), (GLshort x, GLshort y, GLshort z))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3sMESA_debug(GLshort x, GLshort y, GLshort z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3sMESA, "(%hi, %hi, %hi)", (short)x, (short)y, (short)z)
    glatter_glWindowPos3sMESA(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3sMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos3svMESA, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos3svMESA_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos3svMESA, "(%p)", (void*)v)
    glatter_glWindowPos3svMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos3svMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos4dMESA, (x, y, z, w), (GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4dMESA_debug(GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos4dMESA, "(%f, %f, %f, %f)", (double)x, (double)y, (double)z, (double)w)
    glatter_glWindowPos4dMESA(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos4dMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos4dvMESA, (v), (const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4dvMESA_debug(const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos4dvMESA, "(%p)", (void*)v)
    glatter_glWindowPos4dvMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos4dvMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos4fMESA, (x, y, z, w), (GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4fMESA_debug(GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos4fMESA, "(%f, %f, %f, %f)", (float)x, (float)y, (float)z, (float)w)
    glatter_glWindowPos4fMESA(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos4fMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos4fvMESA, (v), (const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4fvMESA_debug(const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos4fvMESA, "(%p)", (void*)v)
    glatter_glWindowPos4fvMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos4fvMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos4iMESA, (x, y, z, w), (GLint x, GLint y, GLint z, GLint w))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4iMESA_debug(GLint x, GLint y, GLint z, GLint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos4iMESA, "(%d, %d, %d, %d)", (int)x, (int)y, (int)z, (int)w)
    glatter_glWindowPos4iMESA(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos4iMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos4ivMESA, (v), (const GLint *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4ivMESA_debug(const GLint *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos4ivMESA, "(%p)", (void*)v)
    glatter_glWindowPos4ivMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos4ivMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos4sMESA, (x, y, z, w), (GLshort x, GLshort y, GLshort z, GLshort w))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4sMESA_debug(GLshort x, GLshort y, GLshort z, GLshort w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos4sMESA, "(%hi, %hi, %hi, %hi)", (short)x, (short)y, (short)z, (short)w)
    glatter_glWindowPos4sMESA(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos4sMESA_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWindowPos4svMESA, (v), (const GLshort *v))
GLATTER_INLINE_OR_NOT void glatter_glWindowPos4svMESA_debug(const GLshort *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWindowPos4svMESA, "(%p)", (void*)v)
    glatter_glWindowPos4svMESA(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWindowPos4svMESA_defined
#endif // defined(GL_MESA_window_pos)
#if defined(GL_NVX_conditional_render)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBeginConditionalRenderNVX, (id), (GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glBeginConditionalRenderNVX_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginConditionalRenderNVX, "(%u)", (unsigned int)id)
    glatter_glBeginConditionalRenderNVX(id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginConditionalRenderNVX_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEndConditionalRenderNVX, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glEndConditionalRenderNVX_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndConditionalRenderNVX, "()")
    glatter_glEndConditionalRenderNVX();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndConditionalRenderNVX_defined
#endif // defined(GL_NVX_conditional_render)
#if defined(GL_NVX_linked_gpu_multicast)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glLGPUCopyImageSubDataNVX, (sourceGpu, destinationGpuMask, srcName, srcTarget, srcLevel, srcX, srxY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth), (GLuint sourceGpu, GLbitfield destinationGpuMask, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srxY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth))
GLATTER_INLINE_OR_NOT void glatter_glLGPUCopyImageSubDataNVX_debug(GLuint sourceGpu, GLbitfield destinationGpuMask, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srxY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLGPUCopyImageSubDataNVX, "(%u, %u, %u, %s, %d, %d, %d, %d, %u, %s, %d, %d, %d, %d, %d, %d, %d)", (unsigned int)sourceGpu, (unsigned int)destinationGpuMask, (unsigned int)srcName, enum_to_string_GL(srcTarget), (int)srcLevel, (int)srcX, (int)srxY, (int)srcZ, (unsigned int)dstName, enum_to_string_GL(dstTarget), (int)dstLevel, (int)dstX, (int)dstY, (int)dstZ, (int)width, (int)height, (int)depth)
    glatter_glLGPUCopyImageSubDataNVX(sourceGpu, destinationGpuMask, srcName, srcTarget, srcLevel, srcX, srxY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLGPUCopyImageSubDataNVX_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glLGPUInterlockNVX, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glLGPUInterlockNVX_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLGPUInterlockNVX, "()")
    glatter_glLGPUInterlockNVX();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLGPUInterlockNVX_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glLGPUNamedBufferSubDataNVX, (gpuMask, buffer, offset, size, data), (GLbitfield gpuMask, GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glLGPUNamedBufferSubDataNVX_debug(GLbitfield gpuMask, GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glLGPUNamedBufferSubDataNVX, "(%u, %u, %s, %s, %p)", (unsigned int)gpuMask, (unsigned int)buffer, GET_PRS(offset), GET_PRS(size), (void*)data)
    glatter_glLGPUNamedBufferSubDataNVX(gpuMask, buffer, offset, size, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glLGPUNamedBufferSubDataNVX_defined
#endif // defined(GL_NVX_linked_gpu_multicast)
#if defined(GL_NV_alpha_to_coverage_dither_control)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glAlphaToCoverageDitherControlNV, (mode), (GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glAlphaToCoverageDitherControlNV_debug(GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glAlphaToCoverageDitherControlNV, "(%s)", enum_to_string_GL(mode))
    glatter_glAlphaToCoverageDitherControlNV(mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glAlphaToCoverageDitherControlNV_defined
#endif // defined(GL_NV_alpha_to_coverage_dither_control)
#if defined(GL_NV_bindless_multi_draw_indirect)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawArraysIndirectBindlessNV, (mode, indirect, drawCount, stride, vertexBufferCount), (GLenum mode, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysIndirectBindlessNV_debug(GLenum mode, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawArraysIndirectBindlessNV, "(%s, %p, %d, %d, %d)", enum_to_string_GL(mode), (void*)indirect, (int)drawCount, (int)stride, (int)vertexBufferCount)
    glatter_glMultiDrawArraysIndirectBindlessNV(mode, indirect, drawCount, stride, vertexBufferCount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawArraysIndirectBindlessNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawElementsIndirectBindlessNV, (mode, type, indirect, drawCount, stride, vertexBufferCount), (GLenum mode, GLenum type, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsIndirectBindlessNV_debug(GLenum mode, GLenum type, const void *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawElementsIndirectBindlessNV, "(%s, %s, %p, %d, %d, %d)", enum_to_string_GL(mode), enum_to_string_GL(type), (void*)indirect, (int)drawCount, (int)stride, (int)vertexBufferCount)
    glatter_glMultiDrawElementsIndirectBindlessNV(mode, type, indirect, drawCount, stride, vertexBufferCount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawElementsIndirectBindlessNV_defined
#endif // defined(GL_NV_bindless_multi_draw_indirect)
#if defined(GL_NV_bindless_multi_draw_indirect_count)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawArraysIndirectBindlessCountNV, (mode, indirect, drawCount, maxDrawCount, stride, vertexBufferCount), (GLenum mode, const void *indirect, GLsizei drawCount, GLsizei maxDrawCount, GLsizei stride, GLint vertexBufferCount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawArraysIndirectBindlessCountNV_debug(GLenum mode, const void *indirect, GLsizei drawCount, GLsizei maxDrawCount, GLsizei stride, GLint vertexBufferCount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawArraysIndirectBindlessCountNV, "(%s, %p, %d, %d, %d, %d)", enum_to_string_GL(mode), (void*)indirect, (int)drawCount, (int)maxDrawCount, (int)stride, (int)vertexBufferCount)
    glatter_glMultiDrawArraysIndirectBindlessCountNV(mode, indirect, drawCount, maxDrawCount, stride, vertexBufferCount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawArraysIndirectBindlessCountNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiDrawElementsIndirectBindlessCountNV, (mode, type, indirect, drawCount, maxDrawCount, stride, vertexBufferCount), (GLenum mode, GLenum type, const void *indirect, GLsizei drawCount, GLsizei maxDrawCount, GLsizei stride, GLint vertexBufferCount))
GLATTER_INLINE_OR_NOT void glatter_glMultiDrawElementsIndirectBindlessCountNV_debug(GLenum mode, GLenum type, const void *indirect, GLsizei drawCount, GLsizei maxDrawCount, GLsizei stride, GLint vertexBufferCount, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiDrawElementsIndirectBindlessCountNV, "(%s, %s, %p, %d, %d, %d, %d)", enum_to_string_GL(mode), enum_to_string_GL(type), (void*)indirect, (int)drawCount, (int)maxDrawCount, (int)stride, (int)vertexBufferCount)
    glatter_glMultiDrawElementsIndirectBindlessCountNV(mode, type, indirect, drawCount, maxDrawCount, stride, vertexBufferCount);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiDrawElementsIndirectBindlessCountNV_defined
#endif // defined(GL_NV_bindless_multi_draw_indirect_count)
#if defined(GL_NV_bindless_texture)
GLATTER_FBLOCK(return, GL, GLAPI, GLuint64, APIENTRY, glGetImageHandleNV, (texture, level, layered, layer, format), (GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format))
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetImageHandleNV_debug(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetImageHandleNV, "(%u, %d, %u, %d, %s)", (unsigned int)texture, (int)level, (unsigned char)layered, (int)layer, enum_to_string_GL(format))
    GLuint64 rval = glatter_glGetImageHandleNV(texture, level, layered, layer, format);
    GLATTER_RBLOCK("%" PRIu64 "\n", (uint64_t)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetImageHandleNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint64, APIENTRY, glGetTextureHandleNV, (texture), (GLuint texture))
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureHandleNV_debug(GLuint texture, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureHandleNV, "(%u)", (unsigned int)texture)
    GLuint64 rval = glatter_glGetTextureHandleNV(texture);
    GLATTER_RBLOCK("%" PRIu64 "\n", (uint64_t)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetTextureHandleNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint64, APIENTRY, glGetTextureSamplerHandleNV, (texture, sampler), (GLuint texture, GLuint sampler))
GLATTER_INLINE_OR_NOT GLuint64 glatter_glGetTextureSamplerHandleNV_debug(GLuint texture, GLuint sampler, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetTextureSamplerHandleNV, "(%u, %u)", (unsigned int)texture, (unsigned int)sampler)
    GLuint64 rval = glatter_glGetTextureSamplerHandleNV(texture, sampler);
    GLATTER_RBLOCK("%" PRIu64 "\n", (uint64_t)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetTextureSamplerHandleNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsImageHandleResidentNV, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsImageHandleResidentNV_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsImageHandleResidentNV, "(%" PRIu64 ")", (uint64_t)handle)
    GLboolean rval = glatter_glIsImageHandleResidentNV(handle);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsImageHandleResidentNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsTextureHandleResidentNV, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsTextureHandleResidentNV_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsTextureHandleResidentNV, "(%" PRIu64 ")", (uint64_t)handle)
    GLboolean rval = glatter_glIsTextureHandleResidentNV(handle);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsTextureHandleResidentNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMakeImageHandleNonResidentNV, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT void glatter_glMakeImageHandleNonResidentNV_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeImageHandleNonResidentNV, "(%" PRIu64 ")", (uint64_t)handle)
    glatter_glMakeImageHandleNonResidentNV(handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeImageHandleNonResidentNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMakeImageHandleResidentNV, (handle, access), (GLuint64 handle, GLenum access))
GLATTER_INLINE_OR_NOT void glatter_glMakeImageHandleResidentNV_debug(GLuint64 handle, GLenum access, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeImageHandleResidentNV, "(%" PRIu64 ", %s)", (uint64_t)handle, enum_to_string_GL(access))
    glatter_glMakeImageHandleResidentNV(handle, access);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeImageHandleResidentNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMakeTextureHandleNonResidentNV, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT void glatter_glMakeTextureHandleNonResidentNV_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeTextureHandleNonResidentNV, "(%" PRIu64 ")", (uint64_t)handle)
    glatter_glMakeTextureHandleNonResidentNV(handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeTextureHandleNonResidentNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMakeTextureHandleResidentNV, (handle), (GLuint64 handle))
GLATTER_INLINE_OR_NOT void glatter_glMakeTextureHandleResidentNV_debug(GLuint64 handle, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMakeTextureHandleResidentNV, "(%" PRIu64 ")", (uint64_t)handle)
    glatter_glMakeTextureHandleResidentNV(handle);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMakeTextureHandleResidentNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformHandleui64NV, (program, location, value), (GLuint program, GLint location, GLuint64 value))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64NV_debug(GLuint program, GLint location, GLuint64 value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformHandleui64NV, "(%u, %d, %" PRIu64 ")", (unsigned int)program, (int)location, (uint64_t)value)
    glatter_glProgramUniformHandleui64NV(program, location, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformHandleui64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramUniformHandleui64vNV, (program, location, count, values), (GLuint program, GLint location, GLsizei count, const GLuint64 *values))
GLATTER_INLINE_OR_NOT void glatter_glProgramUniformHandleui64vNV_debug(GLuint program, GLint location, GLsizei count, const GLuint64 *values, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramUniformHandleui64vNV, "(%u, %d, %d, %p)", (unsigned int)program, (int)location, (int)count, (void*)values)
    glatter_glProgramUniformHandleui64vNV(program, location, count, values);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramUniformHandleui64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniformHandleui64NV, (location, value), (GLint location, GLuint64 value))
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64NV_debug(GLint location, GLuint64 value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformHandleui64NV, "(%d, %" PRIu64 ")", (int)location, (uint64_t)value)
    glatter_glUniformHandleui64NV(location, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformHandleui64NV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glUniformHandleui64vNV, (location, count, value), (GLint location, GLsizei count, const GLuint64 *value))
GLATTER_INLINE_OR_NOT void glatter_glUniformHandleui64vNV_debug(GLint location, GLsizei count, const GLuint64 *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glUniformHandleui64vNV, "(%d, %d, %p)", (int)location, (int)count, (void*)value)
    glatter_glUniformHandleui64vNV(location, count, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glUniformHandleui64vNV_defined
#endif // defined(GL_NV_bindless_texture)
#if defined(GL_NV_blend_equation_advanced)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendBarrierNV, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glBlendBarrierNV_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendBarrierNV, "()")
    glatter_glBlendBarrierNV();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendBarrierNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBlendParameteriNV, (pname, value), (GLenum pname, GLint value))
GLATTER_INLINE_OR_NOT void glatter_glBlendParameteriNV_debug(GLenum pname, GLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBlendParameteriNV, "(%s, %d)", enum_to_string_GL(pname), (int)value)
    glatter_glBlendParameteriNV(pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBlendParameteriNV_defined
#endif // defined(GL_NV_blend_equation_advanced)
#if defined(GL_NV_clip_space_w_scaling)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glViewportPositionWScaleNV, (index, xcoeff, ycoeff), (GLuint index, GLfloat xcoeff, GLfloat ycoeff))
GLATTER_INLINE_OR_NOT void glatter_glViewportPositionWScaleNV_debug(GLuint index, GLfloat xcoeff, GLfloat ycoeff, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glViewportPositionWScaleNV, "(%u, %f, %f)", (unsigned int)index, (float)xcoeff, (float)ycoeff)
    glatter_glViewportPositionWScaleNV(index, xcoeff, ycoeff);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glViewportPositionWScaleNV_defined
#endif // defined(GL_NV_clip_space_w_scaling)
#if defined(GL_NV_command_list)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCallCommandListNV, (list), (GLuint list))
GLATTER_INLINE_OR_NOT void glatter_glCallCommandListNV_debug(GLuint list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCallCommandListNV, "(%u)", (unsigned int)list)
    glatter_glCallCommandListNV(list);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCallCommandListNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCommandListSegmentsNV, (list, segments), (GLuint list, GLuint segments))
GLATTER_INLINE_OR_NOT void glatter_glCommandListSegmentsNV_debug(GLuint list, GLuint segments, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCommandListSegmentsNV, "(%u, %u)", (unsigned int)list, (unsigned int)segments)
    glatter_glCommandListSegmentsNV(list, segments);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCommandListSegmentsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCompileCommandListNV, (list), (GLuint list))
GLATTER_INLINE_OR_NOT void glatter_glCompileCommandListNV_debug(GLuint list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCompileCommandListNV, "(%u)", (unsigned int)list)
    glatter_glCompileCommandListNV(list);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCompileCommandListNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCreateCommandListsNV, (n, lists), (GLsizei n, GLuint *lists))
GLATTER_INLINE_OR_NOT void glatter_glCreateCommandListsNV_debug(GLsizei n, GLuint *lists, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateCommandListsNV, "(%d, %p)", (int)n, (void*)lists)
    glatter_glCreateCommandListsNV(n, lists);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCreateCommandListsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCreateStatesNV, (n, states), (GLsizei n, GLuint *states))
GLATTER_INLINE_OR_NOT void glatter_glCreateStatesNV_debug(GLsizei n, GLuint *states, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCreateStatesNV, "(%d, %p)", (int)n, (void*)states)
    glatter_glCreateStatesNV(n, states);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCreateStatesNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteCommandListsNV, (n, lists), (GLsizei n, const GLuint *lists))
GLATTER_INLINE_OR_NOT void glatter_glDeleteCommandListsNV_debug(GLsizei n, const GLuint *lists, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteCommandListsNV, "(%d, %p)", (int)n, (void*)lists)
    glatter_glDeleteCommandListsNV(n, lists);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteCommandListsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteStatesNV, (n, states), (GLsizei n, const GLuint *states))
GLATTER_INLINE_OR_NOT void glatter_glDeleteStatesNV_debug(GLsizei n, const GLuint *states, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteStatesNV, "(%d, %p)", (int)n, (void*)states)
    glatter_glDeleteStatesNV(n, states);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteStatesNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawCommandsAddressNV, (primitiveMode, indirects, sizes, count), (GLenum primitiveMode, const GLuint64 *indirects, const GLsizei *sizes, GLuint count))
GLATTER_INLINE_OR_NOT void glatter_glDrawCommandsAddressNV_debug(GLenum primitiveMode, const GLuint64 *indirects, const GLsizei *sizes, GLuint count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawCommandsAddressNV, "(%s, %p, %p, %u)", enum_to_string_GL(primitiveMode), (void*)indirects, (void*)sizes, (unsigned int)count)
    glatter_glDrawCommandsAddressNV(primitiveMode, indirects, sizes, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawCommandsAddressNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawCommandsNV, (primitiveMode, buffer, indirects, sizes, count), (GLenum primitiveMode, GLuint buffer, const GLintptr *indirects, const GLsizei *sizes, GLuint count))
GLATTER_INLINE_OR_NOT void glatter_glDrawCommandsNV_debug(GLenum primitiveMode, GLuint buffer, const GLintptr *indirects, const GLsizei *sizes, GLuint count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawCommandsNV, "(%s, %u, %p, %p, %u)", enum_to_string_GL(primitiveMode), (unsigned int)buffer, (void*)indirects, (void*)sizes, (unsigned int)count)
    glatter_glDrawCommandsNV(primitiveMode, buffer, indirects, sizes, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawCommandsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawCommandsStatesAddressNV, (indirects, sizes, states, fbos, count), (const GLuint64 *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count))
GLATTER_INLINE_OR_NOT void glatter_glDrawCommandsStatesAddressNV_debug(const GLuint64 *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawCommandsStatesAddressNV, "(%p, %p, %p, %p, %u)", (void*)indirects, (void*)sizes, (void*)states, (void*)fbos, (unsigned int)count)
    glatter_glDrawCommandsStatesAddressNV(indirects, sizes, states, fbos, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawCommandsStatesAddressNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawCommandsStatesNV, (buffer, indirects, sizes, states, fbos, count), (GLuint buffer, const GLintptr *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count))
GLATTER_INLINE_OR_NOT void glatter_glDrawCommandsStatesNV_debug(GLuint buffer, const GLintptr *indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawCommandsStatesNV, "(%u, %p, %p, %p, %p, %u)", (unsigned int)buffer, (void*)indirects, (void*)sizes, (void*)states, (void*)fbos, (unsigned int)count)
    glatter_glDrawCommandsStatesNV(buffer, indirects, sizes, states, fbos, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawCommandsStatesNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glGetCommandHeaderNV, (tokenID, size), (GLenum tokenID, GLuint size))
GLATTER_INLINE_OR_NOT GLuint glatter_glGetCommandHeaderNV_debug(GLenum tokenID, GLuint size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetCommandHeaderNV, "(%s, %u)", enum_to_string_GL(tokenID), (unsigned int)size)
    GLuint rval = glatter_glGetCommandHeaderNV(tokenID, size);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetCommandHeaderNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLushort, APIENTRY, glGetStageIndexNV, (shadertype), (GLenum shadertype))
GLATTER_INLINE_OR_NOT GLushort glatter_glGetStageIndexNV_debug(GLenum shadertype, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetStageIndexNV, "(%s)", enum_to_string_GL(shadertype))
    GLushort rval = glatter_glGetStageIndexNV(shadertype);
    GLATTER_RBLOCK("%hu\n", (unsigned short)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetStageIndexNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsCommandListNV, (list), (GLuint list))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsCommandListNV_debug(GLuint list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsCommandListNV, "(%u)", (unsigned int)list)
    GLboolean rval = glatter_glIsCommandListNV(list);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsCommandListNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsStateNV, (state), (GLuint state))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsStateNV_debug(GLuint state, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsStateNV, "(%u)", (unsigned int)state)
    GLboolean rval = glatter_glIsStateNV(state);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsStateNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glListDrawCommandsStatesClientNV, (list, segment, indirects, sizes, states, fbos, count), (GLuint list, GLuint segment, const void **indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count))
GLATTER_INLINE_OR_NOT void glatter_glListDrawCommandsStatesClientNV_debug(GLuint list, GLuint segment, const void **indirects, const GLsizei *sizes, const GLuint *states, const GLuint *fbos, GLuint count, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glListDrawCommandsStatesClientNV, "(%u, %u, %p, %p, %p, %p, %u)", (unsigned int)list, (unsigned int)segment, (void*)indirects, (void*)sizes, (void*)states, (void*)fbos, (unsigned int)count)
    glatter_glListDrawCommandsStatesClientNV(list, segment, indirects, sizes, states, fbos, count);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glListDrawCommandsStatesClientNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStateCaptureNV, (state, mode), (GLuint state, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glStateCaptureNV_debug(GLuint state, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStateCaptureNV, "(%u, %s)", (unsigned int)state, enum_to_string_GL(mode))
    glatter_glStateCaptureNV(state, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStateCaptureNV_defined
#endif // defined(GL_NV_command_list)
#if defined(GL_NV_conditional_render)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBeginConditionalRenderNV, (id, mode), (GLuint id, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glBeginConditionalRenderNV_debug(GLuint id, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginConditionalRenderNV, "(%u, %s)", (unsigned int)id, enum_to_string_GL(mode))
    glatter_glBeginConditionalRenderNV(id, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginConditionalRenderNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEndConditionalRenderNV, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glEndConditionalRenderNV_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndConditionalRenderNV, "()")
    glatter_glEndConditionalRenderNV();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndConditionalRenderNV_defined
#endif // defined(GL_NV_conditional_render)
#if defined(GL_NV_conservative_raster)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSubpixelPrecisionBiasNV, (xbits, ybits), (GLuint xbits, GLuint ybits))
GLATTER_INLINE_OR_NOT void glatter_glSubpixelPrecisionBiasNV_debug(GLuint xbits, GLuint ybits, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSubpixelPrecisionBiasNV, "(%u, %u)", (unsigned int)xbits, (unsigned int)ybits)
    glatter_glSubpixelPrecisionBiasNV(xbits, ybits);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSubpixelPrecisionBiasNV_defined
#endif // defined(GL_NV_conservative_raster)
#if defined(GL_NV_conservative_raster_dilate)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConservativeRasterParameterfNV, (pname, value), (GLenum pname, GLfloat value))
GLATTER_INLINE_OR_NOT void glatter_glConservativeRasterParameterfNV_debug(GLenum pname, GLfloat value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConservativeRasterParameterfNV, "(%s, %f)", enum_to_string_GL(pname), (float)value)
    glatter_glConservativeRasterParameterfNV(pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConservativeRasterParameterfNV_defined
#endif // defined(GL_NV_conservative_raster_dilate)
#if defined(GL_NV_conservative_raster_pre_snap_triangles)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glConservativeRasterParameteriNV, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glConservativeRasterParameteriNV_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glConservativeRasterParameteriNV, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glConservativeRasterParameteriNV(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glConservativeRasterParameteriNV_defined
#endif // defined(GL_NV_conservative_raster_pre_snap_triangles)
#if defined(GL_NV_copy_image)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyImageSubDataNV, (srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth), (GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth))
GLATTER_INLINE_OR_NOT void glatter_glCopyImageSubDataNV_debug(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei width, GLsizei height, GLsizei depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyImageSubDataNV, "(%u, %s, %d, %d, %d, %d, %u, %s, %d, %d, %d, %d, %d, %d, %d)", (unsigned int)srcName, enum_to_string_GL(srcTarget), (int)srcLevel, (int)srcX, (int)srcY, (int)srcZ, (unsigned int)dstName, enum_to_string_GL(dstTarget), (int)dstLevel, (int)dstX, (int)dstY, (int)dstZ, (int)width, (int)height, (int)depth)
    glatter_glCopyImageSubDataNV(srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, width, height, depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyImageSubDataNV_defined
#endif // defined(GL_NV_copy_image)
#if defined(GL_NV_depth_buffer_float)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glClearDepthdNV, (depth), (GLdouble depth))
GLATTER_INLINE_OR_NOT void glatter_glClearDepthdNV_debug(GLdouble depth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glClearDepthdNV, "(%f)", (double)depth)
    glatter_glClearDepthdNV(depth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glClearDepthdNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDepthBoundsdNV, (zmin, zmax), (GLdouble zmin, GLdouble zmax))
GLATTER_INLINE_OR_NOT void glatter_glDepthBoundsdNV_debug(GLdouble zmin, GLdouble zmax, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthBoundsdNV, "(%f, %f)", (double)zmin, (double)zmax)
    glatter_glDepthBoundsdNV(zmin, zmax);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthBoundsdNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDepthRangedNV, (zNear, zFar), (GLdouble zNear, GLdouble zFar))
GLATTER_INLINE_OR_NOT void glatter_glDepthRangedNV_debug(GLdouble zNear, GLdouble zFar, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDepthRangedNV, "(%f, %f)", (double)zNear, (double)zFar)
    glatter_glDepthRangedNV(zNear, zFar);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDepthRangedNV_defined
#endif // defined(GL_NV_depth_buffer_float)
#if defined(GL_NV_draw_texture)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawTextureNV, (texture, sampler, x0, y0, x1, y1, z, s0, t0, s1, t1), (GLuint texture, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1))
GLATTER_INLINE_OR_NOT void glatter_glDrawTextureNV_debug(GLuint texture, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawTextureNV, "(%u, %u, %f, %f, %f, %f, %f, %f, %f, %f, %f)", (unsigned int)texture, (unsigned int)sampler, (float)x0, (float)y0, (float)x1, (float)y1, (float)z, (float)s0, (float)t0, (float)s1, (float)t1)
    glatter_glDrawTextureNV(texture, sampler, x0, y0, x1, y1, z, s0, t0, s1, t1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawTextureNV_defined
#endif // defined(GL_NV_draw_texture)
#if defined(GL_NV_draw_vulkan_image)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDrawVkImageNV, (vkImage, sampler, x0, y0, x1, y1, z, s0, t0, s1, t1), (GLuint64 vkImage, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1))
GLATTER_INLINE_OR_NOT void glatter_glDrawVkImageNV_debug(GLuint64 vkImage, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDrawVkImageNV, "(%" PRIu64 ", %u, %f, %f, %f, %f, %f, %f, %f, %f, %f)", (uint64_t)vkImage, (unsigned int)sampler, (float)x0, (float)y0, (float)x1, (float)y1, (float)z, (float)s0, (float)t0, (float)s1, (float)t1)
    glatter_glDrawVkImageNV(vkImage, sampler, x0, y0, x1, y1, z, s0, t0, s1, t1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDrawVkImageNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLVULKANPROCNV, APIENTRY, glGetVkProcAddrNV, (name), (const GLchar *name))
GLATTER_INLINE_OR_NOT GLVULKANPROCNV glatter_glGetVkProcAddrNV_debug(const GLchar *name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVkProcAddrNV, "(%p)", (void*)name)
    GLVULKANPROCNV rval = glatter_glGetVkProcAddrNV(name);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetVkProcAddrNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSignalVkFenceNV, (vkFence), (GLuint64 vkFence))
GLATTER_INLINE_OR_NOT void glatter_glSignalVkFenceNV_debug(GLuint64 vkFence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSignalVkFenceNV, "(%" PRIu64 ")", (uint64_t)vkFence)
    glatter_glSignalVkFenceNV(vkFence);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSignalVkFenceNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSignalVkSemaphoreNV, (vkSemaphore), (GLuint64 vkSemaphore))
GLATTER_INLINE_OR_NOT void glatter_glSignalVkSemaphoreNV_debug(GLuint64 vkSemaphore, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSignalVkSemaphoreNV, "(%" PRIu64 ")", (uint64_t)vkSemaphore)
    glatter_glSignalVkSemaphoreNV(vkSemaphore);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSignalVkSemaphoreNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWaitVkSemaphoreNV, (vkSemaphore), (GLuint64 vkSemaphore))
GLATTER_INLINE_OR_NOT void glatter_glWaitVkSemaphoreNV_debug(GLuint64 vkSemaphore, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWaitVkSemaphoreNV, "(%" PRIu64 ")", (uint64_t)vkSemaphore)
    glatter_glWaitVkSemaphoreNV(vkSemaphore);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWaitVkSemaphoreNV_defined
#endif // defined(GL_NV_draw_vulkan_image)
#if defined(GL_NV_evaluators)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEvalMapsNV, (target, mode), (GLenum target, GLenum mode))
GLATTER_INLINE_OR_NOT void glatter_glEvalMapsNV_debug(GLenum target, GLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEvalMapsNV, "(%s, %s)", enum_to_string_GL(target), enum_to_string_GL(mode))
    glatter_glEvalMapsNV(target, mode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEvalMapsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMapAttribParameterfvNV, (target, index, pname, params), (GLenum target, GLuint index, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMapAttribParameterfvNV_debug(GLenum target, GLuint index, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMapAttribParameterfvNV, "(%s, %u, %s, %p)", enum_to_string_GL(target), (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetMapAttribParameterfvNV(target, index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMapAttribParameterfvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMapAttribParameterivNV, (target, index, pname, params), (GLenum target, GLuint index, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMapAttribParameterivNV_debug(GLenum target, GLuint index, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMapAttribParameterivNV, "(%s, %u, %s, %p)", enum_to_string_GL(target), (unsigned int)index, enum_to_string_GL(pname), (void*)params)
    glatter_glGetMapAttribParameterivNV(target, index, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMapAttribParameterivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMapControlPointsNV, (target, index, type, ustride, vstride, packed, points), (GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, void *points))
GLATTER_INLINE_OR_NOT void glatter_glGetMapControlPointsNV_debug(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, void *points, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMapControlPointsNV, "(%s, %u, %s, %d, %d, %u, %p)", enum_to_string_GL(target), (unsigned int)index, enum_to_string_GL(type), (int)ustride, (int)vstride, (unsigned char)packed, (void*)points)
    glatter_glGetMapControlPointsNV(target, index, type, ustride, vstride, packed, points);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMapControlPointsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMapParameterfvNV, (target, pname, params), (GLenum target, GLenum pname, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMapParameterfvNV_debug(GLenum target, GLenum pname, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMapParameterfvNV, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMapParameterfvNV(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMapParameterfvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMapParameterivNV, (target, pname, params), (GLenum target, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetMapParameterivNV_debug(GLenum target, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMapParameterivNV, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glGetMapParameterivNV(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMapParameterivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMapControlPointsNV, (target, index, type, ustride, vstride, uorder, vorder, packed, points), (GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, const void *points))
GLATTER_INLINE_OR_NOT void glatter_glMapControlPointsNV_debug(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, const void *points, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapControlPointsNV, "(%s, %u, %s, %d, %d, %d, %d, %u, %p)", enum_to_string_GL(target), (unsigned int)index, enum_to_string_GL(type), (int)ustride, (int)vstride, (int)uorder, (int)vorder, (unsigned char)packed, (void*)points)
    glatter_glMapControlPointsNV(target, index, type, ustride, vstride, uorder, vorder, packed, points);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMapControlPointsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMapParameterfvNV, (target, pname, params), (GLenum target, GLenum pname, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glMapParameterfvNV_debug(GLenum target, GLenum pname, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapParameterfvNV, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glMapParameterfvNV(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMapParameterfvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMapParameterivNV, (target, pname, params), (GLenum target, GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glMapParameterivNV_debug(GLenum target, GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMapParameterivNV, "(%s, %s, %p)", enum_to_string_GL(target), enum_to_string_GL(pname), (void*)params)
    glatter_glMapParameterivNV(target, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMapParameterivNV_defined
#endif // defined(GL_NV_evaluators)
#if defined(GL_NV_explicit_multisample)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetMultisamplefvNV, (pname, index, val), (GLenum pname, GLuint index, GLfloat *val))
GLATTER_INLINE_OR_NOT void glatter_glGetMultisamplefvNV_debug(GLenum pname, GLuint index, GLfloat *val, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetMultisamplefvNV, "(%s, %u, %p)", enum_to_string_GL(pname), (unsigned int)index, (void*)val)
    glatter_glGetMultisamplefvNV(pname, index, val);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetMultisamplefvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSampleMaskIndexedNV, (index, mask), (GLuint index, GLbitfield mask))
GLATTER_INLINE_OR_NOT void glatter_glSampleMaskIndexedNV_debug(GLuint index, GLbitfield mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSampleMaskIndexedNV, "(%u, %u)", (unsigned int)index, (unsigned int)mask)
    glatter_glSampleMaskIndexedNV(index, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSampleMaskIndexedNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexRenderbufferNV, (target, renderbuffer), (GLenum target, GLuint renderbuffer))
GLATTER_INLINE_OR_NOT void glatter_glTexRenderbufferNV_debug(GLenum target, GLuint renderbuffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexRenderbufferNV, "(%s, %u)", enum_to_string_GL(target), (unsigned int)renderbuffer)
    glatter_glTexRenderbufferNV(target, renderbuffer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexRenderbufferNV_defined
#endif // defined(GL_NV_explicit_multisample)
#if defined(GL_NV_fence)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteFencesNV, (n, fences), (GLsizei n, const GLuint *fences))
GLATTER_INLINE_OR_NOT void glatter_glDeleteFencesNV_debug(GLsizei n, const GLuint *fences, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteFencesNV, "(%d, %p)", (int)n, (void*)fences)
    glatter_glDeleteFencesNV(n, fences);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteFencesNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFinishFenceNV, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT void glatter_glFinishFenceNV_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFinishFenceNV, "(%u)", (unsigned int)fence)
    glatter_glFinishFenceNV(fence);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFinishFenceNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenFencesNV, (n, fences), (GLsizei n, GLuint *fences))
GLATTER_INLINE_OR_NOT void glatter_glGenFencesNV_debug(GLsizei n, GLuint *fences, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenFencesNV, "(%d, %p)", (int)n, (void*)fences)
    glatter_glGenFencesNV(n, fences);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenFencesNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetFenceivNV, (fence, pname, params), (GLuint fence, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetFenceivNV_debug(GLuint fence, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetFenceivNV, "(%u, %s, %p)", (unsigned int)fence, enum_to_string_GL(pname), (void*)params)
    glatter_glGetFenceivNV(fence, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetFenceivNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsFenceNV, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsFenceNV_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsFenceNV, "(%u)", (unsigned int)fence)
    GLboolean rval = glatter_glIsFenceNV(fence);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsFenceNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSetFenceNV, (fence, condition), (GLuint fence, GLenum condition))
GLATTER_INLINE_OR_NOT void glatter_glSetFenceNV_debug(GLuint fence, GLenum condition, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSetFenceNV, "(%u, %s)", (unsigned int)fence, enum_to_string_GL(condition))
    glatter_glSetFenceNV(fence, condition);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSetFenceNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glTestFenceNV, (fence), (GLuint fence))
GLATTER_INLINE_OR_NOT GLboolean glatter_glTestFenceNV_debug(GLuint fence, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTestFenceNV, "(%u)", (unsigned int)fence)
    GLboolean rval = glatter_glTestFenceNV(fence);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glTestFenceNV_defined
#endif // defined(GL_NV_fence)
#if defined(GL_NV_fragment_coverage_to_color)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFragmentCoverageColorNV, (color), (GLuint color))
GLATTER_INLINE_OR_NOT void glatter_glFragmentCoverageColorNV_debug(GLuint color, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFragmentCoverageColorNV, "(%u)", (unsigned int)color)
    glatter_glFragmentCoverageColorNV(color);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFragmentCoverageColorNV_defined
#endif // defined(GL_NV_fragment_coverage_to_color)
#if defined(GL_NV_fragment_program)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramNamedParameterdvNV, (id, len, name, params), (GLuint id, GLsizei len, const GLubyte *name, GLdouble *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramNamedParameterdvNV_debug(GLuint id, GLsizei len, const GLubyte *name, GLdouble *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramNamedParameterdvNV, "(%u, %d, %p, %p)", (unsigned int)id, (int)len, (void*)name, (void*)params)
    glatter_glGetProgramNamedParameterdvNV(id, len, name, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramNamedParameterdvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramNamedParameterfvNV, (id, len, name, params), (GLuint id, GLsizei len, const GLubyte *name, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramNamedParameterfvNV_debug(GLuint id, GLsizei len, const GLubyte *name, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramNamedParameterfvNV, "(%u, %d, %p, %p)", (unsigned int)id, (int)len, (void*)name, (void*)params)
    glatter_glGetProgramNamedParameterfvNV(id, len, name, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramNamedParameterfvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramNamedParameter4dNV, (id, len, name, x, y, z, w), (GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w))
GLATTER_INLINE_OR_NOT void glatter_glProgramNamedParameter4dNV_debug(GLuint id, GLsizei len, const GLubyte *name, GLdouble x, GLdouble y, GLdouble z, GLdouble w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramNamedParameter4dNV, "(%u, %d, %p, %f, %f, %f, %f)", (unsigned int)id, (int)len, (void*)name, (double)x, (double)y, (double)z, (double)w)
    glatter_glProgramNamedParameter4dNV(id, len, name, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramNamedParameter4dNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramNamedParameter4dvNV, (id, len, name, v), (GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v))
GLATTER_INLINE_OR_NOT void glatter_glProgramNamedParameter4dvNV_debug(GLuint id, GLsizei len, const GLubyte *name, const GLdouble *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramNamedParameter4dvNV, "(%u, %d, %p, %p)", (unsigned int)id, (int)len, (void*)name, (void*)v)
    glatter_glProgramNamedParameter4dvNV(id, len, name, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramNamedParameter4dvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramNamedParameter4fNV, (id, len, name, x, y, z, w), (GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GLATTER_INLINE_OR_NOT void glatter_glProgramNamedParameter4fNV_debug(GLuint id, GLsizei len, const GLubyte *name, GLfloat x, GLfloat y, GLfloat z, GLfloat w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramNamedParameter4fNV, "(%u, %d, %p, %f, %f, %f, %f)", (unsigned int)id, (int)len, (void*)name, (float)x, (float)y, (float)z, (float)w)
    glatter_glProgramNamedParameter4fNV(id, len, name, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramNamedParameter4fNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramNamedParameter4fvNV, (id, len, name, v), (GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glProgramNamedParameter4fvNV_debug(GLuint id, GLsizei len, const GLubyte *name, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramNamedParameter4fvNV, "(%u, %d, %p, %p)", (unsigned int)id, (int)len, (void*)name, (void*)v)
    glatter_glProgramNamedParameter4fvNV(id, len, name, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramNamedParameter4fvNV_defined
#endif // defined(GL_NV_fragment_program)
#if defined(GL_NV_framebuffer_mixed_samples)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCoverageModulationNV, (components), (GLenum components))
GLATTER_INLINE_OR_NOT void glatter_glCoverageModulationNV_debug(GLenum components, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverageModulationNV, "(%s)", enum_to_string_GL(components))
    glatter_glCoverageModulationNV(components);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverageModulationNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCoverageModulationTableNV, (n, v), (GLsizei n, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glCoverageModulationTableNV_debug(GLsizei n, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverageModulationTableNV, "(%d, %p)", (int)n, (void*)v)
    glatter_glCoverageModulationTableNV(n, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverageModulationTableNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetCoverageModulationTableNV, (bufsize, v), (GLsizei bufsize, GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glGetCoverageModulationTableNV_debug(GLsizei bufsize, GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetCoverageModulationTableNV, "(%d, %p)", (int)bufsize, (void*)v)
    glatter_glGetCoverageModulationTableNV(bufsize, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetCoverageModulationTableNV_defined
#endif // defined(GL_NV_framebuffer_mixed_samples)
#if defined(GL_NV_framebuffer_multisample_coverage)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glRenderbufferStorageMultisampleCoverageNV, (target, coverageSamples, colorSamples, internalformat, width, height), (GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height))
GLATTER_INLINE_OR_NOT void glatter_glRenderbufferStorageMultisampleCoverageNV_debug(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderbufferStorageMultisampleCoverageNV, "(%s, %d, %d, %s, %d, %d)", enum_to_string_GL(target), (int)coverageSamples, (int)colorSamples, enum_to_string_GL(internalformat), (int)width, (int)height)
    glatter_glRenderbufferStorageMultisampleCoverageNV(target, coverageSamples, colorSamples, internalformat, width, height);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderbufferStorageMultisampleCoverageNV_defined
#endif // defined(GL_NV_framebuffer_multisample_coverage)
#if defined(GL_NV_geometry_program4)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferTextureEXT, (target, attachment, texture, level), (GLenum target, GLenum attachment, GLuint texture, GLint level))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureEXT_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureEXT, "(%s, %s, %u, %d)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level)
    glatter_glFramebufferTextureEXT(target, attachment, texture, level);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFramebufferTextureFaceEXT, (target, attachment, texture, level, face), (GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face))
GLATTER_INLINE_OR_NOT void glatter_glFramebufferTextureFaceEXT_debug(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFramebufferTextureFaceEXT, "(%s, %s, %u, %d, %s)", enum_to_string_GL(target), enum_to_string_GL(attachment), (unsigned int)texture, (int)level, enum_to_string_GL(face))
    glatter_glFramebufferTextureFaceEXT(target, attachment, texture, level, face);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFramebufferTextureFaceEXT_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramVertexLimitNV, (target, limit), (GLenum target, GLint limit))
GLATTER_INLINE_OR_NOT void glatter_glProgramVertexLimitNV_debug(GLenum target, GLint limit, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramVertexLimitNV, "(%s, %d)", enum_to_string_GL(target), (int)limit)
    glatter_glProgramVertexLimitNV(target, limit);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramVertexLimitNV_defined
#endif // defined(GL_NV_geometry_program4)
#if defined(GL_NV_gpu_multicast)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMulticastBarrierNV, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glMulticastBarrierNV_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMulticastBarrierNV, "()")
    glatter_glMulticastBarrierNV();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMulticastBarrierNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMulticastBlitFramebufferNV, (srcGpu, dstGpu, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter), (GLuint srcGpu, GLuint dstGpu, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter))
GLATTER_INLINE_OR_NOT void glatter_glMulticastBlitFramebufferNV_debug(GLuint srcGpu, GLuint dstGpu, GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMulticastBlitFramebufferNV, "(%u, %u, %d, %d, %d, %d, %d, %d, %d, %d, %u, %s)", (unsigned int)srcGpu, (unsigned int)dstGpu, (int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (unsigned int)mask, enum_to_string_GL(filter))
    glatter_glMulticastBlitFramebufferNV(srcGpu, dstGpu, srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMulticastBlitFramebufferNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMulticastBufferSubDataNV, (gpuMask, buffer, offset, size, data), (GLbitfield gpuMask, GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data))
GLATTER_INLINE_OR_NOT void glatter_glMulticastBufferSubDataNV_debug(GLbitfield gpuMask, GLuint buffer, GLintptr offset, GLsizeiptr size, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMulticastBufferSubDataNV, "(%u, %u, %s, %s, %p)", (unsigned int)gpuMask, (unsigned int)buffer, GET_PRS(offset), GET_PRS(size), (void*)data)
    glatter_glMulticastBufferSubDataNV(gpuMask, buffer, offset, size, data);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMulticastBufferSubDataNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMulticastCopyBufferSubDataNV, (readGpu, writeGpuMask, readBuffer, writeBuffer, readOffset, writeOffset, size), (GLuint readGpu, GLbitfield writeGpuMask, GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size))
GLATTER_INLINE_OR_NOT void glatter_glMulticastCopyBufferSubDataNV_debug(GLuint readGpu, GLbitfield writeGpuMask, GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMulticastCopyBufferSubDataNV, "(%u, %u, %u, %u, %s, %s, %s)", (unsigned int)readGpu, (unsigned int)writeGpuMask, (unsigned int)readBuffer, (unsigned int)writeBuffer, GET_PRS(readOffset), GET_PRS(writeOffset), GET_PRS(size))
    glatter_glMulticastCopyBufferSubDataNV(readGpu, writeGpuMask, readBuffer, writeBuffer, readOffset, writeOffset, size);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMulticastCopyBufferSubDataNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMulticastCopyImageSubDataNV, (srcGpu, dstGpuMask, srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth), (GLuint srcGpu, GLbitfield dstGpuMask, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth))
GLATTER_INLINE_OR_NOT void glatter_glMulticastCopyImageSubDataNV_debug(GLuint srcGpu, GLbitfield dstGpuMask, GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMulticastCopyImageSubDataNV, "(%u, %u, %u, %s, %d, %d, %d, %d, %u, %s, %d, %d, %d, %d, %d, %d, %d)", (unsigned int)srcGpu, (unsigned int)dstGpuMask, (unsigned int)srcName, enum_to_string_GL(srcTarget), (int)srcLevel, (int)srcX, (int)srcY, (int)srcZ, (unsigned int)dstName, enum_to_string_GL(dstTarget), (int)dstLevel, (int)dstX, (int)dstY, (int)dstZ, (int)srcWidth, (int)srcHeight, (int)srcDepth)
    glatter_glMulticastCopyImageSubDataNV(srcGpu, dstGpuMask, srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMulticastCopyImageSubDataNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMulticastFramebufferSampleLocationsfvNV, (gpu, framebuffer, start, count, v), (GLuint gpu, GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v))
GLATTER_INLINE_OR_NOT void glatter_glMulticastFramebufferSampleLocationsfvNV_debug(GLuint gpu, GLuint framebuffer, GLuint start, GLsizei count, const GLfloat *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMulticastFramebufferSampleLocationsfvNV, "(%u, %u, %u, %d, %p)", (unsigned int)gpu, (unsigned int)framebuffer, (unsigned int)start, (int)count, (void*)v)
    glatter_glMulticastFramebufferSampleLocationsfvNV(gpu, framebuffer, start, count, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMulticastFramebufferSampleLocationsfvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMulticastGetQueryObjecti64vNV, (gpu, id, pname, params), (GLuint gpu, GLuint id, GLenum pname, GLint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glMulticastGetQueryObjecti64vNV_debug(GLuint gpu, GLuint id, GLenum pname, GLint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMulticastGetQueryObjecti64vNV, "(%u, %u, %s, %p)", (unsigned int)gpu, (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glMulticastGetQueryObjecti64vNV(gpu, id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMulticastGetQueryObjecti64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMulticastGetQueryObjectivNV, (gpu, id, pname, params), (GLuint gpu, GLuint id, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glMulticastGetQueryObjectivNV_debug(GLuint gpu, GLuint id, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMulticastGetQueryObjectivNV, "(%u, %u, %s, %p)", (unsigned int)gpu, (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glMulticastGetQueryObjectivNV(gpu, id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMulticastGetQueryObjectivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMulticastGetQueryObjectui64vNV, (gpu, id, pname, params), (GLuint gpu, GLuint id, GLenum pname, GLuint64 *params))
GLATTER_INLINE_OR_NOT void glatter_glMulticastGetQueryObjectui64vNV_debug(GLuint gpu, GLuint id, GLenum pname, GLuint64 *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMulticastGetQueryObjectui64vNV, "(%u, %u, %s, %p)", (unsigned int)gpu, (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glMulticastGetQueryObjectui64vNV(gpu, id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMulticastGetQueryObjectui64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMulticastGetQueryObjectuivNV, (gpu, id, pname, params), (GLuint gpu, GLuint id, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glMulticastGetQueryObjectuivNV_debug(GLuint gpu, GLuint id, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMulticastGetQueryObjectuivNV, "(%u, %u, %s, %p)", (unsigned int)gpu, (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glMulticastGetQueryObjectuivNV(gpu, id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMulticastGetQueryObjectuivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMulticastWaitSyncNV, (signalGpu, waitGpuMask), (GLuint signalGpu, GLbitfield waitGpuMask))
GLATTER_INLINE_OR_NOT void glatter_glMulticastWaitSyncNV_debug(GLuint signalGpu, GLbitfield waitGpuMask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMulticastWaitSyncNV, "(%u, %u)", (unsigned int)signalGpu, (unsigned int)waitGpuMask)
    glatter_glMulticastWaitSyncNV(signalGpu, waitGpuMask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMulticastWaitSyncNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glRenderGpuMaskNV, (mask), (GLbitfield mask))
GLATTER_INLINE_OR_NOT void glatter_glRenderGpuMaskNV_debug(GLbitfield mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glRenderGpuMaskNV, "(%u)", (unsigned int)mask)
    glatter_glRenderGpuMaskNV(mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glRenderGpuMaskNV_defined
#endif // defined(GL_NV_gpu_multicast)
#if defined(GL_NV_gpu_program4)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramEnvParameterIivNV, (target, index, params), (GLenum target, GLuint index, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramEnvParameterIivNV_debug(GLenum target, GLuint index, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramEnvParameterIivNV, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetProgramEnvParameterIivNV(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramEnvParameterIivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramEnvParameterIuivNV, (target, index, params), (GLenum target, GLuint index, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramEnvParameterIuivNV_debug(GLenum target, GLuint index, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramEnvParameterIuivNV, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetProgramEnvParameterIuivNV(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramEnvParameterIuivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramLocalParameterIivNV, (target, index, params), (GLenum target, GLuint index, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramLocalParameterIivNV_debug(GLenum target, GLuint index, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramLocalParameterIivNV, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetProgramLocalParameterIivNV(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramLocalParameterIivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramLocalParameterIuivNV, (target, index, params), (GLenum target, GLuint index, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramLocalParameterIuivNV_debug(GLenum target, GLuint index, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramLocalParameterIuivNV, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glGetProgramLocalParameterIuivNV(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramLocalParameterIuivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramEnvParameterI4iNV, (target, index, x, y, z, w), (GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w))
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameterI4iNV_debug(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramEnvParameterI4iNV, "(%s, %u, %d, %d, %d, %d)", enum_to_string_GL(target), (unsigned int)index, (int)x, (int)y, (int)z, (int)w)
    glatter_glProgramEnvParameterI4iNV(target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramEnvParameterI4iNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramEnvParameterI4ivNV, (target, index, params), (GLenum target, GLuint index, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameterI4ivNV_debug(GLenum target, GLuint index, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramEnvParameterI4ivNV, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glProgramEnvParameterI4ivNV(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramEnvParameterI4ivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramEnvParameterI4uiNV, (target, index, x, y, z, w), (GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w))
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameterI4uiNV_debug(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramEnvParameterI4uiNV, "(%s, %u, %u, %u, %u, %u)", enum_to_string_GL(target), (unsigned int)index, (unsigned int)x, (unsigned int)y, (unsigned int)z, (unsigned int)w)
    glatter_glProgramEnvParameterI4uiNV(target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramEnvParameterI4uiNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramEnvParameterI4uivNV, (target, index, params), (GLenum target, GLuint index, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParameterI4uivNV_debug(GLenum target, GLuint index, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramEnvParameterI4uivNV, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glProgramEnvParameterI4uivNV(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramEnvParameterI4uivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramEnvParametersI4ivNV, (target, index, count, params), (GLenum target, GLuint index, GLsizei count, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParametersI4ivNV_debug(GLenum target, GLuint index, GLsizei count, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramEnvParametersI4ivNV, "(%s, %u, %d, %p)", enum_to_string_GL(target), (unsigned int)index, (int)count, (void*)params)
    glatter_glProgramEnvParametersI4ivNV(target, index, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramEnvParametersI4ivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramEnvParametersI4uivNV, (target, index, count, params), (GLenum target, GLuint index, GLsizei count, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramEnvParametersI4uivNV_debug(GLenum target, GLuint index, GLsizei count, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramEnvParametersI4uivNV, "(%s, %u, %d, %p)", enum_to_string_GL(target), (unsigned int)index, (int)count, (void*)params)
    glatter_glProgramEnvParametersI4uivNV(target, index, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramEnvParametersI4uivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramLocalParameterI4iNV, (target, index, x, y, z, w), (GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w))
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameterI4iNV_debug(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramLocalParameterI4iNV, "(%s, %u, %d, %d, %d, %d)", enum_to_string_GL(target), (unsigned int)index, (int)x, (int)y, (int)z, (int)w)
    glatter_glProgramLocalParameterI4iNV(target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramLocalParameterI4iNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramLocalParameterI4ivNV, (target, index, params), (GLenum target, GLuint index, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameterI4ivNV_debug(GLenum target, GLuint index, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramLocalParameterI4ivNV, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glProgramLocalParameterI4ivNV(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramLocalParameterI4ivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramLocalParameterI4uiNV, (target, index, x, y, z, w), (GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w))
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameterI4uiNV_debug(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramLocalParameterI4uiNV, "(%s, %u, %u, %u, %u, %u)", enum_to_string_GL(target), (unsigned int)index, (unsigned int)x, (unsigned int)y, (unsigned int)z, (unsigned int)w)
    glatter_glProgramLocalParameterI4uiNV(target, index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramLocalParameterI4uiNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramLocalParameterI4uivNV, (target, index, params), (GLenum target, GLuint index, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParameterI4uivNV_debug(GLenum target, GLuint index, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramLocalParameterI4uivNV, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)params)
    glatter_glProgramLocalParameterI4uivNV(target, index, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramLocalParameterI4uivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramLocalParametersI4ivNV, (target, index, count, params), (GLenum target, GLuint index, GLsizei count, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParametersI4ivNV_debug(GLenum target, GLuint index, GLsizei count, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramLocalParametersI4ivNV, "(%s, %u, %d, %p)", enum_to_string_GL(target), (unsigned int)index, (int)count, (void*)params)
    glatter_glProgramLocalParametersI4ivNV(target, index, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramLocalParametersI4ivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramLocalParametersI4uivNV, (target, index, count, params), (GLenum target, GLuint index, GLsizei count, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramLocalParametersI4uivNV_debug(GLenum target, GLuint index, GLsizei count, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramLocalParametersI4uivNV, "(%s, %u, %d, %p)", enum_to_string_GL(target), (unsigned int)index, (int)count, (void*)params)
    glatter_glProgramLocalParametersI4uivNV(target, index, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramLocalParametersI4uivNV_defined
#endif // defined(GL_NV_gpu_program4)
#if defined(GL_NV_gpu_program5)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramSubroutineParameteruivNV, (target, index, param), (GLenum target, GLuint index, GLuint *param))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramSubroutineParameteruivNV_debug(GLenum target, GLuint index, GLuint *param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramSubroutineParameteruivNV, "(%s, %u, %p)", enum_to_string_GL(target), (unsigned int)index, (void*)param)
    glatter_glGetProgramSubroutineParameteruivNV(target, index, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramSubroutineParameteruivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramSubroutineParametersuivNV, (target, count, params), (GLenum target, GLsizei count, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramSubroutineParametersuivNV_debug(GLenum target, GLsizei count, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramSubroutineParametersuivNV, "(%s, %d, %p)", enum_to_string_GL(target), (int)count, (void*)params)
    glatter_glProgramSubroutineParametersuivNV(target, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramSubroutineParametersuivNV_defined
#endif // defined(GL_NV_gpu_program5)
#if defined(GL_NV_half_float)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColor3hNV, (red, green, blue), (GLhalfNV red, GLhalfNV green, GLhalfNV blue))
GLATTER_INLINE_OR_NOT void glatter_glColor3hNV_debug(GLhalfNV red, GLhalfNV green, GLhalfNV blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3hNV, "(%hu, %hu, %hu)", (unsigned short)red, (unsigned short)green, (unsigned short)blue)
    glatter_glColor3hNV(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColor3hvNV, (v), (const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glColor3hvNV_debug(const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor3hvNV, "(%p)", (void*)v)
    glatter_glColor3hvNV(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor3hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColor4hNV, (red, green, blue, alpha), (GLhalfNV red, GLhalfNV green, GLhalfNV blue, GLhalfNV alpha))
GLATTER_INLINE_OR_NOT void glatter_glColor4hNV_debug(GLhalfNV red, GLhalfNV green, GLhalfNV blue, GLhalfNV alpha, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4hNV, "(%hu, %hu, %hu, %hu)", (unsigned short)red, (unsigned short)green, (unsigned short)blue, (unsigned short)alpha)
    glatter_glColor4hNV(red, green, blue, alpha);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glColor4hvNV, (v), (const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glColor4hvNV_debug(const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glColor4hvNV, "(%p)", (void*)v)
    glatter_glColor4hvNV(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glColor4hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFogCoordhNV, (fog), (GLhalfNV fog))
GLATTER_INLINE_OR_NOT void glatter_glFogCoordhNV_debug(GLhalfNV fog, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogCoordhNV, "(%hu)", (unsigned short)fog)
    glatter_glFogCoordhNV(fog);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogCoordhNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFogCoordhvNV, (fog), (const GLhalfNV *fog))
GLATTER_INLINE_OR_NOT void glatter_glFogCoordhvNV_debug(const GLhalfNV *fog, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFogCoordhvNV, "(%p)", (void*)fog)
    glatter_glFogCoordhvNV(fog);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFogCoordhvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord1hNV, (target, s), (GLenum target, GLhalfNV s))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1hNV_debug(GLenum target, GLhalfNV s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord1hNV, "(%s, %hu)", enum_to_string_GL(target), (unsigned short)s)
    glatter_glMultiTexCoord1hNV(target, s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord1hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord1hvNV, (target, v), (GLenum target, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord1hvNV_debug(GLenum target, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord1hvNV, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord1hvNV(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord1hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord2hNV, (target, s, t), (GLenum target, GLhalfNV s, GLhalfNV t))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2hNV_debug(GLenum target, GLhalfNV s, GLhalfNV t, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord2hNV, "(%s, %hu, %hu)", enum_to_string_GL(target), (unsigned short)s, (unsigned short)t)
    glatter_glMultiTexCoord2hNV(target, s, t);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord2hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord2hvNV, (target, v), (GLenum target, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord2hvNV_debug(GLenum target, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord2hvNV, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord2hvNV(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord2hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord3hNV, (target, s, t, r), (GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3hNV_debug(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord3hNV, "(%s, %hu, %hu, %hu)", enum_to_string_GL(target), (unsigned short)s, (unsigned short)t, (unsigned short)r)
    glatter_glMultiTexCoord3hNV(target, s, t, r);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord3hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord3hvNV, (target, v), (GLenum target, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord3hvNV_debug(GLenum target, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord3hvNV, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord3hvNV(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord3hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord4hNV, (target, s, t, r, q), (GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4hNV_debug(GLenum target, GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4hNV, "(%s, %hu, %hu, %hu, %hu)", enum_to_string_GL(target), (unsigned short)s, (unsigned short)t, (unsigned short)r, (unsigned short)q)
    glatter_glMultiTexCoord4hNV(target, s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMultiTexCoord4hvNV, (target, v), (GLenum target, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glMultiTexCoord4hvNV_debug(GLenum target, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMultiTexCoord4hvNV, "(%s, %p)", enum_to_string_GL(target), (void*)v)
    glatter_glMultiTexCoord4hvNV(target, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMultiTexCoord4hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormal3hNV, (nx, ny, nz), (GLhalfNV nx, GLhalfNV ny, GLhalfNV nz))
GLATTER_INLINE_OR_NOT void glatter_glNormal3hNV_debug(GLhalfNV nx, GLhalfNV ny, GLhalfNV nz, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3hNV, "(%hu, %hu, %hu)", (unsigned short)nx, (unsigned short)ny, (unsigned short)nz)
    glatter_glNormal3hNV(nx, ny, nz);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glNormal3hvNV, (v), (const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glNormal3hvNV_debug(const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glNormal3hvNV, "(%p)", (void*)v)
    glatter_glNormal3hvNV(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glNormal3hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3hNV, (red, green, blue), (GLhalfNV red, GLhalfNV green, GLhalfNV blue))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3hNV_debug(GLhalfNV red, GLhalfNV green, GLhalfNV blue, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3hNV, "(%hu, %hu, %hu)", (unsigned short)red, (unsigned short)green, (unsigned short)blue)
    glatter_glSecondaryColor3hNV(red, green, blue);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glSecondaryColor3hvNV, (v), (const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glSecondaryColor3hvNV_debug(const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glSecondaryColor3hvNV, "(%p)", (void*)v)
    glatter_glSecondaryColor3hvNV(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glSecondaryColor3hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexCoord1hNV, (s), (GLhalfNV s))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1hNV_debug(GLhalfNV s, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord1hNV, "(%hu)", (unsigned short)s)
    glatter_glTexCoord1hNV(s);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord1hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexCoord1hvNV, (v), (const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord1hvNV_debug(const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord1hvNV, "(%p)", (void*)v)
    glatter_glTexCoord1hvNV(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord1hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexCoord2hNV, (s, t), (GLhalfNV s, GLhalfNV t))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2hNV_debug(GLhalfNV s, GLhalfNV t, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord2hNV, "(%hu, %hu)", (unsigned short)s, (unsigned short)t)
    glatter_glTexCoord2hNV(s, t);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord2hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexCoord2hvNV, (v), (const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord2hvNV_debug(const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord2hvNV, "(%p)", (void*)v)
    glatter_glTexCoord2hvNV(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord2hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexCoord3hNV, (s, t, r), (GLhalfNV s, GLhalfNV t, GLhalfNV r))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3hNV_debug(GLhalfNV s, GLhalfNV t, GLhalfNV r, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord3hNV, "(%hu, %hu, %hu)", (unsigned short)s, (unsigned short)t, (unsigned short)r)
    glatter_glTexCoord3hNV(s, t, r);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord3hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexCoord3hvNV, (v), (const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord3hvNV_debug(const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord3hvNV, "(%p)", (void*)v)
    glatter_glTexCoord3hvNV(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord3hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexCoord4hNV, (s, t, r, q), (GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4hNV_debug(GLhalfNV s, GLhalfNV t, GLhalfNV r, GLhalfNV q, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord4hNV, "(%hu, %hu, %hu, %hu)", (unsigned short)s, (unsigned short)t, (unsigned short)r, (unsigned short)q)
    glatter_glTexCoord4hNV(s, t, r, q);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord4hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTexCoord4hvNV, (v), (const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glTexCoord4hvNV_debug(const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTexCoord4hvNV, "(%p)", (void*)v)
    glatter_glTexCoord4hvNV(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTexCoord4hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertex2hNV, (x, y), (GLhalfNV x, GLhalfNV y))
GLATTER_INLINE_OR_NOT void glatter_glVertex2hNV_debug(GLhalfNV x, GLhalfNV y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex2hNV, "(%hu, %hu)", (unsigned short)x, (unsigned short)y)
    glatter_glVertex2hNV(x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex2hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertex2hvNV, (v), (const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex2hvNV_debug(const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex2hvNV, "(%p)", (void*)v)
    glatter_glVertex2hvNV(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex2hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertex3hNV, (x, y, z), (GLhalfNV x, GLhalfNV y, GLhalfNV z))
GLATTER_INLINE_OR_NOT void glatter_glVertex3hNV_debug(GLhalfNV x, GLhalfNV y, GLhalfNV z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex3hNV, "(%hu, %hu, %hu)", (unsigned short)x, (unsigned short)y, (unsigned short)z)
    glatter_glVertex3hNV(x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex3hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertex3hvNV, (v), (const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex3hvNV_debug(const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex3hvNV, "(%p)", (void*)v)
    glatter_glVertex3hvNV(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex3hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertex4hNV, (x, y, z, w), (GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w))
GLATTER_INLINE_OR_NOT void glatter_glVertex4hNV_debug(GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex4hNV, "(%hu, %hu, %hu, %hu)", (unsigned short)x, (unsigned short)y, (unsigned short)z, (unsigned short)w)
    glatter_glVertex4hNV(x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex4hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertex4hvNV, (v), (const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glVertex4hvNV_debug(const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertex4hvNV, "(%p)", (void*)v)
    glatter_glVertex4hvNV(v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertex4hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib1hNV, (index, x), (GLuint index, GLhalfNV x))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1hNV_debug(GLuint index, GLhalfNV x, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib1hNV, "(%u, %hu)", (unsigned int)index, (unsigned short)x)
    glatter_glVertexAttrib1hNV(index, x);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib1hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib1hvNV, (index, v), (GLuint index, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib1hvNV_debug(GLuint index, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib1hvNV, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib1hvNV(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib1hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib2hNV, (index, x, y), (GLuint index, GLhalfNV x, GLhalfNV y))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2hNV_debug(GLuint index, GLhalfNV x, GLhalfNV y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib2hNV, "(%u, %hu, %hu)", (unsigned int)index, (unsigned short)x, (unsigned short)y)
    glatter_glVertexAttrib2hNV(index, x, y);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib2hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib2hvNV, (index, v), (GLuint index, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib2hvNV_debug(GLuint index, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib2hvNV, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib2hvNV(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib2hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib3hNV, (index, x, y, z), (GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3hNV_debug(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib3hNV, "(%u, %hu, %hu, %hu)", (unsigned int)index, (unsigned short)x, (unsigned short)y, (unsigned short)z)
    glatter_glVertexAttrib3hNV(index, x, y, z);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib3hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib3hvNV, (index, v), (GLuint index, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib3hvNV_debug(GLuint index, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib3hvNV, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib3hvNV(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib3hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4hNV, (index, x, y, z, w), (GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4hNV_debug(GLuint index, GLhalfNV x, GLhalfNV y, GLhalfNV z, GLhalfNV w, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4hNV, "(%u, %hu, %hu, %hu, %hu)", (unsigned int)index, (unsigned short)x, (unsigned short)y, (unsigned short)z, (unsigned short)w)
    glatter_glVertexAttrib4hNV(index, x, y, z, w);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4hNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttrib4hvNV, (index, v), (GLuint index, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttrib4hvNV_debug(GLuint index, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttrib4hvNV, "(%u, %p)", (unsigned int)index, (void*)v)
    glatter_glVertexAttrib4hvNV(index, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttrib4hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribs1hvNV, (index, n, v), (GLuint index, GLsizei n, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs1hvNV_debug(GLuint index, GLsizei n, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribs1hvNV, "(%u, %d, %p)", (unsigned int)index, (int)n, (void*)v)
    glatter_glVertexAttribs1hvNV(index, n, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribs1hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribs2hvNV, (index, n, v), (GLuint index, GLsizei n, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs2hvNV_debug(GLuint index, GLsizei n, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribs2hvNV, "(%u, %d, %p)", (unsigned int)index, (int)n, (void*)v)
    glatter_glVertexAttribs2hvNV(index, n, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribs2hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribs3hvNV, (index, n, v), (GLuint index, GLsizei n, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs3hvNV_debug(GLuint index, GLsizei n, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribs3hvNV, "(%u, %d, %p)", (unsigned int)index, (int)n, (void*)v)
    glatter_glVertexAttribs3hvNV(index, n, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribs3hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexAttribs4hvNV, (index, n, v), (GLuint index, GLsizei n, const GLhalfNV *v))
GLATTER_INLINE_OR_NOT void glatter_glVertexAttribs4hvNV_debug(GLuint index, GLsizei n, const GLhalfNV *v, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexAttribs4hvNV, "(%u, %d, %p)", (unsigned int)index, (int)n, (void*)v)
    glatter_glVertexAttribs4hvNV(index, n, v);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexAttribs4hvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexWeighthNV, (weight), (GLhalfNV weight))
GLATTER_INLINE_OR_NOT void glatter_glVertexWeighthNV_debug(GLhalfNV weight, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexWeighthNV, "(%hu)", (unsigned short)weight)
    glatter_glVertexWeighthNV(weight);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexWeighthNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glVertexWeighthvNV, (weight), (const GLhalfNV *weight))
GLATTER_INLINE_OR_NOT void glatter_glVertexWeighthvNV_debug(const GLhalfNV *weight, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glVertexWeighthvNV, "(%p)", (void*)weight)
    glatter_glVertexWeighthvNV(weight);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glVertexWeighthvNV_defined
#endif // defined(GL_NV_half_float)
#if defined(GL_NV_internalformat_sample_query)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetInternalformatSampleivNV, (target, internalformat, samples, pname, bufSize, params), (GLenum target, GLenum internalformat, GLsizei samples, GLenum pname, GLsizei bufSize, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetInternalformatSampleivNV_debug(GLenum target, GLenum internalformat, GLsizei samples, GLenum pname, GLsizei bufSize, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetInternalformatSampleivNV, "(%s, %s, %d, %s, %d, %p)", enum_to_string_GL(target), enum_to_string_GL(internalformat), (int)samples, enum_to_string_GL(pname), (int)bufSize, (void*)params)
    glatter_glGetInternalformatSampleivNV(target, internalformat, samples, pname, bufSize, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetInternalformatSampleivNV_defined
#endif // defined(GL_NV_internalformat_sample_query)
#if defined(GL_NV_occlusion_query)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glBeginOcclusionQueryNV, (id), (GLuint id))
GLATTER_INLINE_OR_NOT void glatter_glBeginOcclusionQueryNV_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glBeginOcclusionQueryNV, "(%u)", (unsigned int)id)
    glatter_glBeginOcclusionQueryNV(id);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glBeginOcclusionQueryNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeleteOcclusionQueriesNV, (n, ids), (GLsizei n, const GLuint *ids))
GLATTER_INLINE_OR_NOT void glatter_glDeleteOcclusionQueriesNV_debug(GLsizei n, const GLuint *ids, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeleteOcclusionQueriesNV, "(%d, %p)", (int)n, (void*)ids)
    glatter_glDeleteOcclusionQueriesNV(n, ids);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeleteOcclusionQueriesNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glEndOcclusionQueryNV, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glEndOcclusionQueryNV_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glEndOcclusionQueryNV, "()")
    glatter_glEndOcclusionQueryNV();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glEndOcclusionQueryNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGenOcclusionQueriesNV, (n, ids), (GLsizei n, GLuint *ids))
GLATTER_INLINE_OR_NOT void glatter_glGenOcclusionQueriesNV_debug(GLsizei n, GLuint *ids, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenOcclusionQueriesNV, "(%d, %p)", (int)n, (void*)ids)
    glatter_glGenOcclusionQueriesNV(n, ids);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGenOcclusionQueriesNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetOcclusionQueryivNV, (id, pname, params), (GLuint id, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetOcclusionQueryivNV_debug(GLuint id, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetOcclusionQueryivNV, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetOcclusionQueryivNV(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetOcclusionQueryivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetOcclusionQueryuivNV, (id, pname, params), (GLuint id, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetOcclusionQueryuivNV_debug(GLuint id, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetOcclusionQueryuivNV, "(%u, %s, %p)", (unsigned int)id, enum_to_string_GL(pname), (void*)params)
    glatter_glGetOcclusionQueryuivNV(id, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetOcclusionQueryuivNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsOcclusionQueryNV, (id), (GLuint id))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsOcclusionQueryNV_debug(GLuint id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsOcclusionQueryNV, "(%u)", (unsigned int)id)
    GLboolean rval = glatter_glIsOcclusionQueryNV(id);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsOcclusionQueryNV_defined
#endif // defined(GL_NV_occlusion_query)
#if defined(GL_NV_parameter_buffer_object)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramBufferParametersIivNV, (target, bindingIndex, wordIndex, count, params), (GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramBufferParametersIivNV_debug(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramBufferParametersIivNV, "(%s, %u, %u, %d, %p)", enum_to_string_GL(target), (unsigned int)bindingIndex, (unsigned int)wordIndex, (int)count, (void*)params)
    glatter_glProgramBufferParametersIivNV(target, bindingIndex, wordIndex, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramBufferParametersIivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramBufferParametersIuivNV, (target, bindingIndex, wordIndex, count, params), (GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramBufferParametersIuivNV_debug(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramBufferParametersIuivNV, "(%s, %u, %u, %d, %p)", enum_to_string_GL(target), (unsigned int)bindingIndex, (unsigned int)wordIndex, (int)count, (void*)params)
    glatter_glProgramBufferParametersIuivNV(target, bindingIndex, wordIndex, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramBufferParametersIuivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramBufferParametersfvNV, (target, bindingIndex, wordIndex, count, params), (GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glProgramBufferParametersfvNV_debug(GLenum target, GLuint bindingIndex, GLuint wordIndex, GLsizei count, const GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramBufferParametersfvNV, "(%s, %u, %u, %d, %p)", enum_to_string_GL(target), (unsigned int)bindingIndex, (unsigned int)wordIndex, (int)count, (void*)params)
    glatter_glProgramBufferParametersfvNV(target, bindingIndex, wordIndex, count, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramBufferParametersfvNV_defined
#endif // defined(GL_NV_parameter_buffer_object)
#if defined(GL_NV_path_rendering)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCopyPathNV, (resultPath, srcPath), (GLuint resultPath, GLuint srcPath))
GLATTER_INLINE_OR_NOT void glatter_glCopyPathNV_debug(GLuint resultPath, GLuint srcPath, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCopyPathNV, "(%u, %u)", (unsigned int)resultPath, (unsigned int)srcPath)
    glatter_glCopyPathNV(resultPath, srcPath);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCopyPathNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCoverFillPathInstancedNV, (numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glCoverFillPathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverFillPathInstancedNV, "(%d, %s, %p, %u, %s, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, enum_to_string_GL(coverMode), enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glCoverFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverFillPathInstancedNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCoverFillPathNV, (path, coverMode), (GLuint path, GLenum coverMode))
GLATTER_INLINE_OR_NOT void glatter_glCoverFillPathNV_debug(GLuint path, GLenum coverMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverFillPathNV, "(%u, %s)", (unsigned int)path, enum_to_string_GL(coverMode))
    glatter_glCoverFillPathNV(path, coverMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverFillPathNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCoverStrokePathInstancedNV, (numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glCoverStrokePathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverStrokePathInstancedNV, "(%d, %s, %p, %u, %s, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, enum_to_string_GL(coverMode), enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glCoverStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, coverMode, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverStrokePathInstancedNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glCoverStrokePathNV, (path, coverMode), (GLuint path, GLenum coverMode))
GLATTER_INLINE_OR_NOT void glatter_glCoverStrokePathNV_debug(GLuint path, GLenum coverMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glCoverStrokePathNV, "(%u, %s)", (unsigned int)path, enum_to_string_GL(coverMode))
    glatter_glCoverStrokePathNV(path, coverMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glCoverStrokePathNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glDeletePathsNV, (path, range), (GLuint path, GLsizei range))
GLATTER_INLINE_OR_NOT void glatter_glDeletePathsNV_debug(GLuint path, GLsizei range, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glDeletePathsNV, "(%u, %d)", (unsigned int)path, (int)range)
    glatter_glDeletePathsNV(path, range);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glDeletePathsNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLuint, APIENTRY, glGenPathsNV, (range), (GLsizei range))
GLATTER_INLINE_OR_NOT GLuint glatter_glGenPathsNV_debug(GLsizei range, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGenPathsNV, "(%d)", (int)range)
    GLuint rval = glatter_glGenPathsNV(range);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGenPathsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathColorGenfvNV, (color, pname, value), (GLenum color, GLenum pname, GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glGetPathColorGenfvNV_debug(GLenum color, GLenum pname, GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathColorGenfvNV, "(%s, %s, %p)", enum_to_string_GL(color), enum_to_string_GL(pname), (void*)value)
    glatter_glGetPathColorGenfvNV(color, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathColorGenfvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathColorGenivNV, (color, pname, value), (GLenum color, GLenum pname, GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glGetPathColorGenivNV_debug(GLenum color, GLenum pname, GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathColorGenivNV, "(%s, %s, %p)", enum_to_string_GL(color), enum_to_string_GL(pname), (void*)value)
    glatter_glGetPathColorGenivNV(color, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathColorGenivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathCommandsNV, (path, commands), (GLuint path, GLubyte *commands))
GLATTER_INLINE_OR_NOT void glatter_glGetPathCommandsNV_debug(GLuint path, GLubyte *commands, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathCommandsNV, "(%u, %p)", (unsigned int)path, (void*)commands)
    glatter_glGetPathCommandsNV(path, commands);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathCommandsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathCoordsNV, (path, coords), (GLuint path, GLfloat *coords))
GLATTER_INLINE_OR_NOT void glatter_glGetPathCoordsNV_debug(GLuint path, GLfloat *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathCoordsNV, "(%u, %p)", (unsigned int)path, (void*)coords)
    glatter_glGetPathCoordsNV(path, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathCoordsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathDashArrayNV, (path, dashArray), (GLuint path, GLfloat *dashArray))
GLATTER_INLINE_OR_NOT void glatter_glGetPathDashArrayNV_debug(GLuint path, GLfloat *dashArray, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathDashArrayNV, "(%u, %p)", (unsigned int)path, (void*)dashArray)
    glatter_glGetPathDashArrayNV(path, dashArray);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathDashArrayNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLfloat, APIENTRY, glGetPathLengthNV, (path, startSegment, numSegments), (GLuint path, GLsizei startSegment, GLsizei numSegments))
GLATTER_INLINE_OR_NOT GLfloat glatter_glGetPathLengthNV_debug(GLuint path, GLsizei startSegment, GLsizei numSegments, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathLengthNV, "(%u, %d, %d)", (unsigned int)path, (int)startSegment, (int)numSegments)
    GLfloat rval = glatter_glGetPathLengthNV(path, startSegment, numSegments);
    GLATTER_RBLOCK("%f\n", (float)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glGetPathLengthNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathMetricRangeNV, (metricQueryMask, firstPathName, numPaths, stride, metrics), (GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics))
GLATTER_INLINE_OR_NOT void glatter_glGetPathMetricRangeNV_debug(GLbitfield metricQueryMask, GLuint firstPathName, GLsizei numPaths, GLsizei stride, GLfloat *metrics, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathMetricRangeNV, "(%u, %u, %d, %d, %p)", (unsigned int)metricQueryMask, (unsigned int)firstPathName, (int)numPaths, (int)stride, (void*)metrics)
    glatter_glGetPathMetricRangeNV(metricQueryMask, firstPathName, numPaths, stride, metrics);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathMetricRangeNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathMetricsNV, (metricQueryMask, numPaths, pathNameType, paths, pathBase, stride, metrics), (GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics))
GLATTER_INLINE_OR_NOT void glatter_glGetPathMetricsNV_debug(GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLsizei stride, GLfloat *metrics, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathMetricsNV, "(%u, %d, %s, %p, %u, %d, %p)", (unsigned int)metricQueryMask, (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, (int)stride, (void*)metrics)
    glatter_glGetPathMetricsNV(metricQueryMask, numPaths, pathNameType, paths, pathBase, stride, metrics);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathMetricsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathParameterfvNV, (path, pname, value), (GLuint path, GLenum pname, GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glGetPathParameterfvNV_debug(GLuint path, GLenum pname, GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathParameterfvNV, "(%u, %s, %p)", (unsigned int)path, enum_to_string_GL(pname), (void*)value)
    glatter_glGetPathParameterfvNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathParameterfvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathParameterivNV, (path, pname, value), (GLuint path, GLenum pname, GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glGetPathParameterivNV_debug(GLuint path, GLenum pname, GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathParameterivNV, "(%u, %s, %p)", (unsigned int)path, enum_to_string_GL(pname), (void*)value)
    glatter_glGetPathParameterivNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathParameterivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathSpacingNV, (pathListMode, numPaths, pathNameType, paths, pathBase, advanceScale, kerningScale, transformType, returnedSpacing), (GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing))
GLATTER_INLINE_OR_NOT void glatter_glGetPathSpacingNV_debug(GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathSpacingNV, "(%s, %d, %s, %p, %u, %f, %f, %s, %p)", enum_to_string_GL(pathListMode), (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, (float)advanceScale, (float)kerningScale, enum_to_string_GL(transformType), (void*)returnedSpacing)
    glatter_glGetPathSpacingNV(pathListMode, numPaths, pathNameType, paths, pathBase, advanceScale, kerningScale, transformType, returnedSpacing);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathSpacingNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathTexGenfvNV, (texCoordSet, pname, value), (GLenum texCoordSet, GLenum pname, GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glGetPathTexGenfvNV_debug(GLenum texCoordSet, GLenum pname, GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathTexGenfvNV, "(%s, %s, %p)", enum_to_string_GL(texCoordSet), enum_to_string_GL(pname), (void*)value)
    glatter_glGetPathTexGenfvNV(texCoordSet, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathTexGenfvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetPathTexGenivNV, (texCoordSet, pname, value), (GLenum texCoordSet, GLenum pname, GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glGetPathTexGenivNV_debug(GLenum texCoordSet, GLenum pname, GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetPathTexGenivNV, "(%s, %s, %p)", enum_to_string_GL(texCoordSet), enum_to_string_GL(pname), (void*)value)
    glatter_glGetPathTexGenivNV(texCoordSet, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetPathTexGenivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetProgramResourcefvNV, (program, programInterface, index, propCount, props, bufSize, length, params), (GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLfloat *params))
GLATTER_INLINE_OR_NOT void glatter_glGetProgramResourcefvNV_debug(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum *props, GLsizei bufSize, GLsizei *length, GLfloat *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetProgramResourcefvNV, "(%u, %s, %u, %d, %p, %d, %p, %p)", (unsigned int)program, enum_to_string_GL(programInterface), (unsigned int)index, (int)propCount, (void*)props, (int)bufSize, (void*)length, (void*)params)
    glatter_glGetProgramResourcefvNV(program, programInterface, index, propCount, props, bufSize, length, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetProgramResourcefvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glInterpolatePathsNV, (resultPath, pathA, pathB, weight), (GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight))
GLATTER_INLINE_OR_NOT void glatter_glInterpolatePathsNV_debug(GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glInterpolatePathsNV, "(%u, %u, %u, %f)", (unsigned int)resultPath, (unsigned int)pathA, (unsigned int)pathB, (float)weight)
    glatter_glInterpolatePathsNV(resultPath, pathA, pathB, weight);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glInterpolatePathsNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsPathNV, (path), (GLuint path))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsPathNV_debug(GLuint path, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsPathNV, "(%u)", (unsigned int)path)
    GLboolean rval = glatter_glIsPathNV(path);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsPathNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsPointInFillPathNV, (path, mask, x, y), (GLuint path, GLuint mask, GLfloat x, GLfloat y))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsPointInFillPathNV_debug(GLuint path, GLuint mask, GLfloat x, GLfloat y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsPointInFillPathNV, "(%u, %u, %f, %f)", (unsigned int)path, (unsigned int)mask, (float)x, (float)y)
    GLboolean rval = glatter_glIsPointInFillPathNV(path, mask, x, y);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsPointInFillPathNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glIsPointInStrokePathNV, (path, x, y), (GLuint path, GLfloat x, GLfloat y))
GLATTER_INLINE_OR_NOT GLboolean glatter_glIsPointInStrokePathNV_debug(GLuint path, GLfloat x, GLfloat y, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glIsPointInStrokePathNV, "(%u, %f, %f)", (unsigned int)path, (float)x, (float)y)
    GLboolean rval = glatter_glIsPointInStrokePathNV(path, x, y);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glIsPointInStrokePathNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixLoad3x2fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoad3x2fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoad3x2fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixLoad3x2fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoad3x2fNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixLoad3x3fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoad3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoad3x3fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixLoad3x3fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoad3x3fNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixLoadTranspose3x3fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixLoadTranspose3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixLoadTranspose3x3fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixLoadTranspose3x3fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixLoadTranspose3x3fNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixMult3x2fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMult3x2fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMult3x2fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixMult3x2fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMult3x2fNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixMult3x3fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMult3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMult3x3fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixMult3x3fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMult3x3fNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glMatrixMultTranspose3x3fNV, (matrixMode, m), (GLenum matrixMode, const GLfloat *m))
GLATTER_INLINE_OR_NOT void glatter_glMatrixMultTranspose3x3fNV_debug(GLenum matrixMode, const GLfloat *m, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glMatrixMultTranspose3x3fNV, "(%s, %p)", enum_to_string_GL(matrixMode), (void*)m)
    glatter_glMatrixMultTranspose3x3fNV(matrixMode, m);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glMatrixMultTranspose3x3fNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathColorGenNV, (color, genMode, colorFormat, coeffs), (GLenum color, GLenum genMode, GLenum colorFormat, const GLfloat *coeffs))
GLATTER_INLINE_OR_NOT void glatter_glPathColorGenNV_debug(GLenum color, GLenum genMode, GLenum colorFormat, const GLfloat *coeffs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathColorGenNV, "(%s, %s, %s, %p)", enum_to_string_GL(color), enum_to_string_GL(genMode), enum_to_string_GL(colorFormat), (void*)coeffs)
    glatter_glPathColorGenNV(color, genMode, colorFormat, coeffs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathColorGenNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathCommandsNV, (path, numCommands, commands, numCoords, coordType, coords), (GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords))
GLATTER_INLINE_OR_NOT void glatter_glPathCommandsNV_debug(GLuint path, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathCommandsNV, "(%u, %d, %p, %d, %s, %p)", (unsigned int)path, (int)numCommands, (void*)commands, (int)numCoords, enum_to_string_GL(coordType), (void*)coords)
    glatter_glPathCommandsNV(path, numCommands, commands, numCoords, coordType, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathCommandsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathCoordsNV, (path, numCoords, coordType, coords), (GLuint path, GLsizei numCoords, GLenum coordType, const void *coords))
GLATTER_INLINE_OR_NOT void glatter_glPathCoordsNV_debug(GLuint path, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathCoordsNV, "(%u, %d, %s, %p)", (unsigned int)path, (int)numCoords, enum_to_string_GL(coordType), (void*)coords)
    glatter_glPathCoordsNV(path, numCoords, coordType, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathCoordsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathCoverDepthFuncNV, (func), (GLenum func))
GLATTER_INLINE_OR_NOT void glatter_glPathCoverDepthFuncNV_debug(GLenum func, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathCoverDepthFuncNV, "(%s)", enum_to_string_GL(func))
    glatter_glPathCoverDepthFuncNV(func);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathCoverDepthFuncNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathDashArrayNV, (path, dashCount, dashArray), (GLuint path, GLsizei dashCount, const GLfloat *dashArray))
GLATTER_INLINE_OR_NOT void glatter_glPathDashArrayNV_debug(GLuint path, GLsizei dashCount, const GLfloat *dashArray, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathDashArrayNV, "(%u, %d, %p)", (unsigned int)path, (int)dashCount, (void*)dashArray)
    glatter_glPathDashArrayNV(path, dashCount, dashArray);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathDashArrayNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathFogGenNV, (genMode), (GLenum genMode))
GLATTER_INLINE_OR_NOT void glatter_glPathFogGenNV_debug(GLenum genMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathFogGenNV, "(%s)", enum_to_string_GL(genMode))
    glatter_glPathFogGenNV(genMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathFogGenNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLenum, APIENTRY, glPathGlyphIndexArrayNV, (firstPathName, fontTarget, fontName, fontStyle, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale), (GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
GLATTER_INLINE_OR_NOT GLenum glatter_glPathGlyphIndexArrayNV_debug(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathGlyphIndexArrayNV, "(%u, %s, %p, %u, %u, %d, %u, %f)", (unsigned int)firstPathName, enum_to_string_GL(fontTarget), (void*)fontName, (unsigned int)fontStyle, (unsigned int)firstGlyphIndex, (int)numGlyphs, (unsigned int)pathParameterTemplate, (float)emScale)
    GLenum rval = glatter_glPathGlyphIndexArrayNV(firstPathName, fontTarget, fontName, fontStyle, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glPathGlyphIndexArrayNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLenum, APIENTRY, glPathGlyphIndexRangeNV, (fontTarget, fontName, fontStyle, pathParameterTemplate, emScale, baseAndCount), (GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint pathParameterTemplate, GLfloat emScale, GLuint baseAndCount[2]))
GLATTER_INLINE_OR_NOT GLenum glatter_glPathGlyphIndexRangeNV_debug(GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint pathParameterTemplate, GLfloat emScale, GLuint baseAndCount[2], const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathGlyphIndexRangeNV, "(%s, %p, %u, %u, %f, %s)", enum_to_string_GL(fontTarget), (void*)fontName, (unsigned int)fontStyle, (unsigned int)pathParameterTemplate, (float)emScale, GET_PRS(baseAndCount))
    GLenum rval = glatter_glPathGlyphIndexRangeNV(fontTarget, fontName, fontStyle, pathParameterTemplate, emScale, baseAndCount);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glPathGlyphIndexRangeNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathGlyphRangeNV, (firstPathName, fontTarget, fontName, fontStyle, firstGlyph, numGlyphs, handleMissingGlyphs, pathParameterTemplate, emScale), (GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
GLATTER_INLINE_OR_NOT void glatter_glPathGlyphRangeNV_debug(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathGlyphRangeNV, "(%u, %s, %p, %u, %u, %d, %s, %u, %f)", (unsigned int)firstPathName, enum_to_string_GL(fontTarget), (void*)fontName, (unsigned int)fontStyle, (unsigned int)firstGlyph, (int)numGlyphs, enum_to_string_GL(handleMissingGlyphs), (unsigned int)pathParameterTemplate, (float)emScale)
    glatter_glPathGlyphRangeNV(firstPathName, fontTarget, fontName, fontStyle, firstGlyph, numGlyphs, handleMissingGlyphs, pathParameterTemplate, emScale);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathGlyphRangeNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathGlyphsNV, (firstPathName, fontTarget, fontName, fontStyle, numGlyphs, type, charcodes, handleMissingGlyphs, pathParameterTemplate, emScale), (GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const void *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
GLATTER_INLINE_OR_NOT void glatter_glPathGlyphsNV_debug(GLuint firstPathName, GLenum fontTarget, const void *fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const void *charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathGlyphsNV, "(%u, %s, %p, %u, %d, %s, %p, %s, %u, %f)", (unsigned int)firstPathName, enum_to_string_GL(fontTarget), (void*)fontName, (unsigned int)fontStyle, (int)numGlyphs, enum_to_string_GL(type), (void*)charcodes, enum_to_string_GL(handleMissingGlyphs), (unsigned int)pathParameterTemplate, (float)emScale)
    glatter_glPathGlyphsNV(firstPathName, fontTarget, fontName, fontStyle, numGlyphs, type, charcodes, handleMissingGlyphs, pathParameterTemplate, emScale);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathGlyphsNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLenum, APIENTRY, glPathMemoryGlyphIndexArrayNV, (firstPathName, fontTarget, fontSize, fontData, faceIndex, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale), (GLuint firstPathName, GLenum fontTarget, GLsizeiptr fontSize, const void *fontData, GLsizei faceIndex, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale))
GLATTER_INLINE_OR_NOT GLenum glatter_glPathMemoryGlyphIndexArrayNV_debug(GLuint firstPathName, GLenum fontTarget, GLsizeiptr fontSize, const void *fontData, GLsizei faceIndex, GLuint firstGlyphIndex, GLsizei numGlyphs, GLuint pathParameterTemplate, GLfloat emScale, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathMemoryGlyphIndexArrayNV, "(%u, %s, %s, %p, %d, %u, %d, %u, %f)", (unsigned int)firstPathName, enum_to_string_GL(fontTarget), GET_PRS(fontSize), (void*)fontData, (int)faceIndex, (unsigned int)firstGlyphIndex, (int)numGlyphs, (unsigned int)pathParameterTemplate, (float)emScale)
    GLenum rval = glatter_glPathMemoryGlyphIndexArrayNV(firstPathName, fontTarget, fontSize, fontData, faceIndex, firstGlyphIndex, numGlyphs, pathParameterTemplate, emScale);
    GLATTER_RBLOCK("%s\n", enum_to_string_GL(rval));
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glPathMemoryGlyphIndexArrayNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathParameterfNV, (path, pname, value), (GLuint path, GLenum pname, GLfloat value))
GLATTER_INLINE_OR_NOT void glatter_glPathParameterfNV_debug(GLuint path, GLenum pname, GLfloat value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathParameterfNV, "(%u, %s, %f)", (unsigned int)path, enum_to_string_GL(pname), (float)value)
    glatter_glPathParameterfNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathParameterfNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathParameterfvNV, (path, pname, value), (GLuint path, GLenum pname, const GLfloat *value))
GLATTER_INLINE_OR_NOT void glatter_glPathParameterfvNV_debug(GLuint path, GLenum pname, const GLfloat *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathParameterfvNV, "(%u, %s, %p)", (unsigned int)path, enum_to_string_GL(pname), (void*)value)
    glatter_glPathParameterfvNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathParameterfvNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathParameteriNV, (path, pname, value), (GLuint path, GLenum pname, GLint value))
GLATTER_INLINE_OR_NOT void glatter_glPathParameteriNV_debug(GLuint path, GLenum pname, GLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathParameteriNV, "(%u, %s, %d)", (unsigned int)path, enum_to_string_GL(pname), (int)value)
    glatter_glPathParameteriNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathParameteriNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathParameterivNV, (path, pname, value), (GLuint path, GLenum pname, const GLint *value))
GLATTER_INLINE_OR_NOT void glatter_glPathParameterivNV_debug(GLuint path, GLenum pname, const GLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathParameterivNV, "(%u, %s, %p)", (unsigned int)path, enum_to_string_GL(pname), (void*)value)
    glatter_glPathParameterivNV(path, pname, value);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathParameterivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathStencilDepthOffsetNV, (factor, units), (GLfloat factor, GLfloat units))
GLATTER_INLINE_OR_NOT void glatter_glPathStencilDepthOffsetNV_debug(GLfloat factor, GLfloat units, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathStencilDepthOffsetNV, "(%f, %f)", (float)factor, (float)units)
    glatter_glPathStencilDepthOffsetNV(factor, units);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathStencilDepthOffsetNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathStencilFuncNV, (func, ref, mask), (GLenum func, GLint ref, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glPathStencilFuncNV_debug(GLenum func, GLint ref, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathStencilFuncNV, "(%s, %d, %u)", enum_to_string_GL(func), (int)ref, (unsigned int)mask)
    glatter_glPathStencilFuncNV(func, ref, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathStencilFuncNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathStringNV, (path, format, length, pathString), (GLuint path, GLenum format, GLsizei length, const void *pathString))
GLATTER_INLINE_OR_NOT void glatter_glPathStringNV_debug(GLuint path, GLenum format, GLsizei length, const void *pathString, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathStringNV, "(%u, %s, %d, %p)", (unsigned int)path, enum_to_string_GL(format), (int)length, (void*)pathString)
    glatter_glPathStringNV(path, format, length, pathString);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathStringNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathSubCommandsNV, (path, commandStart, commandsToDelete, numCommands, commands, numCoords, coordType, coords), (GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords))
GLATTER_INLINE_OR_NOT void glatter_glPathSubCommandsNV_debug(GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte *commands, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathSubCommandsNV, "(%u, %d, %d, %d, %p, %d, %s, %p)", (unsigned int)path, (int)commandStart, (int)commandsToDelete, (int)numCommands, (void*)commands, (int)numCoords, enum_to_string_GL(coordType), (void*)coords)
    glatter_glPathSubCommandsNV(path, commandStart, commandsToDelete, numCommands, commands, numCoords, coordType, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathSubCommandsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathSubCoordsNV, (path, coordStart, numCoords, coordType, coords), (GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const void *coords))
GLATTER_INLINE_OR_NOT void glatter_glPathSubCoordsNV_debug(GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const void *coords, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathSubCoordsNV, "(%u, %d, %d, %s, %p)", (unsigned int)path, (int)coordStart, (int)numCoords, enum_to_string_GL(coordType), (void*)coords)
    glatter_glPathSubCoordsNV(path, coordStart, numCoords, coordType, coords);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathSubCoordsNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPathTexGenNV, (texCoordSet, genMode, components, coeffs), (GLenum texCoordSet, GLenum genMode, GLint components, const GLfloat *coeffs))
GLATTER_INLINE_OR_NOT void glatter_glPathTexGenNV_debug(GLenum texCoordSet, GLenum genMode, GLint components, const GLfloat *coeffs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPathTexGenNV, "(%s, %s, %d, %p)", enum_to_string_GL(texCoordSet), enum_to_string_GL(genMode), (int)components, (void*)coeffs)
    glatter_glPathTexGenNV(texCoordSet, genMode, components, coeffs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPathTexGenNV_defined
GLATTER_FBLOCK(return, GL, GLAPI, GLboolean, APIENTRY, glPointAlongPathNV, (path, startSegment, numSegments, distance, x, y, tangentX, tangentY), (GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY))
GLATTER_INLINE_OR_NOT GLboolean glatter_glPointAlongPathNV_debug(GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat *x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointAlongPathNV, "(%u, %d, %d, %f, %p, %p, %p, %p)", (unsigned int)path, (int)startSegment, (int)numSegments, (float)distance, (void*)x, (void*)y, (void*)tangentX, (void*)tangentY)
    GLboolean rval = glatter_glPointAlongPathNV(path, startSegment, numSegments, distance, x, y, tangentX, tangentY);
    GLATTER_RBLOCK("%u\n", (unsigned char)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glPointAlongPathNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glProgramPathFragmentInputGenNV, (program, location, genMode, components, coeffs), (GLuint program, GLint location, GLenum genMode, GLint components, const GLfloat *coeffs))
GLATTER_INLINE_OR_NOT void glatter_glProgramPathFragmentInputGenNV_debug(GLuint program, GLint location, GLenum genMode, GLint components, const GLfloat *coeffs, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glProgramPathFragmentInputGenNV, "(%u, %d, %s, %d, %p)", (unsigned int)program, (int)location, enum_to_string_GL(genMode), (int)components, (void*)coeffs)
    glatter_glProgramPathFragmentInputGenNV(program, location, genMode, components, coeffs);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glProgramPathFragmentInputGenNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilFillPathInstancedNV, (numPaths, pathNameType, paths, pathBase, fillMode, mask, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glStencilFillPathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilFillPathInstancedNV, "(%d, %s, %p, %u, %s, %u, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, enum_to_string_GL(fillMode), (unsigned int)mask, enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glStencilFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, fillMode, mask, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilFillPathInstancedNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilFillPathNV, (path, fillMode, mask), (GLuint path, GLenum fillMode, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilFillPathNV_debug(GLuint path, GLenum fillMode, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilFillPathNV, "(%u, %s, %u)", (unsigned int)path, enum_to_string_GL(fillMode), (unsigned int)mask)
    glatter_glStencilFillPathNV(path, fillMode, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilFillPathNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilStrokePathInstancedNV, (numPaths, pathNameType, paths, pathBase, reference, mask, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glStencilStrokePathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilStrokePathInstancedNV, "(%d, %s, %p, %u, %d, %u, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, (int)reference, (unsigned int)mask, enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glStencilStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, reference, mask, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilStrokePathInstancedNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilStrokePathNV, (path, reference, mask), (GLuint path, GLint reference, GLuint mask))
GLATTER_INLINE_OR_NOT void glatter_glStencilStrokePathNV_debug(GLuint path, GLint reference, GLuint mask, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilStrokePathNV, "(%u, %d, %u)", (unsigned int)path, (int)reference, (unsigned int)mask)
    glatter_glStencilStrokePathNV(path, reference, mask);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilStrokePathNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilThenCoverFillPathInstancedNV, (numPaths, pathNameType, paths, pathBase, fillMode, mask, coverMode, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverFillPathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilThenCoverFillPathInstancedNV, "(%d, %s, %p, %u, %s, %u, %s, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, enum_to_string_GL(fillMode), (unsigned int)mask, enum_to_string_GL(coverMode), enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glStencilThenCoverFillPathInstancedNV(numPaths, pathNameType, paths, pathBase, fillMode, mask, coverMode, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilThenCoverFillPathInstancedNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilThenCoverFillPathNV, (path, fillMode, mask, coverMode), (GLuint path, GLenum fillMode, GLuint mask, GLenum coverMode))
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverFillPathNV_debug(GLuint path, GLenum fillMode, GLuint mask, GLenum coverMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilThenCoverFillPathNV, "(%u, %s, %u, %s)", (unsigned int)path, enum_to_string_GL(fillMode), (unsigned int)mask, enum_to_string_GL(coverMode))
    glatter_glStencilThenCoverFillPathNV(path, fillMode, mask, coverMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilThenCoverFillPathNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilThenCoverStrokePathInstancedNV, (numPaths, pathNameType, paths, pathBase, reference, mask, coverMode, transformType, transformValues), (GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverStrokePathInstancedNV_debug(GLsizei numPaths, GLenum pathNameType, const void *paths, GLuint pathBase, GLint reference, GLuint mask, GLenum coverMode, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilThenCoverStrokePathInstancedNV, "(%d, %s, %p, %u, %d, %u, %s, %s, %p)", (int)numPaths, enum_to_string_GL(pathNameType), (void*)paths, (unsigned int)pathBase, (int)reference, (unsigned int)mask, enum_to_string_GL(coverMode), enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glStencilThenCoverStrokePathInstancedNV(numPaths, pathNameType, paths, pathBase, reference, mask, coverMode, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilThenCoverStrokePathInstancedNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glStencilThenCoverStrokePathNV, (path, reference, mask, coverMode), (GLuint path, GLint reference, GLuint mask, GLenum coverMode))
GLATTER_INLINE_OR_NOT void glatter_glStencilThenCoverStrokePathNV_debug(GLuint path, GLint reference, GLuint mask, GLenum coverMode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glStencilThenCoverStrokePathNV, "(%u, %d, %u, %s)", (unsigned int)path, (int)reference, (unsigned int)mask, enum_to_string_GL(coverMode))
    glatter_glStencilThenCoverStrokePathNV(path, reference, mask, coverMode);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glStencilThenCoverStrokePathNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glTransformPathNV, (resultPath, srcPath, transformType, transformValues), (GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues))
GLATTER_INLINE_OR_NOT void glatter_glTransformPathNV_debug(GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat *transformValues, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glTransformPathNV, "(%u, %u, %s, %p)", (unsigned int)resultPath, (unsigned int)srcPath, enum_to_string_GL(transformType), (void*)transformValues)
    glatter_glTransformPathNV(resultPath, srcPath, transformType, transformValues);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glTransformPathNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glWeightPathsNV, (resultPath, numPaths, paths, weights), (GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights))
GLATTER_INLINE_OR_NOT void glatter_glWeightPathsNV_debug(GLuint resultPath, GLsizei numPaths, const GLuint *paths, const GLfloat *weights, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glWeightPathsNV, "(%u, %d, %p, %p)", (unsigned int)resultPath, (int)numPaths, (void*)paths, (void*)weights)
    glatter_glWeightPathsNV(resultPath, numPaths, paths, weights);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glWeightPathsNV_defined
#endif // defined(GL_NV_path_rendering)
#if defined(GL_NV_pixel_data_range)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glFlushPixelDataRangeNV, (target), (GLenum target))
GLATTER_INLINE_OR_NOT void glatter_glFlushPixelDataRangeNV_debug(GLenum target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glFlushPixelDataRangeNV, "(%s)", enum_to_string_GL(target))
    glatter_glFlushPixelDataRangeNV(target);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glFlushPixelDataRangeNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPixelDataRangeNV, (target, length, pointer), (GLenum target, GLsizei length, const void *pointer))
GLATTER_INLINE_OR_NOT void glatter_glPixelDataRangeNV_debug(GLenum target, GLsizei length, const void *pointer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPixelDataRangeNV, "(%s, %d, %p)", enum_to_string_GL(target), (int)length, (void*)pointer)
    glatter_glPixelDataRangeNV(target, length, pointer);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPixelDataRangeNV_defined
#endif // defined(GL_NV_pixel_data_range)
#if defined(GL_NV_point_sprite)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPointParameteriNV, (pname, param), (GLenum pname, GLint param))
GLATTER_INLINE_OR_NOT void glatter_glPointParameteriNV_debug(GLenum pname, GLint param, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameteriNV, "(%s, %d)", enum_to_string_GL(pname), (int)param)
    glatter_glPointParameteriNV(pname, param);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameteriNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPointParameterivNV, (pname, params), (GLenum pname, const GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glPointParameterivNV_debug(GLenum pname, const GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPointParameterivNV, "(%s, %p)", enum_to_string_GL(pname), (void*)params)
    glatter_glPointParameterivNV(pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPointParameterivNV_defined
#endif // defined(GL_NV_point_sprite)
#if defined(GL_NV_present_video)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVideoi64vNV, (video_slot, pname, params), (GLuint video_slot, GLenum pname, GLint64EXT *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVideoi64vNV_debug(GLuint video_slot, GLenum pname, GLint64EXT *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVideoi64vNV, "(%u, %s, %p)", (unsigned int)video_slot, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVideoi64vNV(video_slot, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVideoi64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVideoivNV, (video_slot, pname, params), (GLuint video_slot, GLenum pname, GLint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVideoivNV_debug(GLuint video_slot, GLenum pname, GLint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVideoivNV, "(%u, %s, %p)", (unsigned int)video_slot, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVideoivNV(video_slot, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVideoivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVideoui64vNV, (video_slot, pname, params), (GLuint video_slot, GLenum pname, GLuint64EXT *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVideoui64vNV_debug(GLuint video_slot, GLenum pname, GLuint64EXT *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVideoui64vNV, "(%u, %s, %p)", (unsigned int)video_slot, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVideoui64vNV(video_slot, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVideoui64vNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glGetVideouivNV, (video_slot, pname, params), (GLuint video_slot, GLenum pname, GLuint *params))
GLATTER_INLINE_OR_NOT void glatter_glGetVideouivNV_debug(GLuint video_slot, GLenum pname, GLuint *params, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glGetVideouivNV, "(%u, %s, %p)", (unsigned int)video_slot, enum_to_string_GL(pname), (void*)params)
    glatter_glGetVideouivNV(video_slot, pname, params);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glGetVideouivNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPresentFrameDualFillNV, (video_slot, minPresentTime, beginPresentTimeId, presentDurationId, type, target0, fill0, target1, fill1, target2, fill2, target3, fill3), (GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3))
GLATTER_INLINE_OR_NOT void glatter_glPresentFrameDualFillNV_debug(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPresentFrameDualFillNV, "(%u, %" PRIu64 ", %u, %u, %s, %s, %u, %s, %u, %s, %u, %s, %u)", (unsigned int)video_slot, (uint64_t)minPresentTime, (unsigned int)beginPresentTimeId, (unsigned int)presentDurationId, enum_to_string_GL(type), enum_to_string_GL(target0), (unsigned int)fill0, enum_to_string_GL(target1), (unsigned int)fill1, enum_to_string_GL(target2), (unsigned int)fill2, enum_to_string_GL(target3), (unsigned int)fill3)
    glatter_glPresentFrameDualFillNV(video_slot, minPresentTime, beginPresentTimeId, presentDurationId, type, target0, fill0, target1, fill1, target2, fill2, target3, fill3);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPresentFrameDualFillNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPresentFrameKeyedNV, (video_slot, minPresentTime, beginPresentTimeId, presentDurationId, type, target0, fill0, key0, target1, fill1, key1), (GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1))
GLATTER_INLINE_OR_NOT void glatter_glPresentFrameKeyedNV_debug(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPresentFrameKeyedNV, "(%u, %" PRIu64 ", %u, %u, %s, %s, %u, %u, %s, %u, %u)", (unsigned int)video_slot, (uint64_t)minPresentTime, (unsigned int)beginPresentTimeId, (unsigned int)presentDurationId, enum_to_string_GL(type), enum_to_string_GL(target0), (unsigned int)fill0, (unsigned int)key0, enum_to_string_GL(target1), (unsigned int)fill1, (unsigned int)key1)
    glatter_glPresentFrameKeyedNV(video_slot, minPresentTime, beginPresentTimeId, presentDurationId, type, target0, fill0, key0, target1, fill1, key1);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPresentFrameKeyedNV_defined
#endif // defined(GL_NV_present_video)
#if defined(GL_NV_primitive_restart)
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPrimitiveRestartIndexNV, (index), (GLuint index))
GLATTER_INLINE_OR_NOT void glatter_glPrimitiveRestartIndexNV_debug(GLuint index, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPrimitiveRestartIndexNV, "(%u)", (unsigned int)index)
    glatter_glPrimitiveRestartIndexNV(index);
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPrimitiveRestartIndexNV_defined
GLATTER_FBLOCK(, GL, GLAPI, void, APIENTRY, glPrimitiveRestartNV, (), (void))
GLATTER_INLINE_OR_NOT void glatter_glPrimitiveRestartNV_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glPrimitiveRestartNV, "()")
    glatter_glPrimitiveRestartNV();
    GLATTER_CHECK_ERROR(GL, file, line)
}
#define glPrimitiveRestartNV_defined
#endif // defined(GL_NV_primitive_restart)
#if defined(GL_NV_query_resource)
GLATTER_FBLOCK(return, GL, GLAPI, GLint, APIENTRY, glQueryResourceNV, (queryType, tagId, bufSize, buffer), (GLenum queryType, GLint tagId, GLuint bufSize, GLint *buffer))
GLATTER_INLINE_OR_NOT GLint glatter_glQueryResourceNV_debug(GLenum queryType, GLint tagId, GLuint bufSize, GLint *buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, glQueryResourceNV, "(%s, %d, %u, %p)", enum_to_string_GL(queryType), (int)tagId, (unsigned int)bufSize, (void*)buffer)
    GLint rval = glatter_glQueryResourceNV(queryType, tagId, bufSize, buffer);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(GL, file, line)
    return rval;
}
#define glQueryResourceNV_defined
#endif // defined(GL_NV_q