<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

August 25, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Matthias Scharfenberg - Industrial Light & Magic
  * [X] Dennis Adams - Sony
  * [X] Thomas Mansencal - Weta Digital

# **OCIO Configs Working Group Meeting Notes**

* Update on config skeleton generation work:
    - Thomas: Started working on config generation code. Dove into OCIO v2. 
      Have some of it working, but difficult to go through new things without 
      complete documentation. One missing piece was the new viewing rules.
    - Michael: Maybe be more brute force for now with views. Could refine with 
      viewing rules later.
    - Thomas: Hoping I could generate OCIO v1 or v2 configs for wider use too.
    - Doug: Looked at the feedback that was posted to Slack.
    - Michael: Yes, great feedback for working on docs.
    - Thomas: As many examples as we can get would help. Help to wrap head 
      around new features. It is easier to build OCIO now. More docs are 
      needed; viewing rules in particular.
    - Carol: Lots of stuff in doc working group around using the ACES ref 
      config to document new features.

* Community feedback on current ACES (studio) config:
    - Thomas: Thread on 3d pro about this. Complaining of complexity. Too large 
      to be useful. Want simple. System has to increase in complexity, but 
      interface needs to be simpler. Too many color spaces in Nuke, DCCs, etc. 
    - Michael: Might need to do without aliases.
    - Thomas: Aliases are option when building config. Should look at docker 
      container for building config.
    - Mark: A lot of the complaints of multiple color spaces are issues with 
      not approaching things correctly. Someone should convert inputs to ACES 
      2065-1 for them to be consistent. Don't need to see other complexities in 
      pipeline
    - Thomas: Studios without color scientist will take what is available for 
      working with ACES, and what’s available is giant and requires someone to 
      be color savvy. Someone else commented that the biggest issue is lack of 
      guidance on how to use it, and to work with wide gamut color spaces.
    - Carol: Majority of use cases the ACES reference config will solve some of 
      that since it’s just ACES. What’s our role in supporting non-ACES 
      workflows in the studio config.
    - Kevin: If people are expected to take config and use it as is, the config 
      won't contain the LMTs. Some shows hand over LMTs so then they need to 
      roll their own config. What I do internally is build a simple config for 
      the specific show, but not put too many camera color spaces in there. We 
      take the ACES config, trim it down to needs. Most people would be better 
      to have a tool.
    - Carol: That and the education around that would be great. But small shops 
      don't have the knowledge to edit the config, so take it as it ships and 
      use that. If we can make it easy for that use case, would be great.
    - Mark: Some ACES shows use an LMT process that splits into multiple parts 
      that can't be slotted into a standard config. We use a config generator 
      at ILM based on requirements. We still generally make all the color 
      spaces available. We have less obscure color spaces that tend to be in 
      there. Have to manually edit to deal with coroner cases. Only way out of 
      it is to put pressure on DI facilities and production companies on 
      working the correct way, so LMTs and CDLs can be slotted in easily. 
    - Doug: Technically LMT is supposed to have ACES 2065-1 as working space, 
      but doesn’t seem like that happens. CLF will allow easier way to package 
      more complex looks.
    - Mark: Would need to be per-shot like it is with CDL. Would like to avoid 
      3D LUT per shot.
    - Kevin: We often throw away CDLs and replace them, so keep them separate 
      from LMT. CDLs are useless after VFX integration starts to happen.
    - Michael: It will be a UX challenge to know how to allow building custom 
      versions simply.
    - Mark: Could be trailblazer and enforce proper ACES workflows. Force 
      fitting in with blocks we give them.
    - Doug: Academy is also pushing ACES metadata file which defines a 
      pipeline. Positioning that as the way to figure out the look. An open 
      question - need to apply AMF for with plate with OCIO. No proposal for 
      how that will work yet.
    - Carol: May need script to build OCIO config from AMF.
    - Doug: The AMF could refer to the OCIO standard transforms, and bake a CLF 
      from that pipeline. One possible answer.
    - Mark: AMF file describes pipeline from camera source to display. 
      Somewhere in there need to wedge those pieces apart.
    - Carol: Pipelines can layer on each other, and they are loosely defined.
    - Mark: AMF file seems to be its own implementation of a color pipeline, 
      conflicts with OCIO config. Would need editing or changing.
    - Carol: AMF meant to replicate the version of ACES a project is using.
    - Kevin: One thing people complain about is the number of color spaces. 
      There are features to limit that exposure. Tagging etc. Is part of the 
      problem that that doesn't exist today? That might help solve some of the 
      problems.
    - Thomas: More complaints: need stripped down config for rendering (i.e. no 
      camera spaces). Education. Productions had honeymoon period with ACES, 
      but it didn’t solve some problems - topics being solved by the gamut 
      mapping working group. Good point that people thought ACES would solve 
      all their problems and in the end it didn’t.
    - Doug: ACES has been promoted heavily, but there are gaps and roadblocks 
      people run into along the way.
    - Kevin: Sounds like people are assuming ACES is what brought along these 
      problems, but you have the same problems with other cases of blending 
      cameras together. Not ACES that brought these problems. All the cameras 
      brought them.
    - Michael: Are the filtering/categorization features enough to provide a 
      simpler interface as they are now? 
    - Thomas: Good point. Going to come down to DCC integration, and how it is 
      presented to user.
    - Kevin: In Baselight it presents groups of color spaces based on what you 
      are doing and allows a modifier key to show everything when needed. 
      Ability to enable hidden color spaces.
    - Michael: OCIO v2 adds inactive color spaces.
    - Doug: Inactive color space are for deprecated spaces. Filtering would use 
      categories instead. Context based.
    - Mark: At some point you have to know what the config author has decided 
      and per DCC need a preference file to say what in a config should be 
      displayed. Either need an API call, or some other configuration outside 
      of OCIO.
    - Doug: Inactive (env var controllable) color spaces could be used, but a 
      bit brute force. The categories and encoding are attributes of a color 
      space, more for config author, and application driven how that is used.
    - Mark: Might be good for docs team to do a style guide showing DCCs how to 
      design interfaces for working with OCIO, and what API calls to use.
    - Thomas: Or write a PyQt app to demonstrate the interfaces. Good to show 
      vendors how we're intending the config to be exposed.
    - Doug: That’s what the app helpers were intended to do. Would be nice to 
      have python thing on top of that.
    - Kevin: Other way of filtering is with tasks/departments. In rendering 
      they don't care about camera spaces, for example. DCC/context based.
    - Michael: That can be facilitated by categories.
    - Mark: Needs to be set with env vars which categories the DCC should 
      display.
    - Doug: On our todo list. Come up with list of categories and tell people 
      how to use them.
    - Kevin: How do we get people to use these categories when writing configs. 
      Might need to be opinionated.
    - Mark: I'm interested in how to generate config, but not able to give the 
      time. Might be able to show how internal tools work that generate configs. 
      Generates config from scratch. Could possibly contribute.
    - Michael: We might be able to find a UX person to contribute as well.
    - Mark: Be nice to have builtin implementation finished first.
