<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

January 19, 2021

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Dennis Adams - Sony
  * [X] Christophe Brejon
  * [X] Zach Lewis - Method
  * [X] Scott Dyer - A.M.P.A.S.
  * [X] Sean Cooper (_TSC_) - ARRI
  * [X] Kevin Wheatley (_TSC_) - Framestore

Apologies:
  * Thomas Mansencal

# **OCIO Configs Working Group Meeting Notes**

* Include skeleton API for missing building transforms in v2.0.0? Need to make 
  call on CY2021 ABI compatibility for VFX ref platform. If not may need to 
  expose transform internals in config:
    - Michael: Following up from TSC meeting discussion. Options put on the 
      table: Add stubs for missing transforms? Switch to a minor version range 
      in CY2021?
    - Decision: Back out of requested VFX ref platform change. Stick with 2.0.x
      for CY2021 and move forward with any needed minor version updates 
      throughout the year. ACES 1.3 support won't arrive until CY2022, and the 
      ACES config will use verbose color space definitions instead of Builtin 
      transforms in some places, but in performance and functionality will be 
      equivalent. We will attempt to maintain ABI compatibility for initial 
      minor version releases for users who want to drop newer versions into 
      CY2021 DCCs. There are some algorithms (e.g. PQ) that need to be added to
      core lib to support LUT-free ACES config. AD will submit PR with these 
      additions this week for the v2.0.0 release next week.
          - Other proposed plans would have worked, but the group determined it
            would be better to strictly follow semver and not make a rash 
            decision based solely on getting the changes into VFX ref platform. 
            As Sean put it: "Feels like the cart driving the horse". The agreed 
            upon resolution permits completion of the ACES reference 
            (and studio) configs and gives us a year to polish the v2 features 
            for CY2022. DCCs likely won't have v2 support until near mid year 
            anyway, and studios will likely delay further beyond that.

* Make decision on config generation code direction:
    - Michael: Propose we stick with current code in repo. Refinements can be 
      contributed via PR if needed. 
    - Mark and group: Go for it.
    - Sean: Will there be artifacts via CI? Biggest buffer to people not caring 
      about code.
    - Mark: Discussed artifacts and versioning earlier. Still plan to provide 
      artifacts.
    - Michael: Yes, Thomas add CI setup which can be extended to support that.

* Spreadsheet questions ACES feedback:
    - Michael: Open questions are related to inclusion of ACESproxy and the 
      DCDM output transforms. Scott suggested they not be included by email, 
      but we can discuss here to confirm a decision.
    - Carol: Get rid of them if ACES doesn't want them.
    - Scott: Better way to do DCDM than the transforms. Leave them out.
    - Michael: Same about ACESproxy?
    - Doug: Clipped integer version of ACEScc. Not sure why needed in OCIO.
    - Scott: Not sure of many using ACESproxy at all.
    - Group agrees to exclude these. Set to "excluded" in spreadsheet.
    - Carol: In first version, get people to speak up if they miss it.
    - Michael: Anything else?
    - Sean: Why only Sony Venice included?
    - Doug: Other Sony transforms in CSC section further up.
    - Carol: There isn't CSC of new Sony Venice IDTs yet.

* Un-tonemapped view naming:
    - Doug: Discussion about needing another view (un-tone-mapped) in config. 
      Trying to come up with name: Source colors, scene referred colors, 
      textures, colorimetry, colorimetric view, un-ton-mapped, no tone-map, 
      identity tone-map, identity view, 1:1, flat...
    - Decision: Group agrees on "un-tone-mapped" since it is explicit and 
      clear. It may be confusing to users not familiar with color science, but
      it is better to have something clear to config authors, and a good 
      learning opportunity for others. Also the term used by ACES.

* Review of ACES Output Transform prototype:
    - Doug demos how to implement output transform with current OCIO v2 state. 
      Breaking down transforms needed to create ODT, which in the future will 
      be defined in a builtin transform via C++.
    - Doug: Clamps around ACES primary change prevent negative values from 
      becoming large positives due to matrix. In testing that, noticed that 
      some ACES output transforms generate black in unexpected places. Tested 
      synthetic chart with camera log space. Values going through power 
      function to infinity. Builtin functions for CSC log transforms will send 
      large input values (outside 0-1) to infinity on output. Is that ok? Or 
      should we clamp to large positive value? Often implemented with LUTs 
      where infinity won't occur. Implemented here with LogCameraTransform, so 
      exact math. Value greater than one could give infinity.
    - Mark: Think infinity fine in that context. Doing the right thing.
    - Doug: Downside is for synthetic chart image, with RGB inf,inf,inf one 
      channel will become negative and get mapped to NaN (Inf - Inf) when going 
      through a matrix. Since NaN typically maps to zero, it's possible that 
      extremely bright values map to black on display.
    - Mark: Don't think would be problem. The formula should do what it does. 
      We understand floating point limitations and are used to hitting them, 
      so not crazy to expect same behavior here. Would be weird to do something 
      different.
