<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

June 19, 2020

Host: Carol Payne

Rotating Secretary: Michael Dolan

Attendees:
  * [X] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Alexa Zalipyatskikh - Autodesk
  * [X] Troy Sobotka

# **OCIO Documentation Working Group Meeting Notes**

* Config documentation:
    - Carol: A lot of the ACES config content is going to change while being 
      developed. Should docs utilize that work? Does it makes sense to tackle 
      other things first?
    - Michael: Config will be generated so may not be able to directly 
      reference in documentation. Could document the core config functionality 
      which is stable.
    - Doug: May want to generate test configs purely for example purposes. The 
      SPI configs were nice and simple, but don't use v2 features, and even 
      don't use some v1 features, so could create a config for purposed of 
      demonstration. 
    - Sean: Agree. Nice to have a config where you don't start pulling in 
      general color science issues. If you start bringing in rendering 
      transforms, etc, it could be confusing to people. Examples that could 
      start at baby steps, bare minimum, and build into something larger. 
      Specific use cases: need per shot CDL, etc.
    - Michael: Unit tests contain a lot of good resources for helping document 
      new config features.
    - Sean: Also good to have doc specific configs to use line numbers while 
      describing configs. A stable config that won't change.
    - Michael: Config docs are likely going to be the basis for all 
      documentation, since it ties everything together.
    - Carol: Would like to start with config docs.
    - Sean: As you start working with it, it will help reveal holes in docs.
    - Carol: Command-line tools are another good thing to document.
    - Michael: Command-line tools have decent usage docs builtin for reference 
      too.
    - Doug: Also good to focus on overall structure of things that need to be 
      written so contributors can pick topics to work on and distribute the 
      work. We need to break it down to help them find something to work on.
    - Sean: Fairly fine grained outline of what we expect is a good place to 
      start. Could be done in Wiki.
    - Carol: And can then break that down into trackable GH issues.

* Overall approach and structure:
    - Doug: Still struggling with previously shown four quadrant diagram and 
      where things fit into that. The existing user guide, where config is 
      currently explained, and then the SPI use case explained (describing 
      color management workflow). Where do those two things fit? Trying to get 
      the big picture of how we could assign different parts of the quadrants. 
      Discussed approach mixes these together.
    - Carol: At the base it would be a reference structure, and then within 
      that would be examples, and lead to user guides, etc. Or do we split 
      everything up, different section per topic and reader. Can approach 
      authoring in more structured ways, but present it together.
    - Doug: Seems like an approach to a text book, to teach someone and mix 
      different items into one narrative. From point of view of collaboration, 
      that makes it difficult to maintain an editorial voice throughout. Easier 
      to contribute by targeting specific item, in a more isolated fashion. 
      How do we merge tutorials with reference?
    - Carol: Will need to be stepping stones. Not sure we should write user 
      guide until reference docs done. Think we should write reference docs 
      first, and then base user guides on that reference. Will help break up 
      the work, but will need someone (Carol and Sean) to help with consistent 
      voice.
    - Sean: Another added complexity is that there's almost a four quadrant 
      structure per user. An artist and a developer are going to be looking for 
      very different things. The mixed structure is a bit like a textbook, with 
      a general narrative, but with side-margin details and reference.
    - Carol: From an artist perspective, they will likely mostly be looking for 
      how OCIO is implemented in DCCs. Think the biggest part of the narrative 
      will be for config authors. If we approach it from that perspective, we 
      can expand on it. By making config authoring more approachable we can 
      reach out from there. 
    - Doug: Starting reference first sounds good. It's concrete and can be 
      outlined. Can precisely describe what we're looking for so people can 
      jump in and help. Start with reference quadrant, which is needed to start 
      looking at v2, and work out from there. 
    - Alexa: There's already decent config docs, so could start from that. Hard 
      part is not just OCIO, but general lack of knowledge of color.
    - Sean: That's where small toy configs will help. Introduce features 
      without going too deep into color science concepts. Original intent of 
      docs and website was to be educational.
    - Alexa: Cinematic color would be good to reference. Have sections for 
      learning about general color science topics. fxphd is another resource.
    - Sean: New cinematic color paper still being worked on. Quite large.
    - Alexa: Would be good to also get some good reference images for examples.

  * Next steps:
    - Carol: Next steps, look at overall structure, and look at mini configs 
      for building up config docs.
    - Doug: Would help to understand the different pieces and deliverables from 
      this. A specification for the documentation, as if we're developing a 
      product. Description of deliverables, which people can then work off of - 
      the written part of it. The other part is the infrastructure part - 
      tools, Sphinx, etc. 
    - **TODO**: Sean to get infrastructure working.
    - Doug: Where will static site be hosted? Same as today?
    - Sean: Still to be determined. GH pages and RTD are options.
    - Doug: Have also discussed seeing what other ASWF projects have done for 
      homepage. 
    - Carol: Depends how tied together the docs are to the homepage. Is the 
      homepage generated with docs? Or separate? Where is each part hosted. 
      These things are flexible as long as doc generation works. Last week it 
      was determined to keep API and user guides tied together and generated 
      the same way. Just not sure about the fancy homepage.
    - Sean: Thinking all the docs will be generated by RTD, versioned, and the 
      website should just be non-version-specific stuff. Static, for 
      presentation. Could potentially host blog posts for interested 
      contributors, usage examples, etc.
    - Alexa: Do the forums fill that role?
    - Sean: Yes, but could be nicer for presentation vs. digging into mail list 
      threads. Since OCIO is super configurable, there are a lot of corner 
      cases, and users can contribute those case studies rather than us trying 
      to think of them all up front. Production-driven solutions that could be 
      shared. The website could host content like that. The site should exist 
      in GH, but not be married to generated docs. Could have ``www/`` subdirectory 
      in git for site.
    - Alexa: Can also have more static forum posts for that.
    - Michael: Could link ASWF lists site to the website, embedded to a link to 
      open a new tab.
    - Sean: Embedding it could be nice, via an iframe maybe, to get the lists 
      functionality for free. Should we start with bullet points in Google docs 
      before moving to GH issues?
    - Carol: Yes, wait to put it into an actionable state until we have an 
      outline. Google docs could use some cleanup to keep it organized. 
    - **TODO**: Carol will reorganize Google docs for planning documentation. 
      Will notify group when it's ready for further additions.
    - Sean: Would be great to have a organized structure by next week if 
      possible.
    - Doug: We (Autodesk) can fill in reference details. Looking for help with 
      how to make it look; the overall flow of where things will live. If you 
      were writing the v1 user guide, that top level tree, with brief 
      explanations, of what that should contain is enough for us to fill in. 
      What are the sections? How does a section compare to the v1 docs? What is 
      the structure of each section. Want to make sure everyone has expressed 
      their opinion on solving the v1 problems. Don't worry about the details 
      of individual features.
    - Sean: Would be good to use the OCIO mission statement as a guiding 
      mentality for how to approach the docs.
    - Carol: Good opportunity for democratization of concepts that have been 
      out of peoples reach. Nobody's creative ability should be limited by not 
      understanding the technical details.
