/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/YlOrBr.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 102, 37, 6, 255, 153, 52, 4, 255, 204, 76, 2, 255, 236, 112, 20, 255, 254, 153, 41, 255, 254, 196, 79, 255, 254, 227, 145, 255, 255, 247, 188, 255, 255, 255, 229, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlOrBr_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 101, 37, 5, 0, 102, 37, 6, 7, 102, 37, 6, 14, 103, 37, 6, 22, 103, 37, 6, 29, 103, 37, 6, 37, 104, 37, 6, 44, 104, 37, 6, 52, 105, 37, 6, 59, 105, 38, 6, 67, 105, 38, 6, 74, 106, 38, 6, 82, 106, 38, 6, 89, 106, 38, 6, 97, 107, 38, 6, 104, 107, 38, 6, 112, 108, 38, 6, 119, 108, 39, 6, 127, 108, 39, 6, 134, 109, 39, 6, 141, 109, 39, 6, 149, 110, 39, 6, 156, 110, 39, 6, 164, 110, 39, 6, 171, 111, 39, 6, 179, 111, 39, 6, 186, 112, 40, 6, 194, 112, 40, 6, 201, 112, 40, 6, 209, 113, 40, 6, 216, 113, 40, 6, 224, 113, 40, 6, 231, 114, 40, 6, 239, 114, 40, 6, 246, 115, 40, 6, 254, 115, 41, 6, 255, 115, 41, 6, 255, 116, 41, 6, 255, 116, 41, 6, 255, 117, 41, 6, 255, 117, 41, 6, 255, 117, 41, 6, 255, 118, 41, 6, 255, 118, 42, 6, 255, 119, 42, 6, 255, 119, 42, 6, 255, 119, 42, 6, 255, 120, 42, 6, 255, 120, 42, 6, 255, 121, 42, 6, 255, 121, 42, 6, 255, 121, 42, 6, 255, 122, 43, 6, 255, 122, 43, 6, 255, 123, 43, 6, 255, 123, 43, 6, 255, 123, 43, 6, 255, 124, 43, 6, 255, 124, 43, 6, 255, 125, 43, 6, 255, 125, 44, 6, 255, 125, 44, 6, 255, 126, 44, 6, 255, 126, 44, 5, 255, 127, 44, 5, 255, 127, 44, 5, 255, 127, 44, 5, 255, 128, 44, 5, 255, 128, 44, 5, 255, 129, 45, 5, 255, 129, 45, 5, 255, 129, 45, 5, 255, 130, 45, 5, 255, 130, 45, 5, 255, 131, 45, 5, 255, 131, 45, 5, 255, 131, 45, 5, 255, 132, 46, 5, 255, 132, 46, 5, 255, 133, 46, 5, 255, 133, 46, 5, 255, 133, 46, 5, 255, 134, 46, 5, 255, 134, 46, 5, 255, 135, 46, 5, 255, 135, 46, 5, 255, 135, 47, 5, 255, 136, 47, 5, 255, 136, 47, 5, 255, 137, 47, 5, 255, 137, 47, 5, 255, 137, 47, 5, 255, 138, 47, 5, 255, 138, 47, 5, 255, 139, 48, 5, 255, 139, 48, 5, 255, 139, 48, 5, 255, 140, 48, 5, 255, 140, 48, 5, 255, 141, 48, 5, 255, 141, 48, 5, 255, 141, 48, 4, 255, 142, 48, 4, 255, 142, 49, 4, 255, 143, 49, 4, 255, 143, 49, 4, 255, 143, 49, 4, 255, 144, 49, 4, 255, 144, 49, 4, 255, 145, 49, 4, 255, 145, 49, 4, 255, 146, 50, 4, 255, 146, 50, 4, 255, 146, 50, 4, 255, 147, 50, 4, 255, 147, 50, 4, 255, 148, 50, 4, 255, 148, 50, 4, 255, 148, 50, 4, 255, 149, 50, 4, 255, 149, 51, 4, 255, 150, 51, 4, 255, 150, 51, 4, 255, 150, 51, 4, 255, 151, 51, 4, 255, 151, 51, 4, 255, 152, 51, 4, 255, 152, 51, 4, 255, 152, 52, 3, 255, 153, 52, 4, 255, 153, 52, 4, 255, 154, 52, 4, 255, 154, 52, 4, 255, 154, 52, 4, 255, 155, 53, 4, 255, 155, 53, 3, 255, 156, 53, 3, 255, 156, 53, 3, 255, 156, 53, 3, 255, 157, 53, 3, 255, 157, 54, 3, 255, 158, 54, 3, 255, 158, 54, 3, 255, 158, 54, 3, 255, 159, 54, 3, 255, 159, 55, 3, 255, 160, 55, 3, 255, 160, 55, 3, 255, 160, 55, 3, 255, 161, 55, 3, 255, 161, 55, 3, 255, 162, 56, 3, 255, 162, 56, 3, 255, 162, 56, 3, 255, 163, 56, 3, 255, 163, 56, 3, 255, 163, 57, 3, 255, 164, 57, 3, 255, 164, 57, 3, 255, 165, 57, 3, 255, 165, 57, 3, 255, 165, 57, 3, 255, 166, 58, 3, 255, 166, 58, 3, 255, 167, 58, 3, 255, 167, 58, 3, 255, 167, 58, 3, 255, 168, 59, 3, 255, 168, 59, 3, 255, 169, 59, 3, 255, 169, 59, 3, 255, 169, 59, 3, 255, 170, 59, 3, 255, 170, 60, 3, 255, 171, 60, 3, 255, 171, 60, 3, 255, 171, 60, 3, 255, 172, 60, 3, 255, 172, 61, 3, 255, 173, 61, 3, 255, 173, 61, 3, 255, 173, 61, 3, 255, 174, 61, 3, 255, 174, 62, 3, 255, 175, 62, 3, 255, 175, 62, 3, 255, 175, 62, 3, 255, 176, 62, 3, 255, 176, 62, 3, 255, 177, 63, 3, 255, 177, 63, 3, 255, 177, 63, 3, 255, 178, 63, 3, 255, 178, 63, 3, 255, 179, 64, 3, 255, 179, 64, 3, 255, 179, 64, 3, 255, 180, 64, 3, 255, 180, 64, 3, 255, 181, 65, 3, 255, 181, 65, 3, 255, 181, 65, 3, 255, 182, 65, 3, 255, 182, 65, 3, 255, 183, 65, 3, 255, 183, 66, 3, 255, 183, 66, 3, 255, 184, 66, 3, 255, 184, 66, 3, 255, 185, 66, 3, 255, 185, 67, 3, 255, 185, 67, 3, 255, 186, 67, 3, 255, 186, 67, 3, 255, 187, 67, 3, 255, 187, 68, 3, 255, 187, 68, 3, 255, 188, 68, 3, 255, 188, 68, 3, 255, 189, 68, 3, 255, 189, 69, 3, 255, 189, 69, 3, 255, 190, 69, 3, 255, 190, 69, 2, 255, 191, 69, 2, 255, 191, 69, 2, 255, 191, 70, 2, 255, 192, 70, 2, 255, 192, 70, 2, 255, 193, 70, 2, 255, 193, 70, 2, 255, 193, 71, 2, 255, 194, 71, 2, 255, 194, 71, 2, 255, 195, 71, 2, 255, 195, 71, 2, 255, 195, 72, 2, 255, 196, 72, 2, 255, 196, 72, 2, 255, 197, 72, 2, 255, 197, 72, 2, 255, 197, 73, 2, 255, 198, 73, 2, 255, 198, 73, 2, 255, 199, 73, 2, 255, 199, 73, 2, 255, 199, 74, 2, 255, 200, 74, 2, 255, 200, 74, 2, 255, 201, 74, 2, 255, 201, 74, 2, 255, 201, 75, 2, 255, 202, 75, 2, 255, 202, 75, 2, 255, 203, 75, 2, 255, 203, 75, 2, 255, 203, 76, 1, 255, 204, 76, 2, 255, 204, 76, 2, 255, 204, 76, 2, 255, 205, 77, 2, 255, 205, 77, 2, 255, 205, 77, 2, 255, 205, 77, 2, 255, 206, 78, 2, 255, 206, 78, 2, 255, 206, 78, 3, 255, 206, 79, 3, 255, 207, 79, 3, 255, 207, 79, 3, 255, 207, 79, 3, 255, 207, 80, 3, 255, 208, 80, 3, 255, 208, 80, 3, 255, 208, 81, 3, 255, 208, 81, 4, 255, 209, 81, 4, 255, 209, 81, 4, 255, 209, 82, 4, 255, 209, 82, 4, 255, 210, 82, 4, 255, 210, 83, 4, 255, 210, 83, 4, 255, 210, 83, 5, 255, 211, 83, 5, 255, 211, 84, 5, 255, 211, 84, 5, 255, 211, 84, 5, 255, 212, 85, 5, 255, 212, 85, 5, 255, 212, 85, 5, 255, 212, 85, 6, 255, 213, 86, 6, 255, 213, 86, 6, 255, 213, 86, 6, 255, 213, 87, 6, 255, 214, 87, 6, 255, 214, 87, 6, 255, 214, 87, 7, 255, 214, 88, 7, 255, 215, 88, 7, 255, 215, 88, 7, 255, 215, 89, 7, 255, 215, 89, 7, 255, 216, 89, 7, 255, 216, 89, 8, 255, 216, 90, 8, 255, 216, 90, 8, 255, 217, 90, 8, 255, 217, 90, 8, 255, 217, 91, 8, 255, 217, 91, 8, 255, 218, 91, 9, 255, 218, 92, 9, 255, 218, 92, 9, 255, 218, 92, 9, 255, 219, 92, 9, 255, 219, 93, 9, 255, 219, 93, 10, 255, 219, 93, 10, 255, 220, 94, 10, 255, 220, 94, 10, 255, 220, 94, 10, 255, 220, 94, 10, 255, 221, 95, 11, 255, 221, 95, 11, 255, 221, 95, 11, 255, 221, 96, 11, 255, 222, 96, 11, 255, 222, 96, 11, 255, 222, 96, 11, 255, 222, 97, 12, 255, 223, 97, 12, 255, 223, 97, 12, 255, 223, 98, 12, 255, 223, 98, 12, 255, 224, 98, 12, 255, 224, 98, 13, 255, 224, 99, 13, 255, 224, 99, 13, 255, 225, 99, 13, 255, 225, 99, 13, 255, 225, 100, 13, 255, 225, 100, 13, 255, 226, 100, 14, 255, 226, 101, 14, 255, 226, 101, 14, 255, 226, 101, 14, 255, 227, 101, 14, 255, 227, 102, 14, 255, 227, 102, 15, 255, 227, 102, 15, 255, 228, 103, 15, 255, 228, 103, 15, 255, 228, 103, 15, 255, 228, 103, 15, 255, 229, 104, 15, 255, 229, 104, 16, 255, 229, 104, 16, 255, 229, 105, 16, 255, 230, 105, 16, 255, 230, 105, 16, 255, 230, 105, 16, 255, 230, 106, 16, 255, 231, 106, 17, 255, 231, 106, 17, 255, 231, 106, 17, 255, 231, 107, 17, 255, 232, 107, 17, 255, 232, 107, 17, 255, 232, 108, 17, 255, 232, 108, 18, 255, 233, 108, 18, 255, 233, 108, 18, 255, 233, 109, 18, 255, 233, 109, 18, 255, 234, 109, 18, 255, 234, 110, 18, 255, 234, 110, 19, 255, 234, 110, 19, 255, 235, 110, 19, 255, 235, 111, 19, 255, 235, 111, 19, 255, 235, 111, 19, 255, 235, 112, 19, 255, 236, 112, 20, 255, 236, 112, 20, 255, 236, 112, 20, 255, 236, 113, 20, 255, 236, 113, 20, 255, 236, 113, 20, 255, 237, 114, 20, 255, 237, 114, 21, 255, 237, 114, 21, 255, 237, 115, 21, 255, 237, 115, 21, 255, 237, 115, 21, 255, 237, 116, 21, 255, 238, 116, 21, 255, 238, 116, 22, 255, 238, 117, 22, 255, 238, 117, 22, 255, 238, 117, 22, 255, 238, 118, 22, 255, 238, 118, 22, 255, 239, 118, 22, 255, 239, 119, 23, 255, 239, 119, 23, 255, 239, 119, 23, 255, 239, 120, 23, 255, 239, 120, 23, 255, 239, 120, 23, 255, 240, 121, 23, 255, 240, 121, 24, 255, 240, 121, 24, 255, 240, 122, 24, 255, 240, 122, 24, 255, 240, 122, 24, 255, 240, 123, 24, 255, 241, 123, 25, 255, 241, 123, 25, 255, 241, 124, 25, 255, 241, 124, 25, 255, 241, 124, 25, 255, 241, 125, 25, 255, 241, 125, 25, 255, 242, 125, 26, 255, 242, 126, 26, 255, 242, 126, 26, 255, 242, 126, 26, 255, 242, 126, 26, 255, 242, 127, 26, 255, 242, 127, 27, 255, 243, 127, 27, 255, 243, 128, 27, 255, 243, 128, 27, 255, 243, 128, 27, 255, 243, 129, 27, 255, 243, 129, 27, 255, 243, 129, 28, 255, 244, 130, 28, 255, 244, 130, 28, 255, 244, 130, 28, 255, 244, 131, 28, 255, 244, 131, 28, 255, 244, 131, 29, 255, 244, 132, 29, 255, 245, 132, 29, 255, 245, 132, 29, 255, 245, 133, 29, 255, 245, 133, 29, 255, 245, 133, 30, 255, 245, 134, 30, 255, 245, 134, 30, 255, 246, 134, 30, 255, 246, 134, 30, 255, 246, 135, 30, 255, 246, 135, 31, 255, 246, 135, 31, 255, 246, 136, 31, 255, 246, 136, 31, 255, 247, 136, 31, 255, 247, 137, 31, 255, 247, 137, 32, 255, 247, 137, 32, 255, 247, 138, 32, 255, 247, 138, 32, 255, 247, 138, 32, 255, 248, 139, 32, 255, 248, 139, 33, 255, 248, 139, 33, 255, 248, 140, 33, 255, 248, 140, 33, 255, 248, 140, 33, 255, 248, 141, 34, 255, 249, 141, 34, 255, 249, 141, 34, 255, 249, 141, 34, 255, 249, 142, 34, 255, 249, 142, 34, 255, 249, 142, 35, 255, 249, 143, 35, 255, 249, 143, 35, 255, 250, 143, 35, 255, 250, 144, 35, 255, 250, 144, 35, 255, 250, 144, 36, 255, 250, 145, 36, 255, 250, 145, 36, 255, 250, 145, 36, 255, 251, 146, 36, 255, 251, 146, 37, 255, 251, 146, 37, 255, 251, 147, 37, 255, 251, 147, 37, 255, 251, 147, 37, 255, 251, 147, 38, 255, 251, 148, 38, 255, 252, 148, 38, 255, 252, 148, 38, 255, 252, 149, 38, 255, 252, 149, 38, 255, 252, 149, 39, 255, 252, 150, 39, 255, 252, 150, 39, 255, 253, 150, 39, 255, 253, 151, 39, 255, 253, 151, 40, 255, 253, 151, 40, 255, 253, 152, 40, 255, 253, 152, 40, 255, 253, 152, 40, 255, 253, 153, 40, 255, 254, 153, 41, 255, 254, 153, 41, 255, 254, 154, 41, 255, 254, 154, 41, 255, 254, 154, 42, 255, 254, 155, 42, 255, 254, 155, 42, 255, 254, 155, 42, 255, 254, 156, 43, 255, 254, 156, 43, 255, 254, 156, 43, 255, 254, 157, 43, 255, 254, 157, 44, 255, 254, 157, 44, 255, 254, 158, 44, 255, 254, 158, 44, 255, 254, 159, 45, 255, 254, 159, 45, 255, 254, 159, 45, 255, 254, 160, 46, 255, 254, 160, 46, 255, 254, 160, 46, 255, 254, 161, 46, 255, 254, 161, 47, 255, 254, 161, 47, 255, 254, 162, 47, 255, 254, 162, 47, 255, 254, 162, 48, 255, 254, 163, 48, 255, 254, 163, 48, 255, 254, 163, 48, 255, 254, 164, 49, 255, 254, 164, 49, 255, 254, 164, 49, 255, 254, 165, 50, 255, 254, 165, 50, 255, 254, 165, 50, 255, 254, 166, 50, 255, 254, 166, 51, 255, 254, 166, 51, 255, 254, 167, 51, 255, 254, 167, 51, 255, 254, 168, 52, 255, 254, 168, 52, 255, 254, 168, 52, 255, 254, 169, 53, 255, 254, 169, 53, 255, 254, 169, 53, 255, 254, 170, 53, 255, 254, 170, 54, 255, 254, 170, 54, 255, 254, 171, 54, 255, 254, 171, 55, 255, 254, 171, 55, 255, 254, 172, 55, 255, 254, 172, 56, 255, 254, 172, 56, 255, 254, 173, 56, 255, 254, 173, 56, 255, 254, 173, 57, 255, 254, 174, 57, 255, 254, 174, 57, 255, 254, 174, 58, 255, 254, 175, 58, 255, 254, 175, 58, 255, 254, 175, 58, 255, 254, 176, 59, 255, 254, 176, 59, 255, 254, 176, 59, 255, 254, 177, 60, 255, 254, 177, 60, 255, 254, 177, 60, 255, 254, 178, 61, 255, 254, 178, 61, 255, 254, 178, 61, 255, 254, 179, 62, 255, 254, 179, 62, 255, 254, 179, 62, 255, 254, 180, 62, 255, 254, 180, 63, 255, 254, 180, 63, 255, 254, 181, 63, 255, 254, 181, 64, 255, 254, 181, 64, 255, 254, 182, 64, 255, 254, 182, 65, 255, 254, 182, 65, 255, 254, 183, 65, 255, 254, 183, 66, 255, 254, 183, 66, 255, 254, 184, 66, 255, 254, 184, 67, 255, 254, 184, 67, 255, 254, 185, 67, 255, 254, 185, 68, 255, 254, 185, 68, 255, 254, 186, 68, 255, 254, 186, 68, 255, 254, 186, 69, 255, 254, 187, 69, 255, 254, 187, 69, 255, 254, 187, 70, 255, 254, 187, 70, 255, 254, 188, 70, 255, 254, 188, 71, 255, 254, 188, 71, 255, 254, 189, 71, 255, 254, 189, 72, 255, 254, 189, 72, 255, 254, 190, 72, 255, 254, 190, 73, 255, 254, 190, 73, 255, 254, 191, 73, 255, 254, 191, 74, 255, 254, 191, 74, 255, 254, 192, 74, 255, 254, 192, 75, 255, 254, 192, 75, 255, 254, 193, 75, 255, 253, 193, 76, 255, 253, 193, 76, 255, 253, 194, 76, 255, 253, 194, 77, 255, 253, 194, 77, 255, 253, 195, 77, 255, 253, 195, 78, 255, 253, 195, 78, 255, 253, 196, 78, 255, 253, 196, 79, 255, 253, 196, 80, 255, 253, 196, 80, 255, 253, 197, 81, 255, 253, 197, 81, 255, 253, 197, 82, 255, 253, 197, 82, 255, 253, 198, 83, 255, 253, 198, 83, 255, 253, 198, 84, 255, 253, 198, 84, 255, 253, 199, 85, 255, 253, 199, 85, 255, 253, 199, 86, 255, 253, 199, 86, 255, 253, 200, 87, 255, 253, 200, 87, 255, 253, 200, 88, 255, 253, 200, 88, 255, 253, 201, 89, 255, 253, 201, 90, 255, 253, 201, 90, 255, 253, 201, 91, 255, 253, 202, 91, 255, 253, 202, 92, 255, 253, 202, 92, 255, 253, 202, 93, 255, 253, 203, 93, 255, 253, 203, 94, 255, 253, 203, 94, 255, 253, 203, 95, 255, 253, 204, 95, 255, 253, 204, 96, 255, 253, 204, 96, 255, 253, 204, 97, 255, 253, 205, 97, 255, 253, 205, 98, 255, 253, 205, 98, 255, 253, 205, 99, 255, 253, 206, 99, 255, 253, 206, 100, 255, 253, 206, 100, 255, 253, 206, 101, 255, 253, 207, 101, 255, 253, 207, 102, 255, 253, 207, 102, 255, 253, 207, 103, 255, 253, 208, 103, 255, 253, 208, 104, 255, 253, 208, 105, 255, 253, 208, 105, 255, 253, 209, 106, 255, 253, 209, 106, 255, 253, 209, 107, 255, 253, 209, 107, 255, 253, 210, 108, 255, 253, 210, 108, 255, 253, 210, 109, 255, 253, 210, 109, 255, 253, 211, 110, 255, 253, 211, 110, 255, 253, 211, 111, 255, 253, 211, 111, 255, 253, 212, 112, 255, 253, 212, 112, 255, 253, 212, 113, 255, 253, 212, 113, 255, 253, 213, 114, 255, 253, 213, 114, 255, 253, 213, 115, 255, 253, 213, 115, 255, 253, 213, 116, 255, 253, 214, 116, 255, 253, 214, 117, 255, 253, 214, 117, 255, 253, 214, 118, 255, 253, 215, 118, 255, 253, 215, 119, 255, 253, 215, 119, 255, 253, 215, 120, 255, 253, 216, 120, 255, 253, 216, 121, 255, 253, 216, 121, 255, 253, 216, 122, 255, 253, 217, 122, 255, 253, 217, 123, 255, 253, 217, 123, 255, 253, 217, 124, 255, 253, 218, 124, 255, 253, 218, 125, 255, 253, 218, 126, 255, 253, 218, 126, 255, 253, 218, 127, 255, 253, 219, 127, 255, 253, 219, 128, 255, 253, 219, 128, 255, 253, 219, 129, 255, 253, 220, 129, 255, 253, 220, 130, 255, 253, 220, 130, 255, 253, 220, 131, 255, 253, 221, 131, 255, 253, 221, 132, 255, 253, 221, 132, 255, 253, 221, 133, 255, 253, 221, 133, 255, 253, 222, 134, 255, 253, 222, 134, 255, 253, 222, 135, 255, 253, 222, 135, 255, 253, 223, 136, 255, 253, 223, 136, 255, 253, 223, 137, 255, 253, 223, 137, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 139, 255, 253, 224, 139, 255, 253, 224, 140, 255, 253, 225, 140, 255, 253, 225, 141, 255, 253, 225, 141, 255, 253, 225, 142, 255, 253, 226, 142, 255, 253, 226, 143, 255, 253, 226, 143, 255, 253, 226, 144, 255, 253, 227, 144, 255, 253, 227, 145, 255, 253, 227, 145, 255, 253, 227, 145, 255, 253, 227, 146, 255, 253, 227, 146, 255, 253, 227, 146, 255, 253, 228, 147, 255, 253, 228, 147, 255, 253, 228, 147, 255, 253, 228, 148, 255, 253, 228, 148, 255, 253, 228, 148, 255, 253, 229, 149, 255, 253, 229, 149, 255, 253, 229, 149, 255, 253, 229, 150, 255, 253, 229, 150, 255, 253, 229, 150, 255, 253, 230, 151, 255, 253, 230, 151, 255, 253, 230, 151, 255, 253, 230, 152, 255, 253, 230, 152, 255, 253, 230, 152, 255, 253, 231, 153, 255, 253, 231, 153, 255, 253, 231, 153, 255, 253, 231, 154, 255, 253, 231, 154, 255, 253, 231, 154, 255, 253, 232, 155, 255, 253, 232, 155, 255, 253, 232, 155, 255, 253, 232, 156, 255, 253, 232, 156, 255, 253, 232, 156, 255, 253, 233, 157, 255, 253, 233, 157, 255, 253, 233, 157, 255, 253, 233, 158, 255, 253, 233, 158, 255, 253, 233, 158, 255, 253, 233, 159, 255, 253, 234, 159, 255, 253, 234, 159, 255, 253, 234, 160, 255, 253, 234, 160, 255, 253, 234, 160, 255, 253, 234, 161, 255, 253, 235, 161, 255, 253, 235, 161, 255, 253, 235, 162, 255, 253, 235, 162, 255, 253, 235, 162, 255, 253, 235, 163, 255, 253, 236, 163, 255, 253, 236, 163, 255, 253, 236, 164, 255, 253, 236, 164, 255, 253, 236, 164, 255, 253, 236, 165, 255, 253, 236, 165, 255, 253, 237, 166, 255, 253, 237, 166, 255, 253, 237, 166, 255, 253, 237, 167, 255, 253, 237, 167, 255, 253, 237, 167, 255, 253, 238, 168, 255, 253, 238, 168, 255, 253, 238, 168, 255, 253, 238, 169, 255, 253, 238, 169, 255, 253, 238, 169, 255, 253, 239, 170, 255, 253, 239, 170, 255, 253, 239, 170, 255, 253, 239, 171, 255, 254, 239, 171, 255, 254, 239, 171, 255, 254, 239, 172, 255, 254, 240, 172, 255, 254, 240, 172, 255, 254, 240, 173, 255, 254, 240, 173, 255, 254, 240, 173, 255, 254, 240, 174, 255, 254, 241, 174, 255, 254, 241, 174, 255, 254, 241, 175, 255, 254, 241, 175, 255, 254, 241, 175, 255, 254, 241, 176, 255, 254, 241, 176, 255, 254, 242, 176, 255, 254, 242, 177, 255, 254, 242, 177, 255, 254, 242, 177, 255, 254, 242, 178, 255, 254, 242, 178, 255, 254, 242, 178, 255, 254, 243, 179, 255, 254, 243, 179, 255, 254, 243, 179, 255, 254, 243, 180, 255, 254, 243, 180, 255, 254, 243, 180, 255, 254, 244, 181, 255, 254, 244, 181, 255, 254, 244, 181, 255, 254, 244, 182, 255, 254, 244, 182, 255, 254, 244, 182, 255, 254, 244, 183, 255, 254, 245, 183, 255, 254, 245, 183, 255, 254, 245, 184, 255, 254, 245, 184, 255, 254, 245, 184, 255, 254, 245, 185, 255, 254, 245, 185, 255, 254, 246, 185, 255, 254, 246, 186, 255, 254, 246, 186, 255, 254, 246, 186, 255, 254, 246, 187, 255, 254, 246, 187, 255, 254, 247, 187, 255, 254, 247, 188, 255, 254, 247, 188, 255, 254, 247, 188, 255, 254, 247, 189, 255, 254, 247, 189, 255, 254, 247, 189, 255, 254, 247, 190, 255, 254, 247, 190, 255, 254, 247, 190, 255, 254, 247, 191, 255, 254, 247, 191, 255, 254, 247, 191, 255, 254, 247, 192, 255, 254, 247, 192, 255, 254, 248, 192, 255, 254, 248, 193, 255, 254, 248, 193, 255, 254, 248, 193, 255, 254, 248, 194, 255, 254, 248, 194, 255, 254, 248, 194, 255, 254, 248, 195, 255, 254, 248, 195, 255, 254, 248, 195, 255, 254, 248, 196, 255, 254, 248, 196, 255, 254, 248, 196, 255, 254, 248, 197, 255, 254, 249, 197, 255, 254, 249, 197, 255, 254, 249, 198, 255, 254, 249, 198, 255, 254, 249, 198, 255, 254, 249, 199, 255, 254, 249, 199, 255, 254, 249, 199, 255, 254, 249, 199, 255, 254, 249, 200, 255, 254, 249, 200, 255, 254, 249, 200, 255, 254, 249, 201, 255, 254, 249, 201, 255, 254, 249, 201, 255, 254, 250, 202, 255, 254, 250, 202, 255, 254, 250, 202, 255, 254, 250, 203, 255, 254, 250, 203, 255, 254, 250, 203, 255, 254, 250, 204, 255, 254, 250, 204, 255, 254, 250, 204, 255, 254, 250, 205, 255, 254, 250, 205, 255, 254, 250, 205, 255, 254, 250, 206, 255, 254, 250, 206, 255, 254, 250, 206, 255, 254, 250, 207, 255, 254, 251, 207, 255, 254, 251, 207, 255, 254, 251, 208, 255, 254, 251, 208, 255, 254, 251, 208, 255, 254, 251, 209, 255, 254, 251, 209, 255, 254, 251, 209, 255, 254, 251, 209, 255, 254, 251, 210, 255, 254, 251, 210, 255, 254, 251, 210, 255, 254, 251, 211, 255, 254, 251, 211, 255, 254, 251, 211, 255, 254, 251, 212, 255, 254, 252, 212, 255, 254, 252, 212, 255, 254, 252, 213, 255, 254, 252, 213, 255, 254, 252, 213, 255, 254, 252, 214, 255, 254, 252, 214, 255, 254, 252, 214, 255, 254, 252, 215, 255, 254, 252, 215, 255, 254, 252, 215, 255, 254, 252, 216, 255, 254, 252, 216, 255, 254, 252, 216, 255, 254, 252, 216, 255, 254, 252, 217, 255, 254, 252, 217, 255, 254, 253, 217, 255, 254, 253, 218, 255, 254, 253, 218, 255, 254, 253, 218, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlOrBr_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 101, 37, 5, 0, 102, 37, 6, 7, 102, 37, 6, 14, 102, 37, 6, 22, 103, 37, 6, 29, 103, 37, 6, 37, 103, 37, 6, 44, 104, 37, 6, 52, 104, 37, 6, 59, 104, 37, 6, 67, 105, 37, 6, 74, 105, 38, 6, 82, 105, 38, 6, 89, 105, 38, 6, 97, 106, 38, 6, 104, 106, 38, 6, 112, 106, 38, 6, 119, 107, 38, 6, 127, 107, 38, 6, 134, 107, 38, 6, 141, 108, 38, 6, 149, 108, 38, 6, 156, 108, 39, 6, 164, 109, 39, 6, 171, 109, 39, 6, 179, 109, 39, 6, 186, 110, 39, 6, 194, 110, 39, 6, 201, 110, 39, 6, 209, 110, 39, 6, 216, 111, 39, 6, 224, 111, 39, 6, 231, 111, 40, 6, 239, 112, 40, 6, 246, 112, 40, 6, 254, 112, 40, 6, 255, 113, 40, 6, 255, 113, 40, 6, 255, 113, 40, 6, 255, 114, 40, 6, 255, 114, 40, 6, 255, 114, 40, 6, 255, 115, 40, 6, 255, 115, 41, 6, 255, 115, 41, 6, 255, 115, 41, 6, 255, 116, 41, 6, 255, 116, 41, 6, 255, 116, 41, 6, 255, 117, 41, 6, 255, 117, 41, 6, 255, 117, 41, 6, 255, 118, 41, 6, 255, 118, 41, 6, 255, 118, 42, 6, 255, 119, 42, 6, 255, 119, 42, 6, 255, 119, 42, 6, 255, 120, 42, 6, 255, 120, 42, 6, 255, 120, 42, 6, 255, 121, 42, 6, 255, 121, 42, 6, 255, 121, 42, 5, 255, 132, 46, 5, 255, 132, 46, 5, 255, 132, 46, 5, 255, 133, 46, 5, 255, 133, 46, 5, 255, 133, 46, 5, 255, 134, 46, 5, 255, 134, 46, 5, 255, 134, 46, 5, 255, 135, 46, 5, 255, 135, 46, 5, 255, 135, 47, 5, 255, 136, 47, 5, 255, 136, 47, 5, 255, 136, 47, 5, 255, 137, 47, 5, 255, 137, 47, 5, 255, 137, 47, 5, 255, 137, 47, 5, 255, 138, 47, 5, 255, 138, 47, 5, 255, 138, 47, 5, 255, 139, 48, 5, 255, 139, 48, 5, 255, 139, 48, 5, 255, 140, 48, 5, 255, 140, 48, 5, 255, 140, 48, 5, 255, 141, 48, 5, 255, 141, 48, 4, 255, 141, 48, 4, 255, 142, 48, 4, 255, 142, 49, 4, 255, 142, 49, 4, 255, 143, 49, 4, 255, 143, 49, 4, 255, 143, 49, 4, 255, 144, 49, 4, 255, 144, 49, 4, 255, 144, 49, 4, 255, 145, 49, 4, 255, 145, 49, 4, 255, 145, 49, 4, 255, 146, 50, 4, 255, 146, 50, 4, 255, 146, 50, 4, 255, 147, 50, 4, 255, 147, 50, 4, 255, 147, 50, 4, 255, 148, 50, 4, 255, 148, 50, 4, 255, 148, 50, 4, 255, 149, 50, 4, 255, 149, 50, 4, 255, 149, 51, 4, 255, 150, 51, 4, 255, 150, 51, 4, 255, 150, 51, 4, 255, 151, 51, 4, 255, 151, 51, 4, 255, 151, 51, 4, 255, 152, 51, 4, 255, 152, 51, 4, 255, 152, 51, 4, 255, 152, 52, 3, 255, 153, 52, 4, 255, 153, 52, 4, 255, 153, 52, 4, 255, 154, 52, 4, 255, 154, 52, 4, 255, 154, 52, 4, 255, 155, 53, 3, 255, 155, 53, 3, 255, 155, 53, 3, 255, 156, 53, 3, 255, 156, 53, 3, 255, 156, 53, 3, 255, 157, 53, 3, 255, 157, 54, 3, 255, 157, 54, 3, 255, 158, 54, 3, 255, 158, 54, 3, 255, 158, 54, 3, 255, 158, 54, 3, 255, 159, 54, 3, 255, 159, 55, 3, 255, 159, 55, 3, 255, 160, 55, 3, 255, 160, 55, 3, 255, 160, 55, 3, 255, 161, 55, 3, 255, 161, 55, 3, 255, 161, 56, 3, 255, 162, 56, 3, 255, 162, 56, 3, 255, 162, 56, 3, 255, 163, 56, 3, 255, 163, 56, 3, 255, 163, 56, 3, 255, 164, 57, 3, 255, 164, 57, 3, 255, 164, 57, 3, 255, 164, 57, 3, 255, 165, 57, 3, 255, 165, 57, 3, 255, 165, 57, 3, 255, 166, 58, 3, 255, 166, 58, 3, 255, 166, 58, 3, 255, 167, 58, 3, 255, 167, 58, 3, 255, 167, 58, 3, 255, 168, 58, 3, 255, 168, 59, 3, 255, 168, 59, 3, 255, 169, 59, 3, 255, 169, 59, 3, 255, 169, 59, 3, 255, 170, 59, 3, 255, 170, 60, 3, 255, 170, 60, 3, 255, 170, 60, 3, 255, 171, 60, 3, 255, 171, 60, 3, 255, 171, 60, 3, 255, 172, 60, 3, 255, 172, 61, 3, 255, 172, 61, 3, 255, 183, 66, 3, 255, 183, 66, 3, 255, 184, 66, 3, 255, 184, 66, 3, 255, 184, 66, 3, 255, 185, 66, 3, 255, 185, 67, 3, 255, 185, 67, 3, 255, 185, 67, 3, 255, 186, 67, 3, 255, 186, 67, 3, 255, 186, 67, 3, 255, 187, 67, 3, 255, 187, 68, 3, 255, 187, 68, 3, 255, 188, 68, 3, 255, 188, 68, 3, 255, 188, 68, 3, 255, 189, 68, 3, 255, 189, 69, 3, 255, 189, 69, 2, 255, 190, 69, 2, 255, 190, 69, 2, 255, 190, 69, 2, 255, 191, 69, 2, 255, 191, 69, 2, 255, 191, 70, 2, 255, 192, 70, 2, 255, 192, 70, 2, 255, 192, 70, 2, 255, 193, 70, 2, 255, 193, 70, 2, 255, 193, 71, 2, 255, 193, 71, 2, 255, 194, 71, 2, 255, 194, 71, 2, 255, 194, 71, 2, 255, 195, 71, 2, 255, 195, 71, 2, 255, 195, 72, 2, 255, 196, 72, 2, 255, 196, 72, 2, 255, 196, 72, 2, 255, 197, 72, 2, 255, 197, 72, 2, 255, 197, 73, 2, 255, 198, 73, 2, 255, 198, 73, 2, 255, 198, 73, 2, 255, 199, 73, 2, 255, 199, 73, 2, 255, 199, 73, 2, 255, 200, 74, 2, 255, 200, 74, 2, 255, 200, 74, 2, 255, 201, 74, 2, 255, 201, 74, 2, 255, 201, 74, 2, 255, 202, 75, 2, 255, 202, 75, 2, 255, 202, 75, 2, 255, 203, 75, 2, 255, 203, 75, 2, 255, 203, 75, 2, 255, 203, 76, 1, 255, 204, 76, 2, 255, 204, 76, 2, 255, 204, 76, 2, 255, 204, 76, 2, 255, 205, 77, 2, 255, 205, 77, 2, 255, 205, 77, 2, 255, 205, 77, 2, 255, 205, 78, 2, 255, 206, 78, 2, 255, 206, 78, 2, 255, 206, 78, 3, 255, 206, 78, 3, 255, 206, 79, 3, 255, 207, 79, 3, 255, 207, 79, 3, 255, 207, 79, 3, 255, 207, 80, 3, 255, 207, 80, 3, 255, 208, 80, 3, 255, 208, 80, 3, 255, 208, 81, 3, 255, 208, 81, 4, 255, 208, 81, 4, 255, 209, 81, 4, 255, 209, 81, 4, 255, 209, 82, 4, 255, 209, 82, 4, 255, 209, 82, 4, 255, 210, 82, 4, 255, 210, 83, 4, 255, 210, 83, 4, 255, 210, 83, 5, 255, 210, 83, 5, 255, 211, 83, 5, 255, 211, 84, 5, 255, 211, 84, 5, 255, 211, 84, 5, 255, 211, 84, 5, 255, 212, 85, 5, 255, 212, 85, 5, 255, 212, 85, 6, 255, 212, 85, 6, 255, 212, 85, 6, 255, 213, 86, 6, 255, 213, 86, 6, 255, 213, 86, 6, 255, 213, 86, 6, 255, 213, 87, 6, 255, 214, 87, 6, 255, 214, 87, 7, 255, 214, 87, 7, 255, 214, 87, 7, 255, 214, 88, 7, 255, 215, 88, 7, 255, 215, 88, 7, 255, 215, 88, 7, 255, 215, 89, 7, 255, 215, 89, 8, 255, 216, 89, 8, 255, 216, 89, 8, 255, 216, 90, 8, 255, 216, 90, 8, 255, 223, 97, 12, 255, 223, 97, 12, 255, 223, 98, 12, 255, 223, 98, 12, 255, 224, 98, 12, 255, 224, 98, 12, 255, 224, 99, 13, 255, 224, 99, 13, 255, 224, 99, 13, 255, 225, 99, 13, 255, 225, 99, 13, 255, 225, 100, 13, 255, 225, 100, 13, 255, 225, 100, 13, 255, 226, 100, 14, 255, 226, 101, 14, 255, 226, 101, 14, 255, 226, 101, 14, 255, 226, 101, 14, 255, 227, 101, 14, 255, 227, 102, 14, 255, 227, 102, 14, 255, 227, 102, 15, 255, 227, 102, 15, 255, 228, 103, 15, 255, 228, 103, 15, 255, 228, 103, 15, 255, 228, 103, 15, 255, 228, 103, 15, 255, 229, 104, 15, 255, 229, 104, 16, 255, 229, 104, 16, 255, 229, 104, 16, 255, 229, 105, 16, 255, 230, 105, 16, 255, 230, 105, 16, 255, 230, 105, 16, 255, 230, 105, 16, 255, 230, 106, 16, 255, 231, 106, 17, 255, 231, 106, 17, 255, 231, 106, 17, 255, 231, 107, 17, 255, 231, 107, 17, 255, 232, 107, 17, 255, 232, 107, 17, 255, 232, 107, 17, 255, 232, 108, 18, 255, 232, 108, 18, 255, 233, 108, 18, 255, 233, 108, 18, 255, 233, 109, 18, 255, 233, 109, 18, 255, 233, 109, 18, 255, 234, 109, 18, 255, 234, 109, 18, 255, 234, 110, 19, 255, 234, 110, 19, 255, 234, 110, 19, 255, 235, 110, 19, 255, 235, 111, 19, 255, 235, 111, 19, 255, 235, 111, 19, 255, 235, 111, 19, 255, 235, 112, 19, 255, 236, 112, 20, 255, 236, 112, 20, 255, 236, 112, 20, 255, 236, 113, 20, 255, 236, 113, 20, 255, 236, 113, 20, 255, 236, 113, 20, 255, 236, 114, 20, 255, 237, 114, 20, 255, 237, 114, 21, 255, 237, 114, 21, 255, 237, 115, 21, 255, 237, 115, 21, 255, 237, 115, 21, 255, 237, 115, 21, 255, 237, 116, 21, 255, 238, 116, 21, 255, 238, 116, 21, 255, 238, 116, 22, 255, 238, 117, 22, 255, 238, 117, 22, 255, 238, 117, 22, 255, 238, 118, 22, 255, 238, 118, 22, 255, 238, 118, 22, 255, 239, 118, 22, 255, 239, 119, 23, 255, 239, 119, 23, 255, 239, 119, 23, 255, 239, 119, 23, 255, 239, 120, 23, 255, 239, 120, 23, 255, 239, 120, 23, 255, 239, 120, 23, 255, 240, 121, 24, 255, 240, 121, 24, 255, 240, 121, 24, 255, 240, 121, 24, 255, 240, 122, 24, 255, 240, 122, 24, 255, 240, 122, 24, 255, 240, 122, 24, 255, 241, 123, 24, 255, 241, 123, 25, 255, 241, 123, 25, 255, 241, 123, 25, 255, 241, 124, 25, 255, 241, 124, 25, 255, 241, 124, 25, 255, 241, 125, 25, 255, 241, 125, 25, 255, 242, 125, 26, 255, 242, 125, 26, 255, 242, 126, 26, 255, 242, 126, 26, 255, 242, 126, 26, 255, 242, 126, 26, 255, 242, 127, 26, 255, 242, 127, 27, 255, 242, 127, 27, 255, 243, 127, 27, 255, 243, 128, 27, 255, 243, 128, 27, 255, 247, 136, 31, 255, 247, 137, 32, 255, 247, 137, 32, 255, 247, 137, 32, 255, 247, 137, 32, 255, 247, 138, 32, 255, 247, 138, 32, 255, 247, 138, 32, 255, 247, 138, 32, 255, 248, 139, 33, 255, 248, 139, 33, 255, 248, 139, 33, 255, 248, 139, 33, 255, 248, 140, 33, 255, 248, 140, 33, 255, 248, 140, 33, 255, 248, 140, 34, 255, 248, 141, 34, 255, 249, 141, 34, 255, 249, 141, 34, 255, 249, 141, 34, 255, 249, 142, 34, 255, 249, 142, 34, 255, 249, 142, 35, 255, 249, 142, 35, 255, 249, 143, 35, 255, 249, 143, 35, 255, 250, 143, 35, 255, 250, 143, 35, 255, 250, 144, 35, 255, 250, 144, 35, 255, 250, 144, 36, 255, 250, 144, 36, 255, 250, 145, 36, 255, 250, 145, 36, 255, 250, 145, 36, 255, 250, 145, 36, 255, 251, 146, 36, 255, 251, 146, 37, 255, 251, 146, 37, 255, 251, 146, 37, 255, 251, 147, 37, 255, 251, 147, 37, 255, 251, 147, 37, 255, 251, 147, 38, 255, 251, 148, 38, 255, 252, 148, 38, 255, 252, 148, 38, 255, 252, 148, 38, 255, 252, 149, 38, 255, 252, 149, 38, 255, 252, 149, 39, 255, 252, 149, 39, 255, 252, 150, 39, 255, 252, 150, 39, 255, 253, 150, 39, 255, 253, 150, 39, 255, 253, 151, 39, 255, 253, 151, 40, 255, 253, 151, 40, 255, 253, 151, 40, 255, 253, 152, 40, 255, 253, 152, 40, 255, 253, 152, 40, 255, 253, 153, 40, 255, 254, 153, 41, 255, 254, 153, 41, 255, 254, 153, 41, 255, 254, 154, 41, 255, 254, 154, 41, 255, 254, 154, 42, 255, 254, 154, 42, 255, 254, 155, 42, 255, 254, 155, 42, 255, 254, 155, 42, 255, 254, 156, 43, 255, 254, 156, 43, 255, 254, 156, 43, 255, 254, 156, 43, 255, 254, 157, 43, 255, 254, 157, 44, 255, 254, 157, 44, 255, 254, 158, 44, 255, 254, 158, 44, 255, 254, 158, 45, 255, 254, 158, 45, 255, 254, 159, 45, 255, 254, 159, 45, 255, 254, 159, 45, 255, 254, 160, 46, 255, 254, 160, 46, 255, 254, 160, 46, 255, 254, 160, 46, 255, 254, 161, 46, 255, 254, 161, 47, 255, 254, 161, 47, 255, 254, 161, 47, 255, 254, 162, 47, 255, 254, 162, 48, 255, 254, 162, 48, 255, 254, 163, 48, 255, 254, 163, 48, 255, 254, 163, 48, 255, 254, 163, 49, 255, 254, 164, 49, 255, 254, 164, 49, 255, 254, 164, 49, 255, 254, 165, 50, 255, 254, 165, 50, 255, 254, 165, 50, 255, 254, 165, 50, 255, 254, 166, 50, 255, 254, 166, 51, 255, 254, 166, 51, 255, 254, 166, 51, 255, 254, 167, 51, 255, 254, 167, 52, 255, 254, 167, 52, 255, 254, 168, 52, 255, 254, 168, 52, 255, 254, 168, 53, 255, 254, 168, 53, 255, 254, 169, 53, 255, 254, 169, 53, 255, 254, 169, 53, 255, 254, 169, 54, 255, 254, 170, 54, 255, 254, 170, 54, 255, 254, 179, 62, 255, 254, 179, 62, 255, 254, 179, 62, 255, 254, 180, 63, 255, 254, 180, 63, 255, 254, 180, 63, 255, 254, 180, 63, 255, 254, 181, 64, 255, 254, 181, 64, 255, 254, 181, 64, 255, 254, 181, 64, 255, 254, 182, 65, 255, 254, 182, 65, 255, 254, 182, 65, 255, 254, 183, 65, 255, 254, 183, 66, 255, 254, 183, 66, 255, 254, 183, 66, 255, 254, 184, 66, 255, 254, 184, 67, 255, 254, 184, 67, 255, 254, 184, 67, 255, 254, 185, 67, 255, 254, 185, 68, 255, 254, 185, 68, 255, 254, 185, 68, 255, 254, 186, 68, 255, 254, 186, 69, 255, 254, 186, 69, 255, 254, 186, 69, 255, 254, 187, 69, 255, 254, 187, 70, 255, 254, 187, 70, 255, 254, 188, 70, 255, 254, 188, 70, 255, 254, 188, 71, 255, 254, 188, 71, 255, 254, 189, 71, 255, 254, 189, 72, 255, 254, 189, 72, 255, 254, 189, 72, 255, 254, 190, 72, 255, 254, 190, 73, 255, 254, 190, 73, 255, 254, 190, 73, 255, 254, 191, 73, 255, 254, 191, 74, 255, 254, 191, 74, 255, 254, 191, 74, 255, 254, 192, 74, 255, 254, 192, 75, 255, 254, 192, 75, 255, 254, 192, 75, 255, 254, 193, 76, 255, 254, 193, 76, 255, 254, 193, 76, 255, 253, 193, 76, 255, 253, 194, 77, 255, 253, 194, 77, 255, 253, 194, 77, 255, 253, 194, 77, 255, 253, 195, 78, 255, 253, 195, 78, 255, 253, 195, 78, 255, 253, 196, 78, 255, 253, 196, 79, 255, 253, 196, 79, 255, 253, 196, 80, 255, 253, 196, 80, 255, 253, 197, 81, 255, 253, 197, 81, 255, 253, 197, 81, 255, 253, 197, 82, 255, 253, 197, 82, 255, 253, 198, 83, 255, 253, 198, 83, 255, 253, 198, 84, 255, 253, 198, 84, 255, 253, 198, 84, 255, 253, 199, 85, 255, 253, 199, 85, 255, 253, 199, 86, 255, 253, 199, 86, 255, 253, 199, 86, 255, 253, 200, 87, 255, 253, 200, 87, 255, 253, 200, 88, 255, 253, 200, 88, 255, 253, 200, 89, 255, 253, 201, 89, 255, 253, 201, 89, 255, 253, 201, 90, 255, 253, 201, 90, 255, 253, 201, 91, 255, 253, 202, 91, 255, 253, 202, 91, 255, 253, 202, 92, 255, 253, 202, 92, 255, 253, 202, 93, 255, 253, 203, 93, 255, 253, 203, 94, 255, 253, 203, 94, 255, 253, 203, 94, 255, 253, 203, 95, 255, 253, 204, 95, 255, 253, 204, 96, 255, 253, 204, 96, 255, 253, 204, 96, 255, 253, 204, 97, 255, 253, 205, 97, 255, 253, 205, 98, 255, 253, 205, 98, 255, 253, 205, 98, 255, 253, 205, 99, 255, 253, 206, 99, 255, 253, 206, 100, 255, 253, 206, 100, 255, 253, 206, 101, 255, 253, 206, 101, 255, 253, 207, 101, 255, 253, 207, 102, 255, 253, 207, 102, 255, 253, 207, 103, 255, 253, 207, 103, 255, 253, 208, 103, 255, 253, 208, 104, 255, 253, 208, 104, 255, 253, 208, 105, 255, 253, 215, 118, 255, 253, 215, 119, 255, 253, 215, 119, 255, 253, 215, 119, 255, 253, 215, 120, 255, 253, 215, 120, 255, 253, 216, 121, 255, 253, 216, 121, 255, 253, 216, 122, 255, 253, 216, 122, 255, 253, 216, 122, 255, 253, 217, 123, 255, 253, 217, 123, 255, 253, 217, 124, 255, 253, 217, 124, 255, 253, 217, 124, 255, 253, 218, 125, 255, 253, 218, 125, 255, 253, 218, 126, 255, 253, 218, 126, 255, 253, 218, 126, 255, 253, 219, 127, 255, 253, 219, 127, 255, 253, 219, 128, 255, 253, 219, 128, 255, 253, 219, 128, 255, 253, 219, 129, 255, 253, 220, 129, 255, 253, 220, 130, 255, 253, 220, 130, 255, 253, 220, 131, 255, 253, 220, 131, 255, 253, 221, 131, 255, 253, 221, 132, 255, 253, 221, 132, 255, 253, 221, 133, 255, 253, 221, 133, 255, 253, 222, 133, 255, 253, 222, 134, 255, 253, 222, 134, 255, 253, 222, 135, 255, 253, 222, 135, 255, 253, 222, 135, 255, 253, 223, 136, 255, 253, 223, 136, 255, 253, 223, 137, 255, 253, 223, 137, 255, 253, 223, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 139, 255, 253, 224, 139, 255, 253, 224, 140, 255, 253, 225, 140, 255, 253, 225, 140, 255, 253, 225, 141, 255, 253, 225, 141, 255, 253, 225, 142, 255, 253, 225, 142, 255, 253, 226, 142, 255, 253, 226, 143, 255, 253, 226, 143, 255, 253, 226, 144, 255, 253, 226, 144, 255, 253, 227, 144, 255, 253, 227, 145, 255, 253, 227, 145, 255, 253, 227, 145, 255, 253, 227, 146, 255, 253, 227, 146, 255, 253, 227, 146, 255, 253, 227, 146, 255, 253, 228, 147, 255, 253, 228, 147, 255, 253, 228, 147, 255, 253, 228, 147, 255, 253, 228, 148, 255, 253, 228, 148, 255, 253, 228, 148, 255, 253, 228, 148, 255, 253, 229, 149, 255, 253, 229, 149, 255, 253, 229, 149, 255, 253, 229, 150, 255, 253, 229, 150, 255, 253, 229, 150, 255, 253, 229, 150, 255, 253, 230, 151, 255, 253, 230, 151, 255, 253, 230, 151, 255, 253, 230, 151, 255, 253, 230, 152, 255, 253, 230, 152, 255, 253, 230, 152, 255, 253, 230, 152, 255, 253, 231, 153, 255, 253, 231, 153, 255, 253, 231, 153, 255, 253, 231, 154, 255, 253, 231, 154, 255, 253, 231, 154, 255, 253, 231, 154, 255, 253, 231, 155, 255, 253, 232, 155, 255, 253, 232, 155, 255, 253, 232, 155, 255, 253, 232, 156, 255, 253, 232, 156, 255, 253, 232, 156, 255, 253, 232, 156, 255, 253, 232, 157, 255, 253, 233, 157, 255, 253, 233, 157, 255, 253, 233, 158, 255, 253, 233, 158, 255, 253, 233, 158, 255, 253, 233, 158, 255, 253, 233, 159, 255, 253, 233, 159, 255, 253, 234, 159, 255, 253, 234, 159, 255, 253, 234, 160, 255, 253, 234, 160, 255, 253, 234, 160, 255, 253, 234, 160, 255, 253, 234, 161, 255, 253, 234, 161, 255, 253, 235, 161, 255, 254, 239, 170, 255, 254, 239, 170, 255, 254, 239, 171, 255, 254, 239, 171, 255, 254, 239, 171, 255, 254, 239, 172, 255, 254, 239, 172, 255, 254, 240, 172, 255, 254, 240, 172, 255, 254, 240, 173, 255, 254, 240, 173, 255, 254, 240, 173, 255, 254, 240, 173, 255, 254, 240, 174, 255, 254, 240, 174, 255, 254, 241, 174, 255, 254, 241, 174, 255, 254, 241, 175, 255, 254, 241, 175, 255, 254, 241, 175, 255, 254, 241, 176, 255, 254, 241, 176, 255, 254, 241, 176, 255, 254, 242, 176, 255, 254, 242, 177, 255, 254, 242, 177, 255, 254, 242, 177, 255, 254, 242, 177, 255, 254, 242, 178, 255, 254, 242, 178, 255, 254, 242, 178, 255, 254, 243, 179, 255, 254, 243, 179, 255, 254, 243, 179, 255, 254, 243, 179, 255, 254, 243, 180, 255, 254, 243, 180, 255, 254, 243, 180, 255, 254, 243, 180, 255, 254, 244, 181, 255, 254, 244, 181, 255, 254, 244, 181, 255, 254, 244, 182, 255, 254, 244, 182, 255, 254, 244, 182, 255, 254, 244, 182, 255, 254, 244, 183, 255, 254, 244, 183, 255, 254, 245, 183, 255, 254, 245, 183, 255, 254, 245, 184, 255, 254, 245, 184, 255, 254, 245, 184, 255, 254, 245, 185, 255, 254, 245, 185, 255, 254, 245, 185, 255, 254, 246, 185, 255, 254, 246, 186, 255, 254, 246, 186, 255, 254, 246, 186, 255, 254, 246, 186, 255, 254, 246, 187, 255, 254, 246, 187, 255, 254, 246, 187, 255, 254, 247, 187, 255, 254, 247, 188, 255, 254, 247, 188, 255, 254, 247, 188, 255, 254, 247, 189, 255, 254, 247, 189, 255, 254, 247, 189, 255, 254, 247, 189, 255, 254, 247, 190, 255, 254, 247, 190, 255, 254, 247, 190, 255, 254, 247, 190, 255, 254, 247, 191, 255, 254, 247, 191, 255, 254, 247, 191, 255, 254, 247, 191, 255, 254, 247, 192, 255, 254, 247, 192, 255, 254, 248, 192, 255, 254, 248, 192, 255, 254, 248, 193, 255, 254, 248, 193, 255, 254, 248, 193, 255, 254, 248, 193, 255, 254, 248, 194, 255, 254, 248, 194, 255, 254, 248, 194, 255, 254, 248, 195, 255, 254, 248, 195, 255, 254, 248, 195, 255, 254, 248, 195, 255, 254, 248, 196, 255, 254, 248, 196, 255, 254, 248, 196, 255, 254, 248, 196, 255, 254, 248, 197, 255, 254, 248, 197, 255, 254, 249, 197, 255, 254, 249, 197, 255, 254, 249, 198, 255, 254, 249, 198, 255, 254, 249, 198, 255, 254, 249, 198, 255, 254, 249, 199, 255, 254, 249, 199, 255, 254, 249, 199, 255, 254, 249, 199, 255, 254, 249, 200, 255, 254, 249, 200, 255, 254, 249, 200, 255, 254, 249, 200, 255, 254, 249, 201, 255, 254, 249, 201, 255, 254, 249, 201, 255, 254, 249, 201, 255, 254, 249, 202, 255, 254, 250, 202, 255, 254, 250, 202, 255, 254, 250, 203, 255, 254, 250, 203, 255, 254, 250, 203, 255, 254, 250, 203, 255, 254, 250, 204, 255, 254, 250, 204, 255, 254, 252, 212, 255, 254, 252, 213, 255, 254, 252, 213, 255, 254, 252, 213, 255, 254, 252, 213, 255, 254, 252, 214, 255, 254, 252, 214, 255, 254, 252, 214, 255, 254, 252, 214, 255, 254, 252, 215, 255, 254, 252, 215, 255, 254, 252, 215, 255, 254, 252, 215, 255, 254, 252, 216, 255, 254, 252, 216, 255, 254, 252, 216, 255, 254, 252, 216, 255, 254, 252, 217, 255, 254, 252, 217, 255, 254, 252, 217, 255, 254, 253, 217, 255, 254, 253, 218, 255, 254, 253, 218, 255, 254, 253, 218, 255, 254, 253, 218, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlOrBr_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 101, 37, 5, 0, 105, 37, 6, 24, 108, 38, 6, 49, 111, 39, 6, 74, 114, 40, 6, 99, 117, 41, 6, 124, 120, 42, 6, 149, 133, 46, 5, 174, 136, 47, 5, 199, 139, 48, 5, 224, 142, 48, 4, 249, 145, 49, 4, 255, 148, 50, 4, 255, 151, 51, 4, 255, 154, 52, 4, 255, 156, 53, 3, 255, 159, 55, 3, 255, 162, 56, 3, 255, 165, 57, 3, 255, 167, 58, 3, 255, 170, 60, 3, 255, 173, 61, 3, 255, 185, 67, 3, 255, 188, 68, 3, 255, 191, 69, 2, 255, 193, 71, 2, 255, 196, 72, 2, 255, 198, 73, 2, 255, 201, 74, 2, 255, 203, 75, 2, 255, 205, 77, 2, 255, 207, 79, 3, 255, 208, 81, 4, 255, 210, 82, 4, 255, 211, 84, 5, 255, 213, 86, 6, 255, 214, 87, 7, 255, 215, 89, 8, 255, 223, 98, 12, 255, 225, 99, 13, 255, 226, 101, 14, 255, 227, 102, 15, 255, 229, 104, 16, 255, 230, 105, 16, 255, 232, 107, 17, 255, 233, 109, 18, 255, 234, 110, 19, 255, 235, 111, 19, 255, 236, 113, 20, 255, 237, 115, 21, 255, 238, 117, 22, 255, 239, 118, 22, 255, 239, 120, 23, 255, 240, 121, 24, 255, 241, 123, 25, 255, 241, 125, 25, 255, 242, 126, 26, 255, 243, 128, 27, 255, 247, 137, 32, 255, 248, 139, 33, 255, 248, 140, 34, 255, 249, 142, 34, 255, 250, 143, 35, 255, 250, 145, 36, 255, 251, 146, 37, 255, 251, 148, 38, 255, 252, 149, 38, 255, 253, 150, 39, 255, 253, 152, 40, 255, 254, 153, 41, 255, 254, 155, 42, 255, 254, 156, 43, 255, 254, 158, 44, 255, 254, 159, 45, 255, 254, 160, 46, 255, 254, 162, 47, 255, 254, 163, 48, 255, 254, 165, 50, 255, 254, 166, 51, 255, 254, 167, 52, 255, 254, 169, 53, 255, 254, 170, 54, 255, 254, 180, 63, 255, 254, 181, 64, 255, 254, 182, 65, 255, 254, 183, 66, 255, 254, 185, 67, 255, 254, 186, 69, 255, 254, 187, 70, 255, 254, 188, 71, 255, 254, 189, 72, 255, 254, 190, 73, 255, 254, 192, 74, 255, 254, 193, 75, 255, 253, 194, 77, 255, 253, 195, 78, 255, 253, 196, 79, 255, 253, 197, 81, 255, 253, 197, 83, 255, 253, 198, 84, 255, 253, 199, 86, 255, 253, 200, 88, 255, 253, 201, 89, 255, 253, 201, 91, 255, 253, 202, 92, 255, 253, 203, 94, 255, 253, 204, 95, 255, 253, 204, 97, 255, 253, 205, 99, 255, 253, 206, 100, 255, 253, 207, 101, 255, 253, 207, 103, 255, 253, 208, 104, 255, 253, 215, 119, 255, 253, 216, 120, 255, 253, 216, 122, 255, 253, 217, 123, 255, 253, 218, 125, 255, 253, 218, 126, 255, 253, 219, 127, 255, 253, 219, 129, 255, 253, 220, 130, 255, 253, 221, 131, 255, 253, 221, 133, 255, 253, 222, 134, 255, 253, 222, 135, 255, 253, 223, 137, 255, 253, 224, 138, 255, 253, 224, 139, 255, 253, 225, 140, 255, 253, 225, 141, 255, 253, 226, 143, 255, 253, 226, 144, 255, 253, 227, 145, 255, 253, 227, 146, 255, 253, 227, 146, 255, 253, 228, 147, 255, 253, 228, 148, 255, 253, 229, 149, 255, 253, 229, 149, 255, 253, 229, 150, 255, 253, 230, 151, 255, 253, 230, 151, 255, 253, 230, 152, 255, 253, 231, 153, 255, 253, 231, 153, 255, 253, 231, 154, 255, 253, 232, 155, 255, 253, 232, 155, 255, 253, 232, 156, 255, 253, 232, 157, 255, 253, 233, 157, 255, 253, 233, 158, 255, 253, 233, 159, 255, 253, 234, 159, 255, 253, 234, 160, 255, 253, 234, 160, 255, 253, 235, 161, 255, 254, 239, 170, 255, 254, 239, 171, 255, 254, 239, 171, 255, 254, 240, 172, 255, 254, 240, 173, 255, 254, 240, 173, 255, 254, 240, 174, 255, 254, 241, 174, 255, 254, 241, 175, 255, 254, 241, 175, 255, 254, 241, 176, 255, 254, 242, 176, 255, 254, 242, 177, 255, 254, 242, 178, 255, 254, 242, 178, 255, 254, 243, 179, 255, 254, 243, 179, 255, 254, 243, 180, 255, 254, 243, 180, 255, 254, 243, 181, 255, 254, 244, 181, 255, 254, 244, 182, 255, 254, 244, 182, 255, 254, 244, 182, 255, 254, 245, 183, 255, 254, 245, 183, 255, 254, 245, 184, 255, 254, 245, 184, 255, 254, 245, 185, 255, 254, 246, 185, 255, 254, 246, 186, 255, 254, 246, 186, 255, 254, 246, 187, 255, 254, 246, 187, 255, 254, 246, 187, 255, 254, 247, 188, 255, 254, 247, 188, 255, 254, 247, 189, 255, 254, 247, 189, 255, 254, 247, 189, 255, 254, 247, 190, 255, 254, 247, 190, 255, 254, 247, 190, 255, 254, 247, 191, 255, 254, 247, 191, 255, 254, 247, 192, 255, 254, 247, 192, 255, 254, 248, 192, 255, 254, 248, 193, 255, 254, 248, 193, 255, 254, 248, 193, 255, 254, 248, 194, 255, 254, 248, 194, 255, 254, 248, 194, 255, 254, 248, 195, 255, 254, 248, 195, 255, 254, 248, 195, 255, 254, 248, 196, 255, 254, 248, 196, 255, 254, 248, 196, 255, 254, 248, 196, 255, 254, 248, 197, 255, 254, 249, 197, 255, 254, 249, 197, 255, 254, 249, 198, 255, 254, 249, 198, 255, 254, 249, 198, 255, 254, 249, 198, 255, 254, 249, 199, 255, 254, 249, 199, 255, 254, 249, 199, 255, 254, 249, 200, 255, 254, 249, 200, 255, 254, 249, 200, 255, 254, 249, 200, 255, 254, 249, 201, 255, 254, 249, 201, 255, 254, 249, 201, 255, 254, 249, 201, 255, 254, 249, 202, 255, 254, 249, 202, 255, 254, 250, 202, 255, 254, 250, 202, 255, 254, 250, 203, 255, 254, 250, 203, 255, 254, 250, 203, 255, 254, 250, 203, 255, 254, 250, 203, 255, 254, 250, 204, 255, 254, 250, 204, 255, 254, 252, 212, 255, 254, 252, 212, 255, 254, 252, 213, 255, 254, 252, 213, 255, 254, 252, 213, 255, 254, 252, 213, 255, 254, 252, 213, 255, 254, 252, 214, 255, 254, 252, 214, 255, 254, 252, 214, 255, 254, 252, 214, 255, 254, 252, 214, 255, 254, 252, 215, 255, 254, 252, 215, 255, 254, 252, 215, 255, 254, 252, 215, 255, 254, 252, 215, 255, 254, 252, 216, 255, 254, 252, 216, 255, 254, 252, 216, 255, 254, 252, 216, 255, 254, 252, 216, 255, 254, 252, 216, 255, 254, 252, 217, 255, 254, 252, 217, 255, 254, 252, 217, 255, 254, 252, 217, 255, 254, 252, 217, 255, 254, 252, 217, 255, 254, 253, 217, 255, 254, 253, 218, 255, 254, 253, 218, 255, 254, 253, 218, 255, 254, 253, 218, 255, 254, 253, 218, 255, 254, 253, 218, 255, 254, 253, 218, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 219, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 220, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 221, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 222, 255, 254, 253, 223, 255, 254, 253, 223, 255, 254, 253, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 223, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 224, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 225, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 226, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 227, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 254, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255, 254, 255, 228, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_YlOrBr_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
