/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/RdYlGn.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 0, 104, 55, 255, 26, 152, 80, 255, 102, 189, 99, 255, 166, 217, 106, 255, 217, 239, 139, 255, 254, 224, 139, 255, 253, 174, 97, 255, 244, 109, 67, 255, 215, 48, 39, 255, 165, 0, 38, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdYlGn_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 0, 104, 54, 0, 0, 104, 55, 7, 0, 104, 55, 14, 0, 105, 55, 22, 0, 105, 55, 29, 0, 106, 56, 37, 0, 106, 56, 44, 1, 107, 56, 52, 1, 107, 56, 59, 1, 108, 57, 67, 1, 108, 57, 74, 1, 109, 57, 82, 1, 109, 57, 89, 2, 109, 58, 97, 2, 110, 58, 104, 2, 110, 58, 112, 2, 111, 58, 119, 2, 111, 59, 127, 3, 112, 59, 134, 3, 112, 59, 141, 3, 113, 59, 149, 3, 113, 60, 156, 3, 114, 60, 164, 4, 114, 60, 171, 4, 114, 60, 179, 4, 115, 61, 186, 4, 115, 61, 194, 5, 116, 61, 201, 5, 116, 61, 209, 5, 117, 62, 216, 5, 117, 62, 224, 6, 118, 62, 231, 6, 118, 62, 239, 6, 119, 63, 246, 6, 119, 63, 254, 7, 120, 63, 255, 7, 120, 63, 255, 7, 120, 64, 255, 7, 121, 64, 255, 8, 121, 64, 255, 8, 122, 64, 255, 8, 122, 65, 255, 8, 123, 65, 255, 9, 123, 65, 255, 9, 124, 65, 255, 9, 124, 65, 255, 10, 125, 66, 255, 10, 125, 66, 255, 10, 126, 66, 255, 10, 126, 66, 255, 11, 127, 67, 255, 11, 127, 67, 255, 11, 127, 67, 255, 12, 128, 67, 255, 12, 128, 68, 255, 12, 129, 68, 255, 13, 129, 68, 255, 13, 130, 68, 255, 13, 130, 69, 255, 13, 131, 69, 255, 14, 131, 69, 255, 14, 132, 69, 255, 14, 132, 70, 255, 15, 133, 70, 255, 15, 133, 70, 255, 15, 134, 70, 255, 15, 134, 71, 255, 16, 135, 71, 255, 16, 135, 71, 255, 16, 136, 71, 255, 16, 136, 72, 255, 17, 136, 72, 255, 17, 137, 72, 255, 17, 137, 72, 255, 18, 138, 73, 255, 18, 138, 73, 255, 18, 139, 73, 255, 18, 139, 73, 255, 19, 140, 74, 255, 19, 140, 74, 255, 19, 141, 74, 255, 20, 141, 74, 255, 20, 142, 75, 255, 20, 142, 75, 255, 20, 143, 75, 255, 21, 143, 75, 255, 21, 144, 76, 255, 21, 144, 76, 255, 22, 145, 76, 255, 22, 145, 76, 255, 22, 146, 76, 255, 22, 146, 77, 255, 23, 146, 77, 255, 23, 147, 77, 255, 23, 147, 77, 255, 23, 148, 78, 255, 24, 148, 78, 255, 24, 149, 78, 255, 24, 149, 78, 255, 25, 150, 79, 255, 25, 150, 79, 255, 25, 151, 79, 255, 25, 151, 79, 255, 26, 152, 80, 255, 27, 152, 80, 255, 29, 152, 80, 255, 30, 153, 80, 255, 31, 153, 80, 255, 32, 154, 80, 255, 33, 154, 81, 255, 34, 154, 81, 255, 35, 155, 81, 255, 36, 155, 81, 255, 37, 155, 81, 255, 38, 156, 82, 255, 39, 156, 82, 255, 40, 156, 82, 255, 41, 157, 82, 255, 42, 157, 82, 255, 43, 157, 82, 255, 43, 158, 83, 255, 44, 158, 83, 255, 45, 159, 83, 255, 46, 159, 83, 255, 47, 159, 83, 255, 48, 160, 84, 255, 48, 160, 84, 255, 49, 160, 84, 255, 50, 161, 84, 255, 51, 161, 84, 255, 52, 161, 84, 255, 52, 162, 85, 255, 53, 162, 85, 255, 54, 163, 85, 255, 55, 163, 85, 255, 56, 163, 85, 255, 56, 164, 86, 255, 57, 164, 86, 255, 58, 164, 86, 255, 59, 165, 86, 255, 59, 165, 86, 255, 60, 165, 86, 255, 61, 166, 87, 255, 61, 166, 87, 255, 62, 166, 87, 255, 63, 167, 87, 255, 64, 167, 87, 255, 64, 168, 88, 255, 65, 168, 88, 255, 66, 168, 88, 255, 66, 169, 88, 255, 67, 169, 88, 255, 68, 169, 88, 255, 68, 170, 89, 255, 69, 170, 89, 255, 70, 170, 89, 255, 70, 171, 89, 255, 71, 171, 89, 255, 72, 172, 90, 255, 73, 172, 90, 255, 73, 172, 90, 255, 74, 173, 90, 255, 75, 173, 90, 255, 75, 173, 90, 255, 76, 174, 91, 255, 76, 174, 91, 255, 77, 174, 91, 255, 78, 175, 91, 255, 78, 175, 91, 255, 79, 176, 92, 255, 80, 176, 92, 255, 80, 176, 92, 255, 81, 177, 92, 255, 82, 177, 92, 255, 82, 177, 93, 255, 83, 178, 93, 255, 84, 178, 93, 255, 84, 178, 93, 255, 85, 179, 93, 255, 86, 179, 94, 255, 86, 180, 94, 255, 87, 180, 94, 255, 87, 180, 94, 255, 88, 181, 94, 255, 89, 181, 94, 255, 89, 181, 95, 255, 90, 182, 95, 255, 91, 182, 95, 255, 91, 182, 95, 255, 92, 183, 95, 255, 92, 183, 96, 255, 93, 183, 96, 255, 94, 184, 96, 255, 94, 184, 96, 255, 95, 185, 96, 255, 95, 185, 97, 255, 96, 185, 97, 255, 97, 186, 97, 255, 97, 186, 97, 255, 98, 186, 97, 255, 99, 187, 98, 255, 99, 187, 98, 255, 100, 187, 98, 255, 100, 188, 98, 255, 101, 188, 98, 255, 102, 189, 99, 255, 102, 189, 99, 255, 103, 189, 99, 255, 104, 189, 99, 255, 104, 190, 99, 255, 105, 190, 99, 255, 106, 190, 99, 255, 106, 191, 99, 255, 107, 191, 99, 255, 107, 191, 99, 255, 108, 191, 99, 255, 109, 192, 99, 255, 109, 192, 99, 255, 110, 192, 99, 255, 111, 192, 99, 255, 111, 193, 99, 255, 112, 193, 99, 255, 113, 193, 99, 255, 113, 194, 99, 255, 114, 194, 99, 255, 114, 194, 100, 255, 115, 194, 100, 255, 116, 195, 100, 255, 116, 195, 100, 255, 117, 195, 100, 255, 118, 196, 100, 255, 118, 196, 100, 255, 119, 196, 100, 255, 120, 196, 100, 255, 120, 197, 100, 255, 121, 197, 100, 255, 121, 197, 100, 255, 122, 197, 100, 255, 123, 198, 100, 255, 123, 198, 100, 255, 124, 198, 100, 255, 125, 199, 100, 255, 125, 199, 101, 255, 126, 199, 101, 255, 126, 199, 101, 255, 127, 200, 101, 255, 128, 200, 101, 255, 128, 200, 101, 255, 129, 200, 101, 255, 130, 201, 101, 255, 130, 201, 101, 255, 131, 201, 101, 255, 131, 202, 101, 255, 132, 202, 101, 255, 133, 202, 101, 255, 133, 202, 101, 255, 134, 203, 101, 255, 135, 203, 102, 255, 135, 203, 102, 255, 136, 203, 102, 255, 136, 204, 102, 255, 137, 204, 102, 255, 138, 204, 102, 255, 138, 205, 102, 255, 139, 205, 102, 255, 139, 205, 102, 255, 140, 205, 102, 255, 141, 206, 102, 255, 141, 206, 102, 255, 142, 206, 102, 255, 143, 206, 102, 255, 143, 207, 103, 255, 144, 207, 103, 255, 144, 207, 103, 255, 145, 208, 103, 255, 146, 208, 103, 255, 146, 208, 103, 255, 147, 208, 103, 255, 148, 209, 103, 255, 148, 209, 103, 255, 149, 209, 103, 255, 149, 209, 103, 255, 150, 210, 103, 255, 151, 210, 103, 255, 151, 210, 104, 255, 152, 211, 104, 255, 152, 211, 104, 255, 153, 211, 104, 255, 154, 211, 104, 255, 154, 212, 104, 255, 155, 212, 104, 255, 156, 212, 104, 255, 156, 212, 104, 255, 157, 213, 104, 255, 157, 213, 104, 255, 158, 213, 104, 255, 159, 214, 105, 255, 159, 214, 105, 255, 160, 214, 105, 255, 160, 214, 105, 255, 161, 215, 105, 255, 162, 215, 105, 255, 162, 215, 105, 255, 163, 215, 105, 255, 164, 216, 105, 255, 164, 216, 105, 255, 165, 216, 105, 255, 165, 216, 105, 255, 166, 217, 106, 255, 166, 217, 106, 255, 167, 217, 106, 255, 168, 217, 107, 255, 168, 218, 107, 255, 169, 218, 107, 255, 169, 218, 108, 255, 170, 218, 108, 255, 170, 218, 108, 255, 171, 219, 108, 255, 171, 219, 109, 255, 172, 219, 109, 255, 172, 219, 109, 255, 173, 219, 110, 255, 173, 220, 110, 255, 174, 220, 110, 255, 174, 220, 111, 255, 175, 220, 111, 255, 175, 221, 111, 255, 176, 221, 111, 255, 176, 221, 112, 255, 177, 221, 112, 255, 177, 221, 112, 255, 178, 222, 113, 255, 178, 222, 113, 255, 179, 222, 113, 255, 179, 222, 114, 255, 180, 222, 114, 255, 180, 223, 114, 255, 181, 223, 115, 255, 182, 223, 115, 255, 182, 223, 115, 255, 183, 223, 115, 255, 183, 224, 116, 255, 184, 224, 116, 255, 184, 224, 116, 255, 185, 224, 117, 255, 185, 225, 117, 255, 186, 225, 117, 255, 186, 225, 118, 255, 187, 225, 118, 255, 187, 225, 118, 255, 188, 226, 119, 255, 188, 226, 119, 255, 189, 226, 119, 255, 189, 226, 120, 255, 190, 226, 120, 255, 190, 227, 120, 255, 191, 227, 121, 255, 191, 227, 121, 255, 192, 227, 121, 255, 192, 228, 121, 255, 193, 228, 122, 255, 193, 228, 122, 255, 194, 228, 122, 255, 194, 228, 123, 255, 195, 229, 123, 255, 195, 229, 123, 255, 196, 229, 124, 255, 196, 229, 124, 255, 197, 229, 124, 255, 197, 230, 125, 255, 198, 230, 125, 255, 198, 230, 125, 255, 198, 230, 126, 255, 199, 231, 126, 255, 199, 231, 126, 255, 200, 231, 127, 255, 200, 231, 127, 255, 201, 231, 127, 255, 201, 232, 128, 255, 202, 232, 128, 255, 202, 232, 128, 255, 203, 232, 129, 255, 203, 233, 129, 255, 204, 233, 129, 255, 204, 233, 130, 255, 205, 233, 130, 255, 205, 233, 130, 255, 206, 234, 131, 255, 206, 234, 131, 255, 207, 234, 131, 255, 207, 234, 132, 255, 208, 234, 132, 255, 208, 235, 132, 255, 209, 235, 133, 255, 209, 235, 133, 255, 210, 235, 133, 255, 210, 236, 134, 255, 211, 236, 134, 255, 211, 236, 134, 255, 211, 236, 135, 255, 212, 236, 135, 255, 212, 237, 136, 255, 213, 237, 136, 255, 213, 237, 136, 255, 214, 237, 137, 255, 214, 237, 137, 255, 215, 238, 137, 255, 215, 238, 138, 255, 216, 238, 138, 255, 216, 238, 138, 255, 217, 238, 138, 255, 217, 238, 138, 255, 217, 238, 138, 255, 217, 238, 138, 255, 217, 238, 138, 255, 218, 238, 138, 255, 218, 238, 138, 255, 218, 238, 138, 255, 218, 238, 138, 255, 219, 238, 138, 255, 219, 238, 138, 255, 219, 238, 138, 255, 219, 238, 138, 255, 219, 238, 138, 255, 220, 237, 138, 255, 220, 237, 138, 255, 220, 237, 138, 255, 220, 237, 138, 255, 220, 237, 138, 255, 221, 237, 138, 255, 221, 237, 138, 255, 221, 237, 137, 255, 221, 237, 137, 255, 221, 237, 137, 255, 222, 237, 137, 255, 222, 237, 137, 255, 222, 237, 137, 255, 222, 237, 137, 255, 223, 236, 137, 255, 223, 236, 137, 255, 223, 236, 137, 255, 223, 236, 137, 255, 223, 236, 137, 255, 224, 236, 137, 255, 224, 236, 137, 255, 224, 236, 137, 255, 224, 236, 137, 255, 224, 236, 137, 255, 225, 236, 137, 255, 225, 236, 137, 255, 225, 236, 137, 255, 225, 235, 137, 255, 225, 235, 137, 255, 226, 235, 137, 255, 226, 235, 137, 255, 226, 235, 137, 255, 226, 235, 137, 255, 226, 235, 137, 255, 227, 235, 137, 255, 227, 235, 137, 255, 227, 235, 137, 255, 227, 235, 137, 255, 227, 235, 136, 255, 228, 235, 136, 255, 228, 235, 136, 255, 228, 234, 136, 255, 228, 234, 136, 255, 228, 234, 136, 255, 229, 234, 136, 255, 229, 234, 136, 255, 229, 234, 136, 255, 229, 234, 136, 255, 229, 234, 136, 255, 230, 234, 136, 255, 230, 234, 136, 255, 230, 234, 136, 255, 230, 234, 136, 255, 230, 234, 136, 255, 231, 234, 136, 255, 231, 233, 136, 255, 231, 233, 136, 255, 231, 233, 136, 255, 231, 233, 136, 255, 231, 233, 136, 255, 232, 233, 136, 255, 232, 233, 136, 255, 232, 233, 136, 255, 232, 233, 136, 255, 232, 233, 136, 255, 233, 233, 136, 255, 233, 233, 136, 255, 233, 233, 136, 255, 233, 232, 136, 255, 233, 232, 136, 255, 234, 232, 136, 255, 234, 232, 136, 255, 234, 232, 136, 255, 234, 232, 136, 255, 234, 232, 136, 255, 235, 232, 136, 255, 235, 232, 136, 255, 235, 232, 136, 255, 235, 232, 136, 255, 235, 232, 136, 255, 235, 232, 136, 255, 236, 232, 136, 255, 236, 231, 136, 255, 236, 231, 136, 255, 236, 231, 136, 255, 236, 231, 136, 255, 237, 231, 136, 255, 237, 231, 136, 255, 237, 231, 136, 255, 237, 231, 136, 255, 237, 231, 136, 255, 237, 231, 136, 255, 238, 231, 136, 255, 238, 231, 136, 255, 238, 231, 136, 255, 238, 230, 136, 255, 238, 230, 136, 255, 238, 230, 136, 255, 239, 230, 136, 255, 239, 230, 136, 255, 239, 230, 136, 255, 239, 230, 136, 255, 239, 230, 136, 255, 240, 230, 136, 255, 240, 230, 136, 255, 240, 230, 136, 255, 240, 230, 136, 255, 240, 230, 136, 255, 240, 230, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 242, 229, 136, 255, 242, 229, 136, 255, 242, 229, 136, 255, 242, 229, 136, 255, 242, 229, 136, 255, 242, 229, 136, 255, 243, 229, 136, 255, 243, 228, 136, 255, 243, 228, 136, 255, 243, 228, 136, 255, 243, 228, 136, 255, 243, 228, 136, 255, 244, 228, 136, 255, 244, 228, 136, 255, 244, 228, 136, 255, 244, 228, 136, 255, 244, 228, 136, 255, 244, 228, 136, 255, 245, 228, 136, 255, 245, 228, 136, 255, 245, 228, 137, 255, 245, 227, 137, 255, 245, 227, 137, 255, 245, 227, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 247, 227, 137, 255, 247, 227, 137, 255, 247, 227, 137, 255, 247, 227, 137, 255, 247, 227, 137, 255, 247, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 249, 226, 137, 255, 249, 226, 137, 255, 249, 226, 137, 255, 249, 226, 137, 255, 249, 226, 137, 255, 249, 225, 137, 255, 250, 225, 137, 255, 250, 225, 137, 255, 250, 225, 137, 255, 250, 225, 137, 255, 250, 225, 138, 255, 250, 225, 138, 255, 250, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 223, 138, 255, 253, 223, 138, 255, 253, 222, 137, 255, 253, 222, 137, 255, 253, 221, 136, 255, 253, 221, 136, 255, 253, 220, 135, 255, 253, 220, 135, 255, 253, 219, 134, 255, 253, 219, 134, 255, 253, 219, 133, 255, 253, 218, 133, 255, 253, 218, 132, 255, 253, 217, 132, 255, 253, 217, 131, 255, 253, 216, 131, 255, 253, 216, 130, 255, 253, 215, 130, 255, 253, 215, 129, 255, 253, 214, 129, 255, 253, 214, 128, 255, 253, 213, 128, 255, 253, 213, 127, 255, 253, 212, 127, 255, 253, 212, 126, 255, 253, 211, 126, 255, 253, 211, 126, 255, 253, 210, 125, 255, 253, 210, 125, 255, 253, 210, 124, 255, 253, 209, 124, 255, 253, 209, 123, 255, 253, 208, 123, 255, 253, 208, 122, 255, 253, 207, 122, 255, 253, 207, 121, 255, 253, 206, 121, 255, 253, 206, 121, 255, 253, 205, 120, 255, 253, 205, 120, 255, 253, 204, 119, 255, 253, 204, 119, 255, 253, 203, 118, 255, 253, 203, 118, 255, 253, 202, 117, 255, 253, 202, 117, 255, 253, 201, 117, 255, 253, 201, 116, 255, 253, 200, 116, 255, 253, 200, 115, 255, 253, 199, 115, 255, 253, 199, 115, 255, 253, 198, 114, 255, 253, 198, 114, 255, 253, 197, 113, 255, 253, 197, 113, 255, 253, 196, 113, 255, 253, 196, 112, 255, 253, 195, 112, 255, 253, 195, 111, 255, 253, 194, 111, 255, 253, 194, 111, 255, 253, 194, 110, 255, 253, 193, 110, 255, 253, 193, 109, 255, 253, 192, 109, 255, 253, 192, 109, 255, 253, 191, 108, 255, 253, 191, 108, 255, 253, 190, 107, 255, 253, 190, 107, 255, 253, 189, 107, 255, 253, 189, 106, 255, 253, 188, 106, 255, 253, 188, 106, 255, 253, 187, 105, 255, 253, 187, 105, 255, 253, 186, 105, 255, 253, 186, 104, 255, 253, 185, 104, 255, 253, 185, 104, 255, 253, 184, 103, 255, 253, 184, 103, 255, 253, 183, 102, 255, 253, 183, 102, 255, 253, 182, 102, 255, 253, 182, 101, 255, 253, 181, 101, 255, 253, 181, 101, 255, 253, 180, 100, 255, 253, 180, 100, 255, 253, 179, 100, 255, 253, 179, 100, 255, 253, 178, 99, 255, 253, 177, 99, 255, 253, 177, 99, 255, 253, 176, 98, 255, 253, 176, 98, 255, 253, 175, 98, 255, 253, 175, 97, 255, 253, 174, 97, 255, 253, 174, 97, 255, 252, 173, 96, 255, 252, 173, 96, 255, 252, 172, 96, 255, 252, 172, 95, 255, 252, 171, 95, 255, 252, 170, 94, 255, 252, 170, 94, 255, 252, 169, 93, 255, 252, 169, 93, 255, 252, 168, 93, 255, 252, 167, 92, 255, 252, 167, 92, 255, 252, 166, 91, 255, 252, 166, 91, 255, 251, 165, 90, 255, 251, 165, 90, 255, 251, 164, 90, 255, 251, 163, 89, 255, 251, 163, 89, 255, 251, 162, 89, 255, 251, 162, 88, 255, 251, 161, 88, 255, 251, 160, 87, 255, 251, 160, 87, 255, 251, 159, 87, 255, 251, 159, 86, 255, 251, 158, 86, 255, 251, 157, 85, 255, 250, 157, 85, 255, 250, 156, 85, 255, 250, 155, 84, 255, 250, 155, 84, 255, 250, 154, 84, 255, 250, 154, 83, 255, 250, 153, 83, 255, 250, 152, 83, 255, 250, 152, 82, 255, 250, 151, 82, 255, 250, 151, 82, 255, 250, 150, 81, 255, 250, 149, 81, 255, 249, 149, 81, 255, 249, 148, 80, 255, 249, 147, 80, 255, 249, 147, 80, 255, 249, 146, 79, 255, 249, 146, 79, 255, 249, 145, 79, 255, 249, 144, 78, 255, 249, 144, 78, 255, 249, 143, 78, 255, 249, 142, 78, 255, 249, 142, 77, 255, 248, 141, 77, 255, 248, 141, 77, 255, 248, 140, 76, 255, 248, 139, 76, 255, 248, 139, 76, 255, 248, 138, 76, 255, 248, 137, 75, 255, 248, 137, 75, 255, 248, 136, 75, 255, 248, 135, 74, 255, 248, 135, 74, 255, 247, 134, 74, 255, 247, 134, 74, 255, 247, 133, 73, 255, 247, 132, 73, 255, 247, 132, 73, 255, 247, 131, 73, 255, 247, 130, 72, 255, 247, 130, 72, 255, 247, 129, 72, 255, 247, 128, 72, 255, 247, 128, 72, 255, 246, 127, 71, 255, 246, 126, 71, 255, 246, 126, 71, 255, 246, 125, 71, 255, 246, 124, 70, 255, 246, 124, 70, 255, 246, 123, 70, 255, 246, 122, 70, 255, 246, 122, 70, 255, 246, 121, 69, 255, 245, 120, 69, 255, 245, 120, 69, 255, 245, 119, 69, 255, 245, 118, 69, 255, 245, 118, 69, 255, 245, 117, 68, 255, 245, 116, 68, 255, 245, 116, 68, 255, 245, 115, 68, 255, 244, 114, 68, 255, 244, 114, 68, 255, 244, 113, 67, 255, 244, 112, 67, 255, 244, 111, 67, 255, 244, 111, 67, 255, 244, 110, 67, 255, 244, 109, 67, 255, 244, 109, 67, 255, 243, 108, 66, 255, 243, 108, 66, 255, 243, 107, 66, 255, 242, 107, 65, 255, 242, 106, 65, 255, 242, 105, 65, 255, 242, 105, 64, 255, 241, 104, 64, 255, 241, 104, 64, 255, 241, 103, 63, 255, 241, 103, 63, 255, 240, 102, 63, 255, 240, 102, 63, 255, 240, 101, 62, 255, 239, 101, 62, 255, 239, 100, 62, 255, 239, 100, 61, 255, 239, 99, 61, 255, 238, 99, 61, 255, 238, 98, 60, 255, 238, 98, 60, 255, 237, 97, 60, 255, 237, 96, 60, 255, 237, 96, 59, 255, 237, 95, 59, 255, 236, 95, 59, 255, 236, 94, 58, 255, 236, 94, 58, 255, 236, 93, 58, 255, 235, 93, 57, 255, 235, 92, 57, 255, 235, 92, 57, 255, 234, 91, 57, 255, 234, 91, 56, 255, 234, 90, 56, 255, 234, 89, 56, 255, 233, 89, 55, 255, 233, 88, 55, 255, 233, 88, 55, 255, 232, 87, 55, 255, 232, 87, 54, 255, 232, 86, 54, 255, 232, 86, 54, 255, 231, 85, 54, 255, 231, 84, 53, 255, 231, 84, 53, 255, 230, 83, 53, 255, 230, 83, 52, 255, 230, 82, 52, 255, 230, 82, 52, 255, 229, 81, 52, 255, 229, 80, 51, 255, 229, 80, 51, 255, 228, 79, 51, 255, 228, 79, 50, 255, 228, 78, 50, 255, 228, 78, 50, 255, 227, 77, 50, 255, 227, 76, 49, 255, 227, 76, 49, 255, 226, 75, 49, 255, 226, 75, 49, 255, 226, 74, 48, 255, 226, 73, 48, 255, 225, 73, 48, 255, 225, 72, 48, 255, 225, 72, 47, 255, 225, 71, 47, 255, 224, 70, 47, 255, 224, 70, 46, 255, 224, 69, 46, 255, 223, 68, 46, 255, 223, 68, 46, 255, 223, 67, 45, 255, 222, 67, 45, 255, 222, 66, 45, 255, 222, 65, 45, 255, 222, 65, 44, 255, 221, 64, 44, 255, 221, 63, 44, 255, 221, 63, 44, 255, 220, 62, 43, 255, 220, 61, 43, 255, 220, 61, 43, 255, 220, 60, 43, 255, 219, 59, 42, 255, 219, 59, 42, 255, 219, 58, 42, 255, 218, 57, 42, 255, 218, 57, 41, 255, 218, 56, 41, 255, 218, 55, 41, 255, 217, 55, 41, 255, 217, 54, 41, 255, 217, 53, 40, 255, 216, 52, 40, 255, 216, 52, 40, 255, 216, 51, 40, 255, 216, 50, 39, 255, 215, 49, 39, 255, 215, 49, 39, 255, 215, 48, 39, 255, 214, 47, 39, 255, 214, 47, 39, 255, 213, 47, 39, 255, 213, 46, 39, 255, 212, 46, 39, 255, 212, 45, 39, 255, 211, 45, 39, 255, 211, 45, 39, 255, 210, 44, 39, 255, 210, 44, 39, 255, 210, 43, 39, 255, 209, 43, 39, 255, 209, 43, 39, 255, 208, 42, 39, 255, 208, 42, 39, 255, 207, 41, 39, 255, 207, 41, 39, 255, 206, 41, 39, 255, 206, 40, 39, 255, 205, 40, 39, 255, 205, 39, 39, 255, 204, 39, 39, 255, 204, 39, 39, 255, 203, 38, 39, 255, 203, 38, 39, 255, 202, 37, 39, 255, 202, 37, 39, 255, 201, 37, 39, 255, 201, 36, 39, 255, 200, 36, 39, 255, 200, 35, 39, 255, 199, 35, 39, 255, 199, 34, 39, 255, 198, 34, 39, 255, 198, 34, 39, 255, 197, 33, 39, 255, 197, 33, 39, 255, 196, 32, 39, 255, 196, 32, 39, 255, 196, 32, 39, 255, 195, 31, 39, 255, 195, 31, 39, 255, 194, 30, 39, 255, 194, 30, 39, 255, 193, 29, 39, 255, 193, 29, 39, 255, 192, 29, 39, 255, 192, 28, 39, 255, 191, 28, 39, 255, 191, 27, 39, 255, 190, 27, 39, 255, 190, 26, 39, 255, 189, 26, 39, 255, 189, 26, 39, 255, 188, 25, 39, 255, 188, 25, 39, 255, 187, 24, 39, 255, 187, 24, 39, 255, 186, 23, 39, 255, 186, 23, 39, 255, 185, 22, 39, 255, 185, 22, 39, 255, 184, 21, 39, 255, 184, 21, 39, 255, 183, 21, 39, 255, 183, 20, 39, 255, 182, 20, 39, 255, 182, 19, 39, 255, 181, 19, 39, 255, 181, 18, 39, 255, 180, 18, 39, 255, 180, 17, 39, 255, 179, 17, 39, 255, 179, 16, 39, 255, 178, 16, 39, 255, 178, 15, 39, 255, 177, 14, 38, 255, 177, 14, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 175, 12, 38, 255, 175, 12, 38, 255, 174, 11, 38, 255, 174, 10, 38, 255, 173, 10, 38, 255, 173, 9, 38, 255, 172, 9, 38, 255, 172, 8, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 169, 5, 38, 255, 169, 4, 38, 255, 168, 4, 38, 255, 168, 3, 38, 255, 167, 3, 38, 255, 167, 2, 38, 255, 166, 2, 38, 255, 166, 1, 38, 255, 165, 1, 38, 255, 165, 0, 38, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdYlGn_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 0, 104, 54, 0, 0, 104, 55, 7, 0, 104, 55, 14, 0, 105, 55, 22, 0, 105, 55, 29, 0, 105, 55, 37, 0, 106, 56, 44, 0, 106, 56, 52, 1, 106, 56, 59, 1, 107, 56, 67, 1, 107, 56, 74, 1, 108, 57, 82, 1, 108, 57, 89, 1, 108, 57, 97, 1, 109, 57, 104, 2, 109, 57, 112, 2, 109, 58, 119, 2, 110, 58, 127, 2, 110, 58, 134, 2, 110, 58, 141, 2, 111, 58, 149, 3, 111, 59, 156, 3, 112, 59, 164, 3, 112, 59, 171, 3, 112, 59, 179, 3, 113, 59, 186, 3, 113, 60, 194, 4, 113, 60, 201, 4, 114, 60, 209, 4, 114, 60, 216, 4, 114, 60, 224, 4, 115, 61, 231, 5, 115, 61, 239, 5, 116, 61, 246, 5, 116, 61, 254, 5, 116, 61, 255, 5, 117, 62, 255, 6, 117, 62, 255, 6, 117, 62, 255, 6, 118, 62, 255, 6, 118, 62, 255, 6, 119, 63, 255, 7, 119, 63, 255, 7, 119, 63, 255, 7, 120, 63, 255, 7, 120, 63, 255, 8, 120, 63, 255, 8, 121, 64, 255, 8, 121, 64, 255, 8, 122, 64, 255, 9, 122, 64, 255, 9, 122, 64, 255, 14, 132, 70, 255, 14, 133, 70, 255, 15, 133, 70, 255, 15, 133, 70, 255, 15, 134, 70, 255, 15, 134, 71, 255, 16, 135, 71, 255, 16, 135, 71, 255, 16, 135, 71, 255, 16, 136, 71, 255, 16, 136, 72, 255, 17, 136, 72, 255, 17, 137, 72, 255, 17, 137, 72, 255, 17, 138, 72, 255, 18, 138, 73, 255, 18, 138, 73, 255, 18, 139, 73, 255, 18, 139, 73, 255, 19, 139, 73, 255, 19, 140, 74, 255, 19, 140, 74, 255, 19, 141, 74, 255, 19, 141, 74, 255, 20, 141, 74, 255, 20, 142, 75, 255, 20, 142, 75, 255, 20, 143, 75, 255, 21, 143, 75, 255, 21, 143, 75, 255, 21, 144, 76, 255, 21, 144, 76, 255, 21, 144, 76, 255, 22, 145, 76, 255, 22, 145, 76, 255, 22, 146, 77, 255, 22, 146, 77, 255, 23, 146, 77, 255, 23, 147, 77, 255, 23, 147, 77, 255, 23, 147, 77, 255, 23, 148, 78, 255, 24, 148, 78, 255, 24, 149, 78, 255, 24, 149, 78, 255, 24, 149, 78, 255, 25, 150, 79, 255, 25, 150, 79, 255, 25, 151, 79, 255, 25, 151, 79, 255, 25, 151, 79, 255, 26, 152, 80, 255, 27, 152, 80, 255, 28, 152, 80, 255, 29, 153, 80, 255, 30, 153, 80, 255, 31, 153, 80, 255, 32, 153, 80, 255, 32, 154, 81, 255, 33, 154, 81, 255, 34, 154, 81, 255, 35, 155, 81, 255, 35, 155, 81, 255, 36, 155, 81, 255, 37, 155, 81, 255, 38, 156, 82, 255, 38, 156, 82, 255, 39, 156, 82, 255, 40, 157, 82, 255, 41, 157, 82, 255, 41, 157, 82, 255, 42, 157, 82, 255, 43, 158, 83, 255, 43, 158, 83, 255, 44, 158, 83, 255, 45, 159, 83, 255, 45, 159, 83, 255, 46, 159, 83, 255, 46, 159, 83, 255, 47, 160, 84, 255, 48, 160, 84, 255, 48, 160, 84, 255, 49, 161, 84, 255, 50, 161, 84, 255, 50, 161, 84, 255, 51, 161, 84, 255, 51, 162, 85, 255, 52, 162, 85, 255, 53, 162, 85, 255, 53, 163, 85, 255, 54, 163, 85, 255, 54, 163, 85, 255, 55, 163, 85, 255, 55, 164, 86, 255, 56, 164, 86, 255, 57, 164, 86, 255, 57, 165, 86, 255, 58, 165, 86, 255, 58, 165, 86, 255, 59, 166, 87, 255, 59, 166, 87, 255, 60, 166, 87, 255, 76, 174, 91, 255, 76, 174, 91, 255, 77, 174, 91, 255, 77, 175, 91, 255, 78, 175, 91, 255, 78, 175, 92, 255, 79, 176, 92, 255, 79, 176, 92, 255, 80, 176, 92, 255, 80, 176, 92, 255, 81, 177, 92, 255, 81, 177, 92, 255, 82, 177, 93, 255, 83, 178, 93, 255, 83, 178, 93, 255, 84, 178, 93, 255, 84, 178, 93, 255, 85, 179, 93, 255, 85, 179, 93, 255, 86, 179, 94, 255, 86, 180, 94, 255, 87, 180, 94, 255, 87, 180, 94, 255, 88, 180, 94, 255, 88, 181, 94, 255, 89, 181, 95, 255, 89, 181, 95, 255, 90, 182, 95, 255, 90, 182, 95, 255, 91, 182, 95, 255, 91, 182, 95, 255, 92, 183, 95, 255, 92, 183, 96, 255, 93, 183, 96, 255, 93, 184, 96, 255, 94, 184, 96, 255, 94, 184, 96, 255, 95, 184, 96, 255, 95, 185, 97, 255, 96, 185, 97, 255, 96, 185, 97, 255, 97, 186, 97, 255, 97, 186, 97, 255, 98, 186, 97, 255, 98, 187, 97, 255, 99, 187, 98, 255, 99, 187, 98, 255, 100, 187, 98, 255, 100, 188, 98, 255, 101, 188, 98, 255, 101, 188, 98, 255, 102, 189, 99, 255, 102, 189, 99, 255, 103, 189, 99, 255, 103, 189, 99, 255, 104, 189, 99, 255, 104, 190, 99, 255, 105, 190, 99, 255, 105, 190, 99, 255, 106, 190, 99, 255, 106, 191, 99, 255, 107, 191, 99, 255, 107, 191, 99, 255, 108, 191, 99, 255, 108, 191, 99, 255, 109, 192, 99, 255, 109, 192, 99, 255, 110, 192, 99, 255, 110, 192, 99, 255, 111, 193, 99, 255, 111, 193, 99, 255, 112, 193, 99, 255, 112, 193, 99, 255, 113, 193, 99, 255, 113, 194, 99, 255, 114, 194, 100, 255, 114, 194, 100, 255, 115, 194, 100, 255, 115, 195, 100, 255, 116, 195, 100, 255, 116, 195, 100, 255, 117, 195, 100, 255, 117, 195, 100, 255, 118, 196, 100, 255, 118, 196, 100, 255, 119, 196, 100, 255, 119, 196, 100, 255, 120, 197, 100, 255, 120, 197, 100, 255, 121, 197, 100, 255, 121, 197, 100, 255, 122, 197, 100, 255, 122, 198, 100, 255, 123, 198, 100, 255, 123, 198, 100, 255, 124, 198, 100, 255, 124, 199, 101, 255, 125, 199, 101, 255, 125, 199, 101, 255, 126, 199, 101, 255, 126, 199, 101, 255, 127, 200, 101, 255, 140, 205, 102, 255, 141, 206, 102, 255, 141, 206, 102, 255, 142, 206, 102, 255, 142, 206, 102, 255, 143, 207, 103, 255, 143, 207, 103, 255, 144, 207, 103, 255, 144, 207, 103, 255, 145, 207, 103, 255, 145, 208, 103, 255, 146, 208, 103, 255, 146, 208, 103, 255, 147, 208, 103, 255, 147, 208, 103, 255, 148, 209, 103, 255, 148, 209, 103, 255, 149, 209, 103, 255, 149, 209, 103, 255, 150, 210, 103, 255, 150, 210, 103, 255, 151, 210, 103, 255, 151, 210, 104, 255, 152, 210, 104, 255, 152, 211, 104, 255, 153, 211, 104, 255, 153, 211, 104, 255, 154, 211, 104, 255, 154, 212, 104, 255, 155, 212, 104, 255, 155, 212, 104, 255, 156, 212, 104, 255, 156, 212, 104, 255, 157, 213, 104, 255, 157, 213, 104, 255, 158, 213, 104, 255, 158, 213, 104, 255, 159, 213, 104, 255, 159, 214, 105, 255, 159, 214, 105, 255, 160, 214, 105, 255, 160, 214, 105, 255, 161, 215, 105, 255, 161, 215, 105, 255, 162, 215, 105, 255, 162, 215, 105, 255, 163, 215, 105, 255, 163, 216, 105, 255, 164, 216, 105, 255, 164, 216, 105, 255, 165, 216, 105, 255, 165, 216, 105, 255, 166, 217, 106, 255, 166, 217, 106, 255, 167, 217, 106, 255, 167, 217, 106, 255, 168, 217, 107, 255, 168, 217, 107, 255, 168, 218, 107, 255, 169, 218, 107, 255, 169, 218, 108, 255, 170, 218, 108, 255, 170, 218, 108, 255, 170, 219, 108, 255, 171, 219, 109, 255, 171, 219, 109, 255, 172, 219, 109, 255, 172, 219, 109, 255, 173, 219, 110, 255, 173, 220, 110, 255, 173, 220, 110, 255, 174, 220, 110, 255, 174, 220, 110, 255, 175, 220, 111, 255, 175, 220, 111, 255, 175, 221, 111, 255, 176, 221, 111, 255, 176, 221, 112, 255, 177, 221, 112, 255, 177, 221, 112, 255, 177, 221, 112, 255, 178, 222, 113, 255, 178, 222, 113, 255, 179, 222, 113, 255, 179, 222, 113, 255, 180, 222, 114, 255, 180, 222, 114, 255, 180, 223, 114, 255, 181, 223, 114, 255, 181, 223, 115, 255, 182, 223, 115, 255, 182, 223, 115, 255, 182, 223, 115, 255, 183, 224, 116, 255, 183, 224, 116, 255, 184, 224, 116, 255, 184, 224, 116, 255, 184, 224, 117, 255, 185, 224, 117, 255, 185, 225, 117, 255, 186, 225, 118, 255, 186, 225, 118, 255, 186, 225, 118, 255, 197, 230, 125, 255, 197, 230, 125, 255, 198, 230, 125, 255, 198, 230, 126, 255, 199, 230, 126, 255, 199, 231, 126, 255, 199, 231, 126, 255, 200, 231, 127, 255, 200, 231, 127, 255, 201, 231, 127, 255, 201, 231, 127, 255, 201, 232, 128, 255, 202, 232, 128, 255, 202, 232, 128, 255, 202, 232, 129, 255, 203, 232, 129, 255, 203, 233, 129, 255, 204, 233, 129, 255, 204, 233, 130, 255, 204, 233, 130, 255, 205, 233, 130, 255, 205, 233, 130, 255, 206, 234, 131, 255, 206, 234, 131, 255, 206, 234, 131, 255, 207, 234, 131, 255, 207, 234, 132, 255, 208, 234, 132, 255, 208, 235, 132, 255, 208, 235, 133, 255, 209, 235, 133, 255, 209, 235, 133, 255, 209, 235, 133, 255, 210, 235, 134, 255, 210, 236, 134, 255, 211, 236, 134, 255, 211, 236, 134, 255, 211, 236, 135, 255, 212, 236, 135, 255, 212, 236, 135, 255, 212, 237, 136, 255, 213, 237, 136, 255, 213, 237, 136, 255, 214, 237, 136, 255, 214, 237, 137, 255, 214, 238, 137, 255, 215, 238, 137, 255, 215, 238, 137, 255, 216, 238, 138, 255, 216, 238, 138, 255, 216, 238, 138, 255, 217, 238, 138, 255, 217, 238, 138, 255, 217, 238, 138, 255, 217, 238, 138, 255, 217, 238, 138, 255, 217, 238, 138, 255, 218, 238, 138, 255, 218, 238, 138, 255, 218, 238, 138, 255, 218, 238, 138, 255, 218, 238, 138, 255, 218, 238, 138, 255, 219, 238, 138, 255, 219, 238, 138, 255, 219, 238, 138, 255, 219, 238, 138, 255, 219, 238, 138, 255, 219, 237, 138, 255, 220, 237, 138, 255, 220, 237, 138, 255, 220, 237, 138, 255, 220, 237, 138, 255, 220, 237, 138, 255, 220, 237, 138, 255, 221, 237, 138, 255, 221, 237, 138, 255, 221, 237, 138, 255, 221, 237, 138, 255, 221, 237, 137, 255, 221, 237, 137, 255, 222, 237, 137, 255, 222, 237, 137, 255, 222, 237, 137, 255, 222, 237, 137, 255, 222, 237, 137, 255, 222, 236, 137, 255, 223, 236, 137, 255, 223, 236, 137, 255, 223, 236, 137, 255, 223, 236, 137, 255, 223, 236, 137, 255, 223, 236, 137, 255, 224, 236, 137, 255, 224, 236, 137, 255, 224, 236, 137, 255, 224, 236, 137, 255, 224, 236, 137, 255, 224, 236, 137, 255, 225, 236, 137, 255, 225, 236, 137, 255, 225, 236, 137, 255, 225, 236, 137, 255, 225, 235, 137, 255, 225, 235, 137, 255, 226, 235, 137, 255, 226, 235, 137, 255, 226, 235, 137, 255, 226, 235, 137, 255, 226, 235, 137, 255, 226, 235, 137, 255, 226, 235, 137, 255, 227, 235, 137, 255, 227, 235, 137, 255, 227, 235, 137, 255, 227, 235, 137, 255, 227, 235, 137, 255, 227, 235, 137, 255, 228, 235, 137, 255, 228, 235, 137, 255, 228, 234, 137, 255, 228, 234, 137, 255, 228, 234, 137, 255, 228, 234, 137, 255, 228, 234, 137, 255, 229, 234, 137, 255, 229, 234, 137, 255, 229, 234, 137, 255, 229, 234, 137, 255, 229, 234, 137, 255, 229, 234, 137, 255, 230, 234, 137, 255, 230, 234, 136, 255, 230, 234, 136, 255, 230, 234, 136, 255, 230, 234, 136, 255, 230, 234, 136, 255, 230, 233, 136, 255, 231, 233, 136, 255, 231, 233, 136, 255, 231, 233, 136, 255, 231, 233, 136, 255, 231, 233, 136, 255, 231, 233, 136, 255, 231, 233, 136, 255, 232, 233, 136, 255, 232, 233, 136, 255, 232, 233, 136, 255, 232, 233, 136, 255, 232, 233, 136, 255, 232, 233, 136, 255, 233, 233, 136, 255, 233, 233, 136, 255, 240, 230, 136, 255, 240, 229, 136, 255, 240, 229, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 242, 229, 136, 255, 242, 229, 136, 255, 242, 229, 136, 255, 242, 229, 136, 255, 242, 229, 136, 255, 242, 229, 136, 255, 242, 229, 136, 255, 243, 228, 136, 255, 243, 228, 137, 255, 243, 228, 137, 255, 243, 228, 137, 255, 243, 228, 137, 255, 243, 228, 137, 255, 243, 228, 137, 255, 244, 228, 137, 255, 244, 228, 137, 255, 244, 228, 137, 255, 244, 228, 137, 255, 244, 228, 137, 255, 244, 228, 137, 255, 244, 228, 137, 255, 245, 228, 137, 255, 245, 228, 137, 255, 245, 228, 137, 255, 245, 227, 137, 255, 245, 227, 137, 255, 245, 227, 137, 255, 245, 227, 137, 255, 245, 227, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 247, 227, 137, 255, 247, 227, 137, 255, 247, 227, 137, 255, 247, 227, 137, 255, 247, 227, 137, 255, 247, 226, 137, 255, 247, 226, 137, 255, 247, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 248, 226, 137, 255, 249, 226, 137, 255, 249, 226, 137, 255, 249, 226, 137, 255, 249, 226, 137, 255, 249, 226, 137, 255, 249, 226, 137, 255, 249, 225, 137, 255, 249, 225, 137, 255, 250, 225, 137, 255, 250, 225, 137, 255, 250, 225, 137, 255, 250, 225, 138, 255, 250, 225, 138, 255, 250, 225, 138, 255, 250, 225, 138, 255, 250, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 251, 225, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 223, 138, 255, 253, 223, 138, 255, 253, 223, 137, 255, 253, 222, 137, 255, 253, 222, 137, 255, 253, 221, 136, 255, 253, 221, 136, 255, 253, 221, 135, 255, 253, 220, 135, 255, 253, 220, 135, 255, 253, 220, 134, 255, 253, 219, 134, 255, 253, 219, 133, 255, 253, 218, 133, 255, 253, 218, 133, 255, 253, 218, 132, 255, 253, 217, 132, 255, 253, 217, 132, 255, 253, 217, 131, 255, 253, 216, 131, 255, 253, 216, 130, 255, 253, 215, 130, 255, 253, 215, 130, 255, 253, 215, 129, 255, 253, 214, 129, 255, 253, 214, 128, 255, 253, 213, 128, 255, 253, 213, 128, 255, 253, 213, 127, 255, 253, 212, 127, 255, 253, 212, 127, 255, 253, 212, 126, 255, 253, 211, 126, 255, 253, 211, 126, 255, 253, 210, 125, 255, 253, 210, 125, 255, 253, 210, 124, 255, 253, 209, 124, 255, 253, 209, 124, 255, 253, 208, 123, 255, 253, 208, 123, 255, 253, 208, 123, 255, 253, 207, 122, 255, 253, 207, 122, 255, 253, 207, 122, 255, 253, 206, 121, 255, 253, 206, 121, 255, 253, 205, 121, 255, 253, 205, 120, 255, 253, 205, 120, 255, 253, 204, 120, 255, 253, 194, 111, 255, 253, 193, 111, 255, 253, 193, 110, 255, 253, 193, 110, 255, 253, 192, 110, 255, 253, 192, 109, 255, 253, 191, 109, 255, 253, 191, 109, 255, 253, 191, 108, 255, 253, 190, 108, 255, 253, 190, 108, 255, 253, 190, 107, 255, 253, 189, 107, 255, 253, 189, 107, 255, 253, 188, 106, 255, 253, 188, 106, 255, 253, 188, 106, 255, 253, 187, 106, 255, 253, 187, 105, 255, 253, 186, 105, 255, 253, 186, 105, 255, 253, 186, 104, 255, 253, 185, 104, 255, 253, 185, 104, 255, 253, 184, 104, 255, 253, 184, 103, 255, 253, 184, 103, 255, 253, 183, 103, 255, 253, 183, 102, 255, 253, 182, 102, 255, 253, 182, 102, 255, 253, 182, 102, 255, 253, 181, 101, 255, 253, 181, 101, 255, 253, 180, 101, 255, 253, 180, 100, 255, 253, 180, 100, 255, 253, 179, 100, 255, 253, 179, 100, 255, 253, 178, 99, 255, 253, 178, 99, 255, 253, 178, 99, 255, 253, 177, 99, 255, 253, 177, 98, 255, 253, 176, 98, 255, 253, 176, 98, 255, 253, 175, 98, 255, 253, 175, 97, 255, 253, 175, 97, 255, 253, 174, 97, 255, 253, 174, 97, 255, 252, 173, 96, 255, 252, 173, 96, 255, 252, 172, 96, 255, 252, 172, 95, 255, 252, 172, 95, 255, 252, 171, 95, 255, 252, 171, 94, 255, 252, 170, 94, 255, 252, 170, 94, 255, 252, 169, 93, 255, 252, 169, 93, 255, 252, 168, 93, 255, 252, 168, 92, 255, 252, 167, 92, 255, 252, 167, 92, 255, 252, 166, 91, 255, 252, 166, 91, 255, 252, 165, 91, 255, 251, 165, 90, 255, 251, 164, 90, 255, 251, 164, 90, 255, 251, 163, 89, 255, 251, 163, 89, 255, 251, 162, 89, 255, 251, 162, 89, 255, 251, 162, 88, 255, 251, 161, 88, 255, 251, 161, 88, 255, 251, 160, 87, 255, 251, 160, 87, 255, 251, 159, 87, 255, 251, 159, 87, 255, 251, 158, 86, 255, 251, 158, 86, 255, 251, 157, 86, 255, 250, 157, 85, 255, 250, 156, 85, 255, 250, 156, 85, 255, 250, 155, 85, 255, 250, 155, 84, 255, 250, 154, 84, 255, 250, 154, 84, 255, 250, 153, 84, 255, 250, 153, 83, 255, 250, 152, 83, 255, 250, 152, 83, 255, 250, 151, 83, 255, 250, 151, 82, 255, 250, 150, 82, 255, 250, 150, 82, 255, 249, 149, 82, 255, 248, 136, 75, 255, 248, 135, 75, 255, 247, 135, 75, 255, 247, 134, 75, 255, 247, 134, 74, 255, 247, 133, 74, 255, 247, 133, 74, 255, 247, 132, 74, 255, 247, 132, 74, 255, 247, 131, 73, 255, 247, 131, 73, 255, 247, 130, 73, 255, 247, 130, 73, 255, 247, 129, 72, 255, 247, 129, 72, 255, 247, 128, 72, 255, 246, 128, 72, 255, 246, 127, 72, 255, 246, 126, 71, 255, 246, 126, 71, 255, 246, 125, 71, 255, 246, 125, 71, 255, 246, 124, 71, 255, 246, 124, 71, 255, 246, 123, 70, 255, 246, 123, 70, 255, 246, 122, 70, 255, 246, 122, 70, 255, 246, 121, 70, 255, 245, 121, 70, 255, 245, 120, 69, 255, 245, 120, 69, 255, 245, 119, 69, 255, 245, 119, 69, 255, 245, 118, 69, 255, 245, 117, 69, 255, 245, 117, 68, 255, 245, 116, 68, 255, 245, 116, 68, 255, 245, 115, 68, 255, 245, 115, 68, 255, 244, 114, 68, 255, 244, 114, 68, 255, 244, 113, 67, 255, 244, 113, 67, 255, 244, 112, 67, 255, 244, 111, 67, 255, 244, 111, 67, 255, 244, 110, 67, 255, 244, 110, 67, 255, 244, 109, 67, 255, 244, 109, 67, 255, 243, 108, 66, 255, 243, 108, 66, 255, 243, 107, 66, 255, 243, 107, 66, 255, 242, 107, 65, 255, 242, 106, 65, 255, 242, 106, 65, 255, 242, 105, 65, 255, 242, 105, 64, 255, 241, 104, 64, 255, 241, 104, 64, 255, 241, 104, 64, 255, 241, 103, 63, 255, 240, 103, 63, 255, 240, 102, 63, 255, 240, 102, 63, 255, 240, 101, 62, 255, 240, 101, 62, 255, 239, 101, 62, 255, 239, 100, 62, 255, 239, 100, 61, 255, 239, 99, 61, 255, 238, 99, 61, 255, 238, 98, 61, 255, 238, 98, 60, 255, 238, 98, 60, 255, 238, 97, 60, 255, 237, 97, 60, 255, 237, 96, 60, 255, 237, 96, 59, 255, 237, 95, 59, 255, 236, 95, 59, 255, 236, 95, 59, 255, 236, 94, 58, 255, 236, 94, 58, 255, 236, 93, 58, 255, 235, 93, 58, 255, 235, 92, 57, 255, 235, 92, 57, 255, 235, 91, 57, 255, 234, 91, 57, 255, 234, 91, 57, 255, 234, 90, 56, 255, 234, 90, 56, 255, 234, 89, 56, 255, 233, 89, 56, 255, 233, 88, 55, 255, 233, 88, 55, 255, 233, 87, 55, 255, 232, 87, 55, 255, 232, 86, 55, 255, 226, 74, 49, 255, 226, 73, 49, 255, 226, 73, 48, 255, 225, 72, 48, 255, 225, 72, 48, 255, 225, 72, 48, 255, 225, 71, 47, 255, 225, 71, 47, 255, 224, 70, 47, 255, 224, 70, 47, 255, 224, 69, 47, 255, 224, 69, 46, 255, 223, 68, 46, 255, 223, 68, 46, 255, 223, 67, 46, 255, 223, 67, 46, 255, 223, 66, 45, 255, 222, 66, 45, 255, 222, 65, 45, 255, 222, 65, 45, 255, 222, 64, 44, 255, 221, 64, 44, 255, 221, 63, 44, 255, 221, 63, 44, 255, 221, 62, 44, 255, 220, 62, 43, 255, 220, 61, 43, 255, 220, 61, 43, 255, 220, 60, 43, 255, 220, 60, 43, 255, 219, 59, 42, 255, 219, 59, 42, 255, 219, 58, 42, 255, 219, 58, 42, 255, 218, 57, 42, 255, 218, 57, 41, 255, 218, 56, 41, 255, 218, 55, 41, 255, 217, 55, 41, 255, 217, 54, 41, 255, 217, 54, 41, 255, 217, 53, 40, 255, 217, 53, 40, 255, 216, 52, 40, 255, 216, 51, 40, 255, 216, 51, 40, 255, 216, 50, 39, 255, 215, 50, 39, 255, 215, 49, 39, 255, 215, 48, 39, 255, 215, 48, 39, 255, 214, 47, 39, 255, 214, 47, 39, 255, 214, 47, 39, 255, 213, 46, 39, 255, 213, 46, 39, 255, 212, 46, 39, 255, 212, 45, 39, 255, 212, 45, 39, 255, 211, 45, 39, 255, 211, 45, 39, 255, 211, 44, 39, 255, 210, 44, 39, 255, 210, 44, 39, 255, 209, 43, 39, 255, 209, 43, 39, 255, 209, 43, 39, 255, 208, 42, 39, 255, 208, 42, 39, 255, 207, 42, 39, 255, 207, 41, 39, 255, 207, 41, 39, 255, 206, 41, 39, 255, 206, 40, 39, 255, 206, 40, 39, 255, 205, 40, 39, 255, 205, 39, 39, 255, 204, 39, 39, 255, 204, 39, 39, 255, 204, 38, 39, 255, 203, 38, 39, 255, 203, 38, 39, 255, 202, 37, 39, 255, 202, 37, 39, 255, 202, 37, 39, 255, 201, 36, 39, 255, 201, 36, 39, 255, 200, 36, 39, 255, 200, 35, 39, 255, 200, 35, 39, 255, 199, 35, 39, 255, 199, 34, 39, 255, 199, 34, 39, 255, 198, 34, 39, 255, 198, 33, 39, 255, 197, 33, 39, 255, 197, 33, 39, 255, 197, 32, 39, 255, 196, 32, 39, 255, 196, 32, 39, 255, 195, 31, 39, 255, 195, 31, 39, 255, 185, 21, 39, 255, 184, 21, 39, 255, 184, 20, 39, 255, 183, 20, 39, 255, 183, 20, 39, 255, 183, 19, 39, 255, 182, 19, 39, 255, 182, 19, 39, 255, 181, 18, 39, 255, 181, 18, 39, 255, 181, 17, 39, 255, 180, 17, 39, 255, 180, 17, 39, 255, 180, 16, 39, 255, 179, 16, 39, 255, 179, 16, 38, 255, 178, 15, 38, 255, 178, 15, 38, 255, 178, 14, 38, 255, 177, 14, 38, 255, 177, 14, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 176, 12, 38, 255, 175, 12, 38, 255, 175, 11, 38, 255, 174, 11, 38, 255, 174, 11, 38, 255, 174, 10, 38, 255, 173, 10, 38, 255, 173, 9, 38, 255, 172, 9, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 5, 38, 255, 169, 5, 38, 255, 169, 4, 38, 255, 168, 4, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 166, 2, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdYlGn_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 0, 104, 54, 0, 1, 107, 56, 24, 2, 111, 58, 49, 4, 114, 60, 74, 6, 118, 62, 99, 8, 122, 64, 124, 16, 135, 71, 149, 18, 138, 73, 174, 20, 142, 75, 199, 22, 145, 76, 224, 24, 149, 78, 249, 28, 152, 80, 255, 35, 155, 81, 255, 42, 157, 82, 255, 48, 160, 84, 255, 53, 162, 85, 255, 58, 165, 86, 255, 78, 175, 91, 255, 82, 177, 93, 255, 87, 180, 94, 255, 91, 182, 95, 255, 95, 185, 96, 255, 99, 187, 98, 255, 103, 189, 99, 255, 107, 191, 99, 255, 112, 193, 99, 255, 116, 195, 100, 255, 120, 196, 100, 255, 123, 198, 100, 255, 127, 200, 101, 255, 144, 207, 103, 255, 148, 209, 103, 255, 151, 210, 104, 255, 155, 212, 104, 255, 159, 214, 105, 255, 162, 215, 105, 255, 166, 217, 106, 255, 169, 218, 107, 255, 172, 219, 109, 255, 175, 220, 111, 255, 178, 222, 113, 255, 181, 223, 114, 255, 183, 224, 116, 255, 186, 225, 118, 255, 199, 231, 126, 255, 202, 232, 128, 255, 204, 233, 130, 255, 207, 234, 131, 255, 209, 235, 133, 255, 212, 236, 135, 255, 214, 237, 137, 255, 217, 238, 138, 255, 218, 238, 138, 255, 219, 238, 138, 255, 220, 237, 138, 255, 221, 237, 138, 255, 222, 237, 137, 255, 223, 236, 137, 255, 224, 236, 137, 255, 225, 236, 137, 255, 226, 235, 137, 255, 226, 235, 137, 255, 227, 235, 137, 255, 228, 234, 137, 255, 229, 234, 137, 255, 230, 234, 136, 255, 231, 233, 136, 255, 232, 233, 136, 255, 232, 233, 136, 255, 241, 229, 136, 255, 241, 229, 136, 255, 242, 229, 136, 255, 243, 228, 137, 255, 243, 228, 137, 255, 244, 228, 137, 255, 245, 228, 137, 255, 246, 227, 137, 255, 246, 227, 137, 255, 247, 227, 137, 255, 247, 226, 137, 255, 248, 226, 137, 255, 249, 226, 137, 255, 249, 226, 137, 255, 250, 225, 137, 255, 250, 225, 138, 255, 251, 225, 138, 255, 252, 224, 138, 255, 252, 224, 138, 255, 253, 224, 138, 255, 253, 224, 138, 255, 253, 223, 138, 255, 253, 221, 136, 255, 253, 220, 134, 255, 253, 218, 133, 255, 253, 217, 131, 255, 253, 215, 130, 255, 253, 213, 128, 255, 253, 212, 126, 255, 253, 210, 125, 255, 253, 209, 124, 255, 253, 207, 122, 255, 253, 206, 121, 255, 253, 204, 120, 255, 253, 193, 110, 255, 253, 191, 109, 255, 253, 190, 107, 255, 253, 188, 106, 255, 253, 187, 105, 255, 253, 185, 104, 255, 253, 184, 103, 255, 253, 182, 102, 255, 253, 181, 101, 255, 253, 179, 100, 255, 253, 178, 99, 255, 253, 177, 98, 255, 253, 175, 97, 255, 253, 174, 97, 255, 252, 172, 95, 255, 252, 171, 94, 255, 252, 169, 93, 255, 252, 167, 92, 255, 252, 166, 91, 255, 251, 164, 90, 255, 251, 163, 89, 255, 251, 161, 88, 255, 251, 160, 87, 255, 251, 158, 86, 255, 250, 157, 86, 255, 250, 155, 85, 255, 250, 154, 84, 255, 250, 152, 83, 255, 250, 151, 82, 255, 250, 149, 82, 255, 248, 135, 75, 255, 247, 134, 74, 255, 247, 132, 74, 255, 247, 131, 73, 255, 247, 129, 73, 255, 247, 128, 72, 255, 246, 127, 72, 255, 246, 125, 71, 255, 246, 124, 71, 255, 246, 122, 70, 255, 245, 121, 70, 255, 245, 120, 69, 255, 245, 118, 69, 255, 245, 117, 68, 255, 245, 116, 68, 255, 244, 114, 68, 255, 244, 113, 67, 255, 244, 111, 67, 255, 244, 110, 67, 255, 244, 109, 67, 255, 243, 108, 66, 255, 243, 107, 65, 255, 242, 106, 65, 255, 242, 105, 64, 255, 241, 104, 64, 255, 241, 103, 63, 255, 240, 102, 63, 255, 240, 101, 62, 255, 239, 100, 62, 255, 239, 99, 61, 255, 238, 98, 61, 255, 238, 97, 60, 255, 237, 97, 60, 255, 237, 96, 59, 255, 236, 95, 59, 255, 236, 94, 58, 255, 235, 93, 58, 255, 235, 92, 57, 255, 235, 91, 57, 255, 234, 90, 57, 255, 234, 90, 56, 255, 233, 89, 56, 255, 233, 88, 55, 255, 232, 87, 55, 255, 226, 74, 49, 255, 226, 73, 48, 255, 225, 72, 48, 255, 225, 72, 48, 255, 225, 71, 47, 255, 224, 70, 47, 255, 224, 69, 47, 255, 223, 68, 46, 255, 223, 68, 46, 255, 223, 67, 46, 255, 222, 66, 45, 255, 222, 65, 45, 255, 222, 64, 45, 255, 221, 64, 44, 255, 221, 63, 44, 255, 221, 62, 44, 255, 220, 61, 43, 255, 220, 60, 43, 255, 219, 60, 43, 255, 219, 59, 42, 255, 219, 58, 42, 255, 218, 57, 42, 255, 218, 56, 41, 255, 218, 56, 41, 255, 217, 55, 41, 255, 217, 54, 41, 255, 217, 53, 40, 255, 217, 53, 40, 255, 216, 52, 40, 255, 216, 51, 40, 255, 216, 50, 39, 255, 215, 50, 39, 255, 215, 49, 39, 255, 215, 48, 39, 255, 214, 47, 39, 255, 214, 47, 39, 255, 213, 47, 39, 255, 213, 46, 39, 255, 212, 46, 39, 255, 212, 45, 39, 255, 212, 45, 39, 255, 211, 45, 39, 255, 211, 44, 39, 255, 210, 44, 39, 255, 210, 44, 39, 255, 209, 43, 39, 255, 209, 43, 39, 255, 209, 43, 39, 255, 208, 42, 39, 255, 208, 42, 39, 255, 207, 41, 39, 255, 207, 41, 39, 255, 206, 41, 39, 255, 206, 40, 39, 255, 206, 40, 39, 255, 205, 40, 39, 255, 205, 40, 39, 255, 205, 39, 39, 255, 204, 39, 39, 255, 204, 39, 39, 255, 203, 38, 39, 255, 203, 38, 39, 255, 203, 38, 39, 255, 202, 37, 39, 255, 202, 37, 39, 255, 202, 37, 39, 255, 201, 36, 39, 255, 201, 36, 39, 255, 201, 36, 39, 255, 200, 36, 39, 255, 200, 35, 39, 255, 200, 35, 39, 255, 199, 35, 39, 255, 199, 35, 39, 255, 199, 34, 39, 255, 198, 34, 39, 255, 198, 34, 39, 255, 198, 33, 39, 255, 198, 33, 39, 255, 197, 33, 39, 255, 197, 33, 39, 255, 197, 32, 39, 255, 196, 32, 39, 255, 196, 32, 39, 255, 196, 32, 39, 255, 196, 31, 39, 255, 195, 31, 39, 255, 195, 31, 39, 255, 195, 31, 39, 255, 184, 21, 39, 255, 184, 21, 39, 255, 184, 20, 39, 255, 184, 20, 39, 255, 183, 20, 39, 255, 183, 20, 39, 255, 183, 20, 39, 255, 183, 19, 39, 255, 182, 19, 39, 255, 182, 19, 39, 255, 182, 19, 39, 255, 182, 18, 39, 255, 182, 18, 39, 255, 181, 18, 39, 255, 181, 18, 39, 255, 181, 18, 39, 255, 181, 17, 39, 255, 180, 17, 39, 255, 180, 17, 39, 255, 180, 17, 39, 255, 180, 17, 39, 255, 180, 16, 39, 255, 179, 16, 39, 255, 179, 16, 39, 255, 179, 16, 39, 255, 179, 16, 38, 255, 179, 15, 38, 255, 178, 15, 38, 255, 178, 15, 38, 255, 178, 15, 38, 255, 178, 15, 38, 255, 178, 14, 38, 255, 178, 14, 38, 255, 177, 14, 38, 255, 177, 14, 38, 255, 177, 14, 38, 255, 177, 14, 38, 255, 177, 13, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 176, 13, 38, 255, 176, 12, 38, 255, 176, 12, 38, 255, 175, 12, 38, 255, 175, 12, 38, 255, 175, 12, 38, 255, 175, 12, 38, 255, 175, 11, 38, 255, 175, 11, 38, 255, 174, 11, 38, 255, 174, 11, 38, 255, 174, 11, 38, 255, 174, 11, 38, 255, 174, 11, 38, 255, 174, 10, 38, 255, 174, 10, 38, 255, 174, 10, 38, 255, 173, 10, 38, 255, 173, 10, 38, 255, 173, 10, 38, 255, 173, 9, 38, 255, 173, 9, 38, 255, 173, 9, 38, 255, 173, 9, 38, 255, 173, 9, 38, 255, 172, 9, 38, 255, 172, 9, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 172, 8, 38, 255, 171, 8, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 7, 38, 255, 171, 6, 38, 255, 171, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 6, 38, 255, 170, 5, 38, 255, 170, 5, 38, 255, 170, 5, 38, 255, 170, 5, 38, 255, 170, 5, 38, 255, 169, 5, 38, 255, 169, 5, 38, 255, 169, 5, 38, 255, 169, 5, 38, 255, 169, 5, 38, 255, 169, 5, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 169, 4, 38, 255, 168, 4, 38, 255, 168, 4, 38, 255, 168, 4, 38, 255, 168, 4, 38, 255, 168, 4, 38, 255, 168, 4, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 168, 3, 38, 255, 167, 3, 38, 255, 167, 3, 38, 255, 167, 3, 38, 255, 167, 3, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 167, 2, 38, 255, 166, 2, 38, 255, 166, 2, 38, 255, 166, 2, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 166, 1, 38, 255, 165, 1, 38, 255, 165, 1, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 38, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 165, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255, 164, 0, 37, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_RdYlGn_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
