# Ported from KFR
function (link_whole_archive TARGET TYPE LIBRARY)
  if(NOT (TARGET "${LIBRARY}"))
      message(FATAL_ERROR "Trying to link missing target ${LIBRARY}")
  endif()
  get_target_property(libtype ${LIBRARY} TYPE)
  if("${libtype}" MATCHES "INTERFACE.*")
    target_link_libraries(${TARGET} ${TYPE} "$<BUILD_INTERFACE:${LIBRARY}>")
    return()
  endif()

  if(CMAKE_LINK_LIBRARY_USING_WHOLE_ARCHIVE_SUPPORTED)
    target_link_libraries(${TARGET} ${TYPE} "$<BUILD_INTERFACE:$<LINK_LIBRARY:WHOLE_ARCHIVE,${LIBRARY}>>")
  else()
    if (APPLE)
      target_link_options(${TARGET} ${TYPE} "$<BUILD_INTERFACE:LINKER:-force_load,$<TARGET_FILE:${LIBRARY}>>")
    elseif (MSVC)
      target_link_options(${TARGET} ${TYPE} "$<BUILD_INTERFACE:/WHOLEARCHIVE:$<TARGET_FILE:${LIBRARY}>>")
    else ()
      target_link_options(${TARGET} ${TYPE} "$<BUILD_INTERFACE:LINKER:--push-state,--whole-archive,$<TARGET_FILE:${LIBRARY}>,--pop-state>")
    endif ()
  endif ()
endfunction ()
