/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */

#ifndef SH4LT_TYPE_FROM_GST_CAPS_H_
#define SH4LT_TYPE_FROM_GST_CAPS_H_

#include "./shtype.hpp"
#include <string>

namespace sh4lt::shtype {

/**
 * Construct a Shtype from a serialized GStreamer Caps.
 *
 * \param   gst_caps The serialized GStreamer Caps.
 * \param   label The ShType label.
 * \param   group_label The ShType group label.
 *
 * \return  The ShType created. Validity can be tested from the SafeBoolLog
 * inheritence.
 */
auto shtype_from_gst_caps(const std::string& gst_caps,
                          const std::string& label,
                          const std::string& group_label) -> ShType;

/**
 * Construct a Shtype from a serialized GStreamer Caps.
 *
 * \param   gst_caps The serialized GStreamer Caps.
 * \param   label The ShType label.
 *
 * \return  The ShType created. Validity can be tested from the SafeBoolLog
 * inheritence.
 */
auto shtype_from_gst_caps(const std::string& gst_caps, const std::string& label) -> ShType;

/**
 * Produce a serialized GStreamer caps from a ShType.
 * Note the ShType label and group label are not embedded in the GStreamer caps.
 *
 * \param   shtype the ShType instance to convert.
 *
 * \return  The string in the GStreamer caps format.
 */
auto shtype_to_gst_caps(const ShType& shtype) -> std::string;

} // namespace sh4lt
#endif
