/* Copyright (c) 2019 - 2020, Nordic Semiconductor ASA
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

3. Neither the name of Nordic Semiconductor ASA nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL NORDIC SEMICONDUCTOR ASA OR CONTRIBUTORS BELIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

'use strict';

const version = require('./package.json').version;
const pathForJson = filename => `${__dirname}/v${version.split('.')[0]}/${filename}.json`;

const companies = require(pathForJson('company_ids'));
const services = require(pathForJson('service_uuids'));
const characteristics = require(pathForJson('characteristic_uuids'));
const descriptors = require(pathForJson('descriptor_uuids'));
const appearances = require(pathForJson('gap_appearance'));

const companySchema = require(pathForJson('company_schema'));
const attributeSchema = require(pathForJson('attribute_schema'));
const appearanceSchema = require(pathForJson('appearance_schema'));

module.exports = {
    version,
    companies,
    services,
    characteristics,
    descriptors,
    appearances,
    schemas: {
        companies: companySchema,
        services: attributeSchema,
        characteristics: attributeSchema,
        descriptors: attributeSchema,
        appearances: appearanceSchema
    }
};
