#pragma once
#include <score/application/ApplicationContext.hpp>
#include <score/command/Command.hpp>
#include <score/command/CommandGeneratorMap.hpp>
#include <score/plugins/InterfaceList.hpp>
#include <score/plugins/qt_interfaces/CommandFactory_QtInterface.hpp>
#include <score/plugins/qt_interfaces/FactoryFamily_QtInterface.hpp>
#include <score/plugins/qt_interfaces/FactoryInterface_QtInterface.hpp>
#include <score/plugins/qt_interfaces/GUIApplicationPlugin_QtInterface.hpp>
#include <score/plugins/qt_interfaces/PluginRequirements_QtInterface.hpp>


#include <utility>
#include <vector>

class score_addon_ndi final : public score::Plugin_QtInterface,
                                   public score::FactoryInterface_QtInterface
{
  SCORE_PLUGIN_METADATA(1, "04dc0e80-05f9-4dd3-9d86-e95691f94b49")

public:
  score_addon_ndi();
  ~score_addon_ndi() override;

private:
  std::vector<score::InterfaceBase*> factories(
      const score::ApplicationContext& ctx,
      const score::InterfaceKey& key) const override;

  bool m_hasNDI{};
};
