#pragma once
#include <Gfx/Graph/RenderState.hpp>

#include <score/plugins/ProjectSettings/ProjectSettingsModel.hpp>
#include <score/plugins/settingsdelegate/SettingsDelegateModel.hpp>

#include <score_plugin_gfx_export.h>

#include <verdigris>
namespace Gfx::Settings
{

struct GraphicsApis
{
  const QString OpenGL{"OpenGL"};
  const QString Vulkan{"Vulkan"};
  const QString Metal{"Metal"};
  const QString D3D11{"Direct3D 11"};
  const QString D3D12{"Direct3D 12"};
  operator QStringList() const noexcept;
};

struct HardwareVideoDecoder
{
  const QString None{"None"};
  const QString CUDA{"CUDA"};
  const QString QSV{"Intel QuickSync"};
  const QString VDPAU{"VDPAU"};
  const QString VAAPI{"VA-API"};
  const QString D3D{"Direct3D 11"};
  const QString DXVA{"DXVA2"};
  const QString VideoToolbox{"Video Toolbox"};
  const QString V4L2{"V4L2-M2M"};
  operator QStringList() const noexcept;
};

class Model : public score::SettingsDelegateModel
{
  W_OBJECT(Model)

  QString m_GraphicsApi{};
  QString m_HardwareDecode{};
  int m_DecodingThreads{1};
  double m_Rate{};
  int m_Samples{1};
  bool m_VSync{};
  int m_Buffers{3};

public:
  Model(QSettings& set, const score::ApplicationContext& ctx);

  SCORE_SETTINGS_PARAMETER_HPP(SCORE_PLUGIN_GFX_EXPORT, QString, HardwareDecode)
  SCORE_SETTINGS_PARAMETER_HPP(SCORE_PLUGIN_GFX_EXPORT, int, DecodingThreads)
  SCORE_SETTINGS_PARAMETER_HPP(SCORE_PLUGIN_GFX_EXPORT, double, Rate)
  SCORE_SETTINGS_PARAMETER_HPP(SCORE_PLUGIN_GFX_EXPORT, int, Samples)
  SCORE_SETTINGS_PARAMETER_HPP(SCORE_PLUGIN_GFX_EXPORT, bool, VSync)
  SCORE_SETTINGS_PARAMETER_HPP(SCORE_PLUGIN_GFX_EXPORT, int, Buffers)

public:
  score::gfx::GraphicsApi graphicsApiEnum() const noexcept;
  QString getGraphicsApi() const;
  void initGraphicsApi(QString);
  void setGraphicsApi(QString);
  void GraphicsApiChanged(QString arg)
      E_SIGNAL(SCORE_PLUGIN_GFX_EXPORT, GraphicsApiChanged, arg)
  SCORE_SETTINGS_PROPERTY(QString, GraphicsApi)

  // Required as D3D12 requires a minimum of 2 samples
  int resolveSamples(score::gfx::GraphicsApi) const noexcept;
};

SCORE_SETTINGS_PARAMETER(Model, GraphicsApi)
SCORE_SETTINGS_PARAMETER(Model, HardwareDecode)
SCORE_SETTINGS_PARAMETER(Model, DecodingThreads)
SCORE_SETTINGS_PARAMETER(Model, Rate)
SCORE_SETTINGS_PARAMETER(Model, Samples)
SCORE_SETTINGS_PARAMETER(Model, VSync)
SCORE_SETTINGS_PARAMETER(Model, Buffers)
}
