#!/usr/bin/env python3

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.

# This test implement a Writer Follower communication, with all
# optional parameter not provided.

import sh4lt as s
import time

frame_duration_ms = 10
data_received = False
label = "minimal writer follower"

# Create a Sh4lt Follower
def on_data(data, size, time_info):
    global data_received
    data_received = True
    assert len(data) == size
    assert "are belong to us".startswith(data.decode(encoding="utf-8"))

follower = s.Follower(s.ShType.get_path(label), on_data)
assert follower

# Create a Sh4lt description for the data to send (a ShType object)
shtype = s.ShType("text/x-raw", label)
assert shtype

# Create a Sh4lt Writer
writer = s.Writer(shtype)
assert writer

# Write data to the Sh4lt
data = bytearray("are belong to us", encoding="utf-8")
i = 0
while i < len(data):
    i += 1
    # You should prefer to provide buffer playhead date and duration, as follows:
    # writer.copy_to_shm(data, i * frame_duration_ms * 1000000, frame_duration_ms * 1000000)
    # but timestamps can be discarded:
    assert writer.copy_to_shm(data)
    time.sleep(frame_duration_ms / 1000)

assert data_received
