Install the CSHARP module {#module_csharp_installation}
==========================

This is an optional module that adds C# support in Chrono.

## Features

The **CSHARP module** allows users to use Chrono in C# programs and interface Chrono to engines such as [Unity3D](http://www.unity.com).
  
## Requirements

- To **build** this module:
    - you must have the [SWIG](http://www.swig.org/) wrapper generator installed. On the Mac type <tt>brew install swig</tt>.

<div class="ce-warning">
Chrono::Csharp requires SWIG version **4.0.0* or newer.
On the Mac **SWIG v. 4.0.1** is known to work. It is installed by homebrew.
</div>

## Building instructions

1. Install SWIG on your system. Version 4.0.0 or newer is required. (on Windows, just unzip where you want).

2. Repeat the instructions for the [full installation](@ref tutorial_install_chrono), but when you see 
   the CMake window, you must add the following steps:

3. Set the `ENABLE_MODULE_CSHARP` as 'on', then press 'Configure' (to refresh the variable list) 

4. When you pressed 'Configure', CMake should have detected your SWIG tools. This should create two variables in CMake called <tt>SWIG_DIR</tt> and <tt>SWIG_EXECUTABLE</tt>. 
   If all is fine, they should automatically contain meaningful values, 
   for example <tt>C:/swigwin-4.0.0/Lib</tt> and <tt>C:/swigwin-4.0.0/swig.exe</tt> , 
   so you do not need to touch them. (On Windows, you may need to set them by hand).

5. Press 'Configure' again, then 'Generate', and proceed as usual in the installation instructions.

## Notes

The build process of the Csharp modules, as generated by CMake, consists of these automatic steps: 

- SWIG preprocesses C++ source code files in order to generate .cxx wrapper files that contain the code for accessing C++ functions through the API, and (several hundreds) .cs files. These C# files are all generated in a subdirectory `chrono_csharp` of the *BUILD* tree.

- the C++ compiler compiles the .cxx file and generates one or more library files.  On Windows, the DLL library files are created in the `bin/<Configuration>` directory of the *BUILD* tree.  On Linux, the .so shared libraries are created in the `lib` directory of the *BUILD* tree.

- the SWIG-generated files (.cs) and resulting library files (.dll on Windows and .so on Linux/Mac) are generated and can be used from the above locations in the *BUILD* tree.  Similarly, after installation, all Chrono::Csharp files are copied in two separate locations of the *INSTALL* tree (C# files under `include/chrono_csharp` and libraries files under `bin` or `lib` on Windows and Linux, respectively).  

<div class="ce-info">
Note that the SWIG tool requires a few minutes to process the source and generate the .cxx wrapper file. When you start the compilation of the entire Chrono project, the process might look 'frozen'  for one or two minutes when SWIG does its job. 
</div>

