# Функціональні можливості { #features }

## Функціональні можливості FastAPI { #fastapi-features }

**FastAPI** надає вам такі можливості:

### На основі відкритих стандартів { #based-on-open-standards }

* <a href="https://github.com/OAI/OpenAPI-Specification" class="external-link" target="_blank"><strong>OpenAPI</strong></a> для створення API, включаючи оголошення <abbr title="також відомі як: endpoints, маршрути">шляхів</abbr>, <abbr title="також відомі як HTTP-методи, наприклад, POST, GET, PUT, DELETE">операцій</abbr>, параметрів, тіл запитів, безпеки тощо.
* Автоматична документація моделей даних за допомогою <a href="https://json-schema.org/" class="external-link" target="_blank"><strong>JSON Schema</strong></a> (оскільки OpenAPI базується саме на JSON Schema).
* Розроблено на основі цих стандартів після ретельного аналізу, а не як додатковий рівень поверх основної архітектури.
* Це також дає змогу використовувати автоматичну **генерацію клієнтського коду** багатьма мовами.

### Автоматична документація { #automatic-docs }

Інтерактивна документація API та вебінтерфейси для його дослідження. Оскільки фреймворк базується на OpenAPI, є кілька варіантів, 2 з яких включені за замовчуванням.

* <a href="https://github.com/swagger-api/swagger-ui" class="external-link" target="_blank"><strong>Swagger UI</strong></a> — з інтерактивним дослідженням, викликом і тестуванням вашого API прямо з браузера.

![Swagger UI interaction](https://fastapi.tiangolo.com/img/index/index-03-swagger-02.png)

* Альтернативна документація API за допомогою <a href="https://github.com/Rebilly/ReDoc" class="external-link" target="_blank"><strong>ReDoc</strong></a>.

![ReDoc](https://fastapi.tiangolo.com/img/index/index-06-redoc-02.png)

### Лише сучасний Python { #just-modern-python }

Усе базується на стандартних оголошеннях **типів Python** (завдяки Pydantic). Жодного нового синтаксису для вивчення. Лише стандартний сучасний Python.

Якщо вам потрібно 2-хвилинне нагадування про те, як використовувати типи Python (навіть якщо ви не використовуєте FastAPI), перегляньте короткий підручник: [Типи Python](python-types.md){.internal-link target=_blank}.

Ви пишете стандартний Python з типами:

```Python
from datetime import date

from pydantic import BaseModel

# Оголосіть змінну як str
# та отримайте підтримку редактора всередині функції
def main(user_id: str):
    return user_id


# Модель Pydantic
class User(BaseModel):
    id: int
    name: str
    joined: date
```

Далі це можна використовувати так:

```Python
my_user: User = User(id=3, name="John Doe", joined="2018-07-19")

second_user_data = {
    "id": 4,
    "name": "Mary",
    "joined": "2018-11-30",
}

my_second_user: User = User(**second_user_data)
```

/// info | Інформація

`**second_user_data` означає:

Передати ключі та значення словника `second_user_data` безпосередньо як аргументи у вигляді «ключ-значення», еквівалентно: `User(id=4, name="Mary", joined="2018-11-30")`

///

### Підтримка редакторів (IDE) { #editor-support }

Увесь фреймворк спроєктовано так, щоб ним було легко та інтуїтивно користуватися; усі рішення тестувалися у кількох редакторах ще до початку розробки, щоб забезпечити найкращий досвід розробки.

З опитувань розробників Python зрозуміло <a href="https://www.jetbrains.com/research/python-developers-survey-2017/#tools-and-features" class="external-link" target="_blank">що однією з найуживаніших функцій є «автодоповнення»</a>.

Увесь фреймворк **FastAPI** побудований так, щоб це забезпечити. Автодоповнення працює всюди.

Вам рідко доведеться повертатися до документації.

Ось як ваш редактор може вам допомогти:

* у <a href="https://code.visualstudio.com/" class="external-link" target="_blank">Visual Studio Code</a>:

![editor support](https://fastapi.tiangolo.com/img/vscode-completion.png)

* у <a href="https://www.jetbrains.com/pycharm/" class="external-link" target="_blank">PyCharm</a>:

![editor support](https://fastapi.tiangolo.com/img/pycharm-completion.png)

Ви отримаєте автодоповнення в коді, який раніше могли вважати навіть неможливим. Наприклад, для ключа `price` всередині JSON body (який міг бути вкладеним), що надходить із запиту.

Більше не доведеться вводити неправильні назви ключів, постійно повертатися до документації або прокручувати вгору-вниз, щоб знайти, чи ви зрештою використали `username` чи `user_name`.

### Короткий код { #short }

FastAPI має розумні **налаштування за замовчуванням** для всього, з можливістю конфігурації всюди. Усі параметри можна точно налаштувати під ваші потреби та визначити потрібний вам API.

Але за замовчуванням усе **«просто працює»**.

### Валідація { #validation }

* Підтримка валідації для більшості (або всіх?) **типів даних Python**, зокрема:
    * JSON-об'єктів (`dict`).
    * JSON-масивів (`list`) із визначенням типів елементів.
    * Полів-рядків (`str`) із визначенням мінімальної та максимальної довжини.
    * Чисел (`int`, `float`) з мінімальними та максимальними значеннями тощо.

* Валідація для більш екзотичних типів, як-от:
    * URL.
    * Email.
    * UUID.
    * ...та інші.

Уся валідація виконується через надійний та перевірений **Pydantic**.

### Безпека та автентифікація { #security-and-authentication }

Інтегровані безпека та автентифікація. Без жодних компромісів із базами даних чи моделями даних.

Підтримуються всі схеми безпеки, визначені в OpenAPI, включно з:

* HTTP Basic.
* **OAuth2** (також із підтримкою **JWT tokens**). Перегляньте підручник: [OAuth2 із JWT](tutorial/security/oauth2-jwt.md){.internal-link target=_blank}.
* Ключі API в:
    * Заголовках.
    * Параметрах запиту.
    * Cookies тощо.

А також усі можливості безпеки від Starlette (зокрема **session cookies**).

Усе це зроблено як багаторазові інструменти та компоненти, які легко інтегруються з вашими системами, сховищами даних, реляційними та NoSQL базами даних тощо.

### Впровадження залежностей { #dependency-injection }

FastAPI містить надзвичайно просту у використанні, але надзвичайно потужну систему <abbr title='також відоме як: "components", "resources", "services", "providers"'><strong>Dependency Injection</strong></abbr>.

* Навіть залежності можуть мати власні залежності, утворюючи ієрархію або **«граф» залежностей**.
* Усе **автоматично обробляється** фреймворком.
* Усі залежності можуть вимагати дані із запитів і **розширювати обмеження операції шляху** та автоматичну документацію.
* **Автоматична валідація** навіть для параметрів *операції шляху*, визначених у залежностях.
* Підтримка складних систем автентифікації користувачів, **підключень до баз даних** тощо.
* **Жодних компромісів** із базами даних, фронтендами тощо. Але проста інтеграція з усіма ними.

### Необмежені «плагіни» { #unlimited-plug-ins }

Інакше кажучи, вони не потрібні — імпортуйте та використовуйте код, який вам потрібен.

Будь-яка інтеграція спроєктована так, щоб її було дуже просто використовувати (із залежностями), тож ви можете створити «плагін» для свого застосунку у 2 рядках коду, використовуючи ту саму структуру та синтаксис, що й для ваших *операцій шляху*.

### Протестовано { #tested }

* 100% <abbr title="Обсяг коду, що автоматично тестується">покриття тестами</abbr>.
* 100% <abbr title="Анотації типів у Python, завдяки яким ваш редактор і зовнішні інструменти можуть надавати кращу підтримку">анотована типами</abbr> кодова база.
* Використовується в production-застосунках.

## Можливості Starlette { #starlette-features }

**FastAPI** повністю сумісний із (та побудований на основі) <a href="https://www.starlette.dev/" class="external-link" target="_blank"><strong>Starlette</strong></a>. Тому будь-який додатковий код Starlette, який ви маєте, також працюватиме.

`FastAPI` фактично є підкласом `Starlette`. Тому, якщо ви вже знайомі зі Starlette або використовуєте його, більшість функціональності працюватиме так само.

З **FastAPI** ви отримуєте всі можливості **Starlette** (адже FastAPI — це просто Starlette на стероїдах):

* Разюча продуктивність. Це <a href="https://github.com/encode/starlette#performance" class="external-link" target="_blank">один із найшвидших доступних Python-фреймворків, на рівні з **NodeJS** і **Go**</a>.
* Підтримка **WebSocket**.
* Фонові задачі у процесі.
* Події запуску та завершення роботи.
* Клієнт для тестування, побудований на HTTPX.
* Підтримка **CORS**, **GZip**, статичних файлів, потокових відповідей.
* Підтримка **сесій** і **cookie**.
* 100% покриття тестами.
* 100% анотована типами кодова база.

## Можливості Pydantic { #pydantic-features }

**FastAPI** повністю сумісний із (та побудований на основі) <a href="https://docs.pydantic.dev/" class="external-link" target="_blank"><strong>Pydantic</strong></a>. Тому будь-який додатковий код Pydantic, який ви маєте, також працюватиме.

Включно із зовнішніми бібліотеками, які також базуються на Pydantic, як-от <abbr title="Object-Relational Mapper - Об'єктно-реляційний відображувач">ORM</abbr>-и, <abbr title="Object-Document Mapper - Об'єктно-документний відображувач">ODM</abbr>-и для баз даних.

Це також означає, що в багатьох випадках ви можете передати той самий об'єкт, який отримуєте із запиту, **безпосередньо в базу даних**, оскільки все автоматично перевіряється.

Те саме застосовується й у зворотному напрямку — у багатьох випадках ви можете просто передати об'єкт, який отримуєте з бази даних, **безпосередньо клієнту**.

З **FastAPI** ви отримуєте всі можливості **Pydantic** (адже FastAPI базується на Pydantic для обробки всіх даних):

* **Ніякої плутанини**:
    * Не потрібно вчити нову мікромову для визначення схем.
    * Якщо ви знаєте типи Python, ви знаєте, як використовувати Pydantic.
* Легко працює з вашим **<abbr title="Integrated Development Environment - Інтегроване середовище розробки: схоже на код-редактор">IDE</abbr>/<abbr title="Програма, що перевіряє код на помилки">linter</abbr>/мозком**:
    * Оскільки структури даних pydantic є просто екземплярами класів, які ви визначаєте; автодоповнення, лінтинг, mypy і ваша інтуїція повинні добре працювати з вашими перевіреними даними.
* Валідує **складні структури**:
    * Використання ієрархічних моделей Pydantic, Python `typing`’s `List` і `Dict` тощо.
    * Валідатори дають змогу складні схеми даних чітко й просто визначати, перевіряти й документувати як JSON Schema.
    * Ви можете мати глибоко **вкладені JSON** об'єкти, і всі вони будуть валідовані та анотовані.
* **Розширюваність**:
    * Pydantic дозволяє визначати користувацькі типи даних або ви можете розширити валідацію методами в моделі, позначеними декоратором validator.
* 100% покриття тестами.
