# Продвинутые типы Python { #advanced-python-types }

Ниже несколько дополнительных идей, которые могут быть полезны при работе с типами Python.

## Использование `Union` или `Optional` { #using-union-or-optional }

Если по какой-то причине ваш код не может использовать `|`, например, если это не аннотация типов, а что-то вроде `response_model=`, вместо вертикальной черты (`|`) можно использовать `Union` из `typing`.

Например, вы можете объявить, что значение может быть `str` или `None`:

```python
from typing import Union


def say_hi(name: Union[str, None]):
        print(f"Hi {name}!")
```

В `typing` также есть сокращение, чтобы объявить, что значение может быть `None`, — `Optional`.

Вот совет с моей очень субъективной точки зрения:

- 🚨 Избегайте использования `Optional[SomeType]`
- Вместо этого ✨ используйте **`Union[SomeType, None]`** ✨.

Оба варианта эквивалентны и под капотом это одно и то же, но я бы рекомендовал `Union` вместо `Optional`, потому что слово «optional» может наводить на мысль, что значение необязательное, тогда как на самом деле это означает «значение может быть `None`», даже если оно не является необязательным и по-прежнему требуется.

По-моему, `Union[SomeType, None]` более явно передаёт смысл.

Речь только о словах и названиях. Но эти слова могут влиять на то, как вы и ваша команда думаете о коде.

В качестве примера возьмём такую функцию:

```python
from typing import Optional


def say_hi(name: Optional[str]):
    print(f"Hey {name}!")
```

Параметр `name` объявлен как `Optional[str]`, но он не является необязательным: вы не можете вызвать функцию без этого параметра:

```Python
say_hi()  # О нет, это вызывает ошибку! 😱
```

Параметр `name` по-прежнему обязателен (не «optional»), так как у него нет значения по умолчанию. При этом `name` принимает `None` в качестве значения:

```Python
say_hi(name=None)  # Это работает, None допустим 🎉
```

Хорошая новость: в большинстве случаев вы сможете просто использовать `|` для объявления объединений типов:

```python
def say_hi(name: str | None):
    print(f"Hey {name}!")
```

Так что обычно вам не о чем переживать из‑за названий вроде `Optional` и `Union`. 😎
