# 응답 - 상태 코드 변경 { #response-change-status-code }

기본 [응답 상태 코드 설정](../tutorial/response-status-code.md){.internal-link target=_blank}이 가능하다는 걸 이미 알고 계실 겁니다.

하지만 경우에 따라 기본 설정과 다른 상태 코드를 반환해야 할 때가 있습니다.

## 사용 예 { #use-case }

예를 들어 기본적으로 HTTP 상태 코드 "OK" `200`을 반환하고 싶다고 가정해 봅시다.

하지만 데이터가 존재하지 않으면 이를 새로 생성하고, HTTP 상태 코드 "CREATED" `201`을 반환하고자 할 때가 있을 수 있습니다.

하지만 여전히 `response_model`을 사용하여 반환하는 데이터를 필터링하고 변환할 수 있기를 원합니다.

이런 경우에는 `Response` 파라미터를 사용할 수 있습니다.

## `Response` 파라미터 사용하기 { #use-a-response-parameter }

*경로 처리 함수*에 `Response` 타입의 파라미터를 선언할 수 있습니다. (쿠키와 헤더에 대해 선언하는 것과 유사하게)

그리고 이 *임시* 응답 객체에서 `status_code`를 설정할 수 있습니다.

{* ../../docs_src/response_change_status_code/tutorial001_py310.py hl[1,9,12] *}

그리고 평소처럼 필요한 어떤 객체든 반환할 수 있습니다(`dict`, 데이터베이스 모델 등).

`response_model`을 선언했다면 반환된 객체는 여전히 필터링되고 변환됩니다.

**FastAPI**는 이 *임시* 응답 객체에서 상태 코드(쿠키와 헤더 포함)를 추출하여, `response_model`로 필터링된 반환 값을 포함하는 최종 응답에 넣습니다.

또한, 의존성에서도 `Response` 파라미터를 선언하고 그 안에서 상태 코드를 설정할 수 있습니다. 단, 마지막으로 설정된 상태 코드가 우선 적용된다는 점을 유의하세요.
