# Условный OpenAPI { #conditional-openapi }

При необходимости вы можете использовать настройки и переменные окружения, чтобы условно настраивать OpenAPI в зависимости от окружения и даже полностью его отключать.

## О безопасности, API и документации { #about-security-apis-and-docs }

Скрытие пользовательских интерфейсов документации в продакшн не должно быть способом защиты вашего API.

Это не добавляет дополнительной безопасности вашему API, операции пути (обработчики пути) всё равно будут доступны по своим путям.

Если в вашем коде есть уязвимость, она всё равно останется.

Сокрытие документации лишь усложняет понимание того, как взаимодействовать с вашим API, и может усложнить его отладку в продакшн. Это можно считать просто разновидностью <a href="https://en.wikipedia.org/wiki/Security_through_obscurity" class="external-link" target="_blank">безопасности через сокрытие</a>.

Если вы хотите обезопасить свой API, есть несколько более эффективных вещей, которые можно сделать, например:

* Убедитесь, что у вас чётко определены Pydantic-модели для тел запросов и ответов.
* Настройте необходимые разрешения и роли с помощью зависимостей.
* Никогда не храните пароли в открытом виде, только хэши паролей.
* Реализуйте и используйте известные криптографические инструменты, например pwdlib и JWT-токены, и т.д.
* Добавьте более тонкое управление доступом с помощью OAuth2 scopes (областей) там, где это необходимо.
* ...и т.п.

Тем не менее, у вас может быть очень специфичный случай использования, когда действительно нужно отключить документацию API для некоторых окружений (например, в продакшн) или в зависимости от настроек из переменных окружения.

## Условный OpenAPI из настроек и переменных окружения { #conditional-openapi-from-settings-and-env-vars }

Вы можете легко использовать те же настройки Pydantic, чтобы настроить сгенерированный OpenAPI и интерфейсы документации.

Например:

{* ../../docs_src/conditional_openapi/tutorial001_py310.py hl[6,11] *}

Здесь мы объявляем настройку `openapi_url` с тем же значением по умолчанию — `"/openapi.json"`.

Затем используем её при создании приложения FastAPI.

Далее вы можете отключить OpenAPI (включая интерфейсы документации), установив переменную окружения `OPENAPI_URL` в пустую строку, например:

<div class="termy">

```console
$ OPENAPI_URL= uvicorn main:app

<span style="color: green;">INFO</span>:     Uvicorn running on http://127.0.0.1:8000 (Press CTRL+C to quit)
```

</div>

После этого, если перейти по адресам `/openapi.json`, `/docs` или `/redoc`, вы получите ошибку `404 Not Found`, например:

```JSON
{
    "detail": "Not Found"
}
```
