#[allow(non_camel_case_types)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Opcode {
  PHI,
  INLINEASM,
  INLINEASM_BR,
  CFI_INSTRUCTION,
  EH_LABEL,
  GC_LABEL,
  ANNOTATION_LABEL,
  KILL,
  EXTRACT_SUBREG,
  INSERT_SUBREG,
  IMPLICIT_DEF,
  INIT_UNDEF,
  SUBREG_TO_REG,
  COPY_TO_REGCLASS,
  DBG_VALUE,
  DBG_VALUE_LIST,
  DBG_INSTR_REF,
  DBG_PHI,
  DBG_LABEL,
  REG_SEQUENCE,
  COPY,
  BUNDLE,
  LIFETIME_START,
  LIFETIME_END,
  PSEUDO_PROBE,
  ARITH_FENCE,
  STACKMAP,
  FENTRY_CALL,
  PATCHPOINT,
  LOAD_STACK_GUARD,
  PREALLOCATED_SETUP,
  PREALLOCATED_ARG,
  STATEPOINT,
  LOCAL_ESCAPE,
  FAULTING_OP,
  PATCHABLE_OP,
  PATCHABLE_FUNCTION_ENTER,
  PATCHABLE_RET,
  PATCHABLE_FUNCTION_EXIT,
  PATCHABLE_TAIL_CALL,
  PATCHABLE_EVENT_CALL,
  PATCHABLE_TYPED_EVENT_CALL,
  ICALL_BRANCH_FUNNEL,
  FAKE_USE,
  MEMBARRIER,
  JUMP_TABLE_DEBUG_INFO,
  CONVERGENCECTRL_ENTRY,
  CONVERGENCECTRL_ANCHOR,
  CONVERGENCECTRL_LOOP,
  CONVERGENCECTRL_GLUE,
  G_ASSERT_SEXT,
  G_ASSERT_ZEXT,
  G_ASSERT_ALIGN,
  G_ADD,
  G_SUB,
  G_MUL,
  G_SDIV,
  G_UDIV,
  G_SREM,
  G_UREM,
  G_SDIVREM,
  G_UDIVREM,
  G_AND,
  G_OR,
  G_XOR,
  G_ABDS,
  G_ABDU,
  G_IMPLICIT_DEF,
  G_PHI,
  G_FRAME_INDEX,
  G_GLOBAL_VALUE,
  G_PTRAUTH_GLOBAL_VALUE,
  G_CONSTANT_POOL,
  G_EXTRACT,
  G_UNMERGE_VALUES,
  G_INSERT,
  G_MERGE_VALUES,
  G_BUILD_VECTOR,
  G_BUILD_VECTOR_TRUNC,
  G_CONCAT_VECTORS,
  G_PTRTOINT,
  G_INTTOPTR,
  G_BITCAST,
  G_FREEZE,
  G_CONSTANT_FOLD_BARRIER,
  G_INTRINSIC_FPTRUNC_ROUND,
  G_INTRINSIC_TRUNC,
  G_INTRINSIC_ROUND,
  G_INTRINSIC_LRINT,
  G_INTRINSIC_LLRINT,
  G_INTRINSIC_ROUNDEVEN,
  G_READCYCLECOUNTER,
  G_READSTEADYCOUNTER,
  G_LOAD,
  G_SEXTLOAD,
  G_ZEXTLOAD,
  G_INDEXED_LOAD,
  G_INDEXED_SEXTLOAD,
  G_INDEXED_ZEXTLOAD,
  G_STORE,
  G_INDEXED_STORE,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS,
  G_ATOMIC_CMPXCHG,
  G_ATOMICRMW_XCHG,
  G_ATOMICRMW_ADD,
  G_ATOMICRMW_SUB,
  G_ATOMICRMW_AND,
  G_ATOMICRMW_NAND,
  G_ATOMICRMW_OR,
  G_ATOMICRMW_XOR,
  G_ATOMICRMW_MAX,
  G_ATOMICRMW_MIN,
  G_ATOMICRMW_UMAX,
  G_ATOMICRMW_UMIN,
  G_ATOMICRMW_FADD,
  G_ATOMICRMW_FSUB,
  G_ATOMICRMW_FMAX,
  G_ATOMICRMW_FMIN,
  G_ATOMICRMW_FMAXIMUM,
  G_ATOMICRMW_FMINIMUM,
  G_ATOMICRMW_UINC_WRAP,
  G_ATOMICRMW_UDEC_WRAP,
  G_ATOMICRMW_USUB_COND,
  G_ATOMICRMW_USUB_SAT,
  G_FENCE,
  G_PREFETCH,
  G_BRCOND,
  G_BRINDIRECT,
  G_INVOKE_REGION_START,
  G_INTRINSIC,
  G_INTRINSIC_W_SIDE_EFFECTS,
  G_INTRINSIC_CONVERGENT,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
  G_ANYEXT,
  G_TRUNC,
  G_TRUNC_SSAT_S,
  G_TRUNC_SSAT_U,
  G_TRUNC_USAT_U,
  G_CONSTANT,
  G_FCONSTANT,
  G_VASTART,
  G_VAARG,
  G_SEXT,
  G_SEXT_INREG,
  G_ZEXT,
  G_SHL,
  G_LSHR,
  G_ASHR,
  G_FSHL,
  G_FSHR,
  G_ROTR,
  G_ROTL,
  G_ICMP,
  G_FCMP,
  G_SCMP,
  G_UCMP,
  G_SELECT,
  G_UADDO,
  G_UADDE,
  G_USUBO,
  G_USUBE,
  G_SADDO,
  G_SADDE,
  G_SSUBO,
  G_SSUBE,
  G_UMULO,
  G_SMULO,
  G_UMULH,
  G_SMULH,
  G_UADDSAT,
  G_SADDSAT,
  G_USUBSAT,
  G_SSUBSAT,
  G_USHLSAT,
  G_SSHLSAT,
  G_SMULFIX,
  G_UMULFIX,
  G_SMULFIXSAT,
  G_UMULFIXSAT,
  G_SDIVFIX,
  G_UDIVFIX,
  G_SDIVFIXSAT,
  G_UDIVFIXSAT,
  G_FADD,
  G_FSUB,
  G_FMUL,
  G_FMA,
  G_FMAD,
  G_FDIV,
  G_FREM,
  G_FPOW,
  G_FPOWI,
  G_FEXP,
  G_FEXP2,
  G_FEXP10,
  G_FLOG,
  G_FLOG2,
  G_FLOG10,
  G_FLDEXP,
  G_FFREXP,
  G_FNEG,
  G_FPEXT,
  G_FPTRUNC,
  G_FPTOSI,
  G_FPTOUI,
  G_SITOFP,
  G_UITOFP,
  G_FPTOSI_SAT,
  G_FPTOUI_SAT,
  G_FABS,
  G_FCOPYSIGN,
  G_IS_FPCLASS,
  G_FCANONICALIZE,
  G_FMINNUM,
  G_FMAXNUM,
  G_FMINNUM_IEEE,
  G_FMAXNUM_IEEE,
  G_FMINIMUM,
  G_FMAXIMUM,
  G_FMINIMUMNUM,
  G_FMAXIMUMNUM,
  G_GET_FPENV,
  G_SET_FPENV,
  G_RESET_FPENV,
  G_GET_FPMODE,
  G_SET_FPMODE,
  G_RESET_FPMODE,
  G_GET_ROUNDING,
  G_PTR_ADD,
  G_PTRMASK,
  G_SMIN,
  G_SMAX,
  G_UMIN,
  G_UMAX,
  G_ABS,
  G_LROUND,
  G_LLROUND,
  G_BR,
  G_BRJT,
  G_VSCALE,
  G_INSERT_SUBVECTOR,
  G_EXTRACT_SUBVECTOR,
  G_INSERT_VECTOR_ELT,
  G_EXTRACT_VECTOR_ELT,
  G_SHUFFLE_VECTOR,
  G_SPLAT_VECTOR,
  G_STEP_VECTOR,
  G_VECTOR_COMPRESS,
  G_CTTZ,
  G_CTTZ_ZERO_UNDEF,
  G_CTLZ,
  G_CTLZ_ZERO_UNDEF,
  G_CTPOP,
  G_BSWAP,
  G_BITREVERSE,
  G_FCEIL,
  G_FCOS,
  G_FSIN,
  G_FSINCOS,
  G_FTAN,
  G_FACOS,
  G_FASIN,
  G_FATAN,
  G_FATAN2,
  G_FCOSH,
  G_FSINH,
  G_FTANH,
  G_FSQRT,
  G_FFLOOR,
  G_FRINT,
  G_FNEARBYINT,
  G_ADDRSPACE_CAST,
  G_BLOCK_ADDR,
  G_JUMP_TABLE,
  G_DYN_STACKALLOC,
  G_STACKSAVE,
  G_STACKRESTORE,
  G_STRICT_FADD,
  G_STRICT_FSUB,
  G_STRICT_FMUL,
  G_STRICT_FDIV,
  G_STRICT_FREM,
  G_STRICT_FMA,
  G_STRICT_FSQRT,
  G_STRICT_FLDEXP,
  G_READ_REGISTER,
  G_WRITE_REGISTER,
  G_MEMCPY,
  G_MEMCPY_INLINE,
  G_MEMMOVE,
  G_MEMSET,
  G_BZERO,
  G_TRAP,
  G_DEBUGTRAP,
  G_UBSANTRAP,
  G_VECREDUCE_SEQ_FADD,
  G_VECREDUCE_SEQ_FMUL,
  G_VECREDUCE_FADD,
  G_VECREDUCE_FMUL,
  G_VECREDUCE_FMAX,
  G_VECREDUCE_FMIN,
  G_VECREDUCE_FMAXIMUM,
  G_VECREDUCE_FMINIMUM,
  G_VECREDUCE_ADD,
  G_VECREDUCE_MUL,
  G_VECREDUCE_AND,
  G_VECREDUCE_OR,
  G_VECREDUCE_XOR,
  G_VECREDUCE_SMAX,
  G_VECREDUCE_SMIN,
  G_VECREDUCE_UMAX,
  G_VECREDUCE_UMIN,
  G_SBFX,
  G_UBFX,
  ADD16ri_DB,
  ADD16rr_DB,
  ADD32ri_DB,
  ADD32rr_DB,
  ADD64ri32_DB,
  ADD64rr_DB,
  ADD8ri_DB,
  ADD8rr_DB,
  AVX1_SETALLONES,
  AVX2_SETALLONES,
  AVX512_128_SET0,
  AVX512_256_SET0,
  AVX512_512_SET0,
  AVX512_512_SETALLONES,
  AVX512_512_SEXT_MASK_32,
  AVX512_512_SEXT_MASK_64,
  AVX512_FsFLD0F128,
  AVX512_FsFLD0SD,
  AVX512_FsFLD0SH,
  AVX512_FsFLD0SS,
  AVX_SET0,
  CALL64m_RVMARKER,
  CALL64pcrel32_RVMARKER,
  CALL64r_ImpCall,
  CALL64r_RVMARKER,
  FsFLD0F128,
  FsFLD0SD,
  FsFLD0SH,
  FsFLD0SS,
  G_FILD,
  G_FIST,
  G_FNSTCW16,
  INDIRECT_THUNK_CALL32,
  INDIRECT_THUNK_CALL64,
  INDIRECT_THUNK_TCRETURN32,
  INDIRECT_THUNK_TCRETURN64,
  KSET0D,
  KSET0Q,
  KSET0W,
  KSET1D,
  KSET1Q,
  KSET1W,
  LCMPXCHG16B_NO_RBX,
  LCMPXCHG16B_SAVE_RBX,
  MMX_SET0,
  MORESTACK_RET,
  MORESTACK_RET_RESTORE_R10,
  MOV32ImmSExti8,
  MOV32r0,
  MOV32r1,
  MOV32r_1,
  MOV32ri64,
  MOV64ImmSExti8,
  MWAITX,
  MWAITX_SAVE_RBX,
  PLDTILECFGV,
  PLEA32r,
  PLEA64r,
  PT2RPNTLVWZ0RST1V,
  PT2RPNTLVWZ0RSV,
  PT2RPNTLVWZ0T1V,
  PT2RPNTLVWZ0V,
  PT2RPNTLVWZ1RST1V,
  PT2RPNTLVWZ1RSV,
  PT2RPNTLVWZ1T1V,
  PT2RPNTLVWZ1V,
  PTDPBF16PSV,
  PTDPBSSDV,
  PTDPBSUDV,
  PTDPBUSDV,
  PTDPBUUDV,
  PTDPFP16PSV,
  PTILELOADDRST1V,
  PTILELOADDRSV,
  PTILELOADDT1V,
  PTILELOADDV,
  PTILEPAIRLOAD,
  PTILEPAIRSTORE,
  PTILESTOREDV,
  PTILEZEROV,
  RDFLAGS32,
  RDFLAGS64,
  SEH_BeginEpilogue,
  SEH_EndEpilogue,
  SEH_EndPrologue,
  SEH_PushFrame,
  SEH_PushReg,
  SEH_SaveReg,
  SEH_SaveXMM,
  SEH_SetFrame,
  SEH_StackAlign,
  SEH_StackAlloc,
  SEH_UnwindV2Start,
  SEH_UnwindVersion,
  SETB_C32r,
  SETB_C64r,
  SHLDROT32ri,
  SHLDROT64ri,
  SHRDROT32ri,
  SHRDROT64ri,
  VMOVAPSZ128mr_NOVLX,
  VMOVAPSZ128rm_NOVLX,
  VMOVAPSZ256mr_NOVLX,
  VMOVAPSZ256rm_NOVLX,
  VMOVUPSZ128mr_NOVLX,
  VMOVUPSZ128rm_NOVLX,
  VMOVUPSZ256mr_NOVLX,
  VMOVUPSZ256rm_NOVLX,
  V_SET0,
  V_SETALLONES,
  WRFLAGS32,
  WRFLAGS64,
  XABORT_DEF,
  XOR32_FP,
  XOR64_FP,
  AAA,
  AAD8i8,
  AADD32mr,
  AADD32mr_EVEX,
  AADD64mr,
  AADD64mr_EVEX,
  AAM8i8,
  AAND32mr,
  AAND32mr_EVEX,
  AAND64mr,
  AAND64mr_EVEX,
  AAS,
  ABS_F,
  ABS_Fp32,
  ABS_Fp64,
  ABS_Fp80,
  ADC16i16,
  ADC16mi,
  ADC16mi8,
  ADC16mi8_EVEX,
  ADC16mi8_ND,
  ADC16mi_EVEX,
  ADC16mi_ND,
  ADC16mr,
  ADC16mr_EVEX,
  ADC16mr_ND,
  ADC16ri,
  ADC16ri8,
  ADC16ri8_EVEX,
  ADC16ri8_ND,
  ADC16ri_EVEX,
  ADC16ri_ND,
  ADC16rm,
  ADC16rm_EVEX,
  ADC16rm_ND,
  ADC16rr,
  ADC16rr_EVEX,
  ADC16rr_EVEX_REV,
  ADC16rr_ND,
  ADC16rr_ND_REV,
  ADC16rr_REV,
  ADC32i32,
  ADC32mi,
  ADC32mi8,
  ADC32mi8_EVEX,
  ADC32mi8_ND,
  ADC32mi_EVEX,
  ADC32mi_ND,
  ADC32mr,
  ADC32mr_EVEX,
  ADC32mr_ND,
  ADC32ri,
  ADC32ri8,
  ADC32ri8_EVEX,
  ADC32ri8_ND,
  ADC32ri_EVEX,
  ADC32ri_ND,
  ADC32rm,
  ADC32rm_EVEX,
  ADC32rm_ND,
  ADC32rr,
  ADC32rr_EVEX,
  ADC32rr_EVEX_REV,
  ADC32rr_ND,
  ADC32rr_ND_REV,
  ADC32rr_REV,
  ADC64i32,
  ADC64mi32,
  ADC64mi32_EVEX,
  ADC64mi32_ND,
  ADC64mi8,
  ADC64mi8_EVEX,
  ADC64mi8_ND,
  ADC64mr,
  ADC64mr_EVEX,
  ADC64mr_ND,
  ADC64ri32,
  ADC64ri32_EVEX,
  ADC64ri32_ND,
  ADC64ri8,
  ADC64ri8_EVEX,
  ADC64ri8_ND,
  ADC64rm,
  ADC64rm_EVEX,
  ADC64rm_ND,
  ADC64rr,
  ADC64rr_EVEX,
  ADC64rr_EVEX_REV,
  ADC64rr_ND,
  ADC64rr_ND_REV,
  ADC64rr_REV,
  ADC8i8,
  ADC8mi,
  ADC8mi8,
  ADC8mi_EVEX,
  ADC8mi_ND,
  ADC8mr,
  ADC8mr_EVEX,
  ADC8mr_ND,
  ADC8ri,
  ADC8ri8,
  ADC8ri_EVEX,
  ADC8ri_ND,
  ADC8rm,
  ADC8rm_EVEX,
  ADC8rm_ND,
  ADC8rr,
  ADC8rr_EVEX,
  ADC8rr_EVEX_REV,
  ADC8rr_ND,
  ADC8rr_ND_REV,
  ADC8rr_REV,
  ADCX32rm,
  ADCX32rm_EVEX,
  ADCX32rm_ND,
  ADCX32rr,
  ADCX32rr_EVEX,
  ADCX32rr_ND,
  ADCX64rm,
  ADCX64rm_EVEX,
  ADCX64rm_ND,
  ADCX64rr,
  ADCX64rr_EVEX,
  ADCX64rr_ND,
  ADD16i16,
  ADD16mi,
  ADD16mi8,
  ADD16mi8_EVEX,
  ADD16mi8_ND,
  ADD16mi8_NF,
  ADD16mi8_NF_ND,
  ADD16mi_EVEX,
  ADD16mi_ND,
  ADD16mi_NF,
  ADD16mi_NF_ND,
  ADD16mr,
  ADD16mr_EVEX,
  ADD16mr_ND,
  ADD16mr_NF,
  ADD16mr_NF_ND,
  ADD16ri,
  ADD16ri8,
  ADD16ri8_EVEX,
  ADD16ri8_ND,
  ADD16ri8_NF,
  ADD16ri8_NF_ND,
  ADD16ri_EVEX,
  ADD16ri_ND,
  ADD16ri_NF,
  ADD16ri_NF_ND,
  ADD16rm,
  ADD16rm_EVEX,
  ADD16rm_ND,
  ADD16rm_NF,
  ADD16rm_NF_ND,
  ADD16rr,
  ADD16rr_EVEX,
  ADD16rr_EVEX_REV,
  ADD16rr_ND,
  ADD16rr_ND_REV,
  ADD16rr_NF,
  ADD16rr_NF_ND,
  ADD16rr_NF_ND_REV,
  ADD16rr_NF_REV,
  ADD16rr_REV,
  ADD32i32,
  ADD32mi,
  ADD32mi8,
  ADD32mi8_EVEX,
  ADD32mi8_ND,
  ADD32mi8_NF,
  ADD32mi8_NF_ND,
  ADD32mi_EVEX,
  ADD32mi_ND,
  ADD32mi_NF,
  ADD32mi_NF_ND,
  ADD32mr,
  ADD32mr_EVEX,
  ADD32mr_ND,
  ADD32mr_NF,
  ADD32mr_NF_ND,
  ADD32ri,
  ADD32ri8,
  ADD32ri8_EVEX,
  ADD32ri8_ND,
  ADD32ri8_NF,
  ADD32ri8_NF_ND,
  ADD32ri_EVEX,
  ADD32ri_ND,
  ADD32ri_NF,
  ADD32ri_NF_ND,
  ADD32rm,
  ADD32rm_EVEX,
  ADD32rm_ND,
  ADD32rm_NF,
  ADD32rm_NF_ND,
  ADD32rr,
  ADD32rr_EVEX,
  ADD32rr_EVEX_REV,
  ADD32rr_ND,
  ADD32rr_ND_REV,
  ADD32rr_NF,
  ADD32rr_NF_ND,
  ADD32rr_NF_ND_REV,
  ADD32rr_NF_REV,
  ADD32rr_REV,
  ADD64i32,
  ADD64mi32,
  ADD64mi32_EVEX,
  ADD64mi32_ND,
  ADD64mi32_NF,
  ADD64mi32_NF_ND,
  ADD64mi8,
  ADD64mi8_EVEX,
  ADD64mi8_ND,
  ADD64mi8_NF,
  ADD64mi8_NF_ND,
  ADD64mr,
  ADD64mr_EVEX,
  ADD64mr_ND,
  ADD64mr_NF,
  ADD64mr_NF_ND,
  ADD64ri32,
  ADD64ri32_EVEX,
  ADD64ri32_ND,
  ADD64ri32_NF,
  ADD64ri32_NF_ND,
  ADD64ri8,
  ADD64ri8_EVEX,
  ADD64ri8_ND,
  ADD64ri8_NF,
  ADD64ri8_NF_ND,
  ADD64rm,
  ADD64rm_EVEX,
  ADD64rm_ND,
  ADD64rm_NF,
  ADD64rm_NF_ND,
  ADD64rr,
  ADD64rr_EVEX,
  ADD64rr_EVEX_REV,
  ADD64rr_ND,
  ADD64rr_ND_REV,
  ADD64rr_NF,
  ADD64rr_NF_ND,
  ADD64rr_NF_ND_REV,
  ADD64rr_NF_REV,
  ADD64rr_REV,
  ADD8i8,
  ADD8mi,
  ADD8mi8,
  ADD8mi_EVEX,
  ADD8mi_ND,
  ADD8mi_NF,
  ADD8mi_NF_ND,
  ADD8mr,
  ADD8mr_EVEX,
  ADD8mr_ND,
  ADD8mr_NF,
  ADD8mr_NF_ND,
  ADD8ri,
  ADD8ri8,
  ADD8ri_EVEX,
  ADD8ri_ND,
  ADD8ri_NF,
  ADD8ri_NF_ND,
  ADD8rm,
  ADD8rm_EVEX,
  ADD8rm_ND,
  ADD8rm_NF,
  ADD8rm_NF_ND,
  ADD8rr,
  ADD8rr_EVEX,
  ADD8rr_EVEX_REV,
  ADD8rr_ND,
  ADD8rr_ND_REV,
  ADD8rr_NF,
  ADD8rr_NF_ND,
  ADD8rr_NF_ND_REV,
  ADD8rr_NF_REV,
  ADD8rr_REV,
  ADDPDrm,
  ADDPDrr,
  ADDPSrm,
  ADDPSrr,
  ADDR16_PREFIX,
  ADDR32_PREFIX,
  ADDSDrm,
  ADDSDrm_Int,
  ADDSDrr,
  ADDSDrr_Int,
  ADDSSrm,
  ADDSSrm_Int,
  ADDSSrr,
  ADDSSrr_Int,
  ADDSUBPDrm,
  ADDSUBPDrr,
  ADDSUBPSrm,
  ADDSUBPSrr,
  ADD_F32m,
  ADD_F64m,
  ADD_FI16m,
  ADD_FI32m,
  ADD_FPrST0,
  ADD_FST0r,
  ADD_Fp32,
  ADD_Fp32m,
  ADD_Fp64,
  ADD_Fp64m,
  ADD_Fp64m32,
  ADD_Fp80,
  ADD_Fp80m32,
  ADD_Fp80m64,
  ADD_FpI16m32,
  ADD_FpI16m64,
  ADD_FpI16m80,
  ADD_FpI32m32,
  ADD_FpI32m64,
  ADD_FpI32m80,
  ADD_FrST0,
  ADJCALLSTACKDOWN32,
  ADJCALLSTACKDOWN64,
  ADJCALLSTACKUP32,
  ADJCALLSTACKUP64,
  ADOX32rm,
  ADOX32rm_EVEX,
  ADOX32rm_ND,
  ADOX32rr,
  ADOX32rr_EVEX,
  ADOX32rr_ND,
  ADOX64rm,
  ADOX64rm_EVEX,
  ADOX64rm_ND,
  ADOX64rr,
  ADOX64rr_EVEX,
  ADOX64rr_ND,
  AESDEC128KL,
  AESDEC256KL,
  AESDECLASTrm,
  AESDECLASTrr,
  AESDECWIDE128KL,
  AESDECWIDE256KL,
  AESDECrm,
  AESDECrr,
  AESENC128KL,
  AESENC256KL,
  AESENCLASTrm,
  AESENCLASTrr,
  AESENCWIDE128KL,
  AESENCWIDE256KL,
  AESENCrm,
  AESENCrr,
  AESIMCrm,
  AESIMCrr,
  AESKEYGENASSIST128rm,
  AESKEYGENASSIST128rr,
  AND16i16,
  AND16mi,
  AND16mi8,
  AND16mi8_EVEX,
  AND16mi8_ND,
  AND16mi8_NF,
  AND16mi8_NF_ND,
  AND16mi_EVEX,
  AND16mi_ND,
  AND16mi_NF,
  AND16mi_NF_ND,
  AND16mr,
  AND16mr_EVEX,
  AND16mr_ND,
  AND16mr_NF,
  AND16mr_NF_ND,
  AND16ri,
  AND16ri8,
  AND16ri8_EVEX,
  AND16ri8_ND,
  AND16ri8_NF,
  AND16ri8_NF_ND,
  AND16ri_EVEX,
  AND16ri_ND,
  AND16ri_NF,
  AND16ri_NF_ND,
  AND16rm,
  AND16rm_EVEX,
  AND16rm_ND,
  AND16rm_NF,
  AND16rm_NF_ND,
  AND16rr,
  AND16rr_EVEX,
  AND16rr_EVEX_REV,
  AND16rr_ND,
  AND16rr_ND_REV,
  AND16rr_NF,
  AND16rr_NF_ND,
  AND16rr_NF_ND_REV,
  AND16rr_NF_REV,
  AND16rr_REV,
  AND32i32,
  AND32mi,
  AND32mi8,
  AND32mi8_EVEX,
  AND32mi8_ND,
  AND32mi8_NF,
  AND32mi8_NF_ND,
  AND32mi_EVEX,
  AND32mi_ND,
  AND32mi_NF,
  AND32mi_NF_ND,
  AND32mr,
  AND32mr_EVEX,
  AND32mr_ND,
  AND32mr_NF,
  AND32mr_NF_ND,
  AND32ri,
  AND32ri8,
  AND32ri8_EVEX,
  AND32ri8_ND,
  AND32ri8_NF,
  AND32ri8_NF_ND,
  AND32ri_EVEX,
  AND32ri_ND,
  AND32ri_NF,
  AND32ri_NF_ND,
  AND32rm,
  AND32rm_EVEX,
  AND32rm_ND,
  AND32rm_NF,
  AND32rm_NF_ND,
  AND32rr,
  AND32rr_EVEX,
  AND32rr_EVEX_REV,
  AND32rr_ND,
  AND32rr_ND_REV,
  AND32rr_NF,
  AND32rr_NF_ND,
  AND32rr_NF_ND_REV,
  AND32rr_NF_REV,
  AND32rr_REV,
  AND64i32,
  AND64mi32,
  AND64mi32_EVEX,
  AND64mi32_ND,
  AND64mi32_NF,
  AND64mi32_NF_ND,
  AND64mi8,
  AND64mi8_EVEX,
  AND64mi8_ND,
  AND64mi8_NF,
  AND64mi8_NF_ND,
  AND64mr,
  AND64mr_EVEX,
  AND64mr_ND,
  AND64mr_NF,
  AND64mr_NF_ND,
  AND64ri32,
  AND64ri32_EVEX,
  AND64ri32_ND,
  AND64ri32_NF,
  AND64ri32_NF_ND,
  AND64ri8,
  AND64ri8_EVEX,
  AND64ri8_ND,
  AND64ri8_NF,
  AND64ri8_NF_ND,
  AND64rm,
  AND64rm_EVEX,
  AND64rm_ND,
  AND64rm_NF,
  AND64rm_NF_ND,
  AND64rr,
  AND64rr_EVEX,
  AND64rr_EVEX_REV,
  AND64rr_ND,
  AND64rr_ND_REV,
  AND64rr_NF,
  AND64rr_NF_ND,
  AND64rr_NF_ND_REV,
  AND64rr_NF_REV,
  AND64rr_REV,
  AND8i8,
  AND8mi,
  AND8mi8,
  AND8mi_EVEX,
  AND8mi_ND,
  AND8mi_NF,
  AND8mi_NF_ND,
  AND8mr,
  AND8mr_EVEX,
  AND8mr_ND,
  AND8mr_NF,
  AND8mr_NF_ND,
  AND8ri,
  AND8ri8,
  AND8ri_EVEX,
  AND8ri_ND,
  AND8ri_NF,
  AND8ri_NF_ND,
  AND8rm,
  AND8rm_EVEX,
  AND8rm_ND,
  AND8rm_NF,
  AND8rm_NF_ND,
  AND8rr,
  AND8rr_EVEX,
  AND8rr_EVEX_REV,
  AND8rr_ND,
  AND8rr_ND_REV,
  AND8rr_NF,
  AND8rr_NF_ND,
  AND8rr_NF_ND_REV,
  AND8rr_NF_REV,
  AND8rr_REV,
  ANDN32rm,
  ANDN32rm_EVEX,
  ANDN32rm_NF,
  ANDN32rr,
  ANDN32rr_EVEX,
  ANDN32rr_NF,
  ANDN64rm,
  ANDN64rm_EVEX,
  ANDN64rm_NF,
  ANDN64rr,
  ANDN64rr_EVEX,
  ANDN64rr_NF,
  ANDNPDrm,
  ANDNPDrr,
  ANDNPSrm,
  ANDNPSrr,
  ANDPDrm,
  ANDPDrr,
  ANDPSrm,
  ANDPSrr,
  AOR32mr,
  AOR32mr_EVEX,
  AOR64mr,
  AOR64mr_EVEX,
  ARPL16mr,
  ARPL16rr,
  ASAN_CHECK_MEMACCESS,
  AXOR32mr,
  AXOR32mr_EVEX,
  AXOR64mr,
  AXOR64mr_EVEX,
  BEXTR32rm,
  BEXTR32rm_EVEX,
  BEXTR32rm_NF,
  BEXTR32rr,
  BEXTR32rr_EVEX,
  BEXTR32rr_NF,
  BEXTR64rm,
  BEXTR64rm_EVEX,
  BEXTR64rm_NF,
  BEXTR64rr,
  BEXTR64rr_EVEX,
  BEXTR64rr_NF,
  BEXTRI32mi,
  BEXTRI32ri,
  BEXTRI64mi,
  BEXTRI64ri,
  BLCFILL32rm,
  BLCFILL32rr,
  BLCFILL64rm,
  BLCFILL64rr,
  BLCI32rm,
  BLCI32rr,
  BLCI64rm,
  BLCI64rr,
  BLCIC32rm,
  BLCIC32rr,
  BLCIC64rm,
  BLCIC64rr,
  BLCMSK32rm,
  BLCMSK32rr,
  BLCMSK64rm,
  BLCMSK64rr,
  BLCS32rm,
  BLCS32rr,
  BLCS64rm,
  BLCS64rr,
  BLENDPDrmi,
  BLENDPDrri,
  BLENDPSrmi,
  BLENDPSrri,
  BLENDVPDrm0,
  BLENDVPDrr0,
  BLENDVPSrm0,
  BLENDVPSrr0,
  BLSFILL32rm,
  BLSFILL32rr,
  BLSFILL64rm,
  BLSFILL64rr,
  BLSI32rm,
  BLSI32rm_EVEX,
  BLSI32rm_NF,
  BLSI32rr,
  BLSI32rr_EVEX,
  BLSI32rr_NF,
  BLSI64rm,
  BLSI64rm_EVEX,
  BLSI64rm_NF,
  BLSI64rr,
  BLSI64rr_EVEX,
  BLSI64rr_NF,
  BLSIC32rm,
  BLSIC32rr,
  BLSIC64rm,
  BLSIC64rr,
  BLSMSK32rm,
  BLSMSK32rm_EVEX,
  BLSMSK32rm_NF,
  BLSMSK32rr,
  BLSMSK32rr_EVEX,
  BLSMSK32rr_NF,
  BLSMSK64rm,
  BLSMSK64rm_EVEX,
  BLSMSK64rm_NF,
  BLSMSK64rr,
  BLSMSK64rr_EVEX,
  BLSMSK64rr_NF,
  BLSR32rm,
  BLSR32rm_EVEX,
  BLSR32rm_NF,
  BLSR32rr,
  BLSR32rr_EVEX,
  BLSR32rr_NF,
  BLSR64rm,
  BLSR64rm_EVEX,
  BLSR64rm_NF,
  BLSR64rr,
  BLSR64rr_EVEX,
  BLSR64rr_NF,
  BOUNDS16rm,
  BOUNDS32rm,
  BSF16rm,
  BSF16rr,
  BSF32rm,
  BSF32rr,
  BSF64rm,
  BSF64rr,
  BSR16rm,
  BSR16rr,
  BSR32rm,
  BSR32rr,
  BSR64rm,
  BSR64rr,
  BSWAP16r_BAD,
  BSWAP32r,
  BSWAP64r,
  BT16mi8,
  BT16mr,
  BT16ri8,
  BT16rr,
  BT32mi8,
  BT32mr,
  BT32ri8,
  BT32rr,
  BT64mi8,
  BT64mr,
  BT64ri8,
  BT64rr,
  BTC16mi8,
  BTC16mr,
  BTC16ri8,
  BTC16rr,
  BTC32mi8,
  BTC32mr,
  BTC32ri8,
  BTC32rr,
  BTC64mi8,
  BTC64mr,
  BTC64ri8,
  BTC64rr,
  BTR16mi8,
  BTR16mr,
  BTR16ri8,
  BTR16rr,
  BTR32mi8,
  BTR32mr,
  BTR32ri8,
  BTR32rr,
  BTR64mi8,
  BTR64mr,
  BTR64ri8,
  BTR64rr,
  BTS16mi8,
  BTS16mr,
  BTS16ri8,
  BTS16rr,
  BTS32mi8,
  BTS32mr,
  BTS32ri8,
  BTS32rr,
  BTS64mi8,
  BTS64mr,
  BTS64ri8,
  BTS64rr,
  BZHI32rm,
  BZHI32rm_EVEX,
  BZHI32rm_NF,
  BZHI32rr,
  BZHI32rr_EVEX,
  BZHI32rr_NF,
  BZHI64rm,
  BZHI64rm_EVEX,
  BZHI64rm_NF,
  BZHI64rr,
  BZHI64rr_EVEX,
  BZHI64rr_NF,
  CALL16m,
  CALL16m_NT,
  CALL16r,
  CALL16r_NT,
  CALL32m,
  CALL32m_NT,
  CALL32r,
  CALL32r_NT,
  CALL64m,
  CALL64m_NT,
  CALL64pcrel32,
  CALL64r,
  CALL64r_NT,
  CALLpcrel16,
  CALLpcrel32,
  CATCHRET,
  CBW,
  CCMP16mi,
  CCMP16mi8,
  CCMP16mr,
  CCMP16ri,
  CCMP16ri8,
  CCMP16rm,
  CCMP16rr,
  CCMP16rr_REV,
  CCMP32mi,
  CCMP32mi8,
  CCMP32mr,
  CCMP32ri,
  CCMP32ri8,
  CCMP32rm,
  CCMP32rr,
  CCMP32rr_REV,
  CCMP64mi32,
  CCMP64mi8,
  CCMP64mr,
  CCMP64ri32,
  CCMP64ri8,
  CCMP64rm,
  CCMP64rr,
  CCMP64rr_REV,
  CCMP8mi,
  CCMP8mr,
  CCMP8ri,
  CCMP8rm,
  CCMP8rr,
  CCMP8rr_REV,
  CDQ,
  CDQE,
  CFCMOV16mr,
  CFCMOV16rm,
  CFCMOV16rm_ND,
  CFCMOV16rr,
  CFCMOV16rr_ND,
  CFCMOV16rr_REV,
  CFCMOV32mr,
  CFCMOV32rm,
  CFCMOV32rm_ND,
  CFCMOV32rr,
  CFCMOV32rr_ND,
  CFCMOV32rr_REV,
  CFCMOV64mr,
  CFCMOV64rm,
  CFCMOV64rm_ND,
  CFCMOV64rr,
  CFCMOV64rr_ND,
  CFCMOV64rr_REV,
  CHS_F,
  CHS_Fp32,
  CHS_Fp64,
  CHS_Fp80,
  CLAC,
  CLC,
  CLD,
  CLDEMOTE,
  CLEANUPRET,
  CLFLUSH,
  CLFLUSHOPT,
  CLGI,
  CLI,
  CLRSSBSY,
  CLTS,
  CLUI,
  CLWB,
  CLZERO32r,
  CLZERO64r,
  CMC,
  CMOV16rm,
  CMOV16rm_ND,
  CMOV16rr,
  CMOV16rr_ND,
  CMOV32rm,
  CMOV32rm_ND,
  CMOV32rr,
  CMOV32rr_ND,
  CMOV64rm,
  CMOV64rm_ND,
  CMOV64rr,
  CMOV64rr_ND,
  CMOVBE_F,
  CMOVBE_Fp32,
  CMOVBE_Fp64,
  CMOVBE_Fp80,
  CMOVB_F,
  CMOVB_Fp32,
  CMOVB_Fp64,
  CMOVB_Fp80,
  CMOVE_F,
  CMOVE_Fp32,
  CMOVE_Fp64,
  CMOVE_Fp80,
  CMOVNBE_F,
  CMOVNBE_Fp32,
  CMOVNBE_Fp64,
  CMOVNBE_Fp80,
  CMOVNB_F,
  CMOVNB_Fp32,
  CMOVNB_Fp64,
  CMOVNB_Fp80,
  CMOVNE_F,
  CMOVNE_Fp32,
  CMOVNE_Fp64,
  CMOVNE_Fp80,
  CMOVNP_F,
  CMOVNP_Fp32,
  CMOVNP_Fp64,
  CMOVNP_Fp80,
  CMOVP_F,
  CMOVP_Fp32,
  CMOVP_Fp64,
  CMOVP_Fp80,
  CMOV_FR16,
  CMOV_FR16X,
  CMOV_FR32,
  CMOV_FR32X,
  CMOV_FR64,
  CMOV_FR64X,
  CMOV_GR16,
  CMOV_GR32,
  CMOV_GR8,
  CMOV_RFP32,
  CMOV_RFP64,
  CMOV_RFP80,
  CMOV_VK1,
  CMOV_VK16,
  CMOV_VK2,
  CMOV_VK32,
  CMOV_VK4,
  CMOV_VK64,
  CMOV_VK8,
  CMOV_VR128,
  CMOV_VR128X,
  CMOV_VR256,
  CMOV_VR256X,
  CMOV_VR512,
  CMOV_VR64,
  CMP16i16,
  CMP16mi,
  CMP16mi8,
  CMP16mr,
  CMP16ri,
  CMP16ri8,
  CMP16rm,
  CMP16rr,
  CMP16rr_REV,
  CMP32i32,
  CMP32mi,
  CMP32mi8,
  CMP32mr,
  CMP32ri,
  CMP32ri8,
  CMP32rm,
  CMP32rr,
  CMP32rr_REV,
  CMP64i32,
  CMP64mi32,
  CMP64mi8,
  CMP64mr,
  CMP64ri32,
  CMP64ri8,
  CMP64rm,
  CMP64rr,
  CMP64rr_REV,
  CMP8i8,
  CMP8mi,
  CMP8mi8,
  CMP8mr,
  CMP8ri,
  CMP8ri8,
  CMP8rm,
  CMP8rr,
  CMP8rr_REV,
  CMPCCXADDmr32,
  CMPCCXADDmr32_EVEX,
  CMPCCXADDmr64,
  CMPCCXADDmr64_EVEX,
  CMPPDrmi,
  CMPPDrri,
  CMPPSrmi,
  CMPPSrri,
  CMPSB,
  CMPSDrmi,
  CMPSDrmi_Int,
  CMPSDrri,
  CMPSDrri_Int,
  CMPSL,
  CMPSQ,
  CMPSSrmi,
  CMPSSrmi_Int,
  CMPSSrri,
  CMPSSrri_Int,
  CMPSW,
  CMPXCHG16B,
  CMPXCHG16rm,
  CMPXCHG16rr,
  CMPXCHG32rm,
  CMPXCHG32rr,
  CMPXCHG64rm,
  CMPXCHG64rr,
  CMPXCHG8B,
  CMPXCHG8rm,
  CMPXCHG8rr,
  COMISDrm,
  COMISDrm_Int,
  COMISDrr,
  COMISDrr_Int,
  COMISSrm,
  COMISSrm_Int,
  COMISSrr,
  COMISSrr_Int,
  COMP_FST0r,
  COM_FIPr,
  COM_FIr,
  COM_FST0r,
  COM_FpIr32,
  COM_FpIr64,
  COM_FpIr80,
  COM_Fpr32,
  COM_Fpr64,
  COM_Fpr80,
  CPUID,
  CQO,
  CRC32r32m16,
  CRC32r32m16_EVEX,
  CRC32r32m32,
  CRC32r32m32_EVEX,
  CRC32r32m8,
  CRC32r32m8_EVEX,
  CRC32r32r16,
  CRC32r32r16_EVEX,
  CRC32r32r32,
  CRC32r32r32_EVEX,
  CRC32r32r8,
  CRC32r32r8_EVEX,
  CRC32r64m64,
  CRC32r64m64_EVEX,
  CRC32r64m8,
  CRC32r64m8_EVEX,
  CRC32r64r64,
  CRC32r64r64_EVEX,
  CRC32r64r8,
  CRC32r64r8_EVEX,
  CS_PREFIX,
  CTEST16mi,
  CTEST16mr,
  CTEST16ri,
  CTEST16rr,
  CTEST32mi,
  CTEST32mr,
  CTEST32ri,
  CTEST32rr,
  CTEST64mi32,
  CTEST64mr,
  CTEST64ri32,
  CTEST64rr,
  CTEST8mi,
  CTEST8mr,
  CTEST8ri,
  CTEST8rr,
  CVTDQ2PDrm,
  CVTDQ2PDrr,
  CVTDQ2PSrm,
  CVTDQ2PSrr,
  CVTPD2DQrm,
  CVTPD2DQrr,
  CVTPD2PSrm,
  CVTPD2PSrr,
  CVTPS2DQrm,
  CVTPS2DQrr,
  CVTPS2PDrm,
  CVTPS2PDrr,
  CVTSD2SI64rm,
  CVTSD2SI64rm_Int,
  CVTSD2SI64rr,
  CVTSD2SI64rr_Int,
  CVTSD2SIrm,
  CVTSD2SIrm_Int,
  CVTSD2SIrr,
  CVTSD2SIrr_Int,
  CVTSD2SSrm,
  CVTSD2SSrm_Int,
  CVTSD2SSrr,
  CVTSD2SSrr_Int,
  CVTSI2SDrm,
  CVTSI2SDrm_Int,
  CVTSI2SDrr,
  CVTSI2SDrr_Int,
  CVTSI2SSrm,
  CVTSI2SSrm_Int,
  CVTSI2SSrr,
  CVTSI2SSrr_Int,
  CVTSI642SDrm,
  CVTSI642SDrm_Int,
  CVTSI642SDrr,
  CVTSI642SDrr_Int,
  CVTSI642SSrm,
  CVTSI642SSrm_Int,
  CVTSI642SSrr,
  CVTSI642SSrr_Int,
  CVTSS2SDrm,
  CVTSS2SDrm_Int,
  CVTSS2SDrr,
  CVTSS2SDrr_Int,
  CVTSS2SI64rm,
  CVTSS2SI64rm_Int,
  CVTSS2SI64rr,
  CVTSS2SI64rr_Int,
  CVTSS2SIrm,
  CVTSS2SIrm_Int,
  CVTSS2SIrr,
  CVTSS2SIrr_Int,
  CVTTPD2DQrm,
  CVTTPD2DQrr,
  CVTTPS2DQrm,
  CVTTPS2DQrr,
  CVTTSD2SI64rm,
  CVTTSD2SI64rm_Int,
  CVTTSD2SI64rr,
  CVTTSD2SI64rr_Int,
  CVTTSD2SIrm,
  CVTTSD2SIrm_Int,
  CVTTSD2SIrr,
  CVTTSD2SIrr_Int,
  CVTTSS2SI64rm,
  CVTTSS2SI64rm_Int,
  CVTTSS2SI64rr,
  CVTTSS2SI64rr_Int,
  CVTTSS2SIrm,
  CVTTSS2SIrm_Int,
  CVTTSS2SIrr,
  CVTTSS2SIrr_Int,
  CWD,
  CWDE,
  DAA,
  DAS,
  DATA16_PREFIX,
  DEC16m,
  DEC16m_EVEX,
  DEC16m_ND,
  DEC16m_NF,
  DEC16m_NF_ND,
  DEC16r,
  DEC16r_EVEX,
  DEC16r_ND,
  DEC16r_NF,
  DEC16r_NF_ND,
  DEC16r_alt,
  DEC32m,
  DEC32m_EVEX,
  DEC32m_ND,
  DEC32m_NF,
  DEC32m_NF_ND,
  DEC32r,
  DEC32r_EVEX,
  DEC32r_ND,
  DEC32r_NF,
  DEC32r_NF_ND,
  DEC32r_alt,
  DEC64m,
  DEC64m_EVEX,
  DEC64m_ND,
  DEC64m_NF,
  DEC64m_NF_ND,
  DEC64r,
  DEC64r_EVEX,
  DEC64r_ND,
  DEC64r_NF,
  DEC64r_NF_ND,
  DEC8m,
  DEC8m_EVEX,
  DEC8m_ND,
  DEC8m_NF,
  DEC8m_NF_ND,
  DEC8r,
  DEC8r_EVEX,
  DEC8r_ND,
  DEC8r_NF,
  DEC8r_NF_ND,
  DIV16m,
  DIV16m_EVEX,
  DIV16m_NF,
  DIV16r,
  DIV16r_EVEX,
  DIV16r_NF,
  DIV32m,
  DIV32m_EVEX,
  DIV32m_NF,
  DIV32r,
  DIV32r_EVEX,
  DIV32r_NF,
  DIV64m,
  DIV64m_EVEX,
  DIV64m_NF,
  DIV64r,
  DIV64r_EVEX,
  DIV64r_NF,
  DIV8m,
  DIV8m_EVEX,
  DIV8m_NF,
  DIV8r,
  DIV8r_EVEX,
  DIV8r_NF,
  DIVPDrm,
  DIVPDrr,
  DIVPSrm,
  DIVPSrr,
  DIVR_F32m,
  DIVR_F64m,
  DIVR_FI16m,
  DIVR_FI32m,
  DIVR_FPrST0,
  DIVR_FST0r,
  DIVR_Fp32m,
  DIVR_Fp64m,
  DIVR_Fp64m32,
  DIVR_Fp80m32,
  DIVR_Fp80m64,
  DIVR_FpI16m32,
  DIVR_FpI16m64,
  DIVR_FpI16m80,
  DIVR_FpI32m32,
  DIVR_FpI32m64,
  DIVR_FpI32m80,
  DIVR_FrST0,
  DIVSDrm,
  DIVSDrm_Int,
  DIVSDrr,
  DIVSDrr_Int,
  DIVSSrm,
  DIVSSrm_Int,
  DIVSSrr,
  DIVSSrr_Int,
  DIV_F32m,
  DIV_F64m,
  DIV_FI16m,
  DIV_FI32m,
  DIV_FPrST0,
  DIV_FST0r,
  DIV_Fp32,
  DIV_Fp32m,
  DIV_Fp64,
  DIV_Fp64m,
  DIV_Fp64m32,
  DIV_Fp80,
  DIV_Fp80m32,
  DIV_Fp80m64,
  DIV_FpI16m32,
  DIV_FpI16m64,
  DIV_FpI16m80,
  DIV_FpI32m32,
  DIV_FpI32m64,
  DIV_FpI32m80,
  DIV_FrST0,
  DPPDrmi,
  DPPDrri,
  DPPSrmi,
  DPPSrri,
  DS_PREFIX,
  DYN_ALLOCA_32,
  DYN_ALLOCA_64,
  EH_RETURN,
  EH_RETURN64,
  EH_SjLj_LongJmp32,
  EH_SjLj_LongJmp64,
  EH_SjLj_SetJmp32,
  EH_SjLj_SetJmp64,
  EH_SjLj_Setup,
  ENCLS,
  ENCLU,
  ENCLV,
  ENCODEKEY128,
  ENCODEKEY256,
  ENDBR32,
  ENDBR64,
  ENQCMD16,
  ENQCMD32,
  ENQCMD32_EVEX,
  ENQCMD64,
  ENQCMD64_EVEX,
  ENQCMDS16,
  ENQCMDS32,
  ENQCMDS32_EVEX,
  ENQCMDS64,
  ENQCMDS64_EVEX,
  ENTER,
  ERETS,
  ERETU,
  ES_PREFIX,
  EXTRACTPSmri,
  EXTRACTPSrri,
  EXTRQ,
  EXTRQI,
  F2XM1,
  FARCALL16i,
  FARCALL16m,
  FARCALL32i,
  FARCALL32m,
  FARCALL64m,
  FARJMP16i,
  FARJMP16m,
  FARJMP32i,
  FARJMP32m,
  FARJMP64m,
  FBLDm,
  FBSTPm,
  FCOM32m,
  FCOM64m,
  FCOMP32m,
  FCOMP64m,
  FCOMPP,
  FCOS,
  FDECSTP,
  FEMMS,
  FFREE,
  FFREEP,
  FICOM16m,
  FICOM32m,
  FICOMP16m,
  FICOMP32m,
  FINCSTP,
  FLDCW16m,
  FLDENVm,
  FLDL2E,
  FLDL2T,
  FLDLG2,
  FLDLN2,
  FLDPI,
  FNCLEX,
  FNINIT,
  FNOP,
  FNSTCW16m,
  FNSTSW16r,
  FNSTSWm,
  FP32_TO_INT16_IN_MEM,
  FP32_TO_INT32_IN_MEM,
  FP32_TO_INT64_IN_MEM,
  FP64_TO_INT16_IN_MEM,
  FP64_TO_INT32_IN_MEM,
  FP64_TO_INT64_IN_MEM,
  FP80_ADDm32,
  FP80_ADDr,
  FP80_TO_INT16_IN_MEM,
  FP80_TO_INT32_IN_MEM,
  FP80_TO_INT64_IN_MEM,
  FPATAN,
  FPREM,
  FPREM1,
  FPTAN,
  FRNDINT,
  FRSTORm,
  FSAVEm,
  FSCALE,
  FSIN,
  FSINCOS,
  FSTENVm,
  FS_PREFIX,
  FXRSTOR,
  FXRSTOR64,
  FXSAVE,
  FXSAVE64,
  FXTRACT,
  FYL2X,
  FYL2XP1,
  GETSEC,
  GF2P8AFFINEINVQBrmi,
  GF2P8AFFINEINVQBrri,
  GF2P8AFFINEQBrmi,
  GF2P8AFFINEQBrri,
  GF2P8MULBrm,
  GF2P8MULBrr,
  GS_PREFIX,
  HADDPDrm,
  HADDPDrr,
  HADDPSrm,
  HADDPSrr,
  HLT,
  HRESET,
  HSUBPDrm,
  HSUBPDrr,
  HSUBPSrm,
  HSUBPSrr,
  IDIV16m,
  IDIV16m_EVEX,
  IDIV16m_NF,
  IDIV16r,
  IDIV16r_EVEX,
  IDIV16r_NF,
  IDIV32m,
  IDIV32m_EVEX,
  IDIV32m_NF,
  IDIV32r,
  IDIV32r_EVEX,
  IDIV32r_NF,
  IDIV64m,
  IDIV64m_EVEX,
  IDIV64m_NF,
  IDIV64r,
  IDIV64r_EVEX,
  IDIV64r_NF,
  IDIV8m,
  IDIV8m_EVEX,
  IDIV8m_NF,
  IDIV8r,
  IDIV8r_EVEX,
  IDIV8r_NF,
  ILD_F16m,
  ILD_F32m,
  ILD_F64m,
  ILD_Fp16m32,
  ILD_Fp16m64,
  ILD_Fp16m80,
  ILD_Fp32m32,
  ILD_Fp32m64,
  ILD_Fp32m80,
  ILD_Fp64m32,
  ILD_Fp64m64,
  ILD_Fp64m80,
  IMUL16m,
  IMUL16m_EVEX,
  IMUL16m_NF,
  IMUL16r,
  IMUL16r_EVEX,
  IMUL16r_NF,
  IMUL16rm,
  IMUL16rm_EVEX,
  IMUL16rm_ND,
  IMUL16rm_NF,
  IMUL16rm_NF_ND,
  IMUL16rmi,
  IMUL16rmi8,
  IMUL16rmi8_EVEX,
  IMUL16rmi8_NF,
  IMUL16rmi_EVEX,
  IMUL16rmi_NF,
  IMUL16rr,
  IMUL16rr_EVEX,
  IMUL16rr_ND,
  IMUL16rr_NF,
  IMUL16rr_NF_ND,
  IMUL16rri,
  IMUL16rri8,
  IMUL16rri8_EVEX,
  IMUL16rri8_NF,
  IMUL16rri_EVEX,
  IMUL16rri_NF,
  IMUL32m,
  IMUL32m_EVEX,
  IMUL32m_NF,
  IMUL32r,
  IMUL32r_EVEX,
  IMUL32r_NF,
  IMUL32rm,
  IMUL32rm_EVEX,
  IMUL32rm_ND,
  IMUL32rm_NF,
  IMUL32rm_NF_ND,
  IMUL32rmi,
  IMUL32rmi8,
  IMUL32rmi8_EVEX,
  IMUL32rmi8_NF,
  IMUL32rmi_EVEX,
  IMUL32rmi_NF,
  IMUL32rr,
  IMUL32rr_EVEX,
  IMUL32rr_ND,
  IMUL32rr_NF,
  IMUL32rr_NF_ND,
  IMUL32rri,
  IMUL32rri8,
  IMUL32rri8_EVEX,
  IMUL32rri8_NF,
  IMUL32rri_EVEX,
  IMUL32rri_NF,
  IMUL64m,
  IMUL64m_EVEX,
  IMUL64m_NF,
  IMUL64r,
  IMUL64r_EVEX,
  IMUL64r_NF,
  IMUL64rm,
  IMUL64rm_EVEX,
  IMUL64rm_ND,
  IMUL64rm_NF,
  IMUL64rm_NF_ND,
  IMUL64rmi32,
  IMUL64rmi32_EVEX,
  IMUL64rmi32_NF,
  IMUL64rmi8,
  IMUL64rmi8_EVEX,
  IMUL64rmi8_NF,
  IMUL64rr,
  IMUL64rr_EVEX,
  IMUL64rr_ND,
  IMUL64rr_NF,
  IMUL64rr_NF_ND,
  IMUL64rri32,
  IMUL64rri32_EVEX,
  IMUL64rri32_NF,
  IMUL64rri8,
  IMUL64rri8_EVEX,
  IMUL64rri8_NF,
  IMUL8m,
  IMUL8m_EVEX,
  IMUL8m_NF,
  IMUL8r,
  IMUL8r_EVEX,
  IMUL8r_NF,
  IMULZU16rmi,
  IMULZU16rmi8,
  IMULZU16rri,
  IMULZU16rri8,
  IMULZU32rmi,
  IMULZU32rmi8,
  IMULZU32rri,
  IMULZU32rri8,
  IMULZU64rmi32,
  IMULZU64rmi8,
  IMULZU64rri32,
  IMULZU64rri8,
  IN16ri,
  IN16rr,
  IN32ri,
  IN32rr,
  IN8ri,
  IN8rr,
  INC16m,
  INC16m_EVEX,
  INC16m_ND,
  INC16m_NF,
  INC16m_NF_ND,
  INC16r,
  INC16r_EVEX,
  INC16r_ND,
  INC16r_NF,
  INC16r_NF_ND,
  INC16r_alt,
  INC32m,
  INC32m_EVEX,
  INC32m_ND,
  INC32m_NF,
  INC32m_NF_ND,
  INC32r,
  INC32r_EVEX,
  INC32r_ND,
  INC32r_NF,
  INC32r_NF_ND,
  INC32r_alt,
  INC64m,
  INC64m_EVEX,
  INC64m_ND,
  INC64m_NF,
  INC64m_NF_ND,
  INC64r,
  INC64r_EVEX,
  INC64r_ND,
  INC64r_NF,
  INC64r_NF_ND,
  INC8m,
  INC8m_EVEX,
  INC8m_ND,
  INC8m_NF,
  INC8m_NF_ND,
  INC8r,
  INC8r_EVEX,
  INC8r_ND,
  INC8r_NF,
  INC8r_NF_ND,
  INCSSPD,
  INCSSPQ,
  INSB,
  INSERTPSrmi,
  INSERTPSrri,
  INSERTQ,
  INSERTQI,
  INSL,
  INSW,
  INT,
  INT3,
  INTO,
  INVD,
  INVEPT32,
  INVEPT64,
  INVEPT64_EVEX,
  INVLPG,
  INVLPGA32,
  INVLPGA64,
  INVLPGB32,
  INVLPGB64,
  INVPCID32,
  INVPCID64,
  INVPCID64_EVEX,
  INVVPID32,
  INVVPID64,
  INVVPID64_EVEX,
  IRET,
  IRET16,
  IRET32,
  IRET64,
  ISTT_FP16m,
  ISTT_FP32m,
  ISTT_FP64m,
  ISTT_Fp16m32,
  ISTT_Fp16m64,
  ISTT_Fp16m80,
  ISTT_Fp32m32,
  ISTT_Fp32m64,
  ISTT_Fp32m80,
  ISTT_Fp64m32,
  ISTT_Fp64m64,
  ISTT_Fp64m80,
  IST_F16m,
  IST_F32m,
  IST_FP16m,
  IST_FP32m,
  IST_FP64m,
  IST_Fp16m32,
  IST_Fp16m64,
  IST_Fp16m80,
  IST_Fp32m32,
  IST_Fp32m64,
  IST_Fp32m80,
  IST_Fp64m32,
  IST_Fp64m64,
  IST_Fp64m80,
  Int_eh_sjlj_setup_dispatch,
  JCC_1,
  JCC_2,
  JCC_4,
  JCXZ,
  JECXZ,
  JMP16m,
  JMP16m_NT,
  JMP16r,
  JMP16r_NT,
  JMP32m,
  JMP32m_NT,
  JMP32r,
  JMP32r_NT,
  JMP64m,
  JMP64m_NT,
  JMP64m_REX,
  JMP64r,
  JMP64r_NT,
  JMP64r_REX,
  JMPABS64i,
  JMP_1,
  JMP_2,
  JMP_4,
  JRCXZ,
  KADDBkk,
  KADDDkk,
  KADDQkk,
  KADDWkk,
  KANDBkk,
  KANDDkk,
  KANDNBkk,
  KANDNDkk,
  KANDNQkk,
  KANDNWkk,
  KANDQkk,
  KANDWkk,
  KCFI_CHECK,
  KMOVBkk,
  KMOVBkk_EVEX,
  KMOVBkm,
  KMOVBkm_EVEX,
  KMOVBkr,
  KMOVBkr_EVEX,
  KMOVBmk,
  KMOVBmk_EVEX,
  KMOVBrk,
  KMOVBrk_EVEX,
  KMOVDkk,
  KMOVDkk_EVEX,
  KMOVDkm,
  KMOVDkm_EVEX,
  KMOVDkr,
  KMOVDkr_EVEX,
  KMOVDmk,
  KMOVDmk_EVEX,
  KMOVDrk,
  KMOVDrk_EVEX,
  KMOVQkk,
  KMOVQkk_EVEX,
  KMOVQkm,
  KMOVQkm_EVEX,
  KMOVQkr,
  KMOVQkr_EVEX,
  KMOVQmk,
  KMOVQmk_EVEX,
  KMOVQrk,
  KMOVQrk_EVEX,
  KMOVWkk,
  KMOVWkk_EVEX,
  KMOVWkm,
  KMOVWkm_EVEX,
  KMOVWkr,
  KMOVWkr_EVEX,
  KMOVWmk,
  KMOVWmk_EVEX,
  KMOVWrk,
  KMOVWrk_EVEX,
  KNOTBkk,
  KNOTDkk,
  KNOTQkk,
  KNOTWkk,
  KORBkk,
  KORDkk,
  KORQkk,
  KORTESTBkk,
  KORTESTDkk,
  KORTESTQkk,
  KORTESTWkk,
  KORWkk,
  KSHIFTLBki,
  KSHIFTLDki,
  KSHIFTLQki,
  KSHIFTLWki,
  KSHIFTRBki,
  KSHIFTRDki,
  KSHIFTRQki,
  KSHIFTRWki,
  KTESTBkk,
  KTESTDkk,
  KTESTQkk,
  KTESTWkk,
  KUNPCKBWkk,
  KUNPCKDQkk,
  KUNPCKWDkk,
  KXNORBkk,
  KXNORDkk,
  KXNORQkk,
  KXNORWkk,
  KXORBkk,
  KXORDkk,
  KXORQkk,
  KXORWkk,
  LAHF,
  LAR16rm,
  LAR16rr,
  LAR32rm,
  LAR32rr,
  LAR64rm,
  LAR64rr,
  LCMPXCHG16,
  LCMPXCHG16B,
  LCMPXCHG32,
  LCMPXCHG64,
  LCMPXCHG8,
  LCMPXCHG8B,
  LDDQUrm,
  LDMXCSR,
  LDS16rm,
  LDS32rm,
  LDTILECFG,
  LDTILECFG_EVEX,
  LD_F0,
  LD_F1,
  LD_F32m,
  LD_F64m,
  LD_F80m,
  LD_Fp032,
  LD_Fp064,
  LD_Fp080,
  LD_Fp132,
  LD_Fp164,
  LD_Fp180,
  LD_Fp32m,
  LD_Fp32m64,
  LD_Fp32m80,
  LD_Fp64m,
  LD_Fp64m80,
  LD_Fp80m,
  LD_Frr,
  LEA16r,
  LEA32r,
  LEA64_16r,
  LEA64_32r,
  LEA64_8r,
  LEA64r,
  LEAVE,
  LEAVE64,
  LES16rm,
  LES32rm,
  LFENCE,
  LFS16rm,
  LFS32rm,
  LFS64rm,
  LGDT16m,
  LGDT32m,
  LGDT64m,
  LGS16rm,
  LGS32rm,
  LGS64rm,
  LIDT16m,
  LIDT32m,
  LIDT64m,
  LKGS16m,
  LKGS16r,
  LLDT16m,
  LLDT16r,
  LLWPCB,
  LLWPCB64,
  LMSW16m,
  LMSW16r,
  LOADIWKEY,
  LOCK_ADD16mi,
  LOCK_ADD16mi8,
  LOCK_ADD16mr,
  LOCK_ADD32mi,
  LOCK_ADD32mi8,
  LOCK_ADD32mr,
  LOCK_ADD64mi32,
  LOCK_ADD64mi8,
  LOCK_ADD64mr,
  LOCK_ADD8mi,
  LOCK_ADD8mr,
  LOCK_AND16mi,
  LOCK_AND16mi8,
  LOCK_AND16mr,
  LOCK_AND32mi,
  LOCK_AND32mi8,
  LOCK_AND32mr,
  LOCK_AND64mi32,
  LOCK_AND64mi8,
  LOCK_AND64mr,
  LOCK_AND8mi,
  LOCK_AND8mr,
  LOCK_BTC16m,
  LOCK_BTC32m,
  LOCK_BTC64m,
  LOCK_BTC_RM16rm,
  LOCK_BTC_RM32rm,
  LOCK_BTC_RM64rm,
  LOCK_BTR16m,
  LOCK_BTR32m,
  LOCK_BTR64m,
  LOCK_BTR_RM16rm,
  LOCK_BTR_RM32rm,
  LOCK_BTR_RM64rm,
  LOCK_BTS16m,
  LOCK_BTS32m,
  LOCK_BTS64m,
  LOCK_BTS_RM16rm,
  LOCK_BTS_RM32rm,
  LOCK_BTS_RM64rm,
  LOCK_DEC16m,
  LOCK_DEC32m,
  LOCK_DEC64m,
  LOCK_DEC8m,
  LOCK_INC16m,
  LOCK_INC32m,
  LOCK_INC64m,
  LOCK_INC8m,
  LOCK_OR16mi,
  LOCK_OR16mi8,
  LOCK_OR16mr,
  LOCK_OR32mi,
  LOCK_OR32mi8,
  LOCK_OR32mr,
  LOCK_OR64mi32,
  LOCK_OR64mi8,
  LOCK_OR64mr,
  LOCK_OR8mi,
  LOCK_OR8mr,
  LOCK_PREFIX,
  LOCK_SUB16mi,
  LOCK_SUB16mi8,
  LOCK_SUB16mr,
  LOCK_SUB32mi,
  LOCK_SUB32mi8,
  LOCK_SUB32mr,
  LOCK_SUB64mi32,
  LOCK_SUB64mi8,
  LOCK_SUB64mr,
  LOCK_SUB8mi,
  LOCK_SUB8mr,
  LOCK_XOR16mi,
  LOCK_XOR16mi8,
  LOCK_XOR16mr,
  LOCK_XOR32mi,
  LOCK_XOR32mi8,
  LOCK_XOR32mr,
  LOCK_XOR64mi32,
  LOCK_XOR64mi8,
  LOCK_XOR64mr,
  LOCK_XOR8mi,
  LOCK_XOR8mr,
  LODSB,
  LODSL,
  LODSQ,
  LODSW,
  LOOP,
  LOOPE,
  LOOPNE,
  LRET16,
  LRET32,
  LRET64,
  LRETI16,
  LRETI32,
  LRETI64,
  LSL16rm,
  LSL16rr,
  LSL32rm,
  LSL32rr,
  LSL64rm,
  LSL64rr,
  LSS16rm,
  LSS32rm,
  LSS64rm,
  LTRm,
  LTRr,
  LWPINS32rmi,
  LWPINS32rri,
  LWPINS64rmi,
  LWPINS64rri,
  LWPVAL32rmi,
  LWPVAL32rri,
  LWPVAL64rmi,
  LWPVAL64rri,
  LXADD16,
  LXADD32,
  LXADD64,
  LXADD8,
  LZCNT16rm,
  LZCNT16rm_EVEX,
  LZCNT16rm_NF,
  LZCNT16rr,
  LZCNT16rr_EVEX,
  LZCNT16rr_NF,
  LZCNT32rm,
  LZCNT32rm_EVEX,
  LZCNT32rm_NF,
  LZCNT32rr,
  LZCNT32rr_EVEX,
  LZCNT32rr_NF,
  LZCNT64rm,
  LZCNT64rm_EVEX,
  LZCNT64rm_NF,
  LZCNT64rr,
  LZCNT64rr_EVEX,
  LZCNT64rr_NF,
  MASKMOVDQU,
  MASKMOVDQU64,
  MASKPAIR16LOAD,
  MASKPAIR16STORE,
  MAXCPDrm,
  MAXCPDrr,
  MAXCPSrm,
  MAXCPSrr,
  MAXCSDrm,
  MAXCSDrr,
  MAXCSSrm,
  MAXCSSrr,
  MAXPDrm,
  MAXPDrr,
  MAXPSrm,
  MAXPSrr,
  MAXSDrm,
  MAXSDrm_Int,
  MAXSDrr,
  MAXSDrr_Int,
  MAXSSrm,
  MAXSSrm_Int,
  MAXSSrr,
  MAXSSrr_Int,
  MFENCE,
  MINCPDrm,
  MINCPDrr,
  MINCPSrm,
  MINCPSrr,
  MINCSDrm,
  MINCSDrr,
  MINCSSrm,
  MINCSSrr,
  MINPDrm,
  MINPDrr,
  MINPSrm,
  MINPSrr,
  MINSDrm,
  MINSDrm_Int,
  MINSDrr,
  MINSDrr_Int,
  MINSSrm,
  MINSSrm_Int,
  MINSSrr,
  MINSSrr_Int,
  MMX_CVTPD2PIrm,
  MMX_CVTPD2PIrr,
  MMX_CVTPI2PDrm,
  MMX_CVTPI2PDrr,
  MMX_CVTPI2PSrm,
  MMX_CVTPI2PSrr,
  MMX_CVTPS2PIrm,
  MMX_CVTPS2PIrr,
  MMX_CVTTPD2PIrm,
  MMX_CVTTPD2PIrr,
  MMX_CVTTPS2PIrm,
  MMX_CVTTPS2PIrr,
  MMX_EMMS,
  MMX_MASKMOVQ,
  MMX_MASKMOVQ64,
  MMX_MOVD64from64mr,
  MMX_MOVD64from64rr,
  MMX_MOVD64grr,
  MMX_MOVD64mr,
  MMX_MOVD64rm,
  MMX_MOVD64rr,
  MMX_MOVD64to64rm,
  MMX_MOVD64to64rr,
  MMX_MOVDQ2Qrr,
  MMX_MOVFR642Qrr,
  MMX_MOVNTQmr,
  MMX_MOVQ2DQrr,
  MMX_MOVQ2FR64rr,
  MMX_MOVQ64mr,
  MMX_MOVQ64rm,
  MMX_MOVQ64rr,
  MMX_MOVQ64rr_REV,
  MMX_PABSBrm,
  MMX_PABSBrr,
  MMX_PABSDrm,
  MMX_PABSDrr,
  MMX_PABSWrm,
  MMX_PABSWrr,
  MMX_PACKSSDWrm,
  MMX_PACKSSDWrr,
  MMX_PACKSSWBrm,
  MMX_PACKSSWBrr,
  MMX_PACKUSWBrm,
  MMX_PACKUSWBrr,
  MMX_PADDBrm,
  MMX_PADDBrr,
  MMX_PADDDrm,
  MMX_PADDDrr,
  MMX_PADDQrm,
  MMX_PADDQrr,
  MMX_PADDSBrm,
  MMX_PADDSBrr,
  MMX_PADDSWrm,
  MMX_PADDSWrr,
  MMX_PADDUSBrm,
  MMX_PADDUSBrr,
  MMX_PADDUSWrm,
  MMX_PADDUSWrr,
  MMX_PADDWrm,
  MMX_PADDWrr,
  MMX_PALIGNRrmi,
  MMX_PALIGNRrri,
  MMX_PANDNrm,
  MMX_PANDNrr,
  MMX_PANDrm,
  MMX_PANDrr,
  MMX_PAVGBrm,
  MMX_PAVGBrr,
  MMX_PAVGWrm,
  MMX_PAVGWrr,
  MMX_PCMPEQBrm,
  MMX_PCMPEQBrr,
  MMX_PCMPEQDrm,
  MMX_PCMPEQDrr,
  MMX_PCMPEQWrm,
  MMX_PCMPEQWrr,
  MMX_PCMPGTBrm,
  MMX_PCMPGTBrr,
  MMX_PCMPGTDrm,
  MMX_PCMPGTDrr,
  MMX_PCMPGTWrm,
  MMX_PCMPGTWrr,
  MMX_PEXTRWrri,
  MMX_PHADDDrm,
  MMX_PHADDDrr,
  MMX_PHADDSWrm,
  MMX_PHADDSWrr,
  MMX_PHADDWrm,
  MMX_PHADDWrr,
  MMX_PHSUBDrm,
  MMX_PHSUBDrr,
  MMX_PHSUBSWrm,
  MMX_PHSUBSWrr,
  MMX_PHSUBWrm,
  MMX_PHSUBWrr,
  MMX_PINSRWrmi,
  MMX_PINSRWrri,
  MMX_PMADDUBSWrm,
  MMX_PMADDUBSWrr,
  MMX_PMADDWDrm,
  MMX_PMADDWDrr,
  MMX_PMAXSWrm,
  MMX_PMAXSWrr,
  MMX_PMAXUBrm,
  MMX_PMAXUBrr,
  MMX_PMINSWrm,
  MMX_PMINSWrr,
  MMX_PMINUBrm,
  MMX_PMINUBrr,
  MMX_PMOVMSKBrr,
  MMX_PMULHRSWrm,
  MMX_PMULHRSWrr,
  MMX_PMULHUWrm,
  MMX_PMULHUWrr,
  MMX_PMULHWrm,
  MMX_PMULHWrr,
  MMX_PMULLWrm,
  MMX_PMULLWrr,
  MMX_PMULUDQrm,
  MMX_PMULUDQrr,
  MMX_PORrm,
  MMX_PORrr,
  MMX_PSADBWrm,
  MMX_PSADBWrr,
  MMX_PSHUFBrm,
  MMX_PSHUFBrr,
  MMX_PSHUFWmi,
  MMX_PSHUFWri,
  MMX_PSIGNBrm,
  MMX_PSIGNBrr,
  MMX_PSIGNDrm,
  MMX_PSIGNDrr,
  MMX_PSIGNWrm,
  MMX_PSIGNWrr,
  MMX_PSLLDri,
  MMX_PSLLDrm,
  MMX_PSLLDrr,
  MMX_PSLLQri,
  MMX_PSLLQrm,
  MMX_PSLLQrr,
  MMX_PSLLWri,
  MMX_PSLLWrm,
  MMX_PSLLWrr,
  MMX_PSRADri,
  MMX_PSRADrm,
  MMX_PSRADrr,
  MMX_PSRAWri,
  MMX_PSRAWrm,
  MMX_PSRAWrr,
  MMX_PSRLDri,
  MMX_PSRLDrm,
  MMX_PSRLDrr,
  MMX_PSRLQri,
  MMX_PSRLQrm,
  MMX_PSRLQrr,
  MMX_PSRLWri,
  MMX_PSRLWrm,
  MMX_PSRLWrr,
  MMX_PSUBBrm,
  MMX_PSUBBrr,
  MMX_PSUBDrm,
  MMX_PSUBDrr,
  MMX_PSUBQrm,
  MMX_PSUBQrr,
  MMX_PSUBSBrm,
  MMX_PSUBSBrr,
  MMX_PSUBSWrm,
  MMX_PSUBSWrr,
  MMX_PSUBUSBrm,
  MMX_PSUBUSBrr,
  MMX_PSUBUSWrm,
  MMX_PSUBUSWrr,
  MMX_PSUBWrm,
  MMX_PSUBWrr,
  MMX_PUNPCKHBWrm,
  MMX_PUNPCKHBWrr,
  MMX_PUNPCKHDQrm,
  MMX_PUNPCKHDQrr,
  MMX_PUNPCKHWDrm,
  MMX_PUNPCKHWDrr,
  MMX_PUNPCKLBWrm,
  MMX_PUNPCKLBWrr,
  MMX_PUNPCKLDQrm,
  MMX_PUNPCKLDQrr,
  MMX_PUNPCKLWDrm,
  MMX_PUNPCKLWDrr,
  MMX_PXORrm,
  MMX_PXORrr,
  MONITOR32rrr,
  MONITOR64rrr,
  MONITORX32rrr,
  MONITORX64rrr,
  MONTMUL,
  MOV16ao16,
  MOV16ao32,
  MOV16ao64,
  MOV16mi,
  MOV16mr,
  MOV16ms,
  MOV16o16a,
  MOV16o32a,
  MOV16o64a,
  MOV16ri,
  MOV16ri_alt,
  MOV16rm,
  MOV16rr,
  MOV16rr_REV,
  MOV16rs,
  MOV16sm,
  MOV16sr,
  MOV32ao16,
  MOV32ao32,
  MOV32ao64,
  MOV32cr,
  MOV32dr,
  MOV32mi,
  MOV32mr,
  MOV32o16a,
  MOV32o32a,
  MOV32o64a,
  MOV32rc,
  MOV32rd,
  MOV32ri,
  MOV32ri_alt,
  MOV32rm,
  MOV32rr,
  MOV32rr_REV,
  MOV32rs,
  MOV32sr,
  MOV64ao32,
  MOV64ao64,
  MOV64cr,
  MOV64dr,
  MOV64mi32,
  MOV64mr,
  MOV64o32a,
  MOV64o64a,
  MOV64rc,
  MOV64rd,
  MOV64ri,
  MOV64ri32,
  MOV64rm,
  MOV64rr,
  MOV64rr_REV,
  MOV64rs,
  MOV64sr,
  MOV64toPQIrm,
  MOV64toPQIrr,
  MOV64toSDrr,
  MOV8ao16,
  MOV8ao32,
  MOV8ao64,
  MOV8mi,
  MOV8mr,
  MOV8mr_NOREX,
  MOV8o16a,
  MOV8o32a,
  MOV8o64a,
  MOV8ri,
  MOV8ri_alt,
  MOV8rm,
  MOV8rm_NOREX,
  MOV8rr,
  MOV8rr_NOREX,
  MOV8rr_REV,
  MOVAPDmr,
  MOVAPDrm,
  MOVAPDrr,
  MOVAPDrr_REV,
  MOVAPSmr,
  MOVAPSrm,
  MOVAPSrr,
  MOVAPSrr_REV,
  MOVBE16mr,
  MOVBE16mr_EVEX,
  MOVBE16rm,
  MOVBE16rm_EVEX,
  MOVBE16rr,
  MOVBE16rr_REV,
  MOVBE32mr,
  MOVBE32mr_EVEX,
  MOVBE32rm,
  MOVBE32rm_EVEX,
  MOVBE32rr,
  MOVBE32rr_REV,
  MOVBE64mr,
  MOVBE64mr_EVEX,
  MOVBE64rm,
  MOVBE64rm_EVEX,
  MOVBE64rr,
  MOVBE64rr_REV,
  MOVDDUPrm,
  MOVDDUPrr,
  MOVDI2PDIrm,
  MOVDI2PDIrr,
  MOVDI2SSrr,
  MOVDIR64B16,
  MOVDIR64B32,
  MOVDIR64B32_EVEX,
  MOVDIR64B64,
  MOVDIR64B64_EVEX,
  MOVDIRI32,
  MOVDIRI32_EVEX,
  MOVDIRI64,
  MOVDIRI64_EVEX,
  MOVDQAmr,
  MOVDQArm,
  MOVDQArr,
  MOVDQArr_REV,
  MOVDQUmr,
  MOVDQUrm,
  MOVDQUrr,
  MOVDQUrr_REV,
  MOVHLPSrr,
  MOVHPDmr,
  MOVHPDrm,
  MOVHPSmr,
  MOVHPSrm,
  MOVLHPSrr,
  MOVLPDmr,
  MOVLPDrm,
  MOVLPSmr,
  MOVLPSrm,
  MOVMSKPDrr,
  MOVMSKPSrr,
  MOVNTDQArm,
  MOVNTDQmr,
  MOVNTI_64mr,
  MOVNTImr,
  MOVNTPDmr,
  MOVNTPSmr,
  MOVNTSD,
  MOVNTSS,
  MOVPC32r,
  MOVPDI2DImr,
  MOVPDI2DIrr,
  MOVPQI2QImr,
  MOVPQI2QIrr,
  MOVPQIto64mr,
  MOVPQIto64rr,
  MOVQI2PQIrm,
  MOVRS16rm,
  MOVRS16rm_EVEX,
  MOVRS32rm,
  MOVRS32rm_EVEX,
  MOVRS64rm,
  MOVRS64rm_EVEX,
  MOVRS8rm,
  MOVRS8rm_EVEX,
  MOVSB,
  MOVSDmr,
  MOVSDrm,
  MOVSDrm_alt,
  MOVSDrr,
  MOVSDrr_REV,
  MOVSDto64rr,
  MOVSHDUPrm,
  MOVSHDUPrr,
  MOVSL,
  MOVSLDUPrm,
  MOVSLDUPrr,
  MOVSQ,
  MOVSS2DIrr,
  MOVSSmr,
  MOVSSrm,
  MOVSSrm_alt,
  MOVSSrr,
  MOVSSrr_REV,
  MOVSW,
  MOVSX16rm16,
  MOVSX16rm32,
  MOVSX16rm8,
  MOVSX16rr16,
  MOVSX16rr32,
  MOVSX16rr8,
  MOVSX32rm16,
  MOVSX32rm32,
  MOVSX32rm8,
  MOVSX32rm8_NOREX,
  MOVSX32rr16,
  MOVSX32rr32,
  MOVSX32rr8,
  MOVSX32rr8_NOREX,
  MOVSX64rm16,
  MOVSX64rm32,
  MOVSX64rm8,
  MOVSX64rr16,
  MOVSX64rr32,
  MOVSX64rr8,
  MOVUPDmr,
  MOVUPDrm,
  MOVUPDrr,
  MOVUPDrr_REV,
  MOVUPSmr,
  MOVUPSrm,
  MOVUPSrr,
  MOVUPSrr_REV,
  MOVZPQILo2PQIrr,
  MOVZX16rm16,
  MOVZX16rm8,
  MOVZX16rr16,
  MOVZX16rr8,
  MOVZX32rm16,
  MOVZX32rm8,
  MOVZX32rm8_NOREX,
  MOVZX32rr16,
  MOVZX32rr8,
  MOVZX32rr8_NOREX,
  MOVZX64rm16,
  MOVZX64rm8,
  MOVZX64rr16,
  MOVZX64rr8,
  MPSADBWrmi,
  MPSADBWrri,
  MUL16m,
  MUL16m_EVEX,
  MUL16m_NF,
  MUL16r,
  MUL16r_EVEX,
  MUL16r_NF,
  MUL32m,
  MUL32m_EVEX,
  MUL32m_NF,
  MUL32r,
  MUL32r_EVEX,
  MUL32r_NF,
  MUL64m,
  MUL64m_EVEX,
  MUL64m_NF,
  MUL64r,
  MUL64r_EVEX,
  MUL64r_NF,
  MUL8m,
  MUL8m_EVEX,
  MUL8m_NF,
  MUL8r,
  MUL8r_EVEX,
  MUL8r_NF,
  MULPDrm,
  MULPDrr,
  MULPSrm,
  MULPSrr,
  MULSDrm,
  MULSDrm_Int,
  MULSDrr,
  MULSDrr_Int,
  MULSSrm,
  MULSSrm_Int,
  MULSSrr,
  MULSSrr_Int,
  MULX32Hrm,
  MULX32Hrr,
  MULX32rm,
  MULX32rm_EVEX,
  MULX32rr,
  MULX32rr_EVEX,
  MULX64Hrm,
  MULX64Hrr,
  MULX64rm,
  MULX64rm_EVEX,
  MULX64rr,
  MULX64rr_EVEX,
  MUL_F32m,
  MUL_F64m,
  MUL_FI16m,
  MUL_FI32m,
  MUL_FPrST0,
  MUL_FST0r,
  MUL_Fp32,
  MUL_Fp32m,
  MUL_Fp64,
  MUL_Fp64m,
  MUL_Fp64m32,
  MUL_Fp80,
  MUL_Fp80m32,
  MUL_Fp80m64,
  MUL_FpI16m32,
  MUL_FpI16m64,
  MUL_FpI16m80,
  MUL_FpI32m32,
  MUL_FpI32m64,
  MUL_FpI32m80,
  MUL_FrST0,
  MWAITXrrr,
  MWAITrr,
  NEG16m,
  NEG16m_EVEX,
  NEG16m_ND,
  NEG16m_NF,
  NEG16m_NF_ND,
  NEG16r,
  NEG16r_EVEX,
  NEG16r_ND,
  NEG16r_NF,
  NEG16r_NF_ND,
  NEG32m,
  NEG32m_EVEX,
  NEG32m_ND,
  NEG32m_NF,
  NEG32m_NF_ND,
  NEG32r,
  NEG32r_EVEX,
  NEG32r_ND,
  NEG32r_NF,
  NEG32r_NF_ND,
  NEG64m,
  NEG64m_EVEX,
  NEG64m_ND,
  NEG64m_NF,
  NEG64m_NF_ND,
  NEG64r,
  NEG64r_EVEX,
  NEG64r_ND,
  NEG64r_NF,
  NEG64r_NF_ND,
  NEG8m,
  NEG8m_EVEX,
  NEG8m_ND,
  NEG8m_NF,
  NEG8m_NF_ND,
  NEG8r,
  NEG8r_EVEX,
  NEG8r_ND,
  NEG8r_NF,
  NEG8r_NF_ND,
  NOOP,
  NOOPL,
  NOOPLr,
  NOOPQ,
  NOOPQr,
  NOOPW,
  NOOPWr,
  NOT16m,
  NOT16m_EVEX,
  NOT16m_ND,
  NOT16r,
  NOT16r_EVEX,
  NOT16r_ND,
  NOT32m,
  NOT32m_EVEX,
  NOT32m_ND,
  NOT32r,
  NOT32r_EVEX,
  NOT32r_ND,
  NOT64m,
  NOT64m_EVEX,
  NOT64m_ND,
  NOT64r,
  NOT64r_EVEX,
  NOT64r_ND,
  NOT8m,
  NOT8m_EVEX,
  NOT8m_ND,
  NOT8r,
  NOT8r_EVEX,
  NOT8r_ND,
  OR16i16,
  OR16mi,
  OR16mi8,
  OR16mi8_EVEX,
  OR16mi8_ND,
  OR16mi8_NF,
  OR16mi8_NF_ND,
  OR16mi_EVEX,
  OR16mi_ND,
  OR16mi_NF,
  OR16mi_NF_ND,
  OR16mr,
  OR16mr_EVEX,
  OR16mr_ND,
  OR16mr_NF,
  OR16mr_NF_ND,
  OR16ri,
  OR16ri8,
  OR16ri8_EVEX,
  OR16ri8_ND,
  OR16ri8_NF,
  OR16ri8_NF_ND,
  OR16ri_EVEX,
  OR16ri_ND,
  OR16ri_NF,
  OR16ri_NF_ND,
  OR16rm,
  OR16rm_EVEX,
  OR16rm_ND,
  OR16rm_NF,
  OR16rm_NF_ND,
  OR16rr,
  OR16rr_EVEX,
  OR16rr_EVEX_REV,
  OR16rr_ND,
  OR16rr_ND_REV,
  OR16rr_NF,
  OR16rr_NF_ND,
  OR16rr_NF_ND_REV,
  OR16rr_NF_REV,
  OR16rr_REV,
  OR32i32,
  OR32mi,
  OR32mi8,
  OR32mi8Locked,
  OR32mi8_EVEX,
  OR32mi8_ND,
  OR32mi8_NF,
  OR32mi8_NF_ND,
  OR32mi_EVEX,
  OR32mi_ND,
  OR32mi_NF,
  OR32mi_NF_ND,
  OR32mr,
  OR32mr_EVEX,
  OR32mr_ND,
  OR32mr_NF,
  OR32mr_NF_ND,
  OR32ri,
  OR32ri8,
  OR32ri8_EVEX,
  OR32ri8_ND,
  OR32ri8_NF,
  OR32ri8_NF_ND,
  OR32ri_EVEX,
  OR32ri_ND,
  OR32ri_NF,
  OR32ri_NF_ND,
  OR32rm,
  OR32rm_EVEX,
  OR32rm_ND,
  OR32rm_NF,
  OR32rm_NF_ND,
  OR32rr,
  OR32rr_EVEX,
  OR32rr_EVEX_REV,
  OR32rr_ND,
  OR32rr_ND_REV,
  OR32rr_NF,
  OR32rr_NF_ND,
  OR32rr_NF_ND_REV,
  OR32rr_NF_REV,
  OR32rr_REV,
  OR64i32,
  OR64mi32,
  OR64mi32_EVEX,
  OR64mi32_ND,
  OR64mi32_NF,
  OR64mi32_NF_ND,
  OR64mi8,
  OR64mi8_EVEX,
  OR64mi8_ND,
  OR64mi8_NF,
  OR64mi8_NF_ND,
  OR64mr,
  OR64mr_EVEX,
  OR64mr_ND,
  OR64mr_NF,
  OR64mr_NF_ND,
  OR64ri32,
  OR64ri32_EVEX,
  OR64ri32_ND,
  OR64ri32_NF,
  OR64ri32_NF_ND,
  OR64ri8,
  OR64ri8_EVEX,
  OR64ri8_ND,
  OR64ri8_NF,
  OR64ri8_NF_ND,
  OR64rm,
  OR64rm_EVEX,
  OR64rm_ND,
  OR64rm_NF,
  OR64rm_NF_ND,
  OR64rr,
  OR64rr_EVEX,
  OR64rr_EVEX_REV,
  OR64rr_ND,
  OR64rr_ND_REV,
  OR64rr_NF,
  OR64rr_NF_ND,
  OR64rr_NF_ND_REV,
  OR64rr_NF_REV,
  OR64rr_REV,
  OR8i8,
  OR8mi,
  OR8mi8,
  OR8mi_EVEX,
  OR8mi_ND,
  OR8mi_NF,
  OR8mi_NF_ND,
  OR8mr,
  OR8mr_EVEX,
  OR8mr_ND,
  OR8mr_NF,
  OR8mr_NF_ND,
  OR8ri,
  OR8ri8,
  OR8ri_EVEX,
  OR8ri_ND,
  OR8ri_NF,
  OR8ri_NF_ND,
  OR8rm,
  OR8rm_EVEX,
  OR8rm_ND,
  OR8rm_NF,
  OR8rm_NF_ND,
  OR8rr,
  OR8rr_EVEX,
  OR8rr_EVEX_REV,
  OR8rr_ND,
  OR8rr_ND_REV,
  OR8rr_NF,
  OR8rr_NF_ND,
  OR8rr_NF_ND_REV,
  OR8rr_NF_REV,
  OR8rr_REV,
  ORPDrm,
  ORPDrr,
  ORPSrm,
  ORPSrr,
  OUT16ir,
  OUT16rr,
  OUT32ir,
  OUT32rr,
  OUT8ir,
  OUT8rr,
  OUTSB,
  OUTSL,
  OUTSW,
  PABSBrm,
  PABSBrr,
  PABSDrm,
  PABSDrr,
  PABSWrm,
  PABSWrr,
  PACKSSDWrm,
  PACKSSDWrr,
  PACKSSWBrm,
  PACKSSWBrr,
  PACKUSDWrm,
  PACKUSDWrr,
  PACKUSWBrm,
  PACKUSWBrr,
  PADDBrm,
  PADDBrr,
  PADDDrm,
  PADDDrr,
  PADDQrm,
  PADDQrr,
  PADDSBrm,
  PADDSBrr,
  PADDSWrm,
  PADDSWrr,
  PADDUSBrm,
  PADDUSBrr,
  PADDUSWrm,
  PADDUSWrr,
  PADDWrm,
  PADDWrr,
  PALIGNRrmi,
  PALIGNRrri,
  PANDNrm,
  PANDNrr,
  PANDrm,
  PANDrr,
  PAUSE,
  PAVGBrm,
  PAVGBrr,
  PAVGUSBrm,
  PAVGUSBrr,
  PAVGWrm,
  PAVGWrr,
  PBLENDVBrm0,
  PBLENDVBrr0,
  PBLENDWrmi,
  PBLENDWrri,
  PBNDKB,
  PCLMULQDQrmi,
  PCLMULQDQrri,
  PCMPEQBrm,
  PCMPEQBrr,
  PCMPEQDrm,
  PCMPEQDrr,
  PCMPEQQrm,
  PCMPEQQrr,
  PCMPEQWrm,
  PCMPEQWrr,
  PCMPESTRIrmi,
  PCMPESTRIrri,
  PCMPESTRMrmi,
  PCMPESTRMrri,
  PCMPGTBrm,
  PCMPGTBrr,
  PCMPGTDrm,
  PCMPGTDrr,
  PCMPGTQrm,
  PCMPGTQrr,
  PCMPGTWrm,
  PCMPGTWrr,
  PCMPISTRIrmi,
  PCMPISTRIrri,
  PCMPISTRMrmi,
  PCMPISTRMrri,
  PCONFIG,
  PDEP32rm,
  PDEP32rm_EVEX,
  PDEP32rr,
  PDEP32rr_EVEX,
  PDEP64rm,
  PDEP64rm_EVEX,
  PDEP64rr,
  PDEP64rr_EVEX,
  PEXT32rm,
  PEXT32rm_EVEX,
  PEXT32rr,
  PEXT32rr_EVEX,
  PEXT64rm,
  PEXT64rm_EVEX,
  PEXT64rr,
  PEXT64rr_EVEX,
  PEXTRBmri,
  PEXTRBrri,
  PEXTRDmri,
  PEXTRDrri,
  PEXTRQmri,
  PEXTRQrri,
  PEXTRWmri,
  PEXTRWrri,
  PEXTRWrri_REV,
  PF2IDrm,
  PF2IDrr,
  PF2IWrm,
  PF2IWrr,
  PFACCrm,
  PFACCrr,
  PFADDrm,
  PFADDrr,
  PFCMPEQrm,
  PFCMPEQrr,
  PFCMPGErm,
  PFCMPGErr,
  PFCMPGTrm,
  PFCMPGTrr,
  PFMAXrm,
  PFMAXrr,
  PFMINrm,
  PFMINrr,
  PFMULrm,
  PFMULrr,
  PFNACCrm,
  PFNACCrr,
  PFPNACCrm,
  PFPNACCrr,
  PFRCPIT1rm,
  PFRCPIT1rr,
  PFRCPIT2rm,
  PFRCPIT2rr,
  PFRCPrm,
  PFRCPrr,
  PFRSQIT1rm,
  PFRSQIT1rr,
  PFRSQRTrm,
  PFRSQRTrr,
  PFSUBRrm,
  PFSUBRrr,
  PFSUBrm,
  PFSUBrr,
  PHADDDrm,
  PHADDDrr,
  PHADDSWrm,
  PHADDSWrr,
  PHADDWrm,
  PHADDWrr,
  PHMINPOSUWrm,
  PHMINPOSUWrr,
  PHSUBDrm,
  PHSUBDrr,
  PHSUBSWrm,
  PHSUBSWrr,
  PHSUBWrm,
  PHSUBWrr,
  PI2FDrm,
  PI2FDrr,
  PI2FWrm,
  PI2FWrr,
  PINSRBrmi,
  PINSRBrri,
  PINSRDrmi,
  PINSRDrri,
  PINSRQrmi,
  PINSRQrri,
  PINSRWrmi,
  PINSRWrri,
  PMADDUBSWrm,
  PMADDUBSWrr,
  PMADDWDrm,
  PMADDWDrr,
  PMAXSBrm,
  PMAXSBrr,
  PMAXSDrm,
  PMAXSDrr,
  PMAXSWrm,
  PMAXSWrr,
  PMAXUBrm,
  PMAXUBrr,
  PMAXUDrm,
  PMAXUDrr,
  PMAXUWrm,
  PMAXUWrr,
  PMINSBrm,
  PMINSBrr,
  PMINSDrm,
  PMINSDrr,
  PMINSWrm,
  PMINSWrr,
  PMINUBrm,
  PMINUBrr,
  PMINUDrm,
  PMINUDrr,
  PMINUWrm,
  PMINUWrr,
  PMOVMSKBrr,
  PMOVSXBDrm,
  PMOVSXBDrr,
  PMOVSXBQrm,
  PMOVSXBQrr,
  PMOVSXBWrm,
  PMOVSXBWrr,
  PMOVSXDQrm,
  PMOVSXDQrr,
  PMOVSXWDrm,
  PMOVSXWDrr,
  PMOVSXWQrm,
  PMOVSXWQrr,
  PMOVZXBDrm,
  PMOVZXBDrr,
  PMOVZXBQrm,
  PMOVZXBQrr,
  PMOVZXBWrm,
  PMOVZXBWrr,
  PMOVZXDQrm,
  PMOVZXDQrr,
  PMOVZXWDrm,
  PMOVZXWDrr,
  PMOVZXWQrm,
  PMOVZXWQrr,
  PMULDQrm,
  PMULDQrr,
  PMULHRSWrm,
  PMULHRSWrr,
  PMULHRWrm,
  PMULHRWrr,
  PMULHUWrm,
  PMULHUWrr,
  PMULHWrm,
  PMULHWrr,
  PMULLDrm,
  PMULLDrr,
  PMULLWrm,
  PMULLWrr,
  PMULUDQrm,
  PMULUDQrr,
  POP16r,
  POP16rmm,
  POP16rmr,
  POP2,
  POP2P,
  POP32r,
  POP32rmm,
  POP32rmr,
  POP64r,
  POP64rmm,
  POP64rmr,
  POPA16,
  POPA32,
  POPCNT16rm,
  POPCNT16rm_EVEX,
  POPCNT16rm_NF,
  POPCNT16rr,
  POPCNT16rr_EVEX,
  POPCNT16rr_NF,
  POPCNT32rm,
  POPCNT32rm_EVEX,
  POPCNT32rm_NF,
  POPCNT32rr,
  POPCNT32rr_EVEX,
  POPCNT32rr_NF,
  POPCNT64rm,
  POPCNT64rm_EVEX,
  POPCNT64rm_NF,
  POPCNT64rr,
  POPCNT64rr_EVEX,
  POPCNT64rr_NF,
  POPDS16,
  POPDS32,
  POPES16,
  POPES32,
  POPF16,
  POPF32,
  POPF64,
  POPFS16,
  POPFS32,
  POPFS64,
  POPGS16,
  POPGS32,
  POPGS64,
  POPP64r,
  POPSS16,
  POPSS32,
  PORrm,
  PORrr,
  PREFETCH,
  PREFETCHIT0,
  PREFETCHIT1,
  PREFETCHNTA,
  PREFETCHRST2,
  PREFETCHT0,
  PREFETCHT1,
  PREFETCHT2,
  PREFETCHW,
  PREFETCHWT1,
  PROBED_ALLOCA_32,
  PROBED_ALLOCA_64,
  PSADBWrm,
  PSADBWrr,
  PSHUFBrm,
  PSHUFBrr,
  PSHUFDmi,
  PSHUFDri,
  PSHUFHWmi,
  PSHUFHWri,
  PSHUFLWmi,
  PSHUFLWri,
  PSIGNBrm,
  PSIGNBrr,
  PSIGNDrm,
  PSIGNDrr,
  PSIGNWrm,
  PSIGNWrr,
  PSLLDQri,
  PSLLDri,
  PSLLDrm,
  PSLLDrr,
  PSLLQri,
  PSLLQrm,
  PSLLQrr,
  PSLLWri,
  PSLLWrm,
  PSLLWrr,
  PSMASH,
  PSRADri,
  PSRADrm,
  PSRADrr,
  PSRAWri,
  PSRAWrm,
  PSRAWrr,
  PSRLDQri,
  PSRLDri,
  PSRLDrm,
  PSRLDrr,
  PSRLQri,
  PSRLQrm,
  PSRLQrr,
  PSRLWri,
  PSRLWrm,
  PSRLWrr,
  PSUBBrm,
  PSUBBrr,
  PSUBDrm,
  PSUBDrr,
  PSUBQrm,
  PSUBQrr,
  PSUBSBrm,
  PSUBSBrr,
  PSUBSWrm,
  PSUBSWrr,
  PSUBUSBrm,
  PSUBUSBrr,
  PSUBUSWrm,
  PSUBUSWrr,
  PSUBWrm,
  PSUBWrr,
  PSWAPDrm,
  PSWAPDrr,
  PT2RPNTLVWZ0,
  PT2RPNTLVWZ0RS,
  PT2RPNTLVWZ0RST1,
  PT2RPNTLVWZ0T1,
  PT2RPNTLVWZ1,
  PT2RPNTLVWZ1RS,
  PT2RPNTLVWZ1RST1,
  PT2RPNTLVWZ1T1,
  PTCMMIMFP16PS,
  PTCMMIMFP16PSV,
  PTCMMRLFP16PS,
  PTCMMRLFP16PSV,
  PTCONJTCMMIMFP16PS,
  PTCONJTCMMIMFP16PSV,
  PTCONJTFP16,
  PTCONJTFP16V,
  PTCVTROWD2PSrre,
  PTCVTROWD2PSrreV,
  PTCVTROWD2PSrri,
  PTCVTROWD2PSrriV,
  PTCVTROWPS2BF16Hrre,
  PTCVTROWPS2BF16HrreV,
  PTCVTROWPS2BF16Hrri,
  PTCVTROWPS2BF16HrriV,
  PTCVTROWPS2BF16Lrre,
  PTCVTROWPS2BF16LrreV,
  PTCVTROWPS2BF16Lrri,
  PTCVTROWPS2BF16LrriV,
  PTCVTROWPS2PHHrre,
  PTCVTROWPS2PHHrreV,
  PTCVTROWPS2PHHrri,
  PTCVTROWPS2PHHrriV,
  PTCVTROWPS2PHLrre,
  PTCVTROWPS2PHLrreV,
  PTCVTROWPS2PHLrri,
  PTCVTROWPS2PHLrriV,
  PTDPBF16PS,
  PTDPBF8PS,
  PTDPBF8PSV,
  PTDPBHF8PS,
  PTDPBHF8PSV,
  PTDPBSSD,
  PTDPBSUD,
  PTDPBUSD,
  PTDPBUUD,
  PTDPFP16PS,
  PTDPHBF8PS,
  PTDPHBF8PSV,
  PTDPHF8PS,
  PTDPHF8PSV,
  PTESTrm,
  PTESTrr,
  PTILELOADD,
  PTILELOADDRS,
  PTILELOADDRST1,
  PTILELOADDT1,
  PTILEMOVROWrre,
  PTILEMOVROWrreV,
  PTILEMOVROWrri,
  PTILEMOVROWrriV,
  PTILESTORED,
  PTILEZERO,
  PTMMULTF32PS,
  PTMMULTF32PSV,
  PTTCMMIMFP16PS,
  PTTCMMIMFP16PSV,
  PTTCMMRLFP16PS,
  PTTCMMRLFP16PSV,
  PTTDPBF16PS,
  PTTDPBF16PSV,
  PTTDPFP16PS,
  PTTDPFP16PSV,
  PTTMMULTF32PS,
  PTTMMULTF32PSV,
  PTTRANSPOSED,
  PTTRANSPOSEDV,
  PTWRITE64m,
  PTWRITE64r,
  PTWRITEm,
  PTWRITEr,
  PUNPCKHBWrm,
  PUNPCKHBWrr,
  PUNPCKHDQrm,
  PUNPCKHDQrr,
  PUNPCKHQDQrm,
  PUNPCKHQDQrr,
  PUNPCKHWDrm,
  PUNPCKHWDrr,
  PUNPCKLBWrm,
  PUNPCKLBWrr,
  PUNPCKLDQrm,
  PUNPCKLDQrr,
  PUNPCKLQDQrm,
  PUNPCKLQDQrr,
  PUNPCKLWDrm,
  PUNPCKLWDrr,
  PUSH16i,
  PUSH16i8,
  PUSH16r,
  PUSH16rmm,
  PUSH16rmr,
  PUSH2,
  PUSH2P,
  PUSH32i,
  PUSH32i8,
  PUSH32r,
  PUSH32rmm,
  PUSH32rmr,
  PUSH64i32,
  PUSH64i8,
  PUSH64r,
  PUSH64rmm,
  PUSH64rmr,
  PUSHA16,
  PUSHA32,
  PUSHCS16,
  PUSHCS32,
  PUSHDS16,
  PUSHDS32,
  PUSHES16,
  PUSHES32,
  PUSHF16,
  PUSHF32,
  PUSHF64,
  PUSHFS16,
  PUSHFS32,
  PUSHFS64,
  PUSHGS16,
  PUSHGS32,
  PUSHGS64,
  PUSHP64r,
  PUSHSS16,
  PUSHSS32,
  PVALIDATE32,
  PVALIDATE64,
  PXORrm,
  PXORrr,
  RCL16m1,
  RCL16m1_EVEX,
  RCL16m1_ND,
  RCL16mCL,
  RCL16mCL_EVEX,
  RCL16mCL_ND,
  RCL16mi,
  RCL16mi_EVEX,
  RCL16mi_ND,
  RCL16r1,
  RCL16r1_EVEX,
  RCL16r1_ND,
  RCL16rCL,
  RCL16rCL_EVEX,
  RCL16rCL_ND,
  RCL16ri,
  RCL16ri_EVEX,
  RCL16ri_ND,
  RCL32m1,
  RCL32m1_EVEX,
  RCL32m1_ND,
  RCL32mCL,
  RCL32mCL_EVEX,
  RCL32mCL_ND,
  RCL32mi,
  RCL32mi_EVEX,
  RCL32mi_ND,
  RCL32r1,
  RCL32r1_EVEX,
  RCL32r1_ND,
  RCL32rCL,
  RCL32rCL_EVEX,
  RCL32rCL_ND,
  RCL32ri,
  RCL32ri_EVEX,
  RCL32ri_ND,
  RCL64m1,
  RCL64m1_EVEX,
  RCL64m1_ND,
  RCL64mCL,
  RCL64mCL_EVEX,
  RCL64mCL_ND,
  RCL64mi,
  RCL64mi_EVEX,
  RCL64mi_ND,
  RCL64r1,
  RCL64r1_EVEX,
  RCL64r1_ND,
  RCL64rCL,
  RCL64rCL_EVEX,
  RCL64rCL_ND,
  RCL64ri,
  RCL64ri_EVEX,
  RCL64ri_ND,
  RCL8m1,
  RCL8m1_EVEX,
  RCL8m1_ND,
  RCL8mCL,
  RCL8mCL_EVEX,
  RCL8mCL_ND,
  RCL8mi,
  RCL8mi_EVEX,
  RCL8mi_ND,
  RCL8r1,
  RCL8r1_EVEX,
  RCL8r1_ND,
  RCL8rCL,
  RCL8rCL_EVEX,
  RCL8rCL_ND,
  RCL8ri,
  RCL8ri_EVEX,
  RCL8ri_ND,
  RCPPSm,
  RCPPSr,
  RCPSSm,
  RCPSSm_Int,
  RCPSSr,
  RCPSSr_Int,
  RCR16m1,
  RCR16m1_EVEX,
  RCR16m1_ND,
  RCR16mCL,
  RCR16mCL_EVEX,
  RCR16mCL_ND,
  RCR16mi,
  RCR16mi_EVEX,
  RCR16mi_ND,
  RCR16r1,
  RCR16r1_EVEX,
  RCR16r1_ND,
  RCR16rCL,
  RCR16rCL_EVEX,
  RCR16rCL_ND,
  RCR16ri,
  RCR16ri_EVEX,
  RCR16ri_ND,
  RCR32m1,
  RCR32m1_EVEX,
  RCR32m1_ND,
  RCR32mCL,
  RCR32mCL_EVEX,
  RCR32mCL_ND,
  RCR32mi,
  RCR32mi_EVEX,
  RCR32mi_ND,
  RCR32r1,
  RCR32r1_EVEX,
  RCR32r1_ND,
  RCR32rCL,
  RCR32rCL_EVEX,
  RCR32rCL_ND,
  RCR32ri,
  RCR32ri_EVEX,
  RCR32ri_ND,
  RCR64m1,
  RCR64m1_EVEX,
  RCR64m1_ND,
  RCR64mCL,
  RCR64mCL_EVEX,
  RCR64mCL_ND,
  RCR64mi,
  RCR64mi_EVEX,
  RCR64mi_ND,
  RCR64r1,
  RCR64r1_EVEX,
  RCR64r1_ND,
  RCR64rCL,
  RCR64rCL_EVEX,
  RCR64rCL_ND,
  RCR64ri,
  RCR64ri_EVEX,
  RCR64ri_ND,
  RCR8m1,
  RCR8m1_EVEX,
  RCR8m1_ND,
  RCR8mCL,
  RCR8mCL_EVEX,
  RCR8mCL_ND,
  RCR8mi,
  RCR8mi_EVEX,
  RCR8mi_ND,
  RCR8r1,
  RCR8r1_EVEX,
  RCR8r1_ND,
  RCR8rCL,
  RCR8rCL_EVEX,
  RCR8rCL_ND,
  RCR8ri,
  RCR8ri_EVEX,
  RCR8ri_ND,
  RDFSBASE,
  RDFSBASE64,
  RDGSBASE,
  RDGSBASE64,
  RDMSR,
  RDMSRLIST,
  RDMSRri,
  RDMSRri_EVEX,
  RDPID32,
  RDPID64,
  RDPKRUr,
  RDPMC,
  RDPRU,
  RDRAND16r,
  RDRAND32r,
  RDRAND64r,
  RDSEED16r,
  RDSEED32r,
  RDSEED64r,
  RDSSPD,
  RDSSPQ,
  RDTSC,
  RDTSCP,
  REPNE_PREFIX,
  REP_MOVSB_32,
  REP_MOVSB_64,
  REP_MOVSD_32,
  REP_MOVSD_64,
  REP_MOVSQ_32,
  REP_MOVSQ_64,
  REP_MOVSW_32,
  REP_MOVSW_64,
  REP_PREFIX,
  REP_STOSB_32,
  REP_STOSB_64,
  REP_STOSD_32,
  REP_STOSD_64,
  REP_STOSQ_32,
  REP_STOSQ_64,
  REP_STOSW_32,
  REP_STOSW_64,
  RET,
  RET16,
  RET32,
  RET64,
  RETI16,
  RETI32,
  RETI64,
  REX64_PREFIX,
  RMPADJUST,
  RMPQUERY,
  RMPUPDATE,
  ROL16m1,
  ROL16m1_EVEX,
  ROL16m1_ND,
  ROL16m1_NF,
  ROL16m1_NF_ND,
  ROL16mCL,
  ROL16mCL_EVEX,
  ROL16mCL_ND,
  ROL16mCL_NF,
  ROL16mCL_NF_ND,
  ROL16mi,
  ROL16mi_EVEX,
  ROL16mi_ND,
  ROL16mi_NF,
  ROL16mi_NF_ND,
  ROL16r1,
  ROL16r1_EVEX,
  ROL16r1_ND,
  ROL16r1_NF,
  ROL16r1_NF_ND,
  ROL16rCL,
  ROL16rCL_EVEX,
  ROL16rCL_ND,
  ROL16rCL_NF,
  ROL16rCL_NF_ND,
  ROL16ri,
  ROL16ri_EVEX,
  ROL16ri_ND,
  ROL16ri_NF,
  ROL16ri_NF_ND,
  ROL32m1,
  ROL32m1_EVEX,
  ROL32m1_ND,
  ROL32m1_NF,
  ROL32m1_NF_ND,
  ROL32mCL,
  ROL32mCL_EVEX,
  ROL32mCL_ND,
  ROL32mCL_NF,
  ROL32mCL_NF_ND,
  ROL32mi,
  ROL32mi_EVEX,
  ROL32mi_ND,
  ROL32mi_NF,
  ROL32mi_NF_ND,
  ROL32r1,
  ROL32r1_EVEX,
  ROL32r1_ND,
  ROL32r1_NF,
  ROL32r1_NF_ND,
  ROL32rCL,
  ROL32rCL_EVEX,
  ROL32rCL_ND,
  ROL32rCL_NF,
  ROL32rCL_NF_ND,
  ROL32ri,
  ROL32ri_EVEX,
  ROL32ri_ND,
  ROL32ri_NF,
  ROL32ri_NF_ND,
  ROL64m1,
  ROL64m1_EVEX,
  ROL64m1_ND,
  ROL64m1_NF,
  ROL64m1_NF_ND,
  ROL64mCL,
  ROL64mCL_EVEX,
  ROL64mCL_ND,
  ROL64mCL_NF,
  ROL64mCL_NF_ND,
  ROL64mi,
  ROL64mi_EVEX,
  ROL64mi_ND,
  ROL64mi_NF,
  ROL64mi_NF_ND,
  ROL64r1,
  ROL64r1_EVEX,
  ROL64r1_ND,
  ROL64r1_NF,
  ROL64r1_NF_ND,
  ROL64rCL,
  ROL64rCL_EVEX,
  ROL64rCL_ND,
  ROL64rCL_NF,
  ROL64rCL_NF_ND,
  ROL64ri,
  ROL64ri_EVEX,
  ROL64ri_ND,
  ROL64ri_NF,
  ROL64ri_NF_ND,
  ROL8m1,
  ROL8m1_EVEX,
  ROL8m1_ND,
  ROL8m1_NF,
  ROL8m1_NF_ND,
  ROL8mCL,
  ROL8mCL_EVEX,
  ROL8mCL_ND,
  ROL8mCL_NF,
  ROL8mCL_NF_ND,
  ROL8mi,
  ROL8mi_EVEX,
  ROL8mi_ND,
  ROL8mi_NF,
  ROL8mi_NF_ND,
  ROL8r1,
  ROL8r1_EVEX,
  ROL8r1_ND,
  ROL8r1_NF,
  ROL8r1_NF_ND,
  ROL8rCL,
  ROL8rCL_EVEX,
  ROL8rCL_ND,
  ROL8rCL_NF,
  ROL8rCL_NF_ND,
  ROL8ri,
  ROL8ri_EVEX,
  ROL8ri_ND,
  ROL8ri_NF,
  ROL8ri_NF_ND,
  ROR16m1,
  ROR16m1_EVEX,
  ROR16m1_ND,
  ROR16m1_NF,
  ROR16m1_NF_ND,
  ROR16mCL,
  ROR16mCL_EVEX,
  ROR16mCL_ND,
  ROR16mCL_NF,
  ROR16mCL_NF_ND,
  ROR16mi,
  ROR16mi_EVEX,
  ROR16mi_ND,
  ROR16mi_NF,
  ROR16mi_NF_ND,
  ROR16r1,
  ROR16r1_EVEX,
  ROR16r1_ND,
  ROR16r1_NF,
  ROR16r1_NF_ND,
  ROR16rCL,
  ROR16rCL_EVEX,
  ROR16rCL_ND,
  ROR16rCL_NF,
  ROR16rCL_NF_ND,
  ROR16ri,
  ROR16ri_EVEX,
  ROR16ri_ND,
  ROR16ri_NF,
  ROR16ri_NF_ND,
  ROR32m1,
  ROR32m1_EVEX,
  ROR32m1_ND,
  ROR32m1_NF,
  ROR32m1_NF_ND,
  ROR32mCL,
  ROR32mCL_EVEX,
  ROR32mCL_ND,
  ROR32mCL_NF,
  ROR32mCL_NF_ND,
  ROR32mi,
  ROR32mi_EVEX,
  ROR32mi_ND,
  ROR32mi_NF,
  ROR32mi_NF_ND,
  ROR32r1,
  ROR32r1_EVEX,
  ROR32r1_ND,
  ROR32r1_NF,
  ROR32r1_NF_ND,
  ROR32rCL,
  ROR32rCL_EVEX,
  ROR32rCL_ND,
  ROR32rCL_NF,
  ROR32rCL_NF_ND,
  ROR32ri,
  ROR32ri_EVEX,
  ROR32ri_ND,
  ROR32ri_NF,
  ROR32ri_NF_ND,
  ROR64m1,
  ROR64m1_EVEX,
  ROR64m1_ND,
  ROR64m1_NF,
  ROR64m1_NF_ND,
  ROR64mCL,
  ROR64mCL_EVEX,
  ROR64mCL_ND,
  ROR64mCL_NF,
  ROR64mCL_NF_ND,
  ROR64mi,
  ROR64mi_EVEX,
  ROR64mi_ND,
  ROR64mi_NF,
  ROR64mi_NF_ND,
  ROR64r1,
  ROR64r1_EVEX,
  ROR64r1_ND,
  ROR64r1_NF,
  ROR64r1_NF_ND,
  ROR64rCL,
  ROR64rCL_EVEX,
  ROR64rCL_ND,
  ROR64rCL_NF,
  ROR64rCL_NF_ND,
  ROR64ri,
  ROR64ri_EVEX,
  ROR64ri_ND,
  ROR64ri_NF,
  ROR64ri_NF_ND,
  ROR8m1,
  ROR8m1_EVEX,
  ROR8m1_ND,
  ROR8m1_NF,
  ROR8m1_NF_ND,
  ROR8mCL,
  ROR8mCL_EVEX,
  ROR8mCL_ND,
  ROR8mCL_NF,
  ROR8mCL_NF_ND,
  ROR8mi,
  ROR8mi_EVEX,
  ROR8mi_ND,
  ROR8mi_NF,
  ROR8mi_NF_ND,
  ROR8r1,
  ROR8r1_EVEX,
  ROR8r1_ND,
  ROR8r1_NF,
  ROR8r1_NF_ND,
  ROR8rCL,
  ROR8rCL_EVEX,
  ROR8rCL_ND,
  ROR8rCL_NF,
  ROR8rCL_NF_ND,
  ROR8ri,
  ROR8ri_EVEX,
  ROR8ri_ND,
  ROR8ri_NF,
  ROR8ri_NF_ND,
  RORX32mi,
  RORX32mi_EVEX,
  RORX32ri,
  RORX32ri_EVEX,
  RORX64mi,
  RORX64mi_EVEX,
  RORX64ri,
  RORX64ri_EVEX,
  ROUNDPDmi,
  ROUNDPDri,
  ROUNDPSmi,
  ROUNDPSri,
  ROUNDSDmi,
  ROUNDSDmi_Int,
  ROUNDSDri,
  ROUNDSDri_Int,
  ROUNDSSmi,
  ROUNDSSmi_Int,
  ROUNDSSri,
  ROUNDSSri_Int,
  RSM,
  RSQRTPSm,
  RSQRTPSr,
  RSQRTSSm,
  RSQRTSSm_Int,
  RSQRTSSr,
  RSQRTSSr_Int,
  RSTORSSP,
  SAHF,
  SALC,
  SAR16m1,
  SAR16m1_EVEX,
  SAR16m1_ND,
  SAR16m1_NF,
  SAR16m1_NF_ND,
  SAR16mCL,
  SAR16mCL_EVEX,
  SAR16mCL_ND,
  SAR16mCL_NF,
  SAR16mCL_NF_ND,
  SAR16mi,
  SAR16mi_EVEX,
  SAR16mi_ND,
  SAR16mi_NF,
  SAR16mi_NF_ND,
  SAR16r1,
  SAR16r1_EVEX,
  SAR16r1_ND,
  SAR16r1_NF,
  SAR16r1_NF_ND,
  SAR16rCL,
  SAR16rCL_EVEX,
  SAR16rCL_ND,
  SAR16rCL_NF,
  SAR16rCL_NF_ND,
  SAR16ri,
  SAR16ri_EVEX,
  SAR16ri_ND,
  SAR16ri_NF,
  SAR16ri_NF_ND,
  SAR32m1,
  SAR32m1_EVEX,
  SAR32m1_ND,
  SAR32m1_NF,
  SAR32m1_NF_ND,
  SAR32mCL,
  SAR32mCL_EVEX,
  SAR32mCL_ND,
  SAR32mCL_NF,
  SAR32mCL_NF_ND,
  SAR32mi,
  SAR32mi_EVEX,
  SAR32mi_ND,
  SAR32mi_NF,
  SAR32mi_NF_ND,
  SAR32r1,
  SAR32r1_EVEX,
  SAR32r1_ND,
  SAR32r1_NF,
  SAR32r1_NF_ND,
  SAR32rCL,
  SAR32rCL_EVEX,
  SAR32rCL_ND,
  SAR32rCL_NF,
  SAR32rCL_NF_ND,
  SAR32ri,
  SAR32ri_EVEX,
  SAR32ri_ND,
  SAR32ri_NF,
  SAR32ri_NF_ND,
  SAR64m1,
  SAR64m1_EVEX,
  SAR64m1_ND,
  SAR64m1_NF,
  SAR64m1_NF_ND,
  SAR64mCL,
  SAR64mCL_EVEX,
  SAR64mCL_ND,
  SAR64mCL_NF,
  SAR64mCL_NF_ND,
  SAR64mi,
  SAR64mi_EVEX,
  SAR64mi_ND,
  SAR64mi_NF,
  SAR64mi_NF_ND,
  SAR64r1,
  SAR64r1_EVEX,
  SAR64r1_ND,
  SAR64r1_NF,
  SAR64r1_NF_ND,
  SAR64rCL,
  SAR64rCL_EVEX,
  SAR64rCL_ND,
  SAR64rCL_NF,
  SAR64rCL_NF_ND,
  SAR64ri,
  SAR64ri_EVEX,
  SAR64ri_ND,
  SAR64ri_NF,
  SAR64ri_NF_ND,
  SAR8m1,
  SAR8m1_EVEX,
  SAR8m1_ND,
  SAR8m1_NF,
  SAR8m1_NF_ND,
  SAR8mCL,
  SAR8mCL_EVEX,
  SAR8mCL_ND,
  SAR8mCL_NF,
  SAR8mCL_NF_ND,
  SAR8mi,
  SAR8mi_EVEX,
  SAR8mi_ND,
  SAR8mi_NF,
  SAR8mi_NF_ND,
  SAR8r1,
  SAR8r1_EVEX,
  SAR8r1_ND,
  SAR8r1_NF,
  SAR8r1_NF_ND,
  SAR8rCL,
  SAR8rCL_EVEX,
  SAR8rCL_ND,
  SAR8rCL_NF,
  SAR8rCL_NF_ND,
  SAR8ri,
  SAR8ri_EVEX,
  SAR8ri_ND,
  SAR8ri_NF,
  SAR8ri_NF_ND,
  SARX32rm,
  SARX32rm_EVEX,
  SARX32rr,
  SARX32rr_EVEX,
  SARX64rm,
  SARX64rm_EVEX,
  SARX64rr,
  SARX64rr_EVEX,
  SAVEPREVSSP,
  SBB16i16,
  SBB16mi,
  SBB16mi8,
  SBB16mi8_EVEX,
  SBB16mi8_ND,
  SBB16mi_EVEX,
  SBB16mi_ND,
  SBB16mr,
  SBB16mr_EVEX,
  SBB16mr_ND,
  SBB16ri,
  SBB16ri8,
  SBB16ri8_EVEX,
  SBB16ri8_ND,
  SBB16ri_EVEX,
  SBB16ri_ND,
  SBB16rm,
  SBB16rm_EVEX,
  SBB16rm_ND,
  SBB16rr,
  SBB16rr_EVEX,
  SBB16rr_EVEX_REV,
  SBB16rr_ND,
  SBB16rr_ND_REV,
  SBB16rr_REV,
  SBB32i32,
  SBB32mi,
  SBB32mi8,
  SBB32mi8_EVEX,
  SBB32mi8_ND,
  SBB32mi_EVEX,
  SBB32mi_ND,
  SBB32mr,
  SBB32mr_EVEX,
  SBB32mr_ND,
  SBB32ri,
  SBB32ri8,
  SBB32ri8_EVEX,
  SBB32ri8_ND,
  SBB32ri_EVEX,
  SBB32ri_ND,
  SBB32rm,
  SBB32rm_EVEX,
  SBB32rm_ND,
  SBB32rr,
  SBB32rr_EVEX,
  SBB32rr_EVEX_REV,
  SBB32rr_ND,
  SBB32rr_ND_REV,
  SBB32rr_REV,
  SBB64i32,
  SBB64mi32,
  SBB64mi32_EVEX,
  SBB64mi32_ND,
  SBB64mi8,
  SBB64mi8_EVEX,
  SBB64mi8_ND,
  SBB64mr,
  SBB64mr_EVEX,
  SBB64mr_ND,
  SBB64ri32,
  SBB64ri32_EVEX,
  SBB64ri32_ND,
  SBB64ri8,
  SBB64ri8_EVEX,
  SBB64ri8_ND,
  SBB64rm,
  SBB64rm_EVEX,
  SBB64rm_ND,
  SBB64rr,
  SBB64rr_EVEX,
  SBB64rr_EVEX_REV,
  SBB64rr_ND,
  SBB64rr_ND_REV,
  SBB64rr_REV,
  SBB8i8,
  SBB8mi,
  SBB8mi8,
  SBB8mi_EVEX,
  SBB8mi_ND,
  SBB8mr,
  SBB8mr_EVEX,
  SBB8mr_ND,
  SBB8ri,
  SBB8ri8,
  SBB8ri_EVEX,
  SBB8ri_ND,
  SBB8rm,
  SBB8rm_EVEX,
  SBB8rm_ND,
  SBB8rr,
  SBB8rr_EVEX,
  SBB8rr_EVEX_REV,
  SBB8rr_ND,
  SBB8rr_ND_REV,
  SBB8rr_REV,
  SCASB,
  SCASL,
  SCASQ,
  SCASW,
  SEAMCALL,
  SEAMOPS,
  SEAMRET,
  SEG_ALLOCA_32,
  SEG_ALLOCA_64,
  SENDUIPI,
  SERIALIZE,
  SETCCm,
  SETCCm_EVEX,
  SETCCr,
  SETCCr_EVEX,
  SETSSBSY,
  SETZUCCm,
  SETZUCCr,
  SFENCE,
  SGDT16m,
  SGDT32m,
  SGDT64m,
  SHA1MSG1rm,
  SHA1MSG1rr,
  SHA1MSG2rm,
  SHA1MSG2rr,
  SHA1NEXTErm,
  SHA1NEXTErr,
  SHA1RNDS4rmi,
  SHA1RNDS4rri,
  SHA256MSG1rm,
  SHA256MSG1rr,
  SHA256MSG2rm,
  SHA256MSG2rr,
  SHA256RNDS2rm,
  SHA256RNDS2rr,
  SHL16m1,
  SHL16m1_EVEX,
  SHL16m1_ND,
  SHL16m1_NF,
  SHL16m1_NF_ND,
  SHL16mCL,
  SHL16mCL_EVEX,
  SHL16mCL_ND,
  SHL16mCL_NF,
  SHL16mCL_NF_ND,
  SHL16mi,
  SHL16mi_EVEX,
  SHL16mi_ND,
  SHL16mi_NF,
  SHL16mi_NF_ND,
  SHL16r1,
  SHL16r1_EVEX,
  SHL16r1_ND,
  SHL16r1_NF,
  SHL16r1_NF_ND,
  SHL16rCL,
  SHL16rCL_EVEX,
  SHL16rCL_ND,
  SHL16rCL_NF,
  SHL16rCL_NF_ND,
  SHL16ri,
  SHL16ri_EVEX,
  SHL16ri_ND,
  SHL16ri_NF,
  SHL16ri_NF_ND,
  SHL32m1,
  SHL32m1_EVEX,
  SHL32m1_ND,
  SHL32m1_NF,
  SHL32m1_NF_ND,
  SHL32mCL,
  SHL32mCL_EVEX,
  SHL32mCL_ND,
  SHL32mCL_NF,
  SHL32mCL_NF_ND,
  SHL32mi,
  SHL32mi_EVEX,
  SHL32mi_ND,
  SHL32mi_NF,
  SHL32mi_NF_ND,
  SHL32r1,
  SHL32r1_EVEX,
  SHL32r1_ND,
  SHL32r1_NF,
  SHL32r1_NF_ND,
  SHL32rCL,
  SHL32rCL_EVEX,
  SHL32rCL_ND,
  SHL32rCL_NF,
  SHL32rCL_NF_ND,
  SHL32ri,
  SHL32ri_EVEX,
  SHL32ri_ND,
  SHL32ri_NF,
  SHL32ri_NF_ND,
  SHL64m1,
  SHL64m1_EVEX,
  SHL64m1_ND,
  SHL64m1_NF,
  SHL64m1_NF_ND,
  SHL64mCL,
  SHL64mCL_EVEX,
  SHL64mCL_ND,
  SHL64mCL_NF,
  SHL64mCL_NF_ND,
  SHL64mi,
  SHL64mi_EVEX,
  SHL64mi_ND,
  SHL64mi_NF,
  SHL64mi_NF_ND,
  SHL64r1,
  SHL64r1_EVEX,
  SHL64r1_ND,
  SHL64r1_NF,
  SHL64r1_NF_ND,
  SHL64rCL,
  SHL64rCL_EVEX,
  SHL64rCL_ND,
  SHL64rCL_NF,
  SHL64rCL_NF_ND,
  SHL64ri,
  SHL64ri_EVEX,
  SHL64ri_ND,
  SHL64ri_NF,
  SHL64ri_NF_ND,
  SHL8m1,
  SHL8m1_EVEX,
  SHL8m1_ND,
  SHL8m1_NF,
  SHL8m1_NF_ND,
  SHL8mCL,
  SHL8mCL_EVEX,
  SHL8mCL_ND,
  SHL8mCL_NF,
  SHL8mCL_NF_ND,
  SHL8mi,
  SHL8mi_EVEX,
  SHL8mi_ND,
  SHL8mi_NF,
  SHL8mi_NF_ND,
  SHL8r1,
  SHL8r1_EVEX,
  SHL8r1_ND,
  SHL8r1_NF,
  SHL8r1_NF_ND,
  SHL8rCL,
  SHL8rCL_EVEX,
  SHL8rCL_ND,
  SHL8rCL_NF,
  SHL8rCL_NF_ND,
  SHL8ri,
  SHL8ri_EVEX,
  SHL8ri_ND,
  SHL8ri_NF,
  SHL8ri_NF_ND,
  SHLD16mrCL,
  SHLD16mrCL_EVEX,
  SHLD16mrCL_ND,
  SHLD16mrCL_NF,
  SHLD16mrCL_NF_ND,
  SHLD16mri8,
  SHLD16mri8_EVEX,
  SHLD16mri8_ND,
  SHLD16mri8_NF,
  SHLD16mri8_NF_ND,
  SHLD16rrCL,
  SHLD16rrCL_EVEX,
  SHLD16rrCL_ND,
  SHLD16rrCL_NF,
  SHLD16rrCL_NF_ND,
  SHLD16rri8,
  SHLD16rri8_EVEX,
  SHLD16rri8_ND,
  SHLD16rri8_NF,
  SHLD16rri8_NF_ND,
  SHLD32mrCL,
  SHLD32mrCL_EVEX,
  SHLD32mrCL_ND,
  SHLD32mrCL_NF,
  SHLD32mrCL_NF_ND,
  SHLD32mri8,
  SHLD32mri8_EVEX,
  SHLD32mri8_ND,
  SHLD32mri8_NF,
  SHLD32mri8_NF_ND,
  SHLD32rrCL,
  SHLD32rrCL_EVEX,
  SHLD32rrCL_ND,
  SHLD32rrCL_NF,
  SHLD32rrCL_NF_ND,
  SHLD32rri8,
  SHLD32rri8_EVEX,
  SHLD32rri8_ND,
  SHLD32rri8_NF,
  SHLD32rri8_NF_ND,
  SHLD64mrCL,
  SHLD64mrCL_EVEX,
  SHLD64mrCL_ND,
  SHLD64mrCL_NF,
  SHLD64mrCL_NF_ND,
  SHLD64mri8,
  SHLD64mri8_EVEX,
  SHLD64mri8_ND,
  SHLD64mri8_NF,
  SHLD64mri8_NF_ND,
  SHLD64rrCL,
  SHLD64rrCL_EVEX,
  SHLD64rrCL_ND,
  SHLD64rrCL_NF,
  SHLD64rrCL_NF_ND,
  SHLD64rri8,
  SHLD64rri8_EVEX,
  SHLD64rri8_ND,
  SHLD64rri8_NF,
  SHLD64rri8_NF_ND,
  SHLX32rm,
  SHLX32rm_EVEX,
  SHLX32rr,
  SHLX32rr_EVEX,
  SHLX64rm,
  SHLX64rm_EVEX,
  SHLX64rr,
  SHLX64rr_EVEX,
  SHR16m1,
  SHR16m1_EVEX,
  SHR16m1_ND,
  SHR16m1_NF,
  SHR16m1_NF_ND,
  SHR16mCL,
  SHR16mCL_EVEX,
  SHR16mCL_ND,
  SHR16mCL_NF,
  SHR16mCL_NF_ND,
  SHR16mi,
  SHR16mi_EVEX,
  SHR16mi_ND,
  SHR16mi_NF,
  SHR16mi_NF_ND,
  SHR16r1,
  SHR16r1_EVEX,
  SHR16r1_ND,
  SHR16r1_NF,
  SHR16r1_NF_ND,
  SHR16rCL,
  SHR16rCL_EVEX,
  SHR16rCL_ND,
  SHR16rCL_NF,
  SHR16rCL_NF_ND,
  SHR16ri,
  SHR16ri_EVEX,
  SHR16ri_ND,
  SHR16ri_NF,
  SHR16ri_NF_ND,
  SHR32m1,
  SHR32m1_EVEX,
  SHR32m1_ND,
  SHR32m1_NF,
  SHR32m1_NF_ND,
  SHR32mCL,
  SHR32mCL_EVEX,
  SHR32mCL_ND,
  SHR32mCL_NF,
  SHR32mCL_NF_ND,
  SHR32mi,
  SHR32mi_EVEX,
  SHR32mi_ND,
  SHR32mi_NF,
  SHR32mi_NF_ND,
  SHR32r1,
  SHR32r1_EVEX,
  SHR32r1_ND,
  SHR32r1_NF,
  SHR32r1_NF_ND,
  SHR32rCL,
  SHR32rCL_EVEX,
  SHR32rCL_ND,
  SHR32rCL_NF,
  SHR32rCL_NF_ND,
  SHR32ri,
  SHR32ri_EVEX,
  SHR32ri_ND,
  SHR32ri_NF,
  SHR32ri_NF_ND,
  SHR64m1,
  SHR64m1_EVEX,
  SHR64m1_ND,
  SHR64m1_NF,
  SHR64m1_NF_ND,
  SHR64mCL,
  SHR64mCL_EVEX,
  SHR64mCL_ND,
  SHR64mCL_NF,
  SHR64mCL_NF_ND,
  SHR64mi,
  SHR64mi_EVEX,
  SHR64mi_ND,
  SHR64mi_NF,
  SHR64mi_NF_ND,
  SHR64r1,
  SHR64r1_EVEX,
  SHR64r1_ND,
  SHR64r1_NF,
  SHR64r1_NF_ND,
  SHR64rCL,
  SHR64rCL_EVEX,
  SHR64rCL_ND,
  SHR64rCL_NF,
  SHR64rCL_NF_ND,
  SHR64ri,
  SHR64ri_EVEX,
  SHR64ri_ND,
  SHR64ri_NF,
  SHR64ri_NF_ND,
  SHR8m1,
  SHR8m1_EVEX,
  SHR8m1_ND,
  SHR8m1_NF,
  SHR8m1_NF_ND,
  SHR8mCL,
  SHR8mCL_EVEX,
  SHR8mCL_ND,
  SHR8mCL_NF,
  SHR8mCL_NF_ND,
  SHR8mi,
  SHR8mi_EVEX,
  SHR8mi_ND,
  SHR8mi_NF,
  SHR8mi_NF_ND,
  SHR8r1,
  SHR8r1_EVEX,
  SHR8r1_ND,
  SHR8r1_NF,
  SHR8r1_NF_ND,
  SHR8rCL,
  SHR8rCL_EVEX,
  SHR8rCL_ND,
  SHR8rCL_NF,
  SHR8rCL_NF_ND,
  SHR8ri,
  SHR8ri_EVEX,
  SHR8ri_ND,
  SHR8ri_NF,
  SHR8ri_NF_ND,
  SHRD16mrCL,
  SHRD16mrCL_EVEX,
  SHRD16mrCL_ND,
  SHRD16mrCL_NF,
  SHRD16mrCL_NF_ND,
  SHRD16mri8,
  SHRD16mri8_EVEX,
  SHRD16mri8_ND,
  SHRD16mri8_NF,
  SHRD16mri8_NF_ND,
  SHRD16rrCL,
  SHRD16rrCL_EVEX,
  SHRD16rrCL_ND,
  SHRD16rrCL_NF,
  SHRD16rrCL_NF_ND,
  SHRD16rri8,
  SHRD16rri8_EVEX,
  SHRD16rri8_ND,
  SHRD16rri8_NF,
  SHRD16rri8_NF_ND,
  SHRD32mrCL,
  SHRD32mrCL_EVEX,
  SHRD32mrCL_ND,
  SHRD32mrCL_NF,
  SHRD32mrCL_NF_ND,
  SHRD32mri8,
  SHRD32mri8_EVEX,
  SHRD32mri8_ND,
  SHRD32mri8_NF,
  SHRD32mri8_NF_ND,
  SHRD32rrCL,
  SHRD32rrCL_EVEX,
  SHRD32rrCL_ND,
  SHRD32rrCL_NF,
  SHRD32rrCL_NF_ND,
  SHRD32rri8,
  SHRD32rri8_EVEX,
  SHRD32rri8_ND,
  SHRD32rri8_NF,
  SHRD32rri8_NF_ND,
  SHRD64mrCL,
  SHRD64mrCL_EVEX,
  SHRD64mrCL_ND,
  SHRD64mrCL_NF,
  SHRD64mrCL_NF_ND,
  SHRD64mri8,
  SHRD64mri8_EVEX,
  SHRD64mri8_ND,
  SHRD64mri8_NF,
  SHRD64mri8_NF_ND,
  SHRD64rrCL,
  SHRD64rrCL_EVEX,
  SHRD64rrCL_ND,
  SHRD64rrCL_NF,
  SHRD64rrCL_NF_ND,
  SHRD64rri8,
  SHRD64rri8_EVEX,
  SHRD64rri8_ND,
  SHRD64rri8_NF,
  SHRD64rri8_NF_ND,
  SHRX32rm,
  SHRX32rm_EVEX,
  SHRX32rr,
  SHRX32rr_EVEX,
  SHRX64rm,
  SHRX64rm_EVEX,
  SHRX64rr,
  SHRX64rr_EVEX,
  SHUFPDrmi,
  SHUFPDrri,
  SHUFPSrmi,
  SHUFPSrri,
  SIDT16m,
  SIDT32m,
  SIDT64m,
  SKINIT,
  SLDT16m,
  SLDT16r,
  SLDT32r,
  SLDT64r,
  SLWPCB,
  SLWPCB64,
  SMSW16m,
  SMSW16r,
  SMSW32r,
  SMSW64r,
  SQRTPDm,
  SQRTPDr,
  SQRTPSm,
  SQRTPSr,
  SQRTSDm,
  SQRTSDm_Int,
  SQRTSDr,
  SQRTSDr_Int,
  SQRTSSm,
  SQRTSSm_Int,
  SQRTSSr,
  SQRTSSr_Int,
  SQRT_F,
  SQRT_Fp32,
  SQRT_Fp64,
  SQRT_Fp80,
  SS_PREFIX,
  STAC,
  STACKALLOC_W_PROBING,
  STC,
  STD,
  STGI,
  STI,
  STMXCSR,
  STOSB,
  STOSL,
  STOSQ,
  STOSW,
  STR16r,
  STR32r,
  STR64r,
  STRm,
  STTILECFG,
  STTILECFG_EVEX,
  STUI,
  ST_F32m,
  ST_F64m,
  ST_FP32m,
  ST_FP64m,
  ST_FP80m,
  ST_FPrr,
  ST_Fp32m,
  ST_Fp64m,
  ST_Fp64m32,
  ST_Fp80m32,
  ST_Fp80m64,
  ST_FpP32m,
  ST_FpP64m,
  ST_FpP64m32,
  ST_FpP80m,
  ST_FpP80m32,
  ST_FpP80m64,
  ST_Frr,
  SUB16i16,
  SUB16mi,
  SUB16mi8,
  SUB16mi8_EVEX,
  SUB16mi8_ND,
  SUB16mi8_NF,
  SUB16mi8_NF_ND,
  SUB16mi_EVEX,
  SUB16mi_ND,
  SUB16mi_NF,
  SUB16mi_NF_ND,
  SUB16mr,
  SUB16mr_EVEX,
  SUB16mr_ND,
  SUB16mr_NF,
  SUB16mr_NF_ND,
  SUB16ri,
  SUB16ri8,
  SUB16ri8_EVEX,
  SUB16ri8_ND,
  SUB16ri8_NF,
  SUB16ri8_NF_ND,
  SUB16ri_EVEX,
  SUB16ri_ND,
  SUB16ri_NF,
  SUB16ri_NF_ND,
  SUB16rm,
  SUB16rm_EVEX,
  SUB16rm_ND,
  SUB16rm_NF,
  SUB16rm_NF_ND,
  SUB16rr,
  SUB16rr_EVEX,
  SUB16rr_EVEX_REV,
  SUB16rr_ND,
  SUB16rr_ND_REV,
  SUB16rr_NF,
  SUB16rr_NF_ND,
  SUB16rr_NF_ND_REV,
  SUB16rr_NF_REV,
  SUB16rr_REV,
  SUB32i32,
  SUB32mi,
  SUB32mi8,
  SUB32mi8_EVEX,
  SUB32mi8_ND,
  SUB32mi8_NF,
  SUB32mi8_NF_ND,
  SUB32mi_EVEX,
  SUB32mi_ND,
  SUB32mi_NF,
  SUB32mi_NF_ND,
  SUB32mr,
  SUB32mr_EVEX,
  SUB32mr_ND,
  SUB32mr_NF,
  SUB32mr_NF_ND,
  SUB32ri,
  SUB32ri8,
  SUB32ri8_EVEX,
  SUB32ri8_ND,
  SUB32ri8_NF,
  SUB32ri8_NF_ND,
  SUB32ri_EVEX,
  SUB32ri_ND,
  SUB32ri_NF,
  SUB32ri_NF_ND,
  SUB32rm,
  SUB32rm_EVEX,
  SUB32rm_ND,
  SUB32rm_NF,
  SUB32rm_NF_ND,
  SUB32rr,
  SUB32rr_EVEX,
  SUB32rr_EVEX_REV,
  SUB32rr_ND,
  SUB32rr_ND_REV,
  SUB32rr_NF,
  SUB32rr_NF_ND,
  SUB32rr_NF_ND_REV,
  SUB32rr_NF_REV,
  SUB32rr_REV,
  SUB64i32,
  SUB64mi32,
  SUB64mi32_EVEX,
  SUB64mi32_ND,
  SUB64mi32_NF,
  SUB64mi32_NF_ND,
  SUB64mi8,
  SUB64mi8_EVEX,
  SUB64mi8_ND,
  SUB64mi8_NF,
  SUB64mi8_NF_ND,
  SUB64mr,
  SUB64mr_EVEX,
  SUB64mr_ND,
  SUB64mr_NF,
  SUB64mr_NF_ND,
  SUB64ri32,
  SUB64ri32_EVEX,
  SUB64ri32_ND,
  SUB64ri32_NF,
  SUB64ri32_NF_ND,
  SUB64ri8,
  SUB64ri8_EVEX,
  SUB64ri8_ND,
  SUB64ri8_NF,
  SUB64ri8_NF_ND,
  SUB64rm,
  SUB64rm_EVEX,
  SUB64rm_ND,
  SUB64rm_NF,
  SUB64rm_NF_ND,
  SUB64rr,
  SUB64rr_EVEX,
  SUB64rr_EVEX_REV,
  SUB64rr_ND,
  SUB64rr_ND_REV,
  SUB64rr_NF,
  SUB64rr_NF_ND,
  SUB64rr_NF_ND_REV,
  SUB64rr_NF_REV,
  SUB64rr_REV,
  SUB8i8,
  SUB8mi,
  SUB8mi8,
  SUB8mi_EVEX,
  SUB8mi_ND,
  SUB8mi_NF,
  SUB8mi_NF_ND,
  SUB8mr,
  SUB8mr_EVEX,
  SUB8mr_ND,
  SUB8mr_NF,
  SUB8mr_NF_ND,
  SUB8ri,
  SUB8ri8,
  SUB8ri_EVEX,
  SUB8ri_ND,
  SUB8ri_NF,
  SUB8ri_NF_ND,
  SUB8rm,
  SUB8rm_EVEX,
  SUB8rm_ND,
  SUB8rm_NF,
  SUB8rm_NF_ND,
  SUB8rr,
  SUB8rr_EVEX,
  SUB8rr_EVEX_REV,
  SUB8rr_ND,
  SUB8rr_ND_REV,
  SUB8rr_NF,
  SUB8rr_NF_ND,
  SUB8rr_NF_ND_REV,
  SUB8rr_NF_REV,
  SUB8rr_REV,
  SUBPDrm,
  SUBPDrr,
  SUBPSrm,
  SUBPSrr,
  SUBR_F32m,
  SUBR_F64m,
  SUBR_FI16m,
  SUBR_FI32m,
  SUBR_FPrST0,
  SUBR_FST0r,
  SUBR_Fp32m,
  SUBR_Fp64m,
  SUBR_Fp64m32,
  SUBR_Fp80m32,
  SUBR_Fp80m64,
  SUBR_FpI16m32,
  SUBR_FpI16m64,
  SUBR_FpI16m80,
  SUBR_FpI32m32,
  SUBR_FpI32m64,
  SUBR_FpI32m80,
  SUBR_FrST0,
  SUBSDrm,
  SUBSDrm_Int,
  SUBSDrr,
  SUBSDrr_Int,
  SUBSSrm,
  SUBSSrm_Int,
  SUBSSrr,
  SUBSSrr_Int,
  SUB_F32m,
  SUB_F64m,
  SUB_FI16m,
  SUB_FI32m,
  SUB_FPrST0,
  SUB_FST0r,
  SUB_Fp32,
  SUB_Fp32m,
  SUB_Fp64,
  SUB_Fp64m,
  SUB_Fp64m32,
  SUB_Fp80,
  SUB_Fp80m32,
  SUB_Fp80m64,
  SUB_FpI16m32,
  SUB_FpI16m64,
  SUB_FpI16m80,
  SUB_FpI32m32,
  SUB_FpI32m64,
  SUB_FpI32m80,
  SUB_FrST0,
  SWAPGS,
  SYSCALL,
  SYSENTER,
  SYSEXIT,
  SYSEXIT64,
  SYSRET,
  SYSRET64,
  T1MSKC32rm,
  T1MSKC32rr,
  T1MSKC64rm,
  T1MSKC64rr,
  T2RPNTLVWZ0,
  T2RPNTLVWZ0RS,
  T2RPNTLVWZ0RST1,
  T2RPNTLVWZ0RST1_EVEX,
  T2RPNTLVWZ0RS_EVEX,
  T2RPNTLVWZ0T1,
  T2RPNTLVWZ0T1_EVEX,
  T2RPNTLVWZ0_EVEX,
  T2RPNTLVWZ1,
  T2RPNTLVWZ1RS,
  T2RPNTLVWZ1RST1,
  T2RPNTLVWZ1RST1_EVEX,
  T2RPNTLVWZ1RS_EVEX,
  T2RPNTLVWZ1T1,
  T2RPNTLVWZ1T1_EVEX,
  T2RPNTLVWZ1_EVEX,
  TAILJMPd,
  TAILJMPd64,
  TAILJMPd64_CC,
  TAILJMPd_CC,
  TAILJMPm,
  TAILJMPm64,
  TAILJMPm64_REX,
  TAILJMPr,
  TAILJMPr64,
  TAILJMPr64_REX,
  TCMMIMFP16PS,
  TCMMRLFP16PS,
  TCONJTCMMIMFP16PS,
  TCONJTFP16,
  TCRETURNdi,
  TCRETURNdi64,
  TCRETURNdi64cc,
  TCRETURNdicc,
  TCRETURNmi,
  TCRETURNmi64,
  TCRETURNri,
  TCRETURNri64,
  TCRETURNri64_ImpCall,
  TCVTROWD2PSrre,
  TCVTROWD2PSrri,
  TCVTROWPS2BF16Hrre,
  TCVTROWPS2BF16Hrri,
  TCVTROWPS2BF16Lrre,
  TCVTROWPS2BF16Lrri,
  TCVTROWPS2PHHrre,
  TCVTROWPS2PHHrri,
  TCVTROWPS2PHLrre,
  TCVTROWPS2PHLrri,
  TDCALL,
  TDPBF16PS,
  TDPBF8PS,
  TDPBHF8PS,
  TDPBSSD,
  TDPBSUD,
  TDPBUSD,
  TDPBUUD,
  TDPFP16PS,
  TDPHBF8PS,
  TDPHF8PS,
  TEST16i16,
  TEST16mi,
  TEST16mr,
  TEST16ri,
  TEST16rr,
  TEST32i32,
  TEST32mi,
  TEST32mr,
  TEST32ri,
  TEST32rr,
  TEST64i32,
  TEST64mi32,
  TEST64mr,
  TEST64ri32,
  TEST64rr,
  TEST8i8,
  TEST8mi,
  TEST8mr,
  TEST8ri,
  TEST8rr,
  TESTUI,
  TILELOADD,
  TILELOADDRS,
  TILELOADDRST1,
  TILELOADDRST1_EVEX,
  TILELOADDRS_EVEX,
  TILELOADDT1,
  TILELOADDT1_EVEX,
  TILELOADD_EVEX,
  TILEMOVROWrre,
  TILEMOVROWrri,
  TILERELEASE,
  TILESTORED,
  TILESTORED_EVEX,
  TILEZERO,
  TLBSYNC,
  TLSCall_32,
  TLSCall_64,
  TLS_addr32,
  TLS_addr64,
  TLS_addrX32,
  TLS_base_addr32,
  TLS_base_addr64,
  TLS_base_addrX32,
  TLS_desc32,
  TLS_desc64,
  TMMULTF32PS,
  TPAUSE,
  TRAP,
  TST_F,
  TST_Fp32,
  TST_Fp64,
  TST_Fp80,
  TTCMMIMFP16PS,
  TTCMMRLFP16PS,
  TTDPBF16PS,
  TTDPFP16PS,
  TTMMULTF32PS,
  TTRANSPOSED,
  TZCNT16rm,
  TZCNT16rm_EVEX,
  TZCNT16rm_NF,
  TZCNT16rr,
  TZCNT16rr_EVEX,
  TZCNT16rr_NF,
  TZCNT32rm,
  TZCNT32rm_EVEX,
  TZCNT32rm_NF,
  TZCNT32rr,
  TZCNT32rr_EVEX,
  TZCNT32rr_NF,
  TZCNT64rm,
  TZCNT64rm_EVEX,
  TZCNT64rm_NF,
  TZCNT64rr,
  TZCNT64rr_EVEX,
  TZCNT64rr_NF,
  TZMSK32rm,
  TZMSK32rr,
  TZMSK64rm,
  TZMSK64rr,
  UBSAN_UD1,
  UCOMISDrm,
  UCOMISDrm_Int,
  UCOMISDrr,
  UCOMISDrr_Int,
  UCOMISSrm,
  UCOMISSrm_Int,
  UCOMISSrr,
  UCOMISSrr_Int,
  UCOM_FIPr,
  UCOM_FIr,
  UCOM_FPPr,
  UCOM_FPr,
  UCOM_FpIr32,
  UCOM_FpIr64,
  UCOM_FpIr80,
  UCOM_Fpr32,
  UCOM_Fpr64,
  UCOM_Fpr80,
  UCOM_Fr,
  UD1Lm,
  UD1Lr,
  UD1Qm,
  UD1Qr,
  UD1Wm,
  UD1Wr,
  UIRET,
  UMONITOR16,
  UMONITOR32,
  UMONITOR64,
  UMWAIT,
  UNPCKHPDrm,
  UNPCKHPDrr,
  UNPCKHPSrm,
  UNPCKHPSrr,
  UNPCKLPDrm,
  UNPCKLPDrr,
  UNPCKLPSrm,
  UNPCKLPSrr,
  URDMSRri,
  URDMSRri_EVEX,
  URDMSRrr,
  URDMSRrr_EVEX,
  UWRMSRir,
  UWRMSRir_EVEX,
  UWRMSRrr,
  UWRMSRrr_EVEX,
  V4FMADDPSrm,
  V4FMADDPSrmk,
  V4FMADDPSrmkz,
  V4FMADDSSrm,
  V4FMADDSSrmk,
  V4FMADDSSrmkz,
  V4FNMADDPSrm,
  V4FNMADDPSrmk,
  V4FNMADDPSrmkz,
  V4FNMADDSSrm,
  V4FNMADDSSrmk,
  V4FNMADDSSrmkz,
  VAARG_64,
  VAARG_X32,
  VADDBF16Z128rm,
  VADDBF16Z128rmb,
  VADDBF16Z128rmbk,
  VADDBF16Z128rmbkz,
  VADDBF16Z128rmk,
  VADDBF16Z128rmkz,
  VADDBF16Z128rr,
  VADDBF16Z128rrk,
  VADDBF16Z128rrkz,
  VADDBF16Z256rm,
  VADDBF16Z256rmb,
  VADDBF16Z256rmbk,
  VADDBF16Z256rmbkz,
  VADDBF16Z256rmk,
  VADDBF16Z256rmkz,
  VADDBF16Z256rr,
  VADDBF16Z256rrk,
  VADDBF16Z256rrkz,
  VADDBF16Zrm,
  VADDBF16Zrmb,
  VADDBF16Zrmbk,
  VADDBF16Zrmbkz,
  VADDBF16Zrmk,
  VADDBF16Zrmkz,
  VADDBF16Zrr,
  VADDBF16Zrrk,
  VADDBF16Zrrkz,
  VADDPDYrm,
  VADDPDYrr,
  VADDPDZ128rm,
  VADDPDZ128rmb,
  VADDPDZ128rmbk,
  VADDPDZ128rmbkz,
  VADDPDZ128rmk,
  VADDPDZ128rmkz,
  VADDPDZ128rr,
  VADDPDZ128rrk,
  VADDPDZ128rrkz,
  VADDPDZ256rm,
  VADDPDZ256rmb,
  VADDPDZ256rmbk,
  VADDPDZ256rmbkz,
  VADDPDZ256rmk,
  VADDPDZ256rmkz,
  VADDPDZ256rr,
  VADDPDZ256rrk,
  VADDPDZ256rrkz,
  VADDPDZrm,
  VADDPDZrmb,
  VADDPDZrmbk,
  VADDPDZrmbkz,
  VADDPDZrmk,
  VADDPDZrmkz,
  VADDPDZrr,
  VADDPDZrrb,
  VADDPDZrrbk,
  VADDPDZrrbkz,
  VADDPDZrrk,
  VADDPDZrrkz,
  VADDPDrm,
  VADDPDrr,
  VADDPHZ128rm,
  VADDPHZ128rmb,
  VADDPHZ128rmbk,
  VADDPHZ128rmbkz,
  VADDPHZ128rmk,
  VADDPHZ128rmkz,
  VADDPHZ128rr,
  VADDPHZ128rrk,
  VADDPHZ128rrkz,
  VADDPHZ256rm,
  VADDPHZ256rmb,
  VADDPHZ256rmbk,
  VADDPHZ256rmbkz,
  VADDPHZ256rmk,
  VADDPHZ256rmkz,
  VADDPHZ256rr,
  VADDPHZ256rrk,
  VADDPHZ256rrkz,
  VADDPHZrm,
  VADDPHZrmb,
  VADDPHZrmbk,
  VADDPHZrmbkz,
  VADDPHZrmk,
  VADDPHZrmkz,
  VADDPHZrr,
  VADDPHZrrb,
  VADDPHZrrbk,
  VADDPHZrrbkz,
  VADDPHZrrk,
  VADDPHZrrkz,
  VADDPSYrm,
  VADDPSYrr,
  VADDPSZ128rm,
  VADDPSZ128rmb,
  VADDPSZ128rmbk,
  VADDPSZ128rmbkz,
  VADDPSZ128rmk,
  VADDPSZ128rmkz,
  VADDPSZ128rr,
  VADDPSZ128rrk,
  VADDPSZ128rrkz,
  VADDPSZ256rm,
  VADDPSZ256rmb,
  VADDPSZ256rmbk,
  VADDPSZ256rmbkz,
  VADDPSZ256rmk,
  VADDPSZ256rmkz,
  VADDPSZ256rr,
  VADDPSZ256rrk,
  VADDPSZ256rrkz,
  VADDPSZrm,
  VADDPSZrmb,
  VADDPSZrmbk,
  VADDPSZrmbkz,
  VADDPSZrmk,
  VADDPSZrmkz,
  VADDPSZrr,
  VADDPSZrrb,
  VADDPSZrrbk,
  VADDPSZrrbkz,
  VADDPSZrrk,
  VADDPSZrrkz,
  VADDPSrm,
  VADDPSrr,
  VADDSDZrm,
  VADDSDZrm_Int,
  VADDSDZrmk_Int,
  VADDSDZrmkz_Int,
  VADDSDZrr,
  VADDSDZrr_Int,
  VADDSDZrrb_Int,
  VADDSDZrrbk_Int,
  VADDSDZrrbkz_Int,
  VADDSDZrrk_Int,
  VADDSDZrrkz_Int,
  VADDSDrm,
  VADDSDrm_Int,
  VADDSDrr,
  VADDSDrr_Int,
  VADDSHZrm,
  VADDSHZrm_Int,
  VADDSHZrmk_Int,
  VADDSHZrmkz_Int,
  VADDSHZrr,
  VADDSHZrr_Int,
  VADDSHZrrb_Int,
  VADDSHZrrbk_Int,
  VADDSHZrrbkz_Int,
  VADDSHZrrk_Int,
  VADDSHZrrkz_Int,
  VADDSSZrm,
  VADDSSZrm_Int,
  VADDSSZrmk_Int,
  VADDSSZrmkz_Int,
  VADDSSZrr,
  VADDSSZrr_Int,
  VADDSSZrrb_Int,
  VADDSSZrrbk_Int,
  VADDSSZrrbkz_Int,
  VADDSSZrrk_Int,
  VADDSSZrrkz_Int,
  VADDSSrm,
  VADDSSrm_Int,
  VADDSSrr,
  VADDSSrr_Int,
  VADDSUBPDYrm,
  VADDSUBPDYrr,
  VADDSUBPDrm,
  VADDSUBPDrr,
  VADDSUBPSYrm,
  VADDSUBPSYrr,
  VADDSUBPSrm,
  VADDSUBPSrr,
  VAESDECLASTYrm,
  VAESDECLASTYrr,
  VAESDECLASTZ128rm,
  VAESDECLASTZ128rr,
  VAESDECLASTZ256rm,
  VAESDECLASTZ256rr,
  VAESDECLASTZrm,
  VAESDECLASTZrr,
  VAESDECLASTrm,
  VAESDECLASTrr,
  VAESDECYrm,
  VAESDECYrr,
  VAESDECZ128rm,
  VAESDECZ128rr,
  VAESDECZ256rm,
  VAESDECZ256rr,
  VAESDECZrm,
  VAESDECZrr,
  VAESDECrm,
  VAESDECrr,
  VAESENCLASTYrm,
  VAESENCLASTYrr,
  VAESENCLASTZ128rm,
  VAESENCLASTZ128rr,
  VAESENCLASTZ256rm,
  VAESENCLASTZ256rr,
  VAESENCLASTZrm,
  VAESENCLASTZrr,
  VAESENCLASTrm,
  VAESENCLASTrr,
  VAESENCYrm,
  VAESENCYrr,
  VAESENCZ128rm,
  VAESENCZ128rr,
  VAESENCZ256rm,
  VAESENCZ256rr,
  VAESENCZrm,
  VAESENCZrr,
  VAESENCrm,
  VAESENCrr,
  VAESIMCrm,
  VAESIMCrr,
  VAESKEYGENASSIST128rm,
  VAESKEYGENASSIST128rr,
  VALIGNDZ128rmbi,
  VALIGNDZ128rmbik,
  VALIGNDZ128rmbikz,
  VALIGNDZ128rmi,
  VALIGNDZ128rmik,
  VALIGNDZ128rmikz,
  VALIGNDZ128rri,
  VALIGNDZ128rrik,
  VALIGNDZ128rrikz,
  VALIGNDZ256rmbi,
  VALIGNDZ256rmbik,
  VALIGNDZ256rmbikz,
  VALIGNDZ256rmi,
  VALIGNDZ256rmik,
  VALIGNDZ256rmikz,
  VALIGNDZ256rri,
  VALIGNDZ256rrik,
  VALIGNDZ256rrikz,
  VALIGNDZrmbi,
  VALIGNDZrmbik,
  VALIGNDZrmbikz,
  VALIGNDZrmi,
  VALIGNDZrmik,
  VALIGNDZrmikz,
  VALIGNDZrri,
  VALIGNDZrrik,
  VALIGNDZrrikz,
  VALIGNQZ128rmbi,
  VALIGNQZ128rmbik,
  VALIGNQZ128rmbikz,
  VALIGNQZ128rmi,
  VALIGNQZ128rmik,
  VALIGNQZ128rmikz,
  VALIGNQZ128rri,
  VALIGNQZ128rrik,
  VALIGNQZ128rrikz,
  VALIGNQZ256rmbi,
  VALIGNQZ256rmbik,
  VALIGNQZ256rmbikz,
  VALIGNQZ256rmi,
  VALIGNQZ256rmik,
  VALIGNQZ256rmikz,
  VALIGNQZ256rri,
  VALIGNQZ256rrik,
  VALIGNQZ256rrikz,
  VALIGNQZrmbi,
  VALIGNQZrmbik,
  VALIGNQZrmbikz,
  VALIGNQZrmi,
  VALIGNQZrmik,
  VALIGNQZrmikz,
  VALIGNQZrri,
  VALIGNQZrrik,
  VALIGNQZrrikz,
  VANDNPDYrm,
  VANDNPDYrr,
  VANDNPDZ128rm,
  VANDNPDZ128rmb,
  VANDNPDZ128rmbk,
  VANDNPDZ128rmbkz,
  VANDNPDZ128rmk,
  VANDNPDZ128rmkz,
  VANDNPDZ128rr,
  VANDNPDZ128rrk,
  VANDNPDZ128rrkz,
  VANDNPDZ256rm,
  VANDNPDZ256rmb,
  VANDNPDZ256rmbk,
  VANDNPDZ256rmbkz,
  VANDNPDZ256rmk,
  VANDNPDZ256rmkz,
  VANDNPDZ256rr,
  VANDNPDZ256rrk,
  VANDNPDZ256rrkz,
  VANDNPDZrm,
  VANDNPDZrmb,
  VANDNPDZrmbk,
  VANDNPDZrmbkz,
  VANDNPDZrmk,
  VANDNPDZrmkz,
  VANDNPDZrr,
  VANDNPDZrrk,
  VANDNPDZrrkz,
  VANDNPDrm,
  VANDNPDrr,
  VANDNPSYrm,
  VANDNPSYrr,
  VANDNPSZ128rm,
  VANDNPSZ128rmb,
  VANDNPSZ128rmbk,
  VANDNPSZ128rmbkz,
  VANDNPSZ128rmk,
  VANDNPSZ128rmkz,
  VANDNPSZ128rr,
  VANDNPSZ128rrk,
  VANDNPSZ128rrkz,
  VANDNPSZ256rm,
  VANDNPSZ256rmb,
  VANDNPSZ256rmbk,
  VANDNPSZ256rmbkz,
  VANDNPSZ256rmk,
  VANDNPSZ256rmkz,
  VANDNPSZ256rr,
  VANDNPSZ256rrk,
  VANDNPSZ256rrkz,
  VANDNPSZrm,
  VANDNPSZrmb,
  VANDNPSZrmbk,
  VANDNPSZrmbkz,
  VANDNPSZrmk,
  VANDNPSZrmkz,
  VANDNPSZrr,
  VANDNPSZrrk,
  VANDNPSZrrkz,
  VANDNPSrm,
  VANDNPSrr,
  VANDPDYrm,
  VANDPDYrr,
  VANDPDZ128rm,
  VANDPDZ128rmb,
  VANDPDZ128rmbk,
  VANDPDZ128rmbkz,
  VANDPDZ128rmk,
  VANDPDZ128rmkz,
  VANDPDZ128rr,
  VANDPDZ128rrk,
  VANDPDZ128rrkz,
  VANDPDZ256rm,
  VANDPDZ256rmb,
  VANDPDZ256rmbk,
  VANDPDZ256rmbkz,
  VANDPDZ256rmk,
  VANDPDZ256rmkz,
  VANDPDZ256rr,
  VANDPDZ256rrk,
  VANDPDZ256rrkz,
  VANDPDZrm,
  VANDPDZrmb,
  VANDPDZrmbk,
  VANDPDZrmbkz,
  VANDPDZrmk,
  VANDPDZrmkz,
  VANDPDZrr,
  VANDPDZrrk,
  VANDPDZrrkz,
  VANDPDrm,
  VANDPDrr,
  VANDPSYrm,
  VANDPSYrr,
  VANDPSZ128rm,
  VANDPSZ128rmb,
  VANDPSZ128rmbk,
  VANDPSZ128rmbkz,
  VANDPSZ128rmk,
  VANDPSZ128rmkz,
  VANDPSZ128rr,
  VANDPSZ128rrk,
  VANDPSZ128rrkz,
  VANDPSZ256rm,
  VANDPSZ256rmb,
  VANDPSZ256rmbk,
  VANDPSZ256rmbkz,
  VANDPSZ256rmk,
  VANDPSZ256rmkz,
  VANDPSZ256rr,
  VANDPSZ256rrk,
  VANDPSZ256rrkz,
  VANDPSZrm,
  VANDPSZrmb,
  VANDPSZrmbk,
  VANDPSZrmbkz,
  VANDPSZrmk,
  VANDPSZrmkz,
  VANDPSZrr,
  VANDPSZrrk,
  VANDPSZrrkz,
  VANDPSrm,
  VANDPSrr,
  VASTART_SAVE_XMM_REGS,
  VBCSTNEBF162PSYrm,
  VBCSTNEBF162PSrm,
  VBCSTNESH2PSYrm,
  VBCSTNESH2PSrm,
  VBLENDMPDZ128rm,
  VBLENDMPDZ128rmb,
  VBLENDMPDZ128rmbk,
  VBLENDMPDZ128rmbkz,
  VBLENDMPDZ128rmk,
  VBLENDMPDZ128rmkz,
  VBLENDMPDZ128rr,
  VBLENDMPDZ128rrk,
  VBLENDMPDZ128rrkz,
  VBLENDMPDZ256rm,
  VBLENDMPDZ256rmb,
  VBLENDMPDZ256rmbk,
  VBLENDMPDZ256rmbkz,
  VBLENDMPDZ256rmk,
  VBLENDMPDZ256rmkz,
  VBLENDMPDZ256rr,
  VBLENDMPDZ256rrk,
  VBLENDMPDZ256rrkz,
  VBLENDMPDZrm,
  VBLENDMPDZrmb,
  VBLENDMPDZrmbk,
  VBLENDMPDZrmbkz,
  VBLENDMPDZrmk,
  VBLENDMPDZrmkz,
  VBLENDMPDZrr,
  VBLENDMPDZrrk,
  VBLENDMPDZrrkz,
  VBLENDMPSZ128rm,
  VBLENDMPSZ128rmb,
  VBLENDMPSZ128rmbk,
  VBLENDMPSZ128rmbkz,
  VBLENDMPSZ128rmk,
  VBLENDMPSZ128rmkz,
  VBLENDMPSZ128rr,
  VBLENDMPSZ128rrk,
  VBLENDMPSZ128rrkz,
  VBLENDMPSZ256rm,
  VBLENDMPSZ256rmb,
  VBLENDMPSZ256rmbk,
  VBLENDMPSZ256rmbkz,
  VBLENDMPSZ256rmk,
  VBLENDMPSZ256rmkz,
  VBLENDMPSZ256rr,
  VBLENDMPSZ256rrk,
  VBLENDMPSZ256rrkz,
  VBLENDMPSZrm,
  VBLENDMPSZrmb,
  VBLENDMPSZrmbk,
  VBLENDMPSZrmbkz,
  VBLENDMPSZrmk,
  VBLENDMPSZrmkz,
  VBLENDMPSZrr,
  VBLENDMPSZrrk,
  VBLENDMPSZrrkz,
  VBLENDPDYrmi,
  VBLENDPDYrri,
  VBLENDPDrmi,
  VBLENDPDrri,
  VBLENDPSYrmi,
  VBLENDPSYrri,
  VBLENDPSrmi,
  VBLENDPSrri,
  VBLENDVPDYrmr,
  VBLENDVPDYrrr,
  VBLENDVPDrmr,
  VBLENDVPDrrr,
  VBLENDVPSYrmr,
  VBLENDVPSYrrr,
  VBLENDVPSrmr,
  VBLENDVPSrrr,
  VBROADCASTF128rm,
  VBROADCASTF32X2Z256rm,
  VBROADCASTF32X2Z256rmk,
  VBROADCASTF32X2Z256rmkz,
  VBROADCASTF32X2Z256rr,
  VBROADCASTF32X2Z256rrk,
  VBROADCASTF32X2Z256rrkz,
  VBROADCASTF32X2Zrm,
  VBROADCASTF32X2Zrmk,
  VBROADCASTF32X2Zrmkz,
  VBROADCASTF32X2Zrr,
  VBROADCASTF32X2Zrrk,
  VBROADCASTF32X2Zrrkz,
  VBROADCASTF32X4Z256rm,
  VBROADCASTF32X4Z256rmk,
  VBROADCASTF32X4Z256rmkz,
  VBROADCASTF32X4Zrm,
  VBROADCASTF32X4Zrmk,
  VBROADCASTF32X4Zrmkz,
  VBROADCASTF32X8Zrm,
  VBROADCASTF32X8Zrmk,
  VBROADCASTF32X8Zrmkz,
  VBROADCASTF64X2Z256rm,
  VBROADCASTF64X2Z256rmk,
  VBROADCASTF64X2Z256rmkz,
  VBROADCASTF64X2Zrm,
  VBROADCASTF64X2Zrmk,
  VBROADCASTF64X2Zrmkz,
  VBROADCASTF64X4Zrm,
  VBROADCASTF64X4Zrmk,
  VBROADCASTF64X4Zrmkz,
  VBROADCASTI128rm,
  VBROADCASTI32X2Z128rm,
  VBROADCASTI32X2Z128rmk,
  VBROADCASTI32X2Z128rmkz,
  VBROADCASTI32X2Z128rr,
  VBROADCASTI32X2Z128rrk,
  VBROADCASTI32X2Z128rrkz,
  VBROADCASTI32X2Z256rm,
  VBROADCASTI32X2Z256rmk,
  VBROADCASTI32X2Z256rmkz,
  VBROADCASTI32X2Z256rr,
  VBROADCASTI32X2Z256rrk,
  VBROADCASTI32X2Z256rrkz,
  VBROADCASTI32X2Zrm,
  VBROADCASTI32X2Zrmk,
  VBROADCASTI32X2Zrmkz,
  VBROADCASTI32X2Zrr,
  VBROADCASTI32X2Zrrk,
  VBROADCASTI32X2Zrrkz,
  VBROADCASTI32X4Z256rm,
  VBROADCASTI32X4Z256rmk,
  VBROADCASTI32X4Z256rmkz,
  VBROADCASTI32X4Zrm,
  VBROADCASTI32X4Zrmk,
  VBROADCASTI32X4Zrmkz,
  VBROADCASTI32X8Zrm,
  VBROADCASTI32X8Zrmk,
  VBROADCASTI32X8Zrmkz,
  VBROADCASTI64X2Z256rm,
  VBROADCASTI64X2Z256rmk,
  VBROADCASTI64X2Z256rmkz,
  VBROADCASTI64X2Zrm,
  VBROADCASTI64X2Zrmk,
  VBROADCASTI64X2Zrmkz,
  VBROADCASTI64X4Zrm,
  VBROADCASTI64X4Zrmk,
  VBROADCASTI64X4Zrmkz,
  VBROADCASTSDYrm,
  VBROADCASTSDYrr,
  VBROADCASTSDZ256rm,
  VBROADCASTSDZ256rmk,
  VBROADCASTSDZ256rmkz,
  VBROADCASTSDZ256rr,
  VBROADCASTSDZ256rrk,
  VBROADCASTSDZ256rrkz,
  VBROADCASTSDZrm,
  VBROADCASTSDZrmk,
  VBROADCASTSDZrmkz,
  VBROADCASTSDZrr,
  VBROADCASTSDZrrk,
  VBROADCASTSDZrrkz,
  VBROADCASTSSYrm,
  VBROADCASTSSYrr,
  VBROADCASTSSZ128rm,
  VBROADCASTSSZ128rmk,
  VBROADCASTSSZ128rmkz,
  VBROADCASTSSZ128rr,
  VBROADCASTSSZ128rrk,
  VBROADCASTSSZ128rrkz,
  VBROADCASTSSZ256rm,
  VBROADCASTSSZ256rmk,
  VBROADCASTSSZ256rmkz,
  VBROADCASTSSZ256rr,
  VBROADCASTSSZ256rrk,
  VBROADCASTSSZ256rrkz,
  VBROADCASTSSZrm,
  VBROADCASTSSZrmk,
  VBROADCASTSSZrmkz,
  VBROADCASTSSZrr,
  VBROADCASTSSZrrk,
  VBROADCASTSSZrrkz,
  VBROADCASTSSrm,
  VBROADCASTSSrr,
  VCMPBF16Z128rmbi,
  VCMPBF16Z128rmbik,
  VCMPBF16Z128rmi,
  VCMPBF16Z128rmik,
  VCMPBF16Z128rri,
  VCMPBF16Z128rrik,
  VCMPBF16Z256rmbi,
  VCMPBF16Z256rmbik,
  VCMPBF16Z256rmi,
  VCMPBF16Z256rmik,
  VCMPBF16Z256rri,
  VCMPBF16Z256rrik,
  VCMPBF16Zrmbi,
  VCMPBF16Zrmbik,
  VCMPBF16Zrmi,
  VCMPBF16Zrmik,
  VCMPBF16Zrri,
  VCMPBF16Zrrik,
  VCMPPDYrmi,
  VCMPPDYrri,
  VCMPPDZ128rmbi,
  VCMPPDZ128rmbik,
  VCMPPDZ128rmi,
  VCMPPDZ128rmik,
  VCMPPDZ128rri,
  VCMPPDZ128rrik,
  VCMPPDZ256rmbi,
  VCMPPDZ256rmbik,
  VCMPPDZ256rmi,
  VCMPPDZ256rmik,
  VCMPPDZ256rri,
  VCMPPDZ256rrik,
  VCMPPDZrmbi,
  VCMPPDZrmbik,
  VCMPPDZrmi,
  VCMPPDZrmik,
  VCMPPDZrri,
  VCMPPDZrrib,
  VCMPPDZrribk,
  VCMPPDZrrik,
  VCMPPDrmi,
  VCMPPDrri,
  VCMPPHZ128rmbi,
  VCMPPHZ128rmbik,
  VCMPPHZ128rmi,
  VCMPPHZ128rmik,
  VCMPPHZ128rri,
  VCMPPHZ128rrik,
  VCMPPHZ256rmbi,
  VCMPPHZ256rmbik,
  VCMPPHZ256rmi,
  VCMPPHZ256rmik,
  VCMPPHZ256rri,
  VCMPPHZ256rrik,
  VCMPPHZrmbi,
  VCMPPHZrmbik,
  VCMPPHZrmi,
  VCMPPHZrmik,
  VCMPPHZrri,
  VCMPPHZrrib,
  VCMPPHZrribk,
  VCMPPHZrrik,
  VCMPPSYrmi,
  VCMPPSYrri,
  VCMPPSZ128rmbi,
  VCMPPSZ128rmbik,
  VCMPPSZ128rmi,
  VCMPPSZ128rmik,
  VCMPPSZ128rri,
  VCMPPSZ128rrik,
  VCMPPSZ256rmbi,
  VCMPPSZ256rmbik,
  VCMPPSZ256rmi,
  VCMPPSZ256rmik,
  VCMPPSZ256rri,
  VCMPPSZ256rrik,
  VCMPPSZrmbi,
  VCMPPSZrmbik,
  VCMPPSZrmi,
  VCMPPSZrmik,
  VCMPPSZrri,
  VCMPPSZrrib,
  VCMPPSZrribk,
  VCMPPSZrrik,
  VCMPPSrmi,
  VCMPPSrri,
  VCMPSDZrmi,
  VCMPSDZrmi_Int,
  VCMPSDZrmik_Int,
  VCMPSDZrri,
  VCMPSDZrri_Int,
  VCMPSDZrrib_Int,
  VCMPSDZrribk_Int,
  VCMPSDZrrik_Int,
  VCMPSDrmi,
  VCMPSDrmi_Int,
  VCMPSDrri,
  VCMPSDrri_Int,
  VCMPSHZrmi,
  VCMPSHZrmi_Int,
  VCMPSHZrmik_Int,
  VCMPSHZrri,
  VCMPSHZrri_Int,
  VCMPSHZrrib_Int,
  VCMPSHZrribk_Int,
  VCMPSHZrrik_Int,
  VCMPSSZrmi,
  VCMPSSZrmi_Int,
  VCMPSSZrmik_Int,
  VCMPSSZrri,
  VCMPSSZrri_Int,
  VCMPSSZrrib_Int,
  VCMPSSZrribk_Int,
  VCMPSSZrrik_Int,
  VCMPSSrmi,
  VCMPSSrmi_Int,
  VCMPSSrri,
  VCMPSSrri_Int,
  VCOMISBF16Zrm,
  VCOMISBF16Zrm_Int,
  VCOMISBF16Zrr,
  VCOMISBF16Zrr_Int,
  VCOMISDZrm,
  VCOMISDZrm_Int,
  VCOMISDZrr,
  VCOMISDZrr_Int,
  VCOMISDZrrb,
  VCOMISDrm,
  VCOMISDrm_Int,
  VCOMISDrr,
  VCOMISDrr_Int,
  VCOMISHZrm,
  VCOMISHZrm_Int,
  VCOMISHZrr,
  VCOMISHZrr_Int,
  VCOMISHZrrb,
  VCOMISSZrm,
  VCOMISSZrm_Int,
  VCOMISSZrr,
  VCOMISSZrr_Int,
  VCOMISSZrrb,
  VCOMISSrm,
  VCOMISSrm_Int,
  VCOMISSrr,
  VCOMISSrr_Int,
  VCOMPRESSPDZ128mr,
  VCOMPRESSPDZ128mrk,
  VCOMPRESSPDZ128rr,
  VCOMPRESSPDZ128rrk,
  VCOMPRESSPDZ128rrkz,
  VCOMPRESSPDZ256mr,
  VCOMPRESSPDZ256mrk,
  VCOMPRESSPDZ256rr,
  VCOMPRESSPDZ256rrk,
  VCOMPRESSPDZ256rrkz,
  VCOMPRESSPDZmr,
  VCOMPRESSPDZmrk,
  VCOMPRESSPDZrr,
  VCOMPRESSPDZrrk,
  VCOMPRESSPDZrrkz,
  VCOMPRESSPSZ128mr,
  VCOMPRESSPSZ128mrk,
  VCOMPRESSPSZ128rr,
  VCOMPRESSPSZ128rrk,
  VCOMPRESSPSZ128rrkz,
  VCOMPRESSPSZ256mr,
  VCOMPRESSPSZ256mrk,
  VCOMPRESSPSZ256rr,
  VCOMPRESSPSZ256rrk,
  VCOMPRESSPSZ256rrkz,
  VCOMPRESSPSZmr,
  VCOMPRESSPSZmrk,
  VCOMPRESSPSZrr,
  VCOMPRESSPSZrrk,
  VCOMPRESSPSZrrkz,
  VCOMXSDZrm_Int,
  VCOMXSDZrr_Int,
  VCOMXSDZrrb_Int,
  VCOMXSHZrm_Int,
  VCOMXSHZrr_Int,
  VCOMXSHZrrb_Int,
  VCOMXSSZrm_Int,
  VCOMXSSZrr_Int,
  VCOMXSSZrrb_Int,
  VCVT2PH2BF8SZ128rm,
  VCVT2PH2BF8SZ128rmb,
  VCVT2PH2BF8SZ128rmbk,
  VCVT2PH2BF8SZ128rmbkz,
  VCVT2PH2BF8SZ128rmk,
  VCVT2PH2BF8SZ128rmkz,
  VCVT2PH2BF8SZ128rr,
  VCVT2PH2BF8SZ128rrk,
  VCVT2PH2BF8SZ128rrkz,
  VCVT2PH2BF8SZ256rm,
  VCVT2PH2BF8SZ256rmb,
  VCVT2PH2BF8SZ256rmbk,
  VCVT2PH2BF8SZ256rmbkz,
  VCVT2PH2BF8SZ256rmk,
  VCVT2PH2BF8SZ256rmkz,
  VCVT2PH2BF8SZ256rr,
  VCVT2PH2BF8SZ256rrk,
  VCVT2PH2BF8SZ256rrkz,
  VCVT2PH2BF8SZrm,
  VCVT2PH2BF8SZrmb,
  VCVT2PH2BF8SZrmbk,
  VCVT2PH2BF8SZrmbkz,
  VCVT2PH2BF8SZrmk,
  VCVT2PH2BF8SZrmkz,
  VCVT2PH2BF8SZrr,
  VCVT2PH2BF8SZrrk,
  VCVT2PH2BF8SZrrkz,
  VCVT2PH2BF8Z128rm,
  VCVT2PH2BF8Z128rmb,
  VCVT2PH2BF8Z128rmbk,
  VCVT2PH2BF8Z128rmbkz,
  VCVT2PH2BF8Z128rmk,
  VCVT2PH2BF8Z128rmkz,
  VCVT2PH2BF8Z128rr,
  VCVT2PH2BF8Z128rrk,
  VCVT2PH2BF8Z128rrkz,
  VCVT2PH2BF8Z256rm,
  VCVT2PH2BF8Z256rmb,
  VCVT2PH2BF8Z256rmbk,
  VCVT2PH2BF8Z256rmbkz,
  VCVT2PH2BF8Z256rmk,
  VCVT2PH2BF8Z256rmkz,
  VCVT2PH2BF8Z256rr,
  VCVT2PH2BF8Z256rrk,
  VCVT2PH2BF8Z256rrkz,
  VCVT2PH2BF8Zrm,
  VCVT2PH2BF8Zrmb,
  VCVT2PH2BF8Zrmbk,
  VCVT2PH2BF8Zrmbkz,
  VCVT2PH2BF8Zrmk,
  VCVT2PH2BF8Zrmkz,
  VCVT2PH2BF8Zrr,
  VCVT2PH2BF8Zrrk,
  VCVT2PH2BF8Zrrkz,
  VCVT2PH2HF8SZ128rm,
  VCVT2PH2HF8SZ128rmb,
  VCVT2PH2HF8SZ128rmbk,
  VCVT2PH2HF8SZ128rmbkz,
  VCVT2PH2HF8SZ128rmk,
  VCVT2PH2HF8SZ128rmkz,
  VCVT2PH2HF8SZ128rr,
  VCVT2PH2HF8SZ128rrk,
  VCVT2PH2HF8SZ128rrkz,
  VCVT2PH2HF8SZ256rm,
  VCVT2PH2HF8SZ256rmb,
  VCVT2PH2HF8SZ256rmbk,
  VCVT2PH2HF8SZ256rmbkz,
  VCVT2PH2HF8SZ256rmk,
  VCVT2PH2HF8SZ256rmkz,
  VCVT2PH2HF8SZ256rr,
  VCVT2PH2HF8SZ256rrk,
  VCVT2PH2HF8SZ256rrkz,
  VCVT2PH2HF8SZrm,
  VCVT2PH2HF8SZrmb,
  VCVT2PH2HF8SZrmbk,
  VCVT2PH2HF8SZrmbkz,
  VCVT2PH2HF8SZrmk,
  VCVT2PH2HF8SZrmkz,
  VCVT2PH2HF8SZrr,
  VCVT2PH2HF8SZrrk,
  VCVT2PH2HF8SZrrkz,
  VCVT2PH2HF8Z128rm,
  VCVT2PH2HF8Z128rmb,
  VCVT2PH2HF8Z128rmbk,
  VCVT2PH2HF8Z128rmbkz,
  VCVT2PH2HF8Z128rmk,
  VCVT2PH2HF8Z128rmkz,
  VCVT2PH2HF8Z128rr,
  VCVT2PH2HF8Z128rrk,
  VCVT2PH2HF8Z128rrkz,
  VCVT2PH2HF8Z256rm,
  VCVT2PH2HF8Z256rmb,
  VCVT2PH2HF8Z256rmbk,
  VCVT2PH2HF8Z256rmbkz,
  VCVT2PH2HF8Z256rmk,
  VCVT2PH2HF8Z256rmkz,
  VCVT2PH2HF8Z256rr,
  VCVT2PH2HF8Z256rrk,
  VCVT2PH2HF8Z256rrkz,
  VCVT2PH2HF8Zrm,
  VCVT2PH2HF8Zrmb,
  VCVT2PH2HF8Zrmbk,
  VCVT2PH2HF8Zrmbkz,
  VCVT2PH2HF8Zrmk,
  VCVT2PH2HF8Zrmkz,
  VCVT2PH2HF8Zrr,
  VCVT2PH2HF8Zrrk,
  VCVT2PH2HF8Zrrkz,
  VCVT2PS2PHXZ128rm,
  VCVT2PS2PHXZ128rmb,
  VCVT2PS2PHXZ128rmbk,
  VCVT2PS2PHXZ128rmbkz,
  VCVT2PS2PHXZ128rmk,
  VCVT2PS2PHXZ128rmkz,
  VCVT2PS2PHXZ128rr,
  VCVT2PS2PHXZ128rrk,
  VCVT2PS2PHXZ128rrkz,
  VCVT2PS2PHXZ256rm,
  VCVT2PS2PHXZ256rmb,
  VCVT2PS2PHXZ256rmbk,
  VCVT2PS2PHXZ256rmbkz,
  VCVT2PS2PHXZ256rmk,
  VCVT2PS2PHXZ256rmkz,
  VCVT2PS2PHXZ256rr,
  VCVT2PS2PHXZ256rrk,
  VCVT2PS2PHXZ256rrkz,
  VCVT2PS2PHXZrm,
  VCVT2PS2PHXZrmb,
  VCVT2PS2PHXZrmbk,
  VCVT2PS2PHXZrmbkz,
  VCVT2PS2PHXZrmk,
  VCVT2PS2PHXZrmkz,
  VCVT2PS2PHXZrr,
  VCVT2PS2PHXZrrb,
  VCVT2PS2PHXZrrbk,
  VCVT2PS2PHXZrrbkz,
  VCVT2PS2PHXZrrk,
  VCVT2PS2PHXZrrkz,
  VCVTBF162IBSZ128rm,
  VCVTBF162IBSZ128rmb,
  VCVTBF162IBSZ128rmbk,
  VCVTBF162IBSZ128rmbkz,
  VCVTBF162IBSZ128rmk,
  VCVTBF162IBSZ128rmkz,
  VCVTBF162IBSZ128rr,
  VCVTBF162IBSZ128rrk,
  VCVTBF162IBSZ128rrkz,
  VCVTBF162IBSZ256rm,
  VCVTBF162IBSZ256rmb,
  VCVTBF162IBSZ256rmbk,
  VCVTBF162IBSZ256rmbkz,
  VCVTBF162IBSZ256rmk,
  VCVTBF162IBSZ256rmkz,
  VCVTBF162IBSZ256rr,
  VCVTBF162IBSZ256rrk,
  VCVTBF162IBSZ256rrkz,
  VCVTBF162IBSZrm,
  VCVTBF162IBSZrmb,
  VCVTBF162IBSZrmbk,
  VCVTBF162IBSZrmbkz,
  VCVTBF162IBSZrmk,
  VCVTBF162IBSZrmkz,
  VCVTBF162IBSZrr,
  VCVTBF162IBSZrrk,
  VCVTBF162IBSZrrkz,
  VCVTBF162IUBSZ128rm,
  VCVTBF162IUBSZ128rmb,
  VCVTBF162IUBSZ128rmbk,
  VCVTBF162IUBSZ128rmbkz,
  VCVTBF162IUBSZ128rmk,
  VCVTBF162IUBSZ128rmkz,
  VCVTBF162IUBSZ128rr,
  VCVTBF162IUBSZ128rrk,
  VCVTBF162IUBSZ128rrkz,
  VCVTBF162IUBSZ256rm,
  VCVTBF162IUBSZ256rmb,
  VCVTBF162IUBSZ256rmbk,
  VCVTBF162IUBSZ256rmbkz,
  VCVTBF162IUBSZ256rmk,
  VCVTBF162IUBSZ256rmkz,
  VCVTBF162IUBSZ256rr,
  VCVTBF162IUBSZ256rrk,
  VCVTBF162IUBSZ256rrkz,
  VCVTBF162IUBSZrm,
  VCVTBF162IUBSZrmb,
  VCVTBF162IUBSZrmbk,
  VCVTBF162IUBSZrmbkz,
  VCVTBF162IUBSZrmk,
  VCVTBF162IUBSZrmkz,
  VCVTBF162IUBSZrr,
  VCVTBF162IUBSZrrk,
  VCVTBF162IUBSZrrkz,
  VCVTBIASPH2BF8SZ128rm,
  VCVTBIASPH2BF8SZ128rmb,
  VCVTBIASPH2BF8SZ128rmbk,
  VCVTBIASPH2BF8SZ128rmbkz,
  VCVTBIASPH2BF8SZ128rmk,
  VCVTBIASPH2BF8SZ128rmkz,
  VCVTBIASPH2BF8SZ128rr,
  VCVTBIASPH2BF8SZ128rrk,
  VCVTBIASPH2BF8SZ128rrkz,
  VCVTBIASPH2BF8SZ256rm,
  VCVTBIASPH2BF8SZ256rmb,
  VCVTBIASPH2BF8SZ256rmbk,
  VCVTBIASPH2BF8SZ256rmbkz,
  VCVTBIASPH2BF8SZ256rmk,
  VCVTBIASPH2BF8SZ256rmkz,
  VCVTBIASPH2BF8SZ256rr,
  VCVTBIASPH2BF8SZ256rrk,
  VCVTBIASPH2BF8SZ256rrkz,
  VCVTBIASPH2BF8SZrm,
  VCVTBIASPH2BF8SZrmb,
  VCVTBIASPH2BF8SZrmbk,
  VCVTBIASPH2BF8SZrmbkz,
  VCVTBIASPH2BF8SZrmk,
  VCVTBIASPH2BF8SZrmkz,
  VCVTBIASPH2BF8SZrr,
  VCVTBIASPH2BF8SZrrk,
  VCVTBIASPH2BF8SZrrkz,
  VCVTBIASPH2BF8Z128rm,
  VCVTBIASPH2BF8Z128rmb,
  VCVTBIASPH2BF8Z128rmbk,
  VCVTBIASPH2BF8Z128rmbkz,
  VCVTBIASPH2BF8Z128rmk,
  VCVTBIASPH2BF8Z128rmkz,
  VCVTBIASPH2BF8Z128rr,
  VCVTBIASPH2BF8Z128rrk,
  VCVTBIASPH2BF8Z128rrkz,
  VCVTBIASPH2BF8Z256rm,
  VCVTBIASPH2BF8Z256rmb,
  VCVTBIASPH2BF8Z256rmbk,
  VCVTBIASPH2BF8Z256rmbkz,
  VCVTBIASPH2BF8Z256rmk,
  VCVTBIASPH2BF8Z256rmkz,
  VCVTBIASPH2BF8Z256rr,
  VCVTBIASPH2BF8Z256rrk,
  VCVTBIASPH2BF8Z256rrkz,
  VCVTBIASPH2BF8Zrm,
  VCVTBIASPH2BF8Zrmb,
  VCVTBIASPH2BF8Zrmbk,
  VCVTBIASPH2BF8Zrmbkz,
  VCVTBIASPH2BF8Zrmk,
  VCVTBIASPH2BF8Zrmkz,
  VCVTBIASPH2BF8Zrr,
  VCVTBIASPH2BF8Zrrk,
  VCVTBIASPH2BF8Zrrkz,
  VCVTBIASPH2HF8SZ128rm,
  VCVTBIASPH2HF8SZ128rmb,
  VCVTBIASPH2HF8SZ128rmbk,
  VCVTBIASPH2HF8SZ128rmbkz,
  VCVTBIASPH2HF8SZ128rmk,
  VCVTBIASPH2HF8SZ128rmkz,
  VCVTBIASPH2HF8SZ128rr,
  VCVTBIASPH2HF8SZ128rrk,
  VCVTBIASPH2HF8SZ128rrkz,
  VCVTBIASPH2HF8SZ256rm,
  VCVTBIASPH2HF8SZ256rmb,
  VCVTBIASPH2HF8SZ256rmbk,
  VCVTBIASPH2HF8SZ256rmbkz,
  VCVTBIASPH2HF8SZ256rmk,
  VCVTBIASPH2HF8SZ256rmkz,
  VCVTBIASPH2HF8SZ256rr,
  VCVTBIASPH2HF8SZ256rrk,
  VCVTBIASPH2HF8SZ256rrkz,
  VCVTBIASPH2HF8SZrm,
  VCVTBIASPH2HF8SZrmb,
  VCVTBIASPH2HF8SZrmbk,
  VCVTBIASPH2HF8SZrmbkz,
  VCVTBIASPH2HF8SZrmk,
  VCVTBIASPH2HF8SZrmkz,
  VCVTBIASPH2HF8SZrr,
  VCVTBIASPH2HF8SZrrk,
  VCVTBIASPH2HF8SZrrkz,
  VCVTBIASPH2HF8Z128rm,
  VCVTBIASPH2HF8Z128rmb,
  VCVTBIASPH2HF8Z128rmbk,
  VCVTBIASPH2HF8Z128rmbkz,
  VCVTBIASPH2HF8Z128rmk,
  VCVTBIASPH2HF8Z128rmkz,
  VCVTBIASPH2HF8Z128rr,
  VCVTBIASPH2HF8Z128rrk,
  VCVTBIASPH2HF8Z128rrkz,
  VCVTBIASPH2HF8Z256rm,
  VCVTBIASPH2HF8Z256rmb,
  VCVTBIASPH2HF8Z256rmbk,
  VCVTBIASPH2HF8Z256rmbkz,
  VCVTBIASPH2HF8Z256rmk,
  VCVTBIASPH2HF8Z256rmkz,
  VCVTBIASPH2HF8Z256rr,
  VCVTBIASPH2HF8Z256rrk,
  VCVTBIASPH2HF8Z256rrkz,
  VCVTBIASPH2HF8Zrm,
  VCVTBIASPH2HF8Zrmb,
  VCVTBIASPH2HF8Zrmbk,
  VCVTBIASPH2HF8Zrmbkz,
  VCVTBIASPH2HF8Zrmk,
  VCVTBIASPH2HF8Zrmkz,
  VCVTBIASPH2HF8Zrr,
  VCVTBIASPH2HF8Zrrk,
  VCVTBIASPH2HF8Zrrkz,
  VCVTDQ2PDYrm,
  VCVTDQ2PDYrr,
  VCVTDQ2PDZ128rm,
  VCVTDQ2PDZ128rmb,
  VCVTDQ2PDZ128rmbk,
  VCVTDQ2PDZ128rmbkz,
  VCVTDQ2PDZ128rmk,
  VCVTDQ2PDZ128rmkz,
  VCVTDQ2PDZ128rr,
  VCVTDQ2PDZ128rrk,
  VCVTDQ2PDZ128rrkz,
  VCVTDQ2PDZ256rm,
  VCVTDQ2PDZ256rmb,
  VCVTDQ2PDZ256rmbk,
  VCVTDQ2PDZ256rmbkz,
  VCVTDQ2PDZ256rmk,
  VCVTDQ2PDZ256rmkz,
  VCVTDQ2PDZ256rr,
  VCVTDQ2PDZ256rrk,
  VCVTDQ2PDZ256rrkz,
  VCVTDQ2PDZrm,
  VCVTDQ2PDZrmb,
  VCVTDQ2PDZrmbk,
  VCVTDQ2PDZrmbkz,
  VCVTDQ2PDZrmk,
  VCVTDQ2PDZrmkz,
  VCVTDQ2PDZrr,
  VCVTDQ2PDZrrk,
  VCVTDQ2PDZrrkz,
  VCVTDQ2PDrm,
  VCVTDQ2PDrr,
  VCVTDQ2PHZ128rm,
  VCVTDQ2PHZ128rmb,
  VCVTDQ2PHZ128rmbk,
  VCVTDQ2PHZ128rmbkz,
  VCVTDQ2PHZ128rmk,
  VCVTDQ2PHZ128rmkz,
  VCVTDQ2PHZ128rr,
  VCVTDQ2PHZ128rrk,
  VCVTDQ2PHZ128rrkz,
  VCVTDQ2PHZ256rm,
  VCVTDQ2PHZ256rmb,
  VCVTDQ2PHZ256rmbk,
  VCVTDQ2PHZ256rmbkz,
  VCVTDQ2PHZ256rmk,
  VCVTDQ2PHZ256rmkz,
  VCVTDQ2PHZ256rr,
  VCVTDQ2PHZ256rrk,
  VCVTDQ2PHZ256rrkz,
  VCVTDQ2PHZrm,
  VCVTDQ2PHZrmb,
  VCVTDQ2PHZrmbk,
  VCVTDQ2PHZrmbkz,
  VCVTDQ2PHZrmk,
  VCVTDQ2PHZrmkz,
  VCVTDQ2PHZrr,
  VCVTDQ2PHZrrb,
  VCVTDQ2PHZrrbk,
  VCVTDQ2PHZrrbkz,
  VCVTDQ2PHZrrk,
  VCVTDQ2PHZrrkz,
  VCVTDQ2PSYrm,
  VCVTDQ2PSYrr,
  VCVTDQ2PSZ128rm,
  VCVTDQ2PSZ128rmb,
  VCVTDQ2PSZ128rmbk,
  VCVTDQ2PSZ128rmbkz,
  VCVTDQ2PSZ128rmk,
  VCVTDQ2PSZ128rmkz,
  VCVTDQ2PSZ128rr,
  VCVTDQ2PSZ128rrk,
  VCVTDQ2PSZ128rrkz,
  VCVTDQ2PSZ256rm,
  VCVTDQ2PSZ256rmb,
  VCVTDQ2PSZ256rmbk,
  VCVTDQ2PSZ256rmbkz,
  VCVTDQ2PSZ256rmk,
  VCVTDQ2PSZ256rmkz,
  VCVTDQ2PSZ256rr,
  VCVTDQ2PSZ256rrk,
  VCVTDQ2PSZ256rrkz,
  VCVTDQ2PSZrm,
  VCVTDQ2PSZrmb,
  VCVTDQ2PSZrmbk,
  VCVTDQ2PSZrmbkz,
  VCVTDQ2PSZrmk,
  VCVTDQ2PSZrmkz,
  VCVTDQ2PSZrr,
  VCVTDQ2PSZrrb,
  VCVTDQ2PSZrrbk,
  VCVTDQ2PSZrrbkz,
  VCVTDQ2PSZrrk,
  VCVTDQ2PSZrrkz,
  VCVTDQ2PSrm,
  VCVTDQ2PSrr,
  VCVTHF82PHZ128rm,
  VCVTHF82PHZ128rmk,
  VCVTHF82PHZ128rmkz,
  VCVTHF82PHZ128rr,
  VCVTHF82PHZ128rrk,
  VCVTHF82PHZ128rrkz,
  VCVTHF82PHZ256rm,
  VCVTHF82PHZ256rmk,
  VCVTHF82PHZ256rmkz,
  VCVTHF82PHZ256rr,
  VCVTHF82PHZ256rrk,
  VCVTHF82PHZ256rrkz,
  VCVTHF82PHZrm,
  VCVTHF82PHZrmk,
  VCVTHF82PHZrmkz,
  VCVTHF82PHZrr,
  VCVTHF82PHZrrk,
  VCVTHF82PHZrrkz,
  VCVTNE2PS2BF16Z128rm,
  VCVTNE2PS2BF16Z128rmb,
  VCVTNE2PS2BF16Z128rmbk,
  VCVTNE2PS2BF16Z128rmbkz,
  VCVTNE2PS2BF16Z128rmk,
  VCVTNE2PS2BF16Z128rmkz,
  VCVTNE2PS2BF16Z128rr,
  VCVTNE2PS2BF16Z128rrk,
  VCVTNE2PS2BF16Z128rrkz,
  VCVTNE2PS2BF16Z256rm,
  VCVTNE2PS2BF16Z256rmb,
  VCVTNE2PS2BF16Z256rmbk,
  VCVTNE2PS2BF16Z256rmbkz,
  VCVTNE2PS2BF16Z256rmk,
  VCVTNE2PS2BF16Z256rmkz,
  VCVTNE2PS2BF16Z256rr,
  VCVTNE2PS2BF16Z256rrk,
  VCVTNE2PS2BF16Z256rrkz,
  VCVTNE2PS2BF16Zrm,
  VCVTNE2PS2BF16Zrmb,
  VCVTNE2PS2BF16Zrmbk,
  VCVTNE2PS2BF16Zrmbkz,
  VCVTNE2PS2BF16Zrmk,
  VCVTNE2PS2BF16Zrmkz,
  VCVTNE2PS2BF16Zrr,
  VCVTNE2PS2BF16Zrrk,
  VCVTNE2PS2BF16Zrrkz,
  VCVTNEEBF162PSYrm,
  VCVTNEEBF162PSrm,
  VCVTNEEPH2PSYrm,
  VCVTNEEPH2PSrm,
  VCVTNEOBF162PSYrm,
  VCVTNEOBF162PSrm,
  VCVTNEOPH2PSYrm,
  VCVTNEOPH2PSrm,
  VCVTNEPS2BF16Yrm,
  VCVTNEPS2BF16Yrr,
  VCVTNEPS2BF16Z128rm,
  VCVTNEPS2BF16Z128rmb,
  VCVTNEPS2BF16Z128rmbk,
  VCVTNEPS2BF16Z128rmbkz,
  VCVTNEPS2BF16Z128rmk,
  VCVTNEPS2BF16Z128rmkz,
  VCVTNEPS2BF16Z128rr,
  VCVTNEPS2BF16Z128rrk,
  VCVTNEPS2BF16Z128rrkz,
  VCVTNEPS2BF16Z256rm,
  VCVTNEPS2BF16Z256rmb,
  VCVTNEPS2BF16Z256rmbk,
  VCVTNEPS2BF16Z256rmbkz,
  VCVTNEPS2BF16Z256rmk,
  VCVTNEPS2BF16Z256rmkz,
  VCVTNEPS2BF16Z256rr,
  VCVTNEPS2BF16Z256rrk,
  VCVTNEPS2BF16Z256rrkz,
  VCVTNEPS2BF16Zrm,
  VCVTNEPS2BF16Zrmb,
  VCVTNEPS2BF16Zrmbk,
  VCVTNEPS2BF16Zrmbkz,
  VCVTNEPS2BF16Zrmk,
  VCVTNEPS2BF16Zrmkz,
  VCVTNEPS2BF16Zrr,
  VCVTNEPS2BF16Zrrk,
  VCVTNEPS2BF16Zrrkz,
  VCVTNEPS2BF16rm,
  VCVTNEPS2BF16rr,
  VCVTPD2DQYrm,
  VCVTPD2DQYrr,
  VCVTPD2DQZ128rm,
  VCVTPD2DQZ128rmb,
  VCVTPD2DQZ128rmbk,
  VCVTPD2DQZ128rmbkz,
  VCVTPD2DQZ128rmk,
  VCVTPD2DQZ128rmkz,
  VCVTPD2DQZ128rr,
  VCVTPD2DQZ128rrk,
  VCVTPD2DQZ128rrkz,
  VCVTPD2DQZ256rm,
  VCVTPD2DQZ256rmb,
  VCVTPD2DQZ256rmbk,
  VCVTPD2DQZ256rmbkz,
  VCVTPD2DQZ256rmk,
  VCVTPD2DQZ256rmkz,
  VCVTPD2DQZ256rr,
  VCVTPD2DQZ256rrk,
  VCVTPD2DQZ256rrkz,
  VCVTPD2DQZrm,
  VCVTPD2DQZrmb,
  VCVTPD2DQZrmbk,
  VCVTPD2DQZrmbkz,
  VCVTPD2DQZrmk,
  VCVTPD2DQZrmkz,
  VCVTPD2DQZrr,
  VCVTPD2DQZrrb,
  VCVTPD2DQZrrbk,
  VCVTPD2DQZrrbkz,
  VCVTPD2DQZrrk,
  VCVTPD2DQZrrkz,
  VCVTPD2DQrm,
  VCVTPD2DQrr,
  VCVTPD2PHZ128rm,
  VCVTPD2PHZ128rmb,
  VCVTPD2PHZ128rmbk,
  VCVTPD2PHZ128rmbkz,
  VCVTPD2PHZ128rmk,
  VCVTPD2PHZ128rmkz,
  VCVTPD2PHZ128rr,
  VCVTPD2PHZ128rrk,
  VCVTPD2PHZ128rrkz,
  VCVTPD2PHZ256rm,
  VCVTPD2PHZ256rmb,
  VCVTPD2PHZ256rmbk,
  VCVTPD2PHZ256rmbkz,
  VCVTPD2PHZ256rmk,
  VCVTPD2PHZ256rmkz,
  VCVTPD2PHZ256rr,
  VCVTPD2PHZ256rrk,
  VCVTPD2PHZ256rrkz,
  VCVTPD2PHZrm,
  VCVTPD2PHZrmb,
  VCVTPD2PHZrmbk,
  VCVTPD2PHZrmbkz,
  VCVTPD2PHZrmk,
  VCVTPD2PHZrmkz,
  VCVTPD2PHZrr,
  VCVTPD2PHZrrb,
  VCVTPD2PHZrrbk,
  VCVTPD2PHZrrbkz,
  VCVTPD2PHZrrk,
  VCVTPD2PHZrrkz,
  VCVTPD2PSYrm,
  VCVTPD2PSYrr,
  VCVTPD2PSZ128rm,
  VCVTPD2PSZ128rmb,
  VCVTPD2PSZ128rmbk,
  VCVTPD2PSZ128rmbkz,
  VCVTPD2PSZ128rmk,
  VCVTPD2PSZ128rmkz,
  VCVTPD2PSZ128rr,
  VCVTPD2PSZ128rrk,
  VCVTPD2PSZ128rrkz,
  VCVTPD2PSZ256rm,
  VCVTPD2PSZ256rmb,
  VCVTPD2PSZ256rmbk,
  VCVTPD2PSZ256rmbkz,
  VCVTPD2PSZ256rmk,
  VCVTPD2PSZ256rmkz,
  VCVTPD2PSZ256rr,
  VCVTPD2PSZ256rrk,
  VCVTPD2PSZ256rrkz,
  VCVTPD2PSZrm,
  VCVTPD2PSZrmb,
  VCVTPD2PSZrmbk,
  VCVTPD2PSZrmbkz,
  VCVTPD2PSZrmk,
  VCVTPD2PSZrmkz,
  VCVTPD2PSZrr,
  VCVTPD2PSZrrb,
  VCVTPD2PSZrrbk,
  VCVTPD2PSZrrbkz,
  VCVTPD2PSZrrk,
  VCVTPD2PSZrrkz,
  VCVTPD2PSrm,
  VCVTPD2PSrr,
  VCVTPD2QQZ128rm,
  VCVTPD2QQZ128rmb,
  VCVTPD2QQZ128rmbk,
  VCVTPD2QQZ128rmbkz,
  VCVTPD2QQZ128rmk,
  VCVTPD2QQZ128rmkz,
  VCVTPD2QQZ128rr,
  VCVTPD2QQZ128rrk,
  VCVTPD2QQZ128rrkz,
  VCVTPD2QQZ256rm,
  VCVTPD2QQZ256rmb,
  VCVTPD2QQZ256rmbk,
  VCVTPD2QQZ256rmbkz,
  VCVTPD2QQZ256rmk,
  VCVTPD2QQZ256rmkz,
  VCVTPD2QQZ256rr,
  VCVTPD2QQZ256rrk,
  VCVTPD2QQZ256rrkz,
  VCVTPD2QQZrm,
  VCVTPD2QQZrmb,
  VCVTPD2QQZrmbk,
  VCVTPD2QQZrmbkz,
  VCVTPD2QQZrmk,
  VCVTPD2QQZrmkz,
  VCVTPD2QQZrr,
  VCVTPD2QQZrrb,
  VCVTPD2QQZrrbk,
  VCVTPD2QQZrrbkz,
  VCVTPD2QQZrrk,
  VCVTPD2QQZrrkz,
  VCVTPD2UDQZ128rm,
  VCVTPD2UDQZ128rmb,
  VCVTPD2UDQZ128rmbk,
  VCVTPD2UDQZ128rmbkz,
  VCVTPD2UDQZ128rmk,
  VCVTPD2UDQZ128rmkz,
  VCVTPD2UDQZ128rr,
  VCVTPD2UDQZ128rrk,
  VCVTPD2UDQZ128rrkz,
  VCVTPD2UDQZ256rm,
  VCVTPD2UDQZ256rmb,
  VCVTPD2UDQZ256rmbk,
  VCVTPD2UDQZ256rmbkz,
  VCVTPD2UDQZ256rmk,
  VCVTPD2UDQZ256rmkz,
  VCVTPD2UDQZ256rr,
  VCVTPD2UDQZ256rrk,
  VCVTPD2UDQZ256rrkz,
  VCVTPD2UDQZrm,
  VCVTPD2UDQZrmb,
  VCVTPD2UDQZrmbk,
  VCVTPD2UDQZrmbkz,
  VCVTPD2UDQZrmk,
  VCVTPD2UDQZrmkz,
  VCVTPD2UDQZrr,
  VCVTPD2UDQZrrb,
  VCVTPD2UDQZrrbk,
  VCVTPD2UDQZrrbkz,
  VCVTPD2UDQZrrk,
  VCVTPD2UDQZrrkz,
  VCVTPD2UQQZ128rm,
  VCVTPD2UQQZ128rmb,
  VCVTPD2UQQZ128rmbk,
  VCVTPD2UQQZ128rmbkz,
  VCVTPD2UQQZ128rmk,
  VCVTPD2UQQZ128rmkz,
  VCVTPD2UQQZ128rr,
  VCVTPD2UQQZ128rrk,
  VCVTPD2UQQZ128rrkz,
  VCVTPD2UQQZ256rm,
  VCVTPD2UQQZ256rmb,
  VCVTPD2UQQZ256rmbk,
  VCVTPD2UQQZ256rmbkz,
  VCVTPD2UQQZ256rmk,
  VCVTPD2UQQZ256rmkz,
  VCVTPD2UQQZ256rr,
  VCVTPD2UQQZ256rrk,
  VCVTPD2UQQZ256rrkz,
  VCVTPD2UQQZrm,
  VCVTPD2UQQZrmb,
  VCVTPD2UQQZrmbk,
  VCVTPD2UQQZrmbkz,
  VCVTPD2UQQZrmk,
  VCVTPD2UQQZrmkz,
  VCVTPD2UQQZrr,
  VCVTPD2UQQZrrb,
  VCVTPD2UQQZrrbk,
  VCVTPD2UQQZrrbkz,
  VCVTPD2UQQZrrk,
  VCVTPD2UQQZrrkz,
  VCVTPH2BF8SZ128rm,
  VCVTPH2BF8SZ128rmb,
  VCVTPH2BF8SZ128rmbk,
  VCVTPH2BF8SZ128rmbkz,
  VCVTPH2BF8SZ128rmk,
  VCVTPH2BF8SZ128rmkz,
  VCVTPH2BF8SZ128rr,
  VCVTPH2BF8SZ128rrk,
  VCVTPH2BF8SZ128rrkz,
  VCVTPH2BF8SZ256rm,
  VCVTPH2BF8SZ256rmb,
  VCVTPH2BF8SZ256rmbk,
  VCVTPH2BF8SZ256rmbkz,
  VCVTPH2BF8SZ256rmk,
  VCVTPH2BF8SZ256rmkz,
  VCVTPH2BF8SZ256rr,
  VCVTPH2BF8SZ256rrk,
  VCVTPH2BF8SZ256rrkz,
  VCVTPH2BF8SZrm,
  VCVTPH2BF8SZrmb,
  VCVTPH2BF8SZrmbk,
  VCVTPH2BF8SZrmbkz,
  VCVTPH2BF8SZrmk,
  VCVTPH2BF8SZrmkz,
  VCVTPH2BF8SZrr,
  VCVTPH2BF8SZrrk,
  VCVTPH2BF8SZrrkz,
  VCVTPH2BF8Z128rm,
  VCVTPH2BF8Z128rmb,
  VCVTPH2BF8Z128rmbk,
  VCVTPH2BF8Z128rmbkz,
  VCVTPH2BF8Z128rmk,
  VCVTPH2BF8Z128rmkz,
  VCVTPH2BF8Z128rr,
  VCVTPH2BF8Z128rrk,
  VCVTPH2BF8Z128rrkz,
  VCVTPH2BF8Z256rm,
  VCVTPH2BF8Z256rmb,
  VCVTPH2BF8Z256rmbk,
  VCVTPH2BF8Z256rmbkz,
  VCVTPH2BF8Z256rmk,
  VCVTPH2BF8Z256rmkz,
  VCVTPH2BF8Z256rr,
  VCVTPH2BF8Z256rrk,
  VCVTPH2BF8Z256rrkz,
  VCVTPH2BF8Zrm,
  VCVTPH2BF8Zrmb,
  VCVTPH2BF8Zrmbk,
  VCVTPH2BF8Zrmbkz,
  VCVTPH2BF8Zrmk,
  VCVTPH2BF8Zrmkz,
  VCVTPH2BF8Zrr,
  VCVTPH2BF8Zrrk,
  VCVTPH2BF8Zrrkz,
  VCVTPH2DQZ128rm,
  VCVTPH2DQZ128rmb,
  VCVTPH2DQZ128rmbk,
  VCVTPH2DQZ128rmbkz,
  VCVTPH2DQZ128rmk,
  VCVTPH2DQZ128rmkz,
  VCVTPH2DQZ128rr,
  VCVTPH2DQZ128rrk,
  VCVTPH2DQZ128rrkz,
  VCVTPH2DQZ256rm,
  VCVTPH2DQZ256rmb,
  VCVTPH2DQZ256rmbk,
  VCVTPH2DQZ256rmbkz,
  VCVTPH2DQZ256rmk,
  VCVTPH2DQZ256rmkz,
  VCVTPH2DQZ256rr,
  VCVTPH2DQZ256rrk,
  VCVTPH2DQZ256rrkz,
  VCVTPH2DQZrm,
  VCVTPH2DQZrmb,
  VCVTPH2DQZrmbk,
  VCVTPH2DQZrmbkz,
  VCVTPH2DQZrmk,
  VCVTPH2DQZrmkz,
  VCVTPH2DQZrr,
  VCVTPH2DQZrrb,
  VCVTPH2DQZrrbk,
  VCVTPH2DQZrrbkz,
  VCVTPH2DQZrrk,
  VCVTPH2DQZrrkz,
  VCVTPH2HF8SZ128rm,
  VCVTPH2HF8SZ128rmb,
  VCVTPH2HF8SZ128rmbk,
  VCVTPH2HF8SZ128rmbkz,
  VCVTPH2HF8SZ128rmk,
  VCVTPH2HF8SZ128rmkz,
  VCVTPH2HF8SZ128rr,
  VCVTPH2HF8SZ128rrk,
  VCVTPH2HF8SZ128rrkz,
  VCVTPH2HF8SZ256rm,
  VCVTPH2HF8SZ256rmb,
  VCVTPH2HF8SZ256rmbk,
  VCVTPH2HF8SZ256rmbkz,
  VCVTPH2HF8SZ256rmk,
  VCVTPH2HF8SZ256rmkz,
  VCVTPH2HF8SZ256rr,
  VCVTPH2HF8SZ256rrk,
  VCVTPH2HF8SZ256rrkz,
  VCVTPH2HF8SZrm,
  VCVTPH2HF8SZrmb,
  VCVTPH2HF8SZrmbk,
  VCVTPH2HF8SZrmbkz,
  VCVTPH2HF8SZrmk,
  VCVTPH2HF8SZrmkz,
  VCVTPH2HF8SZrr,
  VCVTPH2HF8SZrrk,
  VCVTPH2HF8SZrrkz,
  VCVTPH2HF8Z128rm,
  VCVTPH2HF8Z128rmb,
  VCVTPH2HF8Z128rmbk,
  VCVTPH2HF8Z128rmbkz,
  VCVTPH2HF8Z128rmk,
  VCVTPH2HF8Z128rmkz,
  VCVTPH2HF8Z128rr,
  VCVTPH2HF8Z128rrk,
  VCVTPH2HF8Z128rrkz,
  VCVTPH2HF8Z256rm,
  VCVTPH2HF8Z256rmb,
  VCVTPH2HF8Z256rmbk,
  VCVTPH2HF8Z256rmbkz,
  VCVTPH2HF8Z256rmk,
  VCVTPH2HF8Z256rmkz,
  VCVTPH2HF8Z256rr,
  VCVTPH2HF8Z256rrk,
  VCVTPH2HF8Z256rrkz,
  VCVTPH2HF8Zrm,
  VCVTPH2HF8Zrmb,
  VCVTPH2HF8Zrmbk,
  VCVTPH2HF8Zrmbkz,
  VCVTPH2HF8Zrmk,
  VCVTPH2HF8Zrmkz,
  VCVTPH2HF8Zrr,
  VCVTPH2HF8Zrrk,
  VCVTPH2HF8Zrrkz,
  VCVTPH2IBSZ128rm,
  VCVTPH2IBSZ128rmb,
  VCVTPH2IBSZ128rmbk,
  VCVTPH2IBSZ128rmbkz,
  VCVTPH2IBSZ128rmk,
  VCVTPH2IBSZ128rmkz,
  VCVTPH2IBSZ128rr,
  VCVTPH2IBSZ128rrk,
  VCVTPH2IBSZ128rrkz,
  VCVTPH2IBSZ256rm,
  VCVTPH2IBSZ256rmb,
  VCVTPH2IBSZ256rmbk,
  VCVTPH2IBSZ256rmbkz,
  VCVTPH2IBSZ256rmk,
  VCVTPH2IBSZ256rmkz,
  VCVTPH2IBSZ256rr,
  VCVTPH2IBSZ256rrk,
  VCVTPH2IBSZ256rrkz,
  VCVTPH2IBSZrm,
  VCVTPH2IBSZrmb,
  VCVTPH2IBSZrmbk,
  VCVTPH2IBSZrmbkz,
  VCVTPH2IBSZrmk,
  VCVTPH2IBSZrmkz,
  VCVTPH2IBSZrr,
  VCVTPH2IBSZrrb,
  VCVTPH2IBSZrrbk,
  VCVTPH2IBSZrrbkz,
  VCVTPH2IBSZrrk,
  VCVTPH2IBSZrrkz,
  VCVTPH2IUBSZ128rm,
  VCVTPH2IUBSZ128rmb,
  VCVTPH2IUBSZ128rmbk,
  VCVTPH2IUBSZ128rmbkz,
  VCVTPH2IUBSZ128rmk,
  VCVTPH2IUBSZ128rmkz,
  VCVTPH2IUBSZ128rr,
  VCVTPH2IUBSZ128rrk,
  VCVTPH2IUBSZ128rrkz,
  VCVTPH2IUBSZ256rm,
  VCVTPH2IUBSZ256rmb,
  VCVTPH2IUBSZ256rmbk,
  VCVTPH2IUBSZ256rmbkz,
  VCVTPH2IUBSZ256rmk,
  VCVTPH2IUBSZ256rmkz,
  VCVTPH2IUBSZ256rr,
  VCVTPH2IUBSZ256rrk,
  VCVTPH2IUBSZ256rrkz,
  VCVTPH2IUBSZrm,
  VCVTPH2IUBSZrmb,
  VCVTPH2IUBSZrmbk,
  VCVTPH2IUBSZrmbkz,
  VCVTPH2IUBSZrmk,
  VCVTPH2IUBSZrmkz,
  VCVTPH2IUBSZrr,
  VCVTPH2IUBSZrrb,
  VCVTPH2IUBSZrrbk,
  VCVTPH2IUBSZrrbkz,
  VCVTPH2IUBSZrrk,
  VCVTPH2IUBSZrrkz,
  VCVTPH2PDZ128rm,
  VCVTPH2PDZ128rmb,
  VCVTPH2PDZ128rmbk,
  VCVTPH2PDZ128rmbkz,
  VCVTPH2PDZ128rmk,
  VCVTPH2PDZ128rmkz,
  VCVTPH2PDZ128rr,
  VCVTPH2PDZ128rrk,
  VCVTPH2PDZ128rrkz,
  VCVTPH2PDZ256rm,
  VCVTPH2PDZ256rmb,
  VCVTPH2PDZ256rmbk,
  VCVTPH2PDZ256rmbkz,
  VCVTPH2PDZ256rmk,
  VCVTPH2PDZ256rmkz,
  VCVTPH2PDZ256rr,
  VCVTPH2PDZ256rrk,
  VCVTPH2PDZ256rrkz,
  VCVTPH2PDZrm,
  VCVTPH2PDZrmb,
  VCVTPH2PDZrmbk,
  VCVTPH2PDZrmbkz,
  VCVTPH2PDZrmk,
  VCVTPH2PDZrmkz,
  VCVTPH2PDZrr,
  VCVTPH2PDZrrb,
  VCVTPH2PDZrrbk,
  VCVTPH2PDZrrbkz,
  VCVTPH2PDZrrk,
  VCVTPH2PDZrrkz,
  VCVTPH2PSXZ128rm,
  VCVTPH2PSXZ128rmb,
  VCVTPH2PSXZ128rmbk,
  VCVTPH2PSXZ128rmbkz,
  VCVTPH2PSXZ128rmk,
  VCVTPH2PSXZ128rmkz,
  VCVTPH2PSXZ128rr,
  VCVTPH2PSXZ128rrk,
  VCVTPH2PSXZ128rrkz,
  VCVTPH2PSXZ256rm,
  VCVTPH2PSXZ256rmb,
  VCVTPH2PSXZ256rmbk,
  VCVTPH2PSXZ256rmbkz,
  VCVTPH2PSXZ256rmk,
  VCVTPH2PSXZ256rmkz,
  VCVTPH2PSXZ256rr,
  VCVTPH2PSXZ256rrk,
  VCVTPH2PSXZ256rrkz,
  VCVTPH2PSXZrm,
  VCVTPH2PSXZrmb,
  VCVTPH2PSXZrmbk,
  VCVTPH2PSXZrmbkz,
  VCVTPH2PSXZrmk,
  VCVTPH2PSXZrmkz,
  VCVTPH2PSXZrr,
  VCVTPH2PSXZrrb,
  VCVTPH2PSXZrrbk,
  VCVTPH2PSXZrrbkz,
  VCVTPH2PSXZrrk,
  VCVTPH2PSXZrrkz,
  VCVTPH2PSYrm,
  VCVTPH2PSYrr,
  VCVTPH2PSZ128rm,
  VCVTPH2PSZ128rmk,
  VCVTPH2PSZ128rmkz,
  VCVTPH2PSZ128rr,
  VCVTPH2PSZ128rrk,
  VCVTPH2PSZ128rrkz,
  VCVTPH2PSZ256rm,
  VCVTPH2PSZ256rmk,
  VCVTPH2PSZ256rmkz,
  VCVTPH2PSZ256rr,
  VCVTPH2PSZ256rrk,
  VCVTPH2PSZ256rrkz,
  VCVTPH2PSZrm,
  VCVTPH2PSZrmk,
  VCVTPH2PSZrmkz,
  VCVTPH2PSZrr,
  VCVTPH2PSZrrb,
  VCVTPH2PSZrrbk,
  VCVTPH2PSZrrbkz,
  VCVTPH2PSZrrk,
  VCVTPH2PSZrrkz,
  VCVTPH2PSrm,
  VCVTPH2PSrr,
  VCVTPH2QQZ128rm,
  VCVTPH2QQZ128rmb,
  VCVTPH2QQZ128rmbk,
  VCVTPH2QQZ128rmbkz,
  VCVTPH2QQZ128rmk,
  VCVTPH2QQZ128rmkz,
  VCVTPH2QQZ128rr,
  VCVTPH2QQZ128rrk,
  VCVTPH2QQZ128rrkz,
  VCVTPH2QQZ256rm,
  VCVTPH2QQZ256rmb,
  VCVTPH2QQZ256rmbk,
  VCVTPH2QQZ256rmbkz,
  VCVTPH2QQZ256rmk,
  VCVTPH2QQZ256rmkz,
  VCVTPH2QQZ256rr,
  VCVTPH2QQZ256rrk,
  VCVTPH2QQZ256rrkz,
  VCVTPH2QQZrm,
  VCVTPH2QQZrmb,
  VCVTPH2QQZrmbk,
  VCVTPH2QQZrmbkz,
  VCVTPH2QQZrmk,
  VCVTPH2QQZrmkz,
  VCVTPH2QQZrr,
  VCVTPH2QQZrrb,
  VCVTPH2QQZrrbk,
  VCVTPH2QQZrrbkz,
  VCVTPH2QQZrrk,
  VCVTPH2QQZrrkz,
  VCVTPH2UDQZ128rm,
  VCVTPH2UDQZ128rmb,
  VCVTPH2UDQZ128rmbk,
  VCVTPH2UDQZ128rmbkz,
  VCVTPH2UDQZ128rmk,
  VCVTPH2UDQZ128rmkz,
  VCVTPH2UDQZ128rr,
  VCVTPH2UDQZ128rrk,
  VCVTPH2UDQZ128rrkz,
  VCVTPH2UDQZ256rm,
  VCVTPH2UDQZ256rmb,
  VCVTPH2UDQZ256rmbk,
  VCVTPH2UDQZ256rmbkz,
  VCVTPH2UDQZ256rmk,
  VCVTPH2UDQZ256rmkz,
  VCVTPH2UDQZ256rr,
  VCVTPH2UDQZ256rrk,
  VCVTPH2UDQZ256rrkz,
  VCVTPH2UDQZrm,
  VCVTPH2UDQZrmb,
  VCVTPH2UDQZrmbk,
  VCVTPH2UDQZrmbkz,
  VCVTPH2UDQZrmk,
  VCVTPH2UDQZrmkz,
  VCVTPH2UDQZrr,
  VCVTPH2UDQZrrb,
  VCVTPH2UDQZrrbk,
  VCVTPH2UDQZrrbkz,
  VCVTPH2UDQZrrk,
  VCVTPH2UDQZrrkz,
  VCVTPH2UQQZ128rm,
  VCVTPH2UQQZ128rmb,
  VCVTPH2UQQZ128rmbk,
  VCVTPH2UQQZ128rmbkz,
  VCVTPH2UQQZ128rmk,
  VCVTPH2UQQZ128rmkz,
  VCVTPH2UQQZ128rr,
  VCVTPH2UQQZ128rrk,
  VCVTPH2UQQZ128rrkz,
  VCVTPH2UQQZ256rm,
  VCVTPH2UQQZ256rmb,
  VCVTPH2UQQZ256rmbk,
  VCVTPH2UQQZ256rmbkz,
  VCVTPH2UQQZ256rmk,
  VCVTPH2UQQZ256rmkz,
  VCVTPH2UQQZ256rr,
  VCVTPH2UQQZ256rrk,
  VCVTPH2UQQZ256rrkz,
  VCVTPH2UQQZrm,
  VCVTPH2UQQZrmb,
  VCVTPH2UQQZrmbk,
  VCVTPH2UQQZrmbkz,
  VCVTPH2UQQZrmk,
  VCVTPH2UQQZrmkz,
  VCVTPH2UQQZrr,
  VCVTPH2UQQZrrb,
  VCVTPH2UQQZrrbk,
  VCVTPH2UQQZrrbkz,
  VCVTPH2UQQZrrk,
  VCVTPH2UQQZrrkz,
  VCVTPH2UWZ128rm,
  VCVTPH2UWZ128rmb,
  VCVTPH2UWZ128rmbk,
  VCVTPH2UWZ128rmbkz,
  VCVTPH2UWZ128rmk,
  VCVTPH2UWZ128rmkz,
  VCVTPH2UWZ128rr,
  VCVTPH2UWZ128rrk,
  VCVTPH2UWZ128rrkz,
  VCVTPH2UWZ256rm,
  VCVTPH2UWZ256rmb,
  VCVTPH2UWZ256rmbk,
  VCVTPH2UWZ256rmbkz,
  VCVTPH2UWZ256rmk,
  VCVTPH2UWZ256rmkz,
  VCVTPH2UWZ256rr,
  VCVTPH2UWZ256rrk,
  VCVTPH2UWZ256rrkz,
  VCVTPH2UWZrm,
  VCVTPH2UWZrmb,
  VCVTPH2UWZrmbk,
  VCVTPH2UWZrmbkz,
  VCVTPH2UWZrmk,
  VCVTPH2UWZrmkz,
  VCVTPH2UWZrr,
  VCVTPH2UWZrrb,
  VCVTPH2UWZrrbk,
  VCVTPH2UWZrrbkz,
  VCVTPH2UWZrrk,
  VCVTPH2UWZrrkz,
  VCVTPH2WZ128rm,
  VCVTPH2WZ128rmb,
  VCVTPH2WZ128rmbk,
  VCVTPH2WZ128rmbkz,
  VCVTPH2WZ128rmk,
  VCVTPH2WZ128rmkz,
  VCVTPH2WZ128rr,
  VCVTPH2WZ128rrk,
  VCVTPH2WZ128rrkz,
  VCVTPH2WZ256rm,
  VCVTPH2WZ256rmb,
  VCVTPH2WZ256rmbk,
  VCVTPH2WZ256rmbkz,
  VCVTPH2WZ256rmk,
  VCVTPH2WZ256rmkz,
  VCVTPH2WZ256rr,
  VCVTPH2WZ256rrk,
  VCVTPH2WZ256rrkz,
  VCVTPH2WZrm,
  VCVTPH2WZrmb,
  VCVTPH2WZrmbk,
  VCVTPH2WZrmbkz,
  VCVTPH2WZrmk,
  VCVTPH2WZrmkz,
  VCVTPH2WZrr,
  VCVTPH2WZrrb,
  VCVTPH2WZrrbk,
  VCVTPH2WZrrbkz,
  VCVTPH2WZrrk,
  VCVTPH2WZrrkz,
  VCVTPS2DQYrm,
  VCVTPS2DQYrr,
  VCVTPS2DQZ128rm,
  VCVTPS2DQZ128rmb,
  VCVTPS2DQZ128rmbk,
  VCVTPS2DQZ128rmbkz,
  VCVTPS2DQZ128rmk,
  VCVTPS2DQZ128rmkz,
  VCVTPS2DQZ128rr,
  VCVTPS2DQZ128rrk,
  VCVTPS2DQZ128rrkz,
  VCVTPS2DQZ256rm,
  VCVTPS2DQZ256rmb,
  VCVTPS2DQZ256rmbk,
  VCVTPS2DQZ256rmbkz,
  VCVTPS2DQZ256rmk,
  VCVTPS2DQZ256rmkz,
  VCVTPS2DQZ256rr,
  VCVTPS2DQZ256rrk,
  VCVTPS2DQZ256rrkz,
  VCVTPS2DQZrm,
  VCVTPS2DQZrmb,
  VCVTPS2DQZrmbk,
  VCVTPS2DQZrmbkz,
  VCVTPS2DQZrmk,
  VCVTPS2DQZrmkz,
  VCVTPS2DQZrr,
  VCVTPS2DQZrrb,
  VCVTPS2DQZrrbk,
  VCVTPS2DQZrrbkz,
  VCVTPS2DQZrrk,
  VCVTPS2DQZrrkz,
  VCVTPS2DQrm,
  VCVTPS2DQrr,
  VCVTPS2IBSZ128rm,
  VCVTPS2IBSZ128rmb,
  VCVTPS2IBSZ128rmbk,
  VCVTPS2IBSZ128rmbkz,
  VCVTPS2IBSZ128rmk,
  VCVTPS2IBSZ128rmkz,
  VCVTPS2IBSZ128rr,
  VCVTPS2IBSZ128rrk,
  VCVTPS2IBSZ128rrkz,
  VCVTPS2IBSZ256rm,
  VCVTPS2IBSZ256rmb,
  VCVTPS2IBSZ256rmbk,
  VCVTPS2IBSZ256rmbkz,
  VCVTPS2IBSZ256rmk,
  VCVTPS2IBSZ256rmkz,
  VCVTPS2IBSZ256rr,
  VCVTPS2IBSZ256rrk,
  VCVTPS2IBSZ256rrkz,
  VCVTPS2IBSZrm,
  VCVTPS2IBSZrmb,
  VCVTPS2IBSZrmbk,
  VCVTPS2IBSZrmbkz,
  VCVTPS2IBSZrmk,
  VCVTPS2IBSZrmkz,
  VCVTPS2IBSZrr,
  VCVTPS2IBSZrrb,
  VCVTPS2IBSZrrbk,
  VCVTPS2IBSZrrbkz,
  VCVTPS2IBSZrrk,
  VCVTPS2IBSZrrkz,
  VCVTPS2IUBSZ128rm,
  VCVTPS2IUBSZ128rmb,
  VCVTPS2IUBSZ128rmbk,
  VCVTPS2IUBSZ128rmbkz,
  VCVTPS2IUBSZ128rmk,
  VCVTPS2IUBSZ128rmkz,
  VCVTPS2IUBSZ128rr,
  VCVTPS2IUBSZ128rrk,
  VCVTPS2IUBSZ128rrkz,
  VCVTPS2IUBSZ256rm,
  VCVTPS2IUBSZ256rmb,
  VCVTPS2IUBSZ256rmbk,
  VCVTPS2IUBSZ256rmbkz,
  VCVTPS2IUBSZ256rmk,
  VCVTPS2IUBSZ256rmkz,
  VCVTPS2IUBSZ256rr,
  VCVTPS2IUBSZ256rrk,
  VCVTPS2IUBSZ256rrkz,
  VCVTPS2IUBSZrm,
  VCVTPS2IUBSZrmb,
  VCVTPS2IUBSZrmbk,
  VCVTPS2IUBSZrmbkz,
  VCVTPS2IUBSZrmk,
  VCVTPS2IUBSZrmkz,
  VCVTPS2IUBSZrr,
  VCVTPS2IUBSZrrb,
  VCVTPS2IUBSZrrbk,
  VCVTPS2IUBSZrrbkz,
  VCVTPS2IUBSZrrk,
  VCVTPS2IUBSZrrkz,
  VCVTPS2PDYrm,
  VCVTPS2PDYrr,
  VCVTPS2PDZ128rm,
  VCVTPS2PDZ128rmb,
  VCVTPS2PDZ128rmbk,
  VCVTPS2PDZ128rmbkz,
  VCVTPS2PDZ128rmk,
  VCVTPS2PDZ128rmkz,
  VCVTPS2PDZ128rr,
  VCVTPS2PDZ128rrk,
  VCVTPS2PDZ128rrkz,
  VCVTPS2PDZ256rm,
  VCVTPS2PDZ256rmb,
  VCVTPS2PDZ256rmbk,
  VCVTPS2PDZ256rmbkz,
  VCVTPS2PDZ256rmk,
  VCVTPS2PDZ256rmkz,
  VCVTPS2PDZ256rr,
  VCVTPS2PDZ256rrk,
  VCVTPS2PDZ256rrkz,
  VCVTPS2PDZrm,
  VCVTPS2PDZrmb,
  VCVTPS2PDZrmbk,
  VCVTPS2PDZrmbkz,
  VCVTPS2PDZrmk,
  VCVTPS2PDZrmkz,
  VCVTPS2PDZrr,
  VCVTPS2PDZrrb,
  VCVTPS2PDZrrbk,
  VCVTPS2PDZrrbkz,
  VCVTPS2PDZrrk,
  VCVTPS2PDZrrkz,
  VCVTPS2PDrm,
  VCVTPS2PDrr,
  VCVTPS2PHXZ128rm,
  VCVTPS2PHXZ128rmb,
  VCVTPS2PHXZ128rmbk,
  VCVTPS2PHXZ128rmbkz,
  VCVTPS2PHXZ128rmk,
  VCVTPS2PHXZ128rmkz,
  VCVTPS2PHXZ128rr,
  VCVTPS2PHXZ128rrk,
  VCVTPS2PHXZ128rrkz,
  VCVTPS2PHXZ256rm,
  VCVTPS2PHXZ256rmb,
  VCVTPS2PHXZ256rmbk,
  VCVTPS2PHXZ256rmbkz,
  VCVTPS2PHXZ256rmk,
  VCVTPS2PHXZ256rmkz,
  VCVTPS2PHXZ256rr,
  VCVTPS2PHXZ256rrk,
  VCVTPS2PHXZ256rrkz,
  VCVTPS2PHXZrm,
  VCVTPS2PHXZrmb,
  VCVTPS2PHXZrmbk,
  VCVTPS2PHXZrmbkz,
  VCVTPS2PHXZrmk,
  VCVTPS2PHXZrmkz,
  VCVTPS2PHXZrr,
  VCVTPS2PHXZrrb,
  VCVTPS2PHXZrrbk,
  VCVTPS2PHXZrrbkz,
  VCVTPS2PHXZrrk,
  VCVTPS2PHXZrrkz,
  VCVTPS2PHYmr,
  VCVTPS2PHYrr,
  VCVTPS2PHZ128mr,
  VCVTPS2PHZ128mrk,
  VCVTPS2PHZ128rr,
  VCVTPS2PHZ128rrk,
  VCVTPS2PHZ128rrkz,
  VCVTPS2PHZ256mr,
  VCVTPS2PHZ256mrk,
  VCVTPS2PHZ256rr,
  VCVTPS2PHZ256rrk,
  VCVTPS2PHZ256rrkz,
  VCVTPS2PHZmr,
  VCVTPS2PHZmrk,
  VCVTPS2PHZrr,
  VCVTPS2PHZrrb,
  VCVTPS2PHZrrbk,
  VCVTPS2PHZrrbkz,
  VCVTPS2PHZrrk,
  VCVTPS2PHZrrkz,
  VCVTPS2PHmr,
  VCVTPS2PHrr,
  VCVTPS2QQZ128rm,
  VCVTPS2QQZ128rmb,
  VCVTPS2QQZ128rmbk,
  VCVTPS2QQZ128rmbkz,
  VCVTPS2QQZ128rmk,
  VCVTPS2QQZ128rmkz,
  VCVTPS2QQZ128rr,
  VCVTPS2QQZ128rrk,
  VCVTPS2QQZ128rrkz,
  VCVTPS2QQZ256rm,
  VCVTPS2QQZ256rmb,
  VCVTPS2QQZ256rmbk,
  VCVTPS2QQZ256rmbkz,
  VCVTPS2QQZ256rmk,
  VCVTPS2QQZ256rmkz,
  VCVTPS2QQZ256rr,
  VCVTPS2QQZ256rrk,
  VCVTPS2QQZ256rrkz,
  VCVTPS2QQZrm,
  VCVTPS2QQZrmb,
  VCVTPS2QQZrmbk,
  VCVTPS2QQZrmbkz,
  VCVTPS2QQZrmk,
  VCVTPS2QQZrmkz,
  VCVTPS2QQZrr,
  VCVTPS2QQZrrb,
  VCVTPS2QQZrrbk,
  VCVTPS2QQZrrbkz,
  VCVTPS2QQZrrk,
  VCVTPS2QQZrrkz,
  VCVTPS2UDQZ128rm,
  VCVTPS2UDQZ128rmb,
  VCVTPS2UDQZ128rmbk,
  VCVTPS2UDQZ128rmbkz,
  VCVTPS2UDQZ128rmk,
  VCVTPS2UDQZ128rmkz,
  VCVTPS2UDQZ128rr,
  VCVTPS2UDQZ128rrk,
  VCVTPS2UDQZ128rrkz,
  VCVTPS2UDQZ256rm,
  VCVTPS2UDQZ256rmb,
  VCVTPS2UDQZ256rmbk,
  VCVTPS2UDQZ256rmbkz,
  VCVTPS2UDQZ256rmk,
  VCVTPS2UDQZ256rmkz,
  VCVTPS2UDQZ256rr,
  VCVTPS2UDQZ256rrk,
  VCVTPS2UDQZ256rrkz,
  VCVTPS2UDQZrm,
  VCVTPS2UDQZrmb,
  VCVTPS2UDQZrmbk,
  VCVTPS2UDQZrmbkz,
  VCVTPS2UDQZrmk,
  VCVTPS2UDQZrmkz,
  VCVTPS2UDQZrr,
  VCVTPS2UDQZrrb,
  VCVTPS2UDQZrrbk,
  VCVTPS2UDQZrrbkz,
  VCVTPS2UDQZrrk,
  VCVTPS2UDQZrrkz,
  VCVTPS2UQQZ128rm,
  VCVTPS2UQQZ128rmb,
  VCVTPS2UQQZ128rmbk,
  VCVTPS2UQQZ128rmbkz,
  VCVTPS2UQQZ128rmk,
  VCVTPS2UQQZ128rmkz,
  VCVTPS2UQQZ128rr,
  VCVTPS2UQQZ128rrk,
  VCVTPS2UQQZ128rrkz,
  VCVTPS2UQQZ256rm,
  VCVTPS2UQQZ256rmb,
  VCVTPS2UQQZ256rmbk,
  VCVTPS2UQQZ256rmbkz,
  VCVTPS2UQQZ256rmk,
  VCVTPS2UQQZ256rmkz,
  VCVTPS2UQQZ256rr,
  VCVTPS2UQQZ256rrk,
  VCVTPS2UQQZ256rrkz,
  VCVTPS2UQQZrm,
  VCVTPS2UQQZrmb,
  VCVTPS2UQQZrmbk,
  VCVTPS2UQQZrmbkz,
  VCVTPS2UQQZrmk,
  VCVTPS2UQQZrmkz,
  VCVTPS2UQQZrr,
  VCVTPS2UQQZrrb,
  VCVTPS2UQQZrrbk,
  VCVTPS2UQQZrrbkz,
  VCVTPS2UQQZrrk,
  VCVTPS2UQQZrrkz,
  VCVTQQ2PDZ128rm,
  VCVTQQ2PDZ128rmb,
  VCVTQQ2PDZ128rmbk,
  VCVTQQ2PDZ128rmbkz,
  VCVTQQ2PDZ128rmk,
  VCVTQQ2PDZ128rmkz,
  VCVTQQ2PDZ128rr,
  VCVTQQ2PDZ128rrk,
  VCVTQQ2PDZ128rrkz,
  VCVTQQ2PDZ256rm,
  VCVTQQ2PDZ256rmb,
  VCVTQQ2PDZ256rmbk,
  VCVTQQ2PDZ256rmbkz,
  VCVTQQ2PDZ256rmk,
  VCVTQQ2PDZ256rmkz,
  VCVTQQ2PDZ256rr,
  VCVTQQ2PDZ256rrk,
  VCVTQQ2PDZ256rrkz,
  VCVTQQ2PDZrm,
  VCVTQQ2PDZrmb,
  VCVTQQ2PDZrmbk,
  VCVTQQ2PDZrmbkz,
  VCVTQQ2PDZrmk,
  VCVTQQ2PDZrmkz,
  VCVTQQ2PDZrr,
  VCVTQQ2PDZrrb,
  VCVTQQ2PDZrrbk,
  VCVTQQ2PDZrrbkz,
  VCVTQQ2PDZrrk,
  VCVTQQ2PDZrrkz,
  VCVTQQ2PHZ128rm,
  VCVTQQ2PHZ128rmb,
  VCVTQQ2PHZ128rmbk,
  VCVTQQ2PHZ128rmbkz,
  VCVTQQ2PHZ128rmk,
  VCVTQQ2PHZ128rmkz,
  VCVTQQ2PHZ128rr,
  VCVTQQ2PHZ128rrk,
  VCVTQQ2PHZ128rrkz,
  VCVTQQ2PHZ256rm,
  VCVTQQ2PHZ256rmb,
  VCVTQQ2PHZ256rmbk,
  VCVTQQ2PHZ256rmbkz,
  VCVTQQ2PHZ256rmk,
  VCVTQQ2PHZ256rmkz,
  VCVTQQ2PHZ256rr,
  VCVTQQ2PHZ256rrk,
  VCVTQQ2PHZ256rrkz,
  VCVTQQ2PHZrm,
  VCVTQQ2PHZrmb,
  VCVTQQ2PHZrmbk,
  VCVTQQ2PHZrmbkz,
  VCVTQQ2PHZrmk,
  VCVTQQ2PHZrmkz,
  VCVTQQ2PHZrr,
  VCVTQQ2PHZrrb,
  VCVTQQ2PHZrrbk,
  VCVTQQ2PHZrrbkz,
  VCVTQQ2PHZrrk,
  VCVTQQ2PHZrrkz,
  VCVTQQ2PSZ128rm,
  VCVTQQ2PSZ128rmb,
  VCVTQQ2PSZ128rmbk,
  VCVTQQ2PSZ128rmbkz,
  VCVTQQ2PSZ128rmk,
  VCVTQQ2PSZ128rmkz,
  VCVTQQ2PSZ128rr,
  VCVTQQ2PSZ128rrk,
  VCVTQQ2PSZ128rrkz,
  VCVTQQ2PSZ256rm,
  VCVTQQ2PSZ256rmb,
  VCVTQQ2PSZ256rmbk,
  VCVTQQ2PSZ256rmbkz,
  VCVTQQ2PSZ256rmk,
  VCVTQQ2PSZ256rmkz,
  VCVTQQ2PSZ256rr,
  VCVTQQ2PSZ256rrk,
  VCVTQQ2PSZ256rrkz,
  VCVTQQ2PSZrm,
  VCVTQQ2PSZrmb,
  VCVTQQ2PSZrmbk,
  VCVTQQ2PSZrmbkz,
  VCVTQQ2PSZrmk,
  VCVTQQ2PSZrmkz,
  VCVTQQ2PSZrr,
  VCVTQQ2PSZrrb,
  VCVTQQ2PSZrrbk,
  VCVTQQ2PSZrrbkz,
  VCVTQQ2PSZrrk,
  VCVTQQ2PSZrrkz,
  VCVTSD2SHZrm,
  VCVTSD2SHZrm_Int,
  VCVTSD2SHZrmk_Int,
  VCVTSD2SHZrmkz_Int,
  VCVTSD2SHZrr,
  VCVTSD2SHZrr_Int,
  VCVTSD2SHZrrb_Int,
  VCVTSD2SHZrrbk_Int,
  VCVTSD2SHZrrbkz_Int,
  VCVTSD2SHZrrk_Int,
  VCVTSD2SHZrrkz_Int,
  VCVTSD2SI64Zrm,
  VCVTSD2SI64Zrm_Int,
  VCVTSD2SI64Zrr,
  VCVTSD2SI64Zrr_Int,
  VCVTSD2SI64Zrrb_Int,
  VCVTSD2SI64rm,
  VCVTSD2SI64rm_Int,
  VCVTSD2SI64rr,
  VCVTSD2SI64rr_Int,
  VCVTSD2SIZrm,
  VCVTSD2SIZrm_Int,
  VCVTSD2SIZrr,
  VCVTSD2SIZrr_Int,
  VCVTSD2SIZrrb_Int,
  VCVTSD2SIrm,
  VCVTSD2SIrm_Int,
  VCVTSD2SIrr,
  VCVTSD2SIrr_Int,
  VCVTSD2SSZrm,
  VCVTSD2SSZrm_Int,
  VCVTSD2SSZrmk_Int,
  VCVTSD2SSZrmkz_Int,
  VCVTSD2SSZrr,
  VCVTSD2SSZrr_Int,
  VCVTSD2SSZrrb_Int,
  VCVTSD2SSZrrbk_Int,
  VCVTSD2SSZrrbkz_Int,
  VCVTSD2SSZrrk_Int,
  VCVTSD2SSZrrkz_Int,
  VCVTSD2SSrm,
  VCVTSD2SSrm_Int,
  VCVTSD2SSrr,
  VCVTSD2SSrr_Int,
  VCVTSD2USI64Zrm_Int,
  VCVTSD2USI64Zrr_Int,
  VCVTSD2USI64Zrrb_Int,
  VCVTSD2USIZrm_Int,
  VCVTSD2USIZrr_Int,
  VCVTSD2USIZrrb_Int,
  VCVTSH2SDZrm,
  VCVTSH2SDZrm_Int,
  VCVTSH2SDZrmk_Int,
  VCVTSH2SDZrmkz_Int,
  VCVTSH2SDZrr,
  VCVTSH2SDZrr_Int,
  VCVTSH2SDZrrb_Int,
  VCVTSH2SDZrrbk_Int,
  VCVTSH2SDZrrbkz_Int,
  VCVTSH2SDZrrk_Int,
  VCVTSH2SDZrrkz_Int,
  VCVTSH2SI64Zrm_Int,
  VCVTSH2SI64Zrr_Int,
  VCVTSH2SI64Zrrb_Int,
  VCVTSH2SIZrm_Int,
  VCVTSH2SIZrr_Int,
  VCVTSH2SIZrrb_Int,
  VCVTSH2SSZrm,
  VCVTSH2SSZrm_Int,
  VCVTSH2SSZrmk_Int,
  VCVTSH2SSZrmkz_Int,
  VCVTSH2SSZrr,
  VCVTSH2SSZrr_Int,
  VCVTSH2SSZrrb_Int,
  VCVTSH2SSZrrbk_Int,
  VCVTSH2SSZrrbkz_Int,
  VCVTSH2SSZrrk_Int,
  VCVTSH2SSZrrkz_Int,
  VCVTSH2USI64Zrm_Int,
  VCVTSH2USI64Zrr_Int,
  VCVTSH2USI64Zrrb_Int,
  VCVTSH2USIZrm_Int,
  VCVTSH2USIZrr_Int,
  VCVTSH2USIZrrb_Int,
  VCVTSI2SDZrm,
  VCVTSI2SDZrm_Int,
  VCVTSI2SDZrr,
  VCVTSI2SDZrr_Int,
  VCVTSI2SDrm,
  VCVTSI2SDrm_Int,
  VCVTSI2SDrr,
  VCVTSI2SDrr_Int,
  VCVTSI2SHZrm,
  VCVTSI2SHZrm_Int,
  VCVTSI2SHZrr,
  VCVTSI2SHZrr_Int,
  VCVTSI2SHZrrb_Int,
  VCVTSI2SSZrm,
  VCVTSI2SSZrm_Int,
  VCVTSI2SSZrr,
  VCVTSI2SSZrr_Int,
  VCVTSI2SSZrrb_Int,
  VCVTSI2SSrm,
  VCVTSI2SSrm_Int,
  VCVTSI2SSrr,
  VCVTSI2SSrr_Int,
  VCVTSI642SDZrm,
  VCVTSI642SDZrm_Int,
  VCVTSI642SDZrr,
  VCVTSI642SDZrr_Int,
  VCVTSI642SDZrrb_Int,
  VCVTSI642SDrm,
  VCVTSI642SDrm_Int,
  VCVTSI642SDrr,
  VCVTSI642SDrr_Int,
  VCVTSI642SHZrm,
  VCVTSI642SHZrm_Int,
  VCVTSI642SHZrr,
  VCVTSI642SHZrr_Int,
  VCVTSI642SHZrrb_Int,
  VCVTSI642SSZrm,
  VCVTSI642SSZrm_Int,
  VCVTSI642SSZrr,
  VCVTSI642SSZrr_Int,
  VCVTSI642SSZrrb_Int,
  VCVTSI642SSrm,
  VCVTSI642SSrm_Int,
  VCVTSI642SSrr,
  VCVTSI642SSrr_Int,
  VCVTSS2SDZrm,
  VCVTSS2SDZrm_Int,
  VCVTSS2SDZrmk_Int,
  VCVTSS2SDZrmkz_Int,
  VCVTSS2SDZrr,
  VCVTSS2SDZrr_Int,
  VCVTSS2SDZrrb_Int,
  VCVTSS2SDZrrbk_Int,
  VCVTSS2SDZrrbkz_Int,
  VCVTSS2SDZrrk_Int,
  VCVTSS2SDZrrkz_Int,
  VCVTSS2SDrm,
  VCVTSS2SDrm_Int,
  VCVTSS2SDrr,
  VCVTSS2SDrr_Int,
  VCVTSS2SHZrm,
  VCVTSS2SHZrm_Int,
  VCVTSS2SHZrmk_Int,
  VCVTSS2SHZrmkz_Int,
  VCVTSS2SHZrr,
  VCVTSS2SHZrr_Int,
  VCVTSS2SHZrrb_Int,
  VCVTSS2SHZrrbk_Int,
  VCVTSS2SHZrrbkz_Int,
  VCVTSS2SHZrrk_Int,
  VCVTSS2SHZrrkz_Int,
  VCVTSS2SI64Zrm,
  VCVTSS2SI64Zrm_Int,
  VCVTSS2SI64Zrr,
  VCVTSS2SI64Zrr_Int,
  VCVTSS2SI64Zrrb_Int,
  VCVTSS2SI64rm,
  VCVTSS2SI64rm_Int,
  VCVTSS2SI64rr,
  VCVTSS2SI64rr_Int,
  VCVTSS2SIZrm,
  VCVTSS2SIZrm_Int,
  VCVTSS2SIZrr,
  VCVTSS2SIZrr_Int,
  VCVTSS2SIZrrb_Int,
  VCVTSS2SIrm,
  VCVTSS2SIrm_Int,
  VCVTSS2SIrr,
  VCVTSS2SIrr_Int,
  VCVTSS2USI64Zrm_Int,
  VCVTSS2USI64Zrr_Int,
  VCVTSS2USI64Zrrb_Int,
  VCVTSS2USIZrm_Int,
  VCVTSS2USIZrr_Int,
  VCVTSS2USIZrrb_Int,
  VCVTTBF162IBSZ128rm,
  VCVTTBF162IBSZ128rmb,
  VCVTTBF162IBSZ128rmbk,
  VCVTTBF162IBSZ128rmbkz,
  VCVTTBF162IBSZ128rmk,
  VCVTTBF162IBSZ128rmkz,
  VCVTTBF162IBSZ128rr,
  VCVTTBF162IBSZ128rrk,
  VCVTTBF162IBSZ128rrkz,
  VCVTTBF162IBSZ256rm,
  VCVTTBF162IBSZ256rmb,
  VCVTTBF162IBSZ256rmbk,
  VCVTTBF162IBSZ256rmbkz,
  VCVTTBF162IBSZ256rmk,
  VCVTTBF162IBSZ256rmkz,
  VCVTTBF162IBSZ256rr,
  VCVTTBF162IBSZ256rrk,
  VCVTTBF162IBSZ256rrkz,
  VCVTTBF162IBSZrm,
  VCVTTBF162IBSZrmb,
  VCVTTBF162IBSZrmbk,
  VCVTTBF162IBSZrmbkz,
  VCVTTBF162IBSZrmk,
  VCVTTBF162IBSZrmkz,
  VCVTTBF162IBSZrr,
  VCVTTBF162IBSZrrk,
  VCVTTBF162IBSZrrkz,
  VCVTTBF162IUBSZ128rm,
  VCVTTBF162IUBSZ128rmb,
  VCVTTBF162IUBSZ128rmbk,
  VCVTTBF162IUBSZ128rmbkz,
  VCVTTBF162IUBSZ128rmk,
  VCVTTBF162IUBSZ128rmkz,
  VCVTTBF162IUBSZ128rr,
  VCVTTBF162IUBSZ128rrk,
  VCVTTBF162IUBSZ128rrkz,
  VCVTTBF162IUBSZ256rm,
  VCVTTBF162IUBSZ256rmb,
  VCVTTBF162IUBSZ256rmbk,
  VCVTTBF162IUBSZ256rmbkz,
  VCVTTBF162IUBSZ256rmk,
  VCVTTBF162IUBSZ256rmkz,
  VCVTTBF162IUBSZ256rr,
  VCVTTBF162IUBSZ256rrk,
  VCVTTBF162IUBSZ256rrkz,
  VCVTTBF162IUBSZrm,
  VCVTTBF162IUBSZrmb,
  VCVTTBF162IUBSZrmbk,
  VCVTTBF162IUBSZrmbkz,
  VCVTTBF162IUBSZrmk,
  VCVTTBF162IUBSZrmkz,
  VCVTTBF162IUBSZrr,
  VCVTTBF162IUBSZrrk,
  VCVTTBF162IUBSZrrkz,
  VCVTTPD2DQSZ128rm,
  VCVTTPD2DQSZ128rmb,
  VCVTTPD2DQSZ128rmbk,
  VCVTTPD2DQSZ128rmbkz,
  VCVTTPD2DQSZ128rmk,
  VCVTTPD2DQSZ128rmkz,
  VCVTTPD2DQSZ128rr,
  VCVTTPD2DQSZ128rrk,
  VCVTTPD2DQSZ128rrkz,
  VCVTTPD2DQSZ256rm,
  VCVTTPD2DQSZ256rmb,
  VCVTTPD2DQSZ256rmbk,
  VCVTTPD2DQSZ256rmbkz,
  VCVTTPD2DQSZ256rmk,
  VCVTTPD2DQSZ256rmkz,
  VCVTTPD2DQSZ256rr,
  VCVTTPD2DQSZ256rrb,
  VCVTTPD2DQSZ256rrbk,
  VCVTTPD2DQSZ256rrbkz,
  VCVTTPD2DQSZ256rrk,
  VCVTTPD2DQSZ256rrkz,
  VCVTTPD2DQSZrm,
  VCVTTPD2DQSZrmb,
  VCVTTPD2DQSZrmbk,
  VCVTTPD2DQSZrmbkz,
  VCVTTPD2DQSZrmk,
  VCVTTPD2DQSZrmkz,
  VCVTTPD2DQSZrr,
  VCVTTPD2DQSZrrb,
  VCVTTPD2DQSZrrbk,
  VCVTTPD2DQSZrrbkz,
  VCVTTPD2DQSZrrk,
  VCVTTPD2DQSZrrkz,
  VCVTTPD2DQYrm,
  VCVTTPD2DQYrr,
  VCVTTPD2DQZ128rm,
  VCVTTPD2DQZ128rmb,
  VCVTTPD2DQZ128rmbk,
  VCVTTPD2DQZ128rmbkz,
  VCVTTPD2DQZ128rmk,
  VCVTTPD2DQZ128rmkz,
  VCVTTPD2DQZ128rr,
  VCVTTPD2DQZ128rrk,
  VCVTTPD2DQZ128rrkz,
  VCVTTPD2DQZ256rm,
  VCVTTPD2DQZ256rmb,
  VCVTTPD2DQZ256rmbk,
  VCVTTPD2DQZ256rmbkz,
  VCVTTPD2DQZ256rmk,
  VCVTTPD2DQZ256rmkz,
  VCVTTPD2DQZ256rr,
  VCVTTPD2DQZ256rrk,
  VCVTTPD2DQZ256rrkz,
  VCVTTPD2DQZrm,
  VCVTTPD2DQZrmb,
  VCVTTPD2DQZrmbk,
  VCVTTPD2DQZrmbkz,
  VCVTTPD2DQZrmk,
  VCVTTPD2DQZrmkz,
  VCVTTPD2DQZrr,
  VCVTTPD2DQZrrb,
  VCVTTPD2DQZrrbk,
  VCVTTPD2DQZrrbkz,
  VCVTTPD2DQZrrk,
  VCVTTPD2DQZrrkz,
  VCVTTPD2DQrm,
  VCVTTPD2DQrr,
  VCVTTPD2QQSZ128rm,
  VCVTTPD2QQSZ128rmb,
  VCVTTPD2QQSZ128rmbk,
  VCVTTPD2QQSZ128rmbkz,
  VCVTTPD2QQSZ128rmk,
  VCVTTPD2QQSZ128rmkz,
  VCVTTPD2QQSZ128rr,
  VCVTTPD2QQSZ128rrk,
  VCVTTPD2QQSZ128rrkz,
  VCVTTPD2QQSZ256rm,
  VCVTTPD2QQSZ256rmb,
  VCVTTPD2QQSZ256rmbk,
  VCVTTPD2QQSZ256rmbkz,
  VCVTTPD2QQSZ256rmk,
  VCVTTPD2QQSZ256rmkz,
  VCVTTPD2QQSZ256rr,
  VCVTTPD2QQSZ256rrb,
  VCVTTPD2QQSZ256rrbk,
  VCVTTPD2QQSZ256rrbkz,
  VCVTTPD2QQSZ256rrk,
  VCVTTPD2QQSZ256rrkz,
  VCVTTPD2QQSZrm,
  VCVTTPD2QQSZrmb,
  VCVTTPD2QQSZrmbk,
  VCVTTPD2QQSZrmbkz,
  VCVTTPD2QQSZrmk,
  VCVTTPD2QQSZrmkz,
  VCVTTPD2QQSZrr,
  VCVTTPD2QQSZrrb,
  VCVTTPD2QQSZrrbk,
  VCVTTPD2QQSZrrbkz,
  VCVTTPD2QQSZrrk,
  VCVTTPD2QQSZrrkz,
  VCVTTPD2QQZ128rm,
  VCVTTPD2QQZ128rmb,
  VCVTTPD2QQZ128rmbk,
  VCVTTPD2QQZ128rmbkz,
  VCVTTPD2QQZ128rmk,
  VCVTTPD2QQZ128rmkz,
  VCVTTPD2QQZ128rr,
  VCVTTPD2QQZ128rrk,
  VCVTTPD2QQZ128rrkz,
  VCVTTPD2QQZ256rm,
  VCVTTPD2QQZ256rmb,
  VCVTTPD2QQZ256rmbk,
  VCVTTPD2QQZ256rmbkz,
  VCVTTPD2QQZ256rmk,
  VCVTTPD2QQZ256rmkz,
  VCVTTPD2QQZ256rr,
  VCVTTPD2QQZ256rrk,
  VCVTTPD2QQZ256rrkz,
  VCVTTPD2QQZrm,
  VCVTTPD2QQZrmb,
  VCVTTPD2QQZrmbk,
  VCVTTPD2QQZrmbkz,
  VCVTTPD2QQZrmk,
  VCVTTPD2QQZrmkz,
  VCVTTPD2QQZrr,
  VCVTTPD2QQZrrb,
  VCVTTPD2QQZrrbk,
  VCVTTPD2QQZrrbkz,
  VCVTTPD2QQZrrk,
  VCVTTPD2QQZrrkz,
  VCVTTPD2UDQSZ128rm,
  VCVTTPD2UDQSZ128rmb,
  VCVTTPD2UDQSZ128rmbk,
  VCVTTPD2UDQSZ128rmbkz,
  VCVTTPD2UDQSZ128rmk,
  VCVTTPD2UDQSZ128rmkz,
  VCVTTPD2UDQSZ128rr,
  VCVTTPD2UDQSZ128rrk,
  VCVTTPD2UDQSZ128rrkz,
  VCVTTPD2UDQSZ256rm,
  VCVTTPD2UDQSZ256rmb,
  VCVTTPD2UDQSZ256rmbk,
  VCVTTPD2UDQSZ256rmbkz,
  VCVTTPD2UDQSZ256rmk,
  VCVTTPD2UDQSZ256rmkz,
  VCVTTPD2UDQSZ256rr,
  VCVTTPD2UDQSZ256rrb,
  VCVTTPD2UDQSZ256rrbk,
  VCVTTPD2UDQSZ256rrbkz,
  VCVTTPD2UDQSZ256rrk,
  VCVTTPD2UDQSZ256rrkz,
  VCVTTPD2UDQSZrm,
  VCVTTPD2UDQSZrmb,
  VCVTTPD2UDQSZrmbk,
  VCVTTPD2UDQSZrmbkz,
  VCVTTPD2UDQSZrmk,
  VCVTTPD2UDQSZrmkz,
  VCVTTPD2UDQSZrr,
  VCVTTPD2UDQSZrrb,
  VCVTTPD2UDQSZrrbk,
  VCVTTPD2UDQSZrrbkz,
  VCVTTPD2UDQSZrrk,
  VCVTTPD2UDQSZrrkz,
  VCVTTPD2UDQZ128rm,
  VCVTTPD2UDQZ128rmb,
  VCVTTPD2UDQZ128rmbk,
  VCVTTPD2UDQZ128rmbkz,
  VCVTTPD2UDQZ128rmk,
  VCVTTPD2UDQZ128rmkz,
  VCVTTPD2UDQZ128rr,
  VCVTTPD2UDQZ128rrk,
  VCVTTPD2UDQZ128rrkz,
  VCVTTPD2UDQZ256rm,
  VCVTTPD2UDQZ256rmb,
  VCVTTPD2UDQZ256rmbk,
  VCVTTPD2UDQZ256rmbkz,
  VCVTTPD2UDQZ256rmk,
  VCVTTPD2UDQZ256rmkz,
  VCVTTPD2UDQZ256rr,
  VCVTTPD2UDQZ256rrk,
  VCVTTPD2UDQZ256rrkz,
  VCVTTPD2UDQZrm,
  VCVTTPD2UDQZrmb,
  VCVTTPD2UDQZrmbk,
  VCVTTPD2UDQZrmbkz,
  VCVTTPD2UDQZrmk,
  VCVTTPD2UDQZrmkz,
  VCVTTPD2UDQZrr,
  VCVTTPD2UDQZrrb,
  VCVTTPD2UDQZrrbk,
  VCVTTPD2UDQZrrbkz,
  VCVTTPD2UDQZrrk,
  VCVTTPD2UDQZrrkz,
  VCVTTPD2UQQSZ128rm,
  VCVTTPD2UQQSZ128rmb,
  VCVTTPD2UQQSZ128rmbk,
  VCVTTPD2UQQSZ128rmbkz,
  VCVTTPD2UQQSZ128rmk,
  VCVTTPD2UQQSZ128rmkz,
  VCVTTPD2UQQSZ128rr,
  VCVTTPD2UQQSZ128rrk,
  VCVTTPD2UQQSZ128rrkz,
  VCVTTPD2UQQSZ256rm,
  VCVTTPD2UQQSZ256rmb,
  VCVTTPD2UQQSZ256rmbk,
  VCVTTPD2UQQSZ256rmbkz,
  VCVTTPD2UQQSZ256rmk,
  VCVTTPD2UQQSZ256rmkz,
  VCVTTPD2UQQSZ256rr,
  VCVTTPD2UQQSZ256rrb,
  VCVTTPD2UQQSZ256rrbk,
  VCVTTPD2UQQSZ256rrbkz,
  VCVTTPD2UQQSZ256rrk,
  VCVTTPD2UQQSZ256rrkz,
  VCVTTPD2UQQSZrm,
  VCVTTPD2UQQSZrmb,
  VCVTTPD2UQQSZrmbk,
  VCVTTPD2UQQSZrmbkz,
  VCVTTPD2UQQSZrmk,
  VCVTTPD2UQQSZrmkz,
  VCVTTPD2UQQSZrr,
  VCVTTPD2UQQSZrrb,
  VCVTTPD2UQQSZrrbk,
  VCVTTPD2UQQSZrrbkz,
  VCVTTPD2UQQSZrrk,
  VCVTTPD2UQQSZrrkz,
  VCVTTPD2UQQZ128rm,
  VCVTTPD2UQQZ128rmb,
  VCVTTPD2UQQZ128rmbk,
  VCVTTPD2UQQZ128rmbkz,
  VCVTTPD2UQQZ128rmk,
  VCVTTPD2UQQZ128rmkz,
  VCVTTPD2UQQZ128rr,
  VCVTTPD2UQQZ128rrk,
  VCVTTPD2UQQZ128rrkz,
  VCVTTPD2UQQZ256rm,
  VCVTTPD2UQQZ256rmb,
  VCVTTPD2UQQZ256rmbk,
  VCVTTPD2UQQZ256rmbkz,
  VCVTTPD2UQQZ256rmk,
  VCVTTPD2UQQZ256rmkz,
  VCVTTPD2UQQZ256rr,
  VCVTTPD2UQQZ256rrk,
  VCVTTPD2UQQZ256rrkz,
  VCVTTPD2UQQZrm,
  VCVTTPD2UQQZrmb,
  VCVTTPD2UQQZrmbk,
  VCVTTPD2UQQZrmbkz,
  VCVTTPD2UQQZrmk,
  VCVTTPD2UQQZrmkz,
  VCVTTPD2UQQZrr,
  VCVTTPD2UQQZrrb,
  VCVTTPD2UQQZrrbk,
  VCVTTPD2UQQZrrbkz,
  VCVTTPD2UQQZrrk,
  VCVTTPD2UQQZrrkz,
  VCVTTPH2DQZ128rm,
  VCVTTPH2DQZ128rmb,
  VCVTTPH2DQZ128rmbk,
  VCVTTPH2DQZ128rmbkz,
  VCVTTPH2DQZ128rmk,
  VCVTTPH2DQZ128rmkz,
  VCVTTPH2DQZ128rr,
  VCVTTPH2DQZ128rrk,
  VCVTTPH2DQZ128rrkz,
  VCVTTPH2DQZ256rm,
  VCVTTPH2DQZ256rmb,
  VCVTTPH2DQZ256rmbk,
  VCVTTPH2DQZ256rmbkz,
  VCVTTPH2DQZ256rmk,
  VCVTTPH2DQZ256rmkz,
  VCVTTPH2DQZ256rr,
  VCVTTPH2DQZ256rrk,
  VCVTTPH2DQZ256rrkz,
  VCVTTPH2DQZrm,
  VCVTTPH2DQZrmb,
  VCVTTPH2DQZrmbk,
  VCVTTPH2DQZrmbkz,
  VCVTTPH2DQZrmk,
  VCVTTPH2DQZrmkz,
  VCVTTPH2DQZrr,
  VCVTTPH2DQZrrb,
  VCVTTPH2DQZrrbk,
  VCVTTPH2DQZrrbkz,
  VCVTTPH2DQZrrk,
  VCVTTPH2DQZrrkz,
  VCVTTPH2IBSZ128rm,
  VCVTTPH2IBSZ128rmb,
  VCVTTPH2IBSZ128rmbk,
  VCVTTPH2IBSZ128rmbkz,
  VCVTTPH2IBSZ128rmk,
  VCVTTPH2IBSZ128rmkz,
  VCVTTPH2IBSZ128rr,
  VCVTTPH2IBSZ128rrk,
  VCVTTPH2IBSZ128rrkz,
  VCVTTPH2IBSZ256rm,
  VCVTTPH2IBSZ256rmb,
  VCVTTPH2IBSZ256rmbk,
  VCVTTPH2IBSZ256rmbkz,
  VCVTTPH2IBSZ256rmk,
  VCVTTPH2IBSZ256rmkz,
  VCVTTPH2IBSZ256rr,
  VCVTTPH2IBSZ256rrk,
  VCVTTPH2IBSZ256rrkz,
  VCVTTPH2IBSZrm,
  VCVTTPH2IBSZrmb,
  VCVTTPH2IBSZrmbk,
  VCVTTPH2IBSZrmbkz,
  VCVTTPH2IBSZrmk,
  VCVTTPH2IBSZrmkz,
  VCVTTPH2IBSZrr,
  VCVTTPH2IBSZrrb,
  VCVTTPH2IBSZrrbk,
  VCVTTPH2IBSZrrbkz,
  VCVTTPH2IBSZrrk,
  VCVTTPH2IBSZrrkz,
  VCVTTPH2IUBSZ128rm,
  VCVTTPH2IUBSZ128rmb,
  VCVTTPH2IUBSZ128rmbk,
  VCVTTPH2IUBSZ128rmbkz,
  VCVTTPH2IUBSZ128rmk,
  VCVTTPH2IUBSZ128rmkz,
  VCVTTPH2IUBSZ128rr,
  VCVTTPH2IUBSZ128rrk,
  VCVTTPH2IUBSZ128rrkz,
  VCVTTPH2IUBSZ256rm,
  VCVTTPH2IUBSZ256rmb,
  VCVTTPH2IUBSZ256rmbk,
  VCVTTPH2IUBSZ256rmbkz,
  VCVTTPH2IUBSZ256rmk,
  VCVTTPH2IUBSZ256rmkz,
  VCVTTPH2IUBSZ256rr,
  VCVTTPH2IUBSZ256rrk,
  VCVTTPH2IUBSZ256rrkz,
  VCVTTPH2IUBSZrm,
  VCVTTPH2IUBSZrmb,
  VCVTTPH2IUBSZrmbk,
  VCVTTPH2IUBSZrmbkz,
  VCVTTPH2IUBSZrmk,
  VCVTTPH2IUBSZrmkz,
  VCVTTPH2IUBSZrr,
  VCVTTPH2IUBSZrrb,
  VCVTTPH2IUBSZrrbk,
  VCVTTPH2IUBSZrrbkz,
  VCVTTPH2IUBSZrrk,
  VCVTTPH2IUBSZrrkz,
  VCVTTPH2QQZ128rm,
  VCVTTPH2QQZ128rmb,
  VCVTTPH2QQZ128rmbk,
  VCVTTPH2QQZ128rmbkz,
  VCVTTPH2QQZ128rmk,
  VCVTTPH2QQZ128rmkz,
  VCVTTPH2QQZ128rr,
  VCVTTPH2QQZ128rrk,
  VCVTTPH2QQZ128rrkz,
  VCVTTPH2QQZ256rm,
  VCVTTPH2QQZ256rmb,
  VCVTTPH2QQZ256rmbk,
  VCVTTPH2QQZ256rmbkz,
  VCVTTPH2QQZ256rmk,
  VCVTTPH2QQZ256rmkz,
  VCVTTPH2QQZ256rr,
  VCVTTPH2QQZ256rrk,
  VCVTTPH2QQZ256rrkz,
  VCVTTPH2QQZrm,
  VCVTTPH2QQZrmb,
  VCVTTPH2QQZrmbk,
  VCVTTPH2QQZrmbkz,
  VCVTTPH2QQZrmk,
  VCVTTPH2QQZrmkz,
  VCVTTPH2QQZrr,
  VCVTTPH2QQZrrb,
  VCVTTPH2QQZrrbk,
  VCVTTPH2QQZrrbkz,
  VCVTTPH2QQZrrk,
  VCVTTPH2QQZrrkz,
  VCVTTPH2UDQZ128rm,
  VCVTTPH2UDQZ128rmb,
  VCVTTPH2UDQZ128rmbk,
  VCVTTPH2UDQZ128rmbkz,
  VCVTTPH2UDQZ128rmk,
  VCVTTPH2UDQZ128rmkz,
  VCVTTPH2UDQZ128rr,
  VCVTTPH2UDQZ128rrk,
  VCVTTPH2UDQZ128rrkz,
  VCVTTPH2UDQZ256rm,
  VCVTTPH2UDQZ256rmb,
  VCVTTPH2UDQZ256rmbk,
  VCVTTPH2UDQZ256rmbkz,
  VCVTTPH2UDQZ256rmk,
  VCVTTPH2UDQZ256rmkz,
  VCVTTPH2UDQZ256rr,
  VCVTTPH2UDQZ256rrk,
  VCVTTPH2UDQZ256rrkz,
  VCVTTPH2UDQZrm,
  VCVTTPH2UDQZrmb,
  VCVTTPH2UDQZrmbk,
  VCVTTPH2UDQZrmbkz,
  VCVTTPH2UDQZrmk,
  VCVTTPH2UDQZrmkz,
  VCVTTPH2UDQZrr,
  VCVTTPH2UDQZrrb,
  VCVTTPH2UDQZrrbk,
  VCVTTPH2UDQZrrbkz,
  VCVTTPH2UDQZrrk,
  VCVTTPH2UDQZrrkz,
  VCVTTPH2UQQZ128rm,
  VCVTTPH2UQQZ128rmb,
  VCVTTPH2UQQZ128rmbk,
  VCVTTPH2UQQZ128rmbkz,
  VCVTTPH2UQQZ128rmk,
  VCVTTPH2UQQZ128rmkz,
  VCVTTPH2UQQZ128rr,
  VCVTTPH2UQQZ128rrk,
  VCVTTPH2UQQZ128rrkz,
  VCVTTPH2UQQZ256rm,
  VCVTTPH2UQQZ256rmb,
  VCVTTPH2UQQZ256rmbk,
  VCVTTPH2UQQZ256rmbkz,
  VCVTTPH2UQQZ256rmk,
  VCVTTPH2UQQZ256rmkz,
  VCVTTPH2UQQZ256rr,
  VCVTTPH2UQQZ256rrk,
  VCVTTPH2UQQZ256rrkz,
  VCVTTPH2UQQZrm,
  VCVTTPH2UQQZrmb,
  VCVTTPH2UQQZrmbk,
  VCVTTPH2UQQZrmbkz,
  VCVTTPH2UQQZrmk,
  VCVTTPH2UQQZrmkz,
  VCVTTPH2UQQZrr,
  VCVTTPH2UQQZrrb,
  VCVTTPH2UQQZrrbk,
  VCVTTPH2UQQZrrbkz,
  VCVTTPH2UQQZrrk,
  VCVTTPH2UQQZrrkz,
  VCVTTPH2UWZ128rm,
  VCVTTPH2UWZ128rmb,
  VCVTTPH2UWZ128rmbk,
  VCVTTPH2UWZ128rmbkz,
  VCVTTPH2UWZ128rmk,
  VCVTTPH2UWZ128rmkz,
  VCVTTPH2UWZ128rr,
  VCVTTPH2UWZ128rrk,
  VCVTTPH2UWZ128rrkz,
  VCVTTPH2UWZ256rm,
  VCVTTPH2UWZ256rmb,
  VCVTTPH2UWZ256rmbk,
  VCVTTPH2UWZ256rmbkz,
  VCVTTPH2UWZ256rmk,
  VCVTTPH2UWZ256rmkz,
  VCVTTPH2UWZ256rr,
  VCVTTPH2UWZ256rrk,
  VCVTTPH2UWZ256rrkz,
  VCVTTPH2UWZrm,
  VCVTTPH2UWZrmb,
  VCVTTPH2UWZrmbk,
  VCVTTPH2UWZrmbkz,
  VCVTTPH2UWZrmk,
  VCVTTPH2UWZrmkz,
  VCVTTPH2UWZrr,
  VCVTTPH2UWZrrb,
  VCVTTPH2UWZrrbk,
  VCVTTPH2UWZrrbkz,
  VCVTTPH2UWZrrk,
  VCVTTPH2UWZrrkz,
  VCVTTPH2WZ128rm,
  VCVTTPH2WZ128rmb,
  VCVTTPH2WZ128rmbk,
  VCVTTPH2WZ128rmbkz,
  VCVTTPH2WZ128rmk,
  VCVTTPH2WZ128rmkz,
  VCVTTPH2WZ128rr,
  VCVTTPH2WZ128rrk,
  VCVTTPH2WZ128rrkz,
  VCVTTPH2WZ256rm,
  VCVTTPH2WZ256rmb,
  VCVTTPH2WZ256rmbk,
  VCVTTPH2WZ256rmbkz,
  VCVTTPH2WZ256rmk,
  VCVTTPH2WZ256rmkz,
  VCVTTPH2WZ256rr,
  VCVTTPH2WZ256rrk,
  VCVTTPH2WZ256rrkz,
  VCVTTPH2WZrm,
  VCVTTPH2WZrmb,
  VCVTTPH2WZrmbk,
  VCVTTPH2WZrmbkz,
  VCVTTPH2WZrmk,
  VCVTTPH2WZrmkz,
  VCVTTPH2WZrr,
  VCVTTPH2WZrrb,
  VCVTTPH2WZrrbk,
  VCVTTPH2WZrrbkz,
  VCVTTPH2WZrrk,
  VCVTTPH2WZrrkz,
  VCVTTPS2DQSZ128rm,
  VCVTTPS2DQSZ128rmb,
  VCVTTPS2DQSZ128rmbk,
  VCVTTPS2DQSZ128rmbkz,
  VCVTTPS2DQSZ128rmk,
  VCVTTPS2DQSZ128rmkz,
  VCVTTPS2DQSZ128rr,
  VCVTTPS2DQSZ128rrk,
  VCVTTPS2DQSZ128rrkz,
  VCVTTPS2DQSZ256rm,
  VCVTTPS2DQSZ256rmb,
  VCVTTPS2DQSZ256rmbk,
  VCVTTPS2DQSZ256rmbkz,
  VCVTTPS2DQSZ256rmk,
  VCVTTPS2DQSZ256rmkz,
  VCVTTPS2DQSZ256rr,
  VCVTTPS2DQSZ256rrk,
  VCVTTPS2DQSZ256rrkz,
  VCVTTPS2DQSZrm,
  VCVTTPS2DQSZrmb,
  VCVTTPS2DQSZrmbk,
  VCVTTPS2DQSZrmbkz,
  VCVTTPS2DQSZrmk,
  VCVTTPS2DQSZrmkz,
  VCVTTPS2DQSZrr,
  VCVTTPS2DQSZrrb,
  VCVTTPS2DQSZrrbk,
  VCVTTPS2DQSZrrbkz,
  VCVTTPS2DQSZrrk,
  VCVTTPS2DQSZrrkz,
  VCVTTPS2DQYrm,
  VCVTTPS2DQYrr,
  VCVTTPS2DQZ128rm,
  VCVTTPS2DQZ128rmb,
  VCVTTPS2DQZ128rmbk,
  VCVTTPS2DQZ128rmbkz,
  VCVTTPS2DQZ128rmk,
  VCVTTPS2DQZ128rmkz,
  VCVTTPS2DQZ128rr,
  VCVTTPS2DQZ128rrk,
  VCVTTPS2DQZ128rrkz,
  VCVTTPS2DQZ256rm,
  VCVTTPS2DQZ256rmb,
  VCVTTPS2DQZ256rmbk,
  VCVTTPS2DQZ256rmbkz,
  VCVTTPS2DQZ256rmk,
  VCVTTPS2DQZ256rmkz,
  VCVTTPS2DQZ256rr,
  VCVTTPS2DQZ256rrk,
  VCVTTPS2DQZ256rrkz,
  VCVTTPS2DQZrm,
  VCVTTPS2DQZrmb,
  VCVTTPS2DQZrmbk,
  VCVTTPS2DQZrmbkz,
  VCVTTPS2DQZrmk,
  VCVTTPS2DQZrmkz,
  VCVTTPS2DQZrr,
  VCVTTPS2DQZrrb,
  VCVTTPS2DQZrrbk,
  VCVTTPS2DQZrrbkz,
  VCVTTPS2DQZrrk,
  VCVTTPS2DQZrrkz,
  VCVTTPS2DQrm,
  VCVTTPS2DQrr,
  VCVTTPS2IBSZ128rm,
  VCVTTPS2IBSZ128rmb,
  VCVTTPS2IBSZ128rmbk,
  VCVTTPS2IBSZ128rmbkz,
  VCVTTPS2IBSZ128rmk,
  VCVTTPS2IBSZ128rmkz,
  VCVTTPS2IBSZ128rr,
  VCVTTPS2IBSZ128rrk,
  VCVTTPS2IBSZ128rrkz,
  VCVTTPS2IBSZ256rm,
  VCVTTPS2IBSZ256rmb,
  VCVTTPS2IBSZ256rmbk,
  VCVTTPS2IBSZ256rmbkz,
  VCVTTPS2IBSZ256rmk,
  VCVTTPS2IBSZ256rmkz,
  VCVTTPS2IBSZ256rr,
  VCVTTPS2IBSZ256rrk,
  VCVTTPS2IBSZ256rrkz,
  VCVTTPS2IBSZrm,
  VCVTTPS2IBSZrmb,
  VCVTTPS2IBSZrmbk,
  VCVTTPS2IBSZrmbkz,
  VCVTTPS2IBSZrmk,
  VCVTTPS2IBSZrmkz,
  VCVTTPS2IBSZrr,
  VCVTTPS2IBSZrrb,
  VCVTTPS2IBSZrrbk,
  VCVTTPS2IBSZrrbkz,
  VCVTTPS2IBSZrrk,
  VCVTTPS2IBSZrrkz,
  VCVTTPS2IUBSZ128rm,
  VCVTTPS2IUBSZ128rmb,
  VCVTTPS2IUBSZ128rmbk,
  VCVTTPS2IUBSZ128rmbkz,
  VCVTTPS2IUBSZ128rmk,
  VCVTTPS2IUBSZ128rmkz,
  VCVTTPS2IUBSZ128rr,
  VCVTTPS2IUBSZ128rrk,
  VCVTTPS2IUBSZ128rrkz,
  VCVTTPS2IUBSZ256rm,
  VCVTTPS2IUBSZ256rmb,
  VCVTTPS2IUBSZ256rmbk,
  VCVTTPS2IUBSZ256rmbkz,
  VCVTTPS2IUBSZ256rmk,
  VCVTTPS2IUBSZ256rmkz,
  VCVTTPS2IUBSZ256rr,
  VCVTTPS2IUBSZ256rrk,
  VCVTTPS2IUBSZ256rrkz,
  VCVTTPS2IUBSZrm,
  VCVTTPS2IUBSZrmb,
  VCVTTPS2IUBSZrmbk,
  VCVTTPS2IUBSZrmbkz,
  VCVTTPS2IUBSZrmk,
  VCVTTPS2IUBSZrmkz,
  VCVTTPS2IUBSZrr,
  VCVTTPS2IUBSZrrb,
  VCVTTPS2IUBSZrrbk,
  VCVTTPS2IUBSZrrbkz,
  VCVTTPS2IUBSZrrk,
  VCVTTPS2IUBSZrrkz,
  VCVTTPS2QQSZ128rm,
  VCVTTPS2QQSZ128rmb,
  VCVTTPS2QQSZ128rmbk,
  VCVTTPS2QQSZ128rmbkz,
  VCVTTPS2QQSZ128rmk,
  VCVTTPS2QQSZ128rmkz,
  VCVTTPS2QQSZ128rr,
  VCVTTPS2QQSZ128rrk,
  VCVTTPS2QQSZ128rrkz,
  VCVTTPS2QQSZ256rm,
  VCVTTPS2QQSZ256rmb,
  VCVTTPS2QQSZ256rmbk,
  VCVTTPS2QQSZ256rmbkz,
  VCVTTPS2QQSZ256rmk,
  VCVTTPS2QQSZ256rmkz,
  VCVTTPS2QQSZ256rr,
  VCVTTPS2QQSZ256rrb,
  VCVTTPS2QQSZ256rrbk,
  VCVTTPS2QQSZ256rrbkz,
  VCVTTPS2QQSZ256rrk,
  VCVTTPS2QQSZ256rrkz,
  VCVTTPS2QQSZrm,
  VCVTTPS2QQSZrmb,
  VCVTTPS2QQSZrmbk,
  VCVTTPS2QQSZrmbkz,
  VCVTTPS2QQSZrmk,
  VCVTTPS2QQSZrmkz,
  VCVTTPS2QQSZrr,
  VCVTTPS2QQSZrrb,
  VCVTTPS2QQSZrrbk,
  VCVTTPS2QQSZrrbkz,
  VCVTTPS2QQSZrrk,
  VCVTTPS2QQSZrrkz,
  VCVTTPS2QQZ128rm,
  VCVTTPS2QQZ128rmb,
  VCVTTPS2QQZ128rmbk,
  VCVTTPS2QQZ128rmbkz,
  VCVTTPS2QQZ128rmk,
  VCVTTPS2QQZ128rmkz,
  VCVTTPS2QQZ128rr,
  VCVTTPS2QQZ128rrk,
  VCVTTPS2QQZ128rrkz,
  VCVTTPS2QQZ256rm,
  VCVTTPS2QQZ256rmb,
  VCVTTPS2QQZ256rmbk,
  VCVTTPS2QQZ256rmbkz,
  VCVTTPS2QQZ256rmk,
  VCVTTPS2QQZ256rmkz,
  VCVTTPS2QQZ256rr,
  VCVTTPS2QQZ256rrk,
  VCVTTPS2QQZ256rrkz,
  VCVTTPS2QQZrm,
  VCVTTPS2QQZrmb,
  VCVTTPS2QQZrmbk,
  VCVTTPS2QQZrmbkz,
  VCVTTPS2QQZrmk,
  VCVTTPS2QQZrmkz,
  VCVTTPS2QQZrr,
  VCVTTPS2QQZrrb,
  VCVTTPS2QQZrrbk,
  VCVTTPS2QQZrrbkz,
  VCVTTPS2QQZrrk,
  VCVTTPS2QQZrrkz,
  VCVTTPS2UDQSZ128rm,
  VCVTTPS2UDQSZ128rmb,
  VCVTTPS2UDQSZ128rmbk,
  VCVTTPS2UDQSZ128rmbkz,
  VCVTTPS2UDQSZ128rmk,
  VCVTTPS2UDQSZ128rmkz,
  VCVTTPS2UDQSZ128rr,
  VCVTTPS2UDQSZ128rrk,
  VCVTTPS2UDQSZ128rrkz,
  VCVTTPS2UDQSZ256rm,
  VCVTTPS2UDQSZ256rmb,
  VCVTTPS2UDQSZ256rmbk,
  VCVTTPS2UDQSZ256rmbkz,
  VCVTTPS2UDQSZ256rmk,
  VCVTTPS2UDQSZ256rmkz,
  VCVTTPS2UDQSZ256rr,
  VCVTTPS2UDQSZ256rrk,
  VCVTTPS2UDQSZ256rrkz,
  VCVTTPS2UDQSZrm,
  VCVTTPS2UDQSZrmb,
  VCVTTPS2UDQSZrmbk,
  VCVTTPS2UDQSZrmbkz,
  VCVTTPS2UDQSZrmk,
  VCVTTPS2UDQSZrmkz,
  VCVTTPS2UDQSZrr,
  VCVTTPS2UDQSZrrb,
  VCVTTPS2UDQSZrrbk,
  VCVTTPS2UDQSZrrbkz,
  VCVTTPS2UDQSZrrk,
  VCVTTPS2UDQSZrrkz,
  VCVTTPS2UDQZ128rm,
  VCVTTPS2UDQZ128rmb,
  VCVTTPS2UDQZ128rmbk,
  VCVTTPS2UDQZ128rmbkz,
  VCVTTPS2UDQZ128rmk,
  VCVTTPS2UDQZ128rmkz,
  VCVTTPS2UDQZ128rr,
  VCVTTPS2UDQZ128rrk,
  VCVTTPS2UDQZ128rrkz,
  VCVTTPS2UDQZ256rm,
  VCVTTPS2UDQZ256rmb,
  VCVTTPS2UDQZ256rmbk,
  VCVTTPS2UDQZ256rmbkz,
  VCVTTPS2UDQZ256rmk,
  VCVTTPS2UDQZ256rmkz,
  VCVTTPS2UDQZ256rr,
  VCVTTPS2UDQZ256rrk,
  VCVTTPS2UDQZ256rrkz,
  VCVTTPS2UDQZrm,
  VCVTTPS2UDQZrmb,
  VCVTTPS2UDQZrmbk,
  VCVTTPS2UDQZrmbkz,
  VCVTTPS2UDQZrmk,
  VCVTTPS2UDQZrmkz,
  VCVTTPS2UDQZrr,
  VCVTTPS2UDQZrrb,
  VCVTTPS2UDQZrrbk,
  VCVTTPS2UDQZrrbkz,
  VCVTTPS2UDQZrrk,
  VCVTTPS2UDQZrrkz,
  VCVTTPS2UQQSZ128rm,
  VCVTTPS2UQQSZ128rmb,
  VCVTTPS2UQQSZ128rmbk,
  VCVTTPS2UQQSZ128rmbkz,
  VCVTTPS2UQQSZ128rmk,
  VCVTTPS2UQQSZ128rmkz,
  VCVTTPS2UQQSZ128rr,
  VCVTTPS2UQQSZ128rrk,
  VCVTTPS2UQQSZ128rrkz,
  VCVTTPS2UQQSZ256rm,
  VCVTTPS2UQQSZ256rmb,
  VCVTTPS2UQQSZ256rmbk,
  VCVTTPS2UQQSZ256rmbkz,
  VCVTTPS2UQQSZ256rmk,
  VCVTTPS2UQQSZ256rmkz,
  VCVTTPS2UQQSZ256rr,
  VCVTTPS2UQQSZ256rrb,
  VCVTTPS2UQQSZ256rrbk,
  VCVTTPS2UQQSZ256rrbkz,
  VCVTTPS2UQQSZ256rrk,
  VCVTTPS2UQQSZ256rrkz,
  VCVTTPS2UQQSZrm,
  VCVTTPS2UQQSZrmb,
  VCVTTPS2UQQSZrmbk,
  VCVTTPS2UQQSZrmbkz,
  VCVTTPS2UQQSZrmk,
  VCVTTPS2UQQSZrmkz,
  VCVTTPS2UQQSZrr,
  VCVTTPS2UQQSZrrb,
  VCVTTPS2UQQSZrrbk,
  VCVTTPS2UQQSZrrbkz,
  VCVTTPS2UQQSZrrk,
  VCVTTPS2UQQSZrrkz,
  VCVTTPS2UQQZ128rm,
  VCVTTPS2UQQZ128rmb,
  VCVTTPS2UQQZ128rmbk,
  VCVTTPS2UQQZ128rmbkz,
  VCVTTPS2UQQZ128rmk,
  VCVTTPS2UQQZ128rmkz,
  VCVTTPS2UQQZ128rr,
  VCVTTPS2UQQZ128rrk,
  VCVTTPS2UQQZ128rrkz,
  VCVTTPS2UQQZ256rm,
  VCVTTPS2UQQZ256rmb,
  VCVTTPS2UQQZ256rmbk,
  VCVTTPS2UQQZ256rmbkz,
  VCVTTPS2UQQZ256rmk,
  VCVTTPS2UQQZ256rmkz,
  VCVTTPS2UQQZ256rr,
  VCVTTPS2UQQZ256rrk,
  VCVTTPS2UQQZ256rrkz,
  VCVTTPS2UQQZrm,
  VCVTTPS2UQQZrmb,
  VCVTTPS2UQQZrmbk,
  VCVTTPS2UQQZrmbkz,
  VCVTTPS2UQQZrmk,
  VCVTTPS2UQQZrmkz,
  VCVTTPS2UQQZrr,
  VCVTTPS2UQQZrrb,
  VCVTTPS2UQQZrrbk,
  VCVTTPS2UQQZrrbkz,
  VCVTTPS2UQQZrrk,
  VCVTTPS2UQQZrrkz,
  VCVTTSD2SI64Srm,
  VCVTTSD2SI64Srm_Int,
  VCVTTSD2SI64Srr,
  VCVTTSD2SI64Srr_Int,
  VCVTTSD2SI64Srrb_Int,
  VCVTTSD2SI64Zrm,
  VCVTTSD2SI64Zrm_Int,
  VCVTTSD2SI64Zrr,
  VCVTTSD2SI64Zrr_Int,
  VCVTTSD2SI64Zrrb_Int,
  VCVTTSD2SI64rm,
  VCVTTSD2SI64rm_Int,
  VCVTTSD2SI64rr,
  VCVTTSD2SI64rr_Int,
  VCVTTSD2SISrm,
  VCVTTSD2SISrm_Int,
  VCVTTSD2SISrr,
  VCVTTSD2SISrr_Int,
  VCVTTSD2SISrrb_Int,
  VCVTTSD2SIZrm,
  VCVTTSD2SIZrm_Int,
  VCVTTSD2SIZrr,
  VCVTTSD2SIZrr_Int,
  VCVTTSD2SIZrrb_Int,
  VCVTTSD2SIrm,
  VCVTTSD2SIrm_Int,
  VCVTTSD2SIrr,
  VCVTTSD2SIrr_Int,
  VCVTTSD2USI64Srm,
  VCVTTSD2USI64Srm_Int,
  VCVTTSD2USI64Srr,
  VCVTTSD2USI64Srr_Int,
  VCVTTSD2USI64Srrb_Int,
  VCVTTSD2USI64Zrm,
  VCVTTSD2USI64Zrm_Int,
  VCVTTSD2USI64Zrr,
  VCVTTSD2USI64Zrr_Int,
  VCVTTSD2USI64Zrrb_Int,
  VCVTTSD2USISrm,
  VCVTTSD2USISrm_Int,
  VCVTTSD2USISrr,
  VCVTTSD2USISrr_Int,
  VCVTTSD2USISrrb_Int,
  VCVTTSD2USIZrm,
  VCVTTSD2USIZrm_Int,
  VCVTTSD2USIZrr,
  VCVTTSD2USIZrr_Int,
  VCVTTSD2USIZrrb_Int,
  VCVTTSH2SI64Zrm,
  VCVTTSH2SI64Zrm_Int,
  VCVTTSH2SI64Zrr,
  VCVTTSH2SI64Zrr_Int,
  VCVTTSH2SI64Zrrb_Int,
  VCVTTSH2SIZrm,
  VCVTTSH2SIZrm_Int,
  VCVTTSH2SIZrr,
  VCVTTSH2SIZrr_Int,
  VCVTTSH2SIZrrb_Int,
  VCVTTSH2USI64Zrm,
  VCVTTSH2USI64Zrm_Int,
  VCVTTSH2USI64Zrr,
  VCVTTSH2USI64Zrr_Int,
  VCVTTSH2USI64Zrrb_Int,
  VCVTTSH2USIZrm,
  VCVTTSH2USIZrm_Int,
  VCVTTSH2USIZrr,
  VCVTTSH2USIZrr_Int,
  VCVTTSH2USIZrrb_Int,
  VCVTTSS2SI64Srm,
  VCVTTSS2SI64Srm_Int,
  VCVTTSS2SI64Srr,
  VCVTTSS2SI64Srr_Int,
  VCVTTSS2SI64Srrb_Int,
  VCVTTSS2SI64Zrm,
  VCVTTSS2SI64Zrm_Int,
  VCVTTSS2SI64Zrr,
  VCVTTSS2SI64Zrr_Int,
  VCVTTSS2SI64Zrrb_Int,
  VCVTTSS2SI64rm,
  VCVTTSS2SI64rm_Int,
  VCVTTSS2SI64rr,
  VCVTTSS2SI64rr_Int,
  VCVTTSS2SISrm,
  VCVTTSS2SISrm_Int,
  VCVTTSS2SISrr,
  VCVTTSS2SISrr_Int,
  VCVTTSS2SISrrb_Int,
  VCVTTSS2SIZrm,
  VCVTTSS2SIZrm_Int,
  VCVTTSS2SIZrr,
  VCVTTSS2SIZrr_Int,
  VCVTTSS2SIZrrb_Int,
  VCVTTSS2SIrm,
  VCVTTSS2SIrm_Int,
  VCVTTSS2SIrr,
  VCVTTSS2SIrr_Int,
  VCVTTSS2USI64Srm,
  VCVTTSS2USI64Srm_Int,
  VCVTTSS2USI64Srr,
  VCVTTSS2USI64Srr_Int,
  VCVTTSS2USI64Srrb_Int,
  VCVTTSS2USI64Zrm,
  VCVTTSS2USI64Zrm_Int,
  VCVTTSS2USI64Zrr,
  VCVTTSS2USI64Zrr_Int,
  VCVTTSS2USI64Zrrb_Int,
  VCVTTSS2USISrm,
  VCVTTSS2USISrm_Int,
  VCVTTSS2USISrr,
  VCVTTSS2USISrr_Int,
  VCVTTSS2USISrrb_Int,
  VCVTTSS2USIZrm,
  VCVTTSS2USIZrm_Int,
  VCVTTSS2USIZrr,
  VCVTTSS2USIZrr_Int,
  VCVTTSS2USIZrrb_Int,
  VCVTUDQ2PDZ128rm,
  VCVTUDQ2PDZ128rmb,
  VCVTUDQ2PDZ128rmbk,
  VCVTUDQ2PDZ128rmbkz,
  VCVTUDQ2PDZ128rmk,
  VCVTUDQ2PDZ128rmkz,
  VCVTUDQ2PDZ128rr,
  VCVTUDQ2PDZ128rrk,
  VCVTUDQ2PDZ128rrkz,
  VCVTUDQ2PDZ256rm,
  VCVTUDQ2PDZ256rmb,
  VCVTUDQ2PDZ256rmbk,
  VCVTUDQ2PDZ256rmbkz,
  VCVTUDQ2PDZ256rmk,
  VCVTUDQ2PDZ256rmkz,
  VCVTUDQ2PDZ256rr,
  VCVTUDQ2PDZ256rrk,
  VCVTUDQ2PDZ256rrkz,
  VCVTUDQ2PDZrm,
  VCVTUDQ2PDZrmb,
  VCVTUDQ2PDZrmbk,
  VCVTUDQ2PDZrmbkz,
  VCVTUDQ2PDZrmk,
  VCVTUDQ2PDZrmkz,
  VCVTUDQ2PDZrr,
  VCVTUDQ2PDZrrk,
  VCVTUDQ2PDZrrkz,
  VCVTUDQ2PHZ128rm,
  VCVTUDQ2PHZ128rmb,
  VCVTUDQ2PHZ128rmbk,
  VCVTUDQ2PHZ128rmbkz,
  VCVTUDQ2PHZ128rmk,
  VCVTUDQ2PHZ128rmkz,
  VCVTUDQ2PHZ128rr,
  VCVTUDQ2PHZ128rrk,
  VCVTUDQ2PHZ128rrkz,
  VCVTUDQ2PHZ256rm,
  VCVTUDQ2PHZ256rmb,
  VCVTUDQ2PHZ256rmbk,
  VCVTUDQ2PHZ256rmbkz,
  VCVTUDQ2PHZ256rmk,
  VCVTUDQ2PHZ256rmkz,
  VCVTUDQ2PHZ256rr,
  VCVTUDQ2PHZ256rrk,
  VCVTUDQ2PHZ256rrkz,
  VCVTUDQ2PHZrm,
  VCVTUDQ2PHZrmb,
  VCVTUDQ2PHZrmbk,
  VCVTUDQ2PHZrmbkz,
  VCVTUDQ2PHZrmk,
  VCVTUDQ2PHZrmkz,
  VCVTUDQ2PHZrr,
  VCVTUDQ2PHZrrb,
  VCVTUDQ2PHZrrbk,
  VCVTUDQ2PHZrrbkz,
  VCVTUDQ2PHZrrk,
  VCVTUDQ2PHZrrkz,
  VCVTUDQ2PSZ128rm,
  VCVTUDQ2PSZ128rmb,
  VCVTUDQ2PSZ128rmbk,
  VCVTUDQ2PSZ128rmbkz,
  VCVTUDQ2PSZ128rmk,
  VCVTUDQ2PSZ128rmkz,
  VCVTUDQ2PSZ128rr,
  VCVTUDQ2PSZ128rrk,
  VCVTUDQ2PSZ128rrkz,
  VCVTUDQ2PSZ256rm,
  VCVTUDQ2PSZ256rmb,
  VCVTUDQ2PSZ256rmbk,
  VCVTUDQ2PSZ256rmbkz,
  VCVTUDQ2PSZ256rmk,
  VCVTUDQ2PSZ256rmkz,
  VCVTUDQ2PSZ256rr,
  VCVTUDQ2PSZ256rrk,
  VCVTUDQ2PSZ256rrkz,
  VCVTUDQ2PSZrm,
  VCVTUDQ2PSZrmb,
  VCVTUDQ2PSZrmbk,
  VCVTUDQ2PSZrmbkz,
  VCVTUDQ2PSZrmk,
  VCVTUDQ2PSZrmkz,
  VCVTUDQ2PSZrr,
  VCVTUDQ2PSZrrb,
  VCVTUDQ2PSZrrbk,
  VCVTUDQ2PSZrrbkz,
  VCVTUDQ2PSZrrk,
  VCVTUDQ2PSZrrkz,
  VCVTUQQ2PDZ128rm,
  VCVTUQQ2PDZ128rmb,
  VCVTUQQ2PDZ128rmbk,
  VCVTUQQ2PDZ128rmbkz,
  VCVTUQQ2PDZ128rmk,
  VCVTUQQ2PDZ128rmkz,
  VCVTUQQ2PDZ128rr,
  VCVTUQQ2PDZ128rrk,
  VCVTUQQ2PDZ128rrkz,
  VCVTUQQ2PDZ256rm,
  VCVTUQQ2PDZ256rmb,
  VCVTUQQ2PDZ256rmbk,
  VCVTUQQ2PDZ256rmbkz,
  VCVTUQQ2PDZ256rmk,
  VCVTUQQ2PDZ256rmkz,
  VCVTUQQ2PDZ256rr,
  VCVTUQQ2PDZ256rrk,
  VCVTUQQ2PDZ256rrkz,
  VCVTUQQ2PDZrm,
  VCVTUQQ2PDZrmb,
  VCVTUQQ2PDZrmbk,
  VCVTUQQ2PDZrmbkz,
  VCVTUQQ2PDZrmk,
  VCVTUQQ2PDZrmkz,
  VCVTUQQ2PDZrr,
  VCVTUQQ2PDZrrb,
  VCVTUQQ2PDZrrbk,
  VCVTUQQ2PDZrrbkz,
  VCVTUQQ2PDZrrk,
  VCVTUQQ2PDZrrkz,
  VCVTUQQ2PHZ128rm,
  VCVTUQQ2PHZ128rmb,
  VCVTUQQ2PHZ128rmbk,
  VCVTUQQ2PHZ128rmbkz,
  VCVTUQQ2PHZ128rmk,
  VCVTUQQ2PHZ128rmkz,
  VCVTUQQ2PHZ128rr,
  VCVTUQQ2PHZ128rrk,
  VCVTUQQ2PHZ128rrkz,
  VCVTUQQ2PHZ256rm,
  VCVTUQQ2PHZ256rmb,
  VCVTUQQ2PHZ256rmbk,
  VCVTUQQ2PHZ256rmbkz,
  VCVTUQQ2PHZ256rmk,
  VCVTUQQ2PHZ256rmkz,
  VCVTUQQ2PHZ256rr,
  VCVTUQQ2PHZ256rrk,
  VCVTUQQ2PHZ256rrkz,
  VCVTUQQ2PHZrm,
  VCVTUQQ2PHZrmb,
  VCVTUQQ2PHZrmbk,
  VCVTUQQ2PHZrmbkz,
  VCVTUQQ2PHZrmk,
  VCVTUQQ2PHZrmkz,
  VCVTUQQ2PHZrr,
  VCVTUQQ2PHZrrb,
  VCVTUQQ2PHZrrbk,
  VCVTUQQ2PHZrrbkz,
  VCVTUQQ2PHZrrk,
  VCVTUQQ2PHZrrkz,
  VCVTUQQ2PSZ128rm,
  VCVTUQQ2PSZ128rmb,
  VCVTUQQ2PSZ128rmbk,
  VCVTUQQ2PSZ128rmbkz,
  VCVTUQQ2PSZ128rmk,
  VCVTUQQ2PSZ128rmkz,
  VCVTUQQ2PSZ128rr,
  VCVTUQQ2PSZ128rrk,
  VCVTUQQ2PSZ128rrkz,
  VCVTUQQ2PSZ256rm,
  VCVTUQQ2PSZ256rmb,
  VCVTUQQ2PSZ256rmbk,
  VCVTUQQ2PSZ256rmbkz,
  VCVTUQQ2PSZ256rmk,
  VCVTUQQ2PSZ256rmkz,
  VCVTUQQ2PSZ256rr,
  VCVTUQQ2PSZ256rrk,
  VCVTUQQ2PSZ256rrkz,
  VCVTUQQ2PSZrm,
  VCVTUQQ2PSZrmb,
  VCVTUQQ2PSZrmbk,
  VCVTUQQ2PSZrmbkz,
  VCVTUQQ2PSZrmk,
  VCVTUQQ2PSZrmkz,
  VCVTUQQ2PSZrr,
  VCVTUQQ2PSZrrb,
  VCVTUQQ2PSZrrbk,
  VCVTUQQ2PSZrrbkz,
  VCVTUQQ2PSZrrk,
  VCVTUQQ2PSZrrkz,
  VCVTUSI2SDZrm,
  VCVTUSI2SDZrm_Int,
  VCVTUSI2SDZrr,
  VCVTUSI2SDZrr_Int,
  VCVTUSI2SHZrm,
  VCVTUSI2SHZrm_Int,
  VCVTUSI2SHZrr,
  VCVTUSI2SHZrr_Int,
  VCVTUSI2SHZrrb_Int,
  VCVTUSI2SSZrm,
  VCVTUSI2SSZrm_Int,
  VCVTUSI2SSZrr,
  VCVTUSI2SSZrr_Int,
  VCVTUSI2SSZrrb_Int,
  VCVTUSI642SDZrm,
  VCVTUSI642SDZrm_Int,
  VCVTUSI642SDZrr,
  VCVTUSI642SDZrr_Int,
  VCVTUSI642SDZrrb_Int,
  VCVTUSI642SHZrm,
  VCVTUSI642SHZrm_Int,
  VCVTUSI642SHZrr,
  VCVTUSI642SHZrr_Int,
  VCVTUSI642SHZrrb_Int,
  VCVTUSI642SSZrm,
  VCVTUSI642SSZrm_Int,
  VCVTUSI642SSZrr,
  VCVTUSI642SSZrr_Int,
  VCVTUSI642SSZrrb_Int,
  VCVTUW2PHZ128rm,
  VCVTUW2PHZ128rmb,
  VCVTUW2PHZ128rmbk,
  VCVTUW2PHZ128rmbkz,
  VCVTUW2PHZ128rmk,
  VCVTUW2PHZ128rmkz,
  VCVTUW2PHZ128rr,
  VCVTUW2PHZ128rrk,
  VCVTUW2PHZ128rrkz,
  VCVTUW2PHZ256rm,
  VCVTUW2PHZ256rmb,
  VCVTUW2PHZ256rmbk,
  VCVTUW2PHZ256rmbkz,
  VCVTUW2PHZ256rmk,
  VCVTUW2PHZ256rmkz,
  VCVTUW2PHZ256rr,
  VCVTUW2PHZ256rrk,
  VCVTUW2PHZ256rrkz,
  VCVTUW2PHZrm,
  VCVTUW2PHZrmb,
  VCVTUW2PHZrmbk,
  VCVTUW2PHZrmbkz,
  VCVTUW2PHZrmk,
  VCVTUW2PHZrmkz,
  VCVTUW2PHZrr,
  VCVTUW2PHZrrb,
  VCVTUW2PHZrrbk,
  VCVTUW2PHZrrbkz,
  VCVTUW2PHZrrk,
  VCVTUW2PHZrrkz,
  VCVTW2PHZ128rm,
  VCVTW2PHZ128rmb,
  VCVTW2PHZ128rmbk,
  VCVTW2PHZ128rmbkz,
  VCVTW2PHZ128rmk,
  VCVTW2PHZ128rmkz,
  VCVTW2PHZ128rr,
  VCVTW2PHZ128rrk,
  VCVTW2PHZ128rrkz,
  VCVTW2PHZ256rm,
  VCVTW2PHZ256rmb,
  VCVTW2PHZ256rmbk,
  VCVTW2PHZ256rmbkz,
  VCVTW2PHZ256rmk,
  VCVTW2PHZ256rmkz,
  VCVTW2PHZ256rr,
  VCVTW2PHZ256rrk,
  VCVTW2PHZ256rrkz,
  VCVTW2PHZrm,
  VCVTW2PHZrmb,
  VCVTW2PHZrmbk,
  VCVTW2PHZrmbkz,
  VCVTW2PHZrmk,
  VCVTW2PHZrmkz,
  VCVTW2PHZrr,
  VCVTW2PHZrrb,
  VCVTW2PHZrrbk,
  VCVTW2PHZrrbkz,
  VCVTW2PHZrrk,
  VCVTW2PHZrrkz,
  VDBPSADBWZ128rmi,
  VDBPSADBWZ128rmik,
  VDBPSADBWZ128rmikz,
  VDBPSADBWZ128rri,
  VDBPSADBWZ128rrik,
  VDBPSADBWZ128rrikz,
  VDBPSADBWZ256rmi,
  VDBPSADBWZ256rmik,
  VDBPSADBWZ256rmikz,
  VDBPSADBWZ256rri,
  VDBPSADBWZ256rrik,
  VDBPSADBWZ256rrikz,
  VDBPSADBWZrmi,
  VDBPSADBWZrmik,
  VDBPSADBWZrmikz,
  VDBPSADBWZrri,
  VDBPSADBWZrrik,
  VDBPSADBWZrrikz,
  VDIVBF16Z128rm,
  VDIVBF16Z128rmb,
  VDIVBF16Z128rmbk,
  VDIVBF16Z128rmbkz,
  VDIVBF16Z128rmk,
  VDIVBF16Z128rmkz,
  VDIVBF16Z128rr,
  VDIVBF16Z128rrk,
  VDIVBF16Z128rrkz,
  VDIVBF16Z256rm,
  VDIVBF16Z256rmb,
  VDIVBF16Z256rmbk,
  VDIVBF16Z256rmbkz,
  VDIVBF16Z256rmk,
  VDIVBF16Z256rmkz,
  VDIVBF16Z256rr,
  VDIVBF16Z256rrk,
  VDIVBF16Z256rrkz,
  VDIVBF16Zrm,
  VDIVBF16Zrmb,
  VDIVBF16Zrmbk,
  VDIVBF16Zrmbkz,
  VDIVBF16Zrmk,
  VDIVBF16Zrmkz,
  VDIVBF16Zrr,
  VDIVBF16Zrrk,
  VDIVBF16Zrrkz,
  VDIVPDYrm,
  VDIVPDYrr,
  VDIVPDZ128rm,
  VDIVPDZ128rmb,
  VDIVPDZ128rmbk,
  VDIVPDZ128rmbkz,
  VDIVPDZ128rmk,
  VDIVPDZ128rmkz,
  VDIVPDZ128rr,
  VDIVPDZ128rrk,
  VDIVPDZ128rrkz,
  VDIVPDZ256rm,
  VDIVPDZ256rmb,
  VDIVPDZ256rmbk,
  VDIVPDZ256rmbkz,
  VDIVPDZ256rmk,
  VDIVPDZ256rmkz,
  VDIVPDZ256rr,
  VDIVPDZ256rrk,
  VDIVPDZ256rrkz,
  VDIVPDZrm,
  VDIVPDZrmb,
  VDIVPDZrmbk,
  VDIVPDZrmbkz,
  VDIVPDZrmk,
  VDIVPDZrmkz,
  VDIVPDZrr,
  VDIVPDZrrb,
  VDIVPDZrrbk,
  VDIVPDZrrbkz,
  VDIVPDZrrk,
  VDIVPDZrrkz,
  VDIVPDrm,
  VDIVPDrr,
  VDIVPHZ128rm,
  VDIVPHZ128rmb,
  VDIVPHZ128rmbk,
  VDIVPHZ128rmbkz,
  VDIVPHZ128rmk,
  VDIVPHZ128rmkz,
  VDIVPHZ128rr,
  VDIVPHZ128rrk,
  VDIVPHZ128rrkz,
  VDIVPHZ256rm,
  VDIVPHZ256rmb,
  VDIVPHZ256rmbk,
  VDIVPHZ256rmbkz,
  VDIVPHZ256rmk,
  VDIVPHZ256rmkz,
  VDIVPHZ256rr,
  VDIVPHZ256rrk,
  VDIVPHZ256rrkz,
  VDIVPHZrm,
  VDIVPHZrmb,
  VDIVPHZrmbk,
  VDIVPHZrmbkz,
  VDIVPHZrmk,
  VDIVPHZrmkz,
  VDIVPHZrr,
  VDIVPHZrrb,
  VDIVPHZrrbk,
  VDIVPHZrrbkz,
  VDIVPHZrrk,
  VDIVPHZrrkz,
  VDIVPSYrm,
  VDIVPSYrr,
  VDIVPSZ128rm,
  VDIVPSZ128rmb,
  VDIVPSZ128rmbk,
  VDIVPSZ128rmbkz,
  VDIVPSZ128rmk,
  VDIVPSZ128rmkz,
  VDIVPSZ128rr,
  VDIVPSZ128rrk,
  VDIVPSZ128rrkz,
  VDIVPSZ256rm,
  VDIVPSZ256rmb,
  VDIVPSZ256rmbk,
  VDIVPSZ256rmbkz,
  VDIVPSZ256rmk,
  VDIVPSZ256rmkz,
  VDIVPSZ256rr,
  VDIVPSZ256rrk,
  VDIVPSZ256rrkz,
  VDIVPSZrm,
  VDIVPSZrmb,
  VDIVPSZrmbk,
  VDIVPSZrmbkz,
  VDIVPSZrmk,
  VDIVPSZrmkz,
  VDIVPSZrr,
  VDIVPSZrrb,
  VDIVPSZrrbk,
  VDIVPSZrrbkz,
  VDIVPSZrrk,
  VDIVPSZrrkz,
  VDIVPSrm,
  VDIVPSrr,
  VDIVSDZrm,
  VDIVSDZrm_Int,
  VDIVSDZrmk_Int,
  VDIVSDZrmkz_Int,
  VDIVSDZrr,
  VDIVSDZrr_Int,
  VDIVSDZrrb_Int,
  VDIVSDZrrbk_Int,
  VDIVSDZrrbkz_Int,
  VDIVSDZrrk_Int,
  VDIVSDZrrkz_Int,
  VDIVSDrm,
  VDIVSDrm_Int,
  VDIVSDrr,
  VDIVSDrr_Int,
  VDIVSHZrm,
  VDIVSHZrm_Int,
  VDIVSHZrmk_Int,
  VDIVSHZrmkz_Int,
  VDIVSHZrr,
  VDIVSHZrr_Int,
  VDIVSHZrrb_Int,
  VDIVSHZrrbk_Int,
  VDIVSHZrrbkz_Int,
  VDIVSHZrrk_Int,
  VDIVSHZrrkz_Int,
  VDIVSSZrm,
  VDIVSSZrm_Int,
  VDIVSSZrmk_Int,
  VDIVSSZrmkz_Int,
  VDIVSSZrr,
  VDIVSSZrr_Int,
  VDIVSSZrrb_Int,
  VDIVSSZrrbk_Int,
  VDIVSSZrrbkz_Int,
  VDIVSSZrrk_Int,
  VDIVSSZrrkz_Int,
  VDIVSSrm,
  VDIVSSrm_Int,
  VDIVSSrr,
  VDIVSSrr_Int,
  VDPBF16PSZ128m,
  VDPBF16PSZ128mb,
  VDPBF16PSZ128mbk,
  VDPBF16PSZ128mbkz,
  VDPBF16PSZ128mk,
  VDPBF16PSZ128mkz,
  VDPBF16PSZ128r,
  VDPBF16PSZ128rk,
  VDPBF16PSZ128rkz,
  VDPBF16PSZ256m,
  VDPBF16PSZ256mb,
  VDPBF16PSZ256mbk,
  VDPBF16PSZ256mbkz,
  VDPBF16PSZ256mk,
  VDPBF16PSZ256mkz,
  VDPBF16PSZ256r,
  VDPBF16PSZ256rk,
  VDPBF16PSZ256rkz,
  VDPBF16PSZm,
  VDPBF16PSZmb,
  VDPBF16PSZmbk,
  VDPBF16PSZmbkz,
  VDPBF16PSZmk,
  VDPBF16PSZmkz,
  VDPBF16PSZr,
  VDPBF16PSZrk,
  VDPBF16PSZrkz,
  VDPPDrmi,
  VDPPDrri,
  VDPPHPSZ128m,
  VDPPHPSZ128mb,
  VDPPHPSZ128mbk,
  VDPPHPSZ128mbkz,
  VDPPHPSZ128mk,
  VDPPHPSZ128mkz,
  VDPPHPSZ128r,
  VDPPHPSZ128rk,
  VDPPHPSZ128rkz,
  VDPPHPSZ256m,
  VDPPHPSZ256mb,
  VDPPHPSZ256mbk,
  VDPPHPSZ256mbkz,
  VDPPHPSZ256mk,
  VDPPHPSZ256mkz,
  VDPPHPSZ256r,
  VDPPHPSZ256rk,
  VDPPHPSZ256rkz,
  VDPPHPSZm,
  VDPPHPSZmb,
  VDPPHPSZmbk,
  VDPPHPSZmbkz,
  VDPPHPSZmk,
  VDPPHPSZmkz,
  VDPPHPSZr,
  VDPPHPSZrk,
  VDPPHPSZrkz,
  VDPPSYrmi,
  VDPPSYrri,
  VDPPSrmi,
  VDPPSrri,
  VERRm,
  VERRr,
  VERWm,
  VERWr,
  VEXP2PDZm,
  VEXP2PDZmb,
  VEXP2PDZmbk,
  VEXP2PDZmbkz,
  VEXP2PDZmk,
  VEXP2PDZmkz,
  VEXP2PDZr,
  VEXP2PDZrb,
  VEXP2PDZrbk,
  VEXP2PDZrbkz,
  VEXP2PDZrk,
  VEXP2PDZrkz,
  VEXP2PSZm,
  VEXP2PSZmb,
  VEXP2PSZmbk,
  VEXP2PSZmbkz,
  VEXP2PSZmk,
  VEXP2PSZmkz,
  VEXP2PSZr,
  VEXP2PSZrb,
  VEXP2PSZrbk,
  VEXP2PSZrbkz,
  VEXP2PSZrk,
  VEXP2PSZrkz,
  VEXPANDPDZ128rm,
  VEXPANDPDZ128rmk,
  VEXPANDPDZ128rmkz,
  VEXPANDPDZ128rr,
  VEXPANDPDZ128rrk,
  VEXPANDPDZ128rrkz,
  VEXPANDPDZ256rm,
  VEXPANDPDZ256rmk,
  VEXPANDPDZ256rmkz,
  VEXPANDPDZ256rr,
  VEXPANDPDZ256rrk,
  VEXPANDPDZ256rrkz,
  VEXPANDPDZrm,
  VEXPANDPDZrmk,
  VEXPANDPDZrmkz,
  VEXPANDPDZrr,
  VEXPANDPDZrrk,
  VEXPANDPDZrrkz,
  VEXPANDPSZ128rm,
  VEXPANDPSZ128rmk,
  VEXPANDPSZ128rmkz,
  VEXPANDPSZ128rr,
  VEXPANDPSZ128rrk,
  VEXPANDPSZ128rrkz,
  VEXPANDPSZ256rm,
  VEXPANDPSZ256rmk,
  VEXPANDPSZ256rmkz,
  VEXPANDPSZ256rr,
  VEXPANDPSZ256rrk,
  VEXPANDPSZ256rrkz,
  VEXPANDPSZrm,
  VEXPANDPSZrmk,
  VEXPANDPSZrmkz,
  VEXPANDPSZrr,
  VEXPANDPSZrrk,
  VEXPANDPSZrrkz,
  VEXTRACTF128mri,
  VEXTRACTF128rri,
  VEXTRACTF32X4Z256mri,
  VEXTRACTF32X4Z256mrik,
  VEXTRACTF32X4Z256rri,
  VEXTRACTF32X4Z256rrik,
  VEXTRACTF32X4Z256rrikz,
  VEXTRACTF32X4Zmri,
  VEXTRACTF32X4Zmrik,
  VEXTRACTF32X4Zrri,
  VEXTRACTF32X4Zrrik,
  VEXTRACTF32X4Zrrikz,
  VEXTRACTF32X8Zmri,
  VEXTRACTF32X8Zmrik,
  VEXTRACTF32X8Zrri,
  VEXTRACTF32X8Zrrik,
  VEXTRACTF32X8Zrrikz,
  VEXTRACTF64X2Z256mri,
  VEXTRACTF64X2Z256mrik,
  VEXTRACTF64X2Z256rri,
  VEXTRACTF64X2Z256rrik,
  VEXTRACTF64X2Z256rrikz,
  VEXTRACTF64X2Zmri,
  VEXTRACTF64X2Zmrik,
  VEXTRACTF64X2Zrri,
  VEXTRACTF64X2Zrrik,
  VEXTRACTF64X2Zrrikz,
  VEXTRACTF64X4Zmri,
  VEXTRACTF64X4Zmrik,
  VEXTRACTF64X4Zrri,
  VEXTRACTF64X4Zrrik,
  VEXTRACTF64X4Zrrikz,
  VEXTRACTI128mri,
  VEXTRACTI128rri,
  VEXTRACTI32X4Z256mri,
  VEXTRACTI32X4Z256mrik,
  VEXTRACTI32X4Z256rri,
  VEXTRACTI32X4Z256rrik,
  VEXTRACTI32X4Z256rrikz,
  VEXTRACTI32X4Zmri,
  VEXTRACTI32X4Zmrik,
  VEXTRACTI32X4Zrri,
  VEXTRACTI32X4Zrrik,
  VEXTRACTI32X4Zrrikz,
  VEXTRACTI32X8Zmri,
  VEXTRACTI32X8Zmrik,
  VEXTRACTI32X8Zrri,
  VEXTRACTI32X8Zrrik,
  VEXTRACTI32X8Zrrikz,
  VEXTRACTI64X2Z256mri,
  VEXTRACTI64X2Z256mrik,
  VEXTRACTI64X2Z256rri,
  VEXTRACTI64X2Z256rrik,
  VEXTRACTI64X2Z256rrikz,
  VEXTRACTI64X2Zmri,
  VEXTRACTI64X2Zmrik,
  VEXTRACTI64X2Zrri,
  VEXTRACTI64X2Zrrik,
  VEXTRACTI64X2Zrrikz,
  VEXTRACTI64X4Zmri,
  VEXTRACTI64X4Zmrik,
  VEXTRACTI64X4Zrri,
  VEXTRACTI64X4Zrrik,
  VEXTRACTI64X4Zrrikz,
  VEXTRACTPSZmri,
  VEXTRACTPSZrri,
  VEXTRACTPSmri,
  VEXTRACTPSrri,
  VFCMADDCPHZ128m,
  VFCMADDCPHZ128mb,
  VFCMADDCPHZ128mbk,
  VFCMADDCPHZ128mbkz,
  VFCMADDCPHZ128mk,
  VFCMADDCPHZ128mkz,
  VFCMADDCPHZ128r,
  VFCMADDCPHZ128rk,
  VFCMADDCPHZ128rkz,
  VFCMADDCPHZ256m,
  VFCMADDCPHZ256mb,
  VFCMADDCPHZ256mbk,
  VFCMADDCPHZ256mbkz,
  VFCMADDCPHZ256mk,
  VFCMADDCPHZ256mkz,
  VFCMADDCPHZ256r,
  VFCMADDCPHZ256rk,
  VFCMADDCPHZ256rkz,
  VFCMADDCPHZm,
  VFCMADDCPHZmb,
  VFCMADDCPHZmbk,
  VFCMADDCPHZmbkz,
  VFCMADDCPHZmk,
  VFCMADDCPHZmkz,
  VFCMADDCPHZr,
  VFCMADDCPHZrb,
  VFCMADDCPHZrbk,
  VFCMADDCPHZrbkz,
  VFCMADDCPHZrk,
  VFCMADDCPHZrkz,
  VFCMADDCSHZm,
  VFCMADDCSHZmk,
  VFCMADDCSHZmkz,
  VFCMADDCSHZr,
  VFCMADDCSHZrb,
  VFCMADDCSHZrbk,
  VFCMADDCSHZrbkz,
  VFCMADDCSHZrk,
  VFCMADDCSHZrkz,
  VFCMULCPHZ128rm,
  VFCMULCPHZ128rmb,
  VFCMULCPHZ128rmbk,
  VFCMULCPHZ128rmbkz,
  VFCMULCPHZ128rmk,
  VFCMULCPHZ128rmkz,
  VFCMULCPHZ128rr,
  VFCMULCPHZ128rrk,
  VFCMULCPHZ128rrkz,
  VFCMULCPHZ256rm,
  VFCMULCPHZ256rmb,
  VFCMULCPHZ256rmbk,
  VFCMULCPHZ256rmbkz,
  VFCMULCPHZ256rmk,
  VFCMULCPHZ256rmkz,
  VFCMULCPHZ256rr,
  VFCMULCPHZ256rrk,
  VFCMULCPHZ256rrkz,
  VFCMULCPHZrm,
  VFCMULCPHZrmb,
  VFCMULCPHZrmbk,
  VFCMULCPHZrmbkz,
  VFCMULCPHZrmk,
  VFCMULCPHZrmkz,
  VFCMULCPHZrr,
  VFCMULCPHZrrb,
  VFCMULCPHZrrbk,
  VFCMULCPHZrrbkz,
  VFCMULCPHZrrk,
  VFCMULCPHZrrkz,
  VFCMULCSHZrm,
  VFCMULCSHZrmk,
  VFCMULCSHZrmkz,
  VFCMULCSHZrr,
  VFCMULCSHZrrb,
  VFCMULCSHZrrbk,
  VFCMULCSHZrrbkz,
  VFCMULCSHZrrk,
  VFCMULCSHZrrkz,
  VFIXUPIMMPDZ128rmbi,
  VFIXUPIMMPDZ128rmbik,
  VFIXUPIMMPDZ128rmbikz,
  VFIXUPIMMPDZ128rmi,
  VFIXUPIMMPDZ128rmik,
  VFIXUPIMMPDZ128rmikz,
  VFIXUPIMMPDZ128rri,
  VFIXUPIMMPDZ128rrik,
  VFIXUPIMMPDZ128rrikz,
  VFIXUPIMMPDZ256rmbi,
  VFIXUPIMMPDZ256rmbik,
  VFIXUPIMMPDZ256rmbikz,
  VFIXUPIMMPDZ256rmi,
  VFIXUPIMMPDZ256rmik,
  VFIXUPIMMPDZ256rmikz,
  VFIXUPIMMPDZ256rri,
  VFIXUPIMMPDZ256rrik,
  VFIXUPIMMPDZ256rrikz,
  VFIXUPIMMPDZrmbi,
  VFIXUPIMMPDZrmbik,
  VFIXUPIMMPDZrmbikz,
  VFIXUPIMMPDZrmi,
  VFIXUPIMMPDZrmik,
  VFIXUPIMMPDZrmikz,
  VFIXUPIMMPDZrri,
  VFIXUPIMMPDZrrib,
  VFIXUPIMMPDZrribk,
  VFIXUPIMMPDZrribkz,
  VFIXUPIMMPDZrrik,
  VFIXUPIMMPDZrrikz,
  VFIXUPIMMPSZ128rmbi,
  VFIXUPIMMPSZ128rmbik,
  VFIXUPIMMPSZ128rmbikz,
  VFIXUPIMMPSZ128rmi,
  VFIXUPIMMPSZ128rmik,
  VFIXUPIMMPSZ128rmikz,
  VFIXUPIMMPSZ128rri,
  VFIXUPIMMPSZ128rrik,
  VFIXUPIMMPSZ128rrikz,
  VFIXUPIMMPSZ256rmbi,
  VFIXUPIMMPSZ256rmbik,
  VFIXUPIMMPSZ256rmbikz,
  VFIXUPIMMPSZ256rmi,
  VFIXUPIMMPSZ256rmik,
  VFIXUPIMMPSZ256rmikz,
  VFIXUPIMMPSZ256rri,
  VFIXUPIMMPSZ256rrik,
  VFIXUPIMMPSZ256rrikz,
  VFIXUPIMMPSZrmbi,
  VFIXUPIMMPSZrmbik,
  VFIXUPIMMPSZrmbikz,
  VFIXUPIMMPSZrmi,
  VFIXUPIMMPSZrmik,
  VFIXUPIMMPSZrmikz,
  VFIXUPIMMPSZrri,
  VFIXUPIMMPSZrrib,
  VFIXUPIMMPSZrribk,
  VFIXUPIMMPSZrribkz,
  VFIXUPIMMPSZrrik,
  VFIXUPIMMPSZrrikz,
  VFIXUPIMMSDZrmi,
  VFIXUPIMMSDZrmik,
  VFIXUPIMMSDZrmikz,
  VFIXUPIMMSDZrri,
  VFIXUPIMMSDZrrib,
  VFIXUPIMMSDZrribk,
  VFIXUPIMMSDZrribkz,
  VFIXUPIMMSDZrrik,
  VFIXUPIMMSDZrrikz,
  VFIXUPIMMSSZrmi,
  VFIXUPIMMSSZrmik,
  VFIXUPIMMSSZrmikz,
  VFIXUPIMMSSZrri,
  VFIXUPIMMSSZrrib,
  VFIXUPIMMSSZrribk,
  VFIXUPIMMSSZrribkz,
  VFIXUPIMMSSZrrik,
  VFIXUPIMMSSZrrikz,
  VFMADD132BF16Z128m,
  VFMADD132BF16Z128mb,
  VFMADD132BF16Z128mbk,
  VFMADD132BF16Z128mbkz,
  VFMADD132BF16Z128mk,
  VFMADD132BF16Z128mkz,
  VFMADD132BF16Z128r,
  VFMADD132BF16Z128rk,
  VFMADD132BF16Z128rkz,
  VFMADD132BF16Z256m,
  VFMADD132BF16Z256mb,
  VFMADD132BF16Z256mbk,
  VFMADD132BF16Z256mbkz,
  VFMADD132BF16Z256mk,
  VFMADD132BF16Z256mkz,
  VFMADD132BF16Z256r,
  VFMADD132BF16Z256rk,
  VFMADD132BF16Z256rkz,
  VFMADD132BF16Zm,
  VFMADD132BF16Zmb,
  VFMADD132BF16Zmbk,
  VFMADD132BF16Zmbkz,
  VFMADD132BF16Zmk,
  VFMADD132BF16Zmkz,
  VFMADD132BF16Zr,
  VFMADD132BF16Zrk,
  VFMADD132BF16Zrkz,
  VFMADD132PDYm,
  VFMADD132PDYr,
  VFMADD132PDZ128m,
  VFMADD132PDZ128mb,
  VFMADD132PDZ128mbk,
  VFMADD132PDZ128mbkz,
  VFMADD132PDZ128mk,
  VFMADD132PDZ128mkz,
  VFMADD132PDZ128r,
  VFMADD132PDZ128rk,
  VFMADD132PDZ128rkz,
  VFMADD132PDZ256m,
  VFMADD132PDZ256mb,
  VFMADD132PDZ256mbk,
  VFMADD132PDZ256mbkz,
  VFMADD132PDZ256mk,
  VFMADD132PDZ256mkz,
  VFMADD132PDZ256r,
  VFMADD132PDZ256rk,
  VFMADD132PDZ256rkz,
  VFMADD132PDZm,
  VFMADD132PDZmb,
  VFMADD132PDZmbk,
  VFMADD132PDZmbkz,
  VFMADD132PDZmk,
  VFMADD132PDZmkz,
  VFMADD132PDZr,
  VFMADD132PDZrb,
  VFMADD132PDZrbk,
  VFMADD132PDZrbkz,
  VFMADD132PDZrk,
  VFMADD132PDZrkz,
  VFMADD132PDm,
  VFMADD132PDr,
  VFMADD132PHZ128m,
  VFMADD132PHZ128mb,
  VFMADD132PHZ128mbk,
  VFMADD132PHZ128mbkz,
  VFMADD132PHZ128mk,
  VFMADD132PHZ128mkz,
  VFMADD132PHZ128r,
  VFMADD132PHZ128rk,
  VFMADD132PHZ128rkz,
  VFMADD132PHZ256m,
  VFMADD132PHZ256mb,
  VFMADD132PHZ256mbk,
  VFMADD132PHZ256mbkz,
  VFMADD132PHZ256mk,
  VFMADD132PHZ256mkz,
  VFMADD132PHZ256r,
  VFMADD132PHZ256rk,
  VFMADD132PHZ256rkz,
  VFMADD132PHZm,
  VFMADD132PHZmb,
  VFMADD132PHZmbk,
  VFMADD132PHZmbkz,
  VFMADD132PHZmk,
  VFMADD132PHZmkz,
  VFMADD132PHZr,
  VFMADD132PHZrb,
  VFMADD132PHZrbk,
  VFMADD132PHZrbkz,
  VFMADD132PHZrk,
  VFMADD132PHZrkz,
  VFMADD132PSYm,
  VFMADD132PSYr,
  VFMADD132PSZ128m,
  VFMADD132PSZ128mb,
  VFMADD132PSZ128mbk,
  VFMADD132PSZ128mbkz,
  VFMADD132PSZ128mk,
  VFMADD132PSZ128mkz,
  VFMADD132PSZ128r,
  VFMADD132PSZ128rk,
  VFMADD132PSZ128rkz,
  VFMADD132PSZ256m,
  VFMADD132PSZ256mb,
  VFMADD132PSZ256mbk,
  VFMADD132PSZ256mbkz,
  VFMADD132PSZ256mk,
  VFMADD132PSZ256mkz,
  VFMADD132PSZ256r,
  VFMADD132PSZ256rk,
  VFMADD132PSZ256rkz,
  VFMADD132PSZm,
  VFMADD132PSZmb,
  VFMADD132PSZmbk,
  VFMADD132PSZmbkz,
  VFMADD132PSZmk,
  VFMADD132PSZmkz,
  VFMADD132PSZr,
  VFMADD132PSZrb,
  VFMADD132PSZrbk,
  VFMADD132PSZrbkz,
  VFMADD132PSZrk,
  VFMADD132PSZrkz,
  VFMADD132PSm,
  VFMADD132PSr,
  VFMADD132SDZm,
  VFMADD132SDZm_Int,
  VFMADD132SDZmk_Int,
  VFMADD132SDZmkz_Int,
  VFMADD132SDZr,
  VFMADD132SDZr_Int,
  VFMADD132SDZrb,
  VFMADD132SDZrb_Int,
  VFMADD132SDZrbk_Int,
  VFMADD132SDZrbkz_Int,
  VFMADD132SDZrk_Int,
  VFMADD132SDZrkz_Int,
  VFMADD132SDm,
  VFMADD132SDm_Int,
  VFMADD132SDr,
  VFMADD132SDr_Int,
  VFMADD132SHZm,
  VFMADD132SHZm_Int,
  VFMADD132SHZmk_Int,
  VFMADD132SHZmkz_Int,
  VFMADD132SHZr,
  VFMADD132SHZr_Int,
  VFMADD132SHZrb,
  VFMADD132SHZrb_Int,
  VFMADD132SHZrbk_Int,
  VFMADD132SHZrbkz_Int,
  VFMADD132SHZrk_Int,
  VFMADD132SHZrkz_Int,
  VFMADD132SSZm,
  VFMADD132SSZm_Int,
  VFMADD132SSZmk_Int,
  VFMADD132SSZmkz_Int,
  VFMADD132SSZr,
  VFMADD132SSZr_Int,
  VFMADD132SSZrb,
  VFMADD132SSZrb_Int,
  VFMADD132SSZrbk_Int,
  VFMADD132SSZrbkz_Int,
  VFMADD132SSZrk_Int,
  VFMADD132SSZrkz_Int,
  VFMADD132SSm,
  VFMADD132SSm_Int,
  VFMADD132SSr,
  VFMADD132SSr_Int,
  VFMADD213BF16Z128m,
  VFMADD213BF16Z128mb,
  VFMADD213BF16Z128mbk,
  VFMADD213BF16Z128mbkz,
  VFMADD213BF16Z128mk,
  VFMADD213BF16Z128mkz,
  VFMADD213BF16Z128r,
  VFMADD213BF16Z128rk,
  VFMADD213BF16Z128rkz,
  VFMADD213BF16Z256m,
  VFMADD213BF16Z256mb,
  VFMADD213BF16Z256mbk,
  VFMADD213BF16Z256mbkz,
  VFMADD213BF16Z256mk,
  VFMADD213BF16Z256mkz,
  VFMADD213BF16Z256r,
  VFMADD213BF16Z256rk,
  VFMADD213BF16Z256rkz,
  VFMADD213BF16Zm,
  VFMADD213BF16Zmb,
  VFMADD213BF16Zmbk,
  VFMADD213BF16Zmbkz,
  VFMADD213BF16Zmk,
  VFMADD213BF16Zmkz,
  VFMADD213BF16Zr,
  VFMADD213BF16Zrk,
  VFMADD213BF16Zrkz,
  VFMADD213PDYm,
  VFMADD213PDYr,
  VFMADD213PDZ128m,
  VFMADD213PDZ128mb,
  VFMADD213PDZ128mbk,
  VFMADD213PDZ128mbkz,
  VFMADD213PDZ128mk,
  VFMADD213PDZ128mkz,
  VFMADD213PDZ128r,
  VFMADD213PDZ128rk,
  VFMADD213PDZ128rkz,
  VFMADD213PDZ256m,
  VFMADD213PDZ256mb,
  VFMADD213PDZ256mbk,
  VFMADD213PDZ256mbkz,
  VFMADD213PDZ256mk,
  VFMADD213PDZ256mkz,
  VFMADD213PDZ256r,
  VFMADD213PDZ256rk,
  VFMADD213PDZ256rkz,
  VFMADD213PDZm,
  VFMADD213PDZmb,
  VFMADD213PDZmbk,
  VFMADD213PDZmbkz,
  VFMADD213PDZmk,
  VFMADD213PDZmkz,
  VFMADD213PDZr,
  VFMADD213PDZrb,
  VFMADD213PDZrbk,
  VFMADD213PDZrbkz,
  VFMADD213PDZrk,
  VFMADD213PDZrkz,
  VFMADD213PDm,
  VFMADD213PDr,
  VFMADD213PHZ128m,
  VFMADD213PHZ128mb,
  VFMADD213PHZ128mbk,
  VFMADD213PHZ128mbkz,
  VFMADD213PHZ128mk,
  VFMADD213PHZ128mkz,
  VFMADD213PHZ128r,
  VFMADD213PHZ128rk,
  VFMADD213PHZ128rkz,
  VFMADD213PHZ256m,
  VFMADD213PHZ256mb,
  VFMADD213PHZ256mbk,
  VFMADD213PHZ256mbkz,
  VFMADD213PHZ256mk,
  VFMADD213PHZ256mkz,
  VFMADD213PHZ256r,
  VFMADD213PHZ256rk,
  VFMADD213PHZ256rkz,
  VFMADD213PHZm,
  VFMADD213PHZmb,
  VFMADD213PHZmbk,
  VFMADD213PHZmbkz,
  VFMADD213PHZmk,
  VFMADD213PHZmkz,
  VFMADD213PHZr,
  VFMADD213PHZrb,
  VFMADD213PHZrbk,
  VFMADD213PHZrbkz,
  VFMADD213PHZrk,
  VFMADD213PHZrkz,
  VFMADD213PSYm,
  VFMADD213PSYr,
  VFMADD213PSZ128m,
  VFMADD213PSZ128mb,
  VFMADD213PSZ128mbk,
  VFMADD213PSZ128mbkz,
  VFMADD213PSZ128mk,
  VFMADD213PSZ128mkz,
  VFMADD213PSZ128r,
  VFMADD213PSZ128rk,
  VFMADD213PSZ128rkz,
  VFMADD213PSZ256m,
  VFMADD213PSZ256mb,
  VFMADD213PSZ256mbk,
  VFMADD213PSZ256mbkz,
  VFMADD213PSZ256mk,
  VFMADD213PSZ256mkz,
  VFMADD213PSZ256r,
  VFMADD213PSZ256rk,
  VFMADD213PSZ256rkz,
  VFMADD213PSZm,
  VFMADD213PSZmb,
  VFMADD213PSZmbk,
  VFMADD213PSZmbkz,
  VFMADD213PSZmk,
  VFMADD213PSZmkz,
  VFMADD213PSZr,
  VFMADD213PSZrb,
  VFMADD213PSZrbk,
  VFMADD213PSZrbkz,
  VFMADD213PSZrk,
  VFMADD213PSZrkz,
  VFMADD213PSm,
  VFMADD213PSr,
  VFMADD213SDZm,
  VFMADD213SDZm_Int,
  VFMADD213SDZmk_Int,
  VFMADD213SDZmkz_Int,
  VFMADD213SDZr,
  VFMADD213SDZr_Int,
  VFMADD213SDZrb,
  VFMADD213SDZrb_Int,
  VFMADD213SDZrbk_Int,
  VFMADD213SDZrbkz_Int,
  VFMADD213SDZrk_Int,
  VFMADD213SDZrkz_Int,
  VFMADD213SDm,
  VFMADD213SDm_Int,
  VFMADD213SDr,
  VFMADD213SDr_Int,
  VFMADD213SHZm,
  VFMADD213SHZm_Int,
  VFMADD213SHZmk_Int,
  VFMADD213SHZmkz_Int,
  VFMADD213SHZr,
  VFMADD213SHZr_Int,
  VFMADD213SHZrb,
  VFMADD213SHZrb_Int,
  VFMADD213SHZrbk_Int,
  VFMADD213SHZrbkz_Int,
  VFMADD213SHZrk_Int,
  VFMADD213SHZrkz_Int,
  VFMADD213SSZm,
  VFMADD213SSZm_Int,
  VFMADD213SSZmk_Int,
  VFMADD213SSZmkz_Int,
  VFMADD213SSZr,
  VFMADD213SSZr_Int,
  VFMADD213SSZrb,
  VFMADD213SSZrb_Int,
  VFMADD213SSZrbk_Int,
  VFMADD213SSZrbkz_Int,
  VFMADD213SSZrk_Int,
  VFMADD213SSZrkz_Int,
  VFMADD213SSm,
  VFMADD213SSm_Int,
  VFMADD213SSr,
  VFMADD213SSr_Int,
  VFMADD231BF16Z128m,
  VFMADD231BF16Z128mb,
  VFMADD231BF16Z128mbk,
  VFMADD231BF16Z128mbkz,
  VFMADD231BF16Z128mk,
  VFMADD231BF16Z128mkz,
  VFMADD231BF16Z128r,
  VFMADD231BF16Z128rk,
  VFMADD231BF16Z128rkz,
  VFMADD231BF16Z256m,
  VFMADD231BF16Z256mb,
  VFMADD231BF16Z256mbk,
  VFMADD231BF16Z256mbkz,
  VFMADD231BF16Z256mk,
  VFMADD231BF16Z256mkz,
  VFMADD231BF16Z256r,
  VFMADD231BF16Z256rk,
  VFMADD231BF16Z256rkz,
  VFMADD231BF16Zm,
  VFMADD231BF16Zmb,
  VFMADD231BF16Zmbk,
  VFMADD231BF16Zmbkz,
  VFMADD231BF16Zmk,
  VFMADD231BF16Zmkz,
  VFMADD231BF16Zr,
  VFMADD231BF16Zrk,
  VFMADD231BF16Zrkz,
  VFMADD231PDYm,
  VFMADD231PDYr,
  VFMADD231PDZ128m,
  VFMADD231PDZ128mb,
  VFMADD231PDZ128mbk,
  VFMADD231PDZ128mbkz,
  VFMADD231PDZ128mk,
  VFMADD231PDZ128mkz,
  VFMADD231PDZ128r,
  VFMADD231PDZ128rk,
  VFMADD231PDZ128rkz,
  VFMADD231PDZ256m,
  VFMADD231PDZ256mb,
  VFMADD231PDZ256mbk,
  VFMADD231PDZ256mbkz,
  VFMADD231PDZ256mk,
  VFMADD231PDZ256mkz,
  VFMADD231PDZ256r,
  VFMADD231PDZ256rk,
  VFMADD231PDZ256rkz,
  VFMADD231PDZm,
  VFMADD231PDZmb,
  VFMADD231PDZmbk,
  VFMADD231PDZmbkz,
  VFMADD231PDZmk,
  VFMADD231PDZmkz,
  VFMADD231PDZr,
  VFMADD231PDZrb,
  VFMADD231PDZrbk,
  VFMADD231PDZrbkz,
  VFMADD231PDZrk,
  VFMADD231PDZrkz,
  VFMADD231PDm,
  VFMADD231PDr,
  VFMADD231PHZ128m,
  VFMADD231PHZ128mb,
  VFMADD231PHZ128mbk,
  VFMADD231PHZ128mbkz,
  VFMADD231PHZ128mk,
  VFMADD231PHZ128mkz,
  VFMADD231PHZ128r,
  VFMADD231PHZ128rk,
  VFMADD231PHZ128rkz,
  VFMADD231PHZ256m,
  VFMADD231PHZ256mb,
  VFMADD231PHZ256mbk,
  VFMADD231PHZ256mbkz,
  VFMADD231PHZ256mk,
  VFMADD231PHZ256mkz,
  VFMADD231PHZ256r,
  VFMADD231PHZ256rk,
  VFMADD231PHZ256rkz,
  VFMADD231PHZm,
  VFMADD231PHZmb,
  VFMADD231PHZmbk,
  VFMADD231PHZmbkz,
  VFMADD231PHZmk,
  VFMADD231PHZmkz,
  VFMADD231PHZr,
  VFMADD231PHZrb,
  VFMADD231PHZrbk,
  VFMADD231PHZrbkz,
  VFMADD231PHZrk,
  VFMADD231PHZrkz,
  VFMADD231PSYm,
  VFMADD231PSYr,
  VFMADD231PSZ128m,
  VFMADD231PSZ128mb,
  VFMADD231PSZ128mbk,
  VFMADD231PSZ128mbkz,
  VFMADD231PSZ128mk,
  VFMADD231PSZ128mkz,
  VFMADD231PSZ128r,
  VFMADD231PSZ128rk,
  VFMADD231PSZ128rkz,
  VFMADD231PSZ256m,
  VFMADD231PSZ256mb,
  VFMADD231PSZ256mbk,
  VFMADD231PSZ256mbkz,
  VFMADD231PSZ256mk,
  VFMADD231PSZ256mkz,
  VFMADD231PSZ256r,
  VFMADD231PSZ256rk,
  VFMADD231PSZ256rkz,
  VFMADD231PSZm,
  VFMADD231PSZmb,
  VFMADD231PSZmbk,
  VFMADD231PSZmbkz,
  VFMADD231PSZmk,
  VFMADD231PSZmkz,
  VFMADD231PSZr,
  VFMADD231PSZrb,
  VFMADD231PSZrbk,
  VFMADD231PSZrbkz,
  VFMADD231PSZrk,
  VFMADD231PSZrkz,
  VFMADD231PSm,
  VFMADD231PSr,
  VFMADD231SDZm,
  VFMADD231SDZm_Int,
  VFMADD231SDZmk_Int,
  VFMADD231SDZmkz_Int,
  VFMADD231SDZr,
  VFMADD231SDZr_Int,
  VFMADD231SDZrb,
  VFMADD231SDZrb_Int,
  VFMADD231SDZrbk_Int,
  VFMADD231SDZrbkz_Int,
  VFMADD231SDZrk_Int,
  VFMADD231SDZrkz_Int,
  VFMADD231SDm,
  VFMADD231SDm_Int,
  VFMADD231SDr,
  VFMADD231SDr_Int,
  VFMADD231SHZm,
  VFMADD231SHZm_Int,
  VFMADD231SHZmk_Int,
  VFMADD231SHZmkz_Int,
  VFMADD231SHZr,
  VFMADD231SHZr_Int,
  VFMADD231SHZrb,
  VFMADD231SHZrb_Int,
  VFMADD231SHZrbk_Int,
  VFMADD231SHZrbkz_Int,
  VFMADD231SHZrk_Int,
  VFMADD231SHZrkz_Int,
  VFMADD231SSZm,
  VFMADD231SSZm_Int,
  VFMADD231SSZmk_Int,
  VFMADD231SSZmkz_Int,
  VFMADD231SSZr,
  VFMADD231SSZr_Int,
  VFMADD231SSZrb,
  VFMADD231SSZrb_Int,
  VFMADD231SSZrbk_Int,
  VFMADD231SSZrbkz_Int,
  VFMADD231SSZrk_Int,
  VFMADD231SSZrkz_Int,
  VFMADD231SSm,
  VFMADD231SSm_Int,
  VFMADD231SSr,
  VFMADD231SSr_Int,
  VFMADDCPHZ128m,
  VFMADDCPHZ128mb,
  VFMADDCPHZ128mbk,
  VFMADDCPHZ128mbkz,
  VFMADDCPHZ128mk,
  VFMADDCPHZ128mkz,
  VFMADDCPHZ128r,
  VFMADDCPHZ128rk,
  VFMADDCPHZ128rkz,
  VFMADDCPHZ256m,
  VFMADDCPHZ256mb,
  VFMADDCPHZ256mbk,
  VFMADDCPHZ256mbkz,
  VFMADDCPHZ256mk,
  VFMADDCPHZ256mkz,
  VFMADDCPHZ256r,
  VFMADDCPHZ256rk,
  VFMADDCPHZ256rkz,
  VFMADDCPHZm,
  VFMADDCPHZmb,
  VFMADDCPHZmbk,
  VFMADDCPHZmbkz,
  VFMADDCPHZmk,
  VFMADDCPHZmkz,
  VFMADDCPHZr,
  VFMADDCPHZrb,
  VFMADDCPHZrbk,
  VFMADDCPHZrbkz,
  VFMADDCPHZrk,
  VFMADDCPHZrkz,
  VFMADDCSHZm,
  VFMADDCSHZmk,
  VFMADDCSHZmkz,
  VFMADDCSHZr,
  VFMADDCSHZrb,
  VFMADDCSHZrbk,
  VFMADDCSHZrbkz,
  VFMADDCSHZrk,
  VFMADDCSHZrkz,
  VFMADDPD4Ymr,
  VFMADDPD4Yrm,
  VFMADDPD4Yrr,
  VFMADDPD4Yrr_REV,
  VFMADDPD4mr,
  VFMADDPD4rm,
  VFMADDPD4rr,
  VFMADDPD4rr_REV,
  VFMADDPS4Ymr,
  VFMADDPS4Yrm,
  VFMADDPS4Yrr,
  VFMADDPS4Yrr_REV,
  VFMADDPS4mr,
  VFMADDPS4rm,
  VFMADDPS4rr,
  VFMADDPS4rr_REV,
  VFMADDSD4mr,
  VFMADDSD4mr_Int,
  VFMADDSD4rm,
  VFMADDSD4rm_Int,
  VFMADDSD4rr,
  VFMADDSD4rr_Int,
  VFMADDSD4rr_Int_REV,
  VFMADDSD4rr_REV,
  VFMADDSS4mr,
  VFMADDSS4mr_Int,
  VFMADDSS4rm,
  VFMADDSS4rm_Int,
  VFMADDSS4rr,
  VFMADDSS4rr_Int,
  VFMADDSS4rr_Int_REV,
  VFMADDSS4rr_REV,
  VFMADDSUB132PDYm,
  VFMADDSUB132PDYr,
  VFMADDSUB132PDZ128m,
  VFMADDSUB132PDZ128mb,
  VFMADDSUB132PDZ128mbk,
  VFMADDSUB132PDZ128mbkz,
  VFMADDSUB132PDZ128mk,
  VFMADDSUB132PDZ128mkz,
  VFMADDSUB132PDZ128r,
  VFMADDSUB132PDZ128rk,
  VFMADDSUB132PDZ128rkz,
  VFMADDSUB132PDZ256m,
  VFMADDSUB132PDZ256mb,
  VFMADDSUB132PDZ256mbk,
  VFMADDSUB132PDZ256mbkz,
  VFMADDSUB132PDZ256mk,
  VFMADDSUB132PDZ256mkz,
  VFMADDSUB132PDZ256r,
  VFMADDSUB132PDZ256rk,
  VFMADDSUB132PDZ256rkz,
  VFMADDSUB132PDZm,
  VFMADDSUB132PDZmb,
  VFMADDSUB132PDZmbk,
  VFMADDSUB132PDZmbkz,
  VFMADDSUB132PDZmk,
  VFMADDSUB132PDZmkz,
  VFMADDSUB132PDZr,
  VFMADDSUB132PDZrb,
  VFMADDSUB132PDZrbk,
  VFMADDSUB132PDZrbkz,
  VFMADDSUB132PDZrk,
  VFMADDSUB132PDZrkz,
  VFMADDSUB132PDm,
  VFMADDSUB132PDr,
  VFMADDSUB132PHZ128m,
  VFMADDSUB132PHZ128mb,
  VFMADDSUB132PHZ128mbk,
  VFMADDSUB132PHZ128mbkz,
  VFMADDSUB132PHZ128mk,
  VFMADDSUB132PHZ128mkz,
  VFMADDSUB132PHZ128r,
  VFMADDSUB132PHZ128rk,
  VFMADDSUB132PHZ128rkz,
  VFMADDSUB132PHZ256m,
  VFMADDSUB132PHZ256mb,
  VFMADDSUB132PHZ256mbk,
  VFMADDSUB132PHZ256mbkz,
  VFMADDSUB132PHZ256mk,
  VFMADDSUB132PHZ256mkz,
  VFMADDSUB132PHZ256r,
  VFMADDSUB132PHZ256rk,
  VFMADDSUB132PHZ256rkz,
  VFMADDSUB132PHZm,
  VFMADDSUB132PHZmb,
  VFMADDSUB132PHZmbk,
  VFMADDSUB132PHZmbkz,
  VFMADDSUB132PHZmk,
  VFMADDSUB132PHZmkz,
  VFMADDSUB132PHZr,
  VFMADDSUB132PHZrb,
  VFMADDSUB132PHZrbk,
  VFMADDSUB132PHZrbkz,
  VFMADDSUB132PHZrk,
  VFMADDSUB132PHZrkz,
  VFMADDSUB132PSYm,
  VFMADDSUB132PSYr,
  VFMADDSUB132PSZ128m,
  VFMADDSUB132PSZ128mb,
  VFMADDSUB132PSZ128mbk,
  VFMADDSUB132PSZ128mbkz,
  VFMADDSUB132PSZ128mk,
  VFMADDSUB132PSZ128mkz,
  VFMADDSUB132PSZ128r,
  VFMADDSUB132PSZ128rk,
  VFMADDSUB132PSZ128rkz,
  VFMADDSUB132PSZ256m,
  VFMADDSUB132PSZ256mb,
  VFMADDSUB132PSZ256mbk,
  VFMADDSUB132PSZ256mbkz,
  VFMADDSUB132PSZ256mk,
  VFMADDSUB132PSZ256mkz,
  VFMADDSUB132PSZ256r,
  VFMADDSUB132PSZ256rk,
  VFMADDSUB132PSZ256rkz,
  VFMADDSUB132PSZm,
  VFMADDSUB132PSZmb,
  VFMADDSUB132PSZmbk,
  VFMADDSUB132PSZmbkz,
  VFMADDSUB132PSZmk,
  VFMADDSUB132PSZmkz,
  VFMADDSUB132PSZr,
  VFMADDSUB132PSZrb,
  VFMADDSUB132PSZrbk,
  VFMADDSUB132PSZrbkz,
  VFMADDSUB132PSZrk,
  VFMADDSUB132PSZrkz,
  VFMADDSUB132PSm,
  VFMADDSUB132PSr,
  VFMADDSUB213PDYm,
  VFMADDSUB213PDYr,
  VFMADDSUB213PDZ128m,
  VFMADDSUB213PDZ128mb,
  VFMADDSUB213PDZ128mbk,
  VFMADDSUB213PDZ128mbkz,
  VFMADDSUB213PDZ128mk,
  VFMADDSUB213PDZ128mkz,
  VFMADDSUB213PDZ128r,
  VFMADDSUB213PDZ128rk,
  VFMADDSUB213PDZ128rkz,
  VFMADDSUB213PDZ256m,
  VFMADDSUB213PDZ256mb,
  VFMADDSUB213PDZ256mbk,
  VFMADDSUB213PDZ256mbkz,
  VFMADDSUB213PDZ256mk,
  VFMADDSUB213PDZ256mkz,
  VFMADDSUB213PDZ256r,
  VFMADDSUB213PDZ256rk,
  VFMADDSUB213PDZ256rkz,
  VFMADDSUB213PDZm,
  VFMADDSUB213PDZmb,
  VFMADDSUB213PDZmbk,
  VFMADDSUB213PDZmbkz,
  VFMADDSUB213PDZmk,
  VFMADDSUB213PDZmkz,
  VFMADDSUB213PDZr,
  VFMADDSUB213PDZrb,
  VFMADDSUB213PDZrbk,
  VFMADDSUB213PDZrbkz,
  VFMADDSUB213PDZrk,
  VFMADDSUB213PDZrkz,
  VFMADDSUB213PDm,
  VFMADDSUB213PDr,
  VFMADDSUB213PHZ128m,
  VFMADDSUB213PHZ128mb,
  VFMADDSUB213PHZ128mbk,
  VFMADDSUB213PHZ128mbkz,
  VFMADDSUB213PHZ128mk,
  VFMADDSUB213PHZ128mkz,
  VFMADDSUB213PHZ128r,
  VFMADDSUB213PHZ128rk,
  VFMADDSUB213PHZ128rkz,
  VFMADDSUB213PHZ256m,
  VFMADDSUB213PHZ256mb,
  VFMADDSUB213PHZ256mbk,
  VFMADDSUB213PHZ256mbkz,
  VFMADDSUB213PHZ256mk,
  VFMADDSUB213PHZ256mkz,
  VFMADDSUB213PHZ256r,
  VFMADDSUB213PHZ256rk,
  VFMADDSUB213PHZ256rkz,
  VFMADDSUB213PHZm,
  VFMADDSUB213PHZmb,
  VFMADDSUB213PHZmbk,
  VFMADDSUB213PHZmbkz,
  VFMADDSUB213PHZmk,
  VFMADDSUB213PHZmkz,
  VFMADDSUB213PHZr,
  VFMADDSUB213PHZrb,
  VFMADDSUB213PHZrbk,
  VFMADDSUB213PHZrbkz,
  VFMADDSUB213PHZrk,
  VFMADDSUB213PHZrkz,
  VFMADDSUB213PSYm,
  VFMADDSUB213PSYr,
  VFMADDSUB213PSZ128m,
  VFMADDSUB213PSZ128mb,
  VFMADDSUB213PSZ128mbk,
  VFMADDSUB213PSZ128mbkz,
  VFMADDSUB213PSZ128mk,
  VFMADDSUB213PSZ128mkz,
  VFMADDSUB213PSZ128r,
  VFMADDSUB213PSZ128rk,
  VFMADDSUB213PSZ128rkz,
  VFMADDSUB213PSZ256m,
  VFMADDSUB213PSZ256mb,
  VFMADDSUB213PSZ256mbk,
  VFMADDSUB213PSZ256mbkz,
  VFMADDSUB213PSZ256mk,
  VFMADDSUB213PSZ256mkz,
  VFMADDSUB213PSZ256r,
  VFMADDSUB213PSZ256rk,
  VFMADDSUB213PSZ256rkz,
  VFMADDSUB213PSZm,
  VFMADDSUB213PSZmb,
  VFMADDSUB213PSZmbk,
  VFMADDSUB213PSZmbkz,
  VFMADDSUB213PSZmk,
  VFMADDSUB213PSZmkz,
  VFMADDSUB213PSZr,
  VFMADDSUB213PSZrb,
  VFMADDSUB213PSZrbk,
  VFMADDSUB213PSZrbkz,
  VFMADDSUB213PSZrk,
  VFMADDSUB213PSZrkz,
  VFMADDSUB213PSm,
  VFMADDSUB213PSr,
  VFMADDSUB231PDYm,
  VFMADDSUB231PDYr,
  VFMADDSUB231PDZ128m,
  VFMADDSUB231PDZ128mb,
  VFMADDSUB231PDZ128mbk,
  VFMADDSUB231PDZ128mbkz,
  VFMADDSUB231PDZ128mk,
  VFMADDSUB231PDZ128mkz,
  VFMADDSUB231PDZ128r,
  VFMADDSUB231PDZ128rk,
  VFMADDSUB231PDZ128rkz,
  VFMADDSUB231PDZ256m,
  VFMADDSUB231PDZ256mb,
  VFMADDSUB231PDZ256mbk,
  VFMADDSUB231PDZ256mbkz,
  VFMADDSUB231PDZ256mk,
  VFMADDSUB231PDZ256mkz,
  VFMADDSUB231PDZ256r,
  VFMADDSUB231PDZ256rk,
  VFMADDSUB231PDZ256rkz,
  VFMADDSUB231PDZm,
  VFMADDSUB231PDZmb,
  VFMADDSUB231PDZmbk,
  VFMADDSUB231PDZmbkz,
  VFMADDSUB231PDZmk,
  VFMADDSUB231PDZmkz,
  VFMADDSUB231PDZr,
  VFMADDSUB231PDZrb,
  VFMADDSUB231PDZrbk,
  VFMADDSUB231PDZrbkz,
  VFMADDSUB231PDZrk,
  VFMADDSUB231PDZrkz,
  VFMADDSUB231PDm,
  VFMADDSUB231PDr,
  VFMADDSUB231PHZ128m,
  VFMADDSUB231PHZ128mb,
  VFMADDSUB231PHZ128mbk,
  VFMADDSUB231PHZ128mbkz,
  VFMADDSUB231PHZ128mk,
  VFMADDSUB231PHZ128mkz,
  VFMADDSUB231PHZ128r,
  VFMADDSUB231PHZ128rk,
  VFMADDSUB231PHZ128rkz,
  VFMADDSUB231PHZ256m,
  VFMADDSUB231PHZ256mb,
  VFMADDSUB231PHZ256mbk,
  VFMADDSUB231PHZ256mbkz,
  VFMADDSUB231PHZ256mk,
  VFMADDSUB231PHZ256mkz,
  VFMADDSUB231PHZ256r,
  VFMADDSUB231PHZ256rk,
  VFMADDSUB231PHZ256rkz,
  VFMADDSUB231PHZm,
  VFMADDSUB231PHZmb,
  VFMADDSUB231PHZmbk,
  VFMADDSUB231PHZmbkz,
  VFMADDSUB231PHZmk,
  VFMADDSUB231PHZmkz,
  VFMADDSUB231PHZr,
  VFMADDSUB231PHZrb,
  VFMADDSUB231PHZrbk,
  VFMADDSUB231PHZrbkz,
  VFMADDSUB231PHZrk,
  VFMADDSUB231PHZrkz,
  VFMADDSUB231PSYm,
  VFMADDSUB231PSYr,
  VFMADDSUB231PSZ128m,
  VFMADDSUB231PSZ128mb,
  VFMADDSUB231PSZ128mbk,
  VFMADDSUB231PSZ128mbkz,
  VFMADDSUB231PSZ128mk,
  VFMADDSUB231PSZ128mkz,
  VFMADDSUB231PSZ128r,
  VFMADDSUB231PSZ128rk,
  VFMADDSUB231PSZ128rkz,
  VFMADDSUB231PSZ256m,
  VFMADDSUB231PSZ256mb,
  VFMADDSUB231PSZ256mbk,
  VFMADDSUB231PSZ256mbkz,
  VFMADDSUB231PSZ256mk,
  VFMADDSUB231PSZ256mkz,
  VFMADDSUB231PSZ256r,
  VFMADDSUB231PSZ256rk,
  VFMADDSUB231PSZ256rkz,
  VFMADDSUB231PSZm,
  VFMADDSUB231PSZmb,
  VFMADDSUB231PSZmbk,
  VFMADDSUB231PSZmbkz,
  VFMADDSUB231PSZmk,
  VFMADDSUB231PSZmkz,
  VFMADDSUB231PSZr,
  VFMADDSUB231PSZrb,
  VFMADDSUB231PSZrbk,
  VFMADDSUB231PSZrbkz,
  VFMADDSUB231PSZrk,
  VFMADDSUB231PSZrkz,
  VFMADDSUB231PSm,
  VFMADDSUB231PSr,
  VFMADDSUBPD4Ymr,
  VFMADDSUBPD4Yrm,
  VFMADDSUBPD4Yrr,
  VFMADDSUBPD4Yrr_REV,
  VFMADDSUBPD4mr,
  VFMADDSUBPD4rm,
  VFMADDSUBPD4rr,
  VFMADDSUBPD4rr_REV,
  VFMADDSUBPS4Ymr,
  VFMADDSUBPS4Yrm,
  VFMADDSUBPS4Yrr,
  VFMADDSUBPS4Yrr_REV,
  VFMADDSUBPS4mr,
  VFMADDSUBPS4rm,
  VFMADDSUBPS4rr,
  VFMADDSUBPS4rr_REV,
  VFMSUB132BF16Z128m,
  VFMSUB132BF16Z128mb,
  VFMSUB132BF16Z128mbk,
  VFMSUB132BF16Z128mbkz,
  VFMSUB132BF16Z128mk,
  VFMSUB132BF16Z128mkz,
  VFMSUB132BF16Z128r,
  VFMSUB132BF16Z128rk,
  VFMSUB132BF16Z128rkz,
  VFMSUB132BF16Z256m,
  VFMSUB132BF16Z256mb,
  VFMSUB132BF16Z256mbk,
  VFMSUB132BF16Z256mbkz,
  VFMSUB132BF16Z256mk,
  VFMSUB132BF16Z256mkz,
  VFMSUB132BF16Z256r,
  VFMSUB132BF16Z256rk,
  VFMSUB132BF16Z256rkz,
  VFMSUB132BF16Zm,
  VFMSUB132BF16Zmb,
  VFMSUB132BF16Zmbk,
  VFMSUB132BF16Zmbkz,
  VFMSUB132BF16Zmk,
  VFMSUB132BF16Zmkz,
  VFMSUB132BF16Zr,
  VFMSUB132BF16Zrk,
  VFMSUB132BF16Zrkz,
  VFMSUB132PDYm,
  VFMSUB132PDYr,
  VFMSUB132PDZ128m,
  VFMSUB132PDZ128mb,
  VFMSUB132PDZ128mbk,
  VFMSUB132PDZ128mbkz,
  VFMSUB132PDZ128mk,
  VFMSUB132PDZ128mkz,
  VFMSUB132PDZ128r,
  VFMSUB132PDZ128rk,
  VFMSUB132PDZ128rkz,
  VFMSUB132PDZ256m,
  VFMSUB132PDZ256mb,
  VFMSUB132PDZ256mbk,
  VFMSUB132PDZ256mbkz,
  VFMSUB132PDZ256mk,
  VFMSUB132PDZ256mkz,
  VFMSUB132PDZ256r,
  VFMSUB132PDZ256rk,
  VFMSUB132PDZ256rkz,
  VFMSUB132PDZm,
  VFMSUB132PDZmb,
  VFMSUB132PDZmbk,
  VFMSUB132PDZmbkz,
  VFMSUB132PDZmk,
  VFMSUB132PDZmkz,
  VFMSUB132PDZr,
  VFMSUB132PDZrb,
  VFMSUB132PDZrbk,
  VFMSUB132PDZrbkz,
  VFMSUB132PDZrk,
  VFMSUB132PDZrkz,
  VFMSUB132PDm,
  VFMSUB132PDr,
  VFMSUB132PHZ128m,
  VFMSUB132PHZ128mb,
  VFMSUB132PHZ128mbk,
  VFMSUB132PHZ128mbkz,
  VFMSUB132PHZ128mk,
  VFMSUB132PHZ128mkz,
  VFMSUB132PHZ128r,
  VFMSUB132PHZ128rk,
  VFMSUB132PHZ128rkz,
  VFMSUB132PHZ256m,
  VFMSUB132PHZ256mb,
  VFMSUB132PHZ256mbk,
  VFMSUB132PHZ256mbkz,
  VFMSUB132PHZ256mk,
  VFMSUB132PHZ256mkz,
  VFMSUB132PHZ256r,
  VFMSUB132PHZ256rk,
  VFMSUB132PHZ256rkz,
  VFMSUB132PHZm,
  VFMSUB132PHZmb,
  VFMSUB132PHZmbk,
  VFMSUB132PHZmbkz,
  VFMSUB132PHZmk,
  VFMSUB132PHZmkz,
  VFMSUB132PHZr,
  VFMSUB132PHZrb,
  VFMSUB132PHZrbk,
  VFMSUB132PHZrbkz,
  VFMSUB132PHZrk,
  VFMSUB132PHZrkz,
  VFMSUB132PSYm,
  VFMSUB132PSYr,
  VFMSUB132PSZ128m,
  VFMSUB132PSZ128mb,
  VFMSUB132PSZ128mbk,
  VFMSUB132PSZ128mbkz,
  VFMSUB132PSZ128mk,
  VFMSUB132PSZ128mkz,
  VFMSUB132PSZ128r,
  VFMSUB132PSZ128rk,
  VFMSUB132PSZ128rkz,
  VFMSUB132PSZ256m,
  VFMSUB132PSZ256mb,
  VFMSUB132PSZ256mbk,
  VFMSUB132PSZ256mbkz,
  VFMSUB132PSZ256mk,
  VFMSUB132PSZ256mkz,
  VFMSUB132PSZ256r,
  VFMSUB132PSZ256rk,
  VFMSUB132PSZ256rkz,
  VFMSUB132PSZm,
  VFMSUB132PSZmb,
  VFMSUB132PSZmbk,
  VFMSUB132PSZmbkz,
  VFMSUB132PSZmk,
  VFMSUB132PSZmkz,
  VFMSUB132PSZr,
  VFMSUB132PSZrb,
  VFMSUB132PSZrbk,
  VFMSUB132PSZrbkz,
  VFMSUB132PSZrk,
  VFMSUB132PSZrkz,
  VFMSUB132PSm,
  VFMSUB132PSr,
  VFMSUB132SDZm,
  VFMSUB132SDZm_Int,
  VFMSUB132SDZmk_Int,
  VFMSUB132SDZmkz_Int,
  VFMSUB132SDZr,
  VFMSUB132SDZr_Int,
  VFMSUB132SDZrb,
  VFMSUB132SDZrb_Int,
  VFMSUB132SDZrbk_Int,
  VFMSUB132SDZrbkz_Int,
  VFMSUB132SDZrk_Int,
  VFMSUB132SDZrkz_Int,
  VFMSUB132SDm,
  VFMSUB132SDm_Int,
  VFMSUB132SDr,
  VFMSUB132SDr_Int,
  VFMSUB132SHZm,
  VFMSUB132SHZm_Int,
  VFMSUB132SHZmk_Int,
  VFMSUB132SHZmkz_Int,
  VFMSUB132SHZr,
  VFMSUB132SHZr_Int,
  VFMSUB132SHZrb,
  VFMSUB132SHZrb_Int,
  VFMSUB132SHZrbk_Int,
  VFMSUB132SHZrbkz_Int,
  VFMSUB132SHZrk_Int,
  VFMSUB132SHZrkz_Int,
  VFMSUB132SSZm,
  VFMSUB132SSZm_Int,
  VFMSUB132SSZmk_Int,
  VFMSUB132SSZmkz_Int,
  VFMSUB132SSZr,
  VFMSUB132SSZr_Int,
  VFMSUB132SSZrb,
  VFMSUB132SSZrb_Int,
  VFMSUB132SSZrbk_Int,
  VFMSUB132SSZrbkz_Int,
  VFMSUB132SSZrk_Int,
  VFMSUB132SSZrkz_Int,
  VFMSUB132SSm,
  VFMSUB132SSm_Int,
  VFMSUB132SSr,
  VFMSUB132SSr_Int,
  VFMSUB213BF16Z128m,
  VFMSUB213BF16Z128mb,
  VFMSUB213BF16Z128mbk,
  VFMSUB213BF16Z128mbkz,
  VFMSUB213BF16Z128mk,
  VFMSUB213BF16Z128mkz,
  VFMSUB213BF16Z128r,
  VFMSUB213BF16Z128rk,
  VFMSUB213BF16Z128rkz,
  VFMSUB213BF16Z256m,
  VFMSUB213BF16Z256mb,
  VFMSUB213BF16Z256mbk,
  VFMSUB213BF16Z256mbkz,
  VFMSUB213BF16Z256mk,
  VFMSUB213BF16Z256mkz,
  VFMSUB213BF16Z256r,
  VFMSUB213BF16Z256rk,
  VFMSUB213BF16Z256rkz,
  VFMSUB213BF16Zm,
  VFMSUB213BF16Zmb,
  VFMSUB213BF16Zmbk,
  VFMSUB213BF16Zmbkz,
  VFMSUB213BF16Zmk,
  VFMSUB213BF16Zmkz,
  VFMSUB213BF16Zr,
  VFMSUB213BF16Zrk,
  VFMSUB213BF16Zrkz,
  VFMSUB213PDYm,
  VFMSUB213PDYr,
  VFMSUB213PDZ128m,
  VFMSUB213PDZ128mb,
  VFMSUB213PDZ128mbk,
  VFMSUB213PDZ128mbkz,
  VFMSUB213PDZ128mk,
  VFMSUB213PDZ128mkz,
  VFMSUB213PDZ128r,
  VFMSUB213PDZ128rk,
  VFMSUB213PDZ128rkz,
  VFMSUB213PDZ256m,
  VFMSUB213PDZ256mb,
  VFMSUB213PDZ256mbk,
  VFMSUB213PDZ256mbkz,
  VFMSUB213PDZ256mk,
  VFMSUB213PDZ256mkz,
  VFMSUB213PDZ256r,
  VFMSUB213PDZ256rk,
  VFMSUB213PDZ256rkz,
  VFMSUB213PDZm,
  VFMSUB213PDZmb,
  VFMSUB213PDZmbk,
  VFMSUB213PDZmbkz,
  VFMSUB213PDZmk,
  VFMSUB213PDZmkz,
  VFMSUB213PDZr,
  VFMSUB213PDZrb,
  VFMSUB213PDZrbk,
  VFMSUB213PDZrbkz,
  VFMSUB213PDZrk,
  VFMSUB213PDZrkz,
  VFMSUB213PDm,
  VFMSUB213PDr,
  VFMSUB213PHZ128m,
  VFMSUB213PHZ128mb,
  VFMSUB213PHZ128mbk,
  VFMSUB213PHZ128mbkz,
  VFMSUB213PHZ128mk,
  VFMSUB213PHZ128mkz,
  VFMSUB213PHZ128r,
  VFMSUB213PHZ128rk,
  VFMSUB213PHZ128rkz,
  VFMSUB213PHZ256m,
  VFMSUB213PHZ256mb,
  VFMSUB213PHZ256mbk,
  VFMSUB213PHZ256mbkz,
  VFMSUB213PHZ256mk,
  VFMSUB213PHZ256mkz,
  VFMSUB213PHZ256r,
  VFMSUB213PHZ256rk,
  VFMSUB213PHZ256rkz,
  VFMSUB213PHZm,
  VFMSUB213PHZmb,
  VFMSUB213PHZmbk,
  VFMSUB213PHZmbkz,
  VFMSUB213PHZmk,
  VFMSUB213PHZmkz,
  VFMSUB213PHZr,
  VFMSUB213PHZrb,
  VFMSUB213PHZrbk,
  VFMSUB213PHZrbkz,
  VFMSUB213PHZrk,
  VFMSUB213PHZrkz,
  VFMSUB213PSYm,
  VFMSUB213PSYr,
  VFMSUB213PSZ128m,
  VFMSUB213PSZ128mb,
  VFMSUB213PSZ128mbk,
  VFMSUB213PSZ128mbkz,
  VFMSUB213PSZ128mk,
  VFMSUB213PSZ128mkz,
  VFMSUB213PSZ128r,
  VFMSUB213PSZ128rk,
  VFMSUB213PSZ128rkz,
  VFMSUB213PSZ256m,
  VFMSUB213PSZ256mb,
  VFMSUB213PSZ256mbk,
  VFMSUB213PSZ256mbkz,
  VFMSUB213PSZ256mk,
  VFMSUB213PSZ256mkz,
  VFMSUB213PSZ256r,
  VFMSUB213PSZ256rk,
  VFMSUB213PSZ256rkz,
  VFMSUB213PSZm,
  VFMSUB213PSZmb,
  VFMSUB213PSZmbk,
  VFMSUB213PSZmbkz,
  VFMSUB213PSZmk,
  VFMSUB213PSZmkz,
  VFMSUB213PSZr,
  VFMSUB213PSZrb,
  VFMSUB213PSZrbk,
  VFMSUB213PSZrbkz,
  VFMSUB213PSZrk,
  VFMSUB213PSZrkz,
  VFMSUB213PSm,
  VFMSUB213PSr,
  VFMSUB213SDZm,
  VFMSUB213SDZm_Int,
  VFMSUB213SDZmk_Int,
  VFMSUB213SDZmkz_Int,
  VFMSUB213SDZr,
  VFMSUB213SDZr_Int,
  VFMSUB213SDZrb,
  VFMSUB213SDZrb_Int,
  VFMSUB213SDZrbk_Int,
  VFMSUB213SDZrbkz_Int,
  VFMSUB213SDZrk_Int,
  VFMSUB213SDZrkz_Int,
  VFMSUB213SDm,
  VFMSUB213SDm_Int,
  VFMSUB213SDr,
  VFMSUB213SDr_Int,
  VFMSUB213SHZm,
  VFMSUB213SHZm_Int,
  VFMSUB213SHZmk_Int,
  VFMSUB213SHZmkz_Int,
  VFMSUB213SHZr,
  VFMSUB213SHZr_Int,
  VFMSUB213SHZrb,
  VFMSUB213SHZrb_Int,
  VFMSUB213SHZrbk_Int,
  VFMSUB213SHZrbkz_Int,
  VFMSUB213SHZrk_Int,
  VFMSUB213SHZrkz_Int,
  VFMSUB213SSZm,
  VFMSUB213SSZm_Int,
  VFMSUB213SSZmk_Int,
  VFMSUB213SSZmkz_Int,
  VFMSUB213SSZr,
  VFMSUB213SSZr_Int,
  VFMSUB213SSZrb,
  VFMSUB213SSZrb_Int,
  VFMSUB213SSZrbk_Int,
  VFMSUB213SSZrbkz_Int,
  VFMSUB213SSZrk_Int,
  VFMSUB213SSZrkz_Int,
  VFMSUB213SSm,
  VFMSUB213SSm_Int,
  VFMSUB213SSr,
  VFMSUB213SSr_Int,
  VFMSUB231BF16Z128m,
  VFMSUB231BF16Z128mb,
  VFMSUB231BF16Z128mbk,
  VFMSUB231BF16Z128mbkz,
  VFMSUB231BF16Z128mk,
  VFMSUB231BF16Z128mkz,
  VFMSUB231BF16Z128r,
  VFMSUB231BF16Z128rk,
  VFMSUB231BF16Z128rkz,
  VFMSUB231BF16Z256m,
  VFMSUB231BF16Z256mb,
  VFMSUB231BF16Z256mbk,
  VFMSUB231BF16Z256mbkz,
  VFMSUB231BF16Z256mk,
  VFMSUB231BF16Z256mkz,
  VFMSUB231BF16Z256r,
  VFMSUB231BF16Z256rk,
  VFMSUB231BF16Z256rkz,
  VFMSUB231BF16Zm,
  VFMSUB231BF16Zmb,
  VFMSUB231BF16Zmbk,
  VFMSUB231BF16Zmbkz,
  VFMSUB231BF16Zmk,
  VFMSUB231BF16Zmkz,
  VFMSUB231BF16Zr,
  VFMSUB231BF16Zrk,
  VFMSUB231BF16Zrkz,
  VFMSUB231PDYm,
  VFMSUB231PDYr,
  VFMSUB231PDZ128m,
  VFMSUB231PDZ128mb,
  VFMSUB231PDZ128mbk,
  VFMSUB231PDZ128mbkz,
  VFMSUB231PDZ128mk,
  VFMSUB231PDZ128mkz,
  VFMSUB231PDZ128r,
  VFMSUB231PDZ128rk,
  VFMSUB231PDZ128rkz,
  VFMSUB231PDZ256m,
  VFMSUB231PDZ256mb,
  VFMSUB231PDZ256mbk,
  VFMSUB231PDZ256mbkz,
  VFMSUB231PDZ256mk,
  VFMSUB231PDZ256mkz,
  VFMSUB231PDZ256r,
  VFMSUB231PDZ256rk,
  VFMSUB231PDZ256rkz,
  VFMSUB231PDZm,
  VFMSUB231PDZmb,
  VFMSUB231PDZmbk,
  VFMSUB231PDZmbkz,
  VFMSUB231PDZmk,
  VFMSUB231PDZmkz,
  VFMSUB231PDZr,
  VFMSUB231PDZrb,
  VFMSUB231PDZrbk,
  VFMSUB231PDZrbkz,
  VFMSUB231PDZrk,
  VFMSUB231PDZrkz,
  VFMSUB231PDm,
  VFMSUB231PDr,
  VFMSUB231PHZ128m,
  VFMSUB231PHZ128mb,
  VFMSUB231PHZ128mbk,
  VFMSUB231PHZ128mbkz,
  VFMSUB231PHZ128mk,
  VFMSUB231PHZ128mkz,
  VFMSUB231PHZ128r,
  VFMSUB231PHZ128rk,
  VFMSUB231PHZ128rkz,
  VFMSUB231PHZ256m,
  VFMSUB231PHZ256mb,
  VFMSUB231PHZ256mbk,
  VFMSUB231PHZ256mbkz,
  VFMSUB231PHZ256mk,
  VFMSUB231PHZ256mkz,
  VFMSUB231PHZ256r,
  VFMSUB231PHZ256rk,
  VFMSUB231PHZ256rkz,
  VFMSUB231PHZm,
  VFMSUB231PHZmb,
  VFMSUB231PHZmbk,
  VFMSUB231PHZmbkz,
  VFMSUB231PHZmk,
  VFMSUB231PHZmkz,
  VFMSUB231PHZr,
  VFMSUB231PHZrb,
  VFMSUB231PHZrbk,
  VFMSUB231PHZrbkz,
  VFMSUB231PHZrk,
  VFMSUB231PHZrkz,
  VFMSUB231PSYm,
  VFMSUB231PSYr,
  VFMSUB231PSZ128m,
  VFMSUB231PSZ128mb,
  VFMSUB231PSZ128mbk,
  VFMSUB231PSZ128mbkz,
  VFMSUB231PSZ128mk,
  VFMSUB231PSZ128mkz,
  VFMSUB231PSZ128r,
  VFMSUB231PSZ128rk,
  VFMSUB231PSZ128rkz,
  VFMSUB231PSZ256m,
  VFMSUB231PSZ256mb,
  VFMSUB231PSZ256mbk,
  VFMSUB231PSZ256mbkz,
  VFMSUB231PSZ256mk,
  VFMSUB231PSZ256mkz,
  VFMSUB231PSZ256r,
  VFMSUB231PSZ256rk,
  VFMSUB231PSZ256rkz,
  VFMSUB231PSZm,
  VFMSUB231PSZmb,
  VFMSUB231PSZmbk,
  VFMSUB231PSZmbkz,
  VFMSUB231PSZmk,
  VFMSUB231PSZmkz,
  VFMSUB231PSZr,
  VFMSUB231PSZrb,
  VFMSUB231PSZrbk,
  VFMSUB231PSZrbkz,
  VFMSUB231PSZrk,
  VFMSUB231PSZrkz,
  VFMSUB231PSm,
  VFMSUB231PSr,
  VFMSUB231SDZm,
  VFMSUB231SDZm_Int,
  VFMSUB231SDZmk_Int,
  VFMSUB231SDZmkz_Int,
  VFMSUB231SDZr,
  VFMSUB231SDZr_Int,
  VFMSUB231SDZrb,
  VFMSUB231SDZrb_Int,
  VFMSUB231SDZrbk_Int,
  VFMSUB231SDZrbkz_Int,
  VFMSUB231SDZrk_Int,
  VFMSUB231SDZrkz_Int,
  VFMSUB231SDm,
  VFMSUB231SDm_Int,
  VFMSUB231SDr,
  VFMSUB231SDr_Int,
  VFMSUB231SHZm,
  VFMSUB231SHZm_Int,
  VFMSUB231SHZmk_Int,
  VFMSUB231SHZmkz_Int,
  VFMSUB231SHZr,
  VFMSUB231SHZr_Int,
  VFMSUB231SHZrb,
  VFMSUB231SHZrb_Int,
  VFMSUB231SHZrbk_Int,
  VFMSUB231SHZrbkz_Int,
  VFMSUB231SHZrk_Int,
  VFMSUB231SHZrkz_Int,
  VFMSUB231SSZm,
  VFMSUB231SSZm_Int,
  VFMSUB231SSZmk_Int,
  VFMSUB231SSZmkz_Int,
  VFMSUB231SSZr,
  VFMSUB231SSZr_Int,
  VFMSUB231SSZrb,
  VFMSUB231SSZrb_Int,
  VFMSUB231SSZrbk_Int,
  VFMSUB231SSZrbkz_Int,
  VFMSUB231SSZrk_Int,
  VFMSUB231SSZrkz_Int,
  VFMSUB231SSm,
  VFMSUB231SSm_Int,
  VFMSUB231SSr,
  VFMSUB231SSr_Int,
  VFMSUBADD132PDYm,
  VFMSUBADD132PDYr,
  VFMSUBADD132PDZ128m,
  VFMSUBADD132PDZ128mb,
  VFMSUBADD132PDZ128mbk,
  VFMSUBADD132PDZ128mbkz,
  VFMSUBADD132PDZ128mk,
  VFMSUBADD132PDZ128mkz,
  VFMSUBADD132PDZ128r,
  VFMSUBADD132PDZ128rk,
  VFMSUBADD132PDZ128rkz,
  VFMSUBADD132PDZ256m,
  VFMSUBADD132PDZ256mb,
  VFMSUBADD132PDZ256mbk,
  VFMSUBADD132PDZ256mbkz,
  VFMSUBADD132PDZ256mk,
  VFMSUBADD132PDZ256mkz,
  VFMSUBADD132PDZ256r,
  VFMSUBADD132PDZ256rk,
  VFMSUBADD132PDZ256rkz,
  VFMSUBADD132PDZm,
  VFMSUBADD132PDZmb,
  VFMSUBADD132PDZmbk,
  VFMSUBADD132PDZmbkz,
  VFMSUBADD132PDZmk,
  VFMSUBADD132PDZmkz,
  VFMSUBADD132PDZr,
  VFMSUBADD132PDZrb,
  VFMSUBADD132PDZrbk,
  VFMSUBADD132PDZrbkz,
  VFMSUBADD132PDZrk,
  VFMSUBADD132PDZrkz,
  VFMSUBADD132PDm,
  VFMSUBADD132PDr,
  VFMSUBADD132PHZ128m,
  VFMSUBADD132PHZ128mb,
  VFMSUBADD132PHZ128mbk,
  VFMSUBADD132PHZ128mbkz,
  VFMSUBADD132PHZ128mk,
  VFMSUBADD132PHZ128mkz,
  VFMSUBADD132PHZ128r,
  VFMSUBADD132PHZ128rk,
  VFMSUBADD132PHZ128rkz,
  VFMSUBADD132PHZ256m,
  VFMSUBADD132PHZ256mb,
  VFMSUBADD132PHZ256mbk,
  VFMSUBADD132PHZ256mbkz,
  VFMSUBADD132PHZ256mk,
  VFMSUBADD132PHZ256mkz,
  VFMSUBADD132PHZ256r,
  VFMSUBADD132PHZ256rk,
  VFMSUBADD132PHZ256rkz,
  VFMSUBADD132PHZm,
  VFMSUBADD132PHZmb,
  VFMSUBADD132PHZmbk,
  VFMSUBADD132PHZmbkz,
  VFMSUBADD132PHZmk,
  VFMSUBADD132PHZmkz,
  VFMSUBADD132PHZr,
  VFMSUBADD132PHZrb,
  VFMSUBADD132PHZrbk,
  VFMSUBADD132PHZrbkz,
  VFMSUBADD132PHZrk,
  VFMSUBADD132PHZrkz,
  VFMSUBADD132PSYm,
  VFMSUBADD132PSYr,
  VFMSUBADD132PSZ128m,
  VFMSUBADD132PSZ128mb,
  VFMSUBADD132PSZ128mbk,
  VFMSUBADD132PSZ128mbkz,
  VFMSUBADD132PSZ128mk,
  VFMSUBADD132PSZ128mkz,
  VFMSUBADD132PSZ128r,
  VFMSUBADD132PSZ128rk,
  VFMSUBADD132PSZ128rkz,
  VFMSUBADD132PSZ256m,
  VFMSUBADD132PSZ256mb,
  VFMSUBADD132PSZ256mbk,
  VFMSUBADD132PSZ256mbkz,
  VFMSUBADD132PSZ256mk,
  VFMSUBADD132PSZ256mkz,
  VFMSUBADD132PSZ256r,
  VFMSUBADD132PSZ256rk,
  VFMSUBADD132PSZ256rkz,
  VFMSUBADD132PSZm,
  VFMSUBADD132PSZmb,
  VFMSUBADD132PSZmbk,
  VFMSUBADD132PSZmbkz,
  VFMSUBADD132PSZmk,
  VFMSUBADD132PSZmkz,
  VFMSUBADD132PSZr,
  VFMSUBADD132PSZrb,
  VFMSUBADD132PSZrbk,
  VFMSUBADD132PSZrbkz,
  VFMSUBADD132PSZrk,
  VFMSUBADD132PSZrkz,
  VFMSUBADD132PSm,
  VFMSUBADD132PSr,
  VFMSUBADD213PDYm,
  VFMSUBADD213PDYr,
  VFMSUBADD213PDZ128m,
  VFMSUBADD213PDZ128mb,
  VFMSUBADD213PDZ128mbk,
  VFMSUBADD213PDZ128mbkz,
  VFMSUBADD213PDZ128mk,
  VFMSUBADD213PDZ128mkz,
  VFMSUBADD213PDZ128r,
  VFMSUBADD213PDZ128rk,
  VFMSUBADD213PDZ128rkz,
  VFMSUBADD213PDZ256m,
  VFMSUBADD213PDZ256mb,
  VFMSUBADD213PDZ256mbk,
  VFMSUBADD213PDZ256mbkz,
  VFMSUBADD213PDZ256mk,
  VFMSUBADD213PDZ256mkz,
  VFMSUBADD213PDZ256r,
  VFMSUBADD213PDZ256rk,
  VFMSUBADD213PDZ256rkz,
  VFMSUBADD213PDZm,
  VFMSUBADD213PDZmb,
  VFMSUBADD213PDZmbk,
  VFMSUBADD213PDZmbkz,
  VFMSUBADD213PDZmk,
  VFMSUBADD213PDZmkz,
  VFMSUBADD213PDZr,
  VFMSUBADD213PDZrb,
  VFMSUBADD213PDZrbk,
  VFMSUBADD213PDZrbkz,
  VFMSUBADD213PDZrk,
  VFMSUBADD213PDZrkz,
  VFMSUBADD213PDm,
  VFMSUBADD213PDr,
  VFMSUBADD213PHZ128m,
  VFMSUBADD213PHZ128mb,
  VFMSUBADD213PHZ128mbk,
  VFMSUBADD213PHZ128mbkz,
  VFMSUBADD213PHZ128mk,
  VFMSUBADD213PHZ128mkz,
  VFMSUBADD213PHZ128r,
  VFMSUBADD213PHZ128rk,
  VFMSUBADD213PHZ128rkz,
  VFMSUBADD213PHZ256m,
  VFMSUBADD213PHZ256mb,
  VFMSUBADD213PHZ256mbk,
  VFMSUBADD213PHZ256mbkz,
  VFMSUBADD213PHZ256mk,
  VFMSUBADD213PHZ256mkz,
  VFMSUBADD213PHZ256r,
  VFMSUBADD213PHZ256rk,
  VFMSUBADD213PHZ256rkz,
  VFMSUBADD213PHZm,
  VFMSUBADD213PHZmb,
  VFMSUBADD213PHZmbk,
  VFMSUBADD213PHZmbkz,
  VFMSUBADD213PHZmk,
  VFMSUBADD213PHZmkz,
  VFMSUBADD213PHZr,
  VFMSUBADD213PHZrb,
  VFMSUBADD213PHZrbk,
  VFMSUBADD213PHZrbkz,
  VFMSUBADD213PHZrk,
  VFMSUBADD213PHZrkz,
  VFMSUBADD213PSYm,
  VFMSUBADD213PSYr,
  VFMSUBADD213PSZ128m,
  VFMSUBADD213PSZ128mb,
  VFMSUBADD213PSZ128mbk,
  VFMSUBADD213PSZ128mbkz,
  VFMSUBADD213PSZ128mk,
  VFMSUBADD213PSZ128mkz,
  VFMSUBADD213PSZ128r,
  VFMSUBADD213PSZ128rk,
  VFMSUBADD213PSZ128rkz,
  VFMSUBADD213PSZ256m,
  VFMSUBADD213PSZ256mb,
  VFMSUBADD213PSZ256mbk,
  VFMSUBADD213PSZ256mbkz,
  VFMSUBADD213PSZ256mk,
  VFMSUBADD213PSZ256mkz,
  VFMSUBADD213PSZ256r,
  VFMSUBADD213PSZ256rk,
  VFMSUBADD213PSZ256rkz,
  VFMSUBADD213PSZm,
  VFMSUBADD213PSZmb,
  VFMSUBADD213PSZmbk,
  VFMSUBADD213PSZmbkz,
  VFMSUBADD213PSZmk,
  VFMSUBADD213PSZmkz,
  VFMSUBADD213PSZr,
  VFMSUBADD213PSZrb,
  VFMSUBADD213PSZrbk,
  VFMSUBADD213PSZrbkz,
  VFMSUBADD213PSZrk,
  VFMSUBADD213PSZrkz,
  VFMSUBADD213PSm,
  VFMSUBADD213PSr,
  VFMSUBADD231PDYm,
  VFMSUBADD231PDYr,
  VFMSUBADD231PDZ128m,
  VFMSUBADD231PDZ128mb,
  VFMSUBADD231PDZ128mbk,
  VFMSUBADD231PDZ128mbkz,
  VFMSUBADD231PDZ128mk,
  VFMSUBADD231PDZ128mkz,
  VFMSUBADD231PDZ128r,
  VFMSUBADD231PDZ128rk,
  VFMSUBADD231PDZ128rkz,
  VFMSUBADD231PDZ256m,
  VFMSUBADD231PDZ256mb,
  VFMSUBADD231PDZ256mbk,
  VFMSUBADD231PDZ256mbkz,
  VFMSUBADD231PDZ256mk,
  VFMSUBADD231PDZ256mkz,
  VFMSUBADD231PDZ256r,
  VFMSUBADD231PDZ256rk,
  VFMSUBADD231PDZ256rkz,
  VFMSUBADD231PDZm,
  VFMSUBADD231PDZmb,
  VFMSUBADD231PDZmbk,
  VFMSUBADD231PDZmbkz,
  VFMSUBADD231PDZmk,
  VFMSUBADD231PDZmkz,
  VFMSUBADD231PDZr,
  VFMSUBADD231PDZrb,
  VFMSUBADD231PDZrbk,
  VFMSUBADD231PDZrbkz,
  VFMSUBADD231PDZrk,
  VFMSUBADD231PDZrkz,
  VFMSUBADD231PDm,
  VFMSUBADD231PDr,
  VFMSUBADD231PHZ128m,
  VFMSUBADD231PHZ128mb,
  VFMSUBADD231PHZ128mbk,
  VFMSUBADD231PHZ128mbkz,
  VFMSUBADD231PHZ128mk,
  VFMSUBADD231PHZ128mkz,
  VFMSUBADD231PHZ128r,
  VFMSUBADD231PHZ128rk,
  VFMSUBADD231PHZ128rkz,
  VFMSUBADD231PHZ256m,
  VFMSUBADD231PHZ256mb,
  VFMSUBADD231PHZ256mbk,
  VFMSUBADD231PHZ256mbkz,
  VFMSUBADD231PHZ256mk,
  VFMSUBADD231PHZ256mkz,
  VFMSUBADD231PHZ256r,
  VFMSUBADD231PHZ256rk,
  VFMSUBADD231PHZ256rkz,
  VFMSUBADD231PHZm,
  VFMSUBADD231PHZmb,
  VFMSUBADD231PHZmbk,
  VFMSUBADD231PHZmbkz,
  VFMSUBADD231PHZmk,
  VFMSUBADD231PHZmkz,
  VFMSUBADD231PHZr,
  VFMSUBADD231PHZrb,
  VFMSUBADD231PHZrbk,
  VFMSUBADD231PHZrbkz,
  VFMSUBADD231PHZrk,
  VFMSUBADD231PHZrkz,
  VFMSUBADD231PSYm,
  VFMSUBADD231PSYr,
  VFMSUBADD231PSZ128m,
  VFMSUBADD231PSZ128mb,
  VFMSUBADD231PSZ128mbk,
  VFMSUBADD231PSZ128mbkz,
  VFMSUBADD231PSZ128mk,
  VFMSUBADD231PSZ128mkz,
  VFMSUBADD231PSZ128r,
  VFMSUBADD231PSZ128rk,
  VFMSUBADD231PSZ128rkz,
  VFMSUBADD231PSZ256m,
  VFMSUBADD231PSZ256mb,
  VFMSUBADD231PSZ256mbk,
  VFMSUBADD231PSZ256mbkz,
  VFMSUBADD231PSZ256mk,
  VFMSUBADD231PSZ256mkz,
  VFMSUBADD231PSZ256r,
  VFMSUBADD231PSZ256rk,
  VFMSUBADD231PSZ256rkz,
  VFMSUBADD231PSZm,
  VFMSUBADD231PSZmb,
  VFMSUBADD231PSZmbk,
  VFMSUBADD231PSZmbkz,
  VFMSUBADD231PSZmk,
  VFMSUBADD231PSZmkz,
  VFMSUBADD231PSZr,
  VFMSUBADD231PSZrb,
  VFMSUBADD231PSZrbk,
  VFMSUBADD231PSZrbkz,
  VFMSUBADD231PSZrk,
  VFMSUBADD231PSZrkz,
  VFMSUBADD231PSm,
  VFMSUBADD231PSr,
  VFMSUBADDPD4Ymr,
  VFMSUBADDPD4Yrm,
  VFMSUBADDPD4Yrr,
  VFMSUBADDPD4Yrr_REV,
  VFMSUBADDPD4mr,
  VFMSUBADDPD4rm,
  VFMSUBADDPD4rr,
  VFMSUBADDPD4rr_REV,
  VFMSUBADDPS4Ymr,
  VFMSUBADDPS4Yrm,
  VFMSUBADDPS4Yrr,
  VFMSUBADDPS4Yrr_REV,
  VFMSUBADDPS4mr,
  VFMSUBADDPS4rm,
  VFMSUBADDPS4rr,
  VFMSUBADDPS4rr_REV,
  VFMSUBPD4Ymr,
  VFMSUBPD4Yrm,
  VFMSUBPD4Yrr,
  VFMSUBPD4Yrr_REV,
  VFMSUBPD4mr,
  VFMSUBPD4rm,
  VFMSUBPD4rr,
  VFMSUBPD4rr_REV,
  VFMSUBPS4Ymr,
  VFMSUBPS4Yrm,
  VFMSUBPS4Yrr,
  VFMSUBPS4Yrr_REV,
  VFMSUBPS4mr,
  VFMSUBPS4rm,
  VFMSUBPS4rr,
  VFMSUBPS4rr_REV,
  VFMSUBSD4mr,
  VFMSUBSD4mr_Int,
  VFMSUBSD4rm,
  VFMSUBSD4rm_Int,
  VFMSUBSD4rr,
  VFMSUBSD4rr_Int,
  VFMSUBSD4rr_Int_REV,
  VFMSUBSD4rr_REV,
  VFMSUBSS4mr,
  VFMSUBSS4mr_Int,
  VFMSUBSS4rm,
  VFMSUBSS4rm_Int,
  VFMSUBSS4rr,
  VFMSUBSS4rr_Int,
  VFMSUBSS4rr_Int_REV,
  VFMSUBSS4rr_REV,
  VFMULCPHZ128rm,
  VFMULCPHZ128rmb,
  VFMULCPHZ128rmbk,
  VFMULCPHZ128rmbkz,
  VFMULCPHZ128rmk,
  VFMULCPHZ128rmkz,
  VFMULCPHZ128rr,
  VFMULCPHZ128rrk,
  VFMULCPHZ128rrkz,
  VFMULCPHZ256rm,
  VFMULCPHZ256rmb,
  VFMULCPHZ256rmbk,
  VFMULCPHZ256rmbkz,
  VFMULCPHZ256rmk,
  VFMULCPHZ256rmkz,
  VFMULCPHZ256rr,
  VFMULCPHZ256rrk,
  VFMULCPHZ256rrkz,
  VFMULCPHZrm,
  VFMULCPHZrmb,
  VFMULCPHZrmbk,
  VFMULCPHZrmbkz,
  VFMULCPHZrmk,
  VFMULCPHZrmkz,
  VFMULCPHZrr,
  VFMULCPHZrrb,
  VFMULCPHZrrbk,
  VFMULCPHZrrbkz,
  VFMULCPHZrrk,
  VFMULCPHZrrkz,
  VFMULCSHZrm,
  VFMULCSHZrmk,
  VFMULCSHZrmkz,
  VFMULCSHZrr,
  VFMULCSHZrrb,
  VFMULCSHZrrbk,
  VFMULCSHZrrbkz,
  VFMULCSHZrrk,
  VFMULCSHZrrkz,
  VFNMADD132BF16Z128m,
  VFNMADD132BF16Z128mb,
  VFNMADD132BF16Z128mbk,
  VFNMADD132BF16Z128mbkz,
  VFNMADD132BF16Z128mk,
  VFNMADD132BF16Z128mkz,
  VFNMADD132BF16Z128r,
  VFNMADD132BF16Z128rk,
  VFNMADD132BF16Z128rkz,
  VFNMADD132BF16Z256m,
  VFNMADD132BF16Z256mb,
  VFNMADD132BF16Z256mbk,
  VFNMADD132BF16Z256mbkz,
  VFNMADD132BF16Z256mk,
  VFNMADD132BF16Z256mkz,
  VFNMADD132BF16Z256r,
  VFNMADD132BF16Z256rk,
  VFNMADD132BF16Z256rkz,
  VFNMADD132BF16Zm,
  VFNMADD132BF16Zmb,
  VFNMADD132BF16Zmbk,
  VFNMADD132BF16Zmbkz,
  VFNMADD132BF16Zmk,
  VFNMADD132BF16Zmkz,
  VFNMADD132BF16Zr,
  VFNMADD132BF16Zrk,
  VFNMADD132BF16Zrkz,
  VFNMADD132PDYm,
  VFNMADD132PDYr,
  VFNMADD132PDZ128m,
  VFNMADD132PDZ128mb,
  VFNMADD132PDZ128mbk,
  VFNMADD132PDZ128mbkz,
  VFNMADD132PDZ128mk,
  VFNMADD132PDZ128mkz,
  VFNMADD132PDZ128r,
  VFNMADD132PDZ128rk,
  VFNMADD132PDZ128rkz,
  VFNMADD132PDZ256m,
  VFNMADD132PDZ256mb,
  VFNMADD132PDZ256mbk,
  VFNMADD132PDZ256mbkz,
  VFNMADD132PDZ256mk,
  VFNMADD132PDZ256mkz,
  VFNMADD132PDZ256r,
  VFNMADD132PDZ256rk,
  VFNMADD132PDZ256rkz,
  VFNMADD132PDZm,
  VFNMADD132PDZmb,
  VFNMADD132PDZmbk,
  VFNMADD132PDZmbkz,
  VFNMADD132PDZmk,
  VFNMADD132PDZmkz,
  VFNMADD132PDZr,
  VFNMADD132PDZrb,
  VFNMADD132PDZrbk,
  VFNMADD132PDZrbkz,
  VFNMADD132PDZrk,
  VFNMADD132PDZrkz,
  VFNMADD132PDm,
  VFNMADD132PDr,
  VFNMADD132PHZ128m,
  VFNMADD132PHZ128mb,
  VFNMADD132PHZ128mbk,
  VFNMADD132PHZ128mbkz,
  VFNMADD132PHZ128mk,
  VFNMADD132PHZ128mkz,
  VFNMADD132PHZ128r,
  VFNMADD132PHZ128rk,
  VFNMADD132PHZ128rkz,
  VFNMADD132PHZ256m,
  VFNMADD132PHZ256mb,
  VFNMADD132PHZ256mbk,
  VFNMADD132PHZ256mbkz,
  VFNMADD132PHZ256mk,
  VFNMADD132PHZ256mkz,
  VFNMADD132PHZ256r,
  VFNMADD132PHZ256rk,
  VFNMADD132PHZ256rkz,
  VFNMADD132PHZm,
  VFNMADD132PHZmb,
  VFNMADD132PHZmbk,
  VFNMADD132PHZmbkz,
  VFNMADD132PHZmk,
  VFNMADD132PHZmkz,
  VFNMADD132PHZr,
  VFNMADD132PHZrb,
  VFNMADD132PHZrbk,
  VFNMADD132PHZrbkz,
  VFNMADD132PHZrk,
  VFNMADD132PHZrkz,
  VFNMADD132PSYm,
  VFNMADD132PSYr,
  VFNMADD132PSZ128m,
  VFNMADD132PSZ128mb,
  VFNMADD132PSZ128mbk,
  VFNMADD132PSZ128mbkz,
  VFNMADD132PSZ128mk,
  VFNMADD132PSZ128mkz,
  VFNMADD132PSZ128r,
  VFNMADD132PSZ128rk,
  VFNMADD132PSZ128rkz,
  VFNMADD132PSZ256m,
  VFNMADD132PSZ256mb,
  VFNMADD132PSZ256mbk,
  VFNMADD132PSZ256mbkz,
  VFNMADD132PSZ256mk,
  VFNMADD132PSZ256mkz,
  VFNMADD132PSZ256r,
  VFNMADD132PSZ256rk,
  VFNMADD132PSZ256rkz,
  VFNMADD132PSZm,
  VFNMADD132PSZmb,
  VFNMADD132PSZmbk,
  VFNMADD132PSZmbkz,
  VFNMADD132PSZmk,
  VFNMADD132PSZmkz,
  VFNMADD132PSZr,
  VFNMADD132PSZrb,
  VFNMADD132PSZrbk,
  VFNMADD132PSZrbkz,
  VFNMADD132PSZrk,
  VFNMADD132PSZrkz,
  VFNMADD132PSm,
  VFNMADD132PSr,
  VFNMADD132SDZm,
  VFNMADD132SDZm_Int,
  VFNMADD132SDZmk_Int,
  VFNMADD132SDZmkz_Int,
  VFNMADD132SDZr,
  VFNMADD132SDZr_Int,
  VFNMADD132SDZrb,
  VFNMADD132SDZrb_Int,
  VFNMADD132SDZrbk_Int,
  VFNMADD132SDZrbkz_Int,
  VFNMADD132SDZrk_Int,
  VFNMADD132SDZrkz_Int,
  VFNMADD132SDm,
  VFNMADD132SDm_Int,
  VFNMADD132SDr,
  VFNMADD132SDr_Int,
  VFNMADD132SHZm,
  VFNMADD132SHZm_Int,
  VFNMADD132SHZmk_Int,
  VFNMADD132SHZmkz_Int,
  VFNMADD132SHZr,
  VFNMADD132SHZr_Int,
  VFNMADD132SHZrb,
  VFNMADD132SHZrb_Int,
  VFNMADD132SHZrbk_Int,
  VFNMADD132SHZrbkz_Int,
  VFNMADD132SHZrk_Int,
  VFNMADD132SHZrkz_Int,
  VFNMADD132SSZm,
  VFNMADD132SSZm_Int,
  VFNMADD132SSZmk_Int,
  VFNMADD132SSZmkz_Int,
  VFNMADD132SSZr,
  VFNMADD132SSZr_Int,
  VFNMADD132SSZrb,
  VFNMADD132SSZrb_Int,
  VFNMADD132SSZrbk_Int,
  VFNMADD132SSZrbkz_Int,
  VFNMADD132SSZrk_Int,
  VFNMADD132SSZrkz_Int,
  VFNMADD132SSm,
  VFNMADD132SSm_Int,
  VFNMADD132SSr,
  VFNMADD132SSr_Int,
  VFNMADD213BF16Z128m,
  VFNMADD213BF16Z128mb,
  VFNMADD213BF16Z128mbk,
  VFNMADD213BF16Z128mbkz,
  VFNMADD213BF16Z128mk,
  VFNMADD213BF16Z128mkz,
  VFNMADD213BF16Z128r,
  VFNMADD213BF16Z128rk,
  VFNMADD213BF16Z128rkz,
  VFNMADD213BF16Z256m,
  VFNMADD213BF16Z256mb,
  VFNMADD213BF16Z256mbk,
  VFNMADD213BF16Z256mbkz,
  VFNMADD213BF16Z256mk,
  VFNMADD213BF16Z256mkz,
  VFNMADD213BF16Z256r,
  VFNMADD213BF16Z256rk,
  VFNMADD213BF16Z256rkz,
  VFNMADD213BF16Zm,
  VFNMADD213BF16Zmb,
  VFNMADD213BF16Zmbk,
  VFNMADD213BF16Zmbkz,
  VFNMADD213BF16Zmk,
  VFNMADD213BF16Zmkz,
  VFNMADD213BF16Zr,
  VFNMADD213BF16Zrk,
  VFNMADD213BF16Zrkz,
  VFNMADD213PDYm,
  VFNMADD213PDYr,
  VFNMADD213PDZ128m,
  VFNMADD213PDZ128mb,
  VFNMADD213PDZ128mbk,
  VFNMADD213PDZ128mbkz,
  VFNMADD213PDZ128mk,
  VFNMADD213PDZ128mkz,
  VFNMADD213PDZ128r,
  VFNMADD213PDZ128rk,
  VFNMADD213PDZ128rkz,
  VFNMADD213PDZ256m,
  VFNMADD213PDZ256mb,
  VFNMADD213PDZ256mbk,
  VFNMADD213PDZ256mbkz,
  VFNMADD213PDZ256mk,
  VFNMADD213PDZ256mkz,
  VFNMADD213PDZ256r,
  VFNMADD213PDZ256rk,
  VFNMADD213PDZ256rkz,
  VFNMADD213PDZm,
  VFNMADD213PDZmb,
  VFNMADD213PDZmbk,
  VFNMADD213PDZmbkz,
  VFNMADD213PDZmk,
  VFNMADD213PDZmkz,
  VFNMADD213PDZr,
  VFNMADD213PDZrb,
  VFNMADD213PDZrbk,
  VFNMADD213PDZrbkz,
  VFNMADD213PDZrk,
  VFNMADD213PDZrkz,
  VFNMADD213PDm,
  VFNMADD213PDr,
  VFNMADD213PHZ128m,
  VFNMADD213PHZ128mb,
  VFNMADD213PHZ128mbk,
  VFNMADD213PHZ128mbkz,
  VFNMADD213PHZ128mk,
  VFNMADD213PHZ128mkz,
  VFNMADD213PHZ128r,
  VFNMADD213PHZ128rk,
  VFNMADD213PHZ128rkz,
  VFNMADD213PHZ256m,
  VFNMADD213PHZ256mb,
  VFNMADD213PHZ256mbk,
  VFNMADD213PHZ256mbkz,
  VFNMADD213PHZ256mk,
  VFNMADD213PHZ256mkz,
  VFNMADD213PHZ256r,
  VFNMADD213PHZ256rk,
  VFNMADD213PHZ256rkz,
  VFNMADD213PHZm,
  VFNMADD213PHZmb,
  VFNMADD213PHZmbk,
  VFNMADD213PHZmbkz,
  VFNMADD213PHZmk,
  VFNMADD213PHZmkz,
  VFNMADD213PHZr,
  VFNMADD213PHZrb,
  VFNMADD213PHZrbk,
  VFNMADD213PHZrbkz,
  VFNMADD213PHZrk,
  VFNMADD213PHZrkz,
  VFNMADD213PSYm,
  VFNMADD213PSYr,
  VFNMADD213PSZ128m,
  VFNMADD213PSZ128mb,
  VFNMADD213PSZ128mbk,
  VFNMADD213PSZ128mbkz,
  VFNMADD213PSZ128mk,
  VFNMADD213PSZ128mkz,
  VFNMADD213PSZ128r,
  VFNMADD213PSZ128rk,
  VFNMADD213PSZ128rkz,
  VFNMADD213PSZ256m,
  VFNMADD213PSZ256mb,
  VFNMADD213PSZ256mbk,
  VFNMADD213PSZ256mbkz,
  VFNMADD213PSZ256mk,
  VFNMADD213PSZ256mkz,
  VFNMADD213PSZ256r,
  VFNMADD213PSZ256rk,
  VFNMADD213PSZ256rkz,
  VFNMADD213PSZm,
  VFNMADD213PSZmb,
  VFNMADD213PSZmbk,
  VFNMADD213PSZmbkz,
  VFNMADD213PSZmk,
  VFNMADD213PSZmkz,
  VFNMADD213PSZr,
  VFNMADD213PSZrb,
  VFNMADD213PSZrbk,
  VFNMADD213PSZrbkz,
  VFNMADD213PSZrk,
  VFNMADD213PSZrkz,
  VFNMADD213PSm,
  VFNMADD213PSr,
  VFNMADD213SDZm,
  VFNMADD213SDZm_Int,
  VFNMADD213SDZmk_Int,
  VFNMADD213SDZmkz_Int,
  VFNMADD213SDZr,
  VFNMADD213SDZr_Int,
  VFNMADD213SDZrb,
  VFNMADD213SDZrb_Int,
  VFNMADD213SDZrbk_Int,
  VFNMADD213SDZrbkz_Int,
  VFNMADD213SDZrk_Int,
  VFNMADD213SDZrkz_Int,
  VFNMADD213SDm,
  VFNMADD213SDm_Int,
  VFNMADD213SDr,
  VFNMADD213SDr_Int,
  VFNMADD213SHZm,
  VFNMADD213SHZm_Int,
  VFNMADD213SHZmk_Int,
  VFNMADD213SHZmkz_Int,
  VFNMADD213SHZr,
  VFNMADD213SHZr_Int,
  VFNMADD213SHZrb,
  VFNMADD213SHZrb_Int,
  VFNMADD213SHZrbk_Int,
  VFNMADD213SHZrbkz_Int,
  VFNMADD213SHZrk_Int,
  VFNMADD213SHZrkz_Int,
  VFNMADD213SSZm,
  VFNMADD213SSZm_Int,
  VFNMADD213SSZmk_Int,
  VFNMADD213SSZmkz_Int,
  VFNMADD213SSZr,
  VFNMADD213SSZr_Int,
  VFNMADD213SSZrb,
  VFNMADD213SSZrb_Int,
  VFNMADD213SSZrbk_Int,
  VFNMADD213SSZrbkz_Int,
  VFNMADD213SSZrk_Int,
  VFNMADD213SSZrkz_Int,
  VFNMADD213SSm,
  VFNMADD213SSm_Int,
  VFNMADD213SSr,
  VFNMADD213SSr_Int,
  VFNMADD231BF16Z128m,
  VFNMADD231BF16Z128mb,
  VFNMADD231BF16Z128mbk,
  VFNMADD231BF16Z128mbkz,
  VFNMADD231BF16Z128mk,
  VFNMADD231BF16Z128mkz,
  VFNMADD231BF16Z128r,
  VFNMADD231BF16Z128rk,
  VFNMADD231BF16Z128rkz,
  VFNMADD231BF16Z256m,
  VFNMADD231BF16Z256mb,
  VFNMADD231BF16Z256mbk,
  VFNMADD231BF16Z256mbkz,
  VFNMADD231BF16Z256mk,
  VFNMADD231BF16Z256mkz,
  VFNMADD231BF16Z256r,
  VFNMADD231BF16Z256rk,
  VFNMADD231BF16Z256rkz,
  VFNMADD231BF16Zm,
  VFNMADD231BF16Zmb,
  VFNMADD231BF16Zmbk,
  VFNMADD231BF16Zmbkz,
  VFNMADD231BF16Zmk,
  VFNMADD231BF16Zmkz,
  VFNMADD231BF16Zr,
  VFNMADD231BF16Zrk,
  VFNMADD231BF16Zrkz,
  VFNMADD231PDYm,
  VFNMADD231PDYr,
  VFNMADD231PDZ128m,
  VFNMADD231PDZ128mb,
  VFNMADD231PDZ128mbk,
  VFNMADD231PDZ128mbkz,
  VFNMADD231PDZ128mk,
  VFNMADD231PDZ128mkz,
  VFNMADD231PDZ128r,
  VFNMADD231PDZ128rk,
  VFNMADD231PDZ128rkz,
  VFNMADD231PDZ256m,
  VFNMADD231PDZ256mb,
  VFNMADD231PDZ256mbk,
  VFNMADD231PDZ256mbkz,
  VFNMADD231PDZ256mk,
  VFNMADD231PDZ256mkz,
  VFNMADD231PDZ256r,
  VFNMADD231PDZ256rk,
  VFNMADD231PDZ256rkz,
  VFNMADD231PDZm,
  VFNMADD231PDZmb,
  VFNMADD231PDZmbk,
  VFNMADD231PDZmbkz,
  VFNMADD231PDZmk,
  VFNMADD231PDZmkz,
  VFNMADD231PDZr,
  VFNMADD231PDZrb,
  VFNMADD231PDZrbk,
  VFNMADD231PDZrbkz,
  VFNMADD231PDZrk,
  VFNMADD231PDZrkz,
  VFNMADD231PDm,
  VFNMADD231PDr,
  VFNMADD231PHZ128m,
  VFNMADD231PHZ128mb,
  VFNMADD231PHZ128mbk,
  VFNMADD231PHZ128mbkz,
  VFNMADD231PHZ128mk,
  VFNMADD231PHZ128mkz,
  VFNMADD231PHZ128r,
  VFNMADD231PHZ128rk,
  VFNMADD231PHZ128rkz,
  VFNMADD231PHZ256m,
  VFNMADD231PHZ256mb,
  VFNMADD231PHZ256mbk,
  VFNMADD231PHZ256mbkz,
  VFNMADD231PHZ256mk,
  VFNMADD231PHZ256mkz,
  VFNMADD231PHZ256r,
  VFNMADD231PHZ256rk,
  VFNMADD231PHZ256rkz,
  VFNMADD231PHZm,
  VFNMADD231PHZmb,
  VFNMADD231PHZmbk,
  VFNMADD231PHZmbkz,
  VFNMADD231PHZmk,
  VFNMADD231PHZmkz,
  VFNMADD231PHZr,
  VFNMADD231PHZrb,
  VFNMADD231PHZrbk,
  VFNMADD231PHZrbkz,
  VFNMADD231PHZrk,
  VFNMADD231PHZrkz,
  VFNMADD231PSYm,
  VFNMADD231PSYr,
  VFNMADD231PSZ128m,
  VFNMADD231PSZ128mb,
  VFNMADD231PSZ128mbk,
  VFNMADD231PSZ128mbkz,
  VFNMADD231PSZ128mk,
  VFNMADD231PSZ128mkz,
  VFNMADD231PSZ128r,
  VFNMADD231PSZ128rk,
  VFNMADD231PSZ128rkz,
  VFNMADD231PSZ256m,
  VFNMADD231PSZ256mb,
  VFNMADD231PSZ256mbk,
  VFNMADD231PSZ256mbkz,
  VFNMADD231PSZ256mk,
  VFNMADD231PSZ256mkz,
  VFNMADD231PSZ256r,
  VFNMADD231PSZ256rk,
  VFNMADD231PSZ256rkz,
  VFNMADD231PSZm,
  VFNMADD231PSZmb,
  VFNMADD231PSZmbk,
  VFNMADD231PSZmbkz,
  VFNMADD231PSZmk,
  VFNMADD231PSZmkz,
  VFNMADD231PSZr,
  VFNMADD231PSZrb,
  VFNMADD231PSZrbk,
  VFNMADD231PSZrbkz,
  VFNMADD231PSZrk,
  VFNMADD231PSZrkz,
  VFNMADD231PSm,
  VFNMADD231PSr,
  VFNMADD231SDZm,
  VFNMADD231SDZm_Int,
  VFNMADD231SDZmk_Int,
  VFNMADD231SDZmkz_Int,
  VFNMADD231SDZr,
  VFNMADD231SDZr_Int,
  VFNMADD231SDZrb,
  VFNMADD231SDZrb_Int,
  VFNMADD231SDZrbk_Int,
  VFNMADD231SDZrbkz_Int,
  VFNMADD231SDZrk_Int,
  VFNMADD231SDZrkz_Int,
  VFNMADD231SDm,
  VFNMADD231SDm_Int,
  VFNMADD231SDr,
  VFNMADD231SDr_Int,
  VFNMADD231SHZm,
  VFNMADD231SHZm_Int,
  VFNMADD231SHZmk_Int,
  VFNMADD231SHZmkz_Int,
  VFNMADD231SHZr,
  VFNMADD231SHZr_Int,
  VFNMADD231SHZrb,
  VFNMADD231SHZrb_Int,
  VFNMADD231SHZrbk_Int,
  VFNMADD231SHZrbkz_Int,
  VFNMADD231SHZrk_Int,
  VFNMADD231SHZrkz_Int,
  VFNMADD231SSZm,
  VFNMADD231SSZm_Int,
  VFNMADD231SSZmk_Int,
  VFNMADD231SSZmkz_Int,
  VFNMADD231SSZr,
  VFNMADD231SSZr_Int,
  VFNMADD231SSZrb,
  VFNMADD231SSZrb_Int,
  VFNMADD231SSZrbk_Int,
  VFNMADD231SSZrbkz_Int,
  VFNMADD231SSZrk_Int,
  VFNMADD231SSZrkz_Int,
  VFNMADD231SSm,
  VFNMADD231SSm_Int,
  VFNMADD231SSr,
  VFNMADD231SSr_Int,
  VFNMADDPD4Ymr,
  VFNMADDPD4Yrm,
  VFNMADDPD4Yrr,
  VFNMADDPD4Yrr_REV,
  VFNMADDPD4mr,
  VFNMADDPD4rm,
  VFNMADDPD4rr,
  VFNMADDPD4rr_REV,
  VFNMADDPS4Ymr,
  VFNMADDPS4Yrm,
  VFNMADDPS4Yrr,
  VFNMADDPS4Yrr_REV,
  VFNMADDPS4mr,
  VFNMADDPS4rm,
  VFNMADDPS4rr,
  VFNMADDPS4rr_REV,
  VFNMADDSD4mr,
  VFNMADDSD4mr_Int,
  VFNMADDSD4rm,
  VFNMADDSD4rm_Int,
  VFNMADDSD4rr,
  VFNMADDSD4rr_Int,
  VFNMADDSD4rr_Int_REV,
  VFNMADDSD4rr_REV,
  VFNMADDSS4mr,
  VFNMADDSS4mr_Int,
  VFNMADDSS4rm,
  VFNMADDSS4rm_Int,
  VFNMADDSS4rr,
  VFNMADDSS4rr_Int,
  VFNMADDSS4rr_Int_REV,
  VFNMADDSS4rr_REV,
  VFNMSUB132BF16Z128m,
  VFNMSUB132BF16Z128mb,
  VFNMSUB132BF16Z128mbk,
  VFNMSUB132BF16Z128mbkz,
  VFNMSUB132BF16Z128mk,
  VFNMSUB132BF16Z128mkz,
  VFNMSUB132BF16Z128r,
  VFNMSUB132BF16Z128rk,
  VFNMSUB132BF16Z128rkz,
  VFNMSUB132BF16Z256m,
  VFNMSUB132BF16Z256mb,
  VFNMSUB132BF16Z256mbk,
  VFNMSUB132BF16Z256mbkz,
  VFNMSUB132BF16Z256mk,
  VFNMSUB132BF16Z256mkz,
  VFNMSUB132BF16Z256r,
  VFNMSUB132BF16Z256rk,
  VFNMSUB132BF16Z256rkz,
  VFNMSUB132BF16Zm,
  VFNMSUB132BF16Zmb,
  VFNMSUB132BF16Zmbk,
  VFNMSUB132BF16Zmbkz,
  VFNMSUB132BF16Zmk,
  VFNMSUB132BF16Zmkz,
  VFNMSUB132BF16Zr,
  VFNMSUB132BF16Zrk,
  VFNMSUB132BF16Zrkz,
  VFNMSUB132PDYm,
  VFNMSUB132PDYr,
  VFNMSUB132PDZ128m,
  VFNMSUB132PDZ128mb,
  VFNMSUB132PDZ128mbk,
  VFNMSUB132PDZ128mbkz,
  VFNMSUB132PDZ128mk,
  VFNMSUB132PDZ128mkz,
  VFNMSUB132PDZ128r,
  VFNMSUB132PDZ128rk,
  VFNMSUB132PDZ128rkz,
  VFNMSUB132PDZ256m,
  VFNMSUB132PDZ256mb,
  VFNMSUB132PDZ256mbk,
  VFNMSUB132PDZ256mbkz,
  VFNMSUB132PDZ256mk,
  VFNMSUB132PDZ256mkz,
  VFNMSUB132PDZ256r,
  VFNMSUB132PDZ256rk,
  VFNMSUB132PDZ256rkz,
  VFNMSUB132PDZm,
  VFNMSUB132PDZmb,
  VFNMSUB132PDZmbk,
  VFNMSUB132PDZmbkz,
  VFNMSUB132PDZmk,
  VFNMSUB132PDZmkz,
  VFNMSUB132PDZr,
  VFNMSUB132PDZrb,
  VFNMSUB132PDZrbk,
  VFNMSUB132PDZrbkz,
  VFNMSUB132PDZrk,
  VFNMSUB132PDZrkz,
  VFNMSUB132PDm,
  VFNMSUB132PDr,
  VFNMSUB132PHZ128m,
  VFNMSUB132PHZ128mb,
  VFNMSUB132PHZ128mbk,
  VFNMSUB132PHZ128mbkz,
  VFNMSUB132PHZ128mk,
  VFNMSUB132PHZ128mkz,
  VFNMSUB132PHZ128r,
  VFNMSUB132PHZ128rk,
  VFNMSUB132PHZ128rkz,
  VFNMSUB132PHZ256m,
  VFNMSUB132PHZ256mb,
  VFNMSUB132PHZ256mbk,
  VFNMSUB132PHZ256mbkz,
  VFNMSUB132PHZ256mk,
  VFNMSUB132PHZ256mkz,
  VFNMSUB132PHZ256r,
  VFNMSUB132PHZ256rk,
  VFNMSUB132PHZ256rkz,
  VFNMSUB132PHZm,
  VFNMSUB132PHZmb,
  VFNMSUB132PHZmbk,
  VFNMSUB132PHZmbkz,
  VFNMSUB132PHZmk,
  VFNMSUB132PHZmkz,
  VFNMSUB132PHZr,
  VFNMSUB132PHZrb,
  VFNMSUB132PHZrbk,
  VFNMSUB132PHZrbkz,
  VFNMSUB132PHZrk,
  VFNMSUB132PHZrkz,
  VFNMSUB132PSYm,
  VFNMSUB132PSYr,
  VFNMSUB132PSZ128m,
  VFNMSUB132PSZ128mb,
  VFNMSUB132PSZ128mbk,
  VFNMSUB132PSZ128mbkz,
  VFNMSUB132PSZ128mk,
  VFNMSUB132PSZ128mkz,
  VFNMSUB132PSZ128r,
  VFNMSUB132PSZ128rk,
  VFNMSUB132PSZ128rkz,
  VFNMSUB132PSZ256m,
  VFNMSUB132PSZ256mb,
  VFNMSUB132PSZ256mbk,
  VFNMSUB132PSZ256mbkz,
  VFNMSUB132PSZ256mk,
  VFNMSUB132PSZ256mkz,
  VFNMSUB132PSZ256r,
  VFNMSUB132PSZ256rk,
  VFNMSUB132PSZ256rkz,
  VFNMSUB132PSZm,
  VFNMSUB132PSZmb,
  VFNMSUB132PSZmbk,
  VFNMSUB132PSZmbkz,
  VFNMSUB132PSZmk,
  VFNMSUB132PSZmkz,
  VFNMSUB132PSZr,
  VFNMSUB132PSZrb,
  VFNMSUB132PSZrbk,
  VFNMSUB132PSZrbkz,
  VFNMSUB132PSZrk,
  VFNMSUB132PSZrkz,
  VFNMSUB132PSm,
  VFNMSUB132PSr,
  VFNMSUB132SDZm,
  VFNMSUB132SDZm_Int,
  VFNMSUB132SDZmk_Int,
  VFNMSUB132SDZmkz_Int,
  VFNMSUB132SDZr,
  VFNMSUB132SDZr_Int,
  VFNMSUB132SDZrb,
  VFNMSUB132SDZrb_Int,
  VFNMSUB132SDZrbk_Int,
  VFNMSUB132SDZrbkz_Int,
  VFNMSUB132SDZrk_Int,
  VFNMSUB132SDZrkz_Int,
  VFNMSUB132SDm,
  VFNMSUB132SDm_Int,
  VFNMSUB132SDr,
  VFNMSUB132SDr_Int,
  VFNMSUB132SHZm,
  VFNMSUB132SHZm_Int,
  VFNMSUB132SHZmk_Int,
  VFNMSUB132SHZmkz_Int,
  VFNMSUB132SHZr,
  VFNMSUB132SHZr_Int,
  VFNMSUB132SHZrb,
  VFNMSUB132SHZrb_Int,
  VFNMSUB132SHZrbk_Int,
  VFNMSUB132SHZrbkz_Int,
  VFNMSUB132SHZrk_Int,
  VFNMSUB132SHZrkz_Int,
  VFNMSUB132SSZm,
  VFNMSUB132SSZm_Int,
  VFNMSUB132SSZmk_Int,
  VFNMSUB132SSZmkz_Int,
  VFNMSUB132SSZr,
  VFNMSUB132SSZr_Int,
  VFNMSUB132SSZrb,
  VFNMSUB132SSZrb_Int,
  VFNMSUB132SSZrbk_Int,
  VFNMSUB132SSZrbkz_Int,
  VFNMSUB132SSZrk_Int,
  VFNMSUB132SSZrkz_Int,
  VFNMSUB132SSm,
  VFNMSUB132SSm_Int,
  VFNMSUB132SSr,
  VFNMSUB132SSr_Int,
  VFNMSUB213BF16Z128m,
  VFNMSUB213BF16Z128mb,
  VFNMSUB213BF16Z128mbk,
  VFNMSUB213BF16Z128mbkz,
  VFNMSUB213BF16Z128mk,
  VFNMSUB213BF16Z128mkz,
  VFNMSUB213BF16Z128r,
  VFNMSUB213BF16Z128rk,
  VFNMSUB213BF16Z128rkz,
  VFNMSUB213BF16Z256m,
  VFNMSUB213BF16Z256mb,
  VFNMSUB213BF16Z256mbk,
  VFNMSUB213BF16Z256mbkz,
  VFNMSUB213BF16Z256mk,
  VFNMSUB213BF16Z256mkz,
  VFNMSUB213BF16Z256r,
  VFNMSUB213BF16Z256rk,
  VFNMSUB213BF16Z256rkz,
  VFNMSUB213BF16Zm,
  VFNMSUB213BF16Zmb,
  VFNMSUB213BF16Zmbk,
  VFNMSUB213BF16Zmbkz,
  VFNMSUB213BF16Zmk,
  VFNMSUB213BF16Zmkz,
  VFNMSUB213BF16Zr,
  VFNMSUB213BF16Zrk,
  VFNMSUB213BF16Zrkz,
  VFNMSUB213PDYm,
  VFNMSUB213PDYr,
  VFNMSUB213PDZ128m,
  VFNMSUB213PDZ128mb,
  VFNMSUB213PDZ128mbk,
  VFNMSUB213PDZ128mbkz,
  VFNMSUB213PDZ128mk,
  VFNMSUB213PDZ128mkz,
  VFNMSUB213PDZ128r,
  VFNMSUB213PDZ128rk,
  VFNMSUB213PDZ128rkz,
  VFNMSUB213PDZ256m,
  VFNMSUB213PDZ256mb,
  VFNMSUB213PDZ256mbk,
  VFNMSUB213PDZ256mbkz,
  VFNMSUB213PDZ256mk,
  VFNMSUB213PDZ256mkz,
  VFNMSUB213PDZ256r,
  VFNMSUB213PDZ256rk,
  VFNMSUB213PDZ256rkz,
  VFNMSUB213PDZm,
  VFNMSUB213PDZmb,
  VFNMSUB213PDZmbk,
  VFNMSUB213PDZmbkz,
  VFNMSUB213PDZmk,
  VFNMSUB213PDZmkz,
  VFNMSUB213PDZr,
  VFNMSUB213PDZrb,
  VFNMSUB213PDZrbk,
  VFNMSUB213PDZrbkz,
  VFNMSUB213PDZrk,
  VFNMSUB213PDZrkz,
  VFNMSUB213PDm,
  VFNMSUB213PDr,
  VFNMSUB213PHZ128m,
  VFNMSUB213PHZ128mb,
  VFNMSUB213PHZ128mbk,
  VFNMSUB213PHZ128mbkz,
  VFNMSUB213PHZ128mk,
  VFNMSUB213PHZ128mkz,
  VFNMSUB213PHZ128r,
  VFNMSUB213PHZ128rk,
  VFNMSUB213PHZ128rkz,
  VFNMSUB213PHZ256m,
  VFNMSUB213PHZ256mb,
  VFNMSUB213PHZ256mbk,
  VFNMSUB213PHZ256mbkz,
  VFNMSUB213PHZ256mk,
  VFNMSUB213PHZ256mkz,
  VFNMSUB213PHZ256r,
  VFNMSUB213PHZ256rk,
  VFNMSUB213PHZ256rkz,
  VFNMSUB213PHZm,
  VFNMSUB213PHZmb,
  VFNMSUB213PHZmbk,
  VFNMSUB213PHZmbkz,
  VFNMSUB213PHZmk,
  VFNMSUB213PHZmkz,
  VFNMSUB213PHZr,
  VFNMSUB213PHZrb,
  VFNMSUB213PHZrbk,
  VFNMSUB213PHZrbkz,
  VFNMSUB213PHZrk,
  VFNMSUB213PHZrkz,
  VFNMSUB213PSYm,
  VFNMSUB213PSYr,
  VFNMSUB213PSZ128m,
  VFNMSUB213PSZ128mb,
  VFNMSUB213PSZ128mbk,
  VFNMSUB213PSZ128mbkz,
  VFNMSUB213PSZ128mk,
  VFNMSUB213PSZ128mkz,
  VFNMSUB213PSZ128r,
  VFNMSUB213PSZ128rk,
  VFNMSUB213PSZ128rkz,
  VFNMSUB213PSZ256m,
  VFNMSUB213PSZ256mb,
  VFNMSUB213PSZ256mbk,
  VFNMSUB213PSZ256mbkz,
  VFNMSUB213PSZ256mk,
  VFNMSUB213PSZ256mkz,
  VFNMSUB213PSZ256r,
  VFNMSUB213PSZ256rk,
  VFNMSUB213PSZ256rkz,
  VFNMSUB213PSZm,
  VFNMSUB213PSZmb,
  VFNMSUB213PSZmbk,
  VFNMSUB213PSZmbkz,
  VFNMSUB213PSZmk,
  VFNMSUB213PSZmkz,
  VFNMSUB213PSZr,
  VFNMSUB213PSZrb,
  VFNMSUB213PSZrbk,
  VFNMSUB213PSZrbkz,
  VFNMSUB213PSZrk,
  VFNMSUB213PSZrkz,
  VFNMSUB213PSm,
  VFNMSUB213PSr,
  VFNMSUB213SDZm,
  VFNMSUB213SDZm_Int,
  VFNMSUB213SDZmk_Int,
  VFNMSUB213SDZmkz_Int,
  VFNMSUB213SDZr,
  VFNMSUB213SDZr_Int,
  VFNMSUB213SDZrb,
  VFNMSUB213SDZrb_Int,
  VFNMSUB213SDZrbk_Int,
  VFNMSUB213SDZrbkz_Int,
  VFNMSUB213SDZrk_Int,
  VFNMSUB213SDZrkz_Int,
  VFNMSUB213SDm,
  VFNMSUB213SDm_Int,
  VFNMSUB213SDr,
  VFNMSUB213SDr_Int,
  VFNMSUB213SHZm,
  VFNMSUB213SHZm_Int,
  VFNMSUB213SHZmk_Int,
  VFNMSUB213SHZmkz_Int,
  VFNMSUB213SHZr,
  VFNMSUB213SHZr_Int,
  VFNMSUB213SHZrb,
  VFNMSUB213SHZrb_Int,
  VFNMSUB213SHZrbk_Int,
  VFNMSUB213SHZrbkz_Int,
  VFNMSUB213SHZrk_Int,
  VFNMSUB213SHZrkz_Int,
  VFNMSUB213SSZm,
  VFNMSUB213SSZm_Int,
  VFNMSUB213SSZmk_Int,
  VFNMSUB213SSZmkz_Int,
  VFNMSUB213SSZr,
  VFNMSUB213SSZr_Int,
  VFNMSUB213SSZrb,
  VFNMSUB213SSZrb_Int,
  VFNMSUB213SSZrbk_Int,
  VFNMSUB213SSZrbkz_Int,
  VFNMSUB213SSZrk_Int,
  VFNMSUB213SSZrkz_Int,
  VFNMSUB213SSm,
  VFNMSUB213SSm_Int,
  VFNMSUB213SSr,
  VFNMSUB213SSr_Int,
  VFNMSUB231BF16Z128m,
  VFNMSUB231BF16Z128mb,
  VFNMSUB231BF16Z128mbk,
  VFNMSUB231BF16Z128mbkz,
  VFNMSUB231BF16Z128mk,
  VFNMSUB231BF16Z128mkz,
  VFNMSUB231BF16Z128r,
  VFNMSUB231BF16Z128rk,
  VFNMSUB231BF16Z128rkz,
  VFNMSUB231BF16Z256m,
  VFNMSUB231BF16Z256mb,
  VFNMSUB231BF16Z256mbk,
  VFNMSUB231BF16Z256mbkz,
  VFNMSUB231BF16Z256mk,
  VFNMSUB231BF16Z256mkz,
  VFNMSUB231BF16Z256r,
  VFNMSUB231BF16Z256rk,
  VFNMSUB231BF16Z256rkz,
  VFNMSUB231BF16Zm,
  VFNMSUB231BF16Zmb,
  VFNMSUB231BF16Zmbk,
  VFNMSUB231BF16Zmbkz,
  VFNMSUB231BF16Zmk,
  VFNMSUB231BF16Zmkz,
  VFNMSUB231BF16Zr,
  VFNMSUB231BF16Zrk,
  VFNMSUB231BF16Zrkz,
  VFNMSUB231PDYm,
  VFNMSUB231PDYr,
  VFNMSUB231PDZ128m,
  VFNMSUB231PDZ128mb,
  VFNMSUB231PDZ128mbk,
  VFNMSUB231PDZ128mbkz,
  VFNMSUB231PDZ128mk,
  VFNMSUB231PDZ128mkz,
  VFNMSUB231PDZ128r,
  VFNMSUB231PDZ128rk,
  VFNMSUB231PDZ128rkz,
  VFNMSUB231PDZ256m,
  VFNMSUB231PDZ256mb,
  VFNMSUB231PDZ256mbk,
  VFNMSUB231PDZ256mbkz,
  VFNMSUB231PDZ256mk,
  VFNMSUB231PDZ256mkz,
  VFNMSUB231PDZ256r,
  VFNMSUB231PDZ256rk,
  VFNMSUB231PDZ256rkz,
  VFNMSUB231PDZm,
  VFNMSUB231PDZmb,
  VFNMSUB231PDZmbk,
  VFNMSUB231PDZmbkz,
  VFNMSUB231PDZmk,
  VFNMSUB231PDZmkz,
  VFNMSUB231PDZr,
  VFNMSUB231PDZrb,
  VFNMSUB231PDZrbk,
  VFNMSUB231PDZrbkz,
  VFNMSUB231PDZrk,
  VFNMSUB231PDZrkz,
  VFNMSUB231PDm,
  VFNMSUB231PDr,
  VFNMSUB231PHZ128m,
  VFNMSUB231PHZ128mb,
  VFNMSUB231PHZ128mbk,
  VFNMSUB231PHZ128mbkz,
  VFNMSUB231PHZ128mk,
  VFNMSUB231PHZ128mkz,
  VFNMSUB231PHZ128r,
  VFNMSUB231PHZ128rk,
  VFNMSUB231PHZ128rkz,
  VFNMSUB231PHZ256m,
  VFNMSUB231PHZ256mb,
  VFNMSUB231PHZ256mbk,
  VFNMSUB231PHZ256mbkz,
  VFNMSUB231PHZ256mk,
  VFNMSUB231PHZ256mkz,
  VFNMSUB231PHZ256r,
  VFNMSUB231PHZ256rk,
  VFNMSUB231PHZ256rkz,
  VFNMSUB231PHZm,
  VFNMSUB231PHZmb,
  VFNMSUB231PHZmbk,
  VFNMSUB231PHZmbkz,
  VFNMSUB231PHZmk,
  VFNMSUB231PHZmkz,
  VFNMSUB231PHZr,
  VFNMSUB231PHZrb,
  VFNMSUB231PHZrbk,
  VFNMSUB231PHZrbkz,
  VFNMSUB231PHZrk,
  VFNMSUB231PHZrkz,
  VFNMSUB231PSYm,
  VFNMSUB231PSYr,
  VFNMSUB231PSZ128m,
  VFNMSUB231PSZ128mb,
  VFNMSUB231PSZ128mbk,
  VFNMSUB231PSZ128mbkz,
  VFNMSUB231PSZ128mk,
  VFNMSUB231PSZ128mkz,
  VFNMSUB231PSZ128r,
  VFNMSUB231PSZ128rk,
  VFNMSUB231PSZ128rkz,
  VFNMSUB231PSZ256m,
  VFNMSUB231PSZ256mb,
  VFNMSUB231PSZ256mbk,
  VFNMSUB231PSZ256mbkz,
  VFNMSUB231PSZ256mk,
  VFNMSUB231PSZ256mkz,
  VFNMSUB231PSZ256r,
  VFNMSUB231PSZ256rk,
  VFNMSUB231PSZ256rkz,
  VFNMSUB231PSZm,
  VFNMSUB231PSZmb,
  VFNMSUB231PSZmbk,
  VFNMSUB231PSZmbkz,
  VFNMSUB231PSZmk,
  VFNMSUB231PSZmkz,
  VFNMSUB231PSZr,
  VFNMSUB231PSZrb,
  VFNMSUB231PSZrbk,
  VFNMSUB231PSZrbkz,
  VFNMSUB231PSZrk,
  VFNMSUB231PSZrkz,
  VFNMSUB231PSm,
  VFNMSUB231PSr,
  VFNMSUB231SDZm,
  VFNMSUB231SDZm_Int,
  VFNMSUB231SDZmk_Int,
  VFNMSUB231SDZmkz_Int,
  VFNMSUB231SDZr,
  VFNMSUB231SDZr_Int,
  VFNMSUB231SDZrb,
  VFNMSUB231SDZrb_Int,
  VFNMSUB231SDZrbk_Int,
  VFNMSUB231SDZrbkz_Int,
  VFNMSUB231SDZrk_Int,
  VFNMSUB231SDZrkz_Int,
  VFNMSUB231SDm,
  VFNMSUB231SDm_Int,
  VFNMSUB231SDr,
  VFNMSUB231SDr_Int,
  VFNMSUB231SHZm,
  VFNMSUB231SHZm_Int,
  VFNMSUB231SHZmk_Int,
  VFNMSUB231SHZmkz_Int,
  VFNMSUB231SHZr,
  VFNMSUB231SHZr_Int,
  VFNMSUB231SHZrb,
  VFNMSUB231SHZrb_Int,
  VFNMSUB231SHZrbk_Int,
  VFNMSUB231SHZrbkz_Int,
  VFNMSUB231SHZrk_Int,
  VFNMSUB231SHZrkz_Int,
  VFNMSUB231SSZm,
  VFNMSUB231SSZm_Int,
  VFNMSUB231SSZmk_Int,
  VFNMSUB231SSZmkz_Int,
  VFNMSUB231SSZr,
  VFNMSUB231SSZr_Int,
  VFNMSUB231SSZrb,
  VFNMSUB231SSZrb_Int,
  VFNMSUB231SSZrbk_Int,
  VFNMSUB231SSZrbkz_Int,
  VFNMSUB231SSZrk_Int,
  VFNMSUB231SSZrkz_Int,
  VFNMSUB231SSm,
  VFNMSUB231SSm_Int,
  VFNMSUB231SSr,
  VFNMSUB231SSr_Int,
  VFNMSUBPD4Ymr,
  VFNMSUBPD4Yrm,
  VFNMSUBPD4Yrr,
  VFNMSUBPD4Yrr_REV,
  VFNMSUBPD4mr,
  VFNMSUBPD4rm,
  VFNMSUBPD4rr,
  VFNMSUBPD4rr_REV,
  VFNMSUBPS4Ymr,
  VFNMSUBPS4Yrm,
  VFNMSUBPS4Yrr,
  VFNMSUBPS4Yrr_REV,
  VFNMSUBPS4mr,
  VFNMSUBPS4rm,
  VFNMSUBPS4rr,
  VFNMSUBPS4rr_REV,
  VFNMSUBSD4mr,
  VFNMSUBSD4mr_Int,
  VFNMSUBSD4rm,
  VFNMSUBSD4rm_Int,
  VFNMSUBSD4rr,
  VFNMSUBSD4rr_Int,
  VFNMSUBSD4rr_Int_REV,
  VFNMSUBSD4rr_REV,
  VFNMSUBSS4mr,
  VFNMSUBSS4mr_Int,
  VFNMSUBSS4rm,
  VFNMSUBSS4rm_Int,
  VFNMSUBSS4rr,
  VFNMSUBSS4rr_Int,
  VFNMSUBSS4rr_Int_REV,
  VFNMSUBSS4rr_REV,
  VFPCLASSBF16Z128mbi,
  VFPCLASSBF16Z128mbik,
  VFPCLASSBF16Z128mi,
  VFPCLASSBF16Z128mik,
  VFPCLASSBF16Z128ri,
  VFPCLASSBF16Z128rik,
  VFPCLASSBF16Z256mbi,
  VFPCLASSBF16Z256mbik,
  VFPCLASSBF16Z256mi,
  VFPCLASSBF16Z256mik,
  VFPCLASSBF16Z256ri,
  VFPCLASSBF16Z256rik,
  VFPCLASSBF16Zmbi,
  VFPCLASSBF16Zmbik,
  VFPCLASSBF16Zmi,
  VFPCLASSBF16Zmik,
  VFPCLASSBF16Zri,
  VFPCLASSBF16Zrik,
  VFPCLASSPDZ128mbi,
  VFPCLASSPDZ128mbik,
  VFPCLASSPDZ128mi,
  VFPCLASSPDZ128mik,
  VFPCLASSPDZ128ri,
  VFPCLASSPDZ128rik,
  VFPCLASSPDZ256mbi,
  VFPCLASSPDZ256mbik,
  VFPCLASSPDZ256mi,
  VFPCLASSPDZ256mik,
  VFPCLASSPDZ256ri,
  VFPCLASSPDZ256rik,
  VFPCLASSPDZmbi,
  VFPCLASSPDZmbik,
  VFPCLASSPDZmi,
  VFPCLASSPDZmik,
  VFPCLASSPDZri,
  VFPCLASSPDZrik,
  VFPCLASSPHZ128mbi,
  VFPCLASSPHZ128mbik,
  VFPCLASSPHZ128mi,
  VFPCLASSPHZ128mik,
  VFPCLASSPHZ128ri,
  VFPCLASSPHZ128rik,
  VFPCLASSPHZ256mbi,
  VFPCLASSPHZ256mbik,
  VFPCLASSPHZ256mi,
  VFPCLASSPHZ256mik,
  VFPCLASSPHZ256ri,
  VFPCLASSPHZ256rik,
  VFPCLASSPHZmbi,
  VFPCLASSPHZmbik,
  VFPCLASSPHZmi,
  VFPCLASSPHZmik,
  VFPCLASSPHZri,
  VFPCLASSPHZrik,
  VFPCLASSPSZ128mbi,
  VFPCLASSPSZ128mbik,
  VFPCLASSPSZ128mi,
  VFPCLASSPSZ128mik,
  VFPCLASSPSZ128ri,
  VFPCLASSPSZ128rik,
  VFPCLASSPSZ256mbi,
  VFPCLASSPSZ256mbik,
  VFPCLASSPSZ256mi,
  VFPCLASSPSZ256mik,
  VFPCLASSPSZ256ri,
  VFPCLASSPSZ256rik,
  VFPCLASSPSZmbi,
  VFPCLASSPSZmbik,
  VFPCLASSPSZmi,
  VFPCLASSPSZmik,
  VFPCLASSPSZri,
  VFPCLASSPSZrik,
  VFPCLASSSDZmi,
  VFPCLASSSDZmik,
  VFPCLASSSDZri,
  VFPCLASSSDZrik,
  VFPCLASSSHZmi,
  VFPCLASSSHZmik,
  VFPCLASSSHZri,
  VFPCLASSSHZrik,
  VFPCLASSSSZmi,
  VFPCLASSSSZmik,
  VFPCLASSSSZri,
  VFPCLASSSSZrik,
  VFRCZPDYrm,
  VFRCZPDYrr,
  VFRCZPDrm,
  VFRCZPDrr,
  VFRCZPSYrm,
  VFRCZPSYrr,
  VFRCZPSrm,
  VFRCZPSrr,
  VFRCZSDrm,
  VFRCZSDrr,
  VFRCZSSrm,
  VFRCZSSrr,
  VGATHERDPDYrm,
  VGATHERDPDZ128rm,
  VGATHERDPDZ256rm,
  VGATHERDPDZrm,
  VGATHERDPDrm,
  VGATHERDPSYrm,
  VGATHERDPSZ128rm,
  VGATHERDPSZ256rm,
  VGATHERDPSZrm,
  VGATHERDPSrm,
  VGATHERPF0DPDm,
  VGATHERPF0DPSm,
  VGATHERPF0QPDm,
  VGATHERPF0QPSm,
  VGATHERPF1DPDm,
  VGATHERPF1DPSm,
  VGATHERPF1QPDm,
  VGATHERPF1QPSm,
  VGATHERQPDYrm,
  VGATHERQPDZ128rm,
  VGATHERQPDZ256rm,
  VGATHERQPDZrm,
  VGATHERQPDrm,
  VGATHERQPSYrm,
  VGATHERQPSZ128rm,
  VGATHERQPSZ256rm,
  VGATHERQPSZrm,
  VGATHERQPSrm,
  VGETEXPBF16Z128m,
  VGETEXPBF16Z128mb,
  VGETEXPBF16Z128mbk,
  VGETEXPBF16Z128mbkz,
  VGETEXPBF16Z128mk,
  VGETEXPBF16Z128mkz,
  VGETEXPBF16Z128r,
  VGETEXPBF16Z128rk,
  VGETEXPBF16Z128rkz,
  VGETEXPBF16Z256m,
  VGETEXPBF16Z256mb,
  VGETEXPBF16Z256mbk,
  VGETEXPBF16Z256mbkz,
  VGETEXPBF16Z256mk,
  VGETEXPBF16Z256mkz,
  VGETEXPBF16Z256r,
  VGETEXPBF16Z256rk,
  VGETEXPBF16Z256rkz,
  VGETEXPBF16Zm,
  VGETEXPBF16Zmb,
  VGETEXPBF16Zmbk,
  VGETEXPBF16Zmbkz,
  VGETEXPBF16Zmk,
  VGETEXPBF16Zmkz,
  VGETEXPBF16Zr,
  VGETEXPBF16Zrk,
  VGETEXPBF16Zrkz,
  VGETEXPPDZ128m,
  VGETEXPPDZ128mb,
  VGETEXPPDZ128mbk,
  VGETEXPPDZ128mbkz,
  VGETEXPPDZ128mk,
  VGETEXPPDZ128mkz,
  VGETEXPPDZ128r,
  VGETEXPPDZ128rk,
  VGETEXPPDZ128rkz,
  VGETEXPPDZ256m,
  VGETEXPPDZ256mb,
  VGETEXPPDZ256mbk,
  VGETEXPPDZ256mbkz,
  VGETEXPPDZ256mk,
  VGETEXPPDZ256mkz,
  VGETEXPPDZ256r,
  VGETEXPPDZ256rk,
  VGETEXPPDZ256rkz,
  VGETEXPPDZm,
  VGETEXPPDZmb,
  VGETEXPPDZmbk,
  VGETEXPPDZmbkz,
  VGETEXPPDZmk,
  VGETEXPPDZmkz,
  VGETEXPPDZr,
  VGETEXPPDZrb,
  VGETEXPPDZrbk,
  VGETEXPPDZrbkz,
  VGETEXPPDZrk,
  VGETEXPPDZrkz,
  VGETEXPPHZ128m,
  VGETEXPPHZ128mb,
  VGETEXPPHZ128mbk,
  VGETEXPPHZ128mbkz,
  VGETEXPPHZ128mk,
  VGETEXPPHZ128mkz,
  VGETEXPPHZ128r,
  VGETEXPPHZ128rk,
  VGETEXPPHZ128rkz,
  VGETEXPPHZ256m,
  VGETEXPPHZ256mb,
  VGETEXPPHZ256mbk,
  VGETEXPPHZ256mbkz,
  VGETEXPPHZ256mk,
  VGETEXPPHZ256mkz,
  VGETEXPPHZ256r,
  VGETEXPPHZ256rk,
  VGETEXPPHZ256rkz,
  VGETEXPPHZm,
  VGETEXPPHZmb,
  VGETEXPPHZmbk,
  VGETEXPPHZmbkz,
  VGETEXPPHZmk,
  VGETEXPPHZmkz,
  VGETEXPPHZr,
  VGETEXPPHZrb,
  VGETEXPPHZrbk,
  VGETEXPPHZrbkz,
  VGETEXPPHZrk,
  VGETEXPPHZrkz,
  VGETEXPPSZ128m,
  VGETEXPPSZ128mb,
  VGETEXPPSZ128mbk,
  VGETEXPPSZ128mbkz,
  VGETEXPPSZ128mk,
  VGETEXPPSZ128mkz,
  VGETEXPPSZ128r,
  VGETEXPPSZ128rk,
  VGETEXPPSZ128rkz,
  VGETEXPPSZ256m,
  VGETEXPPSZ256mb,
  VGETEXPPSZ256mbk,
  VGETEXPPSZ256mbkz,
  VGETEXPPSZ256mk,
  VGETEXPPSZ256mkz,
  VGETEXPPSZ256r,
  VGETEXPPSZ256rk,
  VGETEXPPSZ256rkz,
  VGETEXPPSZm,
  VGETEXPPSZmb,
  VGETEXPPSZmbk,
  VGETEXPPSZmbkz,
  VGETEXPPSZmk,
  VGETEXPPSZmkz,
  VGETEXPPSZr,
  VGETEXPPSZrb,
  VGETEXPPSZrbk,
  VGETEXPPSZrbkz,
  VGETEXPPSZrk,
  VGETEXPPSZrkz,
  VGETEXPSDZm,
  VGETEXPSDZmk,
  VGETEXPSDZmkz,
  VGETEXPSDZr,
  VGETEXPSDZrb,
  VGETEXPSDZrbk,
  VGETEXPSDZrbkz,
  VGETEXPSDZrk,
  VGETEXPSDZrkz,
  VGETEXPSHZm,
  VGETEXPSHZmk,
  VGETEXPSHZmkz,
  VGETEXPSHZr,
  VGETEXPSHZrb,
  VGETEXPSHZrbk,
  VGETEXPSHZrbkz,
  VGETEXPSHZrk,
  VGETEXPSHZrkz,
  VGETEXPSSZm,
  VGETEXPSSZmk,
  VGETEXPSSZmkz,
  VGETEXPSSZr,
  VGETEXPSSZrb,
  VGETEXPSSZrbk,
  VGETEXPSSZrbkz,
  VGETEXPSSZrk,
  VGETEXPSSZrkz,
  VGETMANTBF16Z128rmbi,
  VGETMANTBF16Z128rmbik,
  VGETMANTBF16Z128rmbikz,
  VGETMANTBF16Z128rmi,
  VGETMANTBF16Z128rmik,
  VGETMANTBF16Z128rmikz,
  VGETMANTBF16Z128rri,
  VGETMANTBF16Z128rrik,
  VGETMANTBF16Z128rrikz,
  VGETMANTBF16Z256rmbi,
  VGETMANTBF16Z256rmbik,
  VGETMANTBF16Z256rmbikz,
  VGETMANTBF16Z256rmi,
  VGETMANTBF16Z256rmik,
  VGETMANTBF16Z256rmikz,
  VGETMANTBF16Z256rri,
  VGETMANTBF16Z256rrik,
  VGETMANTBF16Z256rrikz,
  VGETMANTBF16Zrmbi,
  VGETMANTBF16Zrmbik,
  VGETMANTBF16Zrmbikz,
  VGETMANTBF16Zrmi,
  VGETMANTBF16Zrmik,
  VGETMANTBF16Zrmikz,
  VGETMANTBF16Zrri,
  VGETMANTBF16Zrrik,
  VGETMANTBF16Zrrikz,
  VGETMANTPDZ128rmbi,
  VGETMANTPDZ128rmbik,
  VGETMANTPDZ128rmbikz,
  VGETMANTPDZ128rmi,
  VGETMANTPDZ128rmik,
  VGETMANTPDZ128rmikz,
  VGETMANTPDZ128rri,
  VGETMANTPDZ128rrik,
  VGETMANTPDZ128rrikz,
  VGETMANTPDZ256rmbi,
  VGETMANTPDZ256rmbik,
  VGETMANTPDZ256rmbikz,
  VGETMANTPDZ256rmi,
  VGETMANTPDZ256rmik,
  VGETMANTPDZ256rmikz,
  VGETMANTPDZ256rri,
  VGETMANTPDZ256rrik,
  VGETMANTPDZ256rrikz,
  VGETMANTPDZrmbi,
  VGETMANTPDZrmbik,
  VGETMANTPDZrmbikz,
  VGETMANTPDZrmi,
  VGETMANTPDZrmik,
  VGETMANTPDZrmikz,
  VGETMANTPDZrri,
  VGETMANTPDZrrib,
  VGETMANTPDZrribk,
  VGETMANTPDZrribkz,
  VGETMANTPDZrrik,
  VGETMANTPDZrrikz,
  VGETMANTPHZ128rmbi,
  VGETMANTPHZ128rmbik,
  VGETMANTPHZ128rmbikz,
  VGETMANTPHZ128rmi,
  VGETMANTPHZ128rmik,
  VGETMANTPHZ128rmikz,
  VGETMANTPHZ128rri,
  VGETMANTPHZ128rrik,
  VGETMANTPHZ128rrikz,
  VGETMANTPHZ256rmbi,
  VGETMANTPHZ256rmbik,
  VGETMANTPHZ256rmbikz,
  VGETMANTPHZ256rmi,
  VGETMANTPHZ256rmik,
  VGETMANTPHZ256rmikz,
  VGETMANTPHZ256rri,
  VGETMANTPHZ256rrik,
  VGETMANTPHZ256rrikz,
  VGETMANTPHZrmbi,
  VGETMANTPHZrmbik,
  VGETMANTPHZrmbikz,
  VGETMANTPHZrmi,
  VGETMANTPHZrmik,
  VGETMANTPHZrmikz,
  VGETMANTPHZrri,
  VGETMANTPHZrrib,
  VGETMANTPHZrribk,
  VGETMANTPHZrribkz,
  VGETMANTPHZrrik,
  VGETMANTPHZrrikz,
  VGETMANTPSZ128rmbi,
  VGETMANTPSZ128rmbik,
  VGETMANTPSZ128rmbikz,
  VGETMANTPSZ128rmi,
  VGETMANTPSZ128rmik,
  VGETMANTPSZ128rmikz,
  VGETMANTPSZ128rri,
  VGETMANTPSZ128rrik,
  VGETMANTPSZ128rrikz,
  VGETMANTPSZ256rmbi,
  VGETMANTPSZ256rmbik,
  VGETMANTPSZ256rmbikz,
  VGETMANTPSZ256rmi,
  VGETMANTPSZ256rmik,
  VGETMANTPSZ256rmikz,
  VGETMANTPSZ256rri,
  VGETMANTPSZ256rrik,
  VGETMANTPSZ256rrikz,
  VGETMANTPSZrmbi,
  VGETMANTPSZrmbik,
  VGETMANTPSZrmbikz,
  VGETMANTPSZrmi,
  VGETMANTPSZrmik,
  VGETMANTPSZrmikz,
  VGETMANTPSZrri,
  VGETMANTPSZrrib,
  VGETMANTPSZrribk,
  VGETMANTPSZrribkz,
  VGETMANTPSZrrik,
  VGETMANTPSZrrikz,
  VGETMANTSDZrmi,
  VGETMANTSDZrmik,
  VGETMANTSDZrmikz,
  VGETMANTSDZrri,
  VGETMANTSDZrrib,
  VGETMANTSDZrribk,
  VGETMANTSDZrribkz,
  VGETMANTSDZrrik,
  VGETMANTSDZrrikz,
  VGETMANTSHZrmi,
  VGETMANTSHZrmik,
  VGETMANTSHZrmikz,
  VGETMANTSHZrri,
  VGETMANTSHZrrib,
  VGETMANTSHZrribk,
  VGETMANTSHZrribkz,
  VGETMANTSHZrrik,
  VGETMANTSHZrrikz,
  VGETMANTSSZrmi,
  VGETMANTSSZrmik,
  VGETMANTSSZrmikz,
  VGETMANTSSZrri,
  VGETMANTSSZrrib,
  VGETMANTSSZrribk,
  VGETMANTSSZrribkz,
  VGETMANTSSZrrik,
  VGETMANTSSZrrikz,
  VGF2P8AFFINEINVQBYrmi,
  VGF2P8AFFINEINVQBYrri,
  VGF2P8AFFINEINVQBZ128rmbi,
  VGF2P8AFFINEINVQBZ128rmbik,
  VGF2P8AFFINEINVQBZ128rmbikz,
  VGF2P8AFFINEINVQBZ128rmi,
  VGF2P8AFFINEINVQBZ128rmik,
  VGF2P8AFFINEINVQBZ128rmikz,
  VGF2P8AFFINEINVQBZ128rri,
  VGF2P8AFFINEINVQBZ128rrik,
  VGF2P8AFFINEINVQBZ128rrikz,
  VGF2P8AFFINEINVQBZ256rmbi,
  VGF2P8AFFINEINVQBZ256rmbik,
  VGF2P8AFFINEINVQBZ256rmbikz,
  VGF2P8AFFINEINVQBZ256rmi,
  VGF2P8AFFINEINVQBZ256rmik,
  VGF2P8AFFINEINVQBZ256rmikz,
  VGF2P8AFFINEINVQBZ256rri,
  VGF2P8AFFINEINVQBZ256rrik,
  VGF2P8AFFINEINVQBZ256rrikz,
  VGF2P8AFFINEINVQBZrmbi,
  VGF2P8AFFINEINVQBZrmbik,
  VGF2P8AFFINEINVQBZrmbikz,
  VGF2P8AFFINEINVQBZrmi,
  VGF2P8AFFINEINVQBZrmik,
  VGF2P8AFFINEINVQBZrmikz,
  VGF2P8AFFINEINVQBZrri,
  VGF2P8AFFINEINVQBZrrik,
  VGF2P8AFFINEINVQBZrrikz,
  VGF2P8AFFINEINVQBrmi,
  VGF2P8AFFINEINVQBrri,
  VGF2P8AFFINEQBYrmi,
  VGF2P8AFFINEQBYrri,
  VGF2P8AFFINEQBZ128rmbi,
  VGF2P8AFFINEQBZ128rmbik,
  VGF2P8AFFINEQBZ128rmbikz,
  VGF2P8AFFINEQBZ128rmi,
  VGF2P8AFFINEQBZ128rmik,
  VGF2P8AFFINEQBZ128rmikz,
  VGF2P8AFFINEQBZ128rri,
  VGF2P8AFFINEQBZ128rrik,
  VGF2P8AFFINEQBZ128rrikz,
  VGF2P8AFFINEQBZ256rmbi,
  VGF2P8AFFINEQBZ256rmbik,
  VGF2P8AFFINEQBZ256rmbikz,
  VGF2P8AFFINEQBZ256rmi,
  VGF2P8AFFINEQBZ256rmik,
  VGF2P8AFFINEQBZ256rmikz,
  VGF2P8AFFINEQBZ256rri,
  VGF2P8AFFINEQBZ256rrik,
  VGF2P8AFFINEQBZ256rrikz,
  VGF2P8AFFINEQBZrmbi,
  VGF2P8AFFINEQBZrmbik,
  VGF2P8AFFINEQBZrmbikz,
  VGF2P8AFFINEQBZrmi,
  VGF2P8AFFINEQBZrmik,
  VGF2P8AFFINEQBZrmikz,
  VGF2P8AFFINEQBZrri,
  VGF2P8AFFINEQBZrrik,
  VGF2P8AFFINEQBZrrikz,
  VGF2P8AFFINEQBrmi,
  VGF2P8AFFINEQBrri,
  VGF2P8MULBYrm,
  VGF2P8MULBYrr,
  VGF2P8MULBZ128rm,
  VGF2P8MULBZ128rmk,
  VGF2P8MULBZ128rmkz,
  VGF2P8MULBZ128rr,
  VGF2P8MULBZ128rrk,
  VGF2P8MULBZ128rrkz,
  VGF2P8MULBZ256rm,
  VGF2P8MULBZ256rmk,
  VGF2P8MULBZ256rmkz,
  VGF2P8MULBZ256rr,
  VGF2P8MULBZ256rrk,
  VGF2P8MULBZ256rrkz,
  VGF2P8MULBZrm,
  VGF2P8MULBZrmk,
  VGF2P8MULBZrmkz,
  VGF2P8MULBZrr,
  VGF2P8MULBZrrk,
  VGF2P8MULBZrrkz,
  VGF2P8MULBrm,
  VGF2P8MULBrr,
  VHADDPDYrm,
  VHADDPDYrr,
  VHADDPDrm,
  VHADDPDrr,
  VHADDPSYrm,
  VHADDPSYrr,
  VHADDPSrm,
  VHADDPSrr,
  VHSUBPDYrm,
  VHSUBPDYrr,
  VHSUBPDrm,
  VHSUBPDrr,
  VHSUBPSYrm,
  VHSUBPSYrr,
  VHSUBPSrm,
  VHSUBPSrr,
  VINSERTF128rmi,
  VINSERTF128rri,
  VINSERTF32X4Z256rmi,
  VINSERTF32X4Z256rmik,
  VINSERTF32X4Z256rmikz,
  VINSERTF32X4Z256rri,
  VINSERTF32X4Z256rrik,
  VINSERTF32X4Z256rrikz,
  VINSERTF32X4Zrmi,
  VINSERTF32X4Zrmik,
  VINSERTF32X4Zrmikz,
  VINSERTF32X4Zrri,
  VINSERTF32X4Zrrik,
  VINSERTF32X4Zrrikz,
  VINSERTF32X8Zrmi,
  VINSERTF32X8Zrmik,
  VINSERTF32X8Zrmikz,
  VINSERTF32X8Zrri,
  VINSERTF32X8Zrrik,
  VINSERTF32X8Zrrikz,
  VINSERTF64X2Z256rmi,
  VINSERTF64X2Z256rmik,
  VINSERTF64X2Z256rmikz,
  VINSERTF64X2Z256rri,
  VINSERTF64X2Z256rrik,
  VINSERTF64X2Z256rrikz,
  VINSERTF64X2Zrmi,
  VINSERTF64X2Zrmik,
  VINSERTF64X2Zrmikz,
  VINSERTF64X2Zrri,
  VINSERTF64X2Zrrik,
  VINSERTF64X2Zrrikz,
  VINSERTF64X4Zrmi,
  VINSERTF64X4Zrmik,
  VINSERTF64X4Zrmikz,
  VINSERTF64X4Zrri,
  VINSERTF64X4Zrrik,
  VINSERTF64X4Zrrikz,
  VINSERTI128rmi,
  VINSERTI128rri,
  VINSERTI32X4Z256rmi,
  VINSERTI32X4Z256rmik,
  VINSERTI32X4Z256rmikz,
  VINSERTI32X4Z256rri,
  VINSERTI32X4Z256rrik,
  VINSERTI32X4Z256rrikz,
  VINSERTI32X4Zrmi,
  VINSERTI32X4Zrmik,
  VINSERTI32X4Zrmikz,
  VINSERTI32X4Zrri,
  VINSERTI32X4Zrrik,
  VINSERTI32X4Zrrikz,
  VINSERTI32X8Zrmi,
  VINSERTI32X8Zrmik,
  VINSERTI32X8Zrmikz,
  VINSERTI32X8Zrri,
  VINSERTI32X8Zrrik,
  VINSERTI32X8Zrrikz,
  VINSERTI64X2Z256rmi,
  VINSERTI64X2Z256rmik,
  VINSERTI64X2Z256rmikz,
  VINSERTI64X2Z256rri,
  VINSERTI64X2Z256rrik,
  VINSERTI64X2Z256rrikz,
  VINSERTI64X2Zrmi,
  VINSERTI64X2Zrmik,
  VINSERTI64X2Zrmikz,
  VINSERTI64X2Zrri,
  VINSERTI64X2Zrrik,
  VINSERTI64X2Zrrikz,
  VINSERTI64X4Zrmi,
  VINSERTI64X4Zrmik,
  VINSERTI64X4Zrmikz,
  VINSERTI64X4Zrri,
  VINSERTI64X4Zrrik,
  VINSERTI64X4Zrrikz,
  VINSERTPSZrmi,
  VINSERTPSZrri,
  VINSERTPSrmi,
  VINSERTPSrri,
  VLDDQUYrm,
  VLDDQUrm,
  VLDMXCSR,
  VMASKMOVDQU,
  VMASKMOVDQU64,
  VMASKMOVPDYmr,
  VMASKMOVPDYrm,
  VMASKMOVPDmr,
  VMASKMOVPDrm,
  VMASKMOVPSYmr,
  VMASKMOVPSYrm,
  VMASKMOVPSmr,
  VMASKMOVPSrm,
  VMAXBF16Z128rm,
  VMAXBF16Z128rmb,
  VMAXBF16Z128rmbk,
  VMAXBF16Z128rmbkz,
  VMAXBF16Z128rmk,
  VMAXBF16Z128rmkz,
  VMAXBF16Z128rr,
  VMAXBF16Z128rrk,
  VMAXBF16Z128rrkz,
  VMAXBF16Z256rm,
  VMAXBF16Z256rmb,
  VMAXBF16Z256rmbk,
  VMAXBF16Z256rmbkz,
  VMAXBF16Z256rmk,
  VMAXBF16Z256rmkz,
  VMAXBF16Z256rr,
  VMAXBF16Z256rrk,
  VMAXBF16Z256rrkz,
  VMAXBF16Zrm,
  VMAXBF16Zrmb,
  VMAXBF16Zrmbk,
  VMAXBF16Zrmbkz,
  VMAXBF16Zrmk,
  VMAXBF16Zrmkz,
  VMAXBF16Zrr,
  VMAXBF16Zrrk,
  VMAXBF16Zrrkz,
  VMAXCPDYrm,
  VMAXCPDYrr,
  VMAXCPDZ128rm,
  VMAXCPDZ128rmb,
  VMAXCPDZ128rmbk,
  VMAXCPDZ128rmbkz,
  VMAXCPDZ128rmk,
  VMAXCPDZ128rmkz,
  VMAXCPDZ128rr,
  VMAXCPDZ128rrk,
  VMAXCPDZ128rrkz,
  VMAXCPDZ256rm,
  VMAXCPDZ256rmb,
  VMAXCPDZ256rmbk,
  VMAXCPDZ256rmbkz,
  VMAXCPDZ256rmk,
  VMAXCPDZ256rmkz,
  VMAXCPDZ256rr,
  VMAXCPDZ256rrk,
  VMAXCPDZ256rrkz,
  VMAXCPDZrm,
  VMAXCPDZrmb,
  VMAXCPDZrmbk,
  VMAXCPDZrmbkz,
  VMAXCPDZrmk,
  VMAXCPDZrmkz,
  VMAXCPDZrr,
  VMAXCPDZrrk,
  VMAXCPDZrrkz,
  VMAXCPDrm,
  VMAXCPDrr,
  VMAXCPHZ128rm,
  VMAXCPHZ128rmb,
  VMAXCPHZ128rmbk,
  VMAXCPHZ128rmbkz,
  VMAXCPHZ128rmk,
  VMAXCPHZ128rmkz,
  VMAXCPHZ128rr,
  VMAXCPHZ128rrk,
  VMAXCPHZ128rrkz,
  VMAXCPHZ256rm,
  VMAXCPHZ256rmb,
  VMAXCPHZ256rmbk,
  VMAXCPHZ256rmbkz,
  VMAXCPHZ256rmk,
  VMAXCPHZ256rmkz,
  VMAXCPHZ256rr,
  VMAXCPHZ256rrk,
  VMAXCPHZ256rrkz,
  VMAXCPHZrm,
  VMAXCPHZrmb,
  VMAXCPHZrmbk,
  VMAXCPHZrmbkz,
  VMAXCPHZrmk,
  VMAXCPHZrmkz,
  VMAXCPHZrr,
  VMAXCPHZrrk,
  VMAXCPHZrrkz,
  VMAXCPSYrm,
  VMAXCPSYrr,
  VMAXCPSZ128rm,
  VMAXCPSZ128rmb,
  VMAXCPSZ128rmbk,
  VMAXCPSZ128rmbkz,
  VMAXCPSZ128rmk,
  VMAXCPSZ128rmkz,
  VMAXCPSZ128rr,
  VMAXCPSZ128rrk,
  VMAXCPSZ128rrkz,
  VMAXCPSZ256rm,
  VMAXCPSZ256rmb,
  VMAXCPSZ256rmbk,
  VMAXCPSZ256rmbkz,
  VMAXCPSZ256rmk,
  VMAXCPSZ256rmkz,
  VMAXCPSZ256rr,
  VMAXCPSZ256rrk,
  VMAXCPSZ256rrkz,
  VMAXCPSZrm,
  VMAXCPSZrmb,
  VMAXCPSZrmbk,
  VMAXCPSZrmbkz,
  VMAXCPSZrmk,
  VMAXCPSZrmkz,
  VMAXCPSZrr,
  VMAXCPSZrrk,
  VMAXCPSZrrkz,
  VMAXCPSrm,
  VMAXCPSrr,
  VMAXCSDZrm,
  VMAXCSDZrr,
  VMAXCSDrm,
  VMAXCSDrr,
  VMAXCSHZrm,
  VMAXCSHZrr,
  VMAXCSSZrm,
  VMAXCSSZrr,
  VMAXCSSrm,
  VMAXCSSrr,
  VMAXPDYrm,
  VMAXPDYrr,
  VMAXPDZ128rm,
  VMAXPDZ128rmb,
  VMAXPDZ128rmbk,
  VMAXPDZ128rmbkz,
  VMAXPDZ128rmk,
  VMAXPDZ128rmkz,
  VMAXPDZ128rr,
  VMAXPDZ128rrk,
  VMAXPDZ128rrkz,
  VMAXPDZ256rm,
  VMAXPDZ256rmb,
  VMAXPDZ256rmbk,
  VMAXPDZ256rmbkz,
  VMAXPDZ256rmk,
  VMAXPDZ256rmkz,
  VMAXPDZ256rr,
  VMAXPDZ256rrk,
  VMAXPDZ256rrkz,
  VMAXPDZrm,
  VMAXPDZrmb,
  VMAXPDZrmbk,
  VMAXPDZrmbkz,
  VMAXPDZrmk,
  VMAXPDZrmkz,
  VMAXPDZrr,
  VMAXPDZrrb,
  VMAXPDZrrbk,
  VMAXPDZrrbkz,
  VMAXPDZrrk,
  VMAXPDZrrkz,
  VMAXPDrm,
  VMAXPDrr,
  VMAXPHZ128rm,
  VMAXPHZ128rmb,
  VMAXPHZ128rmbk,
  VMAXPHZ128rmbkz,
  VMAXPHZ128rmk,
  VMAXPHZ128rmkz,
  VMAXPHZ128rr,
  VMAXPHZ128rrk,
  VMAXPHZ128rrkz,
  VMAXPHZ256rm,
  VMAXPHZ256rmb,
  VMAXPHZ256rmbk,
  VMAXPHZ256rmbkz,
  VMAXPHZ256rmk,
  VMAXPHZ256rmkz,
  VMAXPHZ256rr,
  VMAXPHZ256rrk,
  VMAXPHZ256rrkz,
  VMAXPHZrm,
  VMAXPHZrmb,
  VMAXPHZrmbk,
  VMAXPHZrmbkz,
  VMAXPHZrmk,
  VMAXPHZrmkz,
  VMAXPHZrr,
  VMAXPHZrrb,
  VMAXPHZrrbk,
  VMAXPHZrrbkz,
  VMAXPHZrrk,
  VMAXPHZrrkz,
  VMAXPSYrm,
  VMAXPSYrr,
  VMAXPSZ128rm,
  VMAXPSZ128rmb,
  VMAXPSZ128rmbk,
  VMAXPSZ128rmbkz,
  VMAXPSZ128rmk,
  VMAXPSZ128rmkz,
  VMAXPSZ128rr,
  VMAXPSZ128rrk,
  VMAXPSZ128rrkz,
  VMAXPSZ256rm,
  VMAXPSZ256rmb,
  VMAXPSZ256rmbk,
  VMAXPSZ256rmbkz,
  VMAXPSZ256rmk,
  VMAXPSZ256rmkz,
  VMAXPSZ256rr,
  VMAXPSZ256rrk,
  VMAXPSZ256rrkz,
  VMAXPSZrm,
  VMAXPSZrmb,
  VMAXPSZrmbk,
  VMAXPSZrmbkz,
  VMAXPSZrmk,
  VMAXPSZrmkz,
  VMAXPSZrr,
  VMAXPSZrrb,
  VMAXPSZrrbk,
  VMAXPSZrrbkz,
  VMAXPSZrrk,
  VMAXPSZrrkz,
  VMAXPSrm,
  VMAXPSrr,
  VMAXSDZrm,
  VMAXSDZrm_Int,
  VMAXSDZrmk_Int,
  VMAXSDZrmkz_Int,
  VMAXSDZrr,
  VMAXSDZrr_Int,
  VMAXSDZrrb_Int,
  VMAXSDZrrbk_Int,
  VMAXSDZrrbkz_Int,
  VMAXSDZrrk_Int,
  VMAXSDZrrkz_Int,
  VMAXSDrm,
  VMAXSDrm_Int,
  VMAXSDrr,
  VMAXSDrr_Int,
  VMAXSHZrm,
  VMAXSHZrm_Int,
  VMAXSHZrmk_Int,
  VMAXSHZrmkz_Int,
  VMAXSHZrr,
  VMAXSHZrr_Int,
  VMAXSHZrrb_Int,
  VMAXSHZrrbk_Int,
  VMAXSHZrrbkz_Int,
  VMAXSHZrrk_Int,
  VMAXSHZrrkz_Int,
  VMAXSSZrm,
  VMAXSSZrm_Int,
  VMAXSSZrmk_Int,
  VMAXSSZrmkz_Int,
  VMAXSSZrr,
  VMAXSSZrr_Int,
  VMAXSSZrrb_Int,
  VMAXSSZrrbk_Int,
  VMAXSSZrrbkz_Int,
  VMAXSSZrrk_Int,
  VMAXSSZrrkz_Int,
  VMAXSSrm,
  VMAXSSrm_Int,
  VMAXSSrr,
  VMAXSSrr_Int,
  VMCALL,
  VMCLEARm,
  VMFUNC,
  VMINBF16Z128rm,
  VMINBF16Z128rmb,
  VMINBF16Z128rmbk,
  VMINBF16Z128rmbkz,
  VMINBF16Z128rmk,
  VMINBF16Z128rmkz,
  VMINBF16Z128rr,
  VMINBF16Z128rrk,
  VMINBF16Z128rrkz,
  VMINBF16Z256rm,
  VMINBF16Z256rmb,
  VMINBF16Z256rmbk,
  VMINBF16Z256rmbkz,
  VMINBF16Z256rmk,
  VMINBF16Z256rmkz,
  VMINBF16Z256rr,
  VMINBF16Z256rrk,
  VMINBF16Z256rrkz,
  VMINBF16Zrm,
  VMINBF16Zrmb,
  VMINBF16Zrmbk,
  VMINBF16Zrmbkz,
  VMINBF16Zrmk,
  VMINBF16Zrmkz,
  VMINBF16Zrr,
  VMINBF16Zrrk,
  VMINBF16Zrrkz,
  VMINCPDYrm,
  VMINCPDYrr,
  VMINCPDZ128rm,
  VMINCPDZ128rmb,
  VMINCPDZ128rmbk,
  VMINCPDZ128rmbkz,
  VMINCPDZ128rmk,
  VMINCPDZ128rmkz,
  VMINCPDZ128rr,
  VMINCPDZ128rrk,
  VMINCPDZ128rrkz,
  VMINCPDZ256rm,
  VMINCPDZ256rmb,
  VMINCPDZ256rmbk,
  VMINCPDZ256rmbkz,
  VMINCPDZ256rmk,
  VMINCPDZ256rmkz,
  VMINCPDZ256rr,
  VMINCPDZ256rrk,
  VMINCPDZ256rrkz,
  VMINCPDZrm,
  VMINCPDZrmb,
  VMINCPDZrmbk,
  VMINCPDZrmbkz,
  VMINCPDZrmk,
  VMINCPDZrmkz,
  VMINCPDZrr,
  VMINCPDZrrk,
  VMINCPDZrrkz,
  VMINCPDrm,
  VMINCPDrr,
  VMINCPHZ128rm,
  VMINCPHZ128rmb,
  VMINCPHZ128rmbk,
  VMINCPHZ128rmbkz,
  VMINCPHZ128rmk,
  VMINCPHZ128rmkz,
  VMINCPHZ128rr,
  VMINCPHZ128rrk,
  VMINCPHZ128rrkz,
  VMINCPHZ256rm,
  VMINCPHZ256rmb,
  VMINCPHZ256rmbk,
  VMINCPHZ256rmbkz,
  VMINCPHZ256rmk,
  VMINCPHZ256rmkz,
  VMINCPHZ256rr,
  VMINCPHZ256rrk,
  VMINCPHZ256rrkz,
  VMINCPHZrm,
  VMINCPHZrmb,
  VMINCPHZrmbk,
  VMINCPHZrmbkz,
  VMINCPHZrmk,
  VMINCPHZrmkz,
  VMINCPHZrr,
  VMINCPHZrrk,
  VMINCPHZrrkz,
  VMINCPSYrm,
  VMINCPSYrr,
  VMINCPSZ128rm,
  VMINCPSZ128rmb,
  VMINCPSZ128rmbk,
  VMINCPSZ128rmbkz,
  VMINCPSZ128rmk,
  VMINCPSZ128rmkz,
  VMINCPSZ128rr,
  VMINCPSZ128rrk,
  VMINCPSZ128rrkz,
  VMINCPSZ256rm,
  VMINCPSZ256rmb,
  VMINCPSZ256rmbk,
  VMINCPSZ256rmbkz,
  VMINCPSZ256rmk,
  VMINCPSZ256rmkz,
  VMINCPSZ256rr,
  VMINCPSZ256rrk,
  VMINCPSZ256rrkz,
  VMINCPSZrm,
  VMINCPSZrmb,
  VMINCPSZrmbk,
  VMINCPSZrmbkz,
  VMINCPSZrmk,
  VMINCPSZrmkz,
  VMINCPSZrr,
  VMINCPSZrrk,
  VMINCPSZrrkz,
  VMINCPSrm,
  VMINCPSrr,
  VMINCSDZrm,
  VMINCSDZrr,
  VMINCSDrm,
  VMINCSDrr,
  VMINCSHZrm,
  VMINCSHZrr,
  VMINCSSZrm,
  VMINCSSZrr,
  VMINCSSrm,
  VMINCSSrr,
  VMINMAXBF16Z128rmbi,
  VMINMAXBF16Z128rmbik,
  VMINMAXBF16Z128rmbikz,
  VMINMAXBF16Z128rmi,
  VMINMAXBF16Z128rmik,
  VMINMAXBF16Z128rmikz,
  VMINMAXBF16Z128rri,
  VMINMAXBF16Z128rrik,
  VMINMAXBF16Z128rrikz,
  VMINMAXBF16Z256rmbi,
  VMINMAXBF16Z256rmbik,
  VMINMAXBF16Z256rmbikz,
  VMINMAXBF16Z256rmi,
  VMINMAXBF16Z256rmik,
  VMINMAXBF16Z256rmikz,
  VMINMAXBF16Z256rri,
  VMINMAXBF16Z256rrik,
  VMINMAXBF16Z256rrikz,
  VMINMAXBF16Zrmbi,
  VMINMAXBF16Zrmbik,
  VMINMAXBF16Zrmbikz,
  VMINMAXBF16Zrmi,
  VMINMAXBF16Zrmik,
  VMINMAXBF16Zrmikz,
  VMINMAXBF16Zrri,
  VMINMAXBF16Zrrik,
  VMINMAXBF16Zrrikz,
  VMINMAXPDZ128rmbi,
  VMINMAXPDZ128rmbik,
  VMINMAXPDZ128rmbikz,
  VMINMAXPDZ128rmi,
  VMINMAXPDZ128rmik,
  VMINMAXPDZ128rmikz,
  VMINMAXPDZ128rri,
  VMINMAXPDZ128rrik,
  VMINMAXPDZ128rrikz,
  VMINMAXPDZ256rmbi,
  VMINMAXPDZ256rmbik,
  VMINMAXPDZ256rmbikz,
  VMINMAXPDZ256rmi,
  VMINMAXPDZ256rmik,
  VMINMAXPDZ256rmikz,
  VMINMAXPDZ256rri,
  VMINMAXPDZ256rrik,
  VMINMAXPDZ256rrikz,
  VMINMAXPDZrmbi,
  VMINMAXPDZrmbik,
  VMINMAXPDZrmbikz,
  VMINMAXPDZrmi,
  VMINMAXPDZrmik,
  VMINMAXPDZrmikz,
  VMINMAXPDZrri,
  VMINMAXPDZrrib,
  VMINMAXPDZrribk,
  VMINMAXPDZrribkz,
  VMINMAXPDZrrik,
  VMINMAXPDZrrikz,
  VMINMAXPHZ128rmbi,
  VMINMAXPHZ128rmbik,
  VMINMAXPHZ128rmbikz,
  VMINMAXPHZ128rmi,
  VMINMAXPHZ128rmik,
  VMINMAXPHZ128rmikz,
  VMINMAXPHZ128rri,
  VMINMAXPHZ128rrik,
  VMINMAXPHZ128rrikz,
  VMINMAXPHZ256rmbi,
  VMINMAXPHZ256rmbik,
  VMINMAXPHZ256rmbikz,
  VMINMAXPHZ256rmi,
  VMINMAXPHZ256rmik,
  VMINMAXPHZ256rmikz,
  VMINMAXPHZ256rri,
  VMINMAXPHZ256rrik,
  VMINMAXPHZ256rrikz,
  VMINMAXPHZrmbi,
  VMINMAXPHZrmbik,
  VMINMAXPHZrmbikz,
  VMINMAXPHZrmi,
  VMINMAXPHZrmik,
  VMINMAXPHZrmikz,
  VMINMAXPHZrri,
  VMINMAXPHZrrib,
  VMINMAXPHZrribk,
  VMINMAXPHZrribkz,
  VMINMAXPHZrrik,
  VMINMAXPHZrrikz,
  VMINMAXPSZ128rmbi,
  VMINMAXPSZ128rmbik,
  VMINMAXPSZ128rmbikz,
  VMINMAXPSZ128rmi,
  VMINMAXPSZ128rmik,
  VMINMAXPSZ128rmikz,
  VMINMAXPSZ128rri,
  VMINMAXPSZ128rrik,
  VMINMAXPSZ128rrikz,
  VMINMAXPSZ256rmbi,
  VMINMAXPSZ256rmbik,
  VMINMAXPSZ256rmbikz,
  VMINMAXPSZ256rmi,
  VMINMAXPSZ256rmik,
  VMINMAXPSZ256rmikz,
  VMINMAXPSZ256rri,
  VMINMAXPSZ256rrik,
  VMINMAXPSZ256rrikz,
  VMINMAXPSZrmbi,
  VMINMAXPSZrmbik,
  VMINMAXPSZrmbikz,
  VMINMAXPSZrmi,
  VMINMAXPSZrmik,
  VMINMAXPSZrmikz,
  VMINMAXPSZrri,
  VMINMAXPSZrrib,
  VMINMAXPSZrribk,
  VMINMAXPSZrribkz,
  VMINMAXPSZrrik,
  VMINMAXPSZrrikz,
  VMINMAXSDrmi,
  VMINMAXSDrmi_Int,
  VMINMAXSDrmik_Int,
  VMINMAXSDrmikz_Int,
  VMINMAXSDrri,
  VMINMAXSDrri_Int,
  VMINMAXSDrrib_Int,
  VMINMAXSDrribk_Int,
  VMINMAXSDrribkz_Int,
  VMINMAXSDrrik_Int,
  VMINMAXSDrrikz_Int,
  VMINMAXSHrmi,
  VMINMAXSHrmi_Int,
  VMINMAXSHrmik_Int,
  VMINMAXSHrmikz_Int,
  VMINMAXSHrri,
  VMINMAXSHrri_Int,
  VMINMAXSHrrib_Int,
  VMINMAXSHrribk_Int,
  VMINMAXSHrribkz_Int,
  VMINMAXSHrrik_Int,
  VMINMAXSHrrikz_Int,
  VMINMAXSSrmi,
  VMINMAXSSrmi_Int,
  VMINMAXSSrmik_Int,
  VMINMAXSSrmikz_Int,
  VMINMAXSSrri,
  VMINMAXSSrri_Int,
  VMINMAXSSrrib_Int,
  VMINMAXSSrribk_Int,
  VMINMAXSSrribkz_Int,
  VMINMAXSSrrik_Int,
  VMINMAXSSrrikz_Int,
  VMINPDYrm,
  VMINPDYrr,
  VMINPDZ128rm,
  VMINPDZ128rmb,
  VMINPDZ128rmbk,
  VMINPDZ128rmbkz,
  VMINPDZ128rmk,
  VMINPDZ128rmkz,
  VMINPDZ128rr,
  VMINPDZ128rrk,
  VMINPDZ128rrkz,
  VMINPDZ256rm,
  VMINPDZ256rmb,
  VMINPDZ256rmbk,
  VMINPDZ256rmbkz,
  VMINPDZ256rmk,
  VMINPDZ256rmkz,
  VMINPDZ256rr,
  VMINPDZ256rrk,
  VMINPDZ256rrkz,
  VMINPDZrm,
  VMINPDZrmb,
  VMINPDZrmbk,
  VMINPDZrmbkz,
  VMINPDZrmk,
  VMINPDZrmkz,
  VMINPDZrr,
  VMINPDZrrb,
  VMINPDZrrbk,
  VMINPDZrrbkz,
  VMINPDZrrk,
  VMINPDZrrkz,
  VMINPDrm,
  VMINPDrr,
  VMINPHZ128rm,
  VMINPHZ128rmb,
  VMINPHZ128rmbk,
  VMINPHZ128rmbkz,
  VMINPHZ128rmk,
  VMINPHZ128rmkz,
  VMINPHZ128rr,
  VMINPHZ128rrk,
  VMINPHZ128rrkz,
  VMINPHZ256rm,
  VMINPHZ256rmb,
  VMINPHZ256rmbk,
  VMINPHZ256rmbkz,
  VMINPHZ256rmk,
  VMINPHZ256rmkz,
  VMINPHZ256rr,
  VMINPHZ256rrk,
  VMINPHZ256rrkz,
  VMINPHZrm,
  VMINPHZrmb,
  VMINPHZrmbk,
  VMINPHZrmbkz,
  VMINPHZrmk,
  VMINPHZrmkz,
  VMINPHZrr,
  VMINPHZrrb,
  VMINPHZrrbk,
  VMINPHZrrbkz,
  VMINPHZrrk,
  VMINPHZrrkz,
  VMINPSYrm,
  VMINPSYrr,
  VMINPSZ128rm,
  VMINPSZ128rmb,
  VMINPSZ128rmbk,
  VMINPSZ128rmbkz,
  VMINPSZ128rmk,
  VMINPSZ128rmkz,
  VMINPSZ128rr,
  VMINPSZ128rrk,
  VMINPSZ128rrkz,
  VMINPSZ256rm,
  VMINPSZ256rmb,
  VMINPSZ256rmbk,
  VMINPSZ256rmbkz,
  VMINPSZ256rmk,
  VMINPSZ256rmkz,
  VMINPSZ256rr,
  VMINPSZ256rrk,
  VMINPSZ256rrkz,
  VMINPSZrm,
  VMINPSZrmb,
  VMINPSZrmbk,
  VMINPSZrmbkz,
  VMINPSZrmk,
  VMINPSZrmkz,
  VMINPSZrr,
  VMINPSZrrb,
  VMINPSZrrbk,
  VMINPSZrrbkz,
  VMINPSZrrk,
  VMINPSZrrkz,
  VMINPSrm,
  VMINPSrr,
  VMINSDZrm,
  VMINSDZrm_Int,
  VMINSDZrmk_Int,
  VMINSDZrmkz_Int,
  VMINSDZrr,
  VMINSDZrr_Int,
  VMINSDZrrb_Int,
  VMINSDZrrbk_Int,
  VMINSDZrrbkz_Int,
  VMINSDZrrk_Int,
  VMINSDZrrkz_Int,
  VMINSDrm,
  VMINSDrm_Int,
  VMINSDrr,
  VMINSDrr_Int,
  VMINSHZrm,
  VMINSHZrm_Int,
  VMINSHZrmk_Int,
  VMINSHZrmkz_Int,
  VMINSHZrr,
  VMINSHZrr_Int,
  VMINSHZrrb_Int,
  VMINSHZrrbk_Int,
  VMINSHZrrbkz_Int,
  VMINSHZrrk_Int,
  VMINSHZrrkz_Int,
  VMINSSZrm,
  VMINSSZrm_Int,
  VMINSSZrmk_Int,
  VMINSSZrmkz_Int,
  VMINSSZrr,
  VMINSSZrr_Int,
  VMINSSZrrb_Int,
  VMINSSZrrbk_Int,
  VMINSSZrrbkz_Int,
  VMINSSZrrk_Int,
  VMINSSZrrkz_Int,
  VMINSSrm,
  VMINSSrm_Int,
  VMINSSrr,
  VMINSSrr_Int,
  VMLAUNCH,
  VMLOAD32,
  VMLOAD64,
  VMMCALL,
  VMOV64toPQIZrm,
  VMOV64toPQIZrr,
  VMOV64toPQIrm,
  VMOV64toPQIrr,
  VMOV64toSDZrr,
  VMOV64toSDrr,
  VMOVAPDYmr,
  VMOVAPDYrm,
  VMOVAPDYrr,
  VMOVAPDYrr_REV,
  VMOVAPDZ128mr,
  VMOVAPDZ128mrk,
  VMOVAPDZ128rm,
  VMOVAPDZ128rmk,
  VMOVAPDZ128rmkz,
  VMOVAPDZ128rr,
  VMOVAPDZ128rr_REV,
  VMOVAPDZ128rrk,
  VMOVAPDZ128rrk_REV,
  VMOVAPDZ128rrkz,
  VMOVAPDZ128rrkz_REV,
  VMOVAPDZ256mr,
  VMOVAPDZ256mrk,
  VMOVAPDZ256rm,
  VMOVAPDZ256rmk,
  VMOVAPDZ256rmkz,
  VMOVAPDZ256rr,
  VMOVAPDZ256rr_REV,
  VMOVAPDZ256rrk,
  VMOVAPDZ256rrk_REV,
  VMOVAPDZ256rrkz,
  VMOVAPDZ256rrkz_REV,
  VMOVAPDZmr,
  VMOVAPDZmrk,
  VMOVAPDZrm,
  VMOVAPDZrmk,
  VMOVAPDZrmkz,
  VMOVAPDZrr,
  VMOVAPDZrr_REV,
  VMOVAPDZrrk,
  VMOVAPDZrrk_REV,
  VMOVAPDZrrkz,
  VMOVAPDZrrkz_REV,
  VMOVAPDmr,
  VMOVAPDrm,
  VMOVAPDrr,
  VMOVAPDrr_REV,
  VMOVAPSYmr,
  VMOVAPSYrm,
  VMOVAPSYrr,
  VMOVAPSYrr_REV,
  VMOVAPSZ128mr,
  VMOVAPSZ128mrk,
  VMOVAPSZ128rm,
  VMOVAPSZ128rmk,
  VMOVAPSZ128rmkz,
  VMOVAPSZ128rr,
  VMOVAPSZ128rr_REV,
  VMOVAPSZ128rrk,
  VMOVAPSZ128rrk_REV,
  VMOVAPSZ128rrkz,
  VMOVAPSZ128rrkz_REV,
  VMOVAPSZ256mr,
  VMOVAPSZ256mrk,
  VMOVAPSZ256rm,
  VMOVAPSZ256rmk,
  VMOVAPSZ256rmkz,
  VMOVAPSZ256rr,
  VMOVAPSZ256rr_REV,
  VMOVAPSZ256rrk,
  VMOVAPSZ256rrk_REV,
  VMOVAPSZ256rrkz,
  VMOVAPSZ256rrkz_REV,
  VMOVAPSZmr,
  VMOVAPSZmrk,
  VMOVAPSZrm,
  VMOVAPSZrmk,
  VMOVAPSZrmkz,
  VMOVAPSZrr,
  VMOVAPSZrr_REV,
  VMOVAPSZrrk,
  VMOVAPSZrrk_REV,
  VMOVAPSZrrkz,
  VMOVAPSZrrkz_REV,
  VMOVAPSmr,
  VMOVAPSrm,
  VMOVAPSrr,
  VMOVAPSrr_REV,
  VMOVDDUPYrm,
  VMOVDDUPYrr,
  VMOVDDUPZ128rm,
  VMOVDDUPZ128rmk,
  VMOVDDUPZ128rmkz,
  VMOVDDUPZ128rr,
  VMOVDDUPZ128rrk,
  VMOVDDUPZ128rrkz,
  VMOVDDUPZ256rm,
  VMOVDDUPZ256rmk,
  VMOVDDUPZ256rmkz,
  VMOVDDUPZ256rr,
  VMOVDDUPZ256rrk,
  VMOVDDUPZ256rrkz,
  VMOVDDUPZrm,
  VMOVDDUPZrmk,
  VMOVDDUPZrmkz,
  VMOVDDUPZrr,
  VMOVDDUPZrrk,
  VMOVDDUPZrrkz,
  VMOVDDUPrm,
  VMOVDDUPrr,
  VMOVDI2PDIZrm,
  VMOVDI2PDIZrr,
  VMOVDI2PDIrm,
  VMOVDI2PDIrr,
  VMOVDI2SSZrr,
  VMOVDI2SSrr,
  VMOVDQA32Z128mr,
  VMOVDQA32Z128mrk,
  VMOVDQA32Z128rm,
  VMOVDQA32Z128rmk,
  VMOVDQA32Z128rmkz,
  VMOVDQA32Z128rr,
  VMOVDQA32Z128rr_REV,
  VMOVDQA32Z128rrk,
  VMOVDQA32Z128rrk_REV,
  VMOVDQA32Z128rrkz,
  VMOVDQA32Z128rrkz_REV,
  VMOVDQA32Z256mr,
  VMOVDQA32Z256mrk,
  VMOVDQA32Z256rm,
  VMOVDQA32Z256rmk,
  VMOVDQA32Z256rmkz,
  VMOVDQA32Z256rr,
  VMOVDQA32Z256rr_REV,
  VMOVDQA32Z256rrk,
  VMOVDQA32Z256rrk_REV,
  VMOVDQA32Z256rrkz,
  VMOVDQA32Z256rrkz_REV,
  VMOVDQA32Zmr,
  VMOVDQA32Zmrk,
  VMOVDQA32Zrm,
  VMOVDQA32Zrmk,
  VMOVDQA32Zrmkz,
  VMOVDQA32Zrr,
  VMOVDQA32Zrr_REV,
  VMOVDQA32Zrrk,
  VMOVDQA32Zrrk_REV,
  VMOVDQA32Zrrkz,
  VMOVDQA32Zrrkz_REV,
  VMOVDQA64Z128mr,
  VMOVDQA64Z128mrk,
  VMOVDQA64Z128rm,
  VMOVDQA64Z128rmk,
  VMOVDQA64Z128rmkz,
  VMOVDQA64Z128rr,
  VMOVDQA64Z128rr_REV,
  VMOVDQA64Z128rrk,
  VMOVDQA64Z128rrk_REV,
  VMOVDQA64Z128rrkz,
  VMOVDQA64Z128rrkz_REV,
  VMOVDQA64Z256mr,
  VMOVDQA64Z256mrk,
  VMOVDQA64Z256rm,
  VMOVDQA64Z256rmk,
  VMOVDQA64Z256rmkz,
  VMOVDQA64Z256rr,
  VMOVDQA64Z256rr_REV,
  VMOVDQA64Z256rrk,
  VMOVDQA64Z256rrk_REV,
  VMOVDQA64Z256rrkz,
  VMOVDQA64Z256rrkz_REV,
  VMOVDQA64Zmr,
  VMOVDQA64Zmrk,
  VMOVDQA64Zrm,
  VMOVDQA64Zrmk,
  VMOVDQA64Zrmkz,
  VMOVDQA64Zrr,
  VMOVDQA64Zrr_REV,
  VMOVDQA64Zrrk,
  VMOVDQA64Zrrk_REV,
  VMOVDQA64Zrrkz,
  VMOVDQA64Zrrkz_REV,
  VMOVDQAYmr,
  VMOVDQAYrm,
  VMOVDQAYrr,
  VMOVDQAYrr_REV,
  VMOVDQAmr,
  VMOVDQArm,
  VMOVDQArr,
  VMOVDQArr_REV,
  VMOVDQU16Z128mr,
  VMOVDQU16Z128mrk,
  VMOVDQU16Z128rm,
  VMOVDQU16Z128rmk,
  VMOVDQU16Z128rmkz,
  VMOVDQU16Z128rr,
  VMOVDQU16Z128rr_REV,
  VMOVDQU16Z128rrk,
  VMOVDQU16Z128rrk_REV,
  VMOVDQU16Z128rrkz,
  VMOVDQU16Z128rrkz_REV,
  VMOVDQU16Z256mr,
  VMOVDQU16Z256mrk,
  VMOVDQU16Z256rm,
  VMOVDQU16Z256rmk,
  VMOVDQU16Z256rmkz,
  VMOVDQU16Z256rr,
  VMOVDQU16Z256rr_REV,
  VMOVDQU16Z256rrk,
  VMOVDQU16Z256rrk_REV,
  VMOVDQU16Z256rrkz,
  VMOVDQU16Z256rrkz_REV,
  VMOVDQU16Zmr,
  VMOVDQU16Zmrk,
  VMOVDQU16Zrm,
  VMOVDQU16Zrmk,
  VMOVDQU16Zrmkz,
  VMOVDQU16Zrr,
  VMOVDQU16Zrr_REV,
  VMOVDQU16Zrrk,
  VMOVDQU16Zrrk_REV,
  VMOVDQU16Zrrkz,
  VMOVDQU16Zrrkz_REV,
  VMOVDQU32Z128mr,
  VMOVDQU32Z128mrk,
  VMOVDQU32Z128rm,
  VMOVDQU32Z128rmk,
  VMOVDQU32Z128rmkz,
  VMOVDQU32Z128rr,
  VMOVDQU32Z128rr_REV,
  VMOVDQU32Z128rrk,
  VMOVDQU32Z128rrk_REV,
  VMOVDQU32Z128rrkz,
  VMOVDQU32Z128rrkz_REV,
  VMOVDQU32Z256mr,
  VMOVDQU32Z256mrk,
  VMOVDQU32Z256rm,
  VMOVDQU32Z256rmk,
  VMOVDQU32Z256rmkz,
  VMOVDQU32Z256rr,
  VMOVDQU32Z256rr_REV,
  VMOVDQU32Z256rrk,
  VMOVDQU32Z256rrk_REV,
  VMOVDQU32Z256rrkz,
  VMOVDQU32Z256rrkz_REV,
  VMOVDQU32Zmr,
  VMOVDQU32Zmrk,
  VMOVDQU32Zrm,
  VMOVDQU32Zrmk,
  VMOVDQU32Zrmkz,
  VMOVDQU32Zrr,
  VMOVDQU32Zrr_REV,
  VMOVDQU32Zrrk,
  VMOVDQU32Zrrk_REV,
  VMOVDQU32Zrrkz,
  VMOVDQU32Zrrkz_REV,
  VMOVDQU64Z128mr,
  VMOVDQU64Z128mrk,
  VMOVDQU64Z128rm,
  VMOVDQU64Z128rmk,
  VMOVDQU64Z128rmkz,
  VMOVDQU64Z128rr,
  VMOVDQU64Z128rr_REV,
  VMOVDQU64Z128rrk,
  VMOVDQU64Z128rrk_REV,
  VMOVDQU64Z128rrkz,
  VMOVDQU64Z128rrkz_REV,
  VMOVDQU64Z256mr,
  VMOVDQU64Z256mrk,
  VMOVDQU64Z256rm,
  VMOVDQU64Z256rmk,
  VMOVDQU64Z256rmkz,
  VMOVDQU64Z256rr,
  VMOVDQU64Z256rr_REV,
  VMOVDQU64Z256rrk,
  VMOVDQU64Z256rrk_REV,
  VMOVDQU64Z256rrkz,
  VMOVDQU64Z256rrkz_REV,
  VMOVDQU64Zmr,
  VMOVDQU64Zmrk,
  VMOVDQU64Zrm,
  VMOVDQU64Zrmk,
  VMOVDQU64Zrmkz,
  VMOVDQU64Zrr,
  VMOVDQU64Zrr_REV,
  VMOVDQU64Zrrk,
  VMOVDQU64Zrrk_REV,
  VMOVDQU64Zrrkz,
  VMOVDQU64Zrrkz_REV,
  VMOVDQU8Z128mr,
  VMOVDQU8Z128mrk,
  VMOVDQU8Z128rm,
  VMOVDQU8Z128rmk,
  VMOVDQU8Z128rmkz,
  VMOVDQU8Z128rr,
  VMOVDQU8Z128rr_REV,
  VMOVDQU8Z128rrk,
  VMOVDQU8Z128rrk_REV,
  VMOVDQU8Z128rrkz,
  VMOVDQU8Z128rrkz_REV,
  VMOVDQU8Z256mr,
  VMOVDQU8Z256mrk,
  VMOVDQU8Z256rm,
  VMOVDQU8Z256rmk,
  VMOVDQU8Z256rmkz,
  VMOVDQU8Z256rr,
  VMOVDQU8Z256rr_REV,
  VMOVDQU8Z256rrk,
  VMOVDQU8Z256rrk_REV,
  VMOVDQU8Z256rrkz,
  VMOVDQU8Z256rrkz_REV,
  VMOVDQU8Zmr,
  VMOVDQU8Zmrk,
  VMOVDQU8Zrm,
  VMOVDQU8Zrmk,
  VMOVDQU8Zrmkz,
  VMOVDQU8Zrr,
  VMOVDQU8Zrr_REV,
  VMOVDQU8Zrrk,
  VMOVDQU8Zrrk_REV,
  VMOVDQU8Zrrkz,
  VMOVDQU8Zrrkz_REV,
  VMOVDQUYmr,
  VMOVDQUYrm,
  VMOVDQUYrr,
  VMOVDQUYrr_REV,
  VMOVDQUmr,
  VMOVDQUrm,
  VMOVDQUrr,
  VMOVDQUrr_REV,
  VMOVHLPSZrr,
  VMOVHLPSrr,
  VMOVHPDZ128mr,
  VMOVHPDZ128rm,
  VMOVHPDmr,
  VMOVHPDrm,
  VMOVHPSZ128mr,
  VMOVHPSZ128rm,
  VMOVHPSmr,
  VMOVHPSrm,
  VMOVLHPSZrr,
  VMOVLHPSrr,
  VMOVLPDZ128mr,
  VMOVLPDZ128rm,
  VMOVLPDmr,
  VMOVLPDrm,
  VMOVLPSZ128mr,
  VMOVLPSZ128rm,
  VMOVLPSmr,
  VMOVLPSrm,
  VMOVMSKPDYrr,
  VMOVMSKPDrr,
  VMOVMSKPSYrr,
  VMOVMSKPSrr,
  VMOVNTDQAYrm,
  VMOVNTDQAZ128rm,
  VMOVNTDQAZ256rm,
  VMOVNTDQAZrm,
  VMOVNTDQArm,
  VMOVNTDQYmr,
  VMOVNTDQZ128mr,
  VMOVNTDQZ256mr,
  VMOVNTDQZmr,
  VMOVNTDQmr,
  VMOVNTPDYmr,
  VMOVNTPDZ128mr,
  VMOVNTPDZ256mr,
  VMOVNTPDZmr,
  VMOVNTPDmr,
  VMOVNTPSYmr,
  VMOVNTPSZ128mr,
  VMOVNTPSZ256mr,
  VMOVNTPSZmr,
  VMOVNTPSmr,
  VMOVPDI2DIZmr,
  VMOVPDI2DIZrr,
  VMOVPDI2DImr,
  VMOVPDI2DIrr,
  VMOVPQI2QIZmr,
  VMOVPQI2QIZrr,
  VMOVPQI2QImr,
  VMOVPQI2QIrr,
  VMOVPQIto64Zmr,
  VMOVPQIto64Zrr,
  VMOVPQIto64mr,
  VMOVPQIto64rr,
  VMOVQI2PQIZrm,
  VMOVQI2PQIrm,
  VMOVRSBZ128m,
  VMOVRSBZ128mk,
  VMOVRSBZ128mkz,
  VMOVRSBZ256m,
  VMOVRSBZ256mk,
  VMOVRSBZ256mkz,
  VMOVRSBZm,
  VMOVRSBZmk,
  VMOVRSBZmkz,
  VMOVRSDZ128m,
  VMOVRSDZ128mk,
  VMOVRSDZ128mkz,
  VMOVRSDZ256m,
  VMOVRSDZ256mk,
  VMOVRSDZ256mkz,
  VMOVRSDZm,
  VMOVRSDZmk,
  VMOVRSDZmkz,
  VMOVRSQZ128m,
  VMOVRSQZ128mk,
  VMOVRSQZ128mkz,
  VMOVRSQZ256m,
  VMOVRSQZ256mk,
  VMOVRSQZ256mkz,
  VMOVRSQZm,
  VMOVRSQZmk,
  VMOVRSQZmkz,
  VMOVRSWZ128m,
  VMOVRSWZ128mk,
  VMOVRSWZ128mkz,
  VMOVRSWZ256m,
  VMOVRSWZ256mk,
  VMOVRSWZ256mkz,
  VMOVRSWZm,
  VMOVRSWZmk,
  VMOVRSWZmkz,
  VMOVSDZmr,
  VMOVSDZmrk,
  VMOVSDZrm,
  VMOVSDZrm_alt,
  VMOVSDZrmk,
  VMOVSDZrmkz,
  VMOVSDZrr,
  VMOVSDZrr_REV,
  VMOVSDZrrk,
  VMOVSDZrrk_REV,
  VMOVSDZrrkz,
  VMOVSDZrrkz_REV,
  VMOVSDmr,
  VMOVSDrm,
  VMOVSDrm_alt,
  VMOVSDrr,
  VMOVSDrr_REV,
  VMOVSDto64Zrr,
  VMOVSDto64rr,
  VMOVSH2Wrr,
  VMOVSHDUPYrm,
  VMOVSHDUPYrr,
  VMOVSHDUPZ128rm,
  VMOVSHDUPZ128rmk,
  VMOVSHDUPZ128rmkz,
  VMOVSHDUPZ128rr,
  VMOVSHDUPZ128rrk,
  VMOVSHDUPZ128rrkz,
  VMOVSHDUPZ256rm,
  VMOVSHDUPZ256rmk,
  VMOVSHDUPZ256rmkz,
  VMOVSHDUPZ256rr,
  VMOVSHDUPZ256rrk,
  VMOVSHDUPZ256rrkz,
  VMOVSHDUPZrm,
  VMOVSHDUPZrmk,
  VMOVSHDUPZrmkz,
  VMOVSHDUPZrr,
  VMOVSHDUPZrrk,
  VMOVSHDUPZrrkz,
  VMOVSHDUPrm,
  VMOVSHDUPrr,
  VMOVSHZmr,
  VMOVSHZmrk,
  VMOVSHZrm,
  VMOVSHZrm_alt,
  VMOVSHZrmk,
  VMOVSHZrmkz,
  VMOVSHZrr,
  VMOVSHZrr_REV,
  VMOVSHZrrk,
  VMOVSHZrrk_REV,
  VMOVSHZrrkz,
  VMOVSHZrrkz_REV,
  VMOVSHtoW64rr,
  VMOVSLDUPYrm,
  VMOVSLDUPYrr,
  VMOVSLDUPZ128rm,
  VMOVSLDUPZ128rmk,
  VMOVSLDUPZ128rmkz,
  VMOVSLDUPZ128rr,
  VMOVSLDUPZ128rrk,
  VMOVSLDUPZ128rrkz,
  VMOVSLDUPZ256rm,
  VMOVSLDUPZ256rmk,
  VMOVSLDUPZ256rmkz,
  VMOVSLDUPZ256rr,
  VMOVSLDUPZ256rrk,
  VMOVSLDUPZ256rrkz,
  VMOVSLDUPZrm,
  VMOVSLDUPZrmk,
  VMOVSLDUPZrmkz,
  VMOVSLDUPZrr,
  VMOVSLDUPZrrk,
  VMOVSLDUPZrrkz,
  VMOVSLDUPrm,
  VMOVSLDUPrr,
  VMOVSS2DIZrr,
  VMOVSS2DIrr,
  VMOVSSZmr,
  VMOVSSZmrk,
  VMOVSSZrm,
  VMOVSSZrm_alt,
  VMOVSSZrmk,
  VMOVSSZrmkz,
  VMOVSSZrr,
  VMOVSSZrr_REV,
  VMOVSSZrrk,
  VMOVSSZrrk_REV,
  VMOVSSZrrkz,
  VMOVSSZrrkz_REV,
  VMOVSSmr,
  VMOVSSrm,
  VMOVSSrm_alt,
  VMOVSSrr,
  VMOVSSrr_REV,
  VMOVUPDYmr,
  VMOVUPDYrm,
  VMOVUPDYrr,
  VMOVUPDYrr_REV,
  VMOVUPDZ128mr,
  VMOVUPDZ128mrk,
  VMOVUPDZ128rm,
  VMOVUPDZ128rmk,
  VMOVUPDZ128rmkz,
  VMOVUPDZ128rr,
  VMOVUPDZ128rr_REV,
  VMOVUPDZ128rrk,
  VMOVUPDZ128rrk_REV,
  VMOVUPDZ128rrkz,
  VMOVUPDZ128rrkz_REV,
  VMOVUPDZ256mr,
  VMOVUPDZ256mrk,
  VMOVUPDZ256rm,
  VMOVUPDZ256rmk,
  VMOVUPDZ256rmkz,
  VMOVUPDZ256rr,
  VMOVUPDZ256rr_REV,
  VMOVUPDZ256rrk,
  VMOVUPDZ256rrk_REV,
  VMOVUPDZ256rrkz,
  VMOVUPDZ256rrkz_REV,
  VMOVUPDZmr,
  VMOVUPDZmrk,
  VMOVUPDZrm,
  VMOVUPDZrmk,
  VMOVUPDZrmkz,
  VMOVUPDZrr,
  VMOVUPDZrr_REV,
  VMOVUPDZrrk,
  VMOVUPDZrrk_REV,
  VMOVUPDZrrkz,
  VMOVUPDZrrkz_REV,
  VMOVUPDmr,
  VMOVUPDrm,
  VMOVUPDrr,
  VMOVUPDrr_REV,
  VMOVUPSYmr,
  VMOVUPSYrm,
  VMOVUPSYrr,
  VMOVUPSYrr_REV,
  VMOVUPSZ128mr,
  VMOVUPSZ128mrk,
  VMOVUPSZ128rm,
  VMOVUPSZ128rmk,
  VMOVUPSZ128rmkz,
  VMOVUPSZ128rr,
  VMOVUPSZ128rr_REV,
  VMOVUPSZ128rrk,
  VMOVUPSZ128rrk_REV,
  VMOVUPSZ128rrkz,
  VMOVUPSZ128rrkz_REV,
  VMOVUPSZ256mr,
  VMOVUPSZ256mrk,
  VMOVUPSZ256rm,
  VMOVUPSZ256rmk,
  VMOVUPSZ256rmkz,
  VMOVUPSZ256rr,
  VMOVUPSZ256rr_REV,
  VMOVUPSZ256rrk,
  VMOVUPSZ256rrk_REV,
  VMOVUPSZ256rrkz,
  VMOVUPSZ256rrkz_REV,
  VMOVUPSZmr,
  VMOVUPSZmrk,
  VMOVUPSZrm,
  VMOVUPSZrmk,
  VMOVUPSZrmkz,
  VMOVUPSZrr,
  VMOVUPSZrr_REV,
  VMOVUPSZrrk,
  VMOVUPSZrrk_REV,
  VMOVUPSZrrkz,
  VMOVUPSZrrkz_REV,
  VMOVUPSmr,
  VMOVUPSrm,
  VMOVUPSrr,
  VMOVUPSrr_REV,
  VMOVW2SHrr,
  VMOVW64toSHrr,
  VMOVWmr,
  VMOVWrm,
  VMOVZPDILo2PDIZmr,
  VMOVZPDILo2PDIZrm,
  VMOVZPDILo2PDIZrr,
  VMOVZPDILo2PDIZrr2,
  VMOVZPQILo2PQIZrr,
  VMOVZPQILo2PQIrr,
  VMOVZPWILo2PWIZmr,
  VMOVZPWILo2PWIZrm,
  VMOVZPWILo2PWIZrr,
  VMOVZPWILo2PWIZrr2,
  VMPSADBWYrmi,
  VMPSADBWYrri,
  VMPSADBWZ128rmi,
  VMPSADBWZ128rmik,
  VMPSADBWZ128rmikz,
  VMPSADBWZ128rri,
  VMPSADBWZ128rrik,
  VMPSADBWZ128rrikz,
  VMPSADBWZ256rmi,
  VMPSADBWZ256rmik,
  VMPSADBWZ256rmikz,
  VMPSADBWZ256rri,
  VMPSADBWZ256rrik,
  VMPSADBWZ256rrikz,
  VMPSADBWZrmi,
  VMPSADBWZrmik,
  VMPSADBWZrmikz,
  VMPSADBWZrri,
  VMPSADBWZrrik,
  VMPSADBWZrrikz,
  VMPSADBWrmi,
  VMPSADBWrri,
  VMPTRLDm,
  VMPTRSTm,
  VMREAD32mr,
  VMREAD32rr,
  VMREAD64mr,
  VMREAD64rr,
  VMRESUME,
  VMRUN32,
  VMRUN64,
  VMSAVE32,
  VMSAVE64,
  VMULBF16Z128rm,
  VMULBF16Z128rmb,
  VMULBF16Z128rmbk,
  VMULBF16Z128rmbkz,
  VMULBF16Z128rmk,
  VMULBF16Z128rmkz,
  VMULBF16Z128rr,
  VMULBF16Z128rrk,
  VMULBF16Z128rrkz,
  VMULBF16Z256rm,
  VMULBF16Z256rmb,
  VMULBF16Z256rmbk,
  VMULBF16Z256rmbkz,
  VMULBF16Z256rmk,
  VMULBF16Z256rmkz,
  VMULBF16Z256rr,
  VMULBF16Z256rrk,
  VMULBF16Z256rrkz,
  VMULBF16Zrm,
  VMULBF16Zrmb,
  VMULBF16Zrmbk,
  VMULBF16Zrmbkz,
  VMULBF16Zrmk,
  VMULBF16Zrmkz,
  VMULBF16Zrr,
  VMULBF16Zrrk,
  VMULBF16Zrrkz,
  VMULPDYrm,
  VMULPDYrr,
  VMULPDZ128rm,
  VMULPDZ128rmb,
  VMULPDZ128rmbk,
  VMULPDZ128rmbkz,
  VMULPDZ128rmk,
  VMULPDZ128rmkz,
  VMULPDZ128rr,
  VMULPDZ128rrk,
  VMULPDZ128rrkz,
  VMULPDZ256rm,
  VMULPDZ256rmb,
  VMULPDZ256rmbk,
  VMULPDZ256rmbkz,
  VMULPDZ256rmk,
  VMULPDZ256rmkz,
  VMULPDZ256rr,
  VMULPDZ256rrk,
  VMULPDZ256rrkz,
  VMULPDZrm,
  VMULPDZrmb,
  VMULPDZrmbk,
  VMULPDZrmbkz,
  VMULPDZrmk,
  VMULPDZrmkz,
  VMULPDZrr,
  VMULPDZrrb,
  VMULPDZrrbk,
  VMULPDZrrbkz,
  VMULPDZrrk,
  VMULPDZrrkz,
  VMULPDrm,
  VMULPDrr,
  VMULPHZ128rm,
  VMULPHZ128rmb,
  VMULPHZ128rmbk,
  VMULPHZ128rmbkz,
  VMULPHZ128rmk,
  VMULPHZ128rmkz,
  VMULPHZ128rr,
  VMULPHZ128rrk,
  VMULPHZ128rrkz,
  VMULPHZ256rm,
  VMULPHZ256rmb,
  VMULPHZ256rmbk,
  VMULPHZ256rmbkz,
  VMULPHZ256rmk,
  VMULPHZ256rmkz,
  VMULPHZ256rr,
  VMULPHZ256rrk,
  VMULPHZ256rrkz,
  VMULPHZrm,
  VMULPHZrmb,
  VMULPHZrmbk,
  VMULPHZrmbkz,
  VMULPHZrmk,
  VMULPHZrmkz,
  VMULPHZrr,
  VMULPHZrrb,
  VMULPHZrrbk,
  VMULPHZrrbkz,
  VMULPHZrrk,
  VMULPHZrrkz,
  VMULPSYrm,
  VMULPSYrr,
  VMULPSZ128rm,
  VMULPSZ128rmb,
  VMULPSZ128rmbk,
  VMULPSZ128rmbkz,
  VMULPSZ128rmk,
  VMULPSZ128rmkz,
  VMULPSZ128rr,
  VMULPSZ128rrk,
  VMULPSZ128rrkz,
  VMULPSZ256rm,
  VMULPSZ256rmb,
  VMULPSZ256rmbk,
  VMULPSZ256rmbkz,
  VMULPSZ256rmk,
  VMULPSZ256rmkz,
  VMULPSZ256rr,
  VMULPSZ256rrk,
  VMULPSZ256rrkz,
  VMULPSZrm,
  VMULPSZrmb,
  VMULPSZrmbk,
  VMULPSZrmbkz,
  VMULPSZrmk,
  VMULPSZrmkz,
  VMULPSZrr,
  VMULPSZrrb,
  VMULPSZrrbk,
  VMULPSZrrbkz,
  VMULPSZrrk,
  VMULPSZrrkz,
  VMULPSrm,
  VMULPSrr,
  VMULSDZrm,
  VMULSDZrm_Int,
  VMULSDZrmk_Int,
  VMULSDZrmkz_Int,
  VMULSDZrr,
  VMULSDZrr_Int,
  VMULSDZrrb_Int,
  VMULSDZrrbk_Int,
  VMULSDZrrbkz_Int,
  VMULSDZrrk_Int,
  VMULSDZrrkz_Int,
  VMULSDrm,
  VMULSDrm_Int,
  VMULSDrr,
  VMULSDrr_Int,
  VMULSHZrm,
  VMULSHZrm_Int,
  VMULSHZrmk_Int,
  VMULSHZrmkz_Int,
  VMULSHZrr,
  VMULSHZrr_Int,
  VMULSHZrrb_Int,
  VMULSHZrrbk_Int,
  VMULSHZrrbkz_Int,
  VMULSHZrrk_Int,
  VMULSHZrrkz_Int,
  VMULSSZrm,
  VMULSSZrm_Int,
  VMULSSZrmk_Int,
  VMULSSZrmkz_Int,
  VMULSSZrr,
  VMULSSZrr_Int,
  VMULSSZrrb_Int,
  VMULSSZrrbk_Int,
  VMULSSZrrbkz_Int,
  VMULSSZrrk_Int,
  VMULSSZrrkz_Int,
  VMULSSrm,
  VMULSSrm_Int,
  VMULSSrr,
  VMULSSrr_Int,
  VMWRITE32rm,
  VMWRITE32rr,
  VMWRITE64rm,
  VMWRITE64rr,
  VMXOFF,
  VMXON,
  VORPDYrm,
  VORPDYrr,
  VORPDZ128rm,
  VORPDZ128rmb,
  VORPDZ128rmbk,
  VORPDZ128rmbkz,
  VORPDZ128rmk,
  VORPDZ128rmkz,
  VORPDZ128rr,
  VORPDZ128rrk,
  VORPDZ128rrkz,
  VORPDZ256rm,
  VORPDZ256rmb,
  VORPDZ256rmbk,
  VORPDZ256rmbkz,
  VORPDZ256rmk,
  VORPDZ256rmkz,
  VORPDZ256rr,
  VORPDZ256rrk,
  VORPDZ256rrkz,
  VORPDZrm,
  VORPDZrmb,
  VORPDZrmbk,
  VORPDZrmbkz,
  VORPDZrmk,
  VORPDZrmkz,
  VORPDZrr,
  VORPDZrrk,
  VORPDZrrkz,
  VORPDrm,
  VORPDrr,
  VORPSYrm,
  VORPSYrr,
  VORPSZ128rm,
  VORPSZ128rmb,
  VORPSZ128rmbk,
  VORPSZ128rmbkz,
  VORPSZ128rmk,
  VORPSZ128rmkz,
  VORPSZ128rr,
  VORPSZ128rrk,
  VORPSZ128rrkz,
  VORPSZ256rm,
  VORPSZ256rmb,
  VORPSZ256rmbk,
  VORPSZ256rmbkz,
  VORPSZ256rmk,
  VORPSZ256rmkz,
  VORPSZ256rr,
  VORPSZ256rrk,
  VORPSZ256rrkz,
  VORPSZrm,
  VORPSZrmb,
  VORPSZrmbk,
  VORPSZrmbkz,
  VORPSZrmk,
  VORPSZrmkz,
  VORPSZrr,
  VORPSZrrk,
  VORPSZrrkz,
  VORPSrm,
  VORPSrr,
  VP2INTERSECTDZ128rm,
  VP2INTERSECTDZ128rmb,
  VP2INTERSECTDZ128rr,
  VP2INTERSECTDZ256rm,
  VP2INTERSECTDZ256rmb,
  VP2INTERSECTDZ256rr,
  VP2INTERSECTDZrm,
  VP2INTERSECTDZrmb,
  VP2INTERSECTDZrr,
  VP2INTERSECTQZ128rm,
  VP2INTERSECTQZ128rmb,
  VP2INTERSECTQZ128rr,
  VP2INTERSECTQZ256rm,
  VP2INTERSECTQZ256rmb,
  VP2INTERSECTQZ256rr,
  VP2INTERSECTQZrm,
  VP2INTERSECTQZrmb,
  VP2INTERSECTQZrr,
  VP4DPWSSDSrm,
  VP4DPWSSDSrmk,
  VP4DPWSSDSrmkz,
  VP4DPWSSDrm,
  VP4DPWSSDrmk,
  VP4DPWSSDrmkz,
  VPABSBYrm,
  VPABSBYrr,
  VPABSBZ128rm,
  VPABSBZ128rmk,
  VPABSBZ128rmkz,
  VPABSBZ128rr,
  VPABSBZ128rrk,
  VPABSBZ128rrkz,
  VPABSBZ256rm,
  VPABSBZ256rmk,
  VPABSBZ256rmkz,
  VPABSBZ256rr,
  VPABSBZ256rrk,
  VPABSBZ256rrkz,
  VPABSBZrm,
  VPABSBZrmk,
  VPABSBZrmkz,
  VPABSBZrr,
  VPABSBZrrk,
  VPABSBZrrkz,
  VPABSBrm,
  VPABSBrr,
  VPABSDYrm,
  VPABSDYrr,
  VPABSDZ128rm,
  VPABSDZ128rmb,
  VPABSDZ128rmbk,
  VPABSDZ128rmbkz,
  VPABSDZ128rmk,
  VPABSDZ128rmkz,
  VPABSDZ128rr,
  VPABSDZ128rrk,
  VPABSDZ128rrkz,
  VPABSDZ256rm,
  VPABSDZ256rmb,
  VPABSDZ256rmbk,
  VPABSDZ256rmbkz,
  VPABSDZ256rmk,
  VPABSDZ256rmkz,
  VPABSDZ256rr,
  VPABSDZ256rrk,
  VPABSDZ256rrkz,
  VPABSDZrm,
  VPABSDZrmb,
  VPABSDZrmbk,
  VPABSDZrmbkz,
  VPABSDZrmk,
  VPABSDZrmkz,
  VPABSDZrr,
  VPABSDZrrk,
  VPABSDZrrkz,
  VPABSDrm,
  VPABSDrr,
  VPABSQZ128rm,
  VPABSQZ128rmb,
  VPABSQZ128rmbk,
  VPABSQZ128rmbkz,
  VPABSQZ128rmk,
  VPABSQZ128rmkz,
  VPABSQZ128rr,
  VPABSQZ128rrk,
  VPABSQZ128rrkz,
  VPABSQZ256rm,
  VPABSQZ256rmb,
  VPABSQZ256rmbk,
  VPABSQZ256rmbkz,
  VPABSQZ256rmk,
  VPABSQZ256rmkz,
  VPABSQZ256rr,
  VPABSQZ256rrk,
  VPABSQZ256rrkz,
  VPABSQZrm,
  VPABSQZrmb,
  VPABSQZrmbk,
  VPABSQZrmbkz,
  VPABSQZrmk,
  VPABSQZrmkz,
  VPABSQZrr,
  VPABSQZrrk,
  VPABSQZrrkz,
  VPABSWYrm,
  VPABSWYrr,
  VPABSWZ128rm,
  VPABSWZ128rmk,
  VPABSWZ128rmkz,
  VPABSWZ128rr,
  VPABSWZ128rrk,
  VPABSWZ128rrkz,
  VPABSWZ256rm,
  VPABSWZ256rmk,
  VPABSWZ256rmkz,
  VPABSWZ256rr,
  VPABSWZ256rrk,
  VPABSWZ256rrkz,
  VPABSWZrm,
  VPABSWZrmk,
  VPABSWZrmkz,
  VPABSWZrr,
  VPABSWZrrk,
  VPABSWZrrkz,
  VPABSWrm,
  VPABSWrr,
  VPACKSSDWYrm,
  VPACKSSDWYrr,
  VPACKSSDWZ128rm,
  VPACKSSDWZ128rmb,
  VPACKSSDWZ128rmbk,
  VPACKSSDWZ128rmbkz,
  VPACKSSDWZ128rmk,
  VPACKSSDWZ128rmkz,
  VPACKSSDWZ128rr,
  VPACKSSDWZ128rrk,
  VPACKSSDWZ128rrkz,
  VPACKSSDWZ256rm,
  VPACKSSDWZ256rmb,
  VPACKSSDWZ256rmbk,
  VPACKSSDWZ256rmbkz,
  VPACKSSDWZ256rmk,
  VPACKSSDWZ256rmkz,
  VPACKSSDWZ256rr,
  VPACKSSDWZ256rrk,
  VPACKSSDWZ256rrkz,
  VPACKSSDWZrm,
  VPACKSSDWZrmb,
  VPACKSSDWZrmbk,
  VPACKSSDWZrmbkz,
  VPACKSSDWZrmk,
  VPACKSSDWZrmkz,
  VPACKSSDWZrr,
  VPACKSSDWZrrk,
  VPACKSSDWZrrkz,
  VPACKSSDWrm,
  VPACKSSDWrr,
  VPACKSSWBYrm,
  VPACKSSWBYrr,
  VPACKSSWBZ128rm,
  VPACKSSWBZ128rmk,
  VPACKSSWBZ128rmkz,
  VPACKSSWBZ128rr,
  VPACKSSWBZ128rrk,
  VPACKSSWBZ128rrkz,
  VPACKSSWBZ256rm,
  VPACKSSWBZ256rmk,
  VPACKSSWBZ256rmkz,
  VPACKSSWBZ256rr,
  VPACKSSWBZ256rrk,
  VPACKSSWBZ256rrkz,
  VPACKSSWBZrm,
  VPACKSSWBZrmk,
  VPACKSSWBZrmkz,
  VPACKSSWBZrr,
  VPACKSSWBZrrk,
  VPACKSSWBZrrkz,
  VPACKSSWBrm,
  VPACKSSWBrr,
  VPACKUSDWYrm,
  VPACKUSDWYrr,
  VPACKUSDWZ128rm,
  VPACKUSDWZ128rmb,
  VPACKUSDWZ128rmbk,
  VPACKUSDWZ128rmbkz,
  VPACKUSDWZ128rmk,
  VPACKUSDWZ128rmkz,
  VPACKUSDWZ128rr,
  VPACKUSDWZ128rrk,
  VPACKUSDWZ128rrkz,
  VPACKUSDWZ256rm,
  VPACKUSDWZ256rmb,
  VPACKUSDWZ256rmbk,
  VPACKUSDWZ256rmbkz,
  VPACKUSDWZ256rmk,
  VPACKUSDWZ256rmkz,
  VPACKUSDWZ256rr,
  VPACKUSDWZ256rrk,
  VPACKUSDWZ256rrkz,
  VPACKUSDWZrm,
  VPACKUSDWZrmb,
  VPACKUSDWZrmbk,
  VPACKUSDWZrmbkz,
  VPACKUSDWZrmk,
  VPACKUSDWZrmkz,
  VPACKUSDWZrr,
  VPACKUSDWZrrk,
  VPACKUSDWZrrkz,
  VPACKUSDWrm,
  VPACKUSDWrr,
  VPACKUSWBYrm,
  VPACKUSWBYrr,
  VPACKUSWBZ128rm,
  VPACKUSWBZ128rmk,
  VPACKUSWBZ128rmkz,
  VPACKUSWBZ128rr,
  VPACKUSWBZ128rrk,
  VPACKUSWBZ128rrkz,
  VPACKUSWBZ256rm,
  VPACKUSWBZ256rmk,
  VPACKUSWBZ256rmkz,
  VPACKUSWBZ256rr,
  VPACKUSWBZ256rrk,
  VPACKUSWBZ256rrkz,
  VPACKUSWBZrm,
  VPACKUSWBZrmk,
  VPACKUSWBZrmkz,
  VPACKUSWBZrr,
  VPACKUSWBZrrk,
  VPACKUSWBZrrkz,
  VPACKUSWBrm,
  VPACKUSWBrr,
  VPADDBYrm,
  VPADDBYrr,
  VPADDBZ128rm,
  VPADDBZ128rmk,
  VPADDBZ128rmkz,
  VPADDBZ128rr,
  VPADDBZ128rrk,
  VPADDBZ128rrkz,
  VPADDBZ256rm,
  VPADDBZ256rmk,
  VPADDBZ256rmkz,
  VPADDBZ256rr,
  VPADDBZ256rrk,
  VPADDBZ256rrkz,
  VPADDBZrm,
  VPADDBZrmk,
  VPADDBZrmkz,
  VPADDBZrr,
  VPADDBZrrk,
  VPADDBZrrkz,
  VPADDBrm,
  VPADDBrr,
  VPADDDYrm,
  VPADDDYrr,
  VPADDDZ128rm,
  VPADDDZ128rmb,
  VPADDDZ128rmbk,
  VPADDDZ128rmbkz,
  VPADDDZ128rmk,
  VPADDDZ128rmkz,
  VPADDDZ128rr,
  VPADDDZ128rrk,
  VPADDDZ128rrkz,
  VPADDDZ256rm,
  VPADDDZ256rmb,
  VPADDDZ256rmbk,
  VPADDDZ256rmbkz,
  VPADDDZ256rmk,
  VPADDDZ256rmkz,
  VPADDDZ256rr,
  VPADDDZ256rrk,
  VPADDDZ256rrkz,
  VPADDDZrm,
  VPADDDZrmb,
  VPADDDZrmbk,
  VPADDDZrmbkz,
  VPADDDZrmk,
  VPADDDZrmkz,
  VPADDDZrr,
  VPADDDZrrk,
  VPADDDZrrkz,
  VPADDDrm,
  VPADDDrr,
  VPADDQYrm,
  VPADDQYrr,
  VPADDQZ128rm,
  VPADDQZ128rmb,
  VPADDQZ128rmbk,
  VPADDQZ128rmbkz,
  VPADDQZ128rmk,
  VPADDQZ128rmkz,
  VPADDQZ128rr,
  VPADDQZ128rrk,
  VPADDQZ128rrkz,
  VPADDQZ256rm,
  VPADDQZ256rmb,
  VPADDQZ256rmbk,
  VPADDQZ256rmbkz,
  VPADDQZ256rmk,
  VPADDQZ256rmkz,
  VPADDQZ256rr,
  VPADDQZ256rrk,
  VPADDQZ256rrkz,
  VPADDQZrm,
  VPADDQZrmb,
  VPADDQZrmbk,
  VPADDQZrmbkz,
  VPADDQZrmk,
  VPADDQZrmkz,
  VPADDQZrr,
  VPADDQZrrk,
  VPADDQZrrkz,
  VPADDQrm,
  VPADDQrr,
  VPADDSBYrm,
  VPADDSBYrr,
  VPADDSBZ128rm,
  VPADDSBZ128rmk,
  VPADDSBZ128rmkz,
  VPADDSBZ128rr,
  VPADDSBZ128rrk,
  VPADDSBZ128rrkz,
  VPADDSBZ256rm,
  VPADDSBZ256rmk,
  VPADDSBZ256rmkz,
  VPADDSBZ256rr,
  VPADDSBZ256rrk,
  VPADDSBZ256rrkz,
  VPADDSBZrm,
  VPADDSBZrmk,
  VPADDSBZrmkz,
  VPADDSBZrr,
  VPADDSBZrrk,
  VPADDSBZrrkz,
  VPADDSBrm,
  VPADDSBrr,
  VPADDSWYrm,
  VPADDSWYrr,
  VPADDSWZ128rm,
  VPADDSWZ128rmk,
  VPADDSWZ128rmkz,
  VPADDSWZ128rr,
  VPADDSWZ128rrk,
  VPADDSWZ128rrkz,
  VPADDSWZ256rm,
  VPADDSWZ256rmk,
  VPADDSWZ256rmkz,
  VPADDSWZ256rr,
  VPADDSWZ256rrk,
  VPADDSWZ256rrkz,
  VPADDSWZrm,
  VPADDSWZrmk,
  VPADDSWZrmkz,
  VPADDSWZrr,
  VPADDSWZrrk,
  VPADDSWZrrkz,
  VPADDSWrm,
  VPADDSWrr,
  VPADDUSBYrm,
  VPADDUSBYrr,
  VPADDUSBZ128rm,
  VPADDUSBZ128rmk,
  VPADDUSBZ128rmkz,
  VPADDUSBZ128rr,
  VPADDUSBZ128rrk,
  VPADDUSBZ128rrkz,
  VPADDUSBZ256rm,
  VPADDUSBZ256rmk,
  VPADDUSBZ256rmkz,
  VPADDUSBZ256rr,
  VPADDUSBZ256rrk,
  VPADDUSBZ256rrkz,
  VPADDUSBZrm,
  VPADDUSBZrmk,
  VPADDUSBZrmkz,
  VPADDUSBZrr,
  VPADDUSBZrrk,
  VPADDUSBZrrkz,
  VPADDUSBrm,
  VPADDUSBrr,
  VPADDUSWYrm,
  VPADDUSWYrr,
  VPADDUSWZ128rm,
  VPADDUSWZ128rmk,
  VPADDUSWZ128rmkz,
  VPADDUSWZ128rr,
  VPADDUSWZ128rrk,
  VPADDUSWZ128rrkz,
  VPADDUSWZ256rm,
  VPADDUSWZ256rmk,
  VPADDUSWZ256rmkz,
  VPADDUSWZ256rr,
  VPADDUSWZ256rrk,
  VPADDUSWZ256rrkz,
  VPADDUSWZrm,
  VPADDUSWZrmk,
  VPADDUSWZrmkz,
  VPADDUSWZrr,
  VPADDUSWZrrk,
  VPADDUSWZrrkz,
  VPADDUSWrm,
  VPADDUSWrr,
  VPADDWYrm,
  VPADDWYrr,
  VPADDWZ128rm,
  VPADDWZ128rmk,
  VPADDWZ128rmkz,
  VPADDWZ128rr,
  VPADDWZ128rrk,
  VPADDWZ128rrkz,
  VPADDWZ256rm,
  VPADDWZ256rmk,
  VPADDWZ256rmkz,
  VPADDWZ256rr,
  VPADDWZ256rrk,
  VPADDWZ256rrkz,
  VPADDWZrm,
  VPADDWZrmk,
  VPADDWZrmkz,
  VPADDWZrr,
  VPADDWZrrk,
  VPADDWZrrkz,
  VPADDWrm,
  VPADDWrr,
  VPALIGNRYrmi,
  VPALIGNRYrri,
  VPALIGNRZ128rmi,
  VPALIGNRZ128rmik,
  VPALIGNRZ128rmikz,
  VPALIGNRZ128rri,
  VPALIGNRZ128rrik,
  VPALIGNRZ128rrikz,
  VPALIGNRZ256rmi,
  VPALIGNRZ256rmik,
  VPALIGNRZ256rmikz,
  VPALIGNRZ256rri,
  VPALIGNRZ256rrik,
  VPALIGNRZ256rrikz,
  VPALIGNRZrmi,
  VPALIGNRZrmik,
  VPALIGNRZrmikz,
  VPALIGNRZrri,
  VPALIGNRZrrik,
  VPALIGNRZrrikz,
  VPALIGNRrmi,
  VPALIGNRrri,
  VPANDDZ128rm,
  VPANDDZ128rmb,
  VPANDDZ128rmbk,
  VPANDDZ128rmbkz,
  VPANDDZ128rmk,
  VPANDDZ128rmkz,
  VPANDDZ128rr,
  VPANDDZ128rrk,
  VPANDDZ128rrkz,
  VPANDDZ256rm,
  VPANDDZ256rmb,
  VPANDDZ256rmbk,
  VPANDDZ256rmbkz,
  VPANDDZ256rmk,
  VPANDDZ256rmkz,
  VPANDDZ256rr,
  VPANDDZ256rrk,
  VPANDDZ256rrkz,
  VPANDDZrm,
  VPANDDZrmb,
  VPANDDZrmbk,
  VPANDDZrmbkz,
  VPANDDZrmk,
  VPANDDZrmkz,
  VPANDDZrr,
  VPANDDZrrk,
  VPANDDZrrkz,
  VPANDNDZ128rm,
  VPANDNDZ128rmb,
  VPANDNDZ128rmbk,
  VPANDNDZ128rmbkz,
  VPANDNDZ128rmk,
  VPANDNDZ128rmkz,
  VPANDNDZ128rr,
  VPANDNDZ128rrk,
  VPANDNDZ128rrkz,
  VPANDNDZ256rm,
  VPANDNDZ256rmb,
  VPANDNDZ256rmbk,
  VPANDNDZ256rmbkz,
  VPANDNDZ256rmk,
  VPANDNDZ256rmkz,
  VPANDNDZ256rr,
  VPANDNDZ256rrk,
  VPANDNDZ256rrkz,
  VPANDNDZrm,
  VPANDNDZrmb,
  VPANDNDZrmbk,
  VPANDNDZrmbkz,
  VPANDNDZrmk,
  VPANDNDZrmkz,
  VPANDNDZrr,
  VPANDNDZrrk,
  VPANDNDZrrkz,
  VPANDNQZ128rm,
  VPANDNQZ128rmb,
  VPANDNQZ128rmbk,
  VPANDNQZ128rmbkz,
  VPANDNQZ128rmk,
  VPANDNQZ128rmkz,
  VPANDNQZ128rr,
  VPANDNQZ128rrk,
  VPANDNQZ128rrkz,
  VPANDNQZ256rm,
  VPANDNQZ256rmb,
  VPANDNQZ256rmbk,
  VPANDNQZ256rmbkz,
  VPANDNQZ256rmk,
  VPANDNQZ256rmkz,
  VPANDNQZ256rr,
  VPANDNQZ256rrk,
  VPANDNQZ256rrkz,
  VPANDNQZrm,
  VPANDNQZrmb,
  VPANDNQZrmbk,
  VPANDNQZrmbkz,
  VPANDNQZrmk,
  VPANDNQZrmkz,
  VPANDNQZrr,
  VPANDNQZrrk,
  VPANDNQZrrkz,
  VPANDNYrm,
  VPANDNYrr,
  VPANDNrm,
  VPANDNrr,
  VPANDQZ128rm,
  VPANDQZ128rmb,
  VPANDQZ128rmbk,
  VPANDQZ128rmbkz,
  VPANDQZ128rmk,
  VPANDQZ128rmkz,
  VPANDQZ128rr,
  VPANDQZ128rrk,
  VPANDQZ128rrkz,
  VPANDQZ256rm,
  VPANDQZ256rmb,
  VPANDQZ256rmbk,
  VPANDQZ256rmbkz,
  VPANDQZ256rmk,
  VPANDQZ256rmkz,
  VPANDQZ256rr,
  VPANDQZ256rrk,
  VPANDQZ256rrkz,
  VPANDQZrm,
  VPANDQZrmb,
  VPANDQZrmbk,
  VPANDQZrmbkz,
  VPANDQZrmk,
  VPANDQZrmkz,
  VPANDQZrr,
  VPANDQZrrk,
  VPANDQZrrkz,
  VPANDYrm,
  VPANDYrr,
  VPANDrm,
  VPANDrr,
  VPAVGBYrm,
  VPAVGBYrr,
  VPAVGBZ128rm,
  VPAVGBZ128rmk,
  VPAVGBZ128rmkz,
  VPAVGBZ128rr,
  VPAVGBZ128rrk,
  VPAVGBZ128rrkz,
  VPAVGBZ256rm,
  VPAVGBZ256rmk,
  VPAVGBZ256rmkz,
  VPAVGBZ256rr,
  VPAVGBZ256rrk,
  VPAVGBZ256rrkz,
  VPAVGBZrm,
  VPAVGBZrmk,
  VPAVGBZrmkz,
  VPAVGBZrr,
  VPAVGBZrrk,
  VPAVGBZrrkz,
  VPAVGBrm,
  VPAVGBrr,
  VPAVGWYrm,
  VPAVGWYrr,
  VPAVGWZ128rm,
  VPAVGWZ128rmk,
  VPAVGWZ128rmkz,
  VPAVGWZ128rr,
  VPAVGWZ128rrk,
  VPAVGWZ128rrkz,
  VPAVGWZ256rm,
  VPAVGWZ256rmk,
  VPAVGWZ256rmkz,
  VPAVGWZ256rr,
  VPAVGWZ256rrk,
  VPAVGWZ256rrkz,
  VPAVGWZrm,
  VPAVGWZrmk,
  VPAVGWZrmkz,
  VPAVGWZrr,
  VPAVGWZrrk,
  VPAVGWZrrkz,
  VPAVGWrm,
  VPAVGWrr,
  VPBLENDDYrmi,
  VPBLENDDYrri,
  VPBLENDDrmi,
  VPBLENDDrri,
  VPBLENDMBZ128rm,
  VPBLENDMBZ128rmk,
  VPBLENDMBZ128rmkz,
  VPBLENDMBZ128rr,
  VPBLENDMBZ128rrk,
  VPBLENDMBZ128rrkz,
  VPBLENDMBZ256rm,
  VPBLENDMBZ256rmk,
  VPBLENDMBZ256rmkz,
  VPBLENDMBZ256rr,
  VPBLENDMBZ256rrk,
  VPBLENDMBZ256rrkz,
  VPBLENDMBZrm,
  VPBLENDMBZrmk,
  VPBLENDMBZrmkz,
  VPBLENDMBZrr,
  VPBLENDMBZrrk,
  VPBLENDMBZrrkz,
  VPBLENDMDZ128rm,
  VPBLENDMDZ128rmb,
  VPBLENDMDZ128rmbk,
  VPBLENDMDZ128rmbkz,
  VPBLENDMDZ128rmk,
  VPBLENDMDZ128rmkz,
  VPBLENDMDZ128rr,
  VPBLENDMDZ128rrk,
  VPBLENDMDZ128rrkz,
  VPBLENDMDZ256rm,
  VPBLENDMDZ256rmb,
  VPBLENDMDZ256rmbk,
  VPBLENDMDZ256rmbkz,
  VPBLENDMDZ256rmk,
  VPBLENDMDZ256rmkz,
  VPBLENDMDZ256rr,
  VPBLENDMDZ256rrk,
  VPBLENDMDZ256rrkz,
  VPBLENDMDZrm,
  VPBLENDMDZrmb,
  VPBLENDMDZrmbk,
  VPBLENDMDZrmbkz,
  VPBLENDMDZrmk,
  VPBLENDMDZrmkz,
  VPBLENDMDZrr,
  VPBLENDMDZrrk,
  VPBLENDMDZrrkz,
  VPBLENDMQZ128rm,
  VPBLENDMQZ128rmb,
  VPBLENDMQZ128rmbk,
  VPBLENDMQZ128rmbkz,
  VPBLENDMQZ128rmk,
  VPBLENDMQZ128rmkz,
  VPBLENDMQZ128rr,
  VPBLENDMQZ128rrk,
  VPBLENDMQZ128rrkz,
  VPBLENDMQZ256rm,
  VPBLENDMQZ256rmb,
  VPBLENDMQZ256rmbk,
  VPBLENDMQZ256rmbkz,
  VPBLENDMQZ256rmk,
  VPBLENDMQZ256rmkz,
  VPBLENDMQZ256rr,
  VPBLENDMQZ256rrk,
  VPBLENDMQZ256rrkz,
  VPBLENDMQZrm,
  VPBLENDMQZrmb,
  VPBLENDMQZrmbk,
  VPBLENDMQZrmbkz,
  VPBLENDMQZrmk,
  VPBLENDMQZrmkz,
  VPBLENDMQZrr,
  VPBLENDMQZrrk,
  VPBLENDMQZrrkz,
  VPBLENDMWZ128rm,
  VPBLENDMWZ128rmk,
  VPBLENDMWZ128rmkz,
  VPBLENDMWZ128rr,
  VPBLENDMWZ128rrk,
  VPBLENDMWZ128rrkz,
  VPBLENDMWZ256rm,
  VPBLENDMWZ256rmk,
  VPBLENDMWZ256rmkz,
  VPBLENDMWZ256rr,
  VPBLENDMWZ256rrk,
  VPBLENDMWZ256rrkz,
  VPBLENDMWZrm,
  VPBLENDMWZrmk,
  VPBLENDMWZrmkz,
  VPBLENDMWZrr,
  VPBLENDMWZrrk,
  VPBLENDMWZrrkz,
  VPBLENDVBYrmr,
  VPBLENDVBYrrr,
  VPBLENDVBrmr,
  VPBLENDVBrrr,
  VPBLENDWYrmi,
  VPBLENDWYrri,
  VPBLENDWrmi,
  VPBLENDWrri,
  VPBROADCASTBYrm,
  VPBROADCASTBYrr,
  VPBROADCASTBZ128rm,
  VPBROADCASTBZ128rmk,
  VPBROADCASTBZ128rmkz,
  VPBROADCASTBZ128rr,
  VPBROADCASTBZ128rrk,
  VPBROADCASTBZ128rrkz,
  VPBROADCASTBZ256rm,
  VPBROADCASTBZ256rmk,
  VPBROADCASTBZ256rmkz,
  VPBROADCASTBZ256rr,
  VPBROADCASTBZ256rrk,
  VPBROADCASTBZ256rrkz,
  VPBROADCASTBZrm,
  VPBROADCASTBZrmk,
  VPBROADCASTBZrmkz,
  VPBROADCASTBZrr,
  VPBROADCASTBZrrk,
  VPBROADCASTBZrrkz,
  VPBROADCASTBrZ128rr,
  VPBROADCASTBrZ128rrk,
  VPBROADCASTBrZ128rrkz,
  VPBROADCASTBrZ256rr,
  VPBROADCASTBrZ256rrk,
  VPBROADCASTBrZ256rrkz,
  VPBROADCASTBrZrr,
  VPBROADCASTBrZrrk,
  VPBROADCASTBrZrrkz,
  VPBROADCASTBrm,
  VPBROADCASTBrr,
  VPBROADCASTDYrm,
  VPBROADCASTDYrr,
  VPBROADCASTDZ128rm,
  VPBROADCASTDZ128rmk,
  VPBROADCASTDZ128rmkz,
  VPBROADCASTDZ128rr,
  VPBROADCASTDZ128rrk,
  VPBROADCASTDZ128rrkz,
  VPBROADCASTDZ256rm,
  VPBROADCASTDZ256rmk,
  VPBROADCASTDZ256rmkz,
  VPBROADCASTDZ256rr,
  VPBROADCASTDZ256rrk,
  VPBROADCASTDZ256rrkz,
  VPBROADCASTDZrm,
  VPBROADCASTDZrmk,
  VPBROADCASTDZrmkz,
  VPBROADCASTDZrr,
  VPBROADCASTDZrrk,
  VPBROADCASTDZrrkz,
  VPBROADCASTDrZ128rr,
  VPBROADCASTDrZ128rrk,
  VPBROADCASTDrZ128rrkz,
  VPBROADCASTDrZ256rr,
  VPBROADCASTDrZ256rrk,
  VPBROADCASTDrZ256rrkz,
  VPBROADCASTDrZrr,
  VPBROADCASTDrZrrk,
  VPBROADCASTDrZrrkz,
  VPBROADCASTDrm,
  VPBROADCASTDrr,
  VPBROADCASTMB2QZ128rr,
  VPBROADCASTMB2QZ256rr,
  VPBROADCASTMB2QZrr,
  VPBROADCASTMW2DZ128rr,
  VPBROADCASTMW2DZ256rr,
  VPBROADCASTMW2DZrr,
  VPBROADCASTQYrm,
  VPBROADCASTQYrr,
  VPBROADCASTQZ128rm,
  VPBROADCASTQZ128rmk,
  VPBROADCASTQZ128rmkz,
  VPBROADCASTQZ128rr,
  VPBROADCASTQZ128rrk,
  VPBROADCASTQZ128rrkz,
  VPBROADCASTQZ256rm,
  VPBROADCASTQZ256rmk,
  VPBROADCASTQZ256rmkz,
  VPBROADCASTQZ256rr,
  VPBROADCASTQZ256rrk,
  VPBROADCASTQZ256rrkz,
  VPBROADCASTQZrm,
  VPBROADCASTQZrmk,
  VPBROADCASTQZrmkz,
  VPBROADCASTQZrr,
  VPBROADCASTQZrrk,
  VPBROADCASTQZrrkz,
  VPBROADCASTQrZ128rr,
  VPBROADCASTQrZ128rrk,
  VPBROADCASTQrZ128rrkz,
  VPBROADCASTQrZ256rr,
  VPBROADCASTQrZ256rrk,
  VPBROADCASTQrZ256rrkz,
  VPBROADCASTQrZrr,
  VPBROADCASTQrZrrk,
  VPBROADCASTQrZrrkz,
  VPBROADCASTQrm,
  VPBROADCASTQrr,
  VPBROADCASTWYrm,
  VPBROADCASTWYrr,
  VPBROADCASTWZ128rm,
  VPBROADCASTWZ128rmk,
  VPBROADCASTWZ128rmkz,
  VPBROADCASTWZ128rr,
  VPBROADCASTWZ128rrk,
  VPBROADCASTWZ128rrkz,
  VPBROADCASTWZ256rm,
  VPBROADCASTWZ256rmk,
  VPBROADCASTWZ256rmkz,
  VPBROADCASTWZ256rr,
  VPBROADCASTWZ256rrk,
  VPBROADCASTWZ256rrkz,
  VPBROADCASTWZrm,
  VPBROADCASTWZrmk,
  VPBROADCASTWZrmkz,
  VPBROADCASTWZrr,
  VPBROADCASTWZrrk,
  VPBROADCASTWZrrkz,
  VPBROADCASTWrZ128rr,
  VPBROADCASTWrZ128rrk,
  VPBROADCASTWrZ128rrkz,
  VPBROADCASTWrZ256rr,
  VPBROADCASTWrZ256rrk,
  VPBROADCASTWrZ256rrkz,
  VPBROADCASTWrZrr,
  VPBROADCASTWrZrrk,
  VPBROADCASTWrZrrkz,
  VPBROADCASTWrm,
  VPBROADCASTWrr,
  VPCLMULQDQYrmi,
  VPCLMULQDQYrri,
  VPCLMULQDQZ128rmi,
  VPCLMULQDQZ128rri,
  VPCLMULQDQZ256rmi,
  VPCLMULQDQZ256rri,
  VPCLMULQDQZrmi,
  VPCLMULQDQZrri,
  VPCLMULQDQrmi,
  VPCLMULQDQrri,
  VPCMOVYrmr,
  VPCMOVYrrm,
  VPCMOVYrrr,
  VPCMOVYrrr_REV,
  VPCMOVrmr,
  VPCMOVrrm,
  VPCMOVrrr,
  VPCMOVrrr_REV,
  VPCMPBZ128rmi,
  VPCMPBZ128rmik,
  VPCMPBZ128rri,
  VPCMPBZ128rrik,
  VPCMPBZ256rmi,
  VPCMPBZ256rmik,
  VPCMPBZ256rri,
  VPCMPBZ256rrik,
  VPCMPBZrmi,
  VPCMPBZrmik,
  VPCMPBZrri,
  VPCMPBZrrik,
  VPCMPDZ128rmbi,
  VPCMPDZ128rmbik,
  VPCMPDZ128rmi,
  VPCMPDZ128rmik,
  VPCMPDZ128rri,
  VPCMPDZ128rrik,
  VPCMPDZ256rmbi,
  VPCMPDZ256rmbik,
  VPCMPDZ256rmi,
  VPCMPDZ256rmik,
  VPCMPDZ256rri,
  VPCMPDZ256rrik,
  VPCMPDZrmbi,
  VPCMPDZrmbik,
  VPCMPDZrmi,
  VPCMPDZrmik,
  VPCMPDZrri,
  VPCMPDZrrik,
  VPCMPEQBYrm,
  VPCMPEQBYrr,
  VPCMPEQBZ128rm,
  VPCMPEQBZ128rmk,
  VPCMPEQBZ128rr,
  VPCMPEQBZ128rrk,
  VPCMPEQBZ256rm,
  VPCMPEQBZ256rmk,
  VPCMPEQBZ256rr,
  VPCMPEQBZ256rrk,
  VPCMPEQBZrm,
  VPCMPEQBZrmk,
  VPCMPEQBZrr,
  VPCMPEQBZrrk,
  VPCMPEQBrm,
  VPCMPEQBrr,
  VPCMPEQDYrm,
  VPCMPEQDYrr,
  VPCMPEQDZ128rm,
  VPCMPEQDZ128rmb,
  VPCMPEQDZ128rmbk,
  VPCMPEQDZ128rmk,
  VPCMPEQDZ128rr,
  VPCMPEQDZ128rrk,
  VPCMPEQDZ256rm,
  VPCMPEQDZ256rmb,
  VPCMPEQDZ256rmbk,
  VPCMPEQDZ256rmk,
  VPCMPEQDZ256rr,
  VPCMPEQDZ256rrk,
  VPCMPEQDZrm,
  VPCMPEQDZrmb,
  VPCMPEQDZrmbk,
  VPCMPEQDZrmk,
  VPCMPEQDZrr,
  VPCMPEQDZrrk,
  VPCMPEQDrm,
  VPCMPEQDrr,
  VPCMPEQQYrm,
  VPCMPEQQYrr,
  VPCMPEQQZ128rm,
  VPCMPEQQZ128rmb,
  VPCMPEQQZ128rmbk,
  VPCMPEQQZ128rmk,
  VPCMPEQQZ128rr,
  VPCMPEQQZ128rrk,
  VPCMPEQQZ256rm,
  VPCMPEQQZ256rmb,
  VPCMPEQQZ256rmbk,
  VPCMPEQQZ256rmk,
  VPCMPEQQZ256rr,
  VPCMPEQQZ256rrk,
  VPCMPEQQZrm,
  VPCMPEQQZrmb,
  VPCMPEQQZrmbk,
  VPCMPEQQZrmk,
  VPCMPEQQZrr,
  VPCMPEQQZrrk,
  VPCMPEQQrm,
  VPCMPEQQrr,
  VPCMPEQWYrm,
  VPCMPEQWYrr,
  VPCMPEQWZ128rm,
  VPCMPEQWZ128rmk,
  VPCMPEQWZ128rr,
  VPCMPEQWZ128rrk,
  VPCMPEQWZ256rm,
  VPCMPEQWZ256rmk,
  VPCMPEQWZ256rr,
  VPCMPEQWZ256rrk,
  VPCMPEQWZrm,
  VPCMPEQWZrmk,
  VPCMPEQWZrr,
  VPCMPEQWZrrk,
  VPCMPEQWrm,
  VPCMPEQWrr,
  VPCMPESTRIrmi,
  VPCMPESTRIrri,
  VPCMPESTRMrmi,
  VPCMPESTRMrri,
  VPCMPGTBYrm,
  VPCMPGTBYrr,
  VPCMPGTBZ128rm,
  VPCMPGTBZ128rmk,
  VPCMPGTBZ128rr,
  VPCMPGTBZ128rrk,
  VPCMPGTBZ256rm,
  VPCMPGTBZ256rmk,
  VPCMPGTBZ256rr,
  VPCMPGTBZ256rrk,
  VPCMPGTBZrm,
  VPCMPGTBZrmk,
  VPCMPGTBZrr,
  VPCMPGTBZrrk,
  VPCMPGTBrm,
  VPCMPGTBrr,
  VPCMPGTDYrm,
  VPCMPGTDYrr,
  VPCMPGTDZ128rm,
  VPCMPGTDZ128rmb,
  VPCMPGTDZ128rmbk,
  VPCMPGTDZ128rmk,
  VPCMPGTDZ128rr,
  VPCMPGTDZ128rrk,
  VPCMPGTDZ256rm,
  VPCMPGTDZ256rmb,
  VPCMPGTDZ256rmbk,
  VPCMPGTDZ256rmk,
  VPCMPGTDZ256rr,
  VPCMPGTDZ256rrk,
  VPCMPGTDZrm,
  VPCMPGTDZrmb,
  VPCMPGTDZrmbk,
  VPCMPGTDZrmk,
  VPCMPGTDZrr,
  VPCMPGTDZrrk,
  VPCMPGTDrm,
  VPCMPGTDrr,
  VPCMPGTQYrm,
  VPCMPGTQYrr,
  VPCMPGTQZ128rm,
  VPCMPGTQZ128rmb,
  VPCMPGTQZ128rmbk,
  VPCMPGTQZ128rmk,
  VPCMPGTQZ128rr,
  VPCMPGTQZ128rrk,
  VPCMPGTQZ256rm,
  VPCMPGTQZ256rmb,
  VPCMPGTQZ256rmbk,
  VPCMPGTQZ256rmk,
  VPCMPGTQZ256rr,
  VPCMPGTQZ256rrk,
  VPCMPGTQZrm,
  VPCMPGTQZrmb,
  VPCMPGTQZrmbk,
  VPCMPGTQZrmk,
  VPCMPGTQZrr,
  VPCMPGTQZrrk,
  VPCMPGTQrm,
  VPCMPGTQrr,
  VPCMPGTWYrm,
  VPCMPGTWYrr,
  VPCMPGTWZ128rm,
  VPCMPGTWZ128rmk,
  VPCMPGTWZ128rr,
  VPCMPGTWZ128rrk,
  VPCMPGTWZ256rm,
  VPCMPGTWZ256rmk,
  VPCMPGTWZ256rr,
  VPCMPGTWZ256rrk,
  VPCMPGTWZrm,
  VPCMPGTWZrmk,
  VPCMPGTWZrr,
  VPCMPGTWZrrk,
  VPCMPGTWrm,
  VPCMPGTWrr,
  VPCMPISTRIrmi,
  VPCMPISTRIrri,
  VPCMPISTRMrmi,
  VPCMPISTRMrri,
  VPCMPQZ128rmbi,
  VPCMPQZ128rmbik,
  VPCMPQZ128rmi,
  VPCMPQZ128rmik,
  VPCMPQZ128rri,
  VPCMPQZ128rrik,
  VPCMPQZ256rmbi,
  VPCMPQZ256rmbik,
  VPCMPQZ256rmi,
  VPCMPQZ256rmik,
  VPCMPQZ256rri,
  VPCMPQZ256rrik,
  VPCMPQZrmbi,
  VPCMPQZrmbik,
  VPCMPQZrmi,
  VPCMPQZrmik,
  VPCMPQZrri,
  VPCMPQZrrik,
  VPCMPUBZ128rmi,
  VPCMPUBZ128rmik,
  VPCMPUBZ128rri,
  VPCMPUBZ128rrik,
  VPCMPUBZ256rmi,
  VPCMPUBZ256rmik,
  VPCMPUBZ256rri,
  VPCMPUBZ256rrik,
  VPCMPUBZrmi,
  VPCMPUBZrmik,
  VPCMPUBZrri,
  VPCMPUBZrrik,
  VPCMPUDZ128rmbi,
  VPCMPUDZ128rmbik,
  VPCMPUDZ128rmi,
  VPCMPUDZ128rmik,
  VPCMPUDZ128rri,
  VPCMPUDZ128rrik,
  VPCMPUDZ256rmbi,
  VPCMPUDZ256rmbik,
  VPCMPUDZ256rmi,
  VPCMPUDZ256rmik,
  VPCMPUDZ256rri,
  VPCMPUDZ256rrik,
  VPCMPUDZrmbi,
  VPCMPUDZrmbik,
  VPCMPUDZrmi,
  VPCMPUDZrmik,
  VPCMPUDZrri,
  VPCMPUDZrrik,
  VPCMPUQZ128rmbi,
  VPCMPUQZ128rmbik,
  VPCMPUQZ128rmi,
  VPCMPUQZ128rmik,
  VPCMPUQZ128rri,
  VPCMPUQZ128rrik,
  VPCMPUQZ256rmbi,
  VPCMPUQZ256rmbik,
  VPCMPUQZ256rmi,
  VPCMPUQZ256rmik,
  VPCMPUQZ256rri,
  VPCMPUQZ256rrik,
  VPCMPUQZrmbi,
  VPCMPUQZrmbik,
  VPCMPUQZrmi,
  VPCMPUQZrmik,
  VPCMPUQZrri,
  VPCMPUQZrrik,
  VPCMPUWZ128rmi,
  VPCMPUWZ128rmik,
  VPCMPUWZ128rri,
  VPCMPUWZ128rrik,
  VPCMPUWZ256rmi,
  VPCMPUWZ256rmik,
  VPCMPUWZ256rri,
  VPCMPUWZ256rrik,
  VPCMPUWZrmi,
  VPCMPUWZrmik,
  VPCMPUWZrri,
  VPCMPUWZrrik,
  VPCMPWZ128rmi,
  VPCMPWZ128rmik,
  VPCMPWZ128rri,
  VPCMPWZ128rrik,
  VPCMPWZ256rmi,
  VPCMPWZ256rmik,
  VPCMPWZ256rri,
  VPCMPWZ256rrik,
  VPCMPWZrmi,
  VPCMPWZrmik,
  VPCMPWZrri,
  VPCMPWZrrik,
  VPCOMBmi,
  VPCOMBri,
  VPCOMDmi,
  VPCOMDri,
  VPCOMPRESSBZ128mr,
  VPCOMPRESSBZ128mrk,
  VPCOMPRESSBZ128rr,
  VPCOMPRESSBZ128rrk,
  VPCOMPRESSBZ128rrkz,
  VPCOMPRESSBZ256mr,
  VPCOMPRESSBZ256mrk,
  VPCOMPRESSBZ256rr,
  VPCOMPRESSBZ256rrk,
  VPCOMPRESSBZ256rrkz,
  VPCOMPRESSBZmr,
  VPCOMPRESSBZmrk,
  VPCOMPRESSBZrr,
  VPCOMPRESSBZrrk,
  VPCOMPRESSBZrrkz,
  VPCOMPRESSDZ128mr,
  VPCOMPRESSDZ128mrk,
  VPCOMPRESSDZ128rr,
  VPCOMPRESSDZ128rrk,
  VPCOMPRESSDZ128rrkz,
  VPCOMPRESSDZ256mr,
  VPCOMPRESSDZ256mrk,
  VPCOMPRESSDZ256rr,
  VPCOMPRESSDZ256rrk,
  VPCOMPRESSDZ256rrkz,
  VPCOMPRESSDZmr,
  VPCOMPRESSDZmrk,
  VPCOMPRESSDZrr,
  VPCOMPRESSDZrrk,
  VPCOMPRESSDZrrkz,
  VPCOMPRESSQZ128mr,
  VPCOMPRESSQZ128mrk,
  VPCOMPRESSQZ128rr,
  VPCOMPRESSQZ128rrk,
  VPCOMPRESSQZ128rrkz,
  VPCOMPRESSQZ256mr,
  VPCOMPRESSQZ256mrk,
  VPCOMPRESSQZ256rr,
  VPCOMPRESSQZ256rrk,
  VPCOMPRESSQZ256rrkz,
  VPCOMPRESSQZmr,
  VPCOMPRESSQZmrk,
  VPCOMPRESSQZrr,
  VPCOMPRESSQZrrk,
  VPCOMPRESSQZrrkz,
  VPCOMPRESSWZ128mr,
  VPCOMPRESSWZ128mrk,
  VPCOMPRESSWZ128rr,
  VPCOMPRESSWZ128rrk,
  VPCOMPRESSWZ128rrkz,
  VPCOMPRESSWZ256mr,
  VPCOMPRESSWZ256mrk,
  VPCOMPRESSWZ256rr,
  VPCOMPRESSWZ256rrk,
  VPCOMPRESSWZ256rrkz,
  VPCOMPRESSWZmr,
  VPCOMPRESSWZmrk,
  VPCOMPRESSWZrr,
  VPCOMPRESSWZrrk,
  VPCOMPRESSWZrrkz,
  VPCOMQmi,
  VPCOMQri,
  VPCOMUBmi,
  VPCOMUBri,
  VPCOMUDmi,
  VPCOMUDri,
  VPCOMUQmi,
  VPCOMUQri,
  VPCOMUWmi,
  VPCOMUWri,
  VPCOMWmi,
  VPCOMWri,
  VPCONFLICTDZ128rm,
  VPCONFLICTDZ128rmb,
  VPCONFLICTDZ128rmbk,
  VPCONFLICTDZ128rmbkz,
  VPCONFLICTDZ128rmk,
  VPCONFLICTDZ128rmkz,
  VPCONFLICTDZ128rr,
  VPCONFLICTDZ128rrk,
  VPCONFLICTDZ128rrkz,
  VPCONFLICTDZ256rm,
  VPCONFLICTDZ256rmb,
  VPCONFLICTDZ256rmbk,
  VPCONFLICTDZ256rmbkz,
  VPCONFLICTDZ256rmk,
  VPCONFLICTDZ256rmkz,
  VPCONFLICTDZ256rr,
  VPCONFLICTDZ256rrk,
  VPCONFLICTDZ256rrkz,
  VPCONFLICTDZrm,
  VPCONFLICTDZrmb,
  VPCONFLICTDZrmbk,
  VPCONFLICTDZrmbkz,
  VPCONFLICTDZrmk,
  VPCONFLICTDZrmkz,
  VPCONFLICTDZrr,
  VPCONFLICTDZrrk,
  VPCONFLICTDZrrkz,
  VPCONFLICTQZ128rm,
  VPCONFLICTQZ128rmb,
  VPCONFLICTQZ128rmbk,
  VPCONFLICTQZ128rmbkz,
  VPCONFLICTQZ128rmk,
  VPCONFLICTQZ128rmkz,
  VPCONFLICTQZ128rr,
  VPCONFLICTQZ128rrk,
  VPCONFLICTQZ128rrkz,
  VPCONFLICTQZ256rm,
  VPCONFLICTQZ256rmb,
  VPCONFLICTQZ256rmbk,
  VPCONFLICTQZ256rmbkz,
  VPCONFLICTQZ256rmk,
  VPCONFLICTQZ256rmkz,
  VPCONFLICTQZ256rr,
  VPCONFLICTQZ256rrk,
  VPCONFLICTQZ256rrkz,
  VPCONFLICTQZrm,
  VPCONFLICTQZrmb,
  VPCONFLICTQZrmbk,
  VPCONFLICTQZrmbkz,
  VPCONFLICTQZrmk,
  VPCONFLICTQZrmkz,
  VPCONFLICTQZrr,
  VPCONFLICTQZrrk,
  VPCONFLICTQZrrkz,
  VPDPBSSDSYrm,
  VPDPBSSDSYrr,
  VPDPBSSDSZ128m,
  VPDPBSSDSZ128mb,
  VPDPBSSDSZ128mbk,
  VPDPBSSDSZ128mbkz,
  VPDPBSSDSZ128mk,
  VPDPBSSDSZ128mkz,
  VPDPBSSDSZ128r,
  VPDPBSSDSZ128rk,
  VPDPBSSDSZ128rkz,
  VPDPBSSDSZ256m,
  VPDPBSSDSZ256mb,
  VPDPBSSDSZ256mbk,
  VPDPBSSDSZ256mbkz,
  VPDPBSSDSZ256mk,
  VPDPBSSDSZ256mkz,
  VPDPBSSDSZ256r,
  VPDPBSSDSZ256rk,
  VPDPBSSDSZ256rkz,
  VPDPBSSDSZm,
  VPDPBSSDSZmb,
  VPDPBSSDSZmbk,
  VPDPBSSDSZmbkz,
  VPDPBSSDSZmk,
  VPDPBSSDSZmkz,
  VPDPBSSDSZr,
  VPDPBSSDSZrk,
  VPDPBSSDSZrkz,
  VPDPBSSDSrm,
  VPDPBSSDSrr,
  VPDPBSSDYrm,
  VPDPBSSDYrr,
  VPDPBSSDZ128m,
  VPDPBSSDZ128mb,
  VPDPBSSDZ128mbk,
  VPDPBSSDZ128mbkz,
  VPDPBSSDZ128mk,
  VPDPBSSDZ128mkz,
  VPDPBSSDZ128r,
  VPDPBSSDZ128rk,
  VPDPBSSDZ128rkz,
  VPDPBSSDZ256m,
  VPDPBSSDZ256mb,
  VPDPBSSDZ256mbk,
  VPDPBSSDZ256mbkz,
  VPDPBSSDZ256mk,
  VPDPBSSDZ256mkz,
  VPDPBSSDZ256r,
  VPDPBSSDZ256rk,
  VPDPBSSDZ256rkz,
  VPDPBSSDZm,
  VPDPBSSDZmb,
  VPDPBSSDZmbk,
  VPDPBSSDZmbkz,
  VPDPBSSDZmk,
  VPDPBSSDZmkz,
  VPDPBSSDZr,
  VPDPBSSDZrk,
  VPDPBSSDZrkz,
  VPDPBSSDrm,
  VPDPBSSDrr,
  VPDPBSUDSYrm,
  VPDPBSUDSYrr,
  VPDPBSUDSZ128m,
  VPDPBSUDSZ128mb,
  VPDPBSUDSZ128mbk,
  VPDPBSUDSZ128mbkz,
  VPDPBSUDSZ128mk,
  VPDPBSUDSZ128mkz,
  VPDPBSUDSZ128r,
  VPDPBSUDSZ128rk,
  VPDPBSUDSZ128rkz,
  VPDPBSUDSZ256m,
  VPDPBSUDSZ256mb,
  VPDPBSUDSZ256mbk,
  VPDPBSUDSZ256mbkz,
  VPDPBSUDSZ256mk,
  VPDPBSUDSZ256mkz,
  VPDPBSUDSZ256r,
  VPDPBSUDSZ256rk,
  VPDPBSUDSZ256rkz,
  VPDPBSUDSZm,
  VPDPBSUDSZmb,
  VPDPBSUDSZmbk,
  VPDPBSUDSZmbkz,
  VPDPBSUDSZmk,
  VPDPBSUDSZmkz,
  VPDPBSUDSZr,
  VPDPBSUDSZrk,
  VPDPBSUDSZrkz,
  VPDPBSUDSrm,
  VPDPBSUDSrr,
  VPDPBSUDYrm,
  VPDPBSUDYrr,
  VPDPBSUDZ128m,
  VPDPBSUDZ128mb,
  VPDPBSUDZ128mbk,
  VPDPBSUDZ128mbkz,
  VPDPBSUDZ128mk,
  VPDPBSUDZ128mkz,
  VPDPBSUDZ128r,
  VPDPBSUDZ128rk,
  VPDPBSUDZ128rkz,
  VPDPBSUDZ256m,
  VPDPBSUDZ256mb,
  VPDPBSUDZ256mbk,
  VPDPBSUDZ256mbkz,
  VPDPBSUDZ256mk,
  VPDPBSUDZ256mkz,
  VPDPBSUDZ256r,
  VPDPBSUDZ256rk,
  VPDPBSUDZ256rkz,
  VPDPBSUDZm,
  VPDPBSUDZmb,
  VPDPBSUDZmbk,
  VPDPBSUDZmbkz,
  VPDPBSUDZmk,
  VPDPBSUDZmkz,
  VPDPBSUDZr,
  VPDPBSUDZrk,
  VPDPBSUDZrkz,
  VPDPBSUDrm,
  VPDPBSUDrr,
  VPDPBUSDSYrm,
  VPDPBUSDSYrr,
  VPDPBUSDSZ128m,
  VPDPBUSDSZ128mb,
  VPDPBUSDSZ128mbk,
  VPDPBUSDSZ128mbkz,
  VPDPBUSDSZ128mk,
  VPDPBUSDSZ128mkz,
  VPDPBUSDSZ128r,
  VPDPBUSDSZ128rk,
  VPDPBUSDSZ128rkz,
  VPDPBUSDSZ256m,
  VPDPBUSDSZ256mb,
  VPDPBUSDSZ256mbk,
  VPDPBUSDSZ256mbkz,
  VPDPBUSDSZ256mk,
  VPDPBUSDSZ256mkz,
  VPDPBUSDSZ256r,
  VPDPBUSDSZ256rk,
  VPDPBUSDSZ256rkz,
  VPDPBUSDSZm,
  VPDPBUSDSZmb,
  VPDPBUSDSZmbk,
  VPDPBUSDSZmbkz,
  VPDPBUSDSZmk,
  VPDPBUSDSZmkz,
  VPDPBUSDSZr,
  VPDPBUSDSZrk,
  VPDPBUSDSZrkz,
  VPDPBUSDSrm,
  VPDPBUSDSrr,
  VPDPBUSDYrm,
  VPDPBUSDYrr,
  VPDPBUSDZ128m,
  VPDPBUSDZ128mb,
  VPDPBUSDZ128mbk,
  VPDPBUSDZ128mbkz,
  VPDPBUSDZ128mk,
  VPDPBUSDZ128mkz,
  VPDPBUSDZ128r,
  VPDPBUSDZ128rk,
  VPDPBUSDZ128rkz,
  VPDPBUSDZ256m,
  VPDPBUSDZ256mb,
  VPDPBUSDZ256mbk,
  VPDPBUSDZ256mbkz,
  VPDPBUSDZ256mk,
  VPDPBUSDZ256mkz,
  VPDPBUSDZ256r,
  VPDPBUSDZ256rk,
  VPDPBUSDZ256rkz,
  VPDPBUSDZm,
  VPDPBUSDZmb,
  VPDPBUSDZmbk,
  VPDPBUSDZmbkz,
  VPDPBUSDZmk,
  VPDPBUSDZmkz,
  VPDPBUSDZr,
  VPDPBUSDZrk,
  VPDPBUSDZrkz,
  VPDPBUSDrm,
  VPDPBUSDrr,
  VPDPBUUDSYrm,
  VPDPBUUDSYrr,
  VPDPBUUDSZ128m,
  VPDPBUUDSZ128mb,
  VPDPBUUDSZ128mbk,
  VPDPBUUDSZ128mbkz,
  VPDPBUUDSZ128mk,
  VPDPBUUDSZ128mkz,
  VPDPBUUDSZ128r,
  VPDPBUUDSZ128rk,
  VPDPBUUDSZ128rkz,
  VPDPBUUDSZ256m,
  VPDPBUUDSZ256mb,
  VPDPBUUDSZ256mbk,
  VPDPBUUDSZ256mbkz,
  VPDPBUUDSZ256mk,
  VPDPBUUDSZ256mkz,
  VPDPBUUDSZ256r,
  VPDPBUUDSZ256rk,
  VPDPBUUDSZ256rkz,
  VPDPBUUDSZm,
  VPDPBUUDSZmb,
  VPDPBUUDSZmbk,
  VPDPBUUDSZmbkz,
  VPDPBUUDSZmk,
  VPDPBUUDSZmkz,
  VPDPBUUDSZr,
  VPDPBUUDSZrk,
  VPDPBUUDSZrkz,
  VPDPBUUDSrm,
  VPDPBUUDSrr,
  VPDPBUUDYrm,
  VPDPBUUDYrr,
  VPDPBUUDZ128m,
  VPDPBUUDZ128mb,
  VPDPBUUDZ128mbk,
  VPDPBUUDZ128mbkz,
  VPDPBUUDZ128mk,
  VPDPBUUDZ128mkz,
  VPDPBUUDZ128r,
  VPDPBUUDZ128rk,
  VPDPBUUDZ128rkz,
  VPDPBUUDZ256m,
  VPDPBUUDZ256mb,
  VPDPBUUDZ256mbk,
  VPDPBUUDZ256mbkz,
  VPDPBUUDZ256mk,
  VPDPBUUDZ256mkz,
  VPDPBUUDZ256r,
  VPDPBUUDZ256rk,
  VPDPBUUDZ256rkz,
  VPDPBUUDZm,
  VPDPBUUDZmb,
  VPDPBUUDZmbk,
  VPDPBUUDZmbkz,
  VPDPBUUDZmk,
  VPDPBUUDZmkz,
  VPDPBUUDZr,
  VPDPBUUDZrk,
  VPDPBUUDZrkz,
  VPDPBUUDrm,
  VPDPBUUDrr,
  VPDPWSSDSYrm,
  VPDPWSSDSYrr,
  VPDPWSSDSZ128m,
  VPDPWSSDSZ128mb,
  VPDPWSSDSZ128mbk,
  VPDPWSSDSZ128mbkz,
  VPDPWSSDSZ128mk,
  VPDPWSSDSZ128mkz,
  VPDPWSSDSZ128r,
  VPDPWSSDSZ128rk,
  VPDPWSSDSZ128rkz,
  VPDPWSSDSZ256m,
  VPDPWSSDSZ256mb,
  VPDPWSSDSZ256mbk,
  VPDPWSSDSZ256mbkz,
  VPDPWSSDSZ256mk,
  VPDPWSSDSZ256mkz,
  VPDPWSSDSZ256r,
  VPDPWSSDSZ256rk,
  VPDPWSSDSZ256rkz,
  VPDPWSSDSZm,
  VPDPWSSDSZmb,
  VPDPWSSDSZmbk,
  VPDPWSSDSZmbkz,
  VPDPWSSDSZmk,
  VPDPWSSDSZmkz,
  VPDPWSSDSZr,
  VPDPWSSDSZrk,
  VPDPWSSDSZrkz,
  VPDPWSSDSrm,
  VPDPWSSDSrr,
  VPDPWSSDYrm,
  VPDPWSSDYrr,
  VPDPWSSDZ128m,
  VPDPWSSDZ128mb,
  VPDPWSSDZ128mbk,
  VPDPWSSDZ128mbkz,
  VPDPWSSDZ128mk,
  VPDPWSSDZ128mkz,
  VPDPWSSDZ128r,
  VPDPWSSDZ128rk,
  VPDPWSSDZ128rkz,
  VPDPWSSDZ256m,
  VPDPWSSDZ256mb,
  VPDPWSSDZ256mbk,
  VPDPWSSDZ256mbkz,
  VPDPWSSDZ256mk,
  VPDPWSSDZ256mkz,
  VPDPWSSDZ256r,
  VPDPWSSDZ256rk,
  VPDPWSSDZ256rkz,
  VPDPWSSDZm,
  VPDPWSSDZmb,
  VPDPWSSDZmbk,
  VPDPWSSDZmbkz,
  VPDPWSSDZmk,
  VPDPWSSDZmkz,
  VPDPWSSDZr,
  VPDPWSSDZrk,
  VPDPWSSDZrkz,
  VPDPWSSDrm,
  VPDPWSSDrr,
  VPDPWSUDSYrm,
  VPDPWSUDSYrr,
  VPDPWSUDSZ128m,
  VPDPWSUDSZ128mb,
  VPDPWSUDSZ128mbk,
  VPDPWSUDSZ128mbkz,
  VPDPWSUDSZ128mk,
  VPDPWSUDSZ128mkz,
  VPDPWSUDSZ128r,
  VPDPWSUDSZ128rk,
  VPDPWSUDSZ128rkz,
  VPDPWSUDSZ256m,
  VPDPWSUDSZ256mb,
  VPDPWSUDSZ256mbk,
  VPDPWSUDSZ256mbkz,
  VPDPWSUDSZ256mk,
  VPDPWSUDSZ256mkz,
  VPDPWSUDSZ256r,
  VPDPWSUDSZ256rk,
  VPDPWSUDSZ256rkz,
  VPDPWSUDSZm,
  VPDPWSUDSZmb,
  VPDPWSUDSZmbk,
  VPDPWSUDSZmbkz,
  VPDPWSUDSZmk,
  VPDPWSUDSZmkz,
  VPDPWSUDSZr,
  VPDPWSUDSZrk,
  VPDPWSUDSZrkz,
  VPDPWSUDSrm,
  VPDPWSUDSrr,
  VPDPWSUDYrm,
  VPDPWSUDYrr,
  VPDPWSUDZ128m,
  VPDPWSUDZ128mb,
  VPDPWSUDZ128mbk,
  VPDPWSUDZ128mbkz,
  VPDPWSUDZ128mk,
  VPDPWSUDZ128mkz,
  VPDPWSUDZ128r,
  VPDPWSUDZ128rk,
  VPDPWSUDZ128rkz,
  VPDPWSUDZ256m,
  VPDPWSUDZ256mb,
  VPDPWSUDZ256mbk,
  VPDPWSUDZ256mbkz,
  VPDPWSUDZ256mk,
  VPDPWSUDZ256mkz,
  VPDPWSUDZ256r,
  VPDPWSUDZ256rk,
  VPDPWSUDZ256rkz,
  VPDPWSUDZm,
  VPDPWSUDZmb,
  VPDPWSUDZmbk,
  VPDPWSUDZmbkz,
  VPDPWSUDZmk,
  VPDPWSUDZmkz,
  VPDPWSUDZr,
  VPDPWSUDZrk,
  VPDPWSUDZrkz,
  VPDPWSUDrm,
  VPDPWSUDrr,
  VPDPWUSDSYrm,
  VPDPWUSDSYrr,
  VPDPWUSDSZ128m,
  VPDPWUSDSZ128mb,
  VPDPWUSDSZ128mbk,
  VPDPWUSDSZ128mbkz,
  VPDPWUSDSZ128mk,
  VPDPWUSDSZ128mkz,
  VPDPWUSDSZ128r,
  VPDPWUSDSZ128rk,
  VPDPWUSDSZ128rkz,
  VPDPWUSDSZ256m,
  VPDPWUSDSZ256mb,
  VPDPWUSDSZ256mbk,
  VPDPWUSDSZ256mbkz,
  VPDPWUSDSZ256mk,
  VPDPWUSDSZ256mkz,
  VPDPWUSDSZ256r,
  VPDPWUSDSZ256rk,
  VPDPWUSDSZ256rkz,
  VPDPWUSDSZm,
  VPDPWUSDSZmb,
  VPDPWUSDSZmbk,
  VPDPWUSDSZmbkz,
  VPDPWUSDSZmk,
  VPDPWUSDSZmkz,
  VPDPWUSDSZr,
  VPDPWUSDSZrk,
  VPDPWUSDSZrkz,
  VPDPWUSDSrm,
  VPDPWUSDSrr,
  VPDPWUSDYrm,
  VPDPWUSDYrr,
  VPDPWUSDZ128m,
  VPDPWUSDZ128mb,
  VPDPWUSDZ128mbk,
  VPDPWUSDZ128mbkz,
  VPDPWUSDZ128mk,
  VPDPWUSDZ128mkz,
  VPDPWUSDZ128r,
  VPDPWUSDZ128rk,
  VPDPWUSDZ128rkz,
  VPDPWUSDZ256m,
  VPDPWUSDZ256mb,
  VPDPWUSDZ256mbk,
  VPDPWUSDZ256mbkz,
  VPDPWUSDZ256mk,
  VPDPWUSDZ256mkz,
  VPDPWUSDZ256r,
  VPDPWUSDZ256rk,
  VPDPWUSDZ256rkz,
  VPDPWUSDZm,
  VPDPWUSDZmb,
  VPDPWUSDZmbk,
  VPDPWUSDZmbkz,
  VPDPWUSDZmk,
  VPDPWUSDZmkz,
  VPDPWUSDZr,
  VPDPWUSDZrk,
  VPDPWUSDZrkz,
  VPDPWUSDrm,
  VPDPWUSDrr,
  VPDPWUUDSYrm,
  VPDPWUUDSYrr,
  VPDPWUUDSZ128m,
  VPDPWUUDSZ128mb,
  VPDPWUUDSZ128mbk,
  VPDPWUUDSZ128mbkz,
  VPDPWUUDSZ128mk,
  VPDPWUUDSZ128mkz,
  VPDPWUUDSZ128r,
  VPDPWUUDSZ128rk,
  VPDPWUUDSZ128rkz,
  VPDPWUUDSZ256m,
  VPDPWUUDSZ256mb,
  VPDPWUUDSZ256mbk,
  VPDPWUUDSZ256mbkz,
  VPDPWUUDSZ256mk,
  VPDPWUUDSZ256mkz,
  VPDPWUUDSZ256r,
  VPDPWUUDSZ256rk,
  VPDPWUUDSZ256rkz,
  VPDPWUUDSZm,
  VPDPWUUDSZmb,
  VPDPWUUDSZmbk,
  VPDPWUUDSZmbkz,
  VPDPWUUDSZmk,
  VPDPWUUDSZmkz,
  VPDPWUUDSZr,
  VPDPWUUDSZrk,
  VPDPWUUDSZrkz,
  VPDPWUUDSrm,
  VPDPWUUDSrr,
  VPDPWUUDYrm,
  VPDPWUUDYrr,
  VPDPWUUDZ128m,
  VPDPWUUDZ128mb,
  VPDPWUUDZ128mbk,
  VPDPWUUDZ128mbkz,
  VPDPWUUDZ128mk,
  VPDPWUUDZ128mkz,
  VPDPWUUDZ128r,
  VPDPWUUDZ128rk,
  VPDPWUUDZ128rkz,
  VPDPWUUDZ256m,
  VPDPWUUDZ256mb,
  VPDPWUUDZ256mbk,
  VPDPWUUDZ256mbkz,
  VPDPWUUDZ256mk,
  VPDPWUUDZ256mkz,
  VPDPWUUDZ256r,
  VPDPWUUDZ256rk,
  VPDPWUUDZ256rkz,
  VPDPWUUDZm,
  VPDPWUUDZmb,
  VPDPWUUDZmbk,
  VPDPWUUDZmbkz,
  VPDPWUUDZmk,
  VPDPWUUDZmkz,
  VPDPWUUDZr,
  VPDPWUUDZrk,
  VPDPWUUDZrkz,
  VPDPWUUDrm,
  VPDPWUUDrr,
  VPERM2F128rmi,
  VPERM2F128rri,
  VPERM2I128rmi,
  VPERM2I128rri,
  VPERMBZ128rm,
  VPERMBZ128rmk,
  VPERMBZ128rmkz,
  VPERMBZ128rr,
  VPERMBZ128rrk,
  VPERMBZ128rrkz,
  VPERMBZ256rm,
  VPERMBZ256rmk,
  VPERMBZ256rmkz,
  VPERMBZ256rr,
  VPERMBZ256rrk,
  VPERMBZ256rrkz,
  VPERMBZrm,
  VPERMBZrmk,
  VPERMBZrmkz,
  VPERMBZrr,
  VPERMBZrrk,
  VPERMBZrrkz,
  VPERMDYrm,
  VPERMDYrr,
  VPERMDZ256rm,
  VPERMDZ256rmb,
  VPERMDZ256rmbk,
  VPERMDZ256rmbkz,
  VPERMDZ256rmk,
  VPERMDZ256rmkz,
  VPERMDZ256rr,
  VPERMDZ256rrk,
  VPERMDZ256rrkz,
  VPERMDZrm,
  VPERMDZrmb,
  VPERMDZrmbk,
  VPERMDZrmbkz,
  VPERMDZrmk,
  VPERMDZrmkz,
  VPERMDZrr,
  VPERMDZrrk,
  VPERMDZrrkz,
  VPERMI2BZ128rm,
  VPERMI2BZ128rmk,
  VPERMI2BZ128rmkz,
  VPERMI2BZ128rr,
  VPERMI2BZ128rrk,
  VPERMI2BZ128rrkz,
  VPERMI2BZ256rm,
  VPERMI2BZ256rmk,
  VPERMI2BZ256rmkz,
  VPERMI2BZ256rr,
  VPERMI2BZ256rrk,
  VPERMI2BZ256rrkz,
  VPERMI2BZrm,
  VPERMI2BZrmk,
  VPERMI2BZrmkz,
  VPERMI2BZrr,
  VPERMI2BZrrk,
  VPERMI2BZrrkz,
  VPERMI2DZ128rm,
  VPERMI2DZ128rmb,
  VPERMI2DZ128rmbk,
  VPERMI2DZ128rmbkz,
  VPERMI2DZ128rmk,
  VPERMI2DZ128rmkz,
  VPERMI2DZ128rr,
  VPERMI2DZ128rrk,
  VPERMI2DZ128rrkz,
  VPERMI2DZ256rm,
  VPERMI2DZ256rmb,
  VPERMI2DZ256rmbk,
  VPERMI2DZ256rmbkz,
  VPERMI2DZ256rmk,
  VPERMI2DZ256rmkz,
  VPERMI2DZ256rr,
  VPERMI2DZ256rrk,
  VPERMI2DZ256rrkz,
  VPERMI2DZrm,
  VPERMI2DZrmb,
  VPERMI2DZrmbk,
  VPERMI2DZrmbkz,
  VPERMI2DZrmk,
  VPERMI2DZrmkz,
  VPERMI2DZrr,
  VPERMI2DZrrk,
  VPERMI2DZrrkz,
  VPERMI2PDZ128rm,
  VPERMI2PDZ128rmb,
  VPERMI2PDZ128rmbk,
  VPERMI2PDZ128rmbkz,
  VPERMI2PDZ128rmk,
  VPERMI2PDZ128rmkz,
  VPERMI2PDZ128rr,
  VPERMI2PDZ128rrk,
  VPERMI2PDZ128rrkz,
  VPERMI2PDZ256rm,
  VPERMI2PDZ256rmb,
  VPERMI2PDZ256rmbk,
  VPERMI2PDZ256rmbkz,
  VPERMI2PDZ256rmk,
  VPERMI2PDZ256rmkz,
  VPERMI2PDZ256rr,
  VPERMI2PDZ256rrk,
  VPERMI2PDZ256rrkz,
  VPERMI2PDZrm,
  VPERMI2PDZrmb,
  VPERMI2PDZrmbk,
  VPERMI2PDZrmbkz,
  VPERMI2PDZrmk,
  VPERMI2PDZrmkz,
  VPERMI2PDZrr,
  VPERMI2PDZrrk,
  VPERMI2PDZrrkz,
  VPERMI2PSZ128rm,
  VPERMI2PSZ128rmb,
  VPERMI2PSZ128rmbk,
  VPERMI2PSZ128rmbkz,
  VPERMI2PSZ128rmk,
  VPERMI2PSZ128rmkz,
  VPERMI2PSZ128rr,
  VPERMI2PSZ128rrk,
  VPERMI2PSZ128rrkz,
  VPERMI2PSZ256rm,
  VPERMI2PSZ256rmb,
  VPERMI2PSZ256rmbk,
  VPERMI2PSZ256rmbkz,
  VPERMI2PSZ256rmk,
  VPERMI2PSZ256rmkz,
  VPERMI2PSZ256rr,
  VPERMI2PSZ256rrk,
  VPERMI2PSZ256rrkz,
  VPERMI2PSZrm,
  VPERMI2PSZrmb,
  VPERMI2PSZrmbk,
  VPERMI2PSZrmbkz,
  VPERMI2PSZrmk,
  VPERMI2PSZrmkz,
  VPERMI2PSZrr,
  VPERMI2PSZrrk,
  VPERMI2PSZrrkz,
  VPERMI2QZ128rm,
  VPERMI2QZ128rmb,
  VPERMI2QZ128rmbk,
  VPERMI2QZ128rmbkz,
  VPERMI2QZ128rmk,
  VPERMI2QZ128rmkz,
  VPERMI2QZ128rr,
  VPERMI2QZ128rrk,
  VPERMI2QZ128rrkz,
  VPERMI2QZ256rm,
  VPERMI2QZ256rmb,
  VPERMI2QZ256rmbk,
  VPERMI2QZ256rmbkz,
  VPERMI2QZ256rmk,
  VPERMI2QZ256rmkz,
  VPERMI2QZ256rr,
  VPERMI2QZ256rrk,
  VPERMI2QZ256rrkz,
  VPERMI2QZrm,
  VPERMI2QZrmb,
  VPERMI2QZrmbk,
  VPERMI2QZrmbkz,
  VPERMI2QZrmk,
  VPERMI2QZrmkz,
  VPERMI2QZrr,
  VPERMI2QZrrk,
  VPERMI2QZrrkz,
  VPERMI2WZ128rm,
  VPERMI2WZ128rmk,
  VPERMI2WZ128rmkz,
  VPERMI2WZ128rr,
  VPERMI2WZ128rrk,
  VPERMI2WZ128rrkz,
  VPERMI2WZ256rm,
  VPERMI2WZ256rmk,
  VPERMI2WZ256rmkz,
  VPERMI2WZ256rr,
  VPERMI2WZ256rrk,
  VPERMI2WZ256rrkz,
  VPERMI2WZrm,
  VPERMI2WZrmk,
  VPERMI2WZrmkz,
  VPERMI2WZrr,
  VPERMI2WZrrk,
  VPERMI2WZrrkz,
  VPERMIL2PDYmr,
  VPERMIL2PDYrm,
  VPERMIL2PDYrr,
  VPERMIL2PDYrr_REV,
  VPERMIL2PDmr,
  VPERMIL2PDrm,
  VPERMIL2PDrr,
  VPERMIL2PDrr_REV,
  VPERMIL2PSYmr,
  VPERMIL2PSYrm,
  VPERMIL2PSYrr,
  VPERMIL2PSYrr_REV,
  VPERMIL2PSmr,
  VPERMIL2PSrm,
  VPERMIL2PSrr,
  VPERMIL2PSrr_REV,
  VPERMILPDYmi,
  VPERMILPDYri,
  VPERMILPDYrm,
  VPERMILPDYrr,
  VPERMILPDZ128mbi,
  VPERMILPDZ128mbik,
  VPERMILPDZ128mbikz,
  VPERMILPDZ128mi,
  VPERMILPDZ128mik,
  VPERMILPDZ128mikz,
  VPERMILPDZ128ri,
  VPERMILPDZ128rik,
  VPERMILPDZ128rikz,
  VPERMILPDZ128rm,
  VPERMILPDZ128rmb,
  VPERMILPDZ128rmbk,
  VPERMILPDZ128rmbkz,
  VPERMILPDZ128rmk,
  VPERMILPDZ128rmkz,
  VPERMILPDZ128rr,
  VPERMILPDZ128rrk,
  VPERMILPDZ128rrkz,
  VPERMILPDZ256mbi,
  VPERMILPDZ256mbik,
  VPERMILPDZ256mbikz,
  VPERMILPDZ256mi,
  VPERMILPDZ256mik,
  VPERMILPDZ256mikz,
  VPERMILPDZ256ri,
  VPERMILPDZ256rik,
  VPERMILPDZ256rikz,
  VPERMILPDZ256rm,
  VPERMILPDZ256rmb,
  VPERMILPDZ256rmbk,
  VPERMILPDZ256rmbkz,
  VPERMILPDZ256rmk,
  VPERMILPDZ256rmkz,
  VPERMILPDZ256rr,
  VPERMILPDZ256rrk,
  VPERMILPDZ256rrkz,
  VPERMILPDZmbi,
  VPERMILPDZmbik,
  VPERMILPDZmbikz,
  VPERMILPDZmi,
  VPERMILPDZmik,
  VPERMILPDZmikz,
  VPERMILPDZri,
  VPERMILPDZrik,
  VPERMILPDZrikz,
  VPERMILPDZrm,
  VPERMILPDZrmb,
  VPERMILPDZrmbk,
  VPERMILPDZrmbkz,
  VPERMILPDZrmk,
  VPERMILPDZrmkz,
  VPERMILPDZrr,
  VPERMILPDZrrk,
  VPERMILPDZrrkz,
  VPERMILPDmi,
  VPERMILPDri,
  VPERMILPDrm,
  VPERMILPDrr,
  VPERMILPSYmi,
  VPERMILPSYri,
  VPERMILPSYrm,
  VPERMILPSYrr,
  VPERMILPSZ128mbi,
  VPERMILPSZ128mbik,
  VPERMILPSZ128mbikz,
  VPERMILPSZ128mi,
  VPERMILPSZ128mik,
  VPERMILPSZ128mikz,
  VPERMILPSZ128ri,
  VPERMILPSZ128rik,
  VPERMILPSZ128rikz,
  VPERMILPSZ128rm,
  VPERMILPSZ128rmb,
  VPERMILPSZ128rmbk,
  VPERMILPSZ128rmbkz,
  VPERMILPSZ128rmk,
  VPERMILPSZ128rmkz,
  VPERMILPSZ128rr,
  VPERMILPSZ128rrk,
  VPERMILPSZ128rrkz,
  VPERMILPSZ256mbi,
  VPERMILPSZ256mbik,
  VPERMILPSZ256mbikz,
  VPERMILPSZ256mi,
  VPERMILPSZ256mik,
  VPERMILPSZ256mikz,
  VPERMILPSZ256ri,
  VPERMILPSZ256rik,
  VPERMILPSZ256rikz,
  VPERMILPSZ256rm,
  VPERMILPSZ256rmb,
  VPERMILPSZ256rmbk,
  VPERMILPSZ256rmbkz,
  VPERMILPSZ256rmk,
  VPERMILPSZ256rmkz,
  VPERMILPSZ256rr,
  VPERMILPSZ256rrk,
  VPERMILPSZ256rrkz,
  VPERMILPSZmbi,
  VPERMILPSZmbik,
  VPERMILPSZmbikz,
  VPERMILPSZmi,
  VPERMILPSZmik,
  VPERMILPSZmikz,
  VPERMILPSZri,
  VPERMILPSZrik,
  VPERMILPSZrikz,
  VPERMILPSZrm,
  VPERMILPSZrmb,
  VPERMILPSZrmbk,
  VPERMILPSZrmbkz,
  VPERMILPSZrmk,
  VPERMILPSZrmkz,
  VPERMILPSZrr,
  VPERMILPSZrrk,
  VPERMILPSZrrkz,
  VPERMILPSmi,
  VPERMILPSri,
  VPERMILPSrm,
  VPERMILPSrr,
  VPERMPDYmi,
  VPERMPDYri,
  VPERMPDZ256mbi,
  VPERMPDZ256mbik,
  VPERMPDZ256mbikz,
  VPERMPDZ256mi,
  VPERMPDZ256mik,
  VPERMPDZ256mikz,
  VPERMPDZ256ri,
  VPERMPDZ256rik,
  VPERMPDZ256rikz,
  VPERMPDZ256rm,
  VPERMPDZ256rmb,
  VPERMPDZ256rmbk,
  VPERMPDZ256rmbkz,
  VPERMPDZ256rmk,
  VPERMPDZ256rmkz,
  VPERMPDZ256rr,
  VPERMPDZ256rrk,
  VPERMPDZ256rrkz,
  VPERMPDZmbi,
  VPERMPDZmbik,
  VPERMPDZmbikz,
  VPERMPDZmi,
  VPERMPDZmik,
  VPERMPDZmikz,
  VPERMPDZri,
  VPERMPDZrik,
  VPERMPDZrikz,
  VPERMPDZrm,
  VPERMPDZrmb,
  VPERMPDZrmbk,
  VPERMPDZrmbkz,
  VPERMPDZrmk,
  VPERMPDZrmkz,
  VPERMPDZrr,
  VPERMPDZrrk,
  VPERMPDZrrkz,
  VPERMPSYrm,
  VPERMPSYrr,
  VPERMPSZ256rm,
  VPERMPSZ256rmb,
  VPERMPSZ256rmbk,
  VPERMPSZ256rmbkz,
  VPERMPSZ256rmk,
  VPERMPSZ256rmkz,
  VPERMPSZ256rr,
  VPERMPSZ256rrk,
  VPERMPSZ256rrkz,
  VPERMPSZrm,
  VPERMPSZrmb,
  VPERMPSZrmbk,
  VPERMPSZrmbkz,
  VPERMPSZrmk,
  VPERMPSZrmkz,
  VPERMPSZrr,
  VPERMPSZrrk,
  VPERMPSZrrkz,
  VPERMQYmi,
  VPERMQYri,
  VPERMQZ256mbi,
  VPERMQZ256mbik,
  VPERMQZ256mbikz,
  VPERMQZ256mi,
  VPERMQZ256mik,
  VPERMQZ256mikz,
  VPERMQZ256ri,
  VPERMQZ256rik,
  VPERMQZ256rikz,
  VPERMQZ256rm,
  VPERMQZ256rmb,
  VPERMQZ256rmbk,
  VPERMQZ256rmbkz,
  VPERMQZ256rmk,
  VPERMQZ256rmkz,
  VPERMQZ256rr,
  VPERMQZ256rrk,
  VPERMQZ256rrkz,
  VPERMQZmbi,
  VPERMQZmbik,
  VPERMQZmbikz,
  VPERMQZmi,
  VPERMQZmik,
  VPERMQZmikz,
  VPERMQZri,
  VPERMQZrik,
  VPERMQZrikz,
  VPERMQZrm,
  VPERMQZrmb,
  VPERMQZrmbk,
  VPERMQZrmbkz,
  VPERMQZrmk,
  VPERMQZrmkz,
  VPERMQZrr,
  VPERMQZrrk,
  VPERMQZrrkz,
  VPERMT2BZ128rm,
  VPERMT2BZ128rmk,
  VPERMT2BZ128rmkz,
  VPERMT2BZ128rr,
  VPERMT2BZ128rrk,
  VPERMT2BZ128rrkz,
  VPERMT2BZ256rm,
  VPERMT2BZ256rmk,
  VPERMT2BZ256rmkz,
  VPERMT2BZ256rr,
  VPERMT2BZ256rrk,
  VPERMT2BZ256rrkz,
  VPERMT2BZrm,
  VPERMT2BZrmk,
  VPERMT2BZrmkz,
  VPERMT2BZrr,
  VPERMT2BZrrk,
  VPERMT2BZrrkz,
  VPERMT2DZ128rm,
  VPERMT2DZ128rmb,
  VPERMT2DZ128rmbk,
  VPERMT2DZ128rmbkz,
  VPERMT2DZ128rmk,
  VPERMT2DZ128rmkz,
  VPERMT2DZ128rr,
  VPERMT2DZ128rrk,
  VPERMT2DZ128rrkz,
  VPERMT2DZ256rm,
  VPERMT2DZ256rmb,
  VPERMT2DZ256rmbk,
  VPERMT2DZ256rmbkz,
  VPERMT2DZ256rmk,
  VPERMT2DZ256rmkz,
  VPERMT2DZ256rr,
  VPERMT2DZ256rrk,
  VPERMT2DZ256rrkz,
  VPERMT2DZrm,
  VPERMT2DZrmb,
  VPERMT2DZrmbk,
  VPERMT2DZrmbkz,
  VPERMT2DZrmk,
  VPERMT2DZrmkz,
  VPERMT2DZrr,
  VPERMT2DZrrk,
  VPERMT2DZrrkz,
  VPERMT2PDZ128rm,
  VPERMT2PDZ128rmb,
  VPERMT2PDZ128rmbk,
  VPERMT2PDZ128rmbkz,
  VPERMT2PDZ128rmk,
  VPERMT2PDZ128rmkz,
  VPERMT2PDZ128rr,
  VPERMT2PDZ128rrk,
  VPERMT2PDZ128rrkz,
  VPERMT2PDZ256rm,
  VPERMT2PDZ256rmb,
  VPERMT2PDZ256rmbk,
  VPERMT2PDZ256rmbkz,
  VPERMT2PDZ256rmk,
  VPERMT2PDZ256rmkz,
  VPERMT2PDZ256rr,
  VPERMT2PDZ256rrk,
  VPERMT2PDZ256rrkz,
  VPERMT2PDZrm,
  VPERMT2PDZrmb,
  VPERMT2PDZrmbk,
  VPERMT2PDZrmbkz,
  VPERMT2PDZrmk,
  VPERMT2PDZrmkz,
  VPERMT2PDZrr,
  VPERMT2PDZrrk,
  VPERMT2PDZrrkz,
  VPERMT2PSZ128rm,
  VPERMT2PSZ128rmb,
  VPERMT2PSZ128rmbk,
  VPERMT2PSZ128rmbkz,
  VPERMT2PSZ128rmk,
  VPERMT2PSZ128rmkz,
  VPERMT2PSZ128rr,
  VPERMT2PSZ128rrk,
  VPERMT2PSZ128rrkz,
  VPERMT2PSZ256rm,
  VPERMT2PSZ256rmb,
  VPERMT2PSZ256rmbk,
  VPERMT2PSZ256rmbkz,
  VPERMT2PSZ256rmk,
  VPERMT2PSZ256rmkz,
  VPERMT2PSZ256rr,
  VPERMT2PSZ256rrk,
  VPERMT2PSZ256rrkz,
  VPERMT2PSZrm,
  VPERMT2PSZrmb,
  VPERMT2PSZrmbk,
  VPERMT2PSZrmbkz,
  VPERMT2PSZrmk,
  VPERMT2PSZrmkz,
  VPERMT2PSZrr,
  VPERMT2PSZrrk,
  VPERMT2PSZrrkz,
  VPERMT2QZ128rm,
  VPERMT2QZ128rmb,
  VPERMT2QZ128rmbk,
  VPERMT2QZ128rmbkz,
  VPERMT2QZ128rmk,
  VPERMT2QZ128rmkz,
  VPERMT2QZ128rr,
  VPERMT2QZ128rrk,
  VPERMT2QZ128rrkz,
  VPERMT2QZ256rm,
  VPERMT2QZ256rmb,
  VPERMT2QZ256rmbk,
  VPERMT2QZ256rmbkz,
  VPERMT2QZ256rmk,
  VPERMT2QZ256rmkz,
  VPERMT2QZ256rr,
  VPERMT2QZ256rrk,
  VPERMT2QZ256rrkz,
  VPERMT2QZrm,
  VPERMT2QZrmb,
  VPERMT2QZrmbk,
  VPERMT2QZrmbkz,
  VPERMT2QZrmk,
  VPERMT2QZrmkz,
  VPERMT2QZrr,
  VPERMT2QZrrk,
  VPERMT2QZrrkz,
  VPERMT2WZ128rm,
  VPERMT2WZ128rmk,
  VPERMT2WZ128rmkz,
  VPERMT2WZ128rr,
  VPERMT2WZ128rrk,
  VPERMT2WZ128rrkz,
  VPERMT2WZ256rm,
  VPERMT2WZ256rmk,
  VPERMT2WZ256rmkz,
  VPERMT2WZ256rr,
  VPERMT2WZ256rrk,
  VPERMT2WZ256rrkz,
  VPERMT2WZrm,
  VPERMT2WZrmk,
  VPERMT2WZrmkz,
  VPERMT2WZrr,
  VPERMT2WZrrk,
  VPERMT2WZrrkz,
  VPERMWZ128rm,
  VPERMWZ128rmk,
  VPERMWZ128rmkz,
  VPERMWZ128rr,
  VPERMWZ128rrk,
  VPERMWZ128rrkz,
  VPERMWZ256rm,
  VPERMWZ256rmk,
  VPERMWZ256rmkz,
  VPERMWZ256rr,
  VPERMWZ256rrk,
  VPERMWZ256rrkz,
  VPERMWZrm,
  VPERMWZrmk,
  VPERMWZrmkz,
  VPERMWZrr,
  VPERMWZrrk,
  VPERMWZrrkz,
  VPEXPANDBZ128rm,
  VPEXPANDBZ128rmk,
  VPEXPANDBZ128rmkz,
  VPEXPANDBZ128rr,
  VPEXPANDBZ128rrk,
  VPEXPANDBZ128rrkz,
  VPEXPANDBZ256rm,
  VPEXPANDBZ256rmk,
  VPEXPANDBZ256rmkz,
  VPEXPANDBZ256rr,
  VPEXPANDBZ256rrk,
  VPEXPANDBZ256rrkz,
  VPEXPANDBZrm,
  VPEXPANDBZrmk,
  VPEXPANDBZrmkz,
  VPEXPANDBZrr,
  VPEXPANDBZrrk,
  VPEXPANDBZrrkz,
  VPEXPANDDZ128rm,
  VPEXPANDDZ128rmk,
  VPEXPANDDZ128rmkz,
  VPEXPANDDZ128rr,
  VPEXPANDDZ128rrk,
  VPEXPANDDZ128rrkz,
  VPEXPANDDZ256rm,
  VPEXPANDDZ256rmk,
  VPEXPANDDZ256rmkz,
  VPEXPANDDZ256rr,
  VPEXPANDDZ256rrk,
  VPEXPANDDZ256rrkz,
  VPEXPANDDZrm,
  VPEXPANDDZrmk,
  VPEXPANDDZrmkz,
  VPEXPANDDZrr,
  VPEXPANDDZrrk,
  VPEXPANDDZrrkz,
  VPEXPANDQZ128rm,
  VPEXPANDQZ128rmk,
  VPEXPANDQZ128rmkz,
  VPEXPANDQZ128rr,
  VPEXPANDQZ128rrk,
  VPEXPANDQZ128rrkz,
  VPEXPANDQZ256rm,
  VPEXPANDQZ256rmk,
  VPEXPANDQZ256rmkz,
  VPEXPANDQZ256rr,
  VPEXPANDQZ256rrk,
  VPEXPANDQZ256rrkz,
  VPEXPANDQZrm,
  VPEXPANDQZrmk,
  VPEXPANDQZrmkz,
  VPEXPANDQZrr,
  VPEXPANDQZrrk,
  VPEXPANDQZrrkz,
  VPEXPANDWZ128rm,
  VPEXPANDWZ128rmk,
  VPEXPANDWZ128rmkz,
  VPEXPANDWZ128rr,
  VPEXPANDWZ128rrk,
  VPEXPANDWZ128rrkz,
  VPEXPANDWZ256rm,
  VPEXPANDWZ256rmk,
  VPEXPANDWZ256rmkz,
  VPEXPANDWZ256rr,
  VPEXPANDWZ256rrk,
  VPEXPANDWZ256rrkz,
  VPEXPANDWZrm,
  VPEXPANDWZrmk,
  VPEXPANDWZrmkz,
  VPEXPANDWZrr,
  VPEXPANDWZrrk,
  VPEXPANDWZrrkz,
  VPEXTRBZmri,
  VPEXTRBZrri,
  VPEXTRBmri,
  VPEXTRBrri,
  VPEXTRDZmri,
  VPEXTRDZrri,
  VPEXTRDmri,
  VPEXTRDrri,
  VPEXTRQZmri,
  VPEXTRQZrri,
  VPEXTRQmri,
  VPEXTRQrri,
  VPEXTRWZmri,
  VPEXTRWZrri,
  VPEXTRWZrri_REV,
  VPEXTRWmri,
  VPEXTRWrri,
  VPEXTRWrri_REV,
  VPGATHERDDYrm,
  VPGATHERDDZ128rm,
  VPGATHERDDZ256rm,
  VPGATHERDDZrm,
  VPGATHERDDrm,
  VPGATHERDQYrm,
  VPGATHERDQZ128rm,
  VPGATHERDQZ256rm,
  VPGATHERDQZrm,
  VPGATHERDQrm,
  VPGATHERQDYrm,
  VPGATHERQDZ128rm,
  VPGATHERQDZ256rm,
  VPGATHERQDZrm,
  VPGATHERQDrm,
  VPGATHERQQYrm,
  VPGATHERQQZ128rm,
  VPGATHERQQZ256rm,
  VPGATHERQQZrm,
  VPGATHERQQrm,
  VPHADDBDrm,
  VPHADDBDrr,
  VPHADDBQrm,
  VPHADDBQrr,
  VPHADDBWrm,
  VPHADDBWrr,
  VPHADDDQrm,
  VPHADDDQrr,
  VPHADDDYrm,
  VPHADDDYrr,
  VPHADDDrm,
  VPHADDDrr,
  VPHADDSWYrm,
  VPHADDSWYrr,
  VPHADDSWrm,
  VPHADDSWrr,
  VPHADDUBDrm,
  VPHADDUBDrr,
  VPHADDUBQrm,
  VPHADDUBQrr,
  VPHADDUBWrm,
  VPHADDUBWrr,
  VPHADDUDQrm,
  VPHADDUDQrr,
  VPHADDUWDrm,
  VPHADDUWDrr,
  VPHADDUWQrm,
  VPHADDUWQrr,
  VPHADDWDrm,
  VPHADDWDrr,
  VPHADDWQrm,
  VPHADDWQrr,
  VPHADDWYrm,
  VPHADDWYrr,
  VPHADDWrm,
  VPHADDWrr,
  VPHMINPOSUWrm,
  VPHMINPOSUWrr,
  VPHSUBBWrm,
  VPHSUBBWrr,
  VPHSUBDQrm,
  VPHSUBDQrr,
  VPHSUBDYrm,
  VPHSUBDYrr,
  VPHSUBDrm,
  VPHSUBDrr,
  VPHSUBSWYrm,
  VPHSUBSWYrr,
  VPHSUBSWrm,
  VPHSUBSWrr,
  VPHSUBWDrm,
  VPHSUBWDrr,
  VPHSUBWYrm,
  VPHSUBWYrr,
  VPHSUBWrm,
  VPHSUBWrr,
  VPINSRBZrmi,
  VPINSRBZrri,
  VPINSRBrmi,
  VPINSRBrri,
  VPINSRDZrmi,
  VPINSRDZrri,
  VPINSRDrmi,
  VPINSRDrri,
  VPINSRQZrmi,
  VPINSRQZrri,
  VPINSRQrmi,
  VPINSRQrri,
  VPINSRWZrmi,
  VPINSRWZrri,
  VPINSRWrmi,
  VPINSRWrri,
  VPLZCNTDZ128rm,
  VPLZCNTDZ128rmb,
  VPLZCNTDZ128rmbk,
  VPLZCNTDZ128rmbkz,
  VPLZCNTDZ128rmk,
  VPLZCNTDZ128rmkz,
  VPLZCNTDZ128rr,
  VPLZCNTDZ128rrk,
  VPLZCNTDZ128rrkz,
  VPLZCNTDZ256rm,
  VPLZCNTDZ256rmb,
  VPLZCNTDZ256rmbk,
  VPLZCNTDZ256rmbkz,
  VPLZCNTDZ256rmk,
  VPLZCNTDZ256rmkz,
  VPLZCNTDZ256rr,
  VPLZCNTDZ256rrk,
  VPLZCNTDZ256rrkz,
  VPLZCNTDZrm,
  VPLZCNTDZrmb,
  VPLZCNTDZrmbk,
  VPLZCNTDZrmbkz,
  VPLZCNTDZrmk,
  VPLZCNTDZrmkz,
  VPLZCNTDZrr,
  VPLZCNTDZrrk,
  VPLZCNTDZrrkz,
  VPLZCNTQZ128rm,
  VPLZCNTQZ128rmb,
  VPLZCNTQZ128rmbk,
  VPLZCNTQZ128rmbkz,
  VPLZCNTQZ128rmk,
  VPLZCNTQZ128rmkz,
  VPLZCNTQZ128rr,
  VPLZCNTQZ128rrk,
  VPLZCNTQZ128rrkz,
  VPLZCNTQZ256rm,
  VPLZCNTQZ256rmb,
  VPLZCNTQZ256rmbk,
  VPLZCNTQZ256rmbkz,
  VPLZCNTQZ256rmk,
  VPLZCNTQZ256rmkz,
  VPLZCNTQZ256rr,
  VPLZCNTQZ256rrk,
  VPLZCNTQZ256rrkz,
  VPLZCNTQZrm,
  VPLZCNTQZrmb,
  VPLZCNTQZrmbk,
  VPLZCNTQZrmbkz,
  VPLZCNTQZrmk,
  VPLZCNTQZrmkz,
  VPLZCNTQZrr,
  VPLZCNTQZrrk,
  VPLZCNTQZrrkz,
  VPMACSDDrm,
  VPMACSDDrr,
  VPMACSDQHrm,
  VPMACSDQHrr,
  VPMACSDQLrm,
  VPMACSDQLrr,
  VPMACSSDDrm,
  VPMACSSDDrr,
  VPMACSSDQHrm,
  VPMACSSDQHrr,
  VPMACSSDQLrm,
  VPMACSSDQLrr,
  VPMACSSWDrm,
  VPMACSSWDrr,
  VPMACSSWWrm,
  VPMACSSWWrr,
  VPMACSWDrm,
  VPMACSWDrr,
  VPMACSWWrm,
  VPMACSWWrr,
  VPMADCSSWDrm,
  VPMADCSSWDrr,
  VPMADCSWDrm,
  VPMADCSWDrr,
  VPMADD52HUQYrm,
  VPMADD52HUQYrr,
  VPMADD52HUQZ128m,
  VPMADD52HUQZ128mb,
  VPMADD52HUQZ128mbk,
  VPMADD52HUQZ128mbkz,
  VPMADD52HUQZ128mk,
  VPMADD52HUQZ128mkz,
  VPMADD52HUQZ128r,
  VPMADD52HUQZ128rk,
  VPMADD52HUQZ128rkz,
  VPMADD52HUQZ256m,
  VPMADD52HUQZ256mb,
  VPMADD52HUQZ256mbk,
  VPMADD52HUQZ256mbkz,
  VPMADD52HUQZ256mk,
  VPMADD52HUQZ256mkz,
  VPMADD52HUQZ256r,
  VPMADD52HUQZ256rk,
  VPMADD52HUQZ256rkz,
  VPMADD52HUQZm,
  VPMADD52HUQZmb,
  VPMADD52HUQZmbk,
  VPMADD52HUQZmbkz,
  VPMADD52HUQZmk,
  VPMADD52HUQZmkz,
  VPMADD52HUQZr,
  VPMADD52HUQZrk,
  VPMADD52HUQZrkz,
  VPMADD52HUQrm,
  VPMADD52HUQrr,
  VPMADD52LUQYrm,
  VPMADD52LUQYrr,
  VPMADD52LUQZ128m,
  VPMADD52LUQZ128mb,
  VPMADD52LUQZ128mbk,
  VPMADD52LUQZ128mbkz,
  VPMADD52LUQZ128mk,
  VPMADD52LUQZ128mkz,
  VPMADD52LUQZ128r,
  VPMADD52LUQZ128rk,
  VPMADD52LUQZ128rkz,
  VPMADD52LUQZ256m,
  VPMADD52LUQZ256mb,
  VPMADD52LUQZ256mbk,
  VPMADD52LUQZ256mbkz,
  VPMADD52LUQZ256mk,
  VPMADD52LUQZ256mkz,
  VPMADD52LUQZ256r,
  VPMADD52LUQZ256rk,
  VPMADD52LUQZ256rkz,
  VPMADD52LUQZm,
  VPMADD52LUQZmb,
  VPMADD52LUQZmbk,
  VPMADD52LUQZmbkz,
  VPMADD52LUQZmk,
  VPMADD52LUQZmkz,
  VPMADD52LUQZr,
  VPMADD52LUQZrk,
  VPMADD52LUQZrkz,
  VPMADD52LUQrm,
  VPMADD52LUQrr,
  VPMADDUBSWYrm,
  VPMADDUBSWYrr,
  VPMADDUBSWZ128rm,
  VPMADDUBSWZ128rmk,
  VPMADDUBSWZ128rmkz,
  VPMADDUBSWZ128rr,
  VPMADDUBSWZ128rrk,
  VPMADDUBSWZ128rrkz,
  VPMADDUBSWZ256rm,
  VPMADDUBSWZ256rmk,
  VPMADDUBSWZ256rmkz,
  VPMADDUBSWZ256rr,
  VPMADDUBSWZ256rrk,
  VPMADDUBSWZ256rrkz,
  VPMADDUBSWZrm,
  VPMADDUBSWZrmk,
  VPMADDUBSWZrmkz,
  VPMADDUBSWZrr,
  VPMADDUBSWZrrk,
  VPMADDUBSWZrrkz,
  VPMADDUBSWrm,
  VPMADDUBSWrr,
  VPMADDWDYrm,
  VPMADDWDYrr,
  VPMADDWDZ128rm,
  VPMADDWDZ128rmk,
  VPMADDWDZ128rmkz,
  VPMADDWDZ128rr,
  VPMADDWDZ128rrk,
  VPMADDWDZ128rrkz,
  VPMADDWDZ256rm,
  VPMADDWDZ256rmk,
  VPMADDWDZ256rmkz,
  VPMADDWDZ256rr,
  VPMADDWDZ256rrk,
  VPMADDWDZ256rrkz,
  VPMADDWDZrm,
  VPMADDWDZrmk,
  VPMADDWDZrmkz,
  VPMADDWDZrr,
  VPMADDWDZrrk,
  VPMADDWDZrrkz,
  VPMADDWDrm,
  VPMADDWDrr,
  VPMASKMOVDYmr,
  VPMASKMOVDYrm,
  VPMASKMOVDmr,
  VPMASKMOVDrm,
  VPMASKMOVQYmr,
  VPMASKMOVQYrm,
  VPMASKMOVQmr,
  VPMASKMOVQrm,
  VPMAXSBYrm,
  VPMAXSBYrr,
  VPMAXSBZ128rm,
  VPMAXSBZ128rmk,
  VPMAXSBZ128rmkz,
  VPMAXSBZ128rr,
  VPMAXSBZ128rrk,
  VPMAXSBZ128rrkz,
  VPMAXSBZ256rm,
  VPMAXSBZ256rmk,
  VPMAXSBZ256rmkz,
  VPMAXSBZ256rr,
  VPMAXSBZ256rrk,
  VPMAXSBZ256rrkz,
  VPMAXSBZrm,
  VPMAXSBZrmk,
  VPMAXSBZrmkz,
  VPMAXSBZrr,
  VPMAXSBZrrk,
  VPMAXSBZrrkz,
  VPMAXSBrm,
  VPMAXSBrr,
  VPMAXSDYrm,
  VPMAXSDYrr,
  VPMAXSDZ128rm,
  VPMAXSDZ128rmb,
  VPMAXSDZ128rmbk,
  VPMAXSDZ128rmbkz,
  VPMAXSDZ128rmk,
  VPMAXSDZ128rmkz,
  VPMAXSDZ128rr,
  VPMAXSDZ128rrk,
  VPMAXSDZ128rrkz,
  VPMAXSDZ256rm,
  VPMAXSDZ256rmb,
  VPMAXSDZ256rmbk,
  VPMAXSDZ256rmbkz,
  VPMAXSDZ256rmk,
  VPMAXSDZ256rmkz,
  VPMAXSDZ256rr,
  VPMAXSDZ256rrk,
  VPMAXSDZ256rrkz,
  VPMAXSDZrm,
  VPMAXSDZrmb,
  VPMAXSDZrmbk,
  VPMAXSDZrmbkz,
  VPMAXSDZrmk,
  VPMAXSDZrmkz,
  VPMAXSDZrr,
  VPMAXSDZrrk,
  VPMAXSDZrrkz,
  VPMAXSDrm,
  VPMAXSDrr,
  VPMAXSQZ128rm,
  VPMAXSQZ128rmb,
  VPMAXSQZ128rmbk,
  VPMAXSQZ128rmbkz,
  VPMAXSQZ128rmk,
  VPMAXSQZ128rmkz,
  VPMAXSQZ128rr,
  VPMAXSQZ128rrk,
  VPMAXSQZ128rrkz,
  VPMAXSQZ256rm,
  VPMAXSQZ256rmb,
  VPMAXSQZ256rmbk,
  VPMAXSQZ256rmbkz,
  VPMAXSQZ256rmk,
  VPMAXSQZ256rmkz,
  VPMAXSQZ256rr,
  VPMAXSQZ256rrk,
  VPMAXSQZ256rrkz,
  VPMAXSQZrm,
  VPMAXSQZrmb,
  VPMAXSQZrmbk,
  VPMAXSQZrmbkz,
  VPMAXSQZrmk,
  VPMAXSQZrmkz,
  VPMAXSQZrr,
  VPMAXSQZrrk,
  VPMAXSQZrrkz,
  VPMAXSWYrm,
  VPMAXSWYrr,
  VPMAXSWZ128rm,
  VPMAXSWZ128rmk,
  VPMAXSWZ128rmkz,
  VPMAXSWZ128rr,
  VPMAXSWZ128rrk,
  VPMAXSWZ128rrkz,
  VPMAXSWZ256rm,
  VPMAXSWZ256rmk,
  VPMAXSWZ256rmkz,
  VPMAXSWZ256rr,
  VPMAXSWZ256rrk,
  VPMAXSWZ256rrkz,
  VPMAXSWZrm,
  VPMAXSWZrmk,
  VPMAXSWZrmkz,
  VPMAXSWZrr,
  VPMAXSWZrrk,
  VPMAXSWZrrkz,
  VPMAXSWrm,
  VPMAXSWrr,
  VPMAXUBYrm,
  VPMAXUBYrr,
  VPMAXUBZ128rm,
  VPMAXUBZ128rmk,
  VPMAXUBZ128rmkz,
  VPMAXUBZ128rr,
  VPMAXUBZ128rrk,
  VPMAXUBZ128rrkz,
  VPMAXUBZ256rm,
  VPMAXUBZ256rmk,
  VPMAXUBZ256rmkz,
  VPMAXUBZ256rr,
  VPMAXUBZ256rrk,
  VPMAXUBZ256rrkz,
  VPMAXUBZrm,
  VPMAXUBZrmk,
  VPMAXUBZrmkz,
  VPMAXUBZrr,
  VPMAXUBZrrk,
  VPMAXUBZrrkz,
  VPMAXUBrm,
  VPMAXUBrr,
  VPMAXUDYrm,
  VPMAXUDYrr,
  VPMAXUDZ128rm,
  VPMAXUDZ128rmb,
  VPMAXUDZ128rmbk,
  VPMAXUDZ128rmbkz,
  VPMAXUDZ128rmk,
  VPMAXUDZ128rmkz,
  VPMAXUDZ128rr,
  VPMAXUDZ128rrk,
  VPMAXUDZ128rrkz,
  VPMAXUDZ256rm,
  VPMAXUDZ256rmb,
  VPMAXUDZ256rmbk,
  VPMAXUDZ256rmbkz,
  VPMAXUDZ256rmk,
  VPMAXUDZ256rmkz,
  VPMAXUDZ256rr,
  VPMAXUDZ256rrk,
  VPMAXUDZ256rrkz,
  VPMAXUDZrm,
  VPMAXUDZrmb,
  VPMAXUDZrmbk,
  VPMAXUDZrmbkz,
  VPMAXUDZrmk,
  VPMAXUDZrmkz,
  VPMAXUDZrr,
  VPMAXUDZrrk,
  VPMAXUDZrrkz,
  VPMAXUDrm,
  VPMAXUDrr,
  VPMAXUQZ128rm,
  VPMAXUQZ128rmb,
  VPMAXUQZ128rmbk,
  VPMAXUQZ128rmbkz,
  VPMAXUQZ128rmk,
  VPMAXUQZ128rmkz,
  VPMAXUQZ128rr,
  VPMAXUQZ128rrk,
  VPMAXUQZ128rrkz,
  VPMAXUQZ256rm,
  VPMAXUQZ256rmb,
  VPMAXUQZ256rmbk,
  VPMAXUQZ256rmbkz,
  VPMAXUQZ256rmk,
  VPMAXUQZ256rmkz,
  VPMAXUQZ256rr,
  VPMAXUQZ256rrk,
  VPMAXUQZ256rrkz,
  VPMAXUQZrm,
  VPMAXUQZrmb,
  VPMAXUQZrmbk,
  VPMAXUQZrmbkz,
  VPMAXUQZrmk,
  VPMAXUQZrmkz,
  VPMAXUQZrr,
  VPMAXUQZrrk,
  VPMAXUQZrrkz,
  VPMAXUWYrm,
  VPMAXUWYrr,
  VPMAXUWZ128rm,
  VPMAXUWZ128rmk,
  VPMAXUWZ128rmkz,
  VPMAXUWZ128rr,
  VPMAXUWZ128rrk,
  VPMAXUWZ128rrkz,
  VPMAXUWZ256rm,
  VPMAXUWZ256rmk,
  VPMAXUWZ256rmkz,
  VPMAXUWZ256rr,
  VPMAXUWZ256rrk,
  VPMAXUWZ256rrkz,
  VPMAXUWZrm,
  VPMAXUWZrmk,
  VPMAXUWZrmkz,
  VPMAXUWZrr,
  VPMAXUWZrrk,
  VPMAXUWZrrkz,
  VPMAXUWrm,
  VPMAXUWrr,
  VPMINSBYrm,
  VPMINSBYrr,
  VPMINSBZ128rm,
  VPMINSBZ128rmk,
  VPMINSBZ128rmkz,
  VPMINSBZ128rr,
  VPMINSBZ128rrk,
  VPMINSBZ128rrkz,
  VPMINSBZ256rm,
  VPMINSBZ256rmk,
  VPMINSBZ256rmkz,
  VPMINSBZ256rr,
  VPMINSBZ256rrk,
  VPMINSBZ256rrkz,
  VPMINSBZrm,
  VPMINSBZrmk,
  VPMINSBZrmkz,
  VPMINSBZrr,
  VPMINSBZrrk,
  VPMINSBZrrkz,
  VPMINSBrm,
  VPMINSBrr,
  VPMINSDYrm,
  VPMINSDYrr,
  VPMINSDZ128rm,
  VPMINSDZ128rmb,
  VPMINSDZ128rmbk,
  VPMINSDZ128rmbkz,
  VPMINSDZ128rmk,
  VPMINSDZ128rmkz,
  VPMINSDZ128rr,
  VPMINSDZ128rrk,
  VPMINSDZ128rrkz,
  VPMINSDZ256rm,
  VPMINSDZ256rmb,
  VPMINSDZ256rmbk,
  VPMINSDZ256rmbkz,
  VPMINSDZ256rmk,
  VPMINSDZ256rmkz,
  VPMINSDZ256rr,
  VPMINSDZ256rrk,
  VPMINSDZ256rrkz,
  VPMINSDZrm,
  VPMINSDZrmb,
  VPMINSDZrmbk,
  VPMINSDZrmbkz,
  VPMINSDZrmk,
  VPMINSDZrmkz,
  VPMINSDZrr,
  VPMINSDZrrk,
  VPMINSDZrrkz,
  VPMINSDrm,
  VPMINSDrr,
  VPMINSQZ128rm,
  VPMINSQZ128rmb,
  VPMINSQZ128rmbk,
  VPMINSQZ128rmbkz,
  VPMINSQZ128rmk,
  VPMINSQZ128rmkz,
  VPMINSQZ128rr,
  VPMINSQZ128rrk,
  VPMINSQZ128rrkz,
  VPMINSQZ256rm,
  VPMINSQZ256rmb,
  VPMINSQZ256rmbk,
  VPMINSQZ256rmbkz,
  VPMINSQZ256rmk,
  VPMINSQZ256rmkz,
  VPMINSQZ256rr,
  VPMINSQZ256rrk,
  VPMINSQZ256rrkz,
  VPMINSQZrm,
  VPMINSQZrmb,
  VPMINSQZrmbk,
  VPMINSQZrmbkz,
  VPMINSQZrmk,
  VPMINSQZrmkz,
  VPMINSQZrr,
  VPMINSQZrrk,
  VPMINSQZrrkz,
  VPMINSWYrm,
  VPMINSWYrr,
  VPMINSWZ128rm,
  VPMINSWZ128rmk,
  VPMINSWZ128rmkz,
  VPMINSWZ128rr,
  VPMINSWZ128rrk,
  VPMINSWZ128rrkz,
  VPMINSWZ256rm,
  VPMINSWZ256rmk,
  VPMINSWZ256rmkz,
  VPMINSWZ256rr,
  VPMINSWZ256rrk,
  VPMINSWZ256rrkz,
  VPMINSWZrm,
  VPMINSWZrmk,
  VPMINSWZrmkz,
  VPMINSWZrr,
  VPMINSWZrrk,
  VPMINSWZrrkz,
  VPMINSWrm,
  VPMINSWrr,
  VPMINUBYrm,
  VPMINUBYrr,
  VPMINUBZ128rm,
  VPMINUBZ128rmk,
  VPMINUBZ128rmkz,
  VPMINUBZ128rr,
  VPMINUBZ128rrk,
  VPMINUBZ128rrkz,
  VPMINUBZ256rm,
  VPMINUBZ256rmk,
  VPMINUBZ256rmkz,
  VPMINUBZ256rr,
  VPMINUBZ256rrk,
  VPMINUBZ256rrkz,
  VPMINUBZrm,
  VPMINUBZrmk,
  VPMINUBZrmkz,
  VPMINUBZrr,
  VPMINUBZrrk,
  VPMINUBZrrkz,
  VPMINUBrm,
  VPMINUBrr,
  VPMINUDYrm,
  VPMINUDYrr,
  VPMINUDZ128rm,
  VPMINUDZ128rmb,
  VPMINUDZ128rmbk,
  VPMINUDZ128rmbkz,
  VPMINUDZ128rmk,
  VPMINUDZ128rmkz,
  VPMINUDZ128rr,
  VPMINUDZ128rrk,
  VPMINUDZ128rrkz,
  VPMINUDZ256rm,
  VPMINUDZ256rmb,
  VPMINUDZ256rmbk,
  VPMINUDZ256rmbkz,
  VPMINUDZ256rmk,
  VPMINUDZ256rmkz,
  VPMINUDZ256rr,
  VPMINUDZ256rrk,
  VPMINUDZ256rrkz,
  VPMINUDZrm,
  VPMINUDZrmb,
  VPMINUDZrmbk,
  VPMINUDZrmbkz,
  VPMINUDZrmk,
  VPMINUDZrmkz,
  VPMINUDZrr,
  VPMINUDZrrk,
  VPMINUDZrrkz,
  VPMINUDrm,
  VPMINUDrr,
  VPMINUQZ128rm,
  VPMINUQZ128rmb,
  VPMINUQZ128rmbk,
  VPMINUQZ128rmbkz,
  VPMINUQZ128rmk,
  VPMINUQZ128rmkz,
  VPMINUQZ128rr,
  VPMINUQZ128rrk,
  VPMINUQZ128rrkz,
  VPMINUQZ256rm,
  VPMINUQZ256rmb,
  VPMINUQZ256rmbk,
  VPMINUQZ256rmbkz,
  VPMINUQZ256rmk,
  VPMINUQZ256rmkz,
  VPMINUQZ256rr,
  VPMINUQZ256rrk,
  VPMINUQZ256rrkz,
  VPMINUQZrm,
  VPMINUQZrmb,
  VPMINUQZrmbk,
  VPMINUQZrmbkz,
  VPMINUQZrmk,
  VPMINUQZrmkz,
  VPMINUQZrr,
  VPMINUQZrrk,
  VPMINUQZrrkz,
  VPMINUWYrm,
  VPMINUWYrr,
  VPMINUWZ128rm,
  VPMINUWZ128rmk,
  VPMINUWZ128rmkz,
  VPMINUWZ128rr,
  VPMINUWZ128rrk,
  VPMINUWZ128rrkz,
  VPMINUWZ256rm,
  VPMINUWZ256rmk,
  VPMINUWZ256rmkz,
  VPMINUWZ256rr,
  VPMINUWZ256rrk,
  VPMINUWZ256rrkz,
  VPMINUWZrm,
  VPMINUWZrmk,
  VPMINUWZrmkz,
  VPMINUWZrr,
  VPMINUWZrrk,
  VPMINUWZrrkz,
  VPMINUWrm,
  VPMINUWrr,
  VPMOVB2MZ128kr,
  VPMOVB2MZ256kr,
  VPMOVB2MZkr,
  VPMOVD2MZ128kr,
  VPMOVD2MZ256kr,
  VPMOVD2MZkr,
  VPMOVDBZ128mr,
  VPMOVDBZ128mrk,
  VPMOVDBZ128rr,
  VPMOVDBZ128rrk,
  VPMOVDBZ128rrkz,
  VPMOVDBZ256mr,
  VPMOVDBZ256mrk,
  VPMOVDBZ256rr,
  VPMOVDBZ256rrk,
  VPMOVDBZ256rrkz,
  VPMOVDBZmr,
  VPMOVDBZmrk,
  VPMOVDBZrr,
  VPMOVDBZrrk,
  VPMOVDBZrrkz,
  VPMOVDWZ128mr,
  VPMOVDWZ128mrk,
  VPMOVDWZ128rr,
  VPMOVDWZ128rrk,
  VPMOVDWZ128rrkz,
  VPMOVDWZ256mr,
  VPMOVDWZ256mrk,
  VPMOVDWZ256rr,
  VPMOVDWZ256rrk,
  VPMOVDWZ256rrkz,
  VPMOVDWZmr,
  VPMOVDWZmrk,
  VPMOVDWZrr,
  VPMOVDWZrrk,
  VPMOVDWZrrkz,
  VPMOVM2BZ128rk,
  VPMOVM2BZ256rk,
  VPMOVM2BZrk,
  VPMOVM2DZ128rk,
  VPMOVM2DZ256rk,
  VPMOVM2DZrk,
  VPMOVM2QZ128rk,
  VPMOVM2QZ256rk,
  VPMOVM2QZrk,
  VPMOVM2WZ128rk,
  VPMOVM2WZ256rk,
  VPMOVM2WZrk,
  VPMOVMSKBYrr,
  VPMOVMSKBrr,
  VPMOVQ2MZ128kr,
  VPMOVQ2MZ256kr,
  VPMOVQ2MZkr,
  VPMOVQBZ128mr,
  VPMOVQBZ128mrk,
  VPMOVQBZ128rr,
  VPMOVQBZ128rrk,
  VPMOVQBZ128rrkz,
  VPMOVQBZ256mr,
  VPMOVQBZ256mrk,
  VPMOVQBZ256rr,
  VPMOVQBZ256rrk,
  VPMOVQBZ256rrkz,
  VPMOVQBZmr,
  VPMOVQBZmrk,
  VPMOVQBZrr,
  VPMOVQBZrrk,
  VPMOVQBZrrkz,
  VPMOVQDZ128mr,
  VPMOVQDZ128mrk,
  VPMOVQDZ128rr,
  VPMOVQDZ128rrk,
  VPMOVQDZ128rrkz,
  VPMOVQDZ256mr,
  VPMOVQDZ256mrk,
  VPMOVQDZ256rr,
  VPMOVQDZ256rrk,
  VPMOVQDZ256rrkz,
  VPMOVQDZmr,
  VPMOVQDZmrk,
  VPMOVQDZrr,
  VPMOVQDZrrk,
  VPMOVQDZrrkz,
  VPMOVQWZ128mr,
  VPMOVQWZ128mrk,
  VPMOVQWZ128rr,
  VPMOVQWZ128rrk,
  VPMOVQWZ128rrkz,
  VPMOVQWZ256mr,
  VPMOVQWZ256mrk,
  VPMOVQWZ256rr,
  VPMOVQWZ256rrk,
  VPMOVQWZ256rrkz,
  VPMOVQWZmr,
  VPMOVQWZmrk,
  VPMOVQWZrr,
  VPMOVQWZrrk,
  VPMOVQWZrrkz,
  VPMOVSDBZ128mr,
  VPMOVSDBZ128mrk,
  VPMOVSDBZ128rr,
  VPMOVSDBZ128rrk,
  VPMOVSDBZ128rrkz,
  VPMOVSDBZ256mr,
  VPMOVSDBZ256mrk,
  VPMOVSDBZ256rr,
  VPMOVSDBZ256rrk,
  VPMOVSDBZ256rrkz,
  VPMOVSDBZmr,
  VPMOVSDBZmrk,
  VPMOVSDBZrr,
  VPMOVSDBZrrk,
  VPMOVSDBZrrkz,
  VPMOVSDWZ128mr,
  VPMOVSDWZ128mrk,
  VPMOVSDWZ128rr,
  VPMOVSDWZ128rrk,
  VPMOVSDWZ128rrkz,
  VPMOVSDWZ256mr,
  VPMOVSDWZ256mrk,
  VPMOVSDWZ256rr,
  VPMOVSDWZ256rrk,
  VPMOVSDWZ256rrkz,
  VPMOVSDWZmr,
  VPMOVSDWZmrk,
  VPMOVSDWZrr,
  VPMOVSDWZrrk,
  VPMOVSDWZrrkz,
  VPMOVSQBZ128mr,
  VPMOVSQBZ128mrk,
  VPMOVSQBZ128rr,
  VPMOVSQBZ128rrk,
  VPMOVSQBZ128rrkz,
  VPMOVSQBZ256mr,
  VPMOVSQBZ256mrk,
  VPMOVSQBZ256rr,
  VPMOVSQBZ256rrk,
  VPMOVSQBZ256rrkz,
  VPMOVSQBZmr,
  VPMOVSQBZmrk,
  VPMOVSQBZrr,
  VPMOVSQBZrrk,
  VPMOVSQBZrrkz,
  VPMOVSQDZ128mr,
  VPMOVSQDZ128mrk,
  VPMOVSQDZ128rr,
  VPMOVSQDZ128rrk,
  VPMOVSQDZ128rrkz,
  VPMOVSQDZ256mr,
  VPMOVSQDZ256mrk,
  VPMOVSQDZ256rr,
  VPMOVSQDZ256rrk,
  VPMOVSQDZ256rrkz,
  VPMOVSQDZmr,
  VPMOVSQDZmrk,
  VPMOVSQDZrr,
  VPMOVSQDZrrk,
  VPMOVSQDZrrkz,
  VPMOVSQWZ128mr,
  VPMOVSQWZ128mrk,
  VPMOVSQWZ128rr,
  VPMOVSQWZ128rrk,
  VPMOVSQWZ128rrkz,
  VPMOVSQWZ256mr,
  VPMOVSQWZ256mrk,
  VPMOVSQWZ256rr,
  VPMOVSQWZ256rrk,
  VPMOVSQWZ256rrkz,
  VPMOVSQWZmr,
  VPMOVSQWZmrk,
  VPMOVSQWZrr,
  VPMOVSQWZrrk,
  VPMOVSQWZrrkz,
  VPMOVSWBZ128mr,
  VPMOVSWBZ128mrk,
  VPMOVSWBZ128rr,
  VPMOVSWBZ128rrk,
  VPMOVSWBZ128rrkz,
  VPMOVSWBZ256mr,
  VPMOVSWBZ256mrk,
  VPMOVSWBZ256rr,
  VPMOVSWBZ256rrk,
  VPMOVSWBZ256rrkz,
  VPMOVSWBZmr,
  VPMOVSWBZmrk,
  VPMOVSWBZrr,
  VPMOVSWBZrrk,
  VPMOVSWBZrrkz,
  VPMOVSXBDYrm,
  VPMOVSXBDYrr,
  VPMOVSXBDZ128rm,
  VPMOVSXBDZ128rmk,
  VPMOVSXBDZ128rmkz,
  VPMOVSXBDZ128rr,
  VPMOVSXBDZ128rrk,
  VPMOVSXBDZ128rrkz,
  VPMOVSXBDZ256rm,
  VPMOVSXBDZ256rmk,
  VPMOVSXBDZ256rmkz,
  VPMOVSXBDZ256rr,
  VPMOVSXBDZ256rrk,
  VPMOVSXBDZ256rrkz,
  VPMOVSXBDZrm,
  VPMOVSXBDZrmk,
  VPMOVSXBDZrmkz,
  VPMOVSXBDZrr,
  VPMOVSXBDZrrk,
  VPMOVSXBDZrrkz,
  VPMOVSXBDrm,
  VPMOVSXBDrr,
  VPMOVSXBQYrm,
  VPMOVSXBQYrr,
  VPMOVSXBQZ128rm,
  VPMOVSXBQZ128rmk,
  VPMOVSXBQZ128rmkz,
  VPMOVSXBQZ128rr,
  VPMOVSXBQZ128rrk,
  VPMOVSXBQZ128rrkz,
  VPMOVSXBQZ256rm,
  VPMOVSXBQZ256rmk,
  VPMOVSXBQZ256rmkz,
  VPMOVSXBQZ256rr,
  VPMOVSXBQZ256rrk,
  VPMOVSXBQZ256rrkz,
  VPMOVSXBQZrm,
  VPMOVSXBQZrmk,
  VPMOVSXBQZrmkz,
  VPMOVSXBQZrr,
  VPMOVSXBQZrrk,
  VPMOVSXBQZrrkz,
  VPMOVSXBQrm,
  VPMOVSXBQrr,
  VPMOVSXBWYrm,
  VPMOVSXBWYrr,
  VPMOVSXBWZ128rm,
  VPMOVSXBWZ128rmk,
  VPMOVSXBWZ128rmkz,
  VPMOVSXBWZ128rr,
  VPMOVSXBWZ128rrk,
  VPMOVSXBWZ128rrkz,
  VPMOVSXBWZ256rm,
  VPMOVSXBWZ256rmk,
  VPMOVSXBWZ256rmkz,
  VPMOVSXBWZ256rr,
  VPMOVSXBWZ256rrk,
  VPMOVSXBWZ256rrkz,
  VPMOVSXBWZrm,
  VPMOVSXBWZrmk,
  VPMOVSXBWZrmkz,
  VPMOVSXBWZrr,
  VPMOVSXBWZrrk,
  VPMOVSXBWZrrkz,
  VPMOVSXBWrm,
  VPMOVSXBWrr,
  VPMOVSXDQYrm,
  VPMOVSXDQYrr,
  VPMOVSXDQZ128rm,
  VPMOVSXDQZ128rmk,
  VPMOVSXDQZ128rmkz,
  VPMOVSXDQZ128rr,
  VPMOVSXDQZ128rrk,
  VPMOVSXDQZ128rrkz,
  VPMOVSXDQZ256rm,
  VPMOVSXDQZ256rmk,
  VPMOVSXDQZ256rmkz,
  VPMOVSXDQZ256rr,
  VPMOVSXDQZ256rrk,
  VPMOVSXDQZ256rrkz,
  VPMOVSXDQZrm,
  VPMOVSXDQZrmk,
  VPMOVSXDQZrmkz,
  VPMOVSXDQZrr,
  VPMOVSXDQZrrk,
  VPMOVSXDQZrrkz,
  VPMOVSXDQrm,
  VPMOVSXDQrr,
  VPMOVSXWDYrm,
  VPMOVSXWDYrr,
  VPMOVSXWDZ128rm,
  VPMOVSXWDZ128rmk,
  VPMOVSXWDZ128rmkz,
  VPMOVSXWDZ128rr,
  VPMOVSXWDZ128rrk,
  VPMOVSXWDZ128rrkz,
  VPMOVSXWDZ256rm,
  VPMOVSXWDZ256rmk,
  VPMOVSXWDZ256rmkz,
  VPMOVSXWDZ256rr,
  VPMOVSXWDZ256rrk,
  VPMOVSXWDZ256rrkz,
  VPMOVSXWDZrm,
  VPMOVSXWDZrmk,
  VPMOVSXWDZrmkz,
  VPMOVSXWDZrr,
  VPMOVSXWDZrrk,
  VPMOVSXWDZrrkz,
  VPMOVSXWDrm,
  VPMOVSXWDrr,
  VPMOVSXWQYrm,
  VPMOVSXWQYrr,
  VPMOVSXWQZ128rm,
  VPMOVSXWQZ128rmk,
  VPMOVSXWQZ128rmkz,
  VPMOVSXWQZ128rr,
  VPMOVSXWQZ128rrk,
  VPMOVSXWQZ128rrkz,
  VPMOVSXWQZ256rm,
  VPMOVSXWQZ256rmk,
  VPMOVSXWQZ256rmkz,
  VPMOVSXWQZ256rr,
  VPMOVSXWQZ256rrk,
  VPMOVSXWQZ256rrkz,
  VPMOVSXWQZrm,
  VPMOVSXWQZrmk,
  VPMOVSXWQZrmkz,
  VPMOVSXWQZrr,
  VPMOVSXWQZrrk,
  VPMOVSXWQZrrkz,
  VPMOVSXWQrm,
  VPMOVSXWQrr,
  VPMOVUSDBZ128mr,
  VPMOVUSDBZ128mrk,
  VPMOVUSDBZ128rr,
  VPMOVUSDBZ128rrk,
  VPMOVUSDBZ128rrkz,
  VPMOVUSDBZ256mr,
  VPMOVUSDBZ256mrk,
  VPMOVUSDBZ256rr,
  VPMOVUSDBZ256rrk,
  VPMOVUSDBZ256rrkz,
  VPMOVUSDBZmr,
  VPMOVUSDBZmrk,
  VPMOVUSDBZrr,
  VPMOVUSDBZrrk,
  VPMOVUSDBZrrkz,
  VPMOVUSDWZ128mr,
  VPMOVUSDWZ128mrk,
  VPMOVUSDWZ128rr,
  VPMOVUSDWZ128rrk,
  VPMOVUSDWZ128rrkz,
  VPMOVUSDWZ256mr,
  VPMOVUSDWZ256mrk,
  VPMOVUSDWZ256rr,
  VPMOVUSDWZ256rrk,
  VPMOVUSDWZ256rrkz,
  VPMOVUSDWZmr,
  VPMOVUSDWZmrk,
  VPMOVUSDWZrr,
  VPMOVUSDWZrrk,
  VPMOVUSDWZrrkz,
  VPMOVUSQBZ128mr,
  VPMOVUSQBZ128mrk,
  VPMOVUSQBZ128rr,
  VPMOVUSQBZ128rrk,
  VPMOVUSQBZ128rrkz,
  VPMOVUSQBZ256mr,
  VPMOVUSQBZ256mrk,
  VPMOVUSQBZ256rr,
  VPMOVUSQBZ256rrk,
  VPMOVUSQBZ256rrkz,
  VPMOVUSQBZmr,
  VPMOVUSQBZmrk,
  VPMOVUSQBZrr,
  VPMOVUSQBZrrk,
  VPMOVUSQBZrrkz,
  VPMOVUSQDZ128mr,
  VPMOVUSQDZ128mrk,
  VPMOVUSQDZ128rr,
  VPMOVUSQDZ128rrk,
  VPMOVUSQDZ128rrkz,
  VPMOVUSQDZ256mr,
  VPMOVUSQDZ256mrk,
  VPMOVUSQDZ256rr,
  VPMOVUSQDZ256rrk,
  VPMOVUSQDZ256rrkz,
  VPMOVUSQDZmr,
  VPMOVUSQDZmrk,
  VPMOVUSQDZrr,
  VPMOVUSQDZrrk,
  VPMOVUSQDZrrkz,
  VPMOVUSQWZ128mr,
  VPMOVUSQWZ128mrk,
  VPMOVUSQWZ128rr,
  VPMOVUSQWZ128rrk,
  VPMOVUSQWZ128rrkz,
  VPMOVUSQWZ256mr,
  VPMOVUSQWZ256mrk,
  VPMOVUSQWZ256rr,
  VPMOVUSQWZ256rrk,
  VPMOVUSQWZ256rrkz,
  VPMOVUSQWZmr,
  VPMOVUSQWZmrk,
  VPMOVUSQWZrr,
  VPMOVUSQWZrrk,
  VPMOVUSQWZrrkz,
  VPMOVUSWBZ128mr,
  VPMOVUSWBZ128mrk,
  VPMOVUSWBZ128rr,
  VPMOVUSWBZ128rrk,
  VPMOVUSWBZ128rrkz,
  VPMOVUSWBZ256mr,
  VPMOVUSWBZ256mrk,
  VPMOVUSWBZ256rr,
  VPMOVUSWBZ256rrk,
  VPMOVUSWBZ256rrkz,
  VPMOVUSWBZmr,
  VPMOVUSWBZmrk,
  VPMOVUSWBZrr,
  VPMOVUSWBZrrk,
  VPMOVUSWBZrrkz,
  VPMOVW2MZ128kr,
  VPMOVW2MZ256kr,
  VPMOVW2MZkr,
  VPMOVWBZ128mr,
  VPMOVWBZ128mrk,
  VPMOVWBZ128rr,
  VPMOVWBZ128rrk,
  VPMOVWBZ128rrkz,
  VPMOVWBZ256mr,
  VPMOVWBZ256mrk,
  VPMOVWBZ256rr,
  VPMOVWBZ256rrk,
  VPMOVWBZ256rrkz,
  VPMOVWBZmr,
  VPMOVWBZmrk,
  VPMOVWBZrr,
  VPMOVWBZrrk,
  VPMOVWBZrrkz,
  VPMOVZXBDYrm,
  VPMOVZXBDYrr,
  VPMOVZXBDZ128rm,
  VPMOVZXBDZ128rmk,
  VPMOVZXBDZ128rmkz,
  VPMOVZXBDZ128rr,
  VPMOVZXBDZ128rrk,
  VPMOVZXBDZ128rrkz,
  VPMOVZXBDZ256rm,
  VPMOVZXBDZ256rmk,
  VPMOVZXBDZ256rmkz,
  VPMOVZXBDZ256rr,
  VPMOVZXBDZ256rrk,
  VPMOVZXBDZ256rrkz,
  VPMOVZXBDZrm,
  VPMOVZXBDZrmk,
  VPMOVZXBDZrmkz,
  VPMOVZXBDZrr,
  VPMOVZXBDZrrk,
  VPMOVZXBDZrrkz,
  VPMOVZXBDrm,
  VPMOVZXBDrr,
  VPMOVZXBQYrm,
  VPMOVZXBQYrr,
  VPMOVZXBQZ128rm,
  VPMOVZXBQZ128rmk,
  VPMOVZXBQZ128rmkz,
  VPMOVZXBQZ128rr,
  VPMOVZXBQZ128rrk,
  VPMOVZXBQZ128rrkz,
  VPMOVZXBQZ256rm,
  VPMOVZXBQZ256rmk,
  VPMOVZXBQZ256rmkz,
  VPMOVZXBQZ256rr,
  VPMOVZXBQZ256rrk,
  VPMOVZXBQZ256rrkz,
  VPMOVZXBQZrm,
  VPMOVZXBQZrmk,
  VPMOVZXBQZrmkz,
  VPMOVZXBQZrr,
  VPMOVZXBQZrrk,
  VPMOVZXBQZrrkz,
  VPMOVZXBQrm,
  VPMOVZXBQrr,
  VPMOVZXBWYrm,
  VPMOVZXBWYrr,
  VPMOVZXBWZ128rm,
  VPMOVZXBWZ128rmk,
  VPMOVZXBWZ128rmkz,
  VPMOVZXBWZ128rr,
  VPMOVZXBWZ128rrk,
  VPMOVZXBWZ128rrkz,
  VPMOVZXBWZ256rm,
  VPMOVZXBWZ256rmk,
  VPMOVZXBWZ256rmkz,
  VPMOVZXBWZ256rr,
  VPMOVZXBWZ256rrk,
  VPMOVZXBWZ256rrkz,
  VPMOVZXBWZrm,
  VPMOVZXBWZrmk,
  VPMOVZXBWZrmkz,
  VPMOVZXBWZrr,
  VPMOVZXBWZrrk,
  VPMOVZXBWZrrkz,
  VPMOVZXBWrm,
  VPMOVZXBWrr,
  VPMOVZXDQYrm,
  VPMOVZXDQYrr,
  VPMOVZXDQZ128rm,
  VPMOVZXDQZ128rmk,
  VPMOVZXDQZ128rmkz,
  VPMOVZXDQZ128rr,
  VPMOVZXDQZ128rrk,
  VPMOVZXDQZ128rrkz,
  VPMOVZXDQZ256rm,
  VPMOVZXDQZ256rmk,
  VPMOVZXDQZ256rmkz,
  VPMOVZXDQZ256rr,
  VPMOVZXDQZ256rrk,
  VPMOVZXDQZ256rrkz,
  VPMOVZXDQZrm,
  VPMOVZXDQZrmk,
  VPMOVZXDQZrmkz,
  VPMOVZXDQZrr,
  VPMOVZXDQZrrk,
  VPMOVZXDQZrrkz,
  VPMOVZXDQrm,
  VPMOVZXDQrr,
  VPMOVZXWDYrm,
  VPMOVZXWDYrr,
  VPMOVZXWDZ128rm,
  VPMOVZXWDZ128rmk,
  VPMOVZXWDZ128rmkz,
  VPMOVZXWDZ128rr,
  VPMOVZXWDZ128rrk,
  VPMOVZXWDZ128rrkz,
  VPMOVZXWDZ256rm,
  VPMOVZXWDZ256rmk,
  VPMOVZXWDZ256rmkz,
  VPMOVZXWDZ256rr,
  VPMOVZXWDZ256rrk,
  VPMOVZXWDZ256rrkz,
  VPMOVZXWDZrm,
  VPMOVZXWDZrmk,
  VPMOVZXWDZrmkz,
  VPMOVZXWDZrr,
  VPMOVZXWDZrrk,
  VPMOVZXWDZrrkz,
  VPMOVZXWDrm,
  VPMOVZXWDrr,
  VPMOVZXWQYrm,
  VPMOVZXWQYrr,
  VPMOVZXWQZ128rm,
  VPMOVZXWQZ128rmk,
  VPMOVZXWQZ128rmkz,
  VPMOVZXWQZ128rr,
  VPMOVZXWQZ128rrk,
  VPMOVZXWQZ128rrkz,
  VPMOVZXWQZ256rm,
  VPMOVZXWQZ256rmk,
  VPMOVZXWQZ256rmkz,
  VPMOVZXWQZ256rr,
  VPMOVZXWQZ256rrk,
  VPMOVZXWQZ256rrkz,
  VPMOVZXWQZrm,
  VPMOVZXWQZrmk,
  VPMOVZXWQZrmkz,
  VPMOVZXWQZrr,
  VPMOVZXWQZrrk,
  VPMOVZXWQZrrkz,
  VPMOVZXWQrm,
  VPMOVZXWQrr,
  VPMULDQYrm,
  VPMULDQYrr,
  VPMULDQZ128rm,
  VPMULDQZ128rmb,
  VPMULDQZ128rmbk,
  VPMULDQZ128rmbkz,
  VPMULDQZ128rmk,
  VPMULDQZ128rmkz,
  VPMULDQZ128rr,
  VPMULDQZ128rrk,
  VPMULDQZ128rrkz,
  VPMULDQZ256rm,
  VPMULDQZ256rmb,
  VPMULDQZ256rmbk,
  VPMULDQZ256rmbkz,
  VPMULDQZ256rmk,
  VPMULDQZ256rmkz,
  VPMULDQZ256rr,
  VPMULDQZ256rrk,
  VPMULDQZ256rrkz,
  VPMULDQZrm,
  VPMULDQZrmb,
  VPMULDQZrmbk,
  VPMULDQZrmbkz,
  VPMULDQZrmk,
  VPMULDQZrmkz,
  VPMULDQZrr,
  VPMULDQZrrk,
  VPMULDQZrrkz,
  VPMULDQrm,
  VPMULDQrr,
  VPMULHRSWYrm,
  VPMULHRSWYrr,
  VPMULHRSWZ128rm,
  VPMULHRSWZ128rmk,
  VPMULHRSWZ128rmkz,
  VPMULHRSWZ128rr,
  VPMULHRSWZ128rrk,
  VPMULHRSWZ128rrkz,
  VPMULHRSWZ256rm,
  VPMULHRSWZ256rmk,
  VPMULHRSWZ256rmkz,
  VPMULHRSWZ256rr,
  VPMULHRSWZ256rrk,
  VPMULHRSWZ256rrkz,
  VPMULHRSWZrm,
  VPMULHRSWZrmk,
  VPMULHRSWZrmkz,
  VPMULHRSWZrr,
  VPMULHRSWZrrk,
  VPMULHRSWZrrkz,
  VPMULHRSWrm,
  VPMULHRSWrr,
  VPMULHUWYrm,
  VPMULHUWYrr,
  VPMULHUWZ128rm,
  VPMULHUWZ128rmk,
  VPMULHUWZ128rmkz,
  VPMULHUWZ128rr,
  VPMULHUWZ128rrk,
  VPMULHUWZ128rrkz,
  VPMULHUWZ256rm,
  VPMULHUWZ256rmk,
  VPMULHUWZ256rmkz,
  VPMULHUWZ256rr,
  VPMULHUWZ256rrk,
  VPMULHUWZ256rrkz,
  VPMULHUWZrm,
  VPMULHUWZrmk,
  VPMULHUWZrmkz,
  VPMULHUWZrr,
  VPMULHUWZrrk,
  VPMULHUWZrrkz,
  VPMULHUWrm,
  VPMULHUWrr,
  VPMULHWYrm,
  VPMULHWYrr,
  VPMULHWZ128rm,
  VPMULHWZ128rmk,
  VPMULHWZ128rmkz,
  VPMULHWZ128rr,
  VPMULHWZ128rrk,
  VPMULHWZ128rrkz,
  VPMULHWZ256rm,
  VPMULHWZ256rmk,
  VPMULHWZ256rmkz,
  VPMULHWZ256rr,
  VPMULHWZ256rrk,
  VPMULHWZ256rrkz,
  VPMULHWZrm,
  VPMULHWZrmk,
  VPMULHWZrmkz,
  VPMULHWZrr,
  VPMULHWZrrk,
  VPMULHWZrrkz,
  VPMULHWrm,
  VPMULHWrr,
  VPMULLDYrm,
  VPMULLDYrr,
  VPMULLDZ128rm,
  VPMULLDZ128rmb,
  VPMULLDZ128rmbk,
  VPMULLDZ128rmbkz,
  VPMULLDZ128rmk,
  VPMULLDZ128rmkz,
  VPMULLDZ128rr,
  VPMULLDZ128rrk,
  VPMULLDZ128rrkz,
  VPMULLDZ256rm,
  VPMULLDZ256rmb,
  VPMULLDZ256rmbk,
  VPMULLDZ256rmbkz,
  VPMULLDZ256rmk,
  VPMULLDZ256rmkz,
  VPMULLDZ256rr,
  VPMULLDZ256rrk,
  VPMULLDZ256rrkz,
  VPMULLDZrm,
  VPMULLDZrmb,
  VPMULLDZrmbk,
  VPMULLDZrmbkz,
  VPMULLDZrmk,
  VPMULLDZrmkz,
  VPMULLDZrr,
  VPMULLDZrrk,
  VPMULLDZrrkz,
  VPMULLDrm,
  VPMULLDrr,
  VPMULLQZ128rm,
  VPMULLQZ128rmb,
  VPMULLQZ128rmbk,
  VPMULLQZ128rmbkz,
  VPMULLQZ128rmk,
  VPMULLQZ128rmkz,
  VPMULLQZ128rr,
  VPMULLQZ128rrk,
  VPMULLQZ128rrkz,
  VPMULLQZ256rm,
  VPMULLQZ256rmb,
  VPMULLQZ256rmbk,
  VPMULLQZ256rmbkz,
  VPMULLQZ256rmk,
  VPMULLQZ256rmkz,
  VPMULLQZ256rr,
  VPMULLQZ256rrk,
  VPMULLQZ256rrkz,
  VPMULLQZrm,
  VPMULLQZrmb,
  VPMULLQZrmbk,
  VPMULLQZrmbkz,
  VPMULLQZrmk,
  VPMULLQZrmkz,
  VPMULLQZrr,
  VPMULLQZrrk,
  VPMULLQZrrkz,
  VPMULLWYrm,
  VPMULLWYrr,
  VPMULLWZ128rm,
  VPMULLWZ128rmk,
  VPMULLWZ128rmkz,
  VPMULLWZ128rr,
  VPMULLWZ128rrk,
  VPMULLWZ128rrkz,
  VPMULLWZ256rm,
  VPMULLWZ256rmk,
  VPMULLWZ256rmkz,
  VPMULLWZ256rr,
  VPMULLWZ256rrk,
  VPMULLWZ256rrkz,
  VPMULLWZrm,
  VPMULLWZrmk,
  VPMULLWZrmkz,
  VPMULLWZrr,
  VPMULLWZrrk,
  VPMULLWZrrkz,
  VPMULLWrm,
  VPMULLWrr,
  VPMULTISHIFTQBZ128rm,
  VPMULTISHIFTQBZ128rmb,
  VPMULTISHIFTQBZ128rmbk,
  VPMULTISHIFTQBZ128rmbkz,
  VPMULTISHIFTQBZ128rmk,
  VPMULTISHIFTQBZ128rmkz,
  VPMULTISHIFTQBZ128rr,
  VPMULTISHIFTQBZ128rrk,
  VPMULTISHIFTQBZ128rrkz,
  VPMULTISHIFTQBZ256rm,
  VPMULTISHIFTQBZ256rmb,
  VPMULTISHIFTQBZ256rmbk,
  VPMULTISHIFTQBZ256rmbkz,
  VPMULTISHIFTQBZ256rmk,
  VPMULTISHIFTQBZ256rmkz,
  VPMULTISHIFTQBZ256rr,
  VPMULTISHIFTQBZ256rrk,
  VPMULTISHIFTQBZ256rrkz,
  VPMULTISHIFTQBZrm,
  VPMULTISHIFTQBZrmb,
  VPMULTISHIFTQBZrmbk,
  VPMULTISHIFTQBZrmbkz,
  VPMULTISHIFTQBZrmk,
  VPMULTISHIFTQBZrmkz,
  VPMULTISHIFTQBZrr,
  VPMULTISHIFTQBZrrk,
  VPMULTISHIFTQBZrrkz,
  VPMULUDQYrm,
  VPMULUDQYrr,
  VPMULUDQZ128rm,
  VPMULUDQZ128rmb,
  VPMULUDQZ128rmbk,
  VPMULUDQZ128rmbkz,
  VPMULUDQZ128rmk,
  VPMULUDQZ128rmkz,
  VPMULUDQZ128rr,
  VPMULUDQZ128rrk,
  VPMULUDQZ128rrkz,
  VPMULUDQZ256rm,
  VPMULUDQZ256rmb,
  VPMULUDQZ256rmbk,
  VPMULUDQZ256rmbkz,
  VPMULUDQZ256rmk,
  VPMULUDQZ256rmkz,
  VPMULUDQZ256rr,
  VPMULUDQZ256rrk,
  VPMULUDQZ256rrkz,
  VPMULUDQZrm,
  VPMULUDQZrmb,
  VPMULUDQZrmbk,
  VPMULUDQZrmbkz,
  VPMULUDQZrmk,
  VPMULUDQZrmkz,
  VPMULUDQZrr,
  VPMULUDQZrrk,
  VPMULUDQZrrkz,
  VPMULUDQrm,
  VPMULUDQrr,
  VPOPCNTBZ128rm,
  VPOPCNTBZ128rmk,
  VPOPCNTBZ128rmkz,
  VPOPCNTBZ128rr,
  VPOPCNTBZ128rrk,
  VPOPCNTBZ128rrkz,
  VPOPCNTBZ256rm,
  VPOPCNTBZ256rmk,
  VPOPCNTBZ256rmkz,
  VPOPCNTBZ256rr,
  VPOPCNTBZ256rrk,
  VPOPCNTBZ256rrkz,
  VPOPCNTBZrm,
  VPOPCNTBZrmk,
  VPOPCNTBZrmkz,
  VPOPCNTBZrr,
  VPOPCNTBZrrk,
  VPOPCNTBZrrkz,
  VPOPCNTDZ128rm,
  VPOPCNTDZ128rmb,
  VPOPCNTDZ128rmbk,
  VPOPCNTDZ128rmbkz,
  VPOPCNTDZ128rmk,
  VPOPCNTDZ128rmkz,
  VPOPCNTDZ128rr,
  VPOPCNTDZ128rrk,
  VPOPCNTDZ128rrkz,
  VPOPCNTDZ256rm,
  VPOPCNTDZ256rmb,
  VPOPCNTDZ256rmbk,
  VPOPCNTDZ256rmbkz,
  VPOPCNTDZ256rmk,
  VPOPCNTDZ256rmkz,
  VPOPCNTDZ256rr,
  VPOPCNTDZ256rrk,
  VPOPCNTDZ256rrkz,
  VPOPCNTDZrm,
  VPOPCNTDZrmb,
  VPOPCNTDZrmbk,
  VPOPCNTDZrmbkz,
  VPOPCNTDZrmk,
  VPOPCNTDZrmkz,
  VPOPCNTDZrr,
  VPOPCNTDZrrk,
  VPOPCNTDZrrkz,
  VPOPCNTQZ128rm,
  VPOPCNTQZ128rmb,
  VPOPCNTQZ128rmbk,
  VPOPCNTQZ128rmbkz,
  VPOPCNTQZ128rmk,
  VPOPCNTQZ128rmkz,
  VPOPCNTQZ128rr,
  VPOPCNTQZ128rrk,
  VPOPCNTQZ128rrkz,
  VPOPCNTQZ256rm,
  VPOPCNTQZ256rmb,
  VPOPCNTQZ256rmbk,
  VPOPCNTQZ256rmbkz,
  VPOPCNTQZ256rmk,
  VPOPCNTQZ256rmkz,
  VPOPCNTQZ256rr,
  VPOPCNTQZ256rrk,
  VPOPCNTQZ256rrkz,
  VPOPCNTQZrm,
  VPOPCNTQZrmb,
  VPOPCNTQZrmbk,
  VPOPCNTQZrmbkz,
  VPOPCNTQZrmk,
  VPOPCNTQZrmkz,
  VPOPCNTQZrr,
  VPOPCNTQZrrk,
  VPOPCNTQZrrkz,
  VPOPCNTWZ128rm,
  VPOPCNTWZ128rmk,
  VPOPCNTWZ128rmkz,
  VPOPCNTWZ128rr,
  VPOPCNTWZ128rrk,
  VPOPCNTWZ128rrkz,
  VPOPCNTWZ256rm,
  VPOPCNTWZ256rmk,
  VPOPCNTWZ256rmkz,
  VPOPCNTWZ256rr,
  VPOPCNTWZ256rrk,
  VPOPCNTWZ256rrkz,
  VPOPCNTWZrm,
  VPOPCNTWZrmk,
  VPOPCNTWZrmkz,
  VPOPCNTWZrr,
  VPOPCNTWZrrk,
  VPOPCNTWZrrkz,
  VPORDZ128rm,
  VPORDZ128rmb,
  VPORDZ128rmbk,
  VPORDZ128rmbkz,
  VPORDZ128rmk,
  VPORDZ128rmkz,
  VPORDZ128rr,
  VPORDZ128rrk,
  VPORDZ128rrkz,
  VPORDZ256rm,
  VPORDZ256rmb,
  VPORDZ256rmbk,
  VPORDZ256rmbkz,
  VPORDZ256rmk,
  VPORDZ256rmkz,
  VPORDZ256rr,
  VPORDZ256rrk,
  VPORDZ256rrkz,
  VPORDZrm,
  VPORDZrmb,
  VPORDZrmbk,
  VPORDZrmbkz,
  VPORDZrmk,
  VPORDZrmkz,
  VPORDZrr,
  VPORDZrrk,
  VPORDZrrkz,
  VPORQZ128rm,
  VPORQZ128rmb,
  VPORQZ128rmbk,
  VPORQZ128rmbkz,
  VPORQZ128rmk,
  VPORQZ128rmkz,
  VPORQZ128rr,
  VPORQZ128rrk,
  VPORQZ128rrkz,
  VPORQZ256rm,
  VPORQZ256rmb,
  VPORQZ256rmbk,
  VPORQZ256rmbkz,
  VPORQZ256rmk,
  VPORQZ256rmkz,
  VPORQZ256rr,
  VPORQZ256rrk,
  VPORQZ256rrkz,
  VPORQZrm,
  VPORQZrmb,
  VPORQZrmbk,
  VPORQZrmbkz,
  VPORQZrmk,
  VPORQZrmkz,
  VPORQZrr,
  VPORQZrrk,
  VPORQZrrkz,
  VPORYrm,
  VPORYrr,
  VPORrm,
  VPORrr,
  VPPERMrmr,
  VPPERMrrm,
  VPPERMrrr,
  VPPERMrrr_REV,
  VPROLDZ128mbi,
  VPROLDZ128mbik,
  VPROLDZ128mbikz,
  VPROLDZ128mi,
  VPROLDZ128mik,
  VPROLDZ128mikz,
  VPROLDZ128ri,
  VPROLDZ128rik,
  VPROLDZ128rikz,
  VPROLDZ256mbi,
  VPROLDZ256mbik,
  VPROLDZ256mbikz,
  VPROLDZ256mi,
  VPROLDZ256mik,
  VPROLDZ256mikz,
  VPROLDZ256ri,
  VPROLDZ256rik,
  VPROLDZ256rikz,
  VPROLDZmbi,
  VPROLDZmbik,
  VPROLDZmbikz,
  VPROLDZmi,
  VPROLDZmik,
  VPROLDZmikz,
  VPROLDZri,
  VPROLDZrik,
  VPROLDZrikz,
  VPROLQZ128mbi,
  VPROLQZ128mbik,
  VPROLQZ128mbikz,
  VPROLQZ128mi,
  VPROLQZ128mik,
  VPROLQZ128mikz,
  VPROLQZ128ri,
  VPROLQZ128rik,
  VPROLQZ128rikz,
  VPROLQZ256mbi,
  VPROLQZ256mbik,
  VPROLQZ256mbikz,
  VPROLQZ256mi,
  VPROLQZ256mik,
  VPROLQZ256mikz,
  VPROLQZ256ri,
  VPROLQZ256rik,
  VPROLQZ256rikz,
  VPROLQZmbi,
  VPROLQZmbik,
  VPROLQZmbikz,
  VPROLQZmi,
  VPROLQZmik,
  VPROLQZmikz,
  VPROLQZri,
  VPROLQZrik,
  VPROLQZrikz,
  VPROLVDZ128rm,
  VPROLVDZ128rmb,
  VPROLVDZ128rmbk,
  VPROLVDZ128rmbkz,
  VPROLVDZ128rmk,
  VPROLVDZ128rmkz,
  VPROLVDZ128rr,
  VPROLVDZ128rrk,
  VPROLVDZ128rrkz,
  VPROLVDZ256rm,
  VPROLVDZ256rmb,
  VPROLVDZ256rmbk,
  VPROLVDZ256rmbkz,
  VPROLVDZ256rmk,
  VPROLVDZ256rmkz,
  VPROLVDZ256rr,
  VPROLVDZ256rrk,
  VPROLVDZ256rrkz,
  VPROLVDZrm,
  VPROLVDZrmb,
  VPROLVDZrmbk,
  VPROLVDZrmbkz,
  VPROLVDZrmk,
  VPROLVDZrmkz,
  VPROLVDZrr,
  VPROLVDZrrk,
  VPROLVDZrrkz,
  VPROLVQZ128rm,
  VPROLVQZ128rmb,
  VPROLVQZ128rmbk,
  VPROLVQZ128rmbkz,
  VPROLVQZ128rmk,
  VPROLVQZ128rmkz,
  VPROLVQZ128rr,
  VPROLVQZ128rrk,
  VPROLVQZ128rrkz,
  VPROLVQZ256rm,
  VPROLVQZ256rmb,
  VPROLVQZ256rmbk,
  VPROLVQZ256rmbkz,
  VPROLVQZ256rmk,
  VPROLVQZ256rmkz,
  VPROLVQZ256rr,
  VPROLVQZ256rrk,
  VPROLVQZ256rrkz,
  VPROLVQZrm,
  VPROLVQZrmb,
  VPROLVQZrmbk,
  VPROLVQZrmbkz,
  VPROLVQZrmk,
  VPROLVQZrmkz,
  VPROLVQZrr,
  VPROLVQZrrk,
  VPROLVQZrrkz,
  VPRORDZ128mbi,
  VPRORDZ128mbik,
  VPRORDZ128mbikz,
  VPRORDZ128mi,
  VPRORDZ128mik,
  VPRORDZ128mikz,
  VPRORDZ128ri,
  VPRORDZ128rik,
  VPRORDZ128rikz,
  VPRORDZ256mbi,
  VPRORDZ256mbik,
  VPRORDZ256mbikz,
  VPRORDZ256mi,
  VPRORDZ256mik,
  VPRORDZ256mikz,
  VPRORDZ256ri,
  VPRORDZ256rik,
  VPRORDZ256rikz,
  VPRORDZmbi,
  VPRORDZmbik,
  VPRORDZmbikz,
  VPRORDZmi,
  VPRORDZmik,
  VPRORDZmikz,
  VPRORDZri,
  VPRORDZrik,
  VPRORDZrikz,
  VPRORQZ128mbi,
  VPRORQZ128mbik,
  VPRORQZ128mbikz,
  VPRORQZ128mi,
  VPRORQZ128mik,
  VPRORQZ128mikz,
  VPRORQZ128ri,
  VPRORQZ128rik,
  VPRORQZ128rikz,
  VPRORQZ256mbi,
  VPRORQZ256mbik,
  VPRORQZ256mbikz,
  VPRORQZ256mi,
  VPRORQZ256mik,
  VPRORQZ256mikz,
  VPRORQZ256ri,
  VPRORQZ256rik,
  VPRORQZ256rikz,
  VPRORQZmbi,
  VPRORQZmbik,
  VPRORQZmbikz,
  VPRORQZmi,
  VPRORQZmik,
  VPRORQZmikz,
  VPRORQZri,
  VPRORQZrik,
  VPRORQZrikz,
  VPRORVDZ128rm,
  VPRORVDZ128rmb,
  VPRORVDZ128rmbk,
  VPRORVDZ128rmbkz,
  VPRORVDZ128rmk,
  VPRORVDZ128rmkz,
  VPRORVDZ128rr,
  VPRORVDZ128rrk,
  VPRORVDZ128rrkz,
  VPRORVDZ256rm,
  VPRORVDZ256rmb,
  VPRORVDZ256rmbk,
  VPRORVDZ256rmbkz,
  VPRORVDZ256rmk,
  VPRORVDZ256rmkz,
  VPRORVDZ256rr,
  VPRORVDZ256rrk,
  VPRORVDZ256rrkz,
  VPRORVDZrm,
  VPRORVDZrmb,
  VPRORVDZrmbk,
  VPRORVDZrmbkz,
  VPRORVDZrmk,
  VPRORVDZrmkz,
  VPRORVDZrr,
  VPRORVDZrrk,
  VPRORVDZrrkz,
  VPRORVQZ128rm,
  VPRORVQZ128rmb,
  VPRORVQZ128rmbk,
  VPRORVQZ128rmbkz,
  VPRORVQZ128rmk,
  VPRORVQZ128rmkz,
  VPRORVQZ128rr,
  VPRORVQZ128rrk,
  VPRORVQZ128rrkz,
  VPRORVQZ256rm,
  VPRORVQZ256rmb,
  VPRORVQZ256rmbk,
  VPRORVQZ256rmbkz,
  VPRORVQZ256rmk,
  VPRORVQZ256rmkz,
  VPRORVQZ256rr,
  VPRORVQZ256rrk,
  VPRORVQZ256rrkz,
  VPRORVQZrm,
  VPRORVQZrmb,
  VPRORVQZrmbk,
  VPRORVQZrmbkz,
  VPRORVQZrmk,
  VPRORVQZrmkz,
  VPRORVQZrr,
  VPRORVQZrrk,
  VPRORVQZrrkz,
  VPROTBmi,
  VPROTBmr,
  VPROTBri,
  VPROTBrm,
  VPROTBrr,
  VPROTBrr_REV,
  VPROTDmi,
  VPROTDmr,
  VPROTDri,
  VPROTDrm,
  VPROTDrr,
  VPROTDrr_REV,
  VPROTQmi,
  VPROTQmr,
  VPROTQri,
  VPROTQrm,
  VPROTQrr,
  VPROTQrr_REV,
  VPROTWmi,
  VPROTWmr,
  VPROTWri,
  VPROTWrm,
  VPROTWrr,
  VPROTWrr_REV,
  VPSADBWYrm,
  VPSADBWYrr,
  VPSADBWZ128rm,
  VPSADBWZ128rr,
  VPSADBWZ256rm,
  VPSADBWZ256rr,
  VPSADBWZrm,
  VPSADBWZrr,
  VPSADBWrm,
  VPSADBWrr,
  VPSCATTERDDZ128mr,
  VPSCATTERDDZ256mr,
  VPSCATTERDDZmr,
  VPSCATTERDQZ128mr,
  VPSCATTERDQZ256mr,
  VPSCATTERDQZmr,
  VPSCATTERQDZ128mr,
  VPSCATTERQDZ256mr,
  VPSCATTERQDZmr,
  VPSCATTERQQZ128mr,
  VPSCATTERQQZ256mr,
  VPSCATTERQQZmr,
  VPSHABmr,
  VPSHABrm,
  VPSHABrr,
  VPSHABrr_REV,
  VPSHADmr,
  VPSHADrm,
  VPSHADrr,
  VPSHADrr_REV,
  VPSHAQmr,
  VPSHAQrm,
  VPSHAQrr,
  VPSHAQrr_REV,
  VPSHAWmr,
  VPSHAWrm,
  VPSHAWrr,
  VPSHAWrr_REV,
  VPSHLBmr,
  VPSHLBrm,
  VPSHLBrr,
  VPSHLBrr_REV,
  VPSHLDDZ128rmbi,
  VPSHLDDZ128rmbik,
  VPSHLDDZ128rmbikz,
  VPSHLDDZ128rmi,
  VPSHLDDZ128rmik,
  VPSHLDDZ128rmikz,
  VPSHLDDZ128rri,
  VPSHLDDZ128rrik,
  VPSHLDDZ128rrikz,
  VPSHLDDZ256rmbi,
  VPSHLDDZ256rmbik,
  VPSHLDDZ256rmbikz,
  VPSHLDDZ256rmi,
  VPSHLDDZ256rmik,
  VPSHLDDZ256rmikz,
  VPSHLDDZ256rri,
  VPSHLDDZ256rrik,
  VPSHLDDZ256rrikz,
  VPSHLDDZrmbi,
  VPSHLDDZrmbik,
  VPSHLDDZrmbikz,
  VPSHLDDZrmi,
  VPSHLDDZrmik,
  VPSHLDDZrmikz,
  VPSHLDDZrri,
  VPSHLDDZrrik,
  VPSHLDDZrrikz,
  VPSHLDQZ128rmbi,
  VPSHLDQZ128rmbik,
  VPSHLDQZ128rmbikz,
  VPSHLDQZ128rmi,
  VPSHLDQZ128rmik,
  VPSHLDQZ128rmikz,
  VPSHLDQZ128rri,
  VPSHLDQZ128rrik,
  VPSHLDQZ128rrikz,
  VPSHLDQZ256rmbi,
  VPSHLDQZ256rmbik,
  VPSHLDQZ256rmbikz,
  VPSHLDQZ256rmi,
  VPSHLDQZ256rmik,
  VPSHLDQZ256rmikz,
  VPSHLDQZ256rri,
  VPSHLDQZ256rrik,
  VPSHLDQZ256rrikz,
  VPSHLDQZrmbi,
  VPSHLDQZrmbik,
  VPSHLDQZrmbikz,
  VPSHLDQZrmi,
  VPSHLDQZrmik,
  VPSHLDQZrmikz,
  VPSHLDQZrri,
  VPSHLDQZrrik,
  VPSHLDQZrrikz,
  VPSHLDVDZ128m,
  VPSHLDVDZ128mb,
  VPSHLDVDZ128mbk,
  VPSHLDVDZ128mbkz,
  VPSHLDVDZ128mk,
  VPSHLDVDZ128mkz,
  VPSHLDVDZ128r,
  VPSHLDVDZ128rk,
  VPSHLDVDZ128rkz,
  VPSHLDVDZ256m,
  VPSHLDVDZ256mb,
  VPSHLDVDZ256mbk,
  VPSHLDVDZ256mbkz,
  VPSHLDVDZ256mk,
  VPSHLDVDZ256mkz,
  VPSHLDVDZ256r,
  VPSHLDVDZ256rk,
  VPSHLDVDZ256rkz,
  VPSHLDVDZm,
  VPSHLDVDZmb,
  VPSHLDVDZmbk,
  VPSHLDVDZmbkz,
  VPSHLDVDZmk,
  VPSHLDVDZmkz,
  VPSHLDVDZr,
  VPSHLDVDZrk,
  VPSHLDVDZrkz,
  VPSHLDVQZ128m,
  VPSHLDVQZ128mb,
  VPSHLDVQZ128mbk,
  VPSHLDVQZ128mbkz,
  VPSHLDVQZ128mk,
  VPSHLDVQZ128mkz,
  VPSHLDVQZ128r,
  VPSHLDVQZ128rk,
  VPSHLDVQZ128rkz,
  VPSHLDVQZ256m,
  VPSHLDVQZ256mb,
  VPSHLDVQZ256mbk,
  VPSHLDVQZ256mbkz,
  VPSHLDVQZ256mk,
  VPSHLDVQZ256mkz,
  VPSHLDVQZ256r,
  VPSHLDVQZ256rk,
  VPSHLDVQZ256rkz,
  VPSHLDVQZm,
  VPSHLDVQZmb,
  VPSHLDVQZmbk,
  VPSHLDVQZmbkz,
  VPSHLDVQZmk,
  VPSHLDVQZmkz,
  VPSHLDVQZr,
  VPSHLDVQZrk,
  VPSHLDVQZrkz,
  VPSHLDVWZ128m,
  VPSHLDVWZ128mk,
  VPSHLDVWZ128mkz,
  VPSHLDVWZ128r,
  VPSHLDVWZ128rk,
  VPSHLDVWZ128rkz,
  VPSHLDVWZ256m,
  VPSHLDVWZ256mk,
  VPSHLDVWZ256mkz,
  VPSHLDVWZ256r,
  VPSHLDVWZ256rk,
  VPSHLDVWZ256rkz,
  VPSHLDVWZm,
  VPSHLDVWZmk,
  VPSHLDVWZmkz,
  VPSHLDVWZr,
  VPSHLDVWZrk,
  VPSHLDVWZrkz,
  VPSHLDWZ128rmi,
  VPSHLDWZ128rmik,
  VPSHLDWZ128rmikz,
  VPSHLDWZ128rri,
  VPSHLDWZ128rrik,
  VPSHLDWZ128rrikz,
  VPSHLDWZ256rmi,
  VPSHLDWZ256rmik,
  VPSHLDWZ256rmikz,
  VPSHLDWZ256rri,
  VPSHLDWZ256rrik,
  VPSHLDWZ256rrikz,
  VPSHLDWZrmi,
  VPSHLDWZrmik,
  VPSHLDWZrmikz,
  VPSHLDWZrri,
  VPSHLDWZrrik,
  VPSHLDWZrrikz,
  VPSHLDmr,
  VPSHLDrm,
  VPSHLDrr,
  VPSHLDrr_REV,
  VPSHLQmr,
  VPSHLQrm,
  VPSHLQrr,
  VPSHLQrr_REV,
  VPSHLWmr,
  VPSHLWrm,
  VPSHLWrr,
  VPSHLWrr_REV,
  VPSHRDDZ128rmbi,
  VPSHRDDZ128rmbik,
  VPSHRDDZ128rmbikz,
  VPSHRDDZ128rmi,
  VPSHRDDZ128rmik,
  VPSHRDDZ128rmikz,
  VPSHRDDZ128rri,
  VPSHRDDZ128rrik,
  VPSHRDDZ128rrikz,
  VPSHRDDZ256rmbi,
  VPSHRDDZ256rmbik,
  VPSHRDDZ256rmbikz,
  VPSHRDDZ256rmi,
  VPSHRDDZ256rmik,
  VPSHRDDZ256rmikz,
  VPSHRDDZ256rri,
  VPSHRDDZ256rrik,
  VPSHRDDZ256rrikz,
  VPSHRDDZrmbi,
  VPSHRDDZrmbik,
  VPSHRDDZrmbikz,
  VPSHRDDZrmi,
  VPSHRDDZrmik,
  VPSHRDDZrmikz,
  VPSHRDDZrri,
  VPSHRDDZrrik,
  VPSHRDDZrrikz,
  VPSHRDQZ128rmbi,
  VPSHRDQZ128rmbik,
  VPSHRDQZ128rmbikz,
  VPSHRDQZ128rmi,
  VPSHRDQZ128rmik,
  VPSHRDQZ128rmikz,
  VPSHRDQZ128rri,
  VPSHRDQZ128rrik,
  VPSHRDQZ128rrikz,
  VPSHRDQZ256rmbi,
  VPSHRDQZ256rmbik,
  VPSHRDQZ256rmbikz,
  VPSHRDQZ256rmi,
  VPSHRDQZ256rmik,
  VPSHRDQZ256rmikz,
  VPSHRDQZ256rri,
  VPSHRDQZ256rrik,
  VPSHRDQZ256rrikz,
  VPSHRDQZrmbi,
  VPSHRDQZrmbik,
  VPSHRDQZrmbikz,
  VPSHRDQZrmi,
  VPSHRDQZrmik,
  VPSHRDQZrmikz,
  VPSHRDQZrri,
  VPSHRDQZrrik,
  VPSHRDQZrrikz,
  VPSHRDVDZ128m,
  VPSHRDVDZ128mb,
  VPSHRDVDZ128mbk,
  VPSHRDVDZ128mbkz,
  VPSHRDVDZ128mk,
  VPSHRDVDZ128mkz,
  VPSHRDVDZ128r,
  VPSHRDVDZ128rk,
  VPSHRDVDZ128rkz,
  VPSHRDVDZ256m,
  VPSHRDVDZ256mb,
  VPSHRDVDZ256mbk,
  VPSHRDVDZ256mbkz,
  VPSHRDVDZ256mk,
  VPSHRDVDZ256mkz,
  VPSHRDVDZ256r,
  VPSHRDVDZ256rk,
  VPSHRDVDZ256rkz,
  VPSHRDVDZm,
  VPSHRDVDZmb,
  VPSHRDVDZmbk,
  VPSHRDVDZmbkz,
  VPSHRDVDZmk,
  VPSHRDVDZmkz,
  VPSHRDVDZr,
  VPSHRDVDZrk,
  VPSHRDVDZrkz,
  VPSHRDVQZ128m,
  VPSHRDVQZ128mb,
  VPSHRDVQZ128mbk,
  VPSHRDVQZ128mbkz,
  VPSHRDVQZ128mk,
  VPSHRDVQZ128mkz,
  VPSHRDVQZ128r,
  VPSHRDVQZ128rk,
  VPSHRDVQZ128rkz,
  VPSHRDVQZ256m,
  VPSHRDVQZ256mb,
  VPSHRDVQZ256mbk,
  VPSHRDVQZ256mbkz,
  VPSHRDVQZ256mk,
  VPSHRDVQZ256mkz,
  VPSHRDVQZ256r,
  VPSHRDVQZ256rk,
  VPSHRDVQZ256rkz,
  VPSHRDVQZm,
  VPSHRDVQZmb,
  VPSHRDVQZmbk,
  VPSHRDVQZmbkz,
  VPSHRDVQZmk,
  VPSHRDVQZmkz,
  VPSHRDVQZr,
  VPSHRDVQZrk,
  VPSHRDVQZrkz,
  VPSHRDVWZ128m,
  VPSHRDVWZ128mk,
  VPSHRDVWZ128mkz,
  VPSHRDVWZ128r,
  VPSHRDVWZ128rk,
  VPSHRDVWZ128rkz,
  VPSHRDVWZ256m,
  VPSHRDVWZ256mk,
  VPSHRDVWZ256mkz,
  VPSHRDVWZ256r,
  VPSHRDVWZ256rk,
  VPSHRDVWZ256rkz,
  VPSHRDVWZm,
  VPSHRDVWZmk,
  VPSHRDVWZmkz,
  VPSHRDVWZr,
  VPSHRDVWZrk,
  VPSHRDVWZrkz,
  VPSHRDWZ128rmi,
  VPSHRDWZ128rmik,
  VPSHRDWZ128rmikz,
  VPSHRDWZ128rri,
  VPSHRDWZ128rrik,
  VPSHRDWZ128rrikz,
  VPSHRDWZ256rmi,
  VPSHRDWZ256rmik,
  VPSHRDWZ256rmikz,
  VPSHRDWZ256rri,
  VPSHRDWZ256rrik,
  VPSHRDWZ256rrikz,
  VPSHRDWZrmi,
  VPSHRDWZrmik,
  VPSHRDWZrmikz,
  VPSHRDWZrri,
  VPSHRDWZrrik,
  VPSHRDWZrrikz,
  VPSHUFBITQMBZ128rm,
  VPSHUFBITQMBZ128rmk,
  VPSHUFBITQMBZ128rr,
  VPSHUFBITQMBZ128rrk,
  VPSHUFBITQMBZ256rm,
  VPSHUFBITQMBZ256rmk,
  VPSHUFBITQMBZ256rr,
  VPSHUFBITQMBZ256rrk,
  VPSHUFBITQMBZrm,
  VPSHUFBITQMBZrmk,
  VPSHUFBITQMBZrr,
  VPSHUFBITQMBZrrk,
  VPSHUFBYrm,
  VPSHUFBYrr,
  VPSHUFBZ128rm,
  VPSHUFBZ128rmk,
  VPSHUFBZ128rmkz,
  VPSHUFBZ128rr,
  VPSHUFBZ128rrk,
  VPSHUFBZ128rrkz,
  VPSHUFBZ256rm,
  VPSHUFBZ256rmk,
  VPSHUFBZ256rmkz,
  VPSHUFBZ256rr,
  VPSHUFBZ256rrk,
  VPSHUFBZ256rrkz,
  VPSHUFBZrm,
  VPSHUFBZrmk,
  VPSHUFBZrmkz,
  VPSHUFBZrr,
  VPSHUFBZrrk,
  VPSHUFBZrrkz,
  VPSHUFBrm,
  VPSHUFBrr,
  VPSHUFDYmi,
  VPSHUFDYri,
  VPSHUFDZ128mbi,
  VPSHUFDZ128mbik,
  VPSHUFDZ128mbikz,
  VPSHUFDZ128mi,
  VPSHUFDZ128mik,
  VPSHUFDZ128mikz,
  VPSHUFDZ128ri,
  VPSHUFDZ128rik,
  VPSHUFDZ128rikz,
  VPSHUFDZ256mbi,
  VPSHUFDZ256mbik,
  VPSHUFDZ256mbikz,
  VPSHUFDZ256mi,
  VPSHUFDZ256mik,
  VPSHUFDZ256mikz,
  VPSHUFDZ256ri,
  VPSHUFDZ256rik,
  VPSHUFDZ256rikz,
  VPSHUFDZmbi,
  VPSHUFDZmbik,
  VPSHUFDZmbikz,
  VPSHUFDZmi,
  VPSHUFDZmik,
  VPSHUFDZmikz,
  VPSHUFDZri,
  VPSHUFDZrik,
  VPSHUFDZrikz,
  VPSHUFDmi,
  VPSHUFDri,
  VPSHUFHWYmi,
  VPSHUFHWYri,
  VPSHUFHWZ128mi,
  VPSHUFHWZ128mik,
  VPSHUFHWZ128mikz,
  VPSHUFHWZ128ri,
  VPSHUFHWZ128rik,
  VPSHUFHWZ128rikz,
  VPSHUFHWZ256mi,
  VPSHUFHWZ256mik,
  VPSHUFHWZ256mikz,
  VPSHUFHWZ256ri,
  VPSHUFHWZ256rik,
  VPSHUFHWZ256rikz,
  VPSHUFHWZmi,
  VPSHUFHWZmik,
  VPSHUFHWZmikz,
  VPSHUFHWZri,
  VPSHUFHWZrik,
  VPSHUFHWZrikz,
  VPSHUFHWmi,
  VPSHUFHWri,
  VPSHUFLWYmi,
  VPSHUFLWYri,
  VPSHUFLWZ128mi,
  VPSHUFLWZ128mik,
  VPSHUFLWZ128mikz,
  VPSHUFLWZ128ri,
  VPSHUFLWZ128rik,
  VPSHUFLWZ128rikz,
  VPSHUFLWZ256mi,
  VPSHUFLWZ256mik,
  VPSHUFLWZ256mikz,
  VPSHUFLWZ256ri,
  VPSHUFLWZ256rik,
  VPSHUFLWZ256rikz,
  VPSHUFLWZmi,
  VPSHUFLWZmik,
  VPSHUFLWZmikz,
  VPSHUFLWZri,
  VPSHUFLWZrik,
  VPSHUFLWZrikz,
  VPSHUFLWmi,
  VPSHUFLWri,
  VPSIGNBYrm,
  VPSIGNBYrr,
  VPSIGNBrm,
  VPSIGNBrr,
  VPSIGNDYrm,
  VPSIGNDYrr,
  VPSIGNDrm,
  VPSIGNDrr,
  VPSIGNWYrm,
  VPSIGNWYrr,
  VPSIGNWrm,
  VPSIGNWrr,
  VPSLLDQYri,
  VPSLLDQZ128mi,
  VPSLLDQZ128ri,
  VPSLLDQZ256mi,
  VPSLLDQZ256ri,
  VPSLLDQZmi,
  VPSLLDQZri,
  VPSLLDQri,
  VPSLLDYri,
  VPSLLDYrm,
  VPSLLDYrr,
  VPSLLDZ128mbi,
  VPSLLDZ128mbik,
  VPSLLDZ128mbikz,
  VPSLLDZ128mi,
  VPSLLDZ128mik,
  VPSLLDZ128mikz,
  VPSLLDZ128ri,
  VPSLLDZ128rik,
  VPSLLDZ128rikz,
  VPSLLDZ128rm,
  VPSLLDZ128rmk,
  VPSLLDZ128rmkz,
  VPSLLDZ128rr,
  VPSLLDZ128rrk,
  VPSLLDZ128rrkz,
  VPSLLDZ256mbi,
  VPSLLDZ256mbik,
  VPSLLDZ256mbikz,
  VPSLLDZ256mi,
  VPSLLDZ256mik,
  VPSLLDZ256mikz,
  VPSLLDZ256ri,
  VPSLLDZ256rik,
  VPSLLDZ256rikz,
  VPSLLDZ256rm,
  VPSLLDZ256rmk,
  VPSLLDZ256rmkz,
  VPSLLDZ256rr,
  VPSLLDZ256rrk,
  VPSLLDZ256rrkz,
  VPSLLDZmbi,
  VPSLLDZmbik,
  VPSLLDZmbikz,
  VPSLLDZmi,
  VPSLLDZmik,
  VPSLLDZmikz,
  VPSLLDZri,
  VPSLLDZrik,
  VPSLLDZrikz,
  VPSLLDZrm,
  VPSLLDZrmk,
  VPSLLDZrmkz,
  VPSLLDZrr,
  VPSLLDZrrk,
  VPSLLDZrrkz,
  VPSLLDri,
  VPSLLDrm,
  VPSLLDrr,
  VPSLLQYri,
  VPSLLQYrm,
  VPSLLQYrr,
  VPSLLQZ128mbi,
  VPSLLQZ128mbik,
  VPSLLQZ128mbikz,
  VPSLLQZ128mi,
  VPSLLQZ128mik,
  VPSLLQZ128mikz,
  VPSLLQZ128ri,
  VPSLLQZ128rik,
  VPSLLQZ128rikz,
  VPSLLQZ128rm,
  VPSLLQZ128rmk,
  VPSLLQZ128rmkz,
  VPSLLQZ128rr,
  VPSLLQZ128rrk,
  VPSLLQZ128rrkz,
  VPSLLQZ256mbi,
  VPSLLQZ256mbik,
  VPSLLQZ256mbikz,
  VPSLLQZ256mi,
  VPSLLQZ256mik,
  VPSLLQZ256mikz,
  VPSLLQZ256ri,
  VPSLLQZ256rik,
  VPSLLQZ256rikz,
  VPSLLQZ256rm,
  VPSLLQZ256rmk,
  VPSLLQZ256rmkz,
  VPSLLQZ256rr,
  VPSLLQZ256rrk,
  VPSLLQZ256rrkz,
  VPSLLQZmbi,
  VPSLLQZmbik,
  VPSLLQZmbikz,
  VPSLLQZmi,
  VPSLLQZmik,
  VPSLLQZmikz,
  VPSLLQZri,
  VPSLLQZrik,
  VPSLLQZrikz,
  VPSLLQZrm,
  VPSLLQZrmk,
  VPSLLQZrmkz,
  VPSLLQZrr,
  VPSLLQZrrk,
  VPSLLQZrrkz,
  VPSLLQri,
  VPSLLQrm,
  VPSLLQrr,
  VPSLLVDYrm,
  VPSLLVDYrr,
  VPSLLVDZ128rm,
  VPSLLVDZ128rmb,
  VPSLLVDZ128rmbk,
  VPSLLVDZ128rmbkz,
  VPSLLVDZ128rmk,
  VPSLLVDZ128rmkz,
  VPSLLVDZ128rr,
  VPSLLVDZ128rrk,
  VPSLLVDZ128rrkz,
  VPSLLVDZ256rm,
  VPSLLVDZ256rmb,
  VPSLLVDZ256rmbk,
  VPSLLVDZ256rmbkz,
  VPSLLVDZ256rmk,
  VPSLLVDZ256rmkz,
  VPSLLVDZ256rr,
  VPSLLVDZ256rrk,
  VPSLLVDZ256rrkz,
  VPSLLVDZrm,
  VPSLLVDZrmb,
  VPSLLVDZrmbk,
  VPSLLVDZrmbkz,
  VPSLLVDZrmk,
  VPSLLVDZrmkz,
  VPSLLVDZrr,
  VPSLLVDZrrk,
  VPSLLVDZrrkz,
  VPSLLVDrm,
  VPSLLVDrr,
  VPSLLVQYrm,
  VPSLLVQYrr,
  VPSLLVQZ128rm,
  VPSLLVQZ128rmb,
  VPSLLVQZ128rmbk,
  VPSLLVQZ128rmbkz,
  VPSLLVQZ128rmk,
  VPSLLVQZ128rmkz,
  VPSLLVQZ128rr,
  VPSLLVQZ128rrk,
  VPSLLVQZ128rrkz,
  VPSLLVQZ256rm,
  VPSLLVQZ256rmb,
  VPSLLVQZ256rmbk,
  VPSLLVQZ256rmbkz,
  VPSLLVQZ256rmk,
  VPSLLVQZ256rmkz,
  VPSLLVQZ256rr,
  VPSLLVQZ256rrk,
  VPSLLVQZ256rrkz,
  VPSLLVQZrm,
  VPSLLVQZrmb,
  VPSLLVQZrmbk,
  VPSLLVQZrmbkz,
  VPSLLVQZrmk,
  VPSLLVQZrmkz,
  VPSLLVQZrr,
  VPSLLVQZrrk,
  VPSLLVQZrrkz,
  VPSLLVQrm,
  VPSLLVQrr,
  VPSLLVWZ128rm,
  VPSLLVWZ128rmk,
  VPSLLVWZ128rmkz,
  VPSLLVWZ128rr,
  VPSLLVWZ128rrk,
  VPSLLVWZ128rrkz,
  VPSLLVWZ256rm,
  VPSLLVWZ256rmk,
  VPSLLVWZ256rmkz,
  VPSLLVWZ256rr,
  VPSLLVWZ256rrk,
  VPSLLVWZ256rrkz,
  VPSLLVWZrm,
  VPSLLVWZrmk,
  VPSLLVWZrmkz,
  VPSLLVWZrr,
  VPSLLVWZrrk,
  VPSLLVWZrrkz,
  VPSLLWYri,
  VPSLLWYrm,
  VPSLLWYrr,
  VPSLLWZ128mi,
  VPSLLWZ128mik,
  VPSLLWZ128mikz,
  VPSLLWZ128ri,
  VPSLLWZ128rik,
  VPSLLWZ128rikz,
  VPSLLWZ128rm,
  VPSLLWZ128rmk,
  VPSLLWZ128rmkz,
  VPSLLWZ128rr,
  VPSLLWZ128rrk,
  VPSLLWZ128rrkz,
  VPSLLWZ256mi,
  VPSLLWZ256mik,
  VPSLLWZ256mikz,
  VPSLLWZ256ri,
  VPSLLWZ256rik,
  VPSLLWZ256rikz,
  VPSLLWZ256rm,
  VPSLLWZ256rmk,
  VPSLLWZ256rmkz,
  VPSLLWZ256rr,
  VPSLLWZ256rrk,
  VPSLLWZ256rrkz,
  VPSLLWZmi,
  VPSLLWZmik,
  VPSLLWZmikz,
  VPSLLWZri,
  VPSLLWZrik,
  VPSLLWZrikz,
  VPSLLWZrm,
  VPSLLWZrmk,
  VPSLLWZrmkz,
  VPSLLWZrr,
  VPSLLWZrrk,
  VPSLLWZrrkz,
  VPSLLWri,
  VPSLLWrm,
  VPSLLWrr,
  VPSRADYri,
  VPSRADYrm,
  VPSRADYrr,
  VPSRADZ128mbi,
  VPSRADZ128mbik,
  VPSRADZ128mbikz,
  VPSRADZ128mi,
  VPSRADZ128mik,
  VPSRADZ128mikz,
  VPSRADZ128ri,
  VPSRADZ128rik,
  VPSRADZ128rikz,
  VPSRADZ128rm,
  VPSRADZ128rmk,
  VPSRADZ128rmkz,
  VPSRADZ128rr,
  VPSRADZ128rrk,
  VPSRADZ128rrkz,
  VPSRADZ256mbi,
  VPSRADZ256mbik,
  VPSRADZ256mbikz,
  VPSRADZ256mi,
  VPSRADZ256mik,
  VPSRADZ256mikz,
  VPSRADZ256ri,
  VPSRADZ256rik,
  VPSRADZ256rikz,
  VPSRADZ256rm,
  VPSRADZ256rmk,
  VPSRADZ256rmkz,
  VPSRADZ256rr,
  VPSRADZ256rrk,
  VPSRADZ256rrkz,
  VPSRADZmbi,
  VPSRADZmbik,
  VPSRADZmbikz,
  VPSRADZmi,
  VPSRADZmik,
  VPSRADZmikz,
  VPSRADZri,
  VPSRADZrik,
  VPSRADZrikz,
  VPSRADZrm,
  VPSRADZrmk,
  VPSRADZrmkz,
  VPSRADZrr,
  VPSRADZrrk,
  VPSRADZrrkz,
  VPSRADri,
  VPSRADrm,
  VPSRADrr,
  VPSRAQZ128mbi,
  VPSRAQZ128mbik,
  VPSRAQZ128mbikz,
  VPSRAQZ128mi,
  VPSRAQZ128mik,
  VPSRAQZ128mikz,
  VPSRAQZ128ri,
  VPSRAQZ128rik,
  VPSRAQZ128rikz,
  VPSRAQZ128rm,
  VPSRAQZ128rmk,
  VPSRAQZ128rmkz,
  VPSRAQZ128rr,
  VPSRAQZ128rrk,
  VPSRAQZ128rrkz,
  VPSRAQZ256mbi,
  VPSRAQZ256mbik,
  VPSRAQZ256mbikz,
  VPSRAQZ256mi,
  VPSRAQZ256mik,
  VPSRAQZ256mikz,
  VPSRAQZ256ri,
  VPSRAQZ256rik,
  VPSRAQZ256rikz,
  VPSRAQZ256rm,
  VPSRAQZ256rmk,
  VPSRAQZ256rmkz,
  VPSRAQZ256rr,
  VPSRAQZ256rrk,
  VPSRAQZ256rrkz,
  VPSRAQZmbi,
  VPSRAQZmbik,
  VPSRAQZmbikz,
  VPSRAQZmi,
  VPSRAQZmik,
  VPSRAQZmikz,
  VPSRAQZri,
  VPSRAQZrik,
  VPSRAQZrikz,
  VPSRAQZrm,
  VPSRAQZrmk,
  VPSRAQZrmkz,
  VPSRAQZrr,
  VPSRAQZrrk,
  VPSRAQZrrkz,
  VPSRAVDYrm,
  VPSRAVDYrr,
  VPSRAVDZ128rm,
  VPSRAVDZ128rmb,
  VPSRAVDZ128rmbk,
  VPSRAVDZ128rmbkz,
  VPSRAVDZ128rmk,
  VPSRAVDZ128rmkz,
  VPSRAVDZ128rr,
  VPSRAVDZ128rrk,
  VPSRAVDZ128rrkz,
  VPSRAVDZ256rm,
  VPSRAVDZ256rmb,
  VPSRAVDZ256rmbk,
  VPSRAVDZ256rmbkz,
  VPSRAVDZ256rmk,
  VPSRAVDZ256rmkz,
  VPSRAVDZ256rr,
  VPSRAVDZ256rrk,
  VPSRAVDZ256rrkz,
  VPSRAVDZrm,
  VPSRAVDZrmb,
  VPSRAVDZrmbk,
  VPSRAVDZrmbkz,
  VPSRAVDZrmk,
  VPSRAVDZrmkz,
  VPSRAVDZrr,
  VPSRAVDZrrk,
  VPSRAVDZrrkz,
  VPSRAVDrm,
  VPSRAVDrr,
  VPSRAVQZ128rm,
  VPSRAVQZ128rmb,
  VPSRAVQZ128rmbk,
  VPSRAVQZ128rmbkz,
  VPSRAVQZ128rmk,
  VPSRAVQZ128rmkz,
  VPSRAVQZ128rr,
  VPSRAVQZ128rrk,
  VPSRAVQZ128rrkz,
  VPSRAVQZ256rm,
  VPSRAVQZ256rmb,
  VPSRAVQZ256rmbk,
  VPSRAVQZ256rmbkz,
  VPSRAVQZ256rmk,
  VPSRAVQZ256rmkz,
  VPSRAVQZ256rr,
  VPSRAVQZ256rrk,
  VPSRAVQZ256rrkz,
  VPSRAVQZrm,
  VPSRAVQZrmb,
  VPSRAVQZrmbk,
  VPSRAVQZrmbkz,
  VPSRAVQZrmk,
  VPSRAVQZrmkz,
  VPSRAVQZrr,
  VPSRAVQZrrk,
  VPSRAVQZrrkz,
  VPSRAVWZ128rm,
  VPSRAVWZ128rmk,
  VPSRAVWZ128rmkz,
  VPSRAVWZ128rr,
  VPSRAVWZ128rrk,
  VPSRAVWZ128rrkz,
  VPSRAVWZ256rm,
  VPSRAVWZ256rmk,
  VPSRAVWZ256rmkz,
  VPSRAVWZ256rr,
  VPSRAVWZ256rrk,
  VPSRAVWZ256rrkz,
  VPSRAVWZrm,
  VPSRAVWZrmk,
  VPSRAVWZrmkz,
  VPSRAVWZrr,
  VPSRAVWZrrk,
  VPSRAVWZrrkz,
  VPSRAWYri,
  VPSRAWYrm,
  VPSRAWYrr,
  VPSRAWZ128mi,
  VPSRAWZ128mik,
  VPSRAWZ128mikz,
  VPSRAWZ128ri,
  VPSRAWZ128rik,
  VPSRAWZ128rikz,
  VPSRAWZ128rm,
  VPSRAWZ128rmk,
  VPSRAWZ128rmkz,
  VPSRAWZ128rr,
  VPSRAWZ128rrk,
  VPSRAWZ128rrkz,
  VPSRAWZ256mi,
  VPSRAWZ256mik,
  VPSRAWZ256mikz,
  VPSRAWZ256ri,
  VPSRAWZ256rik,
  VPSRAWZ256rikz,
  VPSRAWZ256rm,
  VPSRAWZ256rmk,
  VPSRAWZ256rmkz,
  VPSRAWZ256rr,
  VPSRAWZ256rrk,
  VPSRAWZ256rrkz,
  VPSRAWZmi,
  VPSRAWZmik,
  VPSRAWZmikz,
  VPSRAWZri,
  VPSRAWZrik,
  VPSRAWZrikz,
  VPSRAWZrm,
  VPSRAWZrmk,
  VPSRAWZrmkz,
  VPSRAWZrr,
  VPSRAWZrrk,
  VPSRAWZrrkz,
  VPSRAWri,
  VPSRAWrm,
  VPSRAWrr,
  VPSRLDQYri,
  VPSRLDQZ128mi,
  VPSRLDQZ128ri,
  VPSRLDQZ256mi,
  VPSRLDQZ256ri,
  VPSRLDQZmi,
  VPSRLDQZri,
  VPSRLDQri,
  VPSRLDYri,
  VPSRLDYrm,
  VPSRLDYrr,
  VPSRLDZ128mbi,
  VPSRLDZ128mbik,
  VPSRLDZ128mbikz,
  VPSRLDZ128mi,
  VPSRLDZ128mik,
  VPSRLDZ128mikz,
  VPSRLDZ128ri,
  VPSRLDZ128rik,
  VPSRLDZ128rikz,
  VPSRLDZ128rm,
  VPSRLDZ128rmk,
  VPSRLDZ128rmkz,
  VPSRLDZ128rr,
  VPSRLDZ128rrk,
  VPSRLDZ128rrkz,
  VPSRLDZ256mbi,
  VPSRLDZ256mbik,
  VPSRLDZ256mbikz,
  VPSRLDZ256mi,
  VPSRLDZ256mik,
  VPSRLDZ256mikz,
  VPSRLDZ256ri,
  VPSRLDZ256rik,
  VPSRLDZ256rikz,
  VPSRLDZ256rm,
  VPSRLDZ256rmk,
  VPSRLDZ256rmkz,
  VPSRLDZ256rr,
  VPSRLDZ256rrk,
  VPSRLDZ256rrkz,
  VPSRLDZmbi,
  VPSRLDZmbik,
  VPSRLDZmbikz,
  VPSRLDZmi,
  VPSRLDZmik,
  VPSRLDZmikz,
  VPSRLDZri,
  VPSRLDZrik,
  VPSRLDZrikz,
  VPSRLDZrm,
  VPSRLDZrmk,
  VPSRLDZrmkz,
  VPSRLDZrr,
  VPSRLDZrrk,
  VPSRLDZrrkz,
  VPSRLDri,
  VPSRLDrm,
  VPSRLDrr,
  VPSRLQYri,
  VPSRLQYrm,
  VPSRLQYrr,
  VPSRLQZ128mbi,
  VPSRLQZ128mbik,
  VPSRLQZ128mbikz,
  VPSRLQZ128mi,
  VPSRLQZ128mik,
  VPSRLQZ128mikz,
  VPSRLQZ128ri,
  VPSRLQZ128rik,
  VPSRLQZ128rikz,
  VPSRLQZ128rm,
  VPSRLQZ128rmk,
  VPSRLQZ128rmkz,
  VPSRLQZ128rr,
  VPSRLQZ128rrk,
  VPSRLQZ128rrkz,
  VPSRLQZ256mbi,
  VPSRLQZ256mbik,
  VPSRLQZ256mbikz,
  VPSRLQZ256mi,
  VPSRLQZ256mik,
  VPSRLQZ256mikz,
  VPSRLQZ256ri,
  VPSRLQZ256rik,
  VPSRLQZ256rikz,
  VPSRLQZ256rm,
  VPSRLQZ256rmk,
  VPSRLQZ256rmkz,
  VPSRLQZ256rr,
  VPSRLQZ256rrk,
  VPSRLQZ256rrkz,
  VPSRLQZmbi,
  VPSRLQZmbik,
  VPSRLQZmbikz,
  VPSRLQZmi,
  VPSRLQZmik,
  VPSRLQZmikz,
  VPSRLQZri,
  VPSRLQZrik,
  VPSRLQZrikz,
  VPSRLQZrm,
  VPSRLQZrmk,
  VPSRLQZrmkz,
  VPSRLQZrr,
  VPSRLQZrrk,
  VPSRLQZrrkz,
  VPSRLQri,
  VPSRLQrm,
  VPSRLQrr,
  VPSRLVDYrm,
  VPSRLVDYrr,
  VPSRLVDZ128rm,
  VPSRLVDZ128rmb,
  VPSRLVDZ128rmbk,
  VPSRLVDZ128rmbkz,
  VPSRLVDZ128rmk,
  VPSRLVDZ128rmkz,
  VPSRLVDZ128rr,
  VPSRLVDZ128rrk,
  VPSRLVDZ128rrkz,
  VPSRLVDZ256rm,
  VPSRLVDZ256rmb,
  VPSRLVDZ256rmbk,
  VPSRLVDZ256rmbkz,
  VPSRLVDZ256rmk,
  VPSRLVDZ256rmkz,
  VPSRLVDZ256rr,
  VPSRLVDZ256rrk,
  VPSRLVDZ256rrkz,
  VPSRLVDZrm,
  VPSRLVDZrmb,
  VPSRLVDZrmbk,
  VPSRLVDZrmbkz,
  VPSRLVDZrmk,
  VPSRLVDZrmkz,
  VPSRLVDZrr,
  VPSRLVDZrrk,
  VPSRLVDZrrkz,
  VPSRLVDrm,
  VPSRLVDrr,
  VPSRLVQYrm,
  VPSRLVQYrr,
  VPSRLVQZ128rm,
  VPSRLVQZ128rmb,
  VPSRLVQZ128rmbk,
  VPSRLVQZ128rmbkz,
  VPSRLVQZ128rmk,
  VPSRLVQZ128rmkz,
  VPSRLVQZ128rr,
  VPSRLVQZ128rrk,
  VPSRLVQZ128rrkz,
  VPSRLVQZ256rm,
  VPSRLVQZ256rmb,
  VPSRLVQZ256rmbk,
  VPSRLVQZ256rmbkz,
  VPSRLVQZ256rmk,
  VPSRLVQZ256rmkz,
  VPSRLVQZ256rr,
  VPSRLVQZ256rrk,
  VPSRLVQZ256rrkz,
  VPSRLVQZrm,
  VPSRLVQZrmb,
  VPSRLVQZrmbk,
  VPSRLVQZrmbkz,
  VPSRLVQZrmk,
  VPSRLVQZrmkz,
  VPSRLVQZrr,
  VPSRLVQZrrk,
  VPSRLVQZrrkz,
  VPSRLVQrm,
  VPSRLVQrr,
  VPSRLVWZ128rm,
  VPSRLVWZ128rmk,
  VPSRLVWZ128rmkz,
  VPSRLVWZ128rr,
  VPSRLVWZ128rrk,
  VPSRLVWZ128rrkz,
  VPSRLVWZ256rm,
  VPSRLVWZ256rmk,
  VPSRLVWZ256rmkz,
  VPSRLVWZ256rr,
  VPSRLVWZ256rrk,
  VPSRLVWZ256rrkz,
  VPSRLVWZrm,
  VPSRLVWZrmk,
  VPSRLVWZrmkz,
  VPSRLVWZrr,
  VPSRLVWZrrk,
  VPSRLVWZrrkz,
  VPSRLWYri,
  VPSRLWYrm,
  VPSRLWYrr,
  VPSRLWZ128mi,
  VPSRLWZ128mik,
  VPSRLWZ128mikz,
  VPSRLWZ128ri,
  VPSRLWZ128rik,
  VPSRLWZ128rikz,
  VPSRLWZ128rm,
  VPSRLWZ128rmk,
  VPSRLWZ128rmkz,
  VPSRLWZ128rr,
  VPSRLWZ128rrk,
  VPSRLWZ128rrkz,
  VPSRLWZ256mi,
  VPSRLWZ256mik,
  VPSRLWZ256mikz,
  VPSRLWZ256ri,
  VPSRLWZ256rik,
  VPSRLWZ256rikz,
  VPSRLWZ256rm,
  VPSRLWZ256rmk,
  VPSRLWZ256rmkz,
  VPSRLWZ256rr,
  VPSRLWZ256rrk,
  VPSRLWZ256rrkz,
  VPSRLWZmi,
  VPSRLWZmik,
  VPSRLWZmikz,
  VPSRLWZri,
  VPSRLWZrik,
  VPSRLWZrikz,
  VPSRLWZrm,
  VPSRLWZrmk,
  VPSRLWZrmkz,
  VPSRLWZrr,
  VPSRLWZrrk,
  VPSRLWZrrkz,
  VPSRLWri,
  VPSRLWrm,
  VPSRLWrr,
  VPSUBBYrm,
  VPSUBBYrr,
  VPSUBBZ128rm,
  VPSUBBZ128rmk,
  VPSUBBZ128rmkz,
  VPSUBBZ128rr,
  VPSUBBZ128rrk,
  VPSUBBZ128rrkz,
  VPSUBBZ256rm,
  VPSUBBZ256rmk,
  VPSUBBZ256rmkz,
  VPSUBBZ256rr,
  VPSUBBZ256rrk,
  VPSUBBZ256rrkz,
  VPSUBBZrm,
  VPSUBBZrmk,
  VPSUBBZrmkz,
  VPSUBBZrr,
  VPSUBBZrrk,
  VPSUBBZrrkz,
  VPSUBBrm,
  VPSUBBrr,
  VPSUBDYrm,
  VPSUBDYrr,
  VPSUBDZ128rm,
  VPSUBDZ128rmb,
  VPSUBDZ128rmbk,
  VPSUBDZ128rmbkz,
  VPSUBDZ128rmk,
  VPSUBDZ128rmkz,
  VPSUBDZ128rr,
  VPSUBDZ128rrk,
  VPSUBDZ128rrkz,
  VPSUBDZ256rm,
  VPSUBDZ256rmb,
  VPSUBDZ256rmbk,
  VPSUBDZ256rmbkz,
  VPSUBDZ256rmk,
  VPSUBDZ256rmkz,
  VPSUBDZ256rr,
  VPSUBDZ256rrk,
  VPSUBDZ256rrkz,
  VPSUBDZrm,
  VPSUBDZrmb,
  VPSUBDZrmbk,
  VPSUBDZrmbkz,
  VPSUBDZrmk,
  VPSUBDZrmkz,
  VPSUBDZrr,
  VPSUBDZrrk,
  VPSUBDZrrkz,
  VPSUBDrm,
  VPSUBDrr,
  VPSUBQYrm,
  VPSUBQYrr,
  VPSUBQZ128rm,
  VPSUBQZ128rmb,
  VPSUBQZ128rmbk,
  VPSUBQZ128rmbkz,
  VPSUBQZ128rmk,
  VPSUBQZ128rmkz,
  VPSUBQZ128rr,
  VPSUBQZ128rrk,
  VPSUBQZ128rrkz,
  VPSUBQZ256rm,
  VPSUBQZ256rmb,
  VPSUBQZ256rmbk,
  VPSUBQZ256rmbkz,
  VPSUBQZ256rmk,
  VPSUBQZ256rmkz,
  VPSUBQZ256rr,
  VPSUBQZ256rrk,
  VPSUBQZ256rrkz,
  VPSUBQZrm,
  VPSUBQZrmb,
  VPSUBQZrmbk,
  VPSUBQZrmbkz,
  VPSUBQZrmk,
  VPSUBQZrmkz,
  VPSUBQZrr,
  VPSUBQZrrk,
  VPSUBQZrrkz,
  VPSUBQrm,
  VPSUBQrr,
  VPSUBSBYrm,
  VPSUBSBYrr,
  VPSUBSBZ128rm,
  VPSUBSBZ128rmk,
  VPSUBSBZ128rmkz,
  VPSUBSBZ128rr,
  VPSUBSBZ128rrk,
  VPSUBSBZ128rrkz,
  VPSUBSBZ256rm,
  VPSUBSBZ256rmk,
  VPSUBSBZ256rmkz,
  VPSUBSBZ256rr,
  VPSUBSBZ256rrk,
  VPSUBSBZ256rrkz,
  VPSUBSBZrm,
  VPSUBSBZrmk,
  VPSUBSBZrmkz,
  VPSUBSBZrr,
  VPSUBSBZrrk,
  VPSUBSBZrrkz,
  VPSUBSBrm,
  VPSUBSBrr,
  VPSUBSWYrm,
  VPSUBSWYrr,
  VPSUBSWZ128rm,
  VPSUBSWZ128rmk,
  VPSUBSWZ128rmkz,
  VPSUBSWZ128rr,
  VPSUBSWZ128rrk,
  VPSUBSWZ128rrkz,
  VPSUBSWZ256rm,
  VPSUBSWZ256rmk,
  VPSUBSWZ256rmkz,
  VPSUBSWZ256rr,
  VPSUBSWZ256rrk,
  VPSUBSWZ256rrkz,
  VPSUBSWZrm,
  VPSUBSWZrmk,
  VPSUBSWZrmkz,
  VPSUBSWZrr,
  VPSUBSWZrrk,
  VPSUBSWZrrkz,
  VPSUBSWrm,
  VPSUBSWrr,
  VPSUBUSBYrm,
  VPSUBUSBYrr,
  VPSUBUSBZ128rm,
  VPSUBUSBZ128rmk,
  VPSUBUSBZ128rmkz,
  VPSUBUSBZ128rr,
  VPSUBUSBZ128rrk,
  VPSUBUSBZ128rrkz,
  VPSUBUSBZ256rm,
  VPSUBUSBZ256rmk,
  VPSUBUSBZ256rmkz,
  VPSUBUSBZ256rr,
  VPSUBUSBZ256rrk,
  VPSUBUSBZ256rrkz,
  VPSUBUSBZrm,
  VPSUBUSBZrmk,
  VPSUBUSBZrmkz,
  VPSUBUSBZrr,
  VPSUBUSBZrrk,
  VPSUBUSBZrrkz,
  VPSUBUSBrm,
  VPSUBUSBrr,
  VPSUBUSWYrm,
  VPSUBUSWYrr,
  VPSUBUSWZ128rm,
  VPSUBUSWZ128rmk,
  VPSUBUSWZ128rmkz,
  VPSUBUSWZ128rr,
  VPSUBUSWZ128rrk,
  VPSUBUSWZ128rrkz,
  VPSUBUSWZ256rm,
  VPSUBUSWZ256rmk,
  VPSUBUSWZ256rmkz,
  VPSUBUSWZ256rr,
  VPSUBUSWZ256rrk,
  VPSUBUSWZ256rrkz,
  VPSUBUSWZrm,
  VPSUBUSWZrmk,
  VPSUBUSWZrmkz,
  VPSUBUSWZrr,
  VPSUBUSWZrrk,
  VPSUBUSWZrrkz,
  VPSUBUSWrm,
  VPSUBUSWrr,
  VPSUBWYrm,
  VPSUBWYrr,
  VPSUBWZ128rm,
  VPSUBWZ128rmk,
  VPSUBWZ128rmkz,
  VPSUBWZ128rr,
  VPSUBWZ128rrk,
  VPSUBWZ128rrkz,
  VPSUBWZ256rm,
  VPSUBWZ256rmk,
  VPSUBWZ256rmkz,
  VPSUBWZ256rr,
  VPSUBWZ256rrk,
  VPSUBWZ256rrkz,
  VPSUBWZrm,
  VPSUBWZrmk,
  VPSUBWZrmkz,
  VPSUBWZrr,
  VPSUBWZrrk,
  VPSUBWZrrkz,
  VPSUBWrm,
  VPSUBWrr,
  VPTERNLOGDZ128rmbi,
  VPTERNLOGDZ128rmbik,
  VPTERNLOGDZ128rmbikz,
  VPTERNLOGDZ128rmi,
  VPTERNLOGDZ128rmik,
  VPTERNLOGDZ128rmikz,
  VPTERNLOGDZ128rri,
  VPTERNLOGDZ128rrik,
  VPTERNLOGDZ128rrikz,
  VPTERNLOGDZ256rmbi,
  VPTERNLOGDZ256rmbik,
  VPTERNLOGDZ256rmbikz,
  VPTERNLOGDZ256rmi,
  VPTERNLOGDZ256rmik,
  VPTERNLOGDZ256rmikz,
  VPTERNLOGDZ256rri,
  VPTERNLOGDZ256rrik,
  VPTERNLOGDZ256rrikz,
  VPTERNLOGDZrmbi,
  VPTERNLOGDZrmbik,
  VPTERNLOGDZrmbikz,
  VPTERNLOGDZrmi,
  VPTERNLOGDZrmik,
  VPTERNLOGDZrmikz,
  VPTERNLOGDZrri,
  VPTERNLOGDZrrik,
  VPTERNLOGDZrrikz,
  VPTERNLOGQZ128rmbi,
  VPTERNLOGQZ128rmbik,
  VPTERNLOGQZ128rmbikz,
  VPTERNLOGQZ128rmi,
  VPTERNLOGQZ128rmik,
  VPTERNLOGQZ128rmikz,
  VPTERNLOGQZ128rri,
  VPTERNLOGQZ128rrik,
  VPTERNLOGQZ128rrikz,
  VPTERNLOGQZ256rmbi,
  VPTERNLOGQZ256rmbik,
  VPTERNLOGQZ256rmbikz,
  VPTERNLOGQZ256rmi,
  VPTERNLOGQZ256rmik,
  VPTERNLOGQZ256rmikz,
  VPTERNLOGQZ256rri,
  VPTERNLOGQZ256rrik,
  VPTERNLOGQZ256rrikz,
  VPTERNLOGQZrmbi,
  VPTERNLOGQZrmbik,
  VPTERNLOGQZrmbikz,
  VPTERNLOGQZrmi,
  VPTERNLOGQZrmik,
  VPTERNLOGQZrmikz,
  VPTERNLOGQZrri,
  VPTERNLOGQZrrik,
  VPTERNLOGQZrrikz,
  VPTESTMBZ128rm,
  VPTESTMBZ128rmk,
  VPTESTMBZ128rr,
  VPTESTMBZ128rrk,
  VPTESTMBZ256rm,
  VPTESTMBZ256rmk,
  VPTESTMBZ256rr,
  VPTESTMBZ256rrk,
  VPTESTMBZrm,
  VPTESTMBZrmk,
  VPTESTMBZrr,
  VPTESTMBZrrk,
  VPTESTMDZ128rm,
  VPTESTMDZ128rmb,
  VPTESTMDZ128rmbk,
  VPTESTMDZ128rmk,
  VPTESTMDZ128rr,
  VPTESTMDZ128rrk,
  VPTESTMDZ256rm,
  VPTESTMDZ256rmb,
  VPTESTMDZ256rmbk,
  VPTESTMDZ256rmk,
  VPTESTMDZ256rr,
  VPTESTMDZ256rrk,
  VPTESTMDZrm,
  VPTESTMDZrmb,
  VPTESTMDZrmbk,
  VPTESTMDZrmk,
  VPTESTMDZrr,
  VPTESTMDZrrk,
  VPTESTMQZ128rm,
  VPTESTMQZ128rmb,
  VPTESTMQZ128rmbk,
  VPTESTMQZ128rmk,
  VPTESTMQZ128rr,
  VPTESTMQZ128rrk,
  VPTESTMQZ256rm,
  VPTESTMQZ256rmb,
  VPTESTMQZ256rmbk,
  VPTESTMQZ256rmk,
  VPTESTMQZ256rr,
  VPTESTMQZ256rrk,
  VPTESTMQZrm,
  VPTESTMQZrmb,
  VPTESTMQZrmbk,
  VPTESTMQZrmk,
  VPTESTMQZrr,
  VPTESTMQZrrk,
  VPTESTMWZ128rm,
  VPTESTMWZ128rmk,
  VPTESTMWZ128rr,
  VPTESTMWZ128rrk,
  VPTESTMWZ256rm,
  VPTESTMWZ256rmk,
  VPTESTMWZ256rr,
  VPTESTMWZ256rrk,
  VPTESTMWZrm,
  VPTESTMWZrmk,
  VPTESTMWZrr,
  VPTESTMWZrrk,
  VPTESTNMBZ128rm,
  VPTESTNMBZ128rmk,
  VPTESTNMBZ128rr,
  VPTESTNMBZ128rrk,
  VPTESTNMBZ256rm,
  VPTESTNMBZ256rmk,
  VPTESTNMBZ256rr,
  VPTESTNMBZ256rrk,
  VPTESTNMBZrm,
  VPTESTNMBZrmk,
  VPTESTNMBZrr,
  VPTESTNMBZrrk,
  VPTESTNMDZ128rm,
  VPTESTNMDZ128rmb,
  VPTESTNMDZ128rmbk,
  VPTESTNMDZ128rmk,
  VPTESTNMDZ128rr,
  VPTESTNMDZ128rrk,
  VPTESTNMDZ256rm,
  VPTESTNMDZ256rmb,
  VPTESTNMDZ256rmbk,
  VPTESTNMDZ256rmk,
  VPTESTNMDZ256rr,
  VPTESTNMDZ256rrk,
  VPTESTNMDZrm,
  VPTESTNMDZrmb,
  VPTESTNMDZrmbk,
  VPTESTNMDZrmk,
  VPTESTNMDZrr,
  VPTESTNMDZrrk,
  VPTESTNMQZ128rm,
  VPTESTNMQZ128rmb,
  VPTESTNMQZ128rmbk,
  VPTESTNMQZ128rmk,
  VPTESTNMQZ128rr,
  VPTESTNMQZ128rrk,
  VPTESTNMQZ256rm,
  VPTESTNMQZ256rmb,
  VPTESTNMQZ256rmbk,
  VPTESTNMQZ256rmk,
  VPTESTNMQZ256rr,
  VPTESTNMQZ256rrk,
  VPTESTNMQZrm,
  VPTESTNMQZrmb,
  VPTESTNMQZrmbk,
  VPTESTNMQZrmk,
  VPTESTNMQZrr,
  VPTESTNMQZrrk,
  VPTESTNMWZ128rm,
  VPTESTNMWZ128rmk,
  VPTESTNMWZ128rr,
  VPTESTNMWZ128rrk,
  VPTESTNMWZ256rm,
  VPTESTNMWZ256rmk,
  VPTESTNMWZ256rr,
  VPTESTNMWZ256rrk,
  VPTESTNMWZrm,
  VPTESTNMWZrmk,
  VPTESTNMWZrr,
  VPTESTNMWZrrk,
  VPTESTYrm,
  VPTESTYrr,
  VPTESTrm,
  VPTESTrr,
  VPUNPCKHBWYrm,
  VPUNPCKHBWYrr,
  VPUNPCKHBWZ128rm,
  VPUNPCKHBWZ128rmk,
  VPUNPCKHBWZ128rmkz,
  VPUNPCKHBWZ128rr,
  VPUNPCKHBWZ128rrk,
  VPUNPCKHBWZ128rrkz,
  VPUNPCKHBWZ256rm,
  VPUNPCKHBWZ256rmk,
  VPUNPCKHBWZ256rmkz,
  VPUNPCKHBWZ256rr,
  VPUNPCKHBWZ256rrk,
  VPUNPCKHBWZ256rrkz,
  VPUNPCKHBWZrm,
  VPUNPCKHBWZrmk,
  VPUNPCKHBWZrmkz,
  VPUNPCKHBWZrr,
  VPUNPCKHBWZrrk,
  VPUNPCKHBWZrrkz,
  VPUNPCKHBWrm,
  VPUNPCKHBWrr,
  VPUNPCKHDQYrm,
  VPUNPCKHDQYrr,
  VPUNPCKHDQZ128rm,
  VPUNPCKHDQZ128rmb,
  VPUNPCKHDQZ128rmbk,
  VPUNPCKHDQZ128rmbkz,
  VPUNPCKHDQZ128rmk,
  VPUNPCKHDQZ128rmkz,
  VPUNPCKHDQZ128rr,
  VPUNPCKHDQZ128rrk,
  VPUNPCKHDQZ128rrkz,
  VPUNPCKHDQZ256rm,
  VPUNPCKHDQZ256rmb,
  VPUNPCKHDQZ256rmbk,
  VPUNPCKHDQZ256rmbkz,
  VPUNPCKHDQZ256rmk,
  VPUNPCKHDQZ256rmkz,
  VPUNPCKHDQZ256rr,
  VPUNPCKHDQZ256rrk,
  VPUNPCKHDQZ256rrkz,
  VPUNPCKHDQZrm,
  VPUNPCKHDQZrmb,
  VPUNPCKHDQZrmbk,
  VPUNPCKHDQZrmbkz,
  VPUNPCKHDQZrmk,
  VPUNPCKHDQZrmkz,
  VPUNPCKHDQZrr,
  VPUNPCKHDQZrrk,
  VPUNPCKHDQZrrkz,
  VPUNPCKHDQrm,
  VPUNPCKHDQrr,
  VPUNPCKHQDQYrm,
  VPUNPCKHQDQYrr,
  VPUNPCKHQDQZ128rm,
  VPUNPCKHQDQZ128rmb,
  VPUNPCKHQDQZ128rmbk,
  VPUNPCKHQDQZ128rmbkz,
  VPUNPCKHQDQZ128rmk,
  VPUNPCKHQDQZ128rmkz,
  VPUNPCKHQDQZ128rr,
  VPUNPCKHQDQZ128rrk,
  VPUNPCKHQDQZ128rrkz,
  VPUNPCKHQDQZ256rm,
  VPUNPCKHQDQZ256rmb,
  VPUNPCKHQDQZ256rmbk,
  VPUNPCKHQDQZ256rmbkz,
  VPUNPCKHQDQZ256rmk,
  VPUNPCKHQDQZ256rmkz,
  VPUNPCKHQDQZ256rr,
  VPUNPCKHQDQZ256rrk,
  VPUNPCKHQDQZ256rrkz,
  VPUNPCKHQDQZrm,
  VPUNPCKHQDQZrmb,
  VPUNPCKHQDQZrmbk,
  VPUNPCKHQDQZrmbkz,
  VPUNPCKHQDQZrmk,
  VPUNPCKHQDQZrmkz,
  VPUNPCKHQDQZrr,
  VPUNPCKHQDQZrrk,
  VPUNPCKHQDQZrrkz,
  VPUNPCKHQDQrm,
  VPUNPCKHQDQrr,
  VPUNPCKHWDYrm,
  VPUNPCKHWDYrr,
  VPUNPCKHWDZ128rm,
  VPUNPCKHWDZ128rmk,
  VPUNPCKHWDZ128rmkz,
  VPUNPCKHWDZ128rr,
  VPUNPCKHWDZ128rrk,
  VPUNPCKHWDZ128rrkz,
  VPUNPCKHWDZ256rm,
  VPUNPCKHWDZ256rmk,
  VPUNPCKHWDZ256rmkz,
  VPUNPCKHWDZ256rr,
  VPUNPCKHWDZ256rrk,
  VPUNPCKHWDZ256rrkz,
  VPUNPCKHWDZrm,
  VPUNPCKHWDZrmk,
  VPUNPCKHWDZrmkz,
  VPUNPCKHWDZrr,
  VPUNPCKHWDZrrk,
  VPUNPCKHWDZrrkz,
  VPUNPCKHWDrm,
  VPUNPCKHWDrr,
  VPUNPCKLBWYrm,
  VPUNPCKLBWYrr,
  VPUNPCKLBWZ128rm,
  VPUNPCKLBWZ128rmk,
  VPUNPCKLBWZ128rmkz,
  VPUNPCKLBWZ128rr,
  VPUNPCKLBWZ128rrk,
  VPUNPCKLBWZ128rrkz,
  VPUNPCKLBWZ256rm,
  VPUNPCKLBWZ256rmk,
  VPUNPCKLBWZ256rmkz,
  VPUNPCKLBWZ256rr,
  VPUNPCKLBWZ256rrk,
  VPUNPCKLBWZ256rrkz,
  VPUNPCKLBWZrm,
  VPUNPCKLBWZrmk,
  VPUNPCKLBWZrmkz,
  VPUNPCKLBWZrr,
  VPUNPCKLBWZrrk,
  VPUNPCKLBWZrrkz,
  VPUNPCKLBWrm,
  VPUNPCKLBWrr,
  VPUNPCKLDQYrm,
  VPUNPCKLDQYrr,
  VPUNPCKLDQZ128rm,
  VPUNPCKLDQZ128rmb,
  VPUNPCKLDQZ128rmbk,
  VPUNPCKLDQZ128rmbkz,
  VPUNPCKLDQZ128rmk,
  VPUNPCKLDQZ128rmkz,
  VPUNPCKLDQZ128rr,
  VPUNPCKLDQZ128rrk,
  VPUNPCKLDQZ128rrkz,
  VPUNPCKLDQZ256rm,
  VPUNPCKLDQZ256rmb,
  VPUNPCKLDQZ256rmbk,
  VPUNPCKLDQZ256rmbkz,
  VPUNPCKLDQZ256rmk,
  VPUNPCKLDQZ256rmkz,
  VPUNPCKLDQZ256rr,
  VPUNPCKLDQZ256rrk,
  VPUNPCKLDQZ256rrkz,
  VPUNPCKLDQZrm,
  VPUNPCKLDQZrmb,
  VPUNPCKLDQZrmbk,
  VPUNPCKLDQZrmbkz,
  VPUNPCKLDQZrmk,
  VPUNPCKLDQZrmkz,
  VPUNPCKLDQZrr,
  VPUNPCKLDQZrrk,
  VPUNPCKLDQZrrkz,
  VPUNPCKLDQrm,
  VPUNPCKLDQrr,
  VPUNPCKLQDQYrm,
  VPUNPCKLQDQYrr,
  VPUNPCKLQDQZ128rm,
  VPUNPCKLQDQZ128rmb,
  VPUNPCKLQDQZ128rmbk,
  VPUNPCKLQDQZ128rmbkz,
  VPUNPCKLQDQZ128rmk,
  VPUNPCKLQDQZ128rmkz,
  VPUNPCKLQDQZ128rr,
  VPUNPCKLQDQZ128rrk,
  VPUNPCKLQDQZ128rrkz,
  VPUNPCKLQDQZ256rm,
  VPUNPCKLQDQZ256rmb,
  VPUNPCKLQDQZ256rmbk,
  VPUNPCKLQDQZ256rmbkz,
  VPUNPCKLQDQZ256rmk,
  VPUNPCKLQDQZ256rmkz,
  VPUNPCKLQDQZ256rr,
  VPUNPCKLQDQZ256rrk,
  VPUNPCKLQDQZ256rrkz,
  VPUNPCKLQDQZrm,
  VPUNPCKLQDQZrmb,
  VPUNPCKLQDQZrmbk,
  VPUNPCKLQDQZrmbkz,
  VPUNPCKLQDQZrmk,
  VPUNPCKLQDQZrmkz,
  VPUNPCKLQDQZrr,
  VPUNPCKLQDQZrrk,
  VPUNPCKLQDQZrrkz,
  VPUNPCKLQDQrm,
  VPUNPCKLQDQrr,
  VPUNPCKLWDYrm,
  VPUNPCKLWDYrr,
  VPUNPCKLWDZ128rm,
  VPUNPCKLWDZ128rmk,
  VPUNPCKLWDZ128rmkz,
  VPUNPCKLWDZ128rr,
  VPUNPCKLWDZ128rrk,
  VPUNPCKLWDZ128rrkz,
  VPUNPCKLWDZ256rm,
  VPUNPCKLWDZ256rmk,
  VPUNPCKLWDZ256rmkz,
  VPUNPCKLWDZ256rr,
  VPUNPCKLWDZ256rrk,
  VPUNPCKLWDZ256rrkz,
  VPUNPCKLWDZrm,
  VPUNPCKLWDZrmk,
  VPUNPCKLWDZrmkz,
  VPUNPCKLWDZrr,
  VPUNPCKLWDZrrk,
  VPUNPCKLWDZrrkz,
  VPUNPCKLWDrm,
  VPUNPCKLWDrr,
  VPXORDZ128rm,
  VPXORDZ128rmb,
  VPXORDZ128rmbk,
  VPXORDZ128rmbkz,
  VPXORDZ128rmk,
  VPXORDZ128rmkz,
  VPXORDZ128rr,
  VPXORDZ128rrk,
  VPXORDZ128rrkz,
  VPXORDZ256rm,
  VPXORDZ256rmb,
  VPXORDZ256rmbk,
  VPXORDZ256rmbkz,
  VPXORDZ256rmk,
  VPXORDZ256rmkz,
  VPXORDZ256rr,
  VPXORDZ256rrk,
  VPXORDZ256rrkz,
  VPXORDZrm,
  VPXORDZrmb,
  VPXORDZrmbk,
  VPXORDZrmbkz,
  VPXORDZrmk,
  VPXORDZrmkz,
  VPXORDZrr,
  VPXORDZrrk,
  VPXORDZrrkz,
  VPXORQZ128rm,
  VPXORQZ128rmb,
  VPXORQZ128rmbk,
  VPXORQZ128rmbkz,
  VPXORQZ128rmk,
  VPXORQZ128rmkz,
  VPXORQZ128rr,
  VPXORQZ128rrk,
  VPXORQZ128rrkz,
  VPXORQZ256rm,
  VPXORQZ256rmb,
  VPXORQZ256rmbk,
  VPXORQZ256rmbkz,
  VPXORQZ256rmk,
  VPXORQZ256rmkz,
  VPXORQZ256rr,
  VPXORQZ256rrk,
  VPXORQZ256rrkz,
  VPXORQZrm,
  VPXORQZrmb,
  VPXORQZrmbk,
  VPXORQZrmbkz,
  VPXORQZrmk,
  VPXORQZrmkz,
  VPXORQZrr,
  VPXORQZrrk,
  VPXORQZrrkz,
  VPXORYrm,
  VPXORYrr,
  VPXORrm,
  VPXORrr,
  VRANGEPDZ128rmbi,
  VRANGEPDZ128rmbik,
  VRANGEPDZ128rmbikz,
  VRANGEPDZ128rmi,
  VRANGEPDZ128rmik,
  VRANGEPDZ128rmikz,
  VRANGEPDZ128rri,
  VRANGEPDZ128rrik,
  VRANGEPDZ128rrikz,
  VRANGEPDZ256rmbi,
  VRANGEPDZ256rmbik,
  VRANGEPDZ256rmbikz,
  VRANGEPDZ256rmi,
  VRANGEPDZ256rmik,
  VRANGEPDZ256rmikz,
  VRANGEPDZ256rri,
  VRANGEPDZ256rrik,
  VRANGEPDZ256rrikz,
  VRANGEPDZrmbi,
  VRANGEPDZrmbik,
  VRANGEPDZrmbikz,
  VRANGEPDZrmi,
  VRANGEPDZrmik,
  VRANGEPDZrmikz,
  VRANGEPDZrri,
  VRANGEPDZrrib,
  VRANGEPDZrribk,
  VRANGEPDZrribkz,
  VRANGEPDZrrik,
  VRANGEPDZrrikz,
  VRANGEPSZ128rmbi,
  VRANGEPSZ128rmbik,
  VRANGEPSZ128rmbikz,
  VRANGEPSZ128rmi,
  VRANGEPSZ128rmik,
  VRANGEPSZ128rmikz,
  VRANGEPSZ128rri,
  VRANGEPSZ128rrik,
  VRANGEPSZ128rrikz,
  VRANGEPSZ256rmbi,
  VRANGEPSZ256rmbik,
  VRANGEPSZ256rmbikz,
  VRANGEPSZ256rmi,
  VRANGEPSZ256rmik,
  VRANGEPSZ256rmikz,
  VRANGEPSZ256rri,
  VRANGEPSZ256rrik,
  VRANGEPSZ256rrikz,
  VRANGEPSZrmbi,
  VRANGEPSZrmbik,
  VRANGEPSZrmbikz,
  VRANGEPSZrmi,
  VRANGEPSZrmik,
  VRANGEPSZrmikz,
  VRANGEPSZrri,
  VRANGEPSZrrib,
  VRANGEPSZrribk,
  VRANGEPSZrribkz,
  VRANGEPSZrrik,
  VRANGEPSZrrikz,
  VRANGESDZrmi,
  VRANGESDZrmik,
  VRANGESDZrmikz,
  VRANGESDZrri,
  VRANGESDZrrib,
  VRANGESDZrribk,
  VRANGESDZrribkz,
  VRANGESDZrrik,
  VRANGESDZrrikz,
  VRANGESSZrmi,
  VRANGESSZrmik,
  VRANGESSZrmikz,
  VRANGESSZrri,
  VRANGESSZrrib,
  VRANGESSZrribk,
  VRANGESSZrribkz,
  VRANGESSZrrik,
  VRANGESSZrrikz,
  VRCP14PDZ128m,
  VRCP14PDZ128mb,
  VRCP14PDZ128mbk,
  VRCP14PDZ128mbkz,
  VRCP14PDZ128mk,
  VRCP14PDZ128mkz,
  VRCP14PDZ128r,
  VRCP14PDZ128rk,
  VRCP14PDZ128rkz,
  VRCP14PDZ256m,
  VRCP14PDZ256mb,
  VRCP14PDZ256mbk,
  VRCP14PDZ256mbkz,
  VRCP14PDZ256mk,
  VRCP14PDZ256mkz,
  VRCP14PDZ256r,
  VRCP14PDZ256rk,
  VRCP14PDZ256rkz,
  VRCP14PDZm,
  VRCP14PDZmb,
  VRCP14PDZmbk,
  VRCP14PDZmbkz,
  VRCP14PDZmk,
  VRCP14PDZmkz,
  VRCP14PDZr,
  VRCP14PDZrk,
  VRCP14PDZrkz,
  VRCP14PSZ128m,
  VRCP14PSZ128mb,
  VRCP14PSZ128mbk,
  VRCP14PSZ128mbkz,
  VRCP14PSZ128mk,
  VRCP14PSZ128mkz,
  VRCP14PSZ128r,
  VRCP14PSZ128rk,
  VRCP14PSZ128rkz,
  VRCP14PSZ256m,
  VRCP14PSZ256mb,
  VRCP14PSZ256mbk,
  VRCP14PSZ256mbkz,
  VRCP14PSZ256mk,
  VRCP14PSZ256mkz,
  VRCP14PSZ256r,
  VRCP14PSZ256rk,
  VRCP14PSZ256rkz,
  VRCP14PSZm,
  VRCP14PSZmb,
  VRCP14PSZmbk,
  VRCP14PSZmbkz,
  VRCP14PSZmk,
  VRCP14PSZmkz,
  VRCP14PSZr,
  VRCP14PSZrk,
  VRCP14PSZrkz,
  VRCP14SDZrm,
  VRCP14SDZrmk,
  VRCP14SDZrmkz,
  VRCP14SDZrr,
  VRCP14SDZrrk,
  VRCP14SDZrrkz,
  VRCP14SSZrm,
  VRCP14SSZrmk,
  VRCP14SSZrmkz,
  VRCP14SSZrr,
  VRCP14SSZrrk,
  VRCP14SSZrrkz,
  VRCP28PDZm,
  VRCP28PDZmb,
  VRCP28PDZmbk,
  VRCP28PDZmbkz,
  VRCP28PDZmk,
  VRCP28PDZmkz,
  VRCP28PDZr,
  VRCP28PDZrb,
  VRCP28PDZrbk,
  VRCP28PDZrbkz,
  VRCP28PDZrk,
  VRCP28PDZrkz,
  VRCP28PSZm,
  VRCP28PSZmb,
  VRCP28PSZmbk,
  VRCP28PSZmbkz,
  VRCP28PSZmk,
  VRCP28PSZmkz,
  VRCP28PSZr,
  VRCP28PSZrb,
  VRCP28PSZrbk,
  VRCP28PSZrbkz,
  VRCP28PSZrk,
  VRCP28PSZrkz,
  VRCP28SDZm,
  VRCP28SDZmk,
  VRCP28SDZmkz,
  VRCP28SDZr,
  VRCP28SDZrb,
  VRCP28SDZrbk,
  VRCP28SDZrbkz,
  VRCP28SDZrk,
  VRCP28SDZrkz,
  VRCP28SSZm,
  VRCP28SSZmk,
  VRCP28SSZmkz,
  VRCP28SSZr,
  VRCP28SSZrb,
  VRCP28SSZrbk,
  VRCP28SSZrbkz,
  VRCP28SSZrk,
  VRCP28SSZrkz,
  VRCPBF16Z128m,
  VRCPBF16Z128mb,
  VRCPBF16Z128mbk,
  VRCPBF16Z128mbkz,
  VRCPBF16Z128mk,
  VRCPBF16Z128mkz,
  VRCPBF16Z128r,
  VRCPBF16Z128rk,
  VRCPBF16Z128rkz,
  VRCPBF16Z256m,
  VRCPBF16Z256mb,
  VRCPBF16Z256mbk,
  VRCPBF16Z256mbkz,
  VRCPBF16Z256mk,
  VRCPBF16Z256mkz,
  VRCPBF16Z256r,
  VRCPBF16Z256rk,
  VRCPBF16Z256rkz,
  VRCPBF16Zm,
  VRCPBF16Zmb,
  VRCPBF16Zmbk,
  VRCPBF16Zmbkz,
  VRCPBF16Zmk,
  VRCPBF16Zmkz,
  VRCPBF16Zr,
  VRCPBF16Zrk,
  VRCPBF16Zrkz,
  VRCPPHZ128m,
  VRCPPHZ128mb,
  VRCPPHZ128mbk,
  VRCPPHZ128mbkz,
  VRCPPHZ128mk,
  VRCPPHZ128mkz,
  VRCPPHZ128r,
  VRCPPHZ128rk,
  VRCPPHZ128rkz,
  VRCPPHZ256m,
  VRCPPHZ256mb,
  VRCPPHZ256mbk,
  VRCPPHZ256mbkz,
  VRCPPHZ256mk,
  VRCPPHZ256mkz,
  VRCPPHZ256r,
  VRCPPHZ256rk,
  VRCPPHZ256rkz,
  VRCPPHZm,
  VRCPPHZmb,
  VRCPPHZmbk,
  VRCPPHZmbkz,
  VRCPPHZmk,
  VRCPPHZmkz,
  VRCPPHZr,
  VRCPPHZrk,
  VRCPPHZrkz,
  VRCPPSYm,
  VRCPPSYr,
  VRCPPSm,
  VRCPPSr,
  VRCPSHZrm,
  VRCPSHZrmk,
  VRCPSHZrmkz,
  VRCPSHZrr,
  VRCPSHZrrk,
  VRCPSHZrrkz,
  VRCPSSm,
  VRCPSSm_Int,
  VRCPSSr,
  VRCPSSr_Int,
  VREDUCEBF16Z128rmbi,
  VREDUCEBF16Z128rmbik,
  VREDUCEBF16Z128rmbikz,
  VREDUCEBF16Z128rmi,
  VREDUCEBF16Z128rmik,
  VREDUCEBF16Z128rmikz,
  VREDUCEBF16Z128rri,
  VREDUCEBF16Z128rrik,
  VREDUCEBF16Z128rrikz,
  VREDUCEBF16Z256rmbi,
  VREDUCEBF16Z256rmbik,
  VREDUCEBF16Z256rmbikz,
  VREDUCEBF16Z256rmi,
  VREDUCEBF16Z256rmik,
  VREDUCEBF16Z256rmikz,
  VREDUCEBF16Z256rri,
  VREDUCEBF16Z256rrik,
  VREDUCEBF16Z256rrikz,
  VREDUCEBF16Zrmbi,
  VREDUCEBF16Zrmbik,
  VREDUCEBF16Zrmbikz,
  VREDUCEBF16Zrmi,
  VREDUCEBF16Zrmik,
  VREDUCEBF16Zrmikz,
  VREDUCEBF16Zrri,
  VREDUCEBF16Zrrik,
  VREDUCEBF16Zrrikz,
  VREDUCEPDZ128rmbi,
  VREDUCEPDZ128rmbik,
  VREDUCEPDZ128rmbikz,
  VREDUCEPDZ128rmi,
  VREDUCEPDZ128rmik,
  VREDUCEPDZ128rmikz,
  VREDUCEPDZ128rri,
  VREDUCEPDZ128rrik,
  VREDUCEPDZ128rrikz,
  VREDUCEPDZ256rmbi,
  VREDUCEPDZ256rmbik,
  VREDUCEPDZ256rmbikz,
  VREDUCEPDZ256rmi,
  VREDUCEPDZ256rmik,
  VREDUCEPDZ256rmikz,
  VREDUCEPDZ256rri,
  VREDUCEPDZ256rrik,
  VREDUCEPDZ256rrikz,
  VREDUCEPDZrmbi,
  VREDUCEPDZrmbik,
  VREDUCEPDZrmbikz,
  VREDUCEPDZrmi,
  VREDUCEPDZrmik,
  VREDUCEPDZrmikz,
  VREDUCEPDZrri,
  VREDUCEPDZrrib,
  VREDUCEPDZrribk,
  VREDUCEPDZrribkz,
  VREDUCEPDZrrik,
  VREDUCEPDZrrikz,
  VREDUCEPHZ128rmbi,
  VREDUCEPHZ128rmbik,
  VREDUCEPHZ128rmbikz,
  VREDUCEPHZ128rmi,
  VREDUCEPHZ128rmik,
  VREDUCEPHZ128rmikz,
  VREDUCEPHZ128rri,
  VREDUCEPHZ128rrik,
  VREDUCEPHZ128rrikz,
  VREDUCEPHZ256rmbi,
  VREDUCEPHZ256rmbik,
  VREDUCEPHZ256rmbikz,
  VREDUCEPHZ256rmi,
  VREDUCEPHZ256rmik,
  VREDUCEPHZ256rmikz,
  VREDUCEPHZ256rri,
  VREDUCEPHZ256rrik,
  VREDUCEPHZ256rrikz,
  VREDUCEPHZrmbi,
  VREDUCEPHZrmbik,
  VREDUCEPHZrmbikz,
  VREDUCEPHZrmi,
  VREDUCEPHZrmik,
  VREDUCEPHZrmikz,
  VREDUCEPHZrri,
  VREDUCEPHZrrib,
  VREDUCEPHZrribk,
  VREDUCEPHZrribkz,
  VREDUCEPHZrrik,
  VREDUCEPHZrrikz,
  VREDUCEPSZ128rmbi,
  VREDUCEPSZ128rmbik,
  VREDUCEPSZ128rmbikz,
  VREDUCEPSZ128rmi,
  VREDUCEPSZ128rmik,
  VREDUCEPSZ128rmikz,
  VREDUCEPSZ128rri,
  VREDUCEPSZ128rrik,
  VREDUCEPSZ128rrikz,
  VREDUCEPSZ256rmbi,
  VREDUCEPSZ256rmbik,
  VREDUCEPSZ256rmbikz,
  VREDUCEPSZ256rmi,
  VREDUCEPSZ256rmik,
  VREDUCEPSZ256rmikz,
  VREDUCEPSZ256rri,
  VREDUCEPSZ256rrik,
  VREDUCEPSZ256rrikz,
  VREDUCEPSZrmbi,
  VREDUCEPSZrmbik,
  VREDUCEPSZrmbikz,
  VREDUCEPSZrmi,
  VREDUCEPSZrmik,
  VREDUCEPSZrmikz,
  VREDUCEPSZrri,
  VREDUCEPSZrrib,
  VREDUCEPSZrribk,
  VREDUCEPSZrribkz,
  VREDUCEPSZrrik,
  VREDUCEPSZrrikz,
  VREDUCESDZrmi,
  VREDUCESDZrmik,
  VREDUCESDZrmikz,
  VREDUCESDZrri,
  VREDUCESDZrrib,
  VREDUCESDZrribk,
  VREDUCESDZrribkz,
  VREDUCESDZrrik,
  VREDUCESDZrrikz,
  VREDUCESHZrmi,
  VREDUCESHZrmik,
  VREDUCESHZrmikz,
  VREDUCESHZrri,
  VREDUCESHZrrib,
  VREDUCESHZrribk,
  VREDUCESHZrribkz,
  VREDUCESHZrrik,
  VREDUCESHZrrikz,
  VREDUCESSZrmi,
  VREDUCESSZrmik,
  VREDUCESSZrmikz,
  VREDUCESSZrri,
  VREDUCESSZrrib,
  VREDUCESSZrribk,
  VREDUCESSZrribkz,
  VREDUCESSZrrik,
  VREDUCESSZrrikz,
  VRNDSCALEBF16Z128rmbi,
  VRNDSCALEBF16Z128rmbik,
  VRNDSCALEBF16Z128rmbikz,
  VRNDSCALEBF16Z128rmi,
  VRNDSCALEBF16Z128rmik,
  VRNDSCALEBF16Z128rmikz,
  VRNDSCALEBF16Z128rri,
  VRNDSCALEBF16Z128rrik,
  VRNDSCALEBF16Z128rrikz,
  VRNDSCALEBF16Z256rmbi,
  VRNDSCALEBF16Z256rmbik,
  VRNDSCALEBF16Z256rmbikz,
  VRNDSCALEBF16Z256rmi,
  VRNDSCALEBF16Z256rmik,
  VRNDSCALEBF16Z256rmikz,
  VRNDSCALEBF16Z256rri,
  VRNDSCALEBF16Z256rrik,
  VRNDSCALEBF16Z256rrikz,
  VRNDSCALEBF16Zrmbi,
  VRNDSCALEBF16Zrmbik,
  VRNDSCALEBF16Zrmbikz,
  VRNDSCALEBF16Zrmi,
  VRNDSCALEBF16Zrmik,
  VRNDSCALEBF16Zrmikz,
  VRNDSCALEBF16Zrri,
  VRNDSCALEBF16Zrrik,
  VRNDSCALEBF16Zrrikz,
  VRNDSCALEPDZ128rmbi,
  VRNDSCALEPDZ128rmbik,
  VRNDSCALEPDZ128rmbikz,
  VRNDSCALEPDZ128rmi,
  VRNDSCALEPDZ128rmik,
  VRNDSCALEPDZ128rmikz,
  VRNDSCALEPDZ128rri,
  VRNDSCALEPDZ128rrik,
  VRNDSCALEPDZ128rrikz,
  VRNDSCALEPDZ256rmbi,
  VRNDSCALEPDZ256rmbik,
  VRNDSCALEPDZ256rmbikz,
  VRNDSCALEPDZ256rmi,
  VRNDSCALEPDZ256rmik,
  VRNDSCALEPDZ256rmikz,
  VRNDSCALEPDZ256rri,
  VRNDSCALEPDZ256rrik,
  VRNDSCALEPDZ256rrikz,
  VRNDSCALEPDZrmbi,
  VRNDSCALEPDZrmbik,
  VRNDSCALEPDZrmbikz,
  VRNDSCALEPDZrmi,
  VRNDSCALEPDZrmik,
  VRNDSCALEPDZrmikz,
  VRNDSCALEPDZrri,
  VRNDSCALEPDZrrib,
  VRNDSCALEPDZrribk,
  VRNDSCALEPDZrribkz,
  VRNDSCALEPDZrrik,
  VRNDSCALEPDZrrikz,
  VRNDSCALEPHZ128rmbi,
  VRNDSCALEPHZ128rmbik,
  VRNDSCALEPHZ128rmbikz,
  VRNDSCALEPHZ128rmi,
  VRNDSCALEPHZ128rmik,
  VRNDSCALEPHZ128rmikz,
  VRNDSCALEPHZ128rri,
  VRNDSCALEPHZ128rrik,
  VRNDSCALEPHZ128rrikz,
  VRNDSCALEPHZ256rmbi,
  VRNDSCALEPHZ256rmbik,
  VRNDSCALEPHZ256rmbikz,
  VRNDSCALEPHZ256rmi,
  VRNDSCALEPHZ256rmik,
  VRNDSCALEPHZ256rmikz,
  VRNDSCALEPHZ256rri,
  VRNDSCALEPHZ256rrik,
  VRNDSCALEPHZ256rrikz,
  VRNDSCALEPHZrmbi,
  VRNDSCALEPHZrmbik,
  VRNDSCALEPHZrmbikz,
  VRNDSCALEPHZrmi,
  VRNDSCALEPHZrmik,
  VRNDSCALEPHZrmikz,
  VRNDSCALEPHZrri,
  VRNDSCALEPHZrrib,
  VRNDSCALEPHZrribk,
  VRNDSCALEPHZrribkz,
  VRNDSCALEPHZrrik,
  VRNDSCALEPHZrrikz,
  VRNDSCALEPSZ128rmbi,
  VRNDSCALEPSZ128rmbik,
  VRNDSCALEPSZ128rmbikz,
  VRNDSCALEPSZ128rmi,
  VRNDSCALEPSZ128rmik,
  VRNDSCALEPSZ128rmikz,
  VRNDSCALEPSZ128rri,
  VRNDSCALEPSZ128rrik,
  VRNDSCALEPSZ128rrikz,
  VRNDSCALEPSZ256rmbi,
  VRNDSCALEPSZ256rmbik,
  VRNDSCALEPSZ256rmbikz,
  VRNDSCALEPSZ256rmi,
  VRNDSCALEPSZ256rmik,
  VRNDSCALEPSZ256rmikz,
  VRNDSCALEPSZ256rri,
  VRNDSCALEPSZ256rrik,
  VRNDSCALEPSZ256rrikz,
  VRNDSCALEPSZrmbi,
  VRNDSCALEPSZrmbik,
  VRNDSCALEPSZrmbikz,
  VRNDSCALEPSZrmi,
  VRNDSCALEPSZrmik,
  VRNDSCALEPSZrmikz,
  VRNDSCALEPSZrri,
  VRNDSCALEPSZrrib,
  VRNDSCALEPSZrribk,
  VRNDSCALEPSZrribkz,
  VRNDSCALEPSZrrik,
  VRNDSCALEPSZrrikz,
  VRNDSCALESDZrmi,
  VRNDSCALESDZrmi_Int,
  VRNDSCALESDZrmik_Int,
  VRNDSCALESDZrmikz_Int,
  VRNDSCALESDZrri,
  VRNDSCALESDZrri_Int,
  VRNDSCALESDZrrib_Int,
  VRNDSCALESDZrribk_Int,
  VRNDSCALESDZrribkz_Int,
  VRNDSCALESDZrrik_Int,
  VRNDSCALESDZrrikz_Int,
  VRNDSCALESHZrmi,
  VRNDSCALESHZrmi_Int,
  VRNDSCALESHZrmik_Int,
  VRNDSCALESHZrmikz_Int,
  VRNDSCALESHZrri,
  VRNDSCALESHZrri_Int,
  VRNDSCALESHZrrib_Int,
  VRNDSCALESHZrribk_Int,
  VRNDSCALESHZrribkz_Int,
  VRNDSCALESHZrrik_Int,
  VRNDSCALESHZrrikz_Int,
  VRNDSCALESSZrmi,
  VRNDSCALESSZrmi_Int,
  VRNDSCALESSZrmik_Int,
  VRNDSCALESSZrmikz_Int,
  VRNDSCALESSZrri,
  VRNDSCALESSZrri_Int,
  VRNDSCALESSZrrib_Int,
  VRNDSCALESSZrribk_Int,
  VRNDSCALESSZrribkz_Int,
  VRNDSCALESSZrrik_Int,
  VRNDSCALESSZrrikz_Int,
  VROUNDPDYmi,
  VROUNDPDYri,
  VROUNDPDmi,
  VROUNDPDri,
  VROUNDPSYmi,
  VROUNDPSYri,
  VROUNDPSmi,
  VROUNDPSri,
  VROUNDSDmi,
  VROUNDSDmi_Int,
  VROUNDSDri,
  VROUNDSDri_Int,
  VROUNDSSmi,
  VROUNDSSmi_Int,
  VROUNDSSri,
  VROUNDSSri_Int,
  VRSQRT14PDZ128m,
  VRSQRT14PDZ128mb,
  VRSQRT14PDZ128mbk,
  VRSQRT14PDZ128mbkz,
  VRSQRT14PDZ128mk,
  VRSQRT14PDZ128mkz,
  VRSQRT14PDZ128r,
  VRSQRT14PDZ128rk,
  VRSQRT14PDZ128rkz,
  VRSQRT14PDZ256m,
  VRSQRT14PDZ256mb,
  VRSQRT14PDZ256mbk,
  VRSQRT14PDZ256mbkz,
  VRSQRT14PDZ256mk,
  VRSQRT14PDZ256mkz,
  VRSQRT14PDZ256r,
  VRSQRT14PDZ256rk,
  VRSQRT14PDZ256rkz,
  VRSQRT14PDZm,
  VRSQRT14PDZmb,
  VRSQRT14PDZmbk,
  VRSQRT14PDZmbkz,
  VRSQRT14PDZmk,
  VRSQRT14PDZmkz,
  VRSQRT14PDZr,
  VRSQRT14PDZrk,
  VRSQRT14PDZrkz,
  VRSQRT14PSZ128m,
  VRSQRT14PSZ128mb,
  VRSQRT14PSZ128mbk,
  VRSQRT14PSZ128mbkz,
  VRSQRT14PSZ128mk,
  VRSQRT14PSZ128mkz,
  VRSQRT14PSZ128r,
  VRSQRT14PSZ128rk,
  VRSQRT14PSZ128rkz,
  VRSQRT14PSZ256m,
  VRSQRT14PSZ256mb,
  VRSQRT14PSZ256mbk,
  VRSQRT14PSZ256mbkz,
  VRSQRT14PSZ256mk,
  VRSQRT14PSZ256mkz,
  VRSQRT14PSZ256r,
  VRSQRT14PSZ256rk,
  VRSQRT14PSZ256rkz,
  VRSQRT14PSZm,
  VRSQRT14PSZmb,
  VRSQRT14PSZmbk,
  VRSQRT14PSZmbkz,
  VRSQRT14PSZmk,
  VRSQRT14PSZmkz,
  VRSQRT14PSZr,
  VRSQRT14PSZrk,
  VRSQRT14PSZrkz,
  VRSQRT14SDZrm,
  VRSQRT14SDZrmk,
  VRSQRT14SDZrmkz,
  VRSQRT14SDZrr,
  VRSQRT14SDZrrk,
  VRSQRT14SDZrrkz,
  VRSQRT14SSZrm,
  VRSQRT14SSZrmk,
  VRSQRT14SSZrmkz,
  VRSQRT14SSZrr,
  VRSQRT14SSZrrk,
  VRSQRT14SSZrrkz,
  VRSQRT28PDZm,
  VRSQRT28PDZmb,
  VRSQRT28PDZmbk,
  VRSQRT28PDZmbkz,
  VRSQRT28PDZmk,
  VRSQRT28PDZmkz,
  VRSQRT28PDZr,
  VRSQRT28PDZrb,
  VRSQRT28PDZrbk,
  VRSQRT28PDZrbkz,
  VRSQRT28PDZrk,
  VRSQRT28PDZrkz,
  VRSQRT28PSZm,
  VRSQRT28PSZmb,
  VRSQRT28PSZmbk,
  VRSQRT28PSZmbkz,
  VRSQRT28PSZmk,
  VRSQRT28PSZmkz,
  VRSQRT28PSZr,
  VRSQRT28PSZrb,
  VRSQRT28PSZrbk,
  VRSQRT28PSZrbkz,
  VRSQRT28PSZrk,
  VRSQRT28PSZrkz,
  VRSQRT28SDZm,
  VRSQRT28SDZmk,
  VRSQRT28SDZmkz,
  VRSQRT28SDZr,
  VRSQRT28SDZrb,
  VRSQRT28SDZrbk,
  VRSQRT28SDZrbkz,
  VRSQRT28SDZrk,
  VRSQRT28SDZrkz,
  VRSQRT28SSZm,
  VRSQRT28SSZmk,
  VRSQRT28SSZmkz,
  VRSQRT28SSZr,
  VRSQRT28SSZrb,
  VRSQRT28SSZrbk,
  VRSQRT28SSZrbkz,
  VRSQRT28SSZrk,
  VRSQRT28SSZrkz,
  VRSQRTBF16Z128m,
  VRSQRTBF16Z128mb,
  VRSQRTBF16Z128mbk,
  VRSQRTBF16Z128mbkz,
  VRSQRTBF16Z128mk,
  VRSQRTBF16Z128mkz,
  VRSQRTBF16Z128r,
  VRSQRTBF16Z128rk,
  VRSQRTBF16Z128rkz,
  VRSQRTBF16Z256m,
  VRSQRTBF16Z256mb,
  VRSQRTBF16Z256mbk,
  VRSQRTBF16Z256mbkz,
  VRSQRTBF16Z256mk,
  VRSQRTBF16Z256mkz,
  VRSQRTBF16Z256r,
  VRSQRTBF16Z256rk,
  VRSQRTBF16Z256rkz,
  VRSQRTBF16Zm,
  VRSQRTBF16Zmb,
  VRSQRTBF16Zmbk,
  VRSQRTBF16Zmbkz,
  VRSQRTBF16Zmk,
  VRSQRTBF16Zmkz,
  VRSQRTBF16Zr,
  VRSQRTBF16Zrk,
  VRSQRTBF16Zrkz,
  VRSQRTPHZ128m,
  VRSQRTPHZ128mb,
  VRSQRTPHZ128mbk,
  VRSQRTPHZ128mbkz,
  VRSQRTPHZ128mk,
  VRSQRTPHZ128mkz,
  VRSQRTPHZ128r,
  VRSQRTPHZ128rk,
  VRSQRTPHZ128rkz,
  VRSQRTPHZ256m,
  VRSQRTPHZ256mb,
  VRSQRTPHZ256mbk,
  VRSQRTPHZ256mbkz,
  VRSQRTPHZ256mk,
  VRSQRTPHZ256mkz,
  VRSQRTPHZ256r,
  VRSQRTPHZ256rk,
  VRSQRTPHZ256rkz,
  VRSQRTPHZm,
  VRSQRTPHZmb,
  VRSQRTPHZmbk,
  VRSQRTPHZmbkz,
  VRSQRTPHZmk,
  VRSQRTPHZmkz,
  VRSQRTPHZr,
  VRSQRTPHZrk,
  VRSQRTPHZrkz,
  VRSQRTPSYm,
  VRSQRTPSYr,
  VRSQRTPSm,
  VRSQRTPSr,
  VRSQRTSHZrm,
  VRSQRTSHZrmk,
  VRSQRTSHZrmkz,
  VRSQRTSHZrr,
  VRSQRTSHZrrk,
  VRSQRTSHZrrkz,
  VRSQRTSSm,
  VRSQRTSSm_Int,
  VRSQRTSSr,
  VRSQRTSSr_Int,
  VSCALEFBF16Z128rm,
  VSCALEFBF16Z128rmb,
  VSCALEFBF16Z128rmbk,
  VSCALEFBF16Z128rmbkz,
  VSCALEFBF16Z128rmk,
  VSCALEFBF16Z128rmkz,
  VSCALEFBF16Z128rr,
  VSCALEFBF16Z128rrk,
  VSCALEFBF16Z128rrkz,
  VSCALEFBF16Z256rm,
  VSCALEFBF16Z256rmb,
  VSCALEFBF16Z256rmbk,
  VSCALEFBF16Z256rmbkz,
  VSCALEFBF16Z256rmk,
  VSCALEFBF16Z256rmkz,
  VSCALEFBF16Z256rr,
  VSCALEFBF16Z256rrk,
  VSCALEFBF16Z256rrkz,
  VSCALEFBF16Zrm,
  VSCALEFBF16Zrmb,
  VSCALEFBF16Zrmbk,
  VSCALEFBF16Zrmbkz,
  VSCALEFBF16Zrmk,
  VSCALEFBF16Zrmkz,
  VSCALEFBF16Zrr,
  VSCALEFBF16Zrrk,
  VSCALEFBF16Zrrkz,
  VSCALEFPDZ128rm,
  VSCALEFPDZ128rmb,
  VSCALEFPDZ128rmbk,
  VSCALEFPDZ128rmbkz,
  VSCALEFPDZ128rmk,
  VSCALEFPDZ128rmkz,
  VSCALEFPDZ128rr,
  VSCALEFPDZ128rrk,
  VSCALEFPDZ128rrkz,
  VSCALEFPDZ256rm,
  VSCALEFPDZ256rmb,
  VSCALEFPDZ256rmbk,
  VSCALEFPDZ256rmbkz,
  VSCALEFPDZ256rmk,
  VSCALEFPDZ256rmkz,
  VSCALEFPDZ256rr,
  VSCALEFPDZ256rrk,
  VSCALEFPDZ256rrkz,
  VSCALEFPDZrm,
  VSCALEFPDZrmb,
  VSCALEFPDZrmbk,
  VSCALEFPDZrmbkz,
  VSCALEFPDZrmk,
  VSCALEFPDZrmkz,
  VSCALEFPDZrr,
  VSCALEFPDZrrb,
  VSCALEFPDZrrbk,
  VSCALEFPDZrrbkz,
  VSCALEFPDZrrk,
  VSCALEFPDZrrkz,
  VSCALEFPHZ128rm,
  VSCALEFPHZ128rmb,
  VSCALEFPHZ128rmbk,
  VSCALEFPHZ128rmbkz,
  VSCALEFPHZ128rmk,
  VSCALEFPHZ128rmkz,
  VSCALEFPHZ128rr,
  VSCALEFPHZ128rrk,
  VSCALEFPHZ128rrkz,
  VSCALEFPHZ256rm,
  VSCALEFPHZ256rmb,
  VSCALEFPHZ256rmbk,
  VSCALEFPHZ256rmbkz,
  VSCALEFPHZ256rmk,
  VSCALEFPHZ256rmkz,
  VSCALEFPHZ256rr,
  VSCALEFPHZ256rrk,
  VSCALEFPHZ256rrkz,
  VSCALEFPHZrm,
  VSCALEFPHZrmb,
  VSCALEFPHZrmbk,
  VSCALEFPHZrmbkz,
  VSCALEFPHZrmk,
  VSCALEFPHZrmkz,
  VSCALEFPHZrr,
  VSCALEFPHZrrb,
  VSCALEFPHZrrbk,
  VSCALEFPHZrrbkz,
  VSCALEFPHZrrk,
  VSCALEFPHZrrkz,
  VSCALEFPSZ128rm,
  VSCALEFPSZ128rmb,
  VSCALEFPSZ128rmbk,
  VSCALEFPSZ128rmbkz,
  VSCALEFPSZ128rmk,
  VSCALEFPSZ128rmkz,
  VSCALEFPSZ128rr,
  VSCALEFPSZ128rrk,
  VSCALEFPSZ128rrkz,
  VSCALEFPSZ256rm,
  VSCALEFPSZ256rmb,
  VSCALEFPSZ256rmbk,
  VSCALEFPSZ256rmbkz,
  VSCALEFPSZ256rmk,
  VSCALEFPSZ256rmkz,
  VSCALEFPSZ256rr,
  VSCALEFPSZ256rrk,
  VSCALEFPSZ256rrkz,
  VSCALEFPSZrm,
  VSCALEFPSZrmb,
  VSCALEFPSZrmbk,
  VSCALEFPSZrmbkz,
  VSCALEFPSZrmk,
  VSCALEFPSZrmkz,
  VSCALEFPSZrr,
  VSCALEFPSZrrb,
  VSCALEFPSZrrbk,
  VSCALEFPSZrrbkz,
  VSCALEFPSZrrk,
  VSCALEFPSZrrkz,
  VSCALEFSDZrm,
  VSCALEFSDZrmk,
  VSCALEFSDZrmkz,
  VSCALEFSDZrr,
  VSCALEFSDZrrb_Int,
  VSCALEFSDZrrbk_Int,
  VSCALEFSDZrrbkz_Int,
  VSCALEFSDZrrk,
  VSCALEFSDZrrkz,
  VSCALEFSHZrm,
  VSCALEFSHZrmk,
  VSCALEFSHZrmkz,
  VSCALEFSHZrr,
  VSCALEFSHZrrb_Int,
  VSCALEFSHZrrbk_Int,
  VSCALEFSHZrrbkz_Int,
  VSCALEFSHZrrk,
  VSCALEFSHZrrkz,
  VSCALEFSSZrm,
  VSCALEFSSZrmk,
  VSCALEFSSZrmkz,
  VSCALEFSSZrr,
  VSCALEFSSZrrb_Int,
  VSCALEFSSZrrbk_Int,
  VSCALEFSSZrrbkz_Int,
  VSCALEFSSZrrk,
  VSCALEFSSZrrkz,
  VSCATTERDPDZ128mr,
  VSCATTERDPDZ256mr,
  VSCATTERDPDZmr,
  VSCATTERDPSZ128mr,
  VSCATTERDPSZ256mr,
  VSCATTERDPSZmr,
  VSCATTERPF0DPDm,
  VSCATTERPF0DPSm,
  VSCATTERPF0QPDm,
  VSCATTERPF0QPSm,
  VSCATTERPF1DPDm,
  VSCATTERPF1DPSm,
  VSCATTERPF1QPDm,
  VSCATTERPF1QPSm,
  VSCATTERQPDZ128mr,
  VSCATTERQPDZ256mr,
  VSCATTERQPDZmr,
  VSCATTERQPSZ128mr,
  VSCATTERQPSZ256mr,
  VSCATTERQPSZmr,
  VSHA512MSG1rr,
  VSHA512MSG2rr,
  VSHA512RNDS2rr,
  VSHUFF32X4Z256rmbi,
  VSHUFF32X4Z256rmbik,
  VSHUFF32X4Z256rmbikz,
  VSHUFF32X4Z256rmi,
  VSHUFF32X4Z256rmik,
  VSHUFF32X4Z256rmikz,
  VSHUFF32X4Z256rri,
  VSHUFF32X4Z256rrik,
  VSHUFF32X4Z256rrikz,
  VSHUFF32X4Zrmbi,
  VSHUFF32X4Zrmbik,
  VSHUFF32X4Zrmbikz,
  VSHUFF32X4Zrmi,
  VSHUFF32X4Zrmik,
  VSHUFF32X4Zrmikz,
  VSHUFF32X4Zrri,
  VSHUFF32X4Zrrik,
  VSHUFF32X4Zrrikz,
  VSHUFF64X2Z256rmbi,
  VSHUFF64X2Z256rmbik,
  VSHUFF64X2Z256rmbikz,
  VSHUFF64X2Z256rmi,
  VSHUFF64X2Z256rmik,
  VSHUFF64X2Z256rmikz,
  VSHUFF64X2Z256rri,
  VSHUFF64X2Z256rrik,
  VSHUFF64X2Z256rrikz,
  VSHUFF64X2Zrmbi,
  VSHUFF64X2Zrmbik,
  VSHUFF64X2Zrmbikz,
  VSHUFF64X2Zrmi,
  VSHUFF64X2Zrmik,
  VSHUFF64X2Zrmikz,
  VSHUFF64X2Zrri,
  VSHUFF64X2Zrrik,
  VSHUFF64X2Zrrikz,
  VSHUFI32X4Z256rmbi,
  VSHUFI32X4Z256rmbik,
  VSHUFI32X4Z256rmbikz,
  VSHUFI32X4Z256rmi,
  VSHUFI32X4Z256rmik,
  VSHUFI32X4Z256rmikz,
  VSHUFI32X4Z256rri,
  VSHUFI32X4Z256rrik,
  VSHUFI32X4Z256rrikz,
  VSHUFI32X4Zrmbi,
  VSHUFI32X4Zrmbik,
  VSHUFI32X4Zrmbikz,
  VSHUFI32X4Zrmi,
  VSHUFI32X4Zrmik,
  VSHUFI32X4Zrmikz,
  VSHUFI32X4Zrri,
  VSHUFI32X4Zrrik,
  VSHUFI32X4Zrrikz,
  VSHUFI64X2Z256rmbi,
  VSHUFI64X2Z256rmbik,
  VSHUFI64X2Z256rmbikz,
  VSHUFI64X2Z256rmi,
  VSHUFI64X2Z256rmik,
  VSHUFI64X2Z256rmikz,
  VSHUFI64X2Z256rri,
  VSHUFI64X2Z256rrik,
  VSHUFI64X2Z256rrikz,
  VSHUFI64X2Zrmbi,
  VSHUFI64X2Zrmbik,
  VSHUFI64X2Zrmbikz,
  VSHUFI64X2Zrmi,
  VSHUFI64X2Zrmik,
  VSHUFI64X2Zrmikz,
  VSHUFI64X2Zrri,
  VSHUFI64X2Zrrik,
  VSHUFI64X2Zrrikz,
  VSHUFPDYrmi,
  VSHUFPDYrri,
  VSHUFPDZ128rmbi,
  VSHUFPDZ128rmbik,
  VSHUFPDZ128rmbikz,
  VSHUFPDZ128rmi,
  VSHUFPDZ128rmik,
  VSHUFPDZ128rmikz,
  VSHUFPDZ128rri,
  VSHUFPDZ128rrik,
  VSHUFPDZ128rrikz,
  VSHUFPDZ256rmbi,
  VSHUFPDZ256rmbik,
  VSHUFPDZ256rmbikz,
  VSHUFPDZ256rmi,
  VSHUFPDZ256rmik,
  VSHUFPDZ256rmikz,
  VSHUFPDZ256rri,
  VSHUFPDZ256rrik,
  VSHUFPDZ256rrikz,
  VSHUFPDZrmbi,
  VSHUFPDZrmbik,
  VSHUFPDZrmbikz,
  VSHUFPDZrmi,
  VSHUFPDZrmik,
  VSHUFPDZrmikz,
  VSHUFPDZrri,
  VSHUFPDZrrik,
  VSHUFPDZrrikz,
  VSHUFPDrmi,
  VSHUFPDrri,
  VSHUFPSYrmi,
  VSHUFPSYrri,
  VSHUFPSZ128rmbi,
  VSHUFPSZ128rmbik,
  VSHUFPSZ128rmbikz,
  VSHUFPSZ128rmi,
  VSHUFPSZ128rmik,
  VSHUFPSZ128rmikz,
  VSHUFPSZ128rri,
  VSHUFPSZ128rrik,
  VSHUFPSZ128rrikz,
  VSHUFPSZ256rmbi,
  VSHUFPSZ256rmbik,
  VSHUFPSZ256rmbikz,
  VSHUFPSZ256rmi,
  VSHUFPSZ256rmik,
  VSHUFPSZ256rmikz,
  VSHUFPSZ256rri,
  VSHUFPSZ256rrik,
  VSHUFPSZ256rrikz,
  VSHUFPSZrmbi,
  VSHUFPSZrmbik,
  VSHUFPSZrmbikz,
  VSHUFPSZrmi,
  VSHUFPSZrmik,
  VSHUFPSZrmikz,
  VSHUFPSZrri,
  VSHUFPSZrrik,
  VSHUFPSZrrikz,
  VSHUFPSrmi,
  VSHUFPSrri,
  VSM3MSG1rm,
  VSM3MSG1rr,
  VSM3MSG2rm,
  VSM3MSG2rr,
  VSM3RNDS2rmi,
  VSM3RNDS2rri,
  VSM4KEY4Yrm,
  VSM4KEY4Yrr,
  VSM4KEY4Z128rm,
  VSM4KEY4Z128rr,
  VSM4KEY4Z256rm,
  VSM4KEY4Z256rr,
  VSM4KEY4Zrm,
  VSM4KEY4Zrr,
  VSM4KEY4rm,
  VSM4KEY4rr,
  VSM4RNDS4Yrm,
  VSM4RNDS4Yrr,
  VSM4RNDS4Z128rm,
  VSM4RNDS4Z128rr,
  VSM4RNDS4Z256rm,
  VSM4RNDS4Z256rr,
  VSM4RNDS4Zrm,
  VSM4RNDS4Zrr,
  VSM4RNDS4rm,
  VSM4RNDS4rr,
  VSQRTBF16Z128m,
  VSQRTBF16Z128mb,
  VSQRTBF16Z128mbk,
  VSQRTBF16Z128mbkz,
  VSQRTBF16Z128mk,
  VSQRTBF16Z128mkz,
  VSQRTBF16Z128r,
  VSQRTBF16Z128rk,
  VSQRTBF16Z128rkz,
  VSQRTBF16Z256m,
  VSQRTBF16Z256mb,
  VSQRTBF16Z256mbk,
  VSQRTBF16Z256mbkz,
  VSQRTBF16Z256mk,
  VSQRTBF16Z256mkz,
  VSQRTBF16Z256r,
  VSQRTBF16Z256rk,
  VSQRTBF16Z256rkz,
  VSQRTBF16Zm,
  VSQRTBF16Zmb,
  VSQRTBF16Zmbk,
  VSQRTBF16Zmbkz,
  VSQRTBF16Zmk,
  VSQRTBF16Zmkz,
  VSQRTBF16Zr,
  VSQRTBF16Zrk,
  VSQRTBF16Zrkz,
  VSQRTPDYm,
  VSQRTPDYr,
  VSQRTPDZ128m,
  VSQRTPDZ128mb,
  VSQRTPDZ128mbk,
  VSQRTPDZ128mbkz,
  VSQRTPDZ128mk,
  VSQRTPDZ128mkz,
  VSQRTPDZ128r,
  VSQRTPDZ128rk,
  VSQRTPDZ128rkz,
  VSQRTPDZ256m,
  VSQRTPDZ256mb,
  VSQRTPDZ256mbk,
  VSQRTPDZ256mbkz,
  VSQRTPDZ256mk,
  VSQRTPDZ256mkz,
  VSQRTPDZ256r,
  VSQRTPDZ256rk,
  VSQRTPDZ256rkz,
  VSQRTPDZm,
  VSQRTPDZmb,
  VSQRTPDZmbk,
  VSQRTPDZmbkz,
  VSQRTPDZmk,
  VSQRTPDZmkz,
  VSQRTPDZr,
  VSQRTPDZrb,
  VSQRTPDZrbk,
  VSQRTPDZrbkz,
  VSQRTPDZrk,
  VSQRTPDZrkz,
  VSQRTPDm,
  VSQRTPDr,
  VSQRTPHZ128m,
  VSQRTPHZ128mb,
  VSQRTPHZ128mbk,
  VSQRTPHZ128mbkz,
  VSQRTPHZ128mk,
  VSQRTPHZ128mkz,
  VSQRTPHZ128r,
  VSQRTPHZ128rk,
  VSQRTPHZ128rkz,
  VSQRTPHZ256m,
  VSQRTPHZ256mb,
  VSQRTPHZ256mbk,
  VSQRTPHZ256mbkz,
  VSQRTPHZ256mk,
  VSQRTPHZ256mkz,
  VSQRTPHZ256r,
  VSQRTPHZ256rk,
  VSQRTPHZ256rkz,
  VSQRTPHZm,
  VSQRTPHZmb,
  VSQRTPHZmbk,
  VSQRTPHZmbkz,
  VSQRTPHZmk,
  VSQRTPHZmkz,
  VSQRTPHZr,
  VSQRTPHZrb,
  VSQRTPHZrbk,
  VSQRTPHZrbkz,
  VSQRTPHZrk,
  VSQRTPHZrkz,
  VSQRTPSYm,
  VSQRTPSYr,
  VSQRTPSZ128m,
  VSQRTPSZ128mb,
  VSQRTPSZ128mbk,
  VSQRTPSZ128mbkz,
  VSQRTPSZ128mk,
  VSQRTPSZ128mkz,
  VSQRTPSZ128r,
  VSQRTPSZ128rk,
  VSQRTPSZ128rkz,
  VSQRTPSZ256m,
  VSQRTPSZ256mb,
  VSQRTPSZ256mbk,
  VSQRTPSZ256mbkz,
  VSQRTPSZ256mk,
  VSQRTPSZ256mkz,
  VSQRTPSZ256r,
  VSQRTPSZ256rk,
  VSQRTPSZ256rkz,
  VSQRTPSZm,
  VSQRTPSZmb,
  VSQRTPSZmbk,
  VSQRTPSZmbkz,
  VSQRTPSZmk,
  VSQRTPSZmkz,
  VSQRTPSZr,
  VSQRTPSZrb,
  VSQRTPSZrbk,
  VSQRTPSZrbkz,
  VSQRTPSZrk,
  VSQRTPSZrkz,
  VSQRTPSm,
  VSQRTPSr,
  VSQRTSDZm,
  VSQRTSDZm_Int,
  VSQRTSDZmk_Int,
  VSQRTSDZmkz_Int,
  VSQRTSDZr,
  VSQRTSDZr_Int,
  VSQRTSDZrb_Int,
  VSQRTSDZrbk_Int,
  VSQRTSDZrbkz_Int,
  VSQRTSDZrk_Int,
  VSQRTSDZrkz_Int,
  VSQRTSDm,
  VSQRTSDm_Int,
  VSQRTSDr,
  VSQRTSDr_Int,
  VSQRTSHZm,
  VSQRTSHZm_Int,
  VSQRTSHZmk_Int,
  VSQRTSHZmkz_Int,
  VSQRTSHZr,
  VSQRTSHZr_Int,
  VSQRTSHZrb_Int,
  VSQRTSHZrbk_Int,
  VSQRTSHZrbkz_Int,
  VSQRTSHZrk_Int,
  VSQRTSHZrkz_Int,
  VSQRTSSZm,
  VSQRTSSZm_Int,
  VSQRTSSZmk_Int,
  VSQRTSSZmkz_Int,
  VSQRTSSZr,
  VSQRTSSZr_Int,
  VSQRTSSZrb_Int,
  VSQRTSSZrbk_Int,
  VSQRTSSZrbkz_Int,
  VSQRTSSZrk_Int,
  VSQRTSSZrkz_Int,
  VSQRTSSm,
  VSQRTSSm_Int,
  VSQRTSSr,
  VSQRTSSr_Int,
  VSTMXCSR,
  VSUBBF16Z128rm,
  VSUBBF16Z128rmb,
  VSUBBF16Z128rmbk,
  VSUBBF16Z128rmbkz,
  VSUBBF16Z128rmk,
  VSUBBF16Z128rmkz,
  VSUBBF16Z128rr,
  VSUBBF16Z128rrk,
  VSUBBF16Z128rrkz,
  VSUBBF16Z256rm,
  VSUBBF16Z256rmb,
  VSUBBF16Z256rmbk,
  VSUBBF16Z256rmbkz,
  VSUBBF16Z256rmk,
  VSUBBF16Z256rmkz,
  VSUBBF16Z256rr,
  VSUBBF16Z256rrk,
  VSUBBF16Z256rrkz,
  VSUBBF16Zrm,
  VSUBBF16Zrmb,
  VSUBBF16Zrmbk,
  VSUBBF16Zrmbkz,
  VSUBBF16Zrmk,
  VSUBBF16Zrmkz,
  VSUBBF16Zrr,
  VSUBBF16Zrrk,
  VSUBBF16Zrrkz,
  VSUBPDYrm,
  VSUBPDYrr,
  VSUBPDZ128rm,
  VSUBPDZ128rmb,
  VSUBPDZ128rmbk,
  VSUBPDZ128rmbkz,
  VSUBPDZ128rmk,
  VSUBPDZ128rmkz,
  VSUBPDZ128rr,
  VSUBPDZ128rrk,
  VSUBPDZ128rrkz,
  VSUBPDZ256rm,
  VSUBPDZ256rmb,
  VSUBPDZ256rmbk,
  VSUBPDZ256rmbkz,
  VSUBPDZ256rmk,
  VSUBPDZ256rmkz,
  VSUBPDZ256rr,
  VSUBPDZ256rrk,
  VSUBPDZ256rrkz,
  VSUBPDZrm,
  VSUBPDZrmb,
  VSUBPDZrmbk,
  VSUBPDZrmbkz,
  VSUBPDZrmk,
  VSUBPDZrmkz,
  VSUBPDZrr,
  VSUBPDZrrb,
  VSUBPDZrrbk,
  VSUBPDZrrbkz,
  VSUBPDZrrk,
  VSUBPDZrrkz,
  VSUBPDrm,
  VSUBPDrr,
  VSUBPHZ128rm,
  VSUBPHZ128rmb,
  VSUBPHZ128rmbk,
  VSUBPHZ128rmbkz,
  VSUBPHZ128rmk,
  VSUBPHZ128rmkz,
  VSUBPHZ128rr,
  VSUBPHZ128rrk,
  VSUBPHZ128rrkz,
  VSUBPHZ256rm,
  VSUBPHZ256rmb,
  VSUBPHZ256rmbk,
  VSUBPHZ256rmbkz,
  VSUBPHZ256rmk,
  VSUBPHZ256rmkz,
  VSUBPHZ256rr,
  VSUBPHZ256rrk,
  VSUBPHZ256rrkz,
  VSUBPHZrm,
  VSUBPHZrmb,
  VSUBPHZrmbk,
  VSUBPHZrmbkz,
  VSUBPHZrmk,
  VSUBPHZrmkz,
  VSUBPHZrr,
  VSUBPHZrrb,
  VSUBPHZrrbk,
  VSUBPHZrrbkz,
  VSUBPHZrrk,
  VSUBPHZrrkz,
  VSUBPSYrm,
  VSUBPSYrr,
  VSUBPSZ128rm,
  VSUBPSZ128rmb,
  VSUBPSZ128rmbk,
  VSUBPSZ128rmbkz,
  VSUBPSZ128rmk,
  VSUBPSZ128rmkz,
  VSUBPSZ128rr,
  VSUBPSZ128rrk,
  VSUBPSZ128rrkz,
  VSUBPSZ256rm,
  VSUBPSZ256rmb,
  VSUBPSZ256rmbk,
  VSUBPSZ256rmbkz,
  VSUBPSZ256rmk,
  VSUBPSZ256rmkz,
  VSUBPSZ256rr,
  VSUBPSZ256rrk,
  VSUBPSZ256rrkz,
  VSUBPSZrm,
  VSUBPSZrmb,
  VSUBPSZrmbk,
  VSUBPSZrmbkz,
  VSUBPSZrmk,
  VSUBPSZrmkz,
  VSUBPSZrr,
  VSUBPSZrrb,
  VSUBPSZrrbk,
  VSUBPSZrrbkz,
  VSUBPSZrrk,
  VSUBPSZrrkz,
  VSUBPSrm,
  VSUBPSrr,
  VSUBSDZrm,
  VSUBSDZrm_Int,
  VSUBSDZrmk_Int,
  VSUBSDZrmkz_Int,
  VSUBSDZrr,
  VSUBSDZrr_Int,
  VSUBSDZrrb_Int,
  VSUBSDZrrbk_Int,
  VSUBSDZrrbkz_Int,
  VSUBSDZrrk_Int,
  VSUBSDZrrkz_Int,
  VSUBSDrm,
  VSUBSDrm_Int,
  VSUBSDrr,
  VSUBSDrr_Int,
  VSUBSHZrm,
  VSUBSHZrm_Int,
  VSUBSHZrmk_Int,
  VSUBSHZrmkz_Int,
  VSUBSHZrr,
  VSUBSHZrr_Int,
  VSUBSHZrrb_Int,
  VSUBSHZrrbk_Int,
  VSUBSHZrrbkz_Int,
  VSUBSHZrrk_Int,
  VSUBSHZrrkz_Int,
  VSUBSSZrm,
  VSUBSSZrm_Int,
  VSUBSSZrmk_Int,
  VSUBSSZrmkz_Int,
  VSUBSSZrr,
  VSUBSSZrr_Int,
  VSUBSSZrrb_Int,
  VSUBSSZrrbk_Int,
  VSUBSSZrrbkz_Int,
  VSUBSSZrrk_Int,
  VSUBSSZrrkz_Int,
  VSUBSSrm,
  VSUBSSrm_Int,
  VSUBSSrr,
  VSUBSSrr_Int,
  VTESTPDYrm,
  VTESTPDYrr,
  VTESTPDrm,
  VTESTPDrr,
  VTESTPSYrm,
  VTESTPSYrr,
  VTESTPSrm,
  VTESTPSrr,
  VUCOMISDZrm,
  VUCOMISDZrm_Int,
  VUCOMISDZrr,
  VUCOMISDZrr_Int,
  VUCOMISDZrrb,
  VUCOMISDrm,
  VUCOMISDrm_Int,
  VUCOMISDrr,
  VUCOMISDrr_Int,
  VUCOMISHZrm,
  VUCOMISHZrm_Int,
  VUCOMISHZrr,
  VUCOMISHZrr_Int,
  VUCOMISHZrrb,
  VUCOMISSZrm,
  VUCOMISSZrm_Int,
  VUCOMISSZrr,
  VUCOMISSZrr_Int,
  VUCOMISSZrrb,
  VUCOMISSrm,
  VUCOMISSrm_Int,
  VUCOMISSrr,
  VUCOMISSrr_Int,
  VUCOMXSDZrm,
  VUCOMXSDZrm_Int,
  VUCOMXSDZrr,
  VUCOMXSDZrr_Int,
  VUCOMXSDZrrb_Int,
  VUCOMXSHZrm,
  VUCOMXSHZrm_Int,
  VUCOMXSHZrr,
  VUCOMXSHZrr_Int,
  VUCOMXSHZrrb_Int,
  VUCOMXSSZrm,
  VUCOMXSSZrm_Int,
  VUCOMXSSZrr,
  VUCOMXSSZrr_Int,
  VUCOMXSSZrrb_Int,
  VUNPCKHPDYrm,
  VUNPCKHPDYrr,
  VUNPCKHPDZ128rm,
  VUNPCKHPDZ128rmb,
  VUNPCKHPDZ128rmbk,
  VUNPCKHPDZ128rmbkz,
  VUNPCKHPDZ128rmk,
  VUNPCKHPDZ128rmkz,
  VUNPCKHPDZ128rr,
  VUNPCKHPDZ128rrk,
  VUNPCKHPDZ128rrkz,
  VUNPCKHPDZ256rm,
  VUNPCKHPDZ256rmb,
  VUNPCKHPDZ256rmbk,
  VUNPCKHPDZ256rmbkz,
  VUNPCKHPDZ256rmk,
  VUNPCKHPDZ256rmkz,
  VUNPCKHPDZ256rr,
  VUNPCKHPDZ256rrk,
  VUNPCKHPDZ256rrkz,
  VUNPCKHPDZrm,
  VUNPCKHPDZrmb,
  VUNPCKHPDZrmbk,
  VUNPCKHPDZrmbkz,
  VUNPCKHPDZrmk,
  VUNPCKHPDZrmkz,
  VUNPCKHPDZrr,
  VUNPCKHPDZrrk,
  VUNPCKHPDZrrkz,
  VUNPCKHPDrm,
  VUNPCKHPDrr,
  VUNPCKHPSYrm,
  VUNPCKHPSYrr,
  VUNPCKHPSZ128rm,
  VUNPCKHPSZ128rmb,
  VUNPCKHPSZ128rmbk,
  VUNPCKHPSZ128rmbkz,
  VUNPCKHPSZ128rmk,
  VUNPCKHPSZ128rmkz,
  VUNPCKHPSZ128rr,
  VUNPCKHPSZ128rrk,
  VUNPCKHPSZ128rrkz,
  VUNPCKHPSZ256rm,
  VUNPCKHPSZ256rmb,
  VUNPCKHPSZ256rmbk,
  VUNPCKHPSZ256rmbkz,
  VUNPCKHPSZ256rmk,
  VUNPCKHPSZ256rmkz,
  VUNPCKHPSZ256rr,
  VUNPCKHPSZ256rrk,
  VUNPCKHPSZ256rrkz,
  VUNPCKHPSZrm,
  VUNPCKHPSZrmb,
  VUNPCKHPSZrmbk,
  VUNPCKHPSZrmbkz,
  VUNPCKHPSZrmk,
  VUNPCKHPSZrmkz,
  VUNPCKHPSZrr,
  VUNPCKHPSZrrk,
  VUNPCKHPSZrrkz,
  VUNPCKHPSrm,
  VUNPCKHPSrr,
  VUNPCKLPDYrm,
  VUNPCKLPDYrr,
  VUNPCKLPDZ128rm,
  VUNPCKLPDZ128rmb,
  VUNPCKLPDZ128rmbk,
  VUNPCKLPDZ128rmbkz,
  VUNPCKLPDZ128rmk,
  VUNPCKLPDZ128rmkz,
  VUNPCKLPDZ128rr,
  VUNPCKLPDZ128rrk,
  VUNPCKLPDZ128rrkz,
  VUNPCKLPDZ256rm,
  VUNPCKLPDZ256rmb,
  VUNPCKLPDZ256rmbk,
  VUNPCKLPDZ256rmbkz,
  VUNPCKLPDZ256rmk,
  VUNPCKLPDZ256rmkz,
  VUNPCKLPDZ256rr,
  VUNPCKLPDZ256rrk,
  VUNPCKLPDZ256rrkz,
  VUNPCKLPDZrm,
  VUNPCKLPDZrmb,
  VUNPCKLPDZrmbk,
  VUNPCKLPDZrmbkz,
  VUNPCKLPDZrmk,
  VUNPCKLPDZrmkz,
  VUNPCKLPDZrr,
  VUNPCKLPDZrrk,
  VUNPCKLPDZrrkz,
  VUNPCKLPDrm,
  VUNPCKLPDrr,
  VUNPCKLPSYrm,
  VUNPCKLPSYrr,
  VUNPCKLPSZ128rm,
  VUNPCKLPSZ128rmb,
  VUNPCKLPSZ128rmbk,
  VUNPCKLPSZ128rmbkz,
  VUNPCKLPSZ128rmk,
  VUNPCKLPSZ128rmkz,
  VUNPCKLPSZ128rr,
  VUNPCKLPSZ128rrk,
  VUNPCKLPSZ128rrkz,
  VUNPCKLPSZ256rm,
  VUNPCKLPSZ256rmb,
  VUNPCKLPSZ256rmbk,
  VUNPCKLPSZ256rmbkz,
  VUNPCKLPSZ256rmk,
  VUNPCKLPSZ256rmkz,
  VUNPCKLPSZ256rr,
  VUNPCKLPSZ256rrk,
  VUNPCKLPSZ256rrkz,
  VUNPCKLPSZrm,
  VUNPCKLPSZrmb,
  VUNPCKLPSZrmbk,
  VUNPCKLPSZrmbkz,
  VUNPCKLPSZrmk,
  VUNPCKLPSZrmkz,
  VUNPCKLPSZrr,
  VUNPCKLPSZrrk,
  VUNPCKLPSZrrkz,
  VUNPCKLPSrm,
  VUNPCKLPSrr,
  VXORPDYrm,
  VXORPDYrr,
  VXORPDZ128rm,
  VXORPDZ128rmb,
  VXORPDZ128rmbk,
  VXORPDZ128rmbkz,
  VXORPDZ128rmk,
  VXORPDZ128rmkz,
  VXORPDZ128rr,
  VXORPDZ128rrk,
  VXORPDZ128rrkz,
  VXORPDZ256rm,
  VXORPDZ256rmb,
  VXORPDZ256rmbk,
  VXORPDZ256rmbkz,
  VXORPDZ256rmk,
  VXORPDZ256rmkz,
  VXORPDZ256rr,
  VXORPDZ256rrk,
  VXORPDZ256rrkz,
  VXORPDZrm,
  VXORPDZrmb,
  VXORPDZrmbk,
  VXORPDZrmbkz,
  VXORPDZrmk,
  VXORPDZrmkz,
  VXORPDZrr,
  VXORPDZrrk,
  VXORPDZrrkz,
  VXORPDrm,
  VXORPDrr,
  VXORPSYrm,
  VXORPSYrr,
  VXORPSZ128rm,
  VXORPSZ128rmb,
  VXORPSZ128rmbk,
  VXORPSZ128rmbkz,
  VXORPSZ128rmk,
  VXORPSZ128rmkz,
  VXORPSZ128rr,
  VXORPSZ128rrk,
  VXORPSZ128rrkz,
  VXORPSZ256rm,
  VXORPSZ256rmb,
  VXORPSZ256rmbk,
  VXORPSZ256rmbkz,
  VXORPSZ256rmk,
  VXORPSZ256rmkz,
  VXORPSZ256rr,
  VXORPSZ256rrk,
  VXORPSZ256rrkz,
  VXORPSZrm,
  VXORPSZrmb,
  VXORPSZrmbk,
  VXORPSZrmbkz,
  VXORPSZrmk,
  VXORPSZrmkz,
  VXORPSZrr,
  VXORPSZrrk,
  VXORPSZrrkz,
  VXORPSrm,
  VXORPSrr,
  VZEROALL,
  VZEROUPPER,
  WAIT,
  WBINVD,
  WBNOINVD,
  WRFSBASE,
  WRFSBASE64,
  WRGSBASE,
  WRGSBASE64,
  WRMSR,
  WRMSRLIST,
  WRMSRNS,
  WRMSRNSir,
  WRMSRNSir_EVEX,
  WRPKRUr,
  WRSSD,
  WRSSD_EVEX,
  WRSSQ,
  WRSSQ_EVEX,
  WRUSSD,
  WRUSSD_EVEX,
  WRUSSQ,
  WRUSSQ_EVEX,
  XABORT,
  XACQUIRE_PREFIX,
  XADD16rm,
  XADD16rr,
  XADD32rm,
  XADD32rr,
  XADD64rm,
  XADD64rr,
  XADD8rm,
  XADD8rr,
  XAM_F,
  XAM_Fp32,
  XAM_Fp64,
  XAM_Fp80,
  XBEGIN,
  XBEGIN_2,
  XBEGIN_4,
  XCHG16ar,
  XCHG16rm,
  XCHG16rr,
  XCHG32ar,
  XCHG32rm,
  XCHG32rr,
  XCHG64ar,
  XCHG64rm,
  XCHG64rr,
  XCHG8rm,
  XCHG8rr,
  XCH_F,
  XCRYPTCBC,
  XCRYPTCFB,
  XCRYPTCTR,
  XCRYPTECB,
  XCRYPTOFB,
  XEND,
  XGETBV,
  XLAT,
  XOR16i16,
  XOR16mi,
  XOR16mi8,
  XOR16mi8_EVEX,
  XOR16mi8_ND,
  XOR16mi8_NF,
  XOR16mi8_NF_ND,
  XOR16mi_EVEX,
  XOR16mi_ND,
  XOR16mi_NF,
  XOR16mi_NF_ND,
  XOR16mr,
  XOR16mr_EVEX,
  XOR16mr_ND,
  XOR16mr_NF,
  XOR16mr_NF_ND,
  XOR16ri,
  XOR16ri8,
  XOR16ri8_EVEX,
  XOR16ri8_ND,
  XOR16ri8_NF,
  XOR16ri8_NF_ND,
  XOR16ri_EVEX,
  XOR16ri_ND,
  XOR16ri_NF,
  XOR16ri_NF_ND,
  XOR16rm,
  XOR16rm_EVEX,
  XOR16rm_ND,
  XOR16rm_NF,
  XOR16rm_NF_ND,
  XOR16rr,
  XOR16rr_EVEX,
  XOR16rr_EVEX_REV,
  XOR16rr_ND,
  XOR16rr_ND_REV,
  XOR16rr_NF,
  XOR16rr_NF_ND,
  XOR16rr_NF_ND_REV,
  XOR16rr_NF_REV,
  XOR16rr_REV,
  XOR32i32,
  XOR32mi,
  XOR32mi8,
  XOR32mi8_EVEX,
  XOR32mi8_ND,
  XOR32mi8_NF,
  XOR32mi8_NF_ND,
  XOR32mi_EVEX,
  XOR32mi_ND,
  XOR32mi_NF,
  XOR32mi_NF_ND,
  XOR32mr,
  XOR32mr_EVEX,
  XOR32mr_ND,
  XOR32mr_NF,
  XOR32mr_NF_ND,
  XOR32ri,
  XOR32ri8,
  XOR32ri8_EVEX,
  XOR32ri8_ND,
  XOR32ri8_NF,
  XOR32ri8_NF_ND,
  XOR32ri_EVEX,
  XOR32ri_ND,
  XOR32ri_NF,
  XOR32ri_NF_ND,
  XOR32rm,
  XOR32rm_EVEX,
  XOR32rm_ND,
  XOR32rm_NF,
  XOR32rm_NF_ND,
  XOR32rr,
  XOR32rr_EVEX,
  XOR32rr_EVEX_REV,
  XOR32rr_ND,
  XOR32rr_ND_REV,
  XOR32rr_NF,
  XOR32rr_NF_ND,
  XOR32rr_NF_ND_REV,
  XOR32rr_NF_REV,
  XOR32rr_REV,
  XOR64i32,
  XOR64mi32,
  XOR64mi32_EVEX,
  XOR64mi32_ND,
  XOR64mi32_NF,
  XOR64mi32_NF_ND,
  XOR64mi8,
  XOR64mi8_EVEX,
  XOR64mi8_ND,
  XOR64mi8_NF,
  XOR64mi8_NF_ND,
  XOR64mr,
  XOR64mr_EVEX,
  XOR64mr_ND,
  XOR64mr_NF,
  XOR64mr_NF_ND,
  XOR64ri32,
  XOR64ri32_EVEX,
  XOR64ri32_ND,
  XOR64ri32_NF,
  XOR64ri32_NF_ND,
  XOR64ri8,
  XOR64ri8_EVEX,
  XOR64ri8_ND,
  XOR64ri8_NF,
  XOR64ri8_NF_ND,
  XOR64rm,
  XOR64rm_EVEX,
  XOR64rm_ND,
  XOR64rm_NF,
  XOR64rm_NF_ND,
  XOR64rr,
  XOR64rr_EVEX,
  XOR64rr_EVEX_REV,
  XOR64rr_ND,
  XOR64rr_ND_REV,
  XOR64rr_NF,
  XOR64rr_NF_ND,
  XOR64rr_NF_ND_REV,
  XOR64rr_NF_REV,
  XOR64rr_REV,
  XOR8i8,
  XOR8mi,
  XOR8mi8,
  XOR8mi_EVEX,
  XOR8mi_ND,
  XOR8mi_NF,
  XOR8mi_NF_ND,
  XOR8mr,
  XOR8mr_EVEX,
  XOR8mr_ND,
  XOR8mr_NF,
  XOR8mr_NF_ND,
  XOR8ri,
  XOR8ri8,
  XOR8ri_EVEX,
  XOR8ri_ND,
  XOR8ri_NF,
  XOR8ri_NF_ND,
  XOR8rm,
  XOR8rm_EVEX,
  XOR8rm_ND,
  XOR8rm_NF,
  XOR8rm_NF_ND,
  XOR8rr,
  XOR8rr_EVEX,
  XOR8rr_EVEX_REV,
  XOR8rr_ND,
  XOR8rr_ND_REV,
  XOR8rr_NF,
  XOR8rr_NF_ND,
  XOR8rr_NF_ND_REV,
  XOR8rr_NF_REV,
  XOR8rr_NOREX,
  XOR8rr_REV,
  XORPDrm,
  XORPDrr,
  XORPSrm,
  XORPSrr,
  XRELEASE_PREFIX,
  XRESLDTRK,
  XRSTOR,
  XRSTOR64,
  XRSTORS,
  XRSTORS64,
  XSAVE,
  XSAVE64,
  XSAVEC,
  XSAVEC64,
  XSAVEOPT,
  XSAVEOPT64,
  XSAVES,
  XSAVES64,
  XSETBV,
  XSHA1,
  XSHA256,
  XSTORE,
  XSUSLDTRK,
  XTEST,
  INSTRUCTION_LIST_END,
  UNKNOWN(u64),
}

impl From<u64> for Opcode {
    fn from(value: u64) -> Self {
        match value {
          0 => Opcode::PHI,
          1 => Opcode::INLINEASM,
          2 => Opcode::INLINEASM_BR,
          3 => Opcode::CFI_INSTRUCTION,
          4 => Opcode::EH_LABEL,
          5 => Opcode::GC_LABEL,
          6 => Opcode::ANNOTATION_LABEL,
          7 => Opcode::KILL,
          8 => Opcode::EXTRACT_SUBREG,
          9 => Opcode::INSERT_SUBREG,
          10 => Opcode::IMPLICIT_DEF,
          11 => Opcode::INIT_UNDEF,
          12 => Opcode::SUBREG_TO_REG,
          13 => Opcode::COPY_TO_REGCLASS,
          14 => Opcode::DBG_VALUE,
          15 => Opcode::DBG_VALUE_LIST,
          16 => Opcode::DBG_INSTR_REF,
          17 => Opcode::DBG_PHI,
          18 => Opcode::DBG_LABEL,
          19 => Opcode::REG_SEQUENCE,
          20 => Opcode::COPY,
          21 => Opcode::BUNDLE,
          22 => Opcode::LIFETIME_START,
          23 => Opcode::LIFETIME_END,
          24 => Opcode::PSEUDO_PROBE,
          25 => Opcode::ARITH_FENCE,
          26 => Opcode::STACKMAP,
          27 => Opcode::FENTRY_CALL,
          28 => Opcode::PATCHPOINT,
          29 => Opcode::LOAD_STACK_GUARD,
          30 => Opcode::PREALLOCATED_SETUP,
          31 => Opcode::PREALLOCATED_ARG,
          32 => Opcode::STATEPOINT,
          33 => Opcode::LOCAL_ESCAPE,
          34 => Opcode::FAULTING_OP,
          35 => Opcode::PATCHABLE_OP,
          36 => Opcode::PATCHABLE_FUNCTION_ENTER,
          37 => Opcode::PATCHABLE_RET,
          38 => Opcode::PATCHABLE_FUNCTION_EXIT,
          39 => Opcode::PATCHABLE_TAIL_CALL,
          40 => Opcode::PATCHABLE_EVENT_CALL,
          41 => Opcode::PATCHABLE_TYPED_EVENT_CALL,
          42 => Opcode::ICALL_BRANCH_FUNNEL,
          43 => Opcode::FAKE_USE,
          44 => Opcode::MEMBARRIER,
          45 => Opcode::JUMP_TABLE_DEBUG_INFO,
          46 => Opcode::CONVERGENCECTRL_ENTRY,
          47 => Opcode::CONVERGENCECTRL_ANCHOR,
          48 => Opcode::CONVERGENCECTRL_LOOP,
          49 => Opcode::CONVERGENCECTRL_GLUE,
          50 => Opcode::G_ASSERT_SEXT,
          51 => Opcode::G_ASSERT_ZEXT,
          52 => Opcode::G_ASSERT_ALIGN,
          53 => Opcode::G_ADD,
          54 => Opcode::G_SUB,
          55 => Opcode::G_MUL,
          56 => Opcode::G_SDIV,
          57 => Opcode::G_UDIV,
          58 => Opcode::G_SREM,
          59 => Opcode::G_UREM,
          60 => Opcode::G_SDIVREM,
          61 => Opcode::G_UDIVREM,
          62 => Opcode::G_AND,
          63 => Opcode::G_OR,
          64 => Opcode::G_XOR,
          65 => Opcode::G_ABDS,
          66 => Opcode::G_ABDU,
          67 => Opcode::G_IMPLICIT_DEF,
          68 => Opcode::G_PHI,
          69 => Opcode::G_FRAME_INDEX,
          70 => Opcode::G_GLOBAL_VALUE,
          71 => Opcode::G_PTRAUTH_GLOBAL_VALUE,
          72 => Opcode::G_CONSTANT_POOL,
          73 => Opcode::G_EXTRACT,
          74 => Opcode::G_UNMERGE_VALUES,
          75 => Opcode::G_INSERT,
          76 => Opcode::G_MERGE_VALUES,
          77 => Opcode::G_BUILD_VECTOR,
          78 => Opcode::G_BUILD_VECTOR_TRUNC,
          79 => Opcode::G_CONCAT_VECTORS,
          80 => Opcode::G_PTRTOINT,
          81 => Opcode::G_INTTOPTR,
          82 => Opcode::G_BITCAST,
          83 => Opcode::G_FREEZE,
          84 => Opcode::G_CONSTANT_FOLD_BARRIER,
          85 => Opcode::G_INTRINSIC_FPTRUNC_ROUND,
          86 => Opcode::G_INTRINSIC_TRUNC,
          87 => Opcode::G_INTRINSIC_ROUND,
          88 => Opcode::G_INTRINSIC_LRINT,
          89 => Opcode::G_INTRINSIC_LLRINT,
          90 => Opcode::G_INTRINSIC_ROUNDEVEN,
          91 => Opcode::G_READCYCLECOUNTER,
          92 => Opcode::G_READSTEADYCOUNTER,
          93 => Opcode::G_LOAD,
          94 => Opcode::G_SEXTLOAD,
          95 => Opcode::G_ZEXTLOAD,
          96 => Opcode::G_INDEXED_LOAD,
          97 => Opcode::G_INDEXED_SEXTLOAD,
          98 => Opcode::G_INDEXED_ZEXTLOAD,
          99 => Opcode::G_STORE,
          100 => Opcode::G_INDEXED_STORE,
          101 => Opcode::G_ATOMIC_CMPXCHG_WITH_SUCCESS,
          102 => Opcode::G_ATOMIC_CMPXCHG,
          103 => Opcode::G_ATOMICRMW_XCHG,
          104 => Opcode::G_ATOMICRMW_ADD,
          105 => Opcode::G_ATOMICRMW_SUB,
          106 => Opcode::G_ATOMICRMW_AND,
          107 => Opcode::G_ATOMICRMW_NAND,
          108 => Opcode::G_ATOMICRMW_OR,
          109 => Opcode::G_ATOMICRMW_XOR,
          110 => Opcode::G_ATOMICRMW_MAX,
          111 => Opcode::G_ATOMICRMW_MIN,
          112 => Opcode::G_ATOMICRMW_UMAX,
          113 => Opcode::G_ATOMICRMW_UMIN,
          114 => Opcode::G_ATOMICRMW_FADD,
          115 => Opcode::G_ATOMICRMW_FSUB,
          116 => Opcode::G_ATOMICRMW_FMAX,
          117 => Opcode::G_ATOMICRMW_FMIN,
          118 => Opcode::G_ATOMICRMW_FMAXIMUM,
          119 => Opcode::G_ATOMICRMW_FMINIMUM,
          120 => Opcode::G_ATOMICRMW_UINC_WRAP,
          121 => Opcode::G_ATOMICRMW_UDEC_WRAP,
          122 => Opcode::G_ATOMICRMW_USUB_COND,
          123 => Opcode::G_ATOMICRMW_USUB_SAT,
          124 => Opcode::G_FENCE,
          125 => Opcode::G_PREFETCH,
          126 => Opcode::G_BRCOND,
          127 => Opcode::G_BRINDIRECT,
          128 => Opcode::G_INVOKE_REGION_START,
          129 => Opcode::G_INTRINSIC,
          130 => Opcode::G_INTRINSIC_W_SIDE_EFFECTS,
          131 => Opcode::G_INTRINSIC_CONVERGENT,
          132 => Opcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
          133 => Opcode::G_ANYEXT,
          134 => Opcode::G_TRUNC,
          135 => Opcode::G_TRUNC_SSAT_S,
          136 => Opcode::G_TRUNC_SSAT_U,
          137 => Opcode::G_TRUNC_USAT_U,
          138 => Opcode::G_CONSTANT,
          139 => Opcode::G_FCONSTANT,
          140 => Opcode::G_VASTART,
          141 => Opcode::G_VAARG,
          142 => Opcode::G_SEXT,
          143 => Opcode::G_SEXT_INREG,
          144 => Opcode::G_ZEXT,
          145 => Opcode::G_SHL,
          146 => Opcode::G_LSHR,
          147 => Opcode::G_ASHR,
          148 => Opcode::G_FSHL,
          149 => Opcode::G_FSHR,
          150 => Opcode::G_ROTR,
          151 => Opcode::G_ROTL,
          152 => Opcode::G_ICMP,
          153 => Opcode::G_FCMP,
          154 => Opcode::G_SCMP,
          155 => Opcode::G_UCMP,
          156 => Opcode::G_SELECT,
          157 => Opcode::G_UADDO,
          158 => Opcode::G_UADDE,
          159 => Opcode::G_USUBO,
          160 => Opcode::G_USUBE,
          161 => Opcode::G_SADDO,
          162 => Opcode::G_SADDE,
          163 => Opcode::G_SSUBO,
          164 => Opcode::G_SSUBE,
          165 => Opcode::G_UMULO,
          166 => Opcode::G_SMULO,
          167 => Opcode::G_UMULH,
          168 => Opcode::G_SMULH,
          169 => Opcode::G_UADDSAT,
          170 => Opcode::G_SADDSAT,
          171 => Opcode::G_USUBSAT,
          172 => Opcode::G_SSUBSAT,
          173 => Opcode::G_USHLSAT,
          174 => Opcode::G_SSHLSAT,
          175 => Opcode::G_SMULFIX,
          176 => Opcode::G_UMULFIX,
          177 => Opcode::G_SMULFIXSAT,
          178 => Opcode::G_UMULFIXSAT,
          179 => Opcode::G_SDIVFIX,
          180 => Opcode::G_UDIVFIX,
          181 => Opcode::G_SDIVFIXSAT,
          182 => Opcode::G_UDIVFIXSAT,
          183 => Opcode::G_FADD,
          184 => Opcode::G_FSUB,
          185 => Opcode::G_FMUL,
          186 => Opcode::G_FMA,
          187 => Opcode::G_FMAD,
          188 => Opcode::G_FDIV,
          189 => Opcode::G_FREM,
          190 => Opcode::G_FPOW,
          191 => Opcode::G_FPOWI,
          192 => Opcode::G_FEXP,
          193 => Opcode::G_FEXP2,
          194 => Opcode::G_FEXP10,
          195 => Opcode::G_FLOG,
          196 => Opcode::G_FLOG2,
          197 => Opcode::G_FLOG10,
          198 => Opcode::G_FLDEXP,
          199 => Opcode::G_FFREXP,
          200 => Opcode::G_FNEG,
          201 => Opcode::G_FPEXT,
          202 => Opcode::G_FPTRUNC,
          203 => Opcode::G_FPTOSI,
          204 => Opcode::G_FPTOUI,
          205 => Opcode::G_SITOFP,
          206 => Opcode::G_UITOFP,
          207 => Opcode::G_FPTOSI_SAT,
          208 => Opcode::G_FPTOUI_SAT,
          209 => Opcode::G_FABS,
          210 => Opcode::G_FCOPYSIGN,
          211 => Opcode::G_IS_FPCLASS,
          212 => Opcode::G_FCANONICALIZE,
          213 => Opcode::G_FMINNUM,
          214 => Opcode::G_FMAXNUM,
          215 => Opcode::G_FMINNUM_IEEE,
          216 => Opcode::G_FMAXNUM_IEEE,
          217 => Opcode::G_FMINIMUM,
          218 => Opcode::G_FMAXIMUM,
          219 => Opcode::G_FMINIMUMNUM,
          220 => Opcode::G_FMAXIMUMNUM,
          221 => Opcode::G_GET_FPENV,
          222 => Opcode::G_SET_FPENV,
          223 => Opcode::G_RESET_FPENV,
          224 => Opcode::G_GET_FPMODE,
          225 => Opcode::G_SET_FPMODE,
          226 => Opcode::G_RESET_FPMODE,
          227 => Opcode::G_GET_ROUNDING,
          228 => Opcode::G_PTR_ADD,
          229 => Opcode::G_PTRMASK,
          230 => Opcode::G_SMIN,
          231 => Opcode::G_SMAX,
          232 => Opcode::G_UMIN,
          233 => Opcode::G_UMAX,
          234 => Opcode::G_ABS,
          235 => Opcode::G_LROUND,
          236 => Opcode::G_LLROUND,
          237 => Opcode::G_BR,
          238 => Opcode::G_BRJT,
          239 => Opcode::G_VSCALE,
          240 => Opcode::G_INSERT_SUBVECTOR,
          241 => Opcode::G_EXTRACT_SUBVECTOR,
          242 => Opcode::G_INSERT_VECTOR_ELT,
          243 => Opcode::G_EXTRACT_VECTOR_ELT,
          244 => Opcode::G_SHUFFLE_VECTOR,
          245 => Opcode::G_SPLAT_VECTOR,
          246 => Opcode::G_STEP_VECTOR,
          247 => Opcode::G_VECTOR_COMPRESS,
          248 => Opcode::G_CTTZ,
          249 => Opcode::G_CTTZ_ZERO_UNDEF,
          250 => Opcode::G_CTLZ,
          251 => Opcode::G_CTLZ_ZERO_UNDEF,
          252 => Opcode::G_CTPOP,
          253 => Opcode::G_BSWAP,
          254 => Opcode::G_BITREVERSE,
          255 => Opcode::G_FCEIL,
          256 => Opcode::G_FCOS,
          257 => Opcode::G_FSIN,
          258 => Opcode::G_FSINCOS,
          259 => Opcode::G_FTAN,
          260 => Opcode::G_FACOS,
          261 => Opcode::G_FASIN,
          262 => Opcode::G_FATAN,
          263 => Opcode::G_FATAN2,
          264 => Opcode::G_FCOSH,
          265 => Opcode::G_FSINH,
          266 => Opcode::G_FTANH,
          267 => Opcode::G_FSQRT,
          268 => Opcode::G_FFLOOR,
          269 => Opcode::G_FRINT,
          270 => Opcode::G_FNEARBYINT,
          271 => Opcode::G_ADDRSPACE_CAST,
          272 => Opcode::G_BLOCK_ADDR,
          273 => Opcode::G_JUMP_TABLE,
          274 => Opcode::G_DYN_STACKALLOC,
          275 => Opcode::G_STACKSAVE,
          276 => Opcode::G_STACKRESTORE,
          277 => Opcode::G_STRICT_FADD,
          278 => Opcode::G_STRICT_FSUB,
          279 => Opcode::G_STRICT_FMUL,
          280 => Opcode::G_STRICT_FDIV,
          281 => Opcode::G_STRICT_FREM,
          282 => Opcode::G_STRICT_FMA,
          283 => Opcode::G_STRICT_FSQRT,
          284 => Opcode::G_STRICT_FLDEXP,
          285 => Opcode::G_READ_REGISTER,
          286 => Opcode::G_WRITE_REGISTER,
          287 => Opcode::G_MEMCPY,
          288 => Opcode::G_MEMCPY_INLINE,
          289 => Opcode::G_MEMMOVE,
          290 => Opcode::G_MEMSET,
          291 => Opcode::G_BZERO,
          292 => Opcode::G_TRAP,
          293 => Opcode::G_DEBUGTRAP,
          294 => Opcode::G_UBSANTRAP,
          295 => Opcode::G_VECREDUCE_SEQ_FADD,
          296 => Opcode::G_VECREDUCE_SEQ_FMUL,
          297 => Opcode::G_VECREDUCE_FADD,
          298 => Opcode::G_VECREDUCE_FMUL,
          299 => Opcode::G_VECREDUCE_FMAX,
          300 => Opcode::G_VECREDUCE_FMIN,
          301 => Opcode::G_VECREDUCE_FMAXIMUM,
          302 => Opcode::G_VECREDUCE_FMINIMUM,
          303 => Opcode::G_VECREDUCE_ADD,
          304 => Opcode::G_VECREDUCE_MUL,
          305 => Opcode::G_VECREDUCE_AND,
          306 => Opcode::G_VECREDUCE_OR,
          307 => Opcode::G_VECREDUCE_XOR,
          308 => Opcode::G_VECREDUCE_SMAX,
          309 => Opcode::G_VECREDUCE_SMIN,
          310 => Opcode::G_VECREDUCE_UMAX,
          311 => Opcode::G_VECREDUCE_UMIN,
          312 => Opcode::G_SBFX,
          313 => Opcode::G_UBFX,
          314 => Opcode::ADD16ri_DB,
          315 => Opcode::ADD16rr_DB,
          316 => Opcode::ADD32ri_DB,
          317 => Opcode::ADD32rr_DB,
          318 => Opcode::ADD64ri32_DB,
          319 => Opcode::ADD64rr_DB,
          320 => Opcode::ADD8ri_DB,
          321 => Opcode::ADD8rr_DB,
          322 => Opcode::AVX1_SETALLONES,
          323 => Opcode::AVX2_SETALLONES,
          324 => Opcode::AVX512_128_SET0,
          325 => Opcode::AVX512_256_SET0,
          326 => Opcode::AVX512_512_SET0,
          327 => Opcode::AVX512_512_SETALLONES,
          328 => Opcode::AVX512_512_SEXT_MASK_32,
          329 => Opcode::AVX512_512_SEXT_MASK_64,
          330 => Opcode::AVX512_FsFLD0F128,
          331 => Opcode::AVX512_FsFLD0SD,
          332 => Opcode::AVX512_FsFLD0SH,
          333 => Opcode::AVX512_FsFLD0SS,
          334 => Opcode::AVX_SET0,
          335 => Opcode::CALL64m_RVMARKER,
          336 => Opcode::CALL64pcrel32_RVMARKER,
          337 => Opcode::CALL64r_ImpCall,
          338 => Opcode::CALL64r_RVMARKER,
          339 => Opcode::FsFLD0F128,
          340 => Opcode::FsFLD0SD,
          341 => Opcode::FsFLD0SH,
          342 => Opcode::FsFLD0SS,
          343 => Opcode::G_FILD,
          344 => Opcode::G_FIST,
          345 => Opcode::G_FNSTCW16,
          346 => Opcode::INDIRECT_THUNK_CALL32,
          347 => Opcode::INDIRECT_THUNK_CALL64,
          348 => Opcode::INDIRECT_THUNK_TCRETURN32,
          349 => Opcode::INDIRECT_THUNK_TCRETURN64,
          350 => Opcode::KSET0D,
          351 => Opcode::KSET0Q,
          352 => Opcode::KSET0W,
          353 => Opcode::KSET1D,
          354 => Opcode::KSET1Q,
          355 => Opcode::KSET1W,
          356 => Opcode::LCMPXCHG16B_NO_RBX,
          357 => Opcode::LCMPXCHG16B_SAVE_RBX,
          358 => Opcode::MMX_SET0,
          359 => Opcode::MORESTACK_RET,
          360 => Opcode::MORESTACK_RET_RESTORE_R10,
          361 => Opcode::MOV32ImmSExti8,
          362 => Opcode::MOV32r0,
          363 => Opcode::MOV32r1,
          364 => Opcode::MOV32r_1,
          365 => Opcode::MOV32ri64,
          366 => Opcode::MOV64ImmSExti8,
          367 => Opcode::MWAITX,
          368 => Opcode::MWAITX_SAVE_RBX,
          369 => Opcode::PLDTILECFGV,
          370 => Opcode::PLEA32r,
          371 => Opcode::PLEA64r,
          372 => Opcode::PT2RPNTLVWZ0RST1V,
          373 => Opcode::PT2RPNTLVWZ0RSV,
          374 => Opcode::PT2RPNTLVWZ0T1V,
          375 => Opcode::PT2RPNTLVWZ0V,
          376 => Opcode::PT2RPNTLVWZ1RST1V,
          377 => Opcode::PT2RPNTLVWZ1RSV,
          378 => Opcode::PT2RPNTLVWZ1T1V,
          379 => Opcode::PT2RPNTLVWZ1V,
          380 => Opcode::PTDPBF16PSV,
          381 => Opcode::PTDPBSSDV,
          382 => Opcode::PTDPBSUDV,
          383 => Opcode::PTDPBUSDV,
          384 => Opcode::PTDPBUUDV,
          385 => Opcode::PTDPFP16PSV,
          386 => Opcode::PTILELOADDRST1V,
          387 => Opcode::PTILELOADDRSV,
          388 => Opcode::PTILELOADDT1V,
          389 => Opcode::PTILELOADDV,
          390 => Opcode::PTILEPAIRLOAD,
          391 => Opcode::PTILEPAIRSTORE,
          392 => Opcode::PTILESTOREDV,
          393 => Opcode::PTILEZEROV,
          394 => Opcode::RDFLAGS32,
          395 => Opcode::RDFLAGS64,
          396 => Opcode::SEH_BeginEpilogue,
          397 => Opcode::SEH_EndEpilogue,
          398 => Opcode::SEH_EndPrologue,
          399 => Opcode::SEH_PushFrame,
          400 => Opcode::SEH_PushReg,
          401 => Opcode::SEH_SaveReg,
          402 => Opcode::SEH_SaveXMM,
          403 => Opcode::SEH_SetFrame,
          404 => Opcode::SEH_StackAlign,
          405 => Opcode::SEH_StackAlloc,
          406 => Opcode::SEH_UnwindV2Start,
          407 => Opcode::SEH_UnwindVersion,
          408 => Opcode::SETB_C32r,
          409 => Opcode::SETB_C64r,
          410 => Opcode::SHLDROT32ri,
          411 => Opcode::SHLDROT64ri,
          412 => Opcode::SHRDROT32ri,
          413 => Opcode::SHRDROT64ri,
          414 => Opcode::VMOVAPSZ128mr_NOVLX,
          415 => Opcode::VMOVAPSZ128rm_NOVLX,
          416 => Opcode::VMOVAPSZ256mr_NOVLX,
          417 => Opcode::VMOVAPSZ256rm_NOVLX,
          418 => Opcode::VMOVUPSZ128mr_NOVLX,
          419 => Opcode::VMOVUPSZ128rm_NOVLX,
          420 => Opcode::VMOVUPSZ256mr_NOVLX,
          421 => Opcode::VMOVUPSZ256rm_NOVLX,
          422 => Opcode::V_SET0,
          423 => Opcode::V_SETALLONES,
          424 => Opcode::WRFLAGS32,
          425 => Opcode::WRFLAGS64,
          426 => Opcode::XABORT_DEF,
          427 => Opcode::XOR32_FP,
          428 => Opcode::XOR64_FP,
          429 => Opcode::AAA,
          430 => Opcode::AAD8i8,
          431 => Opcode::AADD32mr,
          432 => Opcode::AADD32mr_EVEX,
          433 => Opcode::AADD64mr,
          434 => Opcode::AADD64mr_EVEX,
          435 => Opcode::AAM8i8,
          436 => Opcode::AAND32mr,
          437 => Opcode::AAND32mr_EVEX,
          438 => Opcode::AAND64mr,
          439 => Opcode::AAND64mr_EVEX,
          440 => Opcode::AAS,
          441 => Opcode::ABS_F,
          442 => Opcode::ABS_Fp32,
          443 => Opcode::ABS_Fp64,
          444 => Opcode::ABS_Fp80,
          445 => Opcode::ADC16i16,
          446 => Opcode::ADC16mi,
          447 => Opcode::ADC16mi8,
          448 => Opcode::ADC16mi8_EVEX,
          449 => Opcode::ADC16mi8_ND,
          450 => Opcode::ADC16mi_EVEX,
          451 => Opcode::ADC16mi_ND,
          452 => Opcode::ADC16mr,
          453 => Opcode::ADC16mr_EVEX,
          454 => Opcode::ADC16mr_ND,
          455 => Opcode::ADC16ri,
          456 => Opcode::ADC16ri8,
          457 => Opcode::ADC16ri8_EVEX,
          458 => Opcode::ADC16ri8_ND,
          459 => Opcode::ADC16ri_EVEX,
          460 => Opcode::ADC16ri_ND,
          461 => Opcode::ADC16rm,
          462 => Opcode::ADC16rm_EVEX,
          463 => Opcode::ADC16rm_ND,
          464 => Opcode::ADC16rr,
          465 => Opcode::ADC16rr_EVEX,
          466 => Opcode::ADC16rr_EVEX_REV,
          467 => Opcode::ADC16rr_ND,
          468 => Opcode::ADC16rr_ND_REV,
          469 => Opcode::ADC16rr_REV,
          470 => Opcode::ADC32i32,
          471 => Opcode::ADC32mi,
          472 => Opcode::ADC32mi8,
          473 => Opcode::ADC32mi8_EVEX,
          474 => Opcode::ADC32mi8_ND,
          475 => Opcode::ADC32mi_EVEX,
          476 => Opcode::ADC32mi_ND,
          477 => Opcode::ADC32mr,
          478 => Opcode::ADC32mr_EVEX,
          479 => Opcode::ADC32mr_ND,
          480 => Opcode::ADC32ri,
          481 => Opcode::ADC32ri8,
          482 => Opcode::ADC32ri8_EVEX,
          483 => Opcode::ADC32ri8_ND,
          484 => Opcode::ADC32ri_EVEX,
          485 => Opcode::ADC32ri_ND,
          486 => Opcode::ADC32rm,
          487 => Opcode::ADC32rm_EVEX,
          488 => Opcode::ADC32rm_ND,
          489 => Opcode::ADC32rr,
          490 => Opcode::ADC32rr_EVEX,
          491 => Opcode::ADC32rr_EVEX_REV,
          492 => Opcode::ADC32rr_ND,
          493 => Opcode::ADC32rr_ND_REV,
          494 => Opcode::ADC32rr_REV,
          495 => Opcode::ADC64i32,
          496 => Opcode::ADC64mi32,
          497 => Opcode::ADC64mi32_EVEX,
          498 => Opcode::ADC64mi32_ND,
          499 => Opcode::ADC64mi8,
          500 => Opcode::ADC64mi8_EVEX,
          501 => Opcode::ADC64mi8_ND,
          502 => Opcode::ADC64mr,
          503 => Opcode::ADC64mr_EVEX,
          504 => Opcode::ADC64mr_ND,
          505 => Opcode::ADC64ri32,
          506 => Opcode::ADC64ri32_EVEX,
          507 => Opcode::ADC64ri32_ND,
          508 => Opcode::ADC64ri8,
          509 => Opcode::ADC64ri8_EVEX,
          510 => Opcode::ADC64ri8_ND,
          511 => Opcode::ADC64rm,
          512 => Opcode::ADC64rm_EVEX,
          513 => Opcode::ADC64rm_ND,
          514 => Opcode::ADC64rr,
          515 => Opcode::ADC64rr_EVEX,
          516 => Opcode::ADC64rr_EVEX_REV,
          517 => Opcode::ADC64rr_ND,
          518 => Opcode::ADC64rr_ND_REV,
          519 => Opcode::ADC64rr_REV,
          520 => Opcode::ADC8i8,
          521 => Opcode::ADC8mi,
          522 => Opcode::ADC8mi8,
          523 => Opcode::ADC8mi_EVEX,
          524 => Opcode::ADC8mi_ND,
          525 => Opcode::ADC8mr,
          526 => Opcode::ADC8mr_EVEX,
          527 => Opcode::ADC8mr_ND,
          528 => Opcode::ADC8ri,
          529 => Opcode::ADC8ri8,
          530 => Opcode::ADC8ri_EVEX,
          531 => Opcode::ADC8ri_ND,
          532 => Opcode::ADC8rm,
          533 => Opcode::ADC8rm_EVEX,
          534 => Opcode::ADC8rm_ND,
          535 => Opcode::ADC8rr,
          536 => Opcode::ADC8rr_EVEX,
          537 => Opcode::ADC8rr_EVEX_REV,
          538 => Opcode::ADC8rr_ND,
          539 => Opcode::ADC8rr_ND_REV,
          540 => Opcode::ADC8rr_REV,
          541 => Opcode::ADCX32rm,
          542 => Opcode::ADCX32rm_EVEX,
          543 => Opcode::ADCX32rm_ND,
          544 => Opcode::ADCX32rr,
          545 => Opcode::ADCX32rr_EVEX,
          546 => Opcode::ADCX32rr_ND,
          547 => Opcode::ADCX64rm,
          548 => Opcode::ADCX64rm_EVEX,
          549 => Opcode::ADCX64rm_ND,
          550 => Opcode::ADCX64rr,
          551 => Opcode::ADCX64rr_EVEX,
          552 => Opcode::ADCX64rr_ND,
          553 => Opcode::ADD16i16,
          554 => Opcode::ADD16mi,
          555 => Opcode::ADD16mi8,
          556 => Opcode::ADD16mi8_EVEX,
          557 => Opcode::ADD16mi8_ND,
          558 => Opcode::ADD16mi8_NF,
          559 => Opcode::ADD16mi8_NF_ND,
          560 => Opcode::ADD16mi_EVEX,
          561 => Opcode::ADD16mi_ND,
          562 => Opcode::ADD16mi_NF,
          563 => Opcode::ADD16mi_NF_ND,
          564 => Opcode::ADD16mr,
          565 => Opcode::ADD16mr_EVEX,
          566 => Opcode::ADD16mr_ND,
          567 => Opcode::ADD16mr_NF,
          568 => Opcode::ADD16mr_NF_ND,
          569 => Opcode::ADD16ri,
          570 => Opcode::ADD16ri8,
          571 => Opcode::ADD16ri8_EVEX,
          572 => Opcode::ADD16ri8_ND,
          573 => Opcode::ADD16ri8_NF,
          574 => Opcode::ADD16ri8_NF_ND,
          575 => Opcode::ADD16ri_EVEX,
          576 => Opcode::ADD16ri_ND,
          577 => Opcode::ADD16ri_NF,
          578 => Opcode::ADD16ri_NF_ND,
          579 => Opcode::ADD16rm,
          580 => Opcode::ADD16rm_EVEX,
          581 => Opcode::ADD16rm_ND,
          582 => Opcode::ADD16rm_NF,
          583 => Opcode::ADD16rm_NF_ND,
          584 => Opcode::ADD16rr,
          585 => Opcode::ADD16rr_EVEX,
          586 => Opcode::ADD16rr_EVEX_REV,
          587 => Opcode::ADD16rr_ND,
          588 => Opcode::ADD16rr_ND_REV,
          589 => Opcode::ADD16rr_NF,
          590 => Opcode::ADD16rr_NF_ND,
          591 => Opcode::ADD16rr_NF_ND_REV,
          592 => Opcode::ADD16rr_NF_REV,
          593 => Opcode::ADD16rr_REV,
          594 => Opcode::ADD32i32,
          595 => Opcode::ADD32mi,
          596 => Opcode::ADD32mi8,
          597 => Opcode::ADD32mi8_EVEX,
          598 => Opcode::ADD32mi8_ND,
          599 => Opcode::ADD32mi8_NF,
          600 => Opcode::ADD32mi8_NF_ND,
          601 => Opcode::ADD32mi_EVEX,
          602 => Opcode::ADD32mi_ND,
          603 => Opcode::ADD32mi_NF,
          604 => Opcode::ADD32mi_NF_ND,
          605 => Opcode::ADD32mr,
          606 => Opcode::ADD32mr_EVEX,
          607 => Opcode::ADD32mr_ND,
          608 => Opcode::ADD32mr_NF,
          609 => Opcode::ADD32mr_NF_ND,
          610 => Opcode::ADD32ri,
          611 => Opcode::ADD32ri8,
          612 => Opcode::ADD32ri8_EVEX,
          613 => Opcode::ADD32ri8_ND,
          614 => Opcode::ADD32ri8_NF,
          615 => Opcode::ADD32ri8_NF_ND,
          616 => Opcode::ADD32ri_EVEX,
          617 => Opcode::ADD32ri_ND,
          618 => Opcode::ADD32ri_NF,
          619 => Opcode::ADD32ri_NF_ND,
          620 => Opcode::ADD32rm,
          621 => Opcode::ADD32rm_EVEX,
          622 => Opcode::ADD32rm_ND,
          623 => Opcode::ADD32rm_NF,
          624 => Opcode::ADD32rm_NF_ND,
          625 => Opcode::ADD32rr,
          626 => Opcode::ADD32rr_EVEX,
          627 => Opcode::ADD32rr_EVEX_REV,
          628 => Opcode::ADD32rr_ND,
          629 => Opcode::ADD32rr_ND_REV,
          630 => Opcode::ADD32rr_NF,
          631 => Opcode::ADD32rr_NF_ND,
          632 => Opcode::ADD32rr_NF_ND_REV,
          633 => Opcode::ADD32rr_NF_REV,
          634 => Opcode::ADD32rr_REV,
          635 => Opcode::ADD64i32,
          636 => Opcode::ADD64mi32,
          637 => Opcode::ADD64mi32_EVEX,
          638 => Opcode::ADD64mi32_ND,
          639 => Opcode::ADD64mi32_NF,
          640 => Opcode::ADD64mi32_NF_ND,
          641 => Opcode::ADD64mi8,
          642 => Opcode::ADD64mi8_EVEX,
          643 => Opcode::ADD64mi8_ND,
          644 => Opcode::ADD64mi8_NF,
          645 => Opcode::ADD64mi8_NF_ND,
          646 => Opcode::ADD64mr,
          647 => Opcode::ADD64mr_EVEX,
          648 => Opcode::ADD64mr_ND,
          649 => Opcode::ADD64mr_NF,
          650 => Opcode::ADD64mr_NF_ND,
          651 => Opcode::ADD64ri32,
          652 => Opcode::ADD64ri32_EVEX,
          653 => Opcode::ADD64ri32_ND,
          654 => Opcode::ADD64ri32_NF,
          655 => Opcode::ADD64ri32_NF_ND,
          656 => Opcode::ADD64ri8,
          657 => Opcode::ADD64ri8_EVEX,
          658 => Opcode::ADD64ri8_ND,
          659 => Opcode::ADD64ri8_NF,
          660 => Opcode::ADD64ri8_NF_ND,
          661 => Opcode::ADD64rm,
          662 => Opcode::ADD64rm_EVEX,
          663 => Opcode::ADD64rm_ND,
          664 => Opcode::ADD64rm_NF,
          665 => Opcode::ADD64rm_NF_ND,
          666 => Opcode::ADD64rr,
          667 => Opcode::ADD64rr_EVEX,
          668 => Opcode::ADD64rr_EVEX_REV,
          669 => Opcode::ADD64rr_ND,
          670 => Opcode::ADD64rr_ND_REV,
          671 => Opcode::ADD64rr_NF,
          672 => Opcode::ADD64rr_NF_ND,
          673 => Opcode::ADD64rr_NF_ND_REV,
          674 => Opcode::ADD64rr_NF_REV,
          675 => Opcode::ADD64rr_REV,
          676 => Opcode::ADD8i8,
          677 => Opcode::ADD8mi,
          678 => Opcode::ADD8mi8,
          679 => Opcode::ADD8mi_EVEX,
          680 => Opcode::ADD8mi_ND,
          681 => Opcode::ADD8mi_NF,
          682 => Opcode::ADD8mi_NF_ND,
          683 => Opcode::ADD8mr,
          684 => Opcode::ADD8mr_EVEX,
          685 => Opcode::ADD8mr_ND,
          686 => Opcode::ADD8mr_NF,
          687 => Opcode::ADD8mr_NF_ND,
          688 => Opcode::ADD8ri,
          689 => Opcode::ADD8ri8,
          690 => Opcode::ADD8ri_EVEX,
          691 => Opcode::ADD8ri_ND,
          692 => Opcode::ADD8ri_NF,
          693 => Opcode::ADD8ri_NF_ND,
          694 => Opcode::ADD8rm,
          695 => Opcode::ADD8rm_EVEX,
          696 => Opcode::ADD8rm_ND,
          697 => Opcode::ADD8rm_NF,
          698 => Opcode::ADD8rm_NF_ND,
          699 => Opcode::ADD8rr,
          700 => Opcode::ADD8rr_EVEX,
          701 => Opcode::ADD8rr_EVEX_REV,
          702 => Opcode::ADD8rr_ND,
          703 => Opcode::ADD8rr_ND_REV,
          704 => Opcode::ADD8rr_NF,
          705 => Opcode::ADD8rr_NF_ND,
          706 => Opcode::ADD8rr_NF_ND_REV,
          707 => Opcode::ADD8rr_NF_REV,
          708 => Opcode::ADD8rr_REV,
          709 => Opcode::ADDPDrm,
          710 => Opcode::ADDPDrr,
          711 => Opcode::ADDPSrm,
          712 => Opcode::ADDPSrr,
          713 => Opcode::ADDR16_PREFIX,
          714 => Opcode::ADDR32_PREFIX,
          715 => Opcode::ADDSDrm,
          716 => Opcode::ADDSDrm_Int,
          717 => Opcode::ADDSDrr,
          718 => Opcode::ADDSDrr_Int,
          719 => Opcode::ADDSSrm,
          720 => Opcode::ADDSSrm_Int,
          721 => Opcode::ADDSSrr,
          722 => Opcode::ADDSSrr_Int,
          723 => Opcode::ADDSUBPDrm,
          724 => Opcode::ADDSUBPDrr,
          725 => Opcode::ADDSUBPSrm,
          726 => Opcode::ADDSUBPSrr,
          727 => Opcode::ADD_F32m,
          728 => Opcode::ADD_F64m,
          729 => Opcode::ADD_FI16m,
          730 => Opcode::ADD_FI32m,
          731 => Opcode::ADD_FPrST0,
          732 => Opcode::ADD_FST0r,
          733 => Opcode::ADD_Fp32,
          734 => Opcode::ADD_Fp32m,
          735 => Opcode::ADD_Fp64,
          736 => Opcode::ADD_Fp64m,
          737 => Opcode::ADD_Fp64m32,
          738 => Opcode::ADD_Fp80,
          739 => Opcode::ADD_Fp80m32,
          740 => Opcode::ADD_Fp80m64,
          741 => Opcode::ADD_FpI16m32,
          742 => Opcode::ADD_FpI16m64,
          743 => Opcode::ADD_FpI16m80,
          744 => Opcode::ADD_FpI32m32,
          745 => Opcode::ADD_FpI32m64,
          746 => Opcode::ADD_FpI32m80,
          747 => Opcode::ADD_FrST0,
          748 => Opcode::ADJCALLSTACKDOWN32,
          749 => Opcode::ADJCALLSTACKDOWN64,
          750 => Opcode::ADJCALLSTACKUP32,
          751 => Opcode::ADJCALLSTACKUP64,
          752 => Opcode::ADOX32rm,
          753 => Opcode::ADOX32rm_EVEX,
          754 => Opcode::ADOX32rm_ND,
          755 => Opcode::ADOX32rr,
          756 => Opcode::ADOX32rr_EVEX,
          757 => Opcode::ADOX32rr_ND,
          758 => Opcode::ADOX64rm,
          759 => Opcode::ADOX64rm_EVEX,
          760 => Opcode::ADOX64rm_ND,
          761 => Opcode::ADOX64rr,
          762 => Opcode::ADOX64rr_EVEX,
          763 => Opcode::ADOX64rr_ND,
          764 => Opcode::AESDEC128KL,
          765 => Opcode::AESDEC256KL,
          766 => Opcode::AESDECLASTrm,
          767 => Opcode::AESDECLASTrr,
          768 => Opcode::AESDECWIDE128KL,
          769 => Opcode::AESDECWIDE256KL,
          770 => Opcode::AESDECrm,
          771 => Opcode::AESDECrr,
          772 => Opcode::AESENC128KL,
          773 => Opcode::AESENC256KL,
          774 => Opcode::AESENCLASTrm,
          775 => Opcode::AESENCLASTrr,
          776 => Opcode::AESENCWIDE128KL,
          777 => Opcode::AESENCWIDE256KL,
          778 => Opcode::AESENCrm,
          779 => Opcode::AESENCrr,
          780 => Opcode::AESIMCrm,
          781 => Opcode::AESIMCrr,
          782 => Opcode::AESKEYGENASSIST128rm,
          783 => Opcode::AESKEYGENASSIST128rr,
          784 => Opcode::AND16i16,
          785 => Opcode::AND16mi,
          786 => Opcode::AND16mi8,
          787 => Opcode::AND16mi8_EVEX,
          788 => Opcode::AND16mi8_ND,
          789 => Opcode::AND16mi8_NF,
          790 => Opcode::AND16mi8_NF_ND,
          791 => Opcode::AND16mi_EVEX,
          792 => Opcode::AND16mi_ND,
          793 => Opcode::AND16mi_NF,
          794 => Opcode::AND16mi_NF_ND,
          795 => Opcode::AND16mr,
          796 => Opcode::AND16mr_EVEX,
          797 => Opcode::AND16mr_ND,
          798 => Opcode::AND16mr_NF,
          799 => Opcode::AND16mr_NF_ND,
          800 => Opcode::AND16ri,
          801 => Opcode::AND16ri8,
          802 => Opcode::AND16ri8_EVEX,
          803 => Opcode::AND16ri8_ND,
          804 => Opcode::AND16ri8_NF,
          805 => Opcode::AND16ri8_NF_ND,
          806 => Opcode::AND16ri_EVEX,
          807 => Opcode::AND16ri_ND,
          808 => Opcode::AND16ri_NF,
          809 => Opcode::AND16ri_NF_ND,
          810 => Opcode::AND16rm,
          811 => Opcode::AND16rm_EVEX,
          812 => Opcode::AND16rm_ND,
          813 => Opcode::AND16rm_NF,
          814 => Opcode::AND16rm_NF_ND,
          815 => Opcode::AND16rr,
          816 => Opcode::AND16rr_EVEX,
          817 => Opcode::AND16rr_EVEX_REV,
          818 => Opcode::AND16rr_ND,
          819 => Opcode::AND16rr_ND_REV,
          820 => Opcode::AND16rr_NF,
          821 => Opcode::AND16rr_NF_ND,
          822 => Opcode::AND16rr_NF_ND_REV,
          823 => Opcode::AND16rr_NF_REV,
          824 => Opcode::AND16rr_REV,
          825 => Opcode::AND32i32,
          826 => Opcode::AND32mi,
          827 => Opcode::AND32mi8,
          828 => Opcode::AND32mi8_EVEX,
          829 => Opcode::AND32mi8_ND,
          830 => Opcode::AND32mi8_NF,
          831 => Opcode::AND32mi8_NF_ND,
          832 => Opcode::AND32mi_EVEX,
          833 => Opcode::AND32mi_ND,
          834 => Opcode::AND32mi_NF,
          835 => Opcode::AND32mi_NF_ND,
          836 => Opcode::AND32mr,
          837 => Opcode::AND32mr_EVEX,
          838 => Opcode::AND32mr_ND,
          839 => Opcode::AND32mr_NF,
          840 => Opcode::AND32mr_NF_ND,
          841 => Opcode::AND32ri,
          842 => Opcode::AND32ri8,
          843 => Opcode::AND32ri8_EVEX,
          844 => Opcode::AND32ri8_ND,
          845 => Opcode::AND32ri8_NF,
          846 => Opcode::AND32ri8_NF_ND,
          847 => Opcode::AND32ri_EVEX,
          848 => Opcode::AND32ri_ND,
          849 => Opcode::AND32ri_NF,
          850 => Opcode::AND32ri_NF_ND,
          851 => Opcode::AND32rm,
          852 => Opcode::AND32rm_EVEX,
          853 => Opcode::AND32rm_ND,
          854 => Opcode::AND32rm_NF,
          855 => Opcode::AND32rm_NF_ND,
          856 => Opcode::AND32rr,
          857 => Opcode::AND32rr_EVEX,
          858 => Opcode::AND32rr_EVEX_REV,
          859 => Opcode::AND32rr_ND,
          860 => Opcode::AND32rr_ND_REV,
          861 => Opcode::AND32rr_NF,
          862 => Opcode::AND32rr_NF_ND,
          863 => Opcode::AND32rr_NF_ND_REV,
          864 => Opcode::AND32rr_NF_REV,
          865 => Opcode::AND32rr_REV,
          866 => Opcode::AND64i32,
          867 => Opcode::AND64mi32,
          868 => Opcode::AND64mi32_EVEX,
          869 => Opcode::AND64mi32_ND,
          870 => Opcode::AND64mi32_NF,
          871 => Opcode::AND64mi32_NF_ND,
          872 => Opcode::AND64mi8,
          873 => Opcode::AND64mi8_EVEX,
          874 => Opcode::AND64mi8_ND,
          875 => Opcode::AND64mi8_NF,
          876 => Opcode::AND64mi8_NF_ND,
          877 => Opcode::AND64mr,
          878 => Opcode::AND64mr_EVEX,
          879 => Opcode::AND64mr_ND,
          880 => Opcode::AND64mr_NF,
          881 => Opcode::AND64mr_NF_ND,
          882 => Opcode::AND64ri32,
          883 => Opcode::AND64ri32_EVEX,
          884 => Opcode::AND64ri32_ND,
          885 => Opcode::AND64ri32_NF,
          886 => Opcode::AND64ri32_NF_ND,
          887 => Opcode::AND64ri8,
          888 => Opcode::AND64ri8_EVEX,
          889 => Opcode::AND64ri8_ND,
          890 => Opcode::AND64ri8_NF,
          891 => Opcode::AND64ri8_NF_ND,
          892 => Opcode::AND64rm,
          893 => Opcode::AND64rm_EVEX,
          894 => Opcode::AND64rm_ND,
          895 => Opcode::AND64rm_NF,
          896 => Opcode::AND64rm_NF_ND,
          897 => Opcode::AND64rr,
          898 => Opcode::AND64rr_EVEX,
          899 => Opcode::AND64rr_EVEX_REV,
          900 => Opcode::AND64rr_ND,
          901 => Opcode::AND64rr_ND_REV,
          902 => Opcode::AND64rr_NF,
          903 => Opcode::AND64rr_NF_ND,
          904 => Opcode::AND64rr_NF_ND_REV,
          905 => Opcode::AND64rr_NF_REV,
          906 => Opcode::AND64rr_REV,
          907 => Opcode::AND8i8,
          908 => Opcode::AND8mi,
          909 => Opcode::AND8mi8,
          910 => Opcode::AND8mi_EVEX,
          911 => Opcode::AND8mi_ND,
          912 => Opcode::AND8mi_NF,
          913 => Opcode::AND8mi_NF_ND,
          914 => Opcode::AND8mr,
          915 => Opcode::AND8mr_EVEX,
          916 => Opcode::AND8mr_ND,
          917 => Opcode::AND8mr_NF,
          918 => Opcode::AND8mr_NF_ND,
          919 => Opcode::AND8ri,
          920 => Opcode::AND8ri8,
          921 => Opcode::AND8ri_EVEX,
          922 => Opcode::AND8ri_ND,
          923 => Opcode::AND8ri_NF,
          924 => Opcode::AND8ri_NF_ND,
          925 => Opcode::AND8rm,
          926 => Opcode::AND8rm_EVEX,
          927 => Opcode::AND8rm_ND,
          928 => Opcode::AND8rm_NF,
          929 => Opcode::AND8rm_NF_ND,
          930 => Opcode::AND8rr,
          931 => Opcode::AND8rr_EVEX,
          932 => Opcode::AND8rr_EVEX_REV,
          933 => Opcode::AND8rr_ND,
          934 => Opcode::AND8rr_ND_REV,
          935 => Opcode::AND8rr_NF,
          936 => Opcode::AND8rr_NF_ND,
          937 => Opcode::AND8rr_NF_ND_REV,
          938 => Opcode::AND8rr_NF_REV,
          939 => Opcode::AND8rr_REV,
          940 => Opcode::ANDN32rm,
          941 => Opcode::ANDN32rm_EVEX,
          942 => Opcode::ANDN32rm_NF,
          943 => Opcode::ANDN32rr,
          944 => Opcode::ANDN32rr_EVEX,
          945 => Opcode::ANDN32rr_NF,
          946 => Opcode::ANDN64rm,
          947 => Opcode::ANDN64rm_EVEX,
          948 => Opcode::ANDN64rm_NF,
          949 => Opcode::ANDN64rr,
          950 => Opcode::ANDN64rr_EVEX,
          951 => Opcode::ANDN64rr_NF,
          952 => Opcode::ANDNPDrm,
          953 => Opcode::ANDNPDrr,
          954 => Opcode::ANDNPSrm,
          955 => Opcode::ANDNPSrr,
          956 => Opcode::ANDPDrm,
          957 => Opcode::ANDPDrr,
          958 => Opcode::ANDPSrm,
          959 => Opcode::ANDPSrr,
          960 => Opcode::AOR32mr,
          961 => Opcode::AOR32mr_EVEX,
          962 => Opcode::AOR64mr,
          963 => Opcode::AOR64mr_EVEX,
          964 => Opcode::ARPL16mr,
          965 => Opcode::ARPL16rr,
          966 => Opcode::ASAN_CHECK_MEMACCESS,
          967 => Opcode::AXOR32mr,
          968 => Opcode::AXOR32mr_EVEX,
          969 => Opcode::AXOR64mr,
          970 => Opcode::AXOR64mr_EVEX,
          971 => Opcode::BEXTR32rm,
          972 => Opcode::BEXTR32rm_EVEX,
          973 => Opcode::BEXTR32rm_NF,
          974 => Opcode::BEXTR32rr,
          975 => Opcode::BEXTR32rr_EVEX,
          976 => Opcode::BEXTR32rr_NF,
          977 => Opcode::BEXTR64rm,
          978 => Opcode::BEXTR64rm_EVEX,
          979 => Opcode::BEXTR64rm_NF,
          980 => Opcode::BEXTR64rr,
          981 => Opcode::BEXTR64rr_EVEX,
          982 => Opcode::BEXTR64rr_NF,
          983 => Opcode::BEXTRI32mi,
          984 => Opcode::BEXTRI32ri,
          985 => Opcode::BEXTRI64mi,
          986 => Opcode::BEXTRI64ri,
          987 => Opcode::BLCFILL32rm,
          988 => Opcode::BLCFILL32rr,
          989 => Opcode::BLCFILL64rm,
          990 => Opcode::BLCFILL64rr,
          991 => Opcode::BLCI32rm,
          992 => Opcode::BLCI32rr,
          993 => Opcode::BLCI64rm,
          994 => Opcode::BLCI64rr,
          995 => Opcode::BLCIC32rm,
          996 => Opcode::BLCIC32rr,
          997 => Opcode::BLCIC64rm,
          998 => Opcode::BLCIC64rr,
          999 => Opcode::BLCMSK32rm,
          1000 => Opcode::BLCMSK32rr,
          1001 => Opcode::BLCMSK64rm,
          1002 => Opcode::BLCMSK64rr,
          1003 => Opcode::BLCS32rm,
          1004 => Opcode::BLCS32rr,
          1005 => Opcode::BLCS64rm,
          1006 => Opcode::BLCS64rr,
          1007 => Opcode::BLENDPDrmi,
          1008 => Opcode::BLENDPDrri,
          1009 => Opcode::BLENDPSrmi,
          1010 => Opcode::BLENDPSrri,
          1011 => Opcode::BLENDVPDrm0,
          1012 => Opcode::BLENDVPDrr0,
          1013 => Opcode::BLENDVPSrm0,
          1014 => Opcode::BLENDVPSrr0,
          1015 => Opcode::BLSFILL32rm,
          1016 => Opcode::BLSFILL32rr,
          1017 => Opcode::BLSFILL64rm,
          1018 => Opcode::BLSFILL64rr,
          1019 => Opcode::BLSI32rm,
          1020 => Opcode::BLSI32rm_EVEX,
          1021 => Opcode::BLSI32rm_NF,
          1022 => Opcode::BLSI32rr,
          1023 => Opcode::BLSI32rr_EVEX,
          1024 => Opcode::BLSI32rr_NF,
          1025 => Opcode::BLSI64rm,
          1026 => Opcode::BLSI64rm_EVEX,
          1027 => Opcode::BLSI64rm_NF,
          1028 => Opcode::BLSI64rr,
          1029 => Opcode::BLSI64rr_EVEX,
          1030 => Opcode::BLSI64rr_NF,
          1031 => Opcode::BLSIC32rm,
          1032 => Opcode::BLSIC32rr,
          1033 => Opcode::BLSIC64rm,
          1034 => Opcode::BLSIC64rr,
          1035 => Opcode::BLSMSK32rm,
          1036 => Opcode::BLSMSK32rm_EVEX,
          1037 => Opcode::BLSMSK32rm_NF,
          1038 => Opcode::BLSMSK32rr,
          1039 => Opcode::BLSMSK32rr_EVEX,
          1040 => Opcode::BLSMSK32rr_NF,
          1041 => Opcode::BLSMSK64rm,
          1042 => Opcode::BLSMSK64rm_EVEX,
          1043 => Opcode::BLSMSK64rm_NF,
          1044 => Opcode::BLSMSK64rr,
          1045 => Opcode::BLSMSK64rr_EVEX,
          1046 => Opcode::BLSMSK64rr_NF,
          1047 => Opcode::BLSR32rm,
          1048 => Opcode::BLSR32rm_EVEX,
          1049 => Opcode::BLSR32rm_NF,
          1050 => Opcode::BLSR32rr,
          1051 => Opcode::BLSR32rr_EVEX,
          1052 => Opcode::BLSR32rr_NF,
          1053 => Opcode::BLSR64rm,
          1054 => Opcode::BLSR64rm_EVEX,
          1055 => Opcode::BLSR64rm_NF,
          1056 => Opcode::BLSR64rr,
          1057 => Opcode::BLSR64rr_EVEX,
          1058 => Opcode::BLSR64rr_NF,
          1059 => Opcode::BOUNDS16rm,
          1060 => Opcode::BOUNDS32rm,
          1061 => Opcode::BSF16rm,
          1062 => Opcode::BSF16rr,
          1063 => Opcode::BSF32rm,
          1064 => Opcode::BSF32rr,
          1065 => Opcode::BSF64rm,
          1066 => Opcode::BSF64rr,
          1067 => Opcode::BSR16rm,
          1068 => Opcode::BSR16rr,
          1069 => Opcode::BSR32rm,
          1070 => Opcode::BSR32rr,
          1071 => Opcode::BSR64rm,
          1072 => Opcode::BSR64rr,
          1073 => Opcode::BSWAP16r_BAD,
          1074 => Opcode::BSWAP32r,
          1075 => Opcode::BSWAP64r,
          1076 => Opcode::BT16mi8,
          1077 => Opcode::BT16mr,
          1078 => Opcode::BT16ri8,
          1079 => Opcode::BT16rr,
          1080 => Opcode::BT32mi8,
          1081 => Opcode::BT32mr,
          1082 => Opcode::BT32ri8,
          1083 => Opcode::BT32rr,
          1084 => Opcode::BT64mi8,
          1085 => Opcode::BT64mr,
          1086 => Opcode::BT64ri8,
          1087 => Opcode::BT64rr,
          1088 => Opcode::BTC16mi8,
          1089 => Opcode::BTC16mr,
          1090 => Opcode::BTC16ri8,
          1091 => Opcode::BTC16rr,
          1092 => Opcode::BTC32mi8,
          1093 => Opcode::BTC32mr,
          1094 => Opcode::BTC32ri8,
          1095 => Opcode::BTC32rr,
          1096 => Opcode::BTC64mi8,
          1097 => Opcode::BTC64mr,
          1098 => Opcode::BTC64ri8,
          1099 => Opcode::BTC64rr,
          1100 => Opcode::BTR16mi8,
          1101 => Opcode::BTR16mr,
          1102 => Opcode::BTR16ri8,
          1103 => Opcode::BTR16rr,
          1104 => Opcode::BTR32mi8,
          1105 => Opcode::BTR32mr,
          1106 => Opcode::BTR32ri8,
          1107 => Opcode::BTR32rr,
          1108 => Opcode::BTR64mi8,
          1109 => Opcode::BTR64mr,
          1110 => Opcode::BTR64ri8,
          1111 => Opcode::BTR64rr,
          1112 => Opcode::BTS16mi8,
          1113 => Opcode::BTS16mr,
          1114 => Opcode::BTS16ri8,
          1115 => Opcode::BTS16rr,
          1116 => Opcode::BTS32mi8,
          1117 => Opcode::BTS32mr,
          1118 => Opcode::BTS32ri8,
          1119 => Opcode::BTS32rr,
          1120 => Opcode::BTS64mi8,
          1121 => Opcode::BTS64mr,
          1122 => Opcode::BTS64ri8,
          1123 => Opcode::BTS64rr,
          1124 => Opcode::BZHI32rm,
          1125 => Opcode::BZHI32rm_EVEX,
          1126 => Opcode::BZHI32rm_NF,
          1127 => Opcode::BZHI32rr,
          1128 => Opcode::BZHI32rr_EVEX,
          1129 => Opcode::BZHI32rr_NF,
          1130 => Opcode::BZHI64rm,
          1131 => Opcode::BZHI64rm_EVEX,
          1132 => Opcode::BZHI64rm_NF,
          1133 => Opcode::BZHI64rr,
          1134 => Opcode::BZHI64rr_EVEX,
          1135 => Opcode::BZHI64rr_NF,
          1136 => Opcode::CALL16m,
          1137 => Opcode::CALL16m_NT,
          1138 => Opcode::CALL16r,
          1139 => Opcode::CALL16r_NT,
          1140 => Opcode::CALL32m,
          1141 => Opcode::CALL32m_NT,
          1142 => Opcode::CALL32r,
          1143 => Opcode::CALL32r_NT,
          1144 => Opcode::CALL64m,
          1145 => Opcode::CALL64m_NT,
          1146 => Opcode::CALL64pcrel32,
          1147 => Opcode::CALL64r,
          1148 => Opcode::CALL64r_NT,
          1149 => Opcode::CALLpcrel16,
          1150 => Opcode::CALLpcrel32,
          1151 => Opcode::CATCHRET,
          1152 => Opcode::CBW,
          1153 => Opcode::CCMP16mi,
          1154 => Opcode::CCMP16mi8,
          1155 => Opcode::CCMP16mr,
          1156 => Opcode::CCMP16ri,
          1157 => Opcode::CCMP16ri8,
          1158 => Opcode::CCMP16rm,
          1159 => Opcode::CCMP16rr,
          1160 => Opcode::CCMP16rr_REV,
          1161 => Opcode::CCMP32mi,
          1162 => Opcode::CCMP32mi8,
          1163 => Opcode::CCMP32mr,
          1164 => Opcode::CCMP32ri,
          1165 => Opcode::CCMP32ri8,
          1166 => Opcode::CCMP32rm,
          1167 => Opcode::CCMP32rr,
          1168 => Opcode::CCMP32rr_REV,
          1169 => Opcode::CCMP64mi32,
          1170 => Opcode::CCMP64mi8,
          1171 => Opcode::CCMP64mr,
          1172 => Opcode::CCMP64ri32,
          1173 => Opcode::CCMP64ri8,
          1174 => Opcode::CCMP64rm,
          1175 => Opcode::CCMP64rr,
          1176 => Opcode::CCMP64rr_REV,
          1177 => Opcode::CCMP8mi,
          1178 => Opcode::CCMP8mr,
          1179 => Opcode::CCMP8ri,
          1180 => Opcode::CCMP8rm,
          1181 => Opcode::CCMP8rr,
          1182 => Opcode::CCMP8rr_REV,
          1183 => Opcode::CDQ,
          1184 => Opcode::CDQE,
          1185 => Opcode::CFCMOV16mr,
          1186 => Opcode::CFCMOV16rm,
          1187 => Opcode::CFCMOV16rm_ND,
          1188 => Opcode::CFCMOV16rr,
          1189 => Opcode::CFCMOV16rr_ND,
          1190 => Opcode::CFCMOV16rr_REV,
          1191 => Opcode::CFCMOV32mr,
          1192 => Opcode::CFCMOV32rm,
          1193 => Opcode::CFCMOV32rm_ND,
          1194 => Opcode::CFCMOV32rr,
          1195 => Opcode::CFCMOV32rr_ND,
          1196 => Opcode::CFCMOV32rr_REV,
          1197 => Opcode::CFCMOV64mr,
          1198 => Opcode::CFCMOV64rm,
          1199 => Opcode::CFCMOV64rm_ND,
          1200 => Opcode::CFCMOV64rr,
          1201 => Opcode::CFCMOV64rr_ND,
          1202 => Opcode::CFCMOV64rr_REV,
          1203 => Opcode::CHS_F,
          1204 => Opcode::CHS_Fp32,
          1205 => Opcode::CHS_Fp64,
          1206 => Opcode::CHS_Fp80,
          1207 => Opcode::CLAC,
          1208 => Opcode::CLC,
          1209 => Opcode::CLD,
          1210 => Opcode::CLDEMOTE,
          1211 => Opcode::CLEANUPRET,
          1212 => Opcode::CLFLUSH,
          1213 => Opcode::CLFLUSHOPT,
          1214 => Opcode::CLGI,
          1215 => Opcode::CLI,
          1216 => Opcode::CLRSSBSY,
          1217 => Opcode::CLTS,
          1218 => Opcode::CLUI,
          1219 => Opcode::CLWB,
          1220 => Opcode::CLZERO32r,
          1221 => Opcode::CLZERO64r,
          1222 => Opcode::CMC,
          1223 => Opcode::CMOV16rm,
          1224 => Opcode::CMOV16rm_ND,
          1225 => Opcode::CMOV16rr,
          1226 => Opcode::CMOV16rr_ND,
          1227 => Opcode::CMOV32rm,
          1228 => Opcode::CMOV32rm_ND,
          1229 => Opcode::CMOV32rr,
          1230 => Opcode::CMOV32rr_ND,
          1231 => Opcode::CMOV64rm,
          1232 => Opcode::CMOV64rm_ND,
          1233 => Opcode::CMOV64rr,
          1234 => Opcode::CMOV64rr_ND,
          1235 => Opcode::CMOVBE_F,
          1236 => Opcode::CMOVBE_Fp32,
          1237 => Opcode::CMOVBE_Fp64,
          1238 => Opcode::CMOVBE_Fp80,
          1239 => Opcode::CMOVB_F,
          1240 => Opcode::CMOVB_Fp32,
          1241 => Opcode::CMOVB_Fp64,
          1242 => Opcode::CMOVB_Fp80,
          1243 => Opcode::CMOVE_F,
          1244 => Opcode::CMOVE_Fp32,
          1245 => Opcode::CMOVE_Fp64,
          1246 => Opcode::CMOVE_Fp80,
          1247 => Opcode::CMOVNBE_F,
          1248 => Opcode::CMOVNBE_Fp32,
          1249 => Opcode::CMOVNBE_Fp64,
          1250 => Opcode::CMOVNBE_Fp80,
          1251 => Opcode::CMOVNB_F,
          1252 => Opcode::CMOVNB_Fp32,
          1253 => Opcode::CMOVNB_Fp64,
          1254 => Opcode::CMOVNB_Fp80,
          1255 => Opcode::CMOVNE_F,
          1256 => Opcode::CMOVNE_Fp32,
          1257 => Opcode::CMOVNE_Fp64,
          1258 => Opcode::CMOVNE_Fp80,
          1259 => Opcode::CMOVNP_F,
          1260 => Opcode::CMOVNP_Fp32,
          1261 => Opcode::CMOVNP_Fp64,
          1262 => Opcode::CMOVNP_Fp80,
          1263 => Opcode::CMOVP_F,
          1264 => Opcode::CMOVP_Fp32,
          1265 => Opcode::CMOVP_Fp64,
          1266 => Opcode::CMOVP_Fp80,
          1267 => Opcode::CMOV_FR16,
          1268 => Opcode::CMOV_FR16X,
          1269 => Opcode::CMOV_FR32,
          1270 => Opcode::CMOV_FR32X,
          1271 => Opcode::CMOV_FR64,
          1272 => Opcode::CMOV_FR64X,
          1273 => Opcode::CMOV_GR16,
          1274 => Opcode::CMOV_GR32,
          1275 => Opcode::CMOV_GR8,
          1276 => Opcode::CMOV_RFP32,
          1277 => Opcode::CMOV_RFP64,
          1278 => Opcode::CMOV_RFP80,
          1279 => Opcode::CMOV_VK1,
          1280 => Opcode::CMOV_VK16,
          1281 => Opcode::CMOV_VK2,
          1282 => Opcode::CMOV_VK32,
          1283 => Opcode::CMOV_VK4,
          1284 => Opcode::CMOV_VK64,
          1285 => Opcode::CMOV_VK8,
          1286 => Opcode::CMOV_VR128,
          1287 => Opcode::CMOV_VR128X,
          1288 => Opcode::CMOV_VR256,
          1289 => Opcode::CMOV_VR256X,
          1290 => Opcode::CMOV_VR512,
          1291 => Opcode::CMOV_VR64,
          1292 => Opcode::CMP16i16,
          1293 => Opcode::CMP16mi,
          1294 => Opcode::CMP16mi8,
          1295 => Opcode::CMP16mr,
          1296 => Opcode::CMP16ri,
          1297 => Opcode::CMP16ri8,
          1298 => Opcode::CMP16rm,
          1299 => Opcode::CMP16rr,
          1300 => Opcode::CMP16rr_REV,
          1301 => Opcode::CMP32i32,
          1302 => Opcode::CMP32mi,
          1303 => Opcode::CMP32mi8,
          1304 => Opcode::CMP32mr,
          1305 => Opcode::CMP32ri,
          1306 => Opcode::CMP32ri8,
          1307 => Opcode::CMP32rm,
          1308 => Opcode::CMP32rr,
          1309 => Opcode::CMP32rr_REV,
          1310 => Opcode::CMP64i32,
          1311 => Opcode::CMP64mi32,
          1312 => Opcode::CMP64mi8,
          1313 => Opcode::CMP64mr,
          1314 => Opcode::CMP64ri32,
          1315 => Opcode::CMP64ri8,
          1316 => Opcode::CMP64rm,
          1317 => Opcode::CMP64rr,
          1318 => Opcode::CMP64rr_REV,
          1319 => Opcode::CMP8i8,
          1320 => Opcode::CMP8mi,
          1321 => Opcode::CMP8mi8,
          1322 => Opcode::CMP8mr,
          1323 => Opcode::CMP8ri,
          1324 => Opcode::CMP8ri8,
          1325 => Opcode::CMP8rm,
          1326 => Opcode::CMP8rr,
          1327 => Opcode::CMP8rr_REV,
          1328 => Opcode::CMPCCXADDmr32,
          1329 => Opcode::CMPCCXADDmr32_EVEX,
          1330 => Opcode::CMPCCXADDmr64,
          1331 => Opcode::CMPCCXADDmr64_EVEX,
          1332 => Opcode::CMPPDrmi,
          1333 => Opcode::CMPPDrri,
          1334 => Opcode::CMPPSrmi,
          1335 => Opcode::CMPPSrri,
          1336 => Opcode::CMPSB,
          1337 => Opcode::CMPSDrmi,
          1338 => Opcode::CMPSDrmi_Int,
          1339 => Opcode::CMPSDrri,
          1340 => Opcode::CMPSDrri_Int,
          1341 => Opcode::CMPSL,
          1342 => Opcode::CMPSQ,
          1343 => Opcode::CMPSSrmi,
          1344 => Opcode::CMPSSrmi_Int,
          1345 => Opcode::CMPSSrri,
          1346 => Opcode::CMPSSrri_Int,
          1347 => Opcode::CMPSW,
          1348 => Opcode::CMPXCHG16B,
          1349 => Opcode::CMPXCHG16rm,
          1350 => Opcode::CMPXCHG16rr,
          1351 => Opcode::CMPXCHG32rm,
          1352 => Opcode::CMPXCHG32rr,
          1353 => Opcode::CMPXCHG64rm,
          1354 => Opcode::CMPXCHG64rr,
          1355 => Opcode::CMPXCHG8B,
          1356 => Opcode::CMPXCHG8rm,
          1357 => Opcode::CMPXCHG8rr,
          1358 => Opcode::COMISDrm,
          1359 => Opcode::COMISDrm_Int,
          1360 => Opcode::COMISDrr,
          1361 => Opcode::COMISDrr_Int,
          1362 => Opcode::COMISSrm,
          1363 => Opcode::COMISSrm_Int,
          1364 => Opcode::COMISSrr,
          1365 => Opcode::COMISSrr_Int,
          1366 => Opcode::COMP_FST0r,
          1367 => Opcode::COM_FIPr,
          1368 => Opcode::COM_FIr,
          1369 => Opcode::COM_FST0r,
          1370 => Opcode::COM_FpIr32,
          1371 => Opcode::COM_FpIr64,
          1372 => Opcode::COM_FpIr80,
          1373 => Opcode::COM_Fpr32,
          1374 => Opcode::COM_Fpr64,
          1375 => Opcode::COM_Fpr80,
          1376 => Opcode::CPUID,
          1377 => Opcode::CQO,
          1378 => Opcode::CRC32r32m16,
          1379 => Opcode::CRC32r32m16_EVEX,
          1380 => Opcode::CRC32r32m32,
          1381 => Opcode::CRC32r32m32_EVEX,
          1382 => Opcode::CRC32r32m8,
          1383 => Opcode::CRC32r32m8_EVEX,
          1384 => Opcode::CRC32r32r16,
          1385 => Opcode::CRC32r32r16_EVEX,
          1386 => Opcode::CRC32r32r32,
          1387 => Opcode::CRC32r32r32_EVEX,
          1388 => Opcode::CRC32r32r8,
          1389 => Opcode::CRC32r32r8_EVEX,
          1390 => Opcode::CRC32r64m64,
          1391 => Opcode::CRC32r64m64_EVEX,
          1392 => Opcode::CRC32r64m8,
          1393 => Opcode::CRC32r64m8_EVEX,
          1394 => Opcode::CRC32r64r64,
          1395 => Opcode::CRC32r64r64_EVEX,
          1396 => Opcode::CRC32r64r8,
          1397 => Opcode::CRC32r64r8_EVEX,
          1398 => Opcode::CS_PREFIX,
          1399 => Opcode::CTEST16mi,
          1400 => Opcode::CTEST16mr,
          1401 => Opcode::CTEST16ri,
          1402 => Opcode::CTEST16rr,
          1403 => Opcode::CTEST32mi,
          1404 => Opcode::CTEST32mr,
          1405 => Opcode::CTEST32ri,
          1406 => Opcode::CTEST32rr,
          1407 => Opcode::CTEST64mi32,
          1408 => Opcode::CTEST64mr,
          1409 => Opcode::CTEST64ri32,
          1410 => Opcode::CTEST64rr,
          1411 => Opcode::CTEST8mi,
          1412 => Opcode::CTEST8mr,
          1413 => Opcode::CTEST8ri,
          1414 => Opcode::CTEST8rr,
          1415 => Opcode::CVTDQ2PDrm,
          1416 => Opcode::CVTDQ2PDrr,
          1417 => Opcode::CVTDQ2PSrm,
          1418 => Opcode::CVTDQ2PSrr,
          1419 => Opcode::CVTPD2DQrm,
          1420 => Opcode::CVTPD2DQrr,
          1421 => Opcode::CVTPD2PSrm,
          1422 => Opcode::CVTPD2PSrr,
          1423 => Opcode::CVTPS2DQrm,
          1424 => Opcode::CVTPS2DQrr,
          1425 => Opcode::CVTPS2PDrm,
          1426 => Opcode::CVTPS2PDrr,
          1427 => Opcode::CVTSD2SI64rm,
          1428 => Opcode::CVTSD2SI64rm_Int,
          1429 => Opcode::CVTSD2SI64rr,
          1430 => Opcode::CVTSD2SI64rr_Int,
          1431 => Opcode::CVTSD2SIrm,
          1432 => Opcode::CVTSD2SIrm_Int,
          1433 => Opcode::CVTSD2SIrr,
          1434 => Opcode::CVTSD2SIrr_Int,
          1435 => Opcode::CVTSD2SSrm,
          1436 => Opcode::CVTSD2SSrm_Int,
          1437 => Opcode::CVTSD2SSrr,
          1438 => Opcode::CVTSD2SSrr_Int,
          1439 => Opcode::CVTSI2SDrm,
          1440 => Opcode::CVTSI2SDrm_Int,
          1441 => Opcode::CVTSI2SDrr,
          1442 => Opcode::CVTSI2SDrr_Int,
          1443 => Opcode::CVTSI2SSrm,
          1444 => Opcode::CVTSI2SSrm_Int,
          1445 => Opcode::CVTSI2SSrr,
          1446 => Opcode::CVTSI2SSrr_Int,
          1447 => Opcode::CVTSI642SDrm,
          1448 => Opcode::CVTSI642SDrm_Int,
          1449 => Opcode::CVTSI642SDrr,
          1450 => Opcode::CVTSI642SDrr_Int,
          1451 => Opcode::CVTSI642SSrm,
          1452 => Opcode::CVTSI642SSrm_Int,
          1453 => Opcode::CVTSI642SSrr,
          1454 => Opcode::CVTSI642SSrr_Int,
          1455 => Opcode::CVTSS2SDrm,
          1456 => Opcode::CVTSS2SDrm_Int,
          1457 => Opcode::CVTSS2SDrr,
          1458 => Opcode::CVTSS2SDrr_Int,
          1459 => Opcode::CVTSS2SI64rm,
          1460 => Opcode::CVTSS2SI64rm_Int,
          1461 => Opcode::CVTSS2SI64rr,
          1462 => Opcode::CVTSS2SI64rr_Int,
          1463 => Opcode::CVTSS2SIrm,
          1464 => Opcode::CVTSS2SIrm_Int,
          1465 => Opcode::CVTSS2SIrr,
          1466 => Opcode::CVTSS2SIrr_Int,
          1467 => Opcode::CVTTPD2DQrm,
          1468 => Opcode::CVTTPD2DQrr,
          1469 => Opcode::CVTTPS2DQrm,
          1470 => Opcode::CVTTPS2DQrr,
          1471 => Opcode::CVTTSD2SI64rm,
          1472 => Opcode::CVTTSD2SI64rm_Int,
          1473 => Opcode::CVTTSD2SI64rr,
          1474 => Opcode::CVTTSD2SI64rr_Int,
          1475 => Opcode::CVTTSD2SIrm,
          1476 => Opcode::CVTTSD2SIrm_Int,
          1477 => Opcode::CVTTSD2SIrr,
          1478 => Opcode::CVTTSD2SIrr_Int,
          1479 => Opcode::CVTTSS2SI64rm,
          1480 => Opcode::CVTTSS2SI64rm_Int,
          1481 => Opcode::CVTTSS2SI64rr,
          1482 => Opcode::CVTTSS2SI64rr_Int,
          1483 => Opcode::CVTTSS2SIrm,
          1484 => Opcode::CVTTSS2SIrm_Int,
          1485 => Opcode::CVTTSS2SIrr,
          1486 => Opcode::CVTTSS2SIrr_Int,
          1487 => Opcode::CWD,
          1488 => Opcode::CWDE,
          1489 => Opcode::DAA,
          1490 => Opcode::DAS,
          1491 => Opcode::DATA16_PREFIX,
          1492 => Opcode::DEC16m,
          1493 => Opcode::DEC16m_EVEX,
          1494 => Opcode::DEC16m_ND,
          1495 => Opcode::DEC16m_NF,
          1496 => Opcode::DEC16m_NF_ND,
          1497 => Opcode::DEC16r,
          1498 => Opcode::DEC16r_EVEX,
          1499 => Opcode::DEC16r_ND,
          1500 => Opcode::DEC16r_NF,
          1501 => Opcode::DEC16r_NF_ND,
          1502 => Opcode::DEC16r_alt,
          1503 => Opcode::DEC32m,
          1504 => Opcode::DEC32m_EVEX,
          1505 => Opcode::DEC32m_ND,
          1506 => Opcode::DEC32m_NF,
          1507 => Opcode::DEC32m_NF_ND,
          1508 => Opcode::DEC32r,
          1509 => Opcode::DEC32r_EVEX,
          1510 => Opcode::DEC32r_ND,
          1511 => Opcode::DEC32r_NF,
          1512 => Opcode::DEC32r_NF_ND,
          1513 => Opcode::DEC32r_alt,
          1514 => Opcode::DEC64m,
          1515 => Opcode::DEC64m_EVEX,
          1516 => Opcode::DEC64m_ND,
          1517 => Opcode::DEC64m_NF,
          1518 => Opcode::DEC64m_NF_ND,
          1519 => Opcode::DEC64r,
          1520 => Opcode::DEC64r_EVEX,
          1521 => Opcode::DEC64r_ND,
          1522 => Opcode::DEC64r_NF,
          1523 => Opcode::DEC64r_NF_ND,
          1524 => Opcode::DEC8m,
          1525 => Opcode::DEC8m_EVEX,
          1526 => Opcode::DEC8m_ND,
          1527 => Opcode::DEC8m_NF,
          1528 => Opcode::DEC8m_NF_ND,
          1529 => Opcode::DEC8r,
          1530 => Opcode::DEC8r_EVEX,
          1531 => Opcode::DEC8r_ND,
          1532 => Opcode::DEC8r_NF,
          1533 => Opcode::DEC8r_NF_ND,
          1534 => Opcode::DIV16m,
          1535 => Opcode::DIV16m_EVEX,
          1536 => Opcode::DIV16m_NF,
          1537 => Opcode::DIV16r,
          1538 => Opcode::DIV16r_EVEX,
          1539 => Opcode::DIV16r_NF,
          1540 => Opcode::DIV32m,
          1541 => Opcode::DIV32m_EVEX,
          1542 => Opcode::DIV32m_NF,
          1543 => Opcode::DIV32r,
          1544 => Opcode::DIV32r_EVEX,
          1545 => Opcode::DIV32r_NF,
          1546 => Opcode::DIV64m,
          1547 => Opcode::DIV64m_EVEX,
          1548 => Opcode::DIV64m_NF,
          1549 => Opcode::DIV64r,
          1550 => Opcode::DIV64r_EVEX,
          1551 => Opcode::DIV64r_NF,
          1552 => Opcode::DIV8m,
          1553 => Opcode::DIV8m_EVEX,
          1554 => Opcode::DIV8m_NF,
          1555 => Opcode::DIV8r,
          1556 => Opcode::DIV8r_EVEX,
          1557 => Opcode::DIV8r_NF,
          1558 => Opcode::DIVPDrm,
          1559 => Opcode::DIVPDrr,
          1560 => Opcode::DIVPSrm,
          1561 => Opcode::DIVPSrr,
          1562 => Opcode::DIVR_F32m,
          1563 => Opcode::DIVR_F64m,
          1564 => Opcode::DIVR_FI16m,
          1565 => Opcode::DIVR_FI32m,
          1566 => Opcode::DIVR_FPrST0,
          1567 => Opcode::DIVR_FST0r,
          1568 => Opcode::DIVR_Fp32m,
          1569 => Opcode::DIVR_Fp64m,
          1570 => Opcode::DIVR_Fp64m32,
          1571 => Opcode::DIVR_Fp80m32,
          1572 => Opcode::DIVR_Fp80m64,
          1573 => Opcode::DIVR_FpI16m32,
          1574 => Opcode::DIVR_FpI16m64,
          1575 => Opcode::DIVR_FpI16m80,
          1576 => Opcode::DIVR_FpI32m32,
          1577 => Opcode::DIVR_FpI32m64,
          1578 => Opcode::DIVR_FpI32m80,
          1579 => Opcode::DIVR_FrST0,
          1580 => Opcode::DIVSDrm,
          1581 => Opcode::DIVSDrm_Int,
          1582 => Opcode::DIVSDrr,
          1583 => Opcode::DIVSDrr_Int,
          1584 => Opcode::DIVSSrm,
          1585 => Opcode::DIVSSrm_Int,
          1586 => Opcode::DIVSSrr,
          1587 => Opcode::DIVSSrr_Int,
          1588 => Opcode::DIV_F32m,
          1589 => Opcode::DIV_F64m,
          1590 => Opcode::DIV_FI16m,
          1591 => Opcode::DIV_FI32m,
          1592 => Opcode::DIV_FPrST0,
          1593 => Opcode::DIV_FST0r,
          1594 => Opcode::DIV_Fp32,
          1595 => Opcode::DIV_Fp32m,
          1596 => Opcode::DIV_Fp64,
          1597 => Opcode::DIV_Fp64m,
          1598 => Opcode::DIV_Fp64m32,
          1599 => Opcode::DIV_Fp80,
          1600 => Opcode::DIV_Fp80m32,
          1601 => Opcode::DIV_Fp80m64,
          1602 => Opcode::DIV_FpI16m32,
          1603 => Opcode::DIV_FpI16m64,
          1604 => Opcode::DIV_FpI16m80,
          1605 => Opcode::DIV_FpI32m32,
          1606 => Opcode::DIV_FpI32m64,
          1607 => Opcode::DIV_FpI32m80,
          1608 => Opcode::DIV_FrST0,
          1609 => Opcode::DPPDrmi,
          1610 => Opcode::DPPDrri,
          1611 => Opcode::DPPSrmi,
          1612 => Opcode::DPPSrri,
          1613 => Opcode::DS_PREFIX,
          1614 => Opcode::DYN_ALLOCA_32,
          1615 => Opcode::DYN_ALLOCA_64,
          1616 => Opcode::EH_RETURN,
          1617 => Opcode::EH_RETURN64,
          1618 => Opcode::EH_SjLj_LongJmp32,
          1619 => Opcode::EH_SjLj_LongJmp64,
          1620 => Opcode::EH_SjLj_SetJmp32,
          1621 => Opcode::EH_SjLj_SetJmp64,
          1622 => Opcode::EH_SjLj_Setup,
          1623 => Opcode::ENCLS,
          1624 => Opcode::ENCLU,
          1625 => Opcode::ENCLV,
          1626 => Opcode::ENCODEKEY128,
          1627 => Opcode::ENCODEKEY256,
          1628 => Opcode::ENDBR32,
          1629 => Opcode::ENDBR64,
          1630 => Opcode::ENQCMD16,
          1631 => Opcode::ENQCMD32,
          1632 => Opcode::ENQCMD32_EVEX,
          1633 => Opcode::ENQCMD64,
          1634 => Opcode::ENQCMD64_EVEX,
          1635 => Opcode::ENQCMDS16,
          1636 => Opcode::ENQCMDS32,
          1637 => Opcode::ENQCMDS32_EVEX,
          1638 => Opcode::ENQCMDS64,
          1639 => Opcode::ENQCMDS64_EVEX,
          1640 => Opcode::ENTER,
          1641 => Opcode::ERETS,
          1642 => Opcode::ERETU,
          1643 => Opcode::ES_PREFIX,
          1644 => Opcode::EXTRACTPSmri,
          1645 => Opcode::EXTRACTPSrri,
          1646 => Opcode::EXTRQ,
          1647 => Opcode::EXTRQI,
          1648 => Opcode::F2XM1,
          1649 => Opcode::FARCALL16i,
          1650 => Opcode::FARCALL16m,
          1651 => Opcode::FARCALL32i,
          1652 => Opcode::FARCALL32m,
          1653 => Opcode::FARCALL64m,
          1654 => Opcode::FARJMP16i,
          1655 => Opcode::FARJMP16m,
          1656 => Opcode::FARJMP32i,
          1657 => Opcode::FARJMP32m,
          1658 => Opcode::FARJMP64m,
          1659 => Opcode::FBLDm,
          1660 => Opcode::FBSTPm,
          1661 => Opcode::FCOM32m,
          1662 => Opcode::FCOM64m,
          1663 => Opcode::FCOMP32m,
          1664 => Opcode::FCOMP64m,
          1665 => Opcode::FCOMPP,
          1666 => Opcode::FCOS,
          1667 => Opcode::FDECSTP,
          1668 => Opcode::FEMMS,
          1669 => Opcode::FFREE,
          1670 => Opcode::FFREEP,
          1671 => Opcode::FICOM16m,
          1672 => Opcode::FICOM32m,
          1673 => Opcode::FICOMP16m,
          1674 => Opcode::FICOMP32m,
          1675 => Opcode::FINCSTP,
          1676 => Opcode::FLDCW16m,
          1677 => Opcode::FLDENVm,
          1678 => Opcode::FLDL2E,
          1679 => Opcode::FLDL2T,
          1680 => Opcode::FLDLG2,
          1681 => Opcode::FLDLN2,
          1682 => Opcode::FLDPI,
          1683 => Opcode::FNCLEX,
          1684 => Opcode::FNINIT,
          1685 => Opcode::FNOP,
          1686 => Opcode::FNSTCW16m,
          1687 => Opcode::FNSTSW16r,
          1688 => Opcode::FNSTSWm,
          1689 => Opcode::FP32_TO_INT16_IN_MEM,
          1690 => Opcode::FP32_TO_INT32_IN_MEM,
          1691 => Opcode::FP32_TO_INT64_IN_MEM,
          1692 => Opcode::FP64_TO_INT16_IN_MEM,
          1693 => Opcode::FP64_TO_INT32_IN_MEM,
          1694 => Opcode::FP64_TO_INT64_IN_MEM,
          1695 => Opcode::FP80_ADDm32,
          1696 => Opcode::FP80_ADDr,
          1697 => Opcode::FP80_TO_INT16_IN_MEM,
          1698 => Opcode::FP80_TO_INT32_IN_MEM,
          1699 => Opcode::FP80_TO_INT64_IN_MEM,
          1700 => Opcode::FPATAN,
          1701 => Opcode::FPREM,
          1702 => Opcode::FPREM1,
          1703 => Opcode::FPTAN,
          1704 => Opcode::FRNDINT,
          1705 => Opcode::FRSTORm,
          1706 => Opcode::FSAVEm,
          1707 => Opcode::FSCALE,
          1708 => Opcode::FSIN,
          1709 => Opcode::FSINCOS,
          1710 => Opcode::FSTENVm,
          1711 => Opcode::FS_PREFIX,
          1712 => Opcode::FXRSTOR,
          1713 => Opcode::FXRSTOR64,
          1714 => Opcode::FXSAVE,
          1715 => Opcode::FXSAVE64,
          1716 => Opcode::FXTRACT,
          1717 => Opcode::FYL2X,
          1718 => Opcode::FYL2XP1,
          1719 => Opcode::GETSEC,
          1720 => Opcode::GF2P8AFFINEINVQBrmi,
          1721 => Opcode::GF2P8AFFINEINVQBrri,
          1722 => Opcode::GF2P8AFFINEQBrmi,
          1723 => Opcode::GF2P8AFFINEQBrri,
          1724 => Opcode::GF2P8MULBrm,
          1725 => Opcode::GF2P8MULBrr,
          1726 => Opcode::GS_PREFIX,
          1727 => Opcode::HADDPDrm,
          1728 => Opcode::HADDPDrr,
          1729 => Opcode::HADDPSrm,
          1730 => Opcode::HADDPSrr,
          1731 => Opcode::HLT,
          1732 => Opcode::HRESET,
          1733 => Opcode::HSUBPDrm,
          1734 => Opcode::HSUBPDrr,
          1735 => Opcode::HSUBPSrm,
          1736 => Opcode::HSUBPSrr,
          1737 => Opcode::IDIV16m,
          1738 => Opcode::IDIV16m_EVEX,
          1739 => Opcode::IDIV16m_NF,
          1740 => Opcode::IDIV16r,
          1741 => Opcode::IDIV16r_EVEX,
          1742 => Opcode::IDIV16r_NF,
          1743 => Opcode::IDIV32m,
          1744 => Opcode::IDIV32m_EVEX,
          1745 => Opcode::IDIV32m_NF,
          1746 => Opcode::IDIV32r,
          1747 => Opcode::IDIV32r_EVEX,
          1748 => Opcode::IDIV32r_NF,
          1749 => Opcode::IDIV64m,
          1750 => Opcode::IDIV64m_EVEX,
          1751 => Opcode::IDIV64m_NF,
          1752 => Opcode::IDIV64r,
          1753 => Opcode::IDIV64r_EVEX,
          1754 => Opcode::IDIV64r_NF,
          1755 => Opcode::IDIV8m,
          1756 => Opcode::IDIV8m_EVEX,
          1757 => Opcode::IDIV8m_NF,
          1758 => Opcode::IDIV8r,
          1759 => Opcode::IDIV8r_EVEX,
          1760 => Opcode::IDIV8r_NF,
          1761 => Opcode::ILD_F16m,
          1762 => Opcode::ILD_F32m,
          1763 => Opcode::ILD_F64m,
          1764 => Opcode::ILD_Fp16m32,
          1765 => Opcode::ILD_Fp16m64,
          1766 => Opcode::ILD_Fp16m80,
          1767 => Opcode::ILD_Fp32m32,
          1768 => Opcode::ILD_Fp32m64,
          1769 => Opcode::ILD_Fp32m80,
          1770 => Opcode::ILD_Fp64m32,
          1771 => Opcode::ILD_Fp64m64,
          1772 => Opcode::ILD_Fp64m80,
          1773 => Opcode::IMUL16m,
          1774 => Opcode::IMUL16m_EVEX,
          1775 => Opcode::IMUL16m_NF,
          1776 => Opcode::IMUL16r,
          1777 => Opcode::IMUL16r_EVEX,
          1778 => Opcode::IMUL16r_NF,
          1779 => Opcode::IMUL16rm,
          1780 => Opcode::IMUL16rm_EVEX,
          1781 => Opcode::IMUL16rm_ND,
          1782 => Opcode::IMUL16rm_NF,
          1783 => Opcode::IMUL16rm_NF_ND,
          1784 => Opcode::IMUL16rmi,
          1785 => Opcode::IMUL16rmi8,
          1786 => Opcode::IMUL16rmi8_EVEX,
          1787 => Opcode::IMUL16rmi8_NF,
          1788 => Opcode::IMUL16rmi_EVEX,
          1789 => Opcode::IMUL16rmi_NF,
          1790 => Opcode::IMUL16rr,
          1791 => Opcode::IMUL16rr_EVEX,
          1792 => Opcode::IMUL16rr_ND,
          1793 => Opcode::IMUL16rr_NF,
          1794 => Opcode::IMUL16rr_NF_ND,
          1795 => Opcode::IMUL16rri,
          1796 => Opcode::IMUL16rri8,
          1797 => Opcode::IMUL16rri8_EVEX,
          1798 => Opcode::IMUL16rri8_NF,
          1799 => Opcode::IMUL16rri_EVEX,
          1800 => Opcode::IMUL16rri_NF,
          1801 => Opcode::IMUL32m,
          1802 => Opcode::IMUL32m_EVEX,
          1803 => Opcode::IMUL32m_NF,
          1804 => Opcode::IMUL32r,
          1805 => Opcode::IMUL32r_EVEX,
          1806 => Opcode::IMUL32r_NF,
          1807 => Opcode::IMUL32rm,
          1808 => Opcode::IMUL32rm_EVEX,
          1809 => Opcode::IMUL32rm_ND,
          1810 => Opcode::IMUL32rm_NF,
          1811 => Opcode::IMUL32rm_NF_ND,
          1812 => Opcode::IMUL32rmi,
          1813 => Opcode::IMUL32rmi8,
          1814 => Opcode::IMUL32rmi8_EVEX,
          1815 => Opcode::IMUL32rmi8_NF,
          1816 => Opcode::IMUL32rmi_EVEX,
          1817 => Opcode::IMUL32rmi_NF,
          1818 => Opcode::IMUL32rr,
          1819 => Opcode::IMUL32rr_EVEX,
          1820 => Opcode::IMUL32rr_ND,
          1821 => Opcode::IMUL32rr_NF,
          1822 => Opcode::IMUL32rr_NF_ND,
          1823 => Opcode::IMUL32rri,
          1824 => Opcode::IMUL32rri8,
          1825 => Opcode::IMUL32rri8_EVEX,
          1826 => Opcode::IMUL32rri8_NF,
          1827 => Opcode::IMUL32rri_EVEX,
          1828 => Opcode::IMUL32rri_NF,
          1829 => Opcode::IMUL64m,
          1830 => Opcode::IMUL64m_EVEX,
          1831 => Opcode::IMUL64m_NF,
          1832 => Opcode::IMUL64r,
          1833 => Opcode::IMUL64r_EVEX,
          1834 => Opcode::IMUL64r_NF,
          1835 => Opcode::IMUL64rm,
          1836 => Opcode::IMUL64rm_EVEX,
          1837 => Opcode::IMUL64rm_ND,
          1838 => Opcode::IMUL64rm_NF,
          1839 => Opcode::IMUL64rm_NF_ND,
          1840 => Opcode::IMUL64rmi32,
          1841 => Opcode::IMUL64rmi32_EVEX,
          1842 => Opcode::IMUL64rmi32_NF,
          1843 => Opcode::IMUL64rmi8,
          1844 => Opcode::IMUL64rmi8_EVEX,
          1845 => Opcode::IMUL64rmi8_NF,
          1846 => Opcode::IMUL64rr,
          1847 => Opcode::IMUL64rr_EVEX,
          1848 => Opcode::IMUL64rr_ND,
          1849 => Opcode::IMUL64rr_NF,
          1850 => Opcode::IMUL64rr_NF_ND,
          1851 => Opcode::IMUL64rri32,
          1852 => Opcode::IMUL64rri32_EVEX,
          1853 => Opcode::IMUL64rri32_NF,
          1854 => Opcode::IMUL64rri8,
          1855 => Opcode::IMUL64rri8_EVEX,
          1856 => Opcode::IMUL64rri8_NF,
          1857 => Opcode::IMUL8m,
          1858 => Opcode::IMUL8m_EVEX,
          1859 => Opcode::IMUL8m_NF,
          1860 => Opcode::IMUL8r,
          1861 => Opcode::IMUL8r_EVEX,
          1862 => Opcode::IMUL8r_NF,
          1863 => Opcode::IMULZU16rmi,
          1864 => Opcode::IMULZU16rmi8,
          1865 => Opcode::IMULZU16rri,
          1866 => Opcode::IMULZU16rri8,
          1867 => Opcode::IMULZU32rmi,
          1868 => Opcode::IMULZU32rmi8,
          1869 => Opcode::IMULZU32rri,
          1870 => Opcode::IMULZU32rri8,
          1871 => Opcode::IMULZU64rmi32,
          1872 => Opcode::IMULZU64rmi8,
          1873 => Opcode::IMULZU64rri32,
          1874 => Opcode::IMULZU64rri8,
          1875 => Opcode::IN16ri,
          1876 => Opcode::IN16rr,
          1877 => Opcode::IN32ri,
          1878 => Opcode::IN32rr,
          1879 => Opcode::IN8ri,
          1880 => Opcode::IN8rr,
          1881 => Opcode::INC16m,
          1882 => Opcode::INC16m_EVEX,
          1883 => Opcode::INC16m_ND,
          1884 => Opcode::INC16m_NF,
          1885 => Opcode::INC16m_NF_ND,
          1886 => Opcode::INC16r,
          1887 => Opcode::INC16r_EVEX,
          1888 => Opcode::INC16r_ND,
          1889 => Opcode::INC16r_NF,
          1890 => Opcode::INC16r_NF_ND,
          1891 => Opcode::INC16r_alt,
          1892 => Opcode::INC32m,
          1893 => Opcode::INC32m_EVEX,
          1894 => Opcode::INC32m_ND,
          1895 => Opcode::INC32m_NF,
          1896 => Opcode::INC32m_NF_ND,
          1897 => Opcode::INC32r,
          1898 => Opcode::INC32r_EVEX,
          1899 => Opcode::INC32r_ND,
          1900 => Opcode::INC32r_NF,
          1901 => Opcode::INC32r_NF_ND,
          1902 => Opcode::INC32r_alt,
          1903 => Opcode::INC64m,
          1904 => Opcode::INC64m_EVEX,
          1905 => Opcode::INC64m_ND,
          1906 => Opcode::INC64m_NF,
          1907 => Opcode::INC64m_NF_ND,
          1908 => Opcode::INC64r,
          1909 => Opcode::INC64r_EVEX,
          1910 => Opcode::INC64r_ND,
          1911 => Opcode::INC64r_NF,
          1912 => Opcode::INC64r_NF_ND,
          1913 => Opcode::INC8m,
          1914 => Opcode::INC8m_EVEX,
          1915 => Opcode::INC8m_ND,
          1916 => Opcode::INC8m_NF,
          1917 => Opcode::INC8m_NF_ND,
          1918 => Opcode::INC8r,
          1919 => Opcode::INC8r_EVEX,
          1920 => Opcode::INC8r_ND,
          1921 => Opcode::INC8r_NF,
          1922 => Opcode::INC8r_NF_ND,
          1923 => Opcode::INCSSPD,
          1924 => Opcode::INCSSPQ,
          1925 => Opcode::INSB,
          1926 => Opcode::INSERTPSrmi,
          1927 => Opcode::INSERTPSrri,
          1928 => Opcode::INSERTQ,
          1929 => Opcode::INSERTQI,
          1930 => Opcode::INSL,
          1931 => Opcode::INSW,
          1932 => Opcode::INT,
          1933 => Opcode::INT3,
          1934 => Opcode::INTO,
          1935 => Opcode::INVD,
          1936 => Opcode::INVEPT32,
          1937 => Opcode::INVEPT64,
          1938 => Opcode::INVEPT64_EVEX,
          1939 => Opcode::INVLPG,
          1940 => Opcode::INVLPGA32,
          1941 => Opcode::INVLPGA64,
          1942 => Opcode::INVLPGB32,
          1943 => Opcode::INVLPGB64,
          1944 => Opcode::INVPCID32,
          1945 => Opcode::INVPCID64,
          1946 => Opcode::INVPCID64_EVEX,
          1947 => Opcode::INVVPID32,
          1948 => Opcode::INVVPID64,
          1949 => Opcode::INVVPID64_EVEX,
          1950 => Opcode::IRET,
          1951 => Opcode::IRET16,
          1952 => Opcode::IRET32,
          1953 => Opcode::IRET64,
          1954 => Opcode::ISTT_FP16m,
          1955 => Opcode::ISTT_FP32m,
          1956 => Opcode::ISTT_FP64m,
          1957 => Opcode::ISTT_Fp16m32,
          1958 => Opcode::ISTT_Fp16m64,
          1959 => Opcode::ISTT_Fp16m80,
          1960 => Opcode::ISTT_Fp32m32,
          1961 => Opcode::ISTT_Fp32m64,
          1962 => Opcode::ISTT_Fp32m80,
          1963 => Opcode::ISTT_Fp64m32,
          1964 => Opcode::ISTT_Fp64m64,
          1965 => Opcode::ISTT_Fp64m80,
          1966 => Opcode::IST_F16m,
          1967 => Opcode::IST_F32m,
          1968 => Opcode::IST_FP16m,
          1969 => Opcode::IST_FP32m,
          1970 => Opcode::IST_FP64m,
          1971 => Opcode::IST_Fp16m32,
          1972 => Opcode::IST_Fp16m64,
          1973 => Opcode::IST_Fp16m80,
          1974 => Opcode::IST_Fp32m32,
          1975 => Opcode::IST_Fp32m64,
          1976 => Opcode::IST_Fp32m80,
          1977 => Opcode::IST_Fp64m32,
          1978 => Opcode::IST_Fp64m64,
          1979 => Opcode::IST_Fp64m80,
          1980 => Opcode::Int_eh_sjlj_setup_dispatch,
          1981 => Opcode::JCC_1,
          1982 => Opcode::JCC_2,
          1983 => Opcode::JCC_4,
          1984 => Opcode::JCXZ,
          1985 => Opcode::JECXZ,
          1986 => Opcode::JMP16m,
          1987 => Opcode::JMP16m_NT,
          1988 => Opcode::JMP16r,
          1989 => Opcode::JMP16r_NT,
          1990 => Opcode::JMP32m,
          1991 => Opcode::JMP32m_NT,
          1992 => Opcode::JMP32r,
          1993 => Opcode::JMP32r_NT,
          1994 => Opcode::JMP64m,
          1995 => Opcode::JMP64m_NT,
          1996 => Opcode::JMP64m_REX,
          1997 => Opcode::JMP64r,
          1998 => Opcode::JMP64r_NT,
          1999 => Opcode::JMP64r_REX,
          2000 => Opcode::JMPABS64i,
          2001 => Opcode::JMP_1,
          2002 => Opcode::JMP_2,
          2003 => Opcode::JMP_4,
          2004 => Opcode::JRCXZ,
          2005 => Opcode::KADDBkk,
          2006 => Opcode::KADDDkk,
          2007 => Opcode::KADDQkk,
          2008 => Opcode::KADDWkk,
          2009 => Opcode::KANDBkk,
          2010 => Opcode::KANDDkk,
          2011 => Opcode::KANDNBkk,
          2012 => Opcode::KANDNDkk,
          2013 => Opcode::KANDNQkk,
          2014 => Opcode::KANDNWkk,
          2015 => Opcode::KANDQkk,
          2016 => Opcode::KANDWkk,
          2017 => Opcode::KCFI_CHECK,
          2018 => Opcode::KMOVBkk,
          2019 => Opcode::KMOVBkk_EVEX,
          2020 => Opcode::KMOVBkm,
          2021 => Opcode::KMOVBkm_EVEX,
          2022 => Opcode::KMOVBkr,
          2023 => Opcode::KMOVBkr_EVEX,
          2024 => Opcode::KMOVBmk,
          2025 => Opcode::KMOVBmk_EVEX,
          2026 => Opcode::KMOVBrk,
          2027 => Opcode::KMOVBrk_EVEX,
          2028 => Opcode::KMOVDkk,
          2029 => Opcode::KMOVDkk_EVEX,
          2030 => Opcode::KMOVDkm,
          2031 => Opcode::KMOVDkm_EVEX,
          2032 => Opcode::KMOVDkr,
          2033 => Opcode::KMOVDkr_EVEX,
          2034 => Opcode::KMOVDmk,
          2035 => Opcode::KMOVDmk_EVEX,
          2036 => Opcode::KMOVDrk,
          2037 => Opcode::KMOVDrk_EVEX,
          2038 => Opcode::KMOVQkk,
          2039 => Opcode::KMOVQkk_EVEX,
          2040 => Opcode::KMOVQkm,
          2041 => Opcode::KMOVQkm_EVEX,
          2042 => Opcode::KMOVQkr,
          2043 => Opcode::KMOVQkr_EVEX,
          2044 => Opcode::KMOVQmk,
          2045 => Opcode::KMOVQmk_EVEX,
          2046 => Opcode::KMOVQrk,
          2047 => Opcode::KMOVQrk_EVEX,
          2048 => Opcode::KMOVWkk,
          2049 => Opcode::KMOVWkk_EVEX,
          2050 => Opcode::KMOVWkm,
          2051 => Opcode::KMOVWkm_EVEX,
          2052 => Opcode::KMOVWkr,
          2053 => Opcode::KMOVWkr_EVEX,
          2054 => Opcode::KMOVWmk,
          2055 => Opcode::KMOVWmk_EVEX,
          2056 => Opcode::KMOVWrk,
          2057 => Opcode::KMOVWrk_EVEX,
          2058 => Opcode::KNOTBkk,
          2059 => Opcode::KNOTDkk,
          2060 => Opcode::KNOTQkk,
          2061 => Opcode::KNOTWkk,
          2062 => Opcode::KORBkk,
          2063 => Opcode::KORDkk,
          2064 => Opcode::KORQkk,
          2065 => Opcode::KORTESTBkk,
          2066 => Opcode::KORTESTDkk,
          2067 => Opcode::KORTESTQkk,
          2068 => Opcode::KORTESTWkk,
          2069 => Opcode::KORWkk,
          2070 => Opcode::KSHIFTLBki,
          2071 => Opcode::KSHIFTLDki,
          2072 => Opcode::KSHIFTLQki,
          2073 => Opcode::KSHIFTLWki,
          2074 => Opcode::KSHIFTRBki,
          2075 => Opcode::KSHIFTRDki,
          2076 => Opcode::KSHIFTRQki,
          2077 => Opcode::KSHIFTRWki,
          2078 => Opcode::KTESTBkk,
          2079 => Opcode::KTESTDkk,
          2080 => Opcode::KTESTQkk,
          2081 => Opcode::KTESTWkk,
          2082 => Opcode::KUNPCKBWkk,
          2083 => Opcode::KUNPCKDQkk,
          2084 => Opcode::KUNPCKWDkk,
          2085 => Opcode::KXNORBkk,
          2086 => Opcode::KXNORDkk,
          2087 => Opcode::KXNORQkk,
          2088 => Opcode::KXNORWkk,
          2089 => Opcode::KXORBkk,
          2090 => Opcode::KXORDkk,
          2091 => Opcode::KXORQkk,
          2092 => Opcode::KXORWkk,
          2093 => Opcode::LAHF,
          2094 => Opcode::LAR16rm,
          2095 => Opcode::LAR16rr,
          2096 => Opcode::LAR32rm,
          2097 => Opcode::LAR32rr,
          2098 => Opcode::LAR64rm,
          2099 => Opcode::LAR64rr,
          2100 => Opcode::LCMPXCHG16,
          2101 => Opcode::LCMPXCHG16B,
          2102 => Opcode::LCMPXCHG32,
          2103 => Opcode::LCMPXCHG64,
          2104 => Opcode::LCMPXCHG8,
          2105 => Opcode::LCMPXCHG8B,
          2106 => Opcode::LDDQUrm,
          2107 => Opcode::LDMXCSR,
          2108 => Opcode::LDS16rm,
          2109 => Opcode::LDS32rm,
          2110 => Opcode::LDTILECFG,
          2111 => Opcode::LDTILECFG_EVEX,
          2112 => Opcode::LD_F0,
          2113 => Opcode::LD_F1,
          2114 => Opcode::LD_F32m,
          2115 => Opcode::LD_F64m,
          2116 => Opcode::LD_F80m,
          2117 => Opcode::LD_Fp032,
          2118 => Opcode::LD_Fp064,
          2119 => Opcode::LD_Fp080,
          2120 => Opcode::LD_Fp132,
          2121 => Opcode::LD_Fp164,
          2122 => Opcode::LD_Fp180,
          2123 => Opcode::LD_Fp32m,
          2124 => Opcode::LD_Fp32m64,
          2125 => Opcode::LD_Fp32m80,
          2126 => Opcode::LD_Fp64m,
          2127 => Opcode::LD_Fp64m80,
          2128 => Opcode::LD_Fp80m,
          2129 => Opcode::LD_Frr,
          2130 => Opcode::LEA16r,
          2131 => Opcode::LEA32r,
          2132 => Opcode::LEA64_16r,
          2133 => Opcode::LEA64_32r,
          2134 => Opcode::LEA64_8r,
          2135 => Opcode::LEA64r,
          2136 => Opcode::LEAVE,
          2137 => Opcode::LEAVE64,
          2138 => Opcode::LES16rm,
          2139 => Opcode::LES32rm,
          2140 => Opcode::LFENCE,
          2141 => Opcode::LFS16rm,
          2142 => Opcode::LFS32rm,
          2143 => Opcode::LFS64rm,
          2144 => Opcode::LGDT16m,
          2145 => Opcode::LGDT32m,
          2146 => Opcode::LGDT64m,
          2147 => Opcode::LGS16rm,
          2148 => Opcode::LGS32rm,
          2149 => Opcode::LGS64rm,
          2150 => Opcode::LIDT16m,
          2151 => Opcode::LIDT32m,
          2152 => Opcode::LIDT64m,
          2153 => Opcode::LKGS16m,
          2154 => Opcode::LKGS16r,
          2155 => Opcode::LLDT16m,
          2156 => Opcode::LLDT16r,
          2157 => Opcode::LLWPCB,
          2158 => Opcode::LLWPCB64,
          2159 => Opcode::LMSW16m,
          2160 => Opcode::LMSW16r,
          2161 => Opcode::LOADIWKEY,
          2162 => Opcode::LOCK_ADD16mi,
          2163 => Opcode::LOCK_ADD16mi8,
          2164 => Opcode::LOCK_ADD16mr,
          2165 => Opcode::LOCK_ADD32mi,
          2166 => Opcode::LOCK_ADD32mi8,
          2167 => Opcode::LOCK_ADD32mr,
          2168 => Opcode::LOCK_ADD64mi32,
          2169 => Opcode::LOCK_ADD64mi8,
          2170 => Opcode::LOCK_ADD64mr,
          2171 => Opcode::LOCK_ADD8mi,
          2172 => Opcode::LOCK_ADD8mr,
          2173 => Opcode::LOCK_AND16mi,
          2174 => Opcode::LOCK_AND16mi8,
          2175 => Opcode::LOCK_AND16mr,
          2176 => Opcode::LOCK_AND32mi,
          2177 => Opcode::LOCK_AND32mi8,
          2178 => Opcode::LOCK_AND32mr,
          2179 => Opcode::LOCK_AND64mi32,
          2180 => Opcode::LOCK_AND64mi8,
          2181 => Opcode::LOCK_AND64mr,
          2182 => Opcode::LOCK_AND8mi,
          2183 => Opcode::LOCK_AND8mr,
          2184 => Opcode::LOCK_BTC16m,
          2185 => Opcode::LOCK_BTC32m,
          2186 => Opcode::LOCK_BTC64m,
          2187 => Opcode::LOCK_BTC_RM16rm,
          2188 => Opcode::LOCK_BTC_RM32rm,
          2189 => Opcode::LOCK_BTC_RM64rm,
          2190 => Opcode::LOCK_BTR16m,
          2191 => Opcode::LOCK_BTR32m,
          2192 => Opcode::LOCK_BTR64m,
          2193 => Opcode::LOCK_BTR_RM16rm,
          2194 => Opcode::LOCK_BTR_RM32rm,
          2195 => Opcode::LOCK_BTR_RM64rm,
          2196 => Opcode::LOCK_BTS16m,
          2197 => Opcode::LOCK_BTS32m,
          2198 => Opcode::LOCK_BTS64m,
          2199 => Opcode::LOCK_BTS_RM16rm,
          2200 => Opcode::LOCK_BTS_RM32rm,
          2201 => Opcode::LOCK_BTS_RM64rm,
          2202 => Opcode::LOCK_DEC16m,
          2203 => Opcode::LOCK_DEC32m,
          2204 => Opcode::LOCK_DEC64m,
          2205 => Opcode::LOCK_DEC8m,
          2206 => Opcode::LOCK_INC16m,
          2207 => Opcode::LOCK_INC32m,
          2208 => Opcode::LOCK_INC64m,
          2209 => Opcode::LOCK_INC8m,
          2210 => Opcode::LOCK_OR16mi,
          2211 => Opcode::LOCK_OR16mi8,
          2212 => Opcode::LOCK_OR16mr,
          2213 => Opcode::LOCK_OR32mi,
          2214 => Opcode::LOCK_OR32mi8,
          2215 => Opcode::LOCK_OR32mr,
          2216 => Opcode::LOCK_OR64mi32,
          2217 => Opcode::LOCK_OR64mi8,
          2218 => Opcode::LOCK_OR64mr,
          2219 => Opcode::LOCK_OR8mi,
          2220 => Opcode::LOCK_OR8mr,
          2221 => Opcode::LOCK_PREFIX,
          2222 => Opcode::LOCK_SUB16mi,
          2223 => Opcode::LOCK_SUB16mi8,
          2224 => Opcode::LOCK_SUB16mr,
          2225 => Opcode::LOCK_SUB32mi,
          2226 => Opcode::LOCK_SUB32mi8,
          2227 => Opcode::LOCK_SUB32mr,
          2228 => Opcode::LOCK_SUB64mi32,
          2229 => Opcode::LOCK_SUB64mi8,
          2230 => Opcode::LOCK_SUB64mr,
          2231 => Opcode::LOCK_SUB8mi,
          2232 => Opcode::LOCK_SUB8mr,
          2233 => Opcode::LOCK_XOR16mi,
          2234 => Opcode::LOCK_XOR16mi8,
          2235 => Opcode::LOCK_XOR16mr,
          2236 => Opcode::LOCK_XOR32mi,
          2237 => Opcode::LOCK_XOR32mi8,
          2238 => Opcode::LOCK_XOR32mr,
          2239 => Opcode::LOCK_XOR64mi32,
          2240 => Opcode::LOCK_XOR64mi8,
          2241 => Opcode::LOCK_XOR64mr,
          2242 => Opcode::LOCK_XOR8mi,
          2243 => Opcode::LOCK_XOR8mr,
          2244 => Opcode::LODSB,
          2245 => Opcode::LODSL,
          2246 => Opcode::LODSQ,
          2247 => Opcode::LODSW,
          2248 => Opcode::LOOP,
          2249 => Opcode::LOOPE,
          2250 => Opcode::LOOPNE,
          2251 => Opcode::LRET16,
          2252 => Opcode::LRET32,
          2253 => Opcode::LRET64,
          2254 => Opcode::LRETI16,
          2255 => Opcode::LRETI32,
          2256 => Opcode::LRETI64,
          2257 => Opcode::LSL16rm,
          2258 => Opcode::LSL16rr,
          2259 => Opcode::LSL32rm,
          2260 => Opcode::LSL32rr,
          2261 => Opcode::LSL64rm,
          2262 => Opcode::LSL64rr,
          2263 => Opcode::LSS16rm,
          2264 => Opcode::LSS32rm,
          2265 => Opcode::LSS64rm,
          2266 => Opcode::LTRm,
          2267 => Opcode::LTRr,
          2268 => Opcode::LWPINS32rmi,
          2269 => Opcode::LWPINS32rri,
          2270 => Opcode::LWPINS64rmi,
          2271 => Opcode::LWPINS64rri,
          2272 => Opcode::LWPVAL32rmi,
          2273 => Opcode::LWPVAL32rri,
          2274 => Opcode::LWPVAL64rmi,
          2275 => Opcode::LWPVAL64rri,
          2276 => Opcode::LXADD16,
          2277 => Opcode::LXADD32,
          2278 => Opcode::LXADD64,
          2279 => Opcode::LXADD8,
          2280 => Opcode::LZCNT16rm,
          2281 => Opcode::LZCNT16rm_EVEX,
          2282 => Opcode::LZCNT16rm_NF,
          2283 => Opcode::LZCNT16rr,
          2284 => Opcode::LZCNT16rr_EVEX,
          2285 => Opcode::LZCNT16rr_NF,
          2286 => Opcode::LZCNT32rm,
          2287 => Opcode::LZCNT32rm_EVEX,
          2288 => Opcode::LZCNT32rm_NF,
          2289 => Opcode::LZCNT32rr,
          2290 => Opcode::LZCNT32rr_EVEX,
          2291 => Opcode::LZCNT32rr_NF,
          2292 => Opcode::LZCNT64rm,
          2293 => Opcode::LZCNT64rm_EVEX,
          2294 => Opcode::LZCNT64rm_NF,
          2295 => Opcode::LZCNT64rr,
          2296 => Opcode::LZCNT64rr_EVEX,
          2297 => Opcode::LZCNT64rr_NF,
          2298 => Opcode::MASKMOVDQU,
          2299 => Opcode::MASKMOVDQU64,
          2300 => Opcode::MASKPAIR16LOAD,
          2301 => Opcode::MASKPAIR16STORE,
          2302 => Opcode::MAXCPDrm,
          2303 => Opcode::MAXCPDrr,
          2304 => Opcode::MAXCPSrm,
          2305 => Opcode::MAXCPSrr,
          2306 => Opcode::MAXCSDrm,
          2307 => Opcode::MAXCSDrr,
          2308 => Opcode::MAXCSSrm,
          2309 => Opcode::MAXCSSrr,
          2310 => Opcode::MAXPDrm,
          2311 => Opcode::MAXPDrr,
          2312 => Opcode::MAXPSrm,
          2313 => Opcode::MAXPSrr,
          2314 => Opcode::MAXSDrm,
          2315 => Opcode::MAXSDrm_Int,
          2316 => Opcode::MAXSDrr,
          2317 => Opcode::MAXSDrr_Int,
          2318 => Opcode::MAXSSrm,
          2319 => Opcode::MAXSSrm_Int,
          2320 => Opcode::MAXSSrr,
          2321 => Opcode::MAXSSrr_Int,
          2322 => Opcode::MFENCE,
          2323 => Opcode::MINCPDrm,
          2324 => Opcode::MINCPDrr,
          2325 => Opcode::MINCPSrm,
          2326 => Opcode::MINCPSrr,
          2327 => Opcode::MINCSDrm,
          2328 => Opcode::MINCSDrr,
          2329 => Opcode::MINCSSrm,
          2330 => Opcode::MINCSSrr,
          2331 => Opcode::MINPDrm,
          2332 => Opcode::MINPDrr,
          2333 => Opcode::MINPSrm,
          2334 => Opcode::MINPSrr,
          2335 => Opcode::MINSDrm,
          2336 => Opcode::MINSDrm_Int,
          2337 => Opcode::MINSDrr,
          2338 => Opcode::MINSDrr_Int,
          2339 => Opcode::MINSSrm,
          2340 => Opcode::MINSSrm_Int,
          2341 => Opcode::MINSSrr,
          2342 => Opcode::MINSSrr_Int,
          2343 => Opcode::MMX_CVTPD2PIrm,
          2344 => Opcode::MMX_CVTPD2PIrr,
          2345 => Opcode::MMX_CVTPI2PDrm,
          2346 => Opcode::MMX_CVTPI2PDrr,
          2347 => Opcode::MMX_CVTPI2PSrm,
          2348 => Opcode::MMX_CVTPI2PSrr,
          2349 => Opcode::MMX_CVTPS2PIrm,
          2350 => Opcode::MMX_CVTPS2PIrr,
          2351 => Opcode::MMX_CVTTPD2PIrm,
          2352 => Opcode::MMX_CVTTPD2PIrr,
          2353 => Opcode::MMX_CVTTPS2PIrm,
          2354 => Opcode::MMX_CVTTPS2PIrr,
          2355 => Opcode::MMX_EMMS,
          2356 => Opcode::MMX_MASKMOVQ,
          2357 => Opcode::MMX_MASKMOVQ64,
          2358 => Opcode::MMX_MOVD64from64mr,
          2359 => Opcode::MMX_MOVD64from64rr,
          2360 => Opcode::MMX_MOVD64grr,
          2361 => Opcode::MMX_MOVD64mr,
          2362 => Opcode::MMX_MOVD64rm,
          2363 => Opcode::MMX_MOVD64rr,
          2364 => Opcode::MMX_MOVD64to64rm,
          2365 => Opcode::MMX_MOVD64to64rr,
          2366 => Opcode::MMX_MOVDQ2Qrr,
          2367 => Opcode::MMX_MOVFR642Qrr,
          2368 => Opcode::MMX_MOVNTQmr,
          2369 => Opcode::MMX_MOVQ2DQrr,
          2370 => Opcode::MMX_MOVQ2FR64rr,
          2371 => Opcode::MMX_MOVQ64mr,
          2372 => Opcode::MMX_MOVQ64rm,
          2373 => Opcode::MMX_MOVQ64rr,
          2374 => Opcode::MMX_MOVQ64rr_REV,
          2375 => Opcode::MMX_PABSBrm,
          2376 => Opcode::MMX_PABSBrr,
          2377 => Opcode::MMX_PABSDrm,
          2378 => Opcode::MMX_PABSDrr,
          2379 => Opcode::MMX_PABSWrm,
          2380 => Opcode::MMX_PABSWrr,
          2381 => Opcode::MMX_PACKSSDWrm,
          2382 => Opcode::MMX_PACKSSDWrr,
          2383 => Opcode::MMX_PACKSSWBrm,
          2384 => Opcode::MMX_PACKSSWBrr,
          2385 => Opcode::MMX_PACKUSWBrm,
          2386 => Opcode::MMX_PACKUSWBrr,
          2387 => Opcode::MMX_PADDBrm,
          2388 => Opcode::MMX_PADDBrr,
          2389 => Opcode::MMX_PADDDrm,
          2390 => Opcode::MMX_PADDDrr,
          2391 => Opcode::MMX_PADDQrm,
          2392 => Opcode::MMX_PADDQrr,
          2393 => Opcode::MMX_PADDSBrm,
          2394 => Opcode::MMX_PADDSBrr,
          2395 => Opcode::MMX_PADDSWrm,
          2396 => Opcode::MMX_PADDSWrr,
          2397 => Opcode::MMX_PADDUSBrm,
          2398 => Opcode::MMX_PADDUSBrr,
          2399 => Opcode::MMX_PADDUSWrm,
          2400 => Opcode::MMX_PADDUSWrr,
          2401 => Opcode::MMX_PADDWrm,
          2402 => Opcode::MMX_PADDWrr,
          2403 => Opcode::MMX_PALIGNRrmi,
          2404 => Opcode::MMX_PALIGNRrri,
          2405 => Opcode::MMX_PANDNrm,
          2406 => Opcode::MMX_PANDNrr,
          2407 => Opcode::MMX_PANDrm,
          2408 => Opcode::MMX_PANDrr,
          2409 => Opcode::MMX_PAVGBrm,
          2410 => Opcode::MMX_PAVGBrr,
          2411 => Opcode::MMX_PAVGWrm,
          2412 => Opcode::MMX_PAVGWrr,
          2413 => Opcode::MMX_PCMPEQBrm,
          2414 => Opcode::MMX_PCMPEQBrr,
          2415 => Opcode::MMX_PCMPEQDrm,
          2416 => Opcode::MMX_PCMPEQDrr,
          2417 => Opcode::MMX_PCMPEQWrm,
          2418 => Opcode::MMX_PCMPEQWrr,
          2419 => Opcode::MMX_PCMPGTBrm,
          2420 => Opcode::MMX_PCMPGTBrr,
          2421 => Opcode::MMX_PCMPGTDrm,
          2422 => Opcode::MMX_PCMPGTDrr,
          2423 => Opcode::MMX_PCMPGTWrm,
          2424 => Opcode::MMX_PCMPGTWrr,
          2425 => Opcode::MMX_PEXTRWrri,
          2426 => Opcode::MMX_PHADDDrm,
          2427 => Opcode::MMX_PHADDDrr,
          2428 => Opcode::MMX_PHADDSWrm,
          2429 => Opcode::MMX_PHADDSWrr,
          2430 => Opcode::MMX_PHADDWrm,
          2431 => Opcode::MMX_PHADDWrr,
          2432 => Opcode::MMX_PHSUBDrm,
          2433 => Opcode::MMX_PHSUBDrr,
          2434 => Opcode::MMX_PHSUBSWrm,
          2435 => Opcode::MMX_PHSUBSWrr,
          2436 => Opcode::MMX_PHSUBWrm,
          2437 => Opcode::MMX_PHSUBWrr,
          2438 => Opcode::MMX_PINSRWrmi,
          2439 => Opcode::MMX_PINSRWrri,
          2440 => Opcode::MMX_PMADDUBSWrm,
          2441 => Opcode::MMX_PMADDUBSWrr,
          2442 => Opcode::MMX_PMADDWDrm,
          2443 => Opcode::MMX_PMADDWDrr,
          2444 => Opcode::MMX_PMAXSWrm,
          2445 => Opcode::MMX_PMAXSWrr,
          2446 => Opcode::MMX_PMAXUBrm,
          2447 => Opcode::MMX_PMAXUBrr,
          2448 => Opcode::MMX_PMINSWrm,
          2449 => Opcode::MMX_PMINSWrr,
          2450 => Opcode::MMX_PMINUBrm,
          2451 => Opcode::MMX_PMINUBrr,
          2452 => Opcode::MMX_PMOVMSKBrr,
          2453 => Opcode::MMX_PMULHRSWrm,
          2454 => Opcode::MMX_PMULHRSWrr,
          2455 => Opcode::MMX_PMULHUWrm,
          2456 => Opcode::MMX_PMULHUWrr,
          2457 => Opcode::MMX_PMULHWrm,
          2458 => Opcode::MMX_PMULHWrr,
          2459 => Opcode::MMX_PMULLWrm,
          2460 => Opcode::MMX_PMULLWrr,
          2461 => Opcode::MMX_PMULUDQrm,
          2462 => Opcode::MMX_PMULUDQrr,
          2463 => Opcode::MMX_PORrm,
          2464 => Opcode::MMX_PORrr,
          2465 => Opcode::MMX_PSADBWrm,
          2466 => Opcode::MMX_PSADBWrr,
          2467 => Opcode::MMX_PSHUFBrm,
          2468 => Opcode::MMX_PSHUFBrr,
          2469 => Opcode::MMX_PSHUFWmi,
          2470 => Opcode::MMX_PSHUFWri,
          2471 => Opcode::MMX_PSIGNBrm,
          2472 => Opcode::MMX_PSIGNBrr,
          2473 => Opcode::MMX_PSIGNDrm,
          2474 => Opcode::MMX_PSIGNDrr,
          2475 => Opcode::MMX_PSIGNWrm,
          2476 => Opcode::MMX_PSIGNWrr,
          2477 => Opcode::MMX_PSLLDri,
          2478 => Opcode::MMX_PSLLDrm,
          2479 => Opcode::MMX_PSLLDrr,
          2480 => Opcode::MMX_PSLLQri,
          2481 => Opcode::MMX_PSLLQrm,
          2482 => Opcode::MMX_PSLLQrr,
          2483 => Opcode::MMX_PSLLWri,
          2484 => Opcode::MMX_PSLLWrm,
          2485 => Opcode::MMX_PSLLWrr,
          2486 => Opcode::MMX_PSRADri,
          2487 => Opcode::MMX_PSRADrm,
          2488 => Opcode::MMX_PSRADrr,
          2489 => Opcode::MMX_PSRAWri,
          2490 => Opcode::MMX_PSRAWrm,
          2491 => Opcode::MMX_PSRAWrr,
          2492 => Opcode::MMX_PSRLDri,
          2493 => Opcode::MMX_PSRLDrm,
          2494 => Opcode::MMX_PSRLDrr,
          2495 => Opcode::MMX_PSRLQri,
          2496 => Opcode::MMX_PSRLQrm,
          2497 => Opcode::MMX_PSRLQrr,
          2498 => Opcode::MMX_PSRLWri,
          2499 => Opcode::MMX_PSRLWrm,
          2500 => Opcode::MMX_PSRLWrr,
          2501 => Opcode::MMX_PSUBBrm,
          2502 => Opcode::MMX_PSUBBrr,
          2503 => Opcode::MMX_PSUBDrm,
          2504 => Opcode::MMX_PSUBDrr,
          2505 => Opcode::MMX_PSUBQrm,
          2506 => Opcode::MMX_PSUBQrr,
          2507 => Opcode::MMX_PSUBSBrm,
          2508 => Opcode::MMX_PSUBSBrr,
          2509 => Opcode::MMX_PSUBSWrm,
          2510 => Opcode::MMX_PSUBSWrr,
          2511 => Opcode::MMX_PSUBUSBrm,
          2512 => Opcode::MMX_PSUBUSBrr,
          2513 => Opcode::MMX_PSUBUSWrm,
          2514 => Opcode::MMX_PSUBUSWrr,
          2515 => Opcode::MMX_PSUBWrm,
          2516 => Opcode::MMX_PSUBWrr,
          2517 => Opcode::MMX_PUNPCKHBWrm,
          2518 => Opcode::MMX_PUNPCKHBWrr,
          2519 => Opcode::MMX_PUNPCKHDQrm,
          2520 => Opcode::MMX_PUNPCKHDQrr,
          2521 => Opcode::MMX_PUNPCKHWDrm,
          2522 => Opcode::MMX_PUNPCKHWDrr,
          2523 => Opcode::MMX_PUNPCKLBWrm,
          2524 => Opcode::MMX_PUNPCKLBWrr,
          2525 => Opcode::MMX_PUNPCKLDQrm,
          2526 => Opcode::MMX_PUNPCKLDQrr,
          2527 => Opcode::MMX_PUNPCKLWDrm,
          2528 => Opcode::MMX_PUNPCKLWDrr,
          2529 => Opcode::MMX_PXORrm,
          2530 => Opcode::MMX_PXORrr,
          2531 => Opcode::MONITOR32rrr,
          2532 => Opcode::MONITOR64rrr,
          2533 => Opcode::MONITORX32rrr,
          2534 => Opcode::MONITORX64rrr,
          2535 => Opcode::MONTMUL,
          2536 => Opcode::MOV16ao16,
          2537 => Opcode::MOV16ao32,
          2538 => Opcode::MOV16ao64,
          2539 => Opcode::MOV16mi,
          2540 => Opcode::MOV16mr,
          2541 => Opcode::MOV16ms,
          2542 => Opcode::MOV16o16a,
          2543 => Opcode::MOV16o32a,
          2544 => Opcode::MOV16o64a,
          2545 => Opcode::MOV16ri,
          2546 => Opcode::MOV16ri_alt,
          2547 => Opcode::MOV16rm,
          2548 => Opcode::MOV16rr,
          2549 => Opcode::MOV16rr_REV,
          2550 => Opcode::MOV16rs,
          2551 => Opcode::MOV16sm,
          2552 => Opcode::MOV16sr,
          2553 => Opcode::MOV32ao16,
          2554 => Opcode::MOV32ao32,
          2555 => Opcode::MOV32ao64,
          2556 => Opcode::MOV32cr,
          2557 => Opcode::MOV32dr,
          2558 => Opcode::MOV32mi,
          2559 => Opcode::MOV32mr,
          2560 => Opcode::MOV32o16a,
          2561 => Opcode::MOV32o32a,
          2562 => Opcode::MOV32o64a,
          2563 => Opcode::MOV32rc,
          2564 => Opcode::MOV32rd,
          2565 => Opcode::MOV32ri,
          2566 => Opcode::MOV32ri_alt,
          2567 => Opcode::MOV32rm,
          2568 => Opcode::MOV32rr,
          2569 => Opcode::MOV32rr_REV,
          2570 => Opcode::MOV32rs,
          2571 => Opcode::MOV32sr,
          2572 => Opcode::MOV64ao32,
          2573 => Opcode::MOV64ao64,
          2574 => Opcode::MOV64cr,
          2575 => Opcode::MOV64dr,
          2576 => Opcode::MOV64mi32,
          2577 => Opcode::MOV64mr,
          2578 => Opcode::MOV64o32a,
          2579 => Opcode::MOV64o64a,
          2580 => Opcode::MOV64rc,
          2581 => Opcode::MOV64rd,
          2582 => Opcode::MOV64ri,
          2583 => Opcode::MOV64ri32,
          2584 => Opcode::MOV64rm,
          2585 => Opcode::MOV64rr,
          2586 => Opcode::MOV64rr_REV,
          2587 => Opcode::MOV64rs,
          2588 => Opcode::MOV64sr,
          2589 => Opcode::MOV64toPQIrm,
          2590 => Opcode::MOV64toPQIrr,
          2591 => Opcode::MOV64toSDrr,
          2592 => Opcode::MOV8ao16,
          2593 => Opcode::MOV8ao32,
          2594 => Opcode::MOV8ao64,
          2595 => Opcode::MOV8mi,
          2596 => Opcode::MOV8mr,
          2597 => Opcode::MOV8mr_NOREX,
          2598 => Opcode::MOV8o16a,
          2599 => Opcode::MOV8o32a,
          2600 => Opcode::MOV8o64a,
          2601 => Opcode::MOV8ri,
          2602 => Opcode::MOV8ri_alt,
          2603 => Opcode::MOV8rm,
          2604 => Opcode::MOV8rm_NOREX,
          2605 => Opcode::MOV8rr,
          2606 => Opcode::MOV8rr_NOREX,
          2607 => Opcode::MOV8rr_REV,
          2608 => Opcode::MOVAPDmr,
          2609 => Opcode::MOVAPDrm,
          2610 => Opcode::MOVAPDrr,
          2611 => Opcode::MOVAPDrr_REV,
          2612 => Opcode::MOVAPSmr,
          2613 => Opcode::MOVAPSrm,
          2614 => Opcode::MOVAPSrr,
          2615 => Opcode::MOVAPSrr_REV,
          2616 => Opcode::MOVBE16mr,
          2617 => Opcode::MOVBE16mr_EVEX,
          2618 => Opcode::MOVBE16rm,
          2619 => Opcode::MOVBE16rm_EVEX,
          2620 => Opcode::MOVBE16rr,
          2621 => Opcode::MOVBE16rr_REV,
          2622 => Opcode::MOVBE32mr,
          2623 => Opcode::MOVBE32mr_EVEX,
          2624 => Opcode::MOVBE32rm,
          2625 => Opcode::MOVBE32rm_EVEX,
          2626 => Opcode::MOVBE32rr,
          2627 => Opcode::MOVBE32rr_REV,
          2628 => Opcode::MOVBE64mr,
          2629 => Opcode::MOVBE64mr_EVEX,
          2630 => Opcode::MOVBE64rm,
          2631 => Opcode::MOVBE64rm_EVEX,
          2632 => Opcode::MOVBE64rr,
          2633 => Opcode::MOVBE64rr_REV,
          2634 => Opcode::MOVDDUPrm,
          2635 => Opcode::MOVDDUPrr,
          2636 => Opcode::MOVDI2PDIrm,
          2637 => Opcode::MOVDI2PDIrr,
          2638 => Opcode::MOVDI2SSrr,
          2639 => Opcode::MOVDIR64B16,
          2640 => Opcode::MOVDIR64B32,
          2641 => Opcode::MOVDIR64B32_EVEX,
          2642 => Opcode::MOVDIR64B64,
          2643 => Opcode::MOVDIR64B64_EVEX,
          2644 => Opcode::MOVDIRI32,
          2645 => Opcode::MOVDIRI32_EVEX,
          2646 => Opcode::MOVDIRI64,
          2647 => Opcode::MOVDIRI64_EVEX,
          2648 => Opcode::MOVDQAmr,
          2649 => Opcode::MOVDQArm,
          2650 => Opcode::MOVDQArr,
          2651 => Opcode::MOVDQArr_REV,
          2652 => Opcode::MOVDQUmr,
          2653 => Opcode::MOVDQUrm,
          2654 => Opcode::MOVDQUrr,
          2655 => Opcode::MOVDQUrr_REV,
          2656 => Opcode::MOVHLPSrr,
          2657 => Opcode::MOVHPDmr,
          2658 => Opcode::MOVHPDrm,
          2659 => Opcode::MOVHPSmr,
          2660 => Opcode::MOVHPSrm,
          2661 => Opcode::MOVLHPSrr,
          2662 => Opcode::MOVLPDmr,
          2663 => Opcode::MOVLPDrm,
          2664 => Opcode::MOVLPSmr,
          2665 => Opcode::MOVLPSrm,
          2666 => Opcode::MOVMSKPDrr,
          2667 => Opcode::MOVMSKPSrr,
          2668 => Opcode::MOVNTDQArm,
          2669 => Opcode::MOVNTDQmr,
          2670 => Opcode::MOVNTI_64mr,
          2671 => Opcode::MOVNTImr,
          2672 => Opcode::MOVNTPDmr,
          2673 => Opcode::MOVNTPSmr,
          2674 => Opcode::MOVNTSD,
          2675 => Opcode::MOVNTSS,
          2676 => Opcode::MOVPC32r,
          2677 => Opcode::MOVPDI2DImr,
          2678 => Opcode::MOVPDI2DIrr,
          2679 => Opcode::MOVPQI2QImr,
          2680 => Opcode::MOVPQI2QIrr,
          2681 => Opcode::MOVPQIto64mr,
          2682 => Opcode::MOVPQIto64rr,
          2683 => Opcode::MOVQI2PQIrm,
          2684 => Opcode::MOVRS16rm,
          2685 => Opcode::MOVRS16rm_EVEX,
          2686 => Opcode::MOVRS32rm,
          2687 => Opcode::MOVRS32rm_EVEX,
          2688 => Opcode::MOVRS64rm,
          2689 => Opcode::MOVRS64rm_EVEX,
          2690 => Opcode::MOVRS8rm,
          2691 => Opcode::MOVRS8rm_EVEX,
          2692 => Opcode::MOVSB,
          2693 => Opcode::MOVSDmr,
          2694 => Opcode::MOVSDrm,
          2695 => Opcode::MOVSDrm_alt,
          2696 => Opcode::MOVSDrr,
          2697 => Opcode::MOVSDrr_REV,
          2698 => Opcode::MOVSDto64rr,
          2699 => Opcode::MOVSHDUPrm,
          2700 => Opcode::MOVSHDUPrr,
          2701 => Opcode::MOVSL,
          2702 => Opcode::MOVSLDUPrm,
          2703 => Opcode::MOVSLDUPrr,
          2704 => Opcode::MOVSQ,
          2705 => Opcode::MOVSS2DIrr,
          2706 => Opcode::MOVSSmr,
          2707 => Opcode::MOVSSrm,
          2708 => Opcode::MOVSSrm_alt,
          2709 => Opcode::MOVSSrr,
          2710 => Opcode::MOVSSrr_REV,
          2711 => Opcode::MOVSW,
          2712 => Opcode::MOVSX16rm16,
          2713 => Opcode::MOVSX16rm32,
          2714 => Opcode::MOVSX16rm8,
          2715 => Opcode::MOVSX16rr16,
          2716 => Opcode::MOVSX16rr32,
          2717 => Opcode::MOVSX16rr8,
          2718 => Opcode::MOVSX32rm16,
          2719 => Opcode::MOVSX32rm32,
          2720 => Opcode::MOVSX32rm8,
          2721 => Opcode::MOVSX32rm8_NOREX,
          2722 => Opcode::MOVSX32rr16,
          2723 => Opcode::MOVSX32rr32,
          2724 => Opcode::MOVSX32rr8,
          2725 => Opcode::MOVSX32rr8_NOREX,
          2726 => Opcode::MOVSX64rm16,
          2727 => Opcode::MOVSX64rm32,
          2728 => Opcode::MOVSX64rm8,
          2729 => Opcode::MOVSX64rr16,
          2730 => Opcode::MOVSX64rr32,
          2731 => Opcode::MOVSX64rr8,
          2732 => Opcode::MOVUPDmr,
          2733 => Opcode::MOVUPDrm,
          2734 => Opcode::MOVUPDrr,
          2735 => Opcode::MOVUPDrr_REV,
          2736 => Opcode::MOVUPSmr,
          2737 => Opcode::MOVUPSrm,
          2738 => Opcode::MOVUPSrr,
          2739 => Opcode::MOVUPSrr_REV,
          2740 => Opcode::MOVZPQILo2PQIrr,
          2741 => Opcode::MOVZX16rm16,
          2742 => Opcode::MOVZX16rm8,
          2743 => Opcode::MOVZX16rr16,
          2744 => Opcode::MOVZX16rr8,
          2745 => Opcode::MOVZX32rm16,
          2746 => Opcode::MOVZX32rm8,
          2747 => Opcode::MOVZX32rm8_NOREX,
          2748 => Opcode::MOVZX32rr16,
          2749 => Opcode::MOVZX32rr8,
          2750 => Opcode::MOVZX32rr8_NOREX,
          2751 => Opcode::MOVZX64rm16,
          2752 => Opcode::MOVZX64rm8,
          2753 => Opcode::MOVZX64rr16,
          2754 => Opcode::MOVZX64rr8,
          2755 => Opcode::MPSADBWrmi,
          2756 => Opcode::MPSADBWrri,
          2757 => Opcode::MUL16m,
          2758 => Opcode::MUL16m_EVEX,
          2759 => Opcode::MUL16m_NF,
          2760 => Opcode::MUL16r,
          2761 => Opcode::MUL16r_EVEX,
          2762 => Opcode::MUL16r_NF,
          2763 => Opcode::MUL32m,
          2764 => Opcode::MUL32m_EVEX,
          2765 => Opcode::MUL32m_NF,
          2766 => Opcode::MUL32r,
          2767 => Opcode::MUL32r_EVEX,
          2768 => Opcode::MUL32r_NF,
          2769 => Opcode::MUL64m,
          2770 => Opcode::MUL64m_EVEX,
          2771 => Opcode::MUL64m_NF,
          2772 => Opcode::MUL64r,
          2773 => Opcode::MUL64r_EVEX,
          2774 => Opcode::MUL64r_NF,
          2775 => Opcode::MUL8m,
          2776 => Opcode::MUL8m_EVEX,
          2777 => Opcode::MUL8m_NF,
          2778 => Opcode::MUL8r,
          2779 => Opcode::MUL8r_EVEX,
          2780 => Opcode::MUL8r_NF,
          2781 => Opcode::MULPDrm,
          2782 => Opcode::MULPDrr,
          2783 => Opcode::MULPSrm,
          2784 => Opcode::MULPSrr,
          2785 => Opcode::MULSDrm,
          2786 => Opcode::MULSDrm_Int,
          2787 => Opcode::MULSDrr,
          2788 => Opcode::MULSDrr_Int,
          2789 => Opcode::MULSSrm,
          2790 => Opcode::MULSSrm_Int,
          2791 => Opcode::MULSSrr,
          2792 => Opcode::MULSSrr_Int,
          2793 => Opcode::MULX32Hrm,
          2794 => Opcode::MULX32Hrr,
          2795 => Opcode::MULX32rm,
          2796 => Opcode::MULX32rm_EVEX,
          2797 => Opcode::MULX32rr,
          2798 => Opcode::MULX32rr_EVEX,
          2799 => Opcode::MULX64Hrm,
          2800 => Opcode::MULX64Hrr,
          2801 => Opcode::MULX64rm,
          2802 => Opcode::MULX64rm_EVEX,
          2803 => Opcode::MULX64rr,
          2804 => Opcode::MULX64rr_EVEX,
          2805 => Opcode::MUL_F32m,
          2806 => Opcode::MUL_F64m,
          2807 => Opcode::MUL_FI16m,
          2808 => Opcode::MUL_FI32m,
          2809 => Opcode::MUL_FPrST0,
          2810 => Opcode::MUL_FST0r,
          2811 => Opcode::MUL_Fp32,
          2812 => Opcode::MUL_Fp32m,
          2813 => Opcode::MUL_Fp64,
          2814 => Opcode::MUL_Fp64m,
          2815 => Opcode::MUL_Fp64m32,
          2816 => Opcode::MUL_Fp80,
          2817 => Opcode::MUL_Fp80m32,
          2818 => Opcode::MUL_Fp80m64,
          2819 => Opcode::MUL_FpI16m32,
          2820 => Opcode::MUL_FpI16m64,
          2821 => Opcode::MUL_FpI16m80,
          2822 => Opcode::MUL_FpI32m32,
          2823 => Opcode::MUL_FpI32m64,
          2824 => Opcode::MUL_FpI32m80,
          2825 => Opcode::MUL_FrST0,
          2826 => Opcode::MWAITXrrr,
          2827 => Opcode::MWAITrr,
          2828 => Opcode::NEG16m,
          2829 => Opcode::NEG16m_EVEX,
          2830 => Opcode::NEG16m_ND,
          2831 => Opcode::NEG16m_NF,
          2832 => Opcode::NEG16m_NF_ND,
          2833 => Opcode::NEG16r,
          2834 => Opcode::NEG16r_EVEX,
          2835 => Opcode::NEG16r_ND,
          2836 => Opcode::NEG16r_NF,
          2837 => Opcode::NEG16r_NF_ND,
          2838 => Opcode::NEG32m,
          2839 => Opcode::NEG32m_EVEX,
          2840 => Opcode::NEG32m_ND,
          2841 => Opcode::NEG32m_NF,
          2842 => Opcode::NEG32m_NF_ND,
          2843 => Opcode::NEG32r,
          2844 => Opcode::NEG32r_EVEX,
          2845 => Opcode::NEG32r_ND,
          2846 => Opcode::NEG32r_NF,
          2847 => Opcode::NEG32r_NF_ND,
          2848 => Opcode::NEG64m,
          2849 => Opcode::NEG64m_EVEX,
          2850 => Opcode::NEG64m_ND,
          2851 => Opcode::NEG64m_NF,
          2852 => Opcode::NEG64m_NF_ND,
          2853 => Opcode::NEG64r,
          2854 => Opcode::NEG64r_EVEX,
          2855 => Opcode::NEG64r_ND,
          2856 => Opcode::NEG64r_NF,
          2857 => Opcode::NEG64r_NF_ND,
          2858 => Opcode::NEG8m,
          2859 => Opcode::NEG8m_EVEX,
          2860 => Opcode::NEG8m_ND,
          2861 => Opcode::NEG8m_NF,
          2862 => Opcode::NEG8m_NF_ND,
          2863 => Opcode::NEG8r,
          2864 => Opcode::NEG8r_EVEX,
          2865 => Opcode::NEG8r_ND,
          2866 => Opcode::NEG8r_NF,
          2867 => Opcode::NEG8r_NF_ND,
          2868 => Opcode::NOOP,
          2869 => Opcode::NOOPL,
          2870 => Opcode::NOOPLr,
          2871 => Opcode::NOOPQ,
          2872 => Opcode::NOOPQr,
          2873 => Opcode::NOOPW,
          2874 => Opcode::NOOPWr,
          2875 => Opcode::NOT16m,
          2876 => Opcode::NOT16m_EVEX,
          2877 => Opcode::NOT16m_ND,
          2878 => Opcode::NOT16r,
          2879 => Opcode::NOT16r_EVEX,
          2880 => Opcode::NOT16r_ND,
          2881 => Opcode::NOT32m,
          2882 => Opcode::NOT32m_EVEX,
          2883 => Opcode::NOT32m_ND,
          2884 => Opcode::NOT32r,
          2885 => Opcode::NOT32r_EVEX,
          2886 => Opcode::NOT32r_ND,
          2887 => Opcode::NOT64m,
          2888 => Opcode::NOT64m_EVEX,
          2889 => Opcode::NOT64m_ND,
          2890 => Opcode::NOT64r,
          2891 => Opcode::NOT64r_EVEX,
          2892 => Opcode::NOT64r_ND,
          2893 => Opcode::NOT8m,
          2894 => Opcode::NOT8m_EVEX,
          2895 => Opcode::NOT8m_ND,
          2896 => Opcode::NOT8r,
          2897 => Opcode::NOT8r_EVEX,
          2898 => Opcode::NOT8r_ND,
          2899 => Opcode::OR16i16,
          2900 => Opcode::OR16mi,
          2901 => Opcode::OR16mi8,
          2902 => Opcode::OR16mi8_EVEX,
          2903 => Opcode::OR16mi8_ND,
          2904 => Opcode::OR16mi8_NF,
          2905 => Opcode::OR16mi8_NF_ND,
          2906 => Opcode::OR16mi_EVEX,
          2907 => Opcode::OR16mi_ND,
          2908 => Opcode::OR16mi_NF,
          2909 => Opcode::OR16mi_NF_ND,
          2910 => Opcode::OR16mr,
          2911 => Opcode::OR16mr_EVEX,
          2912 => Opcode::OR16mr_ND,
          2913 => Opcode::OR16mr_NF,
          2914 => Opcode::OR16mr_NF_ND,
          2915 => Opcode::OR16ri,
          2916 => Opcode::OR16ri8,
          2917 => Opcode::OR16ri8_EVEX,
          2918 => Opcode::OR16ri8_ND,
          2919 => Opcode::OR16ri8_NF,
          2920 => Opcode::OR16ri8_NF_ND,
          2921 => Opcode::OR16ri_EVEX,
          2922 => Opcode::OR16ri_ND,
          2923 => Opcode::OR16ri_NF,
          2924 => Opcode::OR16ri_NF_ND,
          2925 => Opcode::OR16rm,
          2926 => Opcode::OR16rm_EVEX,
          2927 => Opcode::OR16rm_ND,
          2928 => Opcode::OR16rm_NF,
          2929 => Opcode::OR16rm_NF_ND,
          2930 => Opcode::OR16rr,
          2931 => Opcode::OR16rr_EVEX,
          2932 => Opcode::OR16rr_EVEX_REV,
          2933 => Opcode::OR16rr_ND,
          2934 => Opcode::OR16rr_ND_REV,
          2935 => Opcode::OR16rr_NF,
          2936 => Opcode::OR16rr_NF_ND,
          2937 => Opcode::OR16rr_NF_ND_REV,
          2938 => Opcode::OR16rr_NF_REV,
          2939 => Opcode::OR16rr_REV,
          2940 => Opcode::OR32i32,
          2941 => Opcode::OR32mi,
          2942 => Opcode::OR32mi8,
          2943 => Opcode::OR32mi8Locked,
          2944 => Opcode::OR32mi8_EVEX,
          2945 => Opcode::OR32mi8_ND,
          2946 => Opcode::OR32mi8_NF,
          2947 => Opcode::OR32mi8_NF_ND,
          2948 => Opcode::OR32mi_EVEX,
          2949 => Opcode::OR32mi_ND,
          2950 => Opcode::OR32mi_NF,
          2951 => Opcode::OR32mi_NF_ND,
          2952 => Opcode::OR32mr,
          2953 => Opcode::OR32mr_EVEX,
          2954 => Opcode::OR32mr_ND,
          2955 => Opcode::OR32mr_NF,
          2956 => Opcode::OR32mr_NF_ND,
          2957 => Opcode::OR32ri,
          2958 => Opcode::OR32ri8,
          2959 => Opcode::OR32ri8_EVEX,
          2960 => Opcode::OR32ri8_ND,
          2961 => Opcode::OR32ri8_NF,
          2962 => Opcode::OR32ri8_NF_ND,
          2963 => Opcode::OR32ri_EVEX,
          2964 => Opcode::OR32ri_ND,
          2965 => Opcode::OR32ri_NF,
          2966 => Opcode::OR32ri_NF_ND,
          2967 => Opcode::OR32rm,
          2968 => Opcode::OR32rm_EVEX,
          2969 => Opcode::OR32rm_ND,
          2970 => Opcode::OR32rm_NF,
          2971 => Opcode::OR32rm_NF_ND,
          2972 => Opcode::OR32rr,
          2973 => Opcode::OR32rr_EVEX,
          2974 => Opcode::OR32rr_EVEX_REV,
          2975 => Opcode::OR32rr_ND,
          2976 => Opcode::OR32rr_ND_REV,
          2977 => Opcode::OR32rr_NF,
          2978 => Opcode::OR32rr_NF_ND,
          2979 => Opcode::OR32rr_NF_ND_REV,
          2980 => Opcode::OR32rr_NF_REV,
          2981 => Opcode::OR32rr_REV,
          2982 => Opcode::OR64i32,
          2983 => Opcode::OR64mi32,
          2984 => Opcode::OR64mi32_EVEX,
          2985 => Opcode::OR64mi32_ND,
          2986 => Opcode::OR64mi32_NF,
          2987 => Opcode::OR64mi32_NF_ND,
          2988 => Opcode::OR64mi8,
          2989 => Opcode::OR64mi8_EVEX,
          2990 => Opcode::OR64mi8_ND,
          2991 => Opcode::OR64mi8_NF,
          2992 => Opcode::OR64mi8_NF_ND,
          2993 => Opcode::OR64mr,
          2994 => Opcode::OR64mr_EVEX,
          2995 => Opcode::OR64mr_ND,
          2996 => Opcode::OR64mr_NF,
          2997 => Opcode::OR64mr_NF_ND,
          2998 => Opcode::OR64ri32,
          2999 => Opcode::OR64ri32_EVEX,
          3000 => Opcode::OR64ri32_ND,
          3001 => Opcode::OR64ri32_NF,
          3002 => Opcode::OR64ri32_NF_ND,
          3003 => Opcode::OR64ri8,
          3004 => Opcode::OR64ri8_EVEX,
          3005 => Opcode::OR64ri8_ND,
          3006 => Opcode::OR64ri8_NF,
          3007 => Opcode::OR64ri8_NF_ND,
          3008 => Opcode::OR64rm,
          3009 => Opcode::OR64rm_EVEX,
          3010 => Opcode::OR64rm_ND,
          3011 => Opcode::OR64rm_NF,
          3012 => Opcode::OR64rm_NF_ND,
          3013 => Opcode::OR64rr,
          3014 => Opcode::OR64rr_EVEX,
          3015 => Opcode::OR64rr_EVEX_REV,
          3016 => Opcode::OR64rr_ND,
          3017 => Opcode::OR64rr_ND_REV,
          3018 => Opcode::OR64rr_NF,
          3019 => Opcode::OR64rr_NF_ND,
          3020 => Opcode::OR64rr_NF_ND_REV,
          3021 => Opcode::OR64rr_NF_REV,
          3022 => Opcode::OR64rr_REV,
          3023 => Opcode::OR8i8,
          3024 => Opcode::OR8mi,
          3025 => Opcode::OR8mi8,
          3026 => Opcode::OR8mi_EVEX,
          3027 => Opcode::OR8mi_ND,
          3028 => Opcode::OR8mi_NF,
          3029 => Opcode::OR8mi_NF_ND,
          3030 => Opcode::OR8mr,
          3031 => Opcode::OR8mr_EVEX,
          3032 => Opcode::OR8mr_ND,
          3033 => Opcode::OR8mr_NF,
          3034 => Opcode::OR8mr_NF_ND,
          3035 => Opcode::OR8ri,
          3036 => Opcode::OR8ri8,
          3037 => Opcode::OR8ri_EVEX,
          3038 => Opcode::OR8ri_ND,
          3039 => Opcode::OR8ri_NF,
          3040 => Opcode::OR8ri_NF_ND,
          3041 => Opcode::OR8rm,
          3042 => Opcode::OR8rm_EVEX,
          3043 => Opcode::OR8rm_ND,
          3044 => Opcode::OR8rm_NF,
          3045 => Opcode::OR8rm_NF_ND,
          3046 => Opcode::OR8rr,
          3047 => Opcode::OR8rr_EVEX,
          3048 => Opcode::OR8rr_EVEX_REV,
          3049 => Opcode::OR8rr_ND,
          3050 => Opcode::OR8rr_ND_REV,
          3051 => Opcode::OR8rr_NF,
          3052 => Opcode::OR8rr_NF_ND,
          3053 => Opcode::OR8rr_NF_ND_REV,
          3054 => Opcode::OR8rr_NF_REV,
          3055 => Opcode::OR8rr_REV,
          3056 => Opcode::ORPDrm,
          3057 => Opcode::ORPDrr,
          3058 => Opcode::ORPSrm,
          3059 => Opcode::ORPSrr,
          3060 => Opcode::OUT16ir,
          3061 => Opcode::OUT16rr,
          3062 => Opcode::OUT32ir,
          3063 => Opcode::OUT32rr,
          3064 => Opcode::OUT8ir,
          3065 => Opcode::OUT8rr,
          3066 => Opcode::OUTSB,
          3067 => Opcode::OUTSL,
          3068 => Opcode::OUTSW,
          3069 => Opcode::PABSBrm,
          3070 => Opcode::PABSBrr,
          3071 => Opcode::PABSDrm,
          3072 => Opcode::PABSDrr,
          3073 => Opcode::PABSWrm,
          3074 => Opcode::PABSWrr,
          3075 => Opcode::PACKSSDWrm,
          3076 => Opcode::PACKSSDWrr,
          3077 => Opcode::PACKSSWBrm,
          3078 => Opcode::PACKSSWBrr,
          3079 => Opcode::PACKUSDWrm,
          3080 => Opcode::PACKUSDWrr,
          3081 => Opcode::PACKUSWBrm,
          3082 => Opcode::PACKUSWBrr,
          3083 => Opcode::PADDBrm,
          3084 => Opcode::PADDBrr,
          3085 => Opcode::PADDDrm,
          3086 => Opcode::PADDDrr,
          3087 => Opcode::PADDQrm,
          3088 => Opcode::PADDQrr,
          3089 => Opcode::PADDSBrm,
          3090 => Opcode::PADDSBrr,
          3091 => Opcode::PADDSWrm,
          3092 => Opcode::PADDSWrr,
          3093 => Opcode::PADDUSBrm,
          3094 => Opcode::PADDUSBrr,
          3095 => Opcode::PADDUSWrm,
          3096 => Opcode::PADDUSWrr,
          3097 => Opcode::PADDWrm,
          3098 => Opcode::PADDWrr,
          3099 => Opcode::PALIGNRrmi,
          3100 => Opcode::PALIGNRrri,
          3101 => Opcode::PANDNrm,
          3102 => Opcode::PANDNrr,
          3103 => Opcode::PANDrm,
          3104 => Opcode::PANDrr,
          3105 => Opcode::PAUSE,
          3106 => Opcode::PAVGBrm,
          3107 => Opcode::PAVGBrr,
          3108 => Opcode::PAVGUSBrm,
          3109 => Opcode::PAVGUSBrr,
          3110 => Opcode::PAVGWrm,
          3111 => Opcode::PAVGWrr,
          3112 => Opcode::PBLENDVBrm0,
          3113 => Opcode::PBLENDVBrr0,
          3114 => Opcode::PBLENDWrmi,
          3115 => Opcode::PBLENDWrri,
          3116 => Opcode::PBNDKB,
          3117 => Opcode::PCLMULQDQrmi,
          3118 => Opcode::PCLMULQDQrri,
          3119 => Opcode::PCMPEQBrm,
          3120 => Opcode::PCMPEQBrr,
          3121 => Opcode::PCMPEQDrm,
          3122 => Opcode::PCMPEQDrr,
          3123 => Opcode::PCMPEQQrm,
          3124 => Opcode::PCMPEQQrr,
          3125 => Opcode::PCMPEQWrm,
          3126 => Opcode::PCMPEQWrr,
          3127 => Opcode::PCMPESTRIrmi,
          3128 => Opcode::PCMPESTRIrri,
          3129 => Opcode::PCMPESTRMrmi,
          3130 => Opcode::PCMPESTRMrri,
          3131 => Opcode::PCMPGTBrm,
          3132 => Opcode::PCMPGTBrr,
          3133 => Opcode::PCMPGTDrm,
          3134 => Opcode::PCMPGTDrr,
          3135 => Opcode::PCMPGTQrm,
          3136 => Opcode::PCMPGTQrr,
          3137 => Opcode::PCMPGTWrm,
          3138 => Opcode::PCMPGTWrr,
          3139 => Opcode::PCMPISTRIrmi,
          3140 => Opcode::PCMPISTRIrri,
          3141 => Opcode::PCMPISTRMrmi,
          3142 => Opcode::PCMPISTRMrri,
          3143 => Opcode::PCONFIG,
          3144 => Opcode::PDEP32rm,
          3145 => Opcode::PDEP32rm_EVEX,
          3146 => Opcode::PDEP32rr,
          3147 => Opcode::PDEP32rr_EVEX,
          3148 => Opcode::PDEP64rm,
          3149 => Opcode::PDEP64rm_EVEX,
          3150 => Opcode::PDEP64rr,
          3151 => Opcode::PDEP64rr_EVEX,
          3152 => Opcode::PEXT32rm,
          3153 => Opcode::PEXT32rm_EVEX,
          3154 => Opcode::PEXT32rr,
          3155 => Opcode::PEXT32rr_EVEX,
          3156 => Opcode::PEXT64rm,
          3157 => Opcode::PEXT64rm_EVEX,
          3158 => Opcode::PEXT64rr,
          3159 => Opcode::PEXT64rr_EVEX,
          3160 => Opcode::PEXTRBmri,
          3161 => Opcode::PEXTRBrri,
          3162 => Opcode::PEXTRDmri,
          3163 => Opcode::PEXTRDrri,
          3164 => Opcode::PEXTRQmri,
          3165 => Opcode::PEXTRQrri,
          3166 => Opcode::PEXTRWmri,
          3167 => Opcode::PEXTRWrri,
          3168 => Opcode::PEXTRWrri_REV,
          3169 => Opcode::PF2IDrm,
          3170 => Opcode::PF2IDrr,
          3171 => Opcode::PF2IWrm,
          3172 => Opcode::PF2IWrr,
          3173 => Opcode::PFACCrm,
          3174 => Opcode::PFACCrr,
          3175 => Opcode::PFADDrm,
          3176 => Opcode::PFADDrr,
          3177 => Opcode::PFCMPEQrm,
          3178 => Opcode::PFCMPEQrr,
          3179 => Opcode::PFCMPGErm,
          3180 => Opcode::PFCMPGErr,
          3181 => Opcode::PFCMPGTrm,
          3182 => Opcode::PFCMPGTrr,
          3183 => Opcode::PFMAXrm,
          3184 => Opcode::PFMAXrr,
          3185 => Opcode::PFMINrm,
          3186 => Opcode::PFMINrr,
          3187 => Opcode::PFMULrm,
          3188 => Opcode::PFMULrr,
          3189 => Opcode::PFNACCrm,
          3190 => Opcode::PFNACCrr,
          3191 => Opcode::PFPNACCrm,
          3192 => Opcode::PFPNACCrr,
          3193 => Opcode::PFRCPIT1rm,
          3194 => Opcode::PFRCPIT1rr,
          3195 => Opcode::PFRCPIT2rm,
          3196 => Opcode::PFRCPIT2rr,
          3197 => Opcode::PFRCPrm,
          3198 => Opcode::PFRCPrr,
          3199 => Opcode::PFRSQIT1rm,
          3200 => Opcode::PFRSQIT1rr,
          3201 => Opcode::PFRSQRTrm,
          3202 => Opcode::PFRSQRTrr,
          3203 => Opcode::PFSUBRrm,
          3204 => Opcode::PFSUBRrr,
          3205 => Opcode::PFSUBrm,
          3206 => Opcode::PFSUBrr,
          3207 => Opcode::PHADDDrm,
          3208 => Opcode::PHADDDrr,
          3209 => Opcode::PHADDSWrm,
          3210 => Opcode::PHADDSWrr,
          3211 => Opcode::PHADDWrm,
          3212 => Opcode::PHADDWrr,
          3213 => Opcode::PHMINPOSUWrm,
          3214 => Opcode::PHMINPOSUWrr,
          3215 => Opcode::PHSUBDrm,
          3216 => Opcode::PHSUBDrr,
          3217 => Opcode::PHSUBSWrm,
          3218 => Opcode::PHSUBSWrr,
          3219 => Opcode::PHSUBWrm,
          3220 => Opcode::PHSUBWrr,
          3221 => Opcode::PI2FDrm,
          3222 => Opcode::PI2FDrr,
          3223 => Opcode::PI2FWrm,
          3224 => Opcode::PI2FWrr,
          3225 => Opcode::PINSRBrmi,
          3226 => Opcode::PINSRBrri,
          3227 => Opcode::PINSRDrmi,
          3228 => Opcode::PINSRDrri,
          3229 => Opcode::PINSRQrmi,
          3230 => Opcode::PINSRQrri,
          3231 => Opcode::PINSRWrmi,
          3232 => Opcode::PINSRWrri,
          3233 => Opcode::PMADDUBSWrm,
          3234 => Opcode::PMADDUBSWrr,
          3235 => Opcode::PMADDWDrm,
          3236 => Opcode::PMADDWDrr,
          3237 => Opcode::PMAXSBrm,
          3238 => Opcode::PMAXSBrr,
          3239 => Opcode::PMAXSDrm,
          3240 => Opcode::PMAXSDrr,
          3241 => Opcode::PMAXSWrm,
          3242 => Opcode::PMAXSWrr,
          3243 => Opcode::PMAXUBrm,
          3244 => Opcode::PMAXUBrr,
          3245 => Opcode::PMAXUDrm,
          3246 => Opcode::PMAXUDrr,
          3247 => Opcode::PMAXUWrm,
          3248 => Opcode::PMAXUWrr,
          3249 => Opcode::PMINSBrm,
          3250 => Opcode::PMINSBrr,
          3251 => Opcode::PMINSDrm,
          3252 => Opcode::PMINSDrr,
          3253 => Opcode::PMINSWrm,
          3254 => Opcode::PMINSWrr,
          3255 => Opcode::PMINUBrm,
          3256 => Opcode::PMINUBrr,
          3257 => Opcode::PMINUDrm,
          3258 => Opcode::PMINUDrr,
          3259 => Opcode::PMINUWrm,
          3260 => Opcode::PMINUWrr,
          3261 => Opcode::PMOVMSKBrr,
          3262 => Opcode::PMOVSXBDrm,
          3263 => Opcode::PMOVSXBDrr,
          3264 => Opcode::PMOVSXBQrm,
          3265 => Opcode::PMOVSXBQrr,
          3266 => Opcode::PMOVSXBWrm,
          3267 => Opcode::PMOVSXBWrr,
          3268 => Opcode::PMOVSXDQrm,
          3269 => Opcode::PMOVSXDQrr,
          3270 => Opcode::PMOVSXWDrm,
          3271 => Opcode::PMOVSXWDrr,
          3272 => Opcode::PMOVSXWQrm,
          3273 => Opcode::PMOVSXWQrr,
          3274 => Opcode::PMOVZXBDrm,
          3275 => Opcode::PMOVZXBDrr,
          3276 => Opcode::PMOVZXBQrm,
          3277 => Opcode::PMOVZXBQrr,
          3278 => Opcode::PMOVZXBWrm,
          3279 => Opcode::PMOVZXBWrr,
          3280 => Opcode::PMOVZXDQrm,
          3281 => Opcode::PMOVZXDQrr,
          3282 => Opcode::PMOVZXWDrm,
          3283 => Opcode::PMOVZXWDrr,
          3284 => Opcode::PMOVZXWQrm,
          3285 => Opcode::PMOVZXWQrr,
          3286 => Opcode::PMULDQrm,
          3287 => Opcode::PMULDQrr,
          3288 => Opcode::PMULHRSWrm,
          3289 => Opcode::PMULHRSWrr,
          3290 => Opcode::PMULHRWrm,
          3291 => Opcode::PMULHRWrr,
          3292 => Opcode::PMULHUWrm,
          3293 => Opcode::PMULHUWrr,
          3294 => Opcode::PMULHWrm,
          3295 => Opcode::PMULHWrr,
          3296 => Opcode::PMULLDrm,
          3297 => Opcode::PMULLDrr,
          3298 => Opcode::PMULLWrm,
          3299 => Opcode::PMULLWrr,
          3300 => Opcode::PMULUDQrm,
          3301 => Opcode::PMULUDQrr,
          3302 => Opcode::POP16r,
          3303 => Opcode::POP16rmm,
          3304 => Opcode::POP16rmr,
          3305 => Opcode::POP2,
          3306 => Opcode::POP2P,
          3307 => Opcode::POP32r,
          3308 => Opcode::POP32rmm,
          3309 => Opcode::POP32rmr,
          3310 => Opcode::POP64r,
          3311 => Opcode::POP64rmm,
          3312 => Opcode::POP64rmr,
          3313 => Opcode::POPA16,
          3314 => Opcode::POPA32,
          3315 => Opcode::POPCNT16rm,
          3316 => Opcode::POPCNT16rm_EVEX,
          3317 => Opcode::POPCNT16rm_NF,
          3318 => Opcode::POPCNT16rr,
          3319 => Opcode::POPCNT16rr_EVEX,
          3320 => Opcode::POPCNT16rr_NF,
          3321 => Opcode::POPCNT32rm,
          3322 => Opcode::POPCNT32rm_EVEX,
          3323 => Opcode::POPCNT32rm_NF,
          3324 => Opcode::POPCNT32rr,
          3325 => Opcode::POPCNT32rr_EVEX,
          3326 => Opcode::POPCNT32rr_NF,
          3327 => Opcode::POPCNT64rm,
          3328 => Opcode::POPCNT64rm_EVEX,
          3329 => Opcode::POPCNT64rm_NF,
          3330 => Opcode::POPCNT64rr,
          3331 => Opcode::POPCNT64rr_EVEX,
          3332 => Opcode::POPCNT64rr_NF,
          3333 => Opcode::POPDS16,
          3334 => Opcode::POPDS32,
          3335 => Opcode::POPES16,
          3336 => Opcode::POPES32,
          3337 => Opcode::POPF16,
          3338 => Opcode::POPF32,
          3339 => Opcode::POPF64,
          3340 => Opcode::POPFS16,
          3341 => Opcode::POPFS32,
          3342 => Opcode::POPFS64,
          3343 => Opcode::POPGS16,
          3344 => Opcode::POPGS32,
          3345 => Opcode::POPGS64,
          3346 => Opcode::POPP64r,
          3347 => Opcode::POPSS16,
          3348 => Opcode::POPSS32,
          3349 => Opcode::PORrm,
          3350 => Opcode::PORrr,
          3351 => Opcode::PREFETCH,
          3352 => Opcode::PREFETCHIT0,
          3353 => Opcode::PREFETCHIT1,
          3354 => Opcode::PREFETCHNTA,
          3355 => Opcode::PREFETCHRST2,
          3356 => Opcode::PREFETCHT0,
          3357 => Opcode::PREFETCHT1,
          3358 => Opcode::PREFETCHT2,
          3359 => Opcode::PREFETCHW,
          3360 => Opcode::PREFETCHWT1,
          3361 => Opcode::PROBED_ALLOCA_32,
          3362 => Opcode::PROBED_ALLOCA_64,
          3363 => Opcode::PSADBWrm,
          3364 => Opcode::PSADBWrr,
          3365 => Opcode::PSHUFBrm,
          3366 => Opcode::PSHUFBrr,
          3367 => Opcode::PSHUFDmi,
          3368 => Opcode::PSHUFDri,
          3369 => Opcode::PSHUFHWmi,
          3370 => Opcode::PSHUFHWri,
          3371 => Opcode::PSHUFLWmi,
          3372 => Opcode::PSHUFLWri,
          3373 => Opcode::PSIGNBrm,
          3374 => Opcode::PSIGNBrr,
          3375 => Opcode::PSIGNDrm,
          3376 => Opcode::PSIGNDrr,
          3377 => Opcode::PSIGNWrm,
          3378 => Opcode::PSIGNWrr,
          3379 => Opcode::PSLLDQri,
          3380 => Opcode::PSLLDri,
          3381 => Opcode::PSLLDrm,
          3382 => Opcode::PSLLDrr,
          3383 => Opcode::PSLLQri,
          3384 => Opcode::PSLLQrm,
          3385 => Opcode::PSLLQrr,
          3386 => Opcode::PSLLWri,
          3387 => Opcode::PSLLWrm,
          3388 => Opcode::PSLLWrr,
          3389 => Opcode::PSMASH,
          3390 => Opcode::PSRADri,
          3391 => Opcode::PSRADrm,
          3392 => Opcode::PSRADrr,
          3393 => Opcode::PSRAWri,
          3394 => Opcode::PSRAWrm,
          3395 => Opcode::PSRAWrr,
          3396 => Opcode::PSRLDQri,
          3397 => Opcode::PSRLDri,
          3398 => Opcode::PSRLDrm,
          3399 => Opcode::PSRLDrr,
          3400 => Opcode::PSRLQri,
          3401 => Opcode::PSRLQrm,
          3402 => Opcode::PSRLQrr,
          3403 => Opcode::PSRLWri,
          3404 => Opcode::PSRLWrm,
          3405 => Opcode::PSRLWrr,
          3406 => Opcode::PSUBBrm,
          3407 => Opcode::PSUBBrr,
          3408 => Opcode::PSUBDrm,
          3409 => Opcode::PSUBDrr,
          3410 => Opcode::PSUBQrm,
          3411 => Opcode::PSUBQrr,
          3412 => Opcode::PSUBSBrm,
          3413 => Opcode::PSUBSBrr,
          3414 => Opcode::PSUBSWrm,
          3415 => Opcode::PSUBSWrr,
          3416 => Opcode::PSUBUSBrm,
          3417 => Opcode::PSUBUSBrr,
          3418 => Opcode::PSUBUSWrm,
          3419 => Opcode::PSUBUSWrr,
          3420 => Opcode::PSUBWrm,
          3421 => Opcode::PSUBWrr,
          3422 => Opcode::PSWAPDrm,
          3423 => Opcode::PSWAPDrr,
          3424 => Opcode::PT2RPNTLVWZ0,
          3425 => Opcode::PT2RPNTLVWZ0RS,
          3426 => Opcode::PT2RPNTLVWZ0RST1,
          3427 => Opcode::PT2RPNTLVWZ0T1,
          3428 => Opcode::PT2RPNTLVWZ1,
          3429 => Opcode::PT2RPNTLVWZ1RS,
          3430 => Opcode::PT2RPNTLVWZ1RST1,
          3431 => Opcode::PT2RPNTLVWZ1T1,
          3432 => Opcode::PTCMMIMFP16PS,
          3433 => Opcode::PTCMMIMFP16PSV,
          3434 => Opcode::PTCMMRLFP16PS,
          3435 => Opcode::PTCMMRLFP16PSV,
          3436 => Opcode::PTCONJTCMMIMFP16PS,
          3437 => Opcode::PTCONJTCMMIMFP16PSV,
          3438 => Opcode::PTCONJTFP16,
          3439 => Opcode::PTCONJTFP16V,
          3440 => Opcode::PTCVTROWD2PSrre,
          3441 => Opcode::PTCVTROWD2PSrreV,
          3442 => Opcode::PTCVTROWD2PSrri,
          3443 => Opcode::PTCVTROWD2PSrriV,
          3444 => Opcode::PTCVTROWPS2BF16Hrre,
          3445 => Opcode::PTCVTROWPS2BF16HrreV,
          3446 => Opcode::PTCVTROWPS2BF16Hrri,
          3447 => Opcode::PTCVTROWPS2BF16HrriV,
          3448 => Opcode::PTCVTROWPS2BF16Lrre,
          3449 => Opcode::PTCVTROWPS2BF16LrreV,
          3450 => Opcode::PTCVTROWPS2BF16Lrri,
          3451 => Opcode::PTCVTROWPS2BF16LrriV,
          3452 => Opcode::PTCVTROWPS2PHHrre,
          3453 => Opcode::PTCVTROWPS2PHHrreV,
          3454 => Opcode::PTCVTROWPS2PHHrri,
          3455 => Opcode::PTCVTROWPS2PHHrriV,
          3456 => Opcode::PTCVTROWPS2PHLrre,
          3457 => Opcode::PTCVTROWPS2PHLrreV,
          3458 => Opcode::PTCVTROWPS2PHLrri,
          3459 => Opcode::PTCVTROWPS2PHLrriV,
          3460 => Opcode::PTDPBF16PS,
          3461 => Opcode::PTDPBF8PS,
          3462 => Opcode::PTDPBF8PSV,
          3463 => Opcode::PTDPBHF8PS,
          3464 => Opcode::PTDPBHF8PSV,
          3465 => Opcode::PTDPBSSD,
          3466 => Opcode::PTDPBSUD,
          3467 => Opcode::PTDPBUSD,
          3468 => Opcode::PTDPBUUD,
          3469 => Opcode::PTDPFP16PS,
          3470 => Opcode::PTDPHBF8PS,
          3471 => Opcode::PTDPHBF8PSV,
          3472 => Opcode::PTDPHF8PS,
          3473 => Opcode::PTDPHF8PSV,
          3474 => Opcode::PTESTrm,
          3475 => Opcode::PTESTrr,
          3476 => Opcode::PTILELOADD,
          3477 => Opcode::PTILELOADDRS,
          3478 => Opcode::PTILELOADDRST1,
          3479 => Opcode::PTILELOADDT1,
          3480 => Opcode::PTILEMOVROWrre,
          3481 => Opcode::PTILEMOVROWrreV,
          3482 => Opcode::PTILEMOVROWrri,
          3483 => Opcode::PTILEMOVROWrriV,
          3484 => Opcode::PTILESTORED,
          3485 => Opcode::PTILEZERO,
          3486 => Opcode::PTMMULTF32PS,
          3487 => Opcode::PTMMULTF32PSV,
          3488 => Opcode::PTTCMMIMFP16PS,
          3489 => Opcode::PTTCMMIMFP16PSV,
          3490 => Opcode::PTTCMMRLFP16PS,
          3491 => Opcode::PTTCMMRLFP16PSV,
          3492 => Opcode::PTTDPBF16PS,
          3493 => Opcode::PTTDPBF16PSV,
          3494 => Opcode::PTTDPFP16PS,
          3495 => Opcode::PTTDPFP16PSV,
          3496 => Opcode::PTTMMULTF32PS,
          3497 => Opcode::PTTMMULTF32PSV,
          3498 => Opcode::PTTRANSPOSED,
          3499 => Opcode::PTTRANSPOSEDV,
          3500 => Opcode::PTWRITE64m,
          3501 => Opcode::PTWRITE64r,
          3502 => Opcode::PTWRITEm,
          3503 => Opcode::PTWRITEr,
          3504 => Opcode::PUNPCKHBWrm,
          3505 => Opcode::PUNPCKHBWrr,
          3506 => Opcode::PUNPCKHDQrm,
          3507 => Opcode::PUNPCKHDQrr,
          3508 => Opcode::PUNPCKHQDQrm,
          3509 => Opcode::PUNPCKHQDQrr,
          3510 => Opcode::PUNPCKHWDrm,
          3511 => Opcode::PUNPCKHWDrr,
          3512 => Opcode::PUNPCKLBWrm,
          3513 => Opcode::PUNPCKLBWrr,
          3514 => Opcode::PUNPCKLDQrm,
          3515 => Opcode::PUNPCKLDQrr,
          3516 => Opcode::PUNPCKLQDQrm,
          3517 => Opcode::PUNPCKLQDQrr,
          3518 => Opcode::PUNPCKLWDrm,
          3519 => Opcode::PUNPCKLWDrr,
          3520 => Opcode::PUSH16i,
          3521 => Opcode::PUSH16i8,
          3522 => Opcode::PUSH16r,
          3523 => Opcode::PUSH16rmm,
          3524 => Opcode::PUSH16rmr,
          3525 => Opcode::PUSH2,
          3526 => Opcode::PUSH2P,
          3527 => Opcode::PUSH32i,
          3528 => Opcode::PUSH32i8,
          3529 => Opcode::PUSH32r,
          3530 => Opcode::PUSH32rmm,
          3531 => Opcode::PUSH32rmr,
          3532 => Opcode::PUSH64i32,
          3533 => Opcode::PUSH64i8,
          3534 => Opcode::PUSH64r,
          3535 => Opcode::PUSH64rmm,
          3536 => Opcode::PUSH64rmr,
          3537 => Opcode::PUSHA16,
          3538 => Opcode::PUSHA32,
          3539 => Opcode::PUSHCS16,
          3540 => Opcode::PUSHCS32,
          3541 => Opcode::PUSHDS16,
          3542 => Opcode::PUSHDS32,
          3543 => Opcode::PUSHES16,
          3544 => Opcode::PUSHES32,
          3545 => Opcode::PUSHF16,
          3546 => Opcode::PUSHF32,
          3547 => Opcode::PUSHF64,
          3548 => Opcode::PUSHFS16,
          3549 => Opcode::PUSHFS32,
          3550 => Opcode::PUSHFS64,
          3551 => Opcode::PUSHGS16,
          3552 => Opcode::PUSHGS32,
          3553 => Opcode::PUSHGS64,
          3554 => Opcode::PUSHP64r,
          3555 => Opcode::PUSHSS16,
          3556 => Opcode::PUSHSS32,
          3557 => Opcode::PVALIDATE32,
          3558 => Opcode::PVALIDATE64,
          3559 => Opcode::PXORrm,
          3560 => Opcode::PXORrr,
          3561 => Opcode::RCL16m1,
          3562 => Opcode::RCL16m1_EVEX,
          3563 => Opcode::RCL16m1_ND,
          3564 => Opcode::RCL16mCL,
          3565 => Opcode::RCL16mCL_EVEX,
          3566 => Opcode::RCL16mCL_ND,
          3567 => Opcode::RCL16mi,
          3568 => Opcode::RCL16mi_EVEX,
          3569 => Opcode::RCL16mi_ND,
          3570 => Opcode::RCL16r1,
          3571 => Opcode::RCL16r1_EVEX,
          3572 => Opcode::RCL16r1_ND,
          3573 => Opcode::RCL16rCL,
          3574 => Opcode::RCL16rCL_EVEX,
          3575 => Opcode::RCL16rCL_ND,
          3576 => Opcode::RCL16ri,
          3577 => Opcode::RCL16ri_EVEX,
          3578 => Opcode::RCL16ri_ND,
          3579 => Opcode::RCL32m1,
          3580 => Opcode::RCL32m1_EVEX,
          3581 => Opcode::RCL32m1_ND,
          3582 => Opcode::RCL32mCL,
          3583 => Opcode::RCL32mCL_EVEX,
          3584 => Opcode::RCL32mCL_ND,
          3585 => Opcode::RCL32mi,
          3586 => Opcode::RCL32mi_EVEX,
          3587 => Opcode::RCL32mi_ND,
          3588 => Opcode::RCL32r1,
          3589 => Opcode::RCL32r1_EVEX,
          3590 => Opcode::RCL32r1_ND,
          3591 => Opcode::RCL32rCL,
          3592 => Opcode::RCL32rCL_EVEX,
          3593 => Opcode::RCL32rCL_ND,
          3594 => Opcode::RCL32ri,
          3595 => Opcode::RCL32ri_EVEX,
          3596 => Opcode::RCL32ri_ND,
          3597 => Opcode::RCL64m1,
          3598 => Opcode::RCL64m1_EVEX,
          3599 => Opcode::RCL64m1_ND,
          3600 => Opcode::RCL64mCL,
          3601 => Opcode::RCL64mCL_EVEX,
          3602 => Opcode::RCL64mCL_ND,
          3603 => Opcode::RCL64mi,
          3604 => Opcode::RCL64mi_EVEX,
          3605 => Opcode::RCL64mi_ND,
          3606 => Opcode::RCL64r1,
          3607 => Opcode::RCL64r1_EVEX,
          3608 => Opcode::RCL64r1_ND,
          3609 => Opcode::RCL64rCL,
          3610 => Opcode::RCL64rCL_EVEX,
          3611 => Opcode::RCL64rCL_ND,
          3612 => Opcode::RCL64ri,
          3613 => Opcode::RCL64ri_EVEX,
          3614 => Opcode::RCL64ri_ND,
          3615 => Opcode::RCL8m1,
          3616 => Opcode::RCL8m1_EVEX,
          3617 => Opcode::RCL8m1_ND,
          3618 => Opcode::RCL8mCL,
          3619 => Opcode::RCL8mCL_EVEX,
          3620 => Opcode::RCL8mCL_ND,
          3621 => Opcode::RCL8mi,
          3622 => Opcode::RCL8mi_EVEX,
          3623 => Opcode::RCL8mi_ND,
          3624 => Opcode::RCL8r1,
          3625 => Opcode::RCL8r1_EVEX,
          3626 => Opcode::RCL8r1_ND,
          3627 => Opcode::RCL8rCL,
          3628 => Opcode::RCL8rCL_EVEX,
          3629 => Opcode::RCL8rCL_ND,
          3630 => Opcode::RCL8ri,
          3631 => Opcode::RCL8ri_EVEX,
          3632 => Opcode::RCL8ri_ND,
          3633 => Opcode::RCPPSm,
          3634 => Opcode::RCPPSr,
          3635 => Opcode::RCPSSm,
          3636 => Opcode::RCPSSm_Int,
          3637 => Opcode::RCPSSr,
          3638 => Opcode::RCPSSr_Int,
          3639 => Opcode::RCR16m1,
          3640 => Opcode::RCR16m1_EVEX,
          3641 => Opcode::RCR16m1_ND,
          3642 => Opcode::RCR16mCL,
          3643 => Opcode::RCR16mCL_EVEX,
          3644 => Opcode::RCR16mCL_ND,
          3645 => Opcode::RCR16mi,
          3646 => Opcode::RCR16mi_EVEX,
          3647 => Opcode::RCR16mi_ND,
          3648 => Opcode::RCR16r1,
          3649 => Opcode::RCR16r1_EVEX,
          3650 => Opcode::RCR16r1_ND,
          3651 => Opcode::RCR16rCL,
          3652 => Opcode::RCR16rCL_EVEX,
          3653 => Opcode::RCR16rCL_ND,
          3654 => Opcode::RCR16ri,
          3655 => Opcode::RCR16ri_EVEX,
          3656 => Opcode::RCR16ri_ND,
          3657 => Opcode::RCR32m1,
          3658 => Opcode::RCR32m1_EVEX,
          3659 => Opcode::RCR32m1_ND,
          3660 => Opcode::RCR32mCL,
          3661 => Opcode::RCR32mCL_EVEX,
          3662 => Opcode::RCR32mCL_ND,
          3663 => Opcode::RCR32mi,
          3664 => Opcode::RCR32mi_EVEX,
          3665 => Opcode::RCR32mi_ND,
          3666 => Opcode::RCR32r1,
          3667 => Opcode::RCR32r1_EVEX,
          3668 => Opcode::RCR32r1_ND,
          3669 => Opcode::RCR32rCL,
          3670 => Opcode::RCR32rCL_EVEX,
          3671 => Opcode::RCR32rCL_ND,
          3672 => Opcode::RCR32ri,
          3673 => Opcode::RCR32ri_EVEX,
          3674 => Opcode::RCR32ri_ND,
          3675 => Opcode::RCR64m1,
          3676 => Opcode::RCR64m1_EVEX,
          3677 => Opcode::RCR64m1_ND,
          3678 => Opcode::RCR64mCL,
          3679 => Opcode::RCR64mCL_EVEX,
          3680 => Opcode::RCR64mCL_ND,
          3681 => Opcode::RCR64mi,
          3682 => Opcode::RCR64mi_EVEX,
          3683 => Opcode::RCR64mi_ND,
          3684 => Opcode::RCR64r1,
          3685 => Opcode::RCR64r1_EVEX,
          3686 => Opcode::RCR64r1_ND,
          3687 => Opcode::RCR64rCL,
          3688 => Opcode::RCR64rCL_EVEX,
          3689 => Opcode::RCR64rCL_ND,
          3690 => Opcode::RCR64ri,
          3691 => Opcode::RCR64ri_EVEX,
          3692 => Opcode::RCR64ri_ND,
          3693 => Opcode::RCR8m1,
          3694 => Opcode::RCR8m1_EVEX,
          3695 => Opcode::RCR8m1_ND,
          3696 => Opcode::RCR8mCL,
          3697 => Opcode::RCR8mCL_EVEX,
          3698 => Opcode::RCR8mCL_ND,
          3699 => Opcode::RCR8mi,
          3700 => Opcode::RCR8mi_EVEX,
          3701 => Opcode::RCR8mi_ND,
          3702 => Opcode::RCR8r1,
          3703 => Opcode::RCR8r1_EVEX,
          3704 => Opcode::RCR8r1_ND,
          3705 => Opcode::RCR8rCL,
          3706 => Opcode::RCR8rCL_EVEX,
          3707 => Opcode::RCR8rCL_ND,
          3708 => Opcode::RCR8ri,
          3709 => Opcode::RCR8ri_EVEX,
          3710 => Opcode::RCR8ri_ND,
          3711 => Opcode::RDFSBASE,
          3712 => Opcode::RDFSBASE64,
          3713 => Opcode::RDGSBASE,
          3714 => Opcode::RDGSBASE64,
          3715 => Opcode::RDMSR,
          3716 => Opcode::RDMSRLIST,
          3717 => Opcode::RDMSRri,
          3718 => Opcode::RDMSRri_EVEX,
          3719 => Opcode::RDPID32,
          3720 => Opcode::RDPID64,
          3721 => Opcode::RDPKRUr,
          3722 => Opcode::RDPMC,
          3723 => Opcode::RDPRU,
          3724 => Opcode::RDRAND16r,
          3725 => Opcode::RDRAND32r,
          3726 => Opcode::RDRAND64r,
          3727 => Opcode::RDSEED16r,
          3728 => Opcode::RDSEED32r,
          3729 => Opcode::RDSEED64r,
          3730 => Opcode::RDSSPD,
          3731 => Opcode::RDSSPQ,
          3732 => Opcode::RDTSC,
          3733 => Opcode::RDTSCP,
          3734 => Opcode::REPNE_PREFIX,
          3735 => Opcode::REP_MOVSB_32,
          3736 => Opcode::REP_MOVSB_64,
          3737 => Opcode::REP_MOVSD_32,
          3738 => Opcode::REP_MOVSD_64,
          3739 => Opcode::REP_MOVSQ_32,
          3740 => Opcode::REP_MOVSQ_64,
          3741 => Opcode::REP_MOVSW_32,
          3742 => Opcode::REP_MOVSW_64,
          3743 => Opcode::REP_PREFIX,
          3744 => Opcode::REP_STOSB_32,
          3745 => Opcode::REP_STOSB_64,
          3746 => Opcode::REP_STOSD_32,
          3747 => Opcode::REP_STOSD_64,
          3748 => Opcode::REP_STOSQ_32,
          3749 => Opcode::REP_STOSQ_64,
          3750 => Opcode::REP_STOSW_32,
          3751 => Opcode::REP_STOSW_64,
          3752 => Opcode::RET,
          3753 => Opcode::RET16,
          3754 => Opcode::RET32,
          3755 => Opcode::RET64,
          3756 => Opcode::RETI16,
          3757 => Opcode::RETI32,
          3758 => Opcode::RETI64,
          3759 => Opcode::REX64_PREFIX,
          3760 => Opcode::RMPADJUST,
          3761 => Opcode::RMPQUERY,
          3762 => Opcode::RMPUPDATE,
          3763 => Opcode::ROL16m1,
          3764 => Opcode::ROL16m1_EVEX,
          3765 => Opcode::ROL16m1_ND,
          3766 => Opcode::ROL16m1_NF,
          3767 => Opcode::ROL16m1_NF_ND,
          3768 => Opcode::ROL16mCL,
          3769 => Opcode::ROL16mCL_EVEX,
          3770 => Opcode::ROL16mCL_ND,
          3771 => Opcode::ROL16mCL_NF,
          3772 => Opcode::ROL16mCL_NF_ND,
          3773 => Opcode::ROL16mi,
          3774 => Opcode::ROL16mi_EVEX,
          3775 => Opcode::ROL16mi_ND,
          3776 => Opcode::ROL16mi_NF,
          3777 => Opcode::ROL16mi_NF_ND,
          3778 => Opcode::ROL16r1,
          3779 => Opcode::ROL16r1_EVEX,
          3780 => Opcode::ROL16r1_ND,
          3781 => Opcode::ROL16r1_NF,
          3782 => Opcode::ROL16r1_NF_ND,
          3783 => Opcode::ROL16rCL,
          3784 => Opcode::ROL16rCL_EVEX,
          3785 => Opcode::ROL16rCL_ND,
          3786 => Opcode::ROL16rCL_NF,
          3787 => Opcode::ROL16rCL_NF_ND,
          3788 => Opcode::ROL16ri,
          3789 => Opcode::ROL16ri_EVEX,
          3790 => Opcode::ROL16ri_ND,
          3791 => Opcode::ROL16ri_NF,
          3792 => Opcode::ROL16ri_NF_ND,
          3793 => Opcode::ROL32m1,
          3794 => Opcode::ROL32m1_EVEX,
          3795 => Opcode::ROL32m1_ND,
          3796 => Opcode::ROL32m1_NF,
          3797 => Opcode::ROL32m1_NF_ND,
          3798 => Opcode::ROL32mCL,
          3799 => Opcode::ROL32mCL_EVEX,
          3800 => Opcode::ROL32mCL_ND,
          3801 => Opcode::ROL32mCL_NF,
          3802 => Opcode::ROL32mCL_NF_ND,
          3803 => Opcode::ROL32mi,
          3804 => Opcode::ROL32mi_EVEX,
          3805 => Opcode::ROL32mi_ND,
          3806 => Opcode::ROL32mi_NF,
          3807 => Opcode::ROL32mi_NF_ND,
          3808 => Opcode::ROL32r1,
          3809 => Opcode::ROL32r1_EVEX,
          3810 => Opcode::ROL32r1_ND,
          3811 => Opcode::ROL32r1_NF,
          3812 => Opcode::ROL32r1_NF_ND,
          3813 => Opcode::ROL32rCL,
          3814 => Opcode::ROL32rCL_EVEX,
          3815 => Opcode::ROL32rCL_ND,
          3816 => Opcode::ROL32rCL_NF,
          3817 => Opcode::ROL32rCL_NF_ND,
          3818 => Opcode::ROL32ri,
          3819 => Opcode::ROL32ri_EVEX,
          3820 => Opcode::ROL32ri_ND,
          3821 => Opcode::ROL32ri_NF,
          3822 => Opcode::ROL32ri_NF_ND,
          3823 => Opcode::ROL64m1,
          3824 => Opcode::ROL64m1_EVEX,
          3825 => Opcode::ROL64m1_ND,
          3826 => Opcode::ROL64m1_NF,
          3827 => Opcode::ROL64m1_NF_ND,
          3828 => Opcode::ROL64mCL,
          3829 => Opcode::ROL64mCL_EVEX,
          3830 => Opcode::ROL64mCL_ND,
          3831 => Opcode::ROL64mCL_NF,
          3832 => Opcode::ROL64mCL_NF_ND,
          3833 => Opcode::ROL64mi,
          3834 => Opcode::ROL64mi_EVEX,
          3835 => Opcode::ROL64mi_ND,
          3836 => Opcode::ROL64mi_NF,
          3837 => Opcode::ROL64mi_NF_ND,
          3838 => Opcode::ROL64r1,
          3839 => Opcode::ROL64r1_EVEX,
          3840 => Opcode::ROL64r1_ND,
          3841 => Opcode::ROL64r1_NF,
          3842 => Opcode::ROL64r1_NF_ND,
          3843 => Opcode::ROL64rCL,
          3844 => Opcode::ROL64rCL_EVEX,
          3845 => Opcode::ROL64rCL_ND,
          3846 => Opcode::ROL64rCL_NF,
          3847 => Opcode::ROL64rCL_NF_ND,
          3848 => Opcode::ROL64ri,
          3849 => Opcode::ROL64ri_EVEX,
          3850 => Opcode::ROL64ri_ND,
          3851 => Opcode::ROL64ri_NF,
          3852 => Opcode::ROL64ri_NF_ND,
          3853 => Opcode::ROL8m1,
          3854 => Opcode::ROL8m1_EVEX,
          3855 => Opcode::ROL8m1_ND,
          3856 => Opcode::ROL8m1_NF,
          3857 => Opcode::ROL8m1_NF_ND,
          3858 => Opcode::ROL8mCL,
          3859 => Opcode::ROL8mCL_EVEX,
          3860 => Opcode::ROL8mCL_ND,
          3861 => Opcode::ROL8mCL_NF,
          3862 => Opcode::ROL8mCL_NF_ND,
          3863 => Opcode::ROL8mi,
          3864 => Opcode::ROL8mi_EVEX,
          3865 => Opcode::ROL8mi_ND,
          3866 => Opcode::ROL8mi_NF,
          3867 => Opcode::ROL8mi_NF_ND,
          3868 => Opcode::ROL8r1,
          3869 => Opcode::ROL8r1_EVEX,
          3870 => Opcode::ROL8r1_ND,
          3871 => Opcode::ROL8r1_NF,
          3872 => Opcode::ROL8r1_NF_ND,
          3873 => Opcode::ROL8rCL,
          3874 => Opcode::ROL8rCL_EVEX,
          3875 => Opcode::ROL8rCL_ND,
          3876 => Opcode::ROL8rCL_NF,
          3877 => Opcode::ROL8rCL_NF_ND,
          3878 => Opcode::ROL8ri,
          3879 => Opcode::ROL8ri_EVEX,
          3880 => Opcode::ROL8ri_ND,
          3881 => Opcode::ROL8ri_NF,
          3882 => Opcode::ROL8ri_NF_ND,
          3883 => Opcode::ROR16m1,
          3884 => Opcode::ROR16m1_EVEX,
          3885 => Opcode::ROR16m1_ND,
          3886 => Opcode::ROR16m1_NF,
          3887 => Opcode::ROR16m1_NF_ND,
          3888 => Opcode::ROR16mCL,
          3889 => Opcode::ROR16mCL_EVEX,
          3890 => Opcode::ROR16mCL_ND,
          3891 => Opcode::ROR16mCL_NF,
          3892 => Opcode::ROR16mCL_NF_ND,
          3893 => Opcode::ROR16mi,
          3894 => Opcode::ROR16mi_EVEX,
          3895 => Opcode::ROR16mi_ND,
          3896 => Opcode::ROR16mi_NF,
          3897 => Opcode::ROR16mi_NF_ND,
          3898 => Opcode::ROR16r1,
          3899 => Opcode::ROR16r1_EVEX,
          3900 => Opcode::ROR16r1_ND,
          3901 => Opcode::ROR16r1_NF,
          3902 => Opcode::ROR16r1_NF_ND,
          3903 => Opcode::ROR16rCL,
          3904 => Opcode::ROR16rCL_EVEX,
          3905 => Opcode::ROR16rCL_ND,
          3906 => Opcode::ROR16rCL_NF,
          3907 => Opcode::ROR16rCL_NF_ND,
          3908 => Opcode::ROR16ri,
          3909 => Opcode::ROR16ri_EVEX,
          3910 => Opcode::ROR16ri_ND,
          3911 => Opcode::ROR16ri_NF,
          3912 => Opcode::ROR16ri_NF_ND,
          3913 => Opcode::ROR32m1,
          3914 => Opcode::ROR32m1_EVEX,
          3915 => Opcode::ROR32m1_ND,
          3916 => Opcode::ROR32m1_NF,
          3917 => Opcode::ROR32m1_NF_ND,
          3918 => Opcode::ROR32mCL,
          3919 => Opcode::ROR32mCL_EVEX,
          3920 => Opcode::ROR32mCL_ND,
          3921 => Opcode::ROR32mCL_NF,
          3922 => Opcode::ROR32mCL_NF_ND,
          3923 => Opcode::ROR32mi,
          3924 => Opcode::ROR32mi_EVEX,
          3925 => Opcode::ROR32mi_ND,
          3926 => Opcode::ROR32mi_NF,
          3927 => Opcode::ROR32mi_NF_ND,
          3928 => Opcode::ROR32r1,
          3929 => Opcode::ROR32r1_EVEX,
          3930 => Opcode::ROR32r1_ND,
          3931 => Opcode::ROR32r1_NF,
          3932 => Opcode::ROR32r1_NF_ND,
          3933 => Opcode::ROR32rCL,
          3934 => Opcode::ROR32rCL_EVEX,
          3935 => Opcode::ROR32rCL_ND,
          3936 => Opcode::ROR32rCL_NF,
          3937 => Opcode::ROR32rCL_NF_ND,
          3938 => Opcode::ROR32ri,
          3939 => Opcode::ROR32ri_EVEX,
          3940 => Opcode::ROR32ri_ND,
          3941 => Opcode::ROR32ri_NF,
          3942 => Opcode::ROR32ri_NF_ND,
          3943 => Opcode::ROR64m1,
          3944 => Opcode::ROR64m1_EVEX,
          3945 => Opcode::ROR64m1_ND,
          3946 => Opcode::ROR64m1_NF,
          3947 => Opcode::ROR64m1_NF_ND,
          3948 => Opcode::ROR64mCL,
          3949 => Opcode::ROR64mCL_EVEX,
          3950 => Opcode::ROR64mCL_ND,
          3951 => Opcode::ROR64mCL_NF,
          3952 => Opcode::ROR64mCL_NF_ND,
          3953 => Opcode::ROR64mi,
          3954 => Opcode::ROR64mi_EVEX,
          3955 => Opcode::ROR64mi_ND,
          3956 => Opcode::ROR64mi_NF,
          3957 => Opcode::ROR64mi_NF_ND,
          3958 => Opcode::ROR64r1,
          3959 => Opcode::ROR64r1_EVEX,
          3960 => Opcode::ROR64r1_ND,
          3961 => Opcode::ROR64r1_NF,
          3962 => Opcode::ROR64r1_NF_ND,
          3963 => Opcode::ROR64rCL,
          3964 => Opcode::ROR64rCL_EVEX,
          3965 => Opcode::ROR64rCL_ND,
          3966 => Opcode::ROR64rCL_NF,
          3967 => Opcode::ROR64rCL_NF_ND,
          3968 => Opcode::ROR64ri,
          3969 => Opcode::ROR64ri_EVEX,
          3970 => Opcode::ROR64ri_ND,
          3971 => Opcode::ROR64ri_NF,
          3972 => Opcode::ROR64ri_NF_ND,
          3973 => Opcode::ROR8m1,
          3974 => Opcode::ROR8m1_EVEX,
          3975 => Opcode::ROR8m1_ND,
          3976 => Opcode::ROR8m1_NF,
          3977 => Opcode::ROR8m1_NF_ND,
          3978 => Opcode::ROR8mCL,
          3979 => Opcode::ROR8mCL_EVEX,
          3980 => Opcode::ROR8mCL_ND,
          3981 => Opcode::ROR8mCL_NF,
          3982 => Opcode::ROR8mCL_NF_ND,
          3983 => Opcode::ROR8mi,
          3984 => Opcode::ROR8mi_EVEX,
          3985 => Opcode::ROR8mi_ND,
          3986 => Opcode::ROR8mi_NF,
          3987 => Opcode::ROR8mi_NF_ND,
          3988 => Opcode::ROR8r1,
          3989 => Opcode::ROR8r1_EVEX,
          3990 => Opcode::ROR8r1_ND,
          3991 => Opcode::ROR8r1_NF,
          3992 => Opcode::ROR8r1_NF_ND,
          3993 => Opcode::ROR8rCL,
          3994 => Opcode::ROR8rCL_EVEX,
          3995 => Opcode::ROR8rCL_ND,
          3996 => Opcode::ROR8rCL_NF,
          3997 => Opcode::ROR8rCL_NF_ND,
          3998 => Opcode::ROR8ri,
          3999 => Opcode::ROR8ri_EVEX,
          4000 => Opcode::ROR8ri_ND,
          4001 => Opcode::ROR8ri_NF,
          4002 => Opcode::ROR8ri_NF_ND,
          4003 => Opcode::RORX32mi,
          4004 => Opcode::RORX32mi_EVEX,
          4005 => Opcode::RORX32ri,
          4006 => Opcode::RORX32ri_EVEX,
          4007 => Opcode::RORX64mi,
          4008 => Opcode::RORX64mi_EVEX,
          4009 => Opcode::RORX64ri,
          4010 => Opcode::RORX64ri_EVEX,
          4011 => Opcode::ROUNDPDmi,
          4012 => Opcode::ROUNDPDri,
          4013 => Opcode::ROUNDPSmi,
          4014 => Opcode::ROUNDPSri,
          4015 => Opcode::ROUNDSDmi,
          4016 => Opcode::ROUNDSDmi_Int,
          4017 => Opcode::ROUNDSDri,
          4018 => Opcode::ROUNDSDri_Int,
          4019 => Opcode::ROUNDSSmi,
          4020 => Opcode::ROUNDSSmi_Int,
          4021 => Opcode::ROUNDSSri,
          4022 => Opcode::ROUNDSSri_Int,
          4023 => Opcode::RSM,
          4024 => Opcode::RSQRTPSm,
          4025 => Opcode::RSQRTPSr,
          4026 => Opcode::RSQRTSSm,
          4027 => Opcode::RSQRTSSm_Int,
          4028 => Opcode::RSQRTSSr,
          4029 => Opcode::RSQRTSSr_Int,
          4030 => Opcode::RSTORSSP,
          4031 => Opcode::SAHF,
          4032 => Opcode::SALC,
          4033 => Opcode::SAR16m1,
          4034 => Opcode::SAR16m1_EVEX,
          4035 => Opcode::SAR16m1_ND,
          4036 => Opcode::SAR16m1_NF,
          4037 => Opcode::SAR16m1_NF_ND,
          4038 => Opcode::SAR16mCL,
          4039 => Opcode::SAR16mCL_EVEX,
          4040 => Opcode::SAR16mCL_ND,
          4041 => Opcode::SAR16mCL_NF,
          4042 => Opcode::SAR16mCL_NF_ND,
          4043 => Opcode::SAR16mi,
          4044 => Opcode::SAR16mi_EVEX,
          4045 => Opcode::SAR16mi_ND,
          4046 => Opcode::SAR16mi_NF,
          4047 => Opcode::SAR16mi_NF_ND,
          4048 => Opcode::SAR16r1,
          4049 => Opcode::SAR16r1_EVEX,
          4050 => Opcode::SAR16r1_ND,
          4051 => Opcode::SAR16r1_NF,
          4052 => Opcode::SAR16r1_NF_ND,
          4053 => Opcode::SAR16rCL,
          4054 => Opcode::SAR16rCL_EVEX,
          4055 => Opcode::SAR16rCL_ND,
          4056 => Opcode::SAR16rCL_NF,
          4057 => Opcode::SAR16rCL_NF_ND,
          4058 => Opcode::SAR16ri,
          4059 => Opcode::SAR16ri_EVEX,
          4060 => Opcode::SAR16ri_ND,
          4061 => Opcode::SAR16ri_NF,
          4062 => Opcode::SAR16ri_NF_ND,
          4063 => Opcode::SAR32m1,
          4064 => Opcode::SAR32m1_EVEX,
          4065 => Opcode::SAR32m1_ND,
          4066 => Opcode::SAR32m1_NF,
          4067 => Opcode::SAR32m1_NF_ND,
          4068 => Opcode::SAR32mCL,
          4069 => Opcode::SAR32mCL_EVEX,
          4070 => Opcode::SAR32mCL_ND,
          4071 => Opcode::SAR32mCL_NF,
          4072 => Opcode::SAR32mCL_NF_ND,
          4073 => Opcode::SAR32mi,
          4074 => Opcode::SAR32mi_EVEX,
          4075 => Opcode::SAR32mi_ND,
          4076 => Opcode::SAR32mi_NF,
          4077 => Opcode::SAR32mi_NF_ND,
          4078 => Opcode::SAR32r1,
          4079 => Opcode::SAR32r1_EVEX,
          4080 => Opcode::SAR32r1_ND,
          4081 => Opcode::SAR32r1_NF,
          4082 => Opcode::SAR32r1_NF_ND,
          4083 => Opcode::SAR32rCL,
          4084 => Opcode::SAR32rCL_EVEX,
          4085 => Opcode::SAR32rCL_ND,
          4086 => Opcode::SAR32rCL_NF,
          4087 => Opcode::SAR32rCL_NF_ND,
          4088 => Opcode::SAR32ri,
          4089 => Opcode::SAR32ri_EVEX,
          4090 => Opcode::SAR32ri_ND,
          4091 => Opcode::SAR32ri_NF,
          4092 => Opcode::SAR32ri_NF_ND,
          4093 => Opcode::SAR64m1,
          4094 => Opcode::SAR64m1_EVEX,
          4095 => Opcode::SAR64m1_ND,
          4096 => Opcode::SAR64m1_NF,
          4097 => Opcode::SAR64m1_NF_ND,
          4098 => Opcode::SAR64mCL,
          4099 => Opcode::SAR64mCL_EVEX,
          4100 => Opcode::SAR64mCL_ND,
          4101 => Opcode::SAR64mCL_NF,
          4102 => Opcode::SAR64mCL_NF_ND,
          4103 => Opcode::SAR64mi,
          4104 => Opcode::SAR64mi_EVEX,
          4105 => Opcode::SAR64mi_ND,
          4106 => Opcode::SAR64mi_NF,
          4107 => Opcode::SAR64mi_NF_ND,
          4108 => Opcode::SAR64r1,
          4109 => Opcode::SAR64r1_EVEX,
          4110 => Opcode::SAR64r1_ND,
          4111 => Opcode::SAR64r1_NF,
          4112 => Opcode::SAR64r1_NF_ND,
          4113 => Opcode::SAR64rCL,
          4114 => Opcode::SAR64rCL_EVEX,
          4115 => Opcode::SAR64rCL_ND,
          4116 => Opcode::SAR64rCL_NF,
          4117 => Opcode::SAR64rCL_NF_ND,
          4118 => Opcode::SAR64ri,
          4119 => Opcode::SAR64ri_EVEX,
          4120 => Opcode::SAR64ri_ND,
          4121 => Opcode::SAR64ri_NF,
          4122 => Opcode::SAR64ri_NF_ND,
          4123 => Opcode::SAR8m1,
          4124 => Opcode::SAR8m1_EVEX,
          4125 => Opcode::SAR8m1_ND,
          4126 => Opcode::SAR8m1_NF,
          4127 => Opcode::SAR8m1_NF_ND,
          4128 => Opcode::SAR8mCL,
          4129 => Opcode::SAR8mCL_EVEX,
          4130 => Opcode::SAR8mCL_ND,
          4131 => Opcode::SAR8mCL_NF,
          4132 => Opcode::SAR8mCL_NF_ND,
          4133 => Opcode::SAR8mi,
          4134 => Opcode::SAR8mi_EVEX,
          4135 => Opcode::SAR8mi_ND,
          4136 => Opcode::SAR8mi_NF,
          4137 => Opcode::SAR8mi_NF_ND,
          4138 => Opcode::SAR8r1,
          4139 => Opcode::SAR8r1_EVEX,
          4140 => Opcode::SAR8r1_ND,
          4141 => Opcode::SAR8r1_NF,
          4142 => Opcode::SAR8r1_NF_ND,
          4143 => Opcode::SAR8rCL,
          4144 => Opcode::SAR8rCL_EVEX,
          4145 => Opcode::SAR8rCL_ND,
          4146 => Opcode::SAR8rCL_NF,
          4147 => Opcode::SAR8rCL_NF_ND,
          4148 => Opcode::SAR8ri,
          4149 => Opcode::SAR8ri_EVEX,
          4150 => Opcode::SAR8ri_ND,
          4151 => Opcode::SAR8ri_NF,
          4152 => Opcode::SAR8ri_NF_ND,
          4153 => Opcode::SARX32rm,
          4154 => Opcode::SARX32rm_EVEX,
          4155 => Opcode::SARX32rr,
          4156 => Opcode::SARX32rr_EVEX,
          4157 => Opcode::SARX64rm,
          4158 => Opcode::SARX64rm_EVEX,
          4159 => Opcode::SARX64rr,
          4160 => Opcode::SARX64rr_EVEX,
          4161 => Opcode::SAVEPREVSSP,
          4162 => Opcode::SBB16i16,
          4163 => Opcode::SBB16mi,
          4164 => Opcode::SBB16mi8,
          4165 => Opcode::SBB16mi8_EVEX,
          4166 => Opcode::SBB16mi8_ND,
          4167 => Opcode::SBB16mi_EVEX,
          4168 => Opcode::SBB16mi_ND,
          4169 => Opcode::SBB16mr,
          4170 => Opcode::SBB16mr_EVEX,
          4171 => Opcode::SBB16mr_ND,
          4172 => Opcode::SBB16ri,
          4173 => Opcode::SBB16ri8,
          4174 => Opcode::SBB16ri8_EVEX,
          4175 => Opcode::SBB16ri8_ND,
          4176 => Opcode::SBB16ri_EVEX,
          4177 => Opcode::SBB16ri_ND,
          4178 => Opcode::SBB16rm,
          4179 => Opcode::SBB16rm_EVEX,
          4180 => Opcode::SBB16rm_ND,
          4181 => Opcode::SBB16rr,
          4182 => Opcode::SBB16rr_EVEX,
          4183 => Opcode::SBB16rr_EVEX_REV,
          4184 => Opcode::SBB16rr_ND,
          4185 => Opcode::SBB16rr_ND_REV,
          4186 => Opcode::SBB16rr_REV,
          4187 => Opcode::SBB32i32,
          4188 => Opcode::SBB32mi,
          4189 => Opcode::SBB32mi8,
          4190 => Opcode::SBB32mi8_EVEX,
          4191 => Opcode::SBB32mi8_ND,
          4192 => Opcode::SBB32mi_EVEX,
          4193 => Opcode::SBB32mi_ND,
          4194 => Opcode::SBB32mr,
          4195 => Opcode::SBB32mr_EVEX,
          4196 => Opcode::SBB32mr_ND,
          4197 => Opcode::SBB32ri,
          4198 => Opcode::SBB32ri8,
          4199 => Opcode::SBB32ri8_EVEX,
          4200 => Opcode::SBB32ri8_ND,
          4201 => Opcode::SBB32ri_EVEX,
          4202 => Opcode::SBB32ri_ND,
          4203 => Opcode::SBB32rm,
          4204 => Opcode::SBB32rm_EVEX,
          4205 => Opcode::SBB32rm_ND,
          4206 => Opcode::SBB32rr,
          4207 => Opcode::SBB32rr_EVEX,
          4208 => Opcode::SBB32rr_EVEX_REV,
          4209 => Opcode::SBB32rr_ND,
          4210 => Opcode::SBB32rr_ND_REV,
          4211 => Opcode::SBB32rr_REV,
          4212 => Opcode::SBB64i32,
          4213 => Opcode::SBB64mi32,
          4214 => Opcode::SBB64mi32_EVEX,
          4215 => Opcode::SBB64mi32_ND,
          4216 => Opcode::SBB64mi8,
          4217 => Opcode::SBB64mi8_EVEX,
          4218 => Opcode::SBB64mi8_ND,
          4219 => Opcode::SBB64mr,
          4220 => Opcode::SBB64mr_EVEX,
          4221 => Opcode::SBB64mr_ND,
          4222 => Opcode::SBB64ri32,
          4223 => Opcode::SBB64ri32_EVEX,
          4224 => Opcode::SBB64ri32_ND,
          4225 => Opcode::SBB64ri8,
          4226 => Opcode::SBB64ri8_EVEX,
          4227 => Opcode::SBB64ri8_ND,
          4228 => Opcode::SBB64rm,
          4229 => Opcode::SBB64rm_EVEX,
          4230 => Opcode::SBB64rm_ND,
          4231 => Opcode::SBB64rr,
          4232 => Opcode::SBB64rr_EVEX,
          4233 => Opcode::SBB64rr_EVEX_REV,
          4234 => Opcode::SBB64rr_ND,
          4235 => Opcode::SBB64rr_ND_REV,
          4236 => Opcode::SBB64rr_REV,
          4237 => Opcode::SBB8i8,
          4238 => Opcode::SBB8mi,
          4239 => Opcode::SBB8mi8,
          4240 => Opcode::SBB8mi_EVEX,
          4241 => Opcode::SBB8mi_ND,
          4242 => Opcode::SBB8mr,
          4243 => Opcode::SBB8mr_EVEX,
          4244 => Opcode::SBB8mr_ND,
          4245 => Opcode::SBB8ri,
          4246 => Opcode::SBB8ri8,
          4247 => Opcode::SBB8ri_EVEX,
          4248 => Opcode::SBB8ri_ND,
          4249 => Opcode::SBB8rm,
          4250 => Opcode::SBB8rm_EVEX,
          4251 => Opcode::SBB8rm_ND,
          4252 => Opcode::SBB8rr,
          4253 => Opcode::SBB8rr_EVEX,
          4254 => Opcode::SBB8rr_EVEX_REV,
          4255 => Opcode::SBB8rr_ND,
          4256 => Opcode::SBB8rr_ND_REV,
          4257 => Opcode::SBB8rr_REV,
          4258 => Opcode::SCASB,
          4259 => Opcode::SCASL,
          4260 => Opcode::SCASQ,
          4261 => Opcode::SCASW,
          4262 => Opcode::SEAMCALL,
          4263 => Opcode::SEAMOPS,
          4264 => Opcode::SEAMRET,
          4265 => Opcode::SEG_ALLOCA_32,
          4266 => Opcode::SEG_ALLOCA_64,
          4267 => Opcode::SENDUIPI,
          4268 => Opcode::SERIALIZE,
          4269 => Opcode::SETCCm,
          4270 => Opcode::SETCCm_EVEX,
          4271 => Opcode::SETCCr,
          4272 => Opcode::SETCCr_EVEX,
          4273 => Opcode::SETSSBSY,
          4274 => Opcode::SETZUCCm,
          4275 => Opcode::SETZUCCr,
          4276 => Opcode::SFENCE,
          4277 => Opcode::SGDT16m,
          4278 => Opcode::SGDT32m,
          4279 => Opcode::SGDT64m,
          4280 => Opcode::SHA1MSG1rm,
          4281 => Opcode::SHA1MSG1rr,
          4282 => Opcode::SHA1MSG2rm,
          4283 => Opcode::SHA1MSG2rr,
          4284 => Opcode::SHA1NEXTErm,
          4285 => Opcode::SHA1NEXTErr,
          4286 => Opcode::SHA1RNDS4rmi,
          4287 => Opcode::SHA1RNDS4rri,
          4288 => Opcode::SHA256MSG1rm,
          4289 => Opcode::SHA256MSG1rr,
          4290 => Opcode::SHA256MSG2rm,
          4291 => Opcode::SHA256MSG2rr,
          4292 => Opcode::SHA256RNDS2rm,
          4293 => Opcode::SHA256RNDS2rr,
          4294 => Opcode::SHL16m1,
          4295 => Opcode::SHL16m1_EVEX,
          4296 => Opcode::SHL16m1_ND,
          4297 => Opcode::SHL16m1_NF,
          4298 => Opcode::SHL16m1_NF_ND,
          4299 => Opcode::SHL16mCL,
          4300 => Opcode::SHL16mCL_EVEX,
          4301 => Opcode::SHL16mCL_ND,
          4302 => Opcode::SHL16mCL_NF,
          4303 => Opcode::SHL16mCL_NF_ND,
          4304 => Opcode::SHL16mi,
          4305 => Opcode::SHL16mi_EVEX,
          4306 => Opcode::SHL16mi_ND,
          4307 => Opcode::SHL16mi_NF,
          4308 => Opcode::SHL16mi_NF_ND,
          4309 => Opcode::SHL16r1,
          4310 => Opcode::SHL16r1_EVEX,
          4311 => Opcode::SHL16r1_ND,
          4312 => Opcode::SHL16r1_NF,
          4313 => Opcode::SHL16r1_NF_ND,
          4314 => Opcode::SHL16rCL,
          4315 => Opcode::SHL16rCL_EVEX,
          4316 => Opcode::SHL16rCL_ND,
          4317 => Opcode::SHL16rCL_NF,
          4318 => Opcode::SHL16rCL_NF_ND,
          4319 => Opcode::SHL16ri,
          4320 => Opcode::SHL16ri_EVEX,
          4321 => Opcode::SHL16ri_ND,
          4322 => Opcode::SHL16ri_NF,
          4323 => Opcode::SHL16ri_NF_ND,
          4324 => Opcode::SHL32m1,
          4325 => Opcode::SHL32m1_EVEX,
          4326 => Opcode::SHL32m1_ND,
          4327 => Opcode::SHL32m1_NF,
          4328 => Opcode::SHL32m1_NF_ND,
          4329 => Opcode::SHL32mCL,
          4330 => Opcode::SHL32mCL_EVEX,
          4331 => Opcode::SHL32mCL_ND,
          4332 => Opcode::SHL32mCL_NF,
          4333 => Opcode::SHL32mCL_NF_ND,
          4334 => Opcode::SHL32mi,
          4335 => Opcode::SHL32mi_EVEX,
          4336 => Opcode::SHL32mi_ND,
          4337 => Opcode::SHL32mi_NF,
          4338 => Opcode::SHL32mi_NF_ND,
          4339 => Opcode::SHL32r1,
          4340 => Opcode::SHL32r1_EVEX,
          4341 => Opcode::SHL32r1_ND,
          4342 => Opcode::SHL32r1_NF,
          4343 => Opcode::SHL32r1_NF_ND,
          4344 => Opcode::SHL32rCL,
          4345 => Opcode::SHL32rCL_EVEX,
          4346 => Opcode::SHL32rCL_ND,
          4347 => Opcode::SHL32rCL_NF,
          4348 => Opcode::SHL32rCL_NF_ND,
          4349 => Opcode::SHL32ri,
          4350 => Opcode::SHL32ri_EVEX,
          4351 => Opcode::SHL32ri_ND,
          4352 => Opcode::SHL32ri_NF,
          4353 => Opcode::SHL32ri_NF_ND,
          4354 => Opcode::SHL64m1,
          4355 => Opcode::SHL64m1_EVEX,
          4356 => Opcode::SHL64m1_ND,
          4357 => Opcode::SHL64m1_NF,
          4358 => Opcode::SHL64m1_NF_ND,
          4359 => Opcode::SHL64mCL,
          4360 => Opcode::SHL64mCL_EVEX,
          4361 => Opcode::SHL64mCL_ND,
          4362 => Opcode::SHL64mCL_NF,
          4363 => Opcode::SHL64mCL_NF_ND,
          4364 => Opcode::SHL64mi,
          4365 => Opcode::SHL64mi_EVEX,
          4366 => Opcode::SHL64mi_ND,
          4367 => Opcode::SHL64mi_NF,
          4368 => Opcode::SHL64mi_NF_ND,
          4369 => Opcode::SHL64r1,
          4370 => Opcode::SHL64r1_EVEX,
          4371 => Opcode::SHL64r1_ND,
          4372 => Opcode::SHL64r1_NF,
          4373 => Opcode::SHL64r1_NF_ND,
          4374 => Opcode::SHL64rCL,
          4375 => Opcode::SHL64rCL_EVEX,
          4376 => Opcode::SHL64rCL_ND,
          4377 => Opcode::SHL64rCL_NF,
          4378 => Opcode::SHL64rCL_NF_ND,
          4379 => Opcode::SHL64ri,
          4380 => Opcode::SHL64ri_EVEX,
          4381 => Opcode::SHL64ri_ND,
          4382 => Opcode::SHL64ri_NF,
          4383 => Opcode::SHL64ri_NF_ND,
          4384 => Opcode::SHL8m1,
          4385 => Opcode::SHL8m1_EVEX,
          4386 => Opcode::SHL8m1_ND,
          4387 => Opcode::SHL8m1_NF,
          4388 => Opcode::SHL8m1_NF_ND,
          4389 => Opcode::SHL8mCL,
          4390 => Opcode::SHL8mCL_EVEX,
          4391 => Opcode::SHL8mCL_ND,
          4392 => Opcode::SHL8mCL_NF,
          4393 => Opcode::SHL8mCL_NF_ND,
          4394 => Opcode::SHL8mi,
          4395 => Opcode::SHL8mi_EVEX,
          4396 => Opcode::SHL8mi_ND,
          4397 => Opcode::SHL8mi_NF,
          4398 => Opcode::SHL8mi_NF_ND,
          4399 => Opcode::SHL8r1,
          4400 => Opcode::SHL8r1_EVEX,
          4401 => Opcode::SHL8r1_ND,
          4402 => Opcode::SHL8r1_NF,
          4403 => Opcode::SHL8r1_NF_ND,
          4404 => Opcode::SHL8rCL,
          4405 => Opcode::SHL8rCL_EVEX,
          4406 => Opcode::SHL8rCL_ND,
          4407 => Opcode::SHL8rCL_NF,
          4408 => Opcode::SHL8rCL_NF_ND,
          4409 => Opcode::SHL8ri,
          4410 => Opcode::SHL8ri_EVEX,
          4411 => Opcode::SHL8ri_ND,
          4412 => Opcode::SHL8ri_NF,
          4413 => Opcode::SHL8ri_NF_ND,
          4414 => Opcode::SHLD16mrCL,
          4415 => Opcode::SHLD16mrCL_EVEX,
          4416 => Opcode::SHLD16mrCL_ND,
          4417 => Opcode::SHLD16mrCL_NF,
          4418 => Opcode::SHLD16mrCL_NF_ND,
          4419 => Opcode::SHLD16mri8,
          4420 => Opcode::SHLD16mri8_EVEX,
          4421 => Opcode::SHLD16mri8_ND,
          4422 => Opcode::SHLD16mri8_NF,
          4423 => Opcode::SHLD16mri8_NF_ND,
          4424 => Opcode::SHLD16rrCL,
          4425 => Opcode::SHLD16rrCL_EVEX,
          4426 => Opcode::SHLD16rrCL_ND,
          4427 => Opcode::SHLD16rrCL_NF,
          4428 => Opcode::SHLD16rrCL_NF_ND,
          4429 => Opcode::SHLD16rri8,
          4430 => Opcode::SHLD16rri8_EVEX,
          4431 => Opcode::SHLD16rri8_ND,
          4432 => Opcode::SHLD16rri8_NF,
          4433 => Opcode::SHLD16rri8_NF_ND,
          4434 => Opcode::SHLD32mrCL,
          4435 => Opcode::SHLD32mrCL_EVEX,
          4436 => Opcode::SHLD32mrCL_ND,
          4437 => Opcode::SHLD32mrCL_NF,
          4438 => Opcode::SHLD32mrCL_NF_ND,
          4439 => Opcode::SHLD32mri8,
          4440 => Opcode::SHLD32mri8_EVEX,
          4441 => Opcode::SHLD32mri8_ND,
          4442 => Opcode::SHLD32mri8_NF,
          4443 => Opcode::SHLD32mri8_NF_ND,
          4444 => Opcode::SHLD32rrCL,
          4445 => Opcode::SHLD32rrCL_EVEX,
          4446 => Opcode::SHLD32rrCL_ND,
          4447 => Opcode::SHLD32rrCL_NF,
          4448 => Opcode::SHLD32rrCL_NF_ND,
          4449 => Opcode::SHLD32rri8,
          4450 => Opcode::SHLD32rri8_EVEX,
          4451 => Opcode::SHLD32rri8_ND,
          4452 => Opcode::SHLD32rri8_NF,
          4453 => Opcode::SHLD32rri8_NF_ND,
          4454 => Opcode::SHLD64mrCL,
          4455 => Opcode::SHLD64mrCL_EVEX,
          4456 => Opcode::SHLD64mrCL_ND,
          4457 => Opcode::SHLD64mrCL_NF,
          4458 => Opcode::SHLD64mrCL_NF_ND,
          4459 => Opcode::SHLD64mri8,
          4460 => Opcode::SHLD64mri8_EVEX,
          4461 => Opcode::SHLD64mri8_ND,
          4462 => Opcode::SHLD64mri8_NF,
          4463 => Opcode::SHLD64mri8_NF_ND,
          4464 => Opcode::SHLD64rrCL,
          4465 => Opcode::SHLD64rrCL_EVEX,
          4466 => Opcode::SHLD64rrCL_ND,
          4467 => Opcode::SHLD64rrCL_NF,
          4468 => Opcode::SHLD64rrCL_NF_ND,
          4469 => Opcode::SHLD64rri8,
          4470 => Opcode::SHLD64rri8_EVEX,
          4471 => Opcode::SHLD64rri8_ND,
          4472 => Opcode::SHLD64rri8_NF,
          4473 => Opcode::SHLD64rri8_NF_ND,
          4474 => Opcode::SHLX32rm,
          4475 => Opcode::SHLX32rm_EVEX,
          4476 => Opcode::SHLX32rr,
          4477 => Opcode::SHLX32rr_EVEX,
          4478 => Opcode::SHLX64rm,
          4479 => Opcode::SHLX64rm_EVEX,
          4480 => Opcode::SHLX64rr,
          4481 => Opcode::SHLX64rr_EVEX,
          4482 => Opcode::SHR16m1,
          4483 => Opcode::SHR16m1_EVEX,
          4484 => Opcode::SHR16m1_ND,
          4485 => Opcode::SHR16m1_NF,
          4486 => Opcode::SHR16m1_NF_ND,
          4487 => Opcode::SHR16mCL,
          4488 => Opcode::SHR16mCL_EVEX,
          4489 => Opcode::SHR16mCL_ND,
          4490 => Opcode::SHR16mCL_NF,
          4491 => Opcode::SHR16mCL_NF_ND,
          4492 => Opcode::SHR16mi,
          4493 => Opcode::SHR16mi_EVEX,
          4494 => Opcode::SHR16mi_ND,
          4495 => Opcode::SHR16mi_NF,
          4496 => Opcode::SHR16mi_NF_ND,
          4497 => Opcode::SHR16r1,
          4498 => Opcode::SHR16r1_EVEX,
          4499 => Opcode::SHR16r1_ND,
          4500 => Opcode::SHR16r1_NF,
          4501 => Opcode::SHR16r1_NF_ND,
          4502 => Opcode::SHR16rCL,
          4503 => Opcode::SHR16rCL_EVEX,
          4504 => Opcode::SHR16rCL_ND,
          4505 => Opcode::SHR16rCL_NF,
          4506 => Opcode::SHR16rCL_NF_ND,
          4507 => Opcode::SHR16ri,
          4508 => Opcode::SHR16ri_EVEX,
          4509 => Opcode::SHR16ri_ND,
          4510 => Opcode::SHR16ri_NF,
          4511 => Opcode::SHR16ri_NF_ND,
          4512 => Opcode::SHR32m1,
          4513 => Opcode::SHR32m1_EVEX,
          4514 => Opcode::SHR32m1_ND,
          4515 => Opcode::SHR32m1_NF,
          4516 => Opcode::SHR32m1_NF_ND,
          4517 => Opcode::SHR32mCL,
          4518 => Opcode::SHR32mCL_EVEX,
          4519 => Opcode::SHR32mCL_ND,
          4520 => Opcode::SHR32mCL_NF,
          4521 => Opcode::SHR32mCL_NF_ND,
          4522 => Opcode::SHR32mi,
          4523 => Opcode::SHR32mi_EVEX,
          4524 => Opcode::SHR32mi_ND,
          4525 => Opcode::SHR32mi_NF,
          4526 => Opcode::SHR32mi_NF_ND,
          4527 => Opcode::SHR32r1,
          4528 => Opcode::SHR32r1_EVEX,
          4529 => Opcode::SHR32r1_ND,
          4530 => Opcode::SHR32r1_NF,
          4531 => Opcode::SHR32r1_NF_ND,
          4532 => Opcode::SHR32rCL,
          4533 => Opcode::SHR32rCL_EVEX,
          4534 => Opcode::SHR32rCL_ND,
          4535 => Opcode::SHR32rCL_NF,
          4536 => Opcode::SHR32rCL_NF_ND,
          4537 => Opcode::SHR32ri,
          4538 => Opcode::SHR32ri_EVEX,
          4539 => Opcode::SHR32ri_ND,
          4540 => Opcode::SHR32ri_NF,
          4541 => Opcode::SHR32ri_NF_ND,
          4542 => Opcode::SHR64m1,
          4543 => Opcode::SHR64m1_EVEX,
          4544 => Opcode::SHR64m1_ND,
          4545 => Opcode::SHR64m1_NF,
          4546 => Opcode::SHR64m1_NF_ND,
          4547 => Opcode::SHR64mCL,
          4548 => Opcode::SHR64mCL_EVEX,
          4549 => Opcode::SHR64mCL_ND,
          4550 => Opcode::SHR64mCL_NF,
          4551 => Opcode::SHR64mCL_NF_ND,
          4552 => Opcode::SHR64mi,
          4553 => Opcode::SHR64mi_EVEX,
          4554 => Opcode::SHR64mi_ND,
          4555 => Opcode::SHR64mi_NF,
          4556 => Opcode::SHR64mi_NF_ND,
          4557 => Opcode::SHR64r1,
          4558 => Opcode::SHR64r1_EVEX,
          4559 => Opcode::SHR64r1_ND,
          4560 => Opcode::SHR64r1_NF,
          4561 => Opcode::SHR64r1_NF_ND,
          4562 => Opcode::SHR64rCL,
          4563 => Opcode::SHR64rCL_EVEX,
          4564 => Opcode::SHR64rCL_ND,
          4565 => Opcode::SHR64rCL_NF,
          4566 => Opcode::SHR64rCL_NF_ND,
          4567 => Opcode::SHR64ri,
          4568 => Opcode::SHR64ri_EVEX,
          4569 => Opcode::SHR64ri_ND,
          4570 => Opcode::SHR64ri_NF,
          4571 => Opcode::SHR64ri_NF_ND,
          4572 => Opcode::SHR8m1,
          4573 => Opcode::SHR8m1_EVEX,
          4574 => Opcode::SHR8m1_ND,
          4575 => Opcode::SHR8m1_NF,
          4576 => Opcode::SHR8m1_NF_ND,
          4577 => Opcode::SHR8mCL,
          4578 => Opcode::SHR8mCL_EVEX,
          4579 => Opcode::SHR8mCL_ND,
          4580 => Opcode::SHR8mCL_NF,
          4581 => Opcode::SHR8mCL_NF_ND,
          4582 => Opcode::SHR8mi,
          4583 => Opcode::SHR8mi_EVEX,
          4584 => Opcode::SHR8mi_ND,
          4585 => Opcode::SHR8mi_NF,
          4586 => Opcode::SHR8mi_NF_ND,
          4587 => Opcode::SHR8r1,
          4588 => Opcode::SHR8r1_EVEX,
          4589 => Opcode::SHR8r1_ND,
          4590 => Opcode::SHR8r1_NF,
          4591 => Opcode::SHR8r1_NF_ND,
          4592 => Opcode::SHR8rCL,
          4593 => Opcode::SHR8rCL_EVEX,
          4594 => Opcode::SHR8rCL_ND,
          4595 => Opcode::SHR8rCL_NF,
          4596 => Opcode::SHR8rCL_NF_ND,
          4597 => Opcode::SHR8ri,
          4598 => Opcode::SHR8ri_EVEX,
          4599 => Opcode::SHR8ri_ND,
          4600 => Opcode::SHR8ri_NF,
          4601 => Opcode::SHR8ri_NF_ND,
          4602 => Opcode::SHRD16mrCL,
          4603 => Opcode::SHRD16mrCL_EVEX,
          4604 => Opcode::SHRD16mrCL_ND,
          4605 => Opcode::SHRD16mrCL_NF,
          4606 => Opcode::SHRD16mrCL_NF_ND,
          4607 => Opcode::SHRD16mri8,
          4608 => Opcode::SHRD16mri8_EVEX,
          4609 => Opcode::SHRD16mri8_ND,
          4610 => Opcode::SHRD16mri8_NF,
          4611 => Opcode::SHRD16mri8_NF_ND,
          4612 => Opcode::SHRD16rrCL,
          4613 => Opcode::SHRD16rrCL_EVEX,
          4614 => Opcode::SHRD16rrCL_ND,
          4615 => Opcode::SHRD16rrCL_NF,
          4616 => Opcode::SHRD16rrCL_NF_ND,
          4617 => Opcode::SHRD16rri8,
          4618 => Opcode::SHRD16rri8_EVEX,
          4619 => Opcode::SHRD16rri8_ND,
          4620 => Opcode::SHRD16rri8_NF,
          4621 => Opcode::SHRD16rri8_NF_ND,
          4622 => Opcode::SHRD32mrCL,
          4623 => Opcode::SHRD32mrCL_EVEX,
          4624 => Opcode::SHRD32mrCL_ND,
          4625 => Opcode::SHRD32mrCL_NF,
          4626 => Opcode::SHRD32mrCL_NF_ND,
          4627 => Opcode::SHRD32mri8,
          4628 => Opcode::SHRD32mri8_EVEX,
          4629 => Opcode::SHRD32mri8_ND,
          4630 => Opcode::SHRD32mri8_NF,
          4631 => Opcode::SHRD32mri8_NF_ND,
          4632 => Opcode::SHRD32rrCL,
          4633 => Opcode::SHRD32rrCL_EVEX,
          4634 => Opcode::SHRD32rrCL_ND,
          4635 => Opcode::SHRD32rrCL_NF,
          4636 => Opcode::SHRD32rrCL_NF_ND,
          4637 => Opcode::SHRD32rri8,
          4638 => Opcode::SHRD32rri8_EVEX,
          4639 => Opcode::SHRD32rri8_ND,
          4640 => Opcode::SHRD32rri8_NF,
          4641 => Opcode::SHRD32rri8_NF_ND,
          4642 => Opcode::SHRD64mrCL,
          4643 => Opcode::SHRD64mrCL_EVEX,
          4644 => Opcode::SHRD64mrCL_ND,
          4645 => Opcode::SHRD64mrCL_NF,
          4646 => Opcode::SHRD64mrCL_NF_ND,
          4647 => Opcode::SHRD64mri8,
          4648 => Opcode::SHRD64mri8_EVEX,
          4649 => Opcode::SHRD64mri8_ND,
          4650 => Opcode::SHRD64mri8_NF,
          4651 => Opcode::SHRD64mri8_NF_ND,
          4652 => Opcode::SHRD64rrCL,
          4653 => Opcode::SHRD64rrCL_EVEX,
          4654 => Opcode::SHRD64rrCL_ND,
          4655 => Opcode::SHRD64rrCL_NF,
          4656 => Opcode::SHRD64rrCL_NF_ND,
          4657 => Opcode::SHRD64rri8,
          4658 => Opcode::SHRD64rri8_EVEX,
          4659 => Opcode::SHRD64rri8_ND,
          4660 => Opcode::SHRD64rri8_NF,
          4661 => Opcode::SHRD64rri8_NF_ND,
          4662 => Opcode::SHRX32rm,
          4663 => Opcode::SHRX32rm_EVEX,
          4664 => Opcode::SHRX32rr,
          4665 => Opcode::SHRX32rr_EVEX,
          4666 => Opcode::SHRX64rm,
          4667 => Opcode::SHRX64rm_EVEX,
          4668 => Opcode::SHRX64rr,
          4669 => Opcode::SHRX64rr_EVEX,
          4670 => Opcode::SHUFPDrmi,
          4671 => Opcode::SHUFPDrri,
          4672 => Opcode::SHUFPSrmi,
          4673 => Opcode::SHUFPSrri,
          4674 => Opcode::SIDT16m,
          4675 => Opcode::SIDT32m,
          4676 => Opcode::SIDT64m,
          4677 => Opcode::SKINIT,
          4678 => Opcode::SLDT16m,
          4679 => Opcode::SLDT16r,
          4680 => Opcode::SLDT32r,
          4681 => Opcode::SLDT64r,
          4682 => Opcode::SLWPCB,
          4683 => Opcode::SLWPCB64,
          4684 => Opcode::SMSW16m,
          4685 => Opcode::SMSW16r,
          4686 => Opcode::SMSW32r,
          4687 => Opcode::SMSW64r,
          4688 => Opcode::SQRTPDm,
          4689 => Opcode::SQRTPDr,
          4690 => Opcode::SQRTPSm,
          4691 => Opcode::SQRTPSr,
          4692 => Opcode::SQRTSDm,
          4693 => Opcode::SQRTSDm_Int,
          4694 => Opcode::SQRTSDr,
          4695 => Opcode::SQRTSDr_Int,
          4696 => Opcode::SQRTSSm,
          4697 => Opcode::SQRTSSm_Int,
          4698 => Opcode::SQRTSSr,
          4699 => Opcode::SQRTSSr_Int,
          4700 => Opcode::SQRT_F,
          4701 => Opcode::SQRT_Fp32,
          4702 => Opcode::SQRT_Fp64,
          4703 => Opcode::SQRT_Fp80,
          4704 => Opcode::SS_PREFIX,
          4705 => Opcode::STAC,
          4706 => Opcode::STACKALLOC_W_PROBING,
          4707 => Opcode::STC,
          4708 => Opcode::STD,
          4709 => Opcode::STGI,
          4710 => Opcode::STI,
          4711 => Opcode::STMXCSR,
          4712 => Opcode::STOSB,
          4713 => Opcode::STOSL,
          4714 => Opcode::STOSQ,
          4715 => Opcode::STOSW,
          4716 => Opcode::STR16r,
          4717 => Opcode::STR32r,
          4718 => Opcode::STR64r,
          4719 => Opcode::STRm,
          4720 => Opcode::STTILECFG,
          4721 => Opcode::STTILECFG_EVEX,
          4722 => Opcode::STUI,
          4723 => Opcode::ST_F32m,
          4724 => Opcode::ST_F64m,
          4725 => Opcode::ST_FP32m,
          4726 => Opcode::ST_FP64m,
          4727 => Opcode::ST_FP80m,
          4728 => Opcode::ST_FPrr,
          4729 => Opcode::ST_Fp32m,
          4730 => Opcode::ST_Fp64m,
          4731 => Opcode::ST_Fp64m32,
          4732 => Opcode::ST_Fp80m32,
          4733 => Opcode::ST_Fp80m64,
          4734 => Opcode::ST_FpP32m,
          4735 => Opcode::ST_FpP64m,
          4736 => Opcode::ST_FpP64m32,
          4737 => Opcode::ST_FpP80m,
          4738 => Opcode::ST_FpP80m32,
          4739 => Opcode::ST_FpP80m64,
          4740 => Opcode::ST_Frr,
          4741 => Opcode::SUB16i16,
          4742 => Opcode::SUB16mi,
          4743 => Opcode::SUB16mi8,
          4744 => Opcode::SUB16mi8_EVEX,
          4745 => Opcode::SUB16mi8_ND,
          4746 => Opcode::SUB16mi8_NF,
          4747 => Opcode::SUB16mi8_NF_ND,
          4748 => Opcode::SUB16mi_EVEX,
          4749 => Opcode::SUB16mi_ND,
          4750 => Opcode::SUB16mi_NF,
          4751 => Opcode::SUB16mi_NF_ND,
          4752 => Opcode::SUB16mr,
          4753 => Opcode::SUB16mr_EVEX,
          4754 => Opcode::SUB16mr_ND,
          4755 => Opcode::SUB16mr_NF,
          4756 => Opcode::SUB16mr_NF_ND,
          4757 => Opcode::SUB16ri,
          4758 => Opcode::SUB16ri8,
          4759 => Opcode::SUB16ri8_EVEX,
          4760 => Opcode::SUB16ri8_ND,
          4761 => Opcode::SUB16ri8_NF,
          4762 => Opcode::SUB16ri8_NF_ND,
          4763 => Opcode::SUB16ri_EVEX,
          4764 => Opcode::SUB16ri_ND,
          4765 => Opcode::SUB16ri_NF,
          4766 => Opcode::SUB16ri_NF_ND,
          4767 => Opcode::SUB16rm,
          4768 => Opcode::SUB16rm_EVEX,
          4769 => Opcode::SUB16rm_ND,
          4770 => Opcode::SUB16rm_NF,
          4771 => Opcode::SUB16rm_NF_ND,
          4772 => Opcode::SUB16rr,
          4773 => Opcode::SUB16rr_EVEX,
          4774 => Opcode::SUB16rr_EVEX_REV,
          4775 => Opcode::SUB16rr_ND,
          4776 => Opcode::SUB16rr_ND_REV,
          4777 => Opcode::SUB16rr_NF,
          4778 => Opcode::SUB16rr_NF_ND,
          4779 => Opcode::SUB16rr_NF_ND_REV,
          4780 => Opcode::SUB16rr_NF_REV,
          4781 => Opcode::SUB16rr_REV,
          4782 => Opcode::SUB32i32,
          4783 => Opcode::SUB32mi,
          4784 => Opcode::SUB32mi8,
          4785 => Opcode::SUB32mi8_EVEX,
          4786 => Opcode::SUB32mi8_ND,
          4787 => Opcode::SUB32mi8_NF,
          4788 => Opcode::SUB32mi8_NF_ND,
          4789 => Opcode::SUB32mi_EVEX,
          4790 => Opcode::SUB32mi_ND,
          4791 => Opcode::SUB32mi_NF,
          4792 => Opcode::SUB32mi_NF_ND,
          4793 => Opcode::SUB32mr,
          4794 => Opcode::SUB32mr_EVEX,
          4795 => Opcode::SUB32mr_ND,
          4796 => Opcode::SUB32mr_NF,
          4797 => Opcode::SUB32mr_NF_ND,
          4798 => Opcode::SUB32ri,
          4799 => Opcode::SUB32ri8,
          4800 => Opcode::SUB32ri8_EVEX,
          4801 => Opcode::SUB32ri8_ND,
          4802 => Opcode::SUB32ri8_NF,
          4803 => Opcode::SUB32ri8_NF_ND,
          4804 => Opcode::SUB32ri_EVEX,
          4805 => Opcode::SUB32ri_ND,
          4806 => Opcode::SUB32ri_NF,
          4807 => Opcode::SUB32ri_NF_ND,
          4808 => Opcode::SUB32rm,
          4809 => Opcode::SUB32rm_EVEX,
          4810 => Opcode::SUB32rm_ND,
          4811 => Opcode::SUB32rm_NF,
          4812 => Opcode::SUB32rm_NF_ND,
          4813 => Opcode::SUB32rr,
          4814 => Opcode::SUB32rr_EVEX,
          4815 => Opcode::SUB32rr_EVEX_REV,
          4816 => Opcode::SUB32rr_ND,
          4817 => Opcode::SUB32rr_ND_REV,
          4818 => Opcode::SUB32rr_NF,
          4819 => Opcode::SUB32rr_NF_ND,
          4820 => Opcode::SUB32rr_NF_ND_REV,
          4821 => Opcode::SUB32rr_NF_REV,
          4822 => Opcode::SUB32rr_REV,
          4823 => Opcode::SUB64i32,
          4824 => Opcode::SUB64mi32,
          4825 => Opcode::SUB64mi32_EVEX,
          4826 => Opcode::SUB64mi32_ND,
          4827 => Opcode::SUB64mi32_NF,
          4828 => Opcode::SUB64mi32_NF_ND,
          4829 => Opcode::SUB64mi8,
          4830 => Opcode::SUB64mi8_EVEX,
          4831 => Opcode::SUB64mi8_ND,
          4832 => Opcode::SUB64mi8_NF,
          4833 => Opcode::SUB64mi8_NF_ND,
          4834 => Opcode::SUB64mr,
          4835 => Opcode::SUB64mr_EVEX,
          4836 => Opcode::SUB64mr_ND,
          4837 => Opcode::SUB64mr_NF,
          4838 => Opcode::SUB64mr_NF_ND,
          4839 => Opcode::SUB64ri32,
          4840 => Opcode::SUB64ri32_EVEX,
          4841 => Opcode::SUB64ri32_ND,
          4842 => Opcode::SUB64ri32_NF,
          4843 => Opcode::SUB64ri32_NF_ND,
          4844 => Opcode::SUB64ri8,
          4845 => Opcode::SUB64ri8_EVEX,
          4846 => Opcode::SUB64ri8_ND,
          4847 => Opcode::SUB64ri8_NF,
          4848 => Opcode::SUB64ri8_NF_ND,
          4849 => Opcode::SUB64rm,
          4850 => Opcode::SUB64rm_EVEX,
          4851 => Opcode::SUB64rm_ND,
          4852 => Opcode::SUB64rm_NF,
          4853 => Opcode::SUB64rm_NF_ND,
          4854 => Opcode::SUB64rr,
          4855 => Opcode::SUB64rr_EVEX,
          4856 => Opcode::SUB64rr_EVEX_REV,
          4857 => Opcode::SUB64rr_ND,
          4858 => Opcode::SUB64rr_ND_REV,
          4859 => Opcode::SUB64rr_NF,
          4860 => Opcode::SUB64rr_NF_ND,
          4861 => Opcode::SUB64rr_NF_ND_REV,
          4862 => Opcode::SUB64rr_NF_REV,
          4863 => Opcode::SUB64rr_REV,
          4864 => Opcode::SUB8i8,
          4865 => Opcode::SUB8mi,
          4866 => Opcode::SUB8mi8,
          4867 => Opcode::SUB8mi_EVEX,
          4868 => Opcode::SUB8mi_ND,
          4869 => Opcode::SUB8mi_NF,
          4870 => Opcode::SUB8mi_NF_ND,
          4871 => Opcode::SUB8mr,
          4872 => Opcode::SUB8mr_EVEX,
          4873 => Opcode::SUB8mr_ND,
          4874 => Opcode::SUB8mr_NF,
          4875 => Opcode::SUB8mr_NF_ND,
          4876 => Opcode::SUB8ri,
          4877 => Opcode::SUB8ri8,
          4878 => Opcode::SUB8ri_EVEX,
          4879 => Opcode::SUB8ri_ND,
          4880 => Opcode::SUB8ri_NF,
          4881 => Opcode::SUB8ri_NF_ND,
          4882 => Opcode::SUB8rm,
          4883 => Opcode::SUB8rm_EVEX,
          4884 => Opcode::SUB8rm_ND,
          4885 => Opcode::SUB8rm_NF,
          4886 => Opcode::SUB8rm_NF_ND,
          4887 => Opcode::SUB8rr,
          4888 => Opcode::SUB8rr_EVEX,
          4889 => Opcode::SUB8rr_EVEX_REV,
          4890 => Opcode::SUB8rr_ND,
          4891 => Opcode::SUB8rr_ND_REV,
          4892 => Opcode::SUB8rr_NF,
          4893 => Opcode::SUB8rr_NF_ND,
          4894 => Opcode::SUB8rr_NF_ND_REV,
          4895 => Opcode::SUB8rr_NF_REV,
          4896 => Opcode::SUB8rr_REV,
          4897 => Opcode::SUBPDrm,
          4898 => Opcode::SUBPDrr,
          4899 => Opcode::SUBPSrm,
          4900 => Opcode::SUBPSrr,
          4901 => Opcode::SUBR_F32m,
          4902 => Opcode::SUBR_F64m,
          4903 => Opcode::SUBR_FI16m,
          4904 => Opcode::SUBR_FI32m,
          4905 => Opcode::SUBR_FPrST0,
          4906 => Opcode::SUBR_FST0r,
          4907 => Opcode::SUBR_Fp32m,
          4908 => Opcode::SUBR_Fp64m,
          4909 => Opcode::SUBR_Fp64m32,
          4910 => Opcode::SUBR_Fp80m32,
          4911 => Opcode::SUBR_Fp80m64,
          4912 => Opcode::SUBR_FpI16m32,
          4913 => Opcode::SUBR_FpI16m64,
          4914 => Opcode::SUBR_FpI16m80,
          4915 => Opcode::SUBR_FpI32m32,
          4916 => Opcode::SUBR_FpI32m64,
          4917 => Opcode::SUBR_FpI32m80,
          4918 => Opcode::SUBR_FrST0,
          4919 => Opcode::SUBSDrm,
          4920 => Opcode::SUBSDrm_Int,
          4921 => Opcode::SUBSDrr,
          4922 => Opcode::SUBSDrr_Int,
          4923 => Opcode::SUBSSrm,
          4924 => Opcode::SUBSSrm_Int,
          4925 => Opcode::SUBSSrr,
          4926 => Opcode::SUBSSrr_Int,
          4927 => Opcode::SUB_F32m,
          4928 => Opcode::SUB_F64m,
          4929 => Opcode::SUB_FI16m,
          4930 => Opcode::SUB_FI32m,
          4931 => Opcode::SUB_FPrST0,
          4932 => Opcode::SUB_FST0r,
          4933 => Opcode::SUB_Fp32,
          4934 => Opcode::SUB_Fp32m,
          4935 => Opcode::SUB_Fp64,
          4936 => Opcode::SUB_Fp64m,
          4937 => Opcode::SUB_Fp64m32,
          4938 => Opcode::SUB_Fp80,
          4939 => Opcode::SUB_Fp80m32,
          4940 => Opcode::SUB_Fp80m64,
          4941 => Opcode::SUB_FpI16m32,
          4942 => Opcode::SUB_FpI16m64,
          4943 => Opcode::SUB_FpI16m80,
          4944 => Opcode::SUB_FpI32m32,
          4945 => Opcode::SUB_FpI32m64,
          4946 => Opcode::SUB_FpI32m80,
          4947 => Opcode::SUB_FrST0,
          4948 => Opcode::SWAPGS,
          4949 => Opcode::SYSCALL,
          4950 => Opcode::SYSENTER,
          4951 => Opcode::SYSEXIT,
          4952 => Opcode::SYSEXIT64,
          4953 => Opcode::SYSRET,
          4954 => Opcode::SYSRET64,
          4955 => Opcode::T1MSKC32rm,
          4956 => Opcode::T1MSKC32rr,
          4957 => Opcode::T1MSKC64rm,
          4958 => Opcode::T1MSKC64rr,
          4959 => Opcode::T2RPNTLVWZ0,
          4960 => Opcode::T2RPNTLVWZ0RS,
          4961 => Opcode::T2RPNTLVWZ0RST1,
          4962 => Opcode::T2RPNTLVWZ0RST1_EVEX,
          4963 => Opcode::T2RPNTLVWZ0RS_EVEX,
          4964 => Opcode::T2RPNTLVWZ0T1,
          4965 => Opcode::T2RPNTLVWZ0T1_EVEX,
          4966 => Opcode::T2RPNTLVWZ0_EVEX,
          4967 => Opcode::T2RPNTLVWZ1,
          4968 => Opcode::T2RPNTLVWZ1RS,
          4969 => Opcode::T2RPNTLVWZ1RST1,
          4970 => Opcode::T2RPNTLVWZ1RST1_EVEX,
          4971 => Opcode::T2RPNTLVWZ1RS_EVEX,
          4972 => Opcode::T2RPNTLVWZ1T1,
          4973 => Opcode::T2RPNTLVWZ1T1_EVEX,
          4974 => Opcode::T2RPNTLVWZ1_EVEX,
          4975 => Opcode::TAILJMPd,
          4976 => Opcode::TAILJMPd64,
          4977 => Opcode::TAILJMPd64_CC,
          4978 => Opcode::TAILJMPd_CC,
          4979 => Opcode::TAILJMPm,
          4980 => Opcode::TAILJMPm64,
          4981 => Opcode::TAILJMPm64_REX,
          4982 => Opcode::TAILJMPr,
          4983 => Opcode::TAILJMPr64,
          4984 => Opcode::TAILJMPr64_REX,
          4985 => Opcode::TCMMIMFP16PS,
          4986 => Opcode::TCMMRLFP16PS,
          4987 => Opcode::TCONJTCMMIMFP16PS,
          4988 => Opcode::TCONJTFP16,
          4989 => Opcode::TCRETURNdi,
          4990 => Opcode::TCRETURNdi64,
          4991 => Opcode::TCRETURNdi64cc,
          4992 => Opcode::TCRETURNdicc,
          4993 => Opcode::TCRETURNmi,
          4994 => Opcode::TCRETURNmi64,
          4995 => Opcode::TCRETURNri,
          4996 => Opcode::TCRETURNri64,
          4997 => Opcode::TCRETURNri64_ImpCall,
          4998 => Opcode::TCVTROWD2PSrre,
          4999 => Opcode::TCVTROWD2PSrri,
          5000 => Opcode::TCVTROWPS2BF16Hrre,
          5001 => Opcode::TCVTROWPS2BF16Hrri,
          5002 => Opcode::TCVTROWPS2BF16Lrre,
          5003 => Opcode::TCVTROWPS2BF16Lrri,
          5004 => Opcode::TCVTROWPS2PHHrre,
          5005 => Opcode::TCVTROWPS2PHHrri,
          5006 => Opcode::TCVTROWPS2PHLrre,
          5007 => Opcode::TCVTROWPS2PHLrri,
          5008 => Opcode::TDCALL,
          5009 => Opcode::TDPBF16PS,
          5010 => Opcode::TDPBF8PS,
          5011 => Opcode::TDPBHF8PS,
          5012 => Opcode::TDPBSSD,
          5013 => Opcode::TDPBSUD,
          5014 => Opcode::TDPBUSD,
          5015 => Opcode::TDPBUUD,
          5016 => Opcode::TDPFP16PS,
          5017 => Opcode::TDPHBF8PS,
          5018 => Opcode::TDPHF8PS,
          5019 => Opcode::TEST16i16,
          5020 => Opcode::TEST16mi,
          5021 => Opcode::TEST16mr,
          5022 => Opcode::TEST16ri,
          5023 => Opcode::TEST16rr,
          5024 => Opcode::TEST32i32,
          5025 => Opcode::TEST32mi,
          5026 => Opcode::TEST32mr,
          5027 => Opcode::TEST32ri,
          5028 => Opcode::TEST32rr,
          5029 => Opcode::TEST64i32,
          5030 => Opcode::TEST64mi32,
          5031 => Opcode::TEST64mr,
          5032 => Opcode::TEST64ri32,
          5033 => Opcode::TEST64rr,
          5034 => Opcode::TEST8i8,
          5035 => Opcode::TEST8mi,
          5036 => Opcode::TEST8mr,
          5037 => Opcode::TEST8ri,
          5038 => Opcode::TEST8rr,
          5039 => Opcode::TESTUI,
          5040 => Opcode::TILELOADD,
          5041 => Opcode::TILELOADDRS,
          5042 => Opcode::TILELOADDRST1,
          5043 => Opcode::TILELOADDRST1_EVEX,
          5044 => Opcode::TILELOADDRS_EVEX,
          5045 => Opcode::TILELOADDT1,
          5046 => Opcode::TILELOADDT1_EVEX,
          5047 => Opcode::TILELOADD_EVEX,
          5048 => Opcode::TILEMOVROWrre,
          5049 => Opcode::TILEMOVROWrri,
          5050 => Opcode::TILERELEASE,
          5051 => Opcode::TILESTORED,
          5052 => Opcode::TILESTORED_EVEX,
          5053 => Opcode::TILEZERO,
          5054 => Opcode::TLBSYNC,
          5055 => Opcode::TLSCall_32,
          5056 => Opcode::TLSCall_64,
          5057 => Opcode::TLS_addr32,
          5058 => Opcode::TLS_addr64,
          5059 => Opcode::TLS_addrX32,
          5060 => Opcode::TLS_base_addr32,
          5061 => Opcode::TLS_base_addr64,
          5062 => Opcode::TLS_base_addrX32,
          5063 => Opcode::TLS_desc32,
          5064 => Opcode::TLS_desc64,
          5065 => Opcode::TMMULTF32PS,
          5066 => Opcode::TPAUSE,
          5067 => Opcode::TRAP,
          5068 => Opcode::TST_F,
          5069 => Opcode::TST_Fp32,
          5070 => Opcode::TST_Fp64,
          5071 => Opcode::TST_Fp80,
          5072 => Opcode::TTCMMIMFP16PS,
          5073 => Opcode::TTCMMRLFP16PS,
          5074 => Opcode::TTDPBF16PS,
          5075 => Opcode::TTDPFP16PS,
          5076 => Opcode::TTMMULTF32PS,
          5077 => Opcode::TTRANSPOSED,
          5078 => Opcode::TZCNT16rm,
          5079 => Opcode::TZCNT16rm_EVEX,
          5080 => Opcode::TZCNT16rm_NF,
          5081 => Opcode::TZCNT16rr,
          5082 => Opcode::TZCNT16rr_EVEX,
          5083 => Opcode::TZCNT16rr_NF,
          5084 => Opcode::TZCNT32rm,
          5085 => Opcode::TZCNT32rm_EVEX,
          5086 => Opcode::TZCNT32rm_NF,
          5087 => Opcode::TZCNT32rr,
          5088 => Opcode::TZCNT32rr_EVEX,
          5089 => Opcode::TZCNT32rr_NF,
          5090 => Opcode::TZCNT64rm,
          5091 => Opcode::TZCNT64rm_EVEX,
          5092 => Opcode::TZCNT64rm_NF,
          5093 => Opcode::TZCNT64rr,
          5094 => Opcode::TZCNT64rr_EVEX,
          5095 => Opcode::TZCNT64rr_NF,
          5096 => Opcode::TZMSK32rm,
          5097 => Opcode::TZMSK32rr,
          5098 => Opcode::TZMSK64rm,
          5099 => Opcode::TZMSK64rr,
          5100 => Opcode::UBSAN_UD1,
          5101 => Opcode::UCOMISDrm,
          5102 => Opcode::UCOMISDrm_Int,
          5103 => Opcode::UCOMISDrr,
          5104 => Opcode::UCOMISDrr_Int,
          5105 => Opcode::UCOMISSrm,
          5106 => Opcode::UCOMISSrm_Int,
          5107 => Opcode::UCOMISSrr,
          5108 => Opcode::UCOMISSrr_Int,
          5109 => Opcode::UCOM_FIPr,
          5110 => Opcode::UCOM_FIr,
          5111 => Opcode::UCOM_FPPr,
          5112 => Opcode::UCOM_FPr,
          5113 => Opcode::UCOM_FpIr32,
          5114 => Opcode::UCOM_FpIr64,
          5115 => Opcode::UCOM_FpIr80,
          5116 => Opcode::UCOM_Fpr32,
          5117 => Opcode::UCOM_Fpr64,
          5118 => Opcode::UCOM_Fpr80,
          5119 => Opcode::UCOM_Fr,
          5120 => Opcode::UD1Lm,
          5121 => Opcode::UD1Lr,
          5122 => Opcode::UD1Qm,
          5123 => Opcode::UD1Qr,
          5124 => Opcode::UD1Wm,
          5125 => Opcode::UD1Wr,
          5126 => Opcode::UIRET,
          5127 => Opcode::UMONITOR16,
          5128 => Opcode::UMONITOR32,
          5129 => Opcode::UMONITOR64,
          5130 => Opcode::UMWAIT,
          5131 => Opcode::UNPCKHPDrm,
          5132 => Opcode::UNPCKHPDrr,
          5133 => Opcode::UNPCKHPSrm,
          5134 => Opcode::UNPCKHPSrr,
          5135 => Opcode::UNPCKLPDrm,
          5136 => Opcode::UNPCKLPDrr,
          5137 => Opcode::UNPCKLPSrm,
          5138 => Opcode::UNPCKLPSrr,
          5139 => Opcode::URDMSRri,
          5140 => Opcode::URDMSRri_EVEX,
          5141 => Opcode::URDMSRrr,
          5142 => Opcode::URDMSRrr_EVEX,
          5143 => Opcode::UWRMSRir,
          5144 => Opcode::UWRMSRir_EVEX,
          5145 => Opcode::UWRMSRrr,
          5146 => Opcode::UWRMSRrr_EVEX,
          5147 => Opcode::V4FMADDPSrm,
          5148 => Opcode::V4FMADDPSrmk,
          5149 => Opcode::V4FMADDPSrmkz,
          5150 => Opcode::V4FMADDSSrm,
          5151 => Opcode::V4FMADDSSrmk,
          5152 => Opcode::V4FMADDSSrmkz,
          5153 => Opcode::V4FNMADDPSrm,
          5154 => Opcode::V4FNMADDPSrmk,
          5155 => Opcode::V4FNMADDPSrmkz,
          5156 => Opcode::V4FNMADDSSrm,
          5157 => Opcode::V4FNMADDSSrmk,
          5158 => Opcode::V4FNMADDSSrmkz,
          5159 => Opcode::VAARG_64,
          5160 => Opcode::VAARG_X32,
          5161 => Opcode::VADDBF16Z128rm,
          5162 => Opcode::VADDBF16Z128rmb,
          5163 => Opcode::VADDBF16Z128rmbk,
          5164 => Opcode::VADDBF16Z128rmbkz,
          5165 => Opcode::VADDBF16Z128rmk,
          5166 => Opcode::VADDBF16Z128rmkz,
          5167 => Opcode::VADDBF16Z128rr,
          5168 => Opcode::VADDBF16Z128rrk,
          5169 => Opcode::VADDBF16Z128rrkz,
          5170 => Opcode::VADDBF16Z256rm,
          5171 => Opcode::VADDBF16Z256rmb,
          5172 => Opcode::VADDBF16Z256rmbk,
          5173 => Opcode::VADDBF16Z256rmbkz,
          5174 => Opcode::VADDBF16Z256rmk,
          5175 => Opcode::VADDBF16Z256rmkz,
          5176 => Opcode::VADDBF16Z256rr,
          5177 => Opcode::VADDBF16Z256rrk,
          5178 => Opcode::VADDBF16Z256rrkz,
          5179 => Opcode::VADDBF16Zrm,
          5180 => Opcode::VADDBF16Zrmb,
          5181 => Opcode::VADDBF16Zrmbk,
          5182 => Opcode::VADDBF16Zrmbkz,
          5183 => Opcode::VADDBF16Zrmk,
          5184 => Opcode::VADDBF16Zrmkz,
          5185 => Opcode::VADDBF16Zrr,
          5186 => Opcode::VADDBF16Zrrk,
          5187 => Opcode::VADDBF16Zrrkz,
          5188 => Opcode::VADDPDYrm,
          5189 => Opcode::VADDPDYrr,
          5190 => Opcode::VADDPDZ128rm,
          5191 => Opcode::VADDPDZ128rmb,
          5192 => Opcode::VADDPDZ128rmbk,
          5193 => Opcode::VADDPDZ128rmbkz,
          5194 => Opcode::VADDPDZ128rmk,
          5195 => Opcode::VADDPDZ128rmkz,
          5196 => Opcode::VADDPDZ128rr,
          5197 => Opcode::VADDPDZ128rrk,
          5198 => Opcode::VADDPDZ128rrkz,
          5199 => Opcode::VADDPDZ256rm,
          5200 => Opcode::VADDPDZ256rmb,
          5201 => Opcode::VADDPDZ256rmbk,
          5202 => Opcode::VADDPDZ256rmbkz,
          5203 => Opcode::VADDPDZ256rmk,
          5204 => Opcode::VADDPDZ256rmkz,
          5205 => Opcode::VADDPDZ256rr,
          5206 => Opcode::VADDPDZ256rrk,
          5207 => Opcode::VADDPDZ256rrkz,
          5208 => Opcode::VADDPDZrm,
          5209 => Opcode::VADDPDZrmb,
          5210 => Opcode::VADDPDZrmbk,
          5211 => Opcode::VADDPDZrmbkz,
          5212 => Opcode::VADDPDZrmk,
          5213 => Opcode::VADDPDZrmkz,
          5214 => Opcode::VADDPDZrr,
          5215 => Opcode::VADDPDZrrb,
          5216 => Opcode::VADDPDZrrbk,
          5217 => Opcode::VADDPDZrrbkz,
          5218 => Opcode::VADDPDZrrk,
          5219 => Opcode::VADDPDZrrkz,
          5220 => Opcode::VADDPDrm,
          5221 => Opcode::VADDPDrr,
          5222 => Opcode::VADDPHZ128rm,
          5223 => Opcode::VADDPHZ128rmb,
          5224 => Opcode::VADDPHZ128rmbk,
          5225 => Opcode::VADDPHZ128rmbkz,
          5226 => Opcode::VADDPHZ128rmk,
          5227 => Opcode::VADDPHZ128rmkz,
          5228 => Opcode::VADDPHZ128rr,
          5229 => Opcode::VADDPHZ128rrk,
          5230 => Opcode::VADDPHZ128rrkz,
          5231 => Opcode::VADDPHZ256rm,
          5232 => Opcode::VADDPHZ256rmb,
          5233 => Opcode::VADDPHZ256rmbk,
          5234 => Opcode::VADDPHZ256rmbkz,
          5235 => Opcode::VADDPHZ256rmk,
          5236 => Opcode::VADDPHZ256rmkz,
          5237 => Opcode::VADDPHZ256rr,
          5238 => Opcode::VADDPHZ256rrk,
          5239 => Opcode::VADDPHZ256rrkz,
          5240 => Opcode::VADDPHZrm,
          5241 => Opcode::VADDPHZrmb,
          5242 => Opcode::VADDPHZrmbk,
          5243 => Opcode::VADDPHZrmbkz,
          5244 => Opcode::VADDPHZrmk,
          5245 => Opcode::VADDPHZrmkz,
          5246 => Opcode::VADDPHZrr,
          5247 => Opcode::VADDPHZrrb,
          5248 => Opcode::VADDPHZrrbk,
          5249 => Opcode::VADDPHZrrbkz,
          5250 => Opcode::VADDPHZrrk,
          5251 => Opcode::VADDPHZrrkz,
          5252 => Opcode::VADDPSYrm,
          5253 => Opcode::VADDPSYrr,
          5254 => Opcode::VADDPSZ128rm,
          5255 => Opcode::VADDPSZ128rmb,
          5256 => Opcode::VADDPSZ128rmbk,
          5257 => Opcode::VADDPSZ128rmbkz,
          5258 => Opcode::VADDPSZ128rmk,
          5259 => Opcode::VADDPSZ128rmkz,
          5260 => Opcode::VADDPSZ128rr,
          5261 => Opcode::VADDPSZ128rrk,
          5262 => Opcode::VADDPSZ128rrkz,
          5263 => Opcode::VADDPSZ256rm,
          5264 => Opcode::VADDPSZ256rmb,
          5265 => Opcode::VADDPSZ256rmbk,
          5266 => Opcode::VADDPSZ256rmbkz,
          5267 => Opcode::VADDPSZ256rmk,
          5268 => Opcode::VADDPSZ256rmkz,
          5269 => Opcode::VADDPSZ256rr,
          5270 => Opcode::VADDPSZ256rrk,
          5271 => Opcode::VADDPSZ256rrkz,
          5272 => Opcode::VADDPSZrm,
          5273 => Opcode::VADDPSZrmb,
          5274 => Opcode::VADDPSZrmbk,
          5275 => Opcode::VADDPSZrmbkz,
          5276 => Opcode::VADDPSZrmk,
          5277 => Opcode::VADDPSZrmkz,
          5278 => Opcode::VADDPSZrr,
          5279 => Opcode::VADDPSZrrb,
          5280 => Opcode::VADDPSZrrbk,
          5281 => Opcode::VADDPSZrrbkz,
          5282 => Opcode::VADDPSZrrk,
          5283 => Opcode::VADDPSZrrkz,
          5284 => Opcode::VADDPSrm,
          5285 => Opcode::VADDPSrr,
          5286 => Opcode::VADDSDZrm,
          5287 => Opcode::VADDSDZrm_Int,
          5288 => Opcode::VADDSDZrmk_Int,
          5289 => Opcode::VADDSDZrmkz_Int,
          5290 => Opcode::VADDSDZrr,
          5291 => Opcode::VADDSDZrr_Int,
          5292 => Opcode::VADDSDZrrb_Int,
          5293 => Opcode::VADDSDZrrbk_Int,
          5294 => Opcode::VADDSDZrrbkz_Int,
          5295 => Opcode::VADDSDZrrk_Int,
          5296 => Opcode::VADDSDZrrkz_Int,
          5297 => Opcode::VADDSDrm,
          5298 => Opcode::VADDSDrm_Int,
          5299 => Opcode::VADDSDrr,
          5300 => Opcode::VADDSDrr_Int,
          5301 => Opcode::VADDSHZrm,
          5302 => Opcode::VADDSHZrm_Int,
          5303 => Opcode::VADDSHZrmk_Int,
          5304 => Opcode::VADDSHZrmkz_Int,
          5305 => Opcode::VADDSHZrr,
          5306 => Opcode::VADDSHZrr_Int,
          5307 => Opcode::VADDSHZrrb_Int,
          5308 => Opcode::VADDSHZrrbk_Int,
          5309 => Opcode::VADDSHZrrbkz_Int,
          5310 => Opcode::VADDSHZrrk_Int,
          5311 => Opcode::VADDSHZrrkz_Int,
          5312 => Opcode::VADDSSZrm,
          5313 => Opcode::VADDSSZrm_Int,
          5314 => Opcode::VADDSSZrmk_Int,
          5315 => Opcode::VADDSSZrmkz_Int,
          5316 => Opcode::VADDSSZrr,
          5317 => Opcode::VADDSSZrr_Int,
          5318 => Opcode::VADDSSZrrb_Int,
          5319 => Opcode::VADDSSZrrbk_Int,
          5320 => Opcode::VADDSSZrrbkz_Int,
          5321 => Opcode::VADDSSZrrk_Int,
          5322 => Opcode::VADDSSZrrkz_Int,
          5323 => Opcode::VADDSSrm,
          5324 => Opcode::VADDSSrm_Int,
          5325 => Opcode::VADDSSrr,
          5326 => Opcode::VADDSSrr_Int,
          5327 => Opcode::VADDSUBPDYrm,
          5328 => Opcode::VADDSUBPDYrr,
          5329 => Opcode::VADDSUBPDrm,
          5330 => Opcode::VADDSUBPDrr,
          5331 => Opcode::VADDSUBPSYrm,
          5332 => Opcode::VADDSUBPSYrr,
          5333 => Opcode::VADDSUBPSrm,
          5334 => Opcode::VADDSUBPSrr,
          5335 => Opcode::VAESDECLASTYrm,
          5336 => Opcode::VAESDECLASTYrr,
          5337 => Opcode::VAESDECLASTZ128rm,
          5338 => Opcode::VAESDECLASTZ128rr,
          5339 => Opcode::VAESDECLASTZ256rm,
          5340 => Opcode::VAESDECLASTZ256rr,
          5341 => Opcode::VAESDECLASTZrm,
          5342 => Opcode::VAESDECLASTZrr,
          5343 => Opcode::VAESDECLASTrm,
          5344 => Opcode::VAESDECLASTrr,
          5345 => Opcode::VAESDECYrm,
          5346 => Opcode::VAESDECYrr,
          5347 => Opcode::VAESDECZ128rm,
          5348 => Opcode::VAESDECZ128rr,
          5349 => Opcode::VAESDECZ256rm,
          5350 => Opcode::VAESDECZ256rr,
          5351 => Opcode::VAESDECZrm,
          5352 => Opcode::VAESDECZrr,
          5353 => Opcode::VAESDECrm,
          5354 => Opcode::VAESDECrr,
          5355 => Opcode::VAESENCLASTYrm,
          5356 => Opcode::VAESENCLASTYrr,
          5357 => Opcode::VAESENCLASTZ128rm,
          5358 => Opcode::VAESENCLASTZ128rr,
          5359 => Opcode::VAESENCLASTZ256rm,
          5360 => Opcode::VAESENCLASTZ256rr,
          5361 => Opcode::VAESENCLASTZrm,
          5362 => Opcode::VAESENCLASTZrr,
          5363 => Opcode::VAESENCLASTrm,
          5364 => Opcode::VAESENCLASTrr,
          5365 => Opcode::VAESENCYrm,
          5366 => Opcode::VAESENCYrr,
          5367 => Opcode::VAESENCZ128rm,
          5368 => Opcode::VAESENCZ128rr,
          5369 => Opcode::VAESENCZ256rm,
          5370 => Opcode::VAESENCZ256rr,
          5371 => Opcode::VAESENCZrm,
          5372 => Opcode::VAESENCZrr,
          5373 => Opcode::VAESENCrm,
          5374 => Opcode::VAESENCrr,
          5375 => Opcode::VAESIMCrm,
          5376 => Opcode::VAESIMCrr,
          5377 => Opcode::VAESKEYGENASSIST128rm,
          5378 => Opcode::VAESKEYGENASSIST128rr,
          5379 => Opcode::VALIGNDZ128rmbi,
          5380 => Opcode::VALIGNDZ128rmbik,
          5381 => Opcode::VALIGNDZ128rmbikz,
          5382 => Opcode::VALIGNDZ128rmi,
          5383 => Opcode::VALIGNDZ128rmik,
          5384 => Opcode::VALIGNDZ128rmikz,
          5385 => Opcode::VALIGNDZ128rri,
          5386 => Opcode::VALIGNDZ128rrik,
          5387 => Opcode::VALIGNDZ128rrikz,
          5388 => Opcode::VALIGNDZ256rmbi,
          5389 => Opcode::VALIGNDZ256rmbik,
          5390 => Opcode::VALIGNDZ256rmbikz,
          5391 => Opcode::VALIGNDZ256rmi,
          5392 => Opcode::VALIGNDZ256rmik,
          5393 => Opcode::VALIGNDZ256rmikz,
          5394 => Opcode::VALIGNDZ256rri,
          5395 => Opcode::VALIGNDZ256rrik,
          5396 => Opcode::VALIGNDZ256rrikz,
          5397 => Opcode::VALIGNDZrmbi,
          5398 => Opcode::VALIGNDZrmbik,
          5399 => Opcode::VALIGNDZrmbikz,
          5400 => Opcode::VALIGNDZrmi,
          5401 => Opcode::VALIGNDZrmik,
          5402 => Opcode::VALIGNDZrmikz,
          5403 => Opcode::VALIGNDZrri,
          5404 => Opcode::VALIGNDZrrik,
          5405 => Opcode::VALIGNDZrrikz,
          5406 => Opcode::VALIGNQZ128rmbi,
          5407 => Opcode::VALIGNQZ128rmbik,
          5408 => Opcode::VALIGNQZ128rmbikz,
          5409 => Opcode::VALIGNQZ128rmi,
          5410 => Opcode::VALIGNQZ128rmik,
          5411 => Opcode::VALIGNQZ128rmikz,
          5412 => Opcode::VALIGNQZ128rri,
          5413 => Opcode::VALIGNQZ128rrik,
          5414 => Opcode::VALIGNQZ128rrikz,
          5415 => Opcode::VALIGNQZ256rmbi,
          5416 => Opcode::VALIGNQZ256rmbik,
          5417 => Opcode::VALIGNQZ256rmbikz,
          5418 => Opcode::VALIGNQZ256rmi,
          5419 => Opcode::VALIGNQZ256rmik,
          5420 => Opcode::VALIGNQZ256rmikz,
          5421 => Opcode::VALIGNQZ256rri,
          5422 => Opcode::VALIGNQZ256rrik,
          5423 => Opcode::VALIGNQZ256rrikz,
          5424 => Opcode::VALIGNQZrmbi,
          5425 => Opcode::VALIGNQZrmbik,
          5426 => Opcode::VALIGNQZrmbikz,
          5427 => Opcode::VALIGNQZrmi,
          5428 => Opcode::VALIGNQZrmik,
          5429 => Opcode::VALIGNQZrmikz,
          5430 => Opcode::VALIGNQZrri,
          5431 => Opcode::VALIGNQZrrik,
          5432 => Opcode::VALIGNQZrrikz,
          5433 => Opcode::VANDNPDYrm,
          5434 => Opcode::VANDNPDYrr,
          5435 => Opcode::VANDNPDZ128rm,
          5436 => Opcode::VANDNPDZ128rmb,
          5437 => Opcode::VANDNPDZ128rmbk,
          5438 => Opcode::VANDNPDZ128rmbkz,
          5439 => Opcode::VANDNPDZ128rmk,
          5440 => Opcode::VANDNPDZ128rmkz,
          5441 => Opcode::VANDNPDZ128rr,
          5442 => Opcode::VANDNPDZ128rrk,
          5443 => Opcode::VANDNPDZ128rrkz,
          5444 => Opcode::VANDNPDZ256rm,
          5445 => Opcode::VANDNPDZ256rmb,
          5446 => Opcode::VANDNPDZ256rmbk,
          5447 => Opcode::VANDNPDZ256rmbkz,
          5448 => Opcode::VANDNPDZ256rmk,
          5449 => Opcode::VANDNPDZ256rmkz,
          5450 => Opcode::VANDNPDZ256rr,
          5451 => Opcode::VANDNPDZ256rrk,
          5452 => Opcode::VANDNPDZ256rrkz,
          5453 => Opcode::VANDNPDZrm,
          5454 => Opcode::VANDNPDZrmb,
          5455 => Opcode::VANDNPDZrmbk,
          5456 => Opcode::VANDNPDZrmbkz,
          5457 => Opcode::VANDNPDZrmk,
          5458 => Opcode::VANDNPDZrmkz,
          5459 => Opcode::VANDNPDZrr,
          5460 => Opcode::VANDNPDZrrk,
          5461 => Opcode::VANDNPDZrrkz,
          5462 => Opcode::VANDNPDrm,
          5463 => Opcode::VANDNPDrr,
          5464 => Opcode::VANDNPSYrm,
          5465 => Opcode::VANDNPSYrr,
          5466 => Opcode::VANDNPSZ128rm,
          5467 => Opcode::VANDNPSZ128rmb,
          5468 => Opcode::VANDNPSZ128rmbk,
          5469 => Opcode::VANDNPSZ128rmbkz,
          5470 => Opcode::VANDNPSZ128rmk,
          5471 => Opcode::VANDNPSZ128rmkz,
          5472 => Opcode::VANDNPSZ128rr,
          5473 => Opcode::VANDNPSZ128rrk,
          5474 => Opcode::VANDNPSZ128rrkz,
          5475 => Opcode::VANDNPSZ256rm,
          5476 => Opcode::VANDNPSZ256rmb,
          5477 => Opcode::VANDNPSZ256rmbk,
          5478 => Opcode::VANDNPSZ256rmbkz,
          5479 => Opcode::VANDNPSZ256rmk,
          5480 => Opcode::VANDNPSZ256rmkz,
          5481 => Opcode::VANDNPSZ256rr,
          5482 => Opcode::VANDNPSZ256rrk,
          5483 => Opcode::VANDNPSZ256rrkz,
          5484 => Opcode::VANDNPSZrm,
          5485 => Opcode::VANDNPSZrmb,
          5486 => Opcode::VANDNPSZrmbk,
          5487 => Opcode::VANDNPSZrmbkz,
          5488 => Opcode::VANDNPSZrmk,
          5489 => Opcode::VANDNPSZrmkz,
          5490 => Opcode::VANDNPSZrr,
          5491 => Opcode::VANDNPSZrrk,
          5492 => Opcode::VANDNPSZrrkz,
          5493 => Opcode::VANDNPSrm,
          5494 => Opcode::VANDNPSrr,
          5495 => Opcode::VANDPDYrm,
          5496 => Opcode::VANDPDYrr,
          5497 => Opcode::VANDPDZ128rm,
          5498 => Opcode::VANDPDZ128rmb,
          5499 => Opcode::VANDPDZ128rmbk,
          5500 => Opcode::VANDPDZ128rmbkz,
          5501 => Opcode::VANDPDZ128rmk,
          5502 => Opcode::VANDPDZ128rmkz,
          5503 => Opcode::VANDPDZ128rr,
          5504 => Opcode::VANDPDZ128rrk,
          5505 => Opcode::VANDPDZ128rrkz,
          5506 => Opcode::VANDPDZ256rm,
          5507 => Opcode::VANDPDZ256rmb,
          5508 => Opcode::VANDPDZ256rmbk,
          5509 => Opcode::VANDPDZ256rmbkz,
          5510 => Opcode::VANDPDZ256rmk,
          5511 => Opcode::VANDPDZ256rmkz,
          5512 => Opcode::VANDPDZ256rr,
          5513 => Opcode::VANDPDZ256rrk,
          5514 => Opcode::VANDPDZ256rrkz,
          5515 => Opcode::VANDPDZrm,
          5516 => Opcode::VANDPDZrmb,
          5517 => Opcode::VANDPDZrmbk,
          5518 => Opcode::VANDPDZrmbkz,
          5519 => Opcode::VANDPDZrmk,
          5520 => Opcode::VANDPDZrmkz,
          5521 => Opcode::VANDPDZrr,
          5522 => Opcode::VANDPDZrrk,
          5523 => Opcode::VANDPDZrrkz,
          5524 => Opcode::VANDPDrm,
          5525 => Opcode::VANDPDrr,
          5526 => Opcode::VANDPSYrm,
          5527 => Opcode::VANDPSYrr,
          5528 => Opcode::VANDPSZ128rm,
          5529 => Opcode::VANDPSZ128rmb,
          5530 => Opcode::VANDPSZ128rmbk,
          5531 => Opcode::VANDPSZ128rmbkz,
          5532 => Opcode::VANDPSZ128rmk,
          5533 => Opcode::VANDPSZ128rmkz,
          5534 => Opcode::VANDPSZ128rr,
          5535 => Opcode::VANDPSZ128rrk,
          5536 => Opcode::VANDPSZ128rrkz,
          5537 => Opcode::VANDPSZ256rm,
          5538 => Opcode::VANDPSZ256rmb,
          5539 => Opcode::VANDPSZ256rmbk,
          5540 => Opcode::VANDPSZ256rmbkz,
          5541 => Opcode::VANDPSZ256rmk,
          5542 => Opcode::VANDPSZ256rmkz,
          5543 => Opcode::VANDPSZ256rr,
          5544 => Opcode::VANDPSZ256rrk,
          5545 => Opcode::VANDPSZ256rrkz,
          5546 => Opcode::VANDPSZrm,
          5547 => Opcode::VANDPSZrmb,
          5548 => Opcode::VANDPSZrmbk,
          5549 => Opcode::VANDPSZrmbkz,
          5550 => Opcode::VANDPSZrmk,
          5551 => Opcode::VANDPSZrmkz,
          5552 => Opcode::VANDPSZrr,
          5553 => Opcode::VANDPSZrrk,
          5554 => Opcode::VANDPSZrrkz,
          5555 => Opcode::VANDPSrm,
          5556 => Opcode::VANDPSrr,
          5557 => Opcode::VASTART_SAVE_XMM_REGS,
          5558 => Opcode::VBCSTNEBF162PSYrm,
          5559 => Opcode::VBCSTNEBF162PSrm,
          5560 => Opcode::VBCSTNESH2PSYrm,
          5561 => Opcode::VBCSTNESH2PSrm,
          5562 => Opcode::VBLENDMPDZ128rm,
          5563 => Opcode::VBLENDMPDZ128rmb,
          5564 => Opcode::VBLENDMPDZ128rmbk,
          5565 => Opcode::VBLENDMPDZ128rmbkz,
          5566 => Opcode::VBLENDMPDZ128rmk,
          5567 => Opcode::VBLENDMPDZ128rmkz,
          5568 => Opcode::VBLENDMPDZ128rr,
          5569 => Opcode::VBLENDMPDZ128rrk,
          5570 => Opcode::VBLENDMPDZ128rrkz,
          5571 => Opcode::VBLENDMPDZ256rm,
          5572 => Opcode::VBLENDMPDZ256rmb,
          5573 => Opcode::VBLENDMPDZ256rmbk,
          5574 => Opcode::VBLENDMPDZ256rmbkz,
          5575 => Opcode::VBLENDMPDZ256rmk,
          5576 => Opcode::VBLENDMPDZ256rmkz,
          5577 => Opcode::VBLENDMPDZ256rr,
          5578 => Opcode::VBLENDMPDZ256rrk,
          5579 => Opcode::VBLENDMPDZ256rrkz,
          5580 => Opcode::VBLENDMPDZrm,
          5581 => Opcode::VBLENDMPDZrmb,
          5582 => Opcode::VBLENDMPDZrmbk,
          5583 => Opcode::VBLENDMPDZrmbkz,
          5584 => Opcode::VBLENDMPDZrmk,
          5585 => Opcode::VBLENDMPDZrmkz,
          5586 => Opcode::VBLENDMPDZrr,
          5587 => Opcode::VBLENDMPDZrrk,
          5588 => Opcode::VBLENDMPDZrrkz,
          5589 => Opcode::VBLENDMPSZ128rm,
          5590 => Opcode::VBLENDMPSZ128rmb,
          5591 => Opcode::VBLENDMPSZ128rmbk,
          5592 => Opcode::VBLENDMPSZ128rmbkz,
          5593 => Opcode::VBLENDMPSZ128rmk,
          5594 => Opcode::VBLENDMPSZ128rmkz,
          5595 => Opcode::VBLENDMPSZ128rr,
          5596 => Opcode::VBLENDMPSZ128rrk,
          5597 => Opcode::VBLENDMPSZ128rrkz,
          5598 => Opcode::VBLENDMPSZ256rm,
          5599 => Opcode::VBLENDMPSZ256rmb,
          5600 => Opcode::VBLENDMPSZ256rmbk,
          5601 => Opcode::VBLENDMPSZ256rmbkz,
          5602 => Opcode::VBLENDMPSZ256rmk,
          5603 => Opcode::VBLENDMPSZ256rmkz,
          5604 => Opcode::VBLENDMPSZ256rr,
          5605 => Opcode::VBLENDMPSZ256rrk,
          5606 => Opcode::VBLENDMPSZ256rrkz,
          5607 => Opcode::VBLENDMPSZrm,
          5608 => Opcode::VBLENDMPSZrmb,
          5609 => Opcode::VBLENDMPSZrmbk,
          5610 => Opcode::VBLENDMPSZrmbkz,
          5611 => Opcode::VBLENDMPSZrmk,
          5612 => Opcode::VBLENDMPSZrmkz,
          5613 => Opcode::VBLENDMPSZrr,
          5614 => Opcode::VBLENDMPSZrrk,
          5615 => Opcode::VBLENDMPSZrrkz,
          5616 => Opcode::VBLENDPDYrmi,
          5617 => Opcode::VBLENDPDYrri,
          5618 => Opcode::VBLENDPDrmi,
          5619 => Opcode::VBLENDPDrri,
          5620 => Opcode::VBLENDPSYrmi,
          5621 => Opcode::VBLENDPSYrri,
          5622 => Opcode::VBLENDPSrmi,
          5623 => Opcode::VBLENDPSrri,
          5624 => Opcode::VBLENDVPDYrmr,
          5625 => Opcode::VBLENDVPDYrrr,
          5626 => Opcode::VBLENDVPDrmr,
          5627 => Opcode::VBLENDVPDrrr,
          5628 => Opcode::VBLENDVPSYrmr,
          5629 => Opcode::VBLENDVPSYrrr,
          5630 => Opcode::VBLENDVPSrmr,
          5631 => Opcode::VBLENDVPSrrr,
          5632 => Opcode::VBROADCASTF128rm,
          5633 => Opcode::VBROADCASTF32X2Z256rm,
          5634 => Opcode::VBROADCASTF32X2Z256rmk,
          5635 => Opcode::VBROADCASTF32X2Z256rmkz,
          5636 => Opcode::VBROADCASTF32X2Z256rr,
          5637 => Opcode::VBROADCASTF32X2Z256rrk,
          5638 => Opcode::VBROADCASTF32X2Z256rrkz,
          5639 => Opcode::VBROADCASTF32X2Zrm,
          5640 => Opcode::VBROADCASTF32X2Zrmk,
          5641 => Opcode::VBROADCASTF32X2Zrmkz,
          5642 => Opcode::VBROADCASTF32X2Zrr,
          5643 => Opcode::VBROADCASTF32X2Zrrk,
          5644 => Opcode::VBROADCASTF32X2Zrrkz,
          5645 => Opcode::VBROADCASTF32X4Z256rm,
          5646 => Opcode::VBROADCASTF32X4Z256rmk,
          5647 => Opcode::VBROADCASTF32X4Z256rmkz,
          5648 => Opcode::VBROADCASTF32X4Zrm,
          5649 => Opcode::VBROADCASTF32X4Zrmk,
          5650 => Opcode::VBROADCASTF32X4Zrmkz,
          5651 => Opcode::VBROADCASTF32X8Zrm,
          5652 => Opcode::VBROADCASTF32X8Zrmk,
          5653 => Opcode::VBROADCASTF32X8Zrmkz,
          5654 => Opcode::VBROADCASTF64X2Z256rm,
          5655 => Opcode::VBROADCASTF64X2Z256rmk,
          5656 => Opcode::VBROADCASTF64X2Z256rmkz,
          5657 => Opcode::VBROADCASTF64X2Zrm,
          5658 => Opcode::VBROADCASTF64X2Zrmk,
          5659 => Opcode::VBROADCASTF64X2Zrmkz,
          5660 => Opcode::VBROADCASTF64X4Zrm,
          5661 => Opcode::VBROADCASTF64X4Zrmk,
          5662 => Opcode::VBROADCASTF64X4Zrmkz,
          5663 => Opcode::VBROADCASTI128rm,
          5664 => Opcode::VBROADCASTI32X2Z128rm,
          5665 => Opcode::VBROADCASTI32X2Z128rmk,
          5666 => Opcode::VBROADCASTI32X2Z128rmkz,
          5667 => Opcode::VBROADCASTI32X2Z128rr,
          5668 => Opcode::VBROADCASTI32X2Z128rrk,
          5669 => Opcode::VBROADCASTI32X2Z128rrkz,
          5670 => Opcode::VBROADCASTI32X2Z256rm,
          5671 => Opcode::VBROADCASTI32X2Z256rmk,
          5672 => Opcode::VBROADCASTI32X2Z256rmkz,
          5673 => Opcode::VBROADCASTI32X2Z256rr,
          5674 => Opcode::VBROADCASTI32X2Z256rrk,
          5675 => Opcode::VBROADCASTI32X2Z256rrkz,
          5676 => Opcode::VBROADCASTI32X2Zrm,
          5677 => Opcode::VBROADCASTI32X2Zrmk,
          5678 => Opcode::VBROADCASTI32X2Zrmkz,
          5679 => Opcode::VBROADCASTI32X2Zrr,
          5680 => Opcode::VBROADCASTI32X2Zrrk,
          5681 => Opcode::VBROADCASTI32X2Zrrkz,
          5682 => Opcode::VBROADCASTI32X4Z256rm,
          5683 => Opcode::VBROADCASTI32X4Z256rmk,
          5684 => Opcode::VBROADCASTI32X4Z256rmkz,
          5685 => Opcode::VBROADCASTI32X4Zrm,
          5686 => Opcode::VBROADCASTI32X4Zrmk,
          5687 => Opcode::VBROADCASTI32X4Zrmkz,
          5688 => Opcode::VBROADCASTI32X8Zrm,
          5689 => Opcode::VBROADCASTI32X8Zrmk,
          5690 => Opcode::VBROADCASTI32X8Zrmkz,
          5691 => Opcode::VBROADCASTI64X2Z256rm,
          5692 => Opcode::VBROADCASTI64X2Z256rmk,
          5693 => Opcode::VBROADCASTI64X2Z256rmkz,
          5694 => Opcode::VBROADCASTI64X2Zrm,
          5695 => Opcode::VBROADCASTI64X2Zrmk,
          5696 => Opcode::VBROADCASTI64X2Zrmkz,
          5697 => Opcode::VBROADCASTI64X4Zrm,
          5698 => Opcode::VBROADCASTI64X4Zrmk,
          5699 => Opcode::VBROADCASTI64X4Zrmkz,
          5700 => Opcode::VBROADCASTSDYrm,
          5701 => Opcode::VBROADCASTSDYrr,
          5702 => Opcode::VBROADCASTSDZ256rm,
          5703 => Opcode::VBROADCASTSDZ256rmk,
          5704 => Opcode::VBROADCASTSDZ256rmkz,
          5705 => Opcode::VBROADCASTSDZ256rr,
          5706 => Opcode::VBROADCASTSDZ256rrk,
          5707 => Opcode::VBROADCASTSDZ256rrkz,
          5708 => Opcode::VBROADCASTSDZrm,
          5709 => Opcode::VBROADCASTSDZrmk,
          5710 => Opcode::VBROADCASTSDZrmkz,
          5711 => Opcode::VBROADCASTSDZrr,
          5712 => Opcode::VBROADCASTSDZrrk,
          5713 => Opcode::VBROADCASTSDZrrkz,
          5714 => Opcode::VBROADCASTSSYrm,
          5715 => Opcode::VBROADCASTSSYrr,
          5716 => Opcode::VBROADCASTSSZ128rm,
          5717 => Opcode::VBROADCASTSSZ128rmk,
          5718 => Opcode::VBROADCASTSSZ128rmkz,
          5719 => Opcode::VBROADCASTSSZ128rr,
          5720 => Opcode::VBROADCASTSSZ128rrk,
          5721 => Opcode::VBROADCASTSSZ128rrkz,
          5722 => Opcode::VBROADCASTSSZ256rm,
          5723 => Opcode::VBROADCASTSSZ256rmk,
          5724 => Opcode::VBROADCASTSSZ256rmkz,
          5725 => Opcode::VBROADCASTSSZ256rr,
          5726 => Opcode::VBROADCASTSSZ256rrk,
          5727 => Opcode::VBROADCASTSSZ256rrkz,
          5728 => Opcode::VBROADCASTSSZrm,
          5729 => Opcode::VBROADCASTSSZrmk,
          5730 => Opcode::VBROADCASTSSZrmkz,
          5731 => Opcode::VBROADCASTSSZrr,
          5732 => Opcode::VBROADCASTSSZrrk,
          5733 => Opcode::VBROADCASTSSZrrkz,
          5734 => Opcode::VBROADCASTSSrm,
          5735 => Opcode::VBROADCASTSSrr,
          5736 => Opcode::VCMPBF16Z128rmbi,
          5737 => Opcode::VCMPBF16Z128rmbik,
          5738 => Opcode::VCMPBF16Z128rmi,
          5739 => Opcode::VCMPBF16Z128rmik,
          5740 => Opcode::VCMPBF16Z128rri,
          5741 => Opcode::VCMPBF16Z128rrik,
          5742 => Opcode::VCMPBF16Z256rmbi,
          5743 => Opcode::VCMPBF16Z256rmbik,
          5744 => Opcode::VCMPBF16Z256rmi,
          5745 => Opcode::VCMPBF16Z256rmik,
          5746 => Opcode::VCMPBF16Z256rri,
          5747 => Opcode::VCMPBF16Z256rrik,
          5748 => Opcode::VCMPBF16Zrmbi,
          5749 => Opcode::VCMPBF16Zrmbik,
          5750 => Opcode::VCMPBF16Zrmi,
          5751 => Opcode::VCMPBF16Zrmik,
          5752 => Opcode::VCMPBF16Zrri,
          5753 => Opcode::VCMPBF16Zrrik,
          5754 => Opcode::VCMPPDYrmi,
          5755 => Opcode::VCMPPDYrri,
          5756 => Opcode::VCMPPDZ128rmbi,
          5757 => Opcode::VCMPPDZ128rmbik,
          5758 => Opcode::VCMPPDZ128rmi,
          5759 => Opcode::VCMPPDZ128rmik,
          5760 => Opcode::VCMPPDZ128rri,
          5761 => Opcode::VCMPPDZ128rrik,
          5762 => Opcode::VCMPPDZ256rmbi,
          5763 => Opcode::VCMPPDZ256rmbik,
          5764 => Opcode::VCMPPDZ256rmi,
          5765 => Opcode::VCMPPDZ256rmik,
          5766 => Opcode::VCMPPDZ256rri,
          5767 => Opcode::VCMPPDZ256rrik,
          5768 => Opcode::VCMPPDZrmbi,
          5769 => Opcode::VCMPPDZrmbik,
          5770 => Opcode::VCMPPDZrmi,
          5771 => Opcode::VCMPPDZrmik,
          5772 => Opcode::VCMPPDZrri,
          5773 => Opcode::VCMPPDZrrib,
          5774 => Opcode::VCMPPDZrribk,
          5775 => Opcode::VCMPPDZrrik,
          5776 => Opcode::VCMPPDrmi,
          5777 => Opcode::VCMPPDrri,
          5778 => Opcode::VCMPPHZ128rmbi,
          5779 => Opcode::VCMPPHZ128rmbik,
          5780 => Opcode::VCMPPHZ128rmi,
          5781 => Opcode::VCMPPHZ128rmik,
          5782 => Opcode::VCMPPHZ128rri,
          5783 => Opcode::VCMPPHZ128rrik,
          5784 => Opcode::VCMPPHZ256rmbi,
          5785 => Opcode::VCMPPHZ256rmbik,
          5786 => Opcode::VCMPPHZ256rmi,
          5787 => Opcode::VCMPPHZ256rmik,
          5788 => Opcode::VCMPPHZ256rri,
          5789 => Opcode::VCMPPHZ256rrik,
          5790 => Opcode::VCMPPHZrmbi,
          5791 => Opcode::VCMPPHZrmbik,
          5792 => Opcode::VCMPPHZrmi,
          5793 => Opcode::VCMPPHZrmik,
          5794 => Opcode::VCMPPHZrri,
          5795 => Opcode::VCMPPHZrrib,
          5796 => Opcode::VCMPPHZrribk,
          5797 => Opcode::VCMPPHZrrik,
          5798 => Opcode::VCMPPSYrmi,
          5799 => Opcode::VCMPPSYrri,
          5800 => Opcode::VCMPPSZ128rmbi,
          5801 => Opcode::VCMPPSZ128rmbik,
          5802 => Opcode::VCMPPSZ128rmi,
          5803 => Opcode::VCMPPSZ128rmik,
          5804 => Opcode::VCMPPSZ128rri,
          5805 => Opcode::VCMPPSZ128rrik,
          5806 => Opcode::VCMPPSZ256rmbi,
          5807 => Opcode::VCMPPSZ256rmbik,
          5808 => Opcode::VCMPPSZ256rmi,
          5809 => Opcode::VCMPPSZ256rmik,
          5810 => Opcode::VCMPPSZ256rri,
          5811 => Opcode::VCMPPSZ256rrik,
          5812 => Opcode::VCMPPSZrmbi,
          5813 => Opcode::VCMPPSZrmbik,
          5814 => Opcode::VCMPPSZrmi,
          5815 => Opcode::VCMPPSZrmik,
          5816 => Opcode::VCMPPSZrri,
          5817 => Opcode::VCMPPSZrrib,
          5818 => Opcode::VCMPPSZrribk,
          5819 => Opcode::VCMPPSZrrik,
          5820 => Opcode::VCMPPSrmi,
          5821 => Opcode::VCMPPSrri,
          5822 => Opcode::VCMPSDZrmi,
          5823 => Opcode::VCMPSDZrmi_Int,
          5824 => Opcode::VCMPSDZrmik_Int,
          5825 => Opcode::VCMPSDZrri,
          5826 => Opcode::VCMPSDZrri_Int,
          5827 => Opcode::VCMPSDZrrib_Int,
          5828 => Opcode::VCMPSDZrribk_Int,
          5829 => Opcode::VCMPSDZrrik_Int,
          5830 => Opcode::VCMPSDrmi,
          5831 => Opcode::VCMPSDrmi_Int,
          5832 => Opcode::VCMPSDrri,
          5833 => Opcode::VCMPSDrri_Int,
          5834 => Opcode::VCMPSHZrmi,
          5835 => Opcode::VCMPSHZrmi_Int,
          5836 => Opcode::VCMPSHZrmik_Int,
          5837 => Opcode::VCMPSHZrri,
          5838 => Opcode::VCMPSHZrri_Int,
          5839 => Opcode::VCMPSHZrrib_Int,
          5840 => Opcode::VCMPSHZrribk_Int,
          5841 => Opcode::VCMPSHZrrik_Int,
          5842 => Opcode::VCMPSSZrmi,
          5843 => Opcode::VCMPSSZrmi_Int,
          5844 => Opcode::VCMPSSZrmik_Int,
          5845 => Opcode::VCMPSSZrri,
          5846 => Opcode::VCMPSSZrri_Int,
          5847 => Opcode::VCMPSSZrrib_Int,
          5848 => Opcode::VCMPSSZrribk_Int,
          5849 => Opcode::VCMPSSZrrik_Int,
          5850 => Opcode::VCMPSSrmi,
          5851 => Opcode::VCMPSSrmi_Int,
          5852 => Opcode::VCMPSSrri,
          5853 => Opcode::VCMPSSrri_Int,
          5854 => Opcode::VCOMISBF16Zrm,
          5855 => Opcode::VCOMISBF16Zrm_Int,
          5856 => Opcode::VCOMISBF16Zrr,
          5857 => Opcode::VCOMISBF16Zrr_Int,
          5858 => Opcode::VCOMISDZrm,
          5859 => Opcode::VCOMISDZrm_Int,
          5860 => Opcode::VCOMISDZrr,
          5861 => Opcode::VCOMISDZrr_Int,
          5862 => Opcode::VCOMISDZrrb,
          5863 => Opcode::VCOMISDrm,
          5864 => Opcode::VCOMISDrm_Int,
          5865 => Opcode::VCOMISDrr,
          5866 => Opcode::VCOMISDrr_Int,
          5867 => Opcode::VCOMISHZrm,
          5868 => Opcode::VCOMISHZrm_Int,
          5869 => Opcode::VCOMISHZrr,
          5870 => Opcode::VCOMISHZrr_Int,
          5871 => Opcode::VCOMISHZrrb,
          5872 => Opcode::VCOMISSZrm,
          5873 => Opcode::VCOMISSZrm_Int,
          5874 => Opcode::VCOMISSZrr,
          5875 => Opcode::VCOMISSZrr_Int,
          5876 => Opcode::VCOMISSZrrb,
          5877 => Opcode::VCOMISSrm,
          5878 => Opcode::VCOMISSrm_Int,
          5879 => Opcode::VCOMISSrr,
          5880 => Opcode::VCOMISSrr_Int,
          5881 => Opcode::VCOMPRESSPDZ128mr,
          5882 => Opcode::VCOMPRESSPDZ128mrk,
          5883 => Opcode::VCOMPRESSPDZ128rr,
          5884 => Opcode::VCOMPRESSPDZ128rrk,
          5885 => Opcode::VCOMPRESSPDZ128rrkz,
          5886 => Opcode::VCOMPRESSPDZ256mr,
          5887 => Opcode::VCOMPRESSPDZ256mrk,
          5888 => Opcode::VCOMPRESSPDZ256rr,
          5889 => Opcode::VCOMPRESSPDZ256rrk,
          5890 => Opcode::VCOMPRESSPDZ256rrkz,
          5891 => Opcode::VCOMPRESSPDZmr,
          5892 => Opcode::VCOMPRESSPDZmrk,
          5893 => Opcode::VCOMPRESSPDZrr,
          5894 => Opcode::VCOMPRESSPDZrrk,
          5895 => Opcode::VCOMPRESSPDZrrkz,
          5896 => Opcode::VCOMPRESSPSZ128mr,
          5897 => Opcode::VCOMPRESSPSZ128mrk,
          5898 => Opcode::VCOMPRESSPSZ128rr,
          5899 => Opcode::VCOMPRESSPSZ128rrk,
          5900 => Opcode::VCOMPRESSPSZ128rrkz,
          5901 => Opcode::VCOMPRESSPSZ256mr,
          5902 => Opcode::VCOMPRESSPSZ256mrk,
          5903 => Opcode::VCOMPRESSPSZ256rr,
          5904 => Opcode::VCOMPRESSPSZ256rrk,
          5905 => Opcode::VCOMPRESSPSZ256rrkz,
          5906 => Opcode::VCOMPRESSPSZmr,
          5907 => Opcode::VCOMPRESSPSZmrk,
          5908 => Opcode::VCOMPRESSPSZrr,
          5909 => Opcode::VCOMPRESSPSZrrk,
          5910 => Opcode::VCOMPRESSPSZrrkz,
          5911 => Opcode::VCOMXSDZrm_Int,
          5912 => Opcode::VCOMXSDZrr_Int,
          5913 => Opcode::VCOMXSDZrrb_Int,
          5914 => Opcode::VCOMXSHZrm_Int,
          5915 => Opcode::VCOMXSHZrr_Int,
          5916 => Opcode::VCOMXSHZrrb_Int,
          5917 => Opcode::VCOMXSSZrm_Int,
          5918 => Opcode::VCOMXSSZrr_Int,
          5919 => Opcode::VCOMXSSZrrb_Int,
          5920 => Opcode::VCVT2PH2BF8SZ128rm,
          5921 => Opcode::VCVT2PH2BF8SZ128rmb,
          5922 => Opcode::VCVT2PH2BF8SZ128rmbk,
          5923 => Opcode::VCVT2PH2BF8SZ128rmbkz,
          5924 => Opcode::VCVT2PH2BF8SZ128rmk,
          5925 => Opcode::VCVT2PH2BF8SZ128rmkz,
          5926 => Opcode::VCVT2PH2BF8SZ128rr,
          5927 => Opcode::VCVT2PH2BF8SZ128rrk,
          5928 => Opcode::VCVT2PH2BF8SZ128rrkz,
          5929 => Opcode::VCVT2PH2BF8SZ256rm,
          5930 => Opcode::VCVT2PH2BF8SZ256rmb,
          5931 => Opcode::VCVT2PH2BF8SZ256rmbk,
          5932 => Opcode::VCVT2PH2BF8SZ256rmbkz,
          5933 => Opcode::VCVT2PH2BF8SZ256rmk,
          5934 => Opcode::VCVT2PH2BF8SZ256rmkz,
          5935 => Opcode::VCVT2PH2BF8SZ256rr,
          5936 => Opcode::VCVT2PH2BF8SZ256rrk,
          5937 => Opcode::VCVT2PH2BF8SZ256rrkz,
          5938 => Opcode::VCVT2PH2BF8SZrm,
          5939 => Opcode::VCVT2PH2BF8SZrmb,
          5940 => Opcode::VCVT2PH2BF8SZrmbk,
          5941 => Opcode::VCVT2PH2BF8SZrmbkz,
          5942 => Opcode::VCVT2PH2BF8SZrmk,
          5943 => Opcode::VCVT2PH2BF8SZrmkz,
          5944 => Opcode::VCVT2PH2BF8SZrr,
          5945 => Opcode::VCVT2PH2BF8SZrrk,
          5946 => Opcode::VCVT2PH2BF8SZrrkz,
          5947 => Opcode::VCVT2PH2BF8Z128rm,
          5948 => Opcode::VCVT2PH2BF8Z128rmb,
          5949 => Opcode::VCVT2PH2BF8Z128rmbk,
          5950 => Opcode::VCVT2PH2BF8Z128rmbkz,
          5951 => Opcode::VCVT2PH2BF8Z128rmk,
          5952 => Opcode::VCVT2PH2BF8Z128rmkz,
          5953 => Opcode::VCVT2PH2BF8Z128rr,
          5954 => Opcode::VCVT2PH2BF8Z128rrk,
          5955 => Opcode::VCVT2PH2BF8Z128rrkz,
          5956 => Opcode::VCVT2PH2BF8Z256rm,
          5957 => Opcode::VCVT2PH2BF8Z256rmb,
          5958 => Opcode::VCVT2PH2BF8Z256rmbk,
          5959 => Opcode::VCVT2PH2BF8Z256rmbkz,
          5960 => Opcode::VCVT2PH2BF8Z256rmk,
          5961 => Opcode::VCVT2PH2BF8Z256rmkz,
          5962 => Opcode::VCVT2PH2BF8Z256rr,
          5963 => Opcode::VCVT2PH2BF8Z256rrk,
          5964 => Opcode::VCVT2PH2BF8Z256rrkz,
          5965 => Opcode::VCVT2PH2BF8Zrm,
          5966 => Opcode::VCVT2PH2BF8Zrmb,
          5967 => Opcode::VCVT2PH2BF8Zrmbk,
          5968 => Opcode::VCVT2PH2BF8Zrmbkz,
          5969 => Opcode::VCVT2PH2BF8Zrmk,
          5970 => Opcode::VCVT2PH2BF8Zrmkz,
          5971 => Opcode::VCVT2PH2BF8Zrr,
          5972 => Opcode::VCVT2PH2BF8Zrrk,
          5973 => Opcode::VCVT2PH2BF8Zrrkz,
          5974 => Opcode::VCVT2PH2HF8SZ128rm,
          5975 => Opcode::VCVT2PH2HF8SZ128rmb,
          5976 => Opcode::VCVT2PH2HF8SZ128rmbk,
          5977 => Opcode::VCVT2PH2HF8SZ128rmbkz,
          5978 => Opcode::VCVT2PH2HF8SZ128rmk,
          5979 => Opcode::VCVT2PH2HF8SZ128rmkz,
          5980 => Opcode::VCVT2PH2HF8SZ128rr,
          5981 => Opcode::VCVT2PH2HF8SZ128rrk,
          5982 => Opcode::VCVT2PH2HF8SZ128rrkz,
          5983 => Opcode::VCVT2PH2HF8SZ256rm,
          5984 => Opcode::VCVT2PH2HF8SZ256rmb,
          5985 => Opcode::VCVT2PH2HF8SZ256rmbk,
          5986 => Opcode::VCVT2PH2HF8SZ256rmbkz,
          5987 => Opcode::VCVT2PH2HF8SZ256rmk,
          5988 => Opcode::VCVT2PH2HF8SZ256rmkz,
          5989 => Opcode::VCVT2PH2HF8SZ256rr,
          5990 => Opcode::VCVT2PH2HF8SZ256rrk,
          5991 => Opcode::VCVT2PH2HF8SZ256rrkz,
          5992 => Opcode::VCVT2PH2HF8SZrm,
          5993 => Opcode::VCVT2PH2HF8SZrmb,
          5994 => Opcode::VCVT2PH2HF8SZrmbk,
          5995 => Opcode::VCVT2PH2HF8SZrmbkz,
          5996 => Opcode::VCVT2PH2HF8SZrmk,
          5997 => Opcode::VCVT2PH2HF8SZrmkz,
          5998 => Opcode::VCVT2PH2HF8SZrr,
          5999 => Opcode::VCVT2PH2HF8SZrrk,
          6000 => Opcode::VCVT2PH2HF8SZrrkz,
          6001 => Opcode::VCVT2PH2HF8Z128rm,
          6002 => Opcode::VCVT2PH2HF8Z128rmb,
          6003 => Opcode::VCVT2PH2HF8Z128rmbk,
          6004 => Opcode::VCVT2PH2HF8Z128rmbkz,
          6005 => Opcode::VCVT2PH2HF8Z128rmk,
          6006 => Opcode::VCVT2PH2HF8Z128rmkz,
          6007 => Opcode::VCVT2PH2HF8Z128rr,
          6008 => Opcode::VCVT2PH2HF8Z128rrk,
          6009 => Opcode::VCVT2PH2HF8Z128rrkz,
          6010 => Opcode::VCVT2PH2HF8Z256rm,
          6011 => Opcode::VCVT2PH2HF8Z256rmb,
          6012 => Opcode::VCVT2PH2HF8Z256rmbk,
          6013 => Opcode::VCVT2PH2HF8Z256rmbkz,
          6014 => Opcode::VCVT2PH2HF8Z256rmk,
          6015 => Opcode::VCVT2PH2HF8Z256rmkz,
          6016 => Opcode::VCVT2PH2HF8Z256rr,
          6017 => Opcode::VCVT2PH2HF8Z256rrk,
          6018 => Opcode::VCVT2PH2HF8Z256rrkz,
          6019 => Opcode::VCVT2PH2HF8Zrm,
          6020 => Opcode::VCVT2PH2HF8Zrmb,
          6021 => Opcode::VCVT2PH2HF8Zrmbk,
          6022 => Opcode::VCVT2PH2HF8Zrmbkz,
          6023 => Opcode::VCVT2PH2HF8Zrmk,
          6024 => Opcode::VCVT2PH2HF8Zrmkz,
          6025 => Opcode::VCVT2PH2HF8Zrr,
          6026 => Opcode::VCVT2PH2HF8Zrrk,
          6027 => Opcode::VCVT2PH2HF8Zrrkz,
          6028 => Opcode::VCVT2PS2PHXZ128rm,
          6029 => Opcode::VCVT2PS2PHXZ128rmb,
          6030 => Opcode::VCVT2PS2PHXZ128rmbk,
          6031 => Opcode::VCVT2PS2PHXZ128rmbkz,
          6032 => Opcode::VCVT2PS2PHXZ128rmk,
          6033 => Opcode::VCVT2PS2PHXZ128rmkz,
          6034 => Opcode::VCVT2PS2PHXZ128rr,
          6035 => Opcode::VCVT2PS2PHXZ128rrk,
          6036 => Opcode::VCVT2PS2PHXZ128rrkz,
          6037 => Opcode::VCVT2PS2PHXZ256rm,
          6038 => Opcode::VCVT2PS2PHXZ256rmb,
          6039 => Opcode::VCVT2PS2PHXZ256rmbk,
          6040 => Opcode::VCVT2PS2PHXZ256rmbkz,
          6041 => Opcode::VCVT2PS2PHXZ256rmk,
          6042 => Opcode::VCVT2PS2PHXZ256rmkz,
          6043 => Opcode::VCVT2PS2PHXZ256rr,
          6044 => Opcode::VCVT2PS2PHXZ256rrk,
          6045 => Opcode::VCVT2PS2PHXZ256rrkz,
          6046 => Opcode::VCVT2PS2PHXZrm,
          6047 => Opcode::VCVT2PS2PHXZrmb,
          6048 => Opcode::VCVT2PS2PHXZrmbk,
          6049 => Opcode::VCVT2PS2PHXZrmbkz,
          6050 => Opcode::VCVT2PS2PHXZrmk,
          6051 => Opcode::VCVT2PS2PHXZrmkz,
          6052 => Opcode::VCVT2PS2PHXZrr,
          6053 => Opcode::VCVT2PS2PHXZrrb,
          6054 => Opcode::VCVT2PS2PHXZrrbk,
          6055 => Opcode::VCVT2PS2PHXZrrbkz,
          6056 => Opcode::VCVT2PS2PHXZrrk,
          6057 => Opcode::VCVT2PS2PHXZrrkz,
          6058 => Opcode::VCVTBF162IBSZ128rm,
          6059 => Opcode::VCVTBF162IBSZ128rmb,
          6060 => Opcode::VCVTBF162IBSZ128rmbk,
          6061 => Opcode::VCVTBF162IBSZ128rmbkz,
          6062 => Opcode::VCVTBF162IBSZ128rmk,
          6063 => Opcode::VCVTBF162IBSZ128rmkz,
          6064 => Opcode::VCVTBF162IBSZ128rr,
          6065 => Opcode::VCVTBF162IBSZ128rrk,
          6066 => Opcode::VCVTBF162IBSZ128rrkz,
          6067 => Opcode::VCVTBF162IBSZ256rm,
          6068 => Opcode::VCVTBF162IBSZ256rmb,
          6069 => Opcode::VCVTBF162IBSZ256rmbk,
          6070 => Opcode::VCVTBF162IBSZ256rmbkz,
          6071 => Opcode::VCVTBF162IBSZ256rmk,
          6072 => Opcode::VCVTBF162IBSZ256rmkz,
          6073 => Opcode::VCVTBF162IBSZ256rr,
          6074 => Opcode::VCVTBF162IBSZ256rrk,
          6075 => Opcode::VCVTBF162IBSZ256rrkz,
          6076 => Opcode::VCVTBF162IBSZrm,
          6077 => Opcode::VCVTBF162IBSZrmb,
          6078 => Opcode::VCVTBF162IBSZrmbk,
          6079 => Opcode::VCVTBF162IBSZrmbkz,
          6080 => Opcode::VCVTBF162IBSZrmk,
          6081 => Opcode::VCVTBF162IBSZrmkz,
          6082 => Opcode::VCVTBF162IBSZrr,
          6083 => Opcode::VCVTBF162IBSZrrk,
          6084 => Opcode::VCVTBF162IBSZrrkz,
          6085 => Opcode::VCVTBF162IUBSZ128rm,
          6086 => Opcode::VCVTBF162IUBSZ128rmb,
          6087 => Opcode::VCVTBF162IUBSZ128rmbk,
          6088 => Opcode::VCVTBF162IUBSZ128rmbkz,
          6089 => Opcode::VCVTBF162IUBSZ128rmk,
          6090 => Opcode::VCVTBF162IUBSZ128rmkz,
          6091 => Opcode::VCVTBF162IUBSZ128rr,
          6092 => Opcode::VCVTBF162IUBSZ128rrk,
          6093 => Opcode::VCVTBF162IUBSZ128rrkz,
          6094 => Opcode::VCVTBF162IUBSZ256rm,
          6095 => Opcode::VCVTBF162IUBSZ256rmb,
          6096 => Opcode::VCVTBF162IUBSZ256rmbk,
          6097 => Opcode::VCVTBF162IUBSZ256rmbkz,
          6098 => Opcode::VCVTBF162IUBSZ256rmk,
          6099 => Opcode::VCVTBF162IUBSZ256rmkz,
          6100 => Opcode::VCVTBF162IUBSZ256rr,
          6101 => Opcode::VCVTBF162IUBSZ256rrk,
          6102 => Opcode::VCVTBF162IUBSZ256rrkz,
          6103 => Opcode::VCVTBF162IUBSZrm,
          6104 => Opcode::VCVTBF162IUBSZrmb,
          6105 => Opcode::VCVTBF162IUBSZrmbk,
          6106 => Opcode::VCVTBF162IUBSZrmbkz,
          6107 => Opcode::VCVTBF162IUBSZrmk,
          6108 => Opcode::VCVTBF162IUBSZrmkz,
          6109 => Opcode::VCVTBF162IUBSZrr,
          6110 => Opcode::VCVTBF162IUBSZrrk,
          6111 => Opcode::VCVTBF162IUBSZrrkz,
          6112 => Opcode::VCVTBIASPH2BF8SZ128rm,
          6113 => Opcode::VCVTBIASPH2BF8SZ128rmb,
          6114 => Opcode::VCVTBIASPH2BF8SZ128rmbk,
          6115 => Opcode::VCVTBIASPH2BF8SZ128rmbkz,
          6116 => Opcode::VCVTBIASPH2BF8SZ128rmk,
          6117 => Opcode::VCVTBIASPH2BF8SZ128rmkz,
          6118 => Opcode::VCVTBIASPH2BF8SZ128rr,
          6119 => Opcode::VCVTBIASPH2BF8SZ128rrk,
          6120 => Opcode::VCVTBIASPH2BF8SZ128rrkz,
          6121 => Opcode::VCVTBIASPH2BF8SZ256rm,
          6122 => Opcode::VCVTBIASPH2BF8SZ256rmb,
          6123 => Opcode::VCVTBIASPH2BF8SZ256rmbk,
          6124 => Opcode::VCVTBIASPH2BF8SZ256rmbkz,
          6125 => Opcode::VCVTBIASPH2BF8SZ256rmk,
          6126 => Opcode::VCVTBIASPH2BF8SZ256rmkz,
          6127 => Opcode::VCVTBIASPH2BF8SZ256rr,
          6128 => Opcode::VCVTBIASPH2BF8SZ256rrk,
          6129 => Opcode::VCVTBIASPH2BF8SZ256rrkz,
          6130 => Opcode::VCVTBIASPH2BF8SZrm,
          6131 => Opcode::VCVTBIASPH2BF8SZrmb,
          6132 => Opcode::VCVTBIASPH2BF8SZrmbk,
          6133 => Opcode::VCVTBIASPH2BF8SZrmbkz,
          6134 => Opcode::VCVTBIASPH2BF8SZrmk,
          6135 => Opcode::VCVTBIASPH2BF8SZrmkz,
          6136 => Opcode::VCVTBIASPH2BF8SZrr,
          6137 => Opcode::VCVTBIASPH2BF8SZrrk,
          6138 => Opcode::VCVTBIASPH2BF8SZrrkz,
          6139 => Opcode::VCVTBIASPH2BF8Z128rm,
          6140 => Opcode::VCVTBIASPH2BF8Z128rmb,
          6141 => Opcode::VCVTBIASPH2BF8Z128rmbk,
          6142 => Opcode::VCVTBIASPH2BF8Z128rmbkz,
          6143 => Opcode::VCVTBIASPH2BF8Z128rmk,
          6144 => Opcode::VCVTBIASPH2BF8Z128rmkz,
          6145 => Opcode::VCVTBIASPH2BF8Z128rr,
          6146 => Opcode::VCVTBIASPH2BF8Z128rrk,
          6147 => Opcode::VCVTBIASPH2BF8Z128rrkz,
          6148 => Opcode::VCVTBIASPH2BF8Z256rm,
          6149 => Opcode::VCVTBIASPH2BF8Z256rmb,
          6150 => Opcode::VCVTBIASPH2BF8Z256rmbk,
          6151 => Opcode::VCVTBIASPH2BF8Z256rmbkz,
          6152 => Opcode::VCVTBIASPH2BF8Z256rmk,
          6153 => Opcode::VCVTBIASPH2BF8Z256rmkz,
          6154 => Opcode::VCVTBIASPH2BF8Z256rr,
          6155 => Opcode::VCVTBIASPH2BF8Z256rrk,
          6156 => Opcode::VCVTBIASPH2BF8Z256rrkz,
          6157 => Opcode::VCVTBIASPH2BF8Zrm,
          6158 => Opcode::VCVTBIASPH2BF8Zrmb,
          6159 => Opcode::VCVTBIASPH2BF8Zrmbk,
          6160 => Opcode::VCVTBIASPH2BF8Zrmbkz,
          6161 => Opcode::VCVTBIASPH2BF8Zrmk,
          6162 => Opcode::VCVTBIASPH2BF8Zrmkz,
          6163 => Opcode::VCVTBIASPH2BF8Zrr,
          6164 => Opcode::VCVTBIASPH2BF8Zrrk,
          6165 => Opcode::VCVTBIASPH2BF8Zrrkz,
          6166 => Opcode::VCVTBIASPH2HF8SZ128rm,
          6167 => Opcode::VCVTBIASPH2HF8SZ128rmb,
          6168 => Opcode::VCVTBIASPH2HF8SZ128rmbk,
          6169 => Opcode::VCVTBIASPH2HF8SZ128rmbkz,
          6170 => Opcode::VCVTBIASPH2HF8SZ128rmk,
          6171 => Opcode::VCVTBIASPH2HF8SZ128rmkz,
          6172 => Opcode::VCVTBIASPH2HF8SZ128rr,
          6173 => Opcode::VCVTBIASPH2HF8SZ128rrk,
          6174 => Opcode::VCVTBIASPH2HF8SZ128rrkz,
          6175 => Opcode::VCVTBIASPH2HF8SZ256rm,
          6176 => Opcode::VCVTBIASPH2HF8SZ256rmb,
          6177 => Opcode::VCVTBIASPH2HF8SZ256rmbk,
          6178 => Opcode::VCVTBIASPH2HF8SZ256rmbkz,
          6179 => Opcode::VCVTBIASPH2HF8SZ256rmk,
          6180 => Opcode::VCVTBIASPH2HF8SZ256rmkz,
          6181 => Opcode::VCVTBIASPH2HF8SZ256rr,
          6182 => Opcode::VCVTBIASPH2HF8SZ256rrk,
          6183 => Opcode::VCVTBIASPH2HF8SZ256rrkz,
          6184 => Opcode::VCVTBIASPH2HF8SZrm,
          6185 => Opcode::VCVTBIASPH2HF8SZrmb,
          6186 => Opcode::VCVTBIASPH2HF8SZrmbk,
          6187 => Opcode::VCVTBIASPH2HF8SZrmbkz,
          6188 => Opcode::VCVTBIASPH2HF8SZrmk,
          6189 => Opcode::VCVTBIASPH2HF8SZrmkz,
          6190 => Opcode::VCVTBIASPH2HF8SZrr,
          6191 => Opcode::VCVTBIASPH2HF8SZrrk,
          6192 => Opcode::VCVTBIASPH2HF8SZrrkz,
          6193 => Opcode::VCVTBIASPH2HF8Z128rm,
          6194 => Opcode::VCVTBIASPH2HF8Z128rmb,
          6195 => Opcode::VCVTBIASPH2HF8Z128rmbk,
          6196 => Opcode::VCVTBIASPH2HF8Z128rmbkz,
          6197 => Opcode::VCVTBIASPH2HF8Z128rmk,
          6198 => Opcode::VCVTBIASPH2HF8Z128rmkz,
          6199 => Opcode::VCVTBIASPH2HF8Z128rr,
          6200 => Opcode::VCVTBIASPH2HF8Z128rrk,
          6201 => Opcode::VCVTBIASPH2HF8Z128rrkz,
          6202 => Opcode::VCVTBIASPH2HF8Z256rm,
          6203 => Opcode::VCVTBIASPH2HF8Z256rmb,
          6204 => Opcode::VCVTBIASPH2HF8Z256rmbk,
          6205 => Opcode::VCVTBIASPH2HF8Z256rmbkz,
          6206 => Opcode::VCVTBIASPH2HF8Z256rmk,
          6207 => Opcode::VCVTBIASPH2HF8Z256rmkz,
          6208 => Opcode::VCVTBIASPH2HF8Z256rr,
          6209 => Opcode::VCVTBIASPH2HF8Z256rrk,
          6210 => Opcode::VCVTBIASPH2HF8Z256rrkz,
          6211 => Opcode::VCVTBIASPH2HF8Zrm,
          6212 => Opcode::VCVTBIASPH2HF8Zrmb,
          6213 => Opcode::VCVTBIASPH2HF8Zrmbk,
          6214 => Opcode::VCVTBIASPH2HF8Zrmbkz,
          6215 => Opcode::VCVTBIASPH2HF8Zrmk,
          6216 => Opcode::VCVTBIASPH2HF8Zrmkz,
          6217 => Opcode::VCVTBIASPH2HF8Zrr,
          6218 => Opcode::VCVTBIASPH2HF8Zrrk,
          6219 => Opcode::VCVTBIASPH2HF8Zrrkz,
          6220 => Opcode::VCVTDQ2PDYrm,
          6221 => Opcode::VCVTDQ2PDYrr,
          6222 => Opcode::VCVTDQ2PDZ128rm,
          6223 => Opcode::VCVTDQ2PDZ128rmb,
          6224 => Opcode::VCVTDQ2PDZ128rmbk,
          6225 => Opcode::VCVTDQ2PDZ128rmbkz,
          6226 => Opcode::VCVTDQ2PDZ128rmk,
          6227 => Opcode::VCVTDQ2PDZ128rmkz,
          6228 => Opcode::VCVTDQ2PDZ128rr,
          6229 => Opcode::VCVTDQ2PDZ128rrk,
          6230 => Opcode::VCVTDQ2PDZ128rrkz,
          6231 => Opcode::VCVTDQ2PDZ256rm,
          6232 => Opcode::VCVTDQ2PDZ256rmb,
          6233 => Opcode::VCVTDQ2PDZ256rmbk,
          6234 => Opcode::VCVTDQ2PDZ256rmbkz,
          6235 => Opcode::VCVTDQ2PDZ256rmk,
          6236 => Opcode::VCVTDQ2PDZ256rmkz,
          6237 => Opcode::VCVTDQ2PDZ256rr,
          6238 => Opcode::VCVTDQ2PDZ256rrk,
          6239 => Opcode::VCVTDQ2PDZ256rrkz,
          6240 => Opcode::VCVTDQ2PDZrm,
          6241 => Opcode::VCVTDQ2PDZrmb,
          6242 => Opcode::VCVTDQ2PDZrmbk,
          6243 => Opcode::VCVTDQ2PDZrmbkz,
          6244 => Opcode::VCVTDQ2PDZrmk,
          6245 => Opcode::VCVTDQ2PDZrmkz,
          6246 => Opcode::VCVTDQ2PDZrr,
          6247 => Opcode::VCVTDQ2PDZrrk,
          6248 => Opcode::VCVTDQ2PDZrrkz,
          6249 => Opcode::VCVTDQ2PDrm,
          6250 => Opcode::VCVTDQ2PDrr,
          6251 => Opcode::VCVTDQ2PHZ128rm,
          6252 => Opcode::VCVTDQ2PHZ128rmb,
          6253 => Opcode::VCVTDQ2PHZ128rmbk,
          6254 => Opcode::VCVTDQ2PHZ128rmbkz,
          6255 => Opcode::VCVTDQ2PHZ128rmk,
          6256 => Opcode::VCVTDQ2PHZ128rmkz,
          6257 => Opcode::VCVTDQ2PHZ128rr,
          6258 => Opcode::VCVTDQ2PHZ128rrk,
          6259 => Opcode::VCVTDQ2PHZ128rrkz,
          6260 => Opcode::VCVTDQ2PHZ256rm,
          6261 => Opcode::VCVTDQ2PHZ256rmb,
          6262 => Opcode::VCVTDQ2PHZ256rmbk,
          6263 => Opcode::VCVTDQ2PHZ256rmbkz,
          6264 => Opcode::VCVTDQ2PHZ256rmk,
          6265 => Opcode::VCVTDQ2PHZ256rmkz,
          6266 => Opcode::VCVTDQ2PHZ256rr,
          6267 => Opcode::VCVTDQ2PHZ256rrk,
          6268 => Opcode::VCVTDQ2PHZ256rrkz,
          6269 => Opcode::VCVTDQ2PHZrm,
          6270 => Opcode::VCVTDQ2PHZrmb,
          6271 => Opcode::VCVTDQ2PHZrmbk,
          6272 => Opcode::VCVTDQ2PHZrmbkz,
          6273 => Opcode::VCVTDQ2PHZrmk,
          6274 => Opcode::VCVTDQ2PHZrmkz,
          6275 => Opcode::VCVTDQ2PHZrr,
          6276 => Opcode::VCVTDQ2PHZrrb,
          6277 => Opcode::VCVTDQ2PHZrrbk,
          6278 => Opcode::VCVTDQ2PHZrrbkz,
          6279 => Opcode::VCVTDQ2PHZrrk,
          6280 => Opcode::VCVTDQ2PHZrrkz,
          6281 => Opcode::VCVTDQ2PSYrm,
          6282 => Opcode::VCVTDQ2PSYrr,
          6283 => Opcode::VCVTDQ2PSZ128rm,
          6284 => Opcode::VCVTDQ2PSZ128rmb,
          6285 => Opcode::VCVTDQ2PSZ128rmbk,
          6286 => Opcode::VCVTDQ2PSZ128rmbkz,
          6287 => Opcode::VCVTDQ2PSZ128rmk,
          6288 => Opcode::VCVTDQ2PSZ128rmkz,
          6289 => Opcode::VCVTDQ2PSZ128rr,
          6290 => Opcode::VCVTDQ2PSZ128rrk,
          6291 => Opcode::VCVTDQ2PSZ128rrkz,
          6292 => Opcode::VCVTDQ2PSZ256rm,
          6293 => Opcode::VCVTDQ2PSZ256rmb,
          6294 => Opcode::VCVTDQ2PSZ256rmbk,
          6295 => Opcode::VCVTDQ2PSZ256rmbkz,
          6296 => Opcode::VCVTDQ2PSZ256rmk,
          6297 => Opcode::VCVTDQ2PSZ256rmkz,
          6298 => Opcode::VCVTDQ2PSZ256rr,
          6299 => Opcode::VCVTDQ2PSZ256rrk,
          6300 => Opcode::VCVTDQ2PSZ256rrkz,
          6301 => Opcode::VCVTDQ2PSZrm,
          6302 => Opcode::VCVTDQ2PSZrmb,
          6303 => Opcode::VCVTDQ2PSZrmbk,
          6304 => Opcode::VCVTDQ2PSZrmbkz,
          6305 => Opcode::VCVTDQ2PSZrmk,
          6306 => Opcode::VCVTDQ2PSZrmkz,
          6307 => Opcode::VCVTDQ2PSZrr,
          6308 => Opcode::VCVTDQ2PSZrrb,
          6309 => Opcode::VCVTDQ2PSZrrbk,
          6310 => Opcode::VCVTDQ2PSZrrbkz,
          6311 => Opcode::VCVTDQ2PSZrrk,
          6312 => Opcode::VCVTDQ2PSZrrkz,
          6313 => Opcode::VCVTDQ2PSrm,
          6314 => Opcode::VCVTDQ2PSrr,
          6315 => Opcode::VCVTHF82PHZ128rm,
          6316 => Opcode::VCVTHF82PHZ128rmk,
          6317 => Opcode::VCVTHF82PHZ128rmkz,
          6318 => Opcode::VCVTHF82PHZ128rr,
          6319 => Opcode::VCVTHF82PHZ128rrk,
          6320 => Opcode::VCVTHF82PHZ128rrkz,
          6321 => Opcode::VCVTHF82PHZ256rm,
          6322 => Opcode::VCVTHF82PHZ256rmk,
          6323 => Opcode::VCVTHF82PHZ256rmkz,
          6324 => Opcode::VCVTHF82PHZ256rr,
          6325 => Opcode::VCVTHF82PHZ256rrk,
          6326 => Opcode::VCVTHF82PHZ256rrkz,
          6327 => Opcode::VCVTHF82PHZrm,
          6328 => Opcode::VCVTHF82PHZrmk,
          6329 => Opcode::VCVTHF82PHZrmkz,
          6330 => Opcode::VCVTHF82PHZrr,
          6331 => Opcode::VCVTHF82PHZrrk,
          6332 => Opcode::VCVTHF82PHZrrkz,
          6333 => Opcode::VCVTNE2PS2BF16Z128rm,
          6334 => Opcode::VCVTNE2PS2BF16Z128rmb,
          6335 => Opcode::VCVTNE2PS2BF16Z128rmbk,
          6336 => Opcode::VCVTNE2PS2BF16Z128rmbkz,
          6337 => Opcode::VCVTNE2PS2BF16Z128rmk,
          6338 => Opcode::VCVTNE2PS2BF16Z128rmkz,
          6339 => Opcode::VCVTNE2PS2BF16Z128rr,
          6340 => Opcode::VCVTNE2PS2BF16Z128rrk,
          6341 => Opcode::VCVTNE2PS2BF16Z128rrkz,
          6342 => Opcode::VCVTNE2PS2BF16Z256rm,
          6343 => Opcode::VCVTNE2PS2BF16Z256rmb,
          6344 => Opcode::VCVTNE2PS2BF16Z256rmbk,
          6345 => Opcode::VCVTNE2PS2BF16Z256rmbkz,
          6346 => Opcode::VCVTNE2PS2BF16Z256rmk,
          6347 => Opcode::VCVTNE2PS2BF16Z256rmkz,
          6348 => Opcode::VCVTNE2PS2BF16Z256rr,
          6349 => Opcode::VCVTNE2PS2BF16Z256rrk,
          6350 => Opcode::VCVTNE2PS2BF16Z256rrkz,
          6351 => Opcode::VCVTNE2PS2BF16Zrm,
          6352 => Opcode::VCVTNE2PS2BF16Zrmb,
          6353 => Opcode::VCVTNE2PS2BF16Zrmbk,
          6354 => Opcode::VCVTNE2PS2BF16Zrmbkz,
          6355 => Opcode::VCVTNE2PS2BF16Zrmk,
          6356 => Opcode::VCVTNE2PS2BF16Zrmkz,
          6357 => Opcode::VCVTNE2PS2BF16Zrr,
          6358 => Opcode::VCVTNE2PS2BF16Zrrk,
          6359 => Opcode::VCVTNE2PS2BF16Zrrkz,
          6360 => Opcode::VCVTNEEBF162PSYrm,
          6361 => Opcode::VCVTNEEBF162PSrm,
          6362 => Opcode::VCVTNEEPH2PSYrm,
          6363 => Opcode::VCVTNEEPH2PSrm,
          6364 => Opcode::VCVTNEOBF162PSYrm,
          6365 => Opcode::VCVTNEOBF162PSrm,
          6366 => Opcode::VCVTNEOPH2PSYrm,
          6367 => Opcode::VCVTNEOPH2PSrm,
          6368 => Opcode::VCVTNEPS2BF16Yrm,
          6369 => Opcode::VCVTNEPS2BF16Yrr,
          6370 => Opcode::VCVTNEPS2BF16Z128rm,
          6371 => Opcode::VCVTNEPS2BF16Z128rmb,
          6372 => Opcode::VCVTNEPS2BF16Z128rmbk,
          6373 => Opcode::VCVTNEPS2BF16Z128rmbkz,
          6374 => Opcode::VCVTNEPS2BF16Z128rmk,
          6375 => Opcode::VCVTNEPS2BF16Z128rmkz,
          6376 => Opcode::VCVTNEPS2BF16Z128rr,
          6377 => Opcode::VCVTNEPS2BF16Z128rrk,
          6378 => Opcode::VCVTNEPS2BF16Z128rrkz,
          6379 => Opcode::VCVTNEPS2BF16Z256rm,
          6380 => Opcode::VCVTNEPS2BF16Z256rmb,
          6381 => Opcode::VCVTNEPS2BF16Z256rmbk,
          6382 => Opcode::VCVTNEPS2BF16Z256rmbkz,
          6383 => Opcode::VCVTNEPS2BF16Z256rmk,
          6384 => Opcode::VCVTNEPS2BF16Z256rmkz,
          6385 => Opcode::VCVTNEPS2BF16Z256rr,
          6386 => Opcode::VCVTNEPS2BF16Z256rrk,
          6387 => Opcode::VCVTNEPS2BF16Z256rrkz,
          6388 => Opcode::VCVTNEPS2BF16Zrm,
          6389 => Opcode::VCVTNEPS2BF16Zrmb,
          6390 => Opcode::VCVTNEPS2BF16Zrmbk,
          6391 => Opcode::VCVTNEPS2BF16Zrmbkz,
          6392 => Opcode::VCVTNEPS2BF16Zrmk,
          6393 => Opcode::VCVTNEPS2BF16Zrmkz,
          6394 => Opcode::VCVTNEPS2BF16Zrr,
          6395 => Opcode::VCVTNEPS2BF16Zrrk,
          6396 => Opcode::VCVTNEPS2BF16Zrrkz,
          6397 => Opcode::VCVTNEPS2BF16rm,
          6398 => Opcode::VCVTNEPS2BF16rr,
          6399 => Opcode::VCVTPD2DQYrm,
          6400 => Opcode::VCVTPD2DQYrr,
          6401 => Opcode::VCVTPD2DQZ128rm,
          6402 => Opcode::VCVTPD2DQZ128rmb,
          6403 => Opcode::VCVTPD2DQZ128rmbk,
          6404 => Opcode::VCVTPD2DQZ128rmbkz,
          6405 => Opcode::VCVTPD2DQZ128rmk,
          6406 => Opcode::VCVTPD2DQZ128rmkz,
          6407 => Opcode::VCVTPD2DQZ128rr,
          6408 => Opcode::VCVTPD2DQZ128rrk,
          6409 => Opcode::VCVTPD2DQZ128rrkz,
          6410 => Opcode::VCVTPD2DQZ256rm,
          6411 => Opcode::VCVTPD2DQZ256rmb,
          6412 => Opcode::VCVTPD2DQZ256rmbk,
          6413 => Opcode::VCVTPD2DQZ256rmbkz,
          6414 => Opcode::VCVTPD2DQZ256rmk,
          6415 => Opcode::VCVTPD2DQZ256rmkz,
          6416 => Opcode::VCVTPD2DQZ256rr,
          6417 => Opcode::VCVTPD2DQZ256rrk,
          6418 => Opcode::VCVTPD2DQZ256rrkz,
          6419 => Opcode::VCVTPD2DQZrm,
          6420 => Opcode::VCVTPD2DQZrmb,
          6421 => Opcode::VCVTPD2DQZrmbk,
          6422 => Opcode::VCVTPD2DQZrmbkz,
          6423 => Opcode::VCVTPD2DQZrmk,
          6424 => Opcode::VCVTPD2DQZrmkz,
          6425 => Opcode::VCVTPD2DQZrr,
          6426 => Opcode::VCVTPD2DQZrrb,
          6427 => Opcode::VCVTPD2DQZrrbk,
          6428 => Opcode::VCVTPD2DQZrrbkz,
          6429 => Opcode::VCVTPD2DQZrrk,
          6430 => Opcode::VCVTPD2DQZrrkz,
          6431 => Opcode::VCVTPD2DQrm,
          6432 => Opcode::VCVTPD2DQrr,
          6433 => Opcode::VCVTPD2PHZ128rm,
          6434 => Opcode::VCVTPD2PHZ128rmb,
          6435 => Opcode::VCVTPD2PHZ128rmbk,
          6436 => Opcode::VCVTPD2PHZ128rmbkz,
          6437 => Opcode::VCVTPD2PHZ128rmk,
          6438 => Opcode::VCVTPD2PHZ128rmkz,
          6439 => Opcode::VCVTPD2PHZ128rr,
          6440 => Opcode::VCVTPD2PHZ128rrk,
          6441 => Opcode::VCVTPD2PHZ128rrkz,
          6442 => Opcode::VCVTPD2PHZ256rm,
          6443 => Opcode::VCVTPD2PHZ256rmb,
          6444 => Opcode::VCVTPD2PHZ256rmbk,
          6445 => Opcode::VCVTPD2PHZ256rmbkz,
          6446 => Opcode::VCVTPD2PHZ256rmk,
          6447 => Opcode::VCVTPD2PHZ256rmkz,
          6448 => Opcode::VCVTPD2PHZ256rr,
          6449 => Opcode::VCVTPD2PHZ256rrk,
          6450 => Opcode::VCVTPD2PHZ256rrkz,
          6451 => Opcode::VCVTPD2PHZrm,
          6452 => Opcode::VCVTPD2PHZrmb,
          6453 => Opcode::VCVTPD2PHZrmbk,
          6454 => Opcode::VCVTPD2PHZrmbkz,
          6455 => Opcode::VCVTPD2PHZrmk,
          6456 => Opcode::VCVTPD2PHZrmkz,
          6457 => Opcode::VCVTPD2PHZrr,
          6458 => Opcode::VCVTPD2PHZrrb,
          6459 => Opcode::VCVTPD2PHZrrbk,
          6460 => Opcode::VCVTPD2PHZrrbkz,
          6461 => Opcode::VCVTPD2PHZrrk,
          6462 => Opcode::VCVTPD2PHZrrkz,
          6463 => Opcode::VCVTPD2PSYrm,
          6464 => Opcode::VCVTPD2PSYrr,
          6465 => Opcode::VCVTPD2PSZ128rm,
          6466 => Opcode::VCVTPD2PSZ128rmb,
          6467 => Opcode::VCVTPD2PSZ128rmbk,
          6468 => Opcode::VCVTPD2PSZ128rmbkz,
          6469 => Opcode::VCVTPD2PSZ128rmk,
          6470 => Opcode::VCVTPD2PSZ128rmkz,
          6471 => Opcode::VCVTPD2PSZ128rr,
          6472 => Opcode::VCVTPD2PSZ128rrk,
          6473 => Opcode::VCVTPD2PSZ128rrkz,
          6474 => Opcode::VCVTPD2PSZ256rm,
          6475 => Opcode::VCVTPD2PSZ256rmb,
          6476 => Opcode::VCVTPD2PSZ256rmbk,
          6477 => Opcode::VCVTPD2PSZ256rmbkz,
          6478 => Opcode::VCVTPD2PSZ256rmk,
          6479 => Opcode::VCVTPD2PSZ256rmkz,
          6480 => Opcode::VCVTPD2PSZ256rr,
          6481 => Opcode::VCVTPD2PSZ256rrk,
          6482 => Opcode::VCVTPD2PSZ256rrkz,
          6483 => Opcode::VCVTPD2PSZrm,
          6484 => Opcode::VCVTPD2PSZrmb,
          6485 => Opcode::VCVTPD2PSZrmbk,
          6486 => Opcode::VCVTPD2PSZrmbkz,
          6487 => Opcode::VCVTPD2PSZrmk,
          6488 => Opcode::VCVTPD2PSZrmkz,
          6489 => Opcode::VCVTPD2PSZrr,
          6490 => Opcode::VCVTPD2PSZrrb,
          6491 => Opcode::VCVTPD2PSZrrbk,
          6492 => Opcode::VCVTPD2PSZrrbkz,
          6493 => Opcode::VCVTPD2PSZrrk,
          6494 => Opcode::VCVTPD2PSZrrkz,
          6495 => Opcode::VCVTPD2PSrm,
          6496 => Opcode::VCVTPD2PSrr,
          6497 => Opcode::VCVTPD2QQZ128rm,
          6498 => Opcode::VCVTPD2QQZ128rmb,
          6499 => Opcode::VCVTPD2QQZ128rmbk,
          6500 => Opcode::VCVTPD2QQZ128rmbkz,
          6501 => Opcode::VCVTPD2QQZ128rmk,
          6502 => Opcode::VCVTPD2QQZ128rmkz,
          6503 => Opcode::VCVTPD2QQZ128rr,
          6504 => Opcode::VCVTPD2QQZ128rrk,
          6505 => Opcode::VCVTPD2QQZ128rrkz,
          6506 => Opcode::VCVTPD2QQZ256rm,
          6507 => Opcode::VCVTPD2QQZ256rmb,
          6508 => Opcode::VCVTPD2QQZ256rmbk,
          6509 => Opcode::VCVTPD2QQZ256rmbkz,
          6510 => Opcode::VCVTPD2QQZ256rmk,
          6511 => Opcode::VCVTPD2QQZ256rmkz,
          6512 => Opcode::VCVTPD2QQZ256rr,
          6513 => Opcode::VCVTPD2QQZ256rrk,
          6514 => Opcode::VCVTPD2QQZ256rrkz,
          6515 => Opcode::VCVTPD2QQZrm,
          6516 => Opcode::VCVTPD2QQZrmb,
          6517 => Opcode::VCVTPD2QQZrmbk,
          6518 => Opcode::VCVTPD2QQZrmbkz,
          6519 => Opcode::VCVTPD2QQZrmk,
          6520 => Opcode::VCVTPD2QQZrmkz,
          6521 => Opcode::VCVTPD2QQZrr,
          6522 => Opcode::VCVTPD2QQZrrb,
          6523 => Opcode::VCVTPD2QQZrrbk,
          6524 => Opcode::VCVTPD2QQZrrbkz,
          6525 => Opcode::VCVTPD2QQZrrk,
          6526 => Opcode::VCVTPD2QQZrrkz,
          6527 => Opcode::VCVTPD2UDQZ128rm,
          6528 => Opcode::VCVTPD2UDQZ128rmb,
          6529 => Opcode::VCVTPD2UDQZ128rmbk,
          6530 => Opcode::VCVTPD2UDQZ128rmbkz,
          6531 => Opcode::VCVTPD2UDQZ128rmk,
          6532 => Opcode::VCVTPD2UDQZ128rmkz,
          6533 => Opcode::VCVTPD2UDQZ128rr,
          6534 => Opcode::VCVTPD2UDQZ128rrk,
          6535 => Opcode::VCVTPD2UDQZ128rrkz,
          6536 => Opcode::VCVTPD2UDQZ256rm,
          6537 => Opcode::VCVTPD2UDQZ256rmb,
          6538 => Opcode::VCVTPD2UDQZ256rmbk,
          6539 => Opcode::VCVTPD2UDQZ256rmbkz,
          6540 => Opcode::VCVTPD2UDQZ256rmk,
          6541 => Opcode::VCVTPD2UDQZ256rmkz,
          6542 => Opcode::VCVTPD2UDQZ256rr,
          6543 => Opcode::VCVTPD2UDQZ256rrk,
          6544 => Opcode::VCVTPD2UDQZ256rrkz,
          6545 => Opcode::VCVTPD2UDQZrm,
          6546 => Opcode::VCVTPD2UDQZrmb,
          6547 => Opcode::VCVTPD2UDQZrmbk,
          6548 => Opcode::VCVTPD2UDQZrmbkz,
          6549 => Opcode::VCVTPD2UDQZrmk,
          6550 => Opcode::VCVTPD2UDQZrmkz,
          6551 => Opcode::VCVTPD2UDQZrr,
          6552 => Opcode::VCVTPD2UDQZrrb,
          6553 => Opcode::VCVTPD2UDQZrrbk,
          6554 => Opcode::VCVTPD2UDQZrrbkz,
          6555 => Opcode::VCVTPD2UDQZrrk,
          6556 => Opcode::VCVTPD2UDQZrrkz,
          6557 => Opcode::VCVTPD2UQQZ128rm,
          6558 => Opcode::VCVTPD2UQQZ128rmb,
          6559 => Opcode::VCVTPD2UQQZ128rmbk,
          6560 => Opcode::VCVTPD2UQQZ128rmbkz,
          6561 => Opcode::VCVTPD2UQQZ128rmk,
          6562 => Opcode::VCVTPD2UQQZ128rmkz,
          6563 => Opcode::VCVTPD2UQQZ128rr,
          6564 => Opcode::VCVTPD2UQQZ128rrk,
          6565 => Opcode::VCVTPD2UQQZ128rrkz,
          6566 => Opcode::VCVTPD2UQQZ256rm,
          6567 => Opcode::VCVTPD2UQQZ256rmb,
          6568 => Opcode::VCVTPD2UQQZ256rmbk,
          6569 => Opcode::VCVTPD2UQQZ256rmbkz,
          6570 => Opcode::VCVTPD2UQQZ256rmk,
          6571 => Opcode::VCVTPD2UQQZ256rmkz,
          6572 => Opcode::VCVTPD2UQQZ256rr,
          6573 => Opcode::VCVTPD2UQQZ256rrk,
          6574 => Opcode::VCVTPD2UQQZ256rrkz,
          6575 => Opcode::VCVTPD2UQQZrm,
          6576 => Opcode::VCVTPD2UQQZrmb,
          6577 => Opcode::VCVTPD2UQQZrmbk,
          6578 => Opcode::VCVTPD2UQQZrmbkz,
          6579 => Opcode::VCVTPD2UQQZrmk,
          6580 => Opcode::VCVTPD2UQQZrmkz,
          6581 => Opcode::VCVTPD2UQQZrr,
          6582 => Opcode::VCVTPD2UQQZrrb,
          6583 => Opcode::VCVTPD2UQQZrrbk,
          6584 => Opcode::VCVTPD2UQQZrrbkz,
          6585 => Opcode::VCVTPD2UQQZrrk,
          6586 => Opcode::VCVTPD2UQQZrrkz,
          6587 => Opcode::VCVTPH2BF8SZ128rm,
          6588 => Opcode::VCVTPH2BF8SZ128rmb,
          6589 => Opcode::VCVTPH2BF8SZ128rmbk,
          6590 => Opcode::VCVTPH2BF8SZ128rmbkz,
          6591 => Opcode::VCVTPH2BF8SZ128rmk,
          6592 => Opcode::VCVTPH2BF8SZ128rmkz,
          6593 => Opcode::VCVTPH2BF8SZ128rr,
          6594 => Opcode::VCVTPH2BF8SZ128rrk,
          6595 => Opcode::VCVTPH2BF8SZ128rrkz,
          6596 => Opcode::VCVTPH2BF8SZ256rm,
          6597 => Opcode::VCVTPH2BF8SZ256rmb,
          6598 => Opcode::VCVTPH2BF8SZ256rmbk,
          6599 => Opcode::VCVTPH2BF8SZ256rmbkz,
          6600 => Opcode::VCVTPH2BF8SZ256rmk,
          6601 => Opcode::VCVTPH2BF8SZ256rmkz,
          6602 => Opcode::VCVTPH2BF8SZ256rr,
          6603 => Opcode::VCVTPH2BF8SZ256rrk,
          6604 => Opcode::VCVTPH2BF8SZ256rrkz,
          6605 => Opcode::VCVTPH2BF8SZrm,
          6606 => Opcode::VCVTPH2BF8SZrmb,
          6607 => Opcode::VCVTPH2BF8SZrmbk,
          6608 => Opcode::VCVTPH2BF8SZrmbkz,
          6609 => Opcode::VCVTPH2BF8SZrmk,
          6610 => Opcode::VCVTPH2BF8SZrmkz,
          6611 => Opcode::VCVTPH2BF8SZrr,
          6612 => Opcode::VCVTPH2BF8SZrrk,
          6613 => Opcode::VCVTPH2BF8SZrrkz,
          6614 => Opcode::VCVTPH2BF8Z128rm,
          6615 => Opcode::VCVTPH2BF8Z128rmb,
          6616 => Opcode::VCVTPH2BF8Z128rmbk,
          6617 => Opcode::VCVTPH2BF8Z128rmbkz,
          6618 => Opcode::VCVTPH2BF8Z128rmk,
          6619 => Opcode::VCVTPH2BF8Z128rmkz,
          6620 => Opcode::VCVTPH2BF8Z128rr,
          6621 => Opcode::VCVTPH2BF8Z128rrk,
          6622 => Opcode::VCVTPH2BF8Z128rrkz,
          6623 => Opcode::VCVTPH2BF8Z256rm,
          6624 => Opcode::VCVTPH2BF8Z256rmb,
          6625 => Opcode::VCVTPH2BF8Z256rmbk,
          6626 => Opcode::VCVTPH2BF8Z256rmbkz,
          6627 => Opcode::VCVTPH2BF8Z256rmk,
          6628 => Opcode::VCVTPH2BF8Z256rmkz,
          6629 => Opcode::VCVTPH2BF8Z256rr,
          6630 => Opcode::VCVTPH2BF8Z256rrk,
          6631 => Opcode::VCVTPH2BF8Z256rrkz,
          6632 => Opcode::VCVTPH2BF8Zrm,
          6633 => Opcode::VCVTPH2BF8Zrmb,
          6634 => Opcode::VCVTPH2BF8Zrmbk,
          6635 => Opcode::VCVTPH2BF8Zrmbkz,
          6636 => Opcode::VCVTPH2BF8Zrmk,
          6637 => Opcode::VCVTPH2BF8Zrmkz,
          6638 => Opcode::VCVTPH2BF8Zrr,
          6639 => Opcode::VCVTPH2BF8Zrrk,
          6640 => Opcode::VCVTPH2BF8Zrrkz,
          6641 => Opcode::VCVTPH2DQZ128rm,
          6642 => Opcode::VCVTPH2DQZ128rmb,
          6643 => Opcode::VCVTPH2DQZ128rmbk,
          6644 => Opcode::VCVTPH2DQZ128rmbkz,
          6645 => Opcode::VCVTPH2DQZ128rmk,
          6646 => Opcode::VCVTPH2DQZ128rmkz,
          6647 => Opcode::VCVTPH2DQZ128rr,
          6648 => Opcode::VCVTPH2DQZ128rrk,
          6649 => Opcode::VCVTPH2DQZ128rrkz,
          6650 => Opcode::VCVTPH2DQZ256rm,
          6651 => Opcode::VCVTPH2DQZ256rmb,
          6652 => Opcode::VCVTPH2DQZ256rmbk,
          6653 => Opcode::VCVTPH2DQZ256rmbkz,
          6654 => Opcode::VCVTPH2DQZ256rmk,
          6655 => Opcode::VCVTPH2DQZ256rmkz,
          6656 => Opcode::VCVTPH2DQZ256rr,
          6657 => Opcode::VCVTPH2DQZ256rrk,
          6658 => Opcode::VCVTPH2DQZ256rrkz,
          6659 => Opcode::VCVTPH2DQZrm,
          6660 => Opcode::VCVTPH2DQZrmb,
          6661 => Opcode::VCVTPH2DQZrmbk,
          6662 => Opcode::VCVTPH2DQZrmbkz,
          6663 => Opcode::VCVTPH2DQZrmk,
          6664 => Opcode::VCVTPH2DQZrmkz,
          6665 => Opcode::VCVTPH2DQZrr,
          6666 => Opcode::VCVTPH2DQZrrb,
          6667 => Opcode::VCVTPH2DQZrrbk,
          6668 => Opcode::VCVTPH2DQZrrbkz,
          6669 => Opcode::VCVTPH2DQZrrk,
          6670 => Opcode::VCVTPH2DQZrrkz,
          6671 => Opcode::VCVTPH2HF8SZ128rm,
          6672 => Opcode::VCVTPH2HF8SZ128rmb,
          6673 => Opcode::VCVTPH2HF8SZ128rmbk,
          6674 => Opcode::VCVTPH2HF8SZ128rmbkz,
          6675 => Opcode::VCVTPH2HF8SZ128rmk,
          6676 => Opcode::VCVTPH2HF8SZ128rmkz,
          6677 => Opcode::VCVTPH2HF8SZ128rr,
          6678 => Opcode::VCVTPH2HF8SZ128rrk,
          6679 => Opcode::VCVTPH2HF8SZ128rrkz,
          6680 => Opcode::VCVTPH2HF8SZ256rm,
          6681 => Opcode::VCVTPH2HF8SZ256rmb,
          6682 => Opcode::VCVTPH2HF8SZ256rmbk,
          6683 => Opcode::VCVTPH2HF8SZ256rmbkz,
          6684 => Opcode::VCVTPH2HF8SZ256rmk,
          6685 => Opcode::VCVTPH2HF8SZ256rmkz,
          6686 => Opcode::VCVTPH2HF8SZ256rr,
          6687 => Opcode::VCVTPH2HF8SZ256rrk,
          6688 => Opcode::VCVTPH2HF8SZ256rrkz,
          6689 => Opcode::VCVTPH2HF8SZrm,
          6690 => Opcode::VCVTPH2HF8SZrmb,
          6691 => Opcode::VCVTPH2HF8SZrmbk,
          6692 => Opcode::VCVTPH2HF8SZrmbkz,
          6693 => Opcode::VCVTPH2HF8SZrmk,
          6694 => Opcode::VCVTPH2HF8SZrmkz,
          6695 => Opcode::VCVTPH2HF8SZrr,
          6696 => Opcode::VCVTPH2HF8SZrrk,
          6697 => Opcode::VCVTPH2HF8SZrrkz,
          6698 => Opcode::VCVTPH2HF8Z128rm,
          6699 => Opcode::VCVTPH2HF8Z128rmb,
          6700 => Opcode::VCVTPH2HF8Z128rmbk,
          6701 => Opcode::VCVTPH2HF8Z128rmbkz,
          6702 => Opcode::VCVTPH2HF8Z128rmk,
          6703 => Opcode::VCVTPH2HF8Z128rmkz,
          6704 => Opcode::VCVTPH2HF8Z128rr,
          6705 => Opcode::VCVTPH2HF8Z128rrk,
          6706 => Opcode::VCVTPH2HF8Z128rrkz,
          6707 => Opcode::VCVTPH2HF8Z256rm,
          6708 => Opcode::VCVTPH2HF8Z256rmb,
          6709 => Opcode::VCVTPH2HF8Z256rmbk,
          6710 => Opcode::VCVTPH2HF8Z256rmbkz,
          6711 => Opcode::VCVTPH2HF8Z256rmk,
          6712 => Opcode::VCVTPH2HF8Z256rmkz,
          6713 => Opcode::VCVTPH2HF8Z256rr,
          6714 => Opcode::VCVTPH2HF8Z256rrk,
          6715 => Opcode::VCVTPH2HF8Z256rrkz,
          6716 => Opcode::VCVTPH2HF8Zrm,
          6717 => Opcode::VCVTPH2HF8Zrmb,
          6718 => Opcode::VCVTPH2HF8Zrmbk,
          6719 => Opcode::VCVTPH2HF8Zrmbkz,
          6720 => Opcode::VCVTPH2HF8Zrmk,
          6721 => Opcode::VCVTPH2HF8Zrmkz,
          6722 => Opcode::VCVTPH2HF8Zrr,
          6723 => Opcode::VCVTPH2HF8Zrrk,
          6724 => Opcode::VCVTPH2HF8Zrrkz,
          6725 => Opcode::VCVTPH2IBSZ128rm,
          6726 => Opcode::VCVTPH2IBSZ128rmb,
          6727 => Opcode::VCVTPH2IBSZ128rmbk,
          6728 => Opcode::VCVTPH2IBSZ128rmbkz,
          6729 => Opcode::VCVTPH2IBSZ128rmk,
          6730 => Opcode::VCVTPH2IBSZ128rmkz,
          6731 => Opcode::VCVTPH2IBSZ128rr,
          6732 => Opcode::VCVTPH2IBSZ128rrk,
          6733 => Opcode::VCVTPH2IBSZ128rrkz,
          6734 => Opcode::VCVTPH2IBSZ256rm,
          6735 => Opcode::VCVTPH2IBSZ256rmb,
          6736 => Opcode::VCVTPH2IBSZ256rmbk,
          6737 => Opcode::VCVTPH2IBSZ256rmbkz,
          6738 => Opcode::VCVTPH2IBSZ256rmk,
          6739 => Opcode::VCVTPH2IBSZ256rmkz,
          6740 => Opcode::VCVTPH2IBSZ256rr,
          6741 => Opcode::VCVTPH2IBSZ256rrk,
          6742 => Opcode::VCVTPH2IBSZ256rrkz,
          6743 => Opcode::VCVTPH2IBSZrm,
          6744 => Opcode::VCVTPH2IBSZrmb,
          6745 => Opcode::VCVTPH2IBSZrmbk,
          6746 => Opcode::VCVTPH2IBSZrmbkz,
          6747 => Opcode::VCVTPH2IBSZrmk,
          6748 => Opcode::VCVTPH2IBSZrmkz,
          6749 => Opcode::VCVTPH2IBSZrr,
          6750 => Opcode::VCVTPH2IBSZrrb,
          6751 => Opcode::VCVTPH2IBSZrrbk,
          6752 => Opcode::VCVTPH2IBSZrrbkz,
          6753 => Opcode::VCVTPH2IBSZrrk,
          6754 => Opcode::VCVTPH2IBSZrrkz,
          6755 => Opcode::VCVTPH2IUBSZ128rm,
          6756 => Opcode::VCVTPH2IUBSZ128rmb,
          6757 => Opcode::VCVTPH2IUBSZ128rmbk,
          6758 => Opcode::VCVTPH2IUBSZ128rmbkz,
          6759 => Opcode::VCVTPH2IUBSZ128rmk,
          6760 => Opcode::VCVTPH2IUBSZ128rmkz,
          6761 => Opcode::VCVTPH2IUBSZ128rr,
          6762 => Opcode::VCVTPH2IUBSZ128rrk,
          6763 => Opcode::VCVTPH2IUBSZ128rrkz,
          6764 => Opcode::VCVTPH2IUBSZ256rm,
          6765 => Opcode::VCVTPH2IUBSZ256rmb,
          6766 => Opcode::VCVTPH2IUBSZ256rmbk,
          6767 => Opcode::VCVTPH2IUBSZ256rmbkz,
          6768 => Opcode::VCVTPH2IUBSZ256rmk,
          6769 => Opcode::VCVTPH2IUBSZ256rmkz,
          6770 => Opcode::VCVTPH2IUBSZ256rr,
          6771 => Opcode::VCVTPH2IUBSZ256rrk,
          6772 => Opcode::VCVTPH2IUBSZ256rrkz,
          6773 => Opcode::VCVTPH2IUBSZrm,
          6774 => Opcode::VCVTPH2IUBSZrmb,
          6775 => Opcode::VCVTPH2IUBSZrmbk,
          6776 => Opcode::VCVTPH2IUBSZrmbkz,
          6777 => Opcode::VCVTPH2IUBSZrmk,
          6778 => Opcode::VCVTPH2IUBSZrmkz,
          6779 => Opcode::VCVTPH2IUBSZrr,
          6780 => Opcode::VCVTPH2IUBSZrrb,
          6781 => Opcode::VCVTPH2IUBSZrrbk,
          6782 => Opcode::VCVTPH2IUBSZrrbkz,
          6783 => Opcode::VCVTPH2IUBSZrrk,
          6784 => Opcode::VCVTPH2IUBSZrrkz,
          6785 => Opcode::VCVTPH2PDZ128rm,
          6786 => Opcode::VCVTPH2PDZ128rmb,
          6787 => Opcode::VCVTPH2PDZ128rmbk,
          6788 => Opcode::VCVTPH2PDZ128rmbkz,
          6789 => Opcode::VCVTPH2PDZ128rmk,
          6790 => Opcode::VCVTPH2PDZ128rmkz,
          6791 => Opcode::VCVTPH2PDZ128rr,
          6792 => Opcode::VCVTPH2PDZ128rrk,
          6793 => Opcode::VCVTPH2PDZ128rrkz,
          6794 => Opcode::VCVTPH2PDZ256rm,
          6795 => Opcode::VCVTPH2PDZ256rmb,
          6796 => Opcode::VCVTPH2PDZ256rmbk,
          6797 => Opcode::VCVTPH2PDZ256rmbkz,
          6798 => Opcode::VCVTPH2PDZ256rmk,
          6799 => Opcode::VCVTPH2PDZ256rmkz,
          6800 => Opcode::VCVTPH2PDZ256rr,
          6801 => Opcode::VCVTPH2PDZ256rrk,
          6802 => Opcode::VCVTPH2PDZ256rrkz,
          6803 => Opcode::VCVTPH2PDZrm,
          6804 => Opcode::VCVTPH2PDZrmb,
          6805 => Opcode::VCVTPH2PDZrmbk,
          6806 => Opcode::VCVTPH2PDZrmbkz,
          6807 => Opcode::VCVTPH2PDZrmk,
          6808 => Opcode::VCVTPH2PDZrmkz,
          6809 => Opcode::VCVTPH2PDZrr,
          6810 => Opcode::VCVTPH2PDZrrb,
          6811 => Opcode::VCVTPH2PDZrrbk,
          6812 => Opcode::VCVTPH2PDZrrbkz,
          6813 => Opcode::VCVTPH2PDZrrk,
          6814 => Opcode::VCVTPH2PDZrrkz,
          6815 => Opcode::VCVTPH2PSXZ128rm,
          6816 => Opcode::VCVTPH2PSXZ128rmb,
          6817 => Opcode::VCVTPH2PSXZ128rmbk,
          6818 => Opcode::VCVTPH2PSXZ128rmbkz,
          6819 => Opcode::VCVTPH2PSXZ128rmk,
          6820 => Opcode::VCVTPH2PSXZ128rmkz,
          6821 => Opcode::VCVTPH2PSXZ128rr,
          6822 => Opcode::VCVTPH2PSXZ128rrk,
          6823 => Opcode::VCVTPH2PSXZ128rrkz,
          6824 => Opcode::VCVTPH2PSXZ256rm,
          6825 => Opcode::VCVTPH2PSXZ256rmb,
          6826 => Opcode::VCVTPH2PSXZ256rmbk,
          6827 => Opcode::VCVTPH2PSXZ256rmbkz,
          6828 => Opcode::VCVTPH2PSXZ256rmk,
          6829 => Opcode::VCVTPH2PSXZ256rmkz,
          6830 => Opcode::VCVTPH2PSXZ256rr,
          6831 => Opcode::VCVTPH2PSXZ256rrk,
          6832 => Opcode::VCVTPH2PSXZ256rrkz,
          6833 => Opcode::VCVTPH2PSXZrm,
          6834 => Opcode::VCVTPH2PSXZrmb,
          6835 => Opcode::VCVTPH2PSXZrmbk,
          6836 => Opcode::VCVTPH2PSXZrmbkz,
          6837 => Opcode::VCVTPH2PSXZrmk,
          6838 => Opcode::VCVTPH2PSXZrmkz,
          6839 => Opcode::VCVTPH2PSXZrr,
          6840 => Opcode::VCVTPH2PSXZrrb,
          6841 => Opcode::VCVTPH2PSXZrrbk,
          6842 => Opcode::VCVTPH2PSXZrrbkz,
          6843 => Opcode::VCVTPH2PSXZrrk,
          6844 => Opcode::VCVTPH2PSXZrrkz,
          6845 => Opcode::VCVTPH2PSYrm,
          6846 => Opcode::VCVTPH2PSYrr,
          6847 => Opcode::VCVTPH2PSZ128rm,
          6848 => Opcode::VCVTPH2PSZ128rmk,
          6849 => Opcode::VCVTPH2PSZ128rmkz,
          6850 => Opcode::VCVTPH2PSZ128rr,
          6851 => Opcode::VCVTPH2PSZ128rrk,
          6852 => Opcode::VCVTPH2PSZ128rrkz,
          6853 => Opcode::VCVTPH2PSZ256rm,
          6854 => Opcode::VCVTPH2PSZ256rmk,
          6855 => Opcode::VCVTPH2PSZ256rmkz,
          6856 => Opcode::VCVTPH2PSZ256rr,
          6857 => Opcode::VCVTPH2PSZ256rrk,
          6858 => Opcode::VCVTPH2PSZ256rrkz,
          6859 => Opcode::VCVTPH2PSZrm,
          6860 => Opcode::VCVTPH2PSZrmk,
          6861 => Opcode::VCVTPH2PSZrmkz,
          6862 => Opcode::VCVTPH2PSZrr,
          6863 => Opcode::VCVTPH2PSZrrb,
          6864 => Opcode::VCVTPH2PSZrrbk,
          6865 => Opcode::VCVTPH2PSZrrbkz,
          6866 => Opcode::VCVTPH2PSZrrk,
          6867 => Opcode::VCVTPH2PSZrrkz,
          6868 => Opcode::VCVTPH2PSrm,
          6869 => Opcode::VCVTPH2PSrr,
          6870 => Opcode::VCVTPH2QQZ128rm,
          6871 => Opcode::VCVTPH2QQZ128rmb,
          6872 => Opcode::VCVTPH2QQZ128rmbk,
          6873 => Opcode::VCVTPH2QQZ128rmbkz,
          6874 => Opcode::VCVTPH2QQZ128rmk,
          6875 => Opcode::VCVTPH2QQZ128rmkz,
          6876 => Opcode::VCVTPH2QQZ128rr,
          6877 => Opcode::VCVTPH2QQZ128rrk,
          6878 => Opcode::VCVTPH2QQZ128rrkz,
          6879 => Opcode::VCVTPH2QQZ256rm,
          6880 => Opcode::VCVTPH2QQZ256rmb,
          6881 => Opcode::VCVTPH2QQZ256rmbk,
          6882 => Opcode::VCVTPH2QQZ256rmbkz,
          6883 => Opcode::VCVTPH2QQZ256rmk,
          6884 => Opcode::VCVTPH2QQZ256rmkz,
          6885 => Opcode::VCVTPH2QQZ256rr,
          6886 => Opcode::VCVTPH2QQZ256rrk,
          6887 => Opcode::VCVTPH2QQZ256rrkz,
          6888 => Opcode::VCVTPH2QQZrm,
          6889 => Opcode::VCVTPH2QQZrmb,
          6890 => Opcode::VCVTPH2QQZrmbk,
          6891 => Opcode::VCVTPH2QQZrmbkz,
          6892 => Opcode::VCVTPH2QQZrmk,
          6893 => Opcode::VCVTPH2QQZrmkz,
          6894 => Opcode::VCVTPH2QQZrr,
          6895 => Opcode::VCVTPH2QQZrrb,
          6896 => Opcode::VCVTPH2QQZrrbk,
          6897 => Opcode::VCVTPH2QQZrrbkz,
          6898 => Opcode::VCVTPH2QQZrrk,
          6899 => Opcode::VCVTPH2QQZrrkz,
          6900 => Opcode::VCVTPH2UDQZ128rm,
          6901 => Opcode::VCVTPH2UDQZ128rmb,
          6902 => Opcode::VCVTPH2UDQZ128rmbk,
          6903 => Opcode::VCVTPH2UDQZ128rmbkz,
          6904 => Opcode::VCVTPH2UDQZ128rmk,
          6905 => Opcode::VCVTPH2UDQZ128rmkz,
          6906 => Opcode::VCVTPH2UDQZ128rr,
          6907 => Opcode::VCVTPH2UDQZ128rrk,
          6908 => Opcode::VCVTPH2UDQZ128rrkz,
          6909 => Opcode::VCVTPH2UDQZ256rm,
          6910 => Opcode::VCVTPH2UDQZ256rmb,
          6911 => Opcode::VCVTPH2UDQZ256rmbk,
          6912 => Opcode::VCVTPH2UDQZ256rmbkz,
          6913 => Opcode::VCVTPH2UDQZ256rmk,
          6914 => Opcode::VCVTPH2UDQZ256rmkz,
          6915 => Opcode::VCVTPH2UDQZ256rr,
          6916 => Opcode::VCVTPH2UDQZ256rrk,
          6917 => Opcode::VCVTPH2UDQZ256rrkz,
          6918 => Opcode::VCVTPH2UDQZrm,
          6919 => Opcode::VCVTPH2UDQZrmb,
          6920 => Opcode::VCVTPH2UDQZrmbk,
          6921 => Opcode::VCVTPH2UDQZrmbkz,
          6922 => Opcode::VCVTPH2UDQZrmk,
          6923 => Opcode::VCVTPH2UDQZrmkz,
          6924 => Opcode::VCVTPH2UDQZrr,
          6925 => Opcode::VCVTPH2UDQZrrb,
          6926 => Opcode::VCVTPH2UDQZrrbk,
          6927 => Opcode::VCVTPH2UDQZrrbkz,
          6928 => Opcode::VCVTPH2UDQZrrk,
          6929 => Opcode::VCVTPH2UDQZrrkz,
          6930 => Opcode::VCVTPH2UQQZ128rm,
          6931 => Opcode::VCVTPH2UQQZ128rmb,
          6932 => Opcode::VCVTPH2UQQZ128rmbk,
          6933 => Opcode::VCVTPH2UQQZ128rmbkz,
          6934 => Opcode::VCVTPH2UQQZ128rmk,
          6935 => Opcode::VCVTPH2UQQZ128rmkz,
          6936 => Opcode::VCVTPH2UQQZ128rr,
          6937 => Opcode::VCVTPH2UQQZ128rrk,
          6938 => Opcode::VCVTPH2UQQZ128rrkz,
          6939 => Opcode::VCVTPH2UQQZ256rm,
          6940 => Opcode::VCVTPH2UQQZ256rmb,
          6941 => Opcode::VCVTPH2UQQZ256rmbk,
          6942 => Opcode::VCVTPH2UQQZ256rmbkz,
          6943 => Opcode::VCVTPH2UQQZ256rmk,
          6944 => Opcode::VCVTPH2UQQZ256rmkz,
          6945 => Opcode::VCVTPH2UQQZ256rr,
          6946 => Opcode::VCVTPH2UQQZ256rrk,
          6947 => Opcode::VCVTPH2UQQZ256rrkz,
          6948 => Opcode::VCVTPH2UQQZrm,
          6949 => Opcode::VCVTPH2UQQZrmb,
          6950 => Opcode::VCVTPH2UQQZrmbk,
          6951 => Opcode::VCVTPH2UQQZrmbkz,
          6952 => Opcode::VCVTPH2UQQZrmk,
          6953 => Opcode::VCVTPH2UQQZrmkz,
          6954 => Opcode::VCVTPH2UQQZrr,
          6955 => Opcode::VCVTPH2UQQZrrb,
          6956 => Opcode::VCVTPH2UQQZrrbk,
          6957 => Opcode::VCVTPH2UQQZrrbkz,
          6958 => Opcode::VCVTPH2UQQZrrk,
          6959 => Opcode::VCVTPH2UQQZrrkz,
          6960 => Opcode::VCVTPH2UWZ128rm,
          6961 => Opcode::VCVTPH2UWZ128rmb,
          6962 => Opcode::VCVTPH2UWZ128rmbk,
          6963 => Opcode::VCVTPH2UWZ128rmbkz,
          6964 => Opcode::VCVTPH2UWZ128rmk,
          6965 => Opcode::VCVTPH2UWZ128rmkz,
          6966 => Opcode::VCVTPH2UWZ128rr,
          6967 => Opcode::VCVTPH2UWZ128rrk,
          6968 => Opcode::VCVTPH2UWZ128rrkz,
          6969 => Opcode::VCVTPH2UWZ256rm,
          6970 => Opcode::VCVTPH2UWZ256rmb,
          6971 => Opcode::VCVTPH2UWZ256rmbk,
          6972 => Opcode::VCVTPH2UWZ256rmbkz,
          6973 => Opcode::VCVTPH2UWZ256rmk,
          6974 => Opcode::VCVTPH2UWZ256rmkz,
          6975 => Opcode::VCVTPH2UWZ256rr,
          6976 => Opcode::VCVTPH2UWZ256rrk,
          6977 => Opcode::VCVTPH2UWZ256rrkz,
          6978 => Opcode::VCVTPH2UWZrm,
          6979 => Opcode::VCVTPH2UWZrmb,
          6980 => Opcode::VCVTPH2UWZrmbk,
          6981 => Opcode::VCVTPH2UWZrmbkz,
          6982 => Opcode::VCVTPH2UWZrmk,
          6983 => Opcode::VCVTPH2UWZrmkz,
          6984 => Opcode::VCVTPH2UWZrr,
          6985 => Opcode::VCVTPH2UWZrrb,
          6986 => Opcode::VCVTPH2UWZrrbk,
          6987 => Opcode::VCVTPH2UWZrrbkz,
          6988 => Opcode::VCVTPH2UWZrrk,
          6989 => Opcode::VCVTPH2UWZrrkz,
          6990 => Opcode::VCVTPH2WZ128rm,
          6991 => Opcode::VCVTPH2WZ128rmb,
          6992 => Opcode::VCVTPH2WZ128rmbk,
          6993 => Opcode::VCVTPH2WZ128rmbkz,
          6994 => Opcode::VCVTPH2WZ128rmk,
          6995 => Opcode::VCVTPH2WZ128rmkz,
          6996 => Opcode::VCVTPH2WZ128rr,
          6997 => Opcode::VCVTPH2WZ128rrk,
          6998 => Opcode::VCVTPH2WZ128rrkz,
          6999 => Opcode::VCVTPH2WZ256rm,
          7000 => Opcode::VCVTPH2WZ256rmb,
          7001 => Opcode::VCVTPH2WZ256rmbk,
          7002 => Opcode::VCVTPH2WZ256rmbkz,
          7003 => Opcode::VCVTPH2WZ256rmk,
          7004 => Opcode::VCVTPH2WZ256rmkz,
          7005 => Opcode::VCVTPH2WZ256rr,
          7006 => Opcode::VCVTPH2WZ256rrk,
          7007 => Opcode::VCVTPH2WZ256rrkz,
          7008 => Opcode::VCVTPH2WZrm,
          7009 => Opcode::VCVTPH2WZrmb,
          7010 => Opcode::VCVTPH2WZrmbk,
          7011 => Opcode::VCVTPH2WZrmbkz,
          7012 => Opcode::VCVTPH2WZrmk,
          7013 => Opcode::VCVTPH2WZrmkz,
          7014 => Opcode::VCVTPH2WZrr,
          7015 => Opcode::VCVTPH2WZrrb,
          7016 => Opcode::VCVTPH2WZrrbk,
          7017 => Opcode::VCVTPH2WZrrbkz,
          7018 => Opcode::VCVTPH2WZrrk,
          7019 => Opcode::VCVTPH2WZrrkz,
          7020 => Opcode::VCVTPS2DQYrm,
          7021 => Opcode::VCVTPS2DQYrr,
          7022 => Opcode::VCVTPS2DQZ128rm,
          7023 => Opcode::VCVTPS2DQZ128rmb,
          7024 => Opcode::VCVTPS2DQZ128rmbk,
          7025 => Opcode::VCVTPS2DQZ128rmbkz,
          7026 => Opcode::VCVTPS2DQZ128rmk,
          7027 => Opcode::VCVTPS2DQZ128rmkz,
          7028 => Opcode::VCVTPS2DQZ128rr,
          7029 => Opcode::VCVTPS2DQZ128rrk,
          7030 => Opcode::VCVTPS2DQZ128rrkz,
          7031 => Opcode::VCVTPS2DQZ256rm,
          7032 => Opcode::VCVTPS2DQZ256rmb,
          7033 => Opcode::VCVTPS2DQZ256rmbk,
          7034 => Opcode::VCVTPS2DQZ256rmbkz,
          7035 => Opcode::VCVTPS2DQZ256rmk,
          7036 => Opcode::VCVTPS2DQZ256rmkz,
          7037 => Opcode::VCVTPS2DQZ256rr,
          7038 => Opcode::VCVTPS2DQZ256rrk,
          7039 => Opcode::VCVTPS2DQZ256rrkz,
          7040 => Opcode::VCVTPS2DQZrm,
          7041 => Opcode::VCVTPS2DQZrmb,
          7042 => Opcode::VCVTPS2DQZrmbk,
          7043 => Opcode::VCVTPS2DQZrmbkz,
          7044 => Opcode::VCVTPS2DQZrmk,
          7045 => Opcode::VCVTPS2DQZrmkz,
          7046 => Opcode::VCVTPS2DQZrr,
          7047 => Opcode::VCVTPS2DQZrrb,
          7048 => Opcode::VCVTPS2DQZrrbk,
          7049 => Opcode::VCVTPS2DQZrrbkz,
          7050 => Opcode::VCVTPS2DQZrrk,
          7051 => Opcode::VCVTPS2DQZrrkz,
          7052 => Opcode::VCVTPS2DQrm,
          7053 => Opcode::VCVTPS2DQrr,
          7054 => Opcode::VCVTPS2IBSZ128rm,
          7055 => Opcode::VCVTPS2IBSZ128rmb,
          7056 => Opcode::VCVTPS2IBSZ128rmbk,
          7057 => Opcode::VCVTPS2IBSZ128rmbkz,
          7058 => Opcode::VCVTPS2IBSZ128rmk,
          7059 => Opcode::VCVTPS2IBSZ128rmkz,
          7060 => Opcode::VCVTPS2IBSZ128rr,
          7061 => Opcode::VCVTPS2IBSZ128rrk,
          7062 => Opcode::VCVTPS2IBSZ128rrkz,
          7063 => Opcode::VCVTPS2IBSZ256rm,
          7064 => Opcode::VCVTPS2IBSZ256rmb,
          7065 => Opcode::VCVTPS2IBSZ256rmbk,
          7066 => Opcode::VCVTPS2IBSZ256rmbkz,
          7067 => Opcode::VCVTPS2IBSZ256rmk,
          7068 => Opcode::VCVTPS2IBSZ256rmkz,
          7069 => Opcode::VCVTPS2IBSZ256rr,
          7070 => Opcode::VCVTPS2IBSZ256rrk,
          7071 => Opcode::VCVTPS2IBSZ256rrkz,
          7072 => Opcode::VCVTPS2IBSZrm,
          7073 => Opcode::VCVTPS2IBSZrmb,
          7074 => Opcode::VCVTPS2IBSZrmbk,
          7075 => Opcode::VCVTPS2IBSZrmbkz,
          7076 => Opcode::VCVTPS2IBSZrmk,
          7077 => Opcode::VCVTPS2IBSZrmkz,
          7078 => Opcode::VCVTPS2IBSZrr,
          7079 => Opcode::VCVTPS2IBSZrrb,
          7080 => Opcode::VCVTPS2IBSZrrbk,
          7081 => Opcode::VCVTPS2IBSZrrbkz,
          7082 => Opcode::VCVTPS2IBSZrrk,
          7083 => Opcode::VCVTPS2IBSZrrkz,
          7084 => Opcode::VCVTPS2IUBSZ128rm,
          7085 => Opcode::VCVTPS2IUBSZ128rmb,
          7086 => Opcode::VCVTPS2IUBSZ128rmbk,
          7087 => Opcode::VCVTPS2IUBSZ128rmbkz,
          7088 => Opcode::VCVTPS2IUBSZ128rmk,
          7089 => Opcode::VCVTPS2IUBSZ128rmkz,
          7090 => Opcode::VCVTPS2IUBSZ128rr,
          7091 => Opcode::VCVTPS2IUBSZ128rrk,
          7092 => Opcode::VCVTPS2IUBSZ128rrkz,
          7093 => Opcode::VCVTPS2IUBSZ256rm,
          7094 => Opcode::VCVTPS2IUBSZ256rmb,
          7095 => Opcode::VCVTPS2IUBSZ256rmbk,
          7096 => Opcode::VCVTPS2IUBSZ256rmbkz,
          7097 => Opcode::VCVTPS2IUBSZ256rmk,
          7098 => Opcode::VCVTPS2IUBSZ256rmkz,
          7099 => Opcode::VCVTPS2IUBSZ256rr,
          7100 => Opcode::VCVTPS2IUBSZ256rrk,
          7101 => Opcode::VCVTPS2IUBSZ256rrkz,
          7102 => Opcode::VCVTPS2IUBSZrm,
          7103 => Opcode::VCVTPS2IUBSZrmb,
          7104 => Opcode::VCVTPS2IUBSZrmbk,
          7105 => Opcode::VCVTPS2IUBSZrmbkz,
          7106 => Opcode::VCVTPS2IUBSZrmk,
          7107 => Opcode::VCVTPS2IUBSZrmkz,
          7108 => Opcode::VCVTPS2IUBSZrr,
          7109 => Opcode::VCVTPS2IUBSZrrb,
          7110 => Opcode::VCVTPS2IUBSZrrbk,
          7111 => Opcode::VCVTPS2IUBSZrrbkz,
          7112 => Opcode::VCVTPS2IUBSZrrk,
          7113 => Opcode::VCVTPS2IUBSZrrkz,
          7114 => Opcode::VCVTPS2PDYrm,
          7115 => Opcode::VCVTPS2PDYrr,
          7116 => Opcode::VCVTPS2PDZ128rm,
          7117 => Opcode::VCVTPS2PDZ128rmb,
          7118 => Opcode::VCVTPS2PDZ128rmbk,
          7119 => Opcode::VCVTPS2PDZ128rmbkz,
          7120 => Opcode::VCVTPS2PDZ128rmk,
          7121 => Opcode::VCVTPS2PDZ128rmkz,
          7122 => Opcode::VCVTPS2PDZ128rr,
          7123 => Opcode::VCVTPS2PDZ128rrk,
          7124 => Opcode::VCVTPS2PDZ128rrkz,
          7125 => Opcode::VCVTPS2PDZ256rm,
          7126 => Opcode::VCVTPS2PDZ256rmb,
          7127 => Opcode::VCVTPS2PDZ256rmbk,
          7128 => Opcode::VCVTPS2PDZ256rmbkz,
          7129 => Opcode::VCVTPS2PDZ256rmk,
          7130 => Opcode::VCVTPS2PDZ256rmkz,
          7131 => Opcode::VCVTPS2PDZ256rr,
          7132 => Opcode::VCVTPS2PDZ256rrk,
          7133 => Opcode::VCVTPS2PDZ256rrkz,
          7134 => Opcode::VCVTPS2PDZrm,
          7135 => Opcode::VCVTPS2PDZrmb,
          7136 => Opcode::VCVTPS2PDZrmbk,
          7137 => Opcode::VCVTPS2PDZrmbkz,
          7138 => Opcode::VCVTPS2PDZrmk,
          7139 => Opcode::VCVTPS2PDZrmkz,
          7140 => Opcode::VCVTPS2PDZrr,
          7141 => Opcode::VCVTPS2PDZrrb,
          7142 => Opcode::VCVTPS2PDZrrbk,
          7143 => Opcode::VCVTPS2PDZrrbkz,
          7144 => Opcode::VCVTPS2PDZrrk,
          7145 => Opcode::VCVTPS2PDZrrkz,
          7146 => Opcode::VCVTPS2PDrm,
          7147 => Opcode::VCVTPS2PDrr,
          7148 => Opcode::VCVTPS2PHXZ128rm,
          7149 => Opcode::VCVTPS2PHXZ128rmb,
          7150 => Opcode::VCVTPS2PHXZ128rmbk,
          7151 => Opcode::VCVTPS2PHXZ128rmbkz,
          7152 => Opcode::VCVTPS2PHXZ128rmk,
          7153 => Opcode::VCVTPS2PHXZ128rmkz,
          7154 => Opcode::VCVTPS2PHXZ128rr,
          7155 => Opcode::VCVTPS2PHXZ128rrk,
          7156 => Opcode::VCVTPS2PHXZ128rrkz,
          7157 => Opcode::VCVTPS2PHXZ256rm,
          7158 => Opcode::VCVTPS2PHXZ256rmb,
          7159 => Opcode::VCVTPS2PHXZ256rmbk,
          7160 => Opcode::VCVTPS2PHXZ256rmbkz,
          7161 => Opcode::VCVTPS2PHXZ256rmk,
          7162 => Opcode::VCVTPS2PHXZ256rmkz,
          7163 => Opcode::VCVTPS2PHXZ256rr,
          7164 => Opcode::VCVTPS2PHXZ256rrk,
          7165 => Opcode::VCVTPS2PHXZ256rrkz,
          7166 => Opcode::VCVTPS2PHXZrm,
          7167 => Opcode::VCVTPS2PHXZrmb,
          7168 => Opcode::VCVTPS2PHXZrmbk,
          7169 => Opcode::VCVTPS2PHXZrmbkz,
          7170 => Opcode::VCVTPS2PHXZrmk,
          7171 => Opcode::VCVTPS2PHXZrmkz,
          7172 => Opcode::VCVTPS2PHXZrr,
          7173 => Opcode::VCVTPS2PHXZrrb,
          7174 => Opcode::VCVTPS2PHXZrrbk,
          7175 => Opcode::VCVTPS2PHXZrrbkz,
          7176 => Opcode::VCVTPS2PHXZrrk,
          7177 => Opcode::VCVTPS2PHXZrrkz,
          7178 => Opcode::VCVTPS2PHYmr,
          7179 => Opcode::VCVTPS2PHYrr,
          7180 => Opcode::VCVTPS2PHZ128mr,
          7181 => Opcode::VCVTPS2PHZ128mrk,
          7182 => Opcode::VCVTPS2PHZ128rr,
          7183 => Opcode::VCVTPS2PHZ128rrk,
          7184 => Opcode::VCVTPS2PHZ128rrkz,
          7185 => Opcode::VCVTPS2PHZ256mr,
          7186 => Opcode::VCVTPS2PHZ256mrk,
          7187 => Opcode::VCVTPS2PHZ256rr,
          7188 => Opcode::VCVTPS2PHZ256rrk,
          7189 => Opcode::VCVTPS2PHZ256rrkz,
          7190 => Opcode::VCVTPS2PHZmr,
          7191 => Opcode::VCVTPS2PHZmrk,
          7192 => Opcode::VCVTPS2PHZrr,
          7193 => Opcode::VCVTPS2PHZrrb,
          7194 => Opcode::VCVTPS2PHZrrbk,
          7195 => Opcode::VCVTPS2PHZrrbkz,
          7196 => Opcode::VCVTPS2PHZrrk,
          7197 => Opcode::VCVTPS2PHZrrkz,
          7198 => Opcode::VCVTPS2PHmr,
          7199 => Opcode::VCVTPS2PHrr,
          7200 => Opcode::VCVTPS2QQZ128rm,
          7201 => Opcode::VCVTPS2QQZ128rmb,
          7202 => Opcode::VCVTPS2QQZ128rmbk,
          7203 => Opcode::VCVTPS2QQZ128rmbkz,
          7204 => Opcode::VCVTPS2QQZ128rmk,
          7205 => Opcode::VCVTPS2QQZ128rmkz,
          7206 => Opcode::VCVTPS2QQZ128rr,
          7207 => Opcode::VCVTPS2QQZ128rrk,
          7208 => Opcode::VCVTPS2QQZ128rrkz,
          7209 => Opcode::VCVTPS2QQZ256rm,
          7210 => Opcode::VCVTPS2QQZ256rmb,
          7211 => Opcode::VCVTPS2QQZ256rmbk,
          7212 => Opcode::VCVTPS2QQZ256rmbkz,
          7213 => Opcode::VCVTPS2QQZ256rmk,
          7214 => Opcode::VCVTPS2QQZ256rmkz,
          7215 => Opcode::VCVTPS2QQZ256rr,
          7216 => Opcode::VCVTPS2QQZ256rrk,
          7217 => Opcode::VCVTPS2QQZ256rrkz,
          7218 => Opcode::VCVTPS2QQZrm,
          7219 => Opcode::VCVTPS2QQZrmb,
          7220 => Opcode::VCVTPS2QQZrmbk,
          7221 => Opcode::VCVTPS2QQZrmbkz,
          7222 => Opcode::VCVTPS2QQZrmk,
          7223 => Opcode::VCVTPS2QQZrmkz,
          7224 => Opcode::VCVTPS2QQZrr,
          7225 => Opcode::VCVTPS2QQZrrb,
          7226 => Opcode::VCVTPS2QQZrrbk,
          7227 => Opcode::VCVTPS2QQZrrbkz,
          7228 => Opcode::VCVTPS2QQZrrk,
          7229 => Opcode::VCVTPS2QQZrrkz,
          7230 => Opcode::VCVTPS2UDQZ128rm,
          7231 => Opcode::VCVTPS2UDQZ128rmb,
          7232 => Opcode::VCVTPS2UDQZ128rmbk,
          7233 => Opcode::VCVTPS2UDQZ128rmbkz,
          7234 => Opcode::VCVTPS2UDQZ128rmk,
          7235 => Opcode::VCVTPS2UDQZ128rmkz,
          7236 => Opcode::VCVTPS2UDQZ128rr,
          7237 => Opcode::VCVTPS2UDQZ128rrk,
          7238 => Opcode::VCVTPS2UDQZ128rrkz,
          7239 => Opcode::VCVTPS2UDQZ256rm,
          7240 => Opcode::VCVTPS2UDQZ256rmb,
          7241 => Opcode::VCVTPS2UDQZ256rmbk,
          7242 => Opcode::VCVTPS2UDQZ256rmbkz,
          7243 => Opcode::VCVTPS2UDQZ256rmk,
          7244 => Opcode::VCVTPS2UDQZ256rmkz,
          7245 => Opcode::VCVTPS2UDQZ256rr,
          7246 => Opcode::VCVTPS2UDQZ256rrk,
          7247 => Opcode::VCVTPS2UDQZ256rrkz,
          7248 => Opcode::VCVTPS2UDQZrm,
          7249 => Opcode::VCVTPS2UDQZrmb,
          7250 => Opcode::VCVTPS2UDQZrmbk,
          7251 => Opcode::VCVTPS2UDQZrmbkz,
          7252 => Opcode::VCVTPS2UDQZrmk,
          7253 => Opcode::VCVTPS2UDQZrmkz,
          7254 => Opcode::VCVTPS2UDQZrr,
          7255 => Opcode::VCVTPS2UDQZrrb,
          7256 => Opcode::VCVTPS2UDQZrrbk,
          7257 => Opcode::VCVTPS2UDQZrrbkz,
          7258 => Opcode::VCVTPS2UDQZrrk,
          7259 => Opcode::VCVTPS2UDQZrrkz,
          7260 => Opcode::VCVTPS2UQQZ128rm,
          7261 => Opcode::VCVTPS2UQQZ128rmb,
          7262 => Opcode::VCVTPS2UQQZ128rmbk,
          7263 => Opcode::VCVTPS2UQQZ128rmbkz,
          7264 => Opcode::VCVTPS2UQQZ128rmk,
          7265 => Opcode::VCVTPS2UQQZ128rmkz,
          7266 => Opcode::VCVTPS2UQQZ128rr,
          7267 => Opcode::VCVTPS2UQQZ128rrk,
          7268 => Opcode::VCVTPS2UQQZ128rrkz,
          7269 => Opcode::VCVTPS2UQQZ256rm,
          7270 => Opcode::VCVTPS2UQQZ256rmb,
          7271 => Opcode::VCVTPS2UQQZ256rmbk,
          7272 => Opcode::VCVTPS2UQQZ256rmbkz,
          7273 => Opcode::VCVTPS2UQQZ256rmk,
          7274 => Opcode::VCVTPS2UQQZ256rmkz,
          7275 => Opcode::VCVTPS2UQQZ256rr,
          7276 => Opcode::VCVTPS2UQQZ256rrk,
          7277 => Opcode::VCVTPS2UQQZ256rrkz,
          7278 => Opcode::VCVTPS2UQQZrm,
          7279 => Opcode::VCVTPS2UQQZrmb,
          7280 => Opcode::VCVTPS2UQQZrmbk,
          7281 => Opcode::VCVTPS2UQQZrmbkz,
          7282 => Opcode::VCVTPS2UQQZrmk,
          7283 => Opcode::VCVTPS2UQQZrmkz,
          7284 => Opcode::VCVTPS2UQQZrr,
          7285 => Opcode::VCVTPS2UQQZrrb,
          7286 => Opcode::VCVTPS2UQQZrrbk,
          7287 => Opcode::VCVTPS2UQQZrrbkz,
          7288 => Opcode::VCVTPS2UQQZrrk,
          7289 => Opcode::VCVTPS2UQQZrrkz,
          7290 => Opcode::VCVTQQ2PDZ128rm,
          7291 => Opcode::VCVTQQ2PDZ128rmb,
          7292 => Opcode::VCVTQQ2PDZ128rmbk,
          7293 => Opcode::VCVTQQ2PDZ128rmbkz,
          7294 => Opcode::VCVTQQ2PDZ128rmk,
          7295 => Opcode::VCVTQQ2PDZ128rmkz,
          7296 => Opcode::VCVTQQ2PDZ128rr,
          7297 => Opcode::VCVTQQ2PDZ128rrk,
          7298 => Opcode::VCVTQQ2PDZ128rrkz,
          7299 => Opcode::VCVTQQ2PDZ256rm,
          7300 => Opcode::VCVTQQ2PDZ256rmb,
          7301 => Opcode::VCVTQQ2PDZ256rmbk,
          7302 => Opcode::VCVTQQ2PDZ256rmbkz,
          7303 => Opcode::VCVTQQ2PDZ256rmk,
          7304 => Opcode::VCVTQQ2PDZ256rmkz,
          7305 => Opcode::VCVTQQ2PDZ256rr,
          7306 => Opcode::VCVTQQ2PDZ256rrk,
          7307 => Opcode::VCVTQQ2PDZ256rrkz,
          7308 => Opcode::VCVTQQ2PDZrm,
          7309 => Opcode::VCVTQQ2PDZrmb,
          7310 => Opcode::VCVTQQ2PDZrmbk,
          7311 => Opcode::VCVTQQ2PDZrmbkz,
          7312 => Opcode::VCVTQQ2PDZrmk,
          7313 => Opcode::VCVTQQ2PDZrmkz,
          7314 => Opcode::VCVTQQ2PDZrr,
          7315 => Opcode::VCVTQQ2PDZrrb,
          7316 => Opcode::VCVTQQ2PDZrrbk,
          7317 => Opcode::VCVTQQ2PDZrrbkz,
          7318 => Opcode::VCVTQQ2PDZrrk,
          7319 => Opcode::VCVTQQ2PDZrrkz,
          7320 => Opcode::VCVTQQ2PHZ128rm,
          7321 => Opcode::VCVTQQ2PHZ128rmb,
          7322 => Opcode::VCVTQQ2PHZ128rmbk,
          7323 => Opcode::VCVTQQ2PHZ128rmbkz,
          7324 => Opcode::VCVTQQ2PHZ128rmk,
          7325 => Opcode::VCVTQQ2PHZ128rmkz,
          7326 => Opcode::VCVTQQ2PHZ128rr,
          7327 => Opcode::VCVTQQ2PHZ128rrk,
          7328 => Opcode::VCVTQQ2PHZ128rrkz,
          7329 => Opcode::VCVTQQ2PHZ256rm,
          7330 => Opcode::VCVTQQ2PHZ256rmb,
          7331 => Opcode::VCVTQQ2PHZ256rmbk,
          7332 => Opcode::VCVTQQ2PHZ256rmbkz,
          7333 => Opcode::VCVTQQ2PHZ256rmk,
          7334 => Opcode::VCVTQQ2PHZ256rmkz,
          7335 => Opcode::VCVTQQ2PHZ256rr,
          7336 => Opcode::VCVTQQ2PHZ256rrk,
          7337 => Opcode::VCVTQQ2PHZ256rrkz,
          7338 => Opcode::VCVTQQ2PHZrm,
          7339 => Opcode::VCVTQQ2PHZrmb,
          7340 => Opcode::VCVTQQ2PHZrmbk,
          7341 => Opcode::VCVTQQ2PHZrmbkz,
          7342 => Opcode::VCVTQQ2PHZrmk,
          7343 => Opcode::VCVTQQ2PHZrmkz,
          7344 => Opcode::VCVTQQ2PHZrr,
          7345 => Opcode::VCVTQQ2PHZrrb,
          7346 => Opcode::VCVTQQ2PHZrrbk,
          7347 => Opcode::VCVTQQ2PHZrrbkz,
          7348 => Opcode::VCVTQQ2PHZrrk,
          7349 => Opcode::VCVTQQ2PHZrrkz,
          7350 => Opcode::VCVTQQ2PSZ128rm,
          7351 => Opcode::VCVTQQ2PSZ128rmb,
          7352 => Opcode::VCVTQQ2PSZ128rmbk,
          7353 => Opcode::VCVTQQ2PSZ128rmbkz,
          7354 => Opcode::VCVTQQ2PSZ128rmk,
          7355 => Opcode::VCVTQQ2PSZ128rmkz,
          7356 => Opcode::VCVTQQ2PSZ128rr,
          7357 => Opcode::VCVTQQ2PSZ128rrk,
          7358 => Opcode::VCVTQQ2PSZ128rrkz,
          7359 => Opcode::VCVTQQ2PSZ256rm,
          7360 => Opcode::VCVTQQ2PSZ256rmb,
          7361 => Opcode::VCVTQQ2PSZ256rmbk,
          7362 => Opcode::VCVTQQ2PSZ256rmbkz,
          7363 => Opcode::VCVTQQ2PSZ256rmk,
          7364 => Opcode::VCVTQQ2PSZ256rmkz,
          7365 => Opcode::VCVTQQ2PSZ256rr,
          7366 => Opcode::VCVTQQ2PSZ256rrk,
          7367 => Opcode::VCVTQQ2PSZ256rrkz,
          7368 => Opcode::VCVTQQ2PSZrm,
          7369 => Opcode::VCVTQQ2PSZrmb,
          7370 => Opcode::VCVTQQ2PSZrmbk,
          7371 => Opcode::VCVTQQ2PSZrmbkz,
          7372 => Opcode::VCVTQQ2PSZrmk,
          7373 => Opcode::VCVTQQ2PSZrmkz,
          7374 => Opcode::VCVTQQ2PSZrr,
          7375 => Opcode::VCVTQQ2PSZrrb,
          7376 => Opcode::VCVTQQ2PSZrrbk,
          7377 => Opcode::VCVTQQ2PSZrrbkz,
          7378 => Opcode::VCVTQQ2PSZrrk,
          7379 => Opcode::VCVTQQ2PSZrrkz,
          7380 => Opcode::VCVTSD2SHZrm,
          7381 => Opcode::VCVTSD2SHZrm_Int,
          7382 => Opcode::VCVTSD2SHZrmk_Int,
          7383 => Opcode::VCVTSD2SHZrmkz_Int,
          7384 => Opcode::VCVTSD2SHZrr,
          7385 => Opcode::VCVTSD2SHZrr_Int,
          7386 => Opcode::VCVTSD2SHZrrb_Int,
          7387 => Opcode::VCVTSD2SHZrrbk_Int,
          7388 => Opcode::VCVTSD2SHZrrbkz_Int,
          7389 => Opcode::VCVTSD2SHZrrk_Int,
          7390 => Opcode::VCVTSD2SHZrrkz_Int,
          7391 => Opcode::VCVTSD2SI64Zrm,
          7392 => Opcode::VCVTSD2SI64Zrm_Int,
          7393 => Opcode::VCVTSD2SI64Zrr,
          7394 => Opcode::VCVTSD2SI64Zrr_Int,
          7395 => Opcode::VCVTSD2SI64Zrrb_Int,
          7396 => Opcode::VCVTSD2SI64rm,
          7397 => Opcode::VCVTSD2SI64rm_Int,
          7398 => Opcode::VCVTSD2SI64rr,
          7399 => Opcode::VCVTSD2SI64rr_Int,
          7400 => Opcode::VCVTSD2SIZrm,
          7401 => Opcode::VCVTSD2SIZrm_Int,
          7402 => Opcode::VCVTSD2SIZrr,
          7403 => Opcode::VCVTSD2SIZrr_Int,
          7404 => Opcode::VCVTSD2SIZrrb_Int,
          7405 => Opcode::VCVTSD2SIrm,
          7406 => Opcode::VCVTSD2SIrm_Int,
          7407 => Opcode::VCVTSD2SIrr,
          7408 => Opcode::VCVTSD2SIrr_Int,
          7409 => Opcode::VCVTSD2SSZrm,
          7410 => Opcode::VCVTSD2SSZrm_Int,
          7411 => Opcode::VCVTSD2SSZrmk_Int,
          7412 => Opcode::VCVTSD2SSZrmkz_Int,
          7413 => Opcode::VCVTSD2SSZrr,
          7414 => Opcode::VCVTSD2SSZrr_Int,
          7415 => Opcode::VCVTSD2SSZrrb_Int,
          7416 => Opcode::VCVTSD2SSZrrbk_Int,
          7417 => Opcode::VCVTSD2SSZrrbkz_Int,
          7418 => Opcode::VCVTSD2SSZrrk_Int,
          7419 => Opcode::VCVTSD2SSZrrkz_Int,
          7420 => Opcode::VCVTSD2SSrm,
          7421 => Opcode::VCVTSD2SSrm_Int,
          7422 => Opcode::VCVTSD2SSrr,
          7423 => Opcode::VCVTSD2SSrr_Int,
          7424 => Opcode::VCVTSD2USI64Zrm_Int,
          7425 => Opcode::VCVTSD2USI64Zrr_Int,
          7426 => Opcode::VCVTSD2USI64Zrrb_Int,
          7427 => Opcode::VCVTSD2USIZrm_Int,
          7428 => Opcode::VCVTSD2USIZrr_Int,
          7429 => Opcode::VCVTSD2USIZrrb_Int,
          7430 => Opcode::VCVTSH2SDZrm,
          7431 => Opcode::VCVTSH2SDZrm_Int,
          7432 => Opcode::VCVTSH2SDZrmk_Int,
          7433 => Opcode::VCVTSH2SDZrmkz_Int,
          7434 => Opcode::VCVTSH2SDZrr,
          7435 => Opcode::VCVTSH2SDZrr_Int,
          7436 => Opcode::VCVTSH2SDZrrb_Int,
          7437 => Opcode::VCVTSH2SDZrrbk_Int,
          7438 => Opcode::VCVTSH2SDZrrbkz_Int,
          7439 => Opcode::VCVTSH2SDZrrk_Int,
          7440 => Opcode::VCVTSH2SDZrrkz_Int,
          7441 => Opcode::VCVTSH2SI64Zrm_Int,
          7442 => Opcode::VCVTSH2SI64Zrr_Int,
          7443 => Opcode::VCVTSH2SI64Zrrb_Int,
          7444 => Opcode::VCVTSH2SIZrm_Int,
          7445 => Opcode::VCVTSH2SIZrr_Int,
          7446 => Opcode::VCVTSH2SIZrrb_Int,
          7447 => Opcode::VCVTSH2SSZrm,
          7448 => Opcode::VCVTSH2SSZrm_Int,
          7449 => Opcode::VCVTSH2SSZrmk_Int,
          7450 => Opcode::VCVTSH2SSZrmkz_Int,
          7451 => Opcode::VCVTSH2SSZrr,
          7452 => Opcode::VCVTSH2SSZrr_Int,
          7453 => Opcode::VCVTSH2SSZrrb_Int,
          7454 => Opcode::VCVTSH2SSZrrbk_Int,
          7455 => Opcode::VCVTSH2SSZrrbkz_Int,
          7456 => Opcode::VCVTSH2SSZrrk_Int,
          7457 => Opcode::VCVTSH2SSZrrkz_Int,
          7458 => Opcode::VCVTSH2USI64Zrm_Int,
          7459 => Opcode::VCVTSH2USI64Zrr_Int,
          7460 => Opcode::VCVTSH2USI64Zrrb_Int,
          7461 => Opcode::VCVTSH2USIZrm_Int,
          7462 => Opcode::VCVTSH2USIZrr_Int,
          7463 => Opcode::VCVTSH2USIZrrb_Int,
          7464 => Opcode::VCVTSI2SDZrm,
          7465 => Opcode::VCVTSI2SDZrm_Int,
          7466 => Opcode::VCVTSI2SDZrr,
          7467 => Opcode::VCVTSI2SDZrr_Int,
          7468 => Opcode::VCVTSI2SDrm,
          7469 => Opcode::VCVTSI2SDrm_Int,
          7470 => Opcode::VCVTSI2SDrr,
          7471 => Opcode::VCVTSI2SDrr_Int,
          7472 => Opcode::VCVTSI2SHZrm,
          7473 => Opcode::VCVTSI2SHZrm_Int,
          7474 => Opcode::VCVTSI2SHZrr,
          7475 => Opcode::VCVTSI2SHZrr_Int,
          7476 => Opcode::VCVTSI2SHZrrb_Int,
          7477 => Opcode::VCVTSI2SSZrm,
          7478 => Opcode::VCVTSI2SSZrm_Int,
          7479 => Opcode::VCVTSI2SSZrr,
          7480 => Opcode::VCVTSI2SSZrr_Int,
          7481 => Opcode::VCVTSI2SSZrrb_Int,
          7482 => Opcode::VCVTSI2SSrm,
          7483 => Opcode::VCVTSI2SSrm_Int,
          7484 => Opcode::VCVTSI2SSrr,
          7485 => Opcode::VCVTSI2SSrr_Int,
          7486 => Opcode::VCVTSI642SDZrm,
          7487 => Opcode::VCVTSI642SDZrm_Int,
          7488 => Opcode::VCVTSI642SDZrr,
          7489 => Opcode::VCVTSI642SDZrr_Int,
          7490 => Opcode::VCVTSI642SDZrrb_Int,
          7491 => Opcode::VCVTSI642SDrm,
          7492 => Opcode::VCVTSI642SDrm_Int,
          7493 => Opcode::VCVTSI642SDrr,
          7494 => Opcode::VCVTSI642SDrr_Int,
          7495 => Opcode::VCVTSI642SHZrm,
          7496 => Opcode::VCVTSI642SHZrm_Int,
          7497 => Opcode::VCVTSI642SHZrr,
          7498 => Opcode::VCVTSI642SHZrr_Int,
          7499 => Opcode::VCVTSI642SHZrrb_Int,
          7500 => Opcode::VCVTSI642SSZrm,
          7501 => Opcode::VCVTSI642SSZrm_Int,
          7502 => Opcode::VCVTSI642SSZrr,
          7503 => Opcode::VCVTSI642SSZrr_Int,
          7504 => Opcode::VCVTSI642SSZrrb_Int,
          7505 => Opcode::VCVTSI642SSrm,
          7506 => Opcode::VCVTSI642SSrm_Int,
          7507 => Opcode::VCVTSI642SSrr,
          7508 => Opcode::VCVTSI642SSrr_Int,
          7509 => Opcode::VCVTSS2SDZrm,
          7510 => Opcode::VCVTSS2SDZrm_Int,
          7511 => Opcode::VCVTSS2SDZrmk_Int,
          7512 => Opcode::VCVTSS2SDZrmkz_Int,
          7513 => Opcode::VCVTSS2SDZrr,
          7514 => Opcode::VCVTSS2SDZrr_Int,
          7515 => Opcode::VCVTSS2SDZrrb_Int,
          7516 => Opcode::VCVTSS2SDZrrbk_Int,
          7517 => Opcode::VCVTSS2SDZrrbkz_Int,
          7518 => Opcode::VCVTSS2SDZrrk_Int,
          7519 => Opcode::VCVTSS2SDZrrkz_Int,
          7520 => Opcode::VCVTSS2SDrm,
          7521 => Opcode::VCVTSS2SDrm_Int,
          7522 => Opcode::VCVTSS2SDrr,
          7523 => Opcode::VCVTSS2SDrr_Int,
          7524 => Opcode::VCVTSS2SHZrm,
          7525 => Opcode::VCVTSS2SHZrm_Int,
          7526 => Opcode::VCVTSS2SHZrmk_Int,
          7527 => Opcode::VCVTSS2SHZrmkz_Int,
          7528 => Opcode::VCVTSS2SHZrr,
          7529 => Opcode::VCVTSS2SHZrr_Int,
          7530 => Opcode::VCVTSS2SHZrrb_Int,
          7531 => Opcode::VCVTSS2SHZrrbk_Int,
          7532 => Opcode::VCVTSS2SHZrrbkz_Int,
          7533 => Opcode::VCVTSS2SHZrrk_Int,
          7534 => Opcode::VCVTSS2SHZrrkz_Int,
          7535 => Opcode::VCVTSS2SI64Zrm,
          7536 => Opcode::VCVTSS2SI64Zrm_Int,
          7537 => Opcode::VCVTSS2SI64Zrr,
          7538 => Opcode::VCVTSS2SI64Zrr_Int,
          7539 => Opcode::VCVTSS2SI64Zrrb_Int,
          7540 => Opcode::VCVTSS2SI64rm,
          7541 => Opcode::VCVTSS2SI64rm_Int,
          7542 => Opcode::VCVTSS2SI64rr,
          7543 => Opcode::VCVTSS2SI64rr_Int,
          7544 => Opcode::VCVTSS2SIZrm,
          7545 => Opcode::VCVTSS2SIZrm_Int,
          7546 => Opcode::VCVTSS2SIZrr,
          7547 => Opcode::VCVTSS2SIZrr_Int,
          7548 => Opcode::VCVTSS2SIZrrb_Int,
          7549 => Opcode::VCVTSS2SIrm,
          7550 => Opcode::VCVTSS2SIrm_Int,
          7551 => Opcode::VCVTSS2SIrr,
          7552 => Opcode::VCVTSS2SIrr_Int,
          7553 => Opcode::VCVTSS2USI64Zrm_Int,
          7554 => Opcode::VCVTSS2USI64Zrr_Int,
          7555 => Opcode::VCVTSS2USI64Zrrb_Int,
          7556 => Opcode::VCVTSS2USIZrm_Int,
          7557 => Opcode::VCVTSS2USIZrr_Int,
          7558 => Opcode::VCVTSS2USIZrrb_Int,
          7559 => Opcode::VCVTTBF162IBSZ128rm,
          7560 => Opcode::VCVTTBF162IBSZ128rmb,
          7561 => Opcode::VCVTTBF162IBSZ128rmbk,
          7562 => Opcode::VCVTTBF162IBSZ128rmbkz,
          7563 => Opcode::VCVTTBF162IBSZ128rmk,
          7564 => Opcode::VCVTTBF162IBSZ128rmkz,
          7565 => Opcode::VCVTTBF162IBSZ128rr,
          7566 => Opcode::VCVTTBF162IBSZ128rrk,
          7567 => Opcode::VCVTTBF162IBSZ128rrkz,
          7568 => Opcode::VCVTTBF162IBSZ256rm,
          7569 => Opcode::VCVTTBF162IBSZ256rmb,
          7570 => Opcode::VCVTTBF162IBSZ256rmbk,
          7571 => Opcode::VCVTTBF162IBSZ256rmbkz,
          7572 => Opcode::VCVTTBF162IBSZ256rmk,
          7573 => Opcode::VCVTTBF162IBSZ256rmkz,
          7574 => Opcode::VCVTTBF162IBSZ256rr,
          7575 => Opcode::VCVTTBF162IBSZ256rrk,
          7576 => Opcode::VCVTTBF162IBSZ256rrkz,
          7577 => Opcode::VCVTTBF162IBSZrm,
          7578 => Opcode::VCVTTBF162IBSZrmb,
          7579 => Opcode::VCVTTBF162IBSZrmbk,
          7580 => Opcode::VCVTTBF162IBSZrmbkz,
          7581 => Opcode::VCVTTBF162IBSZrmk,
          7582 => Opcode::VCVTTBF162IBSZrmkz,
          7583 => Opcode::VCVTTBF162IBSZrr,
          7584 => Opcode::VCVTTBF162IBSZrrk,
          7585 => Opcode::VCVTTBF162IBSZrrkz,
          7586 => Opcode::VCVTTBF162IUBSZ128rm,
          7587 => Opcode::VCVTTBF162IUBSZ128rmb,
          7588 => Opcode::VCVTTBF162IUBSZ128rmbk,
          7589 => Opcode::VCVTTBF162IUBSZ128rmbkz,
          7590 => Opcode::VCVTTBF162IUBSZ128rmk,
          7591 => Opcode::VCVTTBF162IUBSZ128rmkz,
          7592 => Opcode::VCVTTBF162IUBSZ128rr,
          7593 => Opcode::VCVTTBF162IUBSZ128rrk,
          7594 => Opcode::VCVTTBF162IUBSZ128rrkz,
          7595 => Opcode::VCVTTBF162IUBSZ256rm,
          7596 => Opcode::VCVTTBF162IUBSZ256rmb,
          7597 => Opcode::VCVTTBF162IUBSZ256rmbk,
          7598 => Opcode::VCVTTBF162IUBSZ256rmbkz,
          7599 => Opcode::VCVTTBF162IUBSZ256rmk,
          7600 => Opcode::VCVTTBF162IUBSZ256rmkz,
          7601 => Opcode::VCVTTBF162IUBSZ256rr,
          7602 => Opcode::VCVTTBF162IUBSZ256rrk,
          7603 => Opcode::VCVTTBF162IUBSZ256rrkz,
          7604 => Opcode::VCVTTBF162IUBSZrm,
          7605 => Opcode::VCVTTBF162IUBSZrmb,
          7606 => Opcode::VCVTTBF162IUBSZrmbk,
          7607 => Opcode::VCVTTBF162IUBSZrmbkz,
          7608 => Opcode::VCVTTBF162IUBSZrmk,
          7609 => Opcode::VCVTTBF162IUBSZrmkz,
          7610 => Opcode::VCVTTBF162IUBSZrr,
          7611 => Opcode::VCVTTBF162IUBSZrrk,
          7612 => Opcode::VCVTTBF162IUBSZrrkz,
          7613 => Opcode::VCVTTPD2DQSZ128rm,
          7614 => Opcode::VCVTTPD2DQSZ128rmb,
          7615 => Opcode::VCVTTPD2DQSZ128rmbk,
          7616 => Opcode::VCVTTPD2DQSZ128rmbkz,
          7617 => Opcode::VCVTTPD2DQSZ128rmk,
          7618 => Opcode::VCVTTPD2DQSZ128rmkz,
          7619 => Opcode::VCVTTPD2DQSZ128rr,
          7620 => Opcode::VCVTTPD2DQSZ128rrk,
          7621 => Opcode::VCVTTPD2DQSZ128rrkz,
          7622 => Opcode::VCVTTPD2DQSZ256rm,
          7623 => Opcode::VCVTTPD2DQSZ256rmb,
          7624 => Opcode::VCVTTPD2DQSZ256rmbk,
          7625 => Opcode::VCVTTPD2DQSZ256rmbkz,
          7626 => Opcode::VCVTTPD2DQSZ256rmk,
          7627 => Opcode::VCVTTPD2DQSZ256rmkz,
          7628 => Opcode::VCVTTPD2DQSZ256rr,
          7629 => Opcode::VCVTTPD2DQSZ256rrb,
          7630 => Opcode::VCVTTPD2DQSZ256rrbk,
          7631 => Opcode::VCVTTPD2DQSZ256rrbkz,
          7632 => Opcode::VCVTTPD2DQSZ256rrk,
          7633 => Opcode::VCVTTPD2DQSZ256rrkz,
          7634 => Opcode::VCVTTPD2DQSZrm,
          7635 => Opcode::VCVTTPD2DQSZrmb,
          7636 => Opcode::VCVTTPD2DQSZrmbk,
          7637 => Opcode::VCVTTPD2DQSZrmbkz,
          7638 => Opcode::VCVTTPD2DQSZrmk,
          7639 => Opcode::VCVTTPD2DQSZrmkz,
          7640 => Opcode::VCVTTPD2DQSZrr,
          7641 => Opcode::VCVTTPD2DQSZrrb,
          7642 => Opcode::VCVTTPD2DQSZrrbk,
          7643 => Opcode::VCVTTPD2DQSZrrbkz,
          7644 => Opcode::VCVTTPD2DQSZrrk,
          7645 => Opcode::VCVTTPD2DQSZrrkz,
          7646 => Opcode::VCVTTPD2DQYrm,
          7647 => Opcode::VCVTTPD2DQYrr,
          7648 => Opcode::VCVTTPD2DQZ128rm,
          7649 => Opcode::VCVTTPD2DQZ128rmb,
          7650 => Opcode::VCVTTPD2DQZ128rmbk,
          7651 => Opcode::VCVTTPD2DQZ128rmbkz,
          7652 => Opcode::VCVTTPD2DQZ128rmk,
          7653 => Opcode::VCVTTPD2DQZ128rmkz,
          7654 => Opcode::VCVTTPD2DQZ128rr,
          7655 => Opcode::VCVTTPD2DQZ128rrk,
          7656 => Opcode::VCVTTPD2DQZ128rrkz,
          7657 => Opcode::VCVTTPD2DQZ256rm,
          7658 => Opcode::VCVTTPD2DQZ256rmb,
          7659 => Opcode::VCVTTPD2DQZ256rmbk,
          7660 => Opcode::VCVTTPD2DQZ256rmbkz,
          7661 => Opcode::VCVTTPD2DQZ256rmk,
          7662 => Opcode::VCVTTPD2DQZ256rmkz,
          7663 => Opcode::VCVTTPD2DQZ256rr,
          7664 => Opcode::VCVTTPD2DQZ256rrk,
          7665 => Opcode::VCVTTPD2DQZ256rrkz,
          7666 => Opcode::VCVTTPD2DQZrm,
          7667 => Opcode::VCVTTPD2DQZrmb,
          7668 => Opcode::VCVTTPD2DQZrmbk,
          7669 => Opcode::VCVTTPD2DQZrmbkz,
          7670 => Opcode::VCVTTPD2DQZrmk,
          7671 => Opcode::VCVTTPD2DQZrmkz,
          7672 => Opcode::VCVTTPD2DQZrr,
          7673 => Opcode::VCVTTPD2DQZrrb,
          7674 => Opcode::VCVTTPD2DQZrrbk,
          7675 => Opcode::VCVTTPD2DQZrrbkz,
          7676 => Opcode::VCVTTPD2DQZrrk,
          7677 => Opcode::VCVTTPD2DQZrrkz,
          7678 => Opcode::VCVTTPD2DQrm,
          7679 => Opcode::VCVTTPD2DQrr,
          7680 => Opcode::VCVTTPD2QQSZ128rm,
          7681 => Opcode::VCVTTPD2QQSZ128rmb,
          7682 => Opcode::VCVTTPD2QQSZ128rmbk,
          7683 => Opcode::VCVTTPD2QQSZ128rmbkz,
          7684 => Opcode::VCVTTPD2QQSZ128rmk,
          7685 => Opcode::VCVTTPD2QQSZ128rmkz,
          7686 => Opcode::VCVTTPD2QQSZ128rr,
          7687 => Opcode::VCVTTPD2QQSZ128rrk,
          7688 => Opcode::VCVTTPD2QQSZ128rrkz,
          7689 => Opcode::VCVTTPD2QQSZ256rm,
          7690 => Opcode::VCVTTPD2QQSZ256rmb,
          7691 => Opcode::VCVTTPD2QQSZ256rmbk,
          7692 => Opcode::VCVTTPD2QQSZ256rmbkz,
          7693 => Opcode::VCVTTPD2QQSZ256rmk,
          7694 => Opcode::VCVTTPD2QQSZ256rmkz,
          7695 => Opcode::VCVTTPD2QQSZ256rr,
          7696 => Opcode::VCVTTPD2QQSZ256rrb,
          7697 => Opcode::VCVTTPD2QQSZ256rrbk,
          7698 => Opcode::VCVTTPD2QQSZ256rrbkz,
          7699 => Opcode::VCVTTPD2QQSZ256rrk,
          7700 => Opcode::VCVTTPD2QQSZ256rrkz,
          7701 => Opcode::VCVTTPD2QQSZrm,
          7702 => Opcode::VCVTTPD2QQSZrmb,
          7703 => Opcode::VCVTTPD2QQSZrmbk,
          7704 => Opcode::VCVTTPD2QQSZrmbkz,
          7705 => Opcode::VCVTTPD2QQSZrmk,
          7706 => Opcode::VCVTTPD2QQSZrmkz,
          7707 => Opcode::VCVTTPD2QQSZrr,
          7708 => Opcode::VCVTTPD2QQSZrrb,
          7709 => Opcode::VCVTTPD2QQSZrrbk,
          7710 => Opcode::VCVTTPD2QQSZrrbkz,
          7711 => Opcode::VCVTTPD2QQSZrrk,
          7712 => Opcode::VCVTTPD2QQSZrrkz,
          7713 => Opcode::VCVTTPD2QQZ128rm,
          7714 => Opcode::VCVTTPD2QQZ128rmb,
          7715 => Opcode::VCVTTPD2QQZ128rmbk,
          7716 => Opcode::VCVTTPD2QQZ128rmbkz,
          7717 => Opcode::VCVTTPD2QQZ128rmk,
          7718 => Opcode::VCVTTPD2QQZ128rmkz,
          7719 => Opcode::VCVTTPD2QQZ128rr,
          7720 => Opcode::VCVTTPD2QQZ128rrk,
          7721 => Opcode::VCVTTPD2QQZ128rrkz,
          7722 => Opcode::VCVTTPD2QQZ256rm,
          7723 => Opcode::VCVTTPD2QQZ256rmb,
          7724 => Opcode::VCVTTPD2QQZ256rmbk,
          7725 => Opcode::VCVTTPD2QQZ256rmbkz,
          7726 => Opcode::VCVTTPD2QQZ256rmk,
          7727 => Opcode::VCVTTPD2QQZ256rmkz,
          7728 => Opcode::VCVTTPD2QQZ256rr,
          7729 => Opcode::VCVTTPD2QQZ256rrk,
          7730 => Opcode::VCVTTPD2QQZ256rrkz,
          7731 => Opcode::VCVTTPD2QQZrm,
          7732 => Opcode::VCVTTPD2QQZrmb,
          7733 => Opcode::VCVTTPD2QQZrmbk,
          7734 => Opcode::VCVTTPD2QQZrmbkz,
          7735 => Opcode::VCVTTPD2QQZrmk,
          7736 => Opcode::VCVTTPD2QQZrmkz,
          7737 => Opcode::VCVTTPD2QQZrr,
          7738 => Opcode::VCVTTPD2QQZrrb,
          7739 => Opcode::VCVTTPD2QQZrrbk,
          7740 => Opcode::VCVTTPD2QQZrrbkz,
          7741 => Opcode::VCVTTPD2QQZrrk,
          7742 => Opcode::VCVTTPD2QQZrrkz,
          7743 => Opcode::VCVTTPD2UDQSZ128rm,
          7744 => Opcode::VCVTTPD2UDQSZ128rmb,
          7745 => Opcode::VCVTTPD2UDQSZ128rmbk,
          7746 => Opcode::VCVTTPD2UDQSZ128rmbkz,
          7747 => Opcode::VCVTTPD2UDQSZ128rmk,
          7748 => Opcode::VCVTTPD2UDQSZ128rmkz,
          7749 => Opcode::VCVTTPD2UDQSZ128rr,
          7750 => Opcode::VCVTTPD2UDQSZ128rrk,
          7751 => Opcode::VCVTTPD2UDQSZ128rrkz,
          7752 => Opcode::VCVTTPD2UDQSZ256rm,
          7753 => Opcode::VCVTTPD2UDQSZ256rmb,
          7754 => Opcode::VCVTTPD2UDQSZ256rmbk,
          7755 => Opcode::VCVTTPD2UDQSZ256rmbkz,
          7756 => Opcode::VCVTTPD2UDQSZ256rmk,
          7757 => Opcode::VCVTTPD2UDQSZ256rmkz,
          7758 => Opcode::VCVTTPD2UDQSZ256rr,
          7759 => Opcode::VCVTTPD2UDQSZ256rrb,
          7760 => Opcode::VCVTTPD2UDQSZ256rrbk,
          7761 => Opcode::VCVTTPD2UDQSZ256rrbkz,
          7762 => Opcode::VCVTTPD2UDQSZ256rrk,
          7763 => Opcode::VCVTTPD2UDQSZ256rrkz,
          7764 => Opcode::VCVTTPD2UDQSZrm,
          7765 => Opcode::VCVTTPD2UDQSZrmb,
          7766 => Opcode::VCVTTPD2UDQSZrmbk,
          7767 => Opcode::VCVTTPD2UDQSZrmbkz,
          7768 => Opcode::VCVTTPD2UDQSZrmk,
          7769 => Opcode::VCVTTPD2UDQSZrmkz,
          7770 => Opcode::VCVTTPD2UDQSZrr,
          7771 => Opcode::VCVTTPD2UDQSZrrb,
          7772 => Opcode::VCVTTPD2UDQSZrrbk,
          7773 => Opcode::VCVTTPD2UDQSZrrbkz,
          7774 => Opcode::VCVTTPD2UDQSZrrk,
          7775 => Opcode::VCVTTPD2UDQSZrrkz,
          7776 => Opcode::VCVTTPD2UDQZ128rm,
          7777 => Opcode::VCVTTPD2UDQZ128rmb,
          7778 => Opcode::VCVTTPD2UDQZ128rmbk,
          7779 => Opcode::VCVTTPD2UDQZ128rmbkz,
          7780 => Opcode::VCVTTPD2UDQZ128rmk,
          7781 => Opcode::VCVTTPD2UDQZ128rmkz,
          7782 => Opcode::VCVTTPD2UDQZ128rr,
          7783 => Opcode::VCVTTPD2UDQZ128rrk,
          7784 => Opcode::VCVTTPD2UDQZ128rrkz,
          7785 => Opcode::VCVTTPD2UDQZ256rm,
          7786 => Opcode::VCVTTPD2UDQZ256rmb,
          7787 => Opcode::VCVTTPD2UDQZ256rmbk,
          7788 => Opcode::VCVTTPD2UDQZ256rmbkz,
          7789 => Opcode::VCVTTPD2UDQZ256rmk,
          7790 => Opcode::VCVTTPD2UDQZ256rmkz,
          7791 => Opcode::VCVTTPD2UDQZ256rr,
          7792 => Opcode::VCVTTPD2UDQZ256rrk,
          7793 => Opcode::VCVTTPD2UDQZ256rrkz,
          7794 => Opcode::VCVTTPD2UDQZrm,
          7795 => Opcode::VCVTTPD2UDQZrmb,
          7796 => Opcode::VCVTTPD2UDQZrmbk,
          7797 => Opcode::VCVTTPD2UDQZrmbkz,
          7798 => Opcode::VCVTTPD2UDQZrmk,
          7799 => Opcode::VCVTTPD2UDQZrmkz,
          7800 => Opcode::VCVTTPD2UDQZrr,
          7801 => Opcode::VCVTTPD2UDQZrrb,
          7802 => Opcode::VCVTTPD2UDQZrrbk,
          7803 => Opcode::VCVTTPD2UDQZrrbkz,
          7804 => Opcode::VCVTTPD2UDQZrrk,
          7805 => Opcode::VCVTTPD2UDQZrrkz,
          7806 => Opcode::VCVTTPD2UQQSZ128rm,
          7807 => Opcode::VCVTTPD2UQQSZ128rmb,
          7808 => Opcode::VCVTTPD2UQQSZ128rmbk,
          7809 => Opcode::VCVTTPD2UQQSZ128rmbkz,
          7810 => Opcode::VCVTTPD2UQQSZ128rmk,
          7811 => Opcode::VCVTTPD2UQQSZ128rmkz,
          7812 => Opcode::VCVTTPD2UQQSZ128rr,
          7813 => Opcode::VCVTTPD2UQQSZ128rrk,
          7814 => Opcode::VCVTTPD2UQQSZ128rrkz,
          7815 => Opcode::VCVTTPD2UQQSZ256rm,
          7816 => Opcode::VCVTTPD2UQQSZ256rmb,
          7817 => Opcode::VCVTTPD2UQQSZ256rmbk,
          7818 => Opcode::VCVTTPD2UQQSZ256rmbkz,
          7819 => Opcode::VCVTTPD2UQQSZ256rmk,
          7820 => Opcode::VCVTTPD2UQQSZ256rmkz,
          7821 => Opcode::VCVTTPD2UQQSZ256rr,
          7822 => Opcode::VCVTTPD2UQQSZ256rrb,
          7823 => Opcode::VCVTTPD2UQQSZ256rrbk,
          7824 => Opcode::VCVTTPD2UQQSZ256rrbkz,
          7825 => Opcode::VCVTTPD2UQQSZ256rrk,
          7826 => Opcode::VCVTTPD2UQQSZ256rrkz,
          7827 => Opcode::VCVTTPD2UQQSZrm,
          7828 => Opcode::VCVTTPD2UQQSZrmb,
          7829 => Opcode::VCVTTPD2UQQSZrmbk,
          7830 => Opcode::VCVTTPD2UQQSZrmbkz,
          7831 => Opcode::VCVTTPD2UQQSZrmk,
          7832 => Opcode::VCVTTPD2UQQSZrmkz,
          7833 => Opcode::VCVTTPD2UQQSZrr,
          7834 => Opcode::VCVTTPD2UQQSZrrb,
          7835 => Opcode::VCVTTPD2UQQSZrrbk,
          7836 => Opcode::VCVTTPD2UQQSZrrbkz,
          7837 => Opcode::VCVTTPD2UQQSZrrk,
          7838 => Opcode::VCVTTPD2UQQSZrrkz,
          7839 => Opcode::VCVTTPD2UQQZ128rm,
          7840 => Opcode::VCVTTPD2UQQZ128rmb,
          7841 => Opcode::VCVTTPD2UQQZ128rmbk,
          7842 => Opcode::VCVTTPD2UQQZ128rmbkz,
          7843 => Opcode::VCVTTPD2UQQZ128rmk,
          7844 => Opcode::VCVTTPD2UQQZ128rmkz,
          7845 => Opcode::VCVTTPD2UQQZ128rr,
          7846 => Opcode::VCVTTPD2UQQZ128rrk,
          7847 => Opcode::VCVTTPD2UQQZ128rrkz,
          7848 => Opcode::VCVTTPD2UQQZ256rm,
          7849 => Opcode::VCVTTPD2UQQZ256rmb,
          7850 => Opcode::VCVTTPD2UQQZ256rmbk,
          7851 => Opcode::VCVTTPD2UQQZ256rmbkz,
          7852 => Opcode::VCVTTPD2UQQZ256rmk,
          7853 => Opcode::VCVTTPD2UQQZ256rmkz,
          7854 => Opcode::VCVTTPD2UQQZ256rr,
          7855 => Opcode::VCVTTPD2UQQZ256rrk,
          7856 => Opcode::VCVTTPD2UQQZ256rrkz,
          7857 => Opcode::VCVTTPD2UQQZrm,
          7858 => Opcode::VCVTTPD2UQQZrmb,
          7859 => Opcode::VCVTTPD2UQQZrmbk,
          7860 => Opcode::VCVTTPD2UQQZrmbkz,
          7861 => Opcode::VCVTTPD2UQQZrmk,
          7862 => Opcode::VCVTTPD2UQQZrmkz,
          7863 => Opcode::VCVTTPD2UQQZrr,
          7864 => Opcode::VCVTTPD2UQQZrrb,
          7865 => Opcode::VCVTTPD2UQQZrrbk,
          7866 => Opcode::VCVTTPD2UQQZrrbkz,
          7867 => Opcode::VCVTTPD2UQQZrrk,
          7868 => Opcode::VCVTTPD2UQQZrrkz,
          7869 => Opcode::VCVTTPH2DQZ128rm,
          7870 => Opcode::VCVTTPH2DQZ128rmb,
          7871 => Opcode::VCVTTPH2DQZ128rmbk,
          7872 => Opcode::VCVTTPH2DQZ128rmbkz,
          7873 => Opcode::VCVTTPH2DQZ128rmk,
          7874 => Opcode::VCVTTPH2DQZ128rmkz,
          7875 => Opcode::VCVTTPH2DQZ128rr,
          7876 => Opcode::VCVTTPH2DQZ128rrk,
          7877 => Opcode::VCVTTPH2DQZ128rrkz,
          7878 => Opcode::VCVTTPH2DQZ256rm,
          7879 => Opcode::VCVTTPH2DQZ256rmb,
          7880 => Opcode::VCVTTPH2DQZ256rmbk,
          7881 => Opcode::VCVTTPH2DQZ256rmbkz,
          7882 => Opcode::VCVTTPH2DQZ256rmk,
          7883 => Opcode::VCVTTPH2DQZ256rmkz,
          7884 => Opcode::VCVTTPH2DQZ256rr,
          7885 => Opcode::VCVTTPH2DQZ256rrk,
          7886 => Opcode::VCVTTPH2DQZ256rrkz,
          7887 => Opcode::VCVTTPH2DQZrm,
          7888 => Opcode::VCVTTPH2DQZrmb,
          7889 => Opcode::VCVTTPH2DQZrmbk,
          7890 => Opcode::VCVTTPH2DQZrmbkz,
          7891 => Opcode::VCVTTPH2DQZrmk,
          7892 => Opcode::VCVTTPH2DQZrmkz,
          7893 => Opcode::VCVTTPH2DQZrr,
          7894 => Opcode::VCVTTPH2DQZrrb,
          7895 => Opcode::VCVTTPH2DQZrrbk,
          7896 => Opcode::VCVTTPH2DQZrrbkz,
          7897 => Opcode::VCVTTPH2DQZrrk,
          7898 => Opcode::VCVTTPH2DQZrrkz,
          7899 => Opcode::VCVTTPH2IBSZ128rm,
          7900 => Opcode::VCVTTPH2IBSZ128rmb,
          7901 => Opcode::VCVTTPH2IBSZ128rmbk,
          7902 => Opcode::VCVTTPH2IBSZ128rmbkz,
          7903 => Opcode::VCVTTPH2IBSZ128rmk,
          7904 => Opcode::VCVTTPH2IBSZ128rmkz,
          7905 => Opcode::VCVTTPH2IBSZ128rr,
          7906 => Opcode::VCVTTPH2IBSZ128rrk,
          7907 => Opcode::VCVTTPH2IBSZ128rrkz,
          7908 => Opcode::VCVTTPH2IBSZ256rm,
          7909 => Opcode::VCVTTPH2IBSZ256rmb,
          7910 => Opcode::VCVTTPH2IBSZ256rmbk,
          7911 => Opcode::VCVTTPH2IBSZ256rmbkz,
          7912 => Opcode::VCVTTPH2IBSZ256rmk,
          7913 => Opcode::VCVTTPH2IBSZ256rmkz,
          7914 => Opcode::VCVTTPH2IBSZ256rr,
          7915 => Opcode::VCVTTPH2IBSZ256rrk,
          7916 => Opcode::VCVTTPH2IBSZ256rrkz,
          7917 => Opcode::VCVTTPH2IBSZrm,
          7918 => Opcode::VCVTTPH2IBSZrmb,
          7919 => Opcode::VCVTTPH2IBSZrmbk,
          7920 => Opcode::VCVTTPH2IBSZrmbkz,
          7921 => Opcode::VCVTTPH2IBSZrmk,
          7922 => Opcode::VCVTTPH2IBSZrmkz,
          7923 => Opcode::VCVTTPH2IBSZrr,
          7924 => Opcode::VCVTTPH2IBSZrrb,
          7925 => Opcode::VCVTTPH2IBSZrrbk,
          7926 => Opcode::VCVTTPH2IBSZrrbkz,
          7927 => Opcode::VCVTTPH2IBSZrrk,
          7928 => Opcode::VCVTTPH2IBSZrrkz,
          7929 => Opcode::VCVTTPH2IUBSZ128rm,
          7930 => Opcode::VCVTTPH2IUBSZ128rmb,
          7931 => Opcode::VCVTTPH2IUBSZ128rmbk,
          7932 => Opcode::VCVTTPH2IUBSZ128rmbkz,
          7933 => Opcode::VCVTTPH2IUBSZ128rmk,
          7934 => Opcode::VCVTTPH2IUBSZ128rmkz,
          7935 => Opcode::VCVTTPH2IUBSZ128rr,
          7936 => Opcode::VCVTTPH2IUBSZ128rrk,
          7937 => Opcode::VCVTTPH2IUBSZ128rrkz,
          7938 => Opcode::VCVTTPH2IUBSZ256rm,
          7939 => Opcode::VCVTTPH2IUBSZ256rmb,
          7940 => Opcode::VCVTTPH2IUBSZ256rmbk,
          7941 => Opcode::VCVTTPH2IUBSZ256rmbkz,
          7942 => Opcode::VCVTTPH2IUBSZ256rmk,
          7943 => Opcode::VCVTTPH2IUBSZ256rmkz,
          7944 => Opcode::VCVTTPH2IUBSZ256rr,
          7945 => Opcode::VCVTTPH2IUBSZ256rrk,
          7946 => Opcode::VCVTTPH2IUBSZ256rrkz,
          7947 => Opcode::VCVTTPH2IUBSZrm,
          7948 => Opcode::VCVTTPH2IUBSZrmb,
          7949 => Opcode::VCVTTPH2IUBSZrmbk,
          7950 => Opcode::VCVTTPH2IUBSZrmbkz,
          7951 => Opcode::VCVTTPH2IUBSZrmk,
          7952 => Opcode::VCVTTPH2IUBSZrmkz,
          7953 => Opcode::VCVTTPH2IUBSZrr,
          7954 => Opcode::VCVTTPH2IUBSZrrb,
          7955 => Opcode::VCVTTPH2IUBSZrrbk,
          7956 => Opcode::VCVTTPH2IUBSZrrbkz,
          7957 => Opcode::VCVTTPH2IUBSZrrk,
          7958 => Opcode::VCVTTPH2IUBSZrrkz,
          7959 => Opcode::VCVTTPH2QQZ128rm,
          7960 => Opcode::VCVTTPH2QQZ128rmb,
          7961 => Opcode::VCVTTPH2QQZ128rmbk,
          7962 => Opcode::VCVTTPH2QQZ128rmbkz,
          7963 => Opcode::VCVTTPH2QQZ128rmk,
          7964 => Opcode::VCVTTPH2QQZ128rmkz,
          7965 => Opcode::VCVTTPH2QQZ128rr,
          7966 => Opcode::VCVTTPH2QQZ128rrk,
          7967 => Opcode::VCVTTPH2QQZ128rrkz,
          7968 => Opcode::VCVTTPH2QQZ256rm,
          7969 => Opcode::VCVTTPH2QQZ256rmb,
          7970 => Opcode::VCVTTPH2QQZ256rmbk,
          7971 => Opcode::VCVTTPH2QQZ256rmbkz,
          7972 => Opcode::VCVTTPH2QQZ256rmk,
          7973 => Opcode::VCVTTPH2QQZ256rmkz,
          7974 => Opcode::VCVTTPH2QQZ256rr,
          7975 => Opcode::VCVTTPH2QQZ256rrk,
          7976 => Opcode::VCVTTPH2QQZ256rrkz,
          7977 => Opcode::VCVTTPH2QQZrm,
          7978 => Opcode::VCVTTPH2QQZrmb,
          7979 => Opcode::VCVTTPH2QQZrmbk,
          7980 => Opcode::VCVTTPH2QQZrmbkz,
          7981 => Opcode::VCVTTPH2QQZrmk,
          7982 => Opcode::VCVTTPH2QQZrmkz,
          7983 => Opcode::VCVTTPH2QQZrr,
          7984 => Opcode::VCVTTPH2QQZrrb,
          7985 => Opcode::VCVTTPH2QQZrrbk,
          7986 => Opcode::VCVTTPH2QQZrrbkz,
          7987 => Opcode::VCVTTPH2QQZrrk,
          7988 => Opcode::VCVTTPH2QQZrrkz,
          7989 => Opcode::VCVTTPH2UDQZ128rm,
          7990 => Opcode::VCVTTPH2UDQZ128rmb,
          7991 => Opcode::VCVTTPH2UDQZ128rmbk,
          7992 => Opcode::VCVTTPH2UDQZ128rmbkz,
          7993 => Opcode::VCVTTPH2UDQZ128rmk,
          7994 => Opcode::VCVTTPH2UDQZ128rmkz,
          7995 => Opcode::VCVTTPH2UDQZ128rr,
          7996 => Opcode::VCVTTPH2UDQZ128rrk,
          7997 => Opcode::VCVTTPH2UDQZ128rrkz,
          7998 => Opcode::VCVTTPH2UDQZ256rm,
          7999 => Opcode::VCVTTPH2UDQZ256rmb,
          8000 => Opcode::VCVTTPH2UDQZ256rmbk,
          8001 => Opcode::VCVTTPH2UDQZ256rmbkz,
          8002 => Opcode::VCVTTPH2UDQZ256rmk,
          8003 => Opcode::VCVTTPH2UDQZ256rmkz,
          8004 => Opcode::VCVTTPH2UDQZ256rr,
          8005 => Opcode::VCVTTPH2UDQZ256rrk,
          8006 => Opcode::VCVTTPH2UDQZ256rrkz,
          8007 => Opcode::VCVTTPH2UDQZrm,
          8008 => Opcode::VCVTTPH2UDQZrmb,
          8009 => Opcode::VCVTTPH2UDQZrmbk,
          8010 => Opcode::VCVTTPH2UDQZrmbkz,
          8011 => Opcode::VCVTTPH2UDQZrmk,
          8012 => Opcode::VCVTTPH2UDQZrmkz,
          8013 => Opcode::VCVTTPH2UDQZrr,
          8014 => Opcode::VCVTTPH2UDQZrrb,
          8015 => Opcode::VCVTTPH2UDQZrrbk,
          8016 => Opcode::VCVTTPH2UDQZrrbkz,
          8017 => Opcode::VCVTTPH2UDQZrrk,
          8018 => Opcode::VCVTTPH2UDQZrrkz,
          8019 => Opcode::VCVTTPH2UQQZ128rm,
          8020 => Opcode::VCVTTPH2UQQZ128rmb,
          8021 => Opcode::VCVTTPH2UQQZ128rmbk,
          8022 => Opcode::VCVTTPH2UQQZ128rmbkz,
          8023 => Opcode::VCVTTPH2UQQZ128rmk,
          8024 => Opcode::VCVTTPH2UQQZ128rmkz,
          8025 => Opcode::VCVTTPH2UQQZ128rr,
          8026 => Opcode::VCVTTPH2UQQZ128rrk,
          8027 => Opcode::VCVTTPH2UQQZ128rrkz,
          8028 => Opcode::VCVTTPH2UQQZ256rm,
          8029 => Opcode::VCVTTPH2UQQZ256rmb,
          8030 => Opcode::VCVTTPH2UQQZ256rmbk,
          8031 => Opcode::VCVTTPH2UQQZ256rmbkz,
          8032 => Opcode::VCVTTPH2UQQZ256rmk,
          8033 => Opcode::VCVTTPH2UQQZ256rmkz,
          8034 => Opcode::VCVTTPH2UQQZ256rr,
          8035 => Opcode::VCVTTPH2UQQZ256rrk,
          8036 => Opcode::VCVTTPH2UQQZ256rrkz,
          8037 => Opcode::VCVTTPH2UQQZrm,
          8038 => Opcode::VCVTTPH2UQQZrmb,
          8039 => Opcode::VCVTTPH2UQQZrmbk,
          8040 => Opcode::VCVTTPH2UQQZrmbkz,
          8041 => Opcode::VCVTTPH2UQQZrmk,
          8042 => Opcode::VCVTTPH2UQQZrmkz,
          8043 => Opcode::VCVTTPH2UQQZrr,
          8044 => Opcode::VCVTTPH2UQQZrrb,
          8045 => Opcode::VCVTTPH2UQQZrrbk,
          8046 => Opcode::VCVTTPH2UQQZrrbkz,
          8047 => Opcode::VCVTTPH2UQQZrrk,
          8048 => Opcode::VCVTTPH2UQQZrrkz,
          8049 => Opcode::VCVTTPH2UWZ128rm,
          8050 => Opcode::VCVTTPH2UWZ128rmb,
          8051 => Opcode::VCVTTPH2UWZ128rmbk,
          8052 => Opcode::VCVTTPH2UWZ128rmbkz,
          8053 => Opcode::VCVTTPH2UWZ128rmk,
          8054 => Opcode::VCVTTPH2UWZ128rmkz,
          8055 => Opcode::VCVTTPH2UWZ128rr,
          8056 => Opcode::VCVTTPH2UWZ128rrk,
          8057 => Opcode::VCVTTPH2UWZ128rrkz,
          8058 => Opcode::VCVTTPH2UWZ256rm,
          8059 => Opcode::VCVTTPH2UWZ256rmb,
          8060 => Opcode::VCVTTPH2UWZ256rmbk,
          8061 => Opcode::VCVTTPH2UWZ256rmbkz,
          8062 => Opcode::VCVTTPH2UWZ256rmk,
          8063 => Opcode::VCVTTPH2UWZ256rmkz,
          8064 => Opcode::VCVTTPH2UWZ256rr,
          8065 => Opcode::VCVTTPH2UWZ256rrk,
          8066 => Opcode::VCVTTPH2UWZ256rrkz,
          8067 => Opcode::VCVTTPH2UWZrm,
          8068 => Opcode::VCVTTPH2UWZrmb,
          8069 => Opcode::VCVTTPH2UWZrmbk,
          8070 => Opcode::VCVTTPH2UWZrmbkz,
          8071 => Opcode::VCVTTPH2UWZrmk,
          8072 => Opcode::VCVTTPH2UWZrmkz,
          8073 => Opcode::VCVTTPH2UWZrr,
          8074 => Opcode::VCVTTPH2UWZrrb,
          8075 => Opcode::VCVTTPH2UWZrrbk,
          8076 => Opcode::VCVTTPH2UWZrrbkz,
          8077 => Opcode::VCVTTPH2UWZrrk,
          8078 => Opcode::VCVTTPH2UWZrrkz,
          8079 => Opcode::VCVTTPH2WZ128rm,
          8080 => Opcode::VCVTTPH2WZ128rmb,
          8081 => Opcode::VCVTTPH2WZ128rmbk,
          8082 => Opcode::VCVTTPH2WZ128rmbkz,
          8083 => Opcode::VCVTTPH2WZ128rmk,
          8084 => Opcode::VCVTTPH2WZ128rmkz,
          8085 => Opcode::VCVTTPH2WZ128rr,
          8086 => Opcode::VCVTTPH2WZ128rrk,
          8087 => Opcode::VCVTTPH2WZ128rrkz,
          8088 => Opcode::VCVTTPH2WZ256rm,
          8089 => Opcode::VCVTTPH2WZ256rmb,
          8090 => Opcode::VCVTTPH2WZ256rmbk,
          8091 => Opcode::VCVTTPH2WZ256rmbkz,
          8092 => Opcode::VCVTTPH2WZ256rmk,
          8093 => Opcode::VCVTTPH2WZ256rmkz,
          8094 => Opcode::VCVTTPH2WZ256rr,
          8095 => Opcode::VCVTTPH2WZ256rrk,
          8096 => Opcode::VCVTTPH2WZ256rrkz,
          8097 => Opcode::VCVTTPH2WZrm,
          8098 => Opcode::VCVTTPH2WZrmb,
          8099 => Opcode::VCVTTPH2WZrmbk,
          8100 => Opcode::VCVTTPH2WZrmbkz,
          8101 => Opcode::VCVTTPH2WZrmk,
          8102 => Opcode::VCVTTPH2WZrmkz,
          8103 => Opcode::VCVTTPH2WZrr,
          8104 => Opcode::VCVTTPH2WZrrb,
          8105 => Opcode::VCVTTPH2WZrrbk,
          8106 => Opcode::VCVTTPH2WZrrbkz,
          8107 => Opcode::VCVTTPH2WZrrk,
          8108 => Opcode::VCVTTPH2WZrrkz,
          8109 => Opcode::VCVTTPS2DQSZ128rm,
          8110 => Opcode::VCVTTPS2DQSZ128rmb,
          8111 => Opcode::VCVTTPS2DQSZ128rmbk,
          8112 => Opcode::VCVTTPS2DQSZ128rmbkz,
          8113 => Opcode::VCVTTPS2DQSZ128rmk,
          8114 => Opcode::VCVTTPS2DQSZ128rmkz,
          8115 => Opcode::VCVTTPS2DQSZ128rr,
          8116 => Opcode::VCVTTPS2DQSZ128rrk,
          8117 => Opcode::VCVTTPS2DQSZ128rrkz,
          8118 => Opcode::VCVTTPS2DQSZ256rm,
          8119 => Opcode::VCVTTPS2DQSZ256rmb,
          8120 => Opcode::VCVTTPS2DQSZ256rmbk,
          8121 => Opcode::VCVTTPS2DQSZ256rmbkz,
          8122 => Opcode::VCVTTPS2DQSZ256rmk,
          8123 => Opcode::VCVTTPS2DQSZ256rmkz,
          8124 => Opcode::VCVTTPS2DQSZ256rr,
          8125 => Opcode::VCVTTPS2DQSZ256rrk,
          8126 => Opcode::VCVTTPS2DQSZ256rrkz,
          8127 => Opcode::VCVTTPS2DQSZrm,
          8128 => Opcode::VCVTTPS2DQSZrmb,
          8129 => Opcode::VCVTTPS2DQSZrmbk,
          8130 => Opcode::VCVTTPS2DQSZrmbkz,
          8131 => Opcode::VCVTTPS2DQSZrmk,
          8132 => Opcode::VCVTTPS2DQSZrmkz,
          8133 => Opcode::VCVTTPS2DQSZrr,
          8134 => Opcode::VCVTTPS2DQSZrrb,
          8135 => Opcode::VCVTTPS2DQSZrrbk,
          8136 => Opcode::VCVTTPS2DQSZrrbkz,
          8137 => Opcode::VCVTTPS2DQSZrrk,
          8138 => Opcode::VCVTTPS2DQSZrrkz,
          8139 => Opcode::VCVTTPS2DQYrm,
          8140 => Opcode::VCVTTPS2DQYrr,
          8141 => Opcode::VCVTTPS2DQZ128rm,
          8142 => Opcode::VCVTTPS2DQZ128rmb,
          8143 => Opcode::VCVTTPS2DQZ128rmbk,
          8144 => Opcode::VCVTTPS2DQZ128rmbkz,
          8145 => Opcode::VCVTTPS2DQZ128rmk,
          8146 => Opcode::VCVTTPS2DQZ128rmkz,
          8147 => Opcode::VCVTTPS2DQZ128rr,
          8148 => Opcode::VCVTTPS2DQZ128rrk,
          8149 => Opcode::VCVTTPS2DQZ128rrkz,
          8150 => Opcode::VCVTTPS2DQZ256rm,
          8151 => Opcode::VCVTTPS2DQZ256rmb,
          8152 => Opcode::VCVTTPS2DQZ256rmbk,
          8153 => Opcode::VCVTTPS2DQZ256rmbkz,
          8154 => Opcode::VCVTTPS2DQZ256rmk,
          8155 => Opcode::VCVTTPS2DQZ256rmkz,
          8156 => Opcode::VCVTTPS2DQZ256rr,
          8157 => Opcode::VCVTTPS2DQZ256rrk,
          8158 => Opcode::VCVTTPS2DQZ256rrkz,
          8159 => Opcode::VCVTTPS2DQZrm,
          8160 => Opcode::VCVTTPS2DQZrmb,
          8161 => Opcode::VCVTTPS2DQZrmbk,
          8162 => Opcode::VCVTTPS2DQZrmbkz,
          8163 => Opcode::VCVTTPS2DQZrmk,
          8164 => Opcode::VCVTTPS2DQZrmkz,
          8165 => Opcode::VCVTTPS2DQZrr,
          8166 => Opcode::VCVTTPS2DQZrrb,
          8167 => Opcode::VCVTTPS2DQZrrbk,
          8168 => Opcode::VCVTTPS2DQZrrbkz,
          8169 => Opcode::VCVTTPS2DQZrrk,
          8170 => Opcode::VCVTTPS2DQZrrkz,
          8171 => Opcode::VCVTTPS2DQrm,
          8172 => Opcode::VCVTTPS2DQrr,
          8173 => Opcode::VCVTTPS2IBSZ128rm,
          8174 => Opcode::VCVTTPS2IBSZ128rmb,
          8175 => Opcode::VCVTTPS2IBSZ128rmbk,
          8176 => Opcode::VCVTTPS2IBSZ128rmbkz,
          8177 => Opcode::VCVTTPS2IBSZ128rmk,
          8178 => Opcode::VCVTTPS2IBSZ128rmkz,
          8179 => Opcode::VCVTTPS2IBSZ128rr,
          8180 => Opcode::VCVTTPS2IBSZ128rrk,
          8181 => Opcode::VCVTTPS2IBSZ128rrkz,
          8182 => Opcode::VCVTTPS2IBSZ256rm,
          8183 => Opcode::VCVTTPS2IBSZ256rmb,
          8184 => Opcode::VCVTTPS2IBSZ256rmbk,
          8185 => Opcode::VCVTTPS2IBSZ256rmbkz,
          8186 => Opcode::VCVTTPS2IBSZ256rmk,
          8187 => Opcode::VCVTTPS2IBSZ256rmkz,
          8188 => Opcode::VCVTTPS2IBSZ256rr,
          8189 => Opcode::VCVTTPS2IBSZ256rrk,
          8190 => Opcode::VCVTTPS2IBSZ256rrkz,
          8191 => Opcode::VCVTTPS2IBSZrm,
          8192 => Opcode::VCVTTPS2IBSZrmb,
          8193 => Opcode::VCVTTPS2IBSZrmbk,
          8194 => Opcode::VCVTTPS2IBSZrmbkz,
          8195 => Opcode::VCVTTPS2IBSZrmk,
          8196 => Opcode::VCVTTPS2IBSZrmkz,
          8197 => Opcode::VCVTTPS2IBSZrr,
          8198 => Opcode::VCVTTPS2IBSZrrb,
          8199 => Opcode::VCVTTPS2IBSZrrbk,
          8200 => Opcode::VCVTTPS2IBSZrrbkz,
          8201 => Opcode::VCVTTPS2IBSZrrk,
          8202 => Opcode::VCVTTPS2IBSZrrkz,
          8203 => Opcode::VCVTTPS2IUBSZ128rm,
          8204 => Opcode::VCVTTPS2IUBSZ128rmb,
          8205 => Opcode::VCVTTPS2IUBSZ128rmbk,
          8206 => Opcode::VCVTTPS2IUBSZ128rmbkz,
          8207 => Opcode::VCVTTPS2IUBSZ128rmk,
          8208 => Opcode::VCVTTPS2IUBSZ128rmkz,
          8209 => Opcode::VCVTTPS2IUBSZ128rr,
          8210 => Opcode::VCVTTPS2IUBSZ128rrk,
          8211 => Opcode::VCVTTPS2IUBSZ128rrkz,
          8212 => Opcode::VCVTTPS2IUBSZ256rm,
          8213 => Opcode::VCVTTPS2IUBSZ256rmb,
          8214 => Opcode::VCVTTPS2IUBSZ256rmbk,
          8215 => Opcode::VCVTTPS2IUBSZ256rmbkz,
          8216 => Opcode::VCVTTPS2IUBSZ256rmk,
          8217 => Opcode::VCVTTPS2IUBSZ256rmkz,
          8218 => Opcode::VCVTTPS2IUBSZ256rr,
          8219 => Opcode::VCVTTPS2IUBSZ256rrk,
          8220 => Opcode::VCVTTPS2IUBSZ256rrkz,
          8221 => Opcode::VCVTTPS2IUBSZrm,
          8222 => Opcode::VCVTTPS2IUBSZrmb,
          8223 => Opcode::VCVTTPS2IUBSZrmbk,
          8224 => Opcode::VCVTTPS2IUBSZrmbkz,
          8225 => Opcode::VCVTTPS2IUBSZrmk,
          8226 => Opcode::VCVTTPS2IUBSZrmkz,
          8227 => Opcode::VCVTTPS2IUBSZrr,
          8228 => Opcode::VCVTTPS2IUBSZrrb,
          8229 => Opcode::VCVTTPS2IUBSZrrbk,
          8230 => Opcode::VCVTTPS2IUBSZrrbkz,
          8231 => Opcode::VCVTTPS2IUBSZrrk,
          8232 => Opcode::VCVTTPS2IUBSZrrkz,
          8233 => Opcode::VCVTTPS2QQSZ128rm,
          8234 => Opcode::VCVTTPS2QQSZ128rmb,
          8235 => Opcode::VCVTTPS2QQSZ128rmbk,
          8236 => Opcode::VCVTTPS2QQSZ128rmbkz,
          8237 => Opcode::VCVTTPS2QQSZ128rmk,
          8238 => Opcode::VCVTTPS2QQSZ128rmkz,
          8239 => Opcode::VCVTTPS2QQSZ128rr,
          8240 => Opcode::VCVTTPS2QQSZ128rrk,
          8241 => Opcode::VCVTTPS2QQSZ128rrkz,
          8242 => Opcode::VCVTTPS2QQSZ256rm,
          8243 => Opcode::VCVTTPS2QQSZ256rmb,
          8244 => Opcode::VCVTTPS2QQSZ256rmbk,
          8245 => Opcode::VCVTTPS2QQSZ256rmbkz,
          8246 => Opcode::VCVTTPS2QQSZ256rmk,
          8247 => Opcode::VCVTTPS2QQSZ256rmkz,
          8248 => Opcode::VCVTTPS2QQSZ256rr,
          8249 => Opcode::VCVTTPS2QQSZ256rrb,
          8250 => Opcode::VCVTTPS2QQSZ256rrbk,
          8251 => Opcode::VCVTTPS2QQSZ256rrbkz,
          8252 => Opcode::VCVTTPS2QQSZ256rrk,
          8253 => Opcode::VCVTTPS2QQSZ256rrkz,
          8254 => Opcode::VCVTTPS2QQSZrm,
          8255 => Opcode::VCVTTPS2QQSZrmb,
          8256 => Opcode::VCVTTPS2QQSZrmbk,
          8257 => Opcode::VCVTTPS2QQSZrmbkz,
          8258 => Opcode::VCVTTPS2QQSZrmk,
          8259 => Opcode::VCVTTPS2QQSZrmkz,
          8260 => Opcode::VCVTTPS2QQSZrr,
          8261 => Opcode::VCVTTPS2QQSZrrb,
          8262 => Opcode::VCVTTPS2QQSZrrbk,
          8263 => Opcode::VCVTTPS2QQSZrrbkz,
          8264 => Opcode::VCVTTPS2QQSZrrk,
          8265 => Opcode::VCVTTPS2QQSZrrkz,
          8266 => Opcode::VCVTTPS2QQZ128rm,
          8267 => Opcode::VCVTTPS2QQZ128rmb,
          8268 => Opcode::VCVTTPS2QQZ128rmbk,
          8269 => Opcode::VCVTTPS2QQZ128rmbkz,
          8270 => Opcode::VCVTTPS2QQZ128rmk,
          8271 => Opcode::VCVTTPS2QQZ128rmkz,
          8272 => Opcode::VCVTTPS2QQZ128rr,
          8273 => Opcode::VCVTTPS2QQZ128rrk,
          8274 => Opcode::VCVTTPS2QQZ128rrkz,
          8275 => Opcode::VCVTTPS2QQZ256rm,
          8276 => Opcode::VCVTTPS2QQZ256rmb,
          8277 => Opcode::VCVTTPS2QQZ256rmbk,
          8278 => Opcode::VCVTTPS2QQZ256rmbkz,
          8279 => Opcode::VCVTTPS2QQZ256rmk,
          8280 => Opcode::VCVTTPS2QQZ256rmkz,
          8281 => Opcode::VCVTTPS2QQZ256rr,
          8282 => Opcode::VCVTTPS2QQZ256rrk,
          8283 => Opcode::VCVTTPS2QQZ256rrkz,
          8284 => Opcode::VCVTTPS2QQZrm,
          8285 => Opcode::VCVTTPS2QQZrmb,
          8286 => Opcode::VCVTTPS2QQZrmbk,
          8287 => Opcode::VCVTTPS2QQZrmbkz,
          8288 => Opcode::VCVTTPS2QQZrmk,
          8289 => Opcode::VCVTTPS2QQZrmkz,
          8290 => Opcode::VCVTTPS2QQZrr,
          8291 => Opcode::VCVTTPS2QQZrrb,
          8292 => Opcode::VCVTTPS2QQZrrbk,
          8293 => Opcode::VCVTTPS2QQZrrbkz,
          8294 => Opcode::VCVTTPS2QQZrrk,
          8295 => Opcode::VCVTTPS2QQZrrkz,
          8296 => Opcode::VCVTTPS2UDQSZ128rm,
          8297 => Opcode::VCVTTPS2UDQSZ128rmb,
          8298 => Opcode::VCVTTPS2UDQSZ128rmbk,
          8299 => Opcode::VCVTTPS2UDQSZ128rmbkz,
          8300 => Opcode::VCVTTPS2UDQSZ128rmk,
          8301 => Opcode::VCVTTPS2UDQSZ128rmkz,
          8302 => Opcode::VCVTTPS2UDQSZ128rr,
          8303 => Opcode::VCVTTPS2UDQSZ128rrk,
          8304 => Opcode::VCVTTPS2UDQSZ128rrkz,
          8305 => Opcode::VCVTTPS2UDQSZ256rm,
          8306 => Opcode::VCVTTPS2UDQSZ256rmb,
          8307 => Opcode::VCVTTPS2UDQSZ256rmbk,
          8308 => Opcode::VCVTTPS2UDQSZ256rmbkz,
          8309 => Opcode::VCVTTPS2UDQSZ256rmk,
          8310 => Opcode::VCVTTPS2UDQSZ256rmkz,
          8311 => Opcode::VCVTTPS2UDQSZ256rr,
          8312 => Opcode::VCVTTPS2UDQSZ256rrk,
          8313 => Opcode::VCVTTPS2UDQSZ256rrkz,
          8314 => Opcode::VCVTTPS2UDQSZrm,
          8315 => Opcode::VCVTTPS2UDQSZrmb,
          8316 => Opcode::VCVTTPS2UDQSZrmbk,
          8317 => Opcode::VCVTTPS2UDQSZrmbkz,
          8318 => Opcode::VCVTTPS2UDQSZrmk,
          8319 => Opcode::VCVTTPS2UDQSZrmkz,
          8320 => Opcode::VCVTTPS2UDQSZrr,
          8321 => Opcode::VCVTTPS2UDQSZrrb,
          8322 => Opcode::VCVTTPS2UDQSZrrbk,
          8323 => Opcode::VCVTTPS2UDQSZrrbkz,
          8324 => Opcode::VCVTTPS2UDQSZrrk,
          8325 => Opcode::VCVTTPS2UDQSZrrkz,
          8326 => Opcode::VCVTTPS2UDQZ128rm,
          8327 => Opcode::VCVTTPS2UDQZ128rmb,
          8328 => Opcode::VCVTTPS2UDQZ128rmbk,
          8329 => Opcode::VCVTTPS2UDQZ128rmbkz,
          8330 => Opcode::VCVTTPS2UDQZ128rmk,
          8331 => Opcode::VCVTTPS2UDQZ128rmkz,
          8332 => Opcode::VCVTTPS2UDQZ128rr,
          8333 => Opcode::VCVTTPS2UDQZ128rrk,
          8334 => Opcode::VCVTTPS2UDQZ128rrkz,
          8335 => Opcode::VCVTTPS2UDQZ256rm,
          8336 => Opcode::VCVTTPS2UDQZ256rmb,
          8337 => Opcode::VCVTTPS2UDQZ256rmbk,
          8338 => Opcode::VCVTTPS2UDQZ256rmbkz,
          8339 => Opcode::VCVTTPS2UDQZ256rmk,
          8340 => Opcode::VCVTTPS2UDQZ256rmkz,
          8341 => Opcode::VCVTTPS2UDQZ256rr,
          8342 => Opcode::VCVTTPS2UDQZ256rrk,
          8343 => Opcode::VCVTTPS2UDQZ256rrkz,
          8344 => Opcode::VCVTTPS2UDQZrm,
          8345 => Opcode::VCVTTPS2UDQZrmb,
          8346 => Opcode::VCVTTPS2UDQZrmbk,
          8347 => Opcode::VCVTTPS2UDQZrmbkz,
          8348 => Opcode::VCVTTPS2UDQZrmk,
          8349 => Opcode::VCVTTPS2UDQZrmkz,
          8350 => Opcode::VCVTTPS2UDQZrr,
          8351 => Opcode::VCVTTPS2UDQZrrb,
          8352 => Opcode::VCVTTPS2UDQZrrbk,
          8353 => Opcode::VCVTTPS2UDQZrrbkz,
          8354 => Opcode::VCVTTPS2UDQZrrk,
          8355 => Opcode::VCVTTPS2UDQZrrkz,
          8356 => Opcode::VCVTTPS2UQQSZ128rm,
          8357 => Opcode::VCVTTPS2UQQSZ128rmb,
          8358 => Opcode::VCVTTPS2UQQSZ128rmbk,
          8359 => Opcode::VCVTTPS2UQQSZ128rmbkz,
          8360 => Opcode::VCVTTPS2UQQSZ128rmk,
          8361 => Opcode::VCVTTPS2UQQSZ128rmkz,
          8362 => Opcode::VCVTTPS2UQQSZ128rr,
          8363 => Opcode::VCVTTPS2UQQSZ128rrk,
          8364 => Opcode::VCVTTPS2UQQSZ128rrkz,
          8365 => Opcode::VCVTTPS2UQQSZ256rm,
          8366 => Opcode::VCVTTPS2UQQSZ256rmb,
          8367 => Opcode::VCVTTPS2UQQSZ256rmbk,
          8368 => Opcode::VCVTTPS2UQQSZ256rmbkz,
          8369 => Opcode::VCVTTPS2UQQSZ256rmk,
          8370 => Opcode::VCVTTPS2UQQSZ256rmkz,
          8371 => Opcode::VCVTTPS2UQQSZ256rr,
          8372 => Opcode::VCVTTPS2UQQSZ256rrb,
          8373 => Opcode::VCVTTPS2UQQSZ256rrbk,
          8374 => Opcode::VCVTTPS2UQQSZ256rrbkz,
          8375 => Opcode::VCVTTPS2UQQSZ256rrk,
          8376 => Opcode::VCVTTPS2UQQSZ256rrkz,
          8377 => Opcode::VCVTTPS2UQQSZrm,
          8378 => Opcode::VCVTTPS2UQQSZrmb,
          8379 => Opcode::VCVTTPS2UQQSZrmbk,
          8380 => Opcode::VCVTTPS2UQQSZrmbkz,
          8381 => Opcode::VCVTTPS2UQQSZrmk,
          8382 => Opcode::VCVTTPS2UQQSZrmkz,
          8383 => Opcode::VCVTTPS2UQQSZrr,
          8384 => Opcode::VCVTTPS2UQQSZrrb,
          8385 => Opcode::VCVTTPS2UQQSZrrbk,
          8386 => Opcode::VCVTTPS2UQQSZrrbkz,
          8387 => Opcode::VCVTTPS2UQQSZrrk,
          8388 => Opcode::VCVTTPS2UQQSZrrkz,
          8389 => Opcode::VCVTTPS2UQQZ128rm,
          8390 => Opcode::VCVTTPS2UQQZ128rmb,
          8391 => Opcode::VCVTTPS2UQQZ128rmbk,
          8392 => Opcode::VCVTTPS2UQQZ128rmbkz,
          8393 => Opcode::VCVTTPS2UQQZ128rmk,
          8394 => Opcode::VCVTTPS2UQQZ128rmkz,
          8395 => Opcode::VCVTTPS2UQQZ128rr,
          8396 => Opcode::VCVTTPS2UQQZ128rrk,
          8397 => Opcode::VCVTTPS2UQQZ128rrkz,
          8398 => Opcode::VCVTTPS2UQQZ256rm,
          8399 => Opcode::VCVTTPS2UQQZ256rmb,
          8400 => Opcode::VCVTTPS2UQQZ256rmbk,
          8401 => Opcode::VCVTTPS2UQQZ256rmbkz,
          8402 => Opcode::VCVTTPS2UQQZ256rmk,
          8403 => Opcode::VCVTTPS2UQQZ256rmkz,
          8404 => Opcode::VCVTTPS2UQQZ256rr,
          8405 => Opcode::VCVTTPS2UQQZ256rrk,
          8406 => Opcode::VCVTTPS2UQQZ256rrkz,
          8407 => Opcode::VCVTTPS2UQQZrm,
          8408 => Opcode::VCVTTPS2UQQZrmb,
          8409 => Opcode::VCVTTPS2UQQZrmbk,
          8410 => Opcode::VCVTTPS2UQQZrmbkz,
          8411 => Opcode::VCVTTPS2UQQZrmk,
          8412 => Opcode::VCVTTPS2UQQZrmkz,
          8413 => Opcode::VCVTTPS2UQQZrr,
          8414 => Opcode::VCVTTPS2UQQZrrb,
          8415 => Opcode::VCVTTPS2UQQZrrbk,
          8416 => Opcode::VCVTTPS2UQQZrrbkz,
          8417 => Opcode::VCVTTPS2UQQZrrk,
          8418 => Opcode::VCVTTPS2UQQZrrkz,
          8419 => Opcode::VCVTTSD2SI64Srm,
          8420 => Opcode::VCVTTSD2SI64Srm_Int,
          8421 => Opcode::VCVTTSD2SI64Srr,
          8422 => Opcode::VCVTTSD2SI64Srr_Int,
          8423 => Opcode::VCVTTSD2SI64Srrb_Int,
          8424 => Opcode::VCVTTSD2SI64Zrm,
          8425 => Opcode::VCVTTSD2SI64Zrm_Int,
          8426 => Opcode::VCVTTSD2SI64Zrr,
          8427 => Opcode::VCVTTSD2SI64Zrr_Int,
          8428 => Opcode::VCVTTSD2SI64Zrrb_Int,
          8429 => Opcode::VCVTTSD2SI64rm,
          8430 => Opcode::VCVTTSD2SI64rm_Int,
          8431 => Opcode::VCVTTSD2SI64rr,
          8432 => Opcode::VCVTTSD2SI64rr_Int,
          8433 => Opcode::VCVTTSD2SISrm,
          8434 => Opcode::VCVTTSD2SISrm_Int,
          8435 => Opcode::VCVTTSD2SISrr,
          8436 => Opcode::VCVTTSD2SISrr_Int,
          8437 => Opcode::VCVTTSD2SISrrb_Int,
          8438 => Opcode::VCVTTSD2SIZrm,
          8439 => Opcode::VCVTTSD2SIZrm_Int,
          8440 => Opcode::VCVTTSD2SIZrr,
          8441 => Opcode::VCVTTSD2SIZrr_Int,
          8442 => Opcode::VCVTTSD2SIZrrb_Int,
          8443 => Opcode::VCVTTSD2SIrm,
          8444 => Opcode::VCVTTSD2SIrm_Int,
          8445 => Opcode::VCVTTSD2SIrr,
          8446 => Opcode::VCVTTSD2SIrr_Int,
          8447 => Opcode::VCVTTSD2USI64Srm,
          8448 => Opcode::VCVTTSD2USI64Srm_Int,
          8449 => Opcode::VCVTTSD2USI64Srr,
          8450 => Opcode::VCVTTSD2USI64Srr_Int,
          8451 => Opcode::VCVTTSD2USI64Srrb_Int,
          8452 => Opcode::VCVTTSD2USI64Zrm,
          8453 => Opcode::VCVTTSD2USI64Zrm_Int,
          8454 => Opcode::VCVTTSD2USI64Zrr,
          8455 => Opcode::VCVTTSD2USI64Zrr_Int,
          8456 => Opcode::VCVTTSD2USI64Zrrb_Int,
          8457 => Opcode::VCVTTSD2USISrm,
          8458 => Opcode::VCVTTSD2USISrm_Int,
          8459 => Opcode::VCVTTSD2USISrr,
          8460 => Opcode::VCVTTSD2USISrr_Int,
          8461 => Opcode::VCVTTSD2USISrrb_Int,
          8462 => Opcode::VCVTTSD2USIZrm,
          8463 => Opcode::VCVTTSD2USIZrm_Int,
          8464 => Opcode::VCVTTSD2USIZrr,
          8465 => Opcode::VCVTTSD2USIZrr_Int,
          8466 => Opcode::VCVTTSD2USIZrrb_Int,
          8467 => Opcode::VCVTTSH2SI64Zrm,
          8468 => Opcode::VCVTTSH2SI64Zrm_Int,
          8469 => Opcode::VCVTTSH2SI64Zrr,
          8470 => Opcode::VCVTTSH2SI64Zrr_Int,
          8471 => Opcode::VCVTTSH2SI64Zrrb_Int,
          8472 => Opcode::VCVTTSH2SIZrm,
          8473 => Opcode::VCVTTSH2SIZrm_Int,
          8474 => Opcode::VCVTTSH2SIZrr,
          8475 => Opcode::VCVTTSH2SIZrr_Int,
          8476 => Opcode::VCVTTSH2SIZrrb_Int,
          8477 => Opcode::VCVTTSH2USI64Zrm,
          8478 => Opcode::VCVTTSH2USI64Zrm_Int,
          8479 => Opcode::VCVTTSH2USI64Zrr,
          8480 => Opcode::VCVTTSH2USI64Zrr_Int,
          8481 => Opcode::VCVTTSH2USI64Zrrb_Int,
          8482 => Opcode::VCVTTSH2USIZrm,
          8483 => Opcode::VCVTTSH2USIZrm_Int,
          8484 => Opcode::VCVTTSH2USIZrr,
          8485 => Opcode::VCVTTSH2USIZrr_Int,
          8486 => Opcode::VCVTTSH2USIZrrb_Int,
          8487 => Opcode::VCVTTSS2SI64Srm,
          8488 => Opcode::VCVTTSS2SI64Srm_Int,
          8489 => Opcode::VCVTTSS2SI64Srr,
          8490 => Opcode::VCVTTSS2SI64Srr_Int,
          8491 => Opcode::VCVTTSS2SI64Srrb_Int,
          8492 => Opcode::VCVTTSS2SI64Zrm,
          8493 => Opcode::VCVTTSS2SI64Zrm_Int,
          8494 => Opcode::VCVTTSS2SI64Zrr,
          8495 => Opcode::VCVTTSS2SI64Zrr_Int,
          8496 => Opcode::VCVTTSS2SI64Zrrb_Int,
          8497 => Opcode::VCVTTSS2SI64rm,
          8498 => Opcode::VCVTTSS2SI64rm_Int,
          8499 => Opcode::VCVTTSS2SI64rr,
          8500 => Opcode::VCVTTSS2SI64rr_Int,
          8501 => Opcode::VCVTTSS2SISrm,
          8502 => Opcode::VCVTTSS2SISrm_Int,
          8503 => Opcode::VCVTTSS2SISrr,
          8504 => Opcode::VCVTTSS2SISrr_Int,
          8505 => Opcode::VCVTTSS2SISrrb_Int,
          8506 => Opcode::VCVTTSS2SIZrm,
          8507 => Opcode::VCVTTSS2SIZrm_Int,
          8508 => Opcode::VCVTTSS2SIZrr,
          8509 => Opcode::VCVTTSS2SIZrr_Int,
          8510 => Opcode::VCVTTSS2SIZrrb_Int,
          8511 => Opcode::VCVTTSS2SIrm,
          8512 => Opcode::VCVTTSS2SIrm_Int,
          8513 => Opcode::VCVTTSS2SIrr,
          8514 => Opcode::VCVTTSS2SIrr_Int,
          8515 => Opcode::VCVTTSS2USI64Srm,
          8516 => Opcode::VCVTTSS2USI64Srm_Int,
          8517 => Opcode::VCVTTSS2USI64Srr,
          8518 => Opcode::VCVTTSS2USI64Srr_Int,
          8519 => Opcode::VCVTTSS2USI64Srrb_Int,
          8520 => Opcode::VCVTTSS2USI64Zrm,
          8521 => Opcode::VCVTTSS2USI64Zrm_Int,
          8522 => Opcode::VCVTTSS2USI64Zrr,
          8523 => Opcode::VCVTTSS2USI64Zrr_Int,
          8524 => Opcode::VCVTTSS2USI64Zrrb_Int,
          8525 => Opcode::VCVTTSS2USISrm,
          8526 => Opcode::VCVTTSS2USISrm_Int,
          8527 => Opcode::VCVTTSS2USISrr,
          8528 => Opcode::VCVTTSS2USISrr_Int,
          8529 => Opcode::VCVTTSS2USISrrb_Int,
          8530 => Opcode::VCVTTSS2USIZrm,
          8531 => Opcode::VCVTTSS2USIZrm_Int,
          8532 => Opcode::VCVTTSS2USIZrr,
          8533 => Opcode::VCVTTSS2USIZrr_Int,
          8534 => Opcode::VCVTTSS2USIZrrb_Int,
          8535 => Opcode::VCVTUDQ2PDZ128rm,
          8536 => Opcode::VCVTUDQ2PDZ128rmb,
          8537 => Opcode::VCVTUDQ2PDZ128rmbk,
          8538 => Opcode::VCVTUDQ2PDZ128rmbkz,
          8539 => Opcode::VCVTUDQ2PDZ128rmk,
          8540 => Opcode::VCVTUDQ2PDZ128rmkz,
          8541 => Opcode::VCVTUDQ2PDZ128rr,
          8542 => Opcode::VCVTUDQ2PDZ128rrk,
          8543 => Opcode::VCVTUDQ2PDZ128rrkz,
          8544 => Opcode::VCVTUDQ2PDZ256rm,
          8545 => Opcode::VCVTUDQ2PDZ256rmb,
          8546 => Opcode::VCVTUDQ2PDZ256rmbk,
          8547 => Opcode::VCVTUDQ2PDZ256rmbkz,
          8548 => Opcode::VCVTUDQ2PDZ256rmk,
          8549 => Opcode::VCVTUDQ2PDZ256rmkz,
          8550 => Opcode::VCVTUDQ2PDZ256rr,
          8551 => Opcode::VCVTUDQ2PDZ256rrk,
          8552 => Opcode::VCVTUDQ2PDZ256rrkz,
          8553 => Opcode::VCVTUDQ2PDZrm,
          8554 => Opcode::VCVTUDQ2PDZrmb,
          8555 => Opcode::VCVTUDQ2PDZrmbk,
          8556 => Opcode::VCVTUDQ2PDZrmbkz,
          8557 => Opcode::VCVTUDQ2PDZrmk,
          8558 => Opcode::VCVTUDQ2PDZrmkz,
          8559 => Opcode::VCVTUDQ2PDZrr,
          8560 => Opcode::VCVTUDQ2PDZrrk,
          8561 => Opcode::VCVTUDQ2PDZrrkz,
          8562 => Opcode::VCVTUDQ2PHZ128rm,
          8563 => Opcode::VCVTUDQ2PHZ128rmb,
          8564 => Opcode::VCVTUDQ2PHZ128rmbk,
          8565 => Opcode::VCVTUDQ2PHZ128rmbkz,
          8566 => Opcode::VCVTUDQ2PHZ128rmk,
          8567 => Opcode::VCVTUDQ2PHZ128rmkz,
          8568 => Opcode::VCVTUDQ2PHZ128rr,
          8569 => Opcode::VCVTUDQ2PHZ128rrk,
          8570 => Opcode::VCVTUDQ2PHZ128rrkz,
          8571 => Opcode::VCVTUDQ2PHZ256rm,
          8572 => Opcode::VCVTUDQ2PHZ256rmb,
          8573 => Opcode::VCVTUDQ2PHZ256rmbk,
          8574 => Opcode::VCVTUDQ2PHZ256rmbkz,
          8575 => Opcode::VCVTUDQ2PHZ256rmk,
          8576 => Opcode::VCVTUDQ2PHZ256rmkz,
          8577 => Opcode::VCVTUDQ2PHZ256rr,
          8578 => Opcode::VCVTUDQ2PHZ256rrk,
          8579 => Opcode::VCVTUDQ2PHZ256rrkz,
          8580 => Opcode::VCVTUDQ2PHZrm,
          8581 => Opcode::VCVTUDQ2PHZrmb,
          8582 => Opcode::VCVTUDQ2PHZrmbk,
          8583 => Opcode::VCVTUDQ2PHZrmbkz,
          8584 => Opcode::VCVTUDQ2PHZrmk,
          8585 => Opcode::VCVTUDQ2PHZrmkz,
          8586 => Opcode::VCVTUDQ2PHZrr,
          8587 => Opcode::VCVTUDQ2PHZrrb,
          8588 => Opcode::VCVTUDQ2PHZrrbk,
          8589 => Opcode::VCVTUDQ2PHZrrbkz,
          8590 => Opcode::VCVTUDQ2PHZrrk,
          8591 => Opcode::VCVTUDQ2PHZrrkz,
          8592 => Opcode::VCVTUDQ2PSZ128rm,
          8593 => Opcode::VCVTUDQ2PSZ128rmb,
          8594 => Opcode::VCVTUDQ2PSZ128rmbk,
          8595 => Opcode::VCVTUDQ2PSZ128rmbkz,
          8596 => Opcode::VCVTUDQ2PSZ128rmk,
          8597 => Opcode::VCVTUDQ2PSZ128rmkz,
          8598 => Opcode::VCVTUDQ2PSZ128rr,
          8599 => Opcode::VCVTUDQ2PSZ128rrk,
          8600 => Opcode::VCVTUDQ2PSZ128rrkz,
          8601 => Opcode::VCVTUDQ2PSZ256rm,
          8602 => Opcode::VCVTUDQ2PSZ256rmb,
          8603 => Opcode::VCVTUDQ2PSZ256rmbk,
          8604 => Opcode::VCVTUDQ2PSZ256rmbkz,
          8605 => Opcode::VCVTUDQ2PSZ256rmk,
          8606 => Opcode::VCVTUDQ2PSZ256rmkz,
          8607 => Opcode::VCVTUDQ2PSZ256rr,
          8608 => Opcode::VCVTUDQ2PSZ256rrk,
          8609 => Opcode::VCVTUDQ2PSZ256rrkz,
          8610 => Opcode::VCVTUDQ2PSZrm,
          8611 => Opcode::VCVTUDQ2PSZrmb,
          8612 => Opcode::VCVTUDQ2PSZrmbk,
          8613 => Opcode::VCVTUDQ2PSZrmbkz,
          8614 => Opcode::VCVTUDQ2PSZrmk,
          8615 => Opcode::VCVTUDQ2PSZrmkz,
          8616 => Opcode::VCVTUDQ2PSZrr,
          8617 => Opcode::VCVTUDQ2PSZrrb,
          8618 => Opcode::VCVTUDQ2PSZrrbk,
          8619 => Opcode::VCVTUDQ2PSZrrbkz,
          8620 => Opcode::VCVTUDQ2PSZrrk,
          8621 => Opcode::VCVTUDQ2PSZrrkz,
          8622 => Opcode::VCVTUQQ2PDZ128rm,
          8623 => Opcode::VCVTUQQ2PDZ128rmb,
          8624 => Opcode::VCVTUQQ2PDZ128rmbk,
          8625 => Opcode::VCVTUQQ2PDZ128rmbkz,
          8626 => Opcode::VCVTUQQ2PDZ128rmk,
          8627 => Opcode::VCVTUQQ2PDZ128rmkz,
          8628 => Opcode::VCVTUQQ2PDZ128rr,
          8629 => Opcode::VCVTUQQ2PDZ128rrk,
          8630 => Opcode::VCVTUQQ2PDZ128rrkz,
          8631 => Opcode::VCVTUQQ2PDZ256rm,
          8632 => Opcode::VCVTUQQ2PDZ256rmb,
          8633 => Opcode::VCVTUQQ2PDZ256rmbk,
          8634 => Opcode::VCVTUQQ2PDZ256rmbkz,
          8635 => Opcode::VCVTUQQ2PDZ256rmk,
          8636 => Opcode::VCVTUQQ2PDZ256rmkz,
          8637 => Opcode::VCVTUQQ2PDZ256rr,
          8638 => Opcode::VCVTUQQ2PDZ256rrk,
          8639 => Opcode::VCVTUQQ2PDZ256rrkz,
          8640 => Opcode::VCVTUQQ2PDZrm,
          8641 => Opcode::VCVTUQQ2PDZrmb,
          8642 => Opcode::VCVTUQQ2PDZrmbk,
          8643 => Opcode::VCVTUQQ2PDZrmbkz,
          8644 => Opcode::VCVTUQQ2PDZrmk,
          8645 => Opcode::VCVTUQQ2PDZrmkz,
          8646 => Opcode::VCVTUQQ2PDZrr,
          8647 => Opcode::VCVTUQQ2PDZrrb,
          8648 => Opcode::VCVTUQQ2PDZrrbk,
          8649 => Opcode::VCVTUQQ2PDZrrbkz,
          8650 => Opcode::VCVTUQQ2PDZrrk,
          8651 => Opcode::VCVTUQQ2PDZrrkz,
          8652 => Opcode::VCVTUQQ2PHZ128rm,
          8653 => Opcode::VCVTUQQ2PHZ128rmb,
          8654 => Opcode::VCVTUQQ2PHZ128rmbk,
          8655 => Opcode::VCVTUQQ2PHZ128rmbkz,
          8656 => Opcode::VCVTUQQ2PHZ128rmk,
          8657 => Opcode::VCVTUQQ2PHZ128rmkz,
          8658 => Opcode::VCVTUQQ2PHZ128rr,
          8659 => Opcode::VCVTUQQ2PHZ128rrk,
          8660 => Opcode::VCVTUQQ2PHZ128rrkz,
          8661 => Opcode::VCVTUQQ2PHZ256rm,
          8662 => Opcode::VCVTUQQ2PHZ256rmb,
          8663 => Opcode::VCVTUQQ2PHZ256rmbk,
          8664 => Opcode::VCVTUQQ2PHZ256rmbkz,
          8665 => Opcode::VCVTUQQ2PHZ256rmk,
          8666 => Opcode::VCVTUQQ2PHZ256rmkz,
          8667 => Opcode::VCVTUQQ2PHZ256rr,
          8668 => Opcode::VCVTUQQ2PHZ256rrk,
          8669 => Opcode::VCVTUQQ2PHZ256rrkz,
          8670 => Opcode::VCVTUQQ2PHZrm,
          8671 => Opcode::VCVTUQQ2PHZrmb,
          8672 => Opcode::VCVTUQQ2PHZrmbk,
          8673 => Opcode::VCVTUQQ2PHZrmbkz,
          8674 => Opcode::VCVTUQQ2PHZrmk,
          8675 => Opcode::VCVTUQQ2PHZrmkz,
          8676 => Opcode::VCVTUQQ2PHZrr,
          8677 => Opcode::VCVTUQQ2PHZrrb,
          8678 => Opcode::VCVTUQQ2PHZrrbk,
          8679 => Opcode::VCVTUQQ2PHZrrbkz,
          8680 => Opcode::VCVTUQQ2PHZrrk,
          8681 => Opcode::VCVTUQQ2PHZrrkz,
          8682 => Opcode::VCVTUQQ2PSZ128rm,
          8683 => Opcode::VCVTUQQ2PSZ128rmb,
          8684 => Opcode::VCVTUQQ2PSZ128rmbk,
          8685 => Opcode::VCVTUQQ2PSZ128rmbkz,
          8686 => Opcode::VCVTUQQ2PSZ128rmk,
          8687 => Opcode::VCVTUQQ2PSZ128rmkz,
          8688 => Opcode::VCVTUQQ2PSZ128rr,
          8689 => Opcode::VCVTUQQ2PSZ128rrk,
          8690 => Opcode::VCVTUQQ2PSZ128rrkz,
          8691 => Opcode::VCVTUQQ2PSZ256rm,
          8692 => Opcode::VCVTUQQ2PSZ256rmb,
          8693 => Opcode::VCVTUQQ2PSZ256rmbk,
          8694 => Opcode::VCVTUQQ2PSZ256rmbkz,
          8695 => Opcode::VCVTUQQ2PSZ256rmk,
          8696 => Opcode::VCVTUQQ2PSZ256rmkz,
          8697 => Opcode::VCVTUQQ2PSZ256rr,
          8698 => Opcode::VCVTUQQ2PSZ256rrk,
          8699 => Opcode::VCVTUQQ2PSZ256rrkz,
          8700 => Opcode::VCVTUQQ2PSZrm,
          8701 => Opcode::VCVTUQQ2PSZrmb,
          8702 => Opcode::VCVTUQQ2PSZrmbk,
          8703 => Opcode::VCVTUQQ2PSZrmbkz,
          8704 => Opcode::VCVTUQQ2PSZrmk,
          8705 => Opcode::VCVTUQQ2PSZrmkz,
          8706 => Opcode::VCVTUQQ2PSZrr,
          8707 => Opcode::VCVTUQQ2PSZrrb,
          8708 => Opcode::VCVTUQQ2PSZrrbk,
          8709 => Opcode::VCVTUQQ2PSZrrbkz,
          8710 => Opcode::VCVTUQQ2PSZrrk,
          8711 => Opcode::VCVTUQQ2PSZrrkz,
          8712 => Opcode::VCVTUSI2SDZrm,
          8713 => Opcode::VCVTUSI2SDZrm_Int,
          8714 => Opcode::VCVTUSI2SDZrr,
          8715 => Opcode::VCVTUSI2SDZrr_Int,
          8716 => Opcode::VCVTUSI2SHZrm,
          8717 => Opcode::VCVTUSI2SHZrm_Int,
          8718 => Opcode::VCVTUSI2SHZrr,
          8719 => Opcode::VCVTUSI2SHZrr_Int,
          8720 => Opcode::VCVTUSI2SHZrrb_Int,
          8721 => Opcode::VCVTUSI2SSZrm,
          8722 => Opcode::VCVTUSI2SSZrm_Int,
          8723 => Opcode::VCVTUSI2SSZrr,
          8724 => Opcode::VCVTUSI2SSZrr_Int,
          8725 => Opcode::VCVTUSI2SSZrrb_Int,
          8726 => Opcode::VCVTUSI642SDZrm,
          8727 => Opcode::VCVTUSI642SDZrm_Int,
          8728 => Opcode::VCVTUSI642SDZrr,
          8729 => Opcode::VCVTUSI642SDZrr_Int,
          8730 => Opcode::VCVTUSI642SDZrrb_Int,
          8731 => Opcode::VCVTUSI642SHZrm,
          8732 => Opcode::VCVTUSI642SHZrm_Int,
          8733 => Opcode::VCVTUSI642SHZrr,
          8734 => Opcode::VCVTUSI642SHZrr_Int,
          8735 => Opcode::VCVTUSI642SHZrrb_Int,
          8736 => Opcode::VCVTUSI642SSZrm,
          8737 => Opcode::VCVTUSI642SSZrm_Int,
          8738 => Opcode::VCVTUSI642SSZrr,
          8739 => Opcode::VCVTUSI642SSZrr_Int,
          8740 => Opcode::VCVTUSI642SSZrrb_Int,
          8741 => Opcode::VCVTUW2PHZ128rm,
          8742 => Opcode::VCVTUW2PHZ128rmb,
          8743 => Opcode::VCVTUW2PHZ128rmbk,
          8744 => Opcode::VCVTUW2PHZ128rmbkz,
          8745 => Opcode::VCVTUW2PHZ128rmk,
          8746 => Opcode::VCVTUW2PHZ128rmkz,
          8747 => Opcode::VCVTUW2PHZ128rr,
          8748 => Opcode::VCVTUW2PHZ128rrk,
          8749 => Opcode::VCVTUW2PHZ128rrkz,
          8750 => Opcode::VCVTUW2PHZ256rm,
          8751 => Opcode::VCVTUW2PHZ256rmb,
          8752 => Opcode::VCVTUW2PHZ256rmbk,
          8753 => Opcode::VCVTUW2PHZ256rmbkz,
          8754 => Opcode::VCVTUW2PHZ256rmk,
          8755 => Opcode::VCVTUW2PHZ256rmkz,
          8756 => Opcode::VCVTUW2PHZ256rr,
          8757 => Opcode::VCVTUW2PHZ256rrk,
          8758 => Opcode::VCVTUW2PHZ256rrkz,
          8759 => Opcode::VCVTUW2PHZrm,
          8760 => Opcode::VCVTUW2PHZrmb,
          8761 => Opcode::VCVTUW2PHZrmbk,
          8762 => Opcode::VCVTUW2PHZrmbkz,
          8763 => Opcode::VCVTUW2PHZrmk,
          8764 => Opcode::VCVTUW2PHZrmkz,
          8765 => Opcode::VCVTUW2PHZrr,
          8766 => Opcode::VCVTUW2PHZrrb,
          8767 => Opcode::VCVTUW2PHZrrbk,
          8768 => Opcode::VCVTUW2PHZrrbkz,
          8769 => Opcode::VCVTUW2PHZrrk,
          8770 => Opcode::VCVTUW2PHZrrkz,
          8771 => Opcode::VCVTW2PHZ128rm,
          8772 => Opcode::VCVTW2PHZ128rmb,
          8773 => Opcode::VCVTW2PHZ128rmbk,
          8774 => Opcode::VCVTW2PHZ128rmbkz,
          8775 => Opcode::VCVTW2PHZ128rmk,
          8776 => Opcode::VCVTW2PHZ128rmkz,
          8777 => Opcode::VCVTW2PHZ128rr,
          8778 => Opcode::VCVTW2PHZ128rrk,
          8779 => Opcode::VCVTW2PHZ128rrkz,
          8780 => Opcode::VCVTW2PHZ256rm,
          8781 => Opcode::VCVTW2PHZ256rmb,
          8782 => Opcode::VCVTW2PHZ256rmbk,
          8783 => Opcode::VCVTW2PHZ256rmbkz,
          8784 => Opcode::VCVTW2PHZ256rmk,
          8785 => Opcode::VCVTW2PHZ256rmkz,
          8786 => Opcode::VCVTW2PHZ256rr,
          8787 => Opcode::VCVTW2PHZ256rrk,
          8788 => Opcode::VCVTW2PHZ256rrkz,
          8789 => Opcode::VCVTW2PHZrm,
          8790 => Opcode::VCVTW2PHZrmb,
          8791 => Opcode::VCVTW2PHZrmbk,
          8792 => Opcode::VCVTW2PHZrmbkz,
          8793 => Opcode::VCVTW2PHZrmk,
          8794 => Opcode::VCVTW2PHZrmkz,
          8795 => Opcode::VCVTW2PHZrr,
          8796 => Opcode::VCVTW2PHZrrb,
          8797 => Opcode::VCVTW2PHZrrbk,
          8798 => Opcode::VCVTW2PHZrrbkz,
          8799 => Opcode::VCVTW2PHZrrk,
          8800 => Opcode::VCVTW2PHZrrkz,
          8801 => Opcode::VDBPSADBWZ128rmi,
          8802 => Opcode::VDBPSADBWZ128rmik,
          8803 => Opcode::VDBPSADBWZ128rmikz,
          8804 => Opcode::VDBPSADBWZ128rri,
          8805 => Opcode::VDBPSADBWZ128rrik,
          8806 => Opcode::VDBPSADBWZ128rrikz,
          8807 => Opcode::VDBPSADBWZ256rmi,
          8808 => Opcode::VDBPSADBWZ256rmik,
          8809 => Opcode::VDBPSADBWZ256rmikz,
          8810 => Opcode::VDBPSADBWZ256rri,
          8811 => Opcode::VDBPSADBWZ256rrik,
          8812 => Opcode::VDBPSADBWZ256rrikz,
          8813 => Opcode::VDBPSADBWZrmi,
          8814 => Opcode::VDBPSADBWZrmik,
          8815 => Opcode::VDBPSADBWZrmikz,
          8816 => Opcode::VDBPSADBWZrri,
          8817 => Opcode::VDBPSADBWZrrik,
          8818 => Opcode::VDBPSADBWZrrikz,
          8819 => Opcode::VDIVBF16Z128rm,
          8820 => Opcode::VDIVBF16Z128rmb,
          8821 => Opcode::VDIVBF16Z128rmbk,
          8822 => Opcode::VDIVBF16Z128rmbkz,
          8823 => Opcode::VDIVBF16Z128rmk,
          8824 => Opcode::VDIVBF16Z128rmkz,
          8825 => Opcode::VDIVBF16Z128rr,
          8826 => Opcode::VDIVBF16Z128rrk,
          8827 => Opcode::VDIVBF16Z128rrkz,
          8828 => Opcode::VDIVBF16Z256rm,
          8829 => Opcode::VDIVBF16Z256rmb,
          8830 => Opcode::VDIVBF16Z256rmbk,
          8831 => Opcode::VDIVBF16Z256rmbkz,
          8832 => Opcode::VDIVBF16Z256rmk,
          8833 => Opcode::VDIVBF16Z256rmkz,
          8834 => Opcode::VDIVBF16Z256rr,
          8835 => Opcode::VDIVBF16Z256rrk,
          8836 => Opcode::VDIVBF16Z256rrkz,
          8837 => Opcode::VDIVBF16Zrm,
          8838 => Opcode::VDIVBF16Zrmb,
          8839 => Opcode::VDIVBF16Zrmbk,
          8840 => Opcode::VDIVBF16Zrmbkz,
          8841 => Opcode::VDIVBF16Zrmk,
          8842 => Opcode::VDIVBF16Zrmkz,
          8843 => Opcode::VDIVBF16Zrr,
          8844 => Opcode::VDIVBF16Zrrk,
          8845 => Opcode::VDIVBF16Zrrkz,
          8846 => Opcode::VDIVPDYrm,
          8847 => Opcode::VDIVPDYrr,
          8848 => Opcode::VDIVPDZ128rm,
          8849 => Opcode::VDIVPDZ128rmb,
          8850 => Opcode::VDIVPDZ128rmbk,
          8851 => Opcode::VDIVPDZ128rmbkz,
          8852 => Opcode::VDIVPDZ128rmk,
          8853 => Opcode::VDIVPDZ128rmkz,
          8854 => Opcode::VDIVPDZ128rr,
          8855 => Opcode::VDIVPDZ128rrk,
          8856 => Opcode::VDIVPDZ128rrkz,
          8857 => Opcode::VDIVPDZ256rm,
          8858 => Opcode::VDIVPDZ256rmb,
          8859 => Opcode::VDIVPDZ256rmbk,
          8860 => Opcode::VDIVPDZ256rmbkz,
          8861 => Opcode::VDIVPDZ256rmk,
          8862 => Opcode::VDIVPDZ256rmkz,
          8863 => Opcode::VDIVPDZ256rr,
          8864 => Opcode::VDIVPDZ256rrk,
          8865 => Opcode::VDIVPDZ256rrkz,
          8866 => Opcode::VDIVPDZrm,
          8867 => Opcode::VDIVPDZrmb,
          8868 => Opcode::VDIVPDZrmbk,
          8869 => Opcode::VDIVPDZrmbkz,
          8870 => Opcode::VDIVPDZrmk,
          8871 => Opcode::VDIVPDZrmkz,
          8872 => Opcode::VDIVPDZrr,
          8873 => Opcode::VDIVPDZrrb,
          8874 => Opcode::VDIVPDZrrbk,
          8875 => Opcode::VDIVPDZrrbkz,
          8876 => Opcode::VDIVPDZrrk,
          8877 => Opcode::VDIVPDZrrkz,
          8878 => Opcode::VDIVPDrm,
          8879 => Opcode::VDIVPDrr,
          8880 => Opcode::VDIVPHZ128rm,
          8881 => Opcode::VDIVPHZ128rmb,
          8882 => Opcode::VDIVPHZ128rmbk,
          8883 => Opcode::VDIVPHZ128rmbkz,
          8884 => Opcode::VDIVPHZ128rmk,
          8885 => Opcode::VDIVPHZ128rmkz,
          8886 => Opcode::VDIVPHZ128rr,
          8887 => Opcode::VDIVPHZ128rrk,
          8888 => Opcode::VDIVPHZ128rrkz,
          8889 => Opcode::VDIVPHZ256rm,
          8890 => Opcode::VDIVPHZ256rmb,
          8891 => Opcode::VDIVPHZ256rmbk,
          8892 => Opcode::VDIVPHZ256rmbkz,
          8893 => Opcode::VDIVPHZ256rmk,
          8894 => Opcode::VDIVPHZ256rmkz,
          8895 => Opcode::VDIVPHZ256rr,
          8896 => Opcode::VDIVPHZ256rrk,
          8897 => Opcode::VDIVPHZ256rrkz,
          8898 => Opcode::VDIVPHZrm,
          8899 => Opcode::VDIVPHZrmb,
          8900 => Opcode::VDIVPHZrmbk,
          8901 => Opcode::VDIVPHZrmbkz,
          8902 => Opcode::VDIVPHZrmk,
          8903 => Opcode::VDIVPHZrmkz,
          8904 => Opcode::VDIVPHZrr,
          8905 => Opcode::VDIVPHZrrb,
          8906 => Opcode::VDIVPHZrrbk,
          8907 => Opcode::VDIVPHZrrbkz,
          8908 => Opcode::VDIVPHZrrk,
          8909 => Opcode::VDIVPHZrrkz,
          8910 => Opcode::VDIVPSYrm,
          8911 => Opcode::VDIVPSYrr,
          8912 => Opcode::VDIVPSZ128rm,
          8913 => Opcode::VDIVPSZ128rmb,
          8914 => Opcode::VDIVPSZ128rmbk,
          8915 => Opcode::VDIVPSZ128rmbkz,
          8916 => Opcode::VDIVPSZ128rmk,
          8917 => Opcode::VDIVPSZ128rmkz,
          8918 => Opcode::VDIVPSZ128rr,
          8919 => Opcode::VDIVPSZ128rrk,
          8920 => Opcode::VDIVPSZ128rrkz,
          8921 => Opcode::VDIVPSZ256rm,
          8922 => Opcode::VDIVPSZ256rmb,
          8923 => Opcode::VDIVPSZ256rmbk,
          8924 => Opcode::VDIVPSZ256rmbkz,
          8925 => Opcode::VDIVPSZ256rmk,
          8926 => Opcode::VDIVPSZ256rmkz,
          8927 => Opcode::VDIVPSZ256rr,
          8928 => Opcode::VDIVPSZ256rrk,
          8929 => Opcode::VDIVPSZ256rrkz,
          8930 => Opcode::VDIVPSZrm,
          8931 => Opcode::VDIVPSZrmb,
          8932 => Opcode::VDIVPSZrmbk,
          8933 => Opcode::VDIVPSZrmbkz,
          8934 => Opcode::VDIVPSZrmk,
          8935 => Opcode::VDIVPSZrmkz,
          8936 => Opcode::VDIVPSZrr,
          8937 => Opcode::VDIVPSZrrb,
          8938 => Opcode::VDIVPSZrrbk,
          8939 => Opcode::VDIVPSZrrbkz,
          8940 => Opcode::VDIVPSZrrk,
          8941 => Opcode::VDIVPSZrrkz,
          8942 => Opcode::VDIVPSrm,
          8943 => Opcode::VDIVPSrr,
          8944 => Opcode::VDIVSDZrm,
          8945 => Opcode::VDIVSDZrm_Int,
          8946 => Opcode::VDIVSDZrmk_Int,
          8947 => Opcode::VDIVSDZrmkz_Int,
          8948 => Opcode::VDIVSDZrr,
          8949 => Opcode::VDIVSDZrr_Int,
          8950 => Opcode::VDIVSDZrrb_Int,
          8951 => Opcode::VDIVSDZrrbk_Int,
          8952 => Opcode::VDIVSDZrrbkz_Int,
          8953 => Opcode::VDIVSDZrrk_Int,
          8954 => Opcode::VDIVSDZrrkz_Int,
          8955 => Opcode::VDIVSDrm,
          8956 => Opcode::VDIVSDrm_Int,
          8957 => Opcode::VDIVSDrr,
          8958 => Opcode::VDIVSDrr_Int,
          8959 => Opcode::VDIVSHZrm,
          8960 => Opcode::VDIVSHZrm_Int,
          8961 => Opcode::VDIVSHZrmk_Int,
          8962 => Opcode::VDIVSHZrmkz_Int,
          8963 => Opcode::VDIVSHZrr,
          8964 => Opcode::VDIVSHZrr_Int,
          8965 => Opcode::VDIVSHZrrb_Int,
          8966 => Opcode::VDIVSHZrrbk_Int,
          8967 => Opcode::VDIVSHZrrbkz_Int,
          8968 => Opcode::VDIVSHZrrk_Int,
          8969 => Opcode::VDIVSHZrrkz_Int,
          8970 => Opcode::VDIVSSZrm,
          8971 => Opcode::VDIVSSZrm_Int,
          8972 => Opcode::VDIVSSZrmk_Int,
          8973 => Opcode::VDIVSSZrmkz_Int,
          8974 => Opcode::VDIVSSZrr,
          8975 => Opcode::VDIVSSZrr_Int,
          8976 => Opcode::VDIVSSZrrb_Int,
          8977 => Opcode::VDIVSSZrrbk_Int,
          8978 => Opcode::VDIVSSZrrbkz_Int,
          8979 => Opcode::VDIVSSZrrk_Int,
          8980 => Opcode::VDIVSSZrrkz_Int,
          8981 => Opcode::VDIVSSrm,
          8982 => Opcode::VDIVSSrm_Int,
          8983 => Opcode::VDIVSSrr,
          8984 => Opcode::VDIVSSrr_Int,
          8985 => Opcode::VDPBF16PSZ128m,
          8986 => Opcode::VDPBF16PSZ128mb,
          8987 => Opcode::VDPBF16PSZ128mbk,
          8988 => Opcode::VDPBF16PSZ128mbkz,
          8989 => Opcode::VDPBF16PSZ128mk,
          8990 => Opcode::VDPBF16PSZ128mkz,
          8991 => Opcode::VDPBF16PSZ128r,
          8992 => Opcode::VDPBF16PSZ128rk,
          8993 => Opcode::VDPBF16PSZ128rkz,
          8994 => Opcode::VDPBF16PSZ256m,
          8995 => Opcode::VDPBF16PSZ256mb,
          8996 => Opcode::VDPBF16PSZ256mbk,
          8997 => Opcode::VDPBF16PSZ256mbkz,
          8998 => Opcode::VDPBF16PSZ256mk,
          8999 => Opcode::VDPBF16PSZ256mkz,
          9000 => Opcode::VDPBF16PSZ256r,
          9001 => Opcode::VDPBF16PSZ256rk,
          9002 => Opcode::VDPBF16PSZ256rkz,
          9003 => Opcode::VDPBF16PSZm,
          9004 => Opcode::VDPBF16PSZmb,
          9005 => Opcode::VDPBF16PSZmbk,
          9006 => Opcode::VDPBF16PSZmbkz,
          9007 => Opcode::VDPBF16PSZmk,
          9008 => Opcode::VDPBF16PSZmkz,
          9009 => Opcode::VDPBF16PSZr,
          9010 => Opcode::VDPBF16PSZrk,
          9011 => Opcode::VDPBF16PSZrkz,
          9012 => Opcode::VDPPDrmi,
          9013 => Opcode::VDPPDrri,
          9014 => Opcode::VDPPHPSZ128m,
          9015 => Opcode::VDPPHPSZ128mb,
          9016 => Opcode::VDPPHPSZ128mbk,
          9017 => Opcode::VDPPHPSZ128mbkz,
          9018 => Opcode::VDPPHPSZ128mk,
          9019 => Opcode::VDPPHPSZ128mkz,
          9020 => Opcode::VDPPHPSZ128r,
          9021 => Opcode::VDPPHPSZ128rk,
          9022 => Opcode::VDPPHPSZ128rkz,
          9023 => Opcode::VDPPHPSZ256m,
          9024 => Opcode::VDPPHPSZ256mb,
          9025 => Opcode::VDPPHPSZ256mbk,
          9026 => Opcode::VDPPHPSZ256mbkz,
          9027 => Opcode::VDPPHPSZ256mk,
          9028 => Opcode::VDPPHPSZ256mkz,
          9029 => Opcode::VDPPHPSZ256r,
          9030 => Opcode::VDPPHPSZ256rk,
          9031 => Opcode::VDPPHPSZ256rkz,
          9032 => Opcode::VDPPHPSZm,
          9033 => Opcode::VDPPHPSZmb,
          9034 => Opcode::VDPPHPSZmbk,
          9035 => Opcode::VDPPHPSZmbkz,
          9036 => Opcode::VDPPHPSZmk,
          9037 => Opcode::VDPPHPSZmkz,
          9038 => Opcode::VDPPHPSZr,
          9039 => Opcode::VDPPHPSZrk,
          9040 => Opcode::VDPPHPSZrkz,
          9041 => Opcode::VDPPSYrmi,
          9042 => Opcode::VDPPSYrri,
          9043 => Opcode::VDPPSrmi,
          9044 => Opcode::VDPPSrri,
          9045 => Opcode::VERRm,
          9046 => Opcode::VERRr,
          9047 => Opcode::VERWm,
          9048 => Opcode::VERWr,
          9049 => Opcode::VEXP2PDZm,
          9050 => Opcode::VEXP2PDZmb,
          9051 => Opcode::VEXP2PDZmbk,
          9052 => Opcode::VEXP2PDZmbkz,
          9053 => Opcode::VEXP2PDZmk,
          9054 => Opcode::VEXP2PDZmkz,
          9055 => Opcode::VEXP2PDZr,
          9056 => Opcode::VEXP2PDZrb,
          9057 => Opcode::VEXP2PDZrbk,
          9058 => Opcode::VEXP2PDZrbkz,
          9059 => Opcode::VEXP2PDZrk,
          9060 => Opcode::VEXP2PDZrkz,
          9061 => Opcode::VEXP2PSZm,
          9062 => Opcode::VEXP2PSZmb,
          9063 => Opcode::VEXP2PSZmbk,
          9064 => Opcode::VEXP2PSZmbkz,
          9065 => Opcode::VEXP2PSZmk,
          9066 => Opcode::VEXP2PSZmkz,
          9067 => Opcode::VEXP2PSZr,
          9068 => Opcode::VEXP2PSZrb,
          9069 => Opcode::VEXP2PSZrbk,
          9070 => Opcode::VEXP2PSZrbkz,
          9071 => Opcode::VEXP2PSZrk,
          9072 => Opcode::VEXP2PSZrkz,
          9073 => Opcode::VEXPANDPDZ128rm,
          9074 => Opcode::VEXPANDPDZ128rmk,
          9075 => Opcode::VEXPANDPDZ128rmkz,
          9076 => Opcode::VEXPANDPDZ128rr,
          9077 => Opcode::VEXPANDPDZ128rrk,
          9078 => Opcode::VEXPANDPDZ128rrkz,
          9079 => Opcode::VEXPANDPDZ256rm,
          9080 => Opcode::VEXPANDPDZ256rmk,
          9081 => Opcode::VEXPANDPDZ256rmkz,
          9082 => Opcode::VEXPANDPDZ256rr,
          9083 => Opcode::VEXPANDPDZ256rrk,
          9084 => Opcode::VEXPANDPDZ256rrkz,
          9085 => Opcode::VEXPANDPDZrm,
          9086 => Opcode::VEXPANDPDZrmk,
          9087 => Opcode::VEXPANDPDZrmkz,
          9088 => Opcode::VEXPANDPDZrr,
          9089 => Opcode::VEXPANDPDZrrk,
          9090 => Opcode::VEXPANDPDZrrkz,
          9091 => Opcode::VEXPANDPSZ128rm,
          9092 => Opcode::VEXPANDPSZ128rmk,
          9093 => Opcode::VEXPANDPSZ128rmkz,
          9094 => Opcode::VEXPANDPSZ128rr,
          9095 => Opcode::VEXPANDPSZ128rrk,
          9096 => Opcode::VEXPANDPSZ128rrkz,
          9097 => Opcode::VEXPANDPSZ256rm,
          9098 => Opcode::VEXPANDPSZ256rmk,
          9099 => Opcode::VEXPANDPSZ256rmkz,
          9100 => Opcode::VEXPANDPSZ256rr,
          9101 => Opcode::VEXPANDPSZ256rrk,
          9102 => Opcode::VEXPANDPSZ256rrkz,
          9103 => Opcode::VEXPANDPSZrm,
          9104 => Opcode::VEXPANDPSZrmk,
          9105 => Opcode::VEXPANDPSZrmkz,
          9106 => Opcode::VEXPANDPSZrr,
          9107 => Opcode::VEXPANDPSZrrk,
          9108 => Opcode::VEXPANDPSZrrkz,
          9109 => Opcode::VEXTRACTF128mri,
          9110 => Opcode::VEXTRACTF128rri,
          9111 => Opcode::VEXTRACTF32X4Z256mri,
          9112 => Opcode::VEXTRACTF32X4Z256mrik,
          9113 => Opcode::VEXTRACTF32X4Z256rri,
          9114 => Opcode::VEXTRACTF32X4Z256rrik,
          9115 => Opcode::VEXTRACTF32X4Z256rrikz,
          9116 => Opcode::VEXTRACTF32X4Zmri,
          9117 => Opcode::VEXTRACTF32X4Zmrik,
          9118 => Opcode::VEXTRACTF32X4Zrri,
          9119 => Opcode::VEXTRACTF32X4Zrrik,
          9120 => Opcode::VEXTRACTF32X4Zrrikz,
          9121 => Opcode::VEXTRACTF32X8Zmri,
          9122 => Opcode::VEXTRACTF32X8Zmrik,
          9123 => Opcode::VEXTRACTF32X8Zrri,
          9124 => Opcode::VEXTRACTF32X8Zrrik,
          9125 => Opcode::VEXTRACTF32X8Zrrikz,
          9126 => Opcode::VEXTRACTF64X2Z256mri,
          9127 => Opcode::VEXTRACTF64X2Z256mrik,
          9128 => Opcode::VEXTRACTF64X2Z256rri,
          9129 => Opcode::VEXTRACTF64X2Z256rrik,
          9130 => Opcode::VEXTRACTF64X2Z256rrikz,
          9131 => Opcode::VEXTRACTF64X2Zmri,
          9132 => Opcode::VEXTRACTF64X2Zmrik,
          9133 => Opcode::VEXTRACTF64X2Zrri,
          9134 => Opcode::VEXTRACTF64X2Zrrik,
          9135 => Opcode::VEXTRACTF64X2Zrrikz,
          9136 => Opcode::VEXTRACTF64X4Zmri,
          9137 => Opcode::VEXTRACTF64X4Zmrik,
          9138 => Opcode::VEXTRACTF64X4Zrri,
          9139 => Opcode::VEXTRACTF64X4Zrrik,
          9140 => Opcode::VEXTRACTF64X4Zrrikz,
          9141 => Opcode::VEXTRACTI128mri,
          9142 => Opcode::VEXTRACTI128rri,
          9143 => Opcode::VEXTRACTI32X4Z256mri,
          9144 => Opcode::VEXTRACTI32X4Z256mrik,
          9145 => Opcode::VEXTRACTI32X4Z256rri,
          9146 => Opcode::VEXTRACTI32X4Z256rrik,
          9147 => Opcode::VEXTRACTI32X4Z256rrikz,
          9148 => Opcode::VEXTRACTI32X4Zmri,
          9149 => Opcode::VEXTRACTI32X4Zmrik,
          9150 => Opcode::VEXTRACTI32X4Zrri,
          9151 => Opcode::VEXTRACTI32X4Zrrik,
          9152 => Opcode::VEXTRACTI32X4Zrrikz,
          9153 => Opcode::VEXTRACTI32X8Zmri,
          9154 => Opcode::VEXTRACTI32X8Zmrik,
          9155 => Opcode::VEXTRACTI32X8Zrri,
          9156 => Opcode::VEXTRACTI32X8Zrrik,
          9157 => Opcode::VEXTRACTI32X8Zrrikz,
          9158 => Opcode::VEXTRACTI64X2Z256mri,
          9159 => Opcode::VEXTRACTI64X2Z256mrik,
          9160 => Opcode::VEXTRACTI64X2Z256rri,
          9161 => Opcode::VEXTRACTI64X2Z256rrik,
          9162 => Opcode::VEXTRACTI64X2Z256rrikz,
          9163 => Opcode::VEXTRACTI64X2Zmri,
          9164 => Opcode::VEXTRACTI64X2Zmrik,
          9165 => Opcode::VEXTRACTI64X2Zrri,
          9166 => Opcode::VEXTRACTI64X2Zrrik,
          9167 => Opcode::VEXTRACTI64X2Zrrikz,
          9168 => Opcode::VEXTRACTI64X4Zmri,
          9169 => Opcode::VEXTRACTI64X4Zmrik,
          9170 => Opcode::VEXTRACTI64X4Zrri,
          9171 => Opcode::VEXTRACTI64X4Zrrik,
          9172 => Opcode::VEXTRACTI64X4Zrrikz,
          9173 => Opcode::VEXTRACTPSZmri,
          9174 => Opcode::VEXTRACTPSZrri,
          9175 => Opcode::VEXTRACTPSmri,
          9176 => Opcode::VEXTRACTPSrri,
          9177 => Opcode::VFCMADDCPHZ128m,
          9178 => Opcode::VFCMADDCPHZ128mb,
          9179 => Opcode::VFCMADDCPHZ128mbk,
          9180 => Opcode::VFCMADDCPHZ128mbkz,
          9181 => Opcode::VFCMADDCPHZ128mk,
          9182 => Opcode::VFCMADDCPHZ128mkz,
          9183 => Opcode::VFCMADDCPHZ128r,
          9184 => Opcode::VFCMADDCPHZ128rk,
          9185 => Opcode::VFCMADDCPHZ128rkz,
          9186 => Opcode::VFCMADDCPHZ256m,
          9187 => Opcode::VFCMADDCPHZ256mb,
          9188 => Opcode::VFCMADDCPHZ256mbk,
          9189 => Opcode::VFCMADDCPHZ256mbkz,
          9190 => Opcode::VFCMADDCPHZ256mk,
          9191 => Opcode::VFCMADDCPHZ256mkz,
          9192 => Opcode::VFCMADDCPHZ256r,
          9193 => Opcode::VFCMADDCPHZ256rk,
          9194 => Opcode::VFCMADDCPHZ256rkz,
          9195 => Opcode::VFCMADDCPHZm,
          9196 => Opcode::VFCMADDCPHZmb,
          9197 => Opcode::VFCMADDCPHZmbk,
          9198 => Opcode::VFCMADDCPHZmbkz,
          9199 => Opcode::VFCMADDCPHZmk,
          9200 => Opcode::VFCMADDCPHZmkz,
          9201 => Opcode::VFCMADDCPHZr,
          9202 => Opcode::VFCMADDCPHZrb,
          9203 => Opcode::VFCMADDCPHZrbk,
          9204 => Opcode::VFCMADDCPHZrbkz,
          9205 => Opcode::VFCMADDCPHZrk,
          9206 => Opcode::VFCMADDCPHZrkz,
          9207 => Opcode::VFCMADDCSHZm,
          9208 => Opcode::VFCMADDCSHZmk,
          9209 => Opcode::VFCMADDCSHZmkz,
          9210 => Opcode::VFCMADDCSHZr,
          9211 => Opcode::VFCMADDCSHZrb,
          9212 => Opcode::VFCMADDCSHZrbk,
          9213 => Opcode::VFCMADDCSHZrbkz,
          9214 => Opcode::VFCMADDCSHZrk,
          9215 => Opcode::VFCMADDCSHZrkz,
          9216 => Opcode::VFCMULCPHZ128rm,
          9217 => Opcode::VFCMULCPHZ128rmb,
          9218 => Opcode::VFCMULCPHZ128rmbk,
          9219 => Opcode::VFCMULCPHZ128rmbkz,
          9220 => Opcode::VFCMULCPHZ128rmk,
          9221 => Opcode::VFCMULCPHZ128rmkz,
          9222 => Opcode::VFCMULCPHZ128rr,
          9223 => Opcode::VFCMULCPHZ128rrk,
          9224 => Opcode::VFCMULCPHZ128rrkz,
          9225 => Opcode::VFCMULCPHZ256rm,
          9226 => Opcode::VFCMULCPHZ256rmb,
          9227 => Opcode::VFCMULCPHZ256rmbk,
          9228 => Opcode::VFCMULCPHZ256rmbkz,
          9229 => Opcode::VFCMULCPHZ256rmk,
          9230 => Opcode::VFCMULCPHZ256rmkz,
          9231 => Opcode::VFCMULCPHZ256rr,
          9232 => Opcode::VFCMULCPHZ256rrk,
          9233 => Opcode::VFCMULCPHZ256rrkz,
          9234 => Opcode::VFCMULCPHZrm,
          9235 => Opcode::VFCMULCPHZrmb,
          9236 => Opcode::VFCMULCPHZrmbk,
          9237 => Opcode::VFCMULCPHZrmbkz,
          9238 => Opcode::VFCMULCPHZrmk,
          9239 => Opcode::VFCMULCPHZrmkz,
          9240 => Opcode::VFCMULCPHZrr,
          9241 => Opcode::VFCMULCPHZrrb,
          9242 => Opcode::VFCMULCPHZrrbk,
          9243 => Opcode::VFCMULCPHZrrbkz,
          9244 => Opcode::VFCMULCPHZrrk,
          9245 => Opcode::VFCMULCPHZrrkz,
          9246 => Opcode::VFCMULCSHZrm,
          9247 => Opcode::VFCMULCSHZrmk,
          9248 => Opcode::VFCMULCSHZrmkz,
          9249 => Opcode::VFCMULCSHZrr,
          9250 => Opcode::VFCMULCSHZrrb,
          9251 => Opcode::VFCMULCSHZrrbk,
          9252 => Opcode::VFCMULCSHZrrbkz,
          9253 => Opcode::VFCMULCSHZrrk,
          9254 => Opcode::VFCMULCSHZrrkz,
          9255 => Opcode::VFIXUPIMMPDZ128rmbi,
          9256 => Opcode::VFIXUPIMMPDZ128rmbik,
          9257 => Opcode::VFIXUPIMMPDZ128rmbikz,
          9258 => Opcode::VFIXUPIMMPDZ128rmi,
          9259 => Opcode::VFIXUPIMMPDZ128rmik,
          9260 => Opcode::VFIXUPIMMPDZ128rmikz,
          9261 => Opcode::VFIXUPIMMPDZ128rri,
          9262 => Opcode::VFIXUPIMMPDZ128rrik,
          9263 => Opcode::VFIXUPIMMPDZ128rrikz,
          9264 => Opcode::VFIXUPIMMPDZ256rmbi,
          9265 => Opcode::VFIXUPIMMPDZ256rmbik,
          9266 => Opcode::VFIXUPIMMPDZ256rmbikz,
          9267 => Opcode::VFIXUPIMMPDZ256rmi,
          9268 => Opcode::VFIXUPIMMPDZ256rmik,
          9269 => Opcode::VFIXUPIMMPDZ256rmikz,
          9270 => Opcode::VFIXUPIMMPDZ256rri,
          9271 => Opcode::VFIXUPIMMPDZ256rrik,
          9272 => Opcode::VFIXUPIMMPDZ256rrikz,
          9273 => Opcode::VFIXUPIMMPDZrmbi,
          9274 => Opcode::VFIXUPIMMPDZrmbik,
          9275 => Opcode::VFIXUPIMMPDZrmbikz,
          9276 => Opcode::VFIXUPIMMPDZrmi,
          9277 => Opcode::VFIXUPIMMPDZrmik,
          9278 => Opcode::VFIXUPIMMPDZrmikz,
          9279 => Opcode::VFIXUPIMMPDZrri,
          9280 => Opcode::VFIXUPIMMPDZrrib,
          9281 => Opcode::VFIXUPIMMPDZrribk,
          9282 => Opcode::VFIXUPIMMPDZrribkz,
          9283 => Opcode::VFIXUPIMMPDZrrik,
          9284 => Opcode::VFIXUPIMMPDZrrikz,
          9285 => Opcode::VFIXUPIMMPSZ128rmbi,
          9286 => Opcode::VFIXUPIMMPSZ128rmbik,
          9287 => Opcode::VFIXUPIMMPSZ128rmbikz,
          9288 => Opcode::VFIXUPIMMPSZ128rmi,
          9289 => Opcode::VFIXUPIMMPSZ128rmik,
          9290 => Opcode::VFIXUPIMMPSZ128rmikz,
          9291 => Opcode::VFIXUPIMMPSZ128rri,
          9292 => Opcode::VFIXUPIMMPSZ128rrik,
          9293 => Opcode::VFIXUPIMMPSZ128rrikz,
          9294 => Opcode::VFIXUPIMMPSZ256rmbi,
          9295 => Opcode::VFIXUPIMMPSZ256rmbik,
          9296 => Opcode::VFIXUPIMMPSZ256rmbikz,
          9297 => Opcode::VFIXUPIMMPSZ256rmi,
          9298 => Opcode::VFIXUPIMMPSZ256rmik,
          9299 => Opcode::VFIXUPIMMPSZ256rmikz,
          9300 => Opcode::VFIXUPIMMPSZ256rri,
          9301 => Opcode::VFIXUPIMMPSZ256rrik,
          9302 => Opcode::VFIXUPIMMPSZ256rrikz,
          9303 => Opcode::VFIXUPIMMPSZrmbi,
          9304 => Opcode::VFIXUPIMMPSZrmbik,
          9305 => Opcode::VFIXUPIMMPSZrmbikz,
          9306 => Opcode::VFIXUPIMMPSZrmi,
          9307 => Opcode::VFIXUPIMMPSZrmik,
          9308 => Opcode::VFIXUPIMMPSZrmikz,
          9309 => Opcode::VFIXUPIMMPSZrri,
          9310 => Opcode::VFIXUPIMMPSZrrib,
          9311 => Opcode::VFIXUPIMMPSZrribk,
          9312 => Opcode::VFIXUPIMMPSZrribkz,
          9313 => Opcode::VFIXUPIMMPSZrrik,
          9314 => Opcode::VFIXUPIMMPSZrrikz,
          9315 => Opcode::VFIXUPIMMSDZrmi,
          9316 => Opcode::VFIXUPIMMSDZrmik,
          9317 => Opcode::VFIXUPIMMSDZrmikz,
          9318 => Opcode::VFIXUPIMMSDZrri,
          9319 => Opcode::VFIXUPIMMSDZrrib,
          9320 => Opcode::VFIXUPIMMSDZrribk,
          9321 => Opcode::VFIXUPIMMSDZrribkz,
          9322 => Opcode::VFIXUPIMMSDZrrik,
          9323 => Opcode::VFIXUPIMMSDZrrikz,
          9324 => Opcode::VFIXUPIMMSSZrmi,
          9325 => Opcode::VFIXUPIMMSSZrmik,
          9326 => Opcode::VFIXUPIMMSSZrmikz,
          9327 => Opcode::VFIXUPIMMSSZrri,
          9328 => Opcode::VFIXUPIMMSSZrrib,
          9329 => Opcode::VFIXUPIMMSSZrribk,
          9330 => Opcode::VFIXUPIMMSSZrribkz,
          9331 => Opcode::VFIXUPIMMSSZrrik,
          9332 => Opcode::VFIXUPIMMSSZrrikz,
          9333 => Opcode::VFMADD132BF16Z128m,
          9334 => Opcode::VFMADD132BF16Z128mb,
          9335 => Opcode::VFMADD132BF16Z128mbk,
          9336 => Opcode::VFMADD132BF16Z128mbkz,
          9337 => Opcode::VFMADD132BF16Z128mk,
          9338 => Opcode::VFMADD132BF16Z128mkz,
          9339 => Opcode::VFMADD132BF16Z128r,
          9340 => Opcode::VFMADD132BF16Z128rk,
          9341 => Opcode::VFMADD132BF16Z128rkz,
          9342 => Opcode::VFMADD132BF16Z256m,
          9343 => Opcode::VFMADD132BF16Z256mb,
          9344 => Opcode::VFMADD132BF16Z256mbk,
          9345 => Opcode::VFMADD132BF16Z256mbkz,
          9346 => Opcode::VFMADD132BF16Z256mk,
          9347 => Opcode::VFMADD132BF16Z256mkz,
          9348 => Opcode::VFMADD132BF16Z256r,
          9349 => Opcode::VFMADD132BF16Z256rk,
          9350 => Opcode::VFMADD132BF16Z256rkz,
          9351 => Opcode::VFMADD132BF16Zm,
          9352 => Opcode::VFMADD132BF16Zmb,
          9353 => Opcode::VFMADD132BF16Zmbk,
          9354 => Opcode::VFMADD132BF16Zmbkz,
          9355 => Opcode::VFMADD132BF16Zmk,
          9356 => Opcode::VFMADD132BF16Zmkz,
          9357 => Opcode::VFMADD132BF16Zr,
          9358 => Opcode::VFMADD132BF16Zrk,
          9359 => Opcode::VFMADD132BF16Zrkz,
          9360 => Opcode::VFMADD132PDYm,
          9361 => Opcode::VFMADD132PDYr,
          9362 => Opcode::VFMADD132PDZ128m,
          9363 => Opcode::VFMADD132PDZ128mb,
          9364 => Opcode::VFMADD132PDZ128mbk,
          9365 => Opcode::VFMADD132PDZ128mbkz,
          9366 => Opcode::VFMADD132PDZ128mk,
          9367 => Opcode::VFMADD132PDZ128mkz,
          9368 => Opcode::VFMADD132PDZ128r,
          9369 => Opcode::VFMADD132PDZ128rk,
          9370 => Opcode::VFMADD132PDZ128rkz,
          9371 => Opcode::VFMADD132PDZ256m,
          9372 => Opcode::VFMADD132PDZ256mb,
          9373 => Opcode::VFMADD132PDZ256mbk,
          9374 => Opcode::VFMADD132PDZ256mbkz,
          9375 => Opcode::VFMADD132PDZ256mk,
          9376 => Opcode::VFMADD132PDZ256mkz,
          9377 => Opcode::VFMADD132PDZ256r,
          9378 => Opcode::VFMADD132PDZ256rk,
          9379 => Opcode::VFMADD132PDZ256rkz,
          9380 => Opcode::VFMADD132PDZm,
          9381 => Opcode::VFMADD132PDZmb,
          9382 => Opcode::VFMADD132PDZmbk,
          9383 => Opcode::VFMADD132PDZmbkz,
          9384 => Opcode::VFMADD132PDZmk,
          9385 => Opcode::VFMADD132PDZmkz,
          9386 => Opcode::VFMADD132PDZr,
          9387 => Opcode::VFMADD132PDZrb,
          9388 => Opcode::VFMADD132PDZrbk,
          9389 => Opcode::VFMADD132PDZrbkz,
          9390 => Opcode::VFMADD132PDZrk,
          9391 => Opcode::VFMADD132PDZrkz,
          9392 => Opcode::VFMADD132PDm,
          9393 => Opcode::VFMADD132PDr,
          9394 => Opcode::VFMADD132PHZ128m,
          9395 => Opcode::VFMADD132PHZ128mb,
          9396 => Opcode::VFMADD132PHZ128mbk,
          9397 => Opcode::VFMADD132PHZ128mbkz,
          9398 => Opcode::VFMADD132PHZ128mk,
          9399 => Opcode::VFMADD132PHZ128mkz,
          9400 => Opcode::VFMADD132PHZ128r,
          9401 => Opcode::VFMADD132PHZ128rk,
          9402 => Opcode::VFMADD132PHZ128rkz,
          9403 => Opcode::VFMADD132PHZ256m,
          9404 => Opcode::VFMADD132PHZ256mb,
          9405 => Opcode::VFMADD132PHZ256mbk,
          9406 => Opcode::VFMADD132PHZ256mbkz,
          9407 => Opcode::VFMADD132PHZ256mk,
          9408 => Opcode::VFMADD132PHZ256mkz,
          9409 => Opcode::VFMADD132PHZ256r,
          9410 => Opcode::VFMADD132PHZ256rk,
          9411 => Opcode::VFMADD132PHZ256rkz,
          9412 => Opcode::VFMADD132PHZm,
          9413 => Opcode::VFMADD132PHZmb,
          9414 => Opcode::VFMADD132PHZmbk,
          9415 => Opcode::VFMADD132PHZmbkz,
          9416 => Opcode::VFMADD132PHZmk,
          9417 => Opcode::VFMADD132PHZmkz,
          9418 => Opcode::VFMADD132PHZr,
          9419 => Opcode::VFMADD132PHZrb,
          9420 => Opcode::VFMADD132PHZrbk,
          9421 => Opcode::VFMADD132PHZrbkz,
          9422 => Opcode::VFMADD132PHZrk,
          9423 => Opcode::VFMADD132PHZrkz,
          9424 => Opcode::VFMADD132PSYm,
          9425 => Opcode::VFMADD132PSYr,
          9426 => Opcode::VFMADD132PSZ128m,
          9427 => Opcode::VFMADD132PSZ128mb,
          9428 => Opcode::VFMADD132PSZ128mbk,
          9429 => Opcode::VFMADD132PSZ128mbkz,
          9430 => Opcode::VFMADD132PSZ128mk,
          9431 => Opcode::VFMADD132PSZ128mkz,
          9432 => Opcode::VFMADD132PSZ128r,
          9433 => Opcode::VFMADD132PSZ128rk,
          9434 => Opcode::VFMADD132PSZ128rkz,
          9435 => Opcode::VFMADD132PSZ256m,
          9436 => Opcode::VFMADD132PSZ256mb,
          9437 => Opcode::VFMADD132PSZ256mbk,
          9438 => Opcode::VFMADD132PSZ256mbkz,
          9439 => Opcode::VFMADD132PSZ256mk,
          9440 => Opcode::VFMADD132PSZ256mkz,
          9441 => Opcode::VFMADD132PSZ256r,
          9442 => Opcode::VFMADD132PSZ256rk,
          9443 => Opcode::VFMADD132PSZ256rkz,
          9444 => Opcode::VFMADD132PSZm,
          9445 => Opcode::VFMADD132PSZmb,
          9446 => Opcode::VFMADD132PSZmbk,
          9447 => Opcode::VFMADD132PSZmbkz,
          9448 => Opcode::VFMADD132PSZmk,
          9449 => Opcode::VFMADD132PSZmkz,
          9450 => Opcode::VFMADD132PSZr,
          9451 => Opcode::VFMADD132PSZrb,
          9452 => Opcode::VFMADD132PSZrbk,
          9453 => Opcode::VFMADD132PSZrbkz,
          9454 => Opcode::VFMADD132PSZrk,
          9455 => Opcode::VFMADD132PSZrkz,
          9456 => Opcode::VFMADD132PSm,
          9457 => Opcode::VFMADD132PSr,
          9458 => Opcode::VFMADD132SDZm,
          9459 => Opcode::VFMADD132SDZm_Int,
          9460 => Opcode::VFMADD132SDZmk_Int,
          9461 => Opcode::VFMADD132SDZmkz_Int,
          9462 => Opcode::VFMADD132SDZr,
          9463 => Opcode::VFMADD132SDZr_Int,
          9464 => Opcode::VFMADD132SDZrb,
          9465 => Opcode::VFMADD132SDZrb_Int,
          9466 => Opcode::VFMADD132SDZrbk_Int,
          9467 => Opcode::VFMADD132SDZrbkz_Int,
          9468 => Opcode::VFMADD132SDZrk_Int,
          9469 => Opcode::VFMADD132SDZrkz_Int,
          9470 => Opcode::VFMADD132SDm,
          9471 => Opcode::VFMADD132SDm_Int,
          9472 => Opcode::VFMADD132SDr,
          9473 => Opcode::VFMADD132SDr_Int,
          9474 => Opcode::VFMADD132SHZm,
          9475 => Opcode::VFMADD132SHZm_Int,
          9476 => Opcode::VFMADD132SHZmk_Int,
          9477 => Opcode::VFMADD132SHZmkz_Int,
          9478 => Opcode::VFMADD132SHZr,
          9479 => Opcode::VFMADD132SHZr_Int,
          9480 => Opcode::VFMADD132SHZrb,
          9481 => Opcode::VFMADD132SHZrb_Int,
          9482 => Opcode::VFMADD132SHZrbk_Int,
          9483 => Opcode::VFMADD132SHZrbkz_Int,
          9484 => Opcode::VFMADD132SHZrk_Int,
          9485 => Opcode::VFMADD132SHZrkz_Int,
          9486 => Opcode::VFMADD132SSZm,
          9487 => Opcode::VFMADD132SSZm_Int,
          9488 => Opcode::VFMADD132SSZmk_Int,
          9489 => Opcode::VFMADD132SSZmkz_Int,
          9490 => Opcode::VFMADD132SSZr,
          9491 => Opcode::VFMADD132SSZr_Int,
          9492 => Opcode::VFMADD132SSZrb,
          9493 => Opcode::VFMADD132SSZrb_Int,
          9494 => Opcode::VFMADD132SSZrbk_Int,
          9495 => Opcode::VFMADD132SSZrbkz_Int,
          9496 => Opcode::VFMADD132SSZrk_Int,
          9497 => Opcode::VFMADD132SSZrkz_Int,
          9498 => Opcode::VFMADD132SSm,
          9499 => Opcode::VFMADD132SSm_Int,
          9500 => Opcode::VFMADD132SSr,
          9501 => Opcode::VFMADD132SSr_Int,
          9502 => Opcode::VFMADD213BF16Z128m,
          9503 => Opcode::VFMADD213BF16Z128mb,
          9504 => Opcode::VFMADD213BF16Z128mbk,
          9505 => Opcode::VFMADD213BF16Z128mbkz,
          9506 => Opcode::VFMADD213BF16Z128mk,
          9507 => Opcode::VFMADD213BF16Z128mkz,
          9508 => Opcode::VFMADD213BF16Z128r,
          9509 => Opcode::VFMADD213BF16Z128rk,
          9510 => Opcode::VFMADD213BF16Z128rkz,
          9511 => Opcode::VFMADD213BF16Z256m,
          9512 => Opcode::VFMADD213BF16Z256mb,
          9513 => Opcode::VFMADD213BF16Z256mbk,
          9514 => Opcode::VFMADD213BF16Z256mbkz,
          9515 => Opcode::VFMADD213BF16Z256mk,
          9516 => Opcode::VFMADD213BF16Z256mkz,
          9517 => Opcode::VFMADD213BF16Z256r,
          9518 => Opcode::VFMADD213BF16Z256rk,
          9519 => Opcode::VFMADD213BF16Z256rkz,
          9520 => Opcode::VFMADD213BF16Zm,
          9521 => Opcode::VFMADD213BF16Zmb,
          9522 => Opcode::VFMADD213BF16Zmbk,
          9523 => Opcode::VFMADD213BF16Zmbkz,
          9524 => Opcode::VFMADD213BF16Zmk,
          9525 => Opcode::VFMADD213BF16Zmkz,
          9526 => Opcode::VFMADD213BF16Zr,
          9527 => Opcode::VFMADD213BF16Zrk,
          9528 => Opcode::VFMADD213BF16Zrkz,
          9529 => Opcode::VFMADD213PDYm,
          9530 => Opcode::VFMADD213PDYr,
          9531 => Opcode::VFMADD213PDZ128m,
          9532 => Opcode::VFMADD213PDZ128mb,
          9533 => Opcode::VFMADD213PDZ128mbk,
          9534 => Opcode::VFMADD213PDZ128mbkz,
          9535 => Opcode::VFMADD213PDZ128mk,
          9536 => Opcode::VFMADD213PDZ128mkz,
          9537 => Opcode::VFMADD213PDZ128r,
          9538 => Opcode::VFMADD213PDZ128rk,
          9539 => Opcode::VFMADD213PDZ128rkz,
          9540 => Opcode::VFMADD213PDZ256m,
          9541 => Opcode::VFMADD213PDZ256mb,
          9542 => Opcode::VFMADD213PDZ256mbk,
          9543 => Opcode::VFMADD213PDZ256mbkz,
          9544 => Opcode::VFMADD213PDZ256mk,
          9545 => Opcode::VFMADD213PDZ256mkz,
          9546 => Opcode::VFMADD213PDZ256r,
          9547 => Opcode::VFMADD213PDZ256rk,
          9548 => Opcode::VFMADD213PDZ256rkz,
          9549 => Opcode::VFMADD213PDZm,
          9550 => Opcode::VFMADD213PDZmb,
          9551 => Opcode::VFMADD213PDZmbk,
          9552 => Opcode::VFMADD213PDZmbkz,
          9553 => Opcode::VFMADD213PDZmk,
          9554 => Opcode::VFMADD213PDZmkz,
          9555 => Opcode::VFMADD213PDZr,
          9556 => Opcode::VFMADD213PDZrb,
          9557 => Opcode::VFMADD213PDZrbk,
          9558 => Opcode::VFMADD213PDZrbkz,
          9559 => Opcode::VFMADD213PDZrk,
          9560 => Opcode::VFMADD213PDZrkz,
          9561 => Opcode::VFMADD213PDm,
          9562 => Opcode::VFMADD213PDr,
          9563 => Opcode::VFMADD213PHZ128m,
          9564 => Opcode::VFMADD213PHZ128mb,
          9565 => Opcode::VFMADD213PHZ128mbk,
          9566 => Opcode::VFMADD213PHZ128mbkz,
          9567 => Opcode::VFMADD213PHZ128mk,
          9568 => Opcode::VFMADD213PHZ128mkz,
          9569 => Opcode::VFMADD213PHZ128r,
          9570 => Opcode::VFMADD213PHZ128rk,
          9571 => Opcode::VFMADD213PHZ128rkz,
          9572 => Opcode::VFMADD213PHZ256m,
          9573 => Opcode::VFMADD213PHZ256mb,
          9574 => Opcode::VFMADD213PHZ256mbk,
          9575 => Opcode::VFMADD213PHZ256mbkz,
          9576 => Opcode::VFMADD213PHZ256mk,
          9577 => Opcode::VFMADD213PHZ256mkz,
          9578 => Opcode::VFMADD213PHZ256r,
          9579 => Opcode::VFMADD213PHZ256rk,
          9580 => Opcode::VFMADD213PHZ256rkz,
          9581 => Opcode::VFMADD213PHZm,
          9582 => Opcode::VFMADD213PHZmb,
          9583 => Opcode::VFMADD213PHZmbk,
          9584 => Opcode::VFMADD213PHZmbkz,
          9585 => Opcode::VFMADD213PHZmk,
          9586 => Opcode::VFMADD213PHZmkz,
          9587 => Opcode::VFMADD213PHZr,
          9588 => Opcode::VFMADD213PHZrb,
          9589 => Opcode::VFMADD213PHZrbk,
          9590 => Opcode::VFMADD213PHZrbkz,
          9591 => Opcode::VFMADD213PHZrk,
          9592 => Opcode::VFMADD213PHZrkz,
          9593 => Opcode::VFMADD213PSYm,
          9594 => Opcode::VFMADD213PSYr,
          9595 => Opcode::VFMADD213PSZ128m,
          9596 => Opcode::VFMADD213PSZ128mb,
          9597 => Opcode::VFMADD213PSZ128mbk,
          9598 => Opcode::VFMADD213PSZ128mbkz,
          9599 => Opcode::VFMADD213PSZ128mk,
          9600 => Opcode::VFMADD213PSZ128mkz,
          9601 => Opcode::VFMADD213PSZ128r,
          9602 => Opcode::VFMADD213PSZ128rk,
          9603 => Opcode::VFMADD213PSZ128rkz,
          9604 => Opcode::VFMADD213PSZ256m,
          9605 => Opcode::VFMADD213PSZ256mb,
          9606 => Opcode::VFMADD213PSZ256mbk,
          9607 => Opcode::VFMADD213PSZ256mbkz,
          9608 => Opcode::VFMADD213PSZ256mk,
          9609 => Opcode::VFMADD213PSZ256mkz,
          9610 => Opcode::VFMADD213PSZ256r,
          9611 => Opcode::VFMADD213PSZ256rk,
          9612 => Opcode::VFMADD213PSZ256rkz,
          9613 => Opcode::VFMADD213PSZm,
          9614 => Opcode::VFMADD213PSZmb,
          9615 => Opcode::VFMADD213PSZmbk,
          9616 => Opcode::VFMADD213PSZmbkz,
          9617 => Opcode::VFMADD213PSZmk,
          9618 => Opcode::VFMADD213PSZmkz,
          9619 => Opcode::VFMADD213PSZr,
          9620 => Opcode::VFMADD213PSZrb,
          9621 => Opcode::VFMADD213PSZrbk,
          9622 => Opcode::VFMADD213PSZrbkz,
          9623 => Opcode::VFMADD213PSZrk,
          9624 => Opcode::VFMADD213PSZrkz,
          9625 => Opcode::VFMADD213PSm,
          9626 => Opcode::VFMADD213PSr,
          9627 => Opcode::VFMADD213SDZm,
          9628 => Opcode::VFMADD213SDZm_Int,
          9629 => Opcode::VFMADD213SDZmk_Int,
          9630 => Opcode::VFMADD213SDZmkz_Int,
          9631 => Opcode::VFMADD213SDZr,
          9632 => Opcode::VFMADD213SDZr_Int,
          9633 => Opcode::VFMADD213SDZrb,
          9634 => Opcode::VFMADD213SDZrb_Int,
          9635 => Opcode::VFMADD213SDZrbk_Int,
          9636 => Opcode::VFMADD213SDZrbkz_Int,
          9637 => Opcode::VFMADD213SDZrk_Int,
          9638 => Opcode::VFMADD213SDZrkz_Int,
          9639 => Opcode::VFMADD213SDm,
          9640 => Opcode::VFMADD213SDm_Int,
          9641 => Opcode::VFMADD213SDr,
          9642 => Opcode::VFMADD213SDr_Int,
          9643 => Opcode::VFMADD213SHZm,
          9644 => Opcode::VFMADD213SHZm_Int,
          9645 => Opcode::VFMADD213SHZmk_Int,
          9646 => Opcode::VFMADD213SHZmkz_Int,
          9647 => Opcode::VFMADD213SHZr,
          9648 => Opcode::VFMADD213SHZr_Int,
          9649 => Opcode::VFMADD213SHZrb,
          9650 => Opcode::VFMADD213SHZrb_Int,
          9651 => Opcode::VFMADD213SHZrbk_Int,
          9652 => Opcode::VFMADD213SHZrbkz_Int,
          9653 => Opcode::VFMADD213SHZrk_Int,
          9654 => Opcode::VFMADD213SHZrkz_Int,
          9655 => Opcode::VFMADD213SSZm,
          9656 => Opcode::VFMADD213SSZm_Int,
          9657 => Opcode::VFMADD213SSZmk_Int,
          9658 => Opcode::VFMADD213SSZmkz_Int,
          9659 => Opcode::VFMADD213SSZr,
          9660 => Opcode::VFMADD213SSZr_Int,
          9661 => Opcode::VFMADD213SSZrb,
          9662 => Opcode::VFMADD213SSZrb_Int,
          9663 => Opcode::VFMADD213SSZrbk_Int,
          9664 => Opcode::VFMADD213SSZrbkz_Int,
          9665 => Opcode::VFMADD213SSZrk_Int,
          9666 => Opcode::VFMADD213SSZrkz_Int,
          9667 => Opcode::VFMADD213SSm,
          9668 => Opcode::VFMADD213SSm_Int,
          9669 => Opcode::VFMADD213SSr,
          9670 => Opcode::VFMADD213SSr_Int,
          9671 => Opcode::VFMADD231BF16Z128m,
          9672 => Opcode::VFMADD231BF16Z128mb,
          9673 => Opcode::VFMADD231BF16Z128mbk,
          9674 => Opcode::VFMADD231BF16Z128mbkz,
          9675 => Opcode::VFMADD231BF16Z128mk,
          9676 => Opcode::VFMADD231BF16Z128mkz,
          9677 => Opcode::VFMADD231BF16Z128r,
          9678 => Opcode::VFMADD231BF16Z128rk,
          9679 => Opcode::VFMADD231BF16Z128rkz,
          9680 => Opcode::VFMADD231BF16Z256m,
          9681 => Opcode::VFMADD231BF16Z256mb,
          9682 => Opcode::VFMADD231BF16Z256mbk,
          9683 => Opcode::VFMADD231BF16Z256mbkz,
          9684 => Opcode::VFMADD231BF16Z256mk,
          9685 => Opcode::VFMADD231BF16Z256mkz,
          9686 => Opcode::VFMADD231BF16Z256r,
          9687 => Opcode::VFMADD231BF16Z256rk,
          9688 => Opcode::VFMADD231BF16Z256rkz,
          9689 => Opcode::VFMADD231BF16Zm,
          9690 => Opcode::VFMADD231BF16Zmb,
          9691 => Opcode::VFMADD231BF16Zmbk,
          9692 => Opcode::VFMADD231BF16Zmbkz,
          9693 => Opcode::VFMADD231BF16Zmk,
          9694 => Opcode::VFMADD231BF16Zmkz,
          9695 => Opcode::VFMADD231BF16Zr,
          9696 => Opcode::VFMADD231BF16Zrk,
          9697 => Opcode::VFMADD231BF16Zrkz,
          9698 => Opcode::VFMADD231PDYm,
          9699 => Opcode::VFMADD231PDYr,
          9700 => Opcode::VFMADD231PDZ128m,
          9701 => Opcode::VFMADD231PDZ128mb,
          9702 => Opcode::VFMADD231PDZ128mbk,
          9703 => Opcode::VFMADD231PDZ128mbkz,
          9704 => Opcode::VFMADD231PDZ128mk,
          9705 => Opcode::VFMADD231PDZ128mkz,
          9706 => Opcode::VFMADD231PDZ128r,
          9707 => Opcode::VFMADD231PDZ128rk,
          9708 => Opcode::VFMADD231PDZ128rkz,
          9709 => Opcode::VFMADD231PDZ256m,
          9710 => Opcode::VFMADD231PDZ256mb,
          9711 => Opcode::VFMADD231PDZ256mbk,
          9712 => Opcode::VFMADD231PDZ256mbkz,
          9713 => Opcode::VFMADD231PDZ256mk,
          9714 => Opcode::VFMADD231PDZ256mkz,
          9715 => Opcode::VFMADD231PDZ256r,
          9716 => Opcode::VFMADD231PDZ256rk,
          9717 => Opcode::VFMADD231PDZ256rkz,
          9718 => Opcode::VFMADD231PDZm,
          9719 => Opcode::VFMADD231PDZmb,
          9720 => Opcode::VFMADD231PDZmbk,
          9721 => Opcode::VFMADD231PDZmbkz,
          9722 => Opcode::VFMADD231PDZmk,
          9723 => Opcode::VFMADD231PDZmkz,
          9724 => Opcode::VFMADD231PDZr,
          9725 => Opcode::VFMADD231PDZrb,
          9726 => Opcode::VFMADD231PDZrbk,
          9727 => Opcode::VFMADD231PDZrbkz,
          9728 => Opcode::VFMADD231PDZrk,
          9729 => Opcode::VFMADD231PDZrkz,
          9730 => Opcode::VFMADD231PDm,
          9731 => Opcode::VFMADD231PDr,
          9732 => Opcode::VFMADD231PHZ128m,
          9733 => Opcode::VFMADD231PHZ128mb,
          9734 => Opcode::VFMADD231PHZ128mbk,
          9735 => Opcode::VFMADD231PHZ128mbkz,
          9736 => Opcode::VFMADD231PHZ128mk,
          9737 => Opcode::VFMADD231PHZ128mkz,
          9738 => Opcode::VFMADD231PHZ128r,
          9739 => Opcode::VFMADD231PHZ128rk,
          9740 => Opcode::VFMADD231PHZ128rkz,
          9741 => Opcode::VFMADD231PHZ256m,
          9742 => Opcode::VFMADD231PHZ256mb,
          9743 => Opcode::VFMADD231PHZ256mbk,
          9744 => Opcode::VFMADD231PHZ256mbkz,
          9745 => Opcode::VFMADD231PHZ256mk,
          9746 => Opcode::VFMADD231PHZ256mkz,
          9747 => Opcode::VFMADD231PHZ256r,
          9748 => Opcode::VFMADD231PHZ256rk,
          9749 => Opcode::VFMADD231PHZ256rkz,
          9750 => Opcode::VFMADD231PHZm,
          9751 => Opcode::VFMADD231PHZmb,
          9752 => Opcode::VFMADD231PHZmbk,
          9753 => Opcode::VFMADD231PHZmbkz,
          9754 => Opcode::VFMADD231PHZmk,
          9755 => Opcode::VFMADD231PHZmkz,
          9756 => Opcode::VFMADD231PHZr,
          9757 => Opcode::VFMADD231PHZrb,
          9758 => Opcode::VFMADD231PHZrbk,
          9759 => Opcode::VFMADD231PHZrbkz,
          9760 => Opcode::VFMADD231PHZrk,
          9761 => Opcode::VFMADD231PHZrkz,
          9762 => Opcode::VFMADD231PSYm,
          9763 => Opcode::VFMADD231PSYr,
          9764 => Opcode::VFMADD231PSZ128m,
          9765 => Opcode::VFMADD231PSZ128mb,
          9766 => Opcode::VFMADD231PSZ128mbk,
          9767 => Opcode::VFMADD231PSZ128mbkz,
          9768 => Opcode::VFMADD231PSZ128mk,
          9769 => Opcode::VFMADD231PSZ128mkz,
          9770 => Opcode::VFMADD231PSZ128r,
          9771 => Opcode::VFMADD231PSZ128rk,
          9772 => Opcode::VFMADD231PSZ128rkz,
          9773 => Opcode::VFMADD231PSZ256m,
          9774 => Opcode::VFMADD231PSZ256mb,
          9775 => Opcode::VFMADD231PSZ256mbk,
          9776 => Opcode::VFMADD231PSZ256mbkz,
          9777 => Opcode::VFMADD231PSZ256mk,
          9778 => Opcode::VFMADD231PSZ256mkz,
          9779 => Opcode::VFMADD231PSZ256r,
          9780 => Opcode::VFMADD231PSZ256rk,
          9781 => Opcode::VFMADD231PSZ256rkz,
          9782 => Opcode::VFMADD231PSZm,
          9783 => Opcode::VFMADD231PSZmb,
          9784 => Opcode::VFMADD231PSZmbk,
          9785 => Opcode::VFMADD231PSZmbkz,
          9786 => Opcode::VFMADD231PSZmk,
          9787 => Opcode::VFMADD231PSZmkz,
          9788 => Opcode::VFMADD231PSZr,
          9789 => Opcode::VFMADD231PSZrb,
          9790 => Opcode::VFMADD231PSZrbk,
          9791 => Opcode::VFMADD231PSZrbkz,
          9792 => Opcode::VFMADD231PSZrk,
          9793 => Opcode::VFMADD231PSZrkz,
          9794 => Opcode::VFMADD231PSm,
          9795 => Opcode::VFMADD231PSr,
          9796 => Opcode::VFMADD231SDZm,
          9797 => Opcode::VFMADD231SDZm_Int,
          9798 => Opcode::VFMADD231SDZmk_Int,
          9799 => Opcode::VFMADD231SDZmkz_Int,
          9800 => Opcode::VFMADD231SDZr,
          9801 => Opcode::VFMADD231SDZr_Int,
          9802 => Opcode::VFMADD231SDZrb,
          9803 => Opcode::VFMADD231SDZrb_Int,
          9804 => Opcode::VFMADD231SDZrbk_Int,
          9805 => Opcode::VFMADD231SDZrbkz_Int,
          9806 => Opcode::VFMADD231SDZrk_Int,
          9807 => Opcode::VFMADD231SDZrkz_Int,
          9808 => Opcode::VFMADD231SDm,
          9809 => Opcode::VFMADD231SDm_Int,
          9810 => Opcode::VFMADD231SDr,
          9811 => Opcode::VFMADD231SDr_Int,
          9812 => Opcode::VFMADD231SHZm,
          9813 => Opcode::VFMADD231SHZm_Int,
          9814 => Opcode::VFMADD231SHZmk_Int,
          9815 => Opcode::VFMADD231SHZmkz_Int,
          9816 => Opcode::VFMADD231SHZr,
          9817 => Opcode::VFMADD231SHZr_Int,
          9818 => Opcode::VFMADD231SHZrb,
          9819 => Opcode::VFMADD231SHZrb_Int,
          9820 => Opcode::VFMADD231SHZrbk_Int,
          9821 => Opcode::VFMADD231SHZrbkz_Int,
          9822 => Opcode::VFMADD231SHZrk_Int,
          9823 => Opcode::VFMADD231SHZrkz_Int,
          9824 => Opcode::VFMADD231SSZm,
          9825 => Opcode::VFMADD231SSZm_Int,
          9826 => Opcode::VFMADD231SSZmk_Int,
          9827 => Opcode::VFMADD231SSZmkz_Int,
          9828 => Opcode::VFMADD231SSZr,
          9829 => Opcode::VFMADD231SSZr_Int,
          9830 => Opcode::VFMADD231SSZrb,
          9831 => Opcode::VFMADD231SSZrb_Int,
          9832 => Opcode::VFMADD231SSZrbk_Int,
          9833 => Opcode::VFMADD231SSZrbkz_Int,
          9834 => Opcode::VFMADD231SSZrk_Int,
          9835 => Opcode::VFMADD231SSZrkz_Int,
          9836 => Opcode::VFMADD231SSm,
          9837 => Opcode::VFMADD231SSm_Int,
          9838 => Opcode::VFMADD231SSr,
          9839 => Opcode::VFMADD231SSr_Int,
          9840 => Opcode::VFMADDCPHZ128m,
          9841 => Opcode::VFMADDCPHZ128mb,
          9842 => Opcode::VFMADDCPHZ128mbk,
          9843 => Opcode::VFMADDCPHZ128mbkz,
          9844 => Opcode::VFMADDCPHZ128mk,
          9845 => Opcode::VFMADDCPHZ128mkz,
          9846 => Opcode::VFMADDCPHZ128r,
          9847 => Opcode::VFMADDCPHZ128rk,
          9848 => Opcode::VFMADDCPHZ128rkz,
          9849 => Opcode::VFMADDCPHZ256m,
          9850 => Opcode::VFMADDCPHZ256mb,
          9851 => Opcode::VFMADDCPHZ256mbk,
          9852 => Opcode::VFMADDCPHZ256mbkz,
          9853 => Opcode::VFMADDCPHZ256mk,
          9854 => Opcode::VFMADDCPHZ256mkz,
          9855 => Opcode::VFMADDCPHZ256r,
          9856 => Opcode::VFMADDCPHZ256rk,
          9857 => Opcode::VFMADDCPHZ256rkz,
          9858 => Opcode::VFMADDCPHZm,
          9859 => Opcode::VFMADDCPHZmb,
          9860 => Opcode::VFMADDCPHZmbk,
          9861 => Opcode::VFMADDCPHZmbkz,
          9862 => Opcode::VFMADDCPHZmk,
          9863 => Opcode::VFMADDCPHZmkz,
          9864 => Opcode::VFMADDCPHZr,
          9865 => Opcode::VFMADDCPHZrb,
          9866 => Opcode::VFMADDCPHZrbk,
          9867 => Opcode::VFMADDCPHZrbkz,
          9868 => Opcode::VFMADDCPHZrk,
          9869 => Opcode::VFMADDCPHZrkz,
          9870 => Opcode::VFMADDCSHZm,
          9871 => Opcode::VFMADDCSHZmk,
          9872 => Opcode::VFMADDCSHZmkz,
          9873 => Opcode::VFMADDCSHZr,
          9874 => Opcode::VFMADDCSHZrb,
          9875 => Opcode::VFMADDCSHZrbk,
          9876 => Opcode::VFMADDCSHZrbkz,
          9877 => Opcode::VFMADDCSHZrk,
          9878 => Opcode::VFMADDCSHZrkz,
          9879 => Opcode::VFMADDPD4Ymr,
          9880 => Opcode::VFMADDPD4Yrm,
          9881 => Opcode::VFMADDPD4Yrr,
          9882 => Opcode::VFMADDPD4Yrr_REV,
          9883 => Opcode::VFMADDPD4mr,
          9884 => Opcode::VFMADDPD4rm,
          9885 => Opcode::VFMADDPD4rr,
          9886 => Opcode::VFMADDPD4rr_REV,
          9887 => Opcode::VFMADDPS4Ymr,
          9888 => Opcode::VFMADDPS4Yrm,
          9889 => Opcode::VFMADDPS4Yrr,
          9890 => Opcode::VFMADDPS4Yrr_REV,
          9891 => Opcode::VFMADDPS4mr,
          9892 => Opcode::VFMADDPS4rm,
          9893 => Opcode::VFMADDPS4rr,
          9894 => Opcode::VFMADDPS4rr_REV,
          9895 => Opcode::VFMADDSD4mr,
          9896 => Opcode::VFMADDSD4mr_Int,
          9897 => Opcode::VFMADDSD4rm,
          9898 => Opcode::VFMADDSD4rm_Int,
          9899 => Opcode::VFMADDSD4rr,
          9900 => Opcode::VFMADDSD4rr_Int,
          9901 => Opcode::VFMADDSD4rr_Int_REV,
          9902 => Opcode::VFMADDSD4rr_REV,
          9903 => Opcode::VFMADDSS4mr,
          9904 => Opcode::VFMADDSS4mr_Int,
          9905 => Opcode::VFMADDSS4rm,
          9906 => Opcode::VFMADDSS4rm_Int,
          9907 => Opcode::VFMADDSS4rr,
          9908 => Opcode::VFMADDSS4rr_Int,
          9909 => Opcode::VFMADDSS4rr_Int_REV,
          9910 => Opcode::VFMADDSS4rr_REV,
          9911 => Opcode::VFMADDSUB132PDYm,
          9912 => Opcode::VFMADDSUB132PDYr,
          9913 => Opcode::VFMADDSUB132PDZ128m,
          9914 => Opcode::VFMADDSUB132PDZ128mb,
          9915 => Opcode::VFMADDSUB132PDZ128mbk,
          9916 => Opcode::VFMADDSUB132PDZ128mbkz,
          9917 => Opcode::VFMADDSUB132PDZ128mk,
          9918 => Opcode::VFMADDSUB132PDZ128mkz,
          9919 => Opcode::VFMADDSUB132PDZ128r,
          9920 => Opcode::VFMADDSUB132PDZ128rk,
          9921 => Opcode::VFMADDSUB132PDZ128rkz,
          9922 => Opcode::VFMADDSUB132PDZ256m,
          9923 => Opcode::VFMADDSUB132PDZ256mb,
          9924 => Opcode::VFMADDSUB132PDZ256mbk,
          9925 => Opcode::VFMADDSUB132PDZ256mbkz,
          9926 => Opcode::VFMADDSUB132PDZ256mk,
          9927 => Opcode::VFMADDSUB132PDZ256mkz,
          9928 => Opcode::VFMADDSUB132PDZ256r,
          9929 => Opcode::VFMADDSUB132PDZ256rk,
          9930 => Opcode::VFMADDSUB132PDZ256rkz,
          9931 => Opcode::VFMADDSUB132PDZm,
          9932 => Opcode::VFMADDSUB132PDZmb,
          9933 => Opcode::VFMADDSUB132PDZmbk,
          9934 => Opcode::VFMADDSUB132PDZmbkz,
          9935 => Opcode::VFMADDSUB132PDZmk,
          9936 => Opcode::VFMADDSUB132PDZmkz,
          9937 => Opcode::VFMADDSUB132PDZr,
          9938 => Opcode::VFMADDSUB132PDZrb,
          9939 => Opcode::VFMADDSUB132PDZrbk,
          9940 => Opcode::VFMADDSUB132PDZrbkz,
          9941 => Opcode::VFMADDSUB132PDZrk,
          9942 => Opcode::VFMADDSUB132PDZrkz,
          9943 => Opcode::VFMADDSUB132PDm,
          9944 => Opcode::VFMADDSUB132PDr,
          9945 => Opcode::VFMADDSUB132PHZ128m,
          9946 => Opcode::VFMADDSUB132PHZ128mb,
          9947 => Opcode::VFMADDSUB132PHZ128mbk,
          9948 => Opcode::VFMADDSUB132PHZ128mbkz,
          9949 => Opcode::VFMADDSUB132PHZ128mk,
          9950 => Opcode::VFMADDSUB132PHZ128mkz,
          9951 => Opcode::VFMADDSUB132PHZ128r,
          9952 => Opcode::VFMADDSUB132PHZ128rk,
          9953 => Opcode::VFMADDSUB132PHZ128rkz,
          9954 => Opcode::VFMADDSUB132PHZ256m,
          9955 => Opcode::VFMADDSUB132PHZ256mb,
          9956 => Opcode::VFMADDSUB132PHZ256mbk,
          9957 => Opcode::VFMADDSUB132PHZ256mbkz,
          9958 => Opcode::VFMADDSUB132PHZ256mk,
          9959 => Opcode::VFMADDSUB132PHZ256mkz,
          9960 => Opcode::VFMADDSUB132PHZ256r,
          9961 => Opcode::VFMADDSUB132PHZ256rk,
          9962 => Opcode::VFMADDSUB132PHZ256rkz,
          9963 => Opcode::VFMADDSUB132PHZm,
          9964 => Opcode::VFMADDSUB132PHZmb,
          9965 => Opcode::VFMADDSUB132PHZmbk,
          9966 => Opcode::VFMADDSUB132PHZmbkz,
          9967 => Opcode::VFMADDSUB132PHZmk,
          9968 => Opcode::VFMADDSUB132PHZmkz,
          9969 => Opcode::VFMADDSUB132PHZr,
          9970 => Opcode::VFMADDSUB132PHZrb,
          9971 => Opcode::VFMADDSUB132PHZrbk,
          9972 => Opcode::VFMADDSUB132PHZrbkz,
          9973 => Opcode::VFMADDSUB132PHZrk,
          9974 => Opcode::VFMADDSUB132PHZrkz,
          9975 => Opcode::VFMADDSUB132PSYm,
          9976 => Opcode::VFMADDSUB132PSYr,
          9977 => Opcode::VFMADDSUB132PSZ128m,
          9978 => Opcode::VFMADDSUB132PSZ128mb,
          9979 => Opcode::VFMADDSUB132PSZ128mbk,
          9980 => Opcode::VFMADDSUB132PSZ128mbkz,
          9981 => Opcode::VFMADDSUB132PSZ128mk,
          9982 => Opcode::VFMADDSUB132PSZ128mkz,
          9983 => Opcode::VFMADDSUB132PSZ128r,
          9984 => Opcode::VFMADDSUB132PSZ128rk,
          9985 => Opcode::VFMADDSUB132PSZ128rkz,
          9986 => Opcode::VFMADDSUB132PSZ256m,
          9987 => Opcode::VFMADDSUB132PSZ256mb,
          9988 => Opcode::VFMADDSUB132PSZ256mbk,
          9989 => Opcode::VFMADDSUB132PSZ256mbkz,
          9990 => Opcode::VFMADDSUB132PSZ256mk,
          9991 => Opcode::VFMADDSUB132PSZ256mkz,
          9992 => Opcode::VFMADDSUB132PSZ256r,
          9993 => Opcode::VFMADDSUB132PSZ256rk,
          9994 => Opcode::VFMADDSUB132PSZ256rkz,
          9995 => Opcode::VFMADDSUB132PSZm,
          9996 => Opcode::VFMADDSUB132PSZmb,
          9997 => Opcode::VFMADDSUB132PSZmbk,
          9998 => Opcode::VFMADDSUB132PSZmbkz,
          9999 => Opcode::VFMADDSUB132PSZmk,
          10000 => Opcode::VFMADDSUB132PSZmkz,
          10001 => Opcode::VFMADDSUB132PSZr,
          10002 => Opcode::VFMADDSUB132PSZrb,
          10003 => Opcode::VFMADDSUB132PSZrbk,
          10004 => Opcode::VFMADDSUB132PSZrbkz,
          10005 => Opcode::VFMADDSUB132PSZrk,
          10006 => Opcode::VFMADDSUB132PSZrkz,
          10007 => Opcode::VFMADDSUB132PSm,
          10008 => Opcode::VFMADDSUB132PSr,
          10009 => Opcode::VFMADDSUB213PDYm,
          10010 => Opcode::VFMADDSUB213PDYr,
          10011 => Opcode::VFMADDSUB213PDZ128m,
          10012 => Opcode::VFMADDSUB213PDZ128mb,
          10013 => Opcode::VFMADDSUB213PDZ128mbk,
          10014 => Opcode::VFMADDSUB213PDZ128mbkz,
          10015 => Opcode::VFMADDSUB213PDZ128mk,
          10016 => Opcode::VFMADDSUB213PDZ128mkz,
          10017 => Opcode::VFMADDSUB213PDZ128r,
          10018 => Opcode::VFMADDSUB213PDZ128rk,
          10019 => Opcode::VFMADDSUB213PDZ128rkz,
          10020 => Opcode::VFMADDSUB213PDZ256m,
          10021 => Opcode::VFMADDSUB213PDZ256mb,
          10022 => Opcode::VFMADDSUB213PDZ256mbk,
          10023 => Opcode::VFMADDSUB213PDZ256mbkz,
          10024 => Opcode::VFMADDSUB213PDZ256mk,
          10025 => Opcode::VFMADDSUB213PDZ256mkz,
          10026 => Opcode::VFMADDSUB213PDZ256r,
          10027 => Opcode::VFMADDSUB213PDZ256rk,
          10028 => Opcode::VFMADDSUB213PDZ256rkz,
          10029 => Opcode::VFMADDSUB213PDZm,
          10030 => Opcode::VFMADDSUB213PDZmb,
          10031 => Opcode::VFMADDSUB213PDZmbk,
          10032 => Opcode::VFMADDSUB213PDZmbkz,
          10033 => Opcode::VFMADDSUB213PDZmk,
          10034 => Opcode::VFMADDSUB213PDZmkz,
          10035 => Opcode::VFMADDSUB213PDZr,
          10036 => Opcode::VFMADDSUB213PDZrb,
          10037 => Opcode::VFMADDSUB213PDZrbk,
          10038 => Opcode::VFMADDSUB213PDZrbkz,
          10039 => Opcode::VFMADDSUB213PDZrk,
          10040 => Opcode::VFMADDSUB213PDZrkz,
          10041 => Opcode::VFMADDSUB213PDm,
          10042 => Opcode::VFMADDSUB213PDr,
          10043 => Opcode::VFMADDSUB213PHZ128m,
          10044 => Opcode::VFMADDSUB213PHZ128mb,
          10045 => Opcode::VFMADDSUB213PHZ128mbk,
          10046 => Opcode::VFMADDSUB213PHZ128mbkz,
          10047 => Opcode::VFMADDSUB213PHZ128mk,
          10048 => Opcode::VFMADDSUB213PHZ128mkz,
          10049 => Opcode::VFMADDSUB213PHZ128r,
          10050 => Opcode::VFMADDSUB213PHZ128rk,
          10051 => Opcode::VFMADDSUB213PHZ128rkz,
          10052 => Opcode::VFMADDSUB213PHZ256m,
          10053 => Opcode::VFMADDSUB213PHZ256mb,
          10054 => Opcode::VFMADDSUB213PHZ256mbk,
          10055 => Opcode::VFMADDSUB213PHZ256mbkz,
          10056 => Opcode::VFMADDSUB213PHZ256mk,
          10057 => Opcode::VFMADDSUB213PHZ256mkz,
          10058 => Opcode::VFMADDSUB213PHZ256r,
          10059 => Opcode::VFMADDSUB213PHZ256rk,
          10060 => Opcode::VFMADDSUB213PHZ256rkz,
          10061 => Opcode::VFMADDSUB213PHZm,
          10062 => Opcode::VFMADDSUB213PHZmb,
          10063 => Opcode::VFMADDSUB213PHZmbk,
          10064 => Opcode::VFMADDSUB213PHZmbkz,
          10065 => Opcode::VFMADDSUB213PHZmk,
          10066 => Opcode::VFMADDSUB213PHZmkz,
          10067 => Opcode::VFMADDSUB213PHZr,
          10068 => Opcode::VFMADDSUB213PHZrb,
          10069 => Opcode::VFMADDSUB213PHZrbk,
          10070 => Opcode::VFMADDSUB213PHZrbkz,
          10071 => Opcode::VFMADDSUB213PHZrk,
          10072 => Opcode::VFMADDSUB213PHZrkz,
          10073 => Opcode::VFMADDSUB213PSYm,
          10074 => Opcode::VFMADDSUB213PSYr,
          10075 => Opcode::VFMADDSUB213PSZ128m,
          10076 => Opcode::VFMADDSUB213PSZ128mb,
          10077 => Opcode::VFMADDSUB213PSZ128mbk,
          10078 => Opcode::VFMADDSUB213PSZ128mbkz,
          10079 => Opcode::VFMADDSUB213PSZ128mk,
          10080 => Opcode::VFMADDSUB213PSZ128mkz,
          10081 => Opcode::VFMADDSUB213PSZ128r,
          10082 => Opcode::VFMADDSUB213PSZ128rk,
          10083 => Opcode::VFMADDSUB213PSZ128rkz,
          10084 => Opcode::VFMADDSUB213PSZ256m,
          10085 => Opcode::VFMADDSUB213PSZ256mb,
          10086 => Opcode::VFMADDSUB213PSZ256mbk,
          10087 => Opcode::VFMADDSUB213PSZ256mbkz,
          10088 => Opcode::VFMADDSUB213PSZ256mk,
          10089 => Opcode::VFMADDSUB213PSZ256mkz,
          10090 => Opcode::VFMADDSUB213PSZ256r,
          10091 => Opcode::VFMADDSUB213PSZ256rk,
          10092 => Opcode::VFMADDSUB213PSZ256rkz,
          10093 => Opcode::VFMADDSUB213PSZm,
          10094 => Opcode::VFMADDSUB213PSZmb,
          10095 => Opcode::VFMADDSUB213PSZmbk,
          10096 => Opcode::VFMADDSUB213PSZmbkz,
          10097 => Opcode::VFMADDSUB213PSZmk,
          10098 => Opcode::VFMADDSUB213PSZmkz,
          10099 => Opcode::VFMADDSUB213PSZr,
          10100 => Opcode::VFMADDSUB213PSZrb,
          10101 => Opcode::VFMADDSUB213PSZrbk,
          10102 => Opcode::VFMADDSUB213PSZrbkz,
          10103 => Opcode::VFMADDSUB213PSZrk,
          10104 => Opcode::VFMADDSUB213PSZrkz,
          10105 => Opcode::VFMADDSUB213PSm,
          10106 => Opcode::VFMADDSUB213PSr,
          10107 => Opcode::VFMADDSUB231PDYm,
          10108 => Opcode::VFMADDSUB231PDYr,
          10109 => Opcode::VFMADDSUB231PDZ128m,
          10110 => Opcode::VFMADDSUB231PDZ128mb,
          10111 => Opcode::VFMADDSUB231PDZ128mbk,
          10112 => Opcode::VFMADDSUB231PDZ128mbkz,
          10113 => Opcode::VFMADDSUB231PDZ128mk,
          10114 => Opcode::VFMADDSUB231PDZ128mkz,
          10115 => Opcode::VFMADDSUB231PDZ128r,
          10116 => Opcode::VFMADDSUB231PDZ128rk,
          10117 => Opcode::VFMADDSUB231PDZ128rkz,
          10118 => Opcode::VFMADDSUB231PDZ256m,
          10119 => Opcode::VFMADDSUB231PDZ256mb,
          10120 => Opcode::VFMADDSUB231PDZ256mbk,
          10121 => Opcode::VFMADDSUB231PDZ256mbkz,
          10122 => Opcode::VFMADDSUB231PDZ256mk,
          10123 => Opcode::VFMADDSUB231PDZ256mkz,
          10124 => Opcode::VFMADDSUB231PDZ256r,
          10125 => Opcode::VFMADDSUB231PDZ256rk,
          10126 => Opcode::VFMADDSUB231PDZ256rkz,
          10127 => Opcode::VFMADDSUB231PDZm,
          10128 => Opcode::VFMADDSUB231PDZmb,
          10129 => Opcode::VFMADDSUB231PDZmbk,
          10130 => Opcode::VFMADDSUB231PDZmbkz,
          10131 => Opcode::VFMADDSUB231PDZmk,
          10132 => Opcode::VFMADDSUB231PDZmkz,
          10133 => Opcode::VFMADDSUB231PDZr,
          10134 => Opcode::VFMADDSUB231PDZrb,
          10135 => Opcode::VFMADDSUB231PDZrbk,
          10136 => Opcode::VFMADDSUB231PDZrbkz,
          10137 => Opcode::VFMADDSUB231PDZrk,
          10138 => Opcode::VFMADDSUB231PDZrkz,
          10139 => Opcode::VFMADDSUB231PDm,
          10140 => Opcode::VFMADDSUB231PDr,
          10141 => Opcode::VFMADDSUB231PHZ128m,
          10142 => Opcode::VFMADDSUB231PHZ128mb,
          10143 => Opcode::VFMADDSUB231PHZ128mbk,
          10144 => Opcode::VFMADDSUB231PHZ128mbkz,
          10145 => Opcode::VFMADDSUB231PHZ128mk,
          10146 => Opcode::VFMADDSUB231PHZ128mkz,
          10147 => Opcode::VFMADDSUB231PHZ128r,
          10148 => Opcode::VFMADDSUB231PHZ128rk,
          10149 => Opcode::VFMADDSUB231PHZ128rkz,
          10150 => Opcode::VFMADDSUB231PHZ256m,
          10151 => Opcode::VFMADDSUB231PHZ256mb,
          10152 => Opcode::VFMADDSUB231PHZ256mbk,
          10153 => Opcode::VFMADDSUB231PHZ256mbkz,
          10154 => Opcode::VFMADDSUB231PHZ256mk,
          10155 => Opcode::VFMADDSUB231PHZ256mkz,
          10156 => Opcode::VFMADDSUB231PHZ256r,
          10157 => Opcode::VFMADDSUB231PHZ256rk,
          10158 => Opcode::VFMADDSUB231PHZ256rkz,
          10159 => Opcode::VFMADDSUB231PHZm,
          10160 => Opcode::VFMADDSUB231PHZmb,
          10161 => Opcode::VFMADDSUB231PHZmbk,
          10162 => Opcode::VFMADDSUB231PHZmbkz,
          10163 => Opcode::VFMADDSUB231PHZmk,
          10164 => Opcode::VFMADDSUB231PHZmkz,
          10165 => Opcode::VFMADDSUB231PHZr,
          10166 => Opcode::VFMADDSUB231PHZrb,
          10167 => Opcode::VFMADDSUB231PHZrbk,
          10168 => Opcode::VFMADDSUB231PHZrbkz,
          10169 => Opcode::VFMADDSUB231PHZrk,
          10170 => Opcode::VFMADDSUB231PHZrkz,
          10171 => Opcode::VFMADDSUB231PSYm,
          10172 => Opcode::VFMADDSUB231PSYr,
          10173 => Opcode::VFMADDSUB231PSZ128m,
          10174 => Opcode::VFMADDSUB231PSZ128mb,
          10175 => Opcode::VFMADDSUB231PSZ128mbk,
          10176 => Opcode::VFMADDSUB231PSZ128mbkz,
          10177 => Opcode::VFMADDSUB231PSZ128mk,
          10178 => Opcode::VFMADDSUB231PSZ128mkz,
          10179 => Opcode::VFMADDSUB231PSZ128r,
          10180 => Opcode::VFMADDSUB231PSZ128rk,
          10181 => Opcode::VFMADDSUB231PSZ128rkz,
          10182 => Opcode::VFMADDSUB231PSZ256m,
          10183 => Opcode::VFMADDSUB231PSZ256mb,
          10184 => Opcode::VFMADDSUB231PSZ256mbk,
          10185 => Opcode::VFMADDSUB231PSZ256mbkz,
          10186 => Opcode::VFMADDSUB231PSZ256mk,
          10187 => Opcode::VFMADDSUB231PSZ256mkz,
          10188 => Opcode::VFMADDSUB231PSZ256r,
          10189 => Opcode::VFMADDSUB231PSZ256rk,
          10190 => Opcode::VFMADDSUB231PSZ256rkz,
          10191 => Opcode::VFMADDSUB231PSZm,
          10192 => Opcode::VFMADDSUB231PSZmb,
          10193 => Opcode::VFMADDSUB231PSZmbk,
          10194 => Opcode::VFMADDSUB231PSZmbkz,
          10195 => Opcode::VFMADDSUB231PSZmk,
          10196 => Opcode::VFMADDSUB231PSZmkz,
          10197 => Opcode::VFMADDSUB231PSZr,
          10198 => Opcode::VFMADDSUB231PSZrb,
          10199 => Opcode::VFMADDSUB231PSZrbk,
          10200 => Opcode::VFMADDSUB231PSZrbkz,
          10201 => Opcode::VFMADDSUB231PSZrk,
          10202 => Opcode::VFMADDSUB231PSZrkz,
          10203 => Opcode::VFMADDSUB231PSm,
          10204 => Opcode::VFMADDSUB231PSr,
          10205 => Opcode::VFMADDSUBPD4Ymr,
          10206 => Opcode::VFMADDSUBPD4Yrm,
          10207 => Opcode::VFMADDSUBPD4Yrr,
          10208 => Opcode::VFMADDSUBPD4Yrr_REV,
          10209 => Opcode::VFMADDSUBPD4mr,
          10210 => Opcode::VFMADDSUBPD4rm,
          10211 => Opcode::VFMADDSUBPD4rr,
          10212 => Opcode::VFMADDSUBPD4rr_REV,
          10213 => Opcode::VFMADDSUBPS4Ymr,
          10214 => Opcode::VFMADDSUBPS4Yrm,
          10215 => Opcode::VFMADDSUBPS4Yrr,
          10216 => Opcode::VFMADDSUBPS4Yrr_REV,
          10217 => Opcode::VFMADDSUBPS4mr,
          10218 => Opcode::VFMADDSUBPS4rm,
          10219 => Opcode::VFMADDSUBPS4rr,
          10220 => Opcode::VFMADDSUBPS4rr_REV,
          10221 => Opcode::VFMSUB132BF16Z128m,
          10222 => Opcode::VFMSUB132BF16Z128mb,
          10223 => Opcode::VFMSUB132BF16Z128mbk,
          10224 => Opcode::VFMSUB132BF16Z128mbkz,
          10225 => Opcode::VFMSUB132BF16Z128mk,
          10226 => Opcode::VFMSUB132BF16Z128mkz,
          10227 => Opcode::VFMSUB132BF16Z128r,
          10228 => Opcode::VFMSUB132BF16Z128rk,
          10229 => Opcode::VFMSUB132BF16Z128rkz,
          10230 => Opcode::VFMSUB132BF16Z256m,
          10231 => Opcode::VFMSUB132BF16Z256mb,
          10232 => Opcode::VFMSUB132BF16Z256mbk,
          10233 => Opcode::VFMSUB132BF16Z256mbkz,
          10234 => Opcode::VFMSUB132BF16Z256mk,
          10235 => Opcode::VFMSUB132BF16Z256mkz,
          10236 => Opcode::VFMSUB132BF16Z256r,
          10237 => Opcode::VFMSUB132BF16Z256rk,
          10238 => Opcode::VFMSUB132BF16Z256rkz,
          10239 => Opcode::VFMSUB132BF16Zm,
          10240 => Opcode::VFMSUB132BF16Zmb,
          10241 => Opcode::VFMSUB132BF16Zmbk,
          10242 => Opcode::VFMSUB132BF16Zmbkz,
          10243 => Opcode::VFMSUB132BF16Zmk,
          10244 => Opcode::VFMSUB132BF16Zmkz,
          10245 => Opcode::VFMSUB132BF16Zr,
          10246 => Opcode::VFMSUB132BF16Zrk,
          10247 => Opcode::VFMSUB132BF16Zrkz,
          10248 => Opcode::VFMSUB132PDYm,
          10249 => Opcode::VFMSUB132PDYr,
          10250 => Opcode::VFMSUB132PDZ128m,
          10251 => Opcode::VFMSUB132PDZ128mb,
          10252 => Opcode::VFMSUB132PDZ128mbk,
          10253 => Opcode::VFMSUB132PDZ128mbkz,
          10254 => Opcode::VFMSUB132PDZ128mk,
          10255 => Opcode::VFMSUB132PDZ128mkz,
          10256 => Opcode::VFMSUB132PDZ128r,
          10257 => Opcode::VFMSUB132PDZ128rk,
          10258 => Opcode::VFMSUB132PDZ128rkz,
          10259 => Opcode::VFMSUB132PDZ256m,
          10260 => Opcode::VFMSUB132PDZ256mb,
          10261 => Opcode::VFMSUB132PDZ256mbk,
          10262 => Opcode::VFMSUB132PDZ256mbkz,
          10263 => Opcode::VFMSUB132PDZ256mk,
          10264 => Opcode::VFMSUB132PDZ256mkz,
          10265 => Opcode::VFMSUB132PDZ256r,
          10266 => Opcode::VFMSUB132PDZ256rk,
          10267 => Opcode::VFMSUB132PDZ256rkz,
          10268 => Opcode::VFMSUB132PDZm,
          10269 => Opcode::VFMSUB132PDZmb,
          10270 => Opcode::VFMSUB132PDZmbk,
          10271 => Opcode::VFMSUB132PDZmbkz,
          10272 => Opcode::VFMSUB132PDZmk,
          10273 => Opcode::VFMSUB132PDZmkz,
          10274 => Opcode::VFMSUB132PDZr,
          10275 => Opcode::VFMSUB132PDZrb,
          10276 => Opcode::VFMSUB132PDZrbk,
          10277 => Opcode::VFMSUB132PDZrbkz,
          10278 => Opcode::VFMSUB132PDZrk,
          10279 => Opcode::VFMSUB132PDZrkz,
          10280 => Opcode::VFMSUB132PDm,
          10281 => Opcode::VFMSUB132PDr,
          10282 => Opcode::VFMSUB132PHZ128m,
          10283 => Opcode::VFMSUB132PHZ128mb,
          10284 => Opcode::VFMSUB132PHZ128mbk,
          10285 => Opcode::VFMSUB132PHZ128mbkz,
          10286 => Opcode::VFMSUB132PHZ128mk,
          10287 => Opcode::VFMSUB132PHZ128mkz,
          10288 => Opcode::VFMSUB132PHZ128r,
          10289 => Opcode::VFMSUB132PHZ128rk,
          10290 => Opcode::VFMSUB132PHZ128rkz,
          10291 => Opcode::VFMSUB132PHZ256m,
          10292 => Opcode::VFMSUB132PHZ256mb,
          10293 => Opcode::VFMSUB132PHZ256mbk,
          10294 => Opcode::VFMSUB132PHZ256mbkz,
          10295 => Opcode::VFMSUB132PHZ256mk,
          10296 => Opcode::VFMSUB132PHZ256mkz,
          10297 => Opcode::VFMSUB132PHZ256r,
          10298 => Opcode::VFMSUB132PHZ256rk,
          10299 => Opcode::VFMSUB132PHZ256rkz,
          10300 => Opcode::VFMSUB132PHZm,
          10301 => Opcode::VFMSUB132PHZmb,
          10302 => Opcode::VFMSUB132PHZmbk,
          10303 => Opcode::VFMSUB132PHZmbkz,
          10304 => Opcode::VFMSUB132PHZmk,
          10305 => Opcode::VFMSUB132PHZmkz,
          10306 => Opcode::VFMSUB132PHZr,
          10307 => Opcode::VFMSUB132PHZrb,
          10308 => Opcode::VFMSUB132PHZrbk,
          10309 => Opcode::VFMSUB132PHZrbkz,
          10310 => Opcode::VFMSUB132PHZrk,
          10311 => Opcode::VFMSUB132PHZrkz,
          10312 => Opcode::VFMSUB132PSYm,
          10313 => Opcode::VFMSUB132PSYr,
          10314 => Opcode::VFMSUB132PSZ128m,
          10315 => Opcode::VFMSUB132PSZ128mb,
          10316 => Opcode::VFMSUB132PSZ128mbk,
          10317 => Opcode::VFMSUB132PSZ128mbkz,
          10318 => Opcode::VFMSUB132PSZ128mk,
          10319 => Opcode::VFMSUB132PSZ128mkz,
          10320 => Opcode::VFMSUB132PSZ128r,
          10321 => Opcode::VFMSUB132PSZ128rk,
          10322 => Opcode::VFMSUB132PSZ128rkz,
          10323 => Opcode::VFMSUB132PSZ256m,
          10324 => Opcode::VFMSUB132PSZ256mb,
          10325 => Opcode::VFMSUB132PSZ256mbk,
          10326 => Opcode::VFMSUB132PSZ256mbkz,
          10327 => Opcode::VFMSUB132PSZ256mk,
          10328 => Opcode::VFMSUB132PSZ256mkz,
          10329 => Opcode::VFMSUB132PSZ256r,
          10330 => Opcode::VFMSUB132PSZ256rk,
          10331 => Opcode::VFMSUB132PSZ256rkz,
          10332 => Opcode::VFMSUB132PSZm,
          10333 => Opcode::VFMSUB132PSZmb,
          10334 => Opcode::VFMSUB132PSZmbk,
          10335 => Opcode::VFMSUB132PSZmbkz,
          10336 => Opcode::VFMSUB132PSZmk,
          10337 => Opcode::VFMSUB132PSZmkz,
          10338 => Opcode::VFMSUB132PSZr,
          10339 => Opcode::VFMSUB132PSZrb,
          10340 => Opcode::VFMSUB132PSZrbk,
          10341 => Opcode::VFMSUB132PSZrbkz,
          10342 => Opcode::VFMSUB132PSZrk,
          10343 => Opcode::VFMSUB132PSZrkz,
          10344 => Opcode::VFMSUB132PSm,
          10345 => Opcode::VFMSUB132PSr,
          10346 => Opcode::VFMSUB132SDZm,
          10347 => Opcode::VFMSUB132SDZm_Int,
          10348 => Opcode::VFMSUB132SDZmk_Int,
          10349 => Opcode::VFMSUB132SDZmkz_Int,
          10350 => Opcode::VFMSUB132SDZr,
          10351 => Opcode::VFMSUB132SDZr_Int,
          10352 => Opcode::VFMSUB132SDZrb,
          10353 => Opcode::VFMSUB132SDZrb_Int,
          10354 => Opcode::VFMSUB132SDZrbk_Int,
          10355 => Opcode::VFMSUB132SDZrbkz_Int,
          10356 => Opcode::VFMSUB132SDZrk_Int,
          10357 => Opcode::VFMSUB132SDZrkz_Int,
          10358 => Opcode::VFMSUB132SDm,
          10359 => Opcode::VFMSUB132SDm_Int,
          10360 => Opcode::VFMSUB132SDr,
          10361 => Opcode::VFMSUB132SDr_Int,
          10362 => Opcode::VFMSUB132SHZm,
          10363 => Opcode::VFMSUB132SHZm_Int,
          10364 => Opcode::VFMSUB132SHZmk_Int,
          10365 => Opcode::VFMSUB132SHZmkz_Int,
          10366 => Opcode::VFMSUB132SHZr,
          10367 => Opcode::VFMSUB132SHZr_Int,
          10368 => Opcode::VFMSUB132SHZrb,
          10369 => Opcode::VFMSUB132SHZrb_Int,
          10370 => Opcode::VFMSUB132SHZrbk_Int,
          10371 => Opcode::VFMSUB132SHZrbkz_Int,
          10372 => Opcode::VFMSUB132SHZrk_Int,
          10373 => Opcode::VFMSUB132SHZrkz_Int,
          10374 => Opcode::VFMSUB132SSZm,
          10375 => Opcode::VFMSUB132SSZm_Int,
          10376 => Opcode::VFMSUB132SSZmk_Int,
          10377 => Opcode::VFMSUB132SSZmkz_Int,
          10378 => Opcode::VFMSUB132SSZr,
          10379 => Opcode::VFMSUB132SSZr_Int,
          10380 => Opcode::VFMSUB132SSZrb,
          10381 => Opcode::VFMSUB132SSZrb_Int,
          10382 => Opcode::VFMSUB132SSZrbk_Int,
          10383 => Opcode::VFMSUB132SSZrbkz_Int,
          10384 => Opcode::VFMSUB132SSZrk_Int,
          10385 => Opcode::VFMSUB132SSZrkz_Int,
          10386 => Opcode::VFMSUB132SSm,
          10387 => Opcode::VFMSUB132SSm_Int,
          10388 => Opcode::VFMSUB132SSr,
          10389 => Opcode::VFMSUB132SSr_Int,
          10390 => Opcode::VFMSUB213BF16Z128m,
          10391 => Opcode::VFMSUB213BF16Z128mb,
          10392 => Opcode::VFMSUB213BF16Z128mbk,
          10393 => Opcode::VFMSUB213BF16Z128mbkz,
          10394 => Opcode::VFMSUB213BF16Z128mk,
          10395 => Opcode::VFMSUB213BF16Z128mkz,
          10396 => Opcode::VFMSUB213BF16Z128r,
          10397 => Opcode::VFMSUB213BF16Z128rk,
          10398 => Opcode::VFMSUB213BF16Z128rkz,
          10399 => Opcode::VFMSUB213BF16Z256m,
          10400 => Opcode::VFMSUB213BF16Z256mb,
          10401 => Opcode::VFMSUB213BF16Z256mbk,
          10402 => Opcode::VFMSUB213BF16Z256mbkz,
          10403 => Opcode::VFMSUB213BF16Z256mk,
          10404 => Opcode::VFMSUB213BF16Z256mkz,
          10405 => Opcode::VFMSUB213BF16Z256r,
          10406 => Opcode::VFMSUB213BF16Z256rk,
          10407 => Opcode::VFMSUB213BF16Z256rkz,
          10408 => Opcode::VFMSUB213BF16Zm,
          10409 => Opcode::VFMSUB213BF16Zmb,
          10410 => Opcode::VFMSUB213BF16Zmbk,
          10411 => Opcode::VFMSUB213BF16Zmbkz,
          10412 => Opcode::VFMSUB213BF16Zmk,
          10413 => Opcode::VFMSUB213BF16Zmkz,
          10414 => Opcode::VFMSUB213BF16Zr,
          10415 => Opcode::VFMSUB213BF16Zrk,
          10416 => Opcode::VFMSUB213BF16Zrkz,
          10417 => Opcode::VFMSUB213PDYm,
          10418 => Opcode::VFMSUB213PDYr,
          10419 => Opcode::VFMSUB213PDZ128m,
          10420 => Opcode::VFMSUB213PDZ128mb,
          10421 => Opcode::VFMSUB213PDZ128mbk,
          10422 => Opcode::VFMSUB213PDZ128mbkz,
          10423 => Opcode::VFMSUB213PDZ128mk,
          10424 => Opcode::VFMSUB213PDZ128mkz,
          10425 => Opcode::VFMSUB213PDZ128r,
          10426 => Opcode::VFMSUB213PDZ128rk,
          10427 => Opcode::VFMSUB213PDZ128rkz,
          10428 => Opcode::VFMSUB213PDZ256m,
          10429 => Opcode::VFMSUB213PDZ256mb,
          10430 => Opcode::VFMSUB213PDZ256mbk,
          10431 => Opcode::VFMSUB213PDZ256mbkz,
          10432 => Opcode::VFMSUB213PDZ256mk,
          10433 => Opcode::VFMSUB213PDZ256mkz,
          10434 => Opcode::VFMSUB213PDZ256r,
          10435 => Opcode::VFMSUB213PDZ256rk,
          10436 => Opcode::VFMSUB213PDZ256rkz,
          10437 => Opcode::VFMSUB213PDZm,
          10438 => Opcode::VFMSUB213PDZmb,
          10439 => Opcode::VFMSUB213PDZmbk,
          10440 => Opcode::VFMSUB213PDZmbkz,
          10441 => Opcode::VFMSUB213PDZmk,
          10442 => Opcode::VFMSUB213PDZmkz,
          10443 => Opcode::VFMSUB213PDZr,
          10444 => Opcode::VFMSUB213PDZrb,
          10445 => Opcode::VFMSUB213PDZrbk,
          10446 => Opcode::VFMSUB213PDZrbkz,
          10447 => Opcode::VFMSUB213PDZrk,
          10448 => Opcode::VFMSUB213PDZrkz,
          10449 => Opcode::VFMSUB213PDm,
          10450 => Opcode::VFMSUB213PDr,
          10451 => Opcode::VFMSUB213PHZ128m,
          10452 => Opcode::VFMSUB213PHZ128mb,
          10453 => Opcode::VFMSUB213PHZ128mbk,
          10454 => Opcode::VFMSUB213PHZ128mbkz,
          10455 => Opcode::VFMSUB213PHZ128mk,
          10456 => Opcode::VFMSUB213PHZ128mkz,
          10457 => Opcode::VFMSUB213PHZ128r,
          10458 => Opcode::VFMSUB213PHZ128rk,
          10459 => Opcode::VFMSUB213PHZ128rkz,
          10460 => Opcode::VFMSUB213PHZ256m,
          10461 => Opcode::VFMSUB213PHZ256mb,
          10462 => Opcode::VFMSUB213PHZ256mbk,
          10463 => Opcode::VFMSUB213PHZ256mbkz,
          10464 => Opcode::VFMSUB213PHZ256mk,
          10465 => Opcode::VFMSUB213PHZ256mkz,
          10466 => Opcode::VFMSUB213PHZ256r,
          10467 => Opcode::VFMSUB213PHZ256rk,
          10468 => Opcode::VFMSUB213PHZ256rkz,
          10469 => Opcode::VFMSUB213PHZm,
          10470 => Opcode::VFMSUB213PHZmb,
          10471 => Opcode::VFMSUB213PHZmbk,
          10472 => Opcode::VFMSUB213PHZmbkz,
          10473 => Opcode::VFMSUB213PHZmk,
          10474 => Opcode::VFMSUB213PHZmkz,
          10475 => Opcode::VFMSUB213PHZr,
          10476 => Opcode::VFMSUB213PHZrb,
          10477 => Opcode::VFMSUB213PHZrbk,
          10478 => Opcode::VFMSUB213PHZrbkz,
          10479 => Opcode::VFMSUB213PHZrk,
          10480 => Opcode::VFMSUB213PHZrkz,
          10481 => Opcode::VFMSUB213PSYm,
          10482 => Opcode::VFMSUB213PSYr,
          10483 => Opcode::VFMSUB213PSZ128m,
          10484 => Opcode::VFMSUB213PSZ128mb,
          10485 => Opcode::VFMSUB213PSZ128mbk,
          10486 => Opcode::VFMSUB213PSZ128mbkz,
          10487 => Opcode::VFMSUB213PSZ128mk,
          10488 => Opcode::VFMSUB213PSZ128mkz,
          10489 => Opcode::VFMSUB213PSZ128r,
          10490 => Opcode::VFMSUB213PSZ128rk,
          10491 => Opcode::VFMSUB213PSZ128rkz,
          10492 => Opcode::VFMSUB213PSZ256m,
          10493 => Opcode::VFMSUB213PSZ256mb,
          10494 => Opcode::VFMSUB213PSZ256mbk,
          10495 => Opcode::VFMSUB213PSZ256mbkz,
          10496 => Opcode::VFMSUB213PSZ256mk,
          10497 => Opcode::VFMSUB213PSZ256mkz,
          10498 => Opcode::VFMSUB213PSZ256r,
          10499 => Opcode::VFMSUB213PSZ256rk,
          10500 => Opcode::VFMSUB213PSZ256rkz,
          10501 => Opcode::VFMSUB213PSZm,
          10502 => Opcode::VFMSUB213PSZmb,
          10503 => Opcode::VFMSUB213PSZmbk,
          10504 => Opcode::VFMSUB213PSZmbkz,
          10505 => Opcode::VFMSUB213PSZmk,
          10506 => Opcode::VFMSUB213PSZmkz,
          10507 => Opcode::VFMSUB213PSZr,
          10508 => Opcode::VFMSUB213PSZrb,
          10509 => Opcode::VFMSUB213PSZrbk,
          10510 => Opcode::VFMSUB213PSZrbkz,
          10511 => Opcode::VFMSUB213PSZrk,
          10512 => Opcode::VFMSUB213PSZrkz,
          10513 => Opcode::VFMSUB213PSm,
          10514 => Opcode::VFMSUB213PSr,
          10515 => Opcode::VFMSUB213SDZm,
          10516 => Opcode::VFMSUB213SDZm_Int,
          10517 => Opcode::VFMSUB213SDZmk_Int,
          10518 => Opcode::VFMSUB213SDZmkz_Int,
          10519 => Opcode::VFMSUB213SDZr,
          10520 => Opcode::VFMSUB213SDZr_Int,
          10521 => Opcode::VFMSUB213SDZrb,
          10522 => Opcode::VFMSUB213SDZrb_Int,
          10523 => Opcode::VFMSUB213SDZrbk_Int,
          10524 => Opcode::VFMSUB213SDZrbkz_Int,
          10525 => Opcode::VFMSUB213SDZrk_Int,
          10526 => Opcode::VFMSUB213SDZrkz_Int,
          10527 => Opcode::VFMSUB213SDm,
          10528 => Opcode::VFMSUB213SDm_Int,
          10529 => Opcode::VFMSUB213SDr,
          10530 => Opcode::VFMSUB213SDr_Int,
          10531 => Opcode::VFMSUB213SHZm,
          10532 => Opcode::VFMSUB213SHZm_Int,
          10533 => Opcode::VFMSUB213SHZmk_Int,
          10534 => Opcode::VFMSUB213SHZmkz_Int,
          10535 => Opcode::VFMSUB213SHZr,
          10536 => Opcode::VFMSUB213SHZr_Int,
          10537 => Opcode::VFMSUB213SHZrb,
          10538 => Opcode::VFMSUB213SHZrb_Int,
          10539 => Opcode::VFMSUB213SHZrbk_Int,
          10540 => Opcode::VFMSUB213SHZrbkz_Int,
          10541 => Opcode::VFMSUB213SHZrk_Int,
          10542 => Opcode::VFMSUB213SHZrkz_Int,
          10543 => Opcode::VFMSUB213SSZm,
          10544 => Opcode::VFMSUB213SSZm_Int,
          10545 => Opcode::VFMSUB213SSZmk_Int,
          10546 => Opcode::VFMSUB213SSZmkz_Int,
          10547 => Opcode::VFMSUB213SSZr,
          10548 => Opcode::VFMSUB213SSZr_Int,
          10549 => Opcode::VFMSUB213SSZrb,
          10550 => Opcode::VFMSUB213SSZrb_Int,
          10551 => Opcode::VFMSUB213SSZrbk_Int,
          10552 => Opcode::VFMSUB213SSZrbkz_Int,
          10553 => Opcode::VFMSUB213SSZrk_Int,
          10554 => Opcode::VFMSUB213SSZrkz_Int,
          10555 => Opcode::VFMSUB213SSm,
          10556 => Opcode::VFMSUB213SSm_Int,
          10557 => Opcode::VFMSUB213SSr,
          10558 => Opcode::VFMSUB213SSr_Int,
          10559 => Opcode::VFMSUB231BF16Z128m,
          10560 => Opcode::VFMSUB231BF16Z128mb,
          10561 => Opcode::VFMSUB231BF16Z128mbk,
          10562 => Opcode::VFMSUB231BF16Z128mbkz,
          10563 => Opcode::VFMSUB231BF16Z128mk,
          10564 => Opcode::VFMSUB231BF16Z128mkz,
          10565 => Opcode::VFMSUB231BF16Z128r,
          10566 => Opcode::VFMSUB231BF16Z128rk,
          10567 => Opcode::VFMSUB231BF16Z128rkz,
          10568 => Opcode::VFMSUB231BF16Z256m,
          10569 => Opcode::VFMSUB231BF16Z256mb,
          10570 => Opcode::VFMSUB231BF16Z256mbk,
          10571 => Opcode::VFMSUB231BF16Z256mbkz,
          10572 => Opcode::VFMSUB231BF16Z256mk,
          10573 => Opcode::VFMSUB231BF16Z256mkz,
          10574 => Opcode::VFMSUB231BF16Z256r,
          10575 => Opcode::VFMSUB231BF16Z256rk,
          10576 => Opcode::VFMSUB231BF16Z256rkz,
          10577 => Opcode::VFMSUB231BF16Zm,
          10578 => Opcode::VFMSUB231BF16Zmb,
          10579 => Opcode::VFMSUB231BF16Zmbk,
          10580 => Opcode::VFMSUB231BF16Zmbkz,
          10581 => Opcode::VFMSUB231BF16Zmk,
          10582 => Opcode::VFMSUB231BF16Zmkz,
          10583 => Opcode::VFMSUB231BF16Zr,
          10584 => Opcode::VFMSUB231BF16Zrk,
          10585 => Opcode::VFMSUB231BF16Zrkz,
          10586 => Opcode::VFMSUB231PDYm,
          10587 => Opcode::VFMSUB231PDYr,
          10588 => Opcode::VFMSUB231PDZ128m,
          10589 => Opcode::VFMSUB231PDZ128mb,
          10590 => Opcode::VFMSUB231PDZ128mbk,
          10591 => Opcode::VFMSUB231PDZ128mbkz,
          10592 => Opcode::VFMSUB231PDZ128mk,
          10593 => Opcode::VFMSUB231PDZ128mkz,
          10594 => Opcode::VFMSUB231PDZ128r,
          10595 => Opcode::VFMSUB231PDZ128rk,
          10596 => Opcode::VFMSUB231PDZ128rkz,
          10597 => Opcode::VFMSUB231PDZ256m,
          10598 => Opcode::VFMSUB231PDZ256mb,
          10599 => Opcode::VFMSUB231PDZ256mbk,
          10600 => Opcode::VFMSUB231PDZ256mbkz,
          10601 => Opcode::VFMSUB231PDZ256mk,
          10602 => Opcode::VFMSUB231PDZ256mkz,
          10603 => Opcode::VFMSUB231PDZ256r,
          10604 => Opcode::VFMSUB231PDZ256rk,
          10605 => Opcode::VFMSUB231PDZ256rkz,
          10606 => Opcode::VFMSUB231PDZm,
          10607 => Opcode::VFMSUB231PDZmb,
          10608 => Opcode::VFMSUB231PDZmbk,
          10609 => Opcode::VFMSUB231PDZmbkz,
          10610 => Opcode::VFMSUB231PDZmk,
          10611 => Opcode::VFMSUB231PDZmkz,
          10612 => Opcode::VFMSUB231PDZr,
          10613 => Opcode::VFMSUB231PDZrb,
          10614 => Opcode::VFMSUB231PDZrbk,
          10615 => Opcode::VFMSUB231PDZrbkz,
          10616 => Opcode::VFMSUB231PDZrk,
          10617 => Opcode::VFMSUB231PDZrkz,
          10618 => Opcode::VFMSUB231PDm,
          10619 => Opcode::VFMSUB231PDr,
          10620 => Opcode::VFMSUB231PHZ128m,
          10621 => Opcode::VFMSUB231PHZ128mb,
          10622 => Opcode::VFMSUB231PHZ128mbk,
          10623 => Opcode::VFMSUB231PHZ128mbkz,
          10624 => Opcode::VFMSUB231PHZ128mk,
          10625 => Opcode::VFMSUB231PHZ128mkz,
          10626 => Opcode::VFMSUB231PHZ128r,
          10627 => Opcode::VFMSUB231PHZ128rk,
          10628 => Opcode::VFMSUB231PHZ128rkz,
          10629 => Opcode::VFMSUB231PHZ256m,
          10630 => Opcode::VFMSUB231PHZ256mb,
          10631 => Opcode::VFMSUB231PHZ256mbk,
          10632 => Opcode::VFMSUB231PHZ256mbkz,
          10633 => Opcode::VFMSUB231PHZ256mk,
          10634 => Opcode::VFMSUB231PHZ256mkz,
          10635 => Opcode::VFMSUB231PHZ256r,
          10636 => Opcode::VFMSUB231PHZ256rk,
          10637 => Opcode::VFMSUB231PHZ256rkz,
          10638 => Opcode::VFMSUB231PHZm,
          10639 => Opcode::VFMSUB231PHZmb,
          10640 => Opcode::VFMSUB231PHZmbk,
          10641 => Opcode::VFMSUB231PHZmbkz,
          10642 => Opcode::VFMSUB231PHZmk,
          10643 => Opcode::VFMSUB231PHZmkz,
          10644 => Opcode::VFMSUB231PHZr,
          10645 => Opcode::VFMSUB231PHZrb,
          10646 => Opcode::VFMSUB231PHZrbk,
          10647 => Opcode::VFMSUB231PHZrbkz,
          10648 => Opcode::VFMSUB231PHZrk,
          10649 => Opcode::VFMSUB231PHZrkz,
          10650 => Opcode::VFMSUB231PSYm,
          10651 => Opcode::VFMSUB231PSYr,
          10652 => Opcode::VFMSUB231PSZ128m,
          10653 => Opcode::VFMSUB231PSZ128mb,
          10654 => Opcode::VFMSUB231PSZ128mbk,
          10655 => Opcode::VFMSUB231PSZ128mbkz,
          10656 => Opcode::VFMSUB231PSZ128mk,
          10657 => Opcode::VFMSUB231PSZ128mkz,
          10658 => Opcode::VFMSUB231PSZ128r,
          10659 => Opcode::VFMSUB231PSZ128rk,
          10660 => Opcode::VFMSUB231PSZ128rkz,
          10661 => Opcode::VFMSUB231PSZ256m,
          10662 => Opcode::VFMSUB231PSZ256mb,
          10663 => Opcode::VFMSUB231PSZ256mbk,
          10664 => Opcode::VFMSUB231PSZ256mbkz,
          10665 => Opcode::VFMSUB231PSZ256mk,
          10666 => Opcode::VFMSUB231PSZ256mkz,
          10667 => Opcode::VFMSUB231PSZ256r,
          10668 => Opcode::VFMSUB231PSZ256rk,
          10669 => Opcode::VFMSUB231PSZ256rkz,
          10670 => Opcode::VFMSUB231PSZm,
          10671 => Opcode::VFMSUB231PSZmb,
          10672 => Opcode::VFMSUB231PSZmbk,
          10673 => Opcode::VFMSUB231PSZmbkz,
          10674 => Opcode::VFMSUB231PSZmk,
          10675 => Opcode::VFMSUB231PSZmkz,
          10676 => Opcode::VFMSUB231PSZr,
          10677 => Opcode::VFMSUB231PSZrb,
          10678 => Opcode::VFMSUB231PSZrbk,
          10679 => Opcode::VFMSUB231PSZrbkz,
          10680 => Opcode::VFMSUB231PSZrk,
          10681 => Opcode::VFMSUB231PSZrkz,
          10682 => Opcode::VFMSUB231PSm,
          10683 => Opcode::VFMSUB231PSr,
          10684 => Opcode::VFMSUB231SDZm,
          10685 => Opcode::VFMSUB231SDZm_Int,
          10686 => Opcode::VFMSUB231SDZmk_Int,
          10687 => Opcode::VFMSUB231SDZmkz_Int,
          10688 => Opcode::VFMSUB231SDZr,
          10689 => Opcode::VFMSUB231SDZr_Int,
          10690 => Opcode::VFMSUB231SDZrb,
          10691 => Opcode::VFMSUB231SDZrb_Int,
          10692 => Opcode::VFMSUB231SDZrbk_Int,
          10693 => Opcode::VFMSUB231SDZrbkz_Int,
          10694 => Opcode::VFMSUB231SDZrk_Int,
          10695 => Opcode::VFMSUB231SDZrkz_Int,
          10696 => Opcode::VFMSUB231SDm,
          10697 => Opcode::VFMSUB231SDm_Int,
          10698 => Opcode::VFMSUB231SDr,
          10699 => Opcode::VFMSUB231SDr_Int,
          10700 => Opcode::VFMSUB231SHZm,
          10701 => Opcode::VFMSUB231SHZm_Int,
          10702 => Opcode::VFMSUB231SHZmk_Int,
          10703 => Opcode::VFMSUB231SHZmkz_Int,
          10704 => Opcode::VFMSUB231SHZr,
          10705 => Opcode::VFMSUB231SHZr_Int,
          10706 => Opcode::VFMSUB231SHZrb,
          10707 => Opcode::VFMSUB231SHZrb_Int,
          10708 => Opcode::VFMSUB231SHZrbk_Int,
          10709 => Opcode::VFMSUB231SHZrbkz_Int,
          10710 => Opcode::VFMSUB231SHZrk_Int,
          10711 => Opcode::VFMSUB231SHZrkz_Int,
          10712 => Opcode::VFMSUB231SSZm,
          10713 => Opcode::VFMSUB231SSZm_Int,
          10714 => Opcode::VFMSUB231SSZmk_Int,
          10715 => Opcode::VFMSUB231SSZmkz_Int,
          10716 => Opcode::VFMSUB231SSZr,
          10717 => Opcode::VFMSUB231SSZr_Int,
          10718 => Opcode::VFMSUB231SSZrb,
          10719 => Opcode::VFMSUB231SSZrb_Int,
          10720 => Opcode::VFMSUB231SSZrbk_Int,
          10721 => Opcode::VFMSUB231SSZrbkz_Int,
          10722 => Opcode::VFMSUB231SSZrk_Int,
          10723 => Opcode::VFMSUB231SSZrkz_Int,
          10724 => Opcode::VFMSUB231SSm,
          10725 => Opcode::VFMSUB231SSm_Int,
          10726 => Opcode::VFMSUB231SSr,
          10727 => Opcode::VFMSUB231SSr_Int,
          10728 => Opcode::VFMSUBADD132PDYm,
          10729 => Opcode::VFMSUBADD132PDYr,
          10730 => Opcode::VFMSUBADD132PDZ128m,
          10731 => Opcode::VFMSUBADD132PDZ128mb,
          10732 => Opcode::VFMSUBADD132PDZ128mbk,
          10733 => Opcode::VFMSUBADD132PDZ128mbkz,
          10734 => Opcode::VFMSUBADD132PDZ128mk,
          10735 => Opcode::VFMSUBADD132PDZ128mkz,
          10736 => Opcode::VFMSUBADD132PDZ128r,
          10737 => Opcode::VFMSUBADD132PDZ128rk,
          10738 => Opcode::VFMSUBADD132PDZ128rkz,
          10739 => Opcode::VFMSUBADD132PDZ256m,
          10740 => Opcode::VFMSUBADD132PDZ256mb,
          10741 => Opcode::VFMSUBADD132PDZ256mbk,
          10742 => Opcode::VFMSUBADD132PDZ256mbkz,
          10743 => Opcode::VFMSUBADD132PDZ256mk,
          10744 => Opcode::VFMSUBADD132PDZ256mkz,
          10745 => Opcode::VFMSUBADD132PDZ256r,
          10746 => Opcode::VFMSUBADD132PDZ256rk,
          10747 => Opcode::VFMSUBADD132PDZ256rkz,
          10748 => Opcode::VFMSUBADD132PDZm,
          10749 => Opcode::VFMSUBADD132PDZmb,
          10750 => Opcode::VFMSUBADD132PDZmbk,
          10751 => Opcode::VFMSUBADD132PDZmbkz,
          10752 => Opcode::VFMSUBADD132PDZmk,
          10753 => Opcode::VFMSUBADD132PDZmkz,
          10754 => Opcode::VFMSUBADD132PDZr,
          10755 => Opcode::VFMSUBADD132PDZrb,
          10756 => Opcode::VFMSUBADD132PDZrbk,
          10757 => Opcode::VFMSUBADD132PDZrbkz,
          10758 => Opcode::VFMSUBADD132PDZrk,
          10759 => Opcode::VFMSUBADD132PDZrkz,
          10760 => Opcode::VFMSUBADD132PDm,
          10761 => Opcode::VFMSUBADD132PDr,
          10762 => Opcode::VFMSUBADD132PHZ128m,
          10763 => Opcode::VFMSUBADD132PHZ128mb,
          10764 => Opcode::VFMSUBADD132PHZ128mbk,
          10765 => Opcode::VFMSUBADD132PHZ128mbkz,
          10766 => Opcode::VFMSUBADD132PHZ128mk,
          10767 => Opcode::VFMSUBADD132PHZ128mkz,
          10768 => Opcode::VFMSUBADD132PHZ128r,
          10769 => Opcode::VFMSUBADD132PHZ128rk,
          10770 => Opcode::VFMSUBADD132PHZ128rkz,
          10771 => Opcode::VFMSUBADD132PHZ256m,
          10772 => Opcode::VFMSUBADD132PHZ256mb,
          10773 => Opcode::VFMSUBADD132PHZ256mbk,
          10774 => Opcode::VFMSUBADD132PHZ256mbkz,
          10775 => Opcode::VFMSUBADD132PHZ256mk,
          10776 => Opcode::VFMSUBADD132PHZ256mkz,
          10777 => Opcode::VFMSUBADD132PHZ256r,
          10778 => Opcode::VFMSUBADD132PHZ256rk,
          10779 => Opcode::VFMSUBADD132PHZ256rkz,
          10780 => Opcode::VFMSUBADD132PHZm,
          10781 => Opcode::VFMSUBADD132PHZmb,
          10782 => Opcode::VFMSUBADD132PHZmbk,
          10783 => Opcode::VFMSUBADD132PHZmbkz,
          10784 => Opcode::VFMSUBADD132PHZmk,
          10785 => Opcode::VFMSUBADD132PHZmkz,
          10786 => Opcode::VFMSUBADD132PHZr,
          10787 => Opcode::VFMSUBADD132PHZrb,
          10788 => Opcode::VFMSUBADD132PHZrbk,
          10789 => Opcode::VFMSUBADD132PHZrbkz,
          10790 => Opcode::VFMSUBADD132PHZrk,
          10791 => Opcode::VFMSUBADD132PHZrkz,
          10792 => Opcode::VFMSUBADD132PSYm,
          10793 => Opcode::VFMSUBADD132PSYr,
          10794 => Opcode::VFMSUBADD132PSZ128m,
          10795 => Opcode::VFMSUBADD132PSZ128mb,
          10796 => Opcode::VFMSUBADD132PSZ128mbk,
          10797 => Opcode::VFMSUBADD132PSZ128mbkz,
          10798 => Opcode::VFMSUBADD132PSZ128mk,
          10799 => Opcode::VFMSUBADD132PSZ128mkz,
          10800 => Opcode::VFMSUBADD132PSZ128r,
          10801 => Opcode::VFMSUBADD132PSZ128rk,
          10802 => Opcode::VFMSUBADD132PSZ128rkz,
          10803 => Opcode::VFMSUBADD132PSZ256m,
          10804 => Opcode::VFMSUBADD132PSZ256mb,
          10805 => Opcode::VFMSUBADD132PSZ256mbk,
          10806 => Opcode::VFMSUBADD132PSZ256mbkz,
          10807 => Opcode::VFMSUBADD132PSZ256mk,
          10808 => Opcode::VFMSUBADD132PSZ256mkz,
          10809 => Opcode::VFMSUBADD132PSZ256r,
          10810 => Opcode::VFMSUBADD132PSZ256rk,
          10811 => Opcode::VFMSUBADD132PSZ256rkz,
          10812 => Opcode::VFMSUBADD132PSZm,
          10813 => Opcode::VFMSUBADD132PSZmb,
          10814 => Opcode::VFMSUBADD132PSZmbk,
          10815 => Opcode::VFMSUBADD132PSZmbkz,
          10816 => Opcode::VFMSUBADD132PSZmk,
          10817 => Opcode::VFMSUBADD132PSZmkz,
          10818 => Opcode::VFMSUBADD132PSZr,
          10819 => Opcode::VFMSUBADD132PSZrb,
          10820 => Opcode::VFMSUBADD132PSZrbk,
          10821 => Opcode::VFMSUBADD132PSZrbkz,
          10822 => Opcode::VFMSUBADD132PSZrk,
          10823 => Opcode::VFMSUBADD132PSZrkz,
          10824 => Opcode::VFMSUBADD132PSm,
          10825 => Opcode::VFMSUBADD132PSr,
          10826 => Opcode::VFMSUBADD213PDYm,
          10827 => Opcode::VFMSUBADD213PDYr,
          10828 => Opcode::VFMSUBADD213PDZ128m,
          10829 => Opcode::VFMSUBADD213PDZ128mb,
          10830 => Opcode::VFMSUBADD213PDZ128mbk,
          10831 => Opcode::VFMSUBADD213PDZ128mbkz,
          10832 => Opcode::VFMSUBADD213PDZ128mk,
          10833 => Opcode::VFMSUBADD213PDZ128mkz,
          10834 => Opcode::VFMSUBADD213PDZ128r,
          10835 => Opcode::VFMSUBADD213PDZ128rk,
          10836 => Opcode::VFMSUBADD213PDZ128rkz,
          10837 => Opcode::VFMSUBADD213PDZ256m,
          10838 => Opcode::VFMSUBADD213PDZ256mb,
          10839 => Opcode::VFMSUBADD213PDZ256mbk,
          10840 => Opcode::VFMSUBADD213PDZ256mbkz,
          10841 => Opcode::VFMSUBADD213PDZ256mk,
          10842 => Opcode::VFMSUBADD213PDZ256mkz,
          10843 => Opcode::VFMSUBADD213PDZ256r,
          10844 => Opcode::VFMSUBADD213PDZ256rk,
          10845 => Opcode::VFMSUBADD213PDZ256rkz,
          10846 => Opcode::VFMSUBADD213PDZm,
          10847 => Opcode::VFMSUBADD213PDZmb,
          10848 => Opcode::VFMSUBADD213PDZmbk,
          10849 => Opcode::VFMSUBADD213PDZmbkz,
          10850 => Opcode::VFMSUBADD213PDZmk,
          10851 => Opcode::VFMSUBADD213PDZmkz,
          10852 => Opcode::VFMSUBADD213PDZr,
          10853 => Opcode::VFMSUBADD213PDZrb,
          10854 => Opcode::VFMSUBADD213PDZrbk,
          10855 => Opcode::VFMSUBADD213PDZrbkz,
          10856 => Opcode::VFMSUBADD213PDZrk,
          10857 => Opcode::VFMSUBADD213PDZrkz,
          10858 => Opcode::VFMSUBADD213PDm,
          10859 => Opcode::VFMSUBADD213PDr,
          10860 => Opcode::VFMSUBADD213PHZ128m,
          10861 => Opcode::VFMSUBADD213PHZ128mb,
          10862 => Opcode::VFMSUBADD213PHZ128mbk,
          10863 => Opcode::VFMSUBADD213PHZ128mbkz,
          10864 => Opcode::VFMSUBADD213PHZ128mk,
          10865 => Opcode::VFMSUBADD213PHZ128mkz,
          10866 => Opcode::VFMSUBADD213PHZ128r,
          10867 => Opcode::VFMSUBADD213PHZ128rk,
          10868 => Opcode::VFMSUBADD213PHZ128rkz,
          10869 => Opcode::VFMSUBADD213PHZ256m,
          10870 => Opcode::VFMSUBADD213PHZ256mb,
          10871 => Opcode::VFMSUBADD213PHZ256mbk,
          10872 => Opcode::VFMSUBADD213PHZ256mbkz,
          10873 => Opcode::VFMSUBADD213PHZ256mk,
          10874 => Opcode::VFMSUBADD213PHZ256mkz,
          10875 => Opcode::VFMSUBADD213PHZ256r,
          10876 => Opcode::VFMSUBADD213PHZ256rk,
          10877 => Opcode::VFMSUBADD213PHZ256rkz,
          10878 => Opcode::VFMSUBADD213PHZm,
          10879 => Opcode::VFMSUBADD213PHZmb,
          10880 => Opcode::VFMSUBADD213PHZmbk,
          10881 => Opcode::VFMSUBADD213PHZmbkz,
          10882 => Opcode::VFMSUBADD213PHZmk,
          10883 => Opcode::VFMSUBADD213PHZmkz,
          10884 => Opcode::VFMSUBADD213PHZr,
          10885 => Opcode::VFMSUBADD213PHZrb,
          10886 => Opcode::VFMSUBADD213PHZrbk,
          10887 => Opcode::VFMSUBADD213PHZrbkz,
          10888 => Opcode::VFMSUBADD213PHZrk,
          10889 => Opcode::VFMSUBADD213PHZrkz,
          10890 => Opcode::VFMSUBADD213PSYm,
          10891 => Opcode::VFMSUBADD213PSYr,
          10892 => Opcode::VFMSUBADD213PSZ128m,
          10893 => Opcode::VFMSUBADD213PSZ128mb,
          10894 => Opcode::VFMSUBADD213PSZ128mbk,
          10895 => Opcode::VFMSUBADD213PSZ128mbkz,
          10896 => Opcode::VFMSUBADD213PSZ128mk,
          10897 => Opcode::VFMSUBADD213PSZ128mkz,
          10898 => Opcode::VFMSUBADD213PSZ128r,
          10899 => Opcode::VFMSUBADD213PSZ128rk,
          10900 => Opcode::VFMSUBADD213PSZ128rkz,
          10901 => Opcode::VFMSUBADD213PSZ256m,
          10902 => Opcode::VFMSUBADD213PSZ256mb,
          10903 => Opcode::VFMSUBADD213PSZ256mbk,
          10904 => Opcode::VFMSUBADD213PSZ256mbkz,
          10905 => Opcode::VFMSUBADD213PSZ256mk,
          10906 => Opcode::VFMSUBADD213PSZ256mkz,
          10907 => Opcode::VFMSUBADD213PSZ256r,
          10908 => Opcode::VFMSUBADD213PSZ256rk,
          10909 => Opcode::VFMSUBADD213PSZ256rkz,
          10910 => Opcode::VFMSUBADD213PSZm,
          10911 => Opcode::VFMSUBADD213PSZmb,
          10912 => Opcode::VFMSUBADD213PSZmbk,
          10913 => Opcode::VFMSUBADD213PSZmbkz,
          10914 => Opcode::VFMSUBADD213PSZmk,
          10915 => Opcode::VFMSUBADD213PSZmkz,
          10916 => Opcode::VFMSUBADD213PSZr,
          10917 => Opcode::VFMSUBADD213PSZrb,
          10918 => Opcode::VFMSUBADD213PSZrbk,
          10919 => Opcode::VFMSUBADD213PSZrbkz,
          10920 => Opcode::VFMSUBADD213PSZrk,
          10921 => Opcode::VFMSUBADD213PSZrkz,
          10922 => Opcode::VFMSUBADD213PSm,
          10923 => Opcode::VFMSUBADD213PSr,
          10924 => Opcode::VFMSUBADD231PDYm,
          10925 => Opcode::VFMSUBADD231PDYr,
          10926 => Opcode::VFMSUBADD231PDZ128m,
          10927 => Opcode::VFMSUBADD231PDZ128mb,
          10928 => Opcode::VFMSUBADD231PDZ128mbk,
          10929 => Opcode::VFMSUBADD231PDZ128mbkz,
          10930 => Opcode::VFMSUBADD231PDZ128mk,
          10931 => Opcode::VFMSUBADD231PDZ128mkz,
          10932 => Opcode::VFMSUBADD231PDZ128r,
          10933 => Opcode::VFMSUBADD231PDZ128rk,
          10934 => Opcode::VFMSUBADD231PDZ128rkz,
          10935 => Opcode::VFMSUBADD231PDZ256m,
          10936 => Opcode::VFMSUBADD231PDZ256mb,
          10937 => Opcode::VFMSUBADD231PDZ256mbk,
          10938 => Opcode::VFMSUBADD231PDZ256mbkz,
          10939 => Opcode::VFMSUBADD231PDZ256mk,
          10940 => Opcode::VFMSUBADD231PDZ256mkz,
          10941 => Opcode::VFMSUBADD231PDZ256r,
          10942 => Opcode::VFMSUBADD231PDZ256rk,
          10943 => Opcode::VFMSUBADD231PDZ256rkz,
          10944 => Opcode::VFMSUBADD231PDZm,
          10945 => Opcode::VFMSUBADD231PDZmb,
          10946 => Opcode::VFMSUBADD231PDZmbk,
          10947 => Opcode::VFMSUBADD231PDZmbkz,
          10948 => Opcode::VFMSUBADD231PDZmk,
          10949 => Opcode::VFMSUBADD231PDZmkz,
          10950 => Opcode::VFMSUBADD231PDZr,
          10951 => Opcode::VFMSUBADD231PDZrb,
          10952 => Opcode::VFMSUBADD231PDZrbk,
          10953 => Opcode::VFMSUBADD231PDZrbkz,
          10954 => Opcode::VFMSUBADD231PDZrk,
          10955 => Opcode::VFMSUBADD231PDZrkz,
          10956 => Opcode::VFMSUBADD231PDm,
          10957 => Opcode::VFMSUBADD231PDr,
          10958 => Opcode::VFMSUBADD231PHZ128m,
          10959 => Opcode::VFMSUBADD231PHZ128mb,
          10960 => Opcode::VFMSUBADD231PHZ128mbk,
          10961 => Opcode::VFMSUBADD231PHZ128mbkz,
          10962 => Opcode::VFMSUBADD231PHZ128mk,
          10963 => Opcode::VFMSUBADD231PHZ128mkz,
          10964 => Opcode::VFMSUBADD231PHZ128r,
          10965 => Opcode::VFMSUBADD231PHZ128rk,
          10966 => Opcode::VFMSUBADD231PHZ128rkz,
          10967 => Opcode::VFMSUBADD231PHZ256m,
          10968 => Opcode::VFMSUBADD231PHZ256mb,
          10969 => Opcode::VFMSUBADD231PHZ256mbk,
          10970 => Opcode::VFMSUBADD231PHZ256mbkz,
          10971 => Opcode::VFMSUBADD231PHZ256mk,
          10972 => Opcode::VFMSUBADD231PHZ256mkz,
          10973 => Opcode::VFMSUBADD231PHZ256r,
          10974 => Opcode::VFMSUBADD231PHZ256rk,
          10975 => Opcode::VFMSUBADD231PHZ256rkz,
          10976 => Opcode::VFMSUBADD231PHZm,
          10977 => Opcode::VFMSUBADD231PHZmb,
          10978 => Opcode::VFMSUBADD231PHZmbk,
          10979 => Opcode::VFMSUBADD231PHZmbkz,
          10980 => Opcode::VFMSUBADD231PHZmk,
          10981 => Opcode::VFMSUBADD231PHZmkz,
          10982 => Opcode::VFMSUBADD231PHZr,
          10983 => Opcode::VFMSUBADD231PHZrb,
          10984 => Opcode::VFMSUBADD231PHZrbk,
          10985 => Opcode::VFMSUBADD231PHZrbkz,
          10986 => Opcode::VFMSUBADD231PHZrk,
          10987 => Opcode::VFMSUBADD231PHZrkz,
          10988 => Opcode::VFMSUBADD231PSYm,
          10989 => Opcode::VFMSUBADD231PSYr,
          10990 => Opcode::VFMSUBADD231PSZ128m,
          10991 => Opcode::VFMSUBADD231PSZ128mb,
          10992 => Opcode::VFMSUBADD231PSZ128mbk,
          10993 => Opcode::VFMSUBADD231PSZ128mbkz,
          10994 => Opcode::VFMSUBADD231PSZ128mk,
          10995 => Opcode::VFMSUBADD231PSZ128mkz,
          10996 => Opcode::VFMSUBADD231PSZ128r,
          10997 => Opcode::VFMSUBADD231PSZ128rk,
          10998 => Opcode::VFMSUBADD231PSZ128rkz,
          10999 => Opcode::VFMSUBADD231PSZ256m,
          11000 => Opcode::VFMSUBADD231PSZ256mb,
          11001 => Opcode::VFMSUBADD231PSZ256mbk,
          11002 => Opcode::VFMSUBADD231PSZ256mbkz,
          11003 => Opcode::VFMSUBADD231PSZ256mk,
          11004 => Opcode::VFMSUBADD231PSZ256mkz,
          11005 => Opcode::VFMSUBADD231PSZ256r,
          11006 => Opcode::VFMSUBADD231PSZ256rk,
          11007 => Opcode::VFMSUBADD231PSZ256rkz,
          11008 => Opcode::VFMSUBADD231PSZm,
          11009 => Opcode::VFMSUBADD231PSZmb,
          11010 => Opcode::VFMSUBADD231PSZmbk,
          11011 => Opcode::VFMSUBADD231PSZmbkz,
          11012 => Opcode::VFMSUBADD231PSZmk,
          11013 => Opcode::VFMSUBADD231PSZmkz,
          11014 => Opcode::VFMSUBADD231PSZr,
          11015 => Opcode::VFMSUBADD231PSZrb,
          11016 => Opcode::VFMSUBADD231PSZrbk,
          11017 => Opcode::VFMSUBADD231PSZrbkz,
          11018 => Opcode::VFMSUBADD231PSZrk,
          11019 => Opcode::VFMSUBADD231PSZrkz,
          11020 => Opcode::VFMSUBADD231PSm,
          11021 => Opcode::VFMSUBADD231PSr,
          11022 => Opcode::VFMSUBADDPD4Ymr,
          11023 => Opcode::VFMSUBADDPD4Yrm,
          11024 => Opcode::VFMSUBADDPD4Yrr,
          11025 => Opcode::VFMSUBADDPD4Yrr_REV,
          11026 => Opcode::VFMSUBADDPD4mr,
          11027 => Opcode::VFMSUBADDPD4rm,
          11028 => Opcode::VFMSUBADDPD4rr,
          11029 => Opcode::VFMSUBADDPD4rr_REV,
          11030 => Opcode::VFMSUBADDPS4Ymr,
          11031 => Opcode::VFMSUBADDPS4Yrm,
          11032 => Opcode::VFMSUBADDPS4Yrr,
          11033 => Opcode::VFMSUBADDPS4Yrr_REV,
          11034 => Opcode::VFMSUBADDPS4mr,
          11035 => Opcode::VFMSUBADDPS4rm,
          11036 => Opcode::VFMSUBADDPS4rr,
          11037 => Opcode::VFMSUBADDPS4rr_REV,
          11038 => Opcode::VFMSUBPD4Ymr,
          11039 => Opcode::VFMSUBPD4Yrm,
          11040 => Opcode::VFMSUBPD4Yrr,
          11041 => Opcode::VFMSUBPD4Yrr_REV,
          11042 => Opcode::VFMSUBPD4mr,
          11043 => Opcode::VFMSUBPD4rm,
          11044 => Opcode::VFMSUBPD4rr,
          11045 => Opcode::VFMSUBPD4rr_REV,
          11046 => Opcode::VFMSUBPS4Ymr,
          11047 => Opcode::VFMSUBPS4Yrm,
          11048 => Opcode::VFMSUBPS4Yrr,
          11049 => Opcode::VFMSUBPS4Yrr_REV,
          11050 => Opcode::VFMSUBPS4mr,
          11051 => Opcode::VFMSUBPS4rm,
          11052 => Opcode::VFMSUBPS4rr,
          11053 => Opcode::VFMSUBPS4rr_REV,
          11054 => Opcode::VFMSUBSD4mr,
          11055 => Opcode::VFMSUBSD4mr_Int,
          11056 => Opcode::VFMSUBSD4rm,
          11057 => Opcode::VFMSUBSD4rm_Int,
          11058 => Opcode::VFMSUBSD4rr,
          11059 => Opcode::VFMSUBSD4rr_Int,
          11060 => Opcode::VFMSUBSD4rr_Int_REV,
          11061 => Opcode::VFMSUBSD4rr_REV,
          11062 => Opcode::VFMSUBSS4mr,
          11063 => Opcode::VFMSUBSS4mr_Int,
          11064 => Opcode::VFMSUBSS4rm,
          11065 => Opcode::VFMSUBSS4rm_Int,
          11066 => Opcode::VFMSUBSS4rr,
          11067 => Opcode::VFMSUBSS4rr_Int,
          11068 => Opcode::VFMSUBSS4rr_Int_REV,
          11069 => Opcode::VFMSUBSS4rr_REV,
          11070 => Opcode::VFMULCPHZ128rm,
          11071 => Opcode::VFMULCPHZ128rmb,
          11072 => Opcode::VFMULCPHZ128rmbk,
          11073 => Opcode::VFMULCPHZ128rmbkz,
          11074 => Opcode::VFMULCPHZ128rmk,
          11075 => Opcode::VFMULCPHZ128rmkz,
          11076 => Opcode::VFMULCPHZ128rr,
          11077 => Opcode::VFMULCPHZ128rrk,
          11078 => Opcode::VFMULCPHZ128rrkz,
          11079 => Opcode::VFMULCPHZ256rm,
          11080 => Opcode::VFMULCPHZ256rmb,
          11081 => Opcode::VFMULCPHZ256rmbk,
          11082 => Opcode::VFMULCPHZ256rmbkz,
          11083 => Opcode::VFMULCPHZ256rmk,
          11084 => Opcode::VFMULCPHZ256rmkz,
          11085 => Opcode::VFMULCPHZ256rr,
          11086 => Opcode::VFMULCPHZ256rrk,
          11087 => Opcode::VFMULCPHZ256rrkz,
          11088 => Opcode::VFMULCPHZrm,
          11089 => Opcode::VFMULCPHZrmb,
          11090 => Opcode::VFMULCPHZrmbk,
          11091 => Opcode::VFMULCPHZrmbkz,
          11092 => Opcode::VFMULCPHZrmk,
          11093 => Opcode::VFMULCPHZrmkz,
          11094 => Opcode::VFMULCPHZrr,
          11095 => Opcode::VFMULCPHZrrb,
          11096 => Opcode::VFMULCPHZrrbk,
          11097 => Opcode::VFMULCPHZrrbkz,
          11098 => Opcode::VFMULCPHZrrk,
          11099 => Opcode::VFMULCPHZrrkz,
          11100 => Opcode::VFMULCSHZrm,
          11101 => Opcode::VFMULCSHZrmk,
          11102 => Opcode::VFMULCSHZrmkz,
          11103 => Opcode::VFMULCSHZrr,
          11104 => Opcode::VFMULCSHZrrb,
          11105 => Opcode::VFMULCSHZrrbk,
          11106 => Opcode::VFMULCSHZrrbkz,
          11107 => Opcode::VFMULCSHZrrk,
          11108 => Opcode::VFMULCSHZrrkz,
          11109 => Opcode::VFNMADD132BF16Z128m,
          11110 => Opcode::VFNMADD132BF16Z128mb,
          11111 => Opcode::VFNMADD132BF16Z128mbk,
          11112 => Opcode::VFNMADD132BF16Z128mbkz,
          11113 => Opcode::VFNMADD132BF16Z128mk,
          11114 => Opcode::VFNMADD132BF16Z128mkz,
          11115 => Opcode::VFNMADD132BF16Z128r,
          11116 => Opcode::VFNMADD132BF16Z128rk,
          11117 => Opcode::VFNMADD132BF16Z128rkz,
          11118 => Opcode::VFNMADD132BF16Z256m,
          11119 => Opcode::VFNMADD132BF16Z256mb,
          11120 => Opcode::VFNMADD132BF16Z256mbk,
          11121 => Opcode::VFNMADD132BF16Z256mbkz,
          11122 => Opcode::VFNMADD132BF16Z256mk,
          11123 => Opcode::VFNMADD132BF16Z256mkz,
          11124 => Opcode::VFNMADD132BF16Z256r,
          11125 => Opcode::VFNMADD132BF16Z256rk,
          11126 => Opcode::VFNMADD132BF16Z256rkz,
          11127 => Opcode::VFNMADD132BF16Zm,
          11128 => Opcode::VFNMADD132BF16Zmb,
          11129 => Opcode::VFNMADD132BF16Zmbk,
          11130 => Opcode::VFNMADD132BF16Zmbkz,
          11131 => Opcode::VFNMADD132BF16Zmk,
          11132 => Opcode::VFNMADD132BF16Zmkz,
          11133 => Opcode::VFNMADD132BF16Zr,
          11134 => Opcode::VFNMADD132BF16Zrk,
          11135 => Opcode::VFNMADD132BF16Zrkz,
          11136 => Opcode::VFNMADD132PDYm,
          11137 => Opcode::VFNMADD132PDYr,
          11138 => Opcode::VFNMADD132PDZ128m,
          11139 => Opcode::VFNMADD132PDZ128mb,
          11140 => Opcode::VFNMADD132PDZ128mbk,
          11141 => Opcode::VFNMADD132PDZ128mbkz,
          11142 => Opcode::VFNMADD132PDZ128mk,
          11143 => Opcode::VFNMADD132PDZ128mkz,
          11144 => Opcode::VFNMADD132PDZ128r,
          11145 => Opcode::VFNMADD132PDZ128rk,
          11146 => Opcode::VFNMADD132PDZ128rkz,
          11147 => Opcode::VFNMADD132PDZ256m,
          11148 => Opcode::VFNMADD132PDZ256mb,
          11149 => Opcode::VFNMADD132PDZ256mbk,
          11150 => Opcode::VFNMADD132PDZ256mbkz,
          11151 => Opcode::VFNMADD132PDZ256mk,
          11152 => Opcode::VFNMADD132PDZ256mkz,
          11153 => Opcode::VFNMADD132PDZ256r,
          11154 => Opcode::VFNMADD132PDZ256rk,
          11155 => Opcode::VFNMADD132PDZ256rkz,
          11156 => Opcode::VFNMADD132PDZm,
          11157 => Opcode::VFNMADD132PDZmb,
          11158 => Opcode::VFNMADD132PDZmbk,
          11159 => Opcode::VFNMADD132PDZmbkz,
          11160 => Opcode::VFNMADD132PDZmk,
          11161 => Opcode::VFNMADD132PDZmkz,
          11162 => Opcode::VFNMADD132PDZr,
          11163 => Opcode::VFNMADD132PDZrb,
          11164 => Opcode::VFNMADD132PDZrbk,
          11165 => Opcode::VFNMADD132PDZrbkz,
          11166 => Opcode::VFNMADD132PDZrk,
          11167 => Opcode::VFNMADD132PDZrkz,
          11168 => Opcode::VFNMADD132PDm,
          11169 => Opcode::VFNMADD132PDr,
          11170 => Opcode::VFNMADD132PHZ128m,
          11171 => Opcode::VFNMADD132PHZ128mb,
          11172 => Opcode::VFNMADD132PHZ128mbk,
          11173 => Opcode::VFNMADD132PHZ128mbkz,
          11174 => Opcode::VFNMADD132PHZ128mk,
          11175 => Opcode::VFNMADD132PHZ128mkz,
          11176 => Opcode::VFNMADD132PHZ128r,
          11177 => Opcode::VFNMADD132PHZ128rk,
          11178 => Opcode::VFNMADD132PHZ128rkz,
          11179 => Opcode::VFNMADD132PHZ256m,
          11180 => Opcode::VFNMADD132PHZ256mb,
          11181 => Opcode::VFNMADD132PHZ256mbk,
          11182 => Opcode::VFNMADD132PHZ256mbkz,
          11183 => Opcode::VFNMADD132PHZ256mk,
          11184 => Opcode::VFNMADD132PHZ256mkz,
          11185 => Opcode::VFNMADD132PHZ256r,
          11186 => Opcode::VFNMADD132PHZ256rk,
          11187 => Opcode::VFNMADD132PHZ256rkz,
          11188 => Opcode::VFNMADD132PHZm,
          11189 => Opcode::VFNMADD132PHZmb,
          11190 => Opcode::VFNMADD132PHZmbk,
          11191 => Opcode::VFNMADD132PHZmbkz,
          11192 => Opcode::VFNMADD132PHZmk,
          11193 => Opcode::VFNMADD132PHZmkz,
          11194 => Opcode::VFNMADD132PHZr,
          11195 => Opcode::VFNMADD132PHZrb,
          11196 => Opcode::VFNMADD132PHZrbk,
          11197 => Opcode::VFNMADD132PHZrbkz,
          11198 => Opcode::VFNMADD132PHZrk,
          11199 => Opcode::VFNMADD132PHZrkz,
          11200 => Opcode::VFNMADD132PSYm,
          11201 => Opcode::VFNMADD132PSYr,
          11202 => Opcode::VFNMADD132PSZ128m,
          11203 => Opcode::VFNMADD132PSZ128mb,
          11204 => Opcode::VFNMADD132PSZ128mbk,
          11205 => Opcode::VFNMADD132PSZ128mbkz,
          11206 => Opcode::VFNMADD132PSZ128mk,
          11207 => Opcode::VFNMADD132PSZ128mkz,
          11208 => Opcode::VFNMADD132PSZ128r,
          11209 => Opcode::VFNMADD132PSZ128rk,
          11210 => Opcode::VFNMADD132PSZ128rkz,
          11211 => Opcode::VFNMADD132PSZ256m,
          11212 => Opcode::VFNMADD132PSZ256mb,
          11213 => Opcode::VFNMADD132PSZ256mbk,
          11214 => Opcode::VFNMADD132PSZ256mbkz,
          11215 => Opcode::VFNMADD132PSZ256mk,
          11216 => Opcode::VFNMADD132PSZ256mkz,
          11217 => Opcode::VFNMADD132PSZ256r,
          11218 => Opcode::VFNMADD132PSZ256rk,
          11219 => Opcode::VFNMADD132PSZ256rkz,
          11220 => Opcode::VFNMADD132PSZm,
          11221 => Opcode::VFNMADD132PSZmb,
          11222 => Opcode::VFNMADD132PSZmbk,
          11223 => Opcode::VFNMADD132PSZmbkz,
          11224 => Opcode::VFNMADD132PSZmk,
          11225 => Opcode::VFNMADD132PSZmkz,
          11226 => Opcode::VFNMADD132PSZr,
          11227 => Opcode::VFNMADD132PSZrb,
          11228 => Opcode::VFNMADD132PSZrbk,
          11229 => Opcode::VFNMADD132PSZrbkz,
          11230 => Opcode::VFNMADD132PSZrk,
          11231 => Opcode::VFNMADD132PSZrkz,
          11232 => Opcode::VFNMADD132PSm,
          11233 => Opcode::VFNMADD132PSr,
          11234 => Opcode::VFNMADD132SDZm,
          11235 => Opcode::VFNMADD132SDZm_Int,
          11236 => Opcode::VFNMADD132SDZmk_Int,
          11237 => Opcode::VFNMADD132SDZmkz_Int,
          11238 => Opcode::VFNMADD132SDZr,
          11239 => Opcode::VFNMADD132SDZr_Int,
          11240 => Opcode::VFNMADD132SDZrb,
          11241 => Opcode::VFNMADD132SDZrb_Int,
          11242 => Opcode::VFNMADD132SDZrbk_Int,
          11243 => Opcode::VFNMADD132SDZrbkz_Int,
          11244 => Opcode::VFNMADD132SDZrk_Int,
          11245 => Opcode::VFNMADD132SDZrkz_Int,
          11246 => Opcode::VFNMADD132SDm,
          11247 => Opcode::VFNMADD132SDm_Int,
          11248 => Opcode::VFNMADD132SDr,
          11249 => Opcode::VFNMADD132SDr_Int,
          11250 => Opcode::VFNMADD132SHZm,
          11251 => Opcode::VFNMADD132SHZm_Int,
          11252 => Opcode::VFNMADD132SHZmk_Int,
          11253 => Opcode::VFNMADD132SHZmkz_Int,
          11254 => Opcode::VFNMADD132SHZr,
          11255 => Opcode::VFNMADD132SHZr_Int,
          11256 => Opcode::VFNMADD132SHZrb,
          11257 => Opcode::VFNMADD132SHZrb_Int,
          11258 => Opcode::VFNMADD132SHZrbk_Int,
          11259 => Opcode::VFNMADD132SHZrbkz_Int,
          11260 => Opcode::VFNMADD132SHZrk_Int,
          11261 => Opcode::VFNMADD132SHZrkz_Int,
          11262 => Opcode::VFNMADD132SSZm,
          11263 => Opcode::VFNMADD132SSZm_Int,
          11264 => Opcode::VFNMADD132SSZmk_Int,
          11265 => Opcode::VFNMADD132SSZmkz_Int,
          11266 => Opcode::VFNMADD132SSZr,
          11267 => Opcode::VFNMADD132SSZr_Int,
          11268 => Opcode::VFNMADD132SSZrb,
          11269 => Opcode::VFNMADD132SSZrb_Int,
          11270 => Opcode::VFNMADD132SSZrbk_Int,
          11271 => Opcode::VFNMADD132SSZrbkz_Int,
          11272 => Opcode::VFNMADD132SSZrk_Int,
          11273 => Opcode::VFNMADD132SSZrkz_Int,
          11274 => Opcode::VFNMADD132SSm,
          11275 => Opcode::VFNMADD132SSm_Int,
          11276 => Opcode::VFNMADD132SSr,
          11277 => Opcode::VFNMADD132SSr_Int,
          11278 => Opcode::VFNMADD213BF16Z128m,
          11279 => Opcode::VFNMADD213BF16Z128mb,
          11280 => Opcode::VFNMADD213BF16Z128mbk,
          11281 => Opcode::VFNMADD213BF16Z128mbkz,
          11282 => Opcode::VFNMADD213BF16Z128mk,
          11283 => Opcode::VFNMADD213BF16Z128mkz,
          11284 => Opcode::VFNMADD213BF16Z128r,
          11285 => Opcode::VFNMADD213BF16Z128rk,
          11286 => Opcode::VFNMADD213BF16Z128rkz,
          11287 => Opcode::VFNMADD213BF16Z256m,
          11288 => Opcode::VFNMADD213BF16Z256mb,
          11289 => Opcode::VFNMADD213BF16Z256mbk,
          11290 => Opcode::VFNMADD213BF16Z256mbkz,
          11291 => Opcode::VFNMADD213BF16Z256mk,
          11292 => Opcode::VFNMADD213BF16Z256mkz,
          11293 => Opcode::VFNMADD213BF16Z256r,
          11294 => Opcode::VFNMADD213BF16Z256rk,
          11295 => Opcode::VFNMADD213BF16Z256rkz,
          11296 => Opcode::VFNMADD213BF16Zm,
          11297 => Opcode::VFNMADD213BF16Zmb,
          11298 => Opcode::VFNMADD213BF16Zmbk,
          11299 => Opcode::VFNMADD213BF16Zmbkz,
          11300 => Opcode::VFNMADD213BF16Zmk,
          11301 => Opcode::VFNMADD213BF16Zmkz,
          11302 => Opcode::VFNMADD213BF16Zr,
          11303 => Opcode::VFNMADD213BF16Zrk,
          11304 => Opcode::VFNMADD213BF16Zrkz,
          11305 => Opcode::VFNMADD213PDYm,
          11306 => Opcode::VFNMADD213PDYr,
          11307 => Opcode::VFNMADD213PDZ128m,
          11308 => Opcode::VFNMADD213PDZ128mb,
          11309 => Opcode::VFNMADD213PDZ128mbk,
          11310 => Opcode::VFNMADD213PDZ128mbkz,
          11311 => Opcode::VFNMADD213PDZ128mk,
          11312 => Opcode::VFNMADD213PDZ128mkz,
          11313 => Opcode::VFNMADD213PDZ128r,
          11314 => Opcode::VFNMADD213PDZ128rk,
          11315 => Opcode::VFNMADD213PDZ128rkz,
          11316 => Opcode::VFNMADD213PDZ256m,
          11317 => Opcode::VFNMADD213PDZ256mb,
          11318 => Opcode::VFNMADD213PDZ256mbk,
          11319 => Opcode::VFNMADD213PDZ256mbkz,
          11320 => Opcode::VFNMADD213PDZ256mk,
          11321 => Opcode::VFNMADD213PDZ256mkz,
          11322 => Opcode::VFNMADD213PDZ256r,
          11323 => Opcode::VFNMADD213PDZ256rk,
          11324 => Opcode::VFNMADD213PDZ256rkz,
          11325 => Opcode::VFNMADD213PDZm,
          11326 => Opcode::VFNMADD213PDZmb,
          11327 => Opcode::VFNMADD213PDZmbk,
          11328 => Opcode::VFNMADD213PDZmbkz,
          11329 => Opcode::VFNMADD213PDZmk,
          11330 => Opcode::VFNMADD213PDZmkz,
          11331 => Opcode::VFNMADD213PDZr,
          11332 => Opcode::VFNMADD213PDZrb,
          11333 => Opcode::VFNMADD213PDZrbk,
          11334 => Opcode::VFNMADD213PDZrbkz,
          11335 => Opcode::VFNMADD213PDZrk,
          11336 => Opcode::VFNMADD213PDZrkz,
          11337 => Opcode::VFNMADD213PDm,
          11338 => Opcode::VFNMADD213PDr,
          11339 => Opcode::VFNMADD213PHZ128m,
          11340 => Opcode::VFNMADD213PHZ128mb,
          11341 => Opcode::VFNMADD213PHZ128mbk,
          11342 => Opcode::VFNMADD213PHZ128mbkz,
          11343 => Opcode::VFNMADD213PHZ128mk,
          11344 => Opcode::VFNMADD213PHZ128mkz,
          11345 => Opcode::VFNMADD213PHZ128r,
          11346 => Opcode::VFNMADD213PHZ128rk,
          11347 => Opcode::VFNMADD213PHZ128rkz,
          11348 => Opcode::VFNMADD213PHZ256m,
          11349 => Opcode::VFNMADD213PHZ256mb,
          11350 => Opcode::VFNMADD213PHZ256mbk,
          11351 => Opcode::VFNMADD213PHZ256mbkz,
          11352 => Opcode::VFNMADD213PHZ256mk,
          11353 => Opcode::VFNMADD213PHZ256mkz,
          11354 => Opcode::VFNMADD213PHZ256r,
          11355 => Opcode::VFNMADD213PHZ256rk,
          11356 => Opcode::VFNMADD213PHZ256rkz,
          11357 => Opcode::VFNMADD213PHZm,
          11358 => Opcode::VFNMADD213PHZmb,
          11359 => Opcode::VFNMADD213PHZmbk,
          11360 => Opcode::VFNMADD213PHZmbkz,
          11361 => Opcode::VFNMADD213PHZmk,
          11362 => Opcode::VFNMADD213PHZmkz,
          11363 => Opcode::VFNMADD213PHZr,
          11364 => Opcode::VFNMADD213PHZrb,
          11365 => Opcode::VFNMADD213PHZrbk,
          11366 => Opcode::VFNMADD213PHZrbkz,
          11367 => Opcode::VFNMADD213PHZrk,
          11368 => Opcode::VFNMADD213PHZrkz,
          11369 => Opcode::VFNMADD213PSYm,
          11370 => Opcode::VFNMADD213PSYr,
          11371 => Opcode::VFNMADD213PSZ128m,
          11372 => Opcode::VFNMADD213PSZ128mb,
          11373 => Opcode::VFNMADD213PSZ128mbk,
          11374 => Opcode::VFNMADD213PSZ128mbkz,
          11375 => Opcode::VFNMADD213PSZ128mk,
          11376 => Opcode::VFNMADD213PSZ128mkz,
          11377 => Opcode::VFNMADD213PSZ128r,
          11378 => Opcode::VFNMADD213PSZ128rk,
          11379 => Opcode::VFNMADD213PSZ128rkz,
          11380 => Opcode::VFNMADD213PSZ256m,
          11381 => Opcode::VFNMADD213PSZ256mb,
          11382 => Opcode::VFNMADD213PSZ256mbk,
          11383 => Opcode::VFNMADD213PSZ256mbkz,
          11384 => Opcode::VFNMADD213PSZ256mk,
          11385 => Opcode::VFNMADD213PSZ256mkz,
          11386 => Opcode::VFNMADD213PSZ256r,
          11387 => Opcode::VFNMADD213PSZ256rk,
          11388 => Opcode::VFNMADD213PSZ256rkz,
          11389 => Opcode::VFNMADD213PSZm,
          11390 => Opcode::VFNMADD213PSZmb,
          11391 => Opcode::VFNMADD213PSZmbk,
          11392 => Opcode::VFNMADD213PSZmbkz,
          11393 => Opcode::VFNMADD213PSZmk,
          11394 => Opcode::VFNMADD213PSZmkz,
          11395 => Opcode::VFNMADD213PSZr,
          11396 => Opcode::VFNMADD213PSZrb,
          11397 => Opcode::VFNMADD213PSZrbk,
          11398 => Opcode::VFNMADD213PSZrbkz,
          11399 => Opcode::VFNMADD213PSZrk,
          11400 => Opcode::VFNMADD213PSZrkz,
          11401 => Opcode::VFNMADD213PSm,
          11402 => Opcode::VFNMADD213PSr,
          11403 => Opcode::VFNMADD213SDZm,
          11404 => Opcode::VFNMADD213SDZm_Int,
          11405 => Opcode::VFNMADD213SDZmk_Int,
          11406 => Opcode::VFNMADD213SDZmkz_Int,
          11407 => Opcode::VFNMADD213SDZr,
          11408 => Opcode::VFNMADD213SDZr_Int,
          11409 => Opcode::VFNMADD213SDZrb,
          11410 => Opcode::VFNMADD213SDZrb_Int,
          11411 => Opcode::VFNMADD213SDZrbk_Int,
          11412 => Opcode::VFNMADD213SDZrbkz_Int,
          11413 => Opcode::VFNMADD213SDZrk_Int,
          11414 => Opcode::VFNMADD213SDZrkz_Int,
          11415 => Opcode::VFNMADD213SDm,
          11416 => Opcode::VFNMADD213SDm_Int,
          11417 => Opcode::VFNMADD213SDr,
          11418 => Opcode::VFNMADD213SDr_Int,
          11419 => Opcode::VFNMADD213SHZm,
          11420 => Opcode::VFNMADD213SHZm_Int,
          11421 => Opcode::VFNMADD213SHZmk_Int,
          11422 => Opcode::VFNMADD213SHZmkz_Int,
          11423 => Opcode::VFNMADD213SHZr,
          11424 => Opcode::VFNMADD213SHZr_Int,
          11425 => Opcode::VFNMADD213SHZrb,
          11426 => Opcode::VFNMADD213SHZrb_Int,
          11427 => Opcode::VFNMADD213SHZrbk_Int,
          11428 => Opcode::VFNMADD213SHZrbkz_Int,
          11429 => Opcode::VFNMADD213SHZrk_Int,
          11430 => Opcode::VFNMADD213SHZrkz_Int,
          11431 => Opcode::VFNMADD213SSZm,
          11432 => Opcode::VFNMADD213SSZm_Int,
          11433 => Opcode::VFNMADD213SSZmk_Int,
          11434 => Opcode::VFNMADD213SSZmkz_Int,
          11435 => Opcode::VFNMADD213SSZr,
          11436 => Opcode::VFNMADD213SSZr_Int,
          11437 => Opcode::VFNMADD213SSZrb,
          11438 => Opcode::VFNMADD213SSZrb_Int,
          11439 => Opcode::VFNMADD213SSZrbk_Int,
          11440 => Opcode::VFNMADD213SSZrbkz_Int,
          11441 => Opcode::VFNMADD213SSZrk_Int,
          11442 => Opcode::VFNMADD213SSZrkz_Int,
          11443 => Opcode::VFNMADD213SSm,
          11444 => Opcode::VFNMADD213SSm_Int,
          11445 => Opcode::VFNMADD213SSr,
          11446 => Opcode::VFNMADD213SSr_Int,
          11447 => Opcode::VFNMADD231BF16Z128m,
          11448 => Opcode::VFNMADD231BF16Z128mb,
          11449 => Opcode::VFNMADD231BF16Z128mbk,
          11450 => Opcode::VFNMADD231BF16Z128mbkz,
          11451 => Opcode::VFNMADD231BF16Z128mk,
          11452 => Opcode::VFNMADD231BF16Z128mkz,
          11453 => Opcode::VFNMADD231BF16Z128r,
          11454 => Opcode::VFNMADD231BF16Z128rk,
          11455 => Opcode::VFNMADD231BF16Z128rkz,
          11456 => Opcode::VFNMADD231BF16Z256m,
          11457 => Opcode::VFNMADD231BF16Z256mb,
          11458 => Opcode::VFNMADD231BF16Z256mbk,
          11459 => Opcode::VFNMADD231BF16Z256mbkz,
          11460 => Opcode::VFNMADD231BF16Z256mk,
          11461 => Opcode::VFNMADD231BF16Z256mkz,
          11462 => Opcode::VFNMADD231BF16Z256r,
          11463 => Opcode::VFNMADD231BF16Z256rk,
          11464 => Opcode::VFNMADD231BF16Z256rkz,
          11465 => Opcode::VFNMADD231BF16Zm,
          11466 => Opcode::VFNMADD231BF16Zmb,
          11467 => Opcode::VFNMADD231BF16Zmbk,
          11468 => Opcode::VFNMADD231BF16Zmbkz,
          11469 => Opcode::VFNMADD231BF16Zmk,
          11470 => Opcode::VFNMADD231BF16Zmkz,
          11471 => Opcode::VFNMADD231BF16Zr,
          11472 => Opcode::VFNMADD231BF16Zrk,
          11473 => Opcode::VFNMADD231BF16Zrkz,
          11474 => Opcode::VFNMADD231PDYm,
          11475 => Opcode::VFNMADD231PDYr,
          11476 => Opcode::VFNMADD231PDZ128m,
          11477 => Opcode::VFNMADD231PDZ128mb,
          11478 => Opcode::VFNMADD231PDZ128mbk,
          11479 => Opcode::VFNMADD231PDZ128mbkz,
          11480 => Opcode::VFNMADD231PDZ128mk,
          11481 => Opcode::VFNMADD231PDZ128mkz,
          11482 => Opcode::VFNMADD231PDZ128r,
          11483 => Opcode::VFNMADD231PDZ128rk,
          11484 => Opcode::VFNMADD231PDZ128rkz,
          11485 => Opcode::VFNMADD231PDZ256m,
          11486 => Opcode::VFNMADD231PDZ256mb,
          11487 => Opcode::VFNMADD231PDZ256mbk,
          11488 => Opcode::VFNMADD231PDZ256mbkz,
          11489 => Opcode::VFNMADD231PDZ256mk,
          11490 => Opcode::VFNMADD231PDZ256mkz,
          11491 => Opcode::VFNMADD231PDZ256r,
          11492 => Opcode::VFNMADD231PDZ256rk,
          11493 => Opcode::VFNMADD231PDZ256rkz,
          11494 => Opcode::VFNMADD231PDZm,
          11495 => Opcode::VFNMADD231PDZmb,
          11496 => Opcode::VFNMADD231PDZmbk,
          11497 => Opcode::VFNMADD231PDZmbkz,
          11498 => Opcode::VFNMADD231PDZmk,
          11499 => Opcode::VFNMADD231PDZmkz,
          11500 => Opcode::VFNMADD231PDZr,
          11501 => Opcode::VFNMADD231PDZrb,
          11502 => Opcode::VFNMADD231PDZrbk,
          11503 => Opcode::VFNMADD231PDZrbkz,
          11504 => Opcode::VFNMADD231PDZrk,
          11505 => Opcode::VFNMADD231PDZrkz,
          11506 => Opcode::VFNMADD231PDm,
          11507 => Opcode::VFNMADD231PDr,
          11508 => Opcode::VFNMADD231PHZ128m,
          11509 => Opcode::VFNMADD231PHZ128mb,
          11510 => Opcode::VFNMADD231PHZ128mbk,
          11511 => Opcode::VFNMADD231PHZ128mbkz,
          11512 => Opcode::VFNMADD231PHZ128mk,
          11513 => Opcode::VFNMADD231PHZ128mkz,
          11514 => Opcode::VFNMADD231PHZ128r,
          11515 => Opcode::VFNMADD231PHZ128rk,
          11516 => Opcode::VFNMADD231PHZ128rkz,
          11517 => Opcode::VFNMADD231PHZ256m,
          11518 => Opcode::VFNMADD231PHZ256mb,
          11519 => Opcode::VFNMADD231PHZ256mbk,
          11520 => Opcode::VFNMADD231PHZ256mbkz,
          11521 => Opcode::VFNMADD231PHZ256mk,
          11522 => Opcode::VFNMADD231PHZ256mkz,
          11523 => Opcode::VFNMADD231PHZ256r,
          11524 => Opcode::VFNMADD231PHZ256rk,
          11525 => Opcode::VFNMADD231PHZ256rkz,
          11526 => Opcode::VFNMADD231PHZm,
          11527 => Opcode::VFNMADD231PHZmb,
          11528 => Opcode::VFNMADD231PHZmbk,
          11529 => Opcode::VFNMADD231PHZmbkz,
          11530 => Opcode::VFNMADD231PHZmk,
          11531 => Opcode::VFNMADD231PHZmkz,
          11532 => Opcode::VFNMADD231PHZr,
          11533 => Opcode::VFNMADD231PHZrb,
          11534 => Opcode::VFNMADD231PHZrbk,
          11535 => Opcode::VFNMADD231PHZrbkz,
          11536 => Opcode::VFNMADD231PHZrk,
          11537 => Opcode::VFNMADD231PHZrkz,
          11538 => Opcode::VFNMADD231PSYm,
          11539 => Opcode::VFNMADD231PSYr,
          11540 => Opcode::VFNMADD231PSZ128m,
          11541 => Opcode::VFNMADD231PSZ128mb,
          11542 => Opcode::VFNMADD231PSZ128mbk,
          11543 => Opcode::VFNMADD231PSZ128mbkz,
          11544 => Opcode::VFNMADD231PSZ128mk,
          11545 => Opcode::VFNMADD231PSZ128mkz,
          11546 => Opcode::VFNMADD231PSZ128r,
          11547 => Opcode::VFNMADD231PSZ128rk,
          11548 => Opcode::VFNMADD231PSZ128rkz,
          11549 => Opcode::VFNMADD231PSZ256m,
          11550 => Opcode::VFNMADD231PSZ256mb,
          11551 => Opcode::VFNMADD231PSZ256mbk,
          11552 => Opcode::VFNMADD231PSZ256mbkz,
          11553 => Opcode::VFNMADD231PSZ256mk,
          11554 => Opcode::VFNMADD231PSZ256mkz,
          11555 => Opcode::VFNMADD231PSZ256r,
          11556 => Opcode::VFNMADD231PSZ256rk,
          11557 => Opcode::VFNMADD231PSZ256rkz,
          11558 => Opcode::VFNMADD231PSZm,
          11559 => Opcode::VFNMADD231PSZmb,
          11560 => Opcode::VFNMADD231PSZmbk,
          11561 => Opcode::VFNMADD231PSZmbkz,
          11562 => Opcode::VFNMADD231PSZmk,
          11563 => Opcode::VFNMADD231PSZmkz,
          11564 => Opcode::VFNMADD231PSZr,
          11565 => Opcode::VFNMADD231PSZrb,
          11566 => Opcode::VFNMADD231PSZrbk,
          11567 => Opcode::VFNMADD231PSZrbkz,
          11568 => Opcode::VFNMADD231PSZrk,
          11569 => Opcode::VFNMADD231PSZrkz,
          11570 => Opcode::VFNMADD231PSm,
          11571 => Opcode::VFNMADD231PSr,
          11572 => Opcode::VFNMADD231SDZm,
          11573 => Opcode::VFNMADD231SDZm_Int,
          11574 => Opcode::VFNMADD231SDZmk_Int,
          11575 => Opcode::VFNMADD231SDZmkz_Int,
          11576 => Opcode::VFNMADD231SDZr,
          11577 => Opcode::VFNMADD231SDZr_Int,
          11578 => Opcode::VFNMADD231SDZrb,
          11579 => Opcode::VFNMADD231SDZrb_Int,
          11580 => Opcode::VFNMADD231SDZrbk_Int,
          11581 => Opcode::VFNMADD231SDZrbkz_Int,
          11582 => Opcode::VFNMADD231SDZrk_Int,
          11583 => Opcode::VFNMADD231SDZrkz_Int,
          11584 => Opcode::VFNMADD231SDm,
          11585 => Opcode::VFNMADD231SDm_Int,
          11586 => Opcode::VFNMADD231SDr,
          11587 => Opcode::VFNMADD231SDr_Int,
          11588 => Opcode::VFNMADD231SHZm,
          11589 => Opcode::VFNMADD231SHZm_Int,
          11590 => Opcode::VFNMADD231SHZmk_Int,
          11591 => Opcode::VFNMADD231SHZmkz_Int,
          11592 => Opcode::VFNMADD231SHZr,
          11593 => Opcode::VFNMADD231SHZr_Int,
          11594 => Opcode::VFNMADD231SHZrb,
          11595 => Opcode::VFNMADD231SHZrb_Int,
          11596 => Opcode::VFNMADD231SHZrbk_Int,
          11597 => Opcode::VFNMADD231SHZrbkz_Int,
          11598 => Opcode::VFNMADD231SHZrk_Int,
          11599 => Opcode::VFNMADD231SHZrkz_Int,
          11600 => Opcode::VFNMADD231SSZm,
          11601 => Opcode::VFNMADD231SSZm_Int,
          11602 => Opcode::VFNMADD231SSZmk_Int,
          11603 => Opcode::VFNMADD231SSZmkz_Int,
          11604 => Opcode::VFNMADD231SSZr,
          11605 => Opcode::VFNMADD231SSZr_Int,
          11606 => Opcode::VFNMADD231SSZrb,
          11607 => Opcode::VFNMADD231SSZrb_Int,
          11608 => Opcode::VFNMADD231SSZrbk_Int,
          11609 => Opcode::VFNMADD231SSZrbkz_Int,
          11610 => Opcode::VFNMADD231SSZrk_Int,
          11611 => Opcode::VFNMADD231SSZrkz_Int,
          11612 => Opcode::VFNMADD231SSm,
          11613 => Opcode::VFNMADD231SSm_Int,
          11614 => Opcode::VFNMADD231SSr,
          11615 => Opcode::VFNMADD231SSr_Int,
          11616 => Opcode::VFNMADDPD4Ymr,
          11617 => Opcode::VFNMADDPD4Yrm,
          11618 => Opcode::VFNMADDPD4Yrr,
          11619 => Opcode::VFNMADDPD4Yrr_REV,
          11620 => Opcode::VFNMADDPD4mr,
          11621 => Opcode::VFNMADDPD4rm,
          11622 => Opcode::VFNMADDPD4rr,
          11623 => Opcode::VFNMADDPD4rr_REV,
          11624 => Opcode::VFNMADDPS4Ymr,
          11625 => Opcode::VFNMADDPS4Yrm,
          11626 => Opcode::VFNMADDPS4Yrr,
          11627 => Opcode::VFNMADDPS4Yrr_REV,
          11628 => Opcode::VFNMADDPS4mr,
          11629 => Opcode::VFNMADDPS4rm,
          11630 => Opcode::VFNMADDPS4rr,
          11631 => Opcode::VFNMADDPS4rr_REV,
          11632 => Opcode::VFNMADDSD4mr,
          11633 => Opcode::VFNMADDSD4mr_Int,
          11634 => Opcode::VFNMADDSD4rm,
          11635 => Opcode::VFNMADDSD4rm_Int,
          11636 => Opcode::VFNMADDSD4rr,
          11637 => Opcode::VFNMADDSD4rr_Int,
          11638 => Opcode::VFNMADDSD4rr_Int_REV,
          11639 => Opcode::VFNMADDSD4rr_REV,
          11640 => Opcode::VFNMADDSS4mr,
          11641 => Opcode::VFNMADDSS4mr_Int,
          11642 => Opcode::VFNMADDSS4rm,
          11643 => Opcode::VFNMADDSS4rm_Int,
          11644 => Opcode::VFNMADDSS4rr,
          11645 => Opcode::VFNMADDSS4rr_Int,
          11646 => Opcode::VFNMADDSS4rr_Int_REV,
          11647 => Opcode::VFNMADDSS4rr_REV,
          11648 => Opcode::VFNMSUB132BF16Z128m,
          11649 => Opcode::VFNMSUB132BF16Z128mb,
          11650 => Opcode::VFNMSUB132BF16Z128mbk,
          11651 => Opcode::VFNMSUB132BF16Z128mbkz,
          11652 => Opcode::VFNMSUB132BF16Z128mk,
          11653 => Opcode::VFNMSUB132BF16Z128mkz,
          11654 => Opcode::VFNMSUB132BF16Z128r,
          11655 => Opcode::VFNMSUB132BF16Z128rk,
          11656 => Opcode::VFNMSUB132BF16Z128rkz,
          11657 => Opcode::VFNMSUB132BF16Z256m,
          11658 => Opcode::VFNMSUB132BF16Z256mb,
          11659 => Opcode::VFNMSUB132BF16Z256mbk,
          11660 => Opcode::VFNMSUB132BF16Z256mbkz,
          11661 => Opcode::VFNMSUB132BF16Z256mk,
          11662 => Opcode::VFNMSUB132BF16Z256mkz,
          11663 => Opcode::VFNMSUB132BF16Z256r,
          11664 => Opcode::VFNMSUB132BF16Z256rk,
          11665 => Opcode::VFNMSUB132BF16Z256rkz,
          11666 => Opcode::VFNMSUB132BF16Zm,
          11667 => Opcode::VFNMSUB132BF16Zmb,
          11668 => Opcode::VFNMSUB132BF16Zmbk,
          11669 => Opcode::VFNMSUB132BF16Zmbkz,
          11670 => Opcode::VFNMSUB132BF16Zmk,
          11671 => Opcode::VFNMSUB132BF16Zmkz,
          11672 => Opcode::VFNMSUB132BF16Zr,
          11673 => Opcode::VFNMSUB132BF16Zrk,
          11674 => Opcode::VFNMSUB132BF16Zrkz,
          11675 => Opcode::VFNMSUB132PDYm,
          11676 => Opcode::VFNMSUB132PDYr,
          11677 => Opcode::VFNMSUB132PDZ128m,
          11678 => Opcode::VFNMSUB132PDZ128mb,
          11679 => Opcode::VFNMSUB132PDZ128mbk,
          11680 => Opcode::VFNMSUB132PDZ128mbkz,
          11681 => Opcode::VFNMSUB132PDZ128mk,
          11682 => Opcode::VFNMSUB132PDZ128mkz,
          11683 => Opcode::VFNMSUB132PDZ128r,
          11684 => Opcode::VFNMSUB132PDZ128rk,
          11685 => Opcode::VFNMSUB132PDZ128rkz,
          11686 => Opcode::VFNMSUB132PDZ256m,
          11687 => Opcode::VFNMSUB132PDZ256mb,
          11688 => Opcode::VFNMSUB132PDZ256mbk,
          11689 => Opcode::VFNMSUB132PDZ256mbkz,
          11690 => Opcode::VFNMSUB132PDZ256mk,
          11691 => Opcode::VFNMSUB132PDZ256mkz,
          11692 => Opcode::VFNMSUB132PDZ256r,
          11693 => Opcode::VFNMSUB132PDZ256rk,
          11694 => Opcode::VFNMSUB132PDZ256rkz,
          11695 => Opcode::VFNMSUB132PDZm,
          11696 => Opcode::VFNMSUB132PDZmb,
          11697 => Opcode::VFNMSUB132PDZmbk,
          11698 => Opcode::VFNMSUB132PDZmbkz,
          11699 => Opcode::VFNMSUB132PDZmk,
          11700 => Opcode::VFNMSUB132PDZmkz,
          11701 => Opcode::VFNMSUB132PDZr,
          11702 => Opcode::VFNMSUB132PDZrb,
          11703 => Opcode::VFNMSUB132PDZrbk,
          11704 => Opcode::VFNMSUB132PDZrbkz,
          11705 => Opcode::VFNMSUB132PDZrk,
          11706 => Opcode::VFNMSUB132PDZrkz,
          11707 => Opcode::VFNMSUB132PDm,
          11708 => Opcode::VFNMSUB132PDr,
          11709 => Opcode::VFNMSUB132PHZ128m,
          11710 => Opcode::VFNMSUB132PHZ128mb,
          11711 => Opcode::VFNMSUB132PHZ128mbk,
          11712 => Opcode::VFNMSUB132PHZ128mbkz,
          11713 => Opcode::VFNMSUB132PHZ128mk,
          11714 => Opcode::VFNMSUB132PHZ128mkz,
          11715 => Opcode::VFNMSUB132PHZ128r,
          11716 => Opcode::VFNMSUB132PHZ128rk,
          11717 => Opcode::VFNMSUB132PHZ128rkz,
          11718 => Opcode::VFNMSUB132PHZ256m,
          11719 => Opcode::VFNMSUB132PHZ256mb,
          11720 => Opcode::VFNMSUB132PHZ256mbk,
          11721 => Opcode::VFNMSUB132PHZ256mbkz,
          11722 => Opcode::VFNMSUB132PHZ256mk,
          11723 => Opcode::VFNMSUB132PHZ256mkz,
          11724 => Opcode::VFNMSUB132PHZ256r,
          11725 => Opcode::VFNMSUB132PHZ256rk,
          11726 => Opcode::VFNMSUB132PHZ256rkz,
          11727 => Opcode::VFNMSUB132PHZm,
          11728 => Opcode::VFNMSUB132PHZmb,
          11729 => Opcode::VFNMSUB132PHZmbk,
          11730 => Opcode::VFNMSUB132PHZmbkz,
          11731 => Opcode::VFNMSUB132PHZmk,
          11732 => Opcode::VFNMSUB132PHZmkz,
          11733 => Opcode::VFNMSUB132PHZr,
          11734 => Opcode::VFNMSUB132PHZrb,
          11735 => Opcode::VFNMSUB132PHZrbk,
          11736 => Opcode::VFNMSUB132PHZrbkz,
          11737 => Opcode::VFNMSUB132PHZrk,
          11738 => Opcode::VFNMSUB132PHZrkz,
          11739 => Opcode::VFNMSUB132PSYm,
          11740 => Opcode::VFNMSUB132PSYr,
          11741 => Opcode::VFNMSUB132PSZ128m,
          11742 => Opcode::VFNMSUB132PSZ128mb,
          11743 => Opcode::VFNMSUB132PSZ128mbk,
          11744 => Opcode::VFNMSUB132PSZ128mbkz,
          11745 => Opcode::VFNMSUB132PSZ128mk,
          11746 => Opcode::VFNMSUB132PSZ128mkz,
          11747 => Opcode::VFNMSUB132PSZ128r,
          11748 => Opcode::VFNMSUB132PSZ128rk,
          11749 => Opcode::VFNMSUB132PSZ128rkz,
          11750 => Opcode::VFNMSUB132PSZ256m,
          11751 => Opcode::VFNMSUB132PSZ256mb,
          11752 => Opcode::VFNMSUB132PSZ256mbk,
          11753 => Opcode::VFNMSUB132PSZ256mbkz,
          11754 => Opcode::VFNMSUB132PSZ256mk,
          11755 => Opcode::VFNMSUB132PSZ256mkz,
          11756 => Opcode::VFNMSUB132PSZ256r,
          11757 => Opcode::VFNMSUB132PSZ256rk,
          11758 => Opcode::VFNMSUB132PSZ256rkz,
          11759 => Opcode::VFNMSUB132PSZm,
          11760 => Opcode::VFNMSUB132PSZmb,
          11761 => Opcode::VFNMSUB132PSZmbk,
          11762 => Opcode::VFNMSUB132PSZmbkz,
          11763 => Opcode::VFNMSUB132PSZmk,
          11764 => Opcode::VFNMSUB132PSZmkz,
          11765 => Opcode::VFNMSUB132PSZr,
          11766 => Opcode::VFNMSUB132PSZrb,
          11767 => Opcode::VFNMSUB132PSZrbk,
          11768 => Opcode::VFNMSUB132PSZrbkz,
          11769 => Opcode::VFNMSUB132PSZrk,
          11770 => Opcode::VFNMSUB132PSZrkz,
          11771 => Opcode::VFNMSUB132PSm,
          11772 => Opcode::VFNMSUB132PSr,
          11773 => Opcode::VFNMSUB132SDZm,
          11774 => Opcode::VFNMSUB132SDZm_Int,
          11775 => Opcode::VFNMSUB132SDZmk_Int,
          11776 => Opcode::VFNMSUB132SDZmkz_Int,
          11777 => Opcode::VFNMSUB132SDZr,
          11778 => Opcode::VFNMSUB132SDZr_Int,
          11779 => Opcode::VFNMSUB132SDZrb,
          11780 => Opcode::VFNMSUB132SDZrb_Int,
          11781 => Opcode::VFNMSUB132SDZrbk_Int,
          11782 => Opcode::VFNMSUB132SDZrbkz_Int,
          11783 => Opcode::VFNMSUB132SDZrk_Int,
          11784 => Opcode::VFNMSUB132SDZrkz_Int,
          11785 => Opcode::VFNMSUB132SDm,
          11786 => Opcode::VFNMSUB132SDm_Int,
          11787 => Opcode::VFNMSUB132SDr,
          11788 => Opcode::VFNMSUB132SDr_Int,
          11789 => Opcode::VFNMSUB132SHZm,
          11790 => Opcode::VFNMSUB132SHZm_Int,
          11791 => Opcode::VFNMSUB132SHZmk_Int,
          11792 => Opcode::VFNMSUB132SHZmkz_Int,
          11793 => Opcode::VFNMSUB132SHZr,
          11794 => Opcode::VFNMSUB132SHZr_Int,
          11795 => Opcode::VFNMSUB132SHZrb,
          11796 => Opcode::VFNMSUB132SHZrb_Int,
          11797 => Opcode::VFNMSUB132SHZrbk_Int,
          11798 => Opcode::VFNMSUB132SHZrbkz_Int,
          11799 => Opcode::VFNMSUB132SHZrk_Int,
          11800 => Opcode::VFNMSUB132SHZrkz_Int,
          11801 => Opcode::VFNMSUB132SSZm,
          11802 => Opcode::VFNMSUB132SSZm_Int,
          11803 => Opcode::VFNMSUB132SSZmk_Int,
          11804 => Opcode::VFNMSUB132SSZmkz_Int,
          11805 => Opcode::VFNMSUB132SSZr,
          11806 => Opcode::VFNMSUB132SSZr_Int,
          11807 => Opcode::VFNMSUB132SSZrb,
          11808 => Opcode::VFNMSUB132SSZrb_Int,
          11809 => Opcode::VFNMSUB132SSZrbk_Int,
          11810 => Opcode::VFNMSUB132SSZrbkz_Int,
          11811 => Opcode::VFNMSUB132SSZrk_Int,
          11812 => Opcode::VFNMSUB132SSZrkz_Int,
          11813 => Opcode::VFNMSUB132SSm,
          11814 => Opcode::VFNMSUB132SSm_Int,
          11815 => Opcode::VFNMSUB132SSr,
          11816 => Opcode::VFNMSUB132SSr_Int,
          11817 => Opcode::VFNMSUB213BF16Z128m,
          11818 => Opcode::VFNMSUB213BF16Z128mb,
          11819 => Opcode::VFNMSUB213BF16Z128mbk,
          11820 => Opcode::VFNMSUB213BF16Z128mbkz,
          11821 => Opcode::VFNMSUB213BF16Z128mk,
          11822 => Opcode::VFNMSUB213BF16Z128mkz,
          11823 => Opcode::VFNMSUB213BF16Z128r,
          11824 => Opcode::VFNMSUB213BF16Z128rk,
          11825 => Opcode::VFNMSUB213BF16Z128rkz,
          11826 => Opcode::VFNMSUB213BF16Z256m,
          11827 => Opcode::VFNMSUB213BF16Z256mb,
          11828 => Opcode::VFNMSUB213BF16Z256mbk,
          11829 => Opcode::VFNMSUB213BF16Z256mbkz,
          11830 => Opcode::VFNMSUB213BF16Z256mk,
          11831 => Opcode::VFNMSUB213BF16Z256mkz,
          11832 => Opcode::VFNMSUB213BF16Z256r,
          11833 => Opcode::VFNMSUB213BF16Z256rk,
          11834 => Opcode::VFNMSUB213BF16Z256rkz,
          11835 => Opcode::VFNMSUB213BF16Zm,
          11836 => Opcode::VFNMSUB213BF16Zmb,
          11837 => Opcode::VFNMSUB213BF16Zmbk,
          11838 => Opcode::VFNMSUB213BF16Zmbkz,
          11839 => Opcode::VFNMSUB213BF16Zmk,
          11840 => Opcode::VFNMSUB213BF16Zmkz,
          11841 => Opcode::VFNMSUB213BF16Zr,
          11842 => Opcode::VFNMSUB213BF16Zrk,
          11843 => Opcode::VFNMSUB213BF16Zrkz,
          11844 => Opcode::VFNMSUB213PDYm,
          11845 => Opcode::VFNMSUB213PDYr,
          11846 => Opcode::VFNMSUB213PDZ128m,
          11847 => Opcode::VFNMSUB213PDZ128mb,
          11848 => Opcode::VFNMSUB213PDZ128mbk,
          11849 => Opcode::VFNMSUB213PDZ128mbkz,
          11850 => Opcode::VFNMSUB213PDZ128mk,
          11851 => Opcode::VFNMSUB213PDZ128mkz,
          11852 => Opcode::VFNMSUB213PDZ128r,
          11853 => Opcode::VFNMSUB213PDZ128rk,
          11854 => Opcode::VFNMSUB213PDZ128rkz,
          11855 => Opcode::VFNMSUB213PDZ256m,
          11856 => Opcode::VFNMSUB213PDZ256mb,
          11857 => Opcode::VFNMSUB213PDZ256mbk,
          11858 => Opcode::VFNMSUB213PDZ256mbkz,
          11859 => Opcode::VFNMSUB213PDZ256mk,
          11860 => Opcode::VFNMSUB213PDZ256mkz,
          11861 => Opcode::VFNMSUB213PDZ256r,
          11862 => Opcode::VFNMSUB213PDZ256rk,
          11863 => Opcode::VFNMSUB213PDZ256rkz,
          11864 => Opcode::VFNMSUB213PDZm,
          11865 => Opcode::VFNMSUB213PDZmb,
          11866 => Opcode::VFNMSUB213PDZmbk,
          11867 => Opcode::VFNMSUB213PDZmbkz,
          11868 => Opcode::VFNMSUB213PDZmk,
          11869 => Opcode::VFNMSUB213PDZmkz,
          11870 => Opcode::VFNMSUB213PDZr,
          11871 => Opcode::VFNMSUB213PDZrb,
          11872 => Opcode::VFNMSUB213PDZrbk,
          11873 => Opcode::VFNMSUB213PDZrbkz,
          11874 => Opcode::VFNMSUB213PDZrk,
          11875 => Opcode::VFNMSUB213PDZrkz,
          11876 => Opcode::VFNMSUB213PDm,
          11877 => Opcode::VFNMSUB213PDr,
          11878 => Opcode::VFNMSUB213PHZ128m,
          11879 => Opcode::VFNMSUB213PHZ128mb,
          11880 => Opcode::VFNMSUB213PHZ128mbk,
          11881 => Opcode::VFNMSUB213PHZ128mbkz,
          11882 => Opcode::VFNMSUB213PHZ128mk,
          11883 => Opcode::VFNMSUB213PHZ128mkz,
          11884 => Opcode::VFNMSUB213PHZ128r,
          11885 => Opcode::VFNMSUB213PHZ128rk,
          11886 => Opcode::VFNMSUB213PHZ128rkz,
          11887 => Opcode::VFNMSUB213PHZ256m,
          11888 => Opcode::VFNMSUB213PHZ256mb,
          11889 => Opcode::VFNMSUB213PHZ256mbk,
          11890 => Opcode::VFNMSUB213PHZ256mbkz,
          11891 => Opcode::VFNMSUB213PHZ256mk,
          11892 => Opcode::VFNMSUB213PHZ256mkz,
          11893 => Opcode::VFNMSUB213PHZ256r,
          11894 => Opcode::VFNMSUB213PHZ256rk,
          11895 => Opcode::VFNMSUB213PHZ256rkz,
          11896 => Opcode::VFNMSUB213PHZm,
          11897 => Opcode::VFNMSUB213PHZmb,
          11898 => Opcode::VFNMSUB213PHZmbk,
          11899 => Opcode::VFNMSUB213PHZmbkz,
          11900 => Opcode::VFNMSUB213PHZmk,
          11901 => Opcode::VFNMSUB213PHZmkz,
          11902 => Opcode::VFNMSUB213PHZr,
          11903 => Opcode::VFNMSUB213PHZrb,
          11904 => Opcode::VFNMSUB213PHZrbk,
          11905 => Opcode::VFNMSUB213PHZrbkz,
          11906 => Opcode::VFNMSUB213PHZrk,
          11907 => Opcode::VFNMSUB213PHZrkz,
          11908 => Opcode::VFNMSUB213PSYm,
          11909 => Opcode::VFNMSUB213PSYr,
          11910 => Opcode::VFNMSUB213PSZ128m,
          11911 => Opcode::VFNMSUB213PSZ128mb,
          11912 => Opcode::VFNMSUB213PSZ128mbk,
          11913 => Opcode::VFNMSUB213PSZ128mbkz,
          11914 => Opcode::VFNMSUB213PSZ128mk,
          11915 => Opcode::VFNMSUB213PSZ128mkz,
          11916 => Opcode::VFNMSUB213PSZ128r,
          11917 => Opcode::VFNMSUB213PSZ128rk,
          11918 => Opcode::VFNMSUB213PSZ128rkz,
          11919 => Opcode::VFNMSUB213PSZ256m,
          11920 => Opcode::VFNMSUB213PSZ256mb,
          11921 => Opcode::VFNMSUB213PSZ256mbk,
          11922 => Opcode::VFNMSUB213PSZ256mbkz,
          11923 => Opcode::VFNMSUB213PSZ256mk,
          11924 => Opcode::VFNMSUB213PSZ256mkz,
          11925 => Opcode::VFNMSUB213PSZ256r,
          11926 => Opcode::VFNMSUB213PSZ256rk,
          11927 => Opcode::VFNMSUB213PSZ256rkz,
          11928 => Opcode::VFNMSUB213PSZm,
          11929 => Opcode::VFNMSUB213PSZmb,
          11930 => Opcode::VFNMSUB213PSZmbk,
          11931 => Opcode::VFNMSUB213PSZmbkz,
          11932 => Opcode::VFNMSUB213PSZmk,
          11933 => Opcode::VFNMSUB213PSZmkz,
          11934 => Opcode::VFNMSUB213PSZr,
          11935 => Opcode::VFNMSUB213PSZrb,
          11936 => Opcode::VFNMSUB213PSZrbk,
          11937 => Opcode::VFNMSUB213PSZrbkz,
          11938 => Opcode::VFNMSUB213PSZrk,
          11939 => Opcode::VFNMSUB213PSZrkz,
          11940 => Opcode::VFNMSUB213PSm,
          11941 => Opcode::VFNMSUB213PSr,
          11942 => Opcode::VFNMSUB213SDZm,
          11943 => Opcode::VFNMSUB213SDZm_Int,
          11944 => Opcode::VFNMSUB213SDZmk_Int,
          11945 => Opcode::VFNMSUB213SDZmkz_Int,
          11946 => Opcode::VFNMSUB213SDZr,
          11947 => Opcode::VFNMSUB213SDZr_Int,
          11948 => Opcode::VFNMSUB213SDZrb,
          11949 => Opcode::VFNMSUB213SDZrb_Int,
          11950 => Opcode::VFNMSUB213SDZrbk_Int,
          11951 => Opcode::VFNMSUB213SDZrbkz_Int,
          11952 => Opcode::VFNMSUB213SDZrk_Int,
          11953 => Opcode::VFNMSUB213SDZrkz_Int,
          11954 => Opcode::VFNMSUB213SDm,
          11955 => Opcode::VFNMSUB213SDm_Int,
          11956 => Opcode::VFNMSUB213SDr,
          11957 => Opcode::VFNMSUB213SDr_Int,
          11958 => Opcode::VFNMSUB213SHZm,
          11959 => Opcode::VFNMSUB213SHZm_Int,
          11960 => Opcode::VFNMSUB213SHZmk_Int,
          11961 => Opcode::VFNMSUB213SHZmkz_Int,
          11962 => Opcode::VFNMSUB213SHZr,
          11963 => Opcode::VFNMSUB213SHZr_Int,
          11964 => Opcode::VFNMSUB213SHZrb,
          11965 => Opcode::VFNMSUB213SHZrb_Int,
          11966 => Opcode::VFNMSUB213SHZrbk_Int,
          11967 => Opcode::VFNMSUB213SHZrbkz_Int,
          11968 => Opcode::VFNMSUB213SHZrk_Int,
          11969 => Opcode::VFNMSUB213SHZrkz_Int,
          11970 => Opcode::VFNMSUB213SSZm,
          11971 => Opcode::VFNMSUB213SSZm_Int,
          11972 => Opcode::VFNMSUB213SSZmk_Int,
          11973 => Opcode::VFNMSUB213SSZmkz_Int,
          11974 => Opcode::VFNMSUB213SSZr,
          11975 => Opcode::VFNMSUB213SSZr_Int,
          11976 => Opcode::VFNMSUB213SSZrb,
          11977 => Opcode::VFNMSUB213SSZrb_Int,
          11978 => Opcode::VFNMSUB213SSZrbk_Int,
          11979 => Opcode::VFNMSUB213SSZrbkz_Int,
          11980 => Opcode::VFNMSUB213SSZrk_Int,
          11981 => Opcode::VFNMSUB213SSZrkz_Int,
          11982 => Opcode::VFNMSUB213SSm,
          11983 => Opcode::VFNMSUB213SSm_Int,
          11984 => Opcode::VFNMSUB213SSr,
          11985 => Opcode::VFNMSUB213SSr_Int,
          11986 => Opcode::VFNMSUB231BF16Z128m,
          11987 => Opcode::VFNMSUB231BF16Z128mb,
          11988 => Opcode::VFNMSUB231BF16Z128mbk,
          11989 => Opcode::VFNMSUB231BF16Z128mbkz,
          11990 => Opcode::VFNMSUB231BF16Z128mk,
          11991 => Opcode::VFNMSUB231BF16Z128mkz,
          11992 => Opcode::VFNMSUB231BF16Z128r,
          11993 => Opcode::VFNMSUB231BF16Z128rk,
          11994 => Opcode::VFNMSUB231BF16Z128rkz,
          11995 => Opcode::VFNMSUB231BF16Z256m,
          11996 => Opcode::VFNMSUB231BF16Z256mb,
          11997 => Opcode::VFNMSUB231BF16Z256mbk,
          11998 => Opcode::VFNMSUB231BF16Z256mbkz,
          11999 => Opcode::VFNMSUB231BF16Z256mk,
          12000 => Opcode::VFNMSUB231BF16Z256mkz,
          12001 => Opcode::VFNMSUB231BF16Z256r,
          12002 => Opcode::VFNMSUB231BF16Z256rk,
          12003 => Opcode::VFNMSUB231BF16Z256rkz,
          12004 => Opcode::VFNMSUB231BF16Zm,
          12005 => Opcode::VFNMSUB231BF16Zmb,
          12006 => Opcode::VFNMSUB231BF16Zmbk,
          12007 => Opcode::VFNMSUB231BF16Zmbkz,
          12008 => Opcode::VFNMSUB231BF16Zmk,
          12009 => Opcode::VFNMSUB231BF16Zmkz,
          12010 => Opcode::VFNMSUB231BF16Zr,
          12011 => Opcode::VFNMSUB231BF16Zrk,
          12012 => Opcode::VFNMSUB231BF16Zrkz,
          12013 => Opcode::VFNMSUB231PDYm,
          12014 => Opcode::VFNMSUB231PDYr,
          12015 => Opcode::VFNMSUB231PDZ128m,
          12016 => Opcode::VFNMSUB231PDZ128mb,
          12017 => Opcode::VFNMSUB231PDZ128mbk,
          12018 => Opcode::VFNMSUB231PDZ128mbkz,
          12019 => Opcode::VFNMSUB231PDZ128mk,
          12020 => Opcode::VFNMSUB231PDZ128mkz,
          12021 => Opcode::VFNMSUB231PDZ128r,
          12022 => Opcode::VFNMSUB231PDZ128rk,
          12023 => Opcode::VFNMSUB231PDZ128rkz,
          12024 => Opcode::VFNMSUB231PDZ256m,
          12025 => Opcode::VFNMSUB231PDZ256mb,
          12026 => Opcode::VFNMSUB231PDZ256mbk,
          12027 => Opcode::VFNMSUB231PDZ256mbkz,
          12028 => Opcode::VFNMSUB231PDZ256mk,
          12029 => Opcode::VFNMSUB231PDZ256mkz,
          12030 => Opcode::VFNMSUB231PDZ256r,
          12031 => Opcode::VFNMSUB231PDZ256rk,
          12032 => Opcode::VFNMSUB231PDZ256rkz,
          12033 => Opcode::VFNMSUB231PDZm,
          12034 => Opcode::VFNMSUB231PDZmb,
          12035 => Opcode::VFNMSUB231PDZmbk,
          12036 => Opcode::VFNMSUB231PDZmbkz,
          12037 => Opcode::VFNMSUB231PDZmk,
          12038 => Opcode::VFNMSUB231PDZmkz,
          12039 => Opcode::VFNMSUB231PDZr,
          12040 => Opcode::VFNMSUB231PDZrb,
          12041 => Opcode::VFNMSUB231PDZrbk,
          12042 => Opcode::VFNMSUB231PDZrbkz,
          12043 => Opcode::VFNMSUB231PDZrk,
          12044 => Opcode::VFNMSUB231PDZrkz,
          12045 => Opcode::VFNMSUB231PDm,
          12046 => Opcode::VFNMSUB231PDr,
          12047 => Opcode::VFNMSUB231PHZ128m,
          12048 => Opcode::VFNMSUB231PHZ128mb,
          12049 => Opcode::VFNMSUB231PHZ128mbk,
          12050 => Opcode::VFNMSUB231PHZ128mbkz,
          12051 => Opcode::VFNMSUB231PHZ128mk,
          12052 => Opcode::VFNMSUB231PHZ128mkz,
          12053 => Opcode::VFNMSUB231PHZ128r,
          12054 => Opcode::VFNMSUB231PHZ128rk,
          12055 => Opcode::VFNMSUB231PHZ128rkz,
          12056 => Opcode::VFNMSUB231PHZ256m,
          12057 => Opcode::VFNMSUB231PHZ256mb,
          12058 => Opcode::VFNMSUB231PHZ256mbk,
          12059 => Opcode::VFNMSUB231PHZ256mbkz,
          12060 => Opcode::VFNMSUB231PHZ256mk,
          12061 => Opcode::VFNMSUB231PHZ256mkz,
          12062 => Opcode::VFNMSUB231PHZ256r,
          12063 => Opcode::VFNMSUB231PHZ256rk,
          12064 => Opcode::VFNMSUB231PHZ256rkz,
          12065 => Opcode::VFNMSUB231PHZm,
          12066 => Opcode::VFNMSUB231PHZmb,
          12067 => Opcode::VFNMSUB231PHZmbk,
          12068 => Opcode::VFNMSUB231PHZmbkz,
          12069 => Opcode::VFNMSUB231PHZmk,
          12070 => Opcode::VFNMSUB231PHZmkz,
          12071 => Opcode::VFNMSUB231PHZr,
          12072 => Opcode::VFNMSUB231PHZrb,
          12073 => Opcode::VFNMSUB231PHZrbk,
          12074 => Opcode::VFNMSUB231PHZrbkz,
          12075 => Opcode::VFNMSUB231PHZrk,
          12076 => Opcode::VFNMSUB231PHZrkz,
          12077 => Opcode::VFNMSUB231PSYm,
          12078 => Opcode::VFNMSUB231PSYr,
          12079 => Opcode::VFNMSUB231PSZ128m,
          12080 => Opcode::VFNMSUB231PSZ128mb,
          12081 => Opcode::VFNMSUB231PSZ128mbk,
          12082 => Opcode::VFNMSUB231PSZ128mbkz,
          12083 => Opcode::VFNMSUB231PSZ128mk,
          12084 => Opcode::VFNMSUB231PSZ128mkz,
          12085 => Opcode::VFNMSUB231PSZ128r,
          12086 => Opcode::VFNMSUB231PSZ128rk,
          12087 => Opcode::VFNMSUB231PSZ128rkz,
          12088 => Opcode::VFNMSUB231PSZ256m,
          12089 => Opcode::VFNMSUB231PSZ256mb,
          12090 => Opcode::VFNMSUB231PSZ256mbk,
          12091 => Opcode::VFNMSUB231PSZ256mbkz,
          12092 => Opcode::VFNMSUB231PSZ256mk,
          12093 => Opcode::VFNMSUB231PSZ256mkz,
          12094 => Opcode::VFNMSUB231PSZ256r,
          12095 => Opcode::VFNMSUB231PSZ256rk,
          12096 => Opcode::VFNMSUB231PSZ256rkz,
          12097 => Opcode::VFNMSUB231PSZm,
          12098 => Opcode::VFNMSUB231PSZmb,
          12099 => Opcode::VFNMSUB231PSZmbk,
          12100 => Opcode::VFNMSUB231PSZmbkz,
          12101 => Opcode::VFNMSUB231PSZmk,
          12102 => Opcode::VFNMSUB231PSZmkz,
          12103 => Opcode::VFNMSUB231PSZr,
          12104 => Opcode::VFNMSUB231PSZrb,
          12105 => Opcode::VFNMSUB231PSZrbk,
          12106 => Opcode::VFNMSUB231PSZrbkz,
          12107 => Opcode::VFNMSUB231PSZrk,
          12108 => Opcode::VFNMSUB231PSZrkz,
          12109 => Opcode::VFNMSUB231PSm,
          12110 => Opcode::VFNMSUB231PSr,
          12111 => Opcode::VFNMSUB231SDZm,
          12112 => Opcode::VFNMSUB231SDZm_Int,
          12113 => Opcode::VFNMSUB231SDZmk_Int,
          12114 => Opcode::VFNMSUB231SDZmkz_Int,
          12115 => Opcode::VFNMSUB231SDZr,
          12116 => Opcode::VFNMSUB231SDZr_Int,
          12117 => Opcode::VFNMSUB231SDZrb,
          12118 => Opcode::VFNMSUB231SDZrb_Int,
          12119 => Opcode::VFNMSUB231SDZrbk_Int,
          12120 => Opcode::VFNMSUB231SDZrbkz_Int,
          12121 => Opcode::VFNMSUB231SDZrk_Int,
          12122 => Opcode::VFNMSUB231SDZrkz_Int,
          12123 => Opcode::VFNMSUB231SDm,
          12124 => Opcode::VFNMSUB231SDm_Int,
          12125 => Opcode::VFNMSUB231SDr,
          12126 => Opcode::VFNMSUB231SDr_Int,
          12127 => Opcode::VFNMSUB231SHZm,
          12128 => Opcode::VFNMSUB231SHZm_Int,
          12129 => Opcode::VFNMSUB231SHZmk_Int,
          12130 => Opcode::VFNMSUB231SHZmkz_Int,
          12131 => Opcode::VFNMSUB231SHZr,
          12132 => Opcode::VFNMSUB231SHZr_Int,
          12133 => Opcode::VFNMSUB231SHZrb,
          12134 => Opcode::VFNMSUB231SHZrb_Int,
          12135 => Opcode::VFNMSUB231SHZrbk_Int,
          12136 => Opcode::VFNMSUB231SHZrbkz_Int,
          12137 => Opcode::VFNMSUB231SHZrk_Int,
          12138 => Opcode::VFNMSUB231SHZrkz_Int,
          12139 => Opcode::VFNMSUB231SSZm,
          12140 => Opcode::VFNMSUB231SSZm_Int,
          12141 => Opcode::VFNMSUB231SSZmk_Int,
          12142 => Opcode::VFNMSUB231SSZmkz_Int,
          12143 => Opcode::VFNMSUB231SSZr,
          12144 => Opcode::VFNMSUB231SSZr_Int,
          12145 => Opcode::VFNMSUB231SSZrb,
          12146 => Opcode::VFNMSUB231SSZrb_Int,
          12147 => Opcode::VFNMSUB231SSZrbk_Int,
          12148 => Opcode::VFNMSUB231SSZrbkz_Int,
          12149 => Opcode::VFNMSUB231SSZrk_Int,
          12150 => Opcode::VFNMSUB231SSZrkz_Int,
          12151 => Opcode::VFNMSUB231SSm,
          12152 => Opcode::VFNMSUB231SSm_Int,
          12153 => Opcode::VFNMSUB231SSr,
          12154 => Opcode::VFNMSUB231SSr_Int,
          12155 => Opcode::VFNMSUBPD4Ymr,
          12156 => Opcode::VFNMSUBPD4Yrm,
          12157 => Opcode::VFNMSUBPD4Yrr,
          12158 => Opcode::VFNMSUBPD4Yrr_REV,
          12159 => Opcode::VFNMSUBPD4mr,
          12160 => Opcode::VFNMSUBPD4rm,
          12161 => Opcode::VFNMSUBPD4rr,
          12162 => Opcode::VFNMSUBPD4rr_REV,
          12163 => Opcode::VFNMSUBPS4Ymr,
          12164 => Opcode::VFNMSUBPS4Yrm,
          12165 => Opcode::VFNMSUBPS4Yrr,
          12166 => Opcode::VFNMSUBPS4Yrr_REV,
          12167 => Opcode::VFNMSUBPS4mr,
          12168 => Opcode::VFNMSUBPS4rm,
          12169 => Opcode::VFNMSUBPS4rr,
          12170 => Opcode::VFNMSUBPS4rr_REV,
          12171 => Opcode::VFNMSUBSD4mr,
          12172 => Opcode::VFNMSUBSD4mr_Int,
          12173 => Opcode::VFNMSUBSD4rm,
          12174 => Opcode::VFNMSUBSD4rm_Int,
          12175 => Opcode::VFNMSUBSD4rr,
          12176 => Opcode::VFNMSUBSD4rr_Int,
          12177 => Opcode::VFNMSUBSD4rr_Int_REV,
          12178 => Opcode::VFNMSUBSD4rr_REV,
          12179 => Opcode::VFNMSUBSS4mr,
          12180 => Opcode::VFNMSUBSS4mr_Int,
          12181 => Opcode::VFNMSUBSS4rm,
          12182 => Opcode::VFNMSUBSS4rm_Int,
          12183 => Opcode::VFNMSUBSS4rr,
          12184 => Opcode::VFNMSUBSS4rr_Int,
          12185 => Opcode::VFNMSUBSS4rr_Int_REV,
          12186 => Opcode::VFNMSUBSS4rr_REV,
          12187 => Opcode::VFPCLASSBF16Z128mbi,
          12188 => Opcode::VFPCLASSBF16Z128mbik,
          12189 => Opcode::VFPCLASSBF16Z128mi,
          12190 => Opcode::VFPCLASSBF16Z128mik,
          12191 => Opcode::VFPCLASSBF16Z128ri,
          12192 => Opcode::VFPCLASSBF16Z128rik,
          12193 => Opcode::VFPCLASSBF16Z256mbi,
          12194 => Opcode::VFPCLASSBF16Z256mbik,
          12195 => Opcode::VFPCLASSBF16Z256mi,
          12196 => Opcode::VFPCLASSBF16Z256mik,
          12197 => Opcode::VFPCLASSBF16Z256ri,
          12198 => Opcode::VFPCLASSBF16Z256rik,
          12199 => Opcode::VFPCLASSBF16Zmbi,
          12200 => Opcode::VFPCLASSBF16Zmbik,
          12201 => Opcode::VFPCLASSBF16Zmi,
          12202 => Opcode::VFPCLASSBF16Zmik,
          12203 => Opcode::VFPCLASSBF16Zri,
          12204 => Opcode::VFPCLASSBF16Zrik,
          12205 => Opcode::VFPCLASSPDZ128mbi,
          12206 => Opcode::VFPCLASSPDZ128mbik,
          12207 => Opcode::VFPCLASSPDZ128mi,
          12208 => Opcode::VFPCLASSPDZ128mik,
          12209 => Opcode::VFPCLASSPDZ128ri,
          12210 => Opcode::VFPCLASSPDZ128rik,
          12211 => Opcode::VFPCLASSPDZ256mbi,
          12212 => Opcode::VFPCLASSPDZ256mbik,
          12213 => Opcode::VFPCLASSPDZ256mi,
          12214 => Opcode::VFPCLASSPDZ256mik,
          12215 => Opcode::VFPCLASSPDZ256ri,
          12216 => Opcode::VFPCLASSPDZ256rik,
          12217 => Opcode::VFPCLASSPDZmbi,
          12218 => Opcode::VFPCLASSPDZmbik,
          12219 => Opcode::VFPCLASSPDZmi,
          12220 => Opcode::VFPCLASSPDZmik,
          12221 => Opcode::VFPCLASSPDZri,
          12222 => Opcode::VFPCLASSPDZrik,
          12223 => Opcode::VFPCLASSPHZ128mbi,
          12224 => Opcode::VFPCLASSPHZ128mbik,
          12225 => Opcode::VFPCLASSPHZ128mi,
          12226 => Opcode::VFPCLASSPHZ128mik,
          12227 => Opcode::VFPCLASSPHZ128ri,
          12228 => Opcode::VFPCLASSPHZ128rik,
          12229 => Opcode::VFPCLASSPHZ256mbi,
          12230 => Opcode::VFPCLASSPHZ256mbik,
          12231 => Opcode::VFPCLASSPHZ256mi,
          12232 => Opcode::VFPCLASSPHZ256mik,
          12233 => Opcode::VFPCLASSPHZ256ri,
          12234 => Opcode::VFPCLASSPHZ256rik,
          12235 => Opcode::VFPCLASSPHZmbi,
          12236 => Opcode::VFPCLASSPHZmbik,
          12237 => Opcode::VFPCLASSPHZmi,
          12238 => Opcode::VFPCLASSPHZmik,
          12239 => Opcode::VFPCLASSPHZri,
          12240 => Opcode::VFPCLASSPHZrik,
          12241 => Opcode::VFPCLASSPSZ128mbi,
          12242 => Opcode::VFPCLASSPSZ128mbik,
          12243 => Opcode::VFPCLASSPSZ128mi,
          12244 => Opcode::VFPCLASSPSZ128mik,
          12245 => Opcode::VFPCLASSPSZ128ri,
          12246 => Opcode::VFPCLASSPSZ128rik,
          12247 => Opcode::VFPCLASSPSZ256mbi,
          12248 => Opcode::VFPCLASSPSZ256mbik,
          12249 => Opcode::VFPCLASSPSZ256mi,
          12250 => Opcode::VFPCLASSPSZ256mik,
          12251 => Opcode::VFPCLASSPSZ256ri,
          12252 => Opcode::VFPCLASSPSZ256rik,
          12253 => Opcode::VFPCLASSPSZmbi,
          12254 => Opcode::VFPCLASSPSZmbik,
          12255 => Opcode::VFPCLASSPSZmi,
          12256 => Opcode::VFPCLASSPSZmik,
          12257 => Opcode::VFPCLASSPSZri,
          12258 => Opcode::VFPCLASSPSZrik,
          12259 => Opcode::VFPCLASSSDZmi,
          12260 => Opcode::VFPCLASSSDZmik,
          12261 => Opcode::VFPCLASSSDZri,
          12262 => Opcode::VFPCLASSSDZrik,
          12263 => Opcode::VFPCLASSSHZmi,
          12264 => Opcode::VFPCLASSSHZmik,
          12265 => Opcode::VFPCLASSSHZri,
          12266 => Opcode::VFPCLASSSHZrik,
          12267 => Opcode::VFPCLASSSSZmi,
          12268 => Opcode::VFPCLASSSSZmik,
          12269 => Opcode::VFPCLASSSSZri,
          12270 => Opcode::VFPCLASSSSZrik,
          12271 => Opcode::VFRCZPDYrm,
          12272 => Opcode::VFRCZPDYrr,
          12273 => Opcode::VFRCZPDrm,
          12274 => Opcode::VFRCZPDrr,
          12275 => Opcode::VFRCZPSYrm,
          12276 => Opcode::VFRCZPSYrr,
          12277 => Opcode::VFRCZPSrm,
          12278 => Opcode::VFRCZPSrr,
          12279 => Opcode::VFRCZSDrm,
          12280 => Opcode::VFRCZSDrr,
          12281 => Opcode::VFRCZSSrm,
          12282 => Opcode::VFRCZSSrr,
          12283 => Opcode::VGATHERDPDYrm,
          12284 => Opcode::VGATHERDPDZ128rm,
          12285 => Opcode::VGATHERDPDZ256rm,
          12286 => Opcode::VGATHERDPDZrm,
          12287 => Opcode::VGATHERDPDrm,
          12288 => Opcode::VGATHERDPSYrm,
          12289 => Opcode::VGATHERDPSZ128rm,
          12290 => Opcode::VGATHERDPSZ256rm,
          12291 => Opcode::VGATHERDPSZrm,
          12292 => Opcode::VGATHERDPSrm,
          12293 => Opcode::VGATHERPF0DPDm,
          12294 => Opcode::VGATHERPF0DPSm,
          12295 => Opcode::VGATHERPF0QPDm,
          12296 => Opcode::VGATHERPF0QPSm,
          12297 => Opcode::VGATHERPF1DPDm,
          12298 => Opcode::VGATHERPF1DPSm,
          12299 => Opcode::VGATHERPF1QPDm,
          12300 => Opcode::VGATHERPF1QPSm,
          12301 => Opcode::VGATHERQPDYrm,
          12302 => Opcode::VGATHERQPDZ128rm,
          12303 => Opcode::VGATHERQPDZ256rm,
          12304 => Opcode::VGATHERQPDZrm,
          12305 => Opcode::VGATHERQPDrm,
          12306 => Opcode::VGATHERQPSYrm,
          12307 => Opcode::VGATHERQPSZ128rm,
          12308 => Opcode::VGATHERQPSZ256rm,
          12309 => Opcode::VGATHERQPSZrm,
          12310 => Opcode::VGATHERQPSrm,
          12311 => Opcode::VGETEXPBF16Z128m,
          12312 => Opcode::VGETEXPBF16Z128mb,
          12313 => Opcode::VGETEXPBF16Z128mbk,
          12314 => Opcode::VGETEXPBF16Z128mbkz,
          12315 => Opcode::VGETEXPBF16Z128mk,
          12316 => Opcode::VGETEXPBF16Z128mkz,
          12317 => Opcode::VGETEXPBF16Z128r,
          12318 => Opcode::VGETEXPBF16Z128rk,
          12319 => Opcode::VGETEXPBF16Z128rkz,
          12320 => Opcode::VGETEXPBF16Z256m,
          12321 => Opcode::VGETEXPBF16Z256mb,
          12322 => Opcode::VGETEXPBF16Z256mbk,
          12323 => Opcode::VGETEXPBF16Z256mbkz,
          12324 => Opcode::VGETEXPBF16Z256mk,
          12325 => Opcode::VGETEXPBF16Z256mkz,
          12326 => Opcode::VGETEXPBF16Z256r,
          12327 => Opcode::VGETEXPBF16Z256rk,
          12328 => Opcode::VGETEXPBF16Z256rkz,
          12329 => Opcode::VGETEXPBF16Zm,
          12330 => Opcode::VGETEXPBF16Zmb,
          12331 => Opcode::VGETEXPBF16Zmbk,
          12332 => Opcode::VGETEXPBF16Zmbkz,
          12333 => Opcode::VGETEXPBF16Zmk,
          12334 => Opcode::VGETEXPBF16Zmkz,
          12335 => Opcode::VGETEXPBF16Zr,
          12336 => Opcode::VGETEXPBF16Zrk,
          12337 => Opcode::VGETEXPBF16Zrkz,
          12338 => Opcode::VGETEXPPDZ128m,
          12339 => Opcode::VGETEXPPDZ128mb,
          12340 => Opcode::VGETEXPPDZ128mbk,
          12341 => Opcode::VGETEXPPDZ128mbkz,
          12342 => Opcode::VGETEXPPDZ128mk,
          12343 => Opcode::VGETEXPPDZ128mkz,
          12344 => Opcode::VGETEXPPDZ128r,
          12345 => Opcode::VGETEXPPDZ128rk,
          12346 => Opcode::VGETEXPPDZ128rkz,
          12347 => Opcode::VGETEXPPDZ256m,
          12348 => Opcode::VGETEXPPDZ256mb,
          12349 => Opcode::VGETEXPPDZ256mbk,
          12350 => Opcode::VGETEXPPDZ256mbkz,
          12351 => Opcode::VGETEXPPDZ256mk,
          12352 => Opcode::VGETEXPPDZ256mkz,
          12353 => Opcode::VGETEXPPDZ256r,
          12354 => Opcode::VGETEXPPDZ256rk,
          12355 => Opcode::VGETEXPPDZ256rkz,
          12356 => Opcode::VGETEXPPDZm,
          12357 => Opcode::VGETEXPPDZmb,
          12358 => Opcode::VGETEXPPDZmbk,
          12359 => Opcode::VGETEXPPDZmbkz,
          12360 => Opcode::VGETEXPPDZmk,
          12361 => Opcode::VGETEXPPDZmkz,
          12362 => Opcode::VGETEXPPDZr,
          12363 => Opcode::VGETEXPPDZrb,
          12364 => Opcode::VGETEXPPDZrbk,
          12365 => Opcode::VGETEXPPDZrbkz,
          12366 => Opcode::VGETEXPPDZrk,
          12367 => Opcode::VGETEXPPDZrkz,
          12368 => Opcode::VGETEXPPHZ128m,
          12369 => Opcode::VGETEXPPHZ128mb,
          12370 => Opcode::VGETEXPPHZ128mbk,
          12371 => Opcode::VGETEXPPHZ128mbkz,
          12372 => Opcode::VGETEXPPHZ128mk,
          12373 => Opcode::VGETEXPPHZ128mkz,
          12374 => Opcode::VGETEXPPHZ128r,
          12375 => Opcode::VGETEXPPHZ128rk,
          12376 => Opcode::VGETEXPPHZ128rkz,
          12377 => Opcode::VGETEXPPHZ256m,
          12378 => Opcode::VGETEXPPHZ256mb,
          12379 => Opcode::VGETEXPPHZ256mbk,
          12380 => Opcode::VGETEXPPHZ256mbkz,
          12381 => Opcode::VGETEXPPHZ256mk,
          12382 => Opcode::VGETEXPPHZ256mkz,
          12383 => Opcode::VGETEXPPHZ256r,
          12384 => Opcode::VGETEXPPHZ256rk,
          12385 => Opcode::VGETEXPPHZ256rkz,
          12386 => Opcode::VGETEXPPHZm,
          12387 => Opcode::VGETEXPPHZmb,
          12388 => Opcode::VGETEXPPHZmbk,
          12389 => Opcode::VGETEXPPHZmbkz,
          12390 => Opcode::VGETEXPPHZmk,
          12391 => Opcode::VGETEXPPHZmkz,
          12392 => Opcode::VGETEXPPHZr,
          12393 => Opcode::VGETEXPPHZrb,
          12394 => Opcode::VGETEXPPHZrbk,
          12395 => Opcode::VGETEXPPHZrbkz,
          12396 => Opcode::VGETEXPPHZrk,
          12397 => Opcode::VGETEXPPHZrkz,
          12398 => Opcode::VGETEXPPSZ128m,
          12399 => Opcode::VGETEXPPSZ128mb,
          12400 => Opcode::VGETEXPPSZ128mbk,
          12401 => Opcode::VGETEXPPSZ128mbkz,
          12402 => Opcode::VGETEXPPSZ128mk,
          12403 => Opcode::VGETEXPPSZ128mkz,
          12404 => Opcode::VGETEXPPSZ128r,
          12405 => Opcode::VGETEXPPSZ128rk,
          12406 => Opcode::VGETEXPPSZ128rkz,
          12407 => Opcode::VGETEXPPSZ256m,
          12408 => Opcode::VGETEXPPSZ256mb,
          12409 => Opcode::VGETEXPPSZ256mbk,
          12410 => Opcode::VGETEXPPSZ256mbkz,
          12411 => Opcode::VGETEXPPSZ256mk,
          12412 => Opcode::VGETEXPPSZ256mkz,
          12413 => Opcode::VGETEXPPSZ256r,
          12414 => Opcode::VGETEXPPSZ256rk,
          12415 => Opcode::VGETEXPPSZ256rkz,
          12416 => Opcode::VGETEXPPSZm,
          12417 => Opcode::VGETEXPPSZmb,
          12418 => Opcode::VGETEXPPSZmbk,
          12419 => Opcode::VGETEXPPSZmbkz,
          12420 => Opcode::VGETEXPPSZmk,
          12421 => Opcode::VGETEXPPSZmkz,
          12422 => Opcode::VGETEXPPSZr,
          12423 => Opcode::VGETEXPPSZrb,
          12424 => Opcode::VGETEXPPSZrbk,
          12425 => Opcode::VGETEXPPSZrbkz,
          12426 => Opcode::VGETEXPPSZrk,
          12427 => Opcode::VGETEXPPSZrkz,
          12428 => Opcode::VGETEXPSDZm,
          12429 => Opcode::VGETEXPSDZmk,
          12430 => Opcode::VGETEXPSDZmkz,
          12431 => Opcode::VGETEXPSDZr,
          12432 => Opcode::VGETEXPSDZrb,
          12433 => Opcode::VGETEXPSDZrbk,
          12434 => Opcode::VGETEXPSDZrbkz,
          12435 => Opcode::VGETEXPSDZrk,
          12436 => Opcode::VGETEXPSDZrkz,
          12437 => Opcode::VGETEXPSHZm,
          12438 => Opcode::VGETEXPSHZmk,
          12439 => Opcode::VGETEXPSHZmkz,
          12440 => Opcode::VGETEXPSHZr,
          12441 => Opcode::VGETEXPSHZrb,
          12442 => Opcode::VGETEXPSHZrbk,
          12443 => Opcode::VGETEXPSHZrbkz,
          12444 => Opcode::VGETEXPSHZrk,
          12445 => Opcode::VGETEXPSHZrkz,
          12446 => Opcode::VGETEXPSSZm,
          12447 => Opcode::VGETEXPSSZmk,
          12448 => Opcode::VGETEXPSSZmkz,
          12449 => Opcode::VGETEXPSSZr,
          12450 => Opcode::VGETEXPSSZrb,
          12451 => Opcode::VGETEXPSSZrbk,
          12452 => Opcode::VGETEXPSSZrbkz,
          12453 => Opcode::VGETEXPSSZrk,
          12454 => Opcode::VGETEXPSSZrkz,
          12455 => Opcode::VGETMANTBF16Z128rmbi,
          12456 => Opcode::VGETMANTBF16Z128rmbik,
          12457 => Opcode::VGETMANTBF16Z128rmbikz,
          12458 => Opcode::VGETMANTBF16Z128rmi,
          12459 => Opcode::VGETMANTBF16Z128rmik,
          12460 => Opcode::VGETMANTBF16Z128rmikz,
          12461 => Opcode::VGETMANTBF16Z128rri,
          12462 => Opcode::VGETMANTBF16Z128rrik,
          12463 => Opcode::VGETMANTBF16Z128rrikz,
          12464 => Opcode::VGETMANTBF16Z256rmbi,
          12465 => Opcode::VGETMANTBF16Z256rmbik,
          12466 => Opcode::VGETMANTBF16Z256rmbikz,
          12467 => Opcode::VGETMANTBF16Z256rmi,
          12468 => Opcode::VGETMANTBF16Z256rmik,
          12469 => Opcode::VGETMANTBF16Z256rmikz,
          12470 => Opcode::VGETMANTBF16Z256rri,
          12471 => Opcode::VGETMANTBF16Z256rrik,
          12472 => Opcode::VGETMANTBF16Z256rrikz,
          12473 => Opcode::VGETMANTBF16Zrmbi,
          12474 => Opcode::VGETMANTBF16Zrmbik,
          12475 => Opcode::VGETMANTBF16Zrmbikz,
          12476 => Opcode::VGETMANTBF16Zrmi,
          12477 => Opcode::VGETMANTBF16Zrmik,
          12478 => Opcode::VGETMANTBF16Zrmikz,
          12479 => Opcode::VGETMANTBF16Zrri,
          12480 => Opcode::VGETMANTBF16Zrrik,
          12481 => Opcode::VGETMANTBF16Zrrikz,
          12482 => Opcode::VGETMANTPDZ128rmbi,
          12483 => Opcode::VGETMANTPDZ128rmbik,
          12484 => Opcode::VGETMANTPDZ128rmbikz,
          12485 => Opcode::VGETMANTPDZ128rmi,
          12486 => Opcode::VGETMANTPDZ128rmik,
          12487 => Opcode::VGETMANTPDZ128rmikz,
          12488 => Opcode::VGETMANTPDZ128rri,
          12489 => Opcode::VGETMANTPDZ128rrik,
          12490 => Opcode::VGETMANTPDZ128rrikz,
          12491 => Opcode::VGETMANTPDZ256rmbi,
          12492 => Opcode::VGETMANTPDZ256rmbik,
          12493 => Opcode::VGETMANTPDZ256rmbikz,
          12494 => Opcode::VGETMANTPDZ256rmi,
          12495 => Opcode::VGETMANTPDZ256rmik,
          12496 => Opcode::VGETMANTPDZ256rmikz,
          12497 => Opcode::VGETMANTPDZ256rri,
          12498 => Opcode::VGETMANTPDZ256rrik,
          12499 => Opcode::VGETMANTPDZ256rrikz,
          12500 => Opcode::VGETMANTPDZrmbi,
          12501 => Opcode::VGETMANTPDZrmbik,
          12502 => Opcode::VGETMANTPDZrmbikz,
          12503 => Opcode::VGETMANTPDZrmi,
          12504 => Opcode::VGETMANTPDZrmik,
          12505 => Opcode::VGETMANTPDZrmikz,
          12506 => Opcode::VGETMANTPDZrri,
          12507 => Opcode::VGETMANTPDZrrib,
          12508 => Opcode::VGETMANTPDZrribk,
          12509 => Opcode::VGETMANTPDZrribkz,
          12510 => Opcode::VGETMANTPDZrrik,
          12511 => Opcode::VGETMANTPDZrrikz,
          12512 => Opcode::VGETMANTPHZ128rmbi,
          12513 => Opcode::VGETMANTPHZ128rmbik,
          12514 => Opcode::VGETMANTPHZ128rmbikz,
          12515 => Opcode::VGETMANTPHZ128rmi,
          12516 => Opcode::VGETMANTPHZ128rmik,
          12517 => Opcode::VGETMANTPHZ128rmikz,
          12518 => Opcode::VGETMANTPHZ128rri,
          12519 => Opcode::VGETMANTPHZ128rrik,
          12520 => Opcode::VGETMANTPHZ128rrikz,
          12521 => Opcode::VGETMANTPHZ256rmbi,
          12522 => Opcode::VGETMANTPHZ256rmbik,
          12523 => Opcode::VGETMANTPHZ256rmbikz,
          12524 => Opcode::VGETMANTPHZ256rmi,
          12525 => Opcode::VGETMANTPHZ256rmik,
          12526 => Opcode::VGETMANTPHZ256rmikz,
          12527 => Opcode::VGETMANTPHZ256rri,
          12528 => Opcode::VGETMANTPHZ256rrik,
          12529 => Opcode::VGETMANTPHZ256rrikz,
          12530 => Opcode::VGETMANTPHZrmbi,
          12531 => Opcode::VGETMANTPHZrmbik,
          12532 => Opcode::VGETMANTPHZrmbikz,
          12533 => Opcode::VGETMANTPHZrmi,
          12534 => Opcode::VGETMANTPHZrmik,
          12535 => Opcode::VGETMANTPHZrmikz,
          12536 => Opcode::VGETMANTPHZrri,
          12537 => Opcode::VGETMANTPHZrrib,
          12538 => Opcode::VGETMANTPHZrribk,
          12539 => Opcode::VGETMANTPHZrribkz,
          12540 => Opcode::VGETMANTPHZrrik,
          12541 => Opcode::VGETMANTPHZrrikz,
          12542 => Opcode::VGETMANTPSZ128rmbi,
          12543 => Opcode::VGETMANTPSZ128rmbik,
          12544 => Opcode::VGETMANTPSZ128rmbikz,
          12545 => Opcode::VGETMANTPSZ128rmi,
          12546 => Opcode::VGETMANTPSZ128rmik,
          12547 => Opcode::VGETMANTPSZ128rmikz,
          12548 => Opcode::VGETMANTPSZ128rri,
          12549 => Opcode::VGETMANTPSZ128rrik,
          12550 => Opcode::VGETMANTPSZ128rrikz,
          12551 => Opcode::VGETMANTPSZ256rmbi,
          12552 => Opcode::VGETMANTPSZ256rmbik,
          12553 => Opcode::VGETMANTPSZ256rmbikz,
          12554 => Opcode::VGETMANTPSZ256rmi,
          12555 => Opcode::VGETMANTPSZ256rmik,
          12556 => Opcode::VGETMANTPSZ256rmikz,
          12557 => Opcode::VGETMANTPSZ256rri,
          12558 => Opcode::VGETMANTPSZ256rrik,
          12559 => Opcode::VGETMANTPSZ256rrikz,
          12560 => Opcode::VGETMANTPSZrmbi,
          12561 => Opcode::VGETMANTPSZrmbik,
          12562 => Opcode::VGETMANTPSZrmbikz,
          12563 => Opcode::VGETMANTPSZrmi,
          12564 => Opcode::VGETMANTPSZrmik,
          12565 => Opcode::VGETMANTPSZrmikz,
          12566 => Opcode::VGETMANTPSZrri,
          12567 => Opcode::VGETMANTPSZrrib,
          12568 => Opcode::VGETMANTPSZrribk,
          12569 => Opcode::VGETMANTPSZrribkz,
          12570 => Opcode::VGETMANTPSZrrik,
          12571 => Opcode::VGETMANTPSZrrikz,
          12572 => Opcode::VGETMANTSDZrmi,
          12573 => Opcode::VGETMANTSDZrmik,
          12574 => Opcode::VGETMANTSDZrmikz,
          12575 => Opcode::VGETMANTSDZrri,
          12576 => Opcode::VGETMANTSDZrrib,
          12577 => Opcode::VGETMANTSDZrribk,
          12578 => Opcode::VGETMANTSDZrribkz,
          12579 => Opcode::VGETMANTSDZrrik,
          12580 => Opcode::VGETMANTSDZrrikz,
          12581 => Opcode::VGETMANTSHZrmi,
          12582 => Opcode::VGETMANTSHZrmik,
          12583 => Opcode::VGETMANTSHZrmikz,
          12584 => Opcode::VGETMANTSHZrri,
          12585 => Opcode::VGETMANTSHZrrib,
          12586 => Opcode::VGETMANTSHZrribk,
          12587 => Opcode::VGETMANTSHZrribkz,
          12588 => Opcode::VGETMANTSHZrrik,
          12589 => Opcode::VGETMANTSHZrrikz,
          12590 => Opcode::VGETMANTSSZrmi,
          12591 => Opcode::VGETMANTSSZrmik,
          12592 => Opcode::VGETMANTSSZrmikz,
          12593 => Opcode::VGETMANTSSZrri,
          12594 => Opcode::VGETMANTSSZrrib,
          12595 => Opcode::VGETMANTSSZrribk,
          12596 => Opcode::VGETMANTSSZrribkz,
          12597 => Opcode::VGETMANTSSZrrik,
          12598 => Opcode::VGETMANTSSZrrikz,
          12599 => Opcode::VGF2P8AFFINEINVQBYrmi,
          12600 => Opcode::VGF2P8AFFINEINVQBYrri,
          12601 => Opcode::VGF2P8AFFINEINVQBZ128rmbi,
          12602 => Opcode::VGF2P8AFFINEINVQBZ128rmbik,
          12603 => Opcode::VGF2P8AFFINEINVQBZ128rmbikz,
          12604 => Opcode::VGF2P8AFFINEINVQBZ128rmi,
          12605 => Opcode::VGF2P8AFFINEINVQBZ128rmik,
          12606 => Opcode::VGF2P8AFFINEINVQBZ128rmikz,
          12607 => Opcode::VGF2P8AFFINEINVQBZ128rri,
          12608 => Opcode::VGF2P8AFFINEINVQBZ128rrik,
          12609 => Opcode::VGF2P8AFFINEINVQBZ128rrikz,
          12610 => Opcode::VGF2P8AFFINEINVQBZ256rmbi,
          12611 => Opcode::VGF2P8AFFINEINVQBZ256rmbik,
          12612 => Opcode::VGF2P8AFFINEINVQBZ256rmbikz,
          12613 => Opcode::VGF2P8AFFINEINVQBZ256rmi,
          12614 => Opcode::VGF2P8AFFINEINVQBZ256rmik,
          12615 => Opcode::VGF2P8AFFINEINVQBZ256rmikz,
          12616 => Opcode::VGF2P8AFFINEINVQBZ256rri,
          12617 => Opcode::VGF2P8AFFINEINVQBZ256rrik,
          12618 => Opcode::VGF2P8AFFINEINVQBZ256rrikz,
          12619 => Opcode::VGF2P8AFFINEINVQBZrmbi,
          12620 => Opcode::VGF2P8AFFINEINVQBZrmbik,
          12621 => Opcode::VGF2P8AFFINEINVQBZrmbikz,
          12622 => Opcode::VGF2P8AFFINEINVQBZrmi,
          12623 => Opcode::VGF2P8AFFINEINVQBZrmik,
          12624 => Opcode::VGF2P8AFFINEINVQBZrmikz,
          12625 => Opcode::VGF2P8AFFINEINVQBZrri,
          12626 => Opcode::VGF2P8AFFINEINVQBZrrik,
          12627 => Opcode::VGF2P8AFFINEINVQBZrrikz,
          12628 => Opcode::VGF2P8AFFINEINVQBrmi,
          12629 => Opcode::VGF2P8AFFINEINVQBrri,
          12630 => Opcode::VGF2P8AFFINEQBYrmi,
          12631 => Opcode::VGF2P8AFFINEQBYrri,
          12632 => Opcode::VGF2P8AFFINEQBZ128rmbi,
          12633 => Opcode::VGF2P8AFFINEQBZ128rmbik,
          12634 => Opcode::VGF2P8AFFINEQBZ128rmbikz,
          12635 => Opcode::VGF2P8AFFINEQBZ128rmi,
          12636 => Opcode::VGF2P8AFFINEQBZ128rmik,
          12637 => Opcode::VGF2P8AFFINEQBZ128rmikz,
          12638 => Opcode::VGF2P8AFFINEQBZ128rri,
          12639 => Opcode::VGF2P8AFFINEQBZ128rrik,
          12640 => Opcode::VGF2P8AFFINEQBZ128rrikz,
          12641 => Opcode::VGF2P8AFFINEQBZ256rmbi,
          12642 => Opcode::VGF2P8AFFINEQBZ256rmbik,
          12643 => Opcode::VGF2P8AFFINEQBZ256rmbikz,
          12644 => Opcode::VGF2P8AFFINEQBZ256rmi,
          12645 => Opcode::VGF2P8AFFINEQBZ256rmik,
          12646 => Opcode::VGF2P8AFFINEQBZ256rmikz,
          12647 => Opcode::VGF2P8AFFINEQBZ256rri,
          12648 => Opcode::VGF2P8AFFINEQBZ256rrik,
          12649 => Opcode::VGF2P8AFFINEQBZ256rrikz,
          12650 => Opcode::VGF2P8AFFINEQBZrmbi,
          12651 => Opcode::VGF2P8AFFINEQBZrmbik,
          12652 => Opcode::VGF2P8AFFINEQBZrmbikz,
          12653 => Opcode::VGF2P8AFFINEQBZrmi,
          12654 => Opcode::VGF2P8AFFINEQBZrmik,
          12655 => Opcode::VGF2P8AFFINEQBZrmikz,
          12656 => Opcode::VGF2P8AFFINEQBZrri,
          12657 => Opcode::VGF2P8AFFINEQBZrrik,
          12658 => Opcode::VGF2P8AFFINEQBZrrikz,
          12659 => Opcode::VGF2P8AFFINEQBrmi,
          12660 => Opcode::VGF2P8AFFINEQBrri,
          12661 => Opcode::VGF2P8MULBYrm,
          12662 => Opcode::VGF2P8MULBYrr,
          12663 => Opcode::VGF2P8MULBZ128rm,
          12664 => Opcode::VGF2P8MULBZ128rmk,
          12665 => Opcode::VGF2P8MULBZ128rmkz,
          12666 => Opcode::VGF2P8MULBZ128rr,
          12667 => Opcode::VGF2P8MULBZ128rrk,
          12668 => Opcode::VGF2P8MULBZ128rrkz,
          12669 => Opcode::VGF2P8MULBZ256rm,
          12670 => Opcode::VGF2P8MULBZ256rmk,
          12671 => Opcode::VGF2P8MULBZ256rmkz,
          12672 => Opcode::VGF2P8MULBZ256rr,
          12673 => Opcode::VGF2P8MULBZ256rrk,
          12674 => Opcode::VGF2P8MULBZ256rrkz,
          12675 => Opcode::VGF2P8MULBZrm,
          12676 => Opcode::VGF2P8MULBZrmk,
          12677 => Opcode::VGF2P8MULBZrmkz,
          12678 => Opcode::VGF2P8MULBZrr,
          12679 => Opcode::VGF2P8MULBZrrk,
          12680 => Opcode::VGF2P8MULBZrrkz,
          12681 => Opcode::VGF2P8MULBrm,
          12682 => Opcode::VGF2P8MULBrr,
          12683 => Opcode::VHADDPDYrm,
          12684 => Opcode::VHADDPDYrr,
          12685 => Opcode::VHADDPDrm,
          12686 => Opcode::VHADDPDrr,
          12687 => Opcode::VHADDPSYrm,
          12688 => Opcode::VHADDPSYrr,
          12689 => Opcode::VHADDPSrm,
          12690 => Opcode::VHADDPSrr,
          12691 => Opcode::VHSUBPDYrm,
          12692 => Opcode::VHSUBPDYrr,
          12693 => Opcode::VHSUBPDrm,
          12694 => Opcode::VHSUBPDrr,
          12695 => Opcode::VHSUBPSYrm,
          12696 => Opcode::VHSUBPSYrr,
          12697 => Opcode::VHSUBPSrm,
          12698 => Opcode::VHSUBPSrr,
          12699 => Opcode::VINSERTF128rmi,
          12700 => Opcode::VINSERTF128rri,
          12701 => Opcode::VINSERTF32X4Z256rmi,
          12702 => Opcode::VINSERTF32X4Z256rmik,
          12703 => Opcode::VINSERTF32X4Z256rmikz,
          12704 => Opcode::VINSERTF32X4Z256rri,
          12705 => Opcode::VINSERTF32X4Z256rrik,
          12706 => Opcode::VINSERTF32X4Z256rrikz,
          12707 => Opcode::VINSERTF32X4Zrmi,
          12708 => Opcode::VINSERTF32X4Zrmik,
          12709 => Opcode::VINSERTF32X4Zrmikz,
          12710 => Opcode::VINSERTF32X4Zrri,
          12711 => Opcode::VINSERTF32X4Zrrik,
          12712 => Opcode::VINSERTF32X4Zrrikz,
          12713 => Opcode::VINSERTF32X8Zrmi,
          12714 => Opcode::VINSERTF32X8Zrmik,
          12715 => Opcode::VINSERTF32X8Zrmikz,
          12716 => Opcode::VINSERTF32X8Zrri,
          12717 => Opcode::VINSERTF32X8Zrrik,
          12718 => Opcode::VINSERTF32X8Zrrikz,
          12719 => Opcode::VINSERTF64X2Z256rmi,
          12720 => Opcode::VINSERTF64X2Z256rmik,
          12721 => Opcode::VINSERTF64X2Z256rmikz,
          12722 => Opcode::VINSERTF64X2Z256rri,
          12723 => Opcode::VINSERTF64X2Z256rrik,
          12724 => Opcode::VINSERTF64X2Z256rrikz,
          12725 => Opcode::VINSERTF64X2Zrmi,
          12726 => Opcode::VINSERTF64X2Zrmik,
          12727 => Opcode::VINSERTF64X2Zrmikz,
          12728 => Opcode::VINSERTF64X2Zrri,
          12729 => Opcode::VINSERTF64X2Zrrik,
          12730 => Opcode::VINSERTF64X2Zrrikz,
          12731 => Opcode::VINSERTF64X4Zrmi,
          12732 => Opcode::VINSERTF64X4Zrmik,
          12733 => Opcode::VINSERTF64X4Zrmikz,
          12734 => Opcode::VINSERTF64X4Zrri,
          12735 => Opcode::VINSERTF64X4Zrrik,
          12736 => Opcode::VINSERTF64X4Zrrikz,
          12737 => Opcode::VINSERTI128rmi,
          12738 => Opcode::VINSERTI128rri,
          12739 => Opcode::VINSERTI32X4Z256rmi,
          12740 => Opcode::VINSERTI32X4Z256rmik,
          12741 => Opcode::VINSERTI32X4Z256rmikz,
          12742 => Opcode::VINSERTI32X4Z256rri,
          12743 => Opcode::VINSERTI32X4Z256rrik,
          12744 => Opcode::VINSERTI32X4Z256rrikz,
          12745 => Opcode::VINSERTI32X4Zrmi,
          12746 => Opcode::VINSERTI32X4Zrmik,
          12747 => Opcode::VINSERTI32X4Zrmikz,
          12748 => Opcode::VINSERTI32X4Zrri,
          12749 => Opcode::VINSERTI32X4Zrrik,
          12750 => Opcode::VINSERTI32X4Zrrikz,
          12751 => Opcode::VINSERTI32X8Zrmi,
          12752 => Opcode::VINSERTI32X8Zrmik,
          12753 => Opcode::VINSERTI32X8Zrmikz,
          12754 => Opcode::VINSERTI32X8Zrri,
          12755 => Opcode::VINSERTI32X8Zrrik,
          12756 => Opcode::VINSERTI32X8Zrrikz,
          12757 => Opcode::VINSERTI64X2Z256rmi,
          12758 => Opcode::VINSERTI64X2Z256rmik,
          12759 => Opcode::VINSERTI64X2Z256rmikz,
          12760 => Opcode::VINSERTI64X2Z256rri,
          12761 => Opcode::VINSERTI64X2Z256rrik,
          12762 => Opcode::VINSERTI64X2Z256rrikz,
          12763 => Opcode::VINSERTI64X2Zrmi,
          12764 => Opcode::VINSERTI64X2Zrmik,
          12765 => Opcode::VINSERTI64X2Zrmikz,
          12766 => Opcode::VINSERTI64X2Zrri,
          12767 => Opcode::VINSERTI64X2Zrrik,
          12768 => Opcode::VINSERTI64X2Zrrikz,
          12769 => Opcode::VINSERTI64X4Zrmi,
          12770 => Opcode::VINSERTI64X4Zrmik,
          12771 => Opcode::VINSERTI64X4Zrmikz,
          12772 => Opcode::VINSERTI64X4Zrri,
          12773 => Opcode::VINSERTI64X4Zrrik,
          12774 => Opcode::VINSERTI64X4Zrrikz,
          12775 => Opcode::VINSERTPSZrmi,
          12776 => Opcode::VINSERTPSZrri,
          12777 => Opcode::VINSERTPSrmi,
          12778 => Opcode::VINSERTPSrri,
          12779 => Opcode::VLDDQUYrm,
          12780 => Opcode::VLDDQUrm,
          12781 => Opcode::VLDMXCSR,
          12782 => Opcode::VMASKMOVDQU,
          12783 => Opcode::VMASKMOVDQU64,
          12784 => Opcode::VMASKMOVPDYmr,
          12785 => Opcode::VMASKMOVPDYrm,
          12786 => Opcode::VMASKMOVPDmr,
          12787 => Opcode::VMASKMOVPDrm,
          12788 => Opcode::VMASKMOVPSYmr,
          12789 => Opcode::VMASKMOVPSYrm,
          12790 => Opcode::VMASKMOVPSmr,
          12791 => Opcode::VMASKMOVPSrm,
          12792 => Opcode::VMAXBF16Z128rm,
          12793 => Opcode::VMAXBF16Z128rmb,
          12794 => Opcode::VMAXBF16Z128rmbk,
          12795 => Opcode::VMAXBF16Z128rmbkz,
          12796 => Opcode::VMAXBF16Z128rmk,
          12797 => Opcode::VMAXBF16Z128rmkz,
          12798 => Opcode::VMAXBF16Z128rr,
          12799 => Opcode::VMAXBF16Z128rrk,
          12800 => Opcode::VMAXBF16Z128rrkz,
          12801 => Opcode::VMAXBF16Z256rm,
          12802 => Opcode::VMAXBF16Z256rmb,
          12803 => Opcode::VMAXBF16Z256rmbk,
          12804 => Opcode::VMAXBF16Z256rmbkz,
          12805 => Opcode::VMAXBF16Z256rmk,
          12806 => Opcode::VMAXBF16Z256rmkz,
          12807 => Opcode::VMAXBF16Z256rr,
          12808 => Opcode::VMAXBF16Z256rrk,
          12809 => Opcode::VMAXBF16Z256rrkz,
          12810 => Opcode::VMAXBF16Zrm,
          12811 => Opcode::VMAXBF16Zrmb,
          12812 => Opcode::VMAXBF16Zrmbk,
          12813 => Opcode::VMAXBF16Zrmbkz,
          12814 => Opcode::VMAXBF16Zrmk,
          12815 => Opcode::VMAXBF16Zrmkz,
          12816 => Opcode::VMAXBF16Zrr,
          12817 => Opcode::VMAXBF16Zrrk,
          12818 => Opcode::VMAXBF16Zrrkz,
          12819 => Opcode::VMAXCPDYrm,
          12820 => Opcode::VMAXCPDYrr,
          12821 => Opcode::VMAXCPDZ128rm,
          12822 => Opcode::VMAXCPDZ128rmb,
          12823 => Opcode::VMAXCPDZ128rmbk,
          12824 => Opcode::VMAXCPDZ128rmbkz,
          12825 => Opcode::VMAXCPDZ128rmk,
          12826 => Opcode::VMAXCPDZ128rmkz,
          12827 => Opcode::VMAXCPDZ128rr,
          12828 => Opcode::VMAXCPDZ128rrk,
          12829 => Opcode::VMAXCPDZ128rrkz,
          12830 => Opcode::VMAXCPDZ256rm,
          12831 => Opcode::VMAXCPDZ256rmb,
          12832 => Opcode::VMAXCPDZ256rmbk,
          12833 => Opcode::VMAXCPDZ256rmbkz,
          12834 => Opcode::VMAXCPDZ256rmk,
          12835 => Opcode::VMAXCPDZ256rmkz,
          12836 => Opcode::VMAXCPDZ256rr,
          12837 => Opcode::VMAXCPDZ256rrk,
          12838 => Opcode::VMAXCPDZ256rrkz,
          12839 => Opcode::VMAXCPDZrm,
          12840 => Opcode::VMAXCPDZrmb,
          12841 => Opcode::VMAXCPDZrmbk,
          12842 => Opcode::VMAXCPDZrmbkz,
          12843 => Opcode::VMAXCPDZrmk,
          12844 => Opcode::VMAXCPDZrmkz,
          12845 => Opcode::VMAXCPDZrr,
          12846 => Opcode::VMAXCPDZrrk,
          12847 => Opcode::VMAXCPDZrrkz,
          12848 => Opcode::VMAXCPDrm,
          12849 => Opcode::VMAXCPDrr,
          12850 => Opcode::VMAXCPHZ128rm,
          12851 => Opcode::VMAXCPHZ128rmb,
          12852 => Opcode::VMAXCPHZ128rmbk,
          12853 => Opcode::VMAXCPHZ128rmbkz,
          12854 => Opcode::VMAXCPHZ128rmk,
          12855 => Opcode::VMAXCPHZ128rmkz,
          12856 => Opcode::VMAXCPHZ128rr,
          12857 => Opcode::VMAXCPHZ128rrk,
          12858 => Opcode::VMAXCPHZ128rrkz,
          12859 => Opcode::VMAXCPHZ256rm,
          12860 => Opcode::VMAXCPHZ256rmb,
          12861 => Opcode::VMAXCPHZ256rmbk,
          12862 => Opcode::VMAXCPHZ256rmbkz,
          12863 => Opcode::VMAXCPHZ256rmk,
          12864 => Opcode::VMAXCPHZ256rmkz,
          12865 => Opcode::VMAXCPHZ256rr,
          12866 => Opcode::VMAXCPHZ256rrk,
          12867 => Opcode::VMAXCPHZ256rrkz,
          12868 => Opcode::VMAXCPHZrm,
          12869 => Opcode::VMAXCPHZrmb,
          12870 => Opcode::VMAXCPHZrmbk,
          12871 => Opcode::VMAXCPHZrmbkz,
          12872 => Opcode::VMAXCPHZrmk,
          12873 => Opcode::VMAXCPHZrmkz,
          12874 => Opcode::VMAXCPHZrr,
          12875 => Opcode::VMAXCPHZrrk,
          12876 => Opcode::VMAXCPHZrrkz,
          12877 => Opcode::VMAXCPSYrm,
          12878 => Opcode::VMAXCPSYrr,
          12879 => Opcode::VMAXCPSZ128rm,
          12880 => Opcode::VMAXCPSZ128rmb,
          12881 => Opcode::VMAXCPSZ128rmbk,
          12882 => Opcode::VMAXCPSZ128rmbkz,
          12883 => Opcode::VMAXCPSZ128rmk,
          12884 => Opcode::VMAXCPSZ128rmkz,
          12885 => Opcode::VMAXCPSZ128rr,
          12886 => Opcode::VMAXCPSZ128rrk,
          12887 => Opcode::VMAXCPSZ128rrkz,
          12888 => Opcode::VMAXCPSZ256rm,
          12889 => Opcode::VMAXCPSZ256rmb,
          12890 => Opcode::VMAXCPSZ256rmbk,
          12891 => Opcode::VMAXCPSZ256rmbkz,
          12892 => Opcode::VMAXCPSZ256rmk,
          12893 => Opcode::VMAXCPSZ256rmkz,
          12894 => Opcode::VMAXCPSZ256rr,
          12895 => Opcode::VMAXCPSZ256rrk,
          12896 => Opcode::VMAXCPSZ256rrkz,
          12897 => Opcode::VMAXCPSZrm,
          12898 => Opcode::VMAXCPSZrmb,
          12899 => Opcode::VMAXCPSZrmbk,
          12900 => Opcode::VMAXCPSZrmbkz,
          12901 => Opcode::VMAXCPSZrmk,
          12902 => Opcode::VMAXCPSZrmkz,
          12903 => Opcode::VMAXCPSZrr,
          12904 => Opcode::VMAXCPSZrrk,
          12905 => Opcode::VMAXCPSZrrkz,
          12906 => Opcode::VMAXCPSrm,
          12907 => Opcode::VMAXCPSrr,
          12908 => Opcode::VMAXCSDZrm,
          12909 => Opcode::VMAXCSDZrr,
          12910 => Opcode::VMAXCSDrm,
          12911 => Opcode::VMAXCSDrr,
          12912 => Opcode::VMAXCSHZrm,
          12913 => Opcode::VMAXCSHZrr,
          12914 => Opcode::VMAXCSSZrm,
          12915 => Opcode::VMAXCSSZrr,
          12916 => Opcode::VMAXCSSrm,
          12917 => Opcode::VMAXCSSrr,
          12918 => Opcode::VMAXPDYrm,
          12919 => Opcode::VMAXPDYrr,
          12920 => Opcode::VMAXPDZ128rm,
          12921 => Opcode::VMAXPDZ128rmb,
          12922 => Opcode::VMAXPDZ128rmbk,
          12923 => Opcode::VMAXPDZ128rmbkz,
          12924 => Opcode::VMAXPDZ128rmk,
          12925 => Opcode::VMAXPDZ128rmkz,
          12926 => Opcode::VMAXPDZ128rr,
          12927 => Opcode::VMAXPDZ128rrk,
          12928 => Opcode::VMAXPDZ128rrkz,
          12929 => Opcode::VMAXPDZ256rm,
          12930 => Opcode::VMAXPDZ256rmb,
          12931 => Opcode::VMAXPDZ256rmbk,
          12932 => Opcode::VMAXPDZ256rmbkz,
          12933 => Opcode::VMAXPDZ256rmk,
          12934 => Opcode::VMAXPDZ256rmkz,
          12935 => Opcode::VMAXPDZ256rr,
          12936 => Opcode::VMAXPDZ256rrk,
          12937 => Opcode::VMAXPDZ256rrkz,
          12938 => Opcode::VMAXPDZrm,
          12939 => Opcode::VMAXPDZrmb,
          12940 => Opcode::VMAXPDZrmbk,
          12941 => Opcode::VMAXPDZrmbkz,
          12942 => Opcode::VMAXPDZrmk,
          12943 => Opcode::VMAXPDZrmkz,
          12944 => Opcode::VMAXPDZrr,
          12945 => Opcode::VMAXPDZrrb,
          12946 => Opcode::VMAXPDZrrbk,
          12947 => Opcode::VMAXPDZrrbkz,
          12948 => Opcode::VMAXPDZrrk,
          12949 => Opcode::VMAXPDZrrkz,
          12950 => Opcode::VMAXPDrm,
          12951 => Opcode::VMAXPDrr,
          12952 => Opcode::VMAXPHZ128rm,
          12953 => Opcode::VMAXPHZ128rmb,
          12954 => Opcode::VMAXPHZ128rmbk,
          12955 => Opcode::VMAXPHZ128rmbkz,
          12956 => Opcode::VMAXPHZ128rmk,
          12957 => Opcode::VMAXPHZ128rmkz,
          12958 => Opcode::VMAXPHZ128rr,
          12959 => Opcode::VMAXPHZ128rrk,
          12960 => Opcode::VMAXPHZ128rrkz,
          12961 => Opcode::VMAXPHZ256rm,
          12962 => Opcode::VMAXPHZ256rmb,
          12963 => Opcode::VMAXPHZ256rmbk,
          12964 => Opcode::VMAXPHZ256rmbkz,
          12965 => Opcode::VMAXPHZ256rmk,
          12966 => Opcode::VMAXPHZ256rmkz,
          12967 => Opcode::VMAXPHZ256rr,
          12968 => Opcode::VMAXPHZ256rrk,
          12969 => Opcode::VMAXPHZ256rrkz,
          12970 => Opcode::VMAXPHZrm,
          12971 => Opcode::VMAXPHZrmb,
          12972 => Opcode::VMAXPHZrmbk,
          12973 => Opcode::VMAXPHZrmbkz,
          12974 => Opcode::VMAXPHZrmk,
          12975 => Opcode::VMAXPHZrmkz,
          12976 => Opcode::VMAXPHZrr,
          12977 => Opcode::VMAXPHZrrb,
          12978 => Opcode::VMAXPHZrrbk,
          12979 => Opcode::VMAXPHZrrbkz,
          12980 => Opcode::VMAXPHZrrk,
          12981 => Opcode::VMAXPHZrrkz,
          12982 => Opcode::VMAXPSYrm,
          12983 => Opcode::VMAXPSYrr,
          12984 => Opcode::VMAXPSZ128rm,
          12985 => Opcode::VMAXPSZ128rmb,
          12986 => Opcode::VMAXPSZ128rmbk,
          12987 => Opcode::VMAXPSZ128rmbkz,
          12988 => Opcode::VMAXPSZ128rmk,
          12989 => Opcode::VMAXPSZ128rmkz,
          12990 => Opcode::VMAXPSZ128rr,
          12991 => Opcode::VMAXPSZ128rrk,
          12992 => Opcode::VMAXPSZ128rrkz,
          12993 => Opcode::VMAXPSZ256rm,
          12994 => Opcode::VMAXPSZ256rmb,
          12995 => Opcode::VMAXPSZ256rmbk,
          12996 => Opcode::VMAXPSZ256rmbkz,
          12997 => Opcode::VMAXPSZ256rmk,
          12998 => Opcode::VMAXPSZ256rmkz,
          12999 => Opcode::VMAXPSZ256rr,
          13000 => Opcode::VMAXPSZ256rrk,
          13001 => Opcode::VMAXPSZ256rrkz,
          13002 => Opcode::VMAXPSZrm,
          13003 => Opcode::VMAXPSZrmb,
          13004 => Opcode::VMAXPSZrmbk,
          13005 => Opcode::VMAXPSZrmbkz,
          13006 => Opcode::VMAXPSZrmk,
          13007 => Opcode::VMAXPSZrmkz,
          13008 => Opcode::VMAXPSZrr,
          13009 => Opcode::VMAXPSZrrb,
          13010 => Opcode::VMAXPSZrrbk,
          13011 => Opcode::VMAXPSZrrbkz,
          13012 => Opcode::VMAXPSZrrk,
          13013 => Opcode::VMAXPSZrrkz,
          13014 => Opcode::VMAXPSrm,
          13015 => Opcode::VMAXPSrr,
          13016 => Opcode::VMAXSDZrm,
          13017 => Opcode::VMAXSDZrm_Int,
          13018 => Opcode::VMAXSDZrmk_Int,
          13019 => Opcode::VMAXSDZrmkz_Int,
          13020 => Opcode::VMAXSDZrr,
          13021 => Opcode::VMAXSDZrr_Int,
          13022 => Opcode::VMAXSDZrrb_Int,
          13023 => Opcode::VMAXSDZrrbk_Int,
          13024 => Opcode::VMAXSDZrrbkz_Int,
          13025 => Opcode::VMAXSDZrrk_Int,
          13026 => Opcode::VMAXSDZrrkz_Int,
          13027 => Opcode::VMAXSDrm,
          13028 => Opcode::VMAXSDrm_Int,
          13029 => Opcode::VMAXSDrr,
          13030 => Opcode::VMAXSDrr_Int,
          13031 => Opcode::VMAXSHZrm,
          13032 => Opcode::VMAXSHZrm_Int,
          13033 => Opcode::VMAXSHZrmk_Int,
          13034 => Opcode::VMAXSHZrmkz_Int,
          13035 => Opcode::VMAXSHZrr,
          13036 => Opcode::VMAXSHZrr_Int,
          13037 => Opcode::VMAXSHZrrb_Int,
          13038 => Opcode::VMAXSHZrrbk_Int,
          13039 => Opcode::VMAXSHZrrbkz_Int,
          13040 => Opcode::VMAXSHZrrk_Int,
          13041 => Opcode::VMAXSHZrrkz_Int,
          13042 => Opcode::VMAXSSZrm,
          13043 => Opcode::VMAXSSZrm_Int,
          13044 => Opcode::VMAXSSZrmk_Int,
          13045 => Opcode::VMAXSSZrmkz_Int,
          13046 => Opcode::VMAXSSZrr,
          13047 => Opcode::VMAXSSZrr_Int,
          13048 => Opcode::VMAXSSZrrb_Int,
          13049 => Opcode::VMAXSSZrrbk_Int,
          13050 => Opcode::VMAXSSZrrbkz_Int,
          13051 => Opcode::VMAXSSZrrk_Int,
          13052 => Opcode::VMAXSSZrrkz_Int,
          13053 => Opcode::VMAXSSrm,
          13054 => Opcode::VMAXSSrm_Int,
          13055 => Opcode::VMAXSSrr,
          13056 => Opcode::VMAXSSrr_Int,
          13057 => Opcode::VMCALL,
          13058 => Opcode::VMCLEARm,
          13059 => Opcode::VMFUNC,
          13060 => Opcode::VMINBF16Z128rm,
          13061 => Opcode::VMINBF16Z128rmb,
          13062 => Opcode::VMINBF16Z128rmbk,
          13063 => Opcode::VMINBF16Z128rmbkz,
          13064 => Opcode::VMINBF16Z128rmk,
          13065 => Opcode::VMINBF16Z128rmkz,
          13066 => Opcode::VMINBF16Z128rr,
          13067 => Opcode::VMINBF16Z128rrk,
          13068 => Opcode::VMINBF16Z128rrkz,
          13069 => Opcode::VMINBF16Z256rm,
          13070 => Opcode::VMINBF16Z256rmb,
          13071 => Opcode::VMINBF16Z256rmbk,
          13072 => Opcode::VMINBF16Z256rmbkz,
          13073 => Opcode::VMINBF16Z256rmk,
          13074 => Opcode::VMINBF16Z256rmkz,
          13075 => Opcode::VMINBF16Z256rr,
          13076 => Opcode::VMINBF16Z256rrk,
          13077 => Opcode::VMINBF16Z256rrkz,
          13078 => Opcode::VMINBF16Zrm,
          13079 => Opcode::VMINBF16Zrmb,
          13080 => Opcode::VMINBF16Zrmbk,
          13081 => Opcode::VMINBF16Zrmbkz,
          13082 => Opcode::VMINBF16Zrmk,
          13083 => Opcode::VMINBF16Zrmkz,
          13084 => Opcode::VMINBF16Zrr,
          13085 => Opcode::VMINBF16Zrrk,
          13086 => Opcode::VMINBF16Zrrkz,
          13087 => Opcode::VMINCPDYrm,
          13088 => Opcode::VMINCPDYrr,
          13089 => Opcode::VMINCPDZ128rm,
          13090 => Opcode::VMINCPDZ128rmb,
          13091 => Opcode::VMINCPDZ128rmbk,
          13092 => Opcode::VMINCPDZ128rmbkz,
          13093 => Opcode::VMINCPDZ128rmk,
          13094 => Opcode::VMINCPDZ128rmkz,
          13095 => Opcode::VMINCPDZ128rr,
          13096 => Opcode::VMINCPDZ128rrk,
          13097 => Opcode::VMINCPDZ128rrkz,
          13098 => Opcode::VMINCPDZ256rm,
          13099 => Opcode::VMINCPDZ256rmb,
          13100 => Opcode::VMINCPDZ256rmbk,
          13101 => Opcode::VMINCPDZ256rmbkz,
          13102 => Opcode::VMINCPDZ256rmk,
          13103 => Opcode::VMINCPDZ256rmkz,
          13104 => Opcode::VMINCPDZ256rr,
          13105 => Opcode::VMINCPDZ256rrk,
          13106 => Opcode::VMINCPDZ256rrkz,
          13107 => Opcode::VMINCPDZrm,
          13108 => Opcode::VMINCPDZrmb,
          13109 => Opcode::VMINCPDZrmbk,
          13110 => Opcode::VMINCPDZrmbkz,
          13111 => Opcode::VMINCPDZrmk,
          13112 => Opcode::VMINCPDZrmkz,
          13113 => Opcode::VMINCPDZrr,
          13114 => Opcode::VMINCPDZrrk,
          13115 => Opcode::VMINCPDZrrkz,
          13116 => Opcode::VMINCPDrm,
          13117 => Opcode::VMINCPDrr,
          13118 => Opcode::VMINCPHZ128rm,
          13119 => Opcode::VMINCPHZ128rmb,
          13120 => Opcode::VMINCPHZ128rmbk,
          13121 => Opcode::VMINCPHZ128rmbkz,
          13122 => Opcode::VMINCPHZ128rmk,
          13123 => Opcode::VMINCPHZ128rmkz,
          13124 => Opcode::VMINCPHZ128rr,
          13125 => Opcode::VMINCPHZ128rrk,
          13126 => Opcode::VMINCPHZ128rrkz,
          13127 => Opcode::VMINCPHZ256rm,
          13128 => Opcode::VMINCPHZ256rmb,
          13129 => Opcode::VMINCPHZ256rmbk,
          13130 => Opcode::VMINCPHZ256rmbkz,
          13131 => Opcode::VMINCPHZ256rmk,
          13132 => Opcode::VMINCPHZ256rmkz,
          13133 => Opcode::VMINCPHZ256rr,
          13134 => Opcode::VMINCPHZ256rrk,
          13135 => Opcode::VMINCPHZ256rrkz,
          13136 => Opcode::VMINCPHZrm,
          13137 => Opcode::VMINCPHZrmb,
          13138 => Opcode::VMINCPHZrmbk,
          13139 => Opcode::VMINCPHZrmbkz,
          13140 => Opcode::VMINCPHZrmk,
          13141 => Opcode::VMINCPHZrmkz,
          13142 => Opcode::VMINCPHZrr,
          13143 => Opcode::VMINCPHZrrk,
          13144 => Opcode::VMINCPHZrrkz,
          13145 => Opcode::VMINCPSYrm,
          13146 => Opcode::VMINCPSYrr,
          13147 => Opcode::VMINCPSZ128rm,
          13148 => Opcode::VMINCPSZ128rmb,
          13149 => Opcode::VMINCPSZ128rmbk,
          13150 => Opcode::VMINCPSZ128rmbkz,
          13151 => Opcode::VMINCPSZ128rmk,
          13152 => Opcode::VMINCPSZ128rmkz,
          13153 => Opcode::VMINCPSZ128rr,
          13154 => Opcode::VMINCPSZ128rrk,
          13155 => Opcode::VMINCPSZ128rrkz,
          13156 => Opcode::VMINCPSZ256rm,
          13157 => Opcode::VMINCPSZ256rmb,
          13158 => Opcode::VMINCPSZ256rmbk,
          13159 => Opcode::VMINCPSZ256rmbkz,
          13160 => Opcode::VMINCPSZ256rmk,
          13161 => Opcode::VMINCPSZ256rmkz,
          13162 => Opcode::VMINCPSZ256rr,
          13163 => Opcode::VMINCPSZ256rrk,
          13164 => Opcode::VMINCPSZ256rrkz,
          13165 => Opcode::VMINCPSZrm,
          13166 => Opcode::VMINCPSZrmb,
          13167 => Opcode::VMINCPSZrmbk,
          13168 => Opcode::VMINCPSZrmbkz,
          13169 => Opcode::VMINCPSZrmk,
          13170 => Opcode::VMINCPSZrmkz,
          13171 => Opcode::VMINCPSZrr,
          13172 => Opcode::VMINCPSZrrk,
          13173 => Opcode::VMINCPSZrrkz,
          13174 => Opcode::VMINCPSrm,
          13175 => Opcode::VMINCPSrr,
          13176 => Opcode::VMINCSDZrm,
          13177 => Opcode::VMINCSDZrr,
          13178 => Opcode::VMINCSDrm,
          13179 => Opcode::VMINCSDrr,
          13180 => Opcode::VMINCSHZrm,
          13181 => Opcode::VMINCSHZrr,
          13182 => Opcode::VMINCSSZrm,
          13183 => Opcode::VMINCSSZrr,
          13184 => Opcode::VMINCSSrm,
          13185 => Opcode::VMINCSSrr,
          13186 => Opcode::VMINMAXBF16Z128rmbi,
          13187 => Opcode::VMINMAXBF16Z128rmbik,
          13188 => Opcode::VMINMAXBF16Z128rmbikz,
          13189 => Opcode::VMINMAXBF16Z128rmi,
          13190 => Opcode::VMINMAXBF16Z128rmik,
          13191 => Opcode::VMINMAXBF16Z128rmikz,
          13192 => Opcode::VMINMAXBF16Z128rri,
          13193 => Opcode::VMINMAXBF16Z128rrik,
          13194 => Opcode::VMINMAXBF16Z128rrikz,
          13195 => Opcode::VMINMAXBF16Z256rmbi,
          13196 => Opcode::VMINMAXBF16Z256rmbik,
          13197 => Opcode::VMINMAXBF16Z256rmbikz,
          13198 => Opcode::VMINMAXBF16Z256rmi,
          13199 => Opcode::VMINMAXBF16Z256rmik,
          13200 => Opcode::VMINMAXBF16Z256rmikz,
          13201 => Opcode::VMINMAXBF16Z256rri,
          13202 => Opcode::VMINMAXBF16Z256rrik,
          13203 => Opcode::VMINMAXBF16Z256rrikz,
          13204 => Opcode::VMINMAXBF16Zrmbi,
          13205 => Opcode::VMINMAXBF16Zrmbik,
          13206 => Opcode::VMINMAXBF16Zrmbikz,
          13207 => Opcode::VMINMAXBF16Zrmi,
          13208 => Opcode::VMINMAXBF16Zrmik,
          13209 => Opcode::VMINMAXBF16Zrmikz,
          13210 => Opcode::VMINMAXBF16Zrri,
          13211 => Opcode::VMINMAXBF16Zrrik,
          13212 => Opcode::VMINMAXBF16Zrrikz,
          13213 => Opcode::VMINMAXPDZ128rmbi,
          13214 => Opcode::VMINMAXPDZ128rmbik,
          13215 => Opcode::VMINMAXPDZ128rmbikz,
          13216 => Opcode::VMINMAXPDZ128rmi,
          13217 => Opcode::VMINMAXPDZ128rmik,
          13218 => Opcode::VMINMAXPDZ128rmikz,
          13219 => Opcode::VMINMAXPDZ128rri,
          13220 => Opcode::VMINMAXPDZ128rrik,
          13221 => Opcode::VMINMAXPDZ128rrikz,
          13222 => Opcode::VMINMAXPDZ256rmbi,
          13223 => Opcode::VMINMAXPDZ256rmbik,
          13224 => Opcode::VMINMAXPDZ256rmbikz,
          13225 => Opcode::VMINMAXPDZ256rmi,
          13226 => Opcode::VMINMAXPDZ256rmik,
          13227 => Opcode::VMINMAXPDZ256rmikz,
          13228 => Opcode::VMINMAXPDZ256rri,
          13229 => Opcode::VMINMAXPDZ256rrik,
          13230 => Opcode::VMINMAXPDZ256rrikz,
          13231 => Opcode::VMINMAXPDZrmbi,
          13232 => Opcode::VMINMAXPDZrmbik,
          13233 => Opcode::VMINMAXPDZrmbikz,
          13234 => Opcode::VMINMAXPDZrmi,
          13235 => Opcode::VMINMAXPDZrmik,
          13236 => Opcode::VMINMAXPDZrmikz,
          13237 => Opcode::VMINMAXPDZrri,
          13238 => Opcode::VMINMAXPDZrrib,
          13239 => Opcode::VMINMAXPDZrribk,
          13240 => Opcode::VMINMAXPDZrribkz,
          13241 => Opcode::VMINMAXPDZrrik,
          13242 => Opcode::VMINMAXPDZrrikz,
          13243 => Opcode::VMINMAXPHZ128rmbi,
          13244 => Opcode::VMINMAXPHZ128rmbik,
          13245 => Opcode::VMINMAXPHZ128rmbikz,
          13246 => Opcode::VMINMAXPHZ128rmi,
          13247 => Opcode::VMINMAXPHZ128rmik,
          13248 => Opcode::VMINMAXPHZ128rmikz,
          13249 => Opcode::VMINMAXPHZ128rri,
          13250 => Opcode::VMINMAXPHZ128rrik,
          13251 => Opcode::VMINMAXPHZ128rrikz,
          13252 => Opcode::VMINMAXPHZ256rmbi,
          13253 => Opcode::VMINMAXPHZ256rmbik,
          13254 => Opcode::VMINMAXPHZ256rmbikz,
          13255 => Opcode::VMINMAXPHZ256rmi,
          13256 => Opcode::VMINMAXPHZ256rmik,
          13257 => Opcode::VMINMAXPHZ256rmikz,
          13258 => Opcode::VMINMAXPHZ256rri,
          13259 => Opcode::VMINMAXPHZ256rrik,
          13260 => Opcode::VMINMAXPHZ256rrikz,
          13261 => Opcode::VMINMAXPHZrmbi,
          13262 => Opcode::VMINMAXPHZrmbik,
          13263 => Opcode::VMINMAXPHZrmbikz,
          13264 => Opcode::VMINMAXPHZrmi,
          13265 => Opcode::VMINMAXPHZrmik,
          13266 => Opcode::VMINMAXPHZrmikz,
          13267 => Opcode::VMINMAXPHZrri,
          13268 => Opcode::VMINMAXPHZrrib,
          13269 => Opcode::VMINMAXPHZrribk,
          13270 => Opcode::VMINMAXPHZrribkz,
          13271 => Opcode::VMINMAXPHZrrik,
          13272 => Opcode::VMINMAXPHZrrikz,
          13273 => Opcode::VMINMAXPSZ128rmbi,
          13274 => Opcode::VMINMAXPSZ128rmbik,
          13275 => Opcode::VMINMAXPSZ128rmbikz,
          13276 => Opcode::VMINMAXPSZ128rmi,
          13277 => Opcode::VMINMAXPSZ128rmik,
          13278 => Opcode::VMINMAXPSZ128rmikz,
          13279 => Opcode::VMINMAXPSZ128rri,
          13280 => Opcode::VMINMAXPSZ128rrik,
          13281 => Opcode::VMINMAXPSZ128rrikz,
          13282 => Opcode::VMINMAXPSZ256rmbi,
          13283 => Opcode::VMINMAXPSZ256rmbik,
          13284 => Opcode::VMINMAXPSZ256rmbikz,
          13285 => Opcode::VMINMAXPSZ256rmi,
          13286 => Opcode::VMINMAXPSZ256rmik,
          13287 => Opcode::VMINMAXPSZ256rmikz,
          13288 => Opcode::VMINMAXPSZ256rri,
          13289 => Opcode::VMINMAXPSZ256rrik,
          13290 => Opcode::VMINMAXPSZ256rrikz,
          13291 => Opcode::VMINMAXPSZrmbi,
          13292 => Opcode::VMINMAXPSZrmbik,
          13293 => Opcode::VMINMAXPSZrmbikz,
          13294 => Opcode::VMINMAXPSZrmi,
          13295 => Opcode::VMINMAXPSZrmik,
          13296 => Opcode::VMINMAXPSZrmikz,
          13297 => Opcode::VMINMAXPSZrri,
          13298 => Opcode::VMINMAXPSZrrib,
          13299 => Opcode::VMINMAXPSZrribk,
          13300 => Opcode::VMINMAXPSZrribkz,
          13301 => Opcode::VMINMAXPSZrrik,
          13302 => Opcode::VMINMAXPSZrrikz,
          13303 => Opcode::VMINMAXSDrmi,
          13304 => Opcode::VMINMAXSDrmi_Int,
          13305 => Opcode::VMINMAXSDrmik_Int,
          13306 => Opcode::VMINMAXSDrmikz_Int,
          13307 => Opcode::VMINMAXSDrri,
          13308 => Opcode::VMINMAXSDrri_Int,
          13309 => Opcode::VMINMAXSDrrib_Int,
          13310 => Opcode::VMINMAXSDrribk_Int,
          13311 => Opcode::VMINMAXSDrribkz_Int,
          13312 => Opcode::VMINMAXSDrrik_Int,
          13313 => Opcode::VMINMAXSDrrikz_Int,
          13314 => Opcode::VMINMAXSHrmi,
          13315 => Opcode::VMINMAXSHrmi_Int,
          13316 => Opcode::VMINMAXSHrmik_Int,
          13317 => Opcode::VMINMAXSHrmikz_Int,
          13318 => Opcode::VMINMAXSHrri,
          13319 => Opcode::VMINMAXSHrri_Int,
          13320 => Opcode::VMINMAXSHrrib_Int,
          13321 => Opcode::VMINMAXSHrribk_Int,
          13322 => Opcode::VMINMAXSHrribkz_Int,
          13323 => Opcode::VMINMAXSHrrik_Int,
          13324 => Opcode::VMINMAXSHrrikz_Int,
          13325 => Opcode::VMINMAXSSrmi,
          13326 => Opcode::VMINMAXSSrmi_Int,
          13327 => Opcode::VMINMAXSSrmik_Int,
          13328 => Opcode::VMINMAXSSrmikz_Int,
          13329 => Opcode::VMINMAXSSrri,
          13330 => Opcode::VMINMAXSSrri_Int,
          13331 => Opcode::VMINMAXSSrrib_Int,
          13332 => Opcode::VMINMAXSSrribk_Int,
          13333 => Opcode::VMINMAXSSrribkz_Int,
          13334 => Opcode::VMINMAXSSrrik_Int,
          13335 => Opcode::VMINMAXSSrrikz_Int,
          13336 => Opcode::VMINPDYrm,
          13337 => Opcode::VMINPDYrr,
          13338 => Opcode::VMINPDZ128rm,
          13339 => Opcode::VMINPDZ128rmb,
          13340 => Opcode::VMINPDZ128rmbk,
          13341 => Opcode::VMINPDZ128rmbkz,
          13342 => Opcode::VMINPDZ128rmk,
          13343 => Opcode::VMINPDZ128rmkz,
          13344 => Opcode::VMINPDZ128rr,
          13345 => Opcode::VMINPDZ128rrk,
          13346 => Opcode::VMINPDZ128rrkz,
          13347 => Opcode::VMINPDZ256rm,
          13348 => Opcode::VMINPDZ256rmb,
          13349 => Opcode::VMINPDZ256rmbk,
          13350 => Opcode::VMINPDZ256rmbkz,
          13351 => Opcode::VMINPDZ256rmk,
          13352 => Opcode::VMINPDZ256rmkz,
          13353 => Opcode::VMINPDZ256rr,
          13354 => Opcode::VMINPDZ256rrk,
          13355 => Opcode::VMINPDZ256rrkz,
          13356 => Opcode::VMINPDZrm,
          13357 => Opcode::VMINPDZrmb,
          13358 => Opcode::VMINPDZrmbk,
          13359 => Opcode::VMINPDZrmbkz,
          13360 => Opcode::VMINPDZrmk,
          13361 => Opcode::VMINPDZrmkz,
          13362 => Opcode::VMINPDZrr,
          13363 => Opcode::VMINPDZrrb,
          13364 => Opcode::VMINPDZrrbk,
          13365 => Opcode::VMINPDZrrbkz,
          13366 => Opcode::VMINPDZrrk,
          13367 => Opcode::VMINPDZrrkz,
          13368 => Opcode::VMINPDrm,
          13369 => Opcode::VMINPDrr,
          13370 => Opcode::VMINPHZ128rm,
          13371 => Opcode::VMINPHZ128rmb,
          13372 => Opcode::VMINPHZ128rmbk,
          13373 => Opcode::VMINPHZ128rmbkz,
          13374 => Opcode::VMINPHZ128rmk,
          13375 => Opcode::VMINPHZ128rmkz,
          13376 => Opcode::VMINPHZ128rr,
          13377 => Opcode::VMINPHZ128rrk,
          13378 => Opcode::VMINPHZ128rrkz,
          13379 => Opcode::VMINPHZ256rm,
          13380 => Opcode::VMINPHZ256rmb,
          13381 => Opcode::VMINPHZ256rmbk,
          13382 => Opcode::VMINPHZ256rmbkz,
          13383 => Opcode::VMINPHZ256rmk,
          13384 => Opcode::VMINPHZ256rmkz,
          13385 => Opcode::VMINPHZ256rr,
          13386 => Opcode::VMINPHZ256rrk,
          13387 => Opcode::VMINPHZ256rrkz,
          13388 => Opcode::VMINPHZrm,
          13389 => Opcode::VMINPHZrmb,
          13390 => Opcode::VMINPHZrmbk,
          13391 => Opcode::VMINPHZrmbkz,
          13392 => Opcode::VMINPHZrmk,
          13393 => Opcode::VMINPHZrmkz,
          13394 => Opcode::VMINPHZrr,
          13395 => Opcode::VMINPHZrrb,
          13396 => Opcode::VMINPHZrrbk,
          13397 => Opcode::VMINPHZrrbkz,
          13398 => Opcode::VMINPHZrrk,
          13399 => Opcode::VMINPHZrrkz,
          13400 => Opcode::VMINPSYrm,
          13401 => Opcode::VMINPSYrr,
          13402 => Opcode::VMINPSZ128rm,
          13403 => Opcode::VMINPSZ128rmb,
          13404 => Opcode::VMINPSZ128rmbk,
          13405 => Opcode::VMINPSZ128rmbkz,
          13406 => Opcode::VMINPSZ128rmk,
          13407 => Opcode::VMINPSZ128rmkz,
          13408 => Opcode::VMINPSZ128rr,
          13409 => Opcode::VMINPSZ128rrk,
          13410 => Opcode::VMINPSZ128rrkz,
          13411 => Opcode::VMINPSZ256rm,
          13412 => Opcode::VMINPSZ256rmb,
          13413 => Opcode::VMINPSZ256rmbk,
          13414 => Opcode::VMINPSZ256rmbkz,
          13415 => Opcode::VMINPSZ256rmk,
          13416 => Opcode::VMINPSZ256rmkz,
          13417 => Opcode::VMINPSZ256rr,
          13418 => Opcode::VMINPSZ256rrk,
          13419 => Opcode::VMINPSZ256rrkz,
          13420 => Opcode::VMINPSZrm,
          13421 => Opcode::VMINPSZrmb,
          13422 => Opcode::VMINPSZrmbk,
          13423 => Opcode::VMINPSZrmbkz,
          13424 => Opcode::VMINPSZrmk,
          13425 => Opcode::VMINPSZrmkz,
          13426 => Opcode::VMINPSZrr,
          13427 => Opcode::VMINPSZrrb,
          13428 => Opcode::VMINPSZrrbk,
          13429 => Opcode::VMINPSZrrbkz,
          13430 => Opcode::VMINPSZrrk,
          13431 => Opcode::VMINPSZrrkz,
          13432 => Opcode::VMINPSrm,
          13433 => Opcode::VMINPSrr,
          13434 => Opcode::VMINSDZrm,
          13435 => Opcode::VMINSDZrm_Int,
          13436 => Opcode::VMINSDZrmk_Int,
          13437 => Opcode::VMINSDZrmkz_Int,
          13438 => Opcode::VMINSDZrr,
          13439 => Opcode::VMINSDZrr_Int,
          13440 => Opcode::VMINSDZrrb_Int,
          13441 => Opcode::VMINSDZrrbk_Int,
          13442 => Opcode::VMINSDZrrbkz_Int,
          13443 => Opcode::VMINSDZrrk_Int,
          13444 => Opcode::VMINSDZrrkz_Int,
          13445 => Opcode::VMINSDrm,
          13446 => Opcode::VMINSDrm_Int,
          13447 => Opcode::VMINSDrr,
          13448 => Opcode::VMINSDrr_Int,
          13449 => Opcode::VMINSHZrm,
          13450 => Opcode::VMINSHZrm_Int,
          13451 => Opcode::VMINSHZrmk_Int,
          13452 => Opcode::VMINSHZrmkz_Int,
          13453 => Opcode::VMINSHZrr,
          13454 => Opcode::VMINSHZrr_Int,
          13455 => Opcode::VMINSHZrrb_Int,
          13456 => Opcode::VMINSHZrrbk_Int,
          13457 => Opcode::VMINSHZrrbkz_Int,
          13458 => Opcode::VMINSHZrrk_Int,
          13459 => Opcode::VMINSHZrrkz_Int,
          13460 => Opcode::VMINSSZrm,
          13461 => Opcode::VMINSSZrm_Int,
          13462 => Opcode::VMINSSZrmk_Int,
          13463 => Opcode::VMINSSZrmkz_Int,
          13464 => Opcode::VMINSSZrr,
          13465 => Opcode::VMINSSZrr_Int,
          13466 => Opcode::VMINSSZrrb_Int,
          13467 => Opcode::VMINSSZrrbk_Int,
          13468 => Opcode::VMINSSZrrbkz_Int,
          13469 => Opcode::VMINSSZrrk_Int,
          13470 => Opcode::VMINSSZrrkz_Int,
          13471 => Opcode::VMINSSrm,
          13472 => Opcode::VMINSSrm_Int,
          13473 => Opcode::VMINSSrr,
          13474 => Opcode::VMINSSrr_Int,
          13475 => Opcode::VMLAUNCH,
          13476 => Opcode::VMLOAD32,
          13477 => Opcode::VMLOAD64,
          13478 => Opcode::VMMCALL,
          13479 => Opcode::VMOV64toPQIZrm,
          13480 => Opcode::VMOV64toPQIZrr,
          13481 => Opcode::VMOV64toPQIrm,
          13482 => Opcode::VMOV64toPQIrr,
          13483 => Opcode::VMOV64toSDZrr,
          13484 => Opcode::VMOV64toSDrr,
          13485 => Opcode::VMOVAPDYmr,
          13486 => Opcode::VMOVAPDYrm,
          13487 => Opcode::VMOVAPDYrr,
          13488 => Opcode::VMOVAPDYrr_REV,
          13489 => Opcode::VMOVAPDZ128mr,
          13490 => Opcode::VMOVAPDZ128mrk,
          13491 => Opcode::VMOVAPDZ128rm,
          13492 => Opcode::VMOVAPDZ128rmk,
          13493 => Opcode::VMOVAPDZ128rmkz,
          13494 => Opcode::VMOVAPDZ128rr,
          13495 => Opcode::VMOVAPDZ128rr_REV,
          13496 => Opcode::VMOVAPDZ128rrk,
          13497 => Opcode::VMOVAPDZ128rrk_REV,
          13498 => Opcode::VMOVAPDZ128rrkz,
          13499 => Opcode::VMOVAPDZ128rrkz_REV,
          13500 => Opcode::VMOVAPDZ256mr,
          13501 => Opcode::VMOVAPDZ256mrk,
          13502 => Opcode::VMOVAPDZ256rm,
          13503 => Opcode::VMOVAPDZ256rmk,
          13504 => Opcode::VMOVAPDZ256rmkz,
          13505 => Opcode::VMOVAPDZ256rr,
          13506 => Opcode::VMOVAPDZ256rr_REV,
          13507 => Opcode::VMOVAPDZ256rrk,
          13508 => Opcode::VMOVAPDZ256rrk_REV,
          13509 => Opcode::VMOVAPDZ256rrkz,
          13510 => Opcode::VMOVAPDZ256rrkz_REV,
          13511 => Opcode::VMOVAPDZmr,
          13512 => Opcode::VMOVAPDZmrk,
          13513 => Opcode::VMOVAPDZrm,
          13514 => Opcode::VMOVAPDZrmk,
          13515 => Opcode::VMOVAPDZrmkz,
          13516 => Opcode::VMOVAPDZrr,
          13517 => Opcode::VMOVAPDZrr_REV,
          13518 => Opcode::VMOVAPDZrrk,
          13519 => Opcode::VMOVAPDZrrk_REV,
          13520 => Opcode::VMOVAPDZrrkz,
          13521 => Opcode::VMOVAPDZrrkz_REV,
          13522 => Opcode::VMOVAPDmr,
          13523 => Opcode::VMOVAPDrm,
          13524 => Opcode::VMOVAPDrr,
          13525 => Opcode::VMOVAPDrr_REV,
          13526 => Opcode::VMOVAPSYmr,
          13527 => Opcode::VMOVAPSYrm,
          13528 => Opcode::VMOVAPSYrr,
          13529 => Opcode::VMOVAPSYrr_REV,
          13530 => Opcode::VMOVAPSZ128mr,
          13531 => Opcode::VMOVAPSZ128mrk,
          13532 => Opcode::VMOVAPSZ128rm,
          13533 => Opcode::VMOVAPSZ128rmk,
          13534 => Opcode::VMOVAPSZ128rmkz,
          13535 => Opcode::VMOVAPSZ128rr,
          13536 => Opcode::VMOVAPSZ128rr_REV,
          13537 => Opcode::VMOVAPSZ128rrk,
          13538 => Opcode::VMOVAPSZ128rrk_REV,
          13539 => Opcode::VMOVAPSZ128rrkz,
          13540 => Opcode::VMOVAPSZ128rrkz_REV,
          13541 => Opcode::VMOVAPSZ256mr,
          13542 => Opcode::VMOVAPSZ256mrk,
          13543 => Opcode::VMOVAPSZ256rm,
          13544 => Opcode::VMOVAPSZ256rmk,
          13545 => Opcode::VMOVAPSZ256rmkz,
          13546 => Opcode::VMOVAPSZ256rr,
          13547 => Opcode::VMOVAPSZ256rr_REV,
          13548 => Opcode::VMOVAPSZ256rrk,
          13549 => Opcode::VMOVAPSZ256rrk_REV,
          13550 => Opcode::VMOVAPSZ256rrkz,
          13551 => Opcode::VMOVAPSZ256rrkz_REV,
          13552 => Opcode::VMOVAPSZmr,
          13553 => Opcode::VMOVAPSZmrk,
          13554 => Opcode::VMOVAPSZrm,
          13555 => Opcode::VMOVAPSZrmk,
          13556 => Opcode::VMOVAPSZrmkz,
          13557 => Opcode::VMOVAPSZrr,
          13558 => Opcode::VMOVAPSZrr_REV,
          13559 => Opcode::VMOVAPSZrrk,
          13560 => Opcode::VMOVAPSZrrk_REV,
          13561 => Opcode::VMOVAPSZrrkz,
          13562 => Opcode::VMOVAPSZrrkz_REV,
          13563 => Opcode::VMOVAPSmr,
          13564 => Opcode::VMOVAPSrm,
          13565 => Opcode::VMOVAPSrr,
          13566 => Opcode::VMOVAPSrr_REV,
          13567 => Opcode::VMOVDDUPYrm,
          13568 => Opcode::VMOVDDUPYrr,
          13569 => Opcode::VMOVDDUPZ128rm,
          13570 => Opcode::VMOVDDUPZ128rmk,
          13571 => Opcode::VMOVDDUPZ128rmkz,
          13572 => Opcode::VMOVDDUPZ128rr,
          13573 => Opcode::VMOVDDUPZ128rrk,
          13574 => Opcode::VMOVDDUPZ128rrkz,
          13575 => Opcode::VMOVDDUPZ256rm,
          13576 => Opcode::VMOVDDUPZ256rmk,
          13577 => Opcode::VMOVDDUPZ256rmkz,
          13578 => Opcode::VMOVDDUPZ256rr,
          13579 => Opcode::VMOVDDUPZ256rrk,
          13580 => Opcode::VMOVDDUPZ256rrkz,
          13581 => Opcode::VMOVDDUPZrm,
          13582 => Opcode::VMOVDDUPZrmk,
          13583 => Opcode::VMOVDDUPZrmkz,
          13584 => Opcode::VMOVDDUPZrr,
          13585 => Opcode::VMOVDDUPZrrk,
          13586 => Opcode::VMOVDDUPZrrkz,
          13587 => Opcode::VMOVDDUPrm,
          13588 => Opcode::VMOVDDUPrr,
          13589 => Opcode::VMOVDI2PDIZrm,
          13590 => Opcode::VMOVDI2PDIZrr,
          13591 => Opcode::VMOVDI2PDIrm,
          13592 => Opcode::VMOVDI2PDIrr,
          13593 => Opcode::VMOVDI2SSZrr,
          13594 => Opcode::VMOVDI2SSrr,
          13595 => Opcode::VMOVDQA32Z128mr,
          13596 => Opcode::VMOVDQA32Z128mrk,
          13597 => Opcode::VMOVDQA32Z128rm,
          13598 => Opcode::VMOVDQA32Z128rmk,
          13599 => Opcode::VMOVDQA32Z128rmkz,
          13600 => Opcode::VMOVDQA32Z128rr,
          13601 => Opcode::VMOVDQA32Z128rr_REV,
          13602 => Opcode::VMOVDQA32Z128rrk,
          13603 => Opcode::VMOVDQA32Z128rrk_REV,
          13604 => Opcode::VMOVDQA32Z128rrkz,
          13605 => Opcode::VMOVDQA32Z128rrkz_REV,
          13606 => Opcode::VMOVDQA32Z256mr,
          13607 => Opcode::VMOVDQA32Z256mrk,
          13608 => Opcode::VMOVDQA32Z256rm,
          13609 => Opcode::VMOVDQA32Z256rmk,
          13610 => Opcode::VMOVDQA32Z256rmkz,
          13611 => Opcode::VMOVDQA32Z256rr,
          13612 => Opcode::VMOVDQA32Z256rr_REV,
          13613 => Opcode::VMOVDQA32Z256rrk,
          13614 => Opcode::VMOVDQA32Z256rrk_REV,
          13615 => Opcode::VMOVDQA32Z256rrkz,
          13616 => Opcode::VMOVDQA32Z256rrkz_REV,
          13617 => Opcode::VMOVDQA32Zmr,
          13618 => Opcode::VMOVDQA32Zmrk,
          13619 => Opcode::VMOVDQA32Zrm,
          13620 => Opcode::VMOVDQA32Zrmk,
          13621 => Opcode::VMOVDQA32Zrmkz,
          13622 => Opcode::VMOVDQA32Zrr,
          13623 => Opcode::VMOVDQA32Zrr_REV,
          13624 => Opcode::VMOVDQA32Zrrk,
          13625 => Opcode::VMOVDQA32Zrrk_REV,
          13626 => Opcode::VMOVDQA32Zrrkz,
          13627 => Opcode::VMOVDQA32Zrrkz_REV,
          13628 => Opcode::VMOVDQA64Z128mr,
          13629 => Opcode::VMOVDQA64Z128mrk,
          13630 => Opcode::VMOVDQA64Z128rm,
          13631 => Opcode::VMOVDQA64Z128rmk,
          13632 => Opcode::VMOVDQA64Z128rmkz,
          13633 => Opcode::VMOVDQA64Z128rr,
          13634 => Opcode::VMOVDQA64Z128rr_REV,
          13635 => Opcode::VMOVDQA64Z128rrk,
          13636 => Opcode::VMOVDQA64Z128rrk_REV,
          13637 => Opcode::VMOVDQA64Z128rrkz,
          13638 => Opcode::VMOVDQA64Z128rrkz_REV,
          13639 => Opcode::VMOVDQA64Z256mr,
          13640 => Opcode::VMOVDQA64Z256mrk,
          13641 => Opcode::VMOVDQA64Z256rm,
          13642 => Opcode::VMOVDQA64Z256rmk,
          13643 => Opcode::VMOVDQA64Z256rmkz,
          13644 => Opcode::VMOVDQA64Z256rr,
          13645 => Opcode::VMOVDQA64Z256rr_REV,
          13646 => Opcode::VMOVDQA64Z256rrk,
          13647 => Opcode::VMOVDQA64Z256rrk_REV,
          13648 => Opcode::VMOVDQA64Z256rrkz,
          13649 => Opcode::VMOVDQA64Z256rrkz_REV,
          13650 => Opcode::VMOVDQA64Zmr,
          13651 => Opcode::VMOVDQA64Zmrk,
          13652 => Opcode::VMOVDQA64Zrm,
          13653 => Opcode::VMOVDQA64Zrmk,
          13654 => Opcode::VMOVDQA64Zrmkz,
          13655 => Opcode::VMOVDQA64Zrr,
          13656 => Opcode::VMOVDQA64Zrr_REV,
          13657 => Opcode::VMOVDQA64Zrrk,
          13658 => Opcode::VMOVDQA64Zrrk_REV,
          13659 => Opcode::VMOVDQA64Zrrkz,
          13660 => Opcode::VMOVDQA64Zrrkz_REV,
          13661 => Opcode::VMOVDQAYmr,
          13662 => Opcode::VMOVDQAYrm,
          13663 => Opcode::VMOVDQAYrr,
          13664 => Opcode::VMOVDQAYrr_REV,
          13665 => Opcode::VMOVDQAmr,
          13666 => Opcode::VMOVDQArm,
          13667 => Opcode::VMOVDQArr,
          13668 => Opcode::VMOVDQArr_REV,
          13669 => Opcode::VMOVDQU16Z128mr,
          13670 => Opcode::VMOVDQU16Z128mrk,
          13671 => Opcode::VMOVDQU16Z128rm,
          13672 => Opcode::VMOVDQU16Z128rmk,
          13673 => Opcode::VMOVDQU16Z128rmkz,
          13674 => Opcode::VMOVDQU16Z128rr,
          13675 => Opcode::VMOVDQU16Z128rr_REV,
          13676 => Opcode::VMOVDQU16Z128rrk,
          13677 => Opcode::VMOVDQU16Z128rrk_REV,
          13678 => Opcode::VMOVDQU16Z128rrkz,
          13679 => Opcode::VMOVDQU16Z128rrkz_REV,
          13680 => Opcode::VMOVDQU16Z256mr,
          13681 => Opcode::VMOVDQU16Z256mrk,
          13682 => Opcode::VMOVDQU16Z256rm,
          13683 => Opcode::VMOVDQU16Z256rmk,
          13684 => Opcode::VMOVDQU16Z256rmkz,
          13685 => Opcode::VMOVDQU16Z256rr,
          13686 => Opcode::VMOVDQU16Z256rr_REV,
          13687 => Opcode::VMOVDQU16Z256rrk,
          13688 => Opcode::VMOVDQU16Z256rrk_REV,
          13689 => Opcode::VMOVDQU16Z256rrkz,
          13690 => Opcode::VMOVDQU16Z256rrkz_REV,
          13691 => Opcode::VMOVDQU16Zmr,
          13692 => Opcode::VMOVDQU16Zmrk,
          13693 => Opcode::VMOVDQU16Zrm,
          13694 => Opcode::VMOVDQU16Zrmk,
          13695 => Opcode::VMOVDQU16Zrmkz,
          13696 => Opcode::VMOVDQU16Zrr,
          13697 => Opcode::VMOVDQU16Zrr_REV,
          13698 => Opcode::VMOVDQU16Zrrk,
          13699 => Opcode::VMOVDQU16Zrrk_REV,
          13700 => Opcode::VMOVDQU16Zrrkz,
          13701 => Opcode::VMOVDQU16Zrrkz_REV,
          13702 => Opcode::VMOVDQU32Z128mr,
          13703 => Opcode::VMOVDQU32Z128mrk,
          13704 => Opcode::VMOVDQU32Z128rm,
          13705 => Opcode::VMOVDQU32Z128rmk,
          13706 => Opcode::VMOVDQU32Z128rmkz,
          13707 => Opcode::VMOVDQU32Z128rr,
          13708 => Opcode::VMOVDQU32Z128rr_REV,
          13709 => Opcode::VMOVDQU32Z128rrk,
          13710 => Opcode::VMOVDQU32Z128rrk_REV,
          13711 => Opcode::VMOVDQU32Z128rrkz,
          13712 => Opcode::VMOVDQU32Z128rrkz_REV,
          13713 => Opcode::VMOVDQU32Z256mr,
          13714 => Opcode::VMOVDQU32Z256mrk,
          13715 => Opcode::VMOVDQU32Z256rm,
          13716 => Opcode::VMOVDQU32Z256rmk,
          13717 => Opcode::VMOVDQU32Z256rmkz,
          13718 => Opcode::VMOVDQU32Z256rr,
          13719 => Opcode::VMOVDQU32Z256rr_REV,
          13720 => Opcode::VMOVDQU32Z256rrk,
          13721 => Opcode::VMOVDQU32Z256rrk_REV,
          13722 => Opcode::VMOVDQU32Z256rrkz,
          13723 => Opcode::VMOVDQU32Z256rrkz_REV,
          13724 => Opcode::VMOVDQU32Zmr,
          13725 => Opcode::VMOVDQU32Zmrk,
          13726 => Opcode::VMOVDQU32Zrm,
          13727 => Opcode::VMOVDQU32Zrmk,
          13728 => Opcode::VMOVDQU32Zrmkz,
          13729 => Opcode::VMOVDQU32Zrr,
          13730 => Opcode::VMOVDQU32Zrr_REV,
          13731 => Opcode::VMOVDQU32Zrrk,
          13732 => Opcode::VMOVDQU32Zrrk_REV,
          13733 => Opcode::VMOVDQU32Zrrkz,
          13734 => Opcode::VMOVDQU32Zrrkz_REV,
          13735 => Opcode::VMOVDQU64Z128mr,
          13736 => Opcode::VMOVDQU64Z128mrk,
          13737 => Opcode::VMOVDQU64Z128rm,
          13738 => Opcode::VMOVDQU64Z128rmk,
          13739 => Opcode::VMOVDQU64Z128rmkz,
          13740 => Opcode::VMOVDQU64Z128rr,
          13741 => Opcode::VMOVDQU64Z128rr_REV,
          13742 => Opcode::VMOVDQU64Z128rrk,
          13743 => Opcode::VMOVDQU64Z128rrk_REV,
          13744 => Opcode::VMOVDQU64Z128rrkz,
          13745 => Opcode::VMOVDQU64Z128rrkz_REV,
          13746 => Opcode::VMOVDQU64Z256mr,
          13747 => Opcode::VMOVDQU64Z256mrk,
          13748 => Opcode::VMOVDQU64Z256rm,
          13749 => Opcode::VMOVDQU64Z256rmk,
          13750 => Opcode::VMOVDQU64Z256rmkz,
          13751 => Opcode::VMOVDQU64Z256rr,
          13752 => Opcode::VMOVDQU64Z256rr_REV,
          13753 => Opcode::VMOVDQU64Z256rrk,
          13754 => Opcode::VMOVDQU64Z256rrk_REV,
          13755 => Opcode::VMOVDQU64Z256rrkz,
          13756 => Opcode::VMOVDQU64Z256rrkz_REV,
          13757 => Opcode::VMOVDQU64Zmr,
          13758 => Opcode::VMOVDQU64Zmrk,
          13759 => Opcode::VMOVDQU64Zrm,
          13760 => Opcode::VMOVDQU64Zrmk,
          13761 => Opcode::VMOVDQU64Zrmkz,
          13762 => Opcode::VMOVDQU64Zrr,
          13763 => Opcode::VMOVDQU64Zrr_REV,
          13764 => Opcode::VMOVDQU64Zrrk,
          13765 => Opcode::VMOVDQU64Zrrk_REV,
          13766 => Opcode::VMOVDQU64Zrrkz,
          13767 => Opcode::VMOVDQU64Zrrkz_REV,
          13768 => Opcode::VMOVDQU8Z128mr,
          13769 => Opcode::VMOVDQU8Z128mrk,
          13770 => Opcode::VMOVDQU8Z128rm,
          13771 => Opcode::VMOVDQU8Z128rmk,
          13772 => Opcode::VMOVDQU8Z128rmkz,
          13773 => Opcode::VMOVDQU8Z128rr,
          13774 => Opcode::VMOVDQU8Z128rr_REV,
          13775 => Opcode::VMOVDQU8Z128rrk,
          13776 => Opcode::VMOVDQU8Z128rrk_REV,
          13777 => Opcode::VMOVDQU8Z128rrkz,
          13778 => Opcode::VMOVDQU8Z128rrkz_REV,
          13779 => Opcode::VMOVDQU8Z256mr,
          13780 => Opcode::VMOVDQU8Z256mrk,
          13781 => Opcode::VMOVDQU8Z256rm,
          13782 => Opcode::VMOVDQU8Z256rmk,
          13783 => Opcode::VMOVDQU8Z256rmkz,
          13784 => Opcode::VMOVDQU8Z256rr,
          13785 => Opcode::VMOVDQU8Z256rr_REV,
          13786 => Opcode::VMOVDQU8Z256rrk,
          13787 => Opcode::VMOVDQU8Z256rrk_REV,
          13788 => Opcode::VMOVDQU8Z256rrkz,
          13789 => Opcode::VMOVDQU8Z256rrkz_REV,
          13790 => Opcode::VMOVDQU8Zmr,
          13791 => Opcode::VMOVDQU8Zmrk,
          13792 => Opcode::VMOVDQU8Zrm,
          13793 => Opcode::VMOVDQU8Zrmk,
          13794 => Opcode::VMOVDQU8Zrmkz,
          13795 => Opcode::VMOVDQU8Zrr,
          13796 => Opcode::VMOVDQU8Zrr_REV,
          13797 => Opcode::VMOVDQU8Zrrk,
          13798 => Opcode::VMOVDQU8Zrrk_REV,
          13799 => Opcode::VMOVDQU8Zrrkz,
          13800 => Opcode::VMOVDQU8Zrrkz_REV,
          13801 => Opcode::VMOVDQUYmr,
          13802 => Opcode::VMOVDQUYrm,
          13803 => Opcode::VMOVDQUYrr,
          13804 => Opcode::VMOVDQUYrr_REV,
          13805 => Opcode::VMOVDQUmr,
          13806 => Opcode::VMOVDQUrm,
          13807 => Opcode::VMOVDQUrr,
          13808 => Opcode::VMOVDQUrr_REV,
          13809 => Opcode::VMOVHLPSZrr,
          13810 => Opcode::VMOVHLPSrr,
          13811 => Opcode::VMOVHPDZ128mr,
          13812 => Opcode::VMOVHPDZ128rm,
          13813 => Opcode::VMOVHPDmr,
          13814 => Opcode::VMOVHPDrm,
          13815 => Opcode::VMOVHPSZ128mr,
          13816 => Opcode::VMOVHPSZ128rm,
          13817 => Opcode::VMOVHPSmr,
          13818 => Opcode::VMOVHPSrm,
          13819 => Opcode::VMOVLHPSZrr,
          13820 => Opcode::VMOVLHPSrr,
          13821 => Opcode::VMOVLPDZ128mr,
          13822 => Opcode::VMOVLPDZ128rm,
          13823 => Opcode::VMOVLPDmr,
          13824 => Opcode::VMOVLPDrm,
          13825 => Opcode::VMOVLPSZ128mr,
          13826 => Opcode::VMOVLPSZ128rm,
          13827 => Opcode::VMOVLPSmr,
          13828 => Opcode::VMOVLPSrm,
          13829 => Opcode::VMOVMSKPDYrr,
          13830 => Opcode::VMOVMSKPDrr,
          13831 => Opcode::VMOVMSKPSYrr,
          13832 => Opcode::VMOVMSKPSrr,
          13833 => Opcode::VMOVNTDQAYrm,
          13834 => Opcode::VMOVNTDQAZ128rm,
          13835 => Opcode::VMOVNTDQAZ256rm,
          13836 => Opcode::VMOVNTDQAZrm,
          13837 => Opcode::VMOVNTDQArm,
          13838 => Opcode::VMOVNTDQYmr,
          13839 => Opcode::VMOVNTDQZ128mr,
          13840 => Opcode::VMOVNTDQZ256mr,
          13841 => Opcode::VMOVNTDQZmr,
          13842 => Opcode::VMOVNTDQmr,
          13843 => Opcode::VMOVNTPDYmr,
          13844 => Opcode::VMOVNTPDZ128mr,
          13845 => Opcode::VMOVNTPDZ256mr,
          13846 => Opcode::VMOVNTPDZmr,
          13847 => Opcode::VMOVNTPDmr,
          13848 => Opcode::VMOVNTPSYmr,
          13849 => Opcode::VMOVNTPSZ128mr,
          13850 => Opcode::VMOVNTPSZ256mr,
          13851 => Opcode::VMOVNTPSZmr,
          13852 => Opcode::VMOVNTPSmr,
          13853 => Opcode::VMOVPDI2DIZmr,
          13854 => Opcode::VMOVPDI2DIZrr,
          13855 => Opcode::VMOVPDI2DImr,
          13856 => Opcode::VMOVPDI2DIrr,
          13857 => Opcode::VMOVPQI2QIZmr,
          13858 => Opcode::VMOVPQI2QIZrr,
          13859 => Opcode::VMOVPQI2QImr,
          13860 => Opcode::VMOVPQI2QIrr,
          13861 => Opcode::VMOVPQIto64Zmr,
          13862 => Opcode::VMOVPQIto64Zrr,
          13863 => Opcode::VMOVPQIto64mr,
          13864 => Opcode::VMOVPQIto64rr,
          13865 => Opcode::VMOVQI2PQIZrm,
          13866 => Opcode::VMOVQI2PQIrm,
          13867 => Opcode::VMOVRSBZ128m,
          13868 => Opcode::VMOVRSBZ128mk,
          13869 => Opcode::VMOVRSBZ128mkz,
          13870 => Opcode::VMOVRSBZ256m,
          13871 => Opcode::VMOVRSBZ256mk,
          13872 => Opcode::VMOVRSBZ256mkz,
          13873 => Opcode::VMOVRSBZm,
          13874 => Opcode::VMOVRSBZmk,
          13875 => Opcode::VMOVRSBZmkz,
          13876 => Opcode::VMOVRSDZ128m,
          13877 => Opcode::VMOVRSDZ128mk,
          13878 => Opcode::VMOVRSDZ128mkz,
          13879 => Opcode::VMOVRSDZ256m,
          13880 => Opcode::VMOVRSDZ256mk,
          13881 => Opcode::VMOVRSDZ256mkz,
          13882 => Opcode::VMOVRSDZm,
          13883 => Opcode::VMOVRSDZmk,
          13884 => Opcode::VMOVRSDZmkz,
          13885 => Opcode::VMOVRSQZ128m,
          13886 => Opcode::VMOVRSQZ128mk,
          13887 => Opcode::VMOVRSQZ128mkz,
          13888 => Opcode::VMOVRSQZ256m,
          13889 => Opcode::VMOVRSQZ256mk,
          13890 => Opcode::VMOVRSQZ256mkz,
          13891 => Opcode::VMOVRSQZm,
          13892 => Opcode::VMOVRSQZmk,
          13893 => Opcode::VMOVRSQZmkz,
          13894 => Opcode::VMOVRSWZ128m,
          13895 => Opcode::VMOVRSWZ128mk,
          13896 => Opcode::VMOVRSWZ128mkz,
          13897 => Opcode::VMOVRSWZ256m,
          13898 => Opcode::VMOVRSWZ256mk,
          13899 => Opcode::VMOVRSWZ256mkz,
          13900 => Opcode::VMOVRSWZm,
          13901 => Opcode::VMOVRSWZmk,
          13902 => Opcode::VMOVRSWZmkz,
          13903 => Opcode::VMOVSDZmr,
          13904 => Opcode::VMOVSDZmrk,
          13905 => Opcode::VMOVSDZrm,
          13906 => Opcode::VMOVSDZrm_alt,
          13907 => Opcode::VMOVSDZrmk,
          13908 => Opcode::VMOVSDZrmkz,
          13909 => Opcode::VMOVSDZrr,
          13910 => Opcode::VMOVSDZrr_REV,
          13911 => Opcode::VMOVSDZrrk,
          13912 => Opcode::VMOVSDZrrk_REV,
          13913 => Opcode::VMOVSDZrrkz,
          13914 => Opcode::VMOVSDZrrkz_REV,
          13915 => Opcode::VMOVSDmr,
          13916 => Opcode::VMOVSDrm,
          13917 => Opcode::VMOVSDrm_alt,
          13918 => Opcode::VMOVSDrr,
          13919 => Opcode::VMOVSDrr_REV,
          13920 => Opcode::VMOVSDto64Zrr,
          13921 => Opcode::VMOVSDto64rr,
          13922 => Opcode::VMOVSH2Wrr,
          13923 => Opcode::VMOVSHDUPYrm,
          13924 => Opcode::VMOVSHDUPYrr,
          13925 => Opcode::VMOVSHDUPZ128rm,
          13926 => Opcode::VMOVSHDUPZ128rmk,
          13927 => Opcode::VMOVSHDUPZ128rmkz,
          13928 => Opcode::VMOVSHDUPZ128rr,
          13929 => Opcode::VMOVSHDUPZ128rrk,
          13930 => Opcode::VMOVSHDUPZ128rrkz,
          13931 => Opcode::VMOVSHDUPZ256rm,
          13932 => Opcode::VMOVSHDUPZ256rmk,
          13933 => Opcode::VMOVSHDUPZ256rmkz,
          13934 => Opcode::VMOVSHDUPZ256rr,
          13935 => Opcode::VMOVSHDUPZ256rrk,
          13936 => Opcode::VMOVSHDUPZ256rrkz,
          13937 => Opcode::VMOVSHDUPZrm,
          13938 => Opcode::VMOVSHDUPZrmk,
          13939 => Opcode::VMOVSHDUPZrmkz,
          13940 => Opcode::VMOVSHDUPZrr,
          13941 => Opcode::VMOVSHDUPZrrk,
          13942 => Opcode::VMOVSHDUPZrrkz,
          13943 => Opcode::VMOVSHDUPrm,
          13944 => Opcode::VMOVSHDUPrr,
          13945 => Opcode::VMOVSHZmr,
          13946 => Opcode::VMOVSHZmrk,
          13947 => Opcode::VMOVSHZrm,
          13948 => Opcode::VMOVSHZrm_alt,
          13949 => Opcode::VMOVSHZrmk,
          13950 => Opcode::VMOVSHZrmkz,
          13951 => Opcode::VMOVSHZrr,
          13952 => Opcode::VMOVSHZrr_REV,
          13953 => Opcode::VMOVSHZrrk,
          13954 => Opcode::VMOVSHZrrk_REV,
          13955 => Opcode::VMOVSHZrrkz,
          13956 => Opcode::VMOVSHZrrkz_REV,
          13957 => Opcode::VMOVSHtoW64rr,
          13958 => Opcode::VMOVSLDUPYrm,
          13959 => Opcode::VMOVSLDUPYrr,
          13960 => Opcode::VMOVSLDUPZ128rm,
          13961 => Opcode::VMOVSLDUPZ128rmk,
          13962 => Opcode::VMOVSLDUPZ128rmkz,
          13963 => Opcode::VMOVSLDUPZ128rr,
          13964 => Opcode::VMOVSLDUPZ128rrk,
          13965 => Opcode::VMOVSLDUPZ128rrkz,
          13966 => Opcode::VMOVSLDUPZ256rm,
          13967 => Opcode::VMOVSLDUPZ256rmk,
          13968 => Opcode::VMOVSLDUPZ256rmkz,
          13969 => Opcode::VMOVSLDUPZ256rr,
          13970 => Opcode::VMOVSLDUPZ256rrk,
          13971 => Opcode::VMOVSLDUPZ256rrkz,
          13972 => Opcode::VMOVSLDUPZrm,
          13973 => Opcode::VMOVSLDUPZrmk,
          13974 => Opcode::VMOVSLDUPZrmkz,
          13975 => Opcode::VMOVSLDUPZrr,
          13976 => Opcode::VMOVSLDUPZrrk,
          13977 => Opcode::VMOVSLDUPZrrkz,
          13978 => Opcode::VMOVSLDUPrm,
          13979 => Opcode::VMOVSLDUPrr,
          13980 => Opcode::VMOVSS2DIZrr,
          13981 => Opcode::VMOVSS2DIrr,
          13982 => Opcode::VMOVSSZmr,
          13983 => Opcode::VMOVSSZmrk,
          13984 => Opcode::VMOVSSZrm,
          13985 => Opcode::VMOVSSZrm_alt,
          13986 => Opcode::VMOVSSZrmk,
          13987 => Opcode::VMOVSSZrmkz,
          13988 => Opcode::VMOVSSZrr,
          13989 => Opcode::VMOVSSZrr_REV,
          13990 => Opcode::VMOVSSZrrk,
          13991 => Opcode::VMOVSSZrrk_REV,
          13992 => Opcode::VMOVSSZrrkz,
          13993 => Opcode::VMOVSSZrrkz_REV,
          13994 => Opcode::VMOVSSmr,
          13995 => Opcode::VMOVSSrm,
          13996 => Opcode::VMOVSSrm_alt,
          13997 => Opcode::VMOVSSrr,
          13998 => Opcode::VMOVSSrr_REV,
          13999 => Opcode::VMOVUPDYmr,
          14000 => Opcode::VMOVUPDYrm,
          14001 => Opcode::VMOVUPDYrr,
          14002 => Opcode::VMOVUPDYrr_REV,
          14003 => Opcode::VMOVUPDZ128mr,
          14004 => Opcode::VMOVUPDZ128mrk,
          14005 => Opcode::VMOVUPDZ128rm,
          14006 => Opcode::VMOVUPDZ128rmk,
          14007 => Opcode::VMOVUPDZ128rmkz,
          14008 => Opcode::VMOVUPDZ128rr,
          14009 => Opcode::VMOVUPDZ128rr_REV,
          14010 => Opcode::VMOVUPDZ128rrk,
          14011 => Opcode::VMOVUPDZ128rrk_REV,
          14012 => Opcode::VMOVUPDZ128rrkz,
          14013 => Opcode::VMOVUPDZ128rrkz_REV,
          14014 => Opcode::VMOVUPDZ256mr,
          14015 => Opcode::VMOVUPDZ256mrk,
          14016 => Opcode::VMOVUPDZ256rm,
          14017 => Opcode::VMOVUPDZ256rmk,
          14018 => Opcode::VMOVUPDZ256rmkz,
          14019 => Opcode::VMOVUPDZ256rr,
          14020 => Opcode::VMOVUPDZ256rr_REV,
          14021 => Opcode::VMOVUPDZ256rrk,
          14022 => Opcode::VMOVUPDZ256rrk_REV,
          14023 => Opcode::VMOVUPDZ256rrkz,
          14024 => Opcode::VMOVUPDZ256rrkz_REV,
          14025 => Opcode::VMOVUPDZmr,
          14026 => Opcode::VMOVUPDZmrk,
          14027 => Opcode::VMOVUPDZrm,
          14028 => Opcode::VMOVUPDZrmk,
          14029 => Opcode::VMOVUPDZrmkz,
          14030 => Opcode::VMOVUPDZrr,
          14031 => Opcode::VMOVUPDZrr_REV,
          14032 => Opcode::VMOVUPDZrrk,
          14033 => Opcode::VMOVUPDZrrk_REV,
          14034 => Opcode::VMOVUPDZrrkz,
          14035 => Opcode::VMOVUPDZrrkz_REV,
          14036 => Opcode::VMOVUPDmr,
          14037 => Opcode::VMOVUPDrm,
          14038 => Opcode::VMOVUPDrr,
          14039 => Opcode::VMOVUPDrr_REV,
          14040 => Opcode::VMOVUPSYmr,
          14041 => Opcode::VMOVUPSYrm,
          14042 => Opcode::VMOVUPSYrr,
          14043 => Opcode::VMOVUPSYrr_REV,
          14044 => Opcode::VMOVUPSZ128mr,
          14045 => Opcode::VMOVUPSZ128mrk,
          14046 => Opcode::VMOVUPSZ128rm,
          14047 => Opcode::VMOVUPSZ128rmk,
          14048 => Opcode::VMOVUPSZ128rmkz,
          14049 => Opcode::VMOVUPSZ128rr,
          14050 => Opcode::VMOVUPSZ128rr_REV,
          14051 => Opcode::VMOVUPSZ128rrk,
          14052 => Opcode::VMOVUPSZ128rrk_REV,
          14053 => Opcode::VMOVUPSZ128rrkz,
          14054 => Opcode::VMOVUPSZ128rrkz_REV,
          14055 => Opcode::VMOVUPSZ256mr,
          14056 => Opcode::VMOVUPSZ256mrk,
          14057 => Opcode::VMOVUPSZ256rm,
          14058 => Opcode::VMOVUPSZ256rmk,
          14059 => Opcode::VMOVUPSZ256rmkz,
          14060 => Opcode::VMOVUPSZ256rr,
          14061 => Opcode::VMOVUPSZ256rr_REV,
          14062 => Opcode::VMOVUPSZ256rrk,
          14063 => Opcode::VMOVUPSZ256rrk_REV,
          14064 => Opcode::VMOVUPSZ256rrkz,
          14065 => Opcode::VMOVUPSZ256rrkz_REV,
          14066 => Opcode::VMOVUPSZmr,
          14067 => Opcode::VMOVUPSZmrk,
          14068 => Opcode::VMOVUPSZrm,
          14069 => Opcode::VMOVUPSZrmk,
          14070 => Opcode::VMOVUPSZrmkz,
          14071 => Opcode::VMOVUPSZrr,
          14072 => Opcode::VMOVUPSZrr_REV,
          14073 => Opcode::VMOVUPSZrrk,
          14074 => Opcode::VMOVUPSZrrk_REV,
          14075 => Opcode::VMOVUPSZrrkz,
          14076 => Opcode::VMOVUPSZrrkz_REV,
          14077 => Opcode::VMOVUPSmr,
          14078 => Opcode::VMOVUPSrm,
          14079 => Opcode::VMOVUPSrr,
          14080 => Opcode::VMOVUPSrr_REV,
          14081 => Opcode::VMOVW2SHrr,
          14082 => Opcode::VMOVW64toSHrr,
          14083 => Opcode::VMOVWmr,
          14084 => Opcode::VMOVWrm,
          14085 => Opcode::VMOVZPDILo2PDIZmr,
          14086 => Opcode::VMOVZPDILo2PDIZrm,
          14087 => Opcode::VMOVZPDILo2PDIZrr,
          14088 => Opcode::VMOVZPDILo2PDIZrr2,
          14089 => Opcode::VMOVZPQILo2PQIZrr,
          14090 => Opcode::VMOVZPQILo2PQIrr,
          14091 => Opcode::VMOVZPWILo2PWIZmr,
          14092 => Opcode::VMOVZPWILo2PWIZrm,
          14093 => Opcode::VMOVZPWILo2PWIZrr,
          14094 => Opcode::VMOVZPWILo2PWIZrr2,
          14095 => Opcode::VMPSADBWYrmi,
          14096 => Opcode::VMPSADBWYrri,
          14097 => Opcode::VMPSADBWZ128rmi,
          14098 => Opcode::VMPSADBWZ128rmik,
          14099 => Opcode::VMPSADBWZ128rmikz,
          14100 => Opcode::VMPSADBWZ128rri,
          14101 => Opcode::VMPSADBWZ128rrik,
          14102 => Opcode::VMPSADBWZ128rrikz,
          14103 => Opcode::VMPSADBWZ256rmi,
          14104 => Opcode::VMPSADBWZ256rmik,
          14105 => Opcode::VMPSADBWZ256rmikz,
          14106 => Opcode::VMPSADBWZ256rri,
          14107 => Opcode::VMPSADBWZ256rrik,
          14108 => Opcode::VMPSADBWZ256rrikz,
          14109 => Opcode::VMPSADBWZrmi,
          14110 => Opcode::VMPSADBWZrmik,
          14111 => Opcode::VMPSADBWZrmikz,
          14112 => Opcode::VMPSADBWZrri,
          14113 => Opcode::VMPSADBWZrrik,
          14114 => Opcode::VMPSADBWZrrikz,
          14115 => Opcode::VMPSADBWrmi,
          14116 => Opcode::VMPSADBWrri,
          14117 => Opcode::VMPTRLDm,
          14118 => Opcode::VMPTRSTm,
          14119 => Opcode::VMREAD32mr,
          14120 => Opcode::VMREAD32rr,
          14121 => Opcode::VMREAD64mr,
          14122 => Opcode::VMREAD64rr,
          14123 => Opcode::VMRESUME,
          14124 => Opcode::VMRUN32,
          14125 => Opcode::VMRUN64,
          14126 => Opcode::VMSAVE32,
          14127 => Opcode::VMSAVE64,
          14128 => Opcode::VMULBF16Z128rm,
          14129 => Opcode::VMULBF16Z128rmb,
          14130 => Opcode::VMULBF16Z128rmbk,
          14131 => Opcode::VMULBF16Z128rmbkz,
          14132 => Opcode::VMULBF16Z128rmk,
          14133 => Opcode::VMULBF16Z128rmkz,
          14134 => Opcode::VMULBF16Z128rr,
          14135 => Opcode::VMULBF16Z128rrk,
          14136 => Opcode::VMULBF16Z128rrkz,
          14137 => Opcode::VMULBF16Z256rm,
          14138 => Opcode::VMULBF16Z256rmb,
          14139 => Opcode::VMULBF16Z256rmbk,
          14140 => Opcode::VMULBF16Z256rmbkz,
          14141 => Opcode::VMULBF16Z256rmk,
          14142 => Opcode::VMULBF16Z256rmkz,
          14143 => Opcode::VMULBF16Z256rr,
          14144 => Opcode::VMULBF16Z256rrk,
          14145 => Opcode::VMULBF16Z256rrkz,
          14146 => Opcode::VMULBF16Zrm,
          14147 => Opcode::VMULBF16Zrmb,
          14148 => Opcode::VMULBF16Zrmbk,
          14149 => Opcode::VMULBF16Zrmbkz,
          14150 => Opcode::VMULBF16Zrmk,
          14151 => Opcode::VMULBF16Zrmkz,
          14152 => Opcode::VMULBF16Zrr,
          14153 => Opcode::VMULBF16Zrrk,
          14154 => Opcode::VMULBF16Zrrkz,
          14155 => Opcode::VMULPDYrm,
          14156 => Opcode::VMULPDYrr,
          14157 => Opcode::VMULPDZ128rm,
          14158 => Opcode::VMULPDZ128rmb,
          14159 => Opcode::VMULPDZ128rmbk,
          14160 => Opcode::VMULPDZ128rmbkz,
          14161 => Opcode::VMULPDZ128rmk,
          14162 => Opcode::VMULPDZ128rmkz,
          14163 => Opcode::VMULPDZ128rr,
          14164 => Opcode::VMULPDZ128rrk,
          14165 => Opcode::VMULPDZ128rrkz,
          14166 => Opcode::VMULPDZ256rm,
          14167 => Opcode::VMULPDZ256rmb,
          14168 => Opcode::VMULPDZ256rmbk,
          14169 => Opcode::VMULPDZ256rmbkz,
          14170 => Opcode::VMULPDZ256rmk,
          14171 => Opcode::VMULPDZ256rmkz,
          14172 => Opcode::VMULPDZ256rr,
          14173 => Opcode::VMULPDZ256rrk,
          14174 => Opcode::VMULPDZ256rrkz,
          14175 => Opcode::VMULPDZrm,
          14176 => Opcode::VMULPDZrmb,
          14177 => Opcode::VMULPDZrmbk,
          14178 => Opcode::VMULPDZrmbkz,
          14179 => Opcode::VMULPDZrmk,
          14180 => Opcode::VMULPDZrmkz,
          14181 => Opcode::VMULPDZrr,
          14182 => Opcode::VMULPDZrrb,
          14183 => Opcode::VMULPDZrrbk,
          14184 => Opcode::VMULPDZrrbkz,
          14185 => Opcode::VMULPDZrrk,
          14186 => Opcode::VMULPDZrrkz,
          14187 => Opcode::VMULPDrm,
          14188 => Opcode::VMULPDrr,
          14189 => Opcode::VMULPHZ128rm,
          14190 => Opcode::VMULPHZ128rmb,
          14191 => Opcode::VMULPHZ128rmbk,
          14192 => Opcode::VMULPHZ128rmbkz,
          14193 => Opcode::VMULPHZ128rmk,
          14194 => Opcode::VMULPHZ128rmkz,
          14195 => Opcode::VMULPHZ128rr,
          14196 => Opcode::VMULPHZ128rrk,
          14197 => Opcode::VMULPHZ128rrkz,
          14198 => Opcode::VMULPHZ256rm,
          14199 => Opcode::VMULPHZ256rmb,
          14200 => Opcode::VMULPHZ256rmbk,
          14201 => Opcode::VMULPHZ256rmbkz,
          14202 => Opcode::VMULPHZ256rmk,
          14203 => Opcode::VMULPHZ256rmkz,
          14204 => Opcode::VMULPHZ256rr,
          14205 => Opcode::VMULPHZ256rrk,
          14206 => Opcode::VMULPHZ256rrkz,
          14207 => Opcode::VMULPHZrm,
          14208 => Opcode::VMULPHZrmb,
          14209 => Opcode::VMULPHZrmbk,
          14210 => Opcode::VMULPHZrmbkz,
          14211 => Opcode::VMULPHZrmk,
          14212 => Opcode::VMULPHZrmkz,
          14213 => Opcode::VMULPHZrr,
          14214 => Opcode::VMULPHZrrb,
          14215 => Opcode::VMULPHZrrbk,
          14216 => Opcode::VMULPHZrrbkz,
          14217 => Opcode::VMULPHZrrk,
          14218 => Opcode::VMULPHZrrkz,
          14219 => Opcode::VMULPSYrm,
          14220 => Opcode::VMULPSYrr,
          14221 => Opcode::VMULPSZ128rm,
          14222 => Opcode::VMULPSZ128rmb,
          14223 => Opcode::VMULPSZ128rmbk,
          14224 => Opcode::VMULPSZ128rmbkz,
          14225 => Opcode::VMULPSZ128rmk,
          14226 => Opcode::VMULPSZ128rmkz,
          14227 => Opcode::VMULPSZ128rr,
          14228 => Opcode::VMULPSZ128rrk,
          14229 => Opcode::VMULPSZ128rrkz,
          14230 => Opcode::VMULPSZ256rm,
          14231 => Opcode::VMULPSZ256rmb,
          14232 => Opcode::VMULPSZ256rmbk,
          14233 => Opcode::VMULPSZ256rmbkz,
          14234 => Opcode::VMULPSZ256rmk,
          14235 => Opcode::VMULPSZ256rmkz,
          14236 => Opcode::VMULPSZ256rr,
          14237 => Opcode::VMULPSZ256rrk,
          14238 => Opcode::VMULPSZ256rrkz,
          14239 => Opcode::VMULPSZrm,
          14240 => Opcode::VMULPSZrmb,
          14241 => Opcode::VMULPSZrmbk,
          14242 => Opcode::VMULPSZrmbkz,
          14243 => Opcode::VMULPSZrmk,
          14244 => Opcode::VMULPSZrmkz,
          14245 => Opcode::VMULPSZrr,
          14246 => Opcode::VMULPSZrrb,
          14247 => Opcode::VMULPSZrrbk,
          14248 => Opcode::VMULPSZrrbkz,
          14249 => Opcode::VMULPSZrrk,
          14250 => Opcode::VMULPSZrrkz,
          14251 => Opcode::VMULPSrm,
          14252 => Opcode::VMULPSrr,
          14253 => Opcode::VMULSDZrm,
          14254 => Opcode::VMULSDZrm_Int,
          14255 => Opcode::VMULSDZrmk_Int,
          14256 => Opcode::VMULSDZrmkz_Int,
          14257 => Opcode::VMULSDZrr,
          14258 => Opcode::VMULSDZrr_Int,
          14259 => Opcode::VMULSDZrrb_Int,
          14260 => Opcode::VMULSDZrrbk_Int,
          14261 => Opcode::VMULSDZrrbkz_Int,
          14262 => Opcode::VMULSDZrrk_Int,
          14263 => Opcode::VMULSDZrrkz_Int,
          14264 => Opcode::VMULSDrm,
          14265 => Opcode::VMULSDrm_Int,
          14266 => Opcode::VMULSDrr,
          14267 => Opcode::VMULSDrr_Int,
          14268 => Opcode::VMULSHZrm,
          14269 => Opcode::VMULSHZrm_Int,
          14270 => Opcode::VMULSHZrmk_Int,
          14271 => Opcode::VMULSHZrmkz_Int,
          14272 => Opcode::VMULSHZrr,
          14273 => Opcode::VMULSHZrr_Int,
          14274 => Opcode::VMULSHZrrb_Int,
          14275 => Opcode::VMULSHZrrbk_Int,
          14276 => Opcode::VMULSHZrrbkz_Int,
          14277 => Opcode::VMULSHZrrk_Int,
          14278 => Opcode::VMULSHZrrkz_Int,
          14279 => Opcode::VMULSSZrm,
          14280 => Opcode::VMULSSZrm_Int,
          14281 => Opcode::VMULSSZrmk_Int,
          14282 => Opcode::VMULSSZrmkz_Int,
          14283 => Opcode::VMULSSZrr,
          14284 => Opcode::VMULSSZrr_Int,
          14285 => Opcode::VMULSSZrrb_Int,
          14286 => Opcode::VMULSSZrrbk_Int,
          14287 => Opcode::VMULSSZrrbkz_Int,
          14288 => Opcode::VMULSSZrrk_Int,
          14289 => Opcode::VMULSSZrrkz_Int,
          14290 => Opcode::VMULSSrm,
          14291 => Opcode::VMULSSrm_Int,
          14292 => Opcode::VMULSSrr,
          14293 => Opcode::VMULSSrr_Int,
          14294 => Opcode::VMWRITE32rm,
          14295 => Opcode::VMWRITE32rr,
          14296 => Opcode::VMWRITE64rm,
          14297 => Opcode::VMWRITE64rr,
          14298 => Opcode::VMXOFF,
          14299 => Opcode::VMXON,
          14300 => Opcode::VORPDYrm,
          14301 => Opcode::VORPDYrr,
          14302 => Opcode::VORPDZ128rm,
          14303 => Opcode::VORPDZ128rmb,
          14304 => Opcode::VORPDZ128rmbk,
          14305 => Opcode::VORPDZ128rmbkz,
          14306 => Opcode::VORPDZ128rmk,
          14307 => Opcode::VORPDZ128rmkz,
          14308 => Opcode::VORPDZ128rr,
          14309 => Opcode::VORPDZ128rrk,
          14310 => Opcode::VORPDZ128rrkz,
          14311 => Opcode::VORPDZ256rm,
          14312 => Opcode::VORPDZ256rmb,
          14313 => Opcode::VORPDZ256rmbk,
          14314 => Opcode::VORPDZ256rmbkz,
          14315 => Opcode::VORPDZ256rmk,
          14316 => Opcode::VORPDZ256rmkz,
          14317 => Opcode::VORPDZ256rr,
          14318 => Opcode::VORPDZ256rrk,
          14319 => Opcode::VORPDZ256rrkz,
          14320 => Opcode::VORPDZrm,
          14321 => Opcode::VORPDZrmb,
          14322 => Opcode::VORPDZrmbk,
          14323 => Opcode::VORPDZrmbkz,
          14324 => Opcode::VORPDZrmk,
          14325 => Opcode::VORPDZrmkz,
          14326 => Opcode::VORPDZrr,
          14327 => Opcode::VORPDZrrk,
          14328 => Opcode::VORPDZrrkz,
          14329 => Opcode::VORPDrm,
          14330 => Opcode::VORPDrr,
          14331 => Opcode::VORPSYrm,
          14332 => Opcode::VORPSYrr,
          14333 => Opcode::VORPSZ128rm,
          14334 => Opcode::VORPSZ128rmb,
          14335 => Opcode::VORPSZ128rmbk,
          14336 => Opcode::VORPSZ128rmbkz,
          14337 => Opcode::VORPSZ128rmk,
          14338 => Opcode::VORPSZ128rmkz,
          14339 => Opcode::VORPSZ128rr,
          14340 => Opcode::VORPSZ128rrk,
          14341 => Opcode::VORPSZ128rrkz,
          14342 => Opcode::VORPSZ256rm,
          14343 => Opcode::VORPSZ256rmb,
          14344 => Opcode::VORPSZ256rmbk,
          14345 => Opcode::VORPSZ256rmbkz,
          14346 => Opcode::VORPSZ256rmk,
          14347 => Opcode::VORPSZ256rmkz,
          14348 => Opcode::VORPSZ256rr,
          14349 => Opcode::VORPSZ256rrk,
          14350 => Opcode::VORPSZ256rrkz,
          14351 => Opcode::VORPSZrm,
          14352 => Opcode::VORPSZrmb,
          14353 => Opcode::VORPSZrmbk,
          14354 => Opcode::VORPSZrmbkz,
          14355 => Opcode::VORPSZrmk,
          14356 => Opcode::VORPSZrmkz,
          14357 => Opcode::VORPSZrr,
          14358 => Opcode::VORPSZrrk,
          14359 => Opcode::VORPSZrrkz,
