/* Copyright 2022 - 2025 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package lief.dwarf;

import lief.dwarf.editor.CompilationUnit;

public class Editor extends lief.Base {
    @Override
    protected native void destroy();

    private Editor(long impl) {
        super(impl);
    }

    public native static Editor forBinary(lief.generic.Binary binary);

    public native CompilationUnit createCompilationUnit();

    public native void write(String path);
}
