#!/usr/bin/env sh

# Exit on errors
set -e
VERSION_NAME=`git describe`
echo "package build into zip for win"
# workaround for botched qt6 installation
mkdir -p package-zip
cp qdia.exe package-zip/
cp -r translation package-zip/translations
cd package-zip
windeployqt6 qdia.exe
ldd qdia.exe | awk '{print $3}'| grep ming | xargs -I{} cp -u {} .
cd ..
echo "make installer"
cp ../resources/qdia-msys.nsi .
cp ../resources/FileAssociation.nsh .
makensis qdia-msys.nsi

cd package-zip
zip -r ./qdia-win-qt6-${VERSION_NAME}.zip *

cd ..
sha256sum ./package-zip/qdia-win-qt6-${VERSION_NAME}.zip
cp ./package-zip/qdia-win-qt6-${VERSION_NAME}.zip ./qdia-${VERSION_NAME}-win-portable-qt6.zip
cp ./qdia_installer.exe ./qdia-win-qt6-${VERSION_NAME}.exe


