---
title: "rclone tree"
description: "List the contents of the remote in a tree like fashion."
versionIntroduced: v1.38
# autogenerated - DO NOT EDIT, instead edit the source code in cmd/tree/ and as part of making a release run "make commanddocs"
---
# rclone tree

List the contents of the remote in a tree like fashion.

## Synopsis

Lists the contents of a remote in a similar way to the unix tree command.

For example

    $ rclone tree remote:path
    /
    ├── file1
    ├── file2
    ├── file3
    └── subdir
        ├── file4
        └── file5

    1 directories, 5 files

You can use any of the filtering options with the tree command (e.g.
`--include` and `--exclude`.  You can also use `--fast-list`.

The tree command has many options for controlling the listing which
are compatible with the tree command, for example you can include file
sizes with `--size`.  Note that not all of them have
short options as they conflict with rclone's short options.

For a more interactive navigation of the remote see the
[ncdu](/commands/rclone_ncdu/) command.


```
rclone tree remote:path [flags]
```

## Options

```
  -a, --all             All files are listed (list . files too)
  -d, --dirs-only       List directories only
      --dirsfirst       List directories before files (-U disables)
      --full-path       Print the full path prefix for each file
  -h, --help            help for tree
      --level int       Descend only level directories deep
  -D, --modtime         Print the date of last modification.
      --noindent        Don't print indentation lines
      --noreport        Turn off file/directory count at end of tree listing
  -o, --output string   Output to file instead of stdout
  -p, --protections     Print the protections for each file.
  -Q, --quote           Quote filenames with double quotes.
  -s, --size            Print the size in bytes of each file.
      --sort string     Select sort: name,version,size,mtime,ctime
      --sort-ctime      Sort files by last status change time
  -t, --sort-modtime    Sort files by last modification time
  -r, --sort-reverse    Reverse the order of the sort
  -U, --unsorted        Leave files unsorted
      --version         Sort files alphanumerically by version
```

Options shared with other commands are described next.
See the [global flags page](/flags/) for global options not listed here.

### Filter Options

Flags for filtering directory listings

```
      --delete-excluded                     Delete files on dest excluded from sync
      --exclude stringArray                 Exclude files matching pattern
      --exclude-from stringArray            Read file exclude patterns from file (use - to read from stdin)
      --exclude-if-present stringArray      Exclude directories if filename is present
      --files-from stringArray              Read list of source-file names from file (use - to read from stdin)
      --files-from-raw stringArray          Read list of source-file names from file without any processing of lines (use - to read from stdin)
  -f, --filter stringArray                  Add a file filtering rule
      --filter-from stringArray             Read file filtering patterns from a file (use - to read from stdin)
      --hash-filter string                  Partition filenames by hash k/n or randomly @/n
      --ignore-case                         Ignore case in filters (case insensitive)
      --include stringArray                 Include files matching pattern
      --include-from stringArray            Read file include patterns from file (use - to read from stdin)
      --max-age Duration                    Only transfer files younger than this in s or suffix ms|s|m|h|d|w|M|y (default off)
      --max-depth int                       If set limits the recursion depth to this (default -1)
      --max-size SizeSuffix                 Only transfer files smaller than this in KiB or suffix B|K|M|G|T|P (default off)
      --metadata-exclude stringArray        Exclude metadatas matching pattern
      --metadata-exclude-from stringArray   Read metadata exclude patterns from file (use - to read from stdin)
      --metadata-filter stringArray         Add a metadata filtering rule
      --metadata-filter-from stringArray    Read metadata filtering patterns from a file (use - to read from stdin)
      --metadata-include stringArray        Include metadatas matching pattern
      --metadata-include-from stringArray   Read metadata include patterns from file (use - to read from stdin)
      --min-age Duration                    Only transfer files older than this in s or suffix ms|s|m|h|d|w|M|y (default off)
      --min-size SizeSuffix                 Only transfer files bigger than this in KiB or suffix B|K|M|G|T|P (default off)
```

### Listing Options

Flags for listing directories

```
      --default-time Time   Time to show if modtime is unknown for files and directories (default 2000-01-01T00:00:00Z)
      --fast-list           Use recursive list if available; uses more memory but fewer transactions
```

## See Also

* [rclone](/commands/rclone/)	 - Show help for rclone commands, flags and backends.

