"""

opcode module - potentially shared between dis and other modules which
operate on bytecodes (e.g. peephole optimizers).
"""

import sys
from typing import Literal

__all__ = [
    "cmp_op",
    "hasconst",
    "hasname",
    "hasjrel",
    "hasjabs",
    "haslocal",
    "hascompare",
    "hasfree",
    "opname",
    "opmap",
    "HAVE_ARGUMENT",
    "EXTENDED_ARG",
    "stack_effect",
]
if sys.version_info >= (3, 12):
    __all__ += ["hasarg", "hasexc"]
else:
    __all__ += ["hasnargs"]
if sys.version_info >= (3, 13):
    __all__ += ["hasjump"]

cmp_op: tuple[Literal["<"], Literal["<="], Literal["=="], Literal["!="], Literal[">"], Literal[">="]]
hasconst: list[int]
hasname: list[int]
hasjrel: list[int]
hasjabs: list[int]
haslocal: list[int]
hascompare: list[int]
hasfree: list[int]
if sys.version_info >= (3, 12):
    hasarg: list[int]
    hasexc: list[int]
else:
    hasnargs: list[int]
if sys.version_info >= (3, 13):
    hasjump: list[int]
opname: list[str]

opmap: dict[str, int]
HAVE_ARGUMENT: int
EXTENDED_ARG: int

def stack_effect(opcode: int, oparg: int | None = None, /, *, jump: bool | None = None) -> int:
    """Compute the stack effect of the opcode."""
