import socket
import sys
from _typeshed import ReadableBuffer
from builtins import type as Type  # alias to avoid name clashes with property named "type"
from collections.abc import Iterable
from types import TracebackType
from typing import Any, BinaryIO, NoReturn, overload
from typing_extensions import TypeAlias, deprecated

# These are based in socket, maybe move them out into _typeshed.pyi or such
_Address: TypeAlias = socket._Address
_RetAddress: TypeAlias = Any
_WriteBuffer: TypeAlias = bytearray | memoryview
_CMSG: TypeAlias = tuple[int, int, bytes]

class TransportSocket:
    """A socket-like wrapper for exposing real transport sockets.

    These objects can be safely returned by APIs like
    `transport.get_extra_info('socket')`.  All potentially disruptive
    operations (like "socket.close()") are banned.
    """

    __slots__ = ("_sock",)
    def __init__(self, sock: socket.socket) -> None: ...
    @property
    def family(self) -> int: ...
    @property
    def type(self) -> int: ...
    @property
    def proto(self) -> int: ...
    def __getstate__(self) -> NoReturn: ...
    def fileno(self) -> int: ...
    def dup(self) -> socket.socket: ...
    def get_inheritable(self) -> bool: ...
    def shutdown(self, how: int) -> None: ...
    @overload
    def getsockopt(self, level: int, optname: int) -> int: ...
    @overload
    def getsockopt(self, level: int, optname: int, buflen: int) -> bytes: ...
    @overload
    def setsockopt(self, level: int, optname: int, value: int | ReadableBuffer) -> None: ...
    @overload
    def setsockopt(self, level: int, optname: int, value: None, optlen: int) -> None: ...
    def getpeername(self) -> _RetAddress: ...
    def getsockname(self) -> _RetAddress: ...
    def getsockbyname(self) -> NoReturn: ...  # This method doesn't exist on socket, yet is passed through?
    def settimeout(self, value: float | None) -> None: ...
    def gettimeout(self) -> float | None: ...
    def setblocking(self, flag: bool) -> None: ...
    if sys.version_info < (3, 11):
        def _na(self, what: str) -> None: ...
        @deprecated("Removed in Python 3.11")
        def accept(self) -> tuple[socket.socket, _RetAddress]: ...
        @deprecated("Removed in Python 3.11")
        def connect(self, address: _Address) -> None: ...
        @deprecated("Removed in Python 3.11")
        def connect_ex(self, address: _Address) -> int: ...
        @deprecated("Removed in Python 3.11")
        def bind(self, address: _Address) -> None: ...
        if sys.platform == "win32":
            @deprecated("Removed in Python 3.11")
            def ioctl(self, control: int, option: int | tuple[int, int, int] | bool) -> None: ...
        else:
            @deprecated("Removed in Python 3.11")
            def ioctl(self, control: int, option: int | tuple[int, int, int] | bool) -> NoReturn: ...

        @deprecated("Removed in Python 3.11")
        def listen(self, backlog: int = ..., /) -> None: ...
        @deprecated("Removed in Python 3.11")
        def makefile(self) -> BinaryIO: ...
        @deprecated("Rmoved in Python 3.11")
        def sendfile(self, file: BinaryIO, offset: int = 0, count: int | None = None) -> int: ...
        @deprecated("Removed in Python 3.11")
        def close(self) -> None: ...
        @deprecated("Removed in Python 3.11")
        def detach(self) -> int: ...
        if sys.platform == "linux":
            @deprecated("Removed in Python 3.11")
            def sendmsg_afalg(
                self, msg: Iterable[ReadableBuffer] = ..., *, op: int, iv: Any = ..., assoclen: int = ..., flags: int = 0
            ) -> int: ...
        else:
            @deprecated("Removed in Python 3.11.")
            def sendmsg_afalg(
                self, msg: Iterable[ReadableBuffer] = ..., *, op: int, iv: Any = ..., assoclen: int = ..., flags: int = 0
            ) -> NoReturn: ...

        @deprecated("Removed in Python 3.11.")
        def sendmsg(
            self,
            buffers: Iterable[ReadableBuffer],
            ancdata: Iterable[_CMSG] = ...,
            flags: int = 0,
            address: _Address | None = None,
            /,
        ) -> int: ...
        @overload
        @deprecated("Removed in Python 3.11.")
        def sendto(self, data: ReadableBuffer, address: _Address) -> int: ...
        @overload
        @deprecated("Removed in Python 3.11.")
        def sendto(self, data: ReadableBuffer, flags: int, address: _Address) -> int: ...
        @deprecated("Removed in Python 3.11.")
        def send(self, data: ReadableBuffer, flags: int = 0) -> int: ...
        @deprecated("Removed in Python 3.11.")
        def sendall(self, data: ReadableBuffer, flags: int = 0) -> None: ...
        @deprecated("Removed in Python 3.11.")
        def set_inheritable(self, inheritable: bool) -> None: ...
        if sys.platform == "win32":
            @deprecated("Removed in Python 3.11.")
            def share(self, process_id: int) -> bytes: ...
        else:
            @deprecated("Removed in Python 3.11.")
            def share(self, process_id: int) -> NoReturn: ...

        @deprecated("Removed in Python 3.11.")
        def recv_into(self, buffer: _WriteBuffer, nbytes: int = 0, flags: int = 0) -> int: ...
        @deprecated("Removed in Python 3.11.")
        def recvfrom_into(self, buffer: _WriteBuffer, nbytes: int = 0, flags: int = 0) -> tuple[int, _RetAddress]: ...
        @deprecated("Removed in Python 3.11.")
        def recvmsg_into(
            self, buffers: Iterable[_WriteBuffer], ancbufsize: int = 0, flags: int = 0, /
        ) -> tuple[int, list[_CMSG], int, Any]: ...
        @deprecated("Removed in Python 3.11.")
        def recvmsg(self, bufsize: int, ancbufsize: int = 0, flags: int = 0, /) -> tuple[bytes, list[_CMSG], int, Any]: ...
        @deprecated("Removed in Python 3.11.")
        def recvfrom(self, bufsize: int, flags: int = 0) -> tuple[bytes, _RetAddress]: ...
        @deprecated("Removed in Python 3.11.")
        def recv(self, bufsize: int, flags: int = 0) -> bytes: ...
        @deprecated("Removed in Python 3.11.")
        def __enter__(self) -> socket.socket: ...
        @deprecated("Removed in Python 3.11.")
        def __exit__(
            self, exc_type: Type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None
        ) -> None: ...
