# Security Policy

## Security Philosophy

At RustFS, we take security seriously. We believe that **transparency leads to better security**. The more open our code is, the more eyes are on it, and the faster we can identify and resolve potential issues.

We highly value the contributions of the security community and welcome anyone to audit our code. Your efforts help us make RustFS safer for everyone.

## Supported Versions

To help us focus our security efforts, please refer to the table below to see which versions of RustFS are currently supported with security updates.

| Version | Supported          |
| ------- | ------------------ |
| Latest  | :white_check_mark: |
| < 1.0   | :x:                |

## Reporting a Vulnerability

If you discover a security vulnerability in RustFS, we appreciate your help in disclosing it to us responsibly.

**Please do not open a public GitHub issue for security vulnerabilities.** Publicly disclosing a vulnerability can put the entire community at risk before a fix is available.

### How to Report

1. https://github.com/rustfs/rustfs/security/advisories/new
2. Please email us directly at: **security@rustfs.com**

In your email, please include:
1.  **Description**: A detailed description of the vulnerability.
2.  **Steps to Reproduce**: Steps or a script to reproduce the issue.
3.  **Impact**: The potential impact of the vulnerability.

### Our Response Process

1.  **Acknowledgment**: We will acknowledge your email within 48 hours.
2.  **Assessment**: We will investigate the issue and determine its severity.
3.  **Fix & Disclosure**: We will work on a patch. Once the patch is released, we will publicly announce the vulnerability and acknowledge your contribution (unless you prefer to remain anonymous).

Thank you for helping keep RustFS and its users safe!
