/*
   cmpsf-1.c from the execute part of the gcc torture tests.
 */

#include <testfwk.h>

#ifdef __SDCC
#pragma std_c99
#endif

#include <limits.h>
#include <float.h>

#define F 140
#define T 13

#if !defined(__SDCC_pdk14) && !defined(__SDCC_pdk15) // Lack of memory
int
feq (float x, float y)
{
  if (x == y)
    return T;
  else
    return F;
}

int
fne (float x, float y)
{
  if (x != y)
    return T;
  else
    return F;
}

int
flt (float x, float y)
{
  if (x < y)
    return T;
  else
    return F;
}

int
fge (float x, float y)
{
  if (x >= y)
    return T;
  else
    return F;
}

int
fgt (float x, float y)
{
  if (x > y)
    return T;
  else
    return F;
}

int
fle (float x, float y)
{
  if (x <= y)
    return T;
  else
    return F;
}

float args[] =
{
  0.0F,
  1.0F,
  -1.0F,
  FLT_MAX,
  FLT_MIN,
  0.0000000000001F,
  123456789.0F,
  -987654321.0F
};

#ifdef __SDCC_mcs51
const
#endif

int correct_results[] =
{
 T, F, F, T, F, T,
 F, T, T, F, F, T,
 F, T, F, T, T, F,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 T, F, F, T, F, T,
 F, T, F, T, T, F,
 F, T, T, F, F, T,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 F, T, T, F, F, T,
 F, T, F, T, T, F,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 T, F, F, T, F, T,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 T, F, F, T, F, T,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 F, T, T, F, F, T,
 F, T, F, T, T, F,
 F, T, T, F, F, T,
 T, F, F, T, F, T,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 F, T, T, F, F, T,
 F, T, F, T, T, F,
 F, T, T, F, F, T,
 F, T, F, T, T, F,
 T, F, F, T, F, T,
 F, T, T, F, F, T,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 F, T, T, F, F, T,
 F, T, F, T, T, F,
 F, T, F, T, T, F,
 T, F, F, T, F, T,
 F, T, F, T, T, F,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 F, T, T, F, F, T,
 T, F, F, T, F, T,
};
#endif

void
testTortureExecute (void)
{
#if !defined(__SDCC_pdk14) && !defined(__SDCC_pdk15) // Lack of memory
  const int *res = correct_results;
  int i, j;

  for (i = 0; i < 8; i++)
    {
      float arg0 = args[i];
      for (j = 0; j < 8; j++)
	{
	  float arg1 = args[j];

	  ASSERT(feq (arg0, arg1) == *res++);
	  ASSERT(fne (arg0, arg1) == *res++);
	  ASSERT(flt (arg0, arg1) == *res++);
	  ASSERT(fge (arg0, arg1) == *res++);
	  ASSERT(fgt (arg0, arg1) == *res++);
	  ASSERT(fle (arg0, arg1) == *res++);
	}
    }
#endif
  return;
}

