! Module to contain all the Gauss-Fermi quadrature points
! It has been created by an automatic script created by:
! Nick Papior Andersen, 2013, nickpapior@gmail.com
! If you ever need to use this please contact the author for approval

! We have employed the Stieltjes and moment algorithm together with the Golub-Welsch
! for an efficient and fairly accurate stability of the orthogonal polynomials.

module m_gauss_fermi_24

  implicit none

  integer, parameter :: p = selected_real_kind(14,300)

  integer, parameter :: G_NF_MIN_N  =  2
  integer, parameter :: G_NF_MAX_N  = 17
  integer, parameter :: G_NF_MIN_kT = -20
  integer, parameter :: G_NF_MAX_kT = 5
  
  private
  public :: G_NF_MIN_N
  public :: G_NF_MAX_N
  public :: G_NF_MIN_kT
  public :: G_NF_MAX_kT
  public :: GaussFermi_24
  
contains

  ! Die routine for the Gauss-Fermi routines
  subroutine GD(NkT)
    integer, intent(in) :: NkT
    write(*,*) 'Error in Gauss-Fermi ',NkT
    call die('Error in number of points for Gauss-Fermi, see output.')
  end subroutine GD
  
  subroutine GaussFermi_24(NkT,N,x,w)
    integer, intent(in) :: NkT, N
    real(p), intent(out) :: x(N), w(N)
    
    if ( NkT == -20 ) then
       call GF_m20(N,x,w)
    else if ( NkT == -19 ) then
       call GF_m19(N,x,w)
    else if ( NkT == -18 ) then
       call GF_m18(N,x,w)
    else if ( NkT == -17 ) then
       call GF_m17(N,x,w)
    else if ( NkT == -16 ) then
       call GF_m16(N,x,w)
    else if ( NkT == -15 ) then
       call GF_m15(N,x,w)
    else if ( NkT == -14 ) then
       call GF_m14(N,x,w)
    else if ( NkT == -13 ) then
       call GF_m13(N,x,w)
    else if ( NkT == -12 ) then
       call GF_m12(N,x,w)
    else if ( NkT == -11 ) then
       call GF_m11(N,x,w)
    else if ( NkT == -10 ) then
       call GF_m10(N,x,w)
    else if ( NkT == -9 ) then
       call GF_m9(N,x,w)
    else if ( NkT == -8 ) then
       call GF_m8(N,x,w)
    else if ( NkT == -7 ) then
       call GF_m7(N,x,w)
    else if ( NkT == -6 ) then
       call GF_m6(N,x,w)
    else if ( NkT == -5 ) then
       call GF_m5(N,x,w)
    else if ( NkT == -4 ) then
       call GF_m4(N,x,w)
    else if ( NkT == -3 ) then
       call GF_m3(N,x,w)
    else if ( NkT == -2 ) then
       call GF_m2(N,x,w)
    else if ( NkT == -1 ) then
       call GF_m1(N,x,w)
    else if ( NkT == 0 ) then
       call GF_0(N,x,w)
    else if ( NkT == 1 ) then
       call GF_1(N,x,w)
    else if ( NkT == 2 ) then
       call GF_2(N,x,w)
    else if ( NkT == 3 ) then
       call GF_3(N,x,w)
    else if ( NkT == 4 ) then
       call GF_4(N,x,w)
    else if ( NkT == 5 ) then
       call GF_5(N,x,w)
    else
       call die('Could not figure out the Gauss-Fermi &
             &quadratue method you asked for.')
    end if
  end subroutine GaussFermi_24
  
  
! [-20kT;24kT]
subroutine GF_m20(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-15.59867300268749_p
w(1)=10.40132057755674_p
x(2)=-3.761795336128115_p
w(2)=9.598679424466665_p
else if(N==3)then
x(1)=-17.56069618868762_p
w(1)=6.008953649840113_p
x(2)=-9.213296033099315_p
w(2)=9.514824281114022_p
x(3)=-1.155162463727344_p
w(3)=4.476222071069267_p
else if(N==4)then
x(1)=-18.43109885427121_p
w(1)=3.928604231128050_p
x(2)=-12.55785559841776_p
w(2)=7.327553605297298_p
x(3)=-5.008577754192857_p
w(3)=7.006527796402510_p
x(4)=6.703025696915813e-1_p
w(4)=1.737314369195543_p
else if(N==5)then
x(1)=-18.89086399498091_p
w(1)=2.799998176513404_p
x(2)=-14.55266227306007_p
w(2)=5.634863161774931_p
x(3)=-8.251806733342889_p
w(3)=6.590035063711966_p
x(4)=-2.226680442465764_p
w(4)=4.558768254994578_p
x(5)=2.575316146430874_p
w(5)=4.163353450285247e-1_p
else if(N==6)then
x(1)=-19.16409581731362_p
w(1)=2.120016070161965_p
x(2)=-15.81256908095239_p
w(2)=4.449422293343676_p
x(3)=-10.6234454468501_p
w(3)=5.711049629641937_p
x(4)=-4.894595547596343_p
w(4)=5.411415485781180_p
x(5)=-2.097514624035037e-1_p
w(5)=2.254496936430900_p
x(6)=4.860501405790717_p
w(6)=5.359958666374476e-2_p
else if(N==7)then
x(1)=-19.34066484937138_p
w(1)=1.677038520330595_p
x(2)=-16.65605289325576_p
w(2)=3.611659738706329_p
x(3)=-12.33728866367811_p
w(3)=4.890033792406550_p
x(4)=-7.192435254409498_p
w(4)=5.214089860595789_p
x(5)=-2.329787294273659_p
w(5)=3.909619712822009_p
x(6)=1.649509234349046_p
w(6)=6.931554220755709e-1_p
x(7)=7.483131532654339_p
w(7)=4.402955086560034e-3_p
else if(N==8)then
x(1)=-19.46222893336895_p
w(1)=1.370474862300734_p
x(2)=-17.25002336430098_p
w(2)=3.002163167720839_p
x(3)=-13.60133575571988_p
w(3)=4.205611034697495_p
x(4)=-9.049524133761571_p
w(4)=4.776743647831411_p
x(5)=-4.328206890628367_p
w(5)=4.437426428612481_p
x(6)=-3.329891111310738e-1_p
w(6)=2.091767295581187_p
x(7)=3.754275505995627_p
w(7)=1.155335110835070e-1_p
x(8)=10.31848900473915_p
w(8)=2.800541957489846e-4_p
else if(N==9)then
x(1)=-19.55041451088603_p
w(1)=1.147292851257816_p
x(2)=-17.6876142002047_p
w(2)=2.543352523635952_p
x(3)=-14.56167967627412_p
w(3)=3.646801966842189_p
x(4)=-10.54034715346655_p
w(4)=4.311592746186598_p
x(5)=-6.130962489187106_p
w(5)=4.385114702454036_p
x(6)=-2.020603225975822_p
w(6)=3.268188370241376_p
x(7)=1.492728416827569_p
w(7)=6.853219999897991e-1_p
x(8)=6.132342539615346_p
w(8)=1.231876331649600e-2_p
x(9)=13.22740728923216_p
w(9)=1.607809914000055e-5_p
else if(N==10)then
x(1)=-19.61738647039131_p
w(1)=9.773587275327028e-1_p
x(2)=-18.02369010965785_p
w(2)=2.185556858348126_p
x(3)=-15.31556994580843_p
w(3)=3.186756318101435_p
x(4)=-11.75499694847297_p
w(4)=3.873810110684308_p
x(5)=-7.705677812020236_p
w(5)=4.144387776854877_p
x(6)=-3.651407078591259_p
w(6)=3.749559490963214_p
x(7)=-1.599880653199166e-1_p
w(7)=1.751283511436751_p
x(8)=3.462185670731799_p
w(8)=1.301823442739498e-1_p
x(9)=8.615720925804384_p
w(9)=1.103836154600389e-3_p
x(10)=15.98366602236429_p
w(10)=1.027673437475724e-6_p
else if(N==11)then
x(1)=-19.67014040153693_p
w(1)=8.432384603851292e-1_p
x(2)=-18.29067101735425_p
w(2)=1.898081978087857_p
x(3)=-15.92431850411241_p
w(3)=2.802555866402822_p
x(4)=-12.76243981997116_p
w(4)=3.476615775205627_p
x(5)=-9.072386495678311_p
w(5)=3.845866259140495_p
x(6)=-5.202557332285444_p
w(6)=3.792653585805848_p
x(7)=-1.631098588303419_p
w(7)=2.728502372090915_p
x(8)=1.547457326590264_p
w(8)=5.944718330572332e-1_p
x(9)=5.567842687329426_p
w(9)=1.791157018328453e-2_p
x(10)=11.02351957342185_p
w(10)=1.022074940356638e-4_p
x(11)=18.30314867923682_p
w(11)=9.417015644128219e-8_p
else if(N==12)then
x(1)=-19.71271181075014_p
w(1)=7.348421745434213e-1_p
x(2)=-18.50752999546007_p
w(2)=1.662556846164592_p
x(3)=-16.42497331626354_p
w(3)=2.478655024150100_p
x(4)=-13.60772717798851_p
w(4)=3.122392416800154_p
x(5)=-10.2562279625927_p
w(5)=3.537739785414173_p
x(6)=-6.629004494567344_p
w(6)=3.655596516272419_p
x(7)=-3.073768031040673_p
w(7)=3.218840764723910_p
x(8)=4.008239830430881e-2_p
w(8)=1.455981480700871_p
x(9)=3.323669009923968_p
w(9)=1.310935737444697e-1_p
x(10)=7.674182266469116_p
w(10)=2.290186662356522e-3_p
x(11)=13.22193854378025_p
w(11)=1.121851642452887e-5_p
x(12)=20.02819079993268_p
w(12)=1.433051239703828e-8_p
else if(N==13)then
x(1)=-19.74760238335069_p
w(1)=6.458979342861911e-1_p
x(2)=-18.68617066346443_p
w(2)=1.467243758913040_p
x(3)=-16.84139067793636_p
w(3)=2.204173111141208_p
x(4)=-14.32159707719468_p
w(4)=2.809899078421703_p
x(5)=-11.27966592458365_p
w(5)=3.241329749291369_p
x(6)=-7.911971424159758_p
w(6)=3.451441317212206_p
x(7)=-4.472383223669127_p
w(7)=3.328182729425082_p
x(8)=-1.308924993142674_p
w(8)=2.307892510356281_p
x(9)=1.600624688895947_p
w(9)=5.206046024159212e-1_p
x(10)=5.163600274558865_p
w(10)=2.302235839336082e-2_p
x(11)=9.681683024636360_p
w(11)=3.112750741299984e-4_p
x(12)=15.1382507409441_p
w(12)=1.573555476688823e-6_p
x(13)=21.20709949539663_p
w(13)=3.537433574204248e-9_p
else if(N==14)then
x(1)=-19.77653839711019_p
w(1)=5.720639991233863e-1_p
x(2)=-18.83492384188767_p
w(2)=1.303753287950066_p
x(3)=-17.19078518295253_p
w(3)=1.970524453339590_p
x(4)=-14.92772491602009_p
w(4)=2.535828582538446_p
x(5)=-12.16417161576469_p
w(5)=2.965992036200113_p
x(6)=-9.052068463410723_p
w(6)=3.226393969199866_p
x(7)=-5.782714398681827_p
w(7)=3.259286875054777_p
x(8)=-2.618668690762626_p
w(8)=2.796481267316333_p
x(9)=2.020356694839371e-1_p
w(9)=1.234156691023421_p
x(10)=3.203142494940849_p
w(10)=1.316065202378885e-1_p
x(11)=6.984616207926068_p
w(11)=3.863886572566966e-3_p
x(12)=11.53253812025658_p
w(12)=4.814216009355713e-5_p
x(13)=16.74917826705653_p
w(13)=2.900390959899393e-7_p
x(14)=21.98629580532164_p
w(14)=1.267760148997447e-9_p
else if(N==15)then
x(1)=-19.80078768817726_p
w(1)=5.101419947592614e-1_p
x(2)=-18.95999028163263_p
w(2)=1.165718600043283_p
x(3)=-17.48633898792233_p
w(3)=1.770620884130976_p
x(4)=-15.44530424536715_p
w(4)=2.295917199804700_p
x(5)=-12.92993439511027_p
w(5)=2.714935695061919_p
x(6)=-10.05962523255988_p
w(6)=3.001072510269110_p
x(7)=-6.982470991333929_p
w(7)=3.118830906141260_p
x(8)=-3.892251702802862_p
w(8)=2.951662142477141_p
x(9)=-1.047326215296798_p
w(9)=1.977996190629015_p
x(10)=1.637867687064875_p
w(10)=4.645051085441126e-1_p
x(11)=4.840357706766913_p
w(11)=2.790823258142916e-2_p
x(12)=8.724287162061856_p
w(12)=6.816837724055368e-4_p
x(13)=13.19555285814141_p
w(13)=8.783316990706684e-6_p
x(14)=18.06644115615435_p
w(14)=6.990212543508369e-8_p
x(15)=22.50316699115028_p
w(15)=5.896742457690227e-10_p
else if(N==16)then
x(1)=-19.82130352260445_p
w(1)=4.577211726829298e-1_p
x(2)=-19.06608315465396_p
w(2)=1.048225150454098_p
x(3)=-17.73830035798431_p
w(3)=1.598640096009313_p
x(4)=-15.88990957097526_p
w(4)=2.085781366506220_p
x(5)=-13.5949615583392_p
w(5)=2.488268284209041_p
x(6)=-10.94854369616623_p
w(6)=2.785115189536583_p
x(7)=-8.067639415478681_p
w(7)=2.951680480631949_p
x(8)=-5.099355188820609_p
w(8)=2.932359799882281_p
x(9)=-2.248507716380824_p
w(9)=2.452173368063225_p
x(10)=3.369691317536201e-1_p
w(10)=1.062699364227585_p
x(11)=3.099801046004525_p
w(11)=1.314803325343662e-1_p
x(12)=6.454158276955668_p
w(12)=5.720865510698748e-3_p
x(13)=10.34547252008776_p
w(13)=1.325900011098093e-4_p
x(14)=14.65895852913716_p
w(14)=1.919981515718638e-6_p
x(15)=19.12358034233625_p
w(15)=2.146501076465693e-8_p
x(16)=22.85380321514875_p
w(16)=3.274778250618258e-10_p
else if(N==17)then
x(1)=-19.83881161138799_p
w(1)=4.129626525348958e-1_p
x(2)=-19.15682155481189_p
w(2)=9.474537994957186e-1_p
x(3)=-17.95467766304388_p
w(3)=1.449845803675583_p
x(4)=-16.27410500688053_p
w(4)=1.901348113023458_p
x(5)=-14.17472577568161_p
w(5)=2.284635010670772_p
x(6)=-11.73317411818144_p
w(6)=2.582849176015967_p
x(7)=-9.043311191641308_p
w(7)=2.777588736633208_p
x(8)=-6.220189961248126_p
w(8)=2.837841535582599_p
x(9)=-3.417223212062754_p
w(9)=2.639106955349158_p
x(10)=-8.273830113437582e-1_p
w(10)=1.713281281749070_p
x(11)=1.667314773556379_p
w(11)=4.194941023952231e-1_p
x(12)=4.578919319767414_p
w(12)=3.234198737106008e-2_p
x(13)=8.000056149951709_p
w(13)=1.221195598413929e-3_p
x(14)=11.82823277153738_p
w(14)=2.914047403772743e-5_p
x(15)=15.92584713015929_p
w(15)=5.031455886863264e-7_p
x(16)=19.96349114045896_p
w(16)=8.103283033658254e-9_p
x(17)=23.09866930203004_p
w(17)=2.053658951277024e-10_p
else
call GD(-20)
end if
end subroutine GF_m20

! [-19kT;24kT]
subroutine GF_m19(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.80201381408804_p
w(1)=9.919648066238159_p
x(2)=-3.526768406421096_p
w(2)=9.080351939326887_p
else if(N==3)then
x(1)=-16.6660216397734_p
w(1)=5.749160031769502_p
x(2)=-8.682923544768451_p
w(2)=9.091369934389105_p
x(3)=-9.856473180026769e-1_p
w(3)=4.159470039406439_p
else if(N==4)then
x(1)=-17.49427675238193_p
w(1)=3.770228881896011_p
x(2)=-11.85930529115386_p
w(2)=7.027559781184674_p
x(3)=-4.631463309932787_p
w(3)=6.664636724572373_p
x(4)=8.528748973059158e-1_p
w(4)=1.537574617911988_p
else if(N==5)then
x(1)=-17.93258568599818_p
w(1)=2.694560120317493_p
x(2)=-13.75864544838509_p
w(2)=5.420025004458377_p
x(3)=-7.703185705094313_p
w(3)=6.322854174720897_p
x(4)=-1.942147592100226_p
w(4)=4.225549297952126_p
x(5)=2.819865502407690_p
w(5)=3.370114081161521e-1_p
else if(N==6)then
x(1)=-18.19357105170432_p
w(1)=2.045182494521512_p
x(2)=-14.96095700978538_p
w(2)=4.290602520082072_p
x(3)=-9.959926729446488_p
w(3)=5.499396375230101_p
x(4)=-4.457119975259079_p
w(4)=5.154166078413345_p
x(5)=4.405802849504566e-2_p
w(5)=1.971041876806077_p
x(6)=5.178104737523014_p
w(6)=3.961066051193717e-2_p
else if(N==7)then
x(1)=-18.36256072214862_p
w(1)=1.621288190211344_p
x(2)=-15.76763021233614_p
w(2)=3.490345135127827_p
x(3)=-11.5957884762942_p
w(3)=4.720942299604829_p
x(4)=-6.635876434313664_p
w(4)=5.012339070238354_p
x(5)=-1.980557964843317_p
w(5)=3.602869297636925_p
x(6)=1.941969645017223_p
w(6)=5.491701870653168e-1_p
x(7)=7.859570384893868_p
w(7)=3.045825680449450e-3_p
else if(N==8)then
x(1)=-18.47916592642661_p
w(1)=1.327269160745879_p
x(2)=-16.33702324881286_p
w(2)=2.906601302492267_p
x(3)=-12.80576278982002_p
w(3)=4.068453412825227_p
x(4)=-8.406556374606859_p
w(4)=4.609896170237019_p
x(5)=-3.865308701912095_p
w(5)=4.213504036625523_p
x(6)=-2.536953485780791e-2_p
w(6)=1.791446522928228_p
x(7)=4.113164394939204_p
w(7)=8.264423048694410e-2_p
x(8)=10.73665155054409_p
w(8)=1.851692239569577e-4_p
else if(N==9)then
x(1)=-18.56399580541482_p
w(1)=1.112602997776541_p
x(2)=-16.75775611349085_p
w(2)=2.465778228453395_p
x(3)=-13.72807746827237_p
w(3)=3.533260574837321_p
x(4)=-9.834629485995478_p
w(4)=4.170596878963708_p
x(5)=-5.578071290632127_p
w(5)=4.212891276167098_p
x(6)=-1.641639757264597_p
w(6)=2.969874579195582_p
x(7)=1.827082861312402_p
w(7)=5.267042278681097e-1_p
x(8)=6.539069672227616_p
w(8)=8.280819500523132e-3_p
x(9)=13.66092450274947_p
w(9)=1.042280276715153e-5_p
else if(N==10)then
x(1)=-18.6286254416012_p
w(1)=9.486261472245281e-1_p
x(2)=-17.08195370404457_p
w(2)=2.120814827465074_p
x(3)=-14.45470467071411_p
w(3)=3.090721022880928_p
x(4)=-11.00322899225689_p
w(4)=3.752656034771232_p
x(5)=-7.085632058956550_p
w(5)=4.000523318075562_p
x(6)=-3.186917669506155_p
w(6)=3.533209099941125_p
x(7)=1.783150343197507e-1_p
w(7)=1.461691761699081_p
x(8)=3.845577094700830_p
w(8)=9.103326729267042e-2_p
x(9)=9.040177210040941_p
w(9)=7.238466275347025e-4_p
x(10)=16.3880549329345_p
w(10)=6.795873099239127e-7_p
else if(N==11)then
x(1)=-18.67965645677425_p
w(1)=8.188949004730702e-1_p
x(2)=-17.34013696907659_p
w(2)=1.842929430175660_p
x(3)=-15.04300715123709_p
w(3)=2.719959462402670_p
x(4)=-11.97554444958956_p
w(4)=3.371173343009662_p
x(5)=-8.400572041077183_p
w(5)=3.721096273292112_p
x(6)=-4.665576350230820_p
w(6)=3.632256468027370_p
x(7)=-1.244067970393968_p
w(7)=2.435498725542343_p
x(8)=1.904613668155229_p
w(8)=4.461503083079858e-1_p
x(9)=5.978279108155471_p
w(9)=1.197375621984970e-2_p
x(10)=11.43799532937354_p
w(10)=6.727208776775434e-5_p
x(11)=18.63465673871991_p
w(11)=6.602655557809119e-8_p
else if(N==12)then
x(1)=-18.72088749729746_p
w(1)=7.139173155760266e-1_p
x(2)=-17.55011592619363_p
w(2)=1.614953722806554_p
x(3)=-15.52752303174661_p
w(3)=2.406847448870797_p
x(4)=-12.79275441584964_p
w(4)=3.029866795750364_p
x(5)=-9.542642630321959_p
w(5)=3.427816784723719_p
x(6)=-6.033650594417137_p
w(6)=3.524460282767942_p
x(7)=-2.617388975198107_p
w(7)=3.002082381834579_p
x(8)=3.949892749851304e-1_p
w(8)=1.187719434482581_p
x(9)=3.714996923147611_p
w(9)=9.081528060058656e-2_p
x(10)=8.088341876363009_p
w(10)=1.512987677245339e-3_p
x(11)=13.60637252652469_p
w(11)=7.559669880123998e-6_p
x(12)=20.27308647310945_p
w(12)=1.080477017752232e-8_p
else if(N==13)then
x(1)=-18.75469956834051_p
w(1)=6.277264630116794e-1_p
x(2)=-17.72319854591715_p
w(2)=1.425770466399086_p
x(3)=-15.93080969699038_p
w(3)=2.141255320017911_p
x(4)=-13.48356049367774_p
w(4)=2.728216305392593_p
x(5)=-10.53147164500325_p
w(5)=3.143716312285522_p
x(6)=-7.268634633344726_p
w(6)=3.338030188070555_p
x(7)=-3.950955562240899_p
w(7)=3.172281817975978_p
x(8)=-9.172735145737935e-1_p
w(8)=2.023287864211467_p
x(9)=1.971928505428495_p
w(9)=3.841214336631393e-1_p
x(10)=5.572591301083372_p
w(10)=1.538574892305095e-2_p
x(11)=10.08377095758198_p
w(11)=2.069842087089669e-4_p
x(12)=15.48079842338445_p
w(12)=1.098561655364503e-6_p
x(13)=21.3788575729542_p
w(13)=2.843698860069523e-9_p
else if(N==14)then
x(1)=-18.78275328318994_p
w(1)=5.561466798495537e-1_p
x(2)=-17.86739054790493_p
w(2)=1.267330315101052_p
x(3)=-16.26936858562508_p
w(3)=1.915015041410353_p
x(4)=-14.07051096440236_p
w(4)=2.463318344297744_p
x(5)=-11.38697759994822_p
w(5)=2.878824854410968_p
x(6)=-8.368590138014202_p
w(6)=3.125843464788154_p
x(7)=-5.206790938390328_p
w(7)=3.136048100242745_p
x(8)=-2.167914377333289_p
w(8)=2.577839129205043_p
x(9)=5.707557808884028e-1_p
w(9)=9.865179787810018e-1_p
x(10)=3.600572708306498_p
w(10)=9.052347339559721e-2_p
x(11)=7.394298884637958_p
w(11)=2.559819120659175e-3_p
x(12)=11.91187326792551_p
w(12)=3.259296854962501e-5_p
x(13)=17.04496124472407_p
w(13)=2.109241344542121e-7_p
x(14)=22.1057975963939_p
w(14)=1.069489534408632e-9_p
else if(N==15)then
x(1)=-18.80627272294063_p
w(1)=4.960904462911757e-1_p
x(2)=-17.98867445471056_p
w(2)=1.133497006800044_p
x(3)=-16.55589651030285_p
w(3)=1.721330902877459_p
x(4)=-14.57201770072684_p
w(4)=2.231202520810801_p
x(5)=-12.12827186448311_p
w(5)=2.636717703793740_p
x(6)=-9.342201975642121_p
w(6)=2.910857072790523_p
x(7)=-6.361157241450914_p
w(7)=3.013841836246033_p
x(8)=-3.382382417548707_p
w(8)=2.796185235339994_p
x(9)=-6.498709615483859e-1_p
w(9)=1.703321523091756_p
x(10)=2.021037591682396_p
w(10)=3.378825523342963e-1_p
x(11)=5.250420632770021_p
w(11)=1.861273003422155e-2_p
x(12)=9.122997482333270_p
w(12)=4.543230062119927e-4_p
x(13)=13.54527116545119_p
w(13)=6.098664566328290e-6_p
x(14)=18.31611399185896_p
w(14)=5.296950513287163e-8_p
x(15)=22.58769191685593_p
w(15)=5.147193657421243e-10_p
else if(N==16)then
x(1)=-18.82617876135603_p
w(1)=4.452292372305549e-1_p
x(2)=-18.0916005561073_p
w(2)=1.019529979766750_p
x(3)=-16.80027395326733_p
w(3)=1.554609073892762_p
x(4)=-15.00305015940261_p
w(4)=2.027725426561386_p
x(5)=-12.77251669833075_p
w(5)=2.417762773964002_p
x(6)=-10.20218206370387_p
w(6)=2.703603584685443_p
x(7)=-7.407977798454915_p
w(7)=2.858756498209557_p
x(8)=-4.538557397889061_p
w(8)=2.813376914028977_p
x(9)=-1.800824789682532_p
w(9)=2.231684919975528_p
x(10)=7.179137491776281e-1_p
w(10)=8.339915253035893e-1_p
x(11)=3.503114913287478_p
w(11)=8.985038662117473e-2_p
x(12)=6.863233574667777_p
w(12)=3.788609994109402e-3_p
x(13)=10.72543729920521_p
w(13)=8.968538909014900e-5_p
x(14)=14.97549604756157_p
w(14)=1.372753623606960e-6_p
x(15)=19.33144174220015_p
w(15)=1.689573446628071e-8_p
x(16)=22.9151760097858_p
w(16)=2.927642479342448e-10_p
else if(N==17)then
x(1)=-18.84317255125971_p
w(1)=4.017866067661773e-1_p
x(2)=-18.17966363433026_p
w(2)=9.217440454638903e-1_p
x(3)=-17.01022514159221_p
w(3)=1.410294052215656_p
x(4)=-15.37569686385546_p
w(4)=1.849011613165223_p
x(5)=-13.33451076283041_p
w(5)=2.220810527190453_p
x(6)=-10.96196773570686_p
w(6)=2.508830194666069_p
x(7)=-8.350832289133564_p
w(7)=2.693821431675318_p
x(8)=-5.616483328904780_p
w(8)=2.738707193154839_p
x(9)=-2.916162933465044_p
w(9)=2.481507058119706_p
x(10)=-4.237413068962154e-1_p
w(10)=1.449692943164218_p
x(11)=2.060532724105618_p
w(11)=3.014501290959836e-1_p
x(12)=4.991170938863042_p
w(12)=2.151045804319850e-2_p
x(13)=8.398848939737297_p
w(13)=8.132599924650614e-4_p
x(14)=12.18450142821271_p
w(14)=2.011514449059716e-5_p
x(15)=16.20838575491506_p
w(15)=3.709270901070783e-7_p
x(16)=20.13551331801062_p
w(16)=6.593530649033951e-9_p
x(17)=23.14449835732403_p
w(17)=1.867369500959933e-10_p
else
call GD(-19)
end if
end subroutine GF_m19

! [-18kT;24kT]
subroutine GF_m18(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-14.00466036182939_p
w(1)=9.439548869330253_p
x(2)=-3.289241403265918_p
w(2)=8.560451145861975_p
else if(N==3)then
x(1)=-15.77082962895018_p
w(1)=5.490612522533805_p
x(2)=-8.150660695594258_p
w(2)=8.668234953602983_p
x(3)=-8.100979078173212e-1_p
w(3)=3.841152539055440_p
else if(N==4)then
x(1)=-16.55710093956438_p
w(1)=3.612722717279050_p
x(2)=-11.15925639169111_p
w(2)=6.728670585015927_p
x(3)=-4.252904219580433_p
w(3)=6.315427747900826_p
x(4)=1.047528334476888_p
w(4)=1.343178964996426_p
else if(N==5)then
x(1)=-16.97407044989962_p
w(1)=2.589709824442103_p
x(2)=-12.96356785365198_p
w(2)=5.206104430090144_p
x(3)=-7.153095261005293_p
w(3)=6.054178296516922_p
x(4)=-1.655012745277280_p
w(4)=3.882555811082394_p
x(5)=3.082172939813776_p
w(5)=2.674516530606653e-1_p
else if(N==6)then
x(1)=-17.22288858695379_p
w(1)=1.970742035117362_p
x(2)=-14.10862029726954_p
w(2)=4.132446357088415_p
x(3)=-9.295211374580182_p
w(3)=5.287633578894966_p
x(4)=-4.019880457508545_p
w(4)=4.886057195410135_p
x(5)=3.084880062026711e-1_p
w(5)=1.694422974329717_p
x(6)=5.514320896514470_p
w(6)=2.869787435163248e-2_p
else if(N==7)then
x(1)=-17.3843545213283_p
w(1)=1.565792817430538_p
x(2)=-14.87873358144099_p
w(2)=3.369473788809177_p
x(3)=-10.85345849454414_p
w(3)=4.551956032351886_p
x(4)=-6.079223034462061_p
w(4)=4.806638680773839_p
x(5)=-1.631072579492308_p
w(5)=3.279761599062671_p
x(6)=2.253737765872149_p
w(6)=4.243077461379304e-1_p
x(7)=8.253462278677201_p
w(7)=2.069350626186369e-3_p
else if(N==8)then
x(1)=-17.49604513936577_p
w(1)=1.284207502161912_p
x(2)=-15.42375735669503_p
w(2)=2.811283958863040_p
x(3)=-12.00973572786134_p
w(3)=3.931343689403570_p
x(4)=-7.763533983013073_p
w(4)=4.441477954713568_p
x(5)=-3.404908595555906_p
w(5)=3.973485424580862_p
x(6)=2.922763769855594e-1_p
w(6)=1.500308201985534_p
x(7)=4.492002034861260_p
w(7)=5.777274682651806e-2_p
x(8)=11.16988689580722_p
w(8)=1.205366572240886e-4_p
else if(N==9)then
x(1)=-17.57755627783419_p
w(1)=1.077964115457819_p
x(2)=-15.82781084038159_p
w(2)=2.388269622721637_p
x(3)=-12.89437683417736_p
w(3)=3.419629536931055_p
x(4)=-9.129166244551202_p
w(4)=4.028715345133011_p
x(5)=-5.027328081247026_p
w(5)=4.033149182255054_p
x(6)=-1.263670818467404_p
w(6)=2.653488329864673_p
x(7)=2.180775729490358_p
w(7)=3.933067388862407e-1_p
x(8)=6.961820630105115_p
w(8)=5.470458015206666e-3_p
x(9)=14.1038685061142_p
w(9)=6.685927532993154e-6_p
else if(N==10)then
x(1)=-17.63986649645526_p
w(1)=9.198867872651602e-1_p
x(2)=-16.14024139466003_p
w(2)=2.056026098283414_p
x(3)=-13.59396636927807_p
w(3)=2.994500082773521_p
x(4)=-10.25194617582025_p
w(4)=3.630852118964852_p
x(5)=-6.467323402655586_p
w(5)=3.853257483182129_p
x(6)=-2.727077184295417_p
w(6)=3.295576916371792_p
x(7)=5.269567424581242e-1_p
w(7)=1.187198203817382_p
x(8)=4.247062944731958_p
w(8)=6.223294894841685e-2_p
x(9)=9.475643896591636_p
w(9)=4.689273971650063e-4_p
x(10)=16.79284837158307_p
w(10)=4.481883956425820e-7_p
else if(N==11)then
x(1)=-17.68918203864783_p
w(1)=7.945259718907819e-1_p
x(2)=-16.38966153115351_p
w(2)=1.787698001766187_p
x(3)=-14.16188309687948_p
w(3)=2.637168056413746_p
x(4)=-11.18915140496933_p
w(4)=3.265235060419265_p
x(5)=-7.730111232429785_p
w(5)=3.594560261441984_p
x(6)=-4.132519846237026_p
w(6)=3.460266103827586_p
x(7)=-8.574791303817072e-1_p
w(7)=2.127605783811512_p
x(8)=2.280051354927253_p
w(8)=3.250143644948200e-1_p
x(9)=6.402066491183691_p
w(9)=7.882417026678091e-3_p
x(10)=11.85862393664566_p
w(10)=4.394763673673208e-5_p
x(11)=18.9593752755716_p
w(11)=4.646293219425319e-8_p
else if(N==12)then
x(1)=-17.72907273941094_p
w(1)=6.929672748556932e-1_p
x(2)=-16.59275820103404_p
w(2)=1.567277896420715_p
x(3)=-14.63024160856763_p
w(3)=2.334876391986867_p
x(4)=-11.97819985308808_p
w(4)=2.936971006130981_p
x(5)=-8.830068296640388_p
w(5)=3.316848592088275_p
x(6)=-5.441000256819568_p
w(6)=3.387932189410167_p
x(7)=-2.165942924434713_p
w(7)=2.761045353510668_p
x(8)=7.612644311715674e-1_p
w(8)=9.395324432011890e-1_p
x(9)=4.122834766004735_p
w(9)=6.155489535737738e-2_p
x(10)=8.511837350626605_p
w(10)=9.888886483442358e-4_p
x(11)=13.99295381158529_p
w(11)=5.075388295638184e-6_p
x(12)=20.50925596554804_p
w(12)=8.193656019143497e-9_p
else if(N==13)then
x(1)=-17.76180494083945_p
w(1)=6.095334838938020e-1_p
x(2)=-16.76027405519822_p
w(2)=1.384236605333372_p
x(3)=-15.02036816128534_p
w(3)=2.078206544533456_p
x(4)=-12.64585742817616_p
w(4)=2.646254453109010_p
x(5)=-9.784037883184286_p
w(5)=3.045420099816783_p
x(6)=-6.627155747040248_p
w(6)=3.221961305215266_p
x(7)=-3.434137800150216_p
w(7)=3.000726483418373_p
x(8)=-5.243994760896230e-1_p
w(8)=1.728416406767337_p
x(9)=2.360847477163524_p
w(9)=2.749750522660066e-1_p
x(10)=5.993920729202270_p
w(10)=1.013218154224667e-2_p
x(11)=10.49190451833915_p
w(11)=1.366306925860394e-4_p
x(12)=15.82251689316357_p
w(12)=7.663062100756657e-7_p
x(13)=21.54323085614463_p
w(13)=2.297779374377387e-9_p
else if(N==14)then
x(1)=-17.78897522169275_p
w(1)=5.402108817134432e-1_p
x(2)=-16.89989783289309_p
w(2)=1.230856347042349_p
x(3)=-15.34806856616184_p
w(3)=1.859398850948768_p
x(4)=-13.21356810890809_p
w(4)=2.390591288300716_p
x(5)=-10.61037471629143_p
w(5)=2.791177507554188_p
x(6)=-7.686447376091707_p
w(6)=3.023819268177117_p
x(7)=-4.634197968076606_p
w(7)=3.004962458535800_p
x(8)=-1.721560361930527_p
w(8)=2.333790429476339_p
x(9)=9.517248352853604e-1_p
w(9)=7.625501338585264e-1_p
x(10)=4.013554962267862_p
w(10)=6.094232920865491e-2_p
x(11)=7.812838374042104_p
w(11)=1.678401325407770e-3_p
x(12)=12.29451111308972_p
w(12)=2.196459787138186e-5_p
x(13)=17.33802827321486_p
w(13)=1.535474506924921e-7_p
x(14)=22.21994346621027_p
w(14)=9.055969890374642e-10_p
else if(N==15)then
x(1)=-17.81176396612918_p
w(1)=4.820226704333503e-1_p
x(2)=-17.01739397784535_p
w(2)=1.101231499721277_p
x(3)=-15.62555376849167_p
w(3)=1.671951763926140_p
x(4)=-13.69895715150538_p
w(4)=2.166314390505488_p
x(5)=-11.32708371859161_p
w(5)=2.558143373306703_p
x(6)=-8.625784490103294_p
w(6)=2.819726908962521_p
x(7)=-5.742182872855829_p
w(7)=2.904959560131534_p
x(8)=-2.877501018249784_p
w(8)=2.621251600064119_p
x(9)=-2.495777354389281e-1_p
w(9)=1.423466147581665_p
x(10)=2.421144389513266_p
w(10)=2.383912161059206e-1_p
x(11)=5.672167936757054_p
w(11)=1.223604415097532e-2_p
x(12)=9.527784959195523_p
w(12)=3.005754075381212e-4_p
x(13)=13.8961122574608_p
w(13)=4.224225654546857e-6_p
x(14)=18.56217709911617_p
w(14)=4.021894298522112e-8_p
x(15)=22.66852615875245_p
w(15)=4.504009801830497e-10_p
else if(N==16)then
x(1)=-17.83105953364006_p
w(1)=4.327228700659603e-1_p
x(2)=-17.11714917221033_p
w(2)=9.907964342470156e-1_p
x(3)=-15.86233420622117_p
w(3)=1.510502282392781_p
x(4)=-14.11638265817581_p
w(4)=1.969527524307169_p
x(5)=-11.95046189053735_p
w(5)=2.346982321866065_p
x(6)=-9.456606495898603_p
w(6)=2.621471858095108_p
x(7)=-6.750010455883440_p
w(7)=2.763742114033669_p
x(8)=-3.981662634900758_p
w(8)=2.683669119346987_p
x(9)=-1.356709852910299_p
w(9)=1.986352442455577_p
x(10)=1.111626606590035_p
w(10)=6.315754003835791e-1_p
x(11)=3.921146900646941_p
w(11)=6.011263920808791e-2_p
x(12)=7.280819912073754_p
w(12)=2.483655417420435e-3_p
x(13)=11.10922953175465_p
w(13)=6.035912866072328e-5_p
x(14)=15.29156466319506_p
w(14)=9.806521728542377e-7_p
x(15)=19.53552324352176_p
w(15)=1.332984278205518e-8_p
x(16)=22.97401883970763_p
w(16)=2.621323929450562e-10_p
else if(N==17)then
x(1)=-17.84753845260025_p
w(1)=3.905976452858991e-1_p
x(2)=-17.2025334804361_p
w(2)=8.960004602734790e-1_p
x(3)=-16.06584864706634_p
w(3)=1.370677102985676_p
x(4)=-14.47745381120047_p
w(4)=1.796556868575063_p
x(5)=-12.49462232294493_p
w(5)=2.156767682566158_p
x(6)=-10.19139331309189_p
w(6)=2.434362997488588_p
x(7)=-7.659629590075232_p
w(7)=2.608814048046781_p
x(8)=-5.015607341081609_p
w(8)=2.634063081108078_p
x(9)=-2.420201824516478_p
w(9)=2.301319716442427_p
x(10)=-1.582152584705782e-2_p
w(10)=1.186083890189629_p
x(11)=2.469977176217690_p
w(11)=2.100996472865273e-1_p
x(12)=5.414565628901968_p
w(12)=1.410513043211319e-2_p
x(13)=8.803694057849956_p
w(13)=5.376251455354926e-4_p
x(14)=12.54280978283143_p
w(14)=1.384030769854072e-5_p
x(15)=16.48941234055333_p
w(15)=2.735116889193958e-7_p
x(16)=20.30400221517012_p
w(16)=5.376935722119423e-9_p
x(17)=23.18856794676019_p
w(17)=1.699493913875002e-10_p
else
call GD(-18)
end if
end subroutine GF_m18

! [-17kT;24kT]
subroutine GF_m17(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-13.20653105425506_p
w(1)=8.961195865940541_p
x(2)=-3.048806098227249_p
w(2)=8.038804175421085_p
else if(N==3)then
x(1)=-14.87507692770117_p
w(1)=5.233410319798726_p
x(2)=-7.616418753852708_p
w(2)=8.245051514803151_p
x(3)=-6.275441197777321e-1_p
w(3)=3.521538206759747_p
else if(N==4)then
x(1)=-15.61955180295291_p
w(1)=3.456131242878535_p
x(2)=-10.45765712794977_p
w(2)=6.430831139642910_p
x(3)=-3.872961295107389_p
w(3)=5.957223009157726_p
x(4)=1.255976080575594_p
w(4)=1.155814649682454_p
else if(N==5)then
x(1)=-16.01531094028397_p
w(1)=2.485463810978831_p
x(2)=-12.16741416847564_p
w(2)=4.993075713462653_p
x(3)=-6.601686461429098_p
w(3)=5.783127981322527_p
x(4)=-1.364403158286850_p
w(4)=3.530594421122940_p
x(5)=3.363759915737076_p
w(5)=2.077381144746749e-1_p
else if(N==6)then
x(1)=-16.25204734134974_p
w(1)=1.896696195096563_p
x(2)=-13.25556560054262_p
w(2)=3.974925112416886_p
x(3)=-8.629407145960789_p
w(3)=5.075433400911632_p
x(4)=-3.583255183277243_p
w(4)=4.604265487810887_p
x(5)=5.857985276396115e-1_p
w(5)=1.428314702517608_p
x(6)=5.870081348653314_p
w(6)=2.036514260805033e-2_p
else if(N==7)then
x(1)=-16.40604887456392_p
w(1)=1.510544917925106_p
x(2)=-13.98938389764919_p
w(2)=3.249010322410232_p
x(3)=-10.11039783405956_p
w(3)=4.382900753347554_p
x(4)=-5.522920483745962_p
w(4)=4.595302569333096_p
x(5)=-1.280285544270271_p
w(5)=2.941770750189540_p
x(6)=2.586629126452707_p
w(6)=3.190907895802664e-1_p
x(7)=8.665434597764884_p
w(7)=1.379938575830776e-3_p
else if(N==8)then
x(1)=-16.51287200900556_p
w(1)=1.241275508423206_p
x(2)=-14.5102583387426_p
w(2)=2.716167532433952_p
x(3)=-11.21336092121411_p
w(3)=3.794155233494143_p
x(4)=-7.120803129085421_p
w(4)=4.270738914710298_p
x(5)=-2.947524008373410_p
w(5)=3.713618543535353_p
x(6)=6.228283868236844e-1_p
w(6)=1.224510408578530_p
x(7)=4.891320383494235_p
w(7)=3.945666530446292e-2_p
x(8)=11.6183141815239_p
w(8)=7.723488168099765e-5_p
else if(N==9)then
x(1)=-16.59110239763702_p
w(1)=1.043359351412964_p
x(2)=-14.89781478909388_p
w(2)=2.310781608078751_p
x(3)=-12.06068209488943_p
w(3)=3.305806841419952_p
x(4)=-8.424230858428155_p
w(4)=3.885567987003747_p
x(5)=-4.479470037768011_p
w(5)=3.842995752327493_p
x(6)=-8.849989436288528e-1_p
w(6)=2.322944157587457_p
x(7)=2.555399226599498_p
w(7)=2.849882612293853e-1_p
x(8)=7.400554316051676_p
w(8)=3.551835714246466e-3_p
x(9)=14.55540201685697_p
w(9)=4.246587629231891e-6_p
else if(N==10)then
x(1)=-16.65111466881487_p
w(1)=8.911275515296201e-1_p
x(2)=-15.19858131317471_p
w(2)=1.991156173454301_p
x(3)=-12.7334339257109_p
w(3)=2.898020113724033_p
x(4)=-9.501341889468963_p
w(4)=3.508183654246053_p
x(5)=-5.851281202700524_p
w(5)=3.701190594858393_p
x(6)=-2.272066158010967_p
w(6)=3.033260208839592_p
x(7)=8.891080614810926e-1_p
w(7)=9.351485257874032e-1_p
x(8)=4.666660252931373_p
w(8)=4.161271891680451e-2_p
x(9)=9.921735921549873_p
w(9)=3.002048808955182e-4_p
x(10)=17.19657763984178_p
w(10)=2.951245299930615e-7_p
else if(N==11)then
x(1)=-16.69872040301528_p
w(1)=7.701231764690158e-1_p
x(2)=-15.43926311993507_p
w(2)=1.732364820887279_p
x(3)=-13.28099877068338_p
w(3)=2.554132463775458_p
x(4)=-10.40338870954053_p
w(4)=3.158671338414143_p
x(5)=-7.061343968772424_p
w(5)=3.465599125530266_p
x(6)=-3.604116021042502_p
w(6)=3.272644613388199_p
x(7)=-4.688123119486446e-1_p
w(7)=1.811595212877815_p
x(8)=2.674991480784391_p
w(8)=2.297288657974823e-1_p
x(9)=6.838957814689716_p
w(9)=5.111882931216789e-3_p
x(10)=12.28486789312438_p
w(10)=2.850844762937811e-5_p
x(11)=19.27626372031049_p
w(11)=3.284311927198167e-8_p
else if(N==12)then
x(1)=-16.73726989139055_p
w(1)=6.719858980807116e-1_p
x(2)=-15.63547020053466_p
w(2)=1.519512678267937_p
x(3)=-13.73316724688641_p
w(3)=2.262706215334990_p
x(4)=-11.16415533683165_p
w(4)=2.843619009687290_p
x(5)=-8.118734847549128_p
w(5)=3.204495043281761_p
x(6)=-4.851669762134819_p
w(6)=3.243731085096182_p
x(7)=-1.718978928999582_p
w(7)=2.493924822063049_p
x(8)=1.142037274772800_p
w(8)=7.185265937396837e-1_p
x(9)=4.547048583816839_p
w(9)=4.085566026063307e-2_p
x(10)=8.944361773203799_p
w(10)=6.396327527665194e-4_p
x(11)=14.38110968426854_p
w(11)=3.396545260963543e-6_p
x(12)=20.73637024098587_p
w(12)=6.251359392390572e-9_p
else if(N==13)then
x(1)=-16.76892046038682_p
w(1)=5.913138814139808e-1_p
x(2)=-15.7974082557939_p
w(2)=1.342628489430548_p
x(3)=-14.11009718439932_p
w(3)=2.014998523006160_p
x(4)=-11.80856023158287_p
w(4)=2.563951117594493_p
x(5)=-9.037533093605180_p
w(5)=2.946243838280354_p
x(6)=-5.987974702587500_p
w(6)=3.102106241379155_p
x(7)=-2.922540522184105_p
w(7)=2.808738933403911_p
x(8)=-1.272459031081351e-1_p
w(8)=1.432320629983782_p
x(9)=2.768303146560342_p
w(9)=1.910298211111537e-1_p
x(10)=6.427279462046467_p
w(10)=6.578470144689208e-3_p
x(11)=10.9057162672748_p
w(11)=8.955942824028755e-5_p
x(12)=16.16288613459009_p
w(12)=5.343189705485413e-7_p
x(13)=21.70025509582804_p
w(13)=1.866186008645425e-9_p
else if(N==14)then
x(1)=-16.7952059172983_p
w(1)=5.242521627853158e-1_p
x(2)=-15.93245524202331_p
w(2)=1.194319696804735_p
x(3)=-14.42691150802258_p
w(3)=1.803652579786228_p
x(4)=-12.35695576115041_p
w(4)=2.317599648932993_p
x(5)=-9.834492950689851_p
w(5)=2.702923395711786_p
x(6)=-7.005953275486637_p
w(6)=2.919745727535758_p
x(7)=-4.065645490162223_p
w(7)=2.862716967758305_p
x(8)=-1.278518416870825_p
w(8)=2.064861312861095_p
x(9)=1.347852439728898_p
w(9)=5.686231073284014e-1_p
x(10)=4.441829736572245_p
w(10)=4.020108625761897e-2_p
x(11)=8.239917265890231_p
w(11)=1.089503978226424e-3_p
x(12)=12.680056275338_p
w(12)=1.473892140242372e-5_p
x(13)=17.62797927779535_p
w(13)=1.119301616073873e-7_p
x(14)=22.32885815092595_p
w(14)=7.695981553654716e-10_p
else if(N==15)then
x(1)=-16.81726290789475_p
w(1)=4.679347902208617e-1_p
x(2)=-16.04615713739739_p
w(2)=1.068912018691151_p
x(3)=-14.69533334703245_p
w(3)=1.622463972652644_p
x(4)=-12.82617217735269_p
w(4)=2.101215063517331_p
x(5)=-10.52647338171512_p
w(5)=2.479124971811300_p
x(6)=-7.910602933857246_p
w(6)=2.727363624323257_p
x(7)=-5.126104067697650_p
w(7)=2.790397515712619_p
x(8)=-2.377972180470003_p
w(8)=2.422019237425144_p
x(9)=1.569366472147148e-1_p
w(9)=1.149146899458566_p
x(10)=2.838851954295424_p
w(10)=1.632871228116280e-1_p
x(11)=6.105220375454435_p
w(11)=7.934415399153976e-3_p
x(12)=9.938321370940651_p
w(12)=1.974586867509228e-4_p
x(13)=14.24769817868955_p
w(13)=2.919650962797338e-6_p
x(14)=18.80436732588442_p
w(14)=3.060520935706661e-8_p
x(15)=22.74578283303631_p
w(15)=3.950459747731818e-10_p
else if(N==16)then
x(1)=-16.83594714344168_p
w(1)=4.201986827315898e-1_p
x(2)=-16.14273621388876_p
w(2)=9.620158189819781e-1_p
x(3)=-14.92450055087125_p
w(3)=1.466303253030265_p
x(4)=-13.229948885996_p
w(4)=1.911157150167154_p
x(5)=-11.12888124592301_p
w(5)=2.275862599249917_p
x(6)=-8.711992328158766_p
w(6)=2.538527559793432_p
x(7)=-6.094143487098748_p
w(7)=2.665704763477336_p
x(8)=-3.429402880347777_p
w(8)=2.538936727187482_p
x(9)=-9.144467016600618e-1_p
w(9)=1.719426643703133_p
x(10)=1.520734454734268_p
w(10)=4.607857102022174e-1_p
x(11)=4.353541833755538_p
w(11)=3.942760907919090e-2_p
x(12)=7.706577054960428_p
w(12)=1.612383596430446e-3_p
x(13)=11.49652099731383_p
w(13)=4.042925234637244e-5_p
x(14)=15.60683767357549_p
w(14)=7.001321189178739e-7_p
x(15)=19.73567469624955_p
w(15)=1.054199099062617e-8_p
x(16)=23.03041434695901_p
w(16)=2.350423799875516e-10_p
else if(N==17)then
x(1)=-16.85191045993293_p
w(1)=3.793927970055512e-1_p
x(2)=-16.22543739311785_p
w(2)=8.702154903796684e-1_p
x(3)=-15.12156500214075_p
w(3)=1.330980916155015_p
x(4)=-13.57941146729674_p
w(4)=1.743958768235415_p
x(5)=-11.65513007518002_p
w(5)=2.092457292268289_p
x(6)=-9.421588648545669_p
w(6)=2.359321602043261_p
x(7)=-6.970001958451292_p
w(7)=2.522058676976504_p
x(8)=-4.418213910814790_p
w(8)=2.521316487957414_p
x(9)=-1.929330380764218_p
w(9)=2.094430314313191_p
x(10)=3.999140902344248e-1_p
w(10)=9.341519661608237e-1_p
x(11)=2.896102517666336_p
w(11)=1.422266759531891e-1_p
x(12)=5.848671443933688_p
w(12)=9.126441205190992e-3_p
x(13)=9.214276999960029_p
w(13)=3.529117968773895e-4_p
x(14)=12.90284785087304_p
w(14)=9.494596698831007e-6_p
x(15)=16.76866649219188_p
w(15)=2.017650390965561e-7_p
x(16)=20.46888393848727_p
w(16)=4.394699461202385e-9_p
x(17)=23.23093465289336_p
w(17)=1.547962497577124e-10_p
else
call GD(-17)
end if
end subroutine GF_m17

! [-16kT;24kT]
subroutine GF_m16(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-12.40753460331998_p
w(1)=8.484775123007063_p
x(2)=-2.804962850290437_p
w(2)=7.515224989490354_p
else if(N==3)then
x(1)=-13.97871823628258_p
w(1)=4.977654996490942_p
x(2)=-7.080128339462077_p
w(2)=7.821265235177750_p
x(3)=-4.368118209623948e-1_p
w(3)=3.201079880828725_p
else if(N==4)then
x(1)=-14.6816105370649_p
w(1)=3.300496793879630_p
x(2)=-9.754472077464161_p
w(2)=6.133925421063274_p
x(3)=-3.491672581288452_p
w(3)=5.588155386898452_p
x(4)=1.480172425975301_p
w(4)=9.774225106560620e-1_p
else if(N==5)then
x(1)=-15.05630142114642_p
w(1)=2.381833938120232_p
x(2)=-11.37018283752948_p
w(2)=4.780883230780330_p
x(3)=-6.049184689466276_p
w(3)=5.508451966398762_p
x(4)=-1.069107379994237_p
w(4)=3.171168107870117_p
x(5)=3.666182448041754_p
w(5)=1.576628693279757e-1_p
else if(N==6)then
x(1)=-15.2810479814933_p
w(1)=1.823041687416996_p
x(2)=-12.40181155989838_p
w(2)=3.817990050550580_p
x(3)=-7.962676790349329_p
w(3)=4.862307712615727_p
x(4)=-3.147586749265043_p
w(4)=4.305650040780148_p
x(5)=8.785726986584721e-1_p
w(5)=1.176867807934126_p
x(6)=6.246328355472082_p
w(6)=1.414281319983945e-2_p
else if(N==7)then
x(1)=-15.42764819799037_p
w(1)=1.455532230582904_p
x(2)=-13.09961307639379_p
w(2)=3.128903425581014_p
x(3)=-9.366746343692904_p
w(3)=4.213524878871135_p
x(4)=-4.967533351684687_p
w(4)=4.375967219146094_p
x(5)=-9.265852905538675e-1_p
w(5)=2.591997358498101_p
x(6)=2.942345199067498_p
w(6)=2.331723628091353e-1_p
x(7)=9.096102854851521_p
w(7)=9.026370090328353e-4_p
else if(N==8)then
x(1)=-15.52965369588357_p
w(1)=1.198454257472552_p
x(2)=-13.59656888362079_p
w(2)=2.621195046628496_p
x(3)=-10.4167769765661_p
w(3)=3.656716047982536_p
x(4)=-6.478813864272620_p
w(4)=4.096568787816435_p
x(5)=-2.493478708987734_p
w(5)=3.430270127505429_p
x(6)=9.694479304788685e-1_p
w(6)=9.704244995595256e-1_p
x(7)=5.311548158899465_p
w(7)=2.632263609044299e-2_p
x(8)=12.08193849291896_p
w(8)=4.870944200039330e-5_p
else if(N==9)then
x(1)=-15.604641850058_p
w(1)=1.008768645122758_p
x(2)=-13.96781142775329_p
w(2)=2.233259777721884_p
x(3)=-11.22711961743317_p
w(3)=3.191662830482689_p
x(4)=-7.720165239223840_p
w(4)=3.740602982442740_p
x(5)=-3.935331393976776_p
w(5)=3.638570654748848_p
x(6)=-5.031544963513248e-1_p
w(6)=1.984635310035342_p
x(7)=2.952216851953794_p
w(7)=2.002304075729255e-1_p
x(8)=7.855149734533606_p
w(8)=2.266831547914215e-3_p
x(9)=15.01447069140694_p
w(9)=2.672822318150253e-6_p
else if(N==10)then
x(1)=-15.66237567478996_p
w(1)=8.623335229406267e-1_p
x(2)=-14.25700568735066_p
w(2)=1.926164962266720_p
x(3)=-11.873199529919_p
w(3)=2.801191065248194_p
x(4)=-8.751651239506405_p
w(4)=3.384350002949669_p
x(5)=-5.238155140748940_p
w(5)=3.542255805857747_p
x(6)=-1.821558894421529_p
w(6)=2.744217302971440_p
x(7)=1.267984147991838_p
w(7)=7.120660714311854e-1_p
x(8)=5.104261823749172_p
w(8)=2.723118913566572e-2_p
x(9)=10.37799840259543_p
w(9)=1.899954201013158e-4_p
x(10)=17.59767143669636_p
w(10)=1.942760676134173e-7_p
else if(N==11)then
x(1)=-15.70827533781178_p
w(1)=7.456765962337585e-1_p
x(2)=-14.48896332574786_p
w(2)=1.676902731535280_p
x(3)=-12.4004166490445_p
w(3)=2.470791752543049_p
x(4)=-9.618413723181300_p
w(4)=3.051304287591213_p
x(5)=-6.394701360149158_p
w(5)=3.333208717191114_p
x(6)=-3.081063648200868_p
w(6)=3.064478268457477_p
x(7)=-7.477751439480830e-2_p
w(7)=1.496770572244408_p
x(8)=3.090250389407448_p
w(8)=1.575817496786009e-1_p
x(9)=7.288669859042447_p
w(9)=3.267041676992305e-3_p
x(10)=12.71613696769668_p
w(10)=1.837200667957291e-5_p
x(11)=19.58434281957154_p
w(11)=2.333884526509657e-8_p
else if(N==12)then
x(1)=-15.74548181010144_p
w(1)=6.509656996503079e-1_p
x(2)=-14.67826822096231_p
w(2)=1.471637581307047_p
x(3)=-12.83634687288025_p
w(3)=2.190292015389760_p
x(4)=-10.35073579809614_p
w(4)=2.749694325743046_p
x(5)=-7.408938134804607_p
w(5)=3.090239667842988_p
x(6)=-4.266398168217926_p
w(6)=3.088576835536257_p
x(7)=-1.275282420615187_p
w(7)=2.201637510928550_p
x(8)=1.540236000240817_p
w(8)=5.299677992391213e-1_p
x(9)=4.987390073438789_p
w(9)=2.657684384726709e-2_p
x(10)=9.385571354917946_p
w(10)=4.095613640647447e-4_p
x(11)=14.7702308226654_p
w(11)=2.266849407142445e-6_p
x(12)=20.95417622402011_p
w(12)=4.799601695238711e-9_p
else if(N==13)then
x(1)=-15.77604853605982_p
w(1)=5.730613538481464e-1_p
x(2)=-14.83461477880017_p
w(2)=1.300929158786925_p
x(3)=-13.20003530451289_p
w(3)=1.951595589534963_p
x(4)=-10.97175966072226_p
w(4)=2.481223234178175_p
x(5)=-8.292173721503293_p
w(5)=2.845894637263289_p
x(6)=-5.351653240550287_p
w(6)=2.976732234803393_p
x(7)=-2.416554496872573_p
w(7)=2.591278341237290_p
x(8)=2.778837187344665e-1_p
w(8)=1.146107930484323_p
x(9)=3.194783819797656_p
w(9)=1.289058929916307e-1_p
x(10)=6.872329380237396_p
w(10)=4.213051366117856e-3_p
x(11)=11.32480328387457_p
w(11)=5.831390891491957e-5_p
x(12)=16.50137088324245_p
w(12)=3.725708948880565e-7_p
x(13)=21.85000258327397_p
w(13)=1.523354613721644e-9_p
else if(N==14)then
x(1)=-15.80144746216631_p
w(1)=5.082650606298122e-1_p
x(2)=-14.96507451229985_p
w(2)=1.157705916431883_p
x(3)=-13.50593000487261_p
w(3)=1.747746978793522_p
x(4)=-11.50074808847081_p
w(4)=2.244280881076726_p
x(5)=-9.059498004906720_p
w(5)=2.613879951969523_p
x(6)=-6.327513929289990_p
w(6)=2.812721684366769_p
x(7)=-3.501918348547048_p
w(7)=2.704798160078362_p
x(8)=-8.367580068534305e-1_p
w(8)=1.775427734084701_p
x(9)=1.761650576059666_p
w(9)=4.084495878486324e-1_p
x(10)=4.885026245215068_p
w(10)=2.601380688274666e-2_p
x(11)=8.675192499840197_p
w(11)=7.004164446169829e-4_p
x(12)=13.06808670482559_p
w(12)=9.851504171653869e-6_p
x(13)=17.91441677713712_p
w(13)=8.172964114945978e-8_p
x(14)=22.43267784697481_p
w(14)=6.563097682596693e-10_p
else if(N==15)then
x(1)=-15.8227713714283_p
w(1)=4.538220526943836e-1_p
x(2)=-15.07497409044789_p
w(2)=1.036526168987664_p
x(3)=-13.76526304860171_p
w(3)=1.572843188176152_p
x(4)=-11.95372436835226_p
w(4)=2.035855756812706_p
x(5)=-9.726571661321938_p
w(5)=2.399539483093894_p
x(6)=-7.196955522813530_p
w(6)=2.633272015897640_p
x(7)=-4.513610273669785_p
w(7)=2.667459533689791_p
x(8)=-1.883699651308908_p
w(8)=2.194483260472936_p
x(9)=5.734956468584043e-1_p
w(9)=8.922519433862500e-1_p
x(10)=3.274384982619925_p
w(10)=1.087377348859535e-1_p
x(11)=6.549178030445946_p
w(11)=5.078091514107758e-3_p
x(12)=10.35425450089874_p
w(12)=1.288448820150856e-4_p
x(13)=14.59963533753265_p
w(13)=2.014311024958412e-6_p
x(14)=19.04243228872275_p
w(14)=2.334563355533984e-8_p
x(15)=22.81957711335273_p
w(15)=3.472654760386342e-10_p
else if(N==16)then
x(1)=-15.84084318299942_p
w(1)=4.076525293786299e-1_p
x(2)=-15.16837050156536_p
w(2)=9.331774461751386e-1_p
x(3)=-13.98679685259341_p
w(3)=1.421991503664817_p
x(4)=-12.34380060321573_p
w(4)=1.852575258313342_p
x(5)=-10.30788047163681_p
w(5)=2.204315536371192_p
x(6)=-7.968565322385873_p
w(6)=2.454477416185108_p
x(7)=-5.440899800801926_p
w(7)=2.563174048160253_p
x(8)=-2.882476521430922_p
w(8)=2.373767448468327_p
x(9)=-4.713011313618568e-1_p
w(9)=1.438682363855023_p
x(10)=1.947319987539566_p
w(10)=3.237353656806697e-1_p
x(11)=4.799839306113682_p
w(11)=2.538672774812880e-2_p
x(12)=8.140149259273597_p
w(12)=1.037001029417847e-3_p
x(13)=11.88696459399668_p
w(13)=2.695920346155044e-5_p
x(14)=15.92098215904762_p
w(14)=4.996946888208440e-7_p
x(15)=19.93175738822206_p
w(15)=8.358185413704681e-9_p
x(16)=23.08444464571918_p
w(16)=2.110324133260989e-10_p
else if(N==17)then
x(1)=-15.85628996910698_p
w(1)=3.681684310645685e-1_p
x(2)=-15.24838306837251_p
w(2)=8.443798653566320e-1_p
x(3)=-14.17739483058466_p
w(3)=1.291188080682018_p
x(4)=-12.68161380011102_p
w(4)=1.691185414146062_p
x(5)=-10.816121079455_p
w(5)=2.027813310808974_p
x(6)=-8.652729889059678_p
w(6)=2.283518979908908_p
x(7)=-6.282338132273201_p
w(7)=2.432744248834445_p
x(8)=-3.825070877361882_p
w(8)=2.396687769251527_p
x(9)=-1.442835020178719_p
w(9)=1.858951667798652_p
x(10)=8.272079830365680e-1_p
w(10)=7.055992777932116e-1_p
x(11)=3.338931706276285_p
w(11)=9.369532806118672e-2_p
x(12)=6.293043295058597_p
w(12)=5.830987377511828e-3_p
x(13)=9.630267411237508_p
w(13)=2.301029583856796e-4_p
x(14)=13.2642928919468_p
w(14)=6.495782247156396e-6_p
x(15)=17.04588785055565_p
w(15)=1.489318974823483e-7_p
x(16)=20.6300935668408_p
w(16)=3.600095065354850e-9_p
x(17)=23.27165413323094_p
w(17)=1.410962524945458e-10_p
else
call GD(-16)
end if
end subroutine GF_m16

! [-15kT;24kT]
subroutine GF_m15(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-11.60756997520759_p
w(1)=8.010480024217602_p
x(2)=-2.557094434557132_p
w(2)=6.989520281646920_p
else if(N==3)then
x(1)=-13.08170715647806_p
w(1)=4.723446589554914_p
x(2)=-6.541749761629245_p
w(2)=7.396058971381213_p
x(3)=-2.364728360917738e-1_p
w(3)=2.880494744928395_p
else if(N==4)then
x(1)=-13.74326011261899_p
w(1)=3.145855498993440_p
x(2)=-9.049691412357708_p
w(2)=5.837741467162708_p
x(3)=-3.109011655292148_p
w(3)=5.206261772492469_p
x(4)=1.722324815119274_p
w(4)=8.101415672159060e-1_p
else if(N==5)then
x(1)=-14.0970385517186_p
w(1)=2.278825098897517_p
x(2)=-10.57189221011264_p
w(2)=4.569425826787968_p
x(3)=-5.495907539213134_p
w(3)=5.228380991351054_p
x(4)=-7.674888318288463e-1_p
w(4)=2.806642019495667_p
x(5)=3.991014729333610_p
w(5)=1.167263693323158e-1_p
else if(N==6)then
x(1)=-14.30989355814421_p
w(1)=1.749768626739689_p
x(2)=-11.54739323551369_p
w(2)=3.661563461122524_p
x(3)=-7.295257681837302_p
w(3)=4.647520635139712_p
x(4)=-2.713087639620670_p
w(4)=3.987033619869957_p
x(5)=1.189690314276541_p
w(5)=9.445110841249660e-1_p
x(6)=6.644015201475390_p
w(6)=9.602878867675555e-3_p
else if(N==7)then
x(1)=-14.44915923889024_p
w(1)=1.400736206633504_p
x(2)=-12.20946755114909_p
w(2)=3.009079814708995_p
x(3)=-8.622698848174414_p
w(3)=4.043456637563181_p
x(4)=-4.413752457197888_p
w(4)=4.145381287376648_p
x(5)=-5.676787500766294e-1_p
w(5)=2.235428065398548_p
x(6)=3.322421479331684_p
w(6)=1.653394898100816e-1_p
x(7)=9.546060498344129_p
w(7)=5.788043735652393e-4_p
else if(N==8)then
x(1)=-14.54639949053621_p
w(1)=1.155719155907863_p
x(2)=-12.68274426707374_p
w(2)=2.526292025295681_p
x(3)=-9.620164411165657_p
w(3)=3.518786230992677_p
x(4)=-5.838147911913114_p
w(4)=3.917307925012898_p
x(5)=-2.042701539814010_p
w(5)=3.120717270086021_p
x(6)=1.335440689863648_p
w(6)=7.439956320731054e-1_p
x(7)=5.753013478420375_p
w(7)=1.715182999066303e-2_p
x(8)=12.5606192362431_p
w(8)=3.023650561338864e-5_p
else if(N==9)then
x(1)=-14.61818376384351_p
w(1)=9.741680784572962e-1_p
x(2)=-13.03785277363622_p
w(2)=2.155637909979168_p
x(3)=-10.39384363699707_p
w(3)=3.077027738315178_p
x(4)=-7.017400982481952_p
w(4)=3.592993506917326_p
x(5)=-3.395784381539635_p
w(5)=3.414983963765362_p
x(6)=-1.148542729752602e-1_p
w(6)=1.647382673759300_p
x(7)=3.372127313908769_p
w(7)=1.363824117846469e-1_p
x(8)=8.325399277033716_p
w(8)=1.422354162051978e-3_p
x(9)=15.4797834943413_p
w(9)=1.668724193003080e-6_p
else if(N==10)then
x(1)=-14.67365609797204_p
w(1)=8.334874370965821e-1_p
x(2)=-13.3155520211773_p
w(2)=1.861004882010056_p
x(3)=-11.01337298847857_p
w(3)=2.703898368051439_p
x(4)=-8.003166249645723_p
w(4)=3.258910282630147_p
x(5)=-4.628731364010013_p
w(5)=3.373429623192071_p
x(6)=-1.374452886456678_p
w(6)=2.429006909973127_p
x(7)=1.666619732478943_p
w(7)=5.226932699417456e-1_p
x(8)=5.559662236529759_p
w(8)=1.745048163788939e-2_p
x(9)=10.84390414587774_p
w(9)=1.189233138998119e-4_p
x(10)=17.99448126161301_p
w(10)=1.280175648569455e-7_p
else if(N==11)then
x(1)=-14.7178513497198_p
w(1)=7.211743743755860e-1_p
x(2)=-13.53878803821143_p
w(2)=1.621278626488020_p
x(3)=-11.520212950167_p
w(3)=2.387067690634241_p
x(4)=-8.834424631941189_p
w(4)=2.942877522338297_p
x(5)=-5.730734383843370_p
w(5)=3.195837248129432_p
x(6)=-2.563869359771050_p
w(6)=2.830423042815267_p
x(7)=3.285814873656348e-1_p
w(7)=1.194296882210697_p
x(8)=3.526254153446474_p
w(8)=1.049746774934673e-1_p
x(9)=7.750882711458727_p
w(9)=2.058456464953238e-3_p
x(10)=13.15178668618788_p
w(10)=1.176822933102843e-5_p
x(11)=19.88271414840427_p
w(11)=1.668523096854588e-8_p
else if(N==12)then
x(1)=-14.75371201546_p
w(1)=6.298974185328777e-1_p
x(2)=-13.7211724222599_p
w(2)=1.423626960628284_p
x(3)=-11.93983910800725_p
w(3)=2.117575614438582_p
x(4)=-9.538087782711303_p
w(4)=2.655032147155183_p
x(5)=-6.701064040739954_p
w(5)=2.973274416972049_p
x(6)=-3.686023867625914_p
w(6)=2.917923146259006_p
x(7)=-8.326314633393650e-1_p
w(7)=1.889039676575298_p
x(8)=1.958354565548338_p
w(8)=3.764112600384897e-1_p
x(9)=5.443527576794067_p
w(9)=1.695846066808129e-2_p
x(10)=9.835082434385390_p
w(10)=2.596913197080971e-4_p
x(11)=15.15967240753397_p
w(11)=1.509568091731898e-6_p
x(12)=21.16249746688622_p
w(12)=3.708871920003367e-9_p
else if(N==13)then
x(1)=-14.78319215897282_p
w(1)=5.547680465745285e-1_p
x(2)=-13.87191059631239_p
w(2)=1.259117287478877_p
x(3)=-12.29023084400187_p
w(3)=1.887951702615272_p
x(4)=-10.13557128771833_p
w(4)=2.397955789926633_p
x(5)=-7.548242138486907_p
w(5)=2.743919603822077_p
x(6)=-4.718898494960202_p
w(6)=2.843193395126184_p
x(7)=-1.916080221060692_p
w(7)=2.344196958988095_p
x(8)=6.950837396326075e-1_p
w(8)=8.815949190256658e-1_p
x(9)=3.640393582871016_p
w(9)=8.460190685802446e-2_p
x(10)=7.328704780654696_p
w(10)=2.662704100010127e-3_p
x(11)=11.7487260709887_p
w(11)=3.773019088791826e-5_p
x(12)=16.83742398903048_p
w(12)=2.599085550226839e-7_p
x(13)=21.99257896655218_p
w(13)=1.249712086916886e-9_p
else if(N==14)then
x(1)=-14.80770244764621_p
w(1)=4.922427832541229e-1_p
x(2)=-13.99777021893439_p
w(2)=1.120996898778827_p
x(3)=-12.58516478294626_p
w(3)=1.691644567876577_p
x(4)=-10.64503898675649_p
w(4)=2.170550094061395_p
x(5)=-8.285604558231517_p
w(5)=2.523771380258630_p
x(6)=-5.651657678716712_p
w(6)=2.701315883763313_p
x(7)=-2.943776747744730_p
w(7)=2.525487011980386_p
x(8)=-3.931622126330468e-1_p
w(8)=1.474473166994771_p
x(9)=2.195032943222393_p
w(9)=2.825354885311843e-1_p
x(10)=5.342699184765276_p
w(10)=1.653030976000399e-2_p
x(11)=9.118293886225928_p
w(11)=4.460988872260199e-4_p
x(12)=13.45815427720928_p
w(12)=6.561359908126558e-6_p
x(13)=18.19694908101208_p
w(13)=5.979660223689321e-8_p
x(14)=22.53154834025205_p
w(14)=5.615761359470491e-10_p
else if(N==15)then
x(1)=-14.82829160880473_p
w(1)=4.396785639038165e-1_p
x(2)=-14.10385741420642_p
w(2)=1.004058468230082_p
x(3)=-12.83537749337784_p
w(3)=1.523058414581377_p
x(4)=-11.08169129247741_p
w(4)=1.970171311491904_p
x(5)=-8.927546744215974_p
w(5)=2.319205913827853_p
x(6)=-6.485233132740619_p
w(6)=2.536658697961719_p
x(7)=-3.905522387546052_p
w(7)=2.532181939642634_p
x(8)=-1.393786193824030_p
w(8)=1.937273982653697_p
x(9)=1.004010795906386_p
w(9)=6.638919129064021e-1_p
x(10)=3.727605290349270_p
w(10)=7.052658163617181e-2_p
x(11)=7.003623948351999_p
w(11)=3.209578415709539e-3_p
x(12)=10.77520768035006_p
w(12)=8.353480775555314e-5_p
x(13)=14.95151597641641_p
w(13)=1.387645264431533e-6_p
x(14)=19.27613226306347_p
w(14)=1.785423139409090e-8_p
x(15)=22.89002549774287_p
w(15)=3.059035961671644e-10_p
else if(N==16)then
x(1)=-14.84574961581182_p
w(1)=3.950792773616602e-1_p
x(2)=-14.19406293710527_p
w(2)=9.042679957468430e-1_p
x(3)=-13.04925275729928_p
w(3)=1.377541073785067_p
x(4)=-11.45800274404181_p
w(4)=1.793730339520506_p
x(5)=-9.487594589604146_p
w(5)=2.132214757270398_p
x(6)=-7.226620695542977_p
w(6)=2.368855833198967_p
x(7)=-4.790945992643402_p
w(7)=2.453835137534409_p
x(8)=-2.341349574768447_p
w(8)=2.182173138686214_p
x(9)=-2.352786055396284e-2_p
w(9)=1.156354449739078_p
x(10)=2.392776721235088_p
w(10)=2.192024110416097e-1_p
x(11)=5.259515092569423_p
w(11)=1.606664375804553e-2_p
x(12)=8.581164392756060_p
w(12)=6.609824259404355e-4_p
x(13)=12.28019473846495_p
w(13)=1.790234115086175e-5_p
x(14)=16.23366060701994_p
w(14)=3.566209354038820e-7_p
x(15)=20.12364483507875_p
w(15)=6.643991611091869e-9_p
x(16)=23.13619108699603_p
w(16)=1.897066632918080e-10_p
else if(N==17)then
x(1)=-14.86067869965933_p
w(1)=3.569200568673879e-1_p
x(2)=-14.27138000675056_p
w(2)=8.184820497131367e-1_p
x(3)=-13.23336370750581_p
w(3)=1.251276607123028_p
x(4)=-11.78411580442141_p
w(4)=1.638195132177679_p
x(5)=-9.977705936083936_p
w(5)=1.962743015625257_p
x(6)=-7.885046067353048_p
w(6)=2.206663778815536_p
x(7)=-5.597145967039447_p
w(7)=2.339555055257125_p
x(8)=-3.237009123743708_p
w(8)=2.254946424493496_p
x(9)=-9.589541757753268e-1_p
w(9)=1.597327766637193_p
x(10)=1.269591642036220_p
w(10)=5.098590838904269e-1_p
x(11)=3.798153019852525_p
w(11)=6.019652670669556e-2_p
x(12)=6.747228254094873_p
w(12)=3.681194367623833e-3_p
x(13)=10.05131873409876_p
w(13)=1.490677530576073e-4_p
x(14)=13.62681026494814_p
w(14)=4.433327954631887e-6_p
x(15)=17.32081745078171_p
w(15)=1.100242848169413e-7_p
x(16)=20.78757536900702_p
w(16)=2.955949797225878e-9_p
x(17)=23.31078106179207_p
w(17)=1.286903674816507e-10_p
else
call GD(-15)
end if
end subroutine GF_m15

! [-14kT;24kT]
subroutine GF_m14(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.80652726898207_p
w(1)=7.538498982501823_p
x(2)=-2.304430755173744_p
w(2)=6.461501848988799_p
else if(N==3)then
x(1)=-12.18399787365419_p
w(1)=4.470876741538643_p
x(2)=-6.001285162801700_p
w(2)=6.968250815347285_p
x(3)=-2.478274366379249e-2_p
w(3)=2.560873274604693_p
else if(N==4)then
x(1)=-12.80448671317123_p
w(1)=2.992232552529643_p
x(2)=-8.343344116933714_p
w(2)=5.541915632753257_p
x(3)=-2.724819911190386_p
w(3)=4.809656356662087_p
x(4)=1.984894113247585_p
w(4)=6.561962895456348e-1_p
else if(N==5)then
x(1)=-13.13752249549993_p
w(1)=2.176431811949354_p
x(2)=-9.772589358663447_p
w(2)=4.358531208799889_p
x(3)=-4.942280041924144_p
w(3)=4.940444313156924_p
x(4)=-4.573911588944158e-1_p
w(4)=2.440427090305656_p
x(5)=4.339834702468511_p
w(5)=8.416640727879918e-2_p
else if(N==6)then
x(1)=-13.33859038663792_p
w(1)=1.676857915046332_p
x(2)=-10.69236840018628_p
w(2)=3.505524292882562_p
x(3)=-6.627487768159765_p
w(3)=4.429950636423587_p
x(4)=-2.279690579364591_p
w(4)=3.645714966571246_p
x(5)=1.522263715912322_p
w(5)=7.355838047624977e-1_p
x(6)=7.064106452845080_p
w(6)=6.369215804397828e-3_p
else if(N==7)then
x(1)=-13.47059180921489_p
w(1)=1.346129883181439_p
x(2)=-11.319013125089_p
w(2)=2.889434824496979_p
x(3)=-7.878525060597122_p
w(3)=3.872132081922473_p
x(4)=-3.862376451496849_p
w(4)=3.899222241735745_p
x(5)=-2.005030119020929e-1_p
w(5)=1.879068161901904_p
x(6)=3.728191675443370_p
w(6)=1.136500039034588e-1_p
x(7)=10.0158652535351_p
w(7)=3.636343486237298e-4_p
else if(N==8)then
x(1)=-13.56312134455481_p
w(1)=1.113038396526424_p
x(2)=-11.76885578523802_p
w(2)=2.431360238188629_p
x(3)=-8.823759168912339_p
w(3)=3.380019492668029_p
x(4)=-5.199547900491871_p
w(4)=3.730473103898017_p
x(5)=-1.594457053805413_p
w(5)=2.784267213503524_p
x(6)=1.724065305003326_p
w(6)=5.499081531085784e-1_p
x(7)=6.215945003949397_p
w(7)=1.091575591665644e-2_p
x(8)=13.0540326442491_p
w(8)=1.847768076517613e-5_p
else if(N==9)then
x(1)=-13.63173903036466_p
w(1)=9.395289171899696e-1_p
x(2)=-12.10800151812466_p
w(2)=2.077834001133021_p
x(3)=-9.561044765642261_p
w(3)=2.961670033792009_p
x(4)=-6.316487486747969_p
w(4)=3.441468041871168_p
x(5)=-2.861604599930449_p
w(5)=3.166559956356823_p
x(6)=2.839438789207948e-1_p
w(6)=1.321978217795579_p
x(7)=3.815668247151814_p
w(7)=9.008295580677246e-2_p
x(8)=8.811002121843478_p
w(8)=8.776728721249022e-4_p
x(9)=15.94979864677247_p
w(9)=1.034673155113462e-6_p
else if(N==10)then
x(1)=-13.6849636666086_p
w(1)=8.045688609562566e-1_p
x(2)=-12.37426486380151_p
w(2)=1.795617784683737_p
x(3)=-10.15408821606926_p
w(3)=2.605989274355412_p
x(4)=-7.256257778395905_p
w(4)=3.131189103064431_p
x(5)=-4.023927357705992_p
w(5)=3.190402442323518_p
x(6)=-9.285928151735726e-1_p
w(6)=2.092035429949147_p
x(7)=2.087638446389075_p
w(7)=3.691665781331546e-1_p
x(8)=6.032579587284100_p
w(8)=1.095761878511230e-2_p
x(9)=11.31885149500824_p
w(9)=7.365468488749120e-5_p
x(10)=18.38531335552335_p
w(10)=8.455496511267010e-8_p
else if(N==11)then
x(1)=-13.72745392689244_p
w(1)=6.966019528378420e-1_p
x(2)=-12.58876904563882_p
w(2)=1.565450878761581_p
x(3)=-10.64048298721422_p
w(3)=2.302855373123868_p
x(4)=-8.051677128424313_p
w(4)=2.833002658348284_p
x(5)=-5.070144825586506_p
w(5)=3.051079987536588_p
x(6)=-2.052574001533744_p
w(6)=2.565789319441417_p
x(7)=7.456526905001609e-1_p
w(7)=9.159474982297333e-1_p
x(8)=3.983090325414921_p
w(8)=6.798654888307586e-2_p
x(9)=8.225237884902864_p
w(9)=1.279105400773121e-3_p
x(10)=13.5911171805701_p
w(10)=7.496918906000652e-6_p
x(11)=20.17057767346731_p
w(11)=1.200855296371665e-8_p
else if(N==12)then
x(1)=-13.76196491160599_p
w(1)=6.087693781759200e-1_p
x(2)=-12.76420814915956_p
w(2)=1.375447959459942_p
x(3)=-11.04371849809674_p
w(3)=2.044478926032496_p
x(4)=-8.726401832696643_p
w(4)=2.559387461019933_p
x(5)=-5.995620016963214_p
w(5)=2.852307380406203_p
x(6)=-3.111397043252240_p
w(6)=2.725864816628800_p
x(7)=-3.876409871865976e-1_p
w(7)=1.565626329439370_p
x(8)=2.398271148413305_p
w(8)=2.573312928573411e-1_p
x(9)=5.915069867050315_p
w(9)=1.062316213663908e-2_p
x(10)=10.29246871023087_p
w(10)=1.631188358391977e-4_p
x(11)=15.54875612856752_p
w(11)=1.003613254293159e-6_p
x(12)=21.36123313199924_p
w(12)=2.884884549864685e-9_p
else if(N==13)then
x(1)=-13.79035508566273_p
w(1)=5.364240207158969e-1_p
x(2)=-12.90931710347675_p
w(2)=1.217165534026321_p
x(3)=-11.38074526908167_p
w(3)=1.824005576790937_p
x(4)=-9.300144825671998_p
w(4)=2.313981727611141_p
x(5)=-6.806111806291989_p
w(5)=2.639592882649078_p
x(6)=-4.090570548528963_p
w(6)=2.697535170288890_p
x(7)=-1.420158606991698_p
w(7)=2.066118020394944_p
x(8)=1.128481391964018_p
w(8)=6.494035487982991e-1_p
x(9)=4.104930238341844_p
w(9)=5.408839119155574e-2_p
x(10)=7.796012289363936_p
w(10)=1.661508592090961e-3_p
x(11)=12.17700796391141_p
w(11)=2.426792050807787e-5_p
x(12)=17.17049043562663_p
w(12)=1.814807363269591e-7_p
x(13)=22.12811982905957_p
w(13)=1.030224084067703e-9_p
else if(N==14)then
x(1)=-13.81397411947438_p
w(1)=4.761767591935546e-1_p
x(2)=-13.03056068062864_p
w(2)=1.084169521807248_p
x(3)=-11.66466743717258_p
w(3)=1.635295928261707_p
x(4)=-9.789949312007918_p
w(4)=2.096286670356708_p
x(5)=-7.513095421664358_p
w(5)=2.432161522542903_p
x(6)=-4.979067197824514_p
w(6)=2.583248634983904_p
x(7)=-2.391744582030549_p
w(7)=2.318404125404718_p
x(8)=5.643741077952276e-2_p
w(8)=1.175282412690241_p
x(9)=2.649210045714752_p
w(9)=1.883640861315022e-1_p
x(10)=5.814356042601144_p
w(10)=1.032518296929255e-2_p
x(11)=9.568822867483227_p
w(11)=2.815866161095026e-4_p
x(12)=13.84978588432759_p
w(12)=4.356200676549925e-6_p
x(13)=18.47519368245008_p
w(13)=4.385000095386737e-8_p
x(14)=22.6256232333968_p
w(14)=4.820551534238192e-10_p
else if(N==15)then
x(1)=-13.83382643421758_p
w(1)=4.254969025378730e-1_p
x(2)=-13.1328228752059_p
w(2)=9.714892122540999e-1_p
x(3)=-11.90572039036106_p
w(3)=1.473069091778086_p
x(4)=-10.21017224716015_p
w(4)=1.904070844187852_p
x(5)=-8.129618801803913_p
w(5)=2.237843889124278_p
x(6)=-5.775951429966129_p
w(6)=2.436226435922038_p
x(7)=-3.302740689082574_p
w(7)=2.379025972317200_p
x(8)=-9.061646971973168e-1_p
w(8)=1.653837547259380_p
x(9)=1.452055966071420_p
w(9)=4.722438971531801e-1_p
x(10)=4.198107056480514_p
w(10)=4.463780331775935e-2_p
x(11)=7.468125619061016_p
w(11)=2.004436668709960e-3_p
x(12)=11.20077971967221_p
w(12)=5.383015914106832e-5_p
x(13)=15.30292002096894_p
w(13)=9.548487927132055e-7_p
x(14)=19.50524204493288_p
w(14)=1.369223578732943e-8_p
x(15)=22.95724515865684_p
w(15)=2.699958534379893e-10_p
else if(N==16)then
x(1)=-13.85066889198225_p
w(1)=3.824724725354759e-1_p
x(2)=-13.2198271638348_p
w(2)=8.752705546129972e-1_p
x(3)=-12.11190560252897_p
w(3)=1.332918188380092_p
x(4)=-10.57263808415209_p
w(4)=1.734551619554080_p
x(5)=-8.668199250898933_p
w(5)=2.059368902901083_p
x(6)=-6.486549693794138_p
w(6)=2.280898006083992_p
x(7)=-4.145107646016207_p
w(7)=2.334105998171243_p
x(8)=-1.805916775288009_p
w(8)=1.959057149733401_p
x(9)=4.333834243223742e-1_p
w(9)=8.876118495525539e-1_p
x(10)=2.857783948458219_p
w(10)=1.433106740479414e-1_p
x(11)=5.732010827048381_p
w(11)=1.000561171457884e-2_p
x(12)=9.029233162821685_p
w(12)=4.177017040078573e-4_p
x(13)=12.67582811328878_p
w(13)=1.184246516510001e-5_p
x(14)=16.54453277435649_p
w(14)=2.545678329739756e-7_p
x(15)=20.3112235150763_p
w(15)=5.295453562176833e-9_p
x(16)=23.18573406603094_p
w(16)=1.707251326553763e-10_p
else if(N==17)then
x(1)=-13.86507879532542_p
w(1)=3.456420321315815e-1_p
x(2)=-13.29444008412291_p
w(2)=7.925074207465871e-1_p
x(3)=-12.28950378491789_p
w(3)=1.211218015954992_p
x(4)=-10.88698735348374_p
w(4)=1.584931352422757_p
x(5)=-9.140027720952791_p
w(5)=1.897109062496409_p
x(6)=-7.118840037329035_p
w(6)=2.128281423861204_p
x(7)=-4.915085049030417_p
w(7)=2.240349157318290_p
x(8)=-2.654774288690284_p
w(8)=2.089495213857951_p
x(9)=-4.746157777747623e-1_p
w(9)=1.318106461234712_p
x(10)=1.729972069960328_p
w(10)=3.521646852989710e-1_p
x(11)=4.273225517464575_p
w(11)=3.779915370123474e-2_p
x(12)=7.210767973306484_p
w(12)=2.297767282229036e-3_p
x(13)=10.47706819021304_p
w(13)=9.598205672196167e-5_p
x(14)=13.99005456366051_p
w(14)=3.019212754095301e-6_p
x(15)=17.59319921049869_p
w(15)=8.136413080069214e-8_p
x(16)=20.94128299714498_p
w(16)=2.432656916799419e-9_p
x(17)=23.3483690916392_p
w(17)=1.174388399840355e-10_p
else
call GD(-14)
end if
end subroutine GF_m14

! [-13kT;24kT]
subroutine GF_m13(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-10.0042902044254_p
w(1)=7.068991844770678_p
x(2)=-2.046000741984823_p
w(2)=5.931010415518423_p
else if(N==3)then
x(1)=-11.28554795232387_p
w(1)=4.220016715232493_p
x(2)=-5.458790658379419_p
w(2)=6.536163379013519_p
x(3)=2.003951215462840e-1_p
w(3)=2.243822166043089_p
else if(N==4)then
x(1)=-11.86528188265443_p
w(1)=2.839634610543181_p
x(2)=-7.635516637466773_p
w(2)=5.245842691213992_p
x(3)=-2.338703259055125_p
w(3)=4.396808217730370_p
x(4)=2.270578254603061_p
w(4)=5.177167408015585e-1_p
else if(N==5)then
x(1)=-12.17775851861459_p
w(1)=2.074632944747252_p
x(2)=-8.972362881730705_p
w(2)=4.147912739786829_p
x(3)=-4.388838297314745_p
w(3)=4.641267104979033_p
x(4)=-1.360415279839153e-1_p
w(4)=2.077173803007337_p
x(5)=4.714213484490634_p
w(5)=5.901566776865069e-2_p
else if(N==6)then
x(1)=-12.36714929474926_p
w(1)=1.604277278209990_p
x(2)=-9.836826647001219_p
w(2)=3.349683973075412_p
x(3)=-5.959838090709987_p
w(3)=4.207876947200980_p
x(4)=-1.846833520897149_p
w(4)=3.280244237931326_p
x(5)=1.879529924360930_p
w(5)=5.537970947007428e-1_p
x(6)=7.507578111505997_p
w(6)=4.122729170651208e-3_p
else if(N==7)then
x(1)=-12.49195980106265_p
w(1)=1.291674740484868_p
x(2)=-10.42834186125509_p
w(2)=2.769816916221922_p
x(3)=-7.134597230736977_p
w(3)=3.698673064722751_p
x(4)=-3.314240077835790_p
w(4)=3.632066490313349_p
x(5)=1.788090429455408e-1_p
w(5)=1.531871676262700_p
x(6)=4.160772198091180_p
w(6)=7.567566519864473e-2_p
x(7)=10.50602093348668_p
w(7)=2.237070848657470e-4_p
else if(N==8)then
x(1)=-12.57983459001429_p
w(1)=1.070370709092658_p
x(2)=-10.85499554643275_p
w(2)=2.336267545867741_p
x(3)=-8.027871837563126_p
w(3)=3.239895626220400_p
x(4)=-4.563938289974868_p
w(4)=3.532392438495693_p
x(5)=-1.147032637404914_p
w(5)=2.423542412778170_p
x(6)=2.138309527890894_p
w(6)=3.907369957670241e-1_p
x(7)=6.700470560089695_p
w(7)=6.785411693516622e-3_p
x(8)=13.56162842662394_p
w(8)=1.112037389906266e-5_p
else if(N==9)then
x(1)=-12.64532077185589_p
w(1)=9.048160934563023e-1_p
x(2)=-11.1783341858383_p
w(2)=1.999743551696610_p
x(3)=-8.728962719508679_p
w(3)=2.845257434471571_p
x(4)=-5.618126631404402_p
w(4)=3.284038654941160_p
x(5)=-2.333220986499756_p
w(5)=2.887662230538942_p
x(6)=6.978605118682591e-1_p
w(6)=1.020211093792958_p
x(7)=4.283053953691420_p
w(7)=5.773979275066596e-2_p
x(8)=9.311558308215840_p
w(8)=5.327706220951461e-4_p
x(9)=16.42271806286175_p
w(9)=6.380187969139638e-7_p
else if(N==10)then
x(1)=-12.69630767101576_p
w(1)=7.755528692671944e-1_p
x(2)=-11.43319848649534_p
w(2)=1.729929757201195_p
x(3)=-9.295513093342189_p
w(3)=2.507248201485911_p
x(4)=-6.511406230605430_p
w(4)=3.000113493387238_p
x(5)=-3.424733959828845_p
w(5)=2.987332533779710_p
x(6)=-4.805633333101469e-1_p
w(6)=1.742383408359811_p
x(7)=2.533065977884742_p
w(7)=2.506506504241424e-1_p
x(8)=6.522671814647987_p
w(8)=6.746127572608164e-3_p
x(9)=11.80216255075316_p
w(9)=4.516275631322134e-5_p
x(10)=18.76846632247881_p
w(10)=5.605497872938065e-8_p
else if(N==11)then
x(1)=-12.73708991527987_p
w(1)=6.719409007542495e-1_p
x(2)=-11.63894635267082_p
w(2)=1.509365159856501_p
x(3)=-9.761349067105886_p
w(3)=2.218006592760712_p
x(4)=-7.270508524336506_p
w(4)=2.721063300260299_p
x(5)=-4.413807651807721_p
w(5)=2.895256063659199_p
x(6)=-1.546360326780469_p
w(6)=2.268406285046646_p
x(7)=1.180894735921268_p
w(7)=6.723120661055789e-1_p
x(8)=4.460580421055586_p
w(8)=4.286294471286672e-2_p
x(9)=8.711335609373789_p
w(9)=7.841857719454810e-4_p
x(10)=14.03337266426456_p
w(10)=4.752655400414799e-6_p
x(11)=20.44724657983396_p
w(11)=8.705702652423914e-9_p
else if(N==12)then
x(1)=-12.77024610012409_p
w(1)=5.875665112482807e-1_p
x(2)=-11.80740782437702_p
w(2)=1.327057203654268_p
x(3)=-10.14808169721695_p
w(3)=1.970892307854916_p
x(4)=-7.915930646111105_p
w(4)=2.462376763832562_p
x(5)=-5.293272802356030_p
w(5)=2.725251558042350_p
x(6)=-2.543176396735598_p
w(6)=2.505557471947812_p
x(7)=6.421391058507328e-2_p
w(7)=1.245213197933816_p
x(8)=2.861162045223345_p
w(8)=1.694471908604879e-1_p
x(9)=6.401582581031472_p
w(9)=6.537847578406998e-3_p
x(10)=10.75725894139746_p
w(10)=1.015385586532721e-4_p
x(11)=15.93677328095717_p
w(11)=6.665187297508651e-7_p
x(12)=21.55035543979606_p
w(12)=2.258818293001030e-9_p
else if(N==13)then
x(1)=-12.79754209895612_p
w(1)=5.180164384891451e-1_p
x(2)=-11.94686167327447_p
w(2)=1.175037887700757_p
x(3)=-10.47165810461191_p
w(3)=1.759672193654583_p
x(4)=-8.465677929420895_p
w(4)=2.229044893680541_p
x(5)=-6.066281405565578_p
w(5)=2.531718987234433_p
x(6)=-3.467643048239425_p
w(6)=2.534106033196761_p
x(7)=-9.265636104115681e-1_p
w(7)=1.760711318868871_p
x(8)=1.581805199917968_p
w(8)=4.569137397594256e-1_p
x(9)=4.587971621638972_p
w(9)=3.374103950798200e-2_p
x(10)=8.273829990734207_p
w(10)=1.024077088820021e-3_p
x(11)=12.60913520071428_p
w(11)=1.552336270290444e-5_p
x(12)=17.50001204218906_p
w(12)=1.268917761338698e-7_p
x(13)=22.25678714852244_p
w(13)=8.533030556924664e-10_p
else if(N==14)then
x(1)=-12.82026659907709_p
w(1)=4.600559449573082e-1_p
x(2)=-12.06346926174101_p
w(2)=1.047193470322181_p
x(3)=-10.74450443027604_p
w(3)=1.578633284812241_p
x(4)=-8.935637612224625_p
w(4)=2.021309559723617_p
x(5)=-6.742348921910443_p
w(5)=2.338332168286230_p
x(6)=-4.310603250358622_p
w(6)=2.454934680991224_p
x(7)=-1.845740588640287_p
w(7)=2.078052731886091_p
x(8)=5.169775092318974e-1_p
w(8)=8.937096704104007e-1_p
x(9)=3.124699815180746_p
w(9)=1.212564216500882e-1_p
x(10)=6.299475473986821_p
w(10)=6.345186647798684e-3_p
x(11)=10.02635173472562_p
w(11)=1.762237830162140e-4_p
x(12)=14.24248512676639_p
w(12)=2.884164661279320e-6_p
x(13)=18.74878082455965_p
w(13)=3.223919328236324e-8_p
x(14)=22.71506230175083_p
w(14)=4.150505548279572e-10_p
else if(N==15)then
x(1)=-12.83937941397822_p
w(1)=4.112675241044238e-1_p
x(2)=-12.1618905347667_p
w(2)=9.387926569272237e-1_p
x(3)=-10.97634784939068_p
w(3)=1.422820098355312_p
x(4)=-9.339296787965081_p
w(4)=1.837420538836628_p
x(5)=-7.333081389457485_p
w(5)=2.154996837620475_p
x(6)=-5.069788546211883_p
w(6)=2.329837221090847_p
x(7)=-2.706088643857310_p
w(7)=2.200929226225989_p
x(8)=-4.173313323087961e-1_p
w(8)=1.354122179381181_p
x(9)=1.920470379451289_p
w(9)=3.209218641626229e-1_p
x(10)=4.685309343497918_p
w(10)=2.762142260055259e-2_p
x(11)=7.942235247862907_p
w(11)=1.237533377956770e-3_p
x(12)=11.63054534573543_p
w(12)=3.449032063716887e-5_p
x(13)=15.65341737240711_p
w(13)=6.565155132142053e-7_p
x(14)=19.7295527835111_p
w(14)=1.053100322955243e-8_p
x(15)=23.02135338275503_p
w(15)=2.387353724759190e-10_p
else if(N==16)then
x(1)=-12.85560411262971_p
w(1)=3.698238223905215e-1_p
x(2)=-12.24568051395087_p
w(2)=8.461630795455578e-1_p
x(3)=-11.17480319726717_p
w(3)=1.288077273142674_p
x(4)=-9.687814146495755_p
w(4)=1.674936607145691_p
x(5)=-7.849927502520772_p
w(5)=1.985471499750873_p
x(6)=-5.748875059637951_p
w(6)=2.189317496216935_p
x(7)=-3.504344060730006_p
w(7)=2.198661789077987_p
x(8)=-1.275026558338478_p
w(8)=1.702832888103301_p
x(9)=9.042130889083456e-1_p
w(9)=6.476078560027154e-1_p
x(10)=3.342392443136287_p
w(10)=9.070258548887546e-2_p
x(11)=6.216753210089450_p
w(11)=6.137567892421839e-3_p
x(12)=9.483948698769828_p
w(12)=2.618030146471887e-4_p
x(13)=13.07346485050111_p
w(13)=7.806324049698316e-6_p
x(14)=16.85325782631742_p
w(14)=1.818069516114128e-7_p
x(15)=20.49439356465144_p
w(15)=4.232103798061162e-9_p
x(16)=23.23315287545639_p
w(16)=1.537951664595362e-10_p
else if(N==17)then
x(1)=-12.86949296724447_p
w(1)=3.343271113630883e-1_p
x(2)=-12.31757837009773_p
w(2)=7.664369549969989e-1_p
x(3)=-11.34585615097794_p
w(3)=1.170974096705323_p
x(4)=-9.990318882252547_p
w(4)=1.531313298081032_p
x(5)=-8.303275287811880_p
w(5)=1.830695557797424_p
x(6)=-6.354518071512433_p
w(6)=2.047570179510337_p
x(7)=-4.236991567129945_p
w(7)=2.131683341495815_p
x(8)=-2.078719479446884_p
w(8)=1.893340053674637_p
x(9)=1.457789440941473e-2_p
w(9)=1.036170926013858_p
x(10)=2.210338778039182_p
w(10)=2.327633416852341e-1_p
x(11)=4.763472494140917_p
w(11)=2.324498380466617e-2_p
x(12)=7.683199437029538_p
w(12)=1.418855857539717e-3_p
x(13)=10.90713720404417_p
w(13)=6.144461848673896e-5_p
x(14)=14.35367110001782_p
w(14)=2.052328472971011e-6_p
x(15)=17.86278157470036_p
w(15)=6.024236607355072e-8_p
x(16)=21.09117967519855_p
w(16)=2.006605691958082e-9_p
x(17)=23.38447084103219_p
w(17)=1.072186472831275e-10_p
else
call GD(-13)
end if
end subroutine GF_m13

! [-12kT;24kT]
subroutine GF_m12(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-9.200741238648915_p
w(1)=6.602046576426932_p
x(2)=-1.780566062567245_p
w(2)=5.397959567728795_p
else if(N==3)then
x(1)=-10.38632287959363_p
w(1)=3.970896241316781_p
x(2)=-4.914383795659067_p
w(2)=6.097468830445896_p
x(3)=4.416797210069839e-1_p
w(3)=1.931641072393049_p
else if(N==4)then
x(1)=-10.92564577465329_p
w(1)=2.688037051004510_p
x(2)=-6.926378504429756_p
w(2)=4.948530971045574_p
x(3)=-1.949883262229415_p
w(3)=3.966940917418489_p
x(4)=2.582275665950446_p
w(4)=3.964972046871533e-1_p
else if(N==5)then
x(1)=-11.21775934667808_p
w(1)=1.973383097794531_p
x(2)=-8.171361582718681_p
w(2)=3.937094773996386_p
x(3)=-3.836203702870390_p
w(3)=4.326407817921698_p
x(4)=2.000355255281993e-1_p
w(4)=1.722940654123898_p
x(5)=5.115710267386743_p
w(5)=4.017980031921346e-2_p
else if(N==6)then
x(1)=-11.39558743863255_p
w(1)=1.531974896976726_p
x(2)=-8.980902804162074_p
w(2)=3.193743993950162_p
x(3)=-5.292949087168743_p
w(3)=3.978661370821201_p
x(4)=-1.413180587980659_p
w(4)=2.891420508786058_p
x(5)=2.264703468699605_p
w(5)=4.016034978900445e-1_p
x(6)=7.975417616302785_p
w(6)=2.601875731534601e-3_p
else if(N==7)then
x(1)=-11.51328263262135_p
w(1)=1.237315758147099_p
x(2)=-9.537582107305477_p
w(2)=2.650000730419661_p
x(3)=-6.391427483642458_p
w(3)=3.521681087359678_p
x(4)=-2.770046611091747_p
w(4)=3.337746313934244_p
x(5)=5.748740316889928e-1_p
w(5)=1.204334162774518_p
x(6)=4.621066412630382_p
w(6)=4.879339066022766e-2_p
x(7)=11.01695338781746_p
w(7)=1.347008602989803e-4_p
else if(N==8)then
x(1)=-11.59655895601126_p
w(1)=1.027661810106079_p
x(2)=-9.941283413601322_p
w(2)=2.240830236270873_p
x(3)=-7.232915054199138_p
w(3)=3.097600103784744_p
x(4)=-3.932414674018630_p
w(4)=3.317799011147237_p
x(5)=-6.974395005790380e-1_p
w(5)=2.045600518816748_p
x(6)=2.580676163876829_p
w(6)=2.663876484615056e-1_p
x(7)=7.206613037085464_p
w(7)=4.120220759240265e-3_p
x(8)=14.08258132638098_p
w(8)=6.594809299216771e-6_p
else if(N==9)then
x(1)=-11.65894505543087_p
w(1)=8.699856278684396e-1_p
x(2)=-10.24894598833474_p
w(2)=1.921227488320356_p
x(3)=-7.897905554364241_p
w(3)=2.727284994544479_p
x(4)=-4.923208551424741_p
w(4)=3.117587942449901_p
x(5)=-1.810320415461906_p
w(5)=2.574356847989236_p
x(6)=1.131772216790238_p
w(6)=7.532985662987696e-1_p
x(7)=4.774234461518788_p
w(7)=3.594600386101117e-2_p
x(8)=9.826564065148450_p
w(8)=3.182809302672668e-4_p
x(9)=16.89649341845515_p
w(9)=3.918932668108709e-7_p
else if(N==10)then
x(1)=-11.70769959935568_p
w(1)=7.464078100526077e-1_p
x(2)=-10.49242098549606_p
w(2)=1.663841861334298_p
x(3)=-8.437864520479954_p
w(3)=2.407350810888891_p
x(4)=-5.769242059698521_p
w(4)=2.863935655482077_p
x(5)=-2.832050502730234_p
w(5)=2.756981857659873_p
x(6)=-2.564380932526460e-2_p
w(6)=1.393746142527452_p
x(7)=3.004233457530767_p
w(7)=1.636400331470345e-1_p
x(8)=7.029547784132747_p
w(8)=4.074502885253015e-3_p
x(9)=12.29308187485142_p
w(9)=2.743283002381910e-5_p
x(10)=19.1422729968698_p
w(10)=3.734821586119156e-8_p
else if(N==11)then
x(1)=-11.7467680707218_p
w(1)=6.471669998082689e-1_p
x(2)=-10.68937162029759_p
w(2)=1.452947178948232_p
x(3)=-8.882972354806451_p
w(3)=2.132298986342224_p
x(4)=-6.491371879836888_p
w(4)=2.606042471308625_p
x(5)=-3.762757720677125_p
w(5)=2.722917397576069_p
x(6)=-1.043090104267368_p
w(6)=1.941029085330479_p
x(7)=1.638395645662086_p
w(7)=4.707844859582981e-1_p
x(8)=4.958355906391062_p
w(8)=2.634200828713029e-2_p
x(9)=9.208731898929091_p
w(9)=4.745240049323443e-4_p
x(10)=14.47774190099695_p
w(10)=3.000231169620876e-6_p
x(11)=20.71215874525788_p
w(11)=6.360297956129763e-9_p
else if(N==12)then
x(1)=-11.77856283735189_p
w(1)=5.662687673316125e-1_p
x(2)=-10.85081374419796_p
w(2)=1.278395092431271_p
x(3)=-9.253056736246007_p
w(3)=1.896652988877670_p
x(4)=-7.107015676311672_p
w(4)=2.363369930814097_p
x(5)=-4.594884051548014_p
w(5)=2.588751269640646_p
x(6)=-1.981452082123816_p
w(6)=2.250648581083128_p
x(7)=5.283213265757668e-1_p
w(7)=9.442586112647101e-1_p
x(8)=3.347526164377383_p
w(8)=1.076419881283882e-1_p
x(9)=6.902598491142054_p
w(9)=3.955805447739258e-3_p
x(10)=11.22893541454338_p
w(10)=6.266492369304743e-5_p
x(11)=16.32298916918088_p
w(11)=4.424324869852457e-7_p
x(12)=21.72990580144464_p
w(12)=1.780284343667943e-9_p
else if(N==13)then
x(1)=-11.8047593902973_p
w(1)=4.995282245612379e-1_p
x(2)=-10.98457995758579_p
w(2)=1.132685084123296_p
x(3)=-9.563074313222822_p
w(3)=1.694827107314264_p
x(4)=-7.632436792519718_p
w(4)=2.142730025039705_p
x(5)=-5.329417510640805_p
w(5)=2.418298945566999_p
x(6)=-2.851059069183017_p
w(6)=2.345471654591277_p
x(7)=-4.314940292301451e-1_p
w(7)=1.438474383850675_p
x(8)=2.057989167060285_p
w(8)=3.067869962925635e-1_p
x(9)=5.088954059436078_p
w(9)=2.057000435390166e-2_p
x(10)=8.761706478890963_p
w(10)=6.237491793665153e-4_p
x(11)=13.04455786520332_p
w(11)=9.879688914944063e-6_p
x(12)=17.82543287897635_p
w(12)=8.888354010754424e-8_p
x(13)=22.37876575510845_p
w(13)=7.099859206669639e-10_p
else if(N==14)then
x(1)=-11.82658520835291_p
w(1)=4.438656825158142e-1_p
x(2)=-11.09652629993218_p
w(2)=1.010027476272961_p
x(3)=-9.824763094432940_p
w(3)=1.521558682233796_p
x(4)=-8.082316285897988_p
w(4)=1.945330133036405_p
x(5)=-5.973876689995882_p
w(5)=2.241063959885867_p
x(6)=-3.647291070937180_p
w(6)=2.310930403502423_p
x(7)=-1.304550401357639_p
w(7)=1.802621435161199_p
x(8)=9.936263628621899e-1_p
w(8)=6.451041845220304e-1_p
x(9)=3.621435001493067_p
w(9)=7.555337571874664e-2_p
x(10)=6.797518590327030_p
w(10)=3.839496197709359e-3_p
x(11)=10.49042354948636_p
w(11)=1.093859063895299e-4_p
x(12)=14.63573475416925_p
w(12)=1.905073566831736e-6_p
x(13)=19.01735723827468_p
w(13)=2.377043727068802e-8_p
x(14)=22.80003000829081_p
w(14)=3.583801281799318e-10_p
else if(N==15)then
x(1)=-11.84495514529502_p
w(1)=3.969777754748155e-1_p
x(2)=-11.19108638375996_p
w(2)=9.059338841260618e-1_p
x(3)=-10.04733334316287_p
w(3)=1.372232583660614_p
x(4)=-8.469237613408190_p
w(4)=1.770010662221055_p
x(5)=-6.538332381907941_p
w(5)=2.069888708952145_p
x(6)=-4.367617879864687_p
w(6)=2.213997272045117_p
x(7)=-2.115978085063265_p
w(7)=1.990312430848065_p
x(8)=7.764195111255351e-2_p
w(8)=1.054540131339482_p
x(9)=2.411104937103144_p
w(9)=2.085953487014927e-1_p
x(10)=5.188532323627076_p
w(10)=1.673919401224199e-2_p
x(11)=8.425489671769276_p
w(11)=7.557124203500615e-4_p
x(12)=12.06405631242412_p
w(12)=2.198082769898420e-5_p
x(13)=16.00257073662571_p
w(13)=4.511909059710790e-7_p
x(14)=19.94887380270206_p
w(14)=8.124236359428822e-9_p
x(15)=23.0824671095099_p
w(15)=2.114453491965734e-10_p
else if(N==16)then
x(1)=-11.86055927100718_p
w(1)=3.571223391160717e-1_p
x(2)=-11.27164540791911_p
w(2)=8.169157501393245e-1_p
x(3)=-10.23800797861323_p
w(3)=1.242953674101982_p
x(4)=-8.803673641795902_p
w(4)=1.614727200769869_p
x(5)=-7.033094619902514_p
w(5)=1.910005342928620_p
x(6)=-5.014293535510546_p
w(6)=2.091928879832358_p
x(7)=-2.869624085520949_p
w(7)=2.040176055223779_p
x(8)=-7.459738271138469e-1_p
w(8)=1.418678922284964_p
x(9)=1.393360449436606_p
w(9)=4.478820847021615e-1_p
x(10)=3.846178020742620_p
w(10)=5.573616401450131e-2_p
x(11)=6.713165273008467_p
w(11)=3.711657449981310e-3_p
x(12)=9.944886744754719_p
w(12)=1.628106886213854e-4_p
x(13)=13.47269028155151_p
w(13)=5.129433940157275e-6_p
x(14)=17.15949681447094_p
w(14)=1.299393024502619e-7_p
x(15)=20.6730694655973_p
w(15)=3.391584542252209e-9_p
x(16)=23.27852560975743_p
w(16)=1.386643241489082e-10_p
else if(N==17)then
x(1)=-11.8739247038921_p
w(1)=3.229656953477238e-1_p
x(2)=-11.3408143356547_p
w(2)=7.402449672886694e-1_p
x(3)=-10.40247435134981_p
w(3)=1.130491009068464_p
x(4)=-9.094229974212375_p
w(4)=1.477218136988890_p
x(5)=-7.467703226453181_p
w(5)=1.763142428330210_p
x(6)=-5.592629611684615_p
w(6)=1.963142127327064_p
x(7)=-3.563865453737686_p
w(7)=2.008219235269877_p
x(8)=-1.508292674314921_p
w(8)=1.661592108462390_p
x(9)=5.139781007981050e-1_p
w(9)=7.704392475131002e-1_p
x(10)=2.711673732019889_p
w(10)=1.476186629237737e-1_p
x(11)=5.268152796795539_p
w(11)=1.402477656022582e-2_p
x(12)=8.164055071248413_p
w(12)=8.671887216944162e-4_p
x(13)=11.34113241652322_p
w(13)=3.912105061134632e-5_p
x(14)=14.71729783593588_p
w(14)=1.392880692732731e-6_p
x(15)=18.12931936574987_p
w(15)=4.466547794065611e-8_p
x(16)=21.23723841225273_p
w(16)=1.658941182656263e-9_p
x(17)=23.41913790794449_p
w(17)=9.792130765523515e-11_p
else
call GD(-12)
end if
end subroutine GF_m12

! [-11kT;24kT]
subroutine GF_m11(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-8.395770710606786_p
w(1)=6.137601890970807_p
x(2)=-1.506528843945099_p
w(2)=4.862414810552759_p
else if(N==3)then
x(1)=-9.486303336199528_p
w(1)=3.723465553456668_p
x(2)=-4.368236135057693_p
w(2)=5.649032121388305_p
x(3)=7.022735655271829e-1_p
w(3)=1.627519026678594_p
else if(N==4)then
x(1)=-9.985592134079662_p
w(1)=2.537361634557430_p
x(2)=-6.216215685543321_p
w(2)=4.648371723632744_p
x(3)=-1.556994362250102_p
w(3)=3.520559174805187_p
x(4)=2.923028222616561_p
w(4)=2.937241685282054e-1_p
else if(N==5)then
x(1)=-10.25754872369439_p
w(1)=1.872597680339267_p
x(2)=-7.369821537157145_p
w(2)=3.725281643131715_p
x(3)=-3.284996065742649_p
w(3)=3.990369745647802_p
x(4)=5.550707650907439e-1_p
w(4)=1.385243955212156_p
x(5)=5.545874004218735_p
w(5)=2.652367719262605e-2_p
else if(N==6)then
x(1)=-10.42393101936084_p
w(1)=1.459868477988796_p
x(2)=-8.124796903422457_p
w(2)=3.037218996858487_p
x(3)=-4.627659963845205_p
w(3)=3.738309656779815_p
x(4)=-9.763006005492396e-1_p
w(4)=2.483370795333040_p
x(5)=2.680809678742499_p
w(5)=2.796493187870995e-1_p
x(6)=8.468623786464422_p
w(6)=1.599455776330471e-3_p
else if(N==7)then
x(1)=-10.53458737190761_p
w(1)=1.182973049761333_p
x(2)=-8.646913384384744_p
w(2)=2.529637886067492_p
x(3)=-5.649714854482553_p
w(3)=3.338896159576920_p
x(4)=-2.230052228135077_p
w(4)=3.010421425451475_p
x(5)=9.928746255840060e-1_p
w(5)=9.075508056963442e-1_p
x(6)=5.109783966338812_p
w(6)=3.045802103037095e-2_p
x(7)=11.54897901882332_p
w(7)=7.935393963256141e-5_p
else if(N==8)then
x(1)=-10.61332007059306_p
w(1)=9.848382901649617e-1_p
x(2)=-9.027877409730449_p
w(2)=2.144780382528017_p
x(3)=-6.439441811864278_p
w(3)=2.951808931968229_p
x(4)=-3.306154014892992_p
w(4)=3.079572539818946_p
x(5)=-2.412161310711411e-1_p
w(5)=1.662463799578287_p
x(6)=3.053030798499261_p
w(6)=1.741045855143601e-1_p
x(7)=7.734284301892704_p
w(7)=2.444314825042436e-3_p
x(8)=14.61573950475651_p
w(8)=3.857125723792071e-6_p
else if(N==9)then
x(1)=-10.67263201572351_p
w(1)=8.349799424675058e-1_p
x(2)=-9.319958460474899_p
w(2)=1.842089262101471_p
x(3)=-7.068278534834604_p
w(3)=2.606940760951486_p
x(4)=-4.232830165410483_p
w(4)=2.937303548597419_p
x(5)=-1.291321375793958_p
w(5)=2.226896733538829_p
x(6)=1.590368146288653_p
w(6)=5.298614376556655e-1_p
x(7)=5.288961692395953_p
w(7)=2.175755326901532e-2_p
x(8)=10.35540900727859_p
w(8)=1.872227409419493e-4_p
x(9)=17.36884691227542_p
w(9)=2.402012340329619e-7_p
else if(N==10)then
x(1)=-10.71915412173157_p
w(1)=7.170913033327685e-1_p
x(2)=-9.552020662029280_p
w(2)=1.597212745238977_p
x(3)=-7.581431369329152_p
w(3)=2.305776516855074_p
x(4)=-5.030592374081212_p
w(4)=2.719780380997550_p
x(5)=-2.246339067883989_p
w(5)=2.491762567860335_p
x(6)=4.419862241246328e-1_p
w(6)=1.063112451261433_p
x(7)=3.501791125856819_p
w(7)=1.028486280328677e-1_p
x(8)=7.552774248204079_p
w(8)=2.415564802331552e-3_p
x(9)=12.79077596248032_p
w(9)=1.651810105314706e-5_p
x(10)=19.50514462054901_p
w(10)=2.504117620712783e-8_p
else if(N==11)then
x(1)=-10.75649989199096_p
w(1)=6.222468765970113e-1_p
x(2)=-9.740113404879716_p
w(2)=1.396089218570204_p
x(3)=-8.005570916914378_p
w(3)=2.045376743543166_p
x(4)=-5.714881729380410_p
w(4)=2.486216698244970_p
x(5)=-3.118084272710579_p
w(5)=2.526520766959961_p
x(6)=-5.389021584958658e-1_p
w(6)=1.593467850196160_p
x(7)=2.121449664755696_p
w(7)=3.140118415804130e-1_p
x(8)=5.475925225984967_p
w(8)=1.580127491882357e-2_p
x(9)=9.716936090696734_p
w(9)=2.835389404713579e-4_p
x(10)=14.923360171593_p
w(10)=1.887287810321321e-6_p
x(11)=20.9648844805868_p
w(11)=4.684576130197113e-9_p
else if(N==12)then
x(1)=-10.78692472384305_p
w(1)=5.448483015482235e-1_p
x(2)=-9.894482331405801_p
w(2)=1.229375213102693_p
x(3)=-8.358817186549993_p
w(3)=1.821503335656957_p
x(4)=-6.300125215251160_p
w(4)=2.261289268805454_p
x(5)=-3.901518544335694_p
w(5)=2.437548464827087_p
x(6)=-1.425171196978220_p
w(6)=1.958117279453234_p
x(7)=1.010384967441316_p
w(7)=6.788290636305820e-1_p
x(8)=3.857298933679203_p
w(8)=6.611240313559526e-2_p
x(9)=7.417623532891136_p
w(9)=2.354715625928998e-3_p
x(10)=11.70693359008294_p
w(10)=3.836060675998229e-5_p
x(11)=16.70664907499721_p
w(11)=2.937187909721625e-7_p
x(12)=21.89998991778871_p
w(12)=1.412260947852482e-9_p
else if(N==13)then
x(1)=-10.81201513785391_p
w(1)=4.809356873808217e-1_p
x(2)=-10.02251939459114_p
w(2)=1.090036091604001_p
x(3)=-8.655135619159323_p
w(3)=1.629275960967667_p
x(4)=-6.800786685890537_p
w(4)=2.054328779542520_p
x(5)=-4.596397896492990_p
w(5)=2.295994273490986_p
x(6)=-2.241394888749833_p
w(6)=2.123259910177456_p
x(7)=7.044468656265336e-2_p
w(7)=1.116770557555579_p
x(8)=2.558928076342097_p
w(8)=1.967600700972586e-1_p
x(9)=5.607234422885410_p
w(9)=1.227344199188174e-2_p
x(10)=9.259160544836245_p
w(10)=3.756066527116640e-4_p
x(11)=13.48269200563131_p
w(11)=6.259069961045601e-6_p
x(12)=18.14620545368875_p
w(12)=6.239940996183399e-8_p
x(13)=22.49425990917393_p
w(13)=5.933136349288799e-10_p
else if(N==14)then
x(1)=-10.83293696109807_p
w(1)=4.275856602899293e-1_p
x(2)=-10.1297720444039_p
w(2)=9.726123323779761e-1_p
x(3)=-8.905560853414897_p
w(3)=1.463920983828124_p
x(4)=-7.230275994150318_p
w(4)=1.867860275679357_p
x(5)=-5.208371422204070_p
w(5)=2.138251973713131_p
x(6)=-2.990206938555170_p
w(6)=2.143537793700823_p
x(7)=-7.652471148626012e-1_p
w(7)=1.497527099921536_p
x(8)=1.491092623417631_p
w(8)=4.406735587755530e-1_p
x(9)=4.138922174415543_p
w(9)=4.568904904474880e-2_p
x(10)=7.307935545763104_p
w(10)=2.289327961641292e-3_p
x(11)=10.96055310631582_p
w(11)=6.737240102042812e-5_p
x(12)=15.02900006722883_p
w(12)=1.255938791018119e-6_p
x(13)=19.28059008072741_p
w(13)=1.758066478332497e-8_p
x(14)=22.880694211173_p
w(14)=3.102719410477066e-10_p
else if(N==15)then
x(1)=-10.85055967796389_p
w(1)=3.826101298884363e-1_p
x(2)=-10.22044483235752_p
w(2)=8.728629757567804e-1_p
x(3)=-9.118775330629646_p
w(3)=1.321186128674048_p
x(4)=-7.600230231271836_p
w(4)=1.701490492618140_p
x(5)=-5.745916772444441_p
w(5)=1.981159123887629_p
x(6)=-3.670505187738164_p
w(6)=2.083178412528806_p
x(7)=-1.531836287693257_p
w(7)=1.741786602047655_p
x(8)=5.846730475297417e-1_p
w(8)=7.752834109809664e-1_p
x(9)=2.924780701875735_p
w(9)=1.300382350375307e-1_p
x(10)=5.707052649259574_p
w(10)=9.950267319529018e-3_p
x(11)=8.917410705286002_p
w(11)=4.566672103649465e-4_p
x(12)=12.5008434363908_p
w(12)=1.393905001249877e-5_p
x(13)=16.34993913578502_p
w(13)=3.100489064800498e-7_p
x(14)=20.16303446124439_p
w(14)=6.287204953396482e-9_p
x(15)=23.14070258262211_p
w(15)=1.875565672929952e-10_p
else if(N==16)then
x(1)=-10.86553961707837_p
w(1)=3.443527993844416e-1_p
x(2)=-10.29775148387795_p
w(2)=7.874860449178608e-1_p
x(3)=-9.301603393473540_p
w(3)=1.197449495848508_p
x(4)=-7.920410492964623_p
w(4)=1.553662192066812_p
x(5)=-6.218134108958512_p
w(5)=1.832059724435316_p
x(6)=-4.283713397182995_p
w(6)=1.985050752703359_p
x(7)=-2.241607956189748_p
w(7)=1.849948029009492_p
x(8)=-2.141983119965844e-1_p
w(8)=1.120767851646099_p
x(9)=1.904229179730244_p
w(9)=2.935720216296542e-1_p
x(10)=4.368410982743855_p
w(10)=3.334920863287295e-2_p
x(11)=7.220672553117339_p
w(11)=2.214625877439672e-3_p
x(12)=10.41160678001295_p
w(12)=1.004986324943968e-4_p
x(13)=13.87307745444465_p
w(13)=3.360927327467820e-6_p
x(14)=17.46291559909533_p
w(14)=9.296126569802076e-8_p
x(15)=20.8471807788945_p
w(15)=2.725508981012388e-9_p
x(16)=23.32192913105357_p
w(16)=1.251143815486439e-10_p
else if(N==17)then
x(1)=-10.87837858839702_p
w(1)=3.115444773878663e-1_p
x(2)=-10.36417368930622_p
w(2)=7.138949008895761e-1_p
x(3)=-9.459429790745997_p
w(3)=1.089687814313788_p
x(4)=-8.198882578907279_p
w(4)=1.422445331823699_p
x(5)=-6.633661580260103_p
w(5)=1.693817088252871_p
x(6)=-4.833914298311734_p
w(6)=1.872573791009158_p
x(7)=-2.896753675842671_p
w(7)=1.862273554768043_p
x(8)=-9.413715438359684e-1_p
w(8)=1.395592215461144_p
x(9)=1.029126533684816_p
w(9)=5.391492515000660e-1_p
x(10)=3.234064293811660_p
w(10)=9.017273106909185e-2_p
x(11)=5.786509027543773_p
w(11)=8.314920769040706e-3_p
x(12)=8.652863091180919_p
w(12)=5.248646332869065e-4_p
x(13)=11.77864751452751_p
w(13)=2.478091260066740e-5_p
x(14)=15.08056792268694_p
w(14)=9.441017583852160e-7_p
x(15)=18.39257592337017_p
w(15)=3.316754196765989e-8_p
x(16)=21.37944228899588_p
w(16)=1.374584096061066e-9_p
x(17)=23.45242092124967_p
w(17)=8.945098944471344e-11_p
else
call GD(-11)
end if
end subroutine GF_m11

! [-10kT;24kT]
subroutine GF_m10(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-7.589291608570593_p
w(1)=5.675311875473049_p
x(2)=-1.221802106737338_p
w(2)=4.324733523388415_p
else if(N==3)then
x(1)=-8.585496640251687_p
w(1)=3.477525970146773_p
x(2)=-3.820530928403398_p
w(2)=5.186811652106602_p
x(3)=9.860663914093162e-1_p
w(3)=1.335707776608090_p
else if(N==4)then
x(1)=-9.045156011436847_p
w(1)=2.387435541039539_p
x(2)=-5.505469197679433_p
w(2)=4.342783080154430_p
x(3)=-1.157823574540510_p
w(3)=3.060093892223670_p
x(4)=3.295949229441722_p
w(4)=2.097328854438275e-1_p
else if(N==5)then
x(1)=-9.297166899251529_p
w(1)=1.772125503230876_p
x(2)=-6.568104194986492_p
w(2)=3.511126951100874_p
x(3)=-2.735636041495766_p
w(3)=3.627029497662654_p
x(4)=9.340333108923465e-1_p
w(4)=1.072811074071868_p
x(5)=6.006253120914995_p
w(5)=1.695237279519401e-2_p
else if(N==6)then
x(1)=-9.452219451524016_p
w(1)=1.387825214530315_p
x(2)=-7.268803807756785_p
w(2)=2.879294146945852_p
x(3)=-3.965002779228018_p
w(3)=3.480959615239791_p
x(4)=-5.323522124989727e-1_p
w(4)=2.064481211616823_p
x(5)=3.130532667907970_p
w(5)=1.865284250587134e-1_p
x(6)=8.988207045136013_p
w(6)=9.567854699703722e-4_p
else if(N==7)then
x(1)=-9.555911953220432_p
w(1)=1.128526597915007_p
x(2)=-7.756588747607125_p
w(2)=2.408163739276358_p
x(3)=-4.910394963567192_p
w(3)=3.146659628131308_p
x(4)=-1.693562708731394_p
w(4)=2.646645889474379_p
x(5)=1.438220256002299_p
w(5)=6.515978497680132e-1_p
x(6)=5.627468559420037_p
w(6)=1.840596893825950e-2_p
x(7)=12.10226420472905_p
w(7)=4.572535814201677e-5_p
else if(N==8)then
x(1)=-9.630151773608354_p
w(1)=9.417961776240769e-1_p
x(2)=-8.114989688192441_p
w(2)=2.047702635062497_p
x(3)=-5.648195622904517_p
w(3)=2.800310445865129_p
x(4)=-2.686164209333640_p
w(4)=2.809081293958644_p
x(5)=2.275584787812452e-1_p
w(5)=1.290626833148652_p
x(6)=3.556550458685358_p
w(6)=1.091087311521874e-1_p
x(7)=8.283278782872934_p
w(7)=1.417054638043813e-3_p
x(8)=15.15957334570449_p
w(8)=2.227412234406419e-6_p
else if(N==9)then
x(1)=-9.686407661130627_p
w(1)=7.997187845972321e-1_p
x(2)=-8.391531633843417_p
w(2)=1.762029563403241_p
x(3)=-6.240626006188591_p
w(3)=2.482855069341102_p
x(4)=-3.548250365550900_p
w(4)=2.736071256773223_p
x(5)=-7.728178956904408e-1_p
w(5)=1.852431383378913_p
x(6)=2.077666637164877_p
w(6)=3.540133370240038e-1_p
x(7)=5.826851867066310_p
w(7)=1.281735622599365e-2_p
x(8)=10.89737592967718_p
w(8)=1.085009246521060e-4_p
x(9)=17.83730927533938_p
w(9)=1.471931062161176e-7_p
else if(N==10)then
x(1)=-9.730690642140114_p
w(1)=6.875425978892701e-1_p
x(2)=-8.612116071144429_p
w(2)=1.529824377422472_p
x(3)=-6.726608897472640_p
w(3)=2.201639895268819_p
x(4)=-4.296516261935432_p
w(4)=2.562966509984136_p
x(5)=-1.667034724080445_p
w(5)=2.186306776356359_p
x(6)=9.287408146401457e-1_p
w(6)=7.680062088789061e-1_p
x(7)=4.025815882736734_p
w(7)=6.234271274808199e-2_p
x(8)=8.091880450857500_p
w(8)=1.406436905920952e-3_p
x(9)=13.2943340690591_p
w(9)=9.866492371644282e-6_p
x(10)=19.85561506833367_p
w(10)=1.691512823763747e-8_p
else if(N==11)then
x(1)=-9.766300914624335_p
w(1)=5.971316097412001e-1_p
x(2)=-8.791265322954846_p
w(2)=1.338623652971063_p
x(3)=-7.129447161422314_p
w(3)=1.956634052086428_p
x(4)=-4.941867579628333_p
w(4)=2.358634163517362_p
x(5)=-2.480635460000395_p
w(5)=2.296856553286812_p
x(6)=-2.807628065082852e-2_p
w(6)=1.243166797617825_p
x(7)=2.632275922432917_p
w(7)=1.995673764957706e-1_p
x(8)=6.012726297938997_p
w(8)=9.262634070191893e-3_p
x(9)=10.23540975447853_p
w(9)=1.673717324477597e-4_p
x(10)=15.36931343645033_p
w(10)=1.183863069755491e-6_p
x(11)=21.20513044157993_p
w(11)=3.479294745686685e-9_p
else if(N==12)then
x(1)=-9.795344776627314_p
w(1)=5.232641041725302e-1_p
x(2)=-8.938490776121354_p
w(2)=1.179863438300038_p
x(3)=-7.465603986869374_p
w(3)=1.745007610497058_p
x(4)=-5.495905475200049_p
w(4)=2.154241962750127_p
x(5)=-3.214364157510544_p
w(5)=2.263873054486438_p
x(6)=-8.714524862127720e-1_p
w(6)=1.632189094560581_p
x(7)=1.515689369524656_p
w(7)=4.608490443870875e-1_p
x(8)=4.390011468443542_p
w(8)=3.935380394907987e-2_p
x(9)=7.946140841035009_p
w(9)=1.379785634594962e-3_p
x(10)=12.19064353887334_p
w(10)=2.330386414417555e-5_p
x(11)=17.0869861254039_p
w(11)=1.951323442272174e-7_p
x(12)=22.0607721831283_p
w(12)=1.127442346627136e-9_p
else if(N==13)then
x(1)=-9.819320407553002_p
w(1)=4.622039463382883e-1_p
x(2)=-9.060744697703001_p
w(2)=1.046981235214091_p
x(3)=-7.748038112337224_p
w(3)=1.562693068711817_p
x(4)=-5.971235708653219_p
w(4)=1.962583916504897_p
x(5)=-3.868327437008800_p
w(5)=2.159362977478236_p
x(6)=-1.638245690867290_p
w(6)=1.860829903864078_p
x(7)=5.858043555746055e-1_p
w(7)=8.171399008186125e-1_p
x(8)=3.085451988159791_p
w(8)=1.208461531831358e-1_p
x(9)=6.142134484529843_p
w(9)=7.176583879908857e-3_p
x(10)=9.765682324771317_p
w(10)=2.237193448488404e-4_p
x(11)=13.92292339058783_p
w(11)=3.949103065031493e-6_p
x(12)=18.46179778772414_p
w(12)=4.392262427035087e-8_p
x(13)=22.60349012725945_p
w(13)=4.978620700815729e-10_p
else if(N==14)then
x(1)=-9.839331329266820_p
w(1)=4.111859739401918e-1_p
x(2)=-9.163261256449097_p
w(2)=9.348570045838167e-1_p
x(3)=-7.987059627963287_p
w(3)=1.405469208064598_p
x(4)=-6.379921927184582_p
w(4)=1.788031816985573_p
x(5)=-4.446754496623296_p
w(5)=2.026270054126290_p
x(6)=-2.340155444615177_p
w(6)=1.943265537832431_p
x(7)=-2.228213019287287e-1_p
w(7)=1.177928680147081_p
x(8)=2.012982390693494_p
w(8)=2.847636152258224e-1_p
x(9)=4.676405008494249_p
w(9)=2.688549584513107e-2_p
x(10)=7.830169915636611_p
w(10)=1.345980170134911e-3_p
x(11)=11.43622944145086_p
w(11)=4.119186920166767e-5_p
x(12)=15.42173361553057_p
w(12)=8.267560553570504e-7_p
x(13)=19.53817116725678_p
w(13)=1.304585579306469e-8_p
x(14)=22.95722510729848_p
w(14)=2.692824169039209e-10_p
else if(N==15)then
x(1)=-9.856201171792435_p
w(1)=3.681387618954128e-1_p
x(2)=-9.250012607822203_p
w(2)=8.395034037609551e-1_p
x(3)=-8.190809196284386_p
w(3)=1.269482376583829_p
x(4)=-6.732602810876577_p
w(4)=1.631237924429738_p
x(5)=-4.956579608785934_p
w(5)=1.886388892884858_p
x(6)=-2.979597505747500_p
w(6)=1.929227671595191_p
x(7)=-9.513446334963362e-1_p
w(7)=1.456716215406597_p
x(8)=1.109819435869293_p
w(8)=5.352203544401055e-1_p
x(9)=3.461442661867237_p
w(9)=7.803828116566584e-2_p
x(10)=6.240140010961950_p
w(10)=5.809293565914316e-3_p
x(11)=9.417506741526051_p
w(11)=2.732059407434646e-4_p
x(12)=12.9404199601473_p
w(12)=8.799036201147547e-6_p
x(13)=16.69508234275723_p
w(13)=2.131084513911800e-7_p
x(14)=20.37188615401324_p
w(14)=4.881214800724075e-9_p
x(15)=23.19617513794626_p
w(15)=1.665889923698024e-10_p
else if(N==16)then
x(1)=-9.870552225790528_p
w(1)=3.314927423899031e-1_p
x(2)=-9.324038930426504_p
w(2)=7.578089043603550e-1_p
x(3)=-8.365703907972158_p
w(3)=1.151404621689758_p
x(4)=-7.038294487404023_p
w(4)=1.491280734891267_p
x(5)=-5.405646727040832_p
w(5)=1.749986234289386_p
x(6)=-3.558249060371145_p
w(6)=1.862696270988715_p
x(7)=-1.620031021856057_p
w(7)=1.620517099104392_p
x(8)=3.265073888103464e-1_p
w(8)=8.311758376972351e-1_p
x(9)=2.438864110600036_p
w(9)=1.828336405262899e-1_p
x(10)=4.908203182201035_p
w(10)=1.948078103508554e-2_p
x(11)=7.738706903052787_p
w(11)=1.304667022060083e-3_p
x(12)=10.88365452464545_p
w(12)=6.159930263638910e-5_p
x(13)=14.27419074251916_p
w(13)=2.196667005029667e-6_p
x(14)=17.76318839927012_p
w(14)=6.658814377063540e-8_p
x(15)=21.01667302070005_p
w(15)=2.196276484442125e-9_p
x(16)=23.36343911412693_p
w(16)=1.129562694552682e-10_p
else if(N==17)then
x(1)=-9.882860793073622_p
w(1)=3.000437932900487e-1_p
x(2)=-9.387691250131963_p
w(2)=6.873308954534509e-1_p
x(3)=-8.516820211859184_p
w(3)=1.048432936956178_p
x(4)=-7.304501521091777_p
w(4)=1.366643432549180_p
x(5)=-5.801638503540758_p
w(5)=1.621564467926489_p
x(6)=-4.079339293882225_p
w(6)=1.771686820841231_p
x(7)=-2.236412027824857_p
w(7)=1.684292325672456_p
x(8)=-3.736996047608431e-1_p
w(8)=1.107091540346799_p
x(9)=1.564809420014946_p
w(9)=3.545015300577006e-1_p
x(10)=3.776943116642026_p
w(10)=5.327610385339451e-2_p
x(11)=6.317797113014767_p
w(11)=4.850530299967521e-3_p
x(12)=9.149148934464753_p
w(12)=3.147339074974639e-4_p
x(13)=12.219266241125_p
w(13)=1.562254482847969e-5_p
x(14)=15.44311310920194_p
w(14)=6.392679493104966e-7_p
x(15)=18.65232568420944_p
w(15)=2.467111727747476e-8_p
x(16)=21.51778489630878_p
w(16)=1.141455722986494e-9_p
x(17)=23.48436964309319_p
w(17)=8.172287328621366e-11_p
else
call GD(-10)
end if
end subroutine GF_m10

! [-9kT;24kT]
subroutine GF_m9(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-6.781260857443190_p
w(1)=5.214314228762770_p
x(2)=-9.236268448130630e-1_p
w(2)=3.785809173389202_p
else if(N==3)then
x(1)=-7.683954262449468_p
w(1)=3.232601007214564_p
x(2)=-3.271349995538584_p
w(2)=4.705941046968960_p
x(3)=1.297723018615641_p
w(3)=1.061581347968447_p
else if(N==4)then
x(1)=-8.104405707267007_p
w(1)=2.237913324878445_p
x(2)=-4.794767225039734_p
w(2)=4.027695221832492_p
x(3)=-7.489983983058345e-1_p
w(3)=2.590646764100442_p
x(4)=3.704149243429385_p
w(4)=1.438680913405919e-1_p
else if(N==5)then
x(1)=-8.336679190817007_p
w(1)=1.671695819254407_p
x(2)=-5.766746122738151_p
w(2)=3.292332837406468_p
x(3)=-2.187973031964783_p
w(3)=3.230821571124148_p
x(4)=1.342498708373885_p
w(4)=7.947975027443978e-1_p
x(5)=6.498415103182833_p
w(5)=1.047567162255063e-2_p
else if(N==6)then
x(1)=-8.480511876040655_p
w(1)=1.315622805016614_p
x(2)=-6.413355887289875_p
w(2)=2.718558593656321_p
x(3)=-3.306098861470281_p
w(3)=3.198519868178742_p
x(4)=-7.585630801797967e-2_p
w(4)=1.647882171122314_p
x(5)=3.616116901306408_p
w(5)=1.189835779113363e-1_p
x(6)=9.535190716340573_p
w(6)=5.563862666445666e-4_p
else if(N==7)then
x(1)=-8.577310170608214_p
w(1)=1.073786435382762_p
x(2)=-6.866968094679506_p
w(2)=2.284616652263581_p
x(3)=-4.174665904905400_p
w(3)=2.939154484551452_p
x(4)=-1.158261736749157_p
w(4)=2.248346368516819_p
x(5)=1.916071674240797_p
w(5)=4.434254097740142e-1_p
x(6)=6.174528443899670_p
w(6)=1.076828328519168e-2_p
x(7)=12.67677426705951_p
w(7)=2.576837815217429e-5_p
else if(N==8)then
x(1)=-8.647099790854964_p
w(1)=8.983780088112047e-1_p
x(2)=-7.202911162513415_p
w(2)=1.948908073058531_p
x(3)=-4.860165457250758_p
w(3)=2.639370204052196_p
x(4)=-2.072764063506642_p
w(4)=2.497895192592834_p
x(5)=7.159389358490034e-1_p
w(5)=9.491371147690753e-1_p
x(6)=4.091780225813887_p
w(6)=6.563049038247531e-2_p
x(7)=8.853269440519369_p
w(7)=8.030465922350677e-4_p
x(8)=15.71213049089219_p
w(8)=1.271893421288201e-6_p
else if(N==9)then
x(1)=-8.700306821820982_p
w(1)=7.640806658905084e-1_p
x(2)=-7.463883416666221_p
w(2)=1.680554077839054_p
x(3)=-5.415687020883722_p
w(3)=2.352642186946369_p
x(4)=-2.870686184101499_p
w(4)=2.504263662601341_p
x(5)=-2.491997388455818e-1_p
w(5)=1.466707878249254_p
x(6)=2.596627977563239_p
w(6)=2.244569608491271e-1_p
x(7)=6.387439068446217_p
w(7)=7.355890167373828e-3_p
x(8)=11.45164427242944_p
w(8)=6.198924852816516e-5_p
x(9)=18.29927662034819_p
w(9)=9.036041635879414e-8_p
else if(N==10)then
x(1)=-8.742335787182416_p
w(1)=6.576670521905816e-1_p
x(2)=-7.672871924890255_p
w(2)=1.461311914480057_p
x(3)=-5.873947890844718_p
w(3)=2.093367168277130_p
x(4)=-3.568278288719201_p
w(4)=2.386167980191389_p
x(5)=-1.091738788123608_p
w(5)=1.841669524511403_p
x(6)=1.440859987608491_p
w(6)=5.226063694558379e-1_p
x(7)=4.575971090850428_p
w(7)=3.652288456798238e-2_p
x(8)=8.646362737421557_p
w(8)=8.046461637028364e-4_p
x(9)=13.80277148075963_p
w(9)=5.850790490442107e-6_p
x(10)=20.19238280563433_p
w(10)=1.152339816848881e-8_p
else if(N==11)then
x(1)=-8.776192770586389_p
w(1)=5.717437311933700e-1_p
x(2)=-7.842958955717910_p
w(2)=1.280268421115501_p
x(3)=-6.255028542440198_p
w(3)=1.864984212588900_p
x(4)=-4.173414095328294_p
w(4)=2.218297493460526_p
x(5)=-1.850408774410414_p
w(5)=2.025274969696437_p
x(6)=4.966282550608589e-1_p
w(6)=9.130459415170006e-1_p
x(7)=3.171964989898509_p
w(7)=1.210984508301493e-1_p
x(8)=6.568165089441116_p
w(8)=5.311787190684807e-3_p
x(9)=10.7635682786794_p
w(9)=9.765086396572415e-5_p
x(10)=15.81464568894761_p
w(10)=7.410893010420446e-7_p
x(11)=21.43273994554846_p
w(11)=2.606136694404578e-9_p
else if(N==12)then
x(1)=-8.803841140372610_p
w(1)=5.014510024359979e-1_p
x(2)=-7.982947583515118_p
w(2)=1.129634560025463_p
x(3)=-6.573758680849813_p
w(3)=1.666383296148044_p
x(4)=-4.695238222137918_p
w(4)=2.038877177801675_p
x(5)=-2.534443943104322_p
w(5)=2.057504283416452_p
x(6)=-3.150562415651175e-1_p
w(6)=1.287617479644194_p
x(7)=2.048382368089448_p
w(7)=2.950879564894573e-1_p
x(8)=4.944951178668598_p
w(8)=2.275710732031526e-2_p
x(9)=8.487615305197954_p
w(9)=7.963516687180917e-4_p
x(10)=12.67941413890935_p
w(10)=1.405648883703147e-5_p
x(11)=17.46323155365968_p
w(11)=1.298072138669714e-7_p
x(12)=22.21246979407516_p
w(12)=9.056042130104399e-10_p
else if(N==13)then
x(1)=-8.826690593722528_p
w(1)=4.432775072285508e-1_p
x(2)=-8.099346604753023_p
w(2)=1.003336964912449_p
x(3)=-6.842059511565643_p
w(3)=1.494494905780492_p
x(4)=-5.144491842565307_p
w(4)=1.865211974469332_p
x(5)=-3.146453336787796_p
w(5)=2.000055009931862_p
x(6)=-1.039349866732166_p
w(6)=1.558201681743404_p
x(7)=1.121385585146316_p
w(7)=5.599681790814415e-1_p
x(8)=3.637499777466993_p
w(8)=7.132582565827743e-2_p
x(9)=6.692971222960280_p
w(9)=4.116976150789229e-3_p
x(10)=10.28073703871646_p
w(10)=1.318630483559345e-4_p
x(11)=14.3646136428793_p
w(11)=2.482717110276143e-6_p
x(12)=18.77170163139657_p
w(12)=3.101052163050416e-8_p
x(13)=22.70669040651192_p
w(13)=4.193864239189359e-10_p
else if(N==14)then
x(1)=-8.845781468887720_p
w(1)=3.946189640466368e-1_p
x(2)=-8.197070556469180_p
w(2)=8.966094891445340e-1_p
x(3)=-7.069488387130050_p
w(3)=1.345755232092587_p
x(4)=-5.531824694635850_p
w(4)=1.704245135225952_p
x(5)=-3.690186168618329_p
w(5)=1.899049593423968_p
x(6)=-1.697001931932244_p
w(6)=1.701422528700891_p
x(7)=3.296313683572329e-1_p
w(7)=8.677028478734247e-1_p
x(8)=2.561432832602371_p
w(8)=1.744821234069033e-1_p
x(9)=5.233001046045772_p
w(9)=1.543113200656650e-2_p
x(10)=8.363663392461380_p
w(10)=7.807912333161728e-4_p
x(11)=11.91692070881295_p
w(11)=2.501139266253029e-5_p
x(12)=15.81338174128571_p
w(12)=5.436556375059348e-7_p
x(13)=19.78982170510242_p
w(13)=9.714661250046883e-9_p
x(14)=23.02979447623382_p
w(14)=2.342314809034767e-10_p
else if(N==15)then
x(1)=-8.861890948663262_p
w(1)=3.535224148689239e-1_p
x(2)=-8.279854986515808_p
w(2)=8.057275546960285e-1_p
x(3)=-7.263626076461530_p
w(3)=1.216768481872192_p
x(4)=-5.866819910040931_p
w(4)=1.558098167115707_p
x(5)=-4.171312603647531_p
w(5)=1.781309654466525_p
x(6)=-2.295766638233665_p
w(6)=1.741705143436720_p
x(7)=-3.697722984420295e-1_p
w(7)=1.147931899050487_p
x(8)=1.658246311069679_p
w(8)=3.462935870058220e-1_p
x(9)=4.020422900293140_p
w(9)=4.526395056077005e-2_p
x(10)=6.787080414378291_p
w(10)=3.334975427557866e-3_p
x(11)=9.925276660165901_p
w(11)=1.618919238994916e-4_p
x(12)=13.38228691193649_p
w(12)=5.531218614967636e-6_p
x(13)=17.03756665045841_p
w(13)=1.465585830883930e-7_p
x(14)=20.57530464844999_p
w(14)=3.802005637878559e-9_p
x(15)=23.24899916941938_p
w(15)=1.481366587264952e-10_p
else if(N==16)then
x(1)=-8.875606906655944_p
w(1)=3.185061882907144e-1_p
x(2)=-8.350563819777365_p
w(2)=7.277759049378616e-1_p
x(3)=-7.430470870483699_p
w(3)=1.104535254102085_p
x(4)=-6.157708385842231_p
w(4)=1.426724719711577_p
x(5)=-4.596456918257972_p
w(5)=1.660777956880233_p
x(6)=-2.839079759828126_p
w(6)=1.715873842283508_p
x(7)=-1.002791783007192_p
w(7)=1.351032092684554_p
x(8)=8.831117485144989e-1_p
w(8)=5.742840013505504e-1_p
x(9)=2.997949481035500_p
w(9)=1.086803620193766e-1_p
x(10)=5.464616702823458_p
w(10)=1.113474404067764e-2_p
x(11)=8.266710481450042_p
w(11)=7.593478711056191e-4_p
x(12)=11.36056656915283_p
w(12)=3.750571807724234e-5_p
x(13)=14.67559108990207_p
w(13)=1.432619088758353e-6_p
x(14)=18.06000229409804_p
w(14)=4.776591626096477e-8_p
x(15)=21.18150884556001_p
w(15)=1.774621231048521e-9_p
x(16)=23.40313020260284_p
w(16)=1.020257866203992e-10_p
else if(N==17)then
x(1)=-8.887379871124727_p
w(1)=2.884320504121483e-1_p
x(2)=-8.411415548173458_p
w(2)=6.604598636961861e-1_p
x(3)=-7.574783181453800_p
w(3)=1.006493933086092_p
x(4)=-6.411405941774952_p
w(4)=1.309157752693381_p
x(5)=-4.972315621040111_p
w(5)=1.544232370931611_p
x(6)=-3.330073286632648_p
w(6)=1.653593282889219_p
x(7)=-1.582602545213179_p
w(7)=1.465715668500099_p
x(8)=2.011279885841782e-1_p
w(8)=8.190078426996493e-1_p
x(9)=2.124295832866606_p
w(9)=2.194792670954208e-1_p
x(10)=4.339356124144498_p
w(10)=3.056682313283391e-2_p
x(11)=6.861303836671180_p
w(11)=2.787223482042792e-3_p
x(12)=9.652438781655645_p
w(12)=1.870663236078755e-4_p
x(13)=12.66256720248035_p
w(13)=9.805264377424180e-6_p
x(14)=15.80456846395546_p
w(14)=4.325362737527780e-7_p
x(15)=18.90835746611519_p
w(15)=1.838450346129077e-8_p
x(16)=21.65227105880384_p
w(16)=9.498645872976721e-10_p
x(17)=23.51503314786074_p
w(17)=7.466172586903081e-11_p
else
call GD(-9)
end if
end subroutine GF_m9

! [-8kT;24kT]
subroutine GF_m8(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.971704490387202_p
w(1)=4.752845997670363_p
x(2)=-6.083138648271402e-1_p
w(2)=3.247489408664781_p
else if(N==3)then
x(1)=-6.781797142315146_p
w(1)=2.987695480919442_p
x(2)=-2.720431720004385_p
w(2)=4.201208058008925_p
x(3)=1.642725374634074_p
w(3)=8.114318674067775e-1_p
else if(N==4)then
x(1)=-7.163460862629292_p
w(1)=2.088124189603410_p
x(2)=-4.084916367811805_p
w(2)=3.696905023866106_p
x(3)=-3.256459869479345e-1_p
w(3)=2.120794592545233_p
x(4)=4.150679684464460_p
w(4)=9.451160032039561e-2_p
else if(N==5)then
x(1)=-7.376189256085797_p
w(1)=1.570812036992547_p
x(2)=-4.966512093998908_p
w(2)=3.064982813661301_p
x(3)=-1.640682422084215_p
w(3)=2.798979410719246_p
x(4)=1.786367126896753_p
w(4)=5.593115523857234e-1_p
x(5)=7.023979642900457_p
w(5)=6.249592576327579e-3_p
else if(N==6)then
x(1)=-7.508897353314117_p
w(1)=1.242870093041368_p
x(2)=-5.559079401041951_p
w(2)=2.552513577972032_p
x(3)=-2.651842059503295_p
w(3)=2.881047159256755_p
x(4)=4.003303696554958e-1_p
w(4)=1.251069555343953_p
x(5)=4.139350824930539_p
w(5)=7.252081985186080e-2_p
x(6)=10.11061510629512_p
w(6)=3.142008691765855e-4_p
else if(N==7)then
x(1)=-7.598859506955943_p
w(1)=1.018431242484066_p
x(2)=-5.978565492016958_p
w(2)=2.157286288484479_p
x(3)=-3.443919197969224_p
w(3)=2.707580543158204_p
x(4)=-6.195056794664775e-1_p
w(4)=1.825919241542552_p
x(5)=2.430829219916681_p
w(5)=2.850044419248349e-1_p
x(6)=6.751267441079806_p
w(6)=6.099445219324210e-3_p
x(7)=13.27221172409135_p
w(7)=1.420352168441511e-5_p
else if(N==8)then
x(1)=-7.664227644252088_p
w(1)=8.543244866172137e-1_p
x(2)=-6.292048418317518_p
w(2)=1.847179405278765_p
x(3)=-4.076613716744506_p
w(3)=2.462769713646233_p
x(4)=-1.464714969017874_p
w(4)=2.141643840697746_p
x(5)=1.231422867972910_p
w(5)=6.560228024637951e-1_p
x(6)=4.658772077668921_p
w(6)=3.794941617115263e-2_p
x(7)=9.443810200473779_p
w(7)=4.450220109999419e-4_p
x(8)=16.27100563470187_p
w(8)=7.194492389545555e-7_p
else if(N==9)then
x(1)=-7.714377966480248_p
w(1)=7.278632515282404e-1_p
x(2)=-6.537319659941623_p
w(2)=1.596782666942746_p
x(3)=-4.594453498526972_p
w(3)=2.212106308427953_p
x(4)=-2.200791538819592_p
w(4)=2.230963582466587_p
x(5)=2.872820566219716e-1_p
w(5)=1.093275598356760_p
x(6)=3.148995178372356_p
w(6)=1.351928082407666e-1_p
x(7)=6.970220891597782_p
w(7)=4.116195287879018e-3_p
x(8)=12.01729910343261_p
w(8)=3.493939952612033e-5_p
x(9)=18.75208637382043_p
w(9)=5.568468527251143e-8_p
else if(N==10)then
x(1)=-7.754127425492304_p
w(1)=6.273030280101727e-1_p
x(2)=-6.734523903498103_p
w(2)=1.391016735627210_p
x(3)=-5.024216489872732_p
w(3)=1.978092654234611_p
x(4)=-2.847143127509916_p
w(4)=2.178880700168241_p
x(5)=-5.154206369953980e-1_p
w(5)=1.469863129616725_p
x(6)=1.983561936522493_p
w(6)=3.340005130862930e-1_p
x(7)=5.151675153501849_p
w(7)=2.072261677621498e-2_p
x(8)=9.215692394947556_p
w(8)=4.525736736326051e-4_p
x(9)=14.31503714460573_p
w(9)=3.447217994784928e-6_p
x(10)=20.51434855864355_p
w(10)=7.924049373515152e-9_p
else if(N==11)then
x(1)=-7.786206510152060_p
w(1)=5.459493421780942e-1_p
x(2)=-6.895384146444392_p
w(2)=1.220511378330287_p
x(3)=-5.382923419021619_p
w(3)=1.768407958814949_p
x(4)=-3.410822428548187_p
w(4)=2.057117963832825_p
x(5)=-1.225569094230467_p
w(5)=1.708672681157383_p
x(6)=1.043070198253654_p
w(6)=6.262537913970073e-1_p
x(7)=3.740648442045641_p
w(7)=7.038276182563685e-2_p
x(8)=7.141645273204375_p
w(8)=2.982724248452505e-3_p
x(9)=11.30078720839384_p
w(9)=5.633926716979902e-5_p
x(10)=16.25837098175966_p
w(10)=4.633145857795121e-7_p
x(11)=21.64769029235437_p
w(11)=1.968754710023622e-9_p
else if(N==12)then
x(1)=-7.812439856658139_p
w(1)=4.792958931340042e-1_p
x(2)=-7.028009317253185_p
w(2)=1.078279315442175_p
x(3)=-5.683771455087959_p
w(3)=1.584160069954869_p
x(4)=-3.899272770205849_p
w(4)=1.909371761572675_p
x(5)=-1.861943457936245_p
w(5)=1.807914413617565_p
x(6)=2.515825714208638e-1_p
w(6)=9.495234426240117e-1_p
x(7)=2.611033790945767_p
w(7)=1.785177420233456e-1_p
x(8)=5.521297264549675_p
w(8)=1.281130500803318e-2_p
x(9)=9.041501672444047_p
w(9)=4.529527795450118e-4_p
x(10)=13.17256163689891_p
w(10)=8.422932574602570e-6_p
x(11)=17.83462814952932_p
w(11)=8.651464568773739e-8_p
x(12)=22.35534704505155_p
w(12)=7.316994256016330e-10_p
else if(N==13)then
x(1)=-7.834147755907734_p
w(1)=4.240597656734548e-1_p
x(2)=-7.138455856962177_p
w(2)=9.587696520228601e-1_p
x(3)=-5.937599881525732_p
w(3)=1.423578153913477_p
x(4)=-4.321519384774741_p
w(4)=1.758065107029841_p
x(5)=-2.431826135244181_p
w(5)=1.806777236902978_p
x(6)=-4.397314352138499e-1_p
w(6)=1.227721312945077_p
x(7)=1.683087508166156_p
w(7)=3.583564134548388e-1_p
x(8)=4.214402172142236_p
w(8)=4.060988276905497e-2_p
x(9)=7.259079394079390_p
w(9)=2.319356196568423e-3_p
x(10)=10.80377308262838_p
w(10)=7.694708902038742e-5_p
x(11)=14.80710998779251_p
w(11)=1.556015500269379e-6_p
x(12)=19.07544231419606_p
w(12)=2.196792320642822e-8_p
x(13)=22.80410604364394_p
w(13)=3.545509312447782e-10_p
else if(N==14)then
x(1)=-7.852306211237540_p
w(1)=3.778013649126398e-1_p
x(2)=-7.231310215578095_p
w(2)=8.575933119754282e-1_p
x(3)=-6.153177571842854_p
w(3)=1.283928664667217_p
x(4)=-4.686781323189726_p
w(4)=1.613510326855696_p
x(5)=-2.939938346009039_p
w(5)=1.747147735551841_p
x(6)=-1.058622687421004_p
w(6)=1.415969928502321_p
x(7)=8.999500584234476e-1_p
w(7)=5.934442676189058e-1_p
x(8)=3.137137729320547_p
w(8)=1.018210376073487e-1_p
x(9)=5.807802470069488_p
w(9)=8.656176681066712e-3_p
x(10)=8.907863621391030_p
w(10)=4.471386725822682e-4_p
x(11)=12.40208281877701_p
w(11)=1.508856357399385e-5_p
x(12)=16.20339390570331_p
w(12)=3.572619771758598e-7_p
x(13)=20.03529793975823_p
w(13)=7.260396031897136e-9_p
x(14)=23.09857532838906_p
w(14)=2.041510541066154e-10_p
else if(N==15)then
x(1)=-7.867645203059266_p
w(1)=3.386887208333318e-1_p
x(2)=-7.310065829949354_p
w(2)=7.713030548411245e-1_p
x(3)=-6.337502040194852_p
w(3)=1.162373429389798_p
x(4)=-5.003540240596708_p
w(4)=1.479871706068395_p
x(5)=-3.391336742055012_p
w(5)=1.658694316826227_p
x(6)=-1.618824951014739_p
w(6)=1.510869134579572_p
x(7)=2.200734730826618e-1_p
w(7)=8.406585893556209e-1_p
x(8)=2.233419508348180_p
w(8)=2.104227043852601e-1_p
x(9)=4.600716008107791_p
w(9)=2.547078409739399e-2_p
x(10)=7.347193008890387_p
w(10)=1.884338953640492e-3_p
x(11)=10.44021762734119_p
w(11)=9.505918853065127e-5_p
x(12)=13.82594160922222_p
w(12)=3.463836654318058e-6_p
x(13)=17.37697269675565_p
w(13)=1.008766533991348e-7_p
x(14)=20.77319310699269_p
w(14)=2.971086850441225e-9_p
x(15)=23.29928834599536_p
w(15)=1.318552118140890e-10_p
else if(N==16)then
x(1)=-7.880717683914152_p
w(1)=3.053297609682690e-1_p
x(2)=-7.377406719379937_p
w(2)=6.971893240892434e-1_p
x(3)=-6.496137375236843_p
w(3)=1.056301000241041_p
x(4)=-5.279199877762188_p
w(4)=1.358339040908085_p
x(5)=-3.791645780339137_p
w(5)=1.559057646118214_p
x(6)=-2.126992795407685_p
w(6)=1.533146221369462_p
x(7)=-3.850591813723283e-1_p
w(7)=1.053774624462944_p
x(8)=1.461979590693383_p
w(8)=3.685009677480392e-1_p
x(9)=3.581105858006898_p
w(9)=6.199723503027331e-2_p
x(10)=6.036736369501629_p
w(10)=6.239036527478649e-3_p
x(11)=8.804142584938138_p
w(11)=4.368876653081901e-4_p
x(12)=11.84187838589801_p
w(12)=2.269275180379131e-5_p
x(13)=15.07684383292853_p
w(13)=9.326051707044019e-7_p
x(14)=18.35306324925022_p
w(14)=3.431990764849832e-8_p
x(15)=21.3416698221204_p
w(15)=1.437724440557116e-9_p
x(16)=23.44107633256727_p
w(16)=9.217994854982125e-11_p
else if(N==17)then
x(1)=-7.891948045977482_p
w(1)=2.766533632077038e-1_p
x(2)=-7.435416269002381_p
w(2)=6.331117518913453e-1_p
x(3)=-6.633517405840119_p
w(3)=9.634278323919188e-1_p
x(4)=-5.520055023378667_p
w(4)=1.248714851661759_p
x(5)=-4.146620869464468_p
w(5)=1.457827342527722_p
x(6)=-2.587266418563263_p
w(6)=1.508031020024107_p
x(7)=-9.330107258952168e-1_p
w(7)=1.205474830851519_p
x(8)=7.907549706957349e-1_p
w(8)=5.596757093638488e-1_p
x(9)=2.709071662891846_p
w(9)=1.286329580688177e-1_p
x(10)=4.920188951307320_p
w(10)=1.708995991550182e-2_p
x(11)=7.416359197001941_p
w(11)=1.579099134447260e-3_p
x(12)=10.16226661473973_p
w(12)=1.102513468646493e-4_p
x(13)=13.10813153794649_p
w(13)=6.128850516213462e-6_p
x(14)=16.16457918294076_p
w(14)=2.925128675237625e-7_p
x(15)=19.16047892734348_p
w(15)=1.372598435775628e-8_p
x(16)=21.78291807003913_p
w(16)=7.920206066206524e-10_p
x(17)=23.54446012215458_p
w(17)=6.820064681113097e-11_p
else
call GD(-8)
end if
end subroutine GF_m8

! [-7kT;24kT]
subroutine GF_m7(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-5.160732882585797_p
w(1)=4.287642610326931_p
x(2)=-2.708834636493663e-1_p
w(2)=2.713268856089092_p
else if(N==3)then
x(1)=-5.879247671875054_p
w(1)=2.740849544732726_p
x(2)=-2.166718404687567_p
w(2)=3.668240088107285_p
x(3)=2.027330988880821_p
w(3)=5.918218335760120e-1_p
else if(N==4)then
x(1)=-6.222517991614117_p
w(1)=1.936770090533825_p
x(2)=-3.376769609317541_p
w(2)=3.341537280163867_p
x(3)=1.189209954494743e-1_p
w(3)=1.663311968587899_p
x(4)=4.638519392864755_p
w(4)=5.929212713043185e-2_p
else if(N==5)then
x(1)=-6.415858762867009_p
w(1)=1.468534004736639_p
x(2)=-4.168416004227391_p
w(2)=2.822537079605669_p
x(3)=-1.090433989719424_p
w(3)=2.334792935724207_p
x(4)=2.271446979712373_p
w(4)=3.714536199366161e-1_p
x(5)=7.584672825640502_p
w(5)=3.593826412890921e-3_p
else if(N==6)then
x(1)=-6.537510327636189_p
w(1)=1.168841003004540_p
x(2)=-4.706852181903346_p
w(2)=2.376705960542097_p
x(3)=-2.002201504513535_p
w(3)=2.518942356711790_p
x(4)=9.047033719533308e-1_p
w(4)=8.940283255330669e-1_p
x(5)=4.701640408695101_p
w(5)=4.222169846949379e-2_p
x(6)=10.71554791356466_p
w(6)=1.721221550354294e-4_p
else if(N==7)then
x(1)=-6.620673155132381_p
w(1)=9.618776877303431e-1_p
x(2)=-5.092107444724449_p
w(2)=2.023044546216286_p
x(3)=-2.719420065174752_p
w(3)=2.439958033656845_p
x(4)=-6.986165624346077e-2_p
w(4)=1.399914011976112_p
x(5)=2.985753524050288_p
w(5)=1.727644501592738e-1_p
x(6)=7.357919807156114_p
w(6)=3.345076689391692e-3_p
x(7)=13.8879461272409_p
w(7)=7.659987772174771e-6_p
else if(N==8)then
x(1)=-6.681625977704559_p
w(1)=8.091694681372714e-1_p
x(2)=-5.382973833355788_p
w(2)=1.740261844508959_p
x(3)=-3.298983719786077_p
w(3)=2.260685539163227_p
x(4)=-8.580918269321262e-1_p
w(4)=1.745786400100103_p
x(5)=1.780980677336467_p
w(5)=4.236375327350065e-1_p
x(6)=5.257266321815350_p
w(6)=2.112901334059392e-2_p
x(7)=10.05435097869536_p
w(7)=2.412644334172598e-4_p
x(8)=16.83333658936574_p
w(8)=4.039974456543492e-7_p
else if(N==9)then
x(1)=-6.728690889227162_p
w(1)=6.906964519733964e-1_p
x(2)=-5.612277343905425_p
w(2)=1.509055861259607_p
x(3)=-3.778182234907408_p
w(3)=2.054028851012243_p
x(4)=-1.537648033263344_p
w(4)=1.908197670004476_p
x(5)=8.457859789472674e-1_p
w(5)=7.591167981343478e-1_p
x(6)=3.735410312697026_p
w(6)=7.754886154341183e-2_p
x(7)=7.574702407915494_p
w(7)=2.247495307088780e-3_p
x(8)=12.59334900091197_p
w(8)=1.944266480494474e-5_p
x(9)=19.19311100042946_p
w(9)=3.451664630727494e-8_p
else if(N==10)then
x(1)=-6.766121058329224_p
w(1)=5.961489038415481e-1_p
x(2)=-5.797415230985199_p
w(2)=1.317676832373105_p
x(3)=-4.178451237519504_p
w(3)=1.850612618109035_p
x(4)=-2.133777676486380_p
w(4)=1.928561089312398_p
x(5)=6.991270449750780e-2_p
w(5)=1.095705493695075_p
x(6)=2.560416113857955_p
w(6)=2.005454417647042e-1_p
x(7)=5.752252451118460_p
w(7)=1.140869631980889e-2_p
x(8)=9.799331506450727_p
w(8)=2.503657928780168e-4_p
x(9)=14.83002889726083_p
w(9)=2.019703640803311e-6_p
x(10)=20.8206473647261_p
w(10)=5.503830202378629e-9_p
else if(N==11)then
x(1)=-6.796387902233614_p
w(1)=5.194961707504935e-1_p
x(2)=-5.948819572871874_p
w(2)=1.158362325958799_p
x(3)=-4.513981960068133_p
w(3)=1.663109574683664_p
x(4)=-2.655334083421831_p
w(4)=1.863282092412504_p
x(5)=-6.013018613265014e-1_p
w(5)=1.356450875402792_p
x(6)=1.618432078999446_p
w(6)=3.992156999817204e-1_p
x(7)=4.337804960037376_p
w(7)=3.932097086213293e-2_p
x(8)=7.732596973878533_p
w(8)=1.641306304239180e-3_p
x(9)=11.84641678785792_p
w(9)=3.215906318363617e-5_p
x(10)=16.69949240741947_p
w(10)=2.894967324161102e-7_p
x(11)=21.85008809336896_p
w(11)=1.499762035281251e-9_p
else if(N==12)then
x(1)=-6.821179304956429_p
w(1)=4.565845474404518e-1_p
x(2)=-6.073906256227136_p
w(2)=1.025002146372201_p
x(3)=-4.796340743037023_p
w(3)=1.495510228690716_p
x(4)=-3.109333289074340_p
w(4)=1.756200859150654_p
x(5)=-1.195030104276485_p
w(5)=1.510229036882131_p
x(6)=8.374304852298676e-1_p
w(6)=6.476417399905247e-1_p
x(7)=3.204629647232157_p
w(7)=1.024500131168698e-1_p
x(8)=6.118225726891614_p
w(8)=7.033798613303221e-3_p
x(9)=9.607260375484323_p
w(9)=2.540210824374591e-4_p
x(10)=13.66938527963666_p
w(10)=5.016681721465502e-6_p
x(11)=18.20044823738996_p
w(11)=5.780053425915461e-8_p
x(12)=22.48971041117654_p
w(12)=5.944787150054619e-10_p
else if(N==13)then
x(1)=-6.841724380105028_p
w(1)=4.043668345635116e-1_p
x(2)=-6.178264889718337_p
w(2)=9.126278879591786e-1_p
x(3)=-5.035236046142340_p
w(3)=1.347786987674440_p
x(4)=-3.503537292707536_p
w(4)=1.633858829374430_p
x(5)=-1.724470725447607_p
w(5)=1.567972722398409_p
x(6)=1.685383163428801e-1_p
w(6)=8.961205840581370e-1_p
x(7)=2.274967960497962_p
w(7)=2.144639352090454e-1_p
x(8)=4.815176292433177_p
w(8)=2.238401272572204e-2_p
x(9)=7.839834204927833_p
w(9)=1.284210322186757e-3_p
x(10)=11.33423741743125_p
w(10)=4.447353546351206e-5_p
x(11)=15.24976070781869_p
w(11)=9.726759209243217e-7_p
x(12)=19.37259115825475_p
w(12)=1.561885534511962e-8_p
x(13)=22.89599232767418_p
w(13)=3.007227524294197e-10_p
else if(N==14)then
x(1)=-6.858933276638784_p
w(1)=3.605738589155605e-1_p
x(2)=-6.266142625195696_p
w(2)=8.172664215628778e-1_p
x(3)=-5.238607338862346_p
w(3)=1.218308658423401_p
x(4)=-3.845854459727612_p
w(4)=1.510321627575933_p
x(5)=-2.196919660963228_p
w(5)=1.558011518067698_p
x(6)=-4.197909847821540e-1_p
w(6)=1.099235995666376_p
x(7)=1.495370578169405_p
w(7)=3.752813908917571e-1_p
x(8)=3.739692952445296_p
w(8)=5.689624981554418e-2_p
x(9)=6.399947628228619_p
w(9)=4.753540182033296e-3_p
x(10)=9.462238894839603_p
w(10)=2.529176697185617e-4_p
x(11)=12.89117424325126_p
w(11)=9.047310805712654e-6_p
x(12)=16.5912364048167_p
w(12)=2.347097107567186e-7_p
x(13)=20.27439846565032_p
w(13)=5.446363320839188e-9_p
x(14)=23.16374212896797_p
w(14)=1.782439892377321e-10_p
else if(N==15)then
x(1)=-6.873487769302870_p
w(1)=3.234984861768563e-1_p
x(2)=-6.340783420913738_p
w(2)=7.357725050334795e-1_p
x(3)=-5.412840346702017_p
w(3)=1.104959396151299_p
x(4)=-4.143671614381161_p
w(4)=1.392372558167418_p
x(5)=-2.617870111762772_p
w(5)=1.507463983277949_p
x(6)=-9.462585660409815e-1_p
w(6)=1.234987775521144_p
x(7)=8.268270162747173e-1_p
w(7)=5.660671816074778e-1_p
x(8)=2.836863010788393_p
w(8)=1.207330766752298e-1_p
x(9)=5.201206300391663_p
w(9)=1.395019732774481e-2_p
x(10)=7.919847828858499_p
w(10)=1.048741456600828e-3_p
x(11)=10.96183940550366_p
w(11)=5.533133606188806e-5_p
x(12)=14.27089128417521_p
w(12)=2.161727495172748e-6_p
x(13)=17.71290660017325_p
w(13)=6.951054786260081e-8_p
x(14)=20.9654864073893_p
w(14)=2.329267362075824e-9_p
x(15)=23.34715620514991_p
w(15)=1.174515840476201e-10_p
else if(N==16)then
x(1)=-6.885905195929812_p
w(1)=2.918409262788920e-1_p
x(2)=-6.404686361333964_p
w(2)=6.656584721037043e-1_p
x(3)=-5.563045130674359_p
w(3)=1.005617176848078_p
x(4)=-4.403540250748825_p
w(4)=1.282898374727580_p
x(5)=-2.992461842009593_p
w(5)=1.435808762875938_p
x(6)=-1.421383945853109_p
w(6)=1.304808636703113_p
x(7)=2.408884974826321e-1_p
w(7)=7.563687974573881e-1_p
x(8)=2.067619795890627_p
w(8)=2.200911289529025e-1_p
x(9)=4.187314128794596_p
w(9)=3.412414878892640e-2_p
x(10)=6.623718320517484_p
w(10)=3.432160359808050e-3_p
x(11)=9.350492682032852_p
w(11)=2.486004033806012e-4_p
x(12)=12.32713790390817_p
w(12)=1.364879667513749e-5_p
x(13)=15.47753072303556_p
w(13)=6.061659128793148e-7_p
x(14)=18.64210467521705_p
w(14)=2.470267048674262e-8_p
x(15)=21.49715928788985_p
w(15)=1.167759599301619e-9_p
x(16)=23.47735132053127_p
w(16)=8.329385037632226e-11_p
else if(N==17)then
x(1)=-6.896583305048781_p
w(1)=2.645991261454327e-1_p
x(2)=-6.459796128311692_p
w(2)=6.049492809884848e-1_p
x(3)=-5.693314904385555_p
w(3)=9.183406444859411e-1_p
x(4)=-4.631104898267409_p
w(4)=1.182789445863397_p
x(5)=-3.325716951836254_p
w(5)=1.355235122439256_p
x(6)=-1.851394590667724_p
w(6)=1.322748669834953_p
x(7)=-2.821983323370406e-1_p
w(7)=9.180982959890053e-1_p
x(8)=1.402375610915322_p
w(8)=3.519907632867110e-1_p
x(9)=3.319105436902744_p
w(9)=7.187127784361140e-2_p
x(10)=5.518328679604072_p
w(10)=9.337613683023981e-3_p
x(11)=7.982350346475554_p
w(11)=8.827437917369744e-4_p
x(12)=10.67818717801595_p
w(12)=6.445705406869125e-5_p
x(13)=13.55555530914324_p
w(13)=3.816256276730763e-6_p
x(14)=16.522810826331_p
w(14)=1.977621413851350e-7_p
x(15)=19.40852302291051_p
w(15)=1.026805286581296e-8_p
x(16)=21.90975782460067_p
w(16)=6.616497861685770e-10_p
x(17)=23.57269936201066_p
w(17)=6.227995093532544e-11_p
else
call GD(-7)
end if
end subroutine GF_m7

! [-6kT;24kT]
subroutine GF_m6(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-4.348502569407551_p
w(1)=3.813108182940978_p
x(2)=9.542183667493187e-2_p
w(2)=2.189367502159001_p
else if(N==3)then
x(1)=-4.976655543587447_p
w(1)=2.488345797800751_p
x(2)=-1.607601557246433_p
w(2)=3.105730002460194_p
x(3)=2.458421443948151_p
w(3)=4.083998848390337e-1_p
else if(N==4)then
x(1)=-5.281879736523052_p
w(1)=1.781338100744269_p
x(2)=-2.670803873369326_p
w(2)=2.950350718119315_p
x(3)=5.933802848563304e-1_p
w(3)=1.235358492395401_p
x(4)=5.170632666860740_p
w(4)=3.542837384099447e-2_p
else if(N==5)then
x(1)=-5.455932732572657_p
w(1)=1.363033508519490_p
x(2)=-3.373604877138273_p
w(2)=2.554664747540789_p
x(3)=-5.309628009368459e-1_p
w(3)=1.851154188136658_p
x(4)=2.803010258905502_p
w(4)=2.316347323166647e-1_p
x(5)=8.182416487567073_p
w(5)=1.988508586377618e-3_p
else if(N==6)then
x(1)=-5.566551686253729_p
w(1)=1.092125545915040_p
x(2)=-3.857807755853991_p
w(2)=2.183372067677571_p
x(3)=-1.355003890971086_p
w(3)=2.108140761336796_p
x(4)=1.446360543636758_p
w(4)=5.952668074889100e-1_p
x(5)=5.304163162313857_p
w(5)=2.347914215024244e-2_p
x(6)=11.351107810205_p
w(6)=9.136053141942786e-5_p
else if(N==7)then
x(1)=-5.642916882473131_p
w(1)=9.029998777642254e-1_p
x(2)=-4.208573806872321_p
w(2)=1.876160029933757_p
x(3)=-2.001471991733488_p
w(3)=2.123284253752489_p
x(4)=5.007424885949275e-1_p
w(4)=9.994209654694504e-1_p
x(5)=3.582875726217052_p
w(5)=9.883037704210276e-2_p
x(6)=7.994699533096707_p
w(6)=1.776136773540834e-3_p
x(7)=14.52294244066552_p
w(7)=4.044364414102433e-6_p
else if(N==8)then
x(1)=-5.699426092546274_p
w(1)=7.620100328306763e-1_p
x(2)=-4.476474752415058_p
w(2)=1.623893349753163_p
x(3)=-2.528469265649004_p
w(3)=2.019386652222794_p
x(4)=-2.453067262782924e-1_p
w(4)=1.330790153378255_p
x(5)=2.370103172265385_p
w(5)=2.549226560335725e-1_p
x(6)=5.886885920584652_p
w(6)=1.134459880903614e-2_p
x(7)=10.68427458351051_p
w(7)=1.280163165756845e-4_p
x(8)=17.39584071847907_p
w(8)=2.257559064851549e-7_p
else if(N==9)then
x(1)=-5.743348050586114_p
w(1)=6.518500191494477e-1_p
x(2)=-4.689374073460471_p
w(2)=1.414149756102460_p
x(3)=-2.968217293618070_p
w(3)=1.866862240933134_p
x(4)=-8.772900921231990e-1_p
w(4)=1.538894403975903_p
x(5)=1.435499988768905_p
w(5)=4.870096830209097e-1_p
x(6)=4.355744116079565_p
w(6)=4.250078534319759e-2_p
x(7)=8.200449586453784_p
w(7)=1.198085386439383e-3_p
x(8)=13.17875879074851_p
w(8)=1.068962772534912e-5_p
x(9)=19.61986672121969_p
w(9)=2.156076203126320e-8_p
else if(N==10)then
x(1)=-5.778399312267879_p
w(1)=5.636001019215767e-1_p
x(2)=-4.862042116086310_p
w(2)=1.238788595880207_p
x(3)=-3.337909359978892_p
w(3)=1.701877122201665_p
x(4)=-1.427008855700940_p
w(4)=1.625856942933089_p
x(5)=6.745630560174460e-1_p
w(5)=7.526221195472825e-1_p
x(6)=3.173199467349490_p
w(6)=1.134895541531179e-1_p
x(7)=6.377063428145122_p
w(7)=6.103785928936204e-3_p
x(8)=10.39676426282887_p
w(8)=1.362809903402559e-4_p
x(9)=15.34662146959612_p
w(9)=1.177680780535208e-6_p
x(10)=21.1106746699676_p
w(10)=3.862983634357539e-9_p
else if(N==11)then
x(1)=-5.806805385410897_p
w(1)=4.918740090334263e-1_p
x(2)=-5.003672834324529_p
w(2)=1.091828849156629_p
x(3)=-3.649309466202380_p
w(3)=1.542115383413615_p
x(4)=-1.907324719377601_p
w(4)=1.623037950348604_p
x(5)=3.084952459510051e-2_p
w(5)=9.950699788356612e-1_p
x(6)=2.228019804250315_p
w(6)=2.364581042654634e-1_p
x(7)=4.962598784465590_p
w(7)=2.118746233820338e-2_p
x(8)=8.340515354714018_p
w(8)=8.855956855240228e-4_p
x(9)=12.39981038571624_p
w(9)=1.816995380919318e-5_p
x(10)=17.13703150011723_p
w(10)=1.809172399072706e-7_p
x(11)=22.04016401974457_p
w(11)=1.151803796359636e-9_p
else if(N==12)then
x(1)=-5.830116924243952_p
w(1)=4.328807940268801e-1_p
x(2)=-5.120977348500784_p
w(2)=9.681852197231370e-1_p
x(3)=-3.912413183803725_p
w(3)=1.395037691920124_p
x(4)=-2.326466382794859_p
w(4)=1.565815344788042_p
x(5)=-5.284053069850337e-1_p
w(5)=1.174515910949288_p
x(6)=1.451140506373571_p
w(6)=4.060574667379911e-1_p
x(7)=3.828951280369495_p
w(7)=5.606819142659306e-2_p
x(8)=6.734994882075999_p
w(8)=3.771535465354416e-3_p
x(9)=10.18438740186985_p
w(9)=1.405195254001485e-4_p
x(10)=14.16919445818384_p
w(10)=2.971323792372744e-6_p
x(11)=18.5600183548022_p
w(11)=3.872788850828938e-8_p
x(12)=22.61590517267301_p
w(12)=4.854888172310371e-10_p
else if(N==13)then
x(1)=-5.849469111703834_p
w(1)=3.838219502043659e-1_p
x(2)=-5.219058214731265_p
w(2)=8.635752518808441e-1_p
x(3)=-4.135771349570588_p
w(3)=1.262892952473832_p
x(4)=-2.691793708351267_p
w(4)=1.480928318882687_p
x(5)=-1.021918368391375_p
w(5)=1.279669226514100_p
x(6)=7.953421470711534e-1_p
w(6)=5.982373243336653e-1_p
x(7)=2.898935563917364_p
w(7)=1.206448127208481e-1_p
x(8)=5.438774599335397_p
w(8)=1.198046121007651e-2_p
x(9)=8.434683539765075_p
w(9)=6.992993073609877e-4_p
x(10)=11.87160315149207_p
w(10)=2.546946214937533e-5_p
x(11)=15.69193973733092_p
w(11)=6.067067679820452e-7_p
x(12)=19.66278203565557_p
w(12)=1.114746802345447e-8_p
x(13)=22.98261450550259_p
w(13)=2.558142154913468e-10_p
else if(N==14)then
x(1)=-5.865704201313189_p
w(1)=3.426080131794960e-1_p
x(2)=-5.301808714264772_p
w(2)=7.745081991731113e-1_p
x(3)=-4.326459048476531_p
w(3)=1.145529688965998_p
x(4)=-3.010278773422042_p
w(4)=1.385150543867063_p
x(5)=-1.460552018066262_p
w(5)=1.320256877940697_p
x(6)=2.281635190245072e-1_p
w(6)=7.812983629896775e-1_p
x(7)=2.121080961598272_p
w(7)=2.198140183120910e-1_p
x(8)=4.368075387135918_p
w(8)=3.060432611402858e-2_p
x(9)=7.008678988323380_p
w(9)=2.558741909092031e-3_p
x(10)=10.02630522664507_p
w(10)=1.413602075303770e-4_p
x(11)=13.38368101134385_p
w(11)=5.393980071652235e-6_p
x(12)=16.97641312889179_p
w(12)=1.542044391334881e-7_p
x(13)=20.50697445752172_p
w(13)=4.100832649199284e-9_p
x(14)=23.22547186616066_p
w(14)=1.558511682391956e-10_p
else if(N==15)then
x(1)=-5.879454384702496_p
w(1)=3.076630629038353e-1_p
x(2)=-5.372213486959565_p
w(2)=6.981838358145336e-1_p
x(3)=-4.490220946319663_p
w(3)=1.041804518876427_p
x(4)=-3.288350135772272_p
w(4)=1.287953885342346_p
x(5)=-1.851383745634144_p
w(5)=1.314048874972215_p
x(6)=-2.719382591373259e-1_p
w(6)=9.299360812469062e-1_p
x(7)=1.458625067792013_p
w(7)=3.489420714660904e-1_p
x(8)=3.468507329682802_p
w(8)=6.587909519479009e-2_p
x(9)=5.820834143571328_p
w(9)=7.455626064405408e-3_p
x(10)=8.504492751561839_p
w(10)=5.753007139565510e-4_p
x(11)=11.48968953105813_p
w(11)=3.193772273187197e-5_p
x(12)=14.71667513656202_p
w(12)=1.344885464675819e-6_p
x(13)=18.04501649420074_p
w(13)=4.795977930393030e-8_p
x(14)=21.15215775953183_p
w(14)=1.831823019074689e-9_p
x(15)=23.39271732436084_p
w(15)=1.046753707423178e-10_p
else if(N==16)then
x(1)=-5.891200407398221_p
w(1)=2.777841418681176e-1_p
x(2)=-5.432579777268029_p
w(2)=6.323651191098886e-1_p
x(3)=-4.631690420654184_p
w(3)=9.502486308592568e-1_p
x(4)=-3.531742152296712_p
w(4)=1.194274974122678_p
x(5)=-2.199870364357806_p
w(5)=1.278025049643976_p
x(6)=-7.187219132534894e-1_p
w(6)=1.032567088678443_p
x(7)=8.844113863063159e-1_p
w(7)=4.938001626317824e-1_p
x(8)=2.702168185370421_p
w(8)=1.231990370606733e-1_p
x(9)=4.815312364189505_p
w(9)=1.820714499225436e-2_p
x(10)=7.224830698287716_p
w(10)=1.855798164654674e-3_p
x(11)=9.905304555465849_p
w(11)=1.399627475946189e-4_p
x(12)=12.81592832870455_p
w(12)=8.162908290871376e-6_p
x(13)=15.87726886776575_p
w(13)=3.934728298302658e-7_p
x(14)=18.92690019425198_p
w(14)=1.781351111552053e-8_p
x(15)=21.64800707049544_p
w(15)=9.507702957205814e-10_p
x(16)=23.51202987203947_p
w(16)=7.525793358199719e-11_p
else if(N==17)then
x(1)=-5.901312651154031_p
w(1)=2.520416170896120e-1_p
x(2)=-5.484708550725636_p
w(2)=5.752620905003836e-1_p
x(3)=-4.754602937721113_p
w(3)=8.693708506745185e-1_p
x(4)=-3.745445722627971_p
w(4)=1.106440423842088_p
x(5)=-2.510748497055070_p
w(5)=1.225061560954082_p
x(6)=-1.120922750079612_p
w(6)=1.090136674904497_p
x(7)=3.784342785587144e-1_p
w(7)=6.356407678431628e-1_p
x(8)=2.041086981588384_p
w(8)=2.044405555240950e-1_p
x(9)=3.953415399685319_p
w(9)=3.855732679432722e-2_p
x(10)=6.132772441529724_p
w(10)=4.996711583714441e-3_p
x(11)=8.558744415654598_p
w(11)=4.872027816238810e-4_p
x(12)=11.19979877251093_p
w(12)=3.739284986160181e-5_p
x(13)=14.00446973609171_p
w(13)=2.367764779547058e-6_p
x(14)=16.87896523027634_p
w(14)=1.336863015105035e-7_p
x(15)=19.65235782533372_p
w(15)=7.696398130849901e-9_p
x(16)=22.03284047128491_p
w(16)=5.536881703136985e-10_p
x(17)=23.59980059071865_p
w(17)=5.684614687804664e-11_p
else
call GD(-6)
end if
end subroutine GF_m6

! [-5kT;24kT]
subroutine GF_m5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-3.535012787799962_p
w(1)=3.320510993497640_p
x(2)=4.997493418577793e-1_p
w(2)=1.686204354953726_p
else if(N==3)then
x(1)=-4.074468208001936_p
w(1)=2.223446294810727_p
x(2)=-1.037810036490990_p
w(2)=2.518893994982469_p
x(3)=2.943263278262271_p
w(3)=2.643750586581708e-1_p
else if(N==4)then
x(1)=-4.341964509674784_p
w(1)=1.617026926880428_p
x(2)=-1.966137636548298_p
w(2)=2.512457105068376_p
x(3)=1.108256082599999_p
w(3)=8.571222532585300e-1_p
x(4)=5.750130807384980_p
w(4)=2.010906324403262e-2_p
else if(N==5)then
x(1)=-4.496758165113999_p
w(1)=1.250725259342209_p
x(2)=-2.582858189162653_p
w(2)=2.246952818289686_p
x(3)=4.763562047645224e-2_p
w(3)=1.372790221669642_p
x(4)=3.385511194653945_p
w(4)=1.351906238674688e-1_p
x(5)=8.819476276371281_p
w(5)=1.056425282361180e-3_p
else if(N==6)then
x(1)=-4.596308164139878_p
w(1)=1.009919459104778_p
x(2)=-3.013119057320103_p
w(2)=1.959923672918876_p
x(3)=-7.043032527029952e-1_p
w(3)=1.658041475792485_p
x(4)=2.033898389450785_p
w(4)=3.663144840225989e-1_p
x(5)=5.948090653503746_p
w(5)=1.246933173161045e-2_p
x(6)=12.01851221839683_p
w(6)=4.692488101820687e-5_p
else if(N==7)then
x(1)=-4.665826179186928_p
w(1)=8.395420343603016e-1_p
x(2)=-3.329114889654082_p
w(2)=1.706559976855700_p
x(3)=-1.287797478058050_p
w(3)=1.750583520253589_p
x(4)=1.103957600179924_p
w(4)=6.556579733117353e-1_p
x(5)=4.223246571529802_p
w(5)=5.345687085622428e-2_p
x(6)=8.661882803027268_p
w(6)=9.128803433272000e-4_p
x(7)=15.17570107482316_p
w(7)=2.092470489906447e-6_p
else if(N==8)then
x(1)=-4.717814771414625_p
w(1)=7.110145026419730e-1_p
x(2)=-3.573534121646624_p
w(2)=1.490181755703244_p
x(3)=-1.764870442304291_p
w(3)=1.724436267192877_p
x(4)=3.849842387228824e-1_p
w(4)=9.320428042998006e-1_p
x(5)=3.002294436525413_p
w(5)=1.430926016321988e-1_p
x(6)=6.547337716324705_p
w(6)=5.880785715658706e-3_p
x(7)=11.33296852612863_p
w(7)=6.650539760645830e-5_p
x(8)=17.95490610952952_p
w(8)=1.258680087209714e-7_p
else if(N==9)then
x(1)=-4.758497620465588_p
w(1)=6.098157804394810e-1_p
x(2)=-3.769420086026571_p
w(2)=1.305852686212843_p
x(3)=-2.165296889833071_p
w(3)=1.635055642989163_p
x(4)=-2.113237589127644e-1_p
w(4)=1.145379182912094_p
x(5)=2.064040933620298_p
w(5)=2.876579582111579e-1_p
x(6)=5.009523457363894_p
w(6)=2.232453261989004e-2_p
x(7)=8.847168035482651_p
w(7)=6.237407262163885e-4_p
x(8)=13.77250612886274_p
w(8)=5.810746734725920e-6_p
x(9)=20.03013260786182_p
w(9)=1.359378670040212e-8_p
else if(N==10)then
x(1)=-4.791083212064443_p
w(1)=5.283908501050930e-1_p
x(2)=-3.929079083836821_p
w(2)=1.149385269888216_p
x(3)=-2.503679838261133_p
w(3)=1.517872989615896_p
x(4)=-7.219688870291807e-1_p
w(4)=1.275308755446967_p
x(5)=1.309348438598177_p
w(5)=4.716810025882253e-1_p
x(6)=3.822270878016142_p
w(6)=6.082588276185363e-2_p
x(7)=7.025629724860524_p
w(7)=3.176900394896458e-3_p
x(8)=11.00755458852495_p
w(8)=7.301097609853450e-5_p
x(9)=15.8637144045778_p
w(9)=6.839338569847475e-7_p
x(10)=21.38410696434411_p
w(10)=2.740263712366517e-9_p
else if(N==11)then
x(1)=-4.817559769033370_p
w(1)=4.620045330897138e-1_p
x(2)=-4.060510485103132_p
w(2)=1.016872648398629_p
x(3)=-2.790061190179080_p
w(3)=1.393615932681951_p
x(4)=-1.164661156723371_p
w(4)=1.328389383779440_p
x(5)=6.822774111014287e-1_p
w(5)=6.636289888494989e-1_p
x(6)=2.874733325640364_p
w(6)=1.306831329530072e-1_p
x(7)=5.614187604900991_p
w(7)=1.104171934692330e-2_p
x(8)=8.965022751519692_p
w(8)=4.687299300197274e-4_p
x(9)=12.96037515631641_p
w(9)=1.016538226669695e-5_p
x(10)=17.5700726234296_p
w(10)=1.131484927543312e-7_p
x(11)=22.21826855031812_p
w(11)=8.914239257264058e-10_p
else if(N==12)then
x(1)=-4.839337596672039_p
w(1)=4.072554639111604e-1_p
x(2)=-4.169700974471056_p
w(2)=9.044940621990897e-1_p
x(3)=-3.033085055129095_p
w(3)=1.273023643798515_p
x(4)=-1.550233118529359_p
w(4)=1.324459836446624_p
x(5)=1.474738236042666e-1_p
w(5)=8.319425657738219e-1_p
x(6)=2.099268968865983_p
w(6)=2.340706030183331e-1_p
x(7)=4.483139468859277_p
w(7)=2.941367111228398e-2_p
x(8)=7.371031834039494_p
w(8)=1.977027955090876e-3_p
x(9)=10.77246736226039_p
w(9)=7.669699752370054e-5_p
x(10)=14.67135380593076_p
w(10)=1.750808227209808e-6_p
x(11)=18.91275356944442_p
w(11)=2.603235486094972e-8_p
x(12)=22.73431438722092_p
w(12)=3.983425773626027e-10_p
else if(N==13)then
x(1)=-4.857454034194552_p
w(1)=3.616166509666799e-1_p
x(2)=-4.261242029393330_p
w(2)=8.088192488963935e-1_p
x(3)=-3.240197777830796_p
w(3)=1.160932904486395_p
x(4)=-1.886757573153364_p
w(4)=1.284244407869794_p
x(5)=-3.175268558327778e-1_p
w(5)=9.572416259218766e-1_p
x(6)=1.450316407970475_p
w(6)=3.629790318998283e-1_p
x(7)=3.555148325035988_p
w(7)=6.425118782968230e-2_p
x(8)=6.084281934857503_p
w(8)=6.240787400944808e-3_p
x(9)=9.043201324513051_p
w(9)=3.746605246322864e-4_p
x(10)=12.41541663769112_p
w(10)=1.445670854238648e-5_p
x(11)=16.13308532498291_p
w(11)=3.777409848662097e-7_p
x(12)=19.94573425224766_p
w(12)=7.987451389564209e-9_p
x(13)=23.06424949018443_p
w(13)=2.181615752159419e-10_p
else if(N==14)then
x(1)=-4.872680685145396_p
w(1)=3.231943106030327e-1_p
x(2)=-4.338655572229302_p
w(2)=7.269499197123868e-1_p
x(3)=-3.417611434589549_p
w(3)=1.059037713979112_p
x(4)=-2.180947664236461_p
w(4)=1.223865618415191_p
x(5)=-7.269283225991088e-1_p
w(5)=1.034771527178217_p
x(6)=8.960195124869943e-1_p
w(6)=5.014679111608510e-1_p
x(7)=2.779627514777532_p
w(7)=1.200782052477577e-1_p
x(8)=5.021093949607290_p
w(8)=1.591745695110099e-2_p
x(9)=7.633406982937321_p
w(9)=1.351289662713427e-3_p
x(10)=10.59967379151892_p
w(10)=7.809256969716636e-5_p
x(11)=13.87915787199847_p
w(11)=3.198395433496008e-6_p
x(12)=17.35849716381382_p
w(12)=1.013404515664791e-7_p
x(13)=20.73294454720392_p
w(13)=3.098996640335282e-9_p
x(14)=23.28394630242403_p
w(14)=1.364249842699136e-10_p
else if(N==15)then
x(1)=-4.885598250570026_p
w(1)=2.905549712649335e-1_p
x(2)=-4.404654547900159_p
w(2)=6.565046043526781e-1_p
x(3)=-3.570415339668844_p
w(3)=9.674687845273739e-1_p
x(4)=-2.438626140534875_p
w(4)=1.154160362444464_p
x(5)=-1.090015896383899_p
w(5)=1.070020013922244_p
x(6)=4.140016241382834e-1_p
w(6)=6.317634749426840e-1_p
x(7)=2.121222388096712_p
w(7)=1.975856803398942e-1_p
x(8)=4.127360327305809_p
w(8)=3.443148270018574e-2_p
x(9)=6.458721391179303_p
w(9)=3.895628909727458e-3_p
x(10)=9.100699635818644_p
w(10)=3.111911888037959e-4_p
x(11)=12.02339592192026_p
w(11)=1.828491800624509e-5_p
x(12)=15.16289968820478_p
w(12)=8.342649711743735e-7_p
x(13)=18.3730174483169_p
w(13)=3.313720410385570e-8_p
x(14)=21.33322898219716_p
w(14)=1.444885729513965e-9_p
x(15)=23.43608933333811_p
w(15)=9.331155224452810e-11_p
else if(N==16)then
x(1)=-4.896649503180121_p
w(1)=2.626006577571131e-1_p
x(2)=-4.461345354792543_p
w(2)=5.955474258855920e-1_p
x(3)=-3.702748780429518_p
w(3)=8.856348874177541e-1_p
x(4)=-2.664874790810560_p
w(4)=1.081800036722620_p
x(5)=-1.413343227698267_p
w(5)=1.072818835882566_p
x(6)=-1.128284332948694e-2_p
w(6)=7.401829814967451e-1_p
x(7)=1.554080403962607_p
w(7)=2.923785744541240e-1_p
x(8)=3.365763260483775_p
w(8)=6.523053556858716e-2_p
x(9)=5.463899967940739_p
w(9)=9.451202232524268e-3_p
x(10)=7.839503446396179_p
w(10)=9.871003264137004e-4_p
x(11)=10.46821863673042_p
w(11)=7.798651130196079e-5_p
x(12)=13.30790574238394_p
w(12)=4.855370164275092e-6_p
x(13)=16.27574057972769_p
w(13)=2.551124971041033e-7_p
x(14)=19.20728301527603_p
w(14)=1.286958464228909e-8_p
x(15)=21.7942771535132_p
w(15)=7.758037296705669e-10_p
x(16)=23.54518921902269_p
w(16)=6.797555978098230e-11_p
else if(N==17)then
x(1)=-4.906176428247385_p
w(1)=2.384802115876693e-1_p
x(2)=-4.510378550406538_p
w(2)=5.425089180191320e-1_p
x(3)=-3.817973362083089_p
w(3)=8.126559665367885e-1_p
x(4)=-2.864099266043466_p
w(4)=1.010628848873862_p
x(5)=-1.701977316877965_p
w(5)=1.053162404177071_p
x(6)=-3.905412963718194e-1_p
w(6)=8.199273953861310e-1_p
x(7)=1.058855822022014_p
w(7)=3.957850604284453e-1_p
x(8)=2.709221765604206_p
w(8)=1.106716955050462e-1_p
x(9)=4.610659227720409_p
w(9)=1.998332686059264e-2_p
x(10)=6.762710280808965_p
w(10)=2.622839095975973e-3_p
x(11)=9.145128902754166_p
w(11)=2.655922655856117e-4_p
x(12)=11.72678183088156_p
w(12)=2.152903450526263e-5_p
x(13)=14.45457395944955_p
w(13)=1.464017964356261e-6_p
x(14)=17.23280538586062_p
w(14)=9.036692789294653e-8_p
x(15)=19.89190166466163_p
w(15)=5.779780609705700e-9_p
x(16)=22.15224044846281_p
w(16)=4.640383517241191e-10_p
x(17)=23.6258157641073_p
w(17)=5.185097380824554e-11_p
else
call GD(-5)
end if
end subroutine GF_m5

! [-4kT;24kT]
subroutine GF_m4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.719496206327655_p
w(1)=2.798302085323243_p
x(2)=9.542778778200991e-1_p
w(2)=1.219847842556816_p
else if(N==3)then
x(1)=-3.173001819939385_p
w(1)=1.934953858383195_p
x(2)=-4.480249114236745e-1_p
w(2)=1.923940828070322_p
x(3)=3.489288223827451_p
w(3)=1.592552414265415e-1_p
else if(N==4)then
x(1)=-3.403212672936109_p
w(1)=1.435119917131558_p
x(2)=-1.258724550594142_p
w(2)=2.024547116638254_p
x(3)=1.675262543932931_p
w(3)=5.476734216760855e-1_p
x(4)=6.380568964310728_p
w(4)=1.080947243416074e-2_p
else if(N==5)then
x(1)=-3.538743151435289_p
w(1)=1.124783931634875_p
x(2)=-1.795259960370412_p
w(2)=1.884451420652154_p
x(3)=6.588702906596927e-1_p
w(3)=9.346480327685355e-1_p
x(4)=4.022656539727723_p
w(4)=7.372912750677020e-2_p
x(5)=9.498696490312005_p
w(5)=5.374153177237446e-4_p
else if(N==6)then
x(1)=-3.627134308471385_p
w(1)=9.167293402261438e-1_p
x(2)=-2.173169885783702_p
w(2)=1.689289567789638_p
x(3)=-3.899399062314333e-2_p
w(3)=1.198332104238132_p
x(4)=2.674363983982307_p
w(4)=2.074549063395178e-1_p
x(5)=6.634874933668758_p
w(5)=6.320723599995884e-3_p
x(6)=12.7191574157498_p
w(6)=2.328568663105790e-5_p
else if(N==7)then
x(1)=-3.689698181117045_p
w(1)=7.670009013200214e-1_p
x(2)=-2.454547321152952_p
w(2)=1.498615585724145_p
x(3)=-5.712942916924125e-1_p
w(3)=1.333237710470079_p
x(4)=1.751121924863039_p
w(4)=3.914383267207562e-1_p
x(5)=4.907445035639962_p
w(5)=2.740240073638394e-2_p
x(6)=9.359944479675253_p
w(6)=4.539407947199638e-4_p
x(7)=15.84422295148862_p
w(7)=1.062113953319922e-6_p
else if(N==8)then
x(1)=-3.737031681413268_p
w(1)=6.524567009331432e-1_p
x(2)=-2.675026214030805_p
w(2)=1.325793646228922_p
x(3)=-1.004421574724620_p
w(3)=1.371304345676704_p
x(4)=1.046430650511537_p
w(4)=5.904096793482094e-1_p
x(5)=3.679279292652049_p
w(5)=7.520677527185300e-2_p
x(6)=7.238633434621561_p
w(6)=2.944877213340469e-3_p
x(7)=11.99994306744738_p
w(7)=3.383300523797986e-5_p
x(8)=18.50674341567331_p
w(8)=7.020264829700897e-8_p
else if(N==9)then
x(1)=-3.774334112678968_p
w(1)=5.614686123963973e-1_p
x(2)=-2.853235551303675_p
w(2)=1.173014677162036_p
x(3)=-1.367850275452611_p
w(3)=1.345392516993200_p
x(4)=4.731652397637577e-1_p
w(4)=7.699494665335488e-1_p
x(5)=2.736415321712008_p
w(5)=1.567376092517717e-1_p
x(6)=5.696365023832923_p
w(6)=1.126678278281447e-2_p
x(7)=9.514822704965157_p
w(7)=3.171295598068506e-4_p
x(8)=14.37366924632056_p
w(8)=3.124538989401393e-6_p
x(9)=20.42207043482077_p
w(9)=8.661494307209972e-9_p
else if(N==10)then
x(1)=-3.804334379480958_p
w(1)=4.878611276249870e-1_p
x(2)=-2.999268677136823_p
w(2)=1.040149707606254_p
x(3)=-1.675465825243355_p
w(3)=1.282322514225928_p
x(4)=-8.533515109173145e-3_p
w(4)=9.062490886252605e-1_p
x(5)=1.983310513246343_p
w(5)=2.688876978155599e-1_p
x(6)=4.507261741447610_p
w(6)=3.103141847133210e-2_p
x(7)=7.697777598721018_p
w(7)=1.609476535317406e-3_p
x(8)=11.63144036322316_p
w(8)=3.849918550413129e-5_p
x(9)=16.38030485891983_p
w(9)=3.958256062470177e-7_p
x(10)=21.64091611653201_p
w(10)=1.964309318792804e-9_p
else if(N==11)then
x(1)=-3.828787180610569_p
w(1)=4.275965889811995e-1_p
x(2)=-3.119991718314674_p
w(2)=9.256637613139175e-1_p
x(3)=-1.936605993052942_p
w(3)=1.201338448526392_p
x(4)=-4.204766534575110e-1_p
w(4)=9.915087224043013e-1_p
x(5)=1.364920828304397_p
w(5)=3.983586522165368e-1_p
x(6)=3.559439204237659_p
w(6)=6.785843039036717e-2_p
x(7)=6.291990223405802_p
w(7)=5.576237086304101e-3_p
x(8)=9.605967316608623_p
w(8)=2.433830035679781e-4_p
x(9)=13.52765234617174_p
w(9)=5.632412787866435e-6_p
x(10)=17.99782478042676_p
w(10)=7.084983696103736e-8_p
x(11)=22.38486911847848_p
w(11)=6.948468367811529e-10_p
else if(N==12)then
x(1)=-3.848956918132083_p
w(1)=3.777155998686378e-1_p
x(2)=-3.220655884337777_p
w(2)=8.272944238142429e-1_p
x(3)=-2.159036166054393_p
w(3)=1.114515593504832_p
x(4)=-7.765125505827309e-1_p
w(4)=1.030509264617818_p
x(5)=8.452154767742320e-1_p
w(5)=5.273674382876555e-1_p
x(6)=2.785413994871849_p
w(6)=1.248367315559373e-1_p
x(7)=5.166252470492978_p
w(7)=1.485483436959829e-2_p
x(8)=8.026041070981474_p
w(8)=1.013690457483655e-3_p
x(9)=11.37125854366205_p
w(9)=4.130695839834800e-5_p
x(10)=15.17535155862053_p
w(10)=1.026559373698877e-6_p
x(11)=19.25820274122833_p
w(11)=1.755789524661798e-8_p
x(12)=22.84536027865652_p
w(12)=3.281858025987237e-10_p
else if(N==13)then
x(1)=-3.865778015717456_p
w(1)=3.360022770613770e-1_p
x(2)=-3.305322253333169_p
w(2)=7.426874116200544e-1_p
x(3)=-2.349313786393525_p
w(3)=1.028672306383037_p
x(4)=-1.086270868969457_p
w(4)=1.033784051980228_p
x(5)=3.999712774979164e-1_p
w(5)=6.403466408637573e-1_p
x(6)=2.140552115497918_p
w(6)=2.006550998409378e-1_p
x(7)=4.242821121091009_p
w(7)=3.262740154416872e-2_p
x(8)=6.751084726778832_p
w(8)=3.168836603979285e-3_p
x(9)=9.665172847867284_p
w(9)=1.975274782940992e-4_p
x(10)=12.96537089662542_p
w(10)=8.133775815378889e-6_p
x(11)=16.57275656760757_p
w(11)=2.347966418234834e-7_p
x(12)=20.22128276948295_p
w(12)=5.745336073982538e-9_p
x(13)=23.14118935018636_p
w(13)=1.864316126785678e-10_p
else if(N==14)then
x(1)=-3.879947873344363_p
w(1)=3.007865155409342e-1_p
x(2)=-3.377125312701864_p
w(2)=6.696970505143552e-1_p
x(3)=-2.512882064725480_p
w(3)=9.473026511172382e-1_p
x(4)=-1.356977530557977_p
w(4)=1.012459981507591_p
x(5)=1.282420378811742e-2_p
w(5)=7.279064858097448e-1_p
x(6)=1.593824714041731_p
w(6)=2.894635745316875e-1_p
x(7)=3.471389047582783_p
w(7)=6.175715987490383e-2_p
x(8)=5.697748165862524_p
w(8)=8.031425992821953e-3_p
x(9)=8.273797387080815_p
w(9)=7.004835702897907e-4_p
x(10)=11.1821264841615_p
w(10)=4.264394726426280e-5_p
x(11)=14.37729097000296_p
w(11)=1.886381196795080e-6_p
x(12)=17.73717603629391_p
w(12)=6.662255307291509e-8_p
x(13)=20.95231522161975_p
w(13)=2.349969552140751e-9_p
x(14)=23.33935548119593_p
w(14)=1.195079183739261e-10_p
else if(N==15)then
x(1)=-3.891993172940948_p
w(1)=2.707974479634910e-1_p
x(2)=-3.438493671434519_p
w(2)=6.064746128999200e-1_p
x(3)=-2.654211191763761_p
w(3)=8.719570078199267e-1_p
x(4)=-1.594391953567926_p
w(4)=9.758000004804861e-1_p
x(5)=-3.274349741163689e-1_p
w(5)=7.872836614192514e-1_p
x(6)=1.123055749125047_p
w(6)=3.825570854750466e-1_p
x(7)=2.817295081065136_p
w(7)=1.037716543860171e-1_p
x(8)=4.812190529789425_p
w(8)=1.733905394305077e-2_p
x(9)=7.114286411284422_p
w(9)=1.992467206047175e-3_p
x(10)=9.708238902752514_p
w(10)=1.660122126575315e-4_p
x(11)=12.56273319765048_p
w(11)=1.038388128486092e-5_p
x(12)=15.60929165488671_p
w(12)=5.160396940260003e-7_p
x(13)=18.69672693305568_p
w(13)=2.292726503032514e-8_p
x(14)=21.50878518304447_p
w(14)=1.142745706471683e-9_p
x(15)=23.47739585655547_p
w(15)=8.317432866483791e-11_p
else if(N==16)then
x(1)=-3.902316850569320_p
w(1)=2.450569415522124e-1_p
x(2)=-3.491322977499588_p
w(2)=5.514671450889369e-1_p
x(3)=-2.776955912095562_p
w(3)=8.031058202059507e-1_p
x(4)=-1.803277869695481_p
w(4)=9.306133863196605e-1_p
x(5)=-6.287267555859616e-1_p
w(5)=8.205518349684823e-1_p
x(6)=7.121967256386803e-1_p
w(6)=4.709426477564185e-1_p
x(7)=2.255525725444360_p
w(7)=1.581001034288778e-1_p
x(8)=4.057437911263848_p
w(8)=3.296410205843302e-2_p
x(9)=6.132159247366731_p
w(9)=4.785173282692613e-3_p
x(10)=8.467401676686547_p
w(10)=5.167173480527678e-4_p
x(11)=11.03903947500503_p
w(11)=4.300828521892836e-5_p
x(12)=13.80285665779438_p
w(12)=2.872362377907777e-6_p
x(13)=16.67273749954948_p
w(13)=1.652131232330085e-7_p
x(14)=19.48317364334137_p
w(14)=9.314018473581177e-9_p
x(15)=21.93607891084526_p
w(15)=6.342416419215859e-10_p
x(16)=23.5769114771063_p
w(16)=6.136084112410504e-11_p
else if(N==17)then
x(1)=-3.911231090388527_p
w(1)=2.228034745478369e-1_p
x(2)=-3.537105635459363_p
w(2)=5.033849754989149e-1_p
x(3)=-2.884102008693714_p
w(3)=7.406485391642467e-1_p
x(4)=-1.987646791730899_p
w(4)=8.815345945699041e-1_p
x(5)=-8.969079159446239e-1_p
w(5)=8.322744754409001e-1_p
x(6)=3.495744389443409e-1_p
w(6)=5.475381805213719e-1_p
x(7)=1.767439899035458_p
w(7)=2.219175479726852e-1_p
x(8)=3.406884800783596_p
w(8)=5.648828900656398e-2_p
x(9)=5.289596667220964_p
w(9)=1.005169676468832e-2_p
x(10)=7.407609882890707_p
w(10)=1.351854561933588e-3_p
x(11)=9.741277702392129_p
w(11)=1.430294867346006e-4_p
x(12)=12.25895907629191_p
w(12)=1.230236877424981e-5_p
x(13)=14.90568461066303_p
w(13)=9.021125440129547e-7_p
x(14)=17.58419201863002_p
w(14)=6.107840219394819e-8_p
x(15)=20.12714500508402_p
w(15)=4.347931384720201e-9_p
x(16)=22.26806542826361_p
w(16)=3.893757916947293e-10_p
x(17)=23.65080094892575_p
w(17)=4.725048197053334e-11_p
else
call GD(-4)
end if
end subroutine GF_m4

! [-3kT;24kT]
subroutine GF_m3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.899025473623358_p
w(1)=2.236589522567186_p
x(2)=1.474550455090665_p
w(2)=8.119978289688043e-1_p
else if(N==3)then
x(1)=-2.271684869999667_p
w(1)=1.607696109871092_p
x(2)=1.763397598825177e-1_p
w(2)=1.352268299299979_p
x(3)=4.104033812180734_p
w(3)=8.862294236491976e-2_p
else if(N==4)then
x(1)=-2.465660040021644_p
w(1)=1.221900751551971_p
x(2)=-5.388968313004834e-1_p
w(2)=1.502932499176822_p
x(3)=2.306115948466025_p
w(3)=3.182724078530925e-1_p
x(4)=7.066363056269999_p
w(4)=5.481692954105489e-3_p
else if(N==5)then
x(1)=-2.582094221918867_p
w(1)=9.735933850111570e-1_p
x(2)=-1.005655589707483_p
w(2)=1.463727184050740_p
x(3)=1.318511785021360_p
w(3)=5.734630729565070e-1_p
x(4)=4.717859759970331_p
w(4)=3.754287344547242e-2_p
x(5)=10.22380584158515_p
w(5)=2.608360721144152e-4_p
else if(N==6)then
x(1)=-2.659277735047112_p
w(1)=8.027485004655656e-1_p
x(2)=-1.335513270615763_p
w(2)=1.357621959001671_p
x(3)=6.570695110043062e-1_p
w(3)=7.770452746246683e-1_p
x(4)=3.372831006653430_p
w(4)=1.081065726903062e-1_p
x(5)=7.366565730697106_p
w(5)=3.053902561072079e-3_p
x(6)=13.45468840397782_p
w(6)=1.114219270711297e-5_p
else if(N==7)then
x(1)=-2.714768252151582_p
w(1)=6.770735151256110e-1_p
x(2)=-1.583840482301614_p
w(2)=1.234985387387062_p
x(3)=1.615664824140025e-1_p
w(3)=9.110247459410111e-1_p
x(4)=2.451287327706814_p
w(4)=2.119503459772986e-1_p
x(5)=5.636179350977098_p
w(5)=1.333465423549785e-2_p
x(6)=10.08973028280293_p
w(6)=2.181732028524408e-4_p
x(7)=16.52597391305964_p
w(7)=5.296666578194268e-7_p
else if(N==8)then
x(1)=-2.757279970583922_p
w(1)=5.792799440975653e-1_p
x(2)=-1.780624428777849_p
w(2)=1.113242802165491_p
x(3)=-2.371749387062888e-1_p
w(3)=9.822811657092415e-1_p
x(4)=1.752129281694033_p
w(4)=3.351591500895975e-1_p
x(5)=4.401789323219605_p
w(5)=3.718311552684075e-2_p
x(6)=7.961318881891163_p
w(6)=1.424283410746919e-3_p
x(7)=12.68497001393236_p
w(7)=1.685126920351941e-5_p
x(8)=19.0475655327766_p
w(8)=3.926730411511981e-8_p
else if(N==9)then
x(1)=-2.791032195778115_p
w(1)=5.007553932318108e-1_p
x(2)=-1.940862618161165_p
w(2)=9.993267925044055e-1_p
x(3)=-5.692036683892259e-1_p
w(3)=1.003710404075743_p
x(4)=1.191342209332942_p
w(4)=4.599059539816851e-1_p
x(5)=3.455109872989530_p
w(5)=7.925892772735704e-2_p
x(6)=6.416353289761851_p
w(6)=5.470828846563294e-3_p
x(7)=10.20378187872708_p
w(7)=1.573832449676461e-4_p
x(8)=14.9815229838163_p
w(8)=1.662342031400631e-6_p
x(9)=20.79431588419591_p
w(9)=5.581426463963156e-9_p
else if(N==10)then
x(1)=-2.818304805883030_p
w(1)=4.367664107168043e-1_p
x(2)=-2.072845567006703_p
w(2)=8.963676107472955e-1_p
x(3)=-8.490809430378993e-1_p
w(3)=9.897062642754956e-1_p
x(4)=7.280894053220309e-1_p
w(4)=5.697426284958820e-1_p
x(5)=2.702207529450036_p
w(5)=1.400601444902271e-1_p
x(6)=5.227799132106804_p
w(6)=1.513050260792276e-2_p
x(7)=8.393794523409273_p
w(7)=7.935853788425045e-4_p
x(8)=12.26844652658655_p
w(8)=1.997503017589474e-5_p
x(9)=16.8955657751009_p
w(9)=2.283711442510297e-7_p
x(10)=21.88136611411575_p
w(10)=1.422200825602313e-9_p
else if(N==11)then
x(1)=-2.840620205931634_p
w(1)=3.840669443179497e-1_p
x(2)=-2.182440747668298_p
w(2)=8.051168070848016e-1_p
x(3)=-1.086463224452796_p
w(3)=9.533575551002277e-1_p
x(4)=3.379541779306869e-1_p
w(4)=6.546169953494125e-1_p
x(5)=2.088269770878918_p
w(5)=2.152250668723789e-1_p
x(6)=4.281929602418560_p
w(6)=3.334532005250969e-2_p
x(7)=6.995912410540415_p
w(7)=2.731593220982342e-3_p
x(8)=10.2635442621326_p
w(8)=1.239341322343969e-4_p
x(9)=14.10141067957909_p
w(9)=3.090435424032051e-6_p
x(10)=18.41968446262882_p
w(10)=4.442499457491065e-8_p
x(11)=22.54054236881445_p
w(11)=5.450752606867815e-10_p
else if(N==12)then
x(1)=-2.859090630740587_p
w(1)=3.402250038036252e-1_p
x(2)=-2.274198358063579_p
w(2)=7.250074296628557e-1_p
x(3)=-1.288894927537558_p
w(3)=9.046623219447077e-1_p
x(4)=4.702934835353584e-3_p
w(4)=7.116129856424189e-1_p
x(5)=1.577167518103239_p
w(5)=2.971130100614672e-1_p
x(6)=3.510680083100866_p
w(6)=6.219231668298664e-2_p
x(7)=5.877709594884239_p
w(7)=7.243350579085604e-3_p
x(8)=8.700129456998750_p
w(8)=5.083761696179941e-4_p
x(9)=11.98079561170946_p
w(9)=2.194590914486096e-5_p
x(10)=15.68087643938852_p
w(10)=5.989273544834374e-7_p
x(11)=19.59609212383829_p
w(11)=1.188141766549204e-8_p
x(12)=22.94950392093444_p
w(12)=2.713087044117652e-10_p
else if(N==13)then
x(1)=-2.874542302346007_p
w(1)=3.033993403998547e-1_p
x(2)=-2.351656756997446_p
w(2)=6.549341894414553e-1_p
x(3)=-1.462448708716029_p
w(3)=8.504277173869095e-1_p
x(4)=-2.829454120530711e-1_p
w(4)=7.428734640191017e-1_p
x(5)=1.144128469223112_p
w(5)=3.773295004065713e-1_p
x(6)=2.869653221100832_p
w(6)=1.020567442189322e-1_p
x(7)=4.961045457038050_p
w(7)=1.588974828492756e-2_p
x(8)=7.439022376075909_p
w(8)=1.569507859699964e-3_p
x(9)=10.30070004192983_p
w(9)=1.024542289327993e-4_p
x(10)=13.5213921432164_p
w(10)=4.535287279931153e-6_p
x(11)=17.01069520169004_p
w(11)=1.456953460408559e-7_p
x(12)=20.48940654323808_p
w(12)=4.147429294715020e-9_p
x(13)=23.21374389583645_p
w(13)=1.595504314494165e-10_p
else if(N==14)then
x(1)=-2.887594605766254_p
w(1)=2.721897522705137e-1_p
x(2)=-2.417561931114172_p
w(2)=5.936607367227681e-1_p
x(3)=-1.612035086801807_p
w(3)=7.949437974388764e-1_p
x(4)=-5.331568087113264e-1_p
w(4)=7.530458922682277e-1_p
x(5)=7.718334173137302e-1_p
w(5)=4.489041501582133e-1_p
x(6)=2.328301551135533_p
w(6)=1.513452867448812e-1_p
x(7)=4.195650352182811_p
w(7)=3.017771437910673e-2_p
x(8)=6.397488342407645_p
w(8)=3.939424059912745e-3_p
x(9)=8.929875829918778_p
w(9)=3.564328351678013e-4_p
x(10)=11.77370760887859_p
w(10)=2.301250827468156e-5_p
x(11)=14.87797020557503_p
w(11)=1.106450233414855e-6_p
x(12)=18.11230013860533_p
w(12)=4.380766126670749e-8_p
x(13)=21.1652000180833_p
w(13)=1.787438009245251e-9_p
x(14)=23.39190070781833_p
w(14)=1.047156827829225e-10_p
else if(N==15)then
x(1)=-2.898717386650486_p
w(1)=2.455221889126460e-1_p
x(2)=-2.474053724001203_p
w(2)=5.400002665271947e-1_p
x(3)=-1.741637600257636_p
w(3)=7.407443767748133e-1_p
x(4)=-7.521014476096142e-1_p
w(4)=7.473664055369015e-1_p
x(5)=4.479619033938637e-1_p
w(5)=5.074304740192596e-1_p
x(6)=1.864811257854142_p
w(6)=2.068200953427001e-1_p
x(7)=3.547156712410299_p
w(7)=5.116347234927821e-2_p
x(8)=5.522046913981634_p
w(8)=8.448505384466520e-3_p
x(9)=7.787356775435033_p
w(9)=9.980556984697181e-4_p
x(10)=10.32717204634047_p
w(10)=8.732790094290336e-5_p
x(11)=13.10770168119049_p
w(11)=5.847992254370205e-6_p
x(12)=16.05575797831379_p
w(12)=3.182357405989866e-7_p
x(13)=19.01610232793298_p
w(13)=1.588137872667649e-8_p
x(14)=21.67898886785537_p
w(14)=9.058423543200775e-10_p
x(15)=23.5167691633256_p
w(15)=7.410216623694247e-11_p
else if(N==16)then
x(1)=-2.908271607411427_p
w(1)=2.225641255100088e-1_p
x(2)=-2.522811606944213_p
w(2)=4.928852781148499e-1_p
x(3)=-1.854498401146156_p
w(3)=6.892173498375171e-1_p
x(4)=-9.446196817121369e-1_p
w(4)=7.305905452171967e-1_p
x(5)=1.635723453617556e-1_p
w(5)=5.511539885088221e-1_p
x(6)=1.463205611306783_p
w(6)=2.643743398366687e-1_p
x(7)=2.990980668912696_p
w(7)=7.913024081980655e-2_p
x(8)=4.776017271473203_p
w(8)=1.601346489760248e-2_p
x(9)=6.819617853455636_p
w(9)=2.366543271552289e-3_p
x(10)=9.108515878964633_p
w(10)=2.662017519167660e-4_p
x(11)=11.61781803174023_p
w(11)=2.346992426837319e-5_p
x(12)=14.30076558823271_p
w(12)=1.689672744038517e-6_p
x(13)=17.06821007923856_p
w(13)=1.068478098598548e-7_p
x(14)=19.75460908369062_p
w(14)=6.750603284851543e-9_p
x(15)=22.07357817115384_p
w(15)=5.192868751634278e-10_p
x(16)=23.6072858548566_p
w(16)=5.533686998290406e-11_p
else if(N==17)then
x(1)=-2.916538006247344_p
w(1)=2.026633621711466e-1_p
x(2)=-2.565164499522611_p
w(2)=4.513860132895134e-1_p
x(3)=-1.953265220626054_p
w(3)=6.410346690463736e-1_p
x(4)=-1.114617053278622_p
w(4)=7.065736856681537e-1_p
x(5)=-8.798337072121599e-2_p
w(5)=5.803986664520721e-1_p
x(6)=1.111581134853028_p
w(6)=3.199251852200314e-1_p
x(7)=2.508930383742153_p
w(7)=1.134407557259139e-1_p
x(8)=4.133097299676477_p
w(8)=2.747501429964604e-2_p
x(9)=5.989398128873221_p
w(9)=4.921907836226000e-3_p
x(10)=8.067307304504626_p
w(10)=6.844373046025232e-4_p
x(11)=10.34723343222134_p
w(11)=7.608019643700455e-5_p
x(12)=12.79636778007337_p
w(12)=6.975569640821650e-6_p
x(13)=15.35779335513004_p
w(13)=5.538424298080940e-7_p
x(14)=17.93312428945267_p
w(14)=4.126842361419745e-8_p
x(15)=20.35817356197638_p
w(15)=3.275379323117679e-9_p
x(16)=22.38046531759621_p
w(16)=3.269965239047626e-10_p
x(17)=23.67481813973535_p
w(17)=4.300426981724269e-11_p
else
call GD(-3)
end if
end subroutine GF_m3

! [-2kT;24kT]
subroutine GF_m2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-1.066219054989221_p
w(1)=1.641101461742078_p
x(2)=2.078600295343623_p
w(2)=4.858265492631428e-1_p
else if(N==3)then
x(1)=-1.367357278712136_p
w(1)=1.231469899258470_p
x(2)=8.549409961963608e-1_p
w(2)=8.501904891003008e-1_p
x(3)=4.795086929067655_p
w(3)=4.526762264645037e-2_p
else if(N==4)then
x(1)=-1.527776229423794_p
w(1)=9.633513084101594e-1_p
x(2)=2.102530683367665e-1_p
w(2)=9.940973553438549e-1_p
x(3)=3.011031275968798_p
w(3)=1.668697770095445e-1_p
x(4)=7.813030504306217_p
w(4)=2.609570241662396e-3_p
else if(N==5)then
x(1)=-1.625996760452269_p
w(1)=7.830819755675619e-1_p
x(2)=-2.016971305040607e-1_p
w(2)=1.013048621751675_p
x(3)=2.041702866207848_p
w(3)=3.128455221197836e-1_p
x(4)=5.474715155541618_p
w(4)=1.783166589978139e-2_p
x(5)=10.99951375559523_p
w(5)=1.202256664196334e-4_p
else if(N==6)then
x(1)=-1.692275764175802_p
w(1)=6.549134387813634e-1_p
x(2)=-4.916642693687565e-1_p
w(2)=9.753195031863898e-1_p
x(3)=1.402157372262731_p
w(3)=4.433126475997476e-1_p
x(4)=4.132675211218979_p
w(4)=5.197409002660392e-2_p
x(5)=8.145899273204680_p
w(5)=1.403201588020723e-3_p
x(6)=14.22676703653237_p
w(6)=5.129823095585505e-6_p
else if(N==7)then
x(1)=-1.740751898433199_p
w(1)=5.580002357409322e-1_p
x(2)=-7.112138819887754e-1_p
w(2)=9.141071122768590e-1_p
x(3)=9.293061233600304e-1_p
w(3)=5.441165417516931e-1_p
x(4)=3.210145027124739_p
w(4)=1.044389161623229e-1_p
x(5)=6.410640761233351_p
w(5)=6.163745738597782e-3_p
x(6)=10.85243409998802_p
w(6)=1.011993547468340e-4_p
x(7)=17.21763543095917_p
w(7)=2.599800693890083e-7_p
else if(N==8)then
x(1)=-1.778372658408085_p
w(1)=4.810195214814615e-1_p
x(2)=-8.863666606425992e-1_p
w(2)=8.440403909995825e-1_p
x(3)=5.535199749619064e-1_p
w(3)=6.132178077156446e-1_p
x(4)=2.511657805725654_p
w(4)=1.706156024836566e-1_p
x(5)=5.170352973649020_p
w(5)=1.736180238504225e-2_p
x(6)=8.716512126622703_p
w(6)=6.646509119112962e-4_p
x(7)=13.38803885172227_p
w(7)=8.212951046446486e-6_p
x(8)=19.57363201409444_p
w(8)=2.207687597467439e-8_p
else if(N==9)then
x(1)=-1.808469016099286_p
w(1)=4.183670283617915e-1_p
x(2)=-1.029580914688712_p
w(2)=7.727068488796719e-1_p
x(3)=2.444281544552000e-1_p
w(3)=6.527940790584480e-1_p
x(4)=1.956455759746634_p
w(4)=2.429553061636778e-1_p
x(5)=4.220981961702947_p
w(5)=3.747114854084418e-2_p
x(6)=7.170175721719955_p
w(6)=2.556561186173817e-3_p
x(7)=10.91480301333824_p
w(7)=7.616015604423079e-5_p
x(8)=15.59547985832307_p
w(8)=8.750201184226544e-7_p
x(9)=21.14594364422735_p
w(9)=3.638451333084125e-9_p
else if(N==10)then
x(1)=-1.832915121723617_p
w(1)=3.668040497063192e-1_p
x(2)=-1.147932319041224_p
w(2)=7.044204816354336e-1_p
x(3)=-1.368049970151138e-2_p
w(3)=6.677888471895448e-1_p
x(4)=1.503417727654894_p
w(4)=3.131489568554766e-1_p
x(5)=3.468538458748381_p
w(5)=6.730593102641437e-2_p
x(6)=5.983928359844822_p
w(6)=7.068875955277614e-3_p
x(7)=9.114435902065228_p
w(7)=3.805455175497826e-4_p
x(8)=12.91885971502401_p
w(8)=1.019071885206840e-5_p
x(9)=17.40880261660409_p
w(9)=1.313611559826236e-7_p
x(10)=22.10594170610002_p
w(10)=1.039197225646920e-9_p
else if(N==11)then
x(1)=-1.853008252709495_p
w(1)=3.239860921084119e-1_p
x(2)=-1.246549042309741_p
w(2)=6.412716635991376e-1_p
x(3)=-2.313409183184608e-1_p
w(3)=6.643477928293768e-1_p
x(4)=1.126682699957443_p
w(4)=3.747004275816399e-1_p
x(5)=2.857623661433063_p
w(5)=1.056637936283972e-1_p
x(6)=5.041800751820505_p
w(6)=1.559664790731453e-2_p
x(7)=7.726393767071055_p
w(7)=1.298043416366280e-3_p
x(8)=10.93828958827464_p
w(8)=6.184308619209542e-5_p
x(9)=14.68162092117039_p
w(9)=1.678526097498930e-6_p
x(10)=18.83520365077069_p
w(10)=2.789238104670875e-8_p
x(11)=22.68593093437769_p
w(11)=4.299063016249208e-10_p
else if(N==12)then
x(1)=-1.869707192987671_p
w(1)=2.881102749148448e-1_p
x(2)=-1.329406594509938_p
w(2)=5.839821762109407e-1_p
x(3)=-4.164096794630235e-1_p
w(3)=6.482344674942995e-1_p
x(4)=8.085785463093086e-1_p
w(4)=4.239325542654701e-1_p
x(5)=2.351866138162323_p
w(5)=1.497729278742159e-1_p
x(6)=4.274821051394524_p
w(6)=2.921917255998637e-2_p
x(7)=6.617469342912206_p
w(7)=3.415352265536894e-3_p
x(8)=9.393808163343833_p
w(8)=2.492346446897392e-4_p
x(9)=12.60137917256776_p
w(9)=1.149488174303331e-5_p
x(10)=16.1877947330799_p
w(10)=3.476042810696373e-7_p
x(11)=19.92629649189792_p
w(11)=8.064343377357670e-9_p
x(12)=23.04722351451333_p
w(12)=2.248696920327066e-10_p
else if(N==13)then
x(1)=-1.883728101312266_p
w(1)=2.577894309871572e-1_p
x(2)=-1.399590009704285_p
w(2)=5.325465260858433e-1_p
x(3)=-5.749132912466256e-1_p
w(3)=6.241065281151115e-1_p
x(4)=5.366582661070896e-1_p
w(4)=4.597334631749358e-1_p
x(5)=1.926298397016967_p
w(5)=1.961139668713272e-1_p
x(6)=3.638426446066057_p
w(6)=4.837482247666584e-2_p
x(7)=5.709271912719651_p
w(7)=7.450170401105191e-3_p
x(8)=8.148401867367143_p
w(8)=7.582561329966958e-4_p
x(9)=10.95019919791379_p
w(9)=5.224844900294900e-5_p
x(10)=14.08362745640585_p
w(10)=2.504946139195250e-6_p
x(11)=17.44680494558866_p
w(11)=9.022500888769628e-8_p
x(12)=20.75020290747023_p
w(12)=3.003274445501267e-9_p
x(13)=23.28222921533765_p
w(13)=1.366529928000755e-10_p
else if(N==14)then
x(1)=-1.895610698660708_p
w(1)=2.319543018299146e-1_p
x(2)=-1.459495725531071_p
w(2)=4.866105263542631e-1_p
x(3)=-7.115523262946879e-1_p
w(3)=5.954159364552806e-1_p
x(4)=3.019157520545586e-1_p
w(4)=4.827945882537468e-1_p
x(5)=1.563272457220926_p
w(5)=2.412422959655010e-1_p
x(6)=3.102202063920569_p
w(6)=7.272926083372662e-2_p
x(7)=4.951530763325734_p
w(7)=1.411002983687877e-2_p
x(8)=7.120282994953127_p
w(8)=1.880185482264100e-3_p
x(9)=9.602028005573414_p
w(9)=1.779451335692256e-4_p
x(10)=12.37471946080751_p
w(10)=1.226545643288712e-5_p
x(11)=15.38127643133368_p
w(11)=6.451474575905049e-7_p
x(12)=18.48386391855821_p
w(12)=2.880146963174925e-8_p
x(13)=21.37179883061442_p
w(13)=1.362990125680076e-9_p
x(14)=23.4417878976618_p
w(14)=9.172615428779143e-11_p
else if(N==15)then
x(1)=-1.905766549124466_p
w(1)=2.097749176788477e-1_p
x(2)=-1.510996374961173_p
w(2)=4.456763306202686e-1_p
x(3)=-8.300462336908916e-1_p
w(3)=5.645774270884683e-1_p
x(4)=9.764462498863440e-2_p
w(4)=4.948097427442431e-1_p
x(5)=1.250010623483922_p
w(5)=2.823727110064050e-1_p
x(6)=2.644530902288878_p
w(6)=1.012468073672489e-1_p
x(7)=4.310012722777003_p
w(7)=2.393863382857207e-2_p
x(8)=6.256480109692896_p
w(8)=3.993112087527569e-3_p
x(9)=8.478171810179971_p
w(9)=4.895846430962643e-4_p
x(10)=10.95785126237719_p
w(10)=4.527206877462429e-5_p
x(11)=13.658521367578_p
w(11)=3.264495942391622e-6_p
x(12)=16.50237323901197_p
w(12)=1.955816898323584e-7_p
x(13)=19.33122407941691_p
w(13)=1.100888995443330e-8_p
x(14)=21.84406429085975_p
w(14)=7.192916967707336e-10_p
x(15)=23.5543459936022_p
w(15)=6.595516936290198e-11_p
else if(N==16)then
x(1)=-1.914513394299938_p
w(1)=1.906012723281387e-1_p
x(2)=-1.555566894495538_p
w(2)=4.092094908471032e-1_p
x(3)=-9.333728789302408e-1_p
w(3)=5.332056033917338e-1_p
x(4)=-8.128842389294298e-2_p
w(4)=4.978508512975082e-1_p
x(5)=9.770637365123693e-1_p
w(5)=3.176491807851421e-1_p
x(6)=2.249574838616453_p
w(6)=1.324096535892286e-1_p
x(7)=3.760345210678501_p
w(7)=3.719514478210584e-2_p
x(8)=5.520646608073286_p
w(8)=7.514278412875512e-3_p
x(9)=7.526270175360272_p
w(9)=1.143892331914048e-3_p
x(10)=9.763161695633809_p
w(10)=1.349141399599257e-4_p
x(11)=12.20485032576618_p
w(11)=1.266684927148597e-5_p
x(12)=14.80180806318089_p
w(12)=9.878980583992094e-7_p
x(13)=17.46225558923699_p
w(13)=6.897915051108832e-8_p
x(14)=20.02172826869877_p
w(14)=4.897613753073978e-9_p
x(15)=22.20698573003573_p
w(15)=4.255818124033538e-10_p
x(16)=23.63640588670489_p
w(16)=4.983515875080081e-11_p
else if(N==17)then
x(1)=-1.922099470261616_p
w(1)=1.739195475788840e-1_p
x(2)=-1.594378751561440_p
w(2)=3.766923297666024e-1_p
x(3)=-1.023939069845196_p
w(3)=5.023349008923916e-1_p
x(4)=-2.389089098682656e-1_p
w(4)=4.939692201072436e-1_p
x(5)=7.373048934658878e-1_p
w(5)=3.461470476597920e-1_p
x(6)=1.905459201422290_p
w(6)=1.645006171880767e-1_p
x(7)=3.284577420672042_p
w(7)=5.379385384810865e-2_p
x(8)=4.886745579271490_p
w(8)=1.283590088853679e-2_p
x(9)=6.709736127995174_p
w(9)=2.349999385655260e-3_p
x(10)=8.742005141019421_p
w(10)=3.403495033335859e-4_p
x(11)=10.96330810549494_p
w(11)=3.995224205237136e-5_p
x(12)=13.33925722164068_p
w(12)=3.922664241030290e-6_p
x(13)=15.81105949251489_p
w(13)=3.386345487644220e-7_p
x(14)=18.27972868762739_p
w(14)=2.786226686367720e-8_p
x(15)=20.58515611184986_p
w(15)=2.469707468921791e-9_p
x(16)=22.48962387891108_p
w(16)=2.747044893133458e-10_p
x(17)=23.69793335245139_p
w(17)=3.907545917792724e-11_p
else
call GD(-2)
end if
end subroutine GF_m2

! [-1kT;24kT]
subroutine GF_m1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=-2.078063162721687e-1_p
w(1)=1.057155695490366_p
x(2)=2.782863482617373_p
w(2)=2.561059919901059e-1_p
else if(N==3)then
x(1)=-4.522761184329435e-1_p
w(1)=8.263501793989873e-1_p
x(2)=1.608257234228006_p
w(2)=4.657815629342824e-1_p
x(3)=5.568697155099009_p
w(3)=2.112994514720190e-2_p
else if(N==4)then
x(1)=-5.847021689383427e-1_p
w(1)=6.658814950315406e-1_p
x(2)=1.010040465310249_p
w(2)=5.673941862423900e-1_p
x(3)=3.796552672278361_p
w(3)=7.882550805293834e-2_p
x(4)=8.625998433400660_p
w(4)=1.160498153602516e-3_p
else if(N==5)then
x(1)=-6.671706760969670e-1_p
w(1)=5.530226727626876e-1_p
x(2)=6.356416540213118e-1_p
w(2)=6.009285203624321e-1_p
x(3)=2.838749432829806_p
w(3)=1.513632690659941e-1_p
x(4)=6.296203596376504_p
w(4)=7.894831086332512e-3_p
x(5)=11.83023518535154_p
w(5)=5.239420302525419e-5_p
else if(N==6)then
x(1)=-7.237835179271750e-1_p
w(1)=4.698122359460653e-1_p
x(2)=3.741258633568519e-1_p
w(2)=5.985445226212929e-1_p
x(3)=2.210728889221758_p
w(3)=2.211361923359235e-1_p
x(4)=4.955287140519326_p
w(4)=2.315455659752879e-2_p
x(5)=8.975129374297659_p
w(5)=6.119097488512658e-4_p
x(6)=15.03549095969209_p
w(6)=2.270230809745479e-6_p
else if(N==7)then
x(1)=-7.658943695322070e-1_p
w(1)=4.049156777401924e-1_p
x(2)=1.759841480137141e-1_p
w(2)=5.776203477060546e-1_p
x(3)=1.749204674168718_p
w(3)=2.807443884241489e-1_p
x(4)=4.029502986296632_p
w(4)=4.722854518016850e-2_p
x(5)=7.231649950852273_p
w(5)=2.707339276835859e-3_p
x(6)=11.64849059396785_p
w(6)=4.526313752080359e-5_p
x(7)=17.91392274637784_p
w(7)=1.260155503975779e-7_p
else if(N==8)then
x(1)=-7.989601665862721e-1_p
w(1)=3.521870990386496e-1_p
x(2)=1.778018872440034e-2_p
w(2)=5.469312505687942e-1_p
x(3)=1.385947613040107_p
w(3)=3.274733208079701e-1_p
x(4)=3.329096827933403_p
w(4)=7.868574918868348e-2_p
x(5)=5.984940947019322_p
w(5)=7.681307590360693e-3_p
x(6)=9.504949811440152_p
w(6)=2.990306789334588e-4_p
x(7)=14.10840265217182_p
w(7)=3.917097395915475e-6_p
x(8)=20.0807047293559_p
w(8)=1.250968407736945e-8_p
else if(N==9)then
x(1)=-8.255910515691858e-1_p
w(1)=3.086052974807817e-1_p
x(2)=-1.114739476154550e-1_p
w(2)=5.117040348845684e-1_p
x(3)=1.090769688304883_p
w(3)=3.604851446787284e-1_p
x(4)=2.775758931462486_p
w(4)=1.146004219894308e-1_p
x(5)=5.033508028111119_p
w(5)=1.668055683595773e-2_p
x(6)=7.958292034253663_p
w(6)=1.149859326019634e-3_p
x(7)=11.64817135774075_p
w(7)=3.591396743695929e-5_p
x(8)=16.21431548679131_p
w(8)=4.559174481061170e-7_p
x(9)=21.47605889797558_p
w(9)=2.400099785319536e-9_p
else if(N==10)then
x(1)=-8.473306686856841e-1_p
w(1)=2.723026576117566e-1_p
x(2)=-2.182627488602633e-1_p
w(2)=4.753032766336054e-1_p
x(3)=8.469428495664502e-1_p
w(3)=3.806704534394181e-1_p
x(4)=2.327881745578670_p
w(4)=1.514547909348008e-1_p
x(5)=4.282012886308262_p
w(5)=3.017780069368190e-2_p
x(6)=6.775513349445051_p
w(6)=3.170150131697286e-3_p
x(7)=9.860131088963294_p
w(7)=1.773711891798064e-4_p
x(8)=13.58249055580439_p
w(8)=5.110713559056184e-6_p
x(9)=17.91886974659286_p
w(9)=7.536701399470631e-8_p
x(10)=22.31507012226908_p
w(10)=7.657584949528412e-10_p
else if(N==11)then
x(1)=-8.652800096091833e-1_p
w(1)=2.418452083385250e-1_p
x(2)=-3.073175333626039e-1_p
w(2)=4.397274294643947e-1_p
x(3)=6.430354760376606e-1_p
w(3)=3.900548171552028e-1_p
x(4)=1.958626230851216_p
w(4)=1.861859272290850e-1_p
x(5)=3.673889041884189_p
w(5)=4.784395483414548e-2_p
x(6)=5.838282933312859_p
w(6)=6.974851230169640e-3_p
x(7)=8.483672559086472_p
w(7)=5.983530765745200e-4_p
x(8)=11.63038133899805_p
w(8)=3.022588320635966e-5_p
x(9)=15.26784388971446_p
w(9)=9.023905029226882e-7_p
x(10)=19.24365588815055_p
w(10)=1.753805612068790e-8_p
x(11)=22.82157846133234_p
w(11)=3.406088554868077e-10_p
else if(N==12)then
x(1)=-8.802591617829396e-1_p
w(1)=2.160971412299699e-1_p
x(2)=-3.822537529692420e-1_p
w(2)=4.060465837246310e-1_p
x(3)=4.707047101094360e-1_p
w(3)=3.910051128386012e-1_p
x(4)=1.649491633071055_p
w(4)=2.166685123388981e-1_p
x(5)=3.172255590179098_p
w(5)=6.870961926580697e-2_p
x(6)=5.076643655404421_p
w(6)=1.305032768289071e-2_p
x(7)=7.385390235289193_p
w(7)=1.558851069552237e-3_p
x(8)=10.10732427556088_p
w(8)=1.193992055036740e-4_p
x(9)=13.23297179360129_p
w(9)=5.933767773623700e-6_p
x(10)=16.69565201249002_p
w(10)=2.006810258908683e-7_p
x(11)=20.24851391220969_p
w(11)=5.489100941076395e-9_p
x(12)=23.13891471354012_p
w(12)=1.867172648337349e-10_p
else if(N==13)then
x(1)=-8.928834515765414e-1_p
w(1)=1.941662792116734e-1_p
x(2)=-4.458452442756580e-1_p
w(2)=3.747581292860869e-1_p
x(3)=3.237274763411137e-1_p
w(3)=3.857440059752485e-1_p
x(4)=1.387362558792528_p
w(4)=2.417560370498240e-1_p
x(5)=2.751913853472774_p
w(5)=9.144955476969675e-2_p
x(6)=4.445701463138739_p
w(6)=2.163059719915482e-2_p
x(7)=6.486876187833327_p
w(7)=3.372168225352601e-3_p
x(8)=8.879356092810591_p
w(8)=3.573009848671660e-4_p
x(9)=11.6138117929132_p
w(9)=2.618657469811900e-5_p
x(10)=14.6519296144802_p
w(10)=1.370150334245048e-6_p
x(11)=17.88074932795706_p
w(11)=5.575576634405515e-8_p
x(12)=21.00364341311148_p
w(12)=2.180710795101245e-9_p
x(13)=23.34690352821156_p
w(13)=1.170577507890186e-10_p
else if(N==14)then
x(1)=-9.036188958652102e-1_p
w(1)=1.753526515144125e-1_p
x(2)=-5.002333002819814e-1_p
w(2)=3.460230473981484e-1_p
x(3)=1.973736673606407e-1_p
w(3)=3.761454153724943e-1_p
x(4)=1.162707991012139_p
w(4)=2.611071731666073e-1_p
x(5)=2.395042886555823_p
w(5)=1.146684434958497e-1_p
x(6)=3.914982147666890_p
w(6)=3.265191253176097e-2_p
x(7)=5.737925127371959_p
w(7)=6.345367901004422e-3_p
x(8)=7.866017158225437_p
w(8)=8.736953917052259e-4_p
x(9)=10.29042456894952_p
w(9)=8.713231916783956e-5_p
x(10)=12.985207105402_p
w(10)=6.454473200031118e-6_p
x(11)=15.88704616107667_p
w(11)=3.738657223551385e-7_p
x(12)=18.85168216262305_p
w(12)=1.892866685322132e-8_p
x(13)=21.5722144317478_p
w(13)=1.041453092705960e-9_p
x(14)=23.48918389085459_p
w(14)=8.027855149587097e-11_p
else if(N==15)then
x(1)=-9.128226400912965e-1_p
w(1)=1.591045045814730e-1_p
x(2)=-5.470861560078674e-1_p
w(2)=3.198126287281965e-1_p
x(3)=8.798313218673351e-2_p
w(3)=3.636905129324318e-1_p
x(4)=9.684328572992563e-1_p
w(4)=2.749435390859902e-1_p
x(5)=2.088678825025095_p
w(5)=1.371179575857605e-1_p
x(6)=3.462912370139192_p
w(6)=4.577956544240236e-2_p
x(7)=5.104412794745468_p
w(7)=1.071895790618262e-2_p
x(8)=7.015029996911136_p
w(8)=1.833801668236158e-3_p
x(9)=9.186819885519483_p
w(9)=2.351647149612118e-4_p
x(10)=11.60040970265087_p
w(10)=2.312109349334264e-5_p
x(11)=14.21518426173383_p
w(11)=1.805715433011688e-6_p
x(12)=16.94901380776927_p
w(12)=1.197609213556412e-7_p
x(13)=19.64203510127032_p
w(13)=7.634513241966423e-9_p
x(14)=22.00415866487443_p
w(14)=5.718582311864327e-10_p
x(15)=23.59023648904637_p
w(15)=5.861802668864942e-11_p
else if(N==16)then
x(1)=-9.207717317744905e-1_p
w(1)=1.449838967086237e-1_p
x(2)=-5.877163184301351e-1_p
w(2)=2.959973805042484e-1_p
x(3)=-7.320782241204991e-3_p
w(3)=3.494999274998719e-1_p
x(4)=7.991370152349819e-1_p
w(4)=2.838213245768407e-1_p
x(5)=1.823166673220180_p
w(5)=1.578218610732990e-1_p
x(6)=3.073719086365686_p
w(6)=6.048176066729626e-2_p
x(7)=4.562100236765218_p
w(7)=1.662300246480254e-2_p
x(8)=6.290468963764495_p
w(8)=3.417320762971883e-3_p
x(9)=8.252031240330735_p
w(9)=5.405867764818459e-4_p
x(10)=10.43147642849055_p
w(10)=6.724544701798910e-5_p
x(11)=12.80022691880853_p
w(11)=6.758710950822467e-6_p
x(12)=15.30596354793966_p
w(12)=5.738985419455268e-7_p
x(13)=17.85481132587541_p
w(13)=4.444029079037036e-8_p
x(14)=20.28456184311546_p
w(14)=3.555481068915322e-9_p
x(15)=22.33645112237334_p
w(15)=3.489540166721346e-10_p
x(16)=23.664346581206_p
w(16)=4.479860746324670e-11_p
else if(N==17)then
x(1)=-9.276835780740837e-1_p
w(1)=1.326405708127010e-1_p
x(2)=-6.231663263864474e-1_p
w(2)=2.743999117972168e-1_p
x(3)=-9.082890850240213e-2_p
w(3)=3.343940196298372e-1_p
x(4)=6.506283213312172e-1_p
w(4)=2.884527898301810e-1_p
x(5)=1.591169662822433_p
w(5)=1.761180714138198e-1_p
x(6)=2.735574197084567_p
w(6)=7.612205402196415e-2_p
x(7)=4.093179498341772_p
w(7)=2.405736858811356e-2_p
x(8)=5.666588571486407_p
w(8)=5.792328857866917e-3_p
x(9)=7.450276753522209_p
w(9)=1.095244372400043e-3_p
x(10)=9.431774401818767_p
w(10)=1.662089158568729e-4_p
x(11)=11.58963379960539_p
w(11)=2.070522300950052e-5_p
x(12)=13.887691693175_p
w(12)=2.186958515855989e-6_p
x(13)=16.26547624791455_p
w(13)=2.061390209437051e-7_p
x(14)=18.62400180310556_p
w(14)=1.879060588900599e-8_p
x(15)=20.80817425840465_p
w(15)=1.863182890316952e-9_p
x(16)=22.59567625286932_p
w(16)=2.307459816920885e-10_p
x(17)=23.72019935422469_p
w(17)=3.543309621609591e-11_p
else
call GD(-1)
end if
end subroutine GF_m1

! [0kT;24kT]
subroutine GF_0(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=6.905391679523393e-1_p
w(1)=5.746633112011188e-1_p
x(2)=3.592383589004403_p
w(2)=1.184838693210752e-1_p
else if(N==3)then
x(1)=4.840508322559777e-1_p
w(1)=4.633588422219677e-1_p
x(2)=2.446731429807924_p
w(2)=2.207508146817152e-1_p
x(3)=6.424308835358636_p
w(3)=9.037523618511028e-3_p
else if(N==4)then
x(1)=3.712361035477139e-1_p
w(1)=3.825077222613959e-1_p
x(2)=1.875234823188723_p
w(2)=2.763180485973495e-1_p
x(3)=4.660911742551165_p
w(3)=3.383921677152509e-2_p
x(4)=9.505586568012713_p
w(4)=4.821928919234091e-4_p
else if(N==5)then
x(1)=3.001672388360402e-1_p
w(1)=3.235363139346299e-1_p
x(2)=1.522602720838699_p
w(2)=3.005498261102045e-1_p
x(3)=3.709590806498494_p
w(3)=6.576892431183423e-2_p
x(4)=7.180393950786404_p
w(4)=3.270515053754634e-3_p
x(5)=12.71527108836237_p
w(5)=2.160111177074221e-5_p
else if(N==6)then
x(1)=2.506863479877754e-1_p
w(1)=2.786217188100401e-1_p
x(2)=1.277634073485703_p
w(2)=3.068215161587751e-1_p
x(3)=3.085912656023638_p
w(3)=9.780879115472474e-2_p
x(4)=5.836821940022642_p
w(4)=9.640290055335003e-3_p
x(5)=9.851751347460084_p
w(5)=2.538939539041521e-4_p
x(6)=15.874759292505_p
w(6)=9.703894149339029e-7_p
else if(N==7)then
x(1)=2.133649061931877e-1_p
w(1)=2.425890429268264e-1_p
x(2)=1.092173332563735_p
w(2)=3.027487767821605e-1_p
x(3)=2.627873460453838_p
w(3)=1.267919560268582e-1_p
x(4)=4.905009008925016_p
w(4)=1.986329352206395e-2_p
x(5)=8.095979504725298_p
w(5)=1.134462682286315e-3_p
x(6)=12.47389407299404_p
w(6)=1.958778054120574e-5_p
x(7)=18.60458806335878_p
w(7)=6.080145734393024e-8_p
else if(N==8)then
x(1)=1.838188997233652e-1_p
w(1)=2.127271612486930e-1_p
x(2)=9.445467691938262e-1_p
w(2)=2.924478532992237e-1_p
x(3)=2.269591576330587_p
w(3)=1.511352100721464e-1_p
x(4)=4.200881982970692_p
w(4)=3.346606351363080e-2_p
x(5)=6.841882160493608_p
w(5)=3.238980440762049e-3_p
x(6)=10.32366964139839_p
w(6)=1.300697511396923e-4_p
x(7)=14.84159133089737_p
w(7)=1.835016127808189e-6_p
x(8)=20.56249815569429_p
w(8)=7.180470395008076e-9_p
else if(N==9)then
x(1)=1.599241792288805e-1_p
w(1)=1.877055679924123e-1_p
x(2)=8.244817226970003e-1_p
w(2)=2.785658146683395e-1_p
x(3)=1.981178946004078_p
w(3)=1.699944210786513e-1_p
x(4)=3.647387583492154_p
w(4)=4.931135608603400e-2_p
x(5)=5.888476706785020_p
w(5)=7.053929032757447e-3_p
x(6)=8.777876096275122_p
w(6)=4.993076000962497e-4_p
x(7)=12.40086293120621_p
w(7)=1.654651397694807e-5_p
x(8)=16.83387587929088_p
w(8)=2.359452206534594e-7_p
x(9)=21.78282073863281_p
w(9)=1.604705556651382e-9_p
else if(N==10)then
x(1)=1.403547436507230e-1_p
w(1)=1.666296127433059e-1_p
x(2)=7.256275705536218e-1_p
w(2)=2.629329903131490e-1_p
x(3)=1.745066064185459_p
w(3)=1.833402867729150e-1_p
x(4)=3.201926439665334_p
w(4)=6.600368208572224e-2_p
x(5)=5.138100387338785_p
w(5)=1.278711664404832e-2_p
x(6)=7.599453772166671_p
w(6)=1.370371190939395e-3_p
x(7)=10.62829262805126_p
w(7)=8.055099430494130e-5_p
x(8)=14.25632272926405_p
w(8)=2.525961846705280e-6_p
x(9)=18.42248515542369_p
w(9)=4.324678797363518e-8_p
x(10)=22.50852198103117_p
w(10)=5.691744606407330e-10_p
else if(N==11)then
x(1)=1.241464400704077e-1_p
w(1)=1.487742585642156e-1_p
x(2)=6.433592587658069e-1_p
w(2)=2.467486699423783e-1_p
x(3)=1.549100740790562_p
w(3)=1.917239602739635e-1_p
x(4)=2.836736605969005_p
w(4)=8.228854765603393e-2_p
x(5)=4.532701027700234_p
w(5)=2.032859109343424e-2_p
x(6)=6.667842657682456_p
w(6)=2.999899213697663e-3_p
x(7)=9.265225092449999_p
w(7)=2.682599276693090e-4_p
x(8)=12.33732742012508_p
w(8)=1.450121297805103e-5_p
x(9)=15.85732616708562_p
w(9)=4.813030661052299e-7_p
x(10)=19.64280758242198_p
w(10)=1.106370975629429e-8_p
x(11)=22.94756511505485_p
w(11)=2.710476098414880e-10_p
else if(N==12)then
x(1)=1.105797090440615e-1_p
w(1)=1.335501899434601e-1_p
x(2)=5.742068758943396e-1_p
w(2)=2.307540241789361e-1_p
x(3)=1.384511617274305_p
w(3)=1.959520104259990e-1_p
x(4)=2.532715383034423_p
w(4)=9.723301799956033e-2_p
x(5)=4.034719786196050_p
w(5)=2.931961099504050e-2_p
x(6)=5.912173755984267_p
w(6)=5.588244366968895e-3_p
x(7)=8.178804544698723_p
w(7)=6.909270829532035e-4_p
x(8)=10.83841005713531_p
w(8)=5.601134597160175e-5_p
x(9)=13.87323848206582_p
w(9)=3.024809468359189e-6_p
x(10)=17.20215136417715_p
w(10)=1.154676848360076e-7_p
x(11)=20.56136414354601_p
w(11)=3.750863133909721e-9_p
x(12)=23.22465745424227_p
w(12)=1.552879181814476e-10_p
else if(N==13)then
x(1)=9.911388283679617e-2_p
w(1)=1.204854156060476e-1_p
x(2)=5.155468021101839e-1_p
w(2)=2.153820462129951e-1_p
x(3)=1.244844203216228_p
w(3)=1.968724551812485e-1_p
x(4)=2.276329471846398_p
w(4)=1.102546073678705e-1_p
x(5)=3.618639373287927_p
w(5)=3.926179621863933e-2_p
x(6)=5.287198004310812_p
w(6)=9.232862092284187e-3_p
x(7)=7.290912769101141_p
w(7)=1.479712345149713e-3_p
x(8)=9.629659521853437_p
w(8)=1.645834326144028e-4_p
x(9)=12.2894477956664_p
w(9)=1.292245693281334e-5_p
x(10)=15.22421363814061_p
w(10)=7.434876145300466e-7_p
x(11)=18.31074209432492_p
w(11)=3.443183971580413e-8_p
x(12)=21.24890608473299_p
w(12)=1.588691708516947e-9_p
x(13)=23.40780957904085_p
w(13)=1.002658724309283e-10_p
else if(N==14)then
x(1)=8.933843736703016e-2_p
w(1)=1.092032541510474e-1_p
x(2)=4.653738967704572e-1_p
w(2)=2.008657783583933e-1_p
x(3)=1.125257139259676_p
w(3)=1.952646747567525e-1_p
x(4)=2.057739121745047_p
w(4)=1.210750560056435e-1_p
x(5)=3.266460103406657_p
w(5)=4.962143498938983e-2_p
x(6)=4.762315743588928_p
w(6)=1.391464321641774e-2_p
x(7)=6.551539267996415_p
w(7)=2.760520776019917e-3_p
x(8)=8.632378972987789_p
w(8)=3.963079407549068e-4_p
x(9)=10.99309024750234_p
w(9)=4.192243035143631e-5_p
x(10)=13.60326948330004_p
w(10)=3.358937472585914e-6_p
x(11)=16.39350197223424_p
w(11)=2.156437336929576e-7_p
x(12)=19.21442822094579_p
w(12)=1.244841601243929e-8_p
x(13)=21.76595199105477_p
w(13)=7.976159740605862e-10_p
x(14)=23.5341050817794_p
w(14)=7.018518030971286e-11_p
else if(N==15)then
x(1)=8.093781049789618e-2_p
w(1)=9.940229562910669e-2_p
x(2)=4.221369312215280e-1_p
w(2)=1.873116080401701e-1_p
x(3)=1.022051911905038_p
w(3)=1.917941874545699e-1_p
x(4)=1.869619679493069_p
w(4)=1.296461071406966e-1_p
x(5)=2.965093022103025_p
w(5)=5.990674811602185e-2_p
x(6)=4.315926703300907_p
w(6)=1.951152463959472e-2_p
x(7)=5.926713186650687_p
w(7)=4.630249713503544e-3_p
x(8)=7.795201599772996_p
w(8)=8.209178404392459e-4_p
x(9)=9.911342289810220_p
w(9)=1.108207371076377e-4_p
x(10)=12.25306360237009_p
w(10)=1.165114874462375e-5_p
x(11)=14.77600426852222_p
w(11)=9.911039448602353e-7_p
x(12)=17.39421953790654_p
w(12)=7.315065317190161e-8_p
x(13)=19.94757311318611_p
w(13)=5.300380698575892e-9_p
x(14)=22.15896150535006_p
w(14)=4.552494073555936e-10_p
x(15)=23.62444269984928_p
w(15)=5.201092924721964e-11_p
else if(N==16)then
x(1)=7.366646354660399e-2_p
w(1)=9.084013446428679e-2_p
x(2)=3.846215494761588e-1_p
w(2)=1.747476761055298e-1_p
x(3)=9.323565881622942e-1_p
w(3)=1.870034589432299e-1_p
x(4)=1.706404578462636_p
w(4)=1.360743105282454e-1_p
x(5)=2.704779725556720_p
w(5)=6.971309297654574e-2_p
x(6)=3.932270180343773_p
w(6)=2.582771123657384e-2_p
x(7)=5.392328207396003_p
w(7)=7.140983671113084e-3_p
x(8)=7.082737259730236_p
w(8)=1.512545543646561e-3_p
x(9)=8.994879945857935_p
w(9)=2.503185059150043e-4_p
x(10)=11.1117302803879_p
w(10)=3.301518698947493e-5_p
x(11)=13.40234549327045_p
w(11)=3.570194655344951e-6_p
x(12)=15.81177425922811_p
w(12)=3.316570817671024e-7_p
x(13)=18.2447083790595_p
w(13)=2.859798084726321e-8_p
x(14)=20.54241572675875_p
w(14)=2.583946867233457e-9_p
x(15)=22.4617684396672_p
w(15)=2.862635514553466e-10_p
x(16)=23.69110308344982_p
w(16)=4.019003386868190e-11_p
else if(N==17)then
x(1)=6.733114248213708e-2_p
w(1)=8.332064288642176e-2_p
x(2)=3.518666005721156e-1_p
w(2)=1.631553514629964e-1_p
x(3)=8.539091123213622e-1_p
w(3)=1.813205976621196e-1_p
x(4)=1.563786176158098_p
w(4)=1.405577374508849e-1_p
x(5)=2.478091643182458_p
w(5)=7.874074674445405e-2_p
x(6)=3.599540731585558_p
w(6)=3.262746618445279e-2_p
x(7)=4.930694867778817_p
w(7)=1.029424260220707e-2_p
x(8)=6.469590320689064_p
w(8)=2.539043376440546e-3_p
x(9)=8.208870510016963_p
w(9)=4.995537920484773e-4_p
x(10)=10.13488361046201_p
w(10)=7.984457831832686e-5_p
x(11)=12.22466224823763_p
w(11)=1.060418725843051e-5_p
x(12)=14.44025095628629_p
w(12)=1.210240225233485e-6_p
x(13)=16.71980967348073_p
w(13)=1.250544498974092e-7_p
x(14)=18.9650220228568_p
w(14)=1.266732537081935e-8_p
x(15)=21.02672370705235_p
w(15)=1.406744998160726e-9_p
x(16)=22.69847795819489_p
w(16)=1.937874980382664e-10_p
x(17)=23.74160839914674_p
w(17)=3.205863509056745e-11_p
else
call GD(0)
end if
end subroutine GF_0

! [1kT;24kT]
subroutine GF_1(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=1.631825283981254_p
w(1)=2.640326163123104e-1_p
x(2)=4.490326115003141_p
w(2)=4.922907116816107e-2_p
else if(N==3)then
x(1)=1.446124947984395_p
w(1)=2.168194836427193e-1_p
x(2)=3.359510489102638_p
w(2)=9.284038353725976e-2_p
x(3)=7.347222781688061_p
w(3)=3.601820300492439e-3_p
else if(N==4)then
x(1)=1.344345097353445_p
w(1)=1.816694548658391e-1_p
x(2)=2.801188779440550_p
w(2)=1.179065285495511e-1_p
x(3)=5.588721403889111_p
w(3)=1.349623146903079e-2_p
x(4)=10.44013515810196_p
w(4)=1.894725960505495e-4_p
else if(N==5)then
x(1)=1.279785325875746_p
w(1)=1.554339248946358e-1_p
x(2)=2.458891773864470_p
w(2)=1.301474083488827e-1_p
x(3)=4.639567584289312_p
w(3)=2.638616248764937e-2_p
x(4)=8.114498114039126_p
w(4)=1.285664948175251e-3_p
x(5)=13.64228215514552_p
w(5)=8.526801128289271e-6_p
else if(N==6)then
x(1)=1.234348346193133_p
w(1)=1.349765489300376e-1_p
x(2)=2.221181879558240_p
w(2)=1.347355706211494e-1_p
x(3)=4.015032335269305_p
w(3)=3.963230689654651e-2_p
x(4)=6.763500558884302_p
w(4)=3.815354943668553e-3_p
x(5)=10.76303335824629_p
w(5)=1.014990735295462e-4_p
x(6)=16.72692050912015_p
w(6)=4.070155398877912e-7_p
else if(N==7)then
x(1)=1.199746463721408_p
w(1)=1.182316656345313e-1_p
x(2)=2.041137221895455_p
w(2)=1.346595366040546e-1_p
x(3)=3.555494542227027_p
w(3)=5.197372359956433e-2_p
x(4)=5.822867253903469_p
w(4)=7.929285112433323e-3_p
x(5)=8.991678172514384_p
w(5)=4.591449417996737e-4_p
x(6)=13.31587288881833_p
w(6)=8.301931544737001e-6_p
x(7)=19.27214945967764_p
w(7)=2.965654356719527e-8_p
else if(N==8)then
x(1)=1.172256955940437_p
w(1)=1.041830371892951e-1_p
x(2)=1.898407140975048_p
w(2)=1.315964152710370e-1_p
x(3)=3.197625551126906_p
w(3)=6.265776755930255e-2_p
x(4)=5.113720069007826_p
w(4)=1.344983404814435e-2_p
x(5)=7.729755142110426_p
w(5)=1.318499874690277e-3_p
x(6)=11.16201368019027_p
w(6)=5.527578955692002e-5_p
x(7)=15.57618517079328_p
w(7)=8.535359580084104e-7_p
x(8)=21.00988157107858_p
w(8)=4.212487276966335e-9_p
else if(N==9)then
x(1)=1.150010816442677_p
w(1)=9.231751339227241e-2_p
x(2)=1.782973155845961_p
w(2)=1.266805342725585e-1_p
x(3)=2.911542554469807_p
w(3)=7.124694015357617e-2_p
x(4)=4.558938897034761_p
w(4)=1.992295114576960e-2_p
x(5)=6.774544725390734_p
w(5)=2.874668283401428e-3_p
x(6)=9.619084591603650_p
w(6)=2.114386581291822e-4_p
x(7)=13.16327616552561_p
w(7)=7.518114061292942e-6_p
x(8)=17.44481436863181_p
w(8)=1.223687666921829e-7_p
x(9)=22.06293749895225_p
w(9)=1.091936206944470e-9_p
else if(N==10)then
x(1)=1.131781694019524_p
w(1)=8.225642470961170e-2_p
x(2)=1.688365379929043_p
w(2)=1.207241569238243e-1_p
x(3)=2.678858028626706_p
w(3)=7.765847839646237e-2_p
x(4)=4.114475922239159_p
w(4)=2.680123169994747e-2_p
x(5)=6.025428936869480_p
w(5)=5.207323890757770e-3_p
x(6)=8.446212179973836_p
w(6)=5.768519469707820e-4_p
x(7)=11.41013798988598_p
w(7)=3.595401698272754e-5_p
x(8)=14.9319277689262_p
w(8)=1.240479785834024e-6_p
x(9)=18.91268805534341_p
w(9)=2.498850538501273e-8_p
x(10)=22.68508317296948_p
w(10)=4.276231306717876e-10_p
else if(N==11)then
x(1)=1.116671445631458_p
w(1)=7.368194609195576e-2_p
x(2)=1.609896023459832_p
w(2)=1.142821446718235e-1_p
x(3)=2.486821406657828_p
w(3)=8.205360533700222e-2_p
x(4)=3.751604509554228_p
w(4)=3.359411322723006e-2_p
x(5)=5.422766364415427_p
w(5)=8.270155451522361e-3_p
x(6)=7.521009638675978_p
w(6)=1.254611686935864e-3_p
x(7)=10.06270446960107_p
w(7)=1.179655728138558e-4_p
x(8)=13.05131379707365_p
w(8)=6.881742766046799e-6_p
x(9)=16.44299570802707_p
w(9)=2.564449204110619e-7_p
x(10)=20.02784588521284_p
w(10)=7.036578855037715e-9_p
x(11)=23.06329123801677_p
w(11)=2.169225455781468e-10_p
else if(N==12)then
x(1)=1.104012227287228_p
w(1)=6.633226826485494e-2_p
x(2)=1.544101231355113_p
w(2)=1.077171370863278e-1_p
x(3)=2.326311868461076_p
w(3)=8.470889713403811e-2_p
x(4)=3.450679040612559_p
w(4)=3.993184046269380e-2_p
x(5)=4.928267543104329_p
w(5)=1.192146743435302e-2_p
x(6)=6.771888474241670_p
w(6)=2.322628465707633e-3_p
x(7)=8.989583462337285_p
w(7)=2.999265412824378e-4_p
x(8)=11.57964952056645_p
w(8)=2.591991031249531e-5_p
x(9)=14.51536370855217_p
w(9)=1.532884009885882e-6_p
x(10)=17.7016086792312_p
w(10)=6.658549407230671e-8_p
x(11)=20.86161861814964_p
w(11)=2.581919846696697e-9_p
x(12)=23.30406451633121_p
w(12)=1.294774934846807e-10_p
else if(N==13)then
x(1)=1.093303312094511_p
w(1)=5.999536388844293e-2_p
x(2)=1.488392963722973_p
w(2)=1.012573865733204e-1_p
x(3)=2.190673449239319_p
w(3)=8.593292590463464e-2_p
x(4)=3.197835786668950_p
w(4)=4.557506572680012e-2_p
x(5)=4.516058002474621_p
w(5)=1.596815957302663e-2_p
x(6)=6.153311224370292_p
w(6)=3.816311300589914e-3_p
x(7)=8.113325120132945_p
w(7)=6.350823806283525e-4_p
x(8)=10.39214620009319_p
w(8)=7.464742449127611e-5_p
x(9)=12.9705424152928_p
w(9)=6.319588259154322e-6_p
x(10)=15.79467337798965_p
w(10)=4.025269607294750e-7_p
x(11)=18.7323513965493_p
w(11)=2.134333272610096e-8_p
x(12)=21.48380668429931_p
w(12)=1.164045796478641e-9_p
x(13)=23.46466361271018_p
w(13)=8.593877702764181e-11_p
else if(N==14)then
x(1)=1.084164728782642_p
w(1)=5.450025491037870e-2_p
x(2)=1.440810696019578_p
w(2)=9.504007696777804e-2_p
x(3)=2.074950507517483_p
w(3)=8.602117341449164e-2_p
x(4)=2.983017370559431_p
w(4)=5.039795978587183e-2_p
x(5)=4.167945118192592_p
w(5)=2.020557678235699e-2_p
x(6)=5.634565367010644_p
w(6)=5.725030822083589e-3_p
x(7)=7.384290736446306_p
w(7)=1.173041635649964e-3_p
x(8)=9.412343329918038_p
w(8)=1.767559148734823e-4_p
x(9)=11.7036552770837_p
w(9)=1.994547901565479e-5_p
x(10)=14.22316045705241_p
w(10)=1.738477443316534e-6_p
x(11)=16.8957983713201_p
w(11)=1.243953149704506e-7_p
x(12)=19.568698932815_p
w(12)=8.220516829292288e-9_p
x(13)=21.95148902476985_p
w(13)=6.133656592121747e-10_p
x(14)=23.57633352366516_p
w(14)=6.133082120452870e-11_p
else if(N==15)then
x(1)=1.076304366062363_p
w(1)=4.970884385940211e-2_p
x(2)=1.399848155434720_p
w(2)=8.914187141776456e-2_p
x(3)=1.975383817153240_p
w(3)=8.523509969590559e-2_p
x(4)=2.798750286871221_p
w(4)=5.436171697477585e-2_p
x(5)=3.870725241990383_p
w(5)=2.444570925427519e-2_p
x(6)=5.194016026635831_p
w(6)=7.999048850878798e-3_p
x(7)=6.768749376458394_p
w(7)=1.950510635688561e-3_p
x(8)=8.590025489867067_p
w(8)=3.609108709970447e-4_p
x(9)=10.64550621414339_p
w(9)=5.155897885871907e-5_p
x(10)=12.91016340672018_p
w(10)=5.825645351974978e-6_p
x(11)=15.33601477343572_p
w(11)=5.424463570253252e-7_p
x(12)=17.83400532018931_p
w(12)=4.474678366629181e-8_p
x(13)=20.24523062500224_p
w(13)=3.693957925361230e-9_p
x(14)=22.30737258271236_p
w(14)=3.633808958511250e-10_p
x(15)=23.65679377936237_p
w(15)=4.609357615083141e-11_p
else if(N==16)then
x(1)=1.069494831516414_p
w(1)=4.550914130699200e-2_p
x(2)=1.364332698289624_p
w(2)=8.359990560399504e-2_p
x(3)=1.889074062693303_p
w(3)=8.379520105520466e-2_p
x(4)=2.639365384535296_p
w(4)=5.748785157578409e-2_p
x(5)=3.614565531500026_p
w(5)=2.853297935666000e-2_p
x(6)=4.815903340834403_p
w(6)=1.056173743941162e-2_p
x(7)=6.242767744635187_p
w(7)=2.985702369533082e-3_p
x(8)=7.890471103078938_p
w(8)=6.567349482346077e-4_p
x(9)=9.748667041710776_p
w(9)=1.142901457956889e-4_p
x(10)=11.79836397746858_p
w(10)=1.605535003019928e-5_p
x(11)=14.00622668577326_p
w(11)=1.876261021196230e-6_p
x(12)=16.3149934770568_p
w(12)=1.914705615702391e-7_p
x(13)=18.62869540387046_p
w(13)=1.844215401023095e-8_p
x(14)=20.79327825540632_p
w(14)=1.883906291064816e-9_p
x(15)=22.58211511621159_p
w(15)=2.351907237287807e-10_p
x(16)=23.71653970719377_p
w(16)=3.599672186051375e-11_p
else if(N==17)then
x(1)=1.063557044092079_p
w(1)=4.180986765706089e-2_p
x(2)=1.333340353358043_p
w(2)=7.842599681241358e-2_p
x(3)=1.813752331983808_p
w(3)=8.188153085907386e-2_p
x(4)=2.500485266234273_p
w(4)=5.983559193319357e-2_p
x(5)=3.391985526172748_p
w(5)=3.235008238616941e-2_p
x(6)=4.488437350006475_p
w(6)=1.332270928925713e-2_p
x(7)=5.788790582418877_p
w(7)=4.276909070109536e-3_p
x(8)=7.288710811301885_p
w(8)=1.090482590570460e-3_p
x(9)=8.979403613709067_p
w(9)=2.244298031474501e-4_p
x(10)=10.84584342287269_p
w(10)=3.794023537402044e-5_p
x(11)=12.8634395561326_p
w(11)=5.393503599725233e-6_p
x(12)=14.99257662921321_p
w(12)=6.676491165908886e-7_p
x(13)=17.17045641899304_p
w(13)=7.587601067708634e-8_p
x(14)=19.30014238374636_p
w(14)=8.558806808890327e-9_p
x(15)=21.2392336362207_p
w(15)=1.064766307918171e-9_p
x(16)=22.79739598003712_p
w(16)=1.628514197960092e-10_p
x(17)=23.76205151163502_p
w(17)=2.895004501368615e-11_p
else
call GD(1)
end if
end subroutine GF_1

! [2kT;24kT]
subroutine GF_2(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=2.604166809131074_p
w(1)=1.077990458296450e-1_p
x(2)=5.444194586332999_p
w(2)=1.912896517557613e-2_p
else if(N==3)then
x(1)=2.427950352347193_p
w(1)=8.929108368605922e-2_p
x(2)=4.319949721008766_p
w(2)=3.626317898843204e-2_p
x(3)=8.312350632316983_p
w(3)=1.373748330729897e-3_p
else if(N==4)then
x(1)=2.331248479168805_p
w(1)=7.535164005723506e-2_p
x(2)=3.767154461036535_p
w(2)=4.635487041021902e-2_p
x(3)=6.555608914950793_p
w(3)=5.149578974753644e-3_p
x(4)=11.40863524284505_p
w(4)=7.192156301342399e-5_p
else if(N==5)then
x(1)=2.269604236968303_p
w(1)=6.480938662524544e-2_p
x(2)=3.428496226380644_p
w(2)=5.151888468205974e-2_p
x(3)=5.605149567860628_p
w(3)=1.010634254454932e-2_p
x(4)=9.077556011089747_p
w(4)=4.901053439649136e-4_p
x(5)=14.58936212902534_p
w(5)=3.291809401747029e-6_p
else if(N==6)then
x(1)=2.225830041687161_p
w(1)=5.645750464517493e-2_p
x(2)=3.192400870691456_p
w(2)=5.368327752369951e-2_p
x(3)=4.976097412844969_p
w(3)=1.527914161115905e-2_p
x(4)=7.714725388204496_p
w(4)=1.468033887237910e-3_p
x(5)=11.68867489597636_p
w(5)=3.988179369219049e-5_p
x(6)=17.56612165377751_p
w(6)=1.715442575523220e-7_p
else if(N==7)then
x(1)=2.192302674952917_p
w(1)=4.954054380564152e-2_p
x(2)=3.013350044449957_p
w(2)=5.395675462074263e-2_p
x(3)=4.512284147853943_p
w(3)=2.016823645083676e-2_p
x(4)=6.763476100940290_p
w(4)=3.076173350830436e-3_p
x(5)=9.900721948109140_p
w(5)=1.827789955513380e-4_p
x(6)=14.15584478532132_p
w(6)=3.508883192550648e-6_p
x(7)=19.89682282058359_p
w(7)=1.489842592800304e-8_p
else if(N==8)then
x(1)=2.165675978583677_p
w(1)=4.371000253816890e-2_p
x(2)=2.872005052656316_p
w(2)=5.298499736522706e-2_p
x(3)=4.152595487550981_p
w(3)=2.444109561202633e-2_p
x(4)=6.048891383024025_p
w(4)=5.240911921068203e-3_p
x(5)=8.631903569964750_p
w(5)=5.272859858034292e-4_p
x(6)=12.00413792420767_p
w(6)=2.331481425529330e-5_p
x(7)=16.29669664508176_p
w(7)=4.002182488089687e-7_p
x(8)=21.4142694083452_p
w(8)=2.550423132294296e-9_p
else if(N==9)then
x(1)=2.144172367739387_p
w(1)=3.877522532466317e-2_p
x(2)=2.758297519704321_p
w(2)=5.122288571396079e-2_p
x(3)=3.866679445748519_p
w(3)=2.791034269603952e-2_p
x(4)=5.492520390177993_p
w(4)=7.778309519236280e-3_p
x(5)=7.675769245744976_p
w(5)=1.149154820539489e-3_p
x(6)=10.46733851743131_p
w(6)=8.861253472163052e-5_p
x(7)=13.92160709076287_p
w(7)=3.415270718002610e-6_p
x(8)=18.03519352549736_p
w(8)=6.436558698775073e-8_p
x(9)=22.31348224783319_p
w(9)=7.597552777355059e-10_p
else if(N==10)then
x(1)=2.126580985906602_p
w(1)=3.458356362284280e-2_p
x(2)=2.665512104596368_p
w(2)=4.899988979280311e-2_p
x(3)=3.635282760108408_p
w(3)=3.053802073619588e-2_p
x(4)=5.048583181618313_p
w(4)=1.047355983045314e-2_p
x(5)=6.928515037189561_p
w(5)=2.076506882322660e-3_p
x(6)=9.301956330931860_p
w(6)=2.398653907205227e-4_p
x(7)=12.19282392292968_p
w(7)=1.597736263688088e-5_p
x(8)=15.5976556792721_p
w(8)=6.123933076803257e-7_p
x(9)=19.38098218594851_p
w(9)=1.466830030141904e-8_p
x(10)=22.84356860517848_p
w(10)=3.256381673310971e-10_p
else if(N==11)then
x(1)=2.112016811734184_p
w(1)=3.100533977612216e-2_p
x(2)=2.588820193727883_p
w(2)=4.654343065564020e-2_p
x(3)=3.445112781154621_p
w(3)=3.238192438273017e-2_p
x(4)=4.687378206550020_p
w(4)=1.313724591291520e-2_p
x(5)=6.328980037596789_p
w(5)=3.287611192769217e-3_p
x(6)=8.384441033365459_p
w(6)=5.175367013428425e-4_p
x(7)=10.86392168087011_p
w(7)=5.151301445283576e-5_p
x(8)=13.76117572045654_p
w(8)=3.266843234926044e-6_p
x(9)=17.01540121688583_p
w(9)=1.378105552846531e-7_p
x(10)=20.39301872495022_p
w(10)=4.540521130235834e-9_p
x(11)=23.16807768265742_p
w(11)=1.749371808140990e-10_p
else if(N==12)then
x(1)=2.099826189274246_p
w(1)=2.793363670789365e-2_p
x(2)=2.524695615406697_p
w(2)=4.400455649567257e-2_p
x(3)=3.286743154052790_p
w(3)=3.354479415918132e-2_p
x(4)=4.388744171799819_p
w(4)=1.562791687579625e-2_p
x(5)=5.838182296979714_p
w(5)=4.724443908181361e-3_p
x(6)=7.642778697127030_p
w(6)=9.508245116942135e-4_p
x(7)=9.806006323063695_p
w(7)=1.290567485963887e-4_p
x(8)=12.32030939385364_p
w(8)=1.196119718381628e-5_p
x(9)=15.1498347528578_p
w(9)=7.797152398400759e-7_p
x(10)=18.18660243716884_p
w(10)=3.877893968904834e-8_p
x(11)=21.14541171065445_p
w(11)=1.798444632609016e-9_p
x(12)=23.37665422036154_p
w(12)=1.083974237666081e-10_p
else if(N==13)then
x(1)=2.089521153703807_p
w(1)=2.528168315691680e-2_p
x(2)=2.470526728525982_p
w(2)=4.148041991473860e-2_p
x(3)=3.153340535715625_p
w(3)=3.414259305509796e-2_p
x(4)=4.138522743604973_p
w(4)=1.785448478247660e-2_p
x(5)=5.429905318479637_p
w(5)=6.310646024812774e-3_p
x(6)=7.031275533507729_p
w(6)=1.551360120317762e-3_p
x(7)=8.942731312185646_p
w(7)=2.698091427548803e-4_p
x(8)=11.15643861995745_p
w(8)=3.368945332960038e-5_p
x(9)=13.64772865601626_p
w(9)=3.091854457384984e-6_p
x(10)=16.3553595006895_p
w(10)=2.192053054845503e-7_p
x(11)=19.1398613457131_p
w(11)=1.336055930447576e-8_p
x(12)=21.70568633984661_p
w(12)=8.606547268374897e-10_p
x(13)=23.51709715782468_p
w(13)=7.379927481196518e-11_p
else if(N==14)then
x(1)=2.080732445941585_p
w(1)=2.297931201324854e-2_p
x(2)=2.424348282700623_p
w(2)=3.903119514642679e-2_p
x(3)=3.039844598731742_p
w(3)=3.428731470477496e-2_p
x(4)=3.926477024914890_p
w(4)=1.976900393053894e-2_p
x(5)=5.085774918653699_p
w(5)=7.967012452929143e-3_p
x(6)=6.519169510737723_p
w(6)=2.312595480881276e-3_p
x(7)=8.225042349235547_p
w(7)=4.928054551501985e-4_p
x(8)=10.19581906290241_p
w(8)=7.832006045862312e-5_p
x(9)=12.41294446348564_p
w(9)=9.471256590719019e-6_p
x(10)=14.83679642263946_p
w(10)=9.022467884443954e-7_p
x(11)=17.38739063614958_p
w(11)=7.225200133969123e-8_p
x(12)=19.91011761435955_p
w(12)=5.477009561461971e-9_p
x(13)=22.1269298430523_p
w(13)=4.747991245860889e-10_p
x(14)=23.61558030736616_p
w(14)=5.362348669708181e-11_p
else if(N==15)then
x(1)=2.073176760050892_p
w(1)=2.096969469799129e-2_p
x(2)=2.384658563192517_p
w(2)=3.669213160127836e-2_p
x(3)=2.942435171989933_p
w(3)=3.407887090443037e-2_p
x(4)=3.745020329907046_p
w(4)=2.135625711665147e-2_p
x(5)=4.792486676629811_p
w(5)=9.621936728098060e-3_p
x(6)=6.084823403575903_p
w(6)=3.213183954155298e-3_p
x(7)=7.619562536032144_p
w(7)=8.113568182951293e-4_p
x(8)=9.389636584317842_p
w(8)=1.574370697208432e-4_p
x(9)=11.38032634567345_p
w(9)=2.389949383644542e-5_p
x(10)=13.56364146849355_p
w(10)=2.913984124074719e-6_p
x(11)=15.88831018269157_p
w(11)=2.981444133503148e-7_p
x(12)=18.26303049136697_p
w(12)=2.756596957040991e-8_p
x(13)=20.53164078290174_p
w(13)=2.594023152841133e-9_p
x(14)=22.44799037290977_p
w(14)=2.913965317063676e-10_p
x(15)=23.6870604643413_p
w(15)=4.083720501716436e-11_p
else if(N==16)then
x(1)=2.066633904183396_p
w(1)=1.920663135002043e-2_p
x(2)=2.350293818776807_p
w(2)=3.448192911504305e-2_p
x(3)=2.858179087965396_p
w(3)=3.360224689019449e-2_p
x(4)=3.588411360602545_p
w(4)=2.262358870339809e-2_p
x(5)=4.540150511695523_p
w(5)=1.121689891970463e-2_p
x(6)=5.712496203876698_p
w(6)=4.222129780206117e-3_p
x(7)=7.102596126572798_p
w(7)=1.231135438441048e-3_p
x(8)=8.703980318848394_p
w(8)=2.826221298108668e-4_p
x(9)=10.50457866609833_p
w(9)=5.191936351370507e-5_p
x(10)=12.4833854365145_p
w(10)=7.796578170139950e-6_p
x(11)=14.60482157571629_p
w(11)=9.880606636223406e-7_p
x(12)=16.80976615882803_p
w(12)=1.110946830158141e-7_p
x(13)=19.00242753177205_p
w(13)=1.197323362456290e-8_p
x(14)=21.03453050132884_p
w(14)=1.382094608120709e-9_p
x(15)=22.69642186053129_p
w(15)=1.938306569396521e-10_p
x(16)=23.74047272784799_p
w(16)=3.221305614830545e-11_p
else if(N==17)then
x(1)=2.060930689125264_p
w(1)=1.765238162246245e-2_p
x(2)=2.320340667796197_p
w(2)=3.240847295909929e-2_p
x(3)=2.784790524592326_p
w(3)=3.292748719340929e-2_p
x(4)=3.452227131468393_p
w(4)=2.359245279431018e-2_p
x(5)=4.321253427374709_p
w(5)=1.270819655207100e-2_p
x(6)=5.390425446157853_p
w(6)=5.303982948309739e-3_p
x(7)=6.656759658487708_p
w(7)=1.749958116282077e-3_p
x(8)=8.114392880696673_p
w(8)=4.637289173203916e-4_p
x(9)=9.753209464611180_p
w(9)=1.002067165772124e-4_p
x(10)=11.55675840838407_p
w(10)=1.797660594437003e-5_p
x(11)=13.49888003077703_p
w(11)=2.744026099965510e-6_p
x(12)=15.53854377778275_p
w(12)=3.694803775708101e-7_p
x(13)=17.61247388081112_p
w(13)=4.628163111372387e-8_p
x(14)=19.62582216428882_p
w(14)=5.818182705035651e-9_p
x(15)=21.44363791999624_p
w(15)=8.099131286589420e-10_p
x(16)=22.89159325612534_p
w(16)=1.371203621172561e-10_p
x(17)=23.7813800203498_p
w(17)=2.611031366968116e-11_p
else
call GD(2)
end if
end subroutine GF_2

! [3kT;24kT]
subroutine GF_3(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=3.592776636195815_p
w(1)=4.139324343102472e-2_p
x(2)=6.425549289286608_p
w(2)=7.194108104965992e-3_p
else if(N==3)then
x(1)=3.420400477784525_p
w(1)=3.440835143066114e-2_p
x(2)=5.303899134706975_p
w(2)=1.366614498453996e-2_p
x(3)=9.298099388053501_p
w(3)=5.128551207896112e-4_p
else if(N==4)then
x(1)=3.325709999727062_p
w(1)=2.911924100501632e-2_p
x(2)=4.752936323785907_p
w(2)=1.751710625477596e-2_p
x(3)=7.541018149756820_p
w(3)=1.924130092014294e-3_p
x(4)=12.3922857276244_p
w(4)=2.687418418413991e-5_p
else if(N==5)then
x(1)=3.265041458832102_p
w(1)=2.508355297747233e-2_p
x(2)=4.414443398122306_p
w(2)=1.952744064764303e-2_p
x(3)=6.586495787851260_p
w(3)=3.790493029804243e-3_p
x(4)=10.05101593612438_p
w(4)=1.845966920756632e-4_p
x(5)=15.53521783615772_p
w(5)=1.268188995448879e-6_p
else if(N==6)then
x(1)=3.221610676418830_p
w(1)=2.184882406093649e-2_p
x(2)=4.177043402434315_p
w(2)=2.040152774101147e-2_p
x(3)=5.950497521490245_p
w(3)=5.761959048899734e-3_p
x(4)=8.673016662940757_p
w(4)=5.592913104492551e-4_p
x(5)=12.61060539009215_p
w(5)=1.567515731651011e-5_p
x(6)=18.36883110653591_p
w(6)=7.421737724899460e-8_p
else if(N==7)then
x(1)=3.188258446267117_p
w(1)=1.915406599015503e-2_p
x(2)=3.996883914954414_p
w(2)=2.054121930045140e-2_p
x(3)=5.481209419614617_p
w(3)=7.636893042586871e-3_p
x(4)=7.710732828254669_p
w(4)=1.180993793903914e-3_p
x(5)=10.80780639996632_p
w(5)=7.266986480408791e-5_p
x(6)=14.97805284224118_p
w(6)=1.501731328159084e-6_p
x(7)=20.46497110027155_p
w(7)=7.812761247477501e-9_p
else if(N==8)then
x(1)=3.161845665078537_p
w(1)=1.688305262090463e-2_p
x(2)=3.855311320385402_p
w(2)=2.019229839054176e-2_p
x(3)=5.118973363653097_p
w(3)=9.274173364470966e-3_p
x(4)=6.991226400329137_p
w(4)=2.017610291449124e-3_p
x(5)=9.534448597766797_p
w(5)=2.101335204683423e-4_p
x(6)=12.83670373064657_p
w(6)=9.890235773379024e-6_p
x(7)=16.99067479181918_p
w(7)=1.915102288814098e-7_p
x(8)=21.77199933789824_p
w(8)=1.602153628735246e-9_p
else if(N==9)then
x(1)=3.140590307455579_p
w(1)=1.496388652578802e-2_p
x(2)=3.741986217528452_p
w(2)=1.953340142513079e-2_p
x(3)=4.832499836508364_p
w(3)=1.059997678201671e-2_p
x(4)=6.433686982297797_p
w(4)=2.994334970912847e-3_p
x(5)=8.579075453805959_p
w(5)=4.569413837484019e-4_p
x(6)=11.31043904165683_p
w(6)=3.720643190807794e-5_p
x(7)=14.66446162731124_p
w(7)=1.568822675563499e-6_p
x(8)=18.59604654192143_p
w(8)=3.465210370453488e-8_p
x(9)=22.53410907706673_p
w(9)=5.417065928574369e-10_p
else if(N==10)then
x(1)=3.123252010520168_p
w(1)=1.333586125382786e-2_p
x(2)=3.649887418788268_p
w(2)=1.869355469279420e-2_p
x(3)=4.601630995950943_p
w(3)=1.160161035396004e-2_p
x(4)=5.990497361521590_p
w(4)=4.026828663197205e-3_p
x(5)=7.834847590698870_p
w(5)=8.223533344979409e-4_p
x(6)=10.15522288332665_p
w(6)=9.968288023911833e-5_p
x(7)=12.96569597310546_p
w(7)=7.144526978657241e-6_p
x(8)=16.24418002378575_p
w(8)=3.067756896364726e-7_p
x(9)=19.82146679598836_p
w(9)=8.803135284718931e-9_p
x(10)=22.98409885721399_p
w(10)=2.516707798284855e-10_p
else if(N==11)then
x(1)=3.108930806211950_p
w(1)=1.194759721087723e-2_p
x(2)=3.574014580055196_p
w(2)=1.776142263086840e-2_p
x(3)=4.412564246871105_p
w(3)=1.230289503937518e-2_p
x(4)=5.631019529495989_p
w(4)=5.042288370873074e-3_p
x(5)=7.239279494401725_p
w(5)=1.295953255223853e-3_p
x(6)=9.247204393069484_p
w(6)=2.129849926259117e-4_p
x(7)=11.65878346267849_p
w(7)=2.256609460489444e-5_p
x(8)=14.45780190936969_p
w(8)=1.565559502971888e-6_p
x(9)=17.5672447442868_p
w(9)=7.525427035952351e-8_p
x(10)=20.73461651197674_p
w(10)=2.985458917616385e-9_p
x(11)=23.26196434559318_p
w(11)=1.423099210406125e-10_p
else if(N==12)then
x(1)=3.096967120161594_p
w(1)=1.075698519631425e-2_p
x(2)=3.510751183373473_p
w(2)=1.679578809139125e-2_p
x(3)=4.255592387511895_p
w(3)=1.274421251273871e-2_p
x(4)=5.334611418526424_p
w(4)=5.987401126332123e-3_p
x(5)=6.752796441530887_p
w(5)=1.853633310815401e-3_p
x(6)=8.514313523245200_p
w(6)=3.877630597813461e-4_p
x(7)=10.61841816529399_p
w(7)=5.558943761149919e-5_p
x(8)=13.05157463803896_p
w(8)=5.553328731323920e-6_p
x(9)=15.76904642416884_p
w(9)=4.011675877008186e-7_p
x(10)=18.65160719982333_p
w(10)=2.294204390809216e-8_p
x(11)=21.41039004620884_p
w(11)=1.271439332592785e-9_p
x(12)=23.44237670054359_p
w(12)=9.120386886318966e-11_p
else if(N==13)then
x(1)=3.086871119084808_p
w(1)=9.729958342239669e-3_p
x(2)=3.457437131820786_p
w(2)=1.583444111611458e-2_p
x(3)=4.123720015508933_p
w(3)=1.297047013061423e-2_p
x(4)=5.086848845607652_p
w(4)=6.828643909789910e-3_p
x(5)=6.348893254671935_p
w(5)=2.464939568251515e-3_p
x(6)=7.910877580191578_p
w(6)=6.274255807298786e-4_p
x(7)=9.769824650171351_p
w(7)=1.145574728532720e-4_p
x(8)=11.91400810606333_p
w(8)=1.526038032421441e-5_p
x(9)=14.3134076078897_p
w(9)=1.525003840132350e-6_p
x(10)=16.90005502990182_p
w(10)=1.208404449298374e-7_p
x(11)=19.52915397083631_p
w(11)=8.483723657238607e-9_p
x(12)=21.91298186338907_p
w(12)=6.435173801946944e-10_p
x(13)=23.56501867612968_p
w(13)=6.354734238127836e-11_p
else if(N==14)then
x(1)=3.078273542128708_p
w(1)=8.839021753095665e-3_p
x(2)=3.412081411046689_p
w(2)=1.490080174612791e-2_p
x(3)=4.011790914407996_p
w(3)=1.302468429910244e-2_p
x(4)=4.877340482180053_p
w(4)=7.549058376341960e-3_p
x(5)=6.009048159073935_p
w(5)=3.099105750328530e-3_p
x(6)=7.406180616837507_p
w(6)=9.282337866914144e-4_p
x(7)=9.064767983183151_p
w(7)=2.066356414746122e-4_p
x(8)=10.97453416183436_p
w(8)=3.476800355453936e-5_p
x(9)=13.11346864448218_p
w(9)=4.522955692184029e-6_p
x(10)=15.43771229352505_p
w(10)=4.726359432564043e-7_p
x(11)=17.86326854092739_p
w(11)=4.247572102739210e-8_p
x(12)=20.23561438653934_p
w(12)=3.694390283618889e-9_p
x(13)=22.29117412671011_p
w(13)=3.705820441385142e-10_p
x(14)=23.65174312363605_p
w(14)=4.694484667464531e-11_p
else if(N==15)then
x(1)=3.070891957070422_p
w(1)=8.061939827079855e-3_p
x(2)=3.373169396125800_p
w(2)=1.400861886871068e-2_p
x(3)=3.915928144579642_p
w(3)=1.294502299788431e-2_p
x(4)=4.698408005629100_p
w(4)=8.144003160600672e-3_p
x(5)=5.719881005535359_p
w(5)=3.728918379488892e-3_p
x(6)=6.978639296916481_p
w(6)=1.280897766434303e-3_p
x(7)=8.470356324088575_p
w(7)=3.364705106909331e-4_p
x(8)=10.18598678155041_p
w(8)=6.870748067077296e-5_p
x(9)=12.10845632239937_p
w(9)=1.111996293183975e-5_p
x(10)=14.20697305791677_p
w(10)=1.467811804566199e-6_p
x(11)=16.42744805045913_p
w(11)=1.654829576236597e-7_p
x(12)=18.67728452919741_p
w(12)=1.717504084992827e-8_p
x(13)=20.8044878628964_p
w(13)=1.840438374934012e-9_p
x(14)=22.5799982764839_p
w(14)=2.350646068786399e-10_p
x(15)=23.71514421518577_p
w(15)=3.619243605348813e-11_p
else if(N==16)then
x(1)=3.064507428003122_p
w(1)=7.380658213836584e-3_p
x(2)=3.339531835406998_p
w(2)=1.316522572997407e-2_p
x(3)=3.833165659106311_p
w(3)=1.276382785834101e-2_p
x(4)=4.544255829811509_p
w(4)=8.617162710453992e-3_p
x(5)=5.471464758145268_p
w(5)=4.332592868716850e-3_p
x(6)=6.612567152851425_p
w(6)=1.672737279776499e-3_p
x(7)=7.963209933608702_p
w(7)=5.055680713748915e-4_p
x(8)=9.515409802795183_p
w(8)=1.215356127160986e-4_p
x(9)=11.25541684309221_p
w(9)=2.363903305933635e-5_p
x(10)=13.1602961686046_p
w(10)=3.805608342171777e-6_p
x(11)=15.19248744856374_p
w(11)=5.243953219009802e-7_p
x(12)=17.29154229777306_p
w(12)=6.508932060001411e-8_p
x(13)=19.36269456221964_p
w(13)=7.853060586371702e-9_p
x(14)=21.26439369941283_p
w(14)=1.022464427245289e-9_p
x(15)=22.80405694089605_p
w(15)=1.604133456941749e-10_p
x(16)=23.76281297150351_p
w(16)=2.881834425719363e-11_p
else if(N==17)then
x(1)=3.058948147929303_p
w(1)=6.780444790323477e-3_p
x(2)=3.310254112606725_p
w(2)=1.237376441605193e-2_p
x(3)=3.761199587390334_p
w(3)=1.250768162974803e-2_p
x(4)=4.410429676585314_p
w(4)=8.977312770950544e-3_p
x(5)=5.256271123534209_p
w(5)=4.894217165999960e-3_p
x(6)=6.296253609150802_p
w(6)=2.089738267703009e-3_p
x(7)=7.526166678046748_p
w(7)=7.123539076447046e-4_p
x(8)=8.938947170962649_p
w(8)=1.968578722371980e-4_p
x(9)=10.52323238368464_p
w(9)=4.478807021959920e-5_p
x(10)=12.26119622527811_p
w(10)=8.548668859152504e-6_p
x(11)=14.1252622987922_p
w(11)=1.404594467396100e-6_p
x(12)=16.07329999876638_p
w(12)=2.061388292090798e-7_p
x(13)=18.04206978557495_p
w(13)=2.849283778178687e-8_p
x(14)=19.93947870458425_p
w(14)=3.990619234158052e-9_p
x(15)=21.63854235857741_p
w(15)=6.201840116478328e-10_p
x(16)=22.98056590630762_p
w(16)=1.157840024035517e-10_p
x(17)=23.79951550499866_p
w(17)=2.353146702456340e-11_p
else
call GD(3)
end if
end subroutine GF_3

! [4kT;24kT]
subroutine GF_4(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=4.588389432976652_p
w(1)=1.548097111703868e-2_p
x(2)=7.418417445399084_p
w(2)=2.668956763019712e-3_p
else if(N==3)then
x(1)=4.417468023713731_p
w(1)=1.288594504173384e-2_p
x(2)=6.297665188788683_p
w(2)=5.074201687568300e-3_p
x(3)=10.29230871333281_p
w(3)=1.897811507562570e-4_p
else if(N==4)then
x(1)=4.323441416184473_p
w(1)=1.091448253756678e-2_p
x(2)=5.746770107132513_p
w(2)=6.512256433374755e-3_p
x(3)=8.533232610326552_p
w(3)=7.131905625145336e-4_p
x(4)=13.37944131115257_p
w(4)=9.998346602321134e-6_p
else if(N==5)then
x(1)=4.262828918754666_p
w(1)=9.397995665182419e-3_p
x(2)=5.406531611533306_p
w(2)=7.270448982602630e-3_p
x(3)=7.572148281222286_p
w(3)=1.411505350583695e-3_p
x(4)=11.02320344288571_p
w(4)=6.948315905741688e-5_p
x(5)=16.46363043267313_p
w(5)=4.947226322344736e-7_p
else if(N==6)then
x(1)=4.219122893652496_p
w(1)=8.170950184374729e-3_p
x(2)=5.166385936700396_p
w(2)=7.602578509513983e-3_p
x(3)=6.927647097945571_p
w(3)=2.156924032409444e-3_p
x(4)=9.627983173163340_p
w(4)=2.132108351805936e-4_p
x(5)=13.51717513205451_p
w(5)=6.230885152197638e-6_p
x(6)=19.1187260409369_p
w(6)=3.343342744732101e-8_p
else if(N==7)then
x(1)=4.185559433958116_p
w(1)=7.146726080410393e-3_p
x(2)=4.984313911066399_p
w(2)=7.653599386893762e-3_p
x(3)=6.452667950848238_p
w(3)=2.866658370322496e-3_p
x(4)=8.655452247701701_p
w(4)=4.531690287371130e-4_p
x(5)=11.7038145862238_p
w(5)=2.911393491409547e-5_p
x(6)=15.77285278307886_p
w(6)=6.567772815879965e-7_p
x(7)=20.97124128675654_p
w(7)=4.301498946653489e-9_p
else if(N==8)then
x(1)=4.159093699720159_p
w(1)=6.286044866549869e-3_p
x(2)=4.841964395272337_p
w(2)=7.517646315749556e-3_p
x(3)=6.087971366366715_p
w(3)=3.482658806488943e-3_p
x(4)=7.932212369830484_p
w(4)=7.751043577737456e-4_p
x(5)=10.42934177155347_p
w(5)=8.412630552136887e-5_p
x(6)=13.65179318798459_p
w(6)=4.252023229952567e-6_p
x(7)=17.65108622330542_p
w(7)=9.416010417050764e-8_p
x(8)=22.08432542796973_p
w(8)=1.044640788827290e-9_p
else if(N==9)then
x(1)=4.137885813561489_p
w(1)=5.561092906537789e-3_p
x(2)=4.728566303318659_p
w(2)=7.264425227232249e-3_p
x(3)=5.800960422733159_p
w(3)=3.977177380284828e-3_p
x(4)=7.374404311171443_p
w(4)=1.148585329932517e-3_p
x(5)=9.477005232658156_p
w(5)=1.821327091834065e-4_p
x(6)=12.14126455147508_p
w(6)=1.576133583107556e-5_p
x(7)=15.38523351374181_p
w(7)=7.334154505326199e-7_p
x(8)=19.12297295069205_p
w(8)=1.918009829416886e-8_p
x(9)=22.72683002408403_p
w(9)=3.955077038272741e-10_p
else if(N==10)then
x(1)=4.120645750718034_p
w(1)=4.947837090367655e-3_p
x(2)=4.636767276761364_p
w(2)=6.943742378016348e-3_p
x(3)=5.570565573445259_p
w(3)=4.346858678777369e-3_p
x(4)=6.932607196285318_p
w(4)=1.540498824867443e-3_p
x(5)=8.737385496183675_p
w(5)=3.259190267245681e-4_p
x(6)=10.99941256505925_p
w(6)=4.167526298110874e-5_p
x(7)=13.7225892993259_p
w(7)=3.234269473431990e-6_p
x(8)=16.86635567931533_p
w(8)=1.567358265152040e-7_p
x(9)=20.23181768227055_p
w(9)=5.415719202334023e-9_p
x(10)=23.10800795671282_p
w(10)=1.973047537364164e-10_p
else if(N==11)then
x(1)=4.106446577218677_p
w(1)=4.426164364212995e-3_p
x(2)=4.561386080894926_p
w(2)=6.589447476448683e-3_p
x(3)=5.382502171087177_p
w(3)=4.602054053037127e-3_p
x(4)=6.575320101535501_p
w(4)=1.922954551705969e-3_p
x(5)=8.146949318359500_p
w(5)=5.105301783233863e-4_p
x(6)=10.10308171205186_p
w(6)=8.799827073300785e-5_p
x(7)=12.44149011190405_p
w(7)=9.973707225417891e-6_p
x(8)=15.13604289900131_p
w(8)=7.612419907940650e-7_p
x(9)=18.09478110562775_p
w(9)=4.191650210310174e-8_p
x(10)=21.05156893855893_p
w(10)=2.003122570749078e-9_p
x(11)=23.34569698702369_p
w(11)=1.167563412930201e-10_p
else if(N==12)then
x(1)=4.094614192159473_p
w(1)=3.979730259235635e-3_p
x(2)=4.498706735844652_p
w(2)=6.223763787843513e-3_p
x(3)=5.226801378350909_p
w(3)=4.759035354904339e-3_p
x(4)=6.281466876958100_p
w(4)=2.276050409637007e-3_p
x(5)=7.665668052595727_p
w(5)=7.259031544309063e-4_p
x(6)=9.380566582148957_p
w(6)=1.585132288473727e-4_p
x(7)=11.42131415190807_p
w(7)=2.410041828281162e-5_p
x(8)=13.76843914496196_p
w(8)=2.606815358930673e-6_p
x(9)=16.36885105583273_p
w(9)=2.096363319369921e-7_p
x(10)=19.09402839274403_p
w(10)=1.382501777212918e-8_p
x(11)=21.65609970406526_p
w(11)=9.130467826683533e-10_p
x(12)=23.50163157665996_p
w(12)=7.712138958141928e-11_p
else if(N==13)then
x(1)=4.084650680524748_p
w(1)=3.595383913863192e-3_p
x(2)=4.446012397377753_p
w(2)=5.860831470789444e-3_p
x(3)=5.096318586382369_p
w(3)=4.835438485837706e-3_p
x(4)=6.036389674679314_p
w(4)=2.587705209751243e-3_p
x(5)=7.266825410830977_p
w(5)=9.598654603004784e-4_p
x(6)=8.786423256039802_p
w(6)=2.540286588138862e-4_p
x(7)=10.58933993882622_p
w(7)=4.886841226564756e-5_p
x(8)=12.66001736176406_p
w(8)=6.971118380835015e-6_p
x(9)=14.96334896822092_p
w(9)=7.614794593101715e-7_p
x(10)=17.42551756725329_p
w(10)=6.765398299844065e-8_p
x(11)=19.89847551363923_p
w(11)=5.474903284241163e-9_p
x(12)=22.10549949407974_p
w(12)=4.868368882824556e-10_p
x(13)=23.60864051705568_p
w(13)=5.487348036562348e-11_p
else if(N==14)then
x(1)=4.076182279258560_p
w(1)=3.262555316067849e-3_p
x(2)=4.401279263992305_p
w(2)=5.509306647915420e-3_p
x(3)=4.985810484035514_p
w(3)=4.847897863630943e-3_p
x(4)=5.829566996944626_p
w(4)=2.852209525083195e-3_p
x(5)=6.931800892480338_p
w(5)=1.200474625211557e-3_p
x(6)=8.290097669153136_p
w(6)=3.725621059792772e-4_p
x(7)=9.898399588664445_p
w(7)=8.692683302969485e-5_p
x(8)=11.74381387392931_p
w(8)=1.553483623097088e-5_p
x(9)=13.80102874289461_p
w(9)=2.181154760029608e-6_p
x(10)=16.02240216035516_p
w(10)=2.507747090601598e-7_p
x(11)=18.32094680987804_p
w(11)=2.533825682455014e-8_p
x(12)=20.54400307561709_p
w(12)=2.526287306576309e-9_p
x(13)=22.44412408611111_p
w(13)=2.917404825718901e-10_p
x(14)=23.68493404348647_p
w(14)=4.115578568811921e-11_p
else if(N==15)then
x(1)=4.068924133255194_p
w(1)=2.972726033823954e-3_p
x(2)=4.362973974625723_p
w(2)=5.174186086161314e-3_p
x(3)=4.891349265518222_p
w(3)=4.811005392572402e-3_p
x(4)=5.653247746393451_p
w(4)=3.068474022689465e-3_p
x(5)=6.647172205536283_p
w(5)=1.437432862943008e-3_p
x(6)=7.870130823193771_p
w(6)=5.100759432085547e-4_p
x(7)=9.316227323864899_p
w(7)=1.398265839051869e-4_p
x(8)=10.97454894088957_p
w(8)=3.013381430713424e-5_p
x(9)=12.82577076218632_p
w(9)=5.214534134717136e-6_p
x(10)=14.83655940300984_p
w(10)=7.471987464509072e-7_p
x(11)=16.95056569332421_p
w(11)=9.302023913672492e-8_p
x(12)=19.07487858894503_p
w(12)=1.084387385147123e-8_p
x(13)=21.06295190349343_p
w(13)=1.320556946796962e-9_p
x(14)=22.70332836678413_p
w(14)=1.908052939437973e-10_p
x(15)=23.74110279689712_p
w(15)=3.209097951687292e-11_p
else if(N==16)then
x(1)=4.062656115401730_p
w(1)=2.719000577510168e-3_p
x(2)=4.329916972895002_p
w(2)=4.858060006322447e-3_p
x(3)=4.809939809165806_p
w(3)=4.737010638393534e-3_p
x(4)=5.501596799439232_p
w(4)=3.238448198020175e-3_p
x(5)=6.402999911019082_p
w(5)=1.662706619666196e-3_p
x(6)=7.510936623639482_p
w(6)=6.613771782756525e-4_p
x(7)=8.819845893434648_p
w(7)=2.078365528154344e-4_p
x(8)=10.32036354529467_p
w(8)=5.245785658629224e-5_p
x(9)=11.99714406678309_p
w(9)=1.083037680912970e-5_p
x(10)=13.82548483317828_p
w(10)=1.873805569826838e-6_p
x(11)=15.76617352939301_p
w(11)=2.813385556717336e-7_p
x(12)=17.75800567936397_p
w(12)=3.859774413874366e-8_p
x(13)=19.70805842766007_p
w(13)=5.211351706159976e-9_p
x(14)=21.48228027388425_p
w(14)=7.633172074017020e-10_p
x(15)=22.90495909496795_p
w(15)=1.333440205662736e-10_p
x(16)=23.7835883474565_p
w(16)=2.577679523665612e-11_p
else if(N==17)then
x(1)=4.057205960387499_p
w(1)=2.495767678144120e-3_p
x(2)=4.301188451774431_p
w(2)=4.561961078106455e-3_p
x(3)=4.739262505099721_p
w(3)=4.635900782044990e-3_p
x(4)=5.370140091827601_p
w(4)=3.365874888809944e-3_p
x(5)=6.191759154916191_p
w(5)=1.870602429771526e-3_p
x(6)=7.200887911266674_p
w(6)=8.209262810699842e-4_p
x(7)=8.392370624758748_p
w(7)=2.900289026008477e-4_p
x(8)=9.758093299592382_p
w(8)=8.379057281500708e-5_p
x(9)=11.28552469871032_p
w(9)=2.011778061408040e-5_p
x(10)=12.95557205421224_p
w(10)=4.094539662990707e-6_p
x(11)=14.73944954148773_p
w(11)=7.256051197363149e-7_p
x(12)=16.59427940452958_p
w(12)=1.162407348831108e-7_p
x(13)=18.45737639225501_p
w(13)=1.773803459663149e-8_p
x(14)=20.24000632787467_p
w(14)=2.764924208129477e-9_p
x(15)=21.82350777625321_p
w(15)=4.783457327364141e-10_p
x(16)=23.06425296062837_p
w(16)=9.806546797135035e-11_p
x(17)=23.81646927674813_p
w(17)=2.119382512822214e-11_p
else
call GD(4)
end if
end subroutine GF_4

! [5kT;24kT]
subroutine GF_5(N,x,w)
integer,intent(in)::N
real(p),intent(out)::x(N),w(N)
if(N==2)then
x(1)=5.586744886488557_p
w(1)=5.730393441922514e-3_p
x(2)=8.415740861888027_p
w(2)=9.849550094442091e-4_p
else if(N==3)then
x(1)=5.416336895482451_p
w(1)=4.772010938127757e-3_p
x(2)=7.295141505822091_p
w(2)=1.873329951313318e-3_p
x(3)=11.28944310924352_p
w(3)=7.000756192564772e-5_p
else if(N==4)then
x(1)=5.322379667032281_p
w(1)=4.041570183991797e-3_p
x(2)=6.743233450360697_p
w(2)=2.406231775266440e-3_p
x(3)=9.526526605009066_p
w(3)=2.638185974558082e-4_p
x(4)=14.36304678631363_p
w(4)=3.727894652677299e-6_p
else if(N==5)then
x(1)=5.261359385084476_p
w(1)=3.474676768682599e-3_p
x(2)=6.399936420306368_p
w(2)=2.688939329681413e-3_p
x(3)=8.556363585713381_p
w(3)=5.252298679024648e-4_p
x(4)=11.98713987540149_p
w(4)=2.630494025917395e-5_p
x(5)=17.36157772849387_p
w(5)=1.975448410729355e-7_p
else if(N==6)then
x(1)=5.217102214992044_p
w(1)=3.012487100289362e-3_p
x(2)=6.156334478175470_p
w(2)=2.811838100913472e-3_p
x(3)=7.902491572290320_p
w(3)=8.067283679909125e-4_p
x(4)=10.57414044376699_p
w(4)=8.175832167497282e-5_p
x(5)=14.40132751211305_p
w(5)=2.520746533841642e-6_p
x(6)=19.80570132958553_p
w(6)=1.581396416263890e-8_p
else if(N==7)then
x(1)=5.183194640257507_p
w(1)=2.627036633619241e-3_p
x(2)=5.972171567673731_p
w(2)=2.827575557814297e-3_p
x(3)=7.422207306590508_p
w(3)=1.074026819629973e-3_p
x(4)=9.593119945248421_p
w(4)=1.746052116785942e-4_p
x(5)=12.58387202721921_p
w(5)=1.180678908825660e-5_p
x(6)=16.53484289919549_p
w(6)=2.949518905976177e-7_p
x(7)=21.41600059717876_p
w(7)=2.487645763516429e-9_p
else if(N==8)then
x(1)=5.156595843431484_p
w(1)=2.304523614352216e-3_p
x(2)=5.828985957365520_p
w(2)=2.772577796968462e-3_p
x(3)=7.055552141969999_p
w(3)=1.303879658702887e-3_p
x(4)=8.867784924570964_p
w(4)=2.984925990715572e-4_p
x(5)=11.31248382083044_p
w(5)=3.396646581155801e-5_p
x(6)=14.44517264113734_p
w(6)=1.859895849586254e-6_p
x(7)=18.27457694030392_p
w(7)=4.771542802407621e-8_p
x(8)=22.35508984872509_p
w(8)=7.051824321683971e-10_p
else if(N==9)then
x(1)=5.135378242449109_p
w(1)=2.033979640231494e-3_p
x(2)=5.715467152451313_p
w(2)=2.673971212456098e-3_p
x(3)=6.768381722053903_p
w(3)=1.486200648638106e-3_p
x(4)=8.310907541009067_p
w(4)=4.410418096243073e-4_p
x(5)=10.36587735113565_p
w(5)=7.303451457397763e-5_p
x(6)=12.95613660088978_p
w(6)=6.759377003671176e-6_p
x(7)=16.08055313194629_p
w(7)=3.500237559677420e-7_p
x(8)=19.61457566858871_p
w(8)=1.093005077973179e-8_p
x(9)=22.89467594271501_p
w(9)=2.950323225193959e-10_p
else if(N==10)then
x(1)=5.118194296179766_p
w(1)=1.805918019832901e-3_p
x(2)=5.623925586557696_p
w(2)=2.550846380143866e-3_p
x(3)=6.538737202374069_p
w(3)=1.620453955477664e-3_p
x(4)=7.871395486280529_p
w(4)=5.892585762913971e-4_p
x(5)=9.632736992257099_p
w(5)=1.297164883285959e-4_p
x(6)=11.83121272765964_p
w(6)=1.758309793841860e-5_p
x(7)=14.46037305550257_p
w(7)=1.486510958466735e-6_p
x(8)=17.4618309106958_p
w(8)=8.184960349417007e-8_p
x(9)=20.61195358866044_p
w(9)=3.416111924835600e-9_p
x(10)=23.21711948210819_p
w(10)=1.566799952307211e-10_p
else if(N==11)then
x(1)=5.104085765508144_p
w(1)=1.612508150731403e-3_p
x(2)=5.548999737188909_p
w(2)=2.415995044168494e-3_p
x(3)=6.351881657238746_p
w(3)=1.711190534627936e-3_p
x(4)=7.516982446409040_p
w(4)=7.324980057735414e-4_p
x(5)=9.048816003003699_p
w(5)=2.016868011242180e-4_p
x(6)=10.94902356776946_p
w(6)=3.660867792415276e-5_p
x(7)=13.20914061072963_p
w(7)=4.459494967112811e-6_p
x(8)=15.79340743807854_p
w(8)=3.764283304002232e-7_p
x(9)=18.59659508305892_p
w(9)=2.384618224620535e-8_p
x(10)=21.34438683203316_p
w(10)=1.371015017180638e-9_p
x(11)=23.42031511484612_p
w(11)=9.652220135747562e-11_p
else if(N==12)then
x(1)=5.092360952128044_p
w(1)=1.447444367620131e-3_p
x(2)=5.486873527477742_p
w(2)=2.277700197023675e-3_p
x(3)=6.197604045955270_p
w(3)=1.765024395613258e-3_p
x(4)=7.226215552760400_p
w(4)=8.633977071119165e-4_p
x(5)=8.573798538117130_p
w(5)=2.847430395705563e-4_p
x(6)=10.23868663435372_p
w(6)=6.513481211183529e-5_p
x(7)=12.21198510013915_p
w(7)=1.054325706619609e-5_p
x(8)=14.46845742372478_p
w(8)=1.239998930991434e-6_p
x(9)=16.94739771676037_p
w(9)=1.114535482827624e-7_p
x(10)=19.51315292544611_p
w(10)=8.491596997020209e-9_p
x(11)=21.883187545731_p
w(11)=6.656703804239405e-10_p
x(12)=23.55501763997488_p
w(12)=6.550250301345640e-11_p
else if(N==13)then
x(1)=5.082511721970925_p
w(1)=1.305685299699974e-3_p
x(2)=5.434772517934483_p
w(2)=2.141151463627014e-3_p
x(3)=6.068624157031639_p
w(3)=1.788914380253716e-3_p
x(4)=6.984240936336527_p
w(4)=9.776866908068401e-4_p
x(5)=8.180851676624169_p
w(5)=3.740243663036299e-4_p
x(6)=9.655216479957335_p
w(6)=1.032447344613113e-4_p
x(7)=11.39872500633115_p
w(7)=2.099492319566708e-5_p
x(8)=13.39211161703604_p
w(8)=3.218444633716690e-6_p
x(9)=15.59557288748162_p
w(9)=3.856241904361729e-7_p
x(10)=17.93045739850792_p
w(10)=3.851252744714351e-8_p
x(11)=20.24755950119874_p
w(11)=3.591715128597481e-9_p
x(12)=22.28382436432463_p
w(12)=3.724529534274687e-10_p
x(13)=23.6483180889976_p
w(13)=4.749888785958974e-11_p
else if(N==14)then
x(1)=5.074158328720372_p
w(1)=1.183199631556468e-3_p
x(2)=5.390639386090989_p
w(2)=2.009465045613644e-3_p
x(3)=5.959621545412793_p
w(3)=1.789303138913194e-3_p
x(4)=6.780433653448522_p
w(4)=1.073537909167224e-3_p
x(5)=7.851315444374658_p
w(5)=4.649104914559594e-4_p
x(6)=9.168350747536442_p
w(6)=1.499419912591575e-4_p
x(7)=10.72351406951034_p
w(7)=3.677283289063012e-5_p
x(8)=12.50140031268109_p
w(8)=7.000969646812221e-6_p
x(9)=14.47362987011513_p
w(9)=1.064114302807590e-6_p
x(10)=16.58932223161522_p
w(10)=1.349584363836216e-7_p
x(11)=18.75957744830036_p
w(11)=1.534913937976584e-8_p
x(12)=20.83526299254751_p
w(12)=1.751311146519762e-9_p
x(13)=22.58624818132581_p
w(13)=2.315524015077184e-10_p
x(14)=23.7153712567402_p
w(14)=3.612151418507568e-11_p
else if(N==15)then
x(1)=5.067012456353195_p
w(1)=1.076752755167642e-3_p
x(2)=5.352921431891285_p
w(2)=1.884390173732250e-3_p
x(3)=5.866624904944602_p
w(3)=1.771762603600001e-3_p
x(4)=6.606989558640998_p
w(4)=1.150845444096941e-3_p
x(5)=7.571765267672895_p
w(5)=5.535296823865322e-4_p
x(6)=8.756834622475523_p
w(6)=2.034830849417671e-4_p
x(7)=10.1548597786278_p
w(7)=5.836123898832072e-5_p
x(8)=11.75315640949039_p
w(8)=1.330851720868406e-5_p
x(9)=13.53030447277042_p
w(9)=2.468888560004182e-6_p
x(10)=15.45075214091159_p
w(10)=3.849706169557212e-7_p
x(11)=17.45649718520625_p
w(11)=5.300862562908210e-8_p
x(12)=19.45528390382988_p
w(12)=6.941061330255013e-9_p
x(13)=21.30712732837722_p
w(13)=9.581328674987988e-10_p
x(14)=22.81833598146455_p
w(14)=1.557861902857780e-10_p
x(15)=23.76507451957899_p
w(15)=2.846160790315995e-11_p
else if(N==16)then
x(1)=5.060852047685936_p
w(1)=9.837364652486098e-4_p
x(2)=5.320428297016258_p
w(2)=1.766788377901563e-3_p
x(3)=5.786615493697227_p
w(3)=1.740914810868913e-3_p
x(4)=6.458048865212111_p
w(4)=1.210598130531851e-3_p
x(5)=7.332277514873796_p
w(5)=6.369515538090460e-4_p
x(6)=8.405234694224237_p
w(6)=2.617485373093475e-4_p
x(7)=9.670278913799738_p
w(7)=8.572589655722055e-5_p
x(8)=11.11675717610012_p
w(8)=2.277059658227086e-5_p
x(9)=12.72784192881231_p
w(9)=5.001836052508161e-6_p
x(10)=14.47727017023614_p
w(10)=9.320956706788767e-7_p
x(11)=16.32454708819881_p
w(11)=1.527587599093041e-7_p
x(12)=18.208297557154_p
w(12)=2.318296250410532e-8_p
x(13)=20.03820595922121_p
w(13)=3.499820148865102e-9_p
x(14)=21.68832529852779_p
w(14)=5.749468670276266e-10_p
x(15)=22.99939138032028_p
w(15)=1.112972326481262e-10_p
x(16)=23.80288907203046_p
w(16)=2.304805296571601e-11_p
else if(N==17)then
x(1)=5.055503844922252_p
w(1)=9.020356685444982e-4_p
x(2)=5.292234570177976_p
w(2)=1.656954657709881e-3_p
x(3)=5.717262004715721_p
w(3)=1.700488248950665e-3_p
x(4)=6.329129086715096_p
w(4)=1.254401065173603e-3_p
x(5)=7.125351503637992_p
w(5)=7.131759992167465e-4_p
x(6)=8.102043241783196_p
w(6)=3.225575584757040e-4_p
x(7)=9.253224466255539_p
w(7)=1.183735779019578e-4_p
x(8)=10.56981992415003_p
w(8)=3.582792800241209e-5_p
x(9)=12.03821992358266_p
w(9)=9.096831894090820e-6_p
x(10)=13.63820717357749_p
w(10)=1.978250207516607e-6_p
x(11)=15.34002590920273_p
w(11)=3.787732320040308e-7_p
x(12)=17.10042292854174_p
w(12)=6.631066820471377e-8_p
x(13)=18.85777235542333_p
w(13)=1.117215139709889e-8_p
x(14)=20.52722963509343_p
w(14)=1.935329011576400e-9_p
x(15)=21.99867207273725_p
w(15)=3.715466390611527e-10_p
x(16)=23.14284725528631_p
w(16)=8.328917578158748e-11_p
x(17)=23.832301657748_p
w(17)=1.907321599527337e-11_p
else
call GD(5)
end if
end subroutine GF_5

end module m_gauss_fermi_24
