  message(STATUS "Trying to find libboost_python-py${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}")
  # Fix a bug in FindBoost 1.70
  # https://github.com/boostorg/boost_install/issues/5
  if(NOT DEFINED BUILD_SHARED_LIBS)
    set(TFEL_TMP_BUILD_SHARED_LIBS ON)
    set(BUILD_SHARED_LIBS ON)
  endif(NOT DEFINED BUILD_SHARED_LIBS)
  find_package(Boost 1.36.0 COMPONENTS
    "python-py${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}")
  if(Boost_PYTHON-PY${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_FOUND)
    set(Boost_PYTHON_FOUND ON)
    set(Boost_PYTHON_LIBRARY "${Boost_PYTHON-PY${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_LIBRARY}")
    if(enable-numpy-support)
      find_package(Boost 1.36.0 COMPONENTS
        "numpy-py${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}")
      if(Boost_NUMPY-PY${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_FOUND)
        set(Boost_NUMPY_FOUND ON)
        set(Boost_NUMPY_LIBRARY "${Boost_NUMPY-PY${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_LIBRARY}")
      endif(Boost_NUMPY-PY${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_FOUND)
    endif(enable-numpy-support)
  else(Boost_PYTHON-PY${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_FOUND)
    set(Boost_PYTHON_FOUND OFF)
  endif(Boost_PYTHON-PY${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_FOUND)
  if(NOT Boost_PYTHON_FOUND)
    message(STATUS "Trying to find libboost_python${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}")
    find_package(Boost 1.36.0 COMPONENTS
      "python${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}")
    if(Boost_PYTHON${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_FOUND)
      set(Boost_PYTHON_FOUND ON)
      set(Boost_PYTHON_LIBRARY "${Boost_PYTHON${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_LIBRARY}")
      if(enable-numpy-support)
        find_package(Boost 1.36.0 COMPONENTS
         "numpy${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}")
        if(Boost_NUMPY${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_FOUND)
          set(Boost_NUMPY_FOUND ON)
          set(Boost_NUMPY_LIBRARY "${Boost_NUMPY${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_LIBRARY}")
        endif(Boost_NUMPY${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_FOUND)
      endif(enable-numpy-support)
    else(Boost_PYTHON${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_FOUND)
      set(Boost_PYTHON_FOUND OFF)
    endif(Boost_PYTHON${PYTHON_VERSION_MAJOR}${PYTHON_VERSION_MINOR}_FOUND)
  endif(NOT Boost_PYTHON_FOUND)
  if(NOT Boost_PYTHON_FOUND)
    message(STATUS "Trying to find libboost_python-py${PYTHON_VERSION_MAJOR}")
    find_package(Boost 1.36.0 COMPONENTS
      "python-py${PYTHON_VERSION_MAJOR}")
    if(Boost_PYTHON-PY${PYTHON_VERSION_MAJOR}_FOUND)
      set(Boost_PYTHON_FOUND ON)
      set(Boost_PYTHON_LIBRARY "${Boost_PYTHON-PY${PYTHON_VERSION_MAJOR}_LIBRARY}")
      if(enable-numpy-support)
	find_package(Boost 1.36.0 COMPONENTS
	  "numpy-py${PYTHON_VERSION_MAJOR}")
	if(Boost_NUMPY-PY${PYTHON_VERSION_MAJOR}_FOUND)
          set(Boost_NUMPY_FOUND ON)
          set(Boost_NUMPY_LIBRARY "${Boost_NUMPY-PY${PYTHON_VERSION_MAJOR}_LIBRARY}")
	endif(Boost_NUMPY-PY${PYTHON_VERSION_MAJOR}_FOUND)
      endif(enable-numpy-support)
    else(Boost_PYTHON-PY${PYTHON_VERSION_MAJOR}_FOUND)
      set(Boost_PYTHON_FOUND OFF)
    endif(Boost_PYTHON-PY${PYTHON_VERSION_MAJOR}_FOUND)
  endif(NOT Boost_PYTHON_FOUND)
  if(NOT Boost_PYTHON_FOUND)
    message(STATUS "Trying to find libboost_python${PYTHON_VERSION_MAJOR}")
    find_package(Boost 1.36.0 COMPONENTS
      "python${PYTHON_VERSION_MAJOR}")
    if(Boost_PYTHON${PYTHON_VERSION_MAJOR}_FOUND)
      set(Boost_PYTHON_FOUND ON)
      set(Boost_PYTHON_LIBRARY "${Boost_PYTHON${PYTHON_VERSION_MAJOR}_LIBRARY}")
      if(enable-numpy-support)
        find_package(Boost 1.36.0 COMPONENTS
          "numpy${PYTHON_VERSION_MAJOR}")
        if(Boost_NUMPY${PYTHON_VERSION_MAJOR}_FOUND)
          set(Boost_NUMPY_FOUND ON)
          set(Boost_NUMPY_LIBRARY "${Boost_NUMPY${PYTHON_VERSION_MAJOR}_LIBRARY}")
        endif(Boost_NUMPY${PYTHON_VERSION_MAJOR}_FOUND)
      endif(enable-numpy-support)
    else(Boost_PYTHON${PYTHON_VERSION_MAJOR}_FOUND)
      set(Boost_PYTHON_FOUND OFF)
    endif(Boost_PYTHON${PYTHON_VERSION_MAJOR}_FOUND)
  endif(NOT Boost_PYTHON_FOUND)
  if(NOT Boost_PYTHON_FOUND)
    message(STATUS "Trying to find libboost_python")
    find_package(Boost 1.36.0 COMPONENTS python)
    if(Boost_PYTHON_FOUND)
      if(enable-numpy-support)
        find_package(Boost 1.36.0 COMPONENTS numpy)
        if(Boost_NUMPY_FOUND)
          message(STATUS "  numpy found ${Boost_NUMPY_LIBRARY}")
        else(Boost_NUMPY_FOUND)
          message(STATUS "  numpy *not* found")
        endif(Boost_NUMPY_FOUND)
        message(STATUS "Boost library python found (${Boost_PYTHON_LIBRARY}).")
      endif(enable-numpy-support)
    else(Boost_PYTHON_FOUND)
      message(FATAL_ERROR "Boost python libraries not found.\n"
	"Required packages are :" ${BOOST_MANDATORY_COMPONENTS})
    endif(Boost_PYTHON_FOUND)
  endif(NOT Boost_PYTHON_FOUND)
  if(Boost_NUMPY_FOUND)
    set(TFEL_NUMPY_SUPPORT ON)
  endif(Boost_NUMPY_FOUND)
  if(TFEL_USES_CONAN)
    if(NOT python-static-interpreter-workaround)
      set(TFEL_PYTHON_MODULES_PRIVATE_LINK_LIBRARIES
        ${CONAN_LIBS} ${PYTHON_LIBRARIES})
    else(python-static-interpreter-workaround)
      if(APPLE)
        set(TFEL_PYTHON_MODULES_PRIVATE_LINK_LIBRARIES
          ${CONAN_LIBS})
      else(APPLE)
        set(TFEL_PYTHON_MODULES_PRIVATE_LINK_LIBRARIES
          ${CONAN_LIBS} ${PYTHON_LIBRARIES})
      endif(APPLE)
    endif()
  else(TFEL_USES_CONAN)
    if(NOT python-static-interpreter-workaround)
      set(TFEL_PYTHON_MODULES_PRIVATE_LINK_LIBRARIES
        ${Boost_PYTHON_LIBRARY} ${PYTHON_LIBRARIES})
    else()
      if(APPLE)
        set(TFEL_PYTHON_MODULES_PRIVATE_LINK_LIBRARIES
          ${Boost_PYTHON_LIBRARY})
      else(APPLE)
        set(TFEL_PYTHON_MODULES_PRIVATE_LINK_LIBRARIES
          ${Boost_PYTHON_LIBRARY} ${PYTHON_LIBRARIES})
      endif(APPLE)
    endif()
  endif(TFEL_USES_CONAN)
  if(DEFINED TFEL_TMP_BUILD_SHARED_LIBS)
    unset(TFEL_TMP_BUILD_SHARED_LIBS)
    unset(BUILD_SHARED_LIBS)
  endif(DEFINED TFEL_TMP_BUILD_SHARED_LIBS)
