if(WIN32)
  if( CMAKE_SIZEOF_VOID_P EQUAL 8 )
    set(CASTEM_CPPFLAGS "-DWIN64")
  else( CMAKE_SIZEOF_VOID_P EQUAL 8 )
    set(CASTEM_CPPFLAGS "-DWIN32")
  endif( CMAKE_SIZEOF_VOID_P EQUAL 8 )
endif(WIN32)
if(UNIX)
  if(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
    if( CMAKE_SIZEOF_VOID_P EQUAL 8 )
      set(CASTEM_CPPFLAGS "-DLINUX64 -DUNIX64 -DTHREAD")
      tfel_add_c_cxx_definitions("CASTEM_UNIX_TYPE=UNIX64")
    else( CMAKE_SIZEOF_VOID_P EQUAL 8 )
      set(CASTEM_CPPFLAGS "-DLINUX32 -DUNIX32 -DTHREAD")
      tfel_add_c_cxx_definitions("CASTEM_UNIX_TYPE=UNIX32")
    endif( CMAKE_SIZEOF_VOID_P EQUAL 8 )
  else(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
    if( CMAKE_SIZEOF_VOID_P EQUAL 8 )
      set(CASTEM_CPPFLAGS "-DSUN -DUNIX64 -DTHREAD")
      tfel_add_c_cxx_definitions("CASTEM_UNIX_TYPE=UNIX64")
    else( CMAKE_SIZEOF_VOID_P EQUAL 8 )
      set(CASTEM_CPPFLAGS "-DSUN -DUNIX32 -DTHREAD")
      tfel_add_c_cxx_definitions("CASTEM_UNIX_TYPE=UNIX32")
    endif( CMAKE_SIZEOF_VOID_P EQUAL 8 )
  endif(${CMAKE_SYSTEM_NAME} MATCHES "Linux")
endif(UNIX)
tfel_add_c_cxx_definitions("CASTEM_CPPFLAGS=\"${CASTEM_CPPFLAGS}\"")
add_definitions("${CASTEM_CPPFLAGS}")
