import type { Lang } from "./fenced.ts";

// prettier-ignore
export const languages: Lang[] = [
  { candidates: ["batchfile", "bat", "batch"] },
  { candidates: ["bibtex"] },
  { candidates: ["c", "h"] },
  { candidates: ["clojure", "clj", "cljs"] },
  { candidates: ["coffee", "Cakefile", "coffee.erb"] },
  { candidates: ["cpp", "c++", "cxx"] },
  { candidates: ["css", "css.erb"] },
  { candidates: ["cs", "csharp", "c#"] },
  { candidates: ["dart"] },
  { candidates: ["diff", "patch", "rej"] },
  { candidates: ["dockerfile", "Dockerfile"] },
  { candidates: ["elixir"] },
  { candidates: ["erlang"] },
  { candidates: ["fs", "fsharp", "f#"] },
  { /* Git Commit */ as: "text.git-commit", candidates: ["git-commit", "COMMIT_EDITMSG", "MERGE_MSG"] },
  { /* Git Rebase */ as: "text.git-rebase", candidates: ["git-rebase", "git-rebase-todo"] },
  { candidates: ["go", "golang"] },
  { candidates: ["groovy", "gvy"] },
  { /* Handlebars */ as: "text.html.handlebars", candidates: ["handlebars", "hbs"] },
  { /* HTML */ as: "text.html.basic", candidates: ["html", "htm", "shtml", "xhtml", "inc", "tmpl", "tpl"] },
  { candidates: ["ini", "conf"] },
  { candidates: ["java", "bsh"] },
  { candidates: ["js", "jsx", "javascript", "es6", "mjs", "cjs", "dataviewjs"] },
  { /* JSON with Comments */ as: "source.json.comments", candidates: ["jsonc"] },
  { candidates: ["json", "json5", "sublime-settings", "sublime-menu", "sublime-keymap", "sublime-mousemap", "sublime-theme", "sublime-build", "sublime-project", "sublime-completions"] },
  { candidates: ["julia"] },
  { /* LaTeX */ as: "text.tex.latex", candidates: ["latex", "tex"] },
  { /* Less */ as: "source.css.less", candidates: ["less"] },
  { /* Log */ as: "text.log", candidates: ["log"] },
  { candidates: ["lua"] },
  { candidates: ["makefile", "makefile", "GNUmakefile", "OCamlMakefile"] },
  { /* Markdown */ as: "text.html.markdown", candidates: ["markdown", "md"] },
  { candidates: ["objc", "objective-c", "mm", "obj-c", "m"] },
  { candidates: ["perl", "pl", "pm", "pod", "t", "PL", "psgi", "vcl"] },
  { /* Perl 6 */ as: "source.perl.6", candidates: ["perl6", "p6", "pl6", "pm6", "nqp"] },
  { /* PHP */ as: ["text.html.basic", "source.php"], candidates: ["php", "php", "php3", "php4", "php5", "phtml", "aw", "ctp"] },
  { candidates: ["powershell", "ps1", "psm1", "psd1"] },
  { /* Pug */ as: "text.pug", candidates: ["pug", "jade"] },
  { candidates: ["r", "R", "r", "s", "S", "Rprofile"] },
  { /* Regexp (JavaScript) */ as: "source.js.regexp", candidates: ["regexp"] },
  { /* Regexp (Python) */ as: "source.regexp.python", candidates: ["re"] },
  { candidates: ["ruby", "rb", "rbx", "rjs", "Rakefile", "rake", "cgi", "fcgi", "gemspec", "irbrc", "Capfile", "ru", "prawn", "Cheffile", "Gemfile", "Guardfile", "Hobofile", "Vagrantfile", "Appraisals", "Rantfile", "Berksfile", "Berksfile.lock", "Thorfile", "Puppetfile"] },
  { /* SCSS */ as: "source.css.scss", candidates: ["scss"] },
  { candidates: ["sql", "ddl", "dml"] },
  { candidates: ["swift"] },
  { candidates: ["typst", "typ"] },
  { candidates: ["typst-code", "typc"] },
  { /* XML */ as: "text.xml", candidates: ["xml", "xsd", "tld", "jsp", "pt", "cpt", "dtml", "rss", "opml"] },
  { /* XSL */ as: "text.xml.xsl", candidates: ["xsl", "xslt"] },
  { candidates: ["yaml", "yml"] },
  { candidates: ["python", "py", "py3", "rpy", "pyw", "cpy", "SConstruct", "Sconstruct", "sconstruct", "SConscript", "gyp", "gypi"] },
  { candidates: ["rust", "rs"] },
  { candidates: ["scala", "sbt"] },
  { candidates: ["shell", "sh", "bash", "zsh", "bashrc", "bash_profile", "bash_login", "profile", "bash_logout", ".textmate_init"] },
  { candidates: ["ts", "typescript"] },
  { candidates: ["tsx"] },
  { candidates: ["twig"] },
  { /* VB */ as: "source.asp.vb.net", candidates: ["vb"] },
]
