# bat

> 파일을 출력하고 연결.
> 구문 강조 및 Git 통합 기능을 갖춘 `cat`을 클론.
> 더 많은 정보: <https://manned.org/bat>.

- 하나 이상의 파일 내용을 `stdout`으로 깔끔하게 출력:

`bat {{경로/대상/파일1 경로/대상/파일2 ...}}`

- 여러 파일을 대상 파일에 연결:

`bat {{경로/대상/파일1 경로/대상/파일2 ...}} > {{경로/대상/대상_파일}}`

- 꾸밈을 제거하고 페이징을 비활성화 (`--style plain`은 `-p`로 대체되거나, 두 옵션 모두 `-pp`로 대체될 수 있음):

`bat --style plain --pager never {{경로/대상/파일}}`

- 배경색이 다른 특정 줄이나 범위를 강조 표시:

`bat {{-H|--highlight-line}} {{10|5:10|:10|10:|10:+5}} {{경로/대상/파일}}`

- 공백, 탭, 개행 문자 등 출력할 수 없는 문자 표시:

`bat {{[-A|--show-all]}} {{경로/대상/파일}}`

- 출력에서 줄 번호를 제외한 모든 꾸밈을 제거:

`bat {{[-n|--number]}} {{경로/대상/파일}}`

- 구문은 언어를 명시적으로 설정하여 JSON 파일을 강조 표시:

`bat {{[-l|--language]}} json {{경로/대상/파일.json}}`

- 지원되는 모든 언어 표시:

`bat {{[-L|--list-languages]}}`
