# git push

> 로컬 커밋을 원격 저장소로 푸시합니다.
> 더 많은 정보: <https://git-scm.com/docs/git-push>.

- 현재 브랜치의 로컬 변경 사항을 기본 원격 상대 브랜치에 보내기:

`git push`

- 특정 로컬 브랜치에서 해당 원격 상대 브랜치로 변경 사항 보내기:

`git push {{원격_이름}} {{로컬_브랜치}}`

- 특정 로컬 브랜치에서 해당 원격 상대 브랜치로 변경 사항을 보내고, 원격 브랜치를 로컬 브랜치의 기본 푸시/풀 대상으로 설정:

`git push {{[-u|--set-upstream]}} {{원격_이름}} {{로컬_브랜치}}`

- 특정 로컬 브랜치에서 특정 원격 브랜치로 변경 사항 보내기:

`git push {{원격_이름}} {{로컬_브랜치}}:{{원격_브랜치}}`

- 모든 로컬 브랜치의 변경 사항을 주어진 원격 저장소의 상대 브랜치로 보내기:

`git push --all {{원격_이름}}`

- 원격 저장소에서 브랜치 삭제:

`git push {{원격_이름}} {{[-d|--delete]}} {{원격_브랜치}}`

- 로컬과 대응되는 원격 브랜치가 없는 원격 브랜치 제거:

`git push --prune {{원격_이름}}`

- 아직 원격 저장소에 없는 태그 게시:

`git push --tags`
