# 2to3

> Geautomatiseerde conversie van Python 2 naar 3-code.
> Deze module is sinds 3.11 verouderd en is sinds 3.13 verwijderd.
> Ter referentie: <https://github.com/python/cpython/blob/8d42e2d915c3096e7e7ac1c649751d1da567bb7c3/doc/whatsnew/3.13.rst?plain=188>.
> Meer informatie: <https://manned.org/2to3>.

- Geef de wijzigingen weer die zouden worden uitgevoerd zonder ze uit te voeren (simulatie):

`2to3 {{pad/naar/bestand.py}}`

- Converteer een Python 2-bestand naar Python 3:

`2to3 {{[-w|--write]}} {{pad/naar/bestand.py}}`

- Converteer specifieke Python 2-taalfuncties naar Python 3:

`2to3 {{[-w|--write]}} {{pad/naar/bestand.py}} {{[-f|--fix]}} {{raw_input}} {{[-f|--fix]}} {{print}}`

- Converteer alle Python 2-taalfuncties behalve de gespecificeerde naar Python 3:

`2to3 {{[-w|--write]}} {{pad/naar/bestand.py}} {{[-x|--nofix]}} {{has_key}} {{[-x|--nofix]}} {{isinstance}}`

- Geef een lijst weer met alle beschikbare taalfuncties die kunnen worden geconverteerd van Python 2 naar Python 3:

`2to3 {{[-l|--list-fixes]}}`

- Converteer alle Python 2-bestanden in een map naar Python 3:

`2to3 {{[-o|--output-dir]}} {{pad/naar/python3_map}} {{[-W|--write-unchanged-files]}} {{[-n|--nobackups]}} {{pad/naar/python2_map}}`

- Voer 2to3 uit met meerdere threads:

`2to3 {{[-j|--processes]}} {{4}} {{[-o|--output-dir]}} {{pad/naar/python3_map}} {{[-w|--write]}} {{[-n|--nobackups]}} --no-diffs {{pad/naar/python2_map}}`
