# ncat

> 네트워크를 통해 데이터를 읽고, 쓰고, 리디렉션하고, 암호화.
> 유사한 유틸리티 `netcat`/`nc`의 대체 구현.
> 더 많은 정보: <https://nmap.org/ncat/guide/index.html>.

- 지정된 포트에서 입력을 대기하고 지정된 파일에 기록:

`ncat -l {{포트}} > {{경로/대상/파일}}`

- 여러 연결을 수락하고 닫힌 후에도 ncat을 열어 두기:

`ncat -lk {{포트}}`

- 지정된 파일의 출력을 지정된 호스트의 지정된 포트로 전송:

`ncat {{주소}} {{포트}} < {{경로/대상/파일}}`

- 암호화된 채널에서 여러 수신 연결을 수락하여 트래픽 내용을 탐지하지 않도록 회피:

`ncat --ssl -k -l {{포트}}`

- SSL을 통해 열린 `ncat` 연결에 접속:

`ncat --ssl {{호스트}} {{포트}}`

- 특정 포트로 원격 호스트에 연결 가능 여부를 타임아웃과 함께 확인:

`ncat -w {{초}} -vz {{호스트}} {{포트}}`
