// Copyright 2017 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Generated by tools/bigint-tester.py.

var data = [{
  a: 0x211a34fn,
  b: 0xa6n,
  r: 0n
}, {
  a: 0xa0d0aff5d2783ad192f37423n,
  b: 0x7n,
  r: 0x141a15feba4f075a325e6e8n
}, {
  a: -0x68ba010a12ed551fc17c67f63331eea3n,
  b: 0xae5n,
  r: -0x1n
}, {
  a: 0xb64dc8009n,
  b: 0xf1n,
  r: 0n
}, {
  a: -0x364cdec628e438712e4f8cb7an,
  b: 0x48cn,
  r: -0x1n
}, {
  a: -0xb417099aba80a783f52790b779b38c2e6fbdf5f490d7b02a59e81032een,
  b: 0x6a3n,
  r: -0x1n
}, {
  a: 0x9d2b41n,
  b: 0n,
  r: 0x9d2b41n
}, {
  a: -0x4a070c83b02ba86434228a50cbaf50ddf38n,
  b: -0x63n,
  r: -0x25038641d815d4321a11452865d7a86ef9c0000000000000000000000000n
}, {
  a: 0x3e76514036ccb958c98f60n,
  b: -0x76n,
  r: 0xf9d94500db32e563263d8000000000000000000000000000000n
}, {
  a: -0x51fe20d47ba564bc09337d5c8d284deb5006549bad2629230198f34n,
  b: -0xfn,
  r: -0x28ff106a3dd2b25e0499beae469426f5a8032a4dd693149180cc79a0000n
}, {
  a: 0x49adce1d09dadc5a0635f24d066d3a29e37b9be6059b88d0239d6ca6d92267a372n,
  b: -0x6n,
  r: 0x126b73874276b716818d7c93419b4e8a78dee6f98166e23408e75b29b64899e8dc80n
}, {
  a: 0xca19971406fb07cn,
  b: -0x17n,
  r: 0x650ccb8a037d83e000000n
}, {
  a: 0xd8de8f631313b1f98f77d265ee48014f82eb20n,
  b: 0xen,
  r: 0x3637a3d8c4c4ec7e63ddf4997b920053e0bn
}, {
  a: -0x550d3470c8ad9b8f22ed01a4b1d3f648n,
  b: -0x4dn,
  r: -0xaa1a68e1915b371e45da034963a7ec900000000000000000000n
}, {
  a: -0xa7eadcd4a1b8037081952f0a9199n,
  b: -0xcfn,
  r: -0x53f56e6a50dc01b840ca978548cc8000000000000000000000000000000000000000000000000000n
}, {
  a: -0x65b3933c9e1eb5f953f6cc55cn,
  b: 0xa6cn,
  r: -0x1n
}, {
  a: -0x92cea858475460661a2831a28434bde95e5132e1dcaeb161ec89bd9555f41n,
  b: -0xbn,
  r: -0x4967542c23aa30330d1418d1421a5ef4af289970ee5758b0f644decaaafa0800n
}, {
  a: -0x1d838ade17fe571916a26314b6a8b42e9b6e2b74238de734d6f5575df7n,
  b: -0x7n,
  r: -0xec1c56f0bff2b8c8b51318a5b545a174db715ba11c6f39a6b7aabaefb80n
}, {
  a: 0xdd5bf8581e32875d44e26ef10c45bdff68d209015933586dc37211n,
  b: -0xa9n,
  r: 0x1bab7f0b03c650eba89c4dde2188b7bfed1a41202b266b0db86e422000000000000000000000000000000000000000000n
}, {
  a: -0xa92d3014dcn,
  b: -0x4cn,
  r: -0xa92d3014dc0000000000000000000n
}];

var error_count = 0;
for (var i = 0; i < data.length; i++) {
  var d = data[i];
  var r = d.a >> d.b;
  if (d.r !== r) {
    print("Input A:  " + d.a.toString(16));
    print("Input B:  " + d.b.toString(16));
    print("Result:   " + r.toString(16));
    print("Expected: " + d.r);
    print("Op: >>");
    error_count++;
  }
}
if (error_count !== 0) {
  print("Finished with " + error_count + " errors.")
  quit(1);
}
