// Copyright 2021 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Test the calling of the effect of CanonicalizeUnicodeLocaleId(code).
// in step 1.c of
// https://tc39.es/ecma402/#sec-canonicalcodefordisplaynames
//
// The following Data generated by
// METAFILE="third_party/icu/source/data/misc/metadata.txt"
// egrep "^[ ]{12}[a-z]{2,3}(_[a-z]{4})?(_[A-Za-z]{2})?(_[a-z]{5,8})*{" $METAFILE | \
//   sed -e "s/^ */ \"/g" | tr "_{\n" "-\"," |fold -s -w 70
//
let testCases = [
"aa-saaho", "aam", "aar", "abk", "adp", "afr", "agp", "ais", "aju",
"aka", "alb", "als", "amh", "ara", "arb", "arg", "arm", "art-lojban",
"asd", "asm", "aue", "ava", "ave", "aym", "ayr", "ayx", "aze", "azj",
"bak", "bam", "baq", "baz", "bcc", "bcl", "bel", "ben", "bgm", "bh",
"bhk", "bih", "bis", "bjd", "bjq", "bkb", "bod", "bos", "bre", "btb",
"bul", "bur", "bxk", "bxr", "cat", "ccq", "cel-gaulish", "ces",
"cha", "che", "chi", "chu", "chv", "cjr", "cka", "cld", "cmk", "cmn",
"cnr", "cor", "cos", "coy", "cqu", "cre", "cwd", "cym", "cze", "daf",
"dan", "dap", "deu", "dgo", "dhd", "dik", "diq", "dit", "div", "djl",
"dkl", "drh", "drr", "drw", "dud", "duj", "dut", "dwl", "dzo", "ekk",
"ell", "elp", "emk", "eng", "epo", "esk", "est", "eus", "ewe", "fao",
"fas", "fat", "fij", "fin", "fra", "fre", "fry", "fuc", "ful", "gav",
"gaz", "gbc", "gbo", "geo", "ger", "gfx", "ggn", "ggo", "ggr", "gio",
"gla", "gle", "glg", "gli", "glv", "gno", "gre", "grn", "gti", "gug",
"guj", "guv", "gya", "hat", "hau", "hbs", "hdn", "hea", "heb", "her",
"him", "hin", "hmo", "hrr", "hrv", "hun", "hy-arevmda", "hye", "ibi",
"ibo", "ice", "ido", "iii", "ike", "iku", "ile", "ill", "ilw", "in",
"ina", "ind", "ipk", "isl", "ita", "iw", "izi", "jar", "jav", "jeg",
"ji", "jpn", "jw", "kal", "kan", "kas", "kat", "kau", "kaz", "kdv",
"kgc", "kgd", "kgh", "khk", "khm", "kik", "kin", "kir", "kmr", "knc",
"kng", "knn", "koj", "kom", "kon", "kor", "kpp", "kpv", "krm", "ktr",
"kua", "kur", "kvs", "kwq", "kxe", "kxl", "kzh", "kzj", "kzt", "lao",
"lat", "lav", "lbk", "leg", "lii", "lim", "lin", "lit", "llo", "lmm",
"ltz", "lub", "lug", "lvs", "mac", "mah", "mal", "mao", "mar", "may",
"meg", "mgx", "mhr", "mkd", "mlg", "mlt", "mnk", "mnt", "mo", "mof",
"mol", "mon", "mri", "msa", "mst", "mup", "mwd", "mwj", "mya", "myd",
"myt", "nad", "nau", "nav", "nbf", "nbl", "nbx", "ncp", "nde", "ndo",
"nep", "nld", "nln", "nlr", "nno", "nns", "nnx", "no", "no-bokmal",
"no-nynorsk", "nob", "noo", "nor", "npi", "nts", "nxu", "nya", "oci",
"ojg", "oji", "ori", "orm", "ory", "oss", "oun", "pan", "pbu", "pcr",
"per", "pes", "pli", "plt", "pmc", "pmu", "pnb", "pol", "por", "ppa",
"ppr", "prs", "pry", "pus", "puz", "que", "quz", "rmr", "rmy", "roh",
"ron", "rum", "run", "rus", "sag", "san", "sap", "sca", "scc", "scr",
"sgl", "sgn-BR", "sgn-CO", "sgn-DE", "sgn-DK", "sgn-ES", "sgn-FR",
"sgn-GB", "sgn-GR", "sgn-IE", "sgn-IT", "sgn-JP", "sgn-MX", "sgn-NI",
"sgn-NL", "sgn-NO", "sgn-PT", "sgn-SE", "sgn-US", "sgn-ZA", "sh",
"sin", "skk", "slk", "slo", "slv", "sme", "smo", "sna", "snd", "som",
"sot", "spa", "spy", "sqi", "src", "srd", "srp", "ssw", "sul", "sum",
"sun", "swa", "swc", "swe", "swh", "tah", "tam", "tat", "tdu", "tel",
"tgg", "tgk", "tgl", "tha", "thc", "thw", "thx", "tib", "tid", "tie",
"tir", "tkk", "tl", "tlw", "tmp", "tne", "tnf", "ton", "tsf", "tsn",
"tso", "ttq", "tuk", "tur", "tw", "twi", "uig", "ukr", "umu",
"und-aaland", "und-arevela", "und-arevmda", "und-bokmal",
"und-hakka", "und-hepburn-heploc", "und-lojban", "und-nynorsk",
"und-saaho", "und-xiang", "unp", "uok", "urd", "uzb", "uzn", "ven",
"vie", "vol", "wel", "wgw", "wit", "wiw", "wln", "wol", "xba", "xho",
"xia", "xkh", "xpe", "xrq", "xsj", "xsl", "ybd", "ydd", "yen", "yid",
"yiy", "yma", "ymt", "yor", "yos", "yuu", "zai", "zh-guoyu",
"zh-hakka", "zh-xiang", "zha", "zho", "zir", "zsm", "zul", "zyb",
"fra", "frb", "frc", "frd", "fre", "frf", "frg", "frh", "fri", "frj",
"frk", "frl", "frm", "frn", "fro", "frp", "frq", "frr", "frs", "frt",
"fru", "frv", "lud", "lug", "lul", "nzn", "nzs",
    ];
let dn = new Intl.DisplayNames("en", {type: "language"})
testCases.forEach(function(locale) {
  assertEquals(dn.of(new Intl.Locale(locale)), dn.of(locale))
})
