// Copyright 2024 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/*
This file is autogenerated from the antlr grammar fuzzer_regexp_grammar.g4

To regenerate this file, you need fuzztest:
https://github.com/google/fuzztest

Create a bazel BUILD file with a target for this grammar:
cc_fuzztest_grammar_library(
    name = "regex_grammar",
    srcs = ["fuzzer_regexp_grammar.g4"],
    top_level_rule = "pattern",
)

Build it and copy over the resulting file:
bazel build :regex_grammar
*/

#ifndef FUZZTEST_GRAMMARS_PATTERN_GRAMMAR_H_
#define FUZZTEST_GRAMMARS_PATTERN_GRAMMAR_H_

#include "./fuzztest/internal/domains/in_grammar_impl.h"

namespace fuzztest::internal::grammar::pattern {

enum PatternTypes {
  kSourceCharacterNode,
  kIdentifierStartCharNode,
  kIdentifierPartCharNode,
  kAsciiLetterNode,
  kNumericLiteralSeparatorNode,
  kDecimalDigitsNode,
  kDecimalDigitNode,
  kNonZeroDigitNode,
  kHexDigitNode,
  kHexDigitsNode,
  kCodePointNode,
  kHexEscapeSequenceNode,
  kHex4DigitsNode,
  kPatternNode,
  kDisjunctionNode,
  kAlternativeNode,
  kTermNode,
  kAssertionNode,
  kQuantifierNode,
  kQuantifierPrefixNode,
  kAtomNode,
  kSyntaxCharacterNode,
  kPatternCharacterNode,
  kAtomEscapeNode,
  kCharacterEscapeNode,
  kControlEscapeNode,
  kGroupSpecifierNode,
  kGroupNameNode,
  kRegExpIdentifierNameNode,
  kRegExpIdentifierStartNode,
  kRegExpIdentifierPartNode,
  kRegExpUnicodeEscapeSequenceNode,
  kUnicodeLeadSurrogateNode,
  kUnicodeTrailSurrogateNode,
  kHexLeadSurrogateNode,
  kHexTrailSurrogateNode,
  kHexNonSurrogateNode,
  kIdentityEscapeNode,
  kDecimalEscapeNode,
  kCharacterClassEscapeNode,
  kUnicodePropertyValueExpressionNode,
  kUnicodePropertyNameNode,
  kUnicodePropertyNameCharactersNode,
  kUnicodePropertyValueNode,
  kLoneUnicodePropertyNameOrValueNode,
  kUnicodePropertyValueCharactersNode,
  kUnicodePropertyValueCharacterNode,
  kUnicodePropertyNameCharacterNode,
  kCharacterClassNode,
  kClassContentsNode,
  kNonemptyClassRangesNode,
  kNonemptyClassRangesNoDashNode,
  kClassAtomNode,
  kClassAtomNoDashNode,
  kClassEscapeNode,
  kClassSetExpressionNode,
  kClassUnionNode,
  kClassIntersectionNode,
  kClassSubtractionNode,
  kClassSetRangeNode,
  kClassSetOperandNode,
  kNestedClassNode,
  kClassStringDisjunctionNode,
  kClassStringDisjunctionContentsNode,
  kClassStringNode,
  kNonEmptyClassStringNode,
  kClassSetCharacterNode,
  kClassSetReservedDoublePunctuatorNode,
  kClassSetSyntaxCharacterNode,
  kClassSetReservedPunctuatorNode,
  kDecimalDigitsSubNode0,
  kDecimalDigitsSubNode1,
  kDecimalDigitsSubNode3,
  kDecimalDigitsSubNode4,
  kDecimalDigitsSubNode2,
  kHexDigitsSubNode5,
  kHexDigitsSubNode7,
  kHexDigitsSubNode8,
  kHexDigitsSubNode6,
  kHexEscapeSequenceSubNode9,
  kHexEscapeSequenceSubNode10,
  kDisjunctionSubNode11,
  kAlternativeSubNode12,
  kTermSubNode13,
  kTermSubNode14,
  kAssertionSubNode15,
  kAssertionSubNode16,
  kAssertionSubNode17,
  kAssertionSubNode18,
  kAssertionSubNode19,
  kAssertionSubNode20,
  kQuantifierSubNode21,
  kQuantifierPrefixSubNode22,
  kQuantifierPrefixSubNode23,
  kQuantifierPrefixSubNode24,
  kAtomSubNode25,
  kAtomSubNode26,
  kAtomSubNode27,
  kAtomSubNode28,
  kAtomEscapeSubNode29,
  kCharacterEscapeSubNode30,
  kRegExpIdentifierNameSubNode31,
  kRegExpIdentifierStartSubNode32,
  kRegExpIdentifierStartSubNode33,
  kRegExpIdentifierPartSubNode34,
  kRegExpIdentifierPartSubNode35,
  kRegExpUnicodeEscapeSequenceSubNode36,
  kRegExpUnicodeEscapeSequenceSubNode37,
  kRegExpUnicodeEscapeSequenceSubNode38,
  kRegExpUnicodeEscapeSequenceSubNode39,
  kRegExpUnicodeEscapeSequenceSubNode40,
  kRegExpUnicodeEscapeSequenceSubNode41,
  kDecimalEscapeSubNode42,
  kCharacterClassEscapeSubNode43,
  kUnicodePropertyValueExpressionSubNode44,
  kUnicodePropertyNameCharactersSubNode45,
  kUnicodePropertyValueCharactersSubNode46,
  kCharacterClassSubNode47,
  kClassContentsSubNode48,
  kClassContentsSubNode49,
  kNonemptyClassRangesSubNode50,
  kNonemptyClassRangesSubNode51,
  kNonemptyClassRangesNoDashSubNode52,
  kNonemptyClassRangesNoDashSubNode53,
  kClassAtomNoDashSubNode54,
  kClassUnionSubNode55,
  kClassUnionSubNode56,
  kClassUnionSubNode57,
  kClassUnionSubNode58,
  kClassIntersectionSubNode59,
  kClassIntersectionSubNode60,
  kClassSubtractionSubNode61,
  kClassSubtractionSubNode62,
  kNestedClassSubNode63,
  kNestedClassSubNode64,
  kNestedClassSubNode65,
  kClassStringDisjunctionContentsSubNode66,
  kNonEmptyClassStringSubNode67,
  kClassSetCharacterSubNode68,
  kClassSetCharacterSubNode69,
  kClassSetCharacterSubNode70,
  kLiteral15,
  kLiteral16,
  kLiteral0,
  kLiteral17,
  kLiteral18,
  kLiteral14,
  kLiteral43,
  kLiteral38,
  kLiteral44,
  kLiteral40,
  kLiteral39,
  kLiteral36,
  kLiteral37,
  kLiteral19,
  kLiteral20,
  kLiteral41,
  kLiteral21,
  kLiteral8,
  kLiteral50,
  kLiteral2,
  kLiteral22,
  kLiteral7,
  kLiteral3,
  kLiteral23,
  kLiteral24,
  kLiteral5,
  kLiteral25,
  kLiteral48,
  kLiteral26,
  kLiteral6,
  kLiteral27,
  kLiteral4,
  kLiteral28,
  kLiteral29,
  kLiteral35,
  kLiteral9,
  kLiteral47,
  kLiteral10,
  kLiteral49,
  kLiteral30,
  kLiteral1,
  kLiteral31,
  kLiteral11,
  kLiteral46,
  kLiteral45,
  kLiteral12,
  kLiteral33,
  kLiteral34,
  kLiteral42,
  kLiteral13,
  kLiteral32,
  kCharSet0,
  kCharSet17,
  kCharSet16,
  kCharSet9,
  kCharSet5,
  kCharSet7,
  kCharSet6,
  kCharSet15,
  kCharSet2,
  kCharSet1,
  kCharSet3,
  kCharSet12,
  kCharSet13,
  kCharSet10,
  kCharSet8,
  kCharSet4,
  kCharSet14,
  kCharSet11,
  kCharSet18,
};
class SourceCharacterNode;
class IdentifierStartCharNode;
class IdentifierPartCharNode;
class AsciiLetterNode;
class NumericLiteralSeparatorNode;
class DecimalDigitsNode;
class DecimalDigitNode;
class NonZeroDigitNode;
class HexDigitNode;
class HexDigitsNode;
class CodePointNode;
class HexEscapeSequenceNode;
class Hex4DigitsNode;
class PatternNode;
class DisjunctionNode;
class AlternativeNode;
class TermNode;
class AssertionNode;
class QuantifierNode;
class QuantifierPrefixNode;
class AtomNode;
class SyntaxCharacterNode;
class PatternCharacterNode;
class AtomEscapeNode;
class CharacterEscapeNode;
class ControlEscapeNode;
class GroupSpecifierNode;
class GroupNameNode;
class RegExpIdentifierNameNode;
class RegExpIdentifierStartNode;
class RegExpIdentifierPartNode;
class RegExpUnicodeEscapeSequenceNode;
class UnicodeLeadSurrogateNode;
class UnicodeTrailSurrogateNode;
class HexLeadSurrogateNode;
class HexTrailSurrogateNode;
class HexNonSurrogateNode;
class IdentityEscapeNode;
class DecimalEscapeNode;
class CharacterClassEscapeNode;
class UnicodePropertyValueExpressionNode;
class UnicodePropertyNameNode;
class UnicodePropertyNameCharactersNode;
class UnicodePropertyValueNode;
class LoneUnicodePropertyNameOrValueNode;
class UnicodePropertyValueCharactersNode;
class UnicodePropertyValueCharacterNode;
class UnicodePropertyNameCharacterNode;
class CharacterClassNode;
class ClassContentsNode;
class NonemptyClassRangesNode;
class NonemptyClassRangesNoDashNode;
class ClassAtomNode;
class ClassAtomNoDashNode;
class ClassEscapeNode;
class ClassSetExpressionNode;
class ClassUnionNode;
class ClassIntersectionNode;
class ClassSubtractionNode;
class ClassSetRangeNode;
class ClassSetOperandNode;
class NestedClassNode;
class ClassStringDisjunctionNode;
class ClassStringDisjunctionContentsNode;
class ClassStringNode;
class NonEmptyClassStringNode;
class ClassSetCharacterNode;
class ClassSetReservedDoublePunctuatorNode;
class ClassSetSyntaxCharacterNode;
class ClassSetReservedPunctuatorNode;
class DecimalDigitsSubNode0;
class DecimalDigitsSubNode1;
class DecimalDigitsSubNode3;
class DecimalDigitsSubNode4;
class DecimalDigitsSubNode2;
class HexDigitsSubNode5;
class HexDigitsSubNode7;
class HexDigitsSubNode8;
class HexDigitsSubNode6;
class HexEscapeSequenceSubNode9;
class HexEscapeSequenceSubNode10;
class DisjunctionSubNode11;
class AlternativeSubNode12;
class TermSubNode13;
class TermSubNode14;
class AssertionSubNode15;
class AssertionSubNode16;
class AssertionSubNode17;
class AssertionSubNode18;
class AssertionSubNode19;
class AssertionSubNode20;
class QuantifierSubNode21;
class QuantifierPrefixSubNode22;
class QuantifierPrefixSubNode23;
class QuantifierPrefixSubNode24;
class AtomSubNode25;
class AtomSubNode26;
class AtomSubNode27;
class AtomSubNode28;
class AtomEscapeSubNode29;
class CharacterEscapeSubNode30;
class RegExpIdentifierNameSubNode31;
class RegExpIdentifierStartSubNode32;
class RegExpIdentifierStartSubNode33;
class RegExpIdentifierPartSubNode34;
class RegExpIdentifierPartSubNode35;
class RegExpUnicodeEscapeSequenceSubNode36;
class RegExpUnicodeEscapeSequenceSubNode37;
class RegExpUnicodeEscapeSequenceSubNode38;
class RegExpUnicodeEscapeSequenceSubNode39;
class RegExpUnicodeEscapeSequenceSubNode40;
class RegExpUnicodeEscapeSequenceSubNode41;
class DecimalEscapeSubNode42;
class CharacterClassEscapeSubNode43;
class UnicodePropertyValueExpressionSubNode44;
class UnicodePropertyNameCharactersSubNode45;
class UnicodePropertyValueCharactersSubNode46;
class CharacterClassSubNode47;
class ClassContentsSubNode48;
class ClassContentsSubNode49;
class NonemptyClassRangesSubNode50;
class NonemptyClassRangesSubNode51;
class NonemptyClassRangesNoDashSubNode52;
class NonemptyClassRangesNoDashSubNode53;
class ClassAtomNoDashSubNode54;
class ClassUnionSubNode55;
class ClassUnionSubNode56;
class ClassUnionSubNode57;
class ClassUnionSubNode58;
class ClassIntersectionSubNode59;
class ClassIntersectionSubNode60;
class ClassSubtractionSubNode61;
class ClassSubtractionSubNode62;
class NestedClassSubNode63;
class NestedClassSubNode64;
class NestedClassSubNode65;
class ClassStringDisjunctionContentsSubNode66;
class NonEmptyClassStringSubNode67;
class ClassSetCharacterSubNode68;
class ClassSetCharacterSubNode69;
class ClassSetCharacterSubNode70;
class Literal15;
class Literal16;
class Literal0;
class Literal17;
class Literal18;
class Literal14;
class Literal43;
class Literal38;
class Literal44;
class Literal40;
class Literal39;
class Literal36;
class Literal37;
class Literal19;
class Literal20;
class Literal41;
class Literal21;
class Literal8;
class Literal50;
class Literal2;
class Literal22;
class Literal7;
class Literal3;
class Literal23;
class Literal24;
class Literal5;
class Literal25;
class Literal48;
class Literal26;
class Literal6;
class Literal27;
class Literal4;
class Literal28;
class Literal29;
class Literal35;
class Literal9;
class Literal47;
class Literal10;
class Literal49;
class Literal30;
class Literal1;
class Literal31;
class Literal11;
class Literal46;
class Literal45;
class Literal12;
class Literal33;
class Literal34;
class Literal42;
class Literal13;
class Literal32;
class CharSet0;
class CharSet17;
class CharSet16;
class CharSet9;
class CharSet5;
class CharSet7;
class CharSet6;
class CharSet15;
class CharSet2;
class CharSet1;
class CharSet3;
class CharSet12;
class CharSet13;
class CharSet10;
class CharSet8;
class CharSet4;
class CharSet14;
class CharSet11;
class CharSet18;

inline constexpr absl::string_view kStrLiteral15 = "!!";
inline constexpr absl::string_view kStrLiteral16 = "##";
inline constexpr absl::string_view kStrLiteral0 = "$";
inline constexpr absl::string_view kStrLiteral17 = "$$";
inline constexpr absl::string_view kStrLiteral18 = "%%";
inline constexpr absl::string_view kStrLiteral14 = "&&";
inline constexpr absl::string_view kStrLiteral43 = "(";
inline constexpr absl::string_view kStrLiteral38 = "(?!";
inline constexpr absl::string_view kStrLiteral44 = "(?:";
inline constexpr absl::string_view kStrLiteral40 = "(?<!";
inline constexpr absl::string_view kStrLiteral39 = "(?<=";
inline constexpr absl::string_view kStrLiteral36 = "(?=";
inline constexpr absl::string_view kStrLiteral37 = ")";
inline constexpr absl::string_view kStrLiteral19 = "**";
inline constexpr absl::string_view kStrLiteral20 = "++";
inline constexpr absl::string_view kStrLiteral41 = ",";
inline constexpr absl::string_view kStrLiteral21 = ",,";
inline constexpr absl::string_view kStrLiteral8 = "-";
inline constexpr absl::string_view kStrLiteral50 = "--";
inline constexpr absl::string_view kStrLiteral2 = ".";
inline constexpr absl::string_view kStrLiteral22 = "..";
inline constexpr absl::string_view kStrLiteral7 = "/";
inline constexpr absl::string_view kStrLiteral3 = "0";
inline constexpr absl::string_view kStrLiteral23 = "::";
inline constexpr absl::string_view kStrLiteral24 = ";;";
inline constexpr absl::string_view kStrLiteral5 = "<";
inline constexpr absl::string_view kStrLiteral25 = "<<";
inline constexpr absl::string_view kStrLiteral48 = "=";
inline constexpr absl::string_view kStrLiteral26 = "==";
inline constexpr absl::string_view kStrLiteral6 = ">";
inline constexpr absl::string_view kStrLiteral27 = ">>";
inline constexpr absl::string_view kStrLiteral4 = "?";
inline constexpr absl::string_view kStrLiteral28 = "??";
inline constexpr absl::string_view kStrLiteral29 = "@@";
inline constexpr absl::string_view kStrLiteral35 = "B";
inline constexpr absl::string_view kStrLiteral9 = "[";
inline constexpr absl::string_view kStrLiteral47 = "\\\\u";
inline constexpr absl::string_view kStrLiteral10 = "]";
inline constexpr absl::string_view kStrLiteral49 = "^";
inline constexpr absl::string_view kStrLiteral30 = "^^";
inline constexpr absl::string_view kStrLiteral1 = "_";
inline constexpr absl::string_view kStrLiteral31 = "``";
inline constexpr absl::string_view kStrLiteral11 = "b";
inline constexpr absl::string_view kStrLiteral46 = "c";
inline constexpr absl::string_view kStrLiteral45 = "k";
inline constexpr absl::string_view kStrLiteral12 = "q{";
inline constexpr absl::string_view kStrLiteral33 = "u";
inline constexpr absl::string_view kStrLiteral34 = "u{";
inline constexpr absl::string_view kStrLiteral42 = "{";
inline constexpr absl::string_view kStrLiteral13 = "}";
inline constexpr absl::string_view kStrLiteral32 = "~~";
inline constexpr absl::string_view kStrCharSet0 = R"grammar(.)grammar";
inline constexpr absl::string_view kStrCharSet17 =
    R"grammar([&!#%,:;<=>@`~-])grammar";
inline constexpr absl::string_view kStrCharSet16 =
    R"grammar([()[\]{}/\\|-])grammar";
inline constexpr absl::string_view kStrCharSet9 = R"grammar([*+?])grammar";
inline constexpr absl::string_view kStrCharSet5 = R"grammar([0-9])grammar";
inline constexpr absl::string_view kStrCharSet7 =
    R"grammar([0-9a-fA-F])grammar";
inline constexpr absl::string_view kStrCharSet6 = R"grammar([1-9])grammar";
inline constexpr absl::string_view kStrCharSet15 = R"grammar([\\])grammar";
inline constexpr absl::string_view kStrCharSet2 =
    R"grammar([\p{Lu}\p{Ll}\p{Lt}\p{Lm}\p{Lo}\p{Nl}\p{Mn}\p{Mc}\p{Nd}\p{Pc}])grammar";
inline constexpr absl::string_view kStrCharSet1 =
    R"grammar([\p{Lu}\p{Ll}\p{Lt}\p{Lm}\p{Lo}\p{Nl}])grammar";
inline constexpr absl::string_view kStrCharSet3 =
    R"grammar([\x{200C}\x{200D}])grammar";
inline constexpr absl::string_view kStrCharSet12 =
    R"grammar([\x{D800}-\x{DBFF}])grammar";
inline constexpr absl::string_view kStrCharSet13 =
    R"grammar([\x{DC00}-\x{DFFF}])grammar";
inline constexpr absl::string_view kStrCharSet10 =
    R"grammar([^$\\.*+?()[\]{}|])grammar";
inline constexpr absl::string_view kStrCharSet8 = R"grammar([^$])grammar";
inline constexpr absl::string_view kStrCharSet4 = R"grammar([a-zA-Z])grammar";
inline constexpr absl::string_view kStrCharSet14 = R"grammar([dDsSwW])grammar";
inline constexpr absl::string_view kStrCharSet11 = R"grammar([fnrtv])grammar";
inline constexpr absl::string_view kStrCharSet18 = R"grammar([pP])grammar";

class SourceCharacterNode final
    : public TupleDomain<kSourceCharacterNode, CharSet0> {};
class IdentifierStartCharNode final
    : public VariantDomain<kIdentifierStartCharNode, 0, CharSet1, Literal0,
                           Literal1> {};
class IdentifierPartCharNode final
    : public VariantDomain<kIdentifierPartCharNode, 0, CharSet2, Literal0,
                           CharSet3> {};
class AsciiLetterNode final : public TupleDomain<kAsciiLetterNode, CharSet4> {};
class NumericLiteralSeparatorNode final
    : public TupleDomain<kNumericLiteralSeparatorNode, Literal1> {};
class DecimalDigitsNode final
    : public TupleDomain<kDecimalDigitsNode, DecimalDigitsSubNode0,
                         DecimalDigitsSubNode1> {};
class DecimalDigitNode final : public TupleDomain<kDecimalDigitNode, CharSet5> {
};
class NonZeroDigitNode final : public TupleDomain<kNonZeroDigitNode, CharSet6> {
};
class HexDigitNode final : public TupleDomain<kHexDigitNode, CharSet7> {};
class HexDigitsNode final
    : public TupleDomain<kHexDigitsNode, HexDigitsSubNode5> {};
class CodePointNode final : public TupleDomain<kCodePointNode, HexDigitsNode> {
};
class HexEscapeSequenceNode final
    : public VariantDomain<kHexEscapeSequenceNode, 0, HexEscapeSequenceSubNode9,
                           HexEscapeSequenceSubNode10> {};
class Hex4DigitsNode final
    : public TupleDomain<kHex4DigitsNode, HexDigitNode, HexDigitNode,
                         HexDigitNode, HexDigitNode> {};
class PatternNode final : public TupleDomain<kPatternNode, DisjunctionNode> {};
class DisjunctionNode final
    : public TupleDomain<kDisjunctionNode, DisjunctionSubNode11> {};
class AlternativeNode final
    : public TupleDomain<kAlternativeNode, AlternativeSubNode12> {};
class TermNode final
    : public VariantDomain<kTermNode, 0, AssertionNode, TermSubNode14> {};
class AssertionNode final
    : public VariantDomain<kAssertionNode, 0, CharSet8, AssertionSubNode15,
                           AssertionSubNode16, AssertionSubNode17,
                           AssertionSubNode18, AssertionSubNode19,
                           AssertionSubNode20> {};
class QuantifierNode final
    : public TupleDomain<kQuantifierNode, QuantifierPrefixNode,
                         QuantifierSubNode21> {};
class QuantifierPrefixNode final
    : public VariantDomain<kQuantifierPrefixNode, 0, CharSet9,
                           QuantifierPrefixSubNode24> {};
class AtomNode final
    : public VariantDomain<kAtomNode, 1, PatternCharacterNode, Literal2,
                           AtomSubNode25, CharacterClassNode, AtomSubNode27,
                           AtomSubNode28> {};
class SyntaxCharacterNode final
    : public TupleDomain<kSyntaxCharacterNode, CharSet10> {};
class PatternCharacterNode final
    : public TupleDomain<kPatternCharacterNode, SourceCharacterNode> {};
class AtomEscapeNode final
    : public VariantDomain<kAtomEscapeNode, 1, DecimalEscapeNode,
                           CharacterClassEscapeNode, CharacterEscapeNode,
                           AtomEscapeSubNode29> {};
class CharacterEscapeNode final
    : public VariantDomain<
          kCharacterEscapeNode, 2, ControlEscapeNode, CharacterEscapeSubNode30,
          Literal3, HexEscapeSequenceNode, RegExpUnicodeEscapeSequenceNode,
          IdentityEscapeNode> {};
class ControlEscapeNode final
    : public TupleDomain<kControlEscapeNode, CharSet11> {};
class GroupSpecifierNode final
    : public TupleDomain<kGroupSpecifierNode, Literal4, GroupNameNode> {};
class GroupNameNode final
    : public TupleDomain<kGroupNameNode, Literal5, RegExpIdentifierNameNode,
                         Literal6> {};
class RegExpIdentifierNameNode final
    : public TupleDomain<kRegExpIdentifierNameNode, RegExpIdentifierStartNode,
                         RegExpIdentifierNameSubNode31> {};
class RegExpIdentifierStartNode final
    : public VariantDomain<
          kRegExpIdentifierStartNode, 0, IdentifierStartCharNode,
          RegExpIdentifierStartSubNode32, RegExpIdentifierStartSubNode33> {};
class RegExpIdentifierPartNode final
    : public VariantDomain<kRegExpIdentifierPartNode, 0, IdentifierPartCharNode,
                           RegExpIdentifierPartSubNode34,
                           RegExpIdentifierPartSubNode35> {};
class RegExpUnicodeEscapeSequenceNode final
    : public VariantDomain<kRegExpUnicodeEscapeSequenceNode, 0,
                           RegExpUnicodeEscapeSequenceSubNode36,
                           RegExpUnicodeEscapeSequenceSubNode37,
                           RegExpUnicodeEscapeSequenceSubNode38,
                           RegExpUnicodeEscapeSequenceSubNode39,
                           RegExpUnicodeEscapeSequenceSubNode40,
                           RegExpUnicodeEscapeSequenceSubNode41> {};
class UnicodeLeadSurrogateNode final
    : public TupleDomain<kUnicodeLeadSurrogateNode, CharSet12> {};
class UnicodeTrailSurrogateNode final
    : public TupleDomain<kUnicodeTrailSurrogateNode, CharSet13> {};
class HexLeadSurrogateNode final
    : public TupleDomain<kHexLeadSurrogateNode, Hex4DigitsNode> {};
class HexTrailSurrogateNode final
    : public TupleDomain<kHexTrailSurrogateNode, Hex4DigitsNode> {};
class HexNonSurrogateNode final
    : public TupleDomain<kHexNonSurrogateNode, Hex4DigitsNode> {};
class IdentityEscapeNode final
    : public VariantDomain<kIdentityEscapeNode, 0, SyntaxCharacterNode,
                           Literal7, SourceCharacterNode> {};
class DecimalEscapeNode final
    : public TupleDomain<kDecimalEscapeNode, NonZeroDigitNode,
                         DecimalEscapeSubNode42> {};
class CharacterClassEscapeNode final
    : public VariantDomain<kCharacterClassEscapeNode, 0, CharSet14,
                           CharacterClassEscapeSubNode43> {};
class UnicodePropertyValueExpressionNode final
    : public VariantDomain<kUnicodePropertyValueExpressionNode, 0,
                           UnicodePropertyValueExpressionSubNode44,
                           LoneUnicodePropertyNameOrValueNode> {};
class UnicodePropertyNameNode final
    : public TupleDomain<kUnicodePropertyNameNode,
                         UnicodePropertyNameCharactersNode> {};
class UnicodePropertyNameCharactersNode final
    : public TupleDomain<kUnicodePropertyNameCharactersNode,
                         UnicodePropertyNameCharactersSubNode45> {};
class UnicodePropertyValueNode final
    : public TupleDomain<kUnicodePropertyValueNode,
                         UnicodePropertyValueCharactersNode> {};
class LoneUnicodePropertyNameOrValueNode final
    : public TupleDomain<kLoneUnicodePropertyNameOrValueNode,
                         UnicodePropertyValueCharactersNode> {};
class UnicodePropertyValueCharactersNode final
    : public TupleDomain<kUnicodePropertyValueCharactersNode,
                         UnicodePropertyValueCharactersSubNode46> {};
class UnicodePropertyValueCharacterNode final
    : public VariantDomain<kUnicodePropertyValueCharacterNode, 1,
                           UnicodePropertyNameCharacterNode, DecimalDigitNode> {
};
class UnicodePropertyNameCharacterNode final
    : public VariantDomain<kUnicodePropertyNameCharacterNode, 0,
                           AsciiLetterNode, Literal8> {};
class CharacterClassNode final
    : public TupleDomain<kCharacterClassNode, Literal9, CharacterClassSubNode47,
                         ClassContentsNode, Literal10> {};
class ClassContentsNode final
    : public VariantDomain<kClassContentsNode, 0, ClassContentsSubNode48,
                           ClassContentsSubNode49> {};
class NonemptyClassRangesNode final
    : public VariantDomain<kNonemptyClassRangesNode, 0, ClassAtomNode,
                           NonemptyClassRangesSubNode50,
                           NonemptyClassRangesSubNode51> {};
class NonemptyClassRangesNoDashNode final
    : public VariantDomain<kNonemptyClassRangesNoDashNode, 0, ClassAtomNode,
                           NonemptyClassRangesNoDashSubNode52,
                           NonemptyClassRangesNoDashSubNode53> {};
class ClassAtomNode final
    : public VariantDomain<kClassAtomNode, 0, Literal8, ClassAtomNoDashNode> {};
class ClassAtomNoDashNode final
    : public VariantDomain<kClassAtomNoDashNode, 0, SourceCharacterNode,
                           ClassAtomNoDashSubNode54> {};
class ClassEscapeNode final
    : public VariantDomain<kClassEscapeNode, 0, Literal11, Literal8,
                           CharacterClassEscapeNode, CharacterEscapeNode> {};
class ClassSetExpressionNode final
    : public VariantDomain<kClassSetExpressionNode, 0, ClassUnionNode,
                           ClassIntersectionNode, ClassSubtractionNode> {};
class ClassUnionNode final
    : public VariantDomain<kClassUnionNode, 0, ClassUnionSubNode56,
                           ClassUnionSubNode58> {};
class ClassIntersectionNode final
    : public TupleDomain<kClassIntersectionNode, ClassSetOperandNode,
                         ClassIntersectionSubNode59> {};
class ClassSubtractionNode final
    : public TupleDomain<kClassSubtractionNode, ClassSetOperandNode,
                         ClassSubtractionSubNode61> {};
class ClassSetRangeNode final
    : public TupleDomain<kClassSetRangeNode, ClassSetCharacterNode, Literal8,
                         ClassSetCharacterNode> {};
class ClassSetOperandNode final
    : public VariantDomain<kClassSetOperandNode, 2, NestedClassNode,
                           ClassStringDisjunctionNode, ClassSetCharacterNode> {
};
class NestedClassNode final
    : public VariantDomain<kNestedClassNode, 1, NestedClassSubNode64,
                           NestedClassSubNode65> {};
class ClassStringDisjunctionNode final
    : public TupleDomain<kClassStringDisjunctionNode, CharSet15, Literal12,
                         ClassStringDisjunctionContentsNode, Literal13> {};
class ClassStringDisjunctionContentsNode final
    : public TupleDomain<kClassStringDisjunctionContentsNode,
                         ClassStringDisjunctionContentsSubNode66> {};
class ClassStringNode final
    : public TupleDomain<kClassStringNode, NonEmptyClassStringNode> {};
class NonEmptyClassStringNode final
    : public TupleDomain<kNonEmptyClassStringNode, ClassSetCharacterNode,
                         NonEmptyClassStringSubNode67> {};
class ClassSetCharacterNode final
    : public VariantDomain<kClassSetCharacterNode, 0, SourceCharacterNode,
                           ClassSetCharacterSubNode68,
                           ClassSetCharacterSubNode69,
                           ClassSetCharacterSubNode70> {};
class ClassSetReservedDoublePunctuatorNode final
    : public VariantDomain<
          kClassSetReservedDoublePunctuatorNode, 0, Literal14, Literal15,
          Literal16, Literal17, Literal18, Literal19, Literal20, Literal21,
          Literal22, Literal23, Literal24, Literal25, Literal26, Literal27,
          Literal28, Literal29, Literal30, Literal31, Literal32> {};
class ClassSetSyntaxCharacterNode final
    : public TupleDomain<kClassSetSyntaxCharacterNode, CharSet16> {};
class ClassSetReservedPunctuatorNode final
    : public TupleDomain<kClassSetReservedPunctuatorNode, CharSet17> {};
class DecimalDigitsSubNode0 final
    : public NonEmptyVector<kDecimalDigitsSubNode0, DecimalDigitNode> {};
class DecimalDigitsSubNode1 final
    : public Vector<kDecimalDigitsSubNode1, DecimalDigitsSubNode2> {};
class DecimalDigitsSubNode3 final
    : public Optional<kDecimalDigitsSubNode3, NumericLiteralSeparatorNode> {};
class DecimalDigitsSubNode4 final
    : public NonEmptyVector<kDecimalDigitsSubNode4, DecimalDigitNode> {};
class DecimalDigitsSubNode2 final
    : public TupleDomain<kDecimalDigitsSubNode2, DecimalDigitsSubNode3,
                         DecimalDigitsSubNode4> {};
class HexDigitsSubNode5 final
    : public NonEmptyVector<kHexDigitsSubNode5, HexDigitsSubNode6> {};
class HexDigitsSubNode7 final
    : public Optional<kHexDigitsSubNode7, HexDigitsSubNode8> {};
class HexDigitsSubNode8 final
    : public TupleDomain<kHexDigitsSubNode8, NumericLiteralSeparatorNode,
                         HexDigitNode> {};
class HexDigitsSubNode6 final
    : public TupleDomain<kHexDigitsSubNode6, HexDigitNode, HexDigitsSubNode7> {
};
class HexEscapeSequenceSubNode9 final
    : public TupleDomain<kHexEscapeSequenceSubNode9, Literal33,
                         Hex4DigitsNode> {};
class HexEscapeSequenceSubNode10 final
    : public TupleDomain<kHexEscapeSequenceSubNode10, Literal34, CodePointNode,
                         Literal13> {};
class DisjunctionSubNode11 final
    : public NonEmptyVector<kDisjunctionSubNode11, AlternativeNode> {};
class AlternativeSubNode12 final
    : public NonEmptyVector<kAlternativeSubNode12, TermNode> {};
class TermSubNode13 final : public Optional<kTermSubNode13, QuantifierNode> {};
class TermSubNode14 final
    : public TupleDomain<kTermSubNode14, AtomNode, TermSubNode13> {};
class AssertionSubNode15 final
    : public TupleDomain<kAssertionSubNode15, CharSet15, Literal11> {};
class AssertionSubNode16 final
    : public TupleDomain<kAssertionSubNode16, CharSet15, Literal35> {};
class AssertionSubNode17 final
    : public TupleDomain<kAssertionSubNode17, Literal36, DisjunctionNode,
                         Literal37> {};
class AssertionSubNode18 final
    : public TupleDomain<kAssertionSubNode18, Literal38, DisjunctionNode,
                         Literal37> {};
class AssertionSubNode19 final
    : public TupleDomain<kAssertionSubNode19, Literal39, DisjunctionNode,
                         Literal37> {};
class AssertionSubNode20 final
    : public TupleDomain<kAssertionSubNode20, Literal40, DisjunctionNode,
                         Literal37> {};
class QuantifierSubNode21 final
    : public Optional<kQuantifierSubNode21, Literal4> {};
class QuantifierPrefixSubNode22 final
    : public Optional<kQuantifierPrefixSubNode22, Literal41> {};
class QuantifierPrefixSubNode23 final
    : public Optional<kQuantifierPrefixSubNode23, DecimalDigitsNode> {};
class QuantifierPrefixSubNode24 final
    : public TupleDomain<kQuantifierPrefixSubNode24, Literal42,
                         DecimalDigitsNode, QuantifierPrefixSubNode22,
                         QuantifierPrefixSubNode23, Literal13> {};
class AtomSubNode25 final
    : public TupleDomain<kAtomSubNode25, CharSet15, AtomEscapeNode> {};
class AtomSubNode26 final
    : public Optional<kAtomSubNode26, GroupSpecifierNode> {};
class AtomSubNode27 final
    : public TupleDomain<kAtomSubNode27, Literal43, AtomSubNode26,
                         DisjunctionNode, Literal37> {};
class AtomSubNode28 final : public TupleDomain<kAtomSubNode28, Literal44,
                                               DisjunctionNode, Literal37> {};
class AtomEscapeSubNode29 final
    : public TupleDomain<kAtomEscapeSubNode29, Literal45, GroupNameNode> {};
class CharacterEscapeSubNode30 final
    : public TupleDomain<kCharacterEscapeSubNode30, Literal46,
                         AsciiLetterNode> {};
class RegExpIdentifierNameSubNode31 final
    : public NonEmptyVector<kRegExpIdentifierNameSubNode31,
                            RegExpIdentifierPartNode> {};
class RegExpIdentifierStartSubNode32 final
    : public TupleDomain<kRegExpIdentifierStartSubNode32, CharSet15,
                         RegExpUnicodeEscapeSequenceNode> {};
class RegExpIdentifierStartSubNode33 final
    : public TupleDomain<kRegExpIdentifierStartSubNode33,
                         UnicodeLeadSurrogateNode, UnicodeTrailSurrogateNode> {
};
class RegExpIdentifierPartSubNode34 final
    : public TupleDomain<kRegExpIdentifierPartSubNode34, CharSet15,
                         RegExpUnicodeEscapeSequenceNode> {};
class RegExpIdentifierPartSubNode35 final
    : public TupleDomain<kRegExpIdentifierPartSubNode35,
                         UnicodeLeadSurrogateNode, UnicodeTrailSurrogateNode> {
};
class RegExpUnicodeEscapeSequenceSubNode36 final
    : public TupleDomain<kRegExpUnicodeEscapeSequenceSubNode36, Literal33,
                         HexLeadSurrogateNode, Literal47,
                         HexTrailSurrogateNode> {};
class RegExpUnicodeEscapeSequenceSubNode37 final
    : public TupleDomain<kRegExpUnicodeEscapeSequenceSubNode37, Literal33,
                         HexLeadSurrogateNode> {};
class RegExpUnicodeEscapeSequenceSubNode38 final
    : public TupleDomain<kRegExpUnicodeEscapeSequenceSubNode38, Literal33,
                         HexTrailSurrogateNode> {};
class RegExpUnicodeEscapeSequenceSubNode39 final
    : public TupleDomain<kRegExpUnicodeEscapeSequenceSubNode39, Literal33,
                         HexNonSurrogateNode> {};
class RegExpUnicodeEscapeSequenceSubNode40 final
    : public TupleDomain<kRegExpUnicodeEscapeSequenceSubNode40, Literal33,
                         Hex4DigitsNode> {};
class RegExpUnicodeEscapeSequenceSubNode41 final
    : public TupleDomain<kRegExpUnicodeEscapeSequenceSubNode41, Literal34,
                         CodePointNode, Literal13> {};
class DecimalEscapeSubNode42 final
    : public Optional<kDecimalEscapeSubNode42, DecimalDigitsNode> {};
class CharacterClassEscapeSubNode43 final
    : public TupleDomain<kCharacterClassEscapeSubNode43, CharSet18, Literal42,
                         UnicodePropertyValueExpressionNode, Literal13> {};
class UnicodePropertyValueExpressionSubNode44 final
    : public TupleDomain<kUnicodePropertyValueExpressionSubNode44,
                         UnicodePropertyNameNode, Literal48,
                         UnicodePropertyValueNode> {};
class UnicodePropertyNameCharactersSubNode45 final
    : public NonEmptyVector<kUnicodePropertyNameCharactersSubNode45,
                            UnicodePropertyNameCharacterNode> {};
class UnicodePropertyValueCharactersSubNode46 final
    : public NonEmptyVector<kUnicodePropertyValueCharactersSubNode46,
                            UnicodePropertyValueCharacterNode> {};
class CharacterClassSubNode47 final
    : public Optional<kCharacterClassSubNode47, Literal49> {};
class ClassContentsSubNode48 final
    : public Optional<kClassContentsSubNode48, NonemptyClassRangesNode> {};
class ClassContentsSubNode49 final
    : public Optional<kClassContentsSubNode49, ClassSetExpressionNode> {};
class NonemptyClassRangesSubNode50 final
    : public TupleDomain<kNonemptyClassRangesSubNode50, ClassAtomNode,
                         NonemptyClassRangesNoDashNode> {};
class NonemptyClassRangesSubNode51 final
    : public TupleDomain<kNonemptyClassRangesSubNode51, ClassAtomNode, Literal8,
                         ClassAtomNode, ClassContentsNode> {};
class NonemptyClassRangesNoDashSubNode52 final
    : public TupleDomain<kNonemptyClassRangesNoDashSubNode52,
                         ClassAtomNoDashNode, NonemptyClassRangesNoDashNode> {};
class NonemptyClassRangesNoDashSubNode53 final
    : public TupleDomain<kNonemptyClassRangesNoDashSubNode53,
                         ClassAtomNoDashNode, Literal8, ClassAtomNode,
                         ClassContentsNode> {};
class ClassAtomNoDashSubNode54 final
    : public TupleDomain<kClassAtomNoDashSubNode54, CharSet15,
                         ClassEscapeNode> {};
class ClassUnionSubNode55 final
    : public Optional<kClassUnionSubNode55, ClassUnionNode> {};
class ClassUnionSubNode56 final
    : public TupleDomain<kClassUnionSubNode56, ClassSetRangeNode,
                         ClassUnionSubNode55> {};
class ClassUnionSubNode57 final
    : public Optional<kClassUnionSubNode57, ClassUnionNode> {};
class ClassUnionSubNode58 final
    : public TupleDomain<kClassUnionSubNode58, ClassSetOperandNode,
                         ClassUnionSubNode57> {};
class ClassIntersectionSubNode59 final
    : public NonEmptyVector<kClassIntersectionSubNode59,
                            ClassIntersectionSubNode60> {};
class ClassIntersectionSubNode60 final
    : public TupleDomain<kClassIntersectionSubNode60, Literal14,
                         ClassSetOperandNode> {};
class ClassSubtractionSubNode61 final
    : public NonEmptyVector<kClassSubtractionSubNode61,
                            ClassSubtractionSubNode62> {};
class ClassSubtractionSubNode62 final
    : public TupleDomain<kClassSubtractionSubNode62, Literal50,
                         ClassSetOperandNode> {};
class NestedClassSubNode63 final
    : public Optional<kNestedClassSubNode63, Literal49> {};
class NestedClassSubNode64 final
    : public TupleDomain<kNestedClassSubNode64, Literal9, NestedClassSubNode63,
                         ClassContentsNode, Literal10> {};
class NestedClassSubNode65 final
    : public TupleDomain<kNestedClassSubNode65, CharSet15,
                         CharacterClassEscapeNode> {};
class ClassStringDisjunctionContentsSubNode66 final
    : public NonEmptyVector<kClassStringDisjunctionContentsSubNode66,
                            ClassStringNode> {};
class NonEmptyClassStringSubNode67 final
    : public Optional<kNonEmptyClassStringSubNode67, NonEmptyClassStringNode> {
};
class ClassSetCharacterSubNode68 final
    : public TupleDomain<kClassSetCharacterSubNode68, CharSet15,
                         CharacterEscapeNode> {};
class ClassSetCharacterSubNode69 final
    : public TupleDomain<kClassSetCharacterSubNode69, CharSet15,
                         ClassSetReservedPunctuatorNode> {};
class ClassSetCharacterSubNode70 final
    : public TupleDomain<kClassSetCharacterSubNode70, CharSet15, Literal11> {};
class Literal15 final : public StringLiteralDomain<kLiteral15, kStrLiteral15> {
};
class Literal16 final : public StringLiteralDomain<kLiteral16, kStrLiteral16> {
};
class Literal0 final : public StringLiteralDomain<kLiteral0, kStrLiteral0> {};
class Literal17 final : public StringLiteralDomain<kLiteral17, kStrLiteral17> {
};
class Literal18 final : public StringLiteralDomain<kLiteral18, kStrLiteral18> {
};
class Literal14 final : public StringLiteralDomain<kLiteral14, kStrLiteral14> {
};
class Literal43 final : public StringLiteralDomain<kLiteral43, kStrLiteral43> {
};
class Literal38 final : public StringLiteralDomain<kLiteral38, kStrLiteral38> {
};
class Literal44 final : public StringLiteralDomain<kLiteral44, kStrLiteral44> {
};
class Literal40 final : public StringLiteralDomain<kLiteral40, kStrLiteral40> {
};
class Literal39 final : public StringLiteralDomain<kLiteral39, kStrLiteral39> {
};
class Literal36 final : public StringLiteralDomain<kLiteral36, kStrLiteral36> {
};
class Literal37 final : public StringLiteralDomain<kLiteral37, kStrLiteral37> {
};
class Literal19 final : public StringLiteralDomain<kLiteral19, kStrLiteral19> {
};
class Literal20 final : public StringLiteralDomain<kLiteral20, kStrLiteral20> {
};
class Literal41 final : public StringLiteralDomain<kLiteral41, kStrLiteral41> {
};
class Literal21 final : public StringLiteralDomain<kLiteral21, kStrLiteral21> {
};
class Literal8 final : public StringLiteralDomain<kLiteral8, kStrLiteral8> {};
class Literal50 final : public StringLiteralDomain<kLiteral50, kStrLiteral50> {
};
class Literal2 final : public StringLiteralDomain<kLiteral2, kStrLiteral2> {};
class Literal22 final : public StringLiteralDomain<kLiteral22, kStrLiteral22> {
};
class Literal7 final : public StringLiteralDomain<kLiteral7, kStrLiteral7> {};
class Literal3 final : public StringLiteralDomain<kLiteral3, kStrLiteral3> {};
class Literal23 final : public StringLiteralDomain<kLiteral23, kStrLiteral23> {
};
class Literal24 final : public StringLiteralDomain<kLiteral24, kStrLiteral24> {
};
class Literal5 final : public StringLiteralDomain<kLiteral5, kStrLiteral5> {};
class Literal25 final : public StringLiteralDomain<kLiteral25, kStrLiteral25> {
};
class Literal48 final : public StringLiteralDomain<kLiteral48, kStrLiteral48> {
};
class Literal26 final : public StringLiteralDomain<kLiteral26, kStrLiteral26> {
};
class Literal6 final : public StringLiteralDomain<kLiteral6, kStrLiteral6> {};
class Literal27 final : public StringLiteralDomain<kLiteral27, kStrLiteral27> {
};
class Literal4 final : public StringLiteralDomain<kLiteral4, kStrLiteral4> {};
class Literal28 final : public StringLiteralDomain<kLiteral28, kStrLiteral28> {
};
class Literal29 final : public StringLiteralDomain<kLiteral29, kStrLiteral29> {
};
class Literal35 final : public StringLiteralDomain<kLiteral35, kStrLiteral35> {
};
class Literal9 final : public StringLiteralDomain<kLiteral9, kStrLiteral9> {};
class Literal47 final : public StringLiteralDomain<kLiteral47, kStrLiteral47> {
};
class Literal10 final : public StringLiteralDomain<kLiteral10, kStrLiteral10> {
};
class Literal49 final : public StringLiteralDomain<kLiteral49, kStrLiteral49> {
};
class Literal30 final : public StringLiteralDomain<kLiteral30, kStrLiteral30> {
};
class Literal1 final : public StringLiteralDomain<kLiteral1, kStrLiteral1> {};
class Literal31 final : public StringLiteralDomain<kLiteral31, kStrLiteral31> {
};
class Literal11 final : public StringLiteralDomain<kLiteral11, kStrLiteral11> {
};
class Literal46 final : public StringLiteralDomain<kLiteral46, kStrLiteral46> {
};
class Literal45 final : public StringLiteralDomain<kLiteral45, kStrLiteral45> {
};
class Literal12 final : public StringLiteralDomain<kLiteral12, kStrLiteral12> {
};
class Literal33 final : public StringLiteralDomain<kLiteral33, kStrLiteral33> {
};
class Literal34 final : public StringLiteralDomain<kLiteral34, kStrLiteral34> {
};
class Literal42 final : public StringLiteralDomain<kLiteral42, kStrLiteral42> {
};
class Literal13 final : public StringLiteralDomain<kLiteral13, kStrLiteral13> {
};
class Literal32 final : public StringLiteralDomain<kLiteral32, kStrLiteral32> {
};
class CharSet0 final : public RegexLiteralDomain<kCharSet0, kStrCharSet0> {};
class CharSet17 final : public RegexLiteralDomain<kCharSet17, kStrCharSet17> {};
class CharSet16 final : public RegexLiteralDomain<kCharSet16, kStrCharSet16> {};
class CharSet9 final : public RegexLiteralDomain<kCharSet9, kStrCharSet9> {};
class CharSet5 final : public RegexLiteralDomain<kCharSet5, kStrCharSet5> {};
class CharSet7 final : public RegexLiteralDomain<kCharSet7, kStrCharSet7> {};
class CharSet6 final : public RegexLiteralDomain<kCharSet6, kStrCharSet6> {};
class CharSet15 final : public RegexLiteralDomain<kCharSet15, kStrCharSet15> {};
class CharSet2 final : public RegexLiteralDomain<kCharSet2, kStrCharSet2> {};
class CharSet1 final : public RegexLiteralDomain<kCharSet1, kStrCharSet1> {};
class CharSet3 final : public RegexLiteralDomain<kCharSet3, kStrCharSet3> {};
class CharSet12 final : public RegexLiteralDomain<kCharSet12, kStrCharSet12> {};
class CharSet13 final : public RegexLiteralDomain<kCharSet13, kStrCharSet13> {};
class CharSet10 final : public RegexLiteralDomain<kCharSet10, kStrCharSet10> {};
class CharSet8 final : public RegexLiteralDomain<kCharSet8, kStrCharSet8> {};
class CharSet4 final : public RegexLiteralDomain<kCharSet4, kStrCharSet4> {};
class CharSet14 final : public RegexLiteralDomain<kCharSet14, kStrCharSet14> {};
class CharSet11 final : public RegexLiteralDomain<kCharSet11, kStrCharSet11> {};
class CharSet18 final : public RegexLiteralDomain<kCharSet18, kStrCharSet18> {};
}  // namespace fuzztest::internal::grammar::pattern
namespace fuzztest::internal_no_adl {

inline auto InPatternGrammar() {
  return internal::grammar::InGrammarImpl<
      internal::grammar::pattern::PatternNode>();
}

}  // namespace fuzztest::internal_no_adl
#endif  // FUZZTEST_GRAMMARS_PATTERN_GRAMMAR_H_
