/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/uiaction.h>
        #include <wx/gdicmn.h>


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseMove, "MouseMove(x, y) -> bool\n"
"MouseMove(point) -> bool\n"
"\n"
"Move the mouse to the specified coordinates.\n"
"");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseMove(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseMove(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long x;
        long y;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bll", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &x, &y))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseMove(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxPoint* point;
        int pointState = 0;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_point,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, sipType_wxPoint, &point, &pointState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseMove(*point);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(point), sipType_wxPoint, pointState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseMove, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseDown, "MouseDown(button=MOUSE_BTN_LEFT) -> bool\n"
"\n"
"Press a mouse button.");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int button = wxMOUSE_BTN_LEFT;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_button,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &button))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseDown(button);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseUp, "MouseUp(button=MOUSE_BTN_LEFT) -> bool\n"
"\n"
"Release a mouse button.");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseUp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseUp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int button = wxMOUSE_BTN_LEFT;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_button,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &button))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseUp(button);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseUp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseClick, "MouseClick(button=MOUSE_BTN_LEFT) -> bool\n"
"\n"
"Click a mouse button.");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseClick(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseClick(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int button = wxMOUSE_BTN_LEFT;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_button,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &button))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseClick(button);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseClick, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseDblClick, "MouseDblClick(button=MOUSE_BTN_LEFT) -> bool\n"
"\n"
"Double-click a mouse button.");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseDblClick(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseDblClick(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int button = wxMOUSE_BTN_LEFT;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_button,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &button))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseDblClick(button);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseDblClick, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_MouseDragDrop, "MouseDragDrop(x1, y1, x2, y2, button=MOUSE_BTN_LEFT) -> bool\n"
"\n"
"Perform a drag and drop operation.");

extern "C" {static PyObject *meth_wxUIActionSimulator_MouseDragDrop(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_MouseDragDrop(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long x1;
        long y1;
        long x2;
        long y2;
        int button = wxMOUSE_BTN_LEFT;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x1,
            sipName_y1,
            sipName_x2,
            sipName_y2,
            sipName_button,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bllll|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &x1, &y1, &x2, &y2, &button))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MouseDragDrop(x1, y1, x2, y2, button);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_MouseDragDrop, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_KeyDown, "KeyDown(keycode, modifiers=MOD_NONE) -> bool\n"
"\n"
"Press a key.");

extern "C" {static PyObject *meth_wxUIActionSimulator_KeyDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_KeyDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int keycode;
        int modifiers = wxMOD_NONE;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_keycode,
            sipName_modifiers,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &keycode, &modifiers))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->KeyDown(keycode, modifiers);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_KeyDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_KeyUp, "KeyUp(keycode, modifiers=MOD_NONE) -> bool\n"
"\n"
"Release a key.");

extern "C" {static PyObject *meth_wxUIActionSimulator_KeyUp(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_KeyUp(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int keycode;
        int modifiers = wxMOD_NONE;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_keycode,
            sipName_modifiers,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &keycode, &modifiers))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->KeyUp(keycode, modifiers);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_KeyUp, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_Char, "Char(keycode, modifiers=MOD_NONE) -> bool\n"
"\n"
"Press and release a key.");

extern "C" {static PyObject *meth_wxUIActionSimulator_Char(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_Char(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int keycode;
        int modifiers = wxMOD_NONE;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_keycode,
            sipName_modifiers,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|i", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &keycode, &modifiers))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Char(keycode, modifiers);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_Char, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_Select, "Select(text) -> bool\n"
"\n"
"Simulate selection of an item with the given text.");

extern "C" {static PyObject *meth_wxUIActionSimulator_Select(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_Select(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* text;
        int textState = 0;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, sipType_wxString, &text, &textState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Select(*text);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text), sipType_wxString, textState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_Select, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxUIActionSimulator_Text, "Text(text) -> bool\n"
"\n"
"Emulate typing in the keys representing the given string.");

extern "C" {static PyObject *meth_wxUIActionSimulator_Text(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxUIActionSimulator_Text(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const char* text;
        ::wxUIActionSimulator *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bs", &sipSelf, sipType_wxUIActionSimulator, &sipCpp, &text))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Text(text);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_UIActionSimulator, sipName_Text, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxUIActionSimulator(void *, int);}
static void release_wxUIActionSimulator(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxUIActionSimulator *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxUIActionSimulator(sipSimpleWrapper *);}
static void dealloc_wxUIActionSimulator(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxUIActionSimulator(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxUIActionSimulator(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxUIActionSimulator(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxUIActionSimulator *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxUIActionSimulator();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxUIActionSimulator[] = {
    {sipName_Char, SIP_MLMETH_CAST(meth_wxUIActionSimulator_Char), METH_VARARGS|METH_KEYWORDS, doc_wxUIActionSimulator_Char},
    {sipName_KeyDown, SIP_MLMETH_CAST(meth_wxUIActionSimulator_KeyDown), METH_VARARGS|METH_KEYWORDS, doc_wxUIActionSimulator_KeyDown},
    {sipName_KeyUp, SIP_MLMETH_CAST(meth_wxUIActionSimulator_KeyUp), METH_VARARGS|METH_KEYWORDS, doc_wxUIActionSimulator_KeyUp},
    {sipName_MouseClick, SIP_MLMETH_CAST(meth_wxUIActionSimulator_MouseClick), METH_VARARGS|METH_KEYWORDS, doc_wxUIActionSimulator_MouseClick},
    {sipName_MouseDblClick, SIP_MLMETH_CAST(meth_wxUIActionSimulator_MouseDblClick), METH_VARARGS|METH_KEYWORDS, doc_wxUIActionSimulator_MouseDblClick},
    {sipName_MouseDown, SIP_MLMETH_CAST(meth_wxUIActionSimulator_MouseDown), METH_VARARGS|METH_KEYWORDS, doc_wxUIActionSimulator_MouseDown},
    {sipName_MouseDragDrop, SIP_MLMETH_CAST(meth_wxUIActionSimulator_MouseDragDrop), METH_VARARGS|METH_KEYWORDS, doc_wxUIActionSimulator_MouseDragDrop},
    {sipName_MouseMove, SIP_MLMETH_CAST(meth_wxUIActionSimulator_MouseMove), METH_VARARGS|METH_KEYWORDS, doc_wxUIActionSimulator_MouseMove},
    {sipName_MouseUp, SIP_MLMETH_CAST(meth_wxUIActionSimulator_MouseUp), METH_VARARGS|METH_KEYWORDS, doc_wxUIActionSimulator_MouseUp},
    {sipName_Select, SIP_MLMETH_CAST(meth_wxUIActionSimulator_Select), METH_VARARGS|METH_KEYWORDS, doc_wxUIActionSimulator_Select},
    {sipName_Text, SIP_MLMETH_CAST(meth_wxUIActionSimulator_Text), METH_VARARGS|METH_KEYWORDS, doc_wxUIActionSimulator_Text}
};

PyDoc_STRVAR(doc_wxUIActionSimulator, "UIActionSimulator() -> None\n"
"\n"
"wxUIActionSimulator is a class used to simulate user interface actions\n"
"such as a mouse click or a key press.");


sipClassTypeDef sipTypeDef__core_wxUIActionSimulator = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxUIActionSimulator,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_UIActionSimulator,
        {0, 0, 1},
        11, methods_wxUIActionSimulator,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxUIActionSimulator,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxUIActionSimulator,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxUIActionSimulator,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxUIActionSimulator,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxUIActionSimulator),
};
