// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_Storage_Pickers_Provider_H
#define WINRT_Windows_Storage_Pickers_Provider_H
#include "winrt/base.h"
static_assert(winrt::check_version(CPPWINRT_VERSION, "2.0.250303.1"), "Mismatched C++/WinRT headers.");
#define CPPWINRT_VERSION "2.0.250303.1"
#include "winrt/Windows.Storage.Pickers.h"
#include "winrt/impl/Windows.Foundation.2.h"
#include "winrt/impl/Windows.Foundation.Collections.2.h"
#include "winrt/impl/Windows.Storage.2.h"
#include "winrt/impl/Windows.Storage.Pickers.Provider.2.h"
namespace winrt::impl
{
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::AddFile(param::hstring const& id, winrt::Windows::Storage::IStorageFile const& file) const
    {
        winrt::Windows::Storage::Pickers::Provider::AddFileResult addResult{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->AddFile(*(void**)(&id), *(void**)(&file), reinterpret_cast<int32_t*>(&addResult)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            check_hresult(_winrt_abi_type->AddFile(*(void**)(&id), *(void**)(&file), reinterpret_cast<int32_t*>(&addResult)));
        }
        return addResult;
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::RemoveFile(param::hstring const& id) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->RemoveFile(*(void**)(&id)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            check_hresult(_winrt_abi_type->RemoveFile(*(void**)(&id)));
        }
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::ContainsFile(param::hstring const& id) const
    {
        bool isContained{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->ContainsFile(*(void**)(&id), &isContained));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            check_hresult(_winrt_abi_type->ContainsFile(*(void**)(&id), &isContained));
        }
        return isContained;
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::CanAddFile(winrt::Windows::Storage::IStorageFile const& file) const
    {
        bool canAdd{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->CanAddFile(*(void**)(&file), &canAdd));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            check_hresult(_winrt_abi_type->CanAddFile(*(void**)(&file), &canAdd));
        }
        return canAdd;
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::AllowedFileTypes() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowedFileTypes(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            check_hresult(_winrt_abi_type->get_AllowedFileTypes(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::SelectionMode() const
    {
        winrt::Windows::Storage::Pickers::Provider::FileSelectionMode value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SelectionMode(reinterpret_cast<int32_t*>(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            check_hresult(_winrt_abi_type->get_SelectionMode(reinterpret_cast<int32_t*>(&value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::SettingsIdentifier() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SettingsIdentifier(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            check_hresult(_winrt_abi_type->get_SettingsIdentifier(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::Title() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::Title(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Title(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            check_hresult(_winrt_abi_type->put_Title(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::FileRemoved(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileOpenPickerUI, winrt::Windows::Storage::Pickers::Provider::FileRemovedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_FileRemoved(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            check_hresult(_winrt_abi_type->add_FileRemoved(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::FileRemoved(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileOpenPickerUI, winrt::Windows::Storage::Pickers::Provider::FileRemovedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, FileRemoved_revoker>(this, FileRemoved(handler));
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::FileRemoved(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            _winrt_abi_type->remove_FileRemoved(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            _winrt_abi_type->remove_FileRemoved(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::Closing(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileOpenPickerUI, winrt::Windows::Storage::Pickers::Provider::PickerClosingEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_Closing(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            check_hresult(_winrt_abi_type->add_Closing(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::Closing(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileOpenPickerUI, winrt::Windows::Storage::Pickers::Provider::PickerClosingEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, Closing_revoker>(this, Closing(handler));
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileOpenPickerUI<D>::Closing(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)&_winrt_casted_result;
            _winrt_abi_type->remove_Closing(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>**)this;
            _winrt_abi_type->remove_Closing(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileRemovedEventArgs<D>::Id() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileRemovedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileRemovedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileRemovedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileRemovedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Id(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::Title() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)this;
            check_hresult(_winrt_abi_type->get_Title(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::Title(param::hstring const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_Title(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)this;
            check_hresult(_winrt_abi_type->put_Title(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::AllowedFileTypes() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_AllowedFileTypes(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)this;
            check_hresult(_winrt_abi_type->get_AllowedFileTypes(&value));
        }
        return winrt::Windows::Foundation::Collections::IVectorView<hstring>{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::SettingsIdentifier() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_SettingsIdentifier(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)this;
            check_hresult(_winrt_abi_type->get_SettingsIdentifier(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::FileName() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_FileName(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)this;
            check_hresult(_winrt_abi_type->get_FileName(&value));
        }
        return hstring{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::TrySetFileName(param::hstring const& value) const
    {
        winrt::Windows::Storage::Pickers::Provider::SetFileNameResult result{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->TrySetFileName(*(void**)(&value), reinterpret_cast<int32_t*>(&result)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)this;
            check_hresult(_winrt_abi_type->TrySetFileName(*(void**)(&value), reinterpret_cast<int32_t*>(&result)));
        }
        return result;
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::FileNameChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileSavePickerUI, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_FileNameChanged(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)this;
            check_hresult(_winrt_abi_type->add_FileNameChanged(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::FileNameChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileSavePickerUI, winrt::Windows::Foundation::IInspectable> const& handler) const
    {
        return impl::make_event_revoker<D, FileNameChanged_revoker>(this, FileNameChanged(handler));
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::FileNameChanged(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)&_winrt_casted_result;
            _winrt_abi_type->remove_FileNameChanged(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)this;
            _winrt_abi_type->remove_FileNameChanged(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::TargetFileRequested(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileSavePickerUI, winrt::Windows::Storage::Pickers::Provider::TargetFileRequestedEventArgs> const& handler) const
    {
        winrt::event_token token{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->add_TargetFileRequested(*(void**)(&handler), put_abi(token)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)this;
            check_hresult(_winrt_abi_type->add_TargetFileRequested(*(void**)(&handler), put_abi(token)));
        }
        return token;
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::TargetFileRequested(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileSavePickerUI, winrt::Windows::Storage::Pickers::Provider::TargetFileRequestedEventArgs> const& handler) const
    {
        return impl::make_event_revoker<D, TargetFileRequested_revoker>(this, TargetFileRequested(handler));
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IFileSavePickerUI<D>::TargetFileRequested(winrt::event_token const& token) const noexcept
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)&_winrt_casted_result;
            _winrt_abi_type->remove_TargetFileRequested(impl::bind_in(token));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>**)this;
            _winrt_abi_type->remove_TargetFileRequested(impl::bind_in(token));
        }
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IPickerClosingDeferral<D>::Complete() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IPickerClosingDeferral>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IPickerClosingDeferral, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IPickerClosingDeferral>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Complete());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IPickerClosingDeferral>**)this;
            check_hresult(_winrt_abi_type->Complete());
        }
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IPickerClosingEventArgs<D>::ClosingOperation() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IPickerClosingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IPickerClosingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IPickerClosingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_ClosingOperation(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IPickerClosingEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_ClosingOperation(&value));
        }
        return winrt::Windows::Storage::Pickers::Provider::PickerClosingOperation{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IPickerClosingEventArgs<D>::IsCanceled() const
    {
        bool value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IPickerClosingEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IPickerClosingEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IPickerClosingEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_IsCanceled(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IPickerClosingEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_IsCanceled(&value));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IPickerClosingOperation<D>::GetDeferral() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IPickerClosingOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IPickerClosingOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IPickerClosingOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeferral(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IPickerClosingOperation>**)this;
            check_hresult(_winrt_abi_type->GetDeferral(&value));
        }
        return winrt::Windows::Storage::Pickers::Provider::PickerClosingDeferral{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_IPickerClosingOperation<D>::Deadline() const
    {
        winrt::Windows::Foundation::DateTime value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::IPickerClosingOperation>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::IPickerClosingOperation, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IPickerClosingOperation>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Deadline(put_abi(value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::IPickerClosingOperation>**)this;
            check_hresult(_winrt_abi_type->get_Deadline(put_abi(value)));
        }
        return value;
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_ITargetFileRequest<D>::TargetFile() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_TargetFile(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest>**)this;
            check_hresult(_winrt_abi_type->get_TargetFile(&value));
        }
        return winrt::Windows::Storage::IStorageFile{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_ITargetFileRequest<D>::TargetFile(winrt::Windows::Storage::IStorageFile const& value) const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->put_TargetFile(*(void**)(&value)));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest>**)this;
            check_hresult(_winrt_abi_type->put_TargetFile(*(void**)(&value)));
        }
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_ITargetFileRequest<D>::GetDeferral() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->GetDeferral(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest>**)this;
            check_hresult(_winrt_abi_type->GetDeferral(&value));
        }
        return winrt::Windows::Storage::Pickers::Provider::TargetFileRequestDeferral{ value, take_ownership_from_abi };
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_ITargetFileRequestDeferral<D>::Complete() const
    {
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestDeferral>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestDeferral, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestDeferral>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->Complete());
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestDeferral>**)this;
            check_hresult(_winrt_abi_type->Complete());
        }
    }
    template <typename D> auto consume_Windows_Storage_Pickers_Provider_ITargetFileRequestedEventArgs<D>::Request() const
    {
        void* value{};
        if constexpr (!std::is_same_v<D, winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestedEventArgs>)
        {
            winrt::hresult _winrt_cast_result_code;
            auto const _winrt_casted_result = impl::try_as_with_reason<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestedEventArgs, D const*>(static_cast<D const*>(this), _winrt_cast_result_code);
            check_hresult(_winrt_cast_result_code);
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestedEventArgs>**)&_winrt_casted_result;
            check_hresult(_winrt_abi_type->get_Request(&value));
        }
        else
        {
            auto const _winrt_abi_type = *(abi_t<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestedEventArgs>**)this;
            check_hresult(_winrt_abi_type->get_Request(&value));
        }
        return winrt::Windows::Storage::Pickers::Provider::TargetFileRequest{ value, take_ownership_from_abi };
    }
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI> : produce_base<D, winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI>
    {
        int32_t __stdcall AddFile(void* id, void* file, int32_t* addResult) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *addResult = detach_from<winrt::Windows::Storage::Pickers::Provider::AddFileResult>(this->shim().AddFile(*reinterpret_cast<hstring const*>(&id), *reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall RemoveFile(void* id) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().RemoveFile(*reinterpret_cast<hstring const*>(&id));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall ContainsFile(void* id, bool* isContained) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *isContained = detach_from<bool>(this->shim().ContainsFile(*reinterpret_cast<hstring const*>(&id)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall CanAddFile(void* file, bool* canAdd) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *canAdd = detach_from<bool>(this->shim().CanAddFile(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&file)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AllowedFileTypes(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<hstring>>(this->shim().AllowedFileTypes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SelectionMode(int32_t* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Pickers::Provider::FileSelectionMode>(this->shim().SelectionMode());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SettingsIdentifier(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().SettingsIdentifier());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Title(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Title());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Title(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Title(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_FileRemoved(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().FileRemoved(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileOpenPickerUI, winrt::Windows::Storage::Pickers::Provider::FileRemovedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_FileRemoved(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FileRemoved(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_Closing(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().Closing(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileOpenPickerUI, winrt::Windows::Storage::Pickers::Provider::PickerClosingEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_Closing(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Closing(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::Pickers::Provider::IFileRemovedEventArgs> : produce_base<D, winrt::Windows::Storage::Pickers::Provider::IFileRemovedEventArgs>
    {
        int32_t __stdcall get_Id(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Id());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI> : produce_base<D, winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI>
    {
        int32_t __stdcall get_Title(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().Title());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_Title(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Title(*reinterpret_cast<hstring const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_AllowedFileTypes(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::Collections::IVectorView<hstring>>(this->shim().AllowedFileTypes());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_SettingsIdentifier(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().SettingsIdentifier());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_FileName(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<hstring>(this->shim().FileName());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall TrySetFileName(void* value, int32_t* result) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *result = detach_from<winrt::Windows::Storage::Pickers::Provider::SetFileNameResult>(this->shim().TrySetFileName(*reinterpret_cast<hstring const*>(&value)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall add_FileNameChanged(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().FileNameChanged(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileSavePickerUI, winrt::Windows::Foundation::IInspectable> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_FileNameChanged(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().FileNameChanged(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
        int32_t __stdcall add_TargetFileRequested(void* handler, winrt::event_token* token) noexcept final try
        {
            zero_abi<winrt::event_token>(token);
            typename D::abi_guard guard(this->shim());
            *token = detach_from<winrt::event_token>(this->shim().TargetFileRequested(*reinterpret_cast<winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::Storage::Pickers::Provider::FileSavePickerUI, winrt::Windows::Storage::Pickers::Provider::TargetFileRequestedEventArgs> const*>(&handler)));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall remove_TargetFileRequested(winrt::event_token token) noexcept final
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TargetFileRequested(*reinterpret_cast<winrt::event_token const*>(&token));
            return 0;
        }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::Pickers::Provider::IPickerClosingDeferral> : produce_base<D, winrt::Windows::Storage::Pickers::Provider::IPickerClosingDeferral>
    {
        int32_t __stdcall Complete() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Complete();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::Pickers::Provider::IPickerClosingEventArgs> : produce_base<D, winrt::Windows::Storage::Pickers::Provider::IPickerClosingEventArgs>
    {
        int32_t __stdcall get_ClosingOperation(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Pickers::Provider::PickerClosingOperation>(this->shim().ClosingOperation());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_IsCanceled(bool* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            *value = detach_from<bool>(this->shim().IsCanceled());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::Pickers::Provider::IPickerClosingOperation> : produce_base<D, winrt::Windows::Storage::Pickers::Provider::IPickerClosingOperation>
    {
        int32_t __stdcall GetDeferral(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Pickers::Provider::PickerClosingDeferral>(this->shim().GetDeferral());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall get_Deadline(int64_t* value) noexcept final try
        {
            zero_abi<winrt::Windows::Foundation::DateTime>(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Foundation::DateTime>(this->shim().Deadline());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest> : produce_base<D, winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest>
    {
        int32_t __stdcall get_TargetFile(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::IStorageFile>(this->shim().TargetFile());
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall put_TargetFile(void* value) noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().TargetFile(*reinterpret_cast<winrt::Windows::Storage::IStorageFile const*>(&value));
            return 0;
        }
        catch (...) { return to_hresult(); }
        int32_t __stdcall GetDeferral(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Pickers::Provider::TargetFileRequestDeferral>(this->shim().GetDeferral());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestDeferral> : produce_base<D, winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestDeferral>
    {
        int32_t __stdcall Complete() noexcept final try
        {
            typename D::abi_guard guard(this->shim());
            this->shim().Complete();
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
#ifndef WINRT_LEAN_AND_MEAN
    template <typename D>
    struct produce<D, winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestedEventArgs> : produce_base<D, winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestedEventArgs>
    {
        int32_t __stdcall get_Request(void** value) noexcept final try
        {
            clear_abi(value);
            typename D::abi_guard guard(this->shim());
            *value = detach_from<winrt::Windows::Storage::Pickers::Provider::TargetFileRequest>(this->shim().Request());
            return 0;
        }
        catch (...) { return to_hresult(); }
    };
#endif
}
WINRT_EXPORT namespace winrt::Windows::Storage::Pickers::Provider
{
}
namespace std
{
#ifndef WINRT_LEAN_AND_MEAN
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::IFileOpenPickerUI> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::IFileRemovedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::IFileSavePickerUI> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::IPickerClosingDeferral> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::IPickerClosingEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::IPickerClosingOperation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequest> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestDeferral> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::ITargetFileRequestedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::FileOpenPickerUI> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::FileRemovedEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::FileSavePickerUI> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::PickerClosingDeferral> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::PickerClosingEventArgs> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::PickerClosingOperation> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::TargetFileRequest> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::TargetFileRequestDeferral> : winrt::impl::hash_base {};
    template<> struct hash<winrt::Windows::Storage::Pickers::Provider::TargetFileRequestedEventArgs> : winrt::impl::hash_base {};
#endif
#ifdef __cpp_lib_format
#endif
}
#endif
